import numpy as np
from pandas._typing import ArrayLike as ArrayLike, Dtype as Dtype, npt as npt
from typing import Union, Hashable, Literal

STR_NA_VALUES: set[str]

def sanitize_objects(values: npt.NDArray[np.object_], na_values: set) -> int: ...

class TextReader:
    unnamed_cols: set[str]
    table_width: int
    leading_cols: int
    header: list[list[int]]
    def __init__(self, source, delimiter: Union[bytes, str] = ..., header=..., header_start: int = ..., header_end: int = ..., index_col=..., names=..., tokenize_chunksize: int = ..., delim_whitespace: bool = ..., converters=..., skipinitialspace: bool = ..., escapechar: Union[bytes, str, None] = ..., doublequote: bool = ..., quotechar: Union[str, bytes, None] = ..., quoting: int = ..., lineterminator: Union[bytes, str, None] = ..., comment=..., decimal: Union[bytes, str] = ..., thousands: Union[bytes, str, None] = ..., dtype: Union[Dtype, dict[Hashable, Dtype]] = ..., usecols=..., error_bad_lines: bool = ..., warn_bad_lines: bool = ..., na_filter: bool = ..., na_values=..., na_fvalues=..., keep_default_na: bool = ..., true_values=..., false_values=..., allow_leading_cols: bool = ..., skiprows=..., skipfooter: int = ..., verbose: bool = ..., mangle_dupe_cols: bool = ..., float_precision: Union[Literal[round_trip, legacy, high], None] = ..., skip_blank_lines: bool = ..., encoding_errors: Union[bytes, str] = ...) -> None: ...
    def set_error_bad_lines(self, status: int) -> None: ...
    def set_noconvert(self, i: int) -> None: ...
    def remove_noconvert(self, i: int) -> None: ...
    def close(self) -> None: ...
    def read(self, rows: Union[int, None] = ...) -> dict[int, ArrayLike]: ...
    def read_low_memory(self, rows: Union[int, None]) -> list[dict[int, ArrayLike]]: ...
