import numpy as np
from pandas import MultiIndex as MultiIndex
from pandas._typing import npt as npt

class IndexEngine:
    over_size_threshold: bool
    def __init__(self, values: np.ndarray) -> None: ...
    def __contains__(self, val: object) -> bool: ...
    def get_loc(self, val: object) -> Union[int, slice, np.ndarray]: ...
    def sizeof(self, deep: bool = ...) -> int: ...
    def __sizeof__(self) -> int: ...
    @property
    def is_unique(self) -> bool: ...
    @property
    def is_monotonic_increasing(self) -> bool: ...
    @property
    def is_monotonic_decreasing(self) -> bool: ...
    @property
    def is_mapping_populated(self) -> bool: ...
    def clear_mapping(self) -> None: ...
    def get_indexer(self, values: np.ndarray) -> npt.NDArray[np.intp]: ...
    def get_indexer_non_unique(self, targets: np.ndarray) -> tuple[npt.NDArray[np.intp], npt.NDArray[np.intp]]: ...

class Float64Engine(IndexEngine): ...
class Float32Engine(IndexEngine): ...
class Int64Engine(IndexEngine): ...
class Int32Engine(IndexEngine): ...
class Int16Engine(IndexEngine): ...
class Int8Engine(IndexEngine): ...
class UInt64Engine(IndexEngine): ...
class UInt32Engine(IndexEngine): ...
class UInt16Engine(IndexEngine): ...
class UInt8Engine(IndexEngine): ...
class ObjectEngine(IndexEngine): ...
class DatetimeEngine(Int64Engine): ...
class TimedeltaEngine(DatetimeEngine): ...
class PeriodEngine(Int64Engine): ...

class BaseMultiIndexCodesEngine:
    levels: list[np.ndarray]
    offsets: np.ndarray
    def __init__(self, levels: list[np.ndarray], labels: list[np.ndarray], offsets: np.ndarray) -> None: ...
    def get_indexer(self, target: npt.NDArray[np.object_]) -> npt.NDArray[np.intp]: ...
    def get_indexer_with_fill(self, target: np.ndarray, values: np.ndarray, method: str, limit: Union[int, None]) -> npt.NDArray[np.intp]: ...
