import numpy as np
from pandas._typing import npt as npt
from typing import Union, Literal

def group_median_float64(out: np.ndarray, counts: npt.NDArray[np.int64], values: np.ndarray, labels: npt.NDArray[np.int64], min_count: int = ...) -> None: ...
def group_cumprod_float64(out: np.ndarray, values: np.ndarray, labels: np.ndarray, ngroups: int, is_datetimelike: bool, skipna: bool = ...) -> None: ...
def group_cumsum(out: np.ndarray, values: np.ndarray, labels: np.ndarray, ngroups: int, is_datetimelike: bool, skipna: bool = ...) -> None: ...
def group_shift_indexer(out: np.ndarray, labels: np.ndarray, ngroups: int, periods: int) -> None: ...
def group_fillna_indexer(out: np.ndarray, labels: np.ndarray, sorted_labels: npt.NDArray[np.intp], mask: npt.NDArray[np.uint8], direction: Literal[ffill, bfill], limit: int, dropna: bool) -> None: ...
def group_any_all(out: np.ndarray, values: np.ndarray, labels: np.ndarray, mask: np.ndarray, val_test: Literal[any, all], skipna: bool) -> None: ...
def group_add(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ..., datetimelike: bool = ...) -> None: ...
def group_prod(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ...) -> None: ...
def group_var(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ..., ddof: int = ...) -> None: ...
def group_mean(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ..., is_datetimelike: bool = ..., mask: Union[np.ndarray, None] = ..., result_mask: Union[np.ndarray, None] = ...) -> None: ...
def group_ohlc(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ...) -> None: ...
def group_quantile(out: npt.NDArray[np.float64], values: np.ndarray, labels: npt.NDArray[np.intp], mask: npt.NDArray[np.uint8], sort_indexer: npt.NDArray[np.intp], qs: npt.NDArray[np.float64], interpolation: Literal[linear, lower, higher, nearest, midpoint]) -> None: ...
def group_last(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ...) -> None: ...
def group_nth(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ..., rank: int = ...) -> None: ...
def group_rank(out: np.ndarray, values: np.ndarray, labels: np.ndarray, ngroups: int, is_datetimelike: bool, ties_method: Literal[aveage, min, max, first, dense] = ..., ascending: bool = ..., pct: bool = ..., na_option: Literal[keep, top, bottom] = ...) -> None: ...
def group_max(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ..., mask: Union[np.ndarray, None] = ..., result_mask: Union[np.ndarray, None] = ...) -> None: ...
def group_min(out: np.ndarray, counts: np.ndarray, values: np.ndarray, labels: np.ndarray, min_count: int = ..., mask: Union[np.ndarray, None] = ..., result_mask: Union[np.ndarray, None] = ...) -> None: ...
def group_cummin(out: np.ndarray, values: np.ndarray, labels: np.ndarray, ngroups: int, is_datetimelike: bool) -> None: ...
def group_cummax(out: np.ndarray, values: np.ndarray, labels: np.ndarray, ngroups: int, is_datetimelike: bool) -> None: ...
