from numpy import bool_ as bool_, dtype as dtype, float32 as float32, float64 as float64, int16 as int16, int32 as int32, int64 as int64, int8 as int8, int_ as int_, ndarray as ndarray, uint as uint, uint16 as uint16, uint32 as uint32, uint64 as uint64, uint8 as uint8
from numpy.random import BitGenerator as BitGenerator, SeedSequence as SeedSequence
from numpy.typing import ArrayLike as ArrayLike, _ArrayLikeFloat_co, _ArrayLikeInt_co, _DTypeLikeBool, _DTypeLikeInt, _DTypeLikeUInt, _Int16Codes, _Int32Codes, _Int64Codes, _Int8Codes, _IntCodes, _ShapeLike, _SupportsDType, _UInt16Codes, _UInt32Codes, _UInt64Codes, _UInt8Codes, _UIntCodes
from typing import Any, Callable, Dict, Optional, Tuple, Type, Union, overload
from typing_extensions import Literal as Literal

class Generator:
    def __init__(self, bit_generator: BitGenerator) -> None: ...
    def __reduce__(self) -> Tuple[Callable[[str], Generator], Tuple[str], Dict[str, Any]]: ...
    @property
    def bit_generator(self) -> BitGenerator: ...
    def bytes(self, length: int) -> bytes: ...
    @overload
    def standard_normal(self, size: None = ..., dtype: Union[_DTypeLikeFloat32, _DTypeLikeFloat64] = ..., out: None = ...) -> float: ...
    @overload
    def standard_normal(self, size: _ShapeLike = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_normal(self, *, out: ndarray[Any, dtype[float64]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_normal(self, size: _ShapeLike = ..., dtype: _DTypeLikeFloat32 = ..., out: Optional[ndarray[Any, dtype[float32]]] = ...) -> ndarray[Any, dtype[float32]]: ...
    @overload
    def standard_normal(self, size: _ShapeLike = ..., dtype: _DTypeLikeFloat64 = ..., out: Optional[ndarray[Any, dtype[float64]]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def permutation(self, x: int, axis: int = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def permutation(self, x: ArrayLike, axis: int = ...) -> ndarray[Any, Any]: ...
    @overload
    def standard_exponential(self, size: None = ..., dtype: Union[_DTypeLikeFloat32, _DTypeLikeFloat64] = ..., method: Literal[zig, inv] = ..., out: None = ...) -> float: ...
    @overload
    def standard_exponential(self, size: _ShapeLike = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_exponential(self, *, out: ndarray[Any, dtype[float64]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_exponential(self, size: _ShapeLike = ..., *, method: Literal[zig, inv] = ..., out: Optional[ndarray[Any, dtype[float64]]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_exponential(self, size: _ShapeLike = ..., dtype: _DTypeLikeFloat32 = ..., method: Literal[zig, inv] = ..., out: Optional[ndarray[Any, dtype[float32]]] = ...) -> ndarray[Any, dtype[float32]]: ...
    @overload
    def standard_exponential(self, size: _ShapeLike = ..., dtype: _DTypeLikeFloat64 = ..., method: Literal[zig, inv] = ..., out: Optional[ndarray[Any, dtype[float64]]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def random(self, size: None = ..., dtype: Union[_DTypeLikeFloat32, _DTypeLikeFloat64] = ..., out: None = ...) -> float: ...
    @overload
    def random(self, *, out: ndarray[Any, dtype[float64]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def random(self, size: _ShapeLike = ..., *, out: Optional[ndarray[Any, dtype[float64]]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def random(self, size: _ShapeLike = ..., dtype: _DTypeLikeFloat32 = ..., out: Optional[ndarray[Any, dtype[float32]]] = ...) -> ndarray[Any, dtype[float32]]: ...
    @overload
    def random(self, size: _ShapeLike = ..., dtype: _DTypeLikeFloat64 = ..., out: Optional[ndarray[Any, dtype[float64]]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def beta(self, a: float, b: float, size: None = ...) -> float: ...
    @overload
    def beta(self, a: _ArrayLikeFloat_co, b: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def exponential(self, scale: float = ..., size: None = ...) -> float: ...
    @overload
    def exponential(self, scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def integers(self, low: int, high: Optional[int] = ...) -> int: ...
    @overload
    def integers(self, low: int, high: Optional[int] = ..., size: None = ..., dtype: _DTypeLikeBool = ..., endpoint: bool = ...) -> bool: ...
    @overload
    def integers(self, low: int, high: Optional[int] = ..., size: None = ..., dtype: Union[_DTypeLikeInt, _DTypeLikeUInt] = ..., endpoint: bool = ...) -> int: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: _DTypeLikeBool = ..., endpoint: bool = ...) -> ndarray[Any, dtype[bool_]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[int8], Type[int8], _Int8Codes, _SupportsDType[dtype[int8]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[int8]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[int16], Type[int16], _Int16Codes, _SupportsDType[dtype[int16]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[int16]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[int32], Type[int32], _Int32Codes, _SupportsDType[dtype[int32]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[Union[int32]]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Optional[Union[dtype[int64], Type[int64], _Int64Codes, _SupportsDType[dtype[int64]]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[uint8], Type[uint8], _UInt8Codes, _SupportsDType[dtype[uint8]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[uint8]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[uint16], Type[uint16], _UInt16Codes, _SupportsDType[dtype[uint16]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[Union[uint16]]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[uint32], Type[uint32], _UInt32Codes, _SupportsDType[dtype[uint32]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[uint32]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[uint64], Type[uint64], _UInt64Codes, _SupportsDType[dtype[uint64]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[uint64]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[int_], Type[int], Type[int_], _IntCodes, _SupportsDType[dtype[int_]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[int_]]: ...
    @overload
    def integers(self, low: _ArrayLikeInt_co, high: Optional[_ArrayLikeInt_co] = ..., size: Optional[_ShapeLike] = ..., dtype: Union[dtype[uint], Type[uint], _UIntCodes, _SupportsDType[dtype[uint]]] = ..., endpoint: bool = ...) -> ndarray[Any, dtype[uint]]: ...
    @overload
    def choice(self, a: int, size: None = ..., replace: bool = ..., p: Optional[_ArrayLikeFloat_co] = ..., axis: int = ..., shuffle: bool = ...) -> int: ...
    @overload
    def choice(self, a: int, size: _ShapeLike = ..., replace: bool = ..., p: Optional[_ArrayLikeFloat_co] = ..., axis: int = ..., shuffle: bool = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def choice(self, a: ArrayLike, size: None = ..., replace: bool = ..., p: Optional[_ArrayLikeFloat_co] = ..., axis: int = ..., shuffle: bool = ...) -> Any: ...
    @overload
    def choice(self, a: ArrayLike, size: _ShapeLike = ..., replace: bool = ..., p: Optional[_ArrayLikeFloat_co] = ..., axis: int = ..., shuffle: bool = ...) -> ndarray[Any, Any]: ...
    @overload
    def uniform(self, low: float = ..., high: float = ..., size: None = ...) -> float: ...
    @overload
    def uniform(self, low: _ArrayLikeFloat_co = ..., high: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def normal(self, loc: float = ..., scale: float = ..., size: None = ...) -> float: ...
    @overload
    def normal(self, loc: _ArrayLikeFloat_co = ..., scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_gamma(self, shape: float, size: None = ..., dtype: Union[_DTypeLikeFloat32, _DTypeLikeFloat64] = ..., out: None = ...) -> float: ...
    @overload
    def standard_gamma(self, shape: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_gamma(self, shape: _ArrayLikeFloat_co, *, out: ndarray[Any, dtype[float64]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_gamma(self, shape: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ..., dtype: _DTypeLikeFloat32 = ..., out: Optional[ndarray[Any, dtype[float32]]] = ...) -> ndarray[Any, dtype[float32]]: ...
    @overload
    def standard_gamma(self, shape: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ..., dtype: _DTypeLikeFloat64 = ..., out: Optional[ndarray[Any, dtype[float64]]] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def gamma(self, shape: float, scale: float = ..., size: None = ...) -> float: ...
    @overload
    def gamma(self, shape: _ArrayLikeFloat_co, scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def f(self, dfnum: float, dfden: float, size: None = ...) -> float: ...
    @overload
    def f(self, dfnum: _ArrayLikeFloat_co, dfden: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def noncentral_f(self, dfnum: float, dfden: float, nonc: float, size: None = ...) -> float: ...
    @overload
    def noncentral_f(self, dfnum: _ArrayLikeFloat_co, dfden: _ArrayLikeFloat_co, nonc: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def chisquare(self, df: float, size: None = ...) -> float: ...
    @overload
    def chisquare(self, df: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def noncentral_chisquare(self, df: float, nonc: float, size: None = ...) -> float: ...
    @overload
    def noncentral_chisquare(self, df: _ArrayLikeFloat_co, nonc: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_t(self, df: float, size: None = ...) -> float: ...
    @overload
    def standard_t(self, df: _ArrayLikeFloat_co, size: None = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_t(self, df: _ArrayLikeFloat_co, size: _ShapeLike = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def vonmises(self, mu: float, kappa: float, size: None = ...) -> float: ...
    @overload
    def vonmises(self, mu: _ArrayLikeFloat_co, kappa: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def pareto(self, a: float, size: None = ...) -> float: ...
    @overload
    def pareto(self, a: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def weibull(self, a: float, size: None = ...) -> float: ...
    @overload
    def weibull(self, a: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def power(self, a: float, size: None = ...) -> float: ...
    @overload
    def power(self, a: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def standard_cauchy(self, size: None = ...) -> float: ...
    @overload
    def standard_cauchy(self, size: _ShapeLike = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def laplace(self, loc: float = ..., scale: float = ..., size: None = ...) -> float: ...
    @overload
    def laplace(self, loc: _ArrayLikeFloat_co = ..., scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def gumbel(self, loc: float = ..., scale: float = ..., size: None = ...) -> float: ...
    @overload
    def gumbel(self, loc: _ArrayLikeFloat_co = ..., scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def logistic(self, loc: float = ..., scale: float = ..., size: None = ...) -> float: ...
    @overload
    def logistic(self, loc: _ArrayLikeFloat_co = ..., scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def lognormal(self, mean: float = ..., sigma: float = ..., size: None = ...) -> float: ...
    @overload
    def lognormal(self, mean: _ArrayLikeFloat_co = ..., sigma: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def rayleigh(self, scale: float = ..., size: None = ...) -> float: ...
    @overload
    def rayleigh(self, scale: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def wald(self, mean: float, scale: float, size: None = ...) -> float: ...
    @overload
    def wald(self, mean: _ArrayLikeFloat_co, scale: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def triangular(self, left: float, mode: float, right: float, size: None = ...) -> float: ...
    @overload
    def triangular(self, left: _ArrayLikeFloat_co, mode: _ArrayLikeFloat_co, right: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    @overload
    def binomial(self, n: int, p: float, size: None = ...) -> int: ...
    @overload
    def binomial(self, n: _ArrayLikeInt_co, p: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def negative_binomial(self, n: float, p: float, size: None = ...) -> int: ...
    @overload
    def negative_binomial(self, n: _ArrayLikeFloat_co, p: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def poisson(self, lam: float = ..., size: None = ...) -> int: ...
    @overload
    def poisson(self, lam: _ArrayLikeFloat_co = ..., size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def zipf(self, a: float, size: None = ...) -> int: ...
    @overload
    def zipf(self, a: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def geometric(self, p: float, size: None = ...) -> int: ...
    @overload
    def geometric(self, p: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def hypergeometric(self, ngood: int, nbad: int, nsample: int, size: None = ...) -> int: ...
    @overload
    def hypergeometric(self, ngood: _ArrayLikeInt_co, nbad: _ArrayLikeInt_co, nsample: _ArrayLikeInt_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    @overload
    def logseries(self, p: float, size: None = ...) -> int: ...
    @overload
    def logseries(self, p: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    def multivariate_normal(self, mean: _ArrayLikeFloat_co, cov: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ..., check_valid: Literal[warn, 'raise', ignore] = ..., tol: float = ..., *, method: Literal[svd, eigh, cholesky] = ...) -> ndarray[Any, dtype[float64]]: ...
    def multinomial(self, n: _ArrayLikeInt_co, pvals: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[int64]]: ...
    def multivariate_hypergeometric(self, colors: _ArrayLikeInt_co, nsample: int, size: Optional[_ShapeLike] = ..., method: Literal[marginals, count] = ...) -> ndarray[Any, dtype[int64]]: ...
    def dirichlet(self, alpha: _ArrayLikeFloat_co, size: Optional[_ShapeLike] = ...) -> ndarray[Any, dtype[float64]]: ...
    def permuted(self, x: ArrayLike, *, axis: Optional[int] = ..., out: Optional[ndarray[Any, Any]] = ...) -> ndarray[Any, Any]: ...
    def shuffle(self, x: ArrayLike, axis: int = ...) -> None: ...

def default_rng(seed: Union[None, _ArrayLikeInt_co, SeedSequence, BitGenerator, Generator] = ...) -> Generator: ...
