from numpy import bool_ as bool_, dtype as dtype, float64 as float64, ndarray as ndarray
from typing import Any, Callable

MaskType = bool_
nomask: bool_

class MaskedArrayFutureWarning(FutureWarning): ...
class MAError(Exception): ...
class MaskError(MAError): ...

def default_fill_value(obj) -> None: ...
def minimum_fill_value(obj) -> None: ...
def maximum_fill_value(obj) -> None: ...
def set_fill_value(a, fill_value) -> None: ...
def common_fill_value(a, b) -> None: ...
def filled(a, fill_value=...) -> None: ...
def getdata(a, subok=...) -> None: ...
get_data = getdata

def fix_invalid(a, mask=..., copy=..., fill_value=...) -> None: ...

class _MaskedUFunc:
    f: Any
    __doc__: Any
    __name__: Any
    def __init__(self, ufunc) -> None: ...

class _MaskedUnaryOperation(_MaskedUFunc):
    fill: Any
    domain: Any
    def __init__(self, mufunc, fill=..., domain=...) -> None: ...
    def __call__(self, a, *args, **kwargs) -> None: ...

class _MaskedBinaryOperation(_MaskedUFunc):
    fillx: Any
    filly: Any
    def __init__(self, mbfunc, fillx=..., filly=...) -> None: ...
    def __call__(self, a, b, *args, **kwargs) -> None: ...
    def reduce(self, target, axis=..., dtype=...) -> None: ...
    def outer(self, a, b) -> None: ...
    def accumulate(self, target, axis=...) -> None: ...

class _DomainedBinaryOperation(_MaskedUFunc):
    domain: Any
    fillx: Any
    filly: Any
    def __init__(self, dbfunc, domain, fillx=..., filly=...) -> None: ...
    def __call__(self, a, b, *args, **kwargs) -> None: ...

exp: _MaskedUnaryOperation
conjugate: _MaskedUnaryOperation
sin: _MaskedUnaryOperation
cos: _MaskedUnaryOperation
arctan: _MaskedUnaryOperation
arcsinh: _MaskedUnaryOperation
sinh: _MaskedUnaryOperation
cosh: _MaskedUnaryOperation
tanh: _MaskedUnaryOperation
abs: _MaskedUnaryOperation
absolute: _MaskedUnaryOperation
fabs: _MaskedUnaryOperation
negative: _MaskedUnaryOperation
floor: _MaskedUnaryOperation
ceil: _MaskedUnaryOperation
around: _MaskedUnaryOperation
logical_not: _MaskedUnaryOperation
sqrt: _MaskedUnaryOperation
log: _MaskedUnaryOperation
log2: _MaskedUnaryOperation
log10: _MaskedUnaryOperation
tan: _MaskedUnaryOperation
arcsin: _MaskedUnaryOperation
arccos: _MaskedUnaryOperation
arccosh: _MaskedUnaryOperation
arctanh: _MaskedUnaryOperation
add: _MaskedBinaryOperation
subtract: _MaskedBinaryOperation
multiply: _MaskedBinaryOperation
arctan2: _MaskedBinaryOperation
equal: _MaskedBinaryOperation
not_equal: _MaskedBinaryOperation
less_equal: _MaskedBinaryOperation
greater_equal: _MaskedBinaryOperation
less: _MaskedBinaryOperation
greater: _MaskedBinaryOperation
logical_and: _MaskedBinaryOperation
alltrue: _MaskedBinaryOperation
logical_or: _MaskedBinaryOperation
sometrue: Callable[..., Any]
logical_xor: _MaskedBinaryOperation
bitwise_and: _MaskedBinaryOperation
bitwise_or: _MaskedBinaryOperation
bitwise_xor: _MaskedBinaryOperation
hypot: _MaskedBinaryOperation
divide: _MaskedBinaryOperation
true_divide: _MaskedBinaryOperation
floor_divide: _MaskedBinaryOperation
remainder: _MaskedBinaryOperation
fmod: _MaskedBinaryOperation
mod: _MaskedBinaryOperation

def make_mask_descr(ndtype) -> None: ...
def getmask(a) -> None: ...
get_mask = getmask

def getmaskarray(arr) -> None: ...
def is_mask(m) -> None: ...
def make_mask(m, copy=..., shrink=..., dtype=...) -> None: ...
def make_mask_none(newshape, dtype=...) -> None: ...
def mask_or(m1, m2, copy=..., shrink=...) -> None: ...
def flatten_mask(mask) -> None: ...
def masked_where(condition, a, copy=...) -> None: ...
def masked_greater(x, value, copy=...) -> None: ...
def masked_greater_equal(x, value, copy=...) -> None: ...
def masked_less(x, value, copy=...) -> None: ...
def masked_less_equal(x, value, copy=...) -> None: ...
def masked_not_equal(x, value, copy=...) -> None: ...
def masked_equal(x, value, copy=...) -> None: ...
def masked_inside(x, v1, v2, copy=...) -> None: ...
def masked_outside(x, v1, v2, copy=...) -> None: ...
def masked_object(x, value, copy=..., shrink=...) -> None: ...
def masked_values(x, value, rtol=..., atol=..., copy=..., shrink=...) -> None: ...
def masked_invalid(a, copy=...) -> None: ...

class _MaskedPrintOption:
    def __init__(self, display) -> None: ...
    def display(self) -> None: ...
    def set_display(self, s) -> None: ...
    def enabled(self) -> None: ...
    def enable(self, shrink=...) -> None: ...

masked_print_option: _MaskedPrintOption

def flatten_structured_array(a) -> None: ...

class MaskedIterator:
    ma: Any
    dataiter: Any
    maskiter: Any
    def __init__(self, ma) -> None: ...
    def __iter__(self): ...
    def __getitem__(self, indx) -> None: ...
    def __setitem__(self, index, value) -> None: ...
    def __next__(self) -> None: ...

class MaskedArray(ndarray[_ShapeType, _DType_co]):
    __array_priority__: Any
    def __new__(cls, data=..., mask=..., dtype=..., copy=..., subok=..., ndmin=..., fill_value=..., keep_mask=..., hard_mask=..., shrink=..., order=...) -> None: ...
    def __array_finalize__(self, obj) -> None: ...
    def __array_wrap__(self, obj, context=...) -> None: ...
    def view(self, dtype=..., type=..., fill_value=...) -> None: ...
    def __getitem__(self, indx) -> None: ...
    def __setitem__(self, indx, value) -> None: ...
    @property
    def dtype(self) -> None: ...
    @dtype.setter
    def dtype(self, dtype) -> None: ...
    @property
    def shape(self) -> None: ...
    @shape.setter
    def shape(self, shape) -> None: ...
    def __setmask__(self, mask, copy=...) -> None: ...
    @property
    def mask(self) -> None: ...
    @mask.setter
    def mask(self, value) -> None: ...
    @property
    def recordmask(self) -> None: ...
    @recordmask.setter
    def recordmask(self, mask) -> None: ...
    def harden_mask(self) -> None: ...
    def soften_mask(self) -> None: ...
    @property
    def hardmask(self) -> None: ...
    def unshare_mask(self) -> None: ...
    @property
    def sharedmask(self) -> None: ...
    def shrink_mask(self) -> None: ...
    @property
    def baseclass(self) -> None: ...
    data: Any
    @property
    def flat(self) -> None: ...
    @flat.setter
    def flat(self, value) -> None: ...
    @property
    def fill_value(self) -> None: ...
    @fill_value.setter
    def fill_value(self, value=...) -> None: ...
    get_fill_value: Any
    set_fill_value: Any
    def filled(self, fill_value=...) -> None: ...
    def compressed(self) -> None: ...
    def compress(self, condition, axis=..., out=...) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __add__(self, other) -> None: ...
    def __radd__(self, other) -> None: ...
    def __sub__(self, other) -> None: ...
    def __rsub__(self, other) -> None: ...
    def __mul__(self, other) -> None: ...
    def __rmul__(self, other) -> None: ...
    def __div__(self, other) -> None: ...
    def __truediv__(self, other) -> None: ...
    def __rtruediv__(self, other) -> None: ...
    def __floordiv__(self, other) -> None: ...
    def __rfloordiv__(self, other) -> None: ...
    def __pow__(self, other) -> None: ...
    def __rpow__(self, other) -> None: ...
    def __iadd__(self, other) -> None: ...
    def __isub__(self, other) -> None: ...
    def __imul__(self, other) -> None: ...
    def __idiv__(self, other) -> None: ...
    def __ifloordiv__(self, other) -> None: ...
    def __itruediv__(self, other) -> None: ...
    def __ipow__(self, other) -> None: ...
    def __float__(self) -> None: ...
    def __int__(self) -> None: ...
    @property
    def imag(self) -> None: ...
    get_imag: Any
    @property
    def real(self) -> None: ...
    get_real: Any
    def count(self, axis=..., keepdims=...) -> None: ...
    def ravel(self, order=...) -> None: ...
    def reshape(self, *s, **kwargs) -> None: ...
    def resize(self, newshape, refcheck=..., order=...) -> None: ...
    def put(self, indices, values, mode=...) -> None: ...
    def ids(self) -> None: ...
    def iscontiguous(self) -> None: ...
    def all(self, axis=..., out=..., keepdims=...) -> None: ...
    def any(self, axis=..., out=..., keepdims=...) -> None: ...
    def nonzero(self) -> None: ...
    def trace(self, offset=..., axis1=..., axis2=..., dtype=..., out=...) -> None: ...
    def dot(self, b, out=..., strict=...) -> None: ...
    def sum(self, axis=..., dtype=..., out=..., keepdims=...) -> None: ...
    def cumsum(self, axis=..., dtype=..., out=...) -> None: ...
    def prod(self, axis=..., dtype=..., out=..., keepdims=...) -> None: ...
    product: Any
    def cumprod(self, axis=..., dtype=..., out=...) -> None: ...
    def mean(self, axis=..., dtype=..., out=..., keepdims=...) -> None: ...
    def anom(self, axis=..., dtype=...) -> None: ...
    def var(self, axis=..., dtype=..., out=..., ddof=..., keepdims=...) -> None: ...
    def std(self, axis=..., dtype=..., out=..., ddof=..., keepdims=...) -> None: ...
    def round(self, decimals=..., out=...) -> None: ...
    def argsort(self, axis=..., kind=..., order=..., endwith=..., fill_value=...) -> None: ...
    def argmin(self, axis=..., fill_value=..., out=...) -> None: ...
    def argmax(self, axis=..., fill_value=..., out=...) -> None: ...
    def sort(self, axis=..., kind=..., order=..., endwith=..., fill_value=...) -> None: ...
    def min(self, axis=..., out=..., fill_value=..., keepdims=...) -> None: ...
    def max(self, axis=..., out=..., fill_value=..., keepdims=...) -> None: ...
    def ptp(self, axis=..., out=..., fill_value=..., keepdims=...) -> None: ...
    def partition(self, *args, **kwargs) -> None: ...
    def argpartition(self, *args, **kwargs) -> None: ...
    def take(self, indices, axis=..., out=..., mode=...) -> None: ...
    copy: Any
    diagonal: Any
    flatten: Any
    repeat: Any
    squeeze: Any
    swapaxes: Any
    T: Any
    transpose: Any
    def tolist(self, fill_value=...) -> None: ...
    def tobytes(self, fill_value=..., order=...) -> None: ...
    def tofile(self, fid, sep=..., format=...) -> None: ...
    def toflex(self) -> None: ...
    torecords: Any
    def __reduce__(self) -> None: ...
    def __deepcopy__(self, memo=...) -> None: ...

class mvoid(MaskedArray[_ShapeType, _DType_co]):
    def __new__(self, data, mask=..., dtype=..., fill_value=..., hardmask=..., copy=..., subok=...) -> None: ...
    def __getitem__(self, indx) -> None: ...
    def __setitem__(self, indx, value) -> None: ...
    def __iter__(self): ...
    def __len__(self) -> None: ...
    def filled(self, fill_value=...) -> None: ...
    def tolist(self) -> None: ...

def isMaskedArray(x) -> None: ...
isarray = isMaskedArray
isMA = isMaskedArray

class MaskedConstant(MaskedArray[Any, dtype[float64]]):
    def __new__(cls) -> None: ...
    __class__: Any
    def __array_finalize__(self, obj) -> None: ...
    def __array_prepare__(self, obj, context=...) -> None: ...
    def __array_wrap__(self, obj, context=...) -> None: ...
    def __format__(self, format_spec) -> None: ...
    def __reduce__(self) -> None: ...
    def __iop__(self, other) -> None: ...
    __iadd__: Any
    __isub__: Any
    __imul__: Any
    __ifloordiv__: Any
    __itruediv__: Any
    __ipow__: Any
    def copy(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> None: ...
    def __deepcopy__(self, memo) -> None: ...
    def __setattr__(self, attr, value) -> None: ...

masked: MaskedConstant
masked_singleton: MaskedConstant
masked_array = MaskedArray

def array(data, dtype=..., copy=..., order=..., mask=..., fill_value=..., keep_mask=..., hard_mask=..., shrink=..., subok=..., ndmin=...) -> None: ...
def is_masked(x) -> None: ...

class _extrema_operation(_MaskedUFunc):
    compare: Any
    fill_value_func: Any
    def __init__(self, ufunc, compare, fill_value) -> None: ...
    def __call__(self, a, b) -> None: ...
    def reduce(self, target, axis=...) -> None: ...
    def outer(self, a, b) -> None: ...

def min(obj, axis=..., out=..., fill_value=..., keepdims=...) -> None: ...
def max(obj, axis=..., out=..., fill_value=..., keepdims=...) -> None: ...
def ptp(obj, axis=..., out=..., fill_value=..., keepdims=...) -> None: ...

class _frommethod:
    __name__: Any
    __doc__: Any
    reversed: Any
    def __init__(self, methodname, reversed=...) -> None: ...
    def getdoc(self) -> None: ...
    def __call__(self, a, *args, **params) -> None: ...

all: _frommethod
anomalies: _frommethod
anom: _frommethod
any: _frommethod
compress: _frommethod
cumprod: _frommethod
cumsum: _frommethod
copy: _frommethod
diagonal: _frommethod
harden_mask: _frommethod
ids: _frommethod
mean: _frommethod
nonzero: _frommethod
prod: _frommethod
product: _frommethod
ravel: _frommethod
repeat: _frommethod
soften_mask: _frommethod
std: _frommethod
sum: _frommethod
swapaxes: _frommethod
trace: _frommethod
var: _frommethod
count: _frommethod
argmin: _frommethod
argmax: _frommethod
minimum: _extrema_operation
maximum: _extrema_operation

def take(a, indices, axis=..., out=..., mode=...) -> None: ...
def power(a, b, third=...) -> None: ...
def argsort(a, axis=..., kind=..., order=..., endwith=..., fill_value=...) -> None: ...
def sort(a, axis=..., kind=..., order=..., endwith=..., fill_value=...) -> None: ...
def compressed(x) -> None: ...
def concatenate(arrays, axis=...) -> None: ...
def diag(v, k=...) -> None: ...
def left_shift(a, n) -> None: ...
def right_shift(a, n) -> None: ...
def put(a, indices, values, mode=...) -> None: ...
def putmask(a, mask, values) -> None: ...
def transpose(a, axes=...) -> None: ...
def reshape(a, new_shape, order=...) -> None: ...
def resize(x, new_shape) -> None: ...
def ndim(obj) -> None: ...
def shape(obj) -> None: ...
def size(obj, axis=...) -> None: ...
def where(condition, x=..., y=...) -> None: ...
def choose(indices, choices, out=..., mode=...) -> None: ...
def round_(a, decimals=..., out=...) -> None: ...
round = round_

def inner(a, b) -> None: ...
innerproduct = inner

def outer(a, b) -> None: ...
outerproduct = outer

def correlate(a, v, mode=..., propagate_mask=...) -> None: ...
def convolve(a, v, mode=..., propagate_mask=...) -> None: ...
def allequal(a, b, fill_value=...) -> None: ...
def allclose(a, b, masked_equal=..., rtol=..., atol=...) -> None: ...
def asarray(a, dtype=..., order=...) -> None: ...
def asanyarray(a, dtype=...) -> None: ...
def fromflex(fxarray) -> None: ...

class _convert2ma:
    __doc__: Any
    def __init__(self, funcname, params=...) -> None: ...
    def getdoc(self) -> None: ...
    def __call__(self, *args, **params) -> None: ...

arange: _convert2ma
empty: _convert2ma
empty_like: _convert2ma
frombuffer: _convert2ma
fromfunction: _convert2ma
identity: _convert2ma
ones: _convert2ma
zeros: _convert2ma

def append(a, b, axis=...) -> None: ...
def dot(a, b, strict=..., out=...) -> None: ...
def mask_rowcols(a, axis=...) -> None: ...
