from collections.abc import Generator

from _typeshed import Incomplete

from .. import parrec as parrec
from ..fileholders import FileHolder as FileHolder
from ..nifti1 import Nifti1Extension as Nifti1Extension
from ..nifti1 import Nifti1Header as Nifti1Header
from ..nifti1 import Nifti1Image as Nifti1Image
from ..openers import ImageOpener as ImageOpener
from ..parrec import PARRECArrayProxy as PARRECArrayProxy
from ..parrec import PARRECError as PARRECError
from ..parrec import PARRECHeader as PARRECHeader
from ..parrec import PARRECImage as PARRECImage
from ..parrec import exts2pars as exts2pars
from ..parrec import parse_PAR_header as parse_PAR_header
from ..parrec import vol_is_full as vol_is_full
from ..parrec import vol_numbers as vol_numbers
from ..testing import assert_arr_dict_equal as assert_arr_dict_equal
from ..testing import clear_and_catch_warnings as clear_and_catch_warnings
from ..testing import suppress_warnings as suppress_warnings
from ..volumeutils import array_from_file as array_from_file
from . import test_spatialimages as tsi
from .test_arrayproxy import check_mmap as check_mmap

DATA_PATH: Incomplete
EG_PAR: Incomplete
EG_REC: Incomplete
HDR_INFO: Incomplete
HDR_DEFS: Incomplete
TRUNC_PAR: Incomplete
TRUNC_REC: Incomplete
ADC_PAR: Incomplete
V4_PAR: Incomplete
V41_PAR: Incomplete
DUAL_TR_PAR: Incomplete
ANON_PAR: Incomplete
VARY_PAR: Incomplete
VARY_REC: Incomplete
VARIANT_PAR: Incomplete
AN_OLD_AFFINE: Incomplete
PHILIPS_AFFINE: Incomplete
PREVIOUS_AFFINES: Incomplete
DTI_PAR_BVECS: Incomplete
DTI_PAR_BVALS: Incomplete
EXAMPLE_IMAGES: Incomplete

def test_top_level_load() -> None: ...
def test_header() -> None: ...
def test_header_scaling() -> None: ...
def test_header_volume_labels() -> None: ...
def test_orientation() -> None: ...
def test_data_offset() -> None: ...
def test_affine() -> None: ...
def test_affine_regression() -> None: ...
def test_get_sorted_slice_indices() -> None: ...
def test_sorting_dual_echo_T1() -> None: ...
def test_sorting_multiple_echos_and_contrasts() -> None: ...
def test_sorting_multiecho_ASL() -> None: ...
def test_vol_number() -> None: ...
def test_vol_is_full() -> None: ...
def gen_par_fobj() -> Generator[Incomplete, None, None]: ...
def test_truncated_load() -> None: ...
def test_vol_calculations() -> None: ...
def test_diffusion_parameters() -> None: ...
def test_diffusion_parameters_strict_sort() -> None: ...
def test_diffusion_parameters_v4() -> None: ...
def test_null_diffusion_params() -> None: ...
def test_epi_params() -> None: ...
def test_xyzt_unit_conversion() -> None: ...
def test_truncations() -> None: ...
def test__get_uniqe_image_defs() -> None: ...
def test_copy_on_init() -> None: ...
def assert_structarr_equal(star1, star2) -> None: ...
def test_header_copy() -> None: ...
def test_image_creation() -> None: ...

class FakeHeader:
    def __init__(self, shape, dtype) -> None: ...
    def get_data_shape(self): ...
    def get_data_dtype(self): ...
    def get_sorted_slice_indices(self): ...
    def get_data_scaling(self, scaling): ...
    def get_rec_shape(self): ...

def test_parrec_proxy() -> None: ...

class TestPARRECImage(tsi.MmapImageMixin):
    image_class = PARRECImage
    check_mmap_mode: bool
    def get_disk_image(self): ...

def test_bitpix() -> None: ...
def test_varying_scaling() -> None: ...
def test_anonymized() -> None: ...
def test_exts2par() -> None: ...
def test_dualTR() -> None: ...
def test_ADC_map() -> None: ...
def test_alternative_header_field_names() -> None: ...
