import unittest
from collections.abc import Generator
from gzip import GzipFile

from _typeshed import Incomplete

from ..deprecator import ExpiredDeprecationError as ExpiredDeprecationError
from ..openers import HAVE_INDEXED_GZIP as HAVE_INDEXED_GZIP
from ..openers import BZ2File as BZ2File
from ..openers import DeterministicGzipFile as DeterministicGzipFile
from ..openers import ImageOpener as ImageOpener
from ..openers import Opener as Opener
from ..optpkg import optional_package as optional_package
from ..tmpdirs import InTemporaryDirectory as InTemporaryDirectory

pyzstd: Incomplete
HAVE_ZSTD: Incomplete
_: Incomplete

class Lunk:
    closed: bool
    message: Incomplete
    def __init__(self, message) -> None: ...
    def write(self) -> None: ...
    def read(self, size: int = -1): ...

def test_Opener() -> None: ...
def test_Opener_various() -> None: ...

class MockIndexedGzipFile(GzipFile):
    def __init__(self, *args, **kwargs) -> None: ...

def patch_indexed_gzip(state) -> Generator[None, None, None]: ...
def test_Opener_gzip_type(tmp_path) -> None: ...

class TestImageOpener(unittest.TestCase):
    def test_vanilla(self) -> None: ...
    def test_new_association(self): ...

def test_file_like_wrapper() -> None: ...
def test_compressionlevel() -> None: ...
def test_compressed_ext_case() -> None: ...
def test_name() -> None: ...
def test_set_extensions() -> None: ...
def test_close_if_mine() -> None: ...
def test_iter() -> None: ...
def md5sum(fname): ...
def test_DeterministicGzipFile() -> None: ...
def test_DeterministicGzipFile_fileobj() -> None: ...
def test_bitwise_determinism() -> None: ...
