from _typeshed import Incomplete
from nibabel import nifti1 as nifti1
from nibabel.affines import from_matvec as from_matvec
from nibabel.casting import have_binary128 as have_binary128
from nibabel.casting import type_info as type_info
from nibabel.eulerangles import euler2mat as euler2mat
from nibabel.nifti1 import Nifti1DicomExtension as Nifti1DicomExtension
from nibabel.nifti1 import Nifti1Extension as Nifti1Extension
from nibabel.nifti1 import Nifti1Extensions as Nifti1Extensions
from nibabel.nifti1 import Nifti1Header as Nifti1Header
from nibabel.nifti1 import Nifti1Image as Nifti1Image
from nibabel.nifti1 import Nifti1Pair as Nifti1Pair
from nibabel.nifti1 import Nifti1PairHeader as Nifti1PairHeader
from nibabel.nifti1 import data_type_codes as data_type_codes
from nibabel.nifti1 import extension_codes as extension_codes
from nibabel.nifti1 import load as load
from nibabel.nifti1 import slice_order_codes as slice_order_codes
from nibabel.optpkg import optional_package as optional_package
from nibabel.pkg_info import cmp_pkg_version as cmp_pkg_version
from nibabel.spatialimages import HeaderDataError as HeaderDataError
from nibabel.tmpdirs import InTemporaryDirectory as InTemporaryDirectory

from ..orientations import aff2axcodes as aff2axcodes
from ..testing import bytesio_filemap as bytesio_filemap
from ..testing import bytesio_round_trip as bytesio_round_trip
from ..testing import clear_and_catch_warnings as clear_and_catch_warnings
from ..testing import data_path as data_path
from ..testing import runif_extra_has as runif_extra_has
from ..testing import suppress_warnings as suppress_warnings
from . import test_analyze as tana
from . import test_spm99analyze as tspm
from .nibabel_data import get_nibabel_data as get_nibabel_data
from .nibabel_data import needs_nibabel_data as needs_nibabel_data
from .test_arraywriters import IUINT_TYPES as IUINT_TYPES
from .test_arraywriters import rt_err_estimate as rt_err_estimate
from .test_orientations import ALL_ORNTS as ALL_ORNTS

header_file: Incomplete
image_file: Incomplete
pydicom: Incomplete
have_dicom: Incomplete
_: Incomplete
dicom_test: Incomplete
R: Incomplete
Z: Incomplete
T: Incomplete
A: Incomplete

class TestNifti1PairHeader(tana.TestAnalyzeHeader, tspm.HeaderScalingMixin):
    header_class = Nifti1PairHeader
    example_file = header_file
    quat_dtype: Incomplete
    supported_np_types: Incomplete
    def test_empty(self) -> None: ...
    def test_from_eg_file(self) -> None: ...
    def test_data_scaling(self) -> None: ...
    def test_big_scaling(self) -> None: ...
    def test_slope_inter(self) -> None: ...
    def test_nifti_qfac_checks(self) -> None: ...
    def test_nifti_qsform_checks(self) -> None: ...
    def test_nifti_xform_codes(self) -> None: ...
    def test_magic_offset_checks(self) -> None: ...
    def test_freesurfer_large_vector_hack(self) -> None: ...
    def test_freesurfer_ico7_hack(self) -> None: ...
    def test_qform_sform(self) -> None: ...
    def test_datatypes(self) -> None: ...
    def test_quaternion(self) -> None: ...
    def test_qform(self) -> None: ...
    def test_sform(self) -> None: ...
    def test_dim_info(self) -> None: ...
    def test_slice_times(self): ...
    def test_intents(self) -> None: ...
    def test_set_slice_times(self) -> None: ...
    def test_xyzt_units(self) -> None: ...
    def test_recoded_fields(self) -> None: ...

def unshear_44(affine): ...

class TestNifti1SingleHeader(TestNifti1PairHeader):
    header_class = Nifti1Header
    def test_empty(self) -> None: ...
    def test_binblock_is_file(self) -> None: ...
    def test_float128(self) -> None: ...

class TestNifti1Pair(tana.TestAnalyzeImage, tspm.ImageScalingMixin):
    image_class = Nifti1Pair
    supported_np_types: Incomplete
    def test_int64_warning_or_error(self) -> None: ...
    def test_none_qsform(self) -> None: ...
    def test_qform_cycle(self) -> None: ...
    def test_header_update_affine(self) -> None: ...
    def test_set_qform(self) -> None: ...
    def test_set_sform(self) -> None: ...
    def test_sqform_code_type(self) -> None: ...
    def test_hdr_diff(self) -> None: ...
    def test_load_save(self) -> None: ...
    def test_load_pixdims(self) -> None: ...
    def test_affines_init(self) -> None: ...
    def test_read_no_extensions(self) -> None: ...
    def test_write_scaling(self) -> None: ...
    def test_dynamic_dtype_aliases(self) -> None: ...
    def test_static_dtype_aliases(self) -> None: ...

class TestNifti1Image(TestNifti1Pair):
    image_class = Nifti1Image
    def test_offset_errors(self) -> None: ...

def test_extension_basics() -> None: ...
def test_ext_eq() -> None: ...
def test_extension_codes() -> None: ...
def test_extension_list() -> None: ...
def test_extension_io() -> None: ...
def test_nifti_extensions() -> None: ...
def test_nifti_dicom_extension() -> None: ...

class TestNifti1General:
    single_class = Nifti1Image
    pair_class = Nifti1Pair
    module = nifti1
    example_file = image_file
    def test_loadsave_cycle(self) -> None: ...
    def test_load(self) -> None: ...
    def test_float_int_min_max(self) -> None: ...
    def test_float_int_spread(self) -> None: ...
    def test_rt_bias(self) -> None: ...
    def test_reoriented_dim_info(self) -> None: ...

def test_large_nifti1() -> None: ...
