import io
import typing as ty
from collections.abc import Sequence
from typing import Literal

import numpy
import numpy.typing as npt

from .arrayproxy import ArrayLike as ArrayLike
from .casting import sctypes_aliases as sctypes_aliases
from .dataobj_images import DataobjImage as DataobjImage
from .filebasedimages import FileBasedHeader as FileBasedHeader
from .filebasedimages import FileBasedImage as FileBasedImage
from .fileholders import FileMap as FileMap
from .fileslice import canonical_slicers as canonical_slicers
from .orientations import apply_orientation as apply_orientation
from .orientations import inv_ornt_aff as inv_ornt_aff
from .viewers import OrthoSlicer3D as OrthoSlicer3D
from .volumeutils import shape_zoom_affine as shape_zoom_affine

SpatialImgT = ty.TypeVar("SpatialImgT", bound="SpatialImage")
SpatialHdrT = ty.TypeVar("SpatialHdrT", bound="SpatialHeader")

class HasDtype(ty.Protocol):
    def get_data_dtype(self) -> numpydtype: ...
    def set_data_dtype(self, dtype: npt.DTypeLike) -> None: ...

class SpatialProtocol(ty.Protocol):
    def get_data_dtype(self) -> numpydtype: ...
    def get_data_shape(self) -> ty.Tuple[int, ...]: ...
    def get_zooms(self) -> ty.Tuple[float, ...]: ...

class HeaderDataError(Exception): ...
class HeaderTypeError(Exception): ...

class SpatialHeader(FileBasedHeader, SpatialProtocol):
    default_x_flip: bool
    data_layout: Literal["F", "C"]
    def __init__(
        self,
        data_dtype: npt.DTypeLike = ...,
        shape: Sequence[int] = (0,),
        zooms: Sequence[float] | None = None,
    ) -> None: ...
    @classmethod
    def from_header(
        klass: type[SpatialHdrT],
        header: SpatialProtocol | FileBasedHeader | ty.Mapping | None = None,
    ) -> SpatialHdrT: ...
    def __eq__(self, other: object) -> bool: ...
    def copy(self) -> SpatialHdrT: ...
    def get_data_dtype(self) -> numpydtype: ...
    def set_data_dtype(self, dtype: npt.DTypeLike) -> None: ...
    def get_data_shape(self) -> tuple[int, ...]: ...
    def set_data_shape(self, shape: Sequence[int]) -> None: ...
    def get_zooms(self) -> tuple[float, ...]: ...
    def set_zooms(self, zooms: Sequence[float]) -> None: ...
    def get_base_affine(self) -> numpyndarray: ...
    get_best_affine = get_base_affine
    def data_to_fileobj(
        self, data: npt.ArrayLike, fileobj: io.IOBase, rescale: bool = True
    ): ...
    def data_from_fileobj(self, fileobj: io.IOBase) -> numpyndarray: ...

def supported_np_types(obj: HasDtype) -> set[type[numpygeneric]]: ...

class ImageDataError(Exception): ...

class SpatialFirstSlicer(ty.Generic[SpatialImgT]):
    img: SpatialImgT
    def __init__(self, img: SpatialImgT) -> None: ...
    def __getitem__(self, slicer: object) -> SpatialImgT: ...
    def check_slicing(
        self, slicer: object, return_spatial: bool = False
    ) -> tuple[slice | int | None, ...]: ...
    def slice_affine(self, slicer: object) -> numpyndarray: ...

class SpatialImage(DataobjImage):
    header_class: type[SpatialHeader]
    ImageSlicer: type[SpatialFirstSlicer]
    header: SpatialHeader
    def __init__(
        self,
        dataobj: ArrayLike,
        affine: numpyndarray | None,
        header: FileBasedHeader | ty.Mapping | None = None,
        extra: ty.Mapping | None = None,
        file_map: FileMap | None = None,
    ) -> None: ...
    @property
    def affine(self): ...
    def update_header(self) -> None: ...
    def get_data_dtype(self) -> numpydtype: ...
    def set_data_dtype(self, dtype: npt.DTypeLike) -> None: ...
    @classmethod
    def from_image(
        klass: type[SpatialImgT], img: SpatialImage | FileBasedImage
    ) -> SpatialImgT: ...
    @property
    def slicer(self) -> SpatialFirstSlicer[SpatialImgT]: ...
    def __getitem__(self, idx: object) -> None: ...
    def orthoview(self) -> OrthoSlicer3D: ...
    def as_reoriented(self, ornt: Sequence[Sequence[int]]) -> SpatialImgT: ...
