from _typeshed import Incomplete

from . import analyze as analyze
from .arrayproxy import get_obj_dtype as get_obj_dtype
from .batteryrunners import Report as Report
from .casting import have_binary128 as have_binary128
from .deprecated import alert_future_error as alert_future_error
from .filebasedimages import ImageFileError as ImageFileError
from .filebasedimages import SerializableImage as SerializableImage
from .optpkg import optional_package as optional_package
from .quaternions import fillpositive as fillpositive
from .quaternions import mat2quat as mat2quat
from .quaternions import quat2mat as quat2mat
from .spatialimages import HeaderDataError as HeaderDataError
from .spm99analyze import SpmAnalyzeHeader as SpmAnalyzeHeader
from .volumeutils import Recoder as Recoder
from .volumeutils import endian_codes as endian_codes
from .volumeutils import make_dt_codes as make_dt_codes

pdcm: Incomplete
have_dicom: Incomplete
_: Incomplete
header_dtd: Incomplete
header_dtype: Incomplete
data_type_codes: Incomplete
xform_codes: Incomplete
unit_codes: Incomplete
slice_order_codes: Incomplete
intent_codes: Incomplete

class Nifti1Extension:
    def __init__(self, code, content) -> None: ...
    def get_code(self): ...
    def get_content(self): ...
    def get_sizeondisk(self): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def write_to(self, fileobj, byteswap) -> None: ...

class Nifti1DicomExtension(Nifti1Extension):
    def __init__(self, code, content, parent_hdr: Incomplete | None = None) -> None: ...

extension_codes: Incomplete

class Nifti1Extensions(list):
    def count(self, ecode): ...
    def get_codes(self): ...
    def get_sizeondisk(self): ...
    def write_to(self, fileobj, byteswap) -> None: ...
    @classmethod
    def from_fileobj(klass, fileobj, size, byteswap): ...

class Nifti1Header(SpmAnalyzeHeader):
    template_dtype = header_dtype
    has_data_slope: bool
    has_data_intercept: bool
    exts_klass = Nifti1Extensions
    is_single: bool
    pair_vox_offset: int
    single_vox_offset: int
    pair_magic: bytes
    single_magic: bytes
    quaternion_threshold: Incomplete
    extensions: Incomplete
    def __init__(
        self,
        binaryblock: Incomplete | None = None,
        endianness: Incomplete | None = None,
        check: bool = True,
        extensions=(),
    ) -> None: ...
    def copy(self): ...
    @classmethod
    def from_fileobj(
        klass, fileobj, endianness: Incomplete | None = None, check: bool = True
    ): ...
    def write_to(self, fileobj) -> None: ...
    def get_best_affine(self): ...
    @classmethod
    def default_structarr(klass, endianness: Incomplete | None = None): ...
    @classmethod
    def from_header(klass, header: Incomplete | None = None, check: bool = True): ...
    def get_data_shape(self): ...
    def set_data_shape(self, shape) -> None: ...
    def set_data_dtype(self, datatype) -> None: ...
    def get_qform_quaternion(self): ...
    def get_qform(self, coded: bool = False): ...
    def set_qform(
        self, affine, code: Incomplete | None = None, strip_shears: bool = True
    ) -> None: ...
    def get_sform(self, coded: bool = False): ...
    def set_sform(self, affine, code: Incomplete | None = None) -> None: ...
    def get_slope_inter(self): ...
    def set_slope_inter(self, slope, inter: Incomplete | None = None) -> None: ...
    def get_dim_info(self): ...
    def set_dim_info(
        self,
        freq: Incomplete | None = None,
        phase: Incomplete | None = None,
        slice: Incomplete | None = None,
    ) -> None: ...
    def get_intent(self, code_repr: str = "label"): ...
    def set_intent(
        self, code, params=(), name: str = "", allow_unknown: bool = False
    ) -> None: ...
    def get_slice_duration(self): ...
    def set_slice_duration(self, duration) -> None: ...
    def get_n_slices(self): ...
    def get_slice_times(self): ...
    def set_slice_times(self, slice_times) -> None: ...
    def get_xyzt_units(self): ...
    def set_xyzt_units(
        self, xyz: Incomplete | None = None, t: Incomplete | None = None
    ) -> None: ...
    @classmethod
    def may_contain_header(klass, binaryblock): ...

class Nifti1PairHeader(Nifti1Header):
    is_single: bool

class Nifti1Pair(analyze.AnalyzeImage):
    header_class: type[Nifti1Header]
    header: Nifti1Header
    rw: bool
    def __init__(
        self,
        dataobj,
        affine,
        header: Incomplete | None = None,
        extra: Incomplete | None = None,
        file_map: Incomplete | None = None,
        dtype: Incomplete | None = None,
    ) -> None: ...
    def update_header(self) -> None: ...
    def get_qform(self, coded: bool = False): ...
    def set_qform(
        self,
        affine,
        code: Incomplete | None = None,
        strip_shears: bool = True,
        **kwargs
    ) -> None: ...
    def get_sform(self, coded: bool = False): ...
    def set_sform(self, affine, code: Incomplete | None = None, **kwargs) -> None: ...
    def set_data_dtype(self, datatype) -> None: ...
    def get_data_dtype(self, finalize: bool = False): ...
    def to_file_map(
        self, file_map: Incomplete | None = None, dtype: Incomplete | None = None
    ) -> None: ...
    def as_reoriented(self, ornt): ...

class Nifti1Image(Nifti1Pair, SerializableImage):
    header_class = Nifti1Header
    valid_exts: Incomplete
    files_types: Incomplete
    def update_header(self) -> None: ...

def load(filename): ...
def save(img, filename) -> None: ...
