from _typeshed import Incomplete
from nibabel.optpkg import optional_package as optional_package

from ..openers import ImageOpener as ImageOpener
from .dwiparams import B2q as B2q
from .dwiparams import nearest_pos_semi_def as nearest_pos_semi_def
from .dwiparams import q2bg as q2bg

pydicom: Incomplete

class WrapperError(Exception): ...
class WrapperPrecisionError(WrapperError): ...

def wrapper_from_file(file_like, *args, **kwargs): ...
def wrapper_from_data(dcm_data): ...

class Wrapper:
    is_csa: bool
    is_mosaic: bool
    is_multiframe: bool
    b_matrix: Incomplete
    q_vector: Incomplete
    dcm_data: Incomplete
    def __init__(self, dcm_data) -> None: ...
    def image_shape(self): ...
    def image_orient_patient(self): ...
    def slice_normal(self): ...
    def rotation_matrix(self): ...
    def voxel_sizes(self): ...
    def image_position(self): ...
    def slice_indicator(self): ...
    def instance_number(self): ...
    def series_signature(self): ...
    def __getitem__(self, key): ...
    def get(self, key, default: Incomplete | None = None): ...
    @property
    def affine(self): ...
    def get_pixel_array(self): ...
    def get_data(self): ...
    def is_same_series(self, other): ...
    def b_value(self): ...
    def b_vector(self): ...

class MultiframeWrapper(Wrapper):
    is_multiframe: bool
    dcm_data: Incomplete
    frames: Incomplete
    shared: Incomplete
    def __init__(self, dcm_data) -> None: ...
    def image_shape(self): ...
    def image_orient_patient(self): ...
    def voxel_sizes(self): ...
    def image_position(self): ...
    def series_signature(self): ...
    def get_data(self): ...

class SiemensWrapper(Wrapper):
    is_csa: bool
    dcm_data: Incomplete
    csa_header: Incomplete
    def __init__(self, dcm_data, csa_header: Incomplete | None = None) -> None: ...
    def slice_normal(self): ...
    def series_signature(self): ...
    def b_matrix(self): ...
    def q_vector(self): ...

class MosaicWrapper(SiemensWrapper):
    is_mosaic: bool
    n_mosaic: Incomplete
    mosaic_size: Incomplete
    def __init__(
        self,
        dcm_data,
        csa_header: Incomplete | None = None,
        n_mosaic: Incomplete | None = None,
    ) -> None: ...
    def image_shape(self): ...
    def image_position(self): ...
    def get_data(self): ...

def none_or_close(val1, val2, rtol: float = 1e-05, atol: float = 1e-06): ...
