from _typeshed import Incomplete

from .externals.netcdf import netcdf_file as netcdf_file
from .fileslice import canonical_slicers as canonical_slicers
from .spatialimages import SpatialHeader as SpatialHeader
from .spatialimages import SpatialImage as SpatialImage

class MincError(Exception): ...

class Minc1File:
    def __init__(self, mincfile) -> None: ...
    def get_data_dtype(self): ...
    def get_data_shape(self): ...
    def get_zooms(self): ...
    def get_affine(self): ...
    def get_scaled_data(self, sliceobj=()): ...

class MincImageArrayProxy:
    minc_file: Incomplete
    def __init__(self, minc_file) -> None: ...
    @property
    def shape(self): ...
    @property
    def ndim(self): ...
    @property
    def is_proxy(self): ...
    def __array__(self, dtype: Incomplete | None = None): ...
    def __getitem__(self, sliceobj): ...

class MincHeader(SpatialHeader):
    data_layout: str
    def data_to_fileobj(self, data, fileobj, rescale: bool = True) -> None: ...
    def data_from_fileobj(self, fileobj) -> None: ...

class Minc1Header(MincHeader):
    @classmethod
    def may_contain_header(klass, binaryblock): ...

class Minc1Image(SpatialImage):
    header_class: type[MincHeader]
    header: MincHeader
    valid_exts: tuple[str, ...]
    files_types: tuple[tuple[str, str], ...]
    makeable: bool
    rw: bool
    ImageArrayProxy = MincImageArrayProxy
    @classmethod
    def from_file_map(
        klass, file_map, *, mmap: bool = True, keep_file_open: Incomplete | None = None
    ): ...

load: Incomplete
