from _typeshed import Incomplete

from .arraywriters import make_array_writer as make_array_writer
from .fileslice import canonical_slicers as canonical_slicers
from .fileslice import predict_shape as predict_shape
from .fileslice import slice2outax as slice2outax
from .spatialimages import SpatialHeader as SpatialHeader
from .spatialimages import SpatialImage as SpatialImage
from .volumeutils import array_from_file as array_from_file
from .volumeutils import make_dt_codes as make_dt_codes
from .volumeutils import native_code as native_code
from .volumeutils import swapped_code as swapped_code
from .wrapstruct import WrapStruct as WrapStruct

BLOCK_SIZE: int
main_header_dtd: Incomplete
hdr_dtype: Incomplete
subheader_dtd: Incomplete
subhdr_dtype: Incomplete
data_type_codes: Incomplete
ft_defs: Incomplete
file_type_codes: Incomplete
patient_orient_defs: Incomplete
patient_orient_codes: Incomplete
patient_orient_radiological: Incomplete
patient_orient_neurological: Incomplete

class EcatHeader(WrapStruct, SpatialHeader):
    template_dtype = hdr_dtype
    def __init__(
        self,
        binaryblock: Incomplete | None = None,
        endianness: Incomplete | None = None,
        check: bool = True,
    ) -> None: ...
    @classmethod
    def guessed_endian(klass, hdr): ...
    @classmethod
    def default_structarr(klass, endianness: Incomplete | None = None): ...
    def get_data_dtype(self) -> None: ...
    def get_patient_orient(self): ...
    def get_filetype(self): ...

def read_mlist(fileobj, endianness): ...
def get_frame_order(mlist): ...
def get_series_framenumbers(mlist): ...
def read_subheaders(fileobj, mlist, endianness): ...

class EcatSubHeader:
    endianness: Incomplete
    fileobj: Incomplete
    subheaders: Incomplete
    def __init__(self, hdr, mlist, fileobj) -> None: ...
    def get_shape(self, frame: int = 0): ...
    def get_nframes(self): ...
    def get_frame_affine(self, frame: int = 0): ...
    def get_zooms(self, frame: int = 0): ...
    def raw_data_from_fileobj(
        self, frame: int = 0, orientation: Incomplete | None = None
    ): ...
    def data_from_fileobj(
        self, frame: int = 0, orientation: Incomplete | None = None
    ): ...

class EcatImageArrayProxy:
    def __init__(self, subheader) -> None: ...
    @property
    def shape(self): ...
    @property
    def ndim(self): ...
    @property
    def is_proxy(self): ...
    def __array__(self, dtype: Incomplete | None = None): ...
    def __getitem__(self, sliceobj): ...

class EcatImage(SpatialImage):
    header_class = EcatHeader
    subheader_class = EcatSubHeader
    valid_exts: Incomplete
    files_types: Incomplete
    header: EcatHeader
    ImageArrayProxy = EcatImageArrayProxy
    extra: Incomplete
    file_map: Incomplete
    def __init__(
        self,
        dataobj,
        affine,
        header,
        subheader,
        mlist,
        extra: Incomplete | None = None,
        file_map: Incomplete | None = None,
    ) -> None: ...
    @property
    def affine(self): ...
    def get_frame_affine(self, frame): ...
    def get_frame(self, frame, orientation: Incomplete | None = None): ...
    def get_data_dtype(self, frame): ...
    @property
    def shape(self): ...
    def get_mlist(self): ...
    def get_subheaders(self): ...
    @classmethod
    def from_file_map(
        klass, file_map, *, mmap: bool = True, keep_file_open: Incomplete | None = None
    ): ...
    def to_file_map(self, file_map: Incomplete | None = None) -> None: ...
    @classmethod
    def from_image(klass, img) -> None: ...
    @classmethod
    def load(klass, filespec): ...

load: Incomplete
