import abc
from collections.abc import Generator

from _typeshed import Incomplete

from . import cifti2 as cifti2

def from_index_mapping(mim): ...
def to_header(axes): ...

class Axis(abc.ABC, metaclass=abc.ABCMeta):
    @property
    def size(self): ...
    @abc.abstractmethod
    def __len__(self): ...
    @abc.abstractmethod
    def __eq__(self, other): ...
    @abc.abstractmethod
    def __add__(self, other): ...
    @abc.abstractmethod
    def __getitem__(self, item): ...

class BrainModelAxis(Axis):
    voxel: Incomplete
    vertex: Incomplete
    nvertices: Incomplete
    def __init__(
        self,
        name,
        voxel: Incomplete | None = None,
        vertex: Incomplete | None = None,
        affine: Incomplete | None = None,
        volume_shape: Incomplete | None = None,
        nvertices: Incomplete | None = None,
    ) -> None: ...
    @classmethod
    def from_mask(cls, mask, name: str = "other", affine: Incomplete | None = None): ...
    @classmethod
    def from_surface(cls, vertices, nvertex, name: str = "Other"): ...
    @classmethod
    def from_index_mapping(cls, mim): ...
    def to_mapping(self, dim): ...
    def iter_structures(self) -> Generator[Incomplete, None, None]: ...
    @staticmethod
    def to_cifti_brain_structure_name(name): ...
    @property
    def surface_mask(self): ...
    @property
    def volume_mask(self): ...
    @property
    def affine(self): ...
    @affine.setter
    def affine(self, value) -> None: ...
    @property
    def volume_shape(self): ...
    @volume_shape.setter
    def volume_shape(self, value) -> None: ...
    @property
    def name(self): ...
    @name.setter
    def name(self, values) -> None: ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __add__(self, other): ...
    def __getitem__(self, item): ...
    def get_element(self, index): ...

class ParcelsAxis(Axis):
    name: Incomplete
    voxels: Incomplete
    vertices: Incomplete
    nvertices: Incomplete
    def __init__(
        self,
        name,
        voxels,
        vertices,
        affine: Incomplete | None = None,
        volume_shape: Incomplete | None = None,
        nvertices: Incomplete | None = None,
    ) -> None: ...
    @classmethod
    def from_brain_models(cls, named_brain_models): ...
    @classmethod
    def from_index_mapping(cls, mim): ...
    def to_mapping(self, dim): ...
    @property
    def affine(self): ...
    @affine.setter
    def affine(self, value) -> None: ...
    @property
    def volume_shape(self): ...
    @volume_shape.setter
    def volume_shape(self, value) -> None: ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __add__(self, other): ...
    def __getitem__(self, item): ...
    def get_element(self, index): ...

class ScalarAxis(Axis):
    name: Incomplete
    meta: Incomplete
    def __init__(self, name, meta: Incomplete | None = None) -> None: ...
    @classmethod
    def from_index_mapping(cls, mim): ...
    def to_mapping(self, dim): ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __add__(self, other): ...
    def __getitem__(self, item): ...
    def get_element(self, index): ...

class LabelAxis(Axis):
    name: Incomplete
    label: Incomplete
    meta: Incomplete
    def __init__(self, name, label, meta: Incomplete | None = None) -> None: ...
    @classmethod
    def from_index_mapping(cls, mim): ...
    def to_mapping(self, dim): ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __add__(self, other): ...
    def __getitem__(self, item): ...
    def get_element(self, index): ...

class SeriesAxis(Axis):
    size: Incomplete
    start: Incomplete
    step: Incomplete
    def __init__(self, start, step, size, unit: str = "SECOND") -> None: ...
    @property
    def time(self): ...
    @classmethod
    def from_index_mapping(cls, mim): ...
    def to_mapping(self, dim): ...
    @property
    def unit(self): ...
    @unit.setter
    def unit(self, value) -> None: ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __add__(self, other): ...
    def __getitem__(self, item): ...
    def get_element(self, index): ...
