from collections.abc import Generator, MutableMapping, MutableSequence

from _typeshed import Incomplete

from .. import xmlutils as xml
from ..arrayproxy import reshape_dataobj as reshape_dataobj
from ..caret import CaretMetaData as CaretMetaData
from ..dataobj_images import DataobjImage as DataobjImage
from ..filebasedimages import FileBasedHeader as FileBasedHeader
from ..filebasedimages import SerializableImage as SerializableImage
from ..nifti1 import Nifti1Extensions as Nifti1Extensions
from ..nifti2 import Nifti2Header as Nifti2Header
from ..nifti2 import Nifti2Image as Nifti2Image
from ..volumeutils import Recoder as Recoder
from ..volumeutils import make_dt_codes as make_dt_codes

class Cifti2HeaderError(Exception): ...

data_type_codes: Incomplete
CIFTI_MAP_TYPES: Incomplete
CIFTI_MODEL_TYPES: Incomplete
CIFTI_SERIESUNIT_TYPES: Incomplete
CIFTI_BRAIN_STRUCTURES: Incomplete

class LimitedNifti2Header(Nifti2Header): ...

class Cifti2MetaData(CaretMetaData):
    @property
    def data(self): ...
    def difference_update(self, metadata) -> None: ...

class Cifti2LabelTable(xml.XmlSerializable, MutableMapping):
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key): ...
    def append(self, label) -> None: ...
    def __setitem__(self, key, value) -> None: ...
    def __delitem__(self, key) -> None: ...
    def __iter__(self): ...

class Cifti2Label(xml.XmlSerializable):
    key: Incomplete
    label: Incomplete
    red: Incomplete
    green: Incomplete
    blue: Incomplete
    alpha: Incomplete
    def __init__(
        self,
        key: int = 0,
        label: str = "",
        red: float = 0.0,
        green: float = 0.0,
        blue: float = 0.0,
        alpha: float = 0.0,
    ) -> None: ...
    @property
    def rgba(self): ...

class Cifti2NamedMap(xml.XmlSerializable):
    map_name: Incomplete
    def __init__(
        self,
        map_name: Incomplete | None = None,
        metadata: Incomplete | None = None,
        label_table: Incomplete | None = None,
    ) -> None: ...
    @property
    def metadata(self): ...
    @metadata.setter
    def metadata(self, metadata) -> None: ...
    @property
    def label_table(self): ...
    @label_table.setter
    def label_table(self, label_table) -> None: ...

class Cifti2Surface(xml.XmlSerializable):
    brain_structure: Incomplete
    surface_number_of_vertices: Incomplete
    def __init__(
        self,
        brain_structure: Incomplete | None = None,
        surface_number_of_vertices: Incomplete | None = None,
    ) -> None: ...

class Cifti2VoxelIndicesIJK(xml.XmlSerializable, MutableSequence):
    def __init__(self, indices: Incomplete | None = None) -> None: ...
    def __len__(self) -> int: ...
    def __delitem__(self, index) -> None: ...
    def __getitem__(self, index): ...
    def __setitem__(self, index, value) -> None: ...
    def insert(self, index, value) -> None: ...

class Cifti2Vertices(xml.XmlSerializable, MutableSequence):
    brain_structure: Incomplete
    def __init__(
        self,
        brain_structure: Incomplete | None = None,
        vertices: Incomplete | None = None,
    ) -> None: ...
    def __len__(self) -> int: ...
    def __delitem__(self, index) -> None: ...
    def __getitem__(self, index): ...
    def __setitem__(self, index, value) -> None: ...
    def insert(self, index, value) -> None: ...

class Cifti2Parcel(xml.XmlSerializable):
    name: Incomplete
    vertices: Incomplete
    def __init__(
        self,
        name: Incomplete | None = None,
        voxel_indices_ijk: Incomplete | None = None,
        vertices: Incomplete | None = None,
    ) -> None: ...
    @property
    def voxel_indices_ijk(self): ...
    @voxel_indices_ijk.setter
    def voxel_indices_ijk(self, value) -> None: ...
    def append_cifti_vertices(self, vertices) -> None: ...
    def pop_cifti2_vertices(self, ith) -> None: ...

class Cifti2TransformationMatrixVoxelIndicesIJKtoXYZ(xml.XmlSerializable):
    meter_exponent: Incomplete
    matrix: Incomplete
    def __init__(
        self, meter_exponent: Incomplete | None = None, matrix: Incomplete | None = None
    ) -> None: ...

class Cifti2Volume(xml.XmlSerializable):
    volume_dimensions: Incomplete
    transformation_matrix_voxel_indices_ijk_to_xyz: Incomplete
    def __init__(
        self,
        volume_dimensions: Incomplete | None = None,
        transform_matrix: Incomplete | None = None,
    ) -> None: ...

class Cifti2VertexIndices(xml.XmlSerializable, MutableSequence):
    def __init__(self, indices: Incomplete | None = None) -> None: ...
    def __len__(self) -> int: ...
    def __delitem__(self, index) -> None: ...
    def __getitem__(self, index): ...
    def __setitem__(self, index, value) -> None: ...
    def insert(self, index, value) -> None: ...

class Cifti2BrainModel(xml.XmlSerializable):
    index_offset: Incomplete
    index_count: Incomplete
    model_type: Incomplete
    brain_structure: Incomplete
    surface_number_of_vertices: Incomplete
    def __init__(
        self,
        index_offset: Incomplete | None = None,
        index_count: Incomplete | None = None,
        model_type: Incomplete | None = None,
        brain_structure: Incomplete | None = None,
        n_surface_vertices: Incomplete | None = None,
        voxel_indices_ijk: Incomplete | None = None,
        vertex_indices: Incomplete | None = None,
    ) -> None: ...
    @property
    def voxel_indices_ijk(self): ...
    @voxel_indices_ijk.setter
    def voxel_indices_ijk(self, value) -> None: ...
    @property
    def vertex_indices(self): ...
    @vertex_indices.setter
    def vertex_indices(self, value) -> None: ...

class Cifti2MatrixIndicesMap(xml.XmlSerializable, MutableSequence):
    applies_to_matrix_dimension: Incomplete
    indices_map_to_data_type: Incomplete
    number_of_series_points: Incomplete
    series_exponent: Incomplete
    series_start: Incomplete
    series_step: Incomplete
    series_unit: Incomplete
    def __init__(
        self,
        applies_to_matrix_dimension,
        indices_map_to_data_type,
        number_of_series_points: Incomplete | None = None,
        series_exponent: Incomplete | None = None,
        series_start: Incomplete | None = None,
        series_step: Incomplete | None = None,
        series_unit: Incomplete | None = None,
        maps=[],
    ) -> None: ...
    def __len__(self) -> int: ...
    def __delitem__(self, index) -> None: ...
    def __getitem__(self, index): ...
    def __setitem__(self, index, value) -> None: ...
    def insert(self, index, value) -> None: ...
    @property
    def named_maps(self) -> Generator[Incomplete, None, None]: ...
    @property
    def surfaces(self) -> Generator[Incomplete, None, None]: ...
    @property
    def parcels(self) -> Generator[Incomplete, None, None]: ...
    @property
    def volume(self): ...
    @volume.setter
    def volume(self, volume) -> None: ...
    @volume.deleter
    def volume(self) -> None: ...
    @property
    def brain_models(self) -> Generator[Incomplete, None, None]: ...

class Cifti2Matrix(xml.XmlSerializable, MutableSequence):
    def __init__(self) -> None: ...
    @property
    def metadata(self): ...
    @metadata.setter
    def metadata(self, meta) -> None: ...
    @property
    def mapped_indices(self): ...
    def get_index_map(self, index): ...
    def __setitem__(self, key, value) -> None: ...
    def __getitem__(self, key): ...
    def __delitem__(self, key) -> None: ...
    def __len__(self) -> int: ...
    def insert(self, index, value) -> None: ...
    def get_axis(self, index): ...
    def get_data_shape(self): ...

class Cifti2Header(FileBasedHeader, xml.XmlSerializable):
    matrix: Incomplete
    version: Incomplete
    def __init__(
        self, matrix: Incomplete | None = None, version: str = "2.0"
    ) -> None: ...
    def __eq__(self, other): ...
    @classmethod
    def may_contain_header(klass, binaryblock): ...
    @property
    def number_of_mapped_indices(self): ...
    @property
    def mapped_indices(self): ...
    def get_index_map(self, index): ...
    def get_axis(self, index): ...
    @classmethod
    def from_axes(cls, axes): ...

class Cifti2Image(DataobjImage, SerializableImage):
    header_class = Cifti2Header
    header: Cifti2Header
    valid_exts: Incomplete
    files_types: Incomplete
    makeable: bool
    rw: bool
    def __init__(
        self,
        dataobj: Incomplete | None = None,
        header: Incomplete | None = None,
        nifti_header: Incomplete | None = None,
        extra: Incomplete | None = None,
        file_map: Incomplete | None = None,
        dtype: Incomplete | None = None,
    ) -> None: ...
    @property
    def nifti_header(self): ...
    @classmethod
    def from_file_map(
        klass, file_map, *, mmap: bool = True, keep_file_open: Incomplete | None = None
    ): ...
    @classmethod
    def from_image(klass, img): ...
    def to_file_map(
        self, file_map: Incomplete | None = None, dtype: Incomplete | None = None
    ) -> None: ...
    def update_headers(self) -> None: ...
    def get_data_dtype(self): ...
    def set_data_dtype(self, dtype) -> None: ...

load: Incomplete
save: Incomplete
