from _typeshed import Incomplete

from .casting import best_float as best_float
from .casting import floor_exact as floor_exact
from .casting import int_abs as int_abs
from .casting import shared_range as shared_range
from .casting import type_info as type_info
from .volumeutils import array_to_file as array_to_file
from .volumeutils import finite_range as finite_range

class WriterError(Exception): ...
class ScalingError(WriterError): ...

class ArrayWriter:
    def __init__(
        self, array, out_dtype: Incomplete | None = None, **kwargs
    ) -> None: ...
    def scaling_needed(self): ...
    @property
    def array(self): ...
    @property
    def out_dtype(self): ...
    @property
    def has_nan(self): ...
    def finite_range(self): ...
    def to_fileobj(self, fileobj, order: str = "F") -> None: ...

class SlopeArrayWriter(ArrayWriter):
    scaler_dtype: Incomplete
    def __init__(
        self,
        array,
        out_dtype: Incomplete | None = None,
        calc_scale: bool = True,
        scaler_dtype=...,
        **kwargs
    ) -> None: ...
    def scaling_needed(self): ...
    slope: float
    def reset(self) -> None: ...
    def calc_scale(self, force: bool = False) -> None: ...
    def to_fileobj(self, fileobj, order: str = "F") -> None: ...

class SlopeInterArrayWriter(SlopeArrayWriter):
    def __init__(
        self,
        array,
        out_dtype: Incomplete | None = None,
        calc_scale: bool = True,
        scaler_dtype=...,
        **kwargs
    ) -> None: ...
    inter: float
    def reset(self) -> None: ...
    def to_fileobj(self, fileobj, order: str = "F") -> None: ...

def get_slope_inter(writer): ...
def make_array_writer(
    data, out_type, has_slope: bool = True, has_intercept: bool = True, **kwargs
): ...
