import typing as ty

import numpy
import numpy.typing as npt
from _typeshed import Incomplete
from typing_extensions import Self

from . import openers as openers
from .fileslice import canonical_slicers as canonical_slicers
from .fileslice import fileslice as fileslice
from .volumeutils import apply_read_scaling as apply_read_scaling
from .volumeutils import array_from_file as array_from_file

KEEP_FILE_OPEN_DEFAULT: bool

class ArrayLike(ty.Protocol):
    shape: tuple[int, ...]
    @property
    def ndim(self) -> int: ...
    @ty.overload
    def __array__(
        self, dtype: None = ...
    ) -> numpyndarray[ty.Any, numpydtype[ty.Any]]: ...
    @ty.overload
    def __array__(self, dtype: _DType) -> numpyndarray[ty.Any, _DType]: ...
    def __getitem__(self, key) -> npt.NDArray: ...

class ArrayProxy(ArrayLike):
    file_like: Incomplete
    order: Incomplete
    def __init__(
        self,
        file_like,
        spec,
        *,
        mmap: bool = True,
        order: Incomplete | None = None,
        keep_file_open: Incomplete | None = None
    ) -> None: ...
    def copy(self) -> Self: ...
    def __del__(self) -> None: ...
    @property
    def shape(self): ...
    @property
    def ndim(self): ...
    @property
    def dtype(self): ...
    @property
    def offset(self): ...
    @property
    def slope(self): ...
    @property
    def inter(self): ...
    @property
    def is_proxy(self): ...
    def get_unscaled(self): ...
    def __array__(self, dtype: Incomplete | None = None): ...
    def __getitem__(self, slicer): ...
    def reshape(self, shape): ...

def is_proxy(obj): ...
def reshape_dataobj(obj, shape): ...
def get_obj_dtype(obj): ...
