from typing import Any

class _DummyAxis:
    __name__: str
    dataLim: Any
    viewLim: Any
    def __init__(self, minpos: int = ...) -> None: ...
    def get_view_interval(self): ...
    def set_view_interval(self, vmin, vmax) -> None: ...
    def get_minpos(self): ...
    def get_data_interval(self): ...
    def set_data_interval(self, vmin, vmax) -> None: ...
    def get_tick_space(self): ...

class TickHelper:
    axis: Any
    def set_axis(self, axis) -> None: ...
    def create_dummy_axis(self, **kwargs) -> None: ...
    def set_view_interval(self, vmin, vmax) -> None: ...
    def set_data_interval(self, vmin, vmax) -> None: ...
    def set_bounds(self, vmin, vmax) -> None: ...

class Formatter(TickHelper):
    locs: Any
    def __call__(self, x, pos: Any | None = ...) -> None: ...
    def format_ticks(self, values): ...
    def format_data(self, value): ...
    def format_data_short(self, value): ...
    def get_offset(self): ...
    def set_locs(self, locs) -> None: ...
    @staticmethod
    def fix_minus(s): ...

class NullFormatter(Formatter):
    def __call__(self, x, pos: Any | None = ...): ...

class FixedFormatter(Formatter):
    seq: Any
    offset_string: str
    def __init__(self, seq) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...
    def get_offset(self): ...
    def set_offset_string(self, ofs) -> None: ...

class FuncFormatter(Formatter):
    func: Any
    offset_string: str
    def __init__(self, func) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...
    def get_offset(self): ...
    def set_offset_string(self, ofs) -> None: ...

class FormatStrFormatter(Formatter):
    fmt: Any
    def __init__(self, fmt) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...

class StrMethodFormatter(Formatter):
    fmt: Any
    def __init__(self, fmt) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...

class ScalarFormatter(Formatter):
    orderOfMagnitude: int
    format: str
    def __init__(self, useOffset: Any | None = ..., useMathText: Any | None = ..., useLocale: Any | None = ...) -> None: ...
    def get_useOffset(self): ...
    offset: int
    def set_useOffset(self, val) -> None: ...
    useOffset: Any
    def get_useLocale(self): ...
    def set_useLocale(self, val) -> None: ...
    useLocale: Any
    def get_useMathText(self): ...
    def set_useMathText(self, val) -> None: ...
    useMathText: Any
    def __call__(self, x, pos: Any | None = ...): ...
    def set_scientific(self, b) -> None: ...
    def set_powerlimits(self, lims) -> None: ...
    def format_data_short(self, value): ...
    def format_data(self, value): ...
    def get_offset(self): ...
    locs: Any
    def set_locs(self, locs) -> None: ...

class LogFormatter(Formatter):
    labelOnlyBase: Any
    minor_thresholds: Any
    def __init__(self, base: float = ..., labelOnlyBase: bool = ..., minor_thresholds: Any | None = ..., linthresh: Any | None = ...) -> None: ...
    def base(self, base) -> None: ...
    def label_minor(self, labelOnlyBase) -> None: ...
    def set_locs(self, locs: Any | None = ...) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...
    def format_data(self, value): ...
    def format_data_short(self, value): ...

class LogFormatterExponent(LogFormatter): ...

class LogFormatterMathtext(LogFormatter):
    def __call__(self, x, pos: Any | None = ...): ...

class LogFormatterSciNotation(LogFormatterMathtext): ...

class LogitFormatter(Formatter):
    def __init__(self, *, use_overline: bool = ..., one_half: str = ..., minor: bool = ..., minor_threshold: int = ..., minor_number: int = ...) -> None: ...
    def use_overline(self, use_overline) -> None: ...
    def set_one_half(self, one_half) -> None: ...
    def set_minor_threshold(self, minor_threshold) -> None: ...
    def set_minor_number(self, minor_number) -> None: ...
    locs: Any
    def set_locs(self, locs): ...
    def __call__(self, x, pos: Any | None = ...): ...
    def format_data_short(self, value): ...

class EngFormatter(Formatter):
    ENG_PREFIXES: Any
    unit: Any
    places: Any
    sep: Any
    def __init__(self, unit: str = ..., places: Any | None = ..., sep: str = ..., *, usetex: Any | None = ..., useMathText: Any | None = ...) -> None: ...
    def get_usetex(self): ...
    def set_usetex(self, val) -> None: ...
    usetex: Any
    def get_useMathText(self): ...
    def set_useMathText(self, val) -> None: ...
    useMathText: Any
    def __call__(self, x, pos: Any | None = ...): ...
    def format_eng(self, num): ...

class PercentFormatter(Formatter):
    xmax: Any
    decimals: Any
    def __init__(self, xmax: int = ..., decimals: Any | None = ..., symbol: str = ..., is_latex: bool = ...) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...
    def format_pct(self, x, display_range): ...
    def convert_to_pct(self, x): ...
    @property
    def symbol(self): ...
    @symbol.setter
    def symbol(self, symbol) -> None: ...

class Locator(TickHelper):
    MAXTICKS: int
    def tick_values(self, vmin, vmax) -> None: ...
    def set_params(self, **kwargs) -> None: ...
    def __call__(self) -> None: ...
    def raise_if_exceeds(self, locs): ...
    def nonsingular(self, v0, v1): ...
    def view_limits(self, vmin, vmax): ...

class IndexLocator(Locator):
    offset: Any
    def __init__(self, base, offset) -> None: ...
    def set_params(self, base: Any | None = ..., offset: Any | None = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...

class FixedLocator(Locator):
    locs: Any
    nbins: Any
    def __init__(self, locs, nbins: Any | None = ...) -> None: ...
    def set_params(self, nbins: Any | None = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...

class NullLocator(Locator):
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...

class LinearLocator(Locator):
    presets: Any
    def __init__(self, numticks: Any | None = ..., presets: Any | None = ...) -> None: ...
    @property
    def numticks(self): ...
    @numticks.setter
    def numticks(self, numticks) -> None: ...
    def set_params(self, numticks: Any | None = ..., presets: Any | None = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def view_limits(self, vmin, vmax): ...

class MultipleLocator(Locator):
    def __init__(self, base: float = ...) -> None: ...
    def set_params(self, base) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def view_limits(self, dmin, dmax): ...

class _Edge_integer:
    step: Any
    def __init__(self, step, offset) -> None: ...
    def closeto(self, ms, edge): ...
    def le(self, x): ...
    def ge(self, x): ...

class MaxNLocator(Locator):
    default_params: Any
    def __init__(self, nbins: Any | None = ..., **kwargs) -> None: ...
    def set_params(self, **kwargs) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def view_limits(self, dmin, dmax): ...

class LogLocator(Locator):
    numdecs: Any
    numticks: Any
    def __init__(self, base: float = ..., subs=..., numdecs: int = ..., numticks: Any | None = ...) -> None: ...
    def set_params(self, base: Any | None = ..., subs: Any | None = ..., numdecs: Any | None = ..., numticks: Any | None = ...) -> None: ...
    def base(self, base) -> None: ...
    def subs(self, subs) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def view_limits(self, vmin, vmax): ...
    def nonsingular(self, vmin, vmax): ...

class SymmetricalLogLocator(Locator):
    numticks: int
    def __init__(self, transform: Any | None = ..., subs: Any | None = ..., linthresh: Any | None = ..., base: Any | None = ...) -> None: ...
    def set_params(self, subs: Any | None = ..., numticks: Any | None = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def view_limits(self, vmin, vmax): ...

class LogitLocator(MaxNLocator):
    def __init__(self, minor: bool = ..., *, nbins: str = ...) -> None: ...
    def set_params(self, minor: Any | None = ..., **kwargs) -> None: ...
    @property
    def minor(self): ...
    @minor.setter
    def minor(self, value) -> None: ...
    def tick_values(self, vmin, vmax): ...
    def nonsingular(self, vmin, vmax): ...

class AutoLocator(MaxNLocator):
    def __init__(self) -> None: ...

class AutoMinorLocator(Locator):
    ndivs: Any
    def __init__(self, n: Any | None = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax) -> None: ...
