from . import docstring as docstring
from .artist import Artist as Artist, allow_rasterization as allow_rasterization
from .patches import Rectangle as Rectangle
from .path import Path as Path
from .text import Text as Text
from .transforms import Bbox as Bbox
from typing import Any

class Cell(Rectangle):
    PAD: float
    def __init__(self, xy, width, height, edgecolor: str = ..., facecolor: str = ..., fill: bool = ..., text: str = ..., loc: Any | None = ..., fontproperties: Any | None = ..., *, visible_edges: str = ...) -> None: ...
    stale: bool
    def set_transform(self, trans) -> None: ...
    def set_figure(self, fig) -> None: ...
    def get_text(self): ...
    def set_fontsize(self, size) -> None: ...
    def get_fontsize(self): ...
    def auto_set_font_size(self, renderer): ...
    def draw(self, renderer) -> None: ...
    def get_text_bounds(self, renderer): ...
    def get_required_width(self, renderer): ...
    def set_text_props(self, **kwargs) -> None: ...
    @property
    def visible_edges(self): ...
    @visible_edges.setter
    def visible_edges(self, value) -> None: ...
    def get_path(self): ...
CustomCell = Cell

class Table(Artist):
    codes: Any
    FONTSIZE: int
    AXESPAD: float
    def __init__(self, ax, loc: Any | None = ..., bbox: Any | None = ..., **kwargs) -> None: ...
    def add_cell(self, row, col, *args, **kwargs): ...
    stale: bool
    def __setitem__(self, position, cell) -> None: ...
    def __getitem__(self, position): ...
    @property
    def edges(self): ...
    @edges.setter
    def edges(self, value) -> None: ...
    def draw(self, renderer) -> None: ...
    def contains(self, mouseevent): ...
    def get_children(self): ...
    def get_window_extent(self, renderer): ...
    def auto_set_column_width(self, col) -> None: ...
    def auto_set_font_size(self, value: bool = ...) -> None: ...
    def scale(self, xscale, yscale) -> None: ...
    def set_fontsize(self, size) -> None: ...
    def get_celld(self): ...

def table(ax, cellText: Any | None = ..., cellColours: Any | None = ..., cellLoc: str = ..., colWidths: Any | None = ..., rowLabels: Any | None = ..., rowColours: Any | None = ..., rowLoc: str = ..., colLabels: Any | None = ..., colColours: Any | None = ..., colLoc: str = ..., loc: str = ..., bbox: Any | None = ..., edges: str = ..., **kwargs): ...
