from matplotlib.backend_bases import RendererBase as RendererBase
from matplotlib.path import Path as Path
from typing import Any

class AbstractPathEffect:
    def __init__(self, offset=...) -> None: ...
    def draw_path(self, renderer, gc, tpath, affine, rgbFace: Any | None = ...): ...

class PathEffectRenderer(RendererBase):
    def __init__(self, path_effects, renderer) -> None: ...
    def copy_with_path_effect(self, path_effects): ...
    def draw_path(self, gc, tpath, affine, rgbFace: Any | None = ...) -> None: ...
    def draw_markers(self, gc, marker_path, marker_trans, path, *args, **kwargs): ...
    def draw_path_collection(self, gc, master_transform, paths, *args, **kwargs): ...
    def __getattribute__(self, name): ...

class Normal(AbstractPathEffect): ...

class Stroke(AbstractPathEffect):
    def __init__(self, offset=..., **kwargs) -> None: ...
    def draw_path(self, renderer, gc, tpath, affine, rgbFace) -> None: ...

withStroke: Any

class SimplePatchShadow(AbstractPathEffect):
    def __init__(self, offset=..., shadow_rgbFace: Any | None = ..., alpha: Any | None = ..., rho: float = ..., **kwargs) -> None: ...
    def draw_path(self, renderer, gc, tpath, affine, rgbFace) -> None: ...

withSimplePatchShadow: Any

class SimpleLineShadow(AbstractPathEffect):
    def __init__(self, offset=..., shadow_color: str = ..., alpha: float = ..., rho: float = ..., **kwargs) -> None: ...
    def draw_path(self, renderer, gc, tpath, affine, rgbFace) -> None: ...

class PathPatchEffect(AbstractPathEffect):
    patch: Any
    def __init__(self, offset=..., **kwargs) -> None: ...
    def draw_path(self, renderer, gc, tpath, affine, rgbFace) -> None: ...

class TickedStroke(AbstractPathEffect):
    def __init__(self, offset=..., spacing: float = ..., angle: float = ..., length=..., **kwargs) -> None: ...
    def draw_path(self, renderer, gc, tpath, affine, rgbFace) -> None: ...

withTickedStroke: Any
