from . import artist as artist, cbook as cbook, colors as colors, docstring as docstring, transforms as transforms
from ._enums import CapStyle as CapStyle, JoinStyle as JoinStyle
from .bezier import NonIntersectingPathException as NonIntersectingPathException, get_cos_sin as get_cos_sin, get_intersection as get_intersection, get_parallels as get_parallels, inside_circle as inside_circle, make_wedged_bezier2 as make_wedged_bezier2, split_bezier_intersecting_with_closedpath as split_bezier_intersecting_with_closedpath, split_path_inout as split_path_inout
from .path import Path as Path
from typing import Any

class Patch(artist.Artist):
    zorder: int
    def validCap(cls): ...
    def validJoin(cls): ...
    def __init__(self, edgecolor: Any | None = ..., facecolor: Any | None = ..., color: Any | None = ..., linewidth: Any | None = ..., linestyle: Any | None = ..., antialiased: Any | None = ..., hatch: Any | None = ..., fill: bool = ..., capstyle: Any | None = ..., joinstyle: Any | None = ..., **kwargs) -> None: ...
    def get_verts(self): ...
    def contains(self, mouseevent, radius: Any | None = ...): ...
    def contains_point(self, point, radius: Any | None = ...): ...
    def contains_points(self, points, radius: Any | None = ...): ...
    def update_from(self, other) -> None: ...
    def get_extents(self): ...
    def get_transform(self): ...
    def get_data_transform(self): ...
    def get_patch_transform(self): ...
    def get_antialiased(self): ...
    def get_edgecolor(self): ...
    def get_facecolor(self): ...
    def get_linewidth(self): ...
    def get_linestyle(self): ...
    stale: bool
    def set_antialiased(self, aa) -> None: ...
    def set_edgecolor(self, color) -> None: ...
    def set_facecolor(self, color) -> None: ...
    def set_color(self, c) -> None: ...
    def set_alpha(self, alpha) -> None: ...
    def set_linewidth(self, w) -> None: ...
    def set_linestyle(self, ls) -> None: ...
    def set_fill(self, b) -> None: ...
    def get_fill(self): ...
    fill: Any
    def set_capstyle(self, s) -> None: ...
    def get_capstyle(self): ...
    def set_joinstyle(self, s) -> None: ...
    def get_joinstyle(self): ...
    def set_hatch(self, hatch) -> None: ...
    def get_hatch(self): ...
    def draw(self, renderer) -> None: ...
    def get_path(self) -> None: ...
    def get_window_extent(self, renderer: Any | None = ...): ...

class Shadow(Patch):
    patch: Any
    def __init__(self, patch, ox, oy, **kwargs) -> None: ...
    def get_path(self): ...
    def get_patch_transform(self): ...
    def draw(self, renderer) -> None: ...

class Rectangle(Patch):
    angle: Any
    def __init__(self, xy, width, height, angle: float = ..., **kwargs) -> None: ...
    def get_path(self): ...
    def get_patch_transform(self): ...
    def get_x(self): ...
    def get_y(self): ...
    def get_xy(self): ...
    def get_width(self): ...
    def get_height(self): ...
    def get_angle(self): ...
    stale: bool
    def set_x(self, x) -> None: ...
    def set_y(self, y) -> None: ...
    def set_angle(self, angle) -> None: ...
    def set_xy(self, xy) -> None: ...
    def set_width(self, w) -> None: ...
    def set_height(self, h) -> None: ...
    def set_bounds(self, *args) -> None: ...
    def get_bbox(self): ...
    xy: Any

class RegularPolygon(Patch):
    xy: Any
    numvertices: Any
    orientation: Any
    radius: Any
    def __init__(self, xy, numVertices, radius: int = ..., orientation: int = ..., **kwargs) -> None: ...
    def get_path(self): ...
    def get_patch_transform(self): ...

class PathPatch(Patch):
    def __init__(self, path, **kwargs) -> None: ...
    def get_path(self): ...
    def set_path(self, path) -> None: ...

class StepPatch(PathPatch):
    orientation: Any
    def __init__(self, values, edges, *, orientation: str = ..., baseline: int = ..., **kwargs) -> None: ...
    def get_data(self): ...
    stale: bool
    def set_data(self, values: Any | None = ..., edges: Any | None = ..., baseline: Any | None = ...) -> None: ...

class Polygon(Patch):
    def __init__(self, xy, closed: bool = ..., **kwargs) -> None: ...
    def get_path(self): ...
    def get_closed(self): ...
    stale: bool
    def set_closed(self, closed) -> None: ...
    def get_xy(self): ...
    def set_xy(self, xy) -> None: ...
    xy: Any

class Wedge(Patch):
    center: Any
    def __init__(self, center, r, theta1, theta2, width: Any | None = ..., **kwargs) -> None: ...
    stale: bool
    def set_center(self, center) -> None: ...
    r: Any
    def set_radius(self, radius) -> None: ...
    theta1: Any
    def set_theta1(self, theta1) -> None: ...
    theta2: Any
    def set_theta2(self, theta2) -> None: ...
    width: Any
    def set_width(self, width) -> None: ...
    def get_path(self): ...

class Arrow(Patch):
    def __init__(self, x, y, dx, dy, width: float = ..., **kwargs) -> None: ...
    def get_path(self): ...
    def get_patch_transform(self): ...

class FancyArrow(Polygon):
    def __init__(self, x, y, dx, dy, width: float = ..., length_includes_head: bool = ..., head_width: Any | None = ..., head_length: Any | None = ..., shape: str = ..., overhang: int = ..., head_starts_at_zero: bool = ..., **kwargs) -> None: ...
    def set_data(self, *, x: Any | None = ..., y: Any | None = ..., dx: Any | None = ..., dy: Any | None = ..., width: Any | None = ..., head_width: Any | None = ..., head_length: Any | None = ...) -> None: ...

class CirclePolygon(RegularPolygon):
    def __init__(self, xy, radius: int = ..., resolution: int = ..., **kwargs) -> None: ...

class Ellipse(Patch):
    def __init__(self, xy, width, height, angle: int = ..., **kwargs) -> None: ...
    def get_path(self): ...
    def get_patch_transform(self): ...
    stale: bool
    def set_center(self, xy) -> None: ...
    def get_center(self): ...
    center: Any
    def set_width(self, width) -> None: ...
    def get_width(self): ...
    width: Any
    def set_height(self, height) -> None: ...
    def get_height(self): ...
    height: Any
    def set_angle(self, angle) -> None: ...
    def get_angle(self): ...
    angle: Any

class Annulus(Patch):
    center: Any
    width: Any
    angle: Any
    def __init__(self, xy, r, width, angle: float = ..., **kwargs) -> None: ...
    stale: bool
    def set_center(self, xy) -> None: ...
    def get_center(self): ...
    def set_width(self, width) -> None: ...
    def get_width(self): ...
    def set_angle(self, angle) -> None: ...
    def get_angle(self): ...
    a: Any
    def set_semimajor(self, a) -> None: ...
    b: Any
    def set_semiminor(self, b) -> None: ...
    def set_radii(self, r) -> None: ...
    def get_radii(self): ...
    radii: Any
    def get_path(self): ...

class Circle(Ellipse):
    radius: Any
    def __init__(self, xy, radius: int = ..., **kwargs) -> None: ...
    width: Any
    stale: bool
    def set_radius(self, radius) -> None: ...
    def get_radius(self): ...

class Arc(Ellipse):
    theta1: Any
    theta2: Any
    def __init__(self, xy, width, height, angle: float = ..., theta1: float = ..., theta2: float = ..., **kwargs) -> None: ...
    def draw(self, renderer): ...

def bbox_artist(artist, renderer, props: Any | None = ..., fill: bool = ...) -> None: ...
def draw_bbox(bbox, renderer, color: str = ..., trans: Any | None = ...) -> None: ...

class _Style:
    def __new__(cls, stylename, **kw): ...
    @classmethod
    def get_styles(cls): ...
    @classmethod
    def pprint_styles(cls): ...
    @classmethod
    def register(cls, name, style) -> None: ...

class BoxStyle(_Style):
    class _Base:
        def transmute(self, x0, y0, width, height, mutation_size): ...
        def __init_subclass__(cls): ...
        def __call__(self, x0, y0, width, height, mutation_size) -> None: ...
    class Square(_Base):
        pad: Any
        def __init__(self, pad: float = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class Circle(_Base):
        pad: Any
        def __init__(self, pad: float = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class LArrow(_Base):
        pad: Any
        def __init__(self, pad: float = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class RArrow(LArrow):
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class DArrow(_Base):
        pad: Any
        def __init__(self, pad: float = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class Round(_Base):
        pad: Any
        rounding_size: Any
        def __init__(self, pad: float = ..., rounding_size: Any | None = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class Round4(_Base):
        pad: Any
        rounding_size: Any
        def __init__(self, pad: float = ..., rounding_size: Any | None = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class Sawtooth(_Base):
        pad: Any
        tooth_size: Any
        def __init__(self, pad: float = ..., tooth_size: Any | None = ...) -> None: ...
        def __call__(self, x0, y0, width, height, mutation_size): ...
    class Roundtooth(Sawtooth):
        def __call__(self, x0, y0, width, height, mutation_size): ...

class ConnectionStyle(_Style):
    class _Base:
        class SimpleEvent:
            def __init__(self, xy) -> None: ...
        def __call__(self, posA, posB, shrinkA: float = ..., shrinkB: float = ..., patchA: Any | None = ..., patchB: Any | None = ...): ...
    class Arc3(_Base):
        rad: Any
        def __init__(self, rad: float = ...) -> None: ...
        def connect(self, posA, posB): ...
    class Angle3(_Base):
        angleA: Any
        angleB: Any
        def __init__(self, angleA: int = ..., angleB: int = ...) -> None: ...
        def connect(self, posA, posB): ...
    class Angle(_Base):
        angleA: Any
        angleB: Any
        rad: Any
        def __init__(self, angleA: int = ..., angleB: int = ..., rad: float = ...) -> None: ...
        def connect(self, posA, posB): ...
    class Arc(_Base):
        angleA: Any
        angleB: Any
        armA: Any
        armB: Any
        rad: Any
        def __init__(self, angleA: int = ..., angleB: int = ..., armA: Any | None = ..., armB: Any | None = ..., rad: float = ...) -> None: ...
        def connect(self, posA, posB): ...
    class Bar(_Base):
        armA: Any
        armB: Any
        fraction: Any
        angle: Any
        def __init__(self, armA: float = ..., armB: float = ..., fraction: float = ..., angle: Any | None = ...) -> None: ...
        def connect(self, posA, posB): ...

class ArrowStyle(_Style):
    class _Base:
        @staticmethod
        def ensure_quadratic_bezier(path): ...
        def transmute(self, path, mutation_size, linewidth) -> None: ...
        def __call__(self, path, mutation_size, linewidth, aspect_ratio: float = ...): ...
    class _Curve(_Base):
        beginarrow: Any
        endarrow: Any
        arrow: str
        fillbegin: bool
        fillend: bool
        def __init__(self, head_length: float = ..., head_width: float = ..., widthA: float = ..., widthB: float = ..., lengthA: float = ..., lengthB: float = ..., angleA: int = ..., angleB: int = ..., scaleA: Any | None = ..., scaleB: Any | None = ...) -> None: ...
        def transmute(self, path, mutation_size, linewidth): ...
    class Curve(_Curve):
        def __init__(self) -> None: ...
    class CurveA(_Curve):
        arrow: str
    class CurveB(_Curve):
        arrow: str
    class CurveAB(_Curve):
        arrow: str
    class CurveFilledA(_Curve):
        arrow: str
    class CurveFilledB(_Curve):
        arrow: str
    class CurveFilledAB(_Curve):
        arrow: str
    class BracketA(_Curve):
        arrow: str
        def __init__(self, widthA: float = ..., lengthA: float = ..., angleA: int = ...) -> None: ...
    class BracketB(_Curve):
        arrow: str
        def __init__(self, widthB: float = ..., lengthB: float = ..., angleB: int = ...) -> None: ...
    class BracketAB(_Curve):
        arrow: str
        def __init__(self, widthA: float = ..., lengthA: float = ..., angleA: int = ..., widthB: float = ..., lengthB: float = ..., angleB: int = ...) -> None: ...
    class BarAB(_Curve):
        arrow: str
        def __init__(self, widthA: float = ..., angleA: int = ..., widthB: float = ..., angleB: int = ...) -> None: ...
    class BracketCurve(_Curve):
        arrow: str
        def __init__(self, widthA: float = ..., lengthA: float = ..., angleA: Any | None = ...) -> None: ...
    class CurveBracket(_Curve):
        arrow: str
        def __init__(self, widthB: float = ..., lengthB: float = ..., angleB: Any | None = ...) -> None: ...
    class Simple(_Base):
        def __init__(self, head_length: float = ..., head_width: float = ..., tail_width: float = ...) -> None: ...
        def transmute(self, path, mutation_size, linewidth): ...
    class Fancy(_Base):
        def __init__(self, head_length: float = ..., head_width: float = ..., tail_width: float = ...) -> None: ...
        def transmute(self, path, mutation_size, linewidth): ...
    class Wedge(_Base):
        tail_width: Any
        shrink_factor: Any
        def __init__(self, tail_width: float = ..., shrink_factor: float = ...) -> None: ...
        def transmute(self, path, mutation_size, linewidth): ...

class FancyBboxPatch(Patch):
    stale: bool
    def __init__(self, xy, width, height, boxstyle: str = ..., bbox_transmuter: Any | None = ..., mutation_scale: int = ..., mutation_aspect: int = ..., **kwargs) -> None: ...
    def set_boxstyle(self, boxstyle: Any | None = ..., **kwargs): ...
    def set_mutation_scale(self, scale) -> None: ...
    def get_mutation_scale(self): ...
    def set_mutation_aspect(self, aspect) -> None: ...
    def get_mutation_aspect(self): ...
    def get_boxstyle(self): ...
    def get_path(self): ...
    def get_x(self): ...
    def get_y(self): ...
    def get_width(self): ...
    def get_height(self): ...
    def set_x(self, x) -> None: ...
    def set_y(self, y) -> None: ...
    def set_width(self, w) -> None: ...
    def set_height(self, h) -> None: ...
    def set_bounds(self, *args) -> None: ...
    def get_bbox(self): ...

class FancyArrowPatch(Patch):
    patchA: Any
    patchB: Any
    shrinkA: Any
    shrinkB: Any
    def __init__(self, posA: Any | None = ..., posB: Any | None = ..., path: Any | None = ..., arrowstyle: str = ..., connectionstyle: str = ..., patchA: Any | None = ..., patchB: Any | None = ..., shrinkA: int = ..., shrinkB: int = ..., mutation_scale: int = ..., mutation_aspect: int = ..., dpi_cor: int = ..., **kwargs) -> None: ...
    stale: bool
    def set_dpi_cor(self, dpi_cor) -> None: ...
    def get_dpi_cor(self): ...
    def set_positions(self, posA, posB) -> None: ...
    def set_patchA(self, patchA) -> None: ...
    def set_patchB(self, patchB) -> None: ...
    def set_connectionstyle(self, connectionstyle, **kw): ...
    def get_connectionstyle(self): ...
    def set_arrowstyle(self, arrowstyle: Any | None = ..., **kw): ...
    def get_arrowstyle(self): ...
    def set_mutation_scale(self, scale) -> None: ...
    def get_mutation_scale(self): ...
    def set_mutation_aspect(self, aspect) -> None: ...
    def get_mutation_aspect(self): ...
    def get_path(self): ...
    get_path_in_displaycoord: Any
    def draw(self, renderer) -> None: ...

class ConnectionPatch(FancyArrowPatch):
    xy1: Any
    xy2: Any
    coords1: Any
    coords2: Any
    axesA: Any
    axesB: Any
    def __init__(self, xyA, xyB, coordsA, coordsB: Any | None = ..., axesA: Any | None = ..., axesB: Any | None = ..., arrowstyle: str = ..., connectionstyle: str = ..., patchA: Any | None = ..., patchB: Any | None = ..., shrinkA: float = ..., shrinkB: float = ..., mutation_scale: float = ..., mutation_aspect: Any | None = ..., clip_on: bool = ..., dpi_cor: float = ..., **kwargs) -> None: ...
    stale: bool
    def set_annotation_clip(self, b) -> None: ...
    def get_annotation_clip(self): ...
    def draw(self, renderer) -> None: ...
