import matplotlib.artist as martist
import matplotlib.text as mtext
from matplotlib import docstring as docstring, rcParams as rcParams
from matplotlib.font_manager import FontProperties as FontProperties
from matplotlib.image import BboxImage as BboxImage
from matplotlib.patches import FancyArrowPatch as FancyArrowPatch, FancyBboxPatch as FancyBboxPatch
from matplotlib.transforms import Bbox as Bbox, BboxBase as BboxBase, TransformedBbox as TransformedBbox
from typing import Any

DEBUG: bool

def bbox_artist(*args, **kwargs) -> None: ...

class OffsetBox(martist.Artist):
    def __init__(self, *args, **kwargs) -> None: ...
    def set_figure(self, fig) -> None: ...
    def axes(self, ax) -> None: ...
    def contains(self, mouseevent): ...
    stale: bool
    def set_offset(self, xy) -> None: ...
    def get_offset(self, width, height, xdescent, ydescent, renderer): ...
    width: Any
    def set_width(self, width) -> None: ...
    height: Any
    def set_height(self, height) -> None: ...
    def get_visible_children(self): ...
    def get_children(self): ...
    def get_extent_offsets(self, renderer) -> None: ...
    def get_extent(self, renderer): ...
    def get_window_extent(self, renderer): ...
    def draw(self, renderer) -> None: ...

class PackerBase(OffsetBox):
    height: Any
    width: Any
    sep: Any
    pad: Any
    mode: Any
    align: Any
    def __init__(self, pad: Any | None = ..., sep: Any | None = ..., width: Any | None = ..., height: Any | None = ..., align: str = ..., mode: str = ..., children: Any | None = ...) -> None: ...

class VPacker(PackerBase):
    def get_extent_offsets(self, renderer): ...

class HPacker(PackerBase):
    def get_extent_offsets(self, renderer): ...

class PaddedBox(OffsetBox):
    pad: Any
    patch: Any
    def __init__(self, child, pad: Any | None = ..., draw_frame: bool = ..., patch_attrs: Any | None = ...) -> None: ...
    def get_extent_offsets(self, renderer): ...
    stale: bool
    def draw(self, renderer) -> None: ...
    def update_frame(self, bbox, fontsize: Any | None = ...) -> None: ...
    def draw_frame(self, renderer) -> None: ...

class DrawingArea(OffsetBox):
    width: Any
    height: Any
    xdescent: Any
    ydescent: Any
    offset_transform: Any
    dpi_transform: Any
    def __init__(self, width, height, xdescent: float = ..., ydescent: float = ..., clip: bool = ...) -> None: ...
    @property
    def clip_children(self): ...
    stale: bool
    @clip_children.setter
    def clip_children(self, val) -> None: ...
    def get_transform(self): ...
    def set_transform(self, t) -> None: ...
    def set_offset(self, xy) -> None: ...
    def get_offset(self): ...
    def get_window_extent(self, renderer): ...
    def get_extent(self, renderer): ...
    def add_artist(self, a) -> None: ...
    def draw(self, renderer) -> None: ...

class TextArea(OffsetBox):
    offset_transform: Any
    def __init__(self, s, textprops: Any | None = ..., multilinebaseline: bool = ..., minimumdescent: bool = ...) -> None: ...
    stale: bool
    def set_text(self, s) -> None: ...
    def get_text(self): ...
    def set_multilinebaseline(self, t) -> None: ...
    def get_multilinebaseline(self): ...
    def set_minimumdescent(self, t) -> None: ...
    def get_minimumdescent(self): ...
    def set_transform(self, t) -> None: ...
    def set_offset(self, xy) -> None: ...
    def get_offset(self): ...
    def get_window_extent(self, renderer): ...
    def get_extent(self, renderer): ...
    def draw(self, renderer) -> None: ...

class AuxTransformBox(OffsetBox):
    aux_transform: Any
    offset_transform: Any
    ref_offset_transform: Any
    def __init__(self, aux_transform) -> None: ...
    stale: bool
    def add_artist(self, a) -> None: ...
    def get_transform(self): ...
    def set_transform(self, t) -> None: ...
    def set_offset(self, xy) -> None: ...
    def get_offset(self): ...
    def get_window_extent(self, renderer): ...
    def get_extent(self, renderer): ...
    def draw(self, renderer) -> None: ...

class AnchoredOffsetbox(OffsetBox):
    zorder: int
    codes: Any
    loc: Any
    borderpad: Any
    pad: Any
    prop: Any
    patch: Any
    def __init__(self, loc, pad: float = ..., borderpad: float = ..., child: Any | None = ..., prop: Any | None = ..., frameon: bool = ..., bbox_to_anchor: Any | None = ..., bbox_transform: Any | None = ..., **kwargs) -> None: ...
    stale: bool
    def set_child(self, child) -> None: ...
    def get_child(self): ...
    def get_children(self): ...
    def get_extent(self, renderer): ...
    def get_bbox_to_anchor(self): ...
    def set_bbox_to_anchor(self, bbox, transform: Any | None = ...) -> None: ...
    def get_window_extent(self, renderer): ...
    def update_frame(self, bbox, fontsize: Any | None = ...) -> None: ...
    def draw(self, renderer) -> None: ...

class AnchoredText(AnchoredOffsetbox):
    txt: Any
    def __init__(self, s, loc, pad: float = ..., borderpad: float = ..., prop: Any | None = ..., **kwargs) -> None: ...

class OffsetImage(OffsetBox):
    image: Any
    def __init__(self, arr, zoom: int = ..., cmap: Any | None = ..., norm: Any | None = ..., interpolation: Any | None = ..., origin: Any | None = ..., filternorm: bool = ..., filterrad: float = ..., resample: bool = ..., dpi_cor: bool = ..., **kwargs) -> None: ...
    stale: bool
    def set_data(self, arr) -> None: ...
    def get_data(self): ...
    def set_zoom(self, zoom) -> None: ...
    def get_zoom(self): ...
    def get_offset(self): ...
    def get_children(self): ...
    def get_window_extent(self, renderer): ...
    def get_extent(self, renderer): ...
    def draw(self, renderer) -> None: ...

class AnnotationBbox(martist.Artist, mtext._AnnotationBase):
    zorder: int
    offsetbox: Any
    arrowprops: Any
    xybox: Any
    boxcoords: Any
    arrow_patch: Any
    patch: Any
    def __init__(self, offsetbox, xy, xybox: Any | None = ..., xycoords: str = ..., boxcoords: Any | None = ..., frameon: bool = ..., pad: float = ..., annotation_clip: Any | None = ..., box_alignment=..., bboxprops: Any | None = ..., arrowprops: Any | None = ..., fontsize: Any | None = ..., **kwargs) -> None: ...
    @property
    def xyann(self): ...
    stale: bool
    @xyann.setter
    def xyann(self, xyann) -> None: ...
    @property
    def anncoords(self): ...
    @anncoords.setter
    def anncoords(self, coords) -> None: ...
    def contains(self, mouseevent): ...
    def get_children(self): ...
    def set_figure(self, fig) -> None: ...
    prop: Any
    def set_fontsize(self, s: Any | None = ...) -> None: ...
    def get_fontsize(self): ...
    def get_window_extent(self, renderer): ...
    def get_tightbbox(self, renderer): ...
    def update_positions(self, renderer) -> None: ...
    def draw(self, renderer) -> None: ...

class DraggableBase:
    ref_artist: Any
    got_artist: bool
    canvas: Any
    cids: Any
    def __init__(self, ref_artist, use_blit: bool = ...) -> None: ...
    def on_motion(self, evt) -> None: ...
    mouse_x: Any
    mouse_y: Any
    background: Any
    def on_pick(self, evt) -> None: ...
    def on_release(self, event) -> None: ...
    def disconnect(self) -> None: ...
    def save_offset(self) -> None: ...
    def update_offset(self, dx, dy) -> None: ...
    def finalize_offset(self) -> None: ...

class DraggableOffsetBox(DraggableBase):
    offsetbox: Any
    def __init__(self, ref_artist, offsetbox, use_blit: bool = ...) -> None: ...
    def save_offset(self) -> None: ...
    def update_offset(self, dx, dy) -> None: ...
    def get_loc_in_canvas(self): ...

class DraggableAnnotation(DraggableBase):
    annotation: Any
    def __init__(self, annotation, use_blit: bool = ...) -> None: ...
    def save_offset(self) -> None: ...
    def update_offset(self, dx, dy) -> None: ...
