from matplotlib import rcParams as rcParams
from matplotlib.font_manager import FontProperties as FontProperties
from matplotlib.ft2font import FT2Image as FT2Image, LOAD_NO_HINTING as LOAD_NO_HINTING
from typing import Any, NamedTuple

class __getattr__: ...

get_unicode_index: Any

class MathtextBackend:
    width: int
    height: int
    depth: int
    def __init__(self) -> None: ...
    def set_canvas_size(self, w, h, d) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box) -> None: ...
    def get_hinting_type(self): ...

class MathtextBackendAgg(MathtextBackend):
    ox: int
    oy: int
    image: Any
    mode: str
    bbox: Any
    def __init__(self) -> None: ...
    def set_canvas_size(self, w, h, d) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box, used_characters): ...
    def get_hinting_type(self): ...

class MathtextBackendBitmap(MathtextBackendAgg):
    def get_results(self, box, used_characters): ...

class MathtextBackendPs(MathtextBackend):

    class _PSResult(NamedTuple):
        width: Any
        height: Any
        depth: Any
        pswriter: Any
        used_characters: Any
    pswriter: Any
    lastfont: Any
    def __init__(self) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box, used_characters): ...

class MathtextBackendPdf(MathtextBackend):

    class _PDFResult(NamedTuple):
        width: Any
        height: Any
        depth: Any
        glyphs: Any
        rects: Any
        used_characters: Any
    glyphs: Any
    rects: Any
    def __init__(self) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box, used_characters): ...

class MathtextBackendSvg(MathtextBackend):
    svg_glyphs: Any
    svg_rects: Any
    def __init__(self) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box, used_characters): ...

class MathtextBackendPath(MathtextBackend):

    class _Result(NamedTuple):
        width: Any
        height: Any
        depth: Any
        glyphs: Any
        rects: Any
    glyphs: Any
    rects: Any
    def __init__(self) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box, used_characters): ...

class MathtextBackendCairo(MathtextBackend):
    glyphs: Any
    rects: Any
    def __init__(self) -> None: ...
    def render_glyph(self, ox, oy, info) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_results(self, box, used_characters): ...

class MathTextWarning(Warning): ...

def ship(ox, oy, box) -> None: ...

class MathTextParser:
    def __init__(self, output) -> None: ...
    def parse(self, s, dpi: int = ..., prop: Any | None = ..., *, _force_standard_ps_fonts: bool = ...): ...
    def to_mask(self, texstr, dpi: int = ..., fontsize: int = ...): ...
    def to_rgba(self, texstr, color: str = ..., dpi: int = ..., fontsize: int = ...): ...
    def to_png(self, filename, texstr, color: str = ..., dpi: int = ..., fontsize: int = ...): ...
    def get_depth(self, texstr, dpi: int = ..., fontsize: int = ...): ...

def math_to_image(s, filename_or_obj, prop: Any | None = ..., dpi: Any | None = ..., format: Any | None = ...): ...
