import matplotlib.cbook as cbook
from matplotlib import docstring as docstring, projections as projections
from matplotlib.artist import Artist as Artist, allow_rasterization as allow_rasterization
from matplotlib.axes import Axes as Axes, SubplotBase as SubplotBase, subplot_class_factory as subplot_class_factory
from matplotlib.backend_bases import FigureCanvasBase as FigureCanvasBase, MouseButton as MouseButton, NonGuiException as NonGuiException
from matplotlib.gridspec import GridSpec as GridSpec
from matplotlib.patches import Rectangle as Rectangle
from matplotlib.text import Text as Text
from matplotlib.transforms import Affine2D as Affine2D, Bbox as Bbox, BboxTransformTo as BboxTransformTo, TransformedBbox as TransformedBbox
from typing import Any

class _AxesStack(cbook.Stack):
    def __init__(self) -> None: ...
    def as_list(self): ...
    def remove(self, a) -> None: ...
    def bubble(self, a): ...
    def add(self, a) -> None: ...
    def __call__(self): ...
    def __contains__(self, a): ...

class SubplotParams:
    def __init__(self, left: Any | None = ..., bottom: Any | None = ..., right: Any | None = ..., top: Any | None = ..., wspace: Any | None = ..., hspace: Any | None = ...) -> None: ...
    validate: Any
    left: Any
    right: Any
    bottom: Any
    top: Any
    wspace: Any
    hspace: Any
    def update(self, left: Any | None = ..., bottom: Any | None = ..., right: Any | None = ..., top: Any | None = ..., wspace: Any | None = ..., hspace: Any | None = ...) -> None: ...

class FigureBase(Artist):
    figure: Any
    artists: Any
    lines: Any
    patches: Any
    texts: Any
    images: Any
    legends: Any
    subfigs: Any
    stale: bool
    suppressComposite: Any
    def __init__(self, **kwargs) -> None: ...
    def autofmt_xdate(self, bottom: float = ..., rotation: int = ..., ha: str = ..., which: str = ...) -> None: ...
    def get_children(self): ...
    def contains(self, mouseevent): ...
    def get_window_extent(self, *args, **kwargs): ...
    def suptitle(self, t, **kwargs): ...
    def supxlabel(self, t, **kwargs): ...
    def supylabel(self, t, **kwargs): ...
    def get_edgecolor(self): ...
    def get_facecolor(self): ...
    def get_frameon(self): ...
    def set_linewidth(self, linewidth) -> None: ...
    def get_linewidth(self): ...
    def set_edgecolor(self, color) -> None: ...
    def set_facecolor(self, color) -> None: ...
    def set_frameon(self, b) -> None: ...
    frameon: Any
    def add_artist(self, artist, clip: bool = ...): ...
    def add_axes(self, *args, **kwargs): ...
    def add_subplot(self, *args, **kwargs) -> Axes: ...
    def subplots(self, nrows: int = ..., ncols: int = ..., *, sharex: bool = ..., sharey: bool = ..., squeeze: bool = ..., subplot_kw: Any | None = ..., gridspec_kw: Any | None = ...): ...
    def delaxes(self, ax): ...
    def legend(self, *args, **kwargs): ...
    def text(self, x, y, s, fontdict: Any | None = ..., **kwargs): ...
    def colorbar(self, mappable, cax: Any | None = ..., ax: Any | None = ..., use_gridspec: bool = ..., **kw): ...
    def subplots_adjust(self, left: Any | None = ..., bottom: Any | None = ..., right: Any | None = ..., top: Any | None = ..., wspace: Any | None = ..., hspace: Any | None = ...) -> None: ...
    def align_xlabels(self, axs: Any | None = ...) -> None: ...
    def align_ylabels(self, axs: Any | None = ...) -> None: ...
    def align_labels(self, axs: Any | None = ...) -> None: ...
    def add_gridspec(self, nrows: int = ..., ncols: int = ..., **kwargs): ...
    def subfigures(self, nrows: int = ..., ncols: int = ..., squeeze: bool = ..., wspace: Any | None = ..., hspace: Any | None = ..., width_ratios: Any | None = ..., height_ratios: Any | None = ..., **kwargs): ...
    def add_subfigure(self, subplotspec, **kwargs): ...
    def sca(self, a): ...
    def gca(self, **kwargs): ...
    def get_default_bbox_extra_artists(self): ...
    def get_tightbbox(self, renderer, bbox_extra_artists: Any | None = ...): ...
    def subplot_mosaic(self, mosaic, *, sharex: bool = ..., sharey: bool = ..., subplot_kw: Any | None = ..., gridspec_kw: Any | None = ..., empty_sentinel: str = ...): ...

class SubFigure(FigureBase):
    figure: Any
    subplotpars: Any
    dpi_scale_trans: Any
    canvas: Any
    transFigure: Any
    bbox_relative: Any
    figbbox: Any
    bbox: Any
    transSubfigure: Any
    patch: Any
    def __init__(self, parent, subplotspec, *, facecolor: Any | None = ..., edgecolor: Any | None = ..., linewidth: float = ..., frameon: Any | None = ..., **kwargs) -> None: ...
    @property
    def dpi(self): ...
    @dpi.setter
    def dpi(self, value) -> None: ...
    def get_constrained_layout(self): ...
    def get_constrained_layout_pads(self, relative: bool = ...): ...
    @property
    def axes(self): ...
    get_axes: Any
    stale: bool
    def draw(self, renderer) -> None: ...

class Figure(FigureBase):
    callbacks: Any
    bbox_inches: Any
    dpi_scale_trans: Any
    bbox: Any
    figbbox: Any
    transFigure: Any
    transSubfigure: Any
    patch: Any
    subplotpars: Any
    def __init__(self, figsize: Any | None = ..., dpi: Any | None = ..., facecolor: Any | None = ..., edgecolor: Any | None = ..., linewidth: float = ..., frameon: Any | None = ..., subplotpars: Any | None = ..., tight_layout: Any | None = ..., constrained_layout: Any | None = ..., *, layout: Any | None = ..., **kwargs): ...
    def show(self, warn: bool = ...) -> None: ...
    @property
    def axes(self): ...
    get_axes: Any
    dpi: Any
    def get_tight_layout(self): ...
    stale: bool
    def set_tight_layout(self, tight) -> None: ...
    def get_constrained_layout(self): ...
    def set_constrained_layout(self, constrained) -> None: ...
    def set_constrained_layout_pads(self, *, w_pad: Any | None = ..., h_pad: Any | None = ..., wspace: Any | None = ..., hspace: Any | None = ...) -> None: ...
    def get_constrained_layout_pads(self, relative: bool = ...): ...
    canvas: Any
    def set_canvas(self, canvas) -> None: ...
    def figimage(self, X, xo: int = ..., yo: int = ..., alpha: Any | None = ..., norm: Any | None = ..., cmap: Any | None = ..., vmin: Any | None = ..., vmax: Any | None = ..., origin: Any | None = ..., resize: bool = ..., **kwargs): ...
    def set_size_inches(self, w, h: Any | None = ..., forward: bool = ...) -> None: ...
    def get_size_inches(self): ...
    def get_figwidth(self): ...
    def get_figheight(self): ...
    def get_dpi(self): ...
    def set_dpi(self, val) -> None: ...
    def set_figwidth(self, val, forward: bool = ...) -> None: ...
    def set_figheight(self, val, forward: bool = ...) -> None: ...
    suppressComposite: Any
    artists: Any
    lines: Any
    patches: Any
    texts: Any
    images: Any
    legends: Any
    def clf(self, keep_observers: bool = ...) -> None: ...
    def clear(self, keep_observers: bool = ...) -> None: ...
    def draw(self, renderer) -> None: ...
    def draw_without_rendering(self) -> None: ...
    def draw_artist(self, a) -> None: ...
    def add_axobserver(self, func): ...
    def savefig(self, fname, *, transparent: Any | None = ..., **kwargs) -> None: ...
    def ginput(self, n: int = ..., timeout: int = ..., show_clicks: bool = ..., mouse_add=..., mouse_pop=..., mouse_stop=...): ...
    def waitforbuttonpress(self, timeout: int = ...): ...
    def execute_constrained_layout(self, renderer: Any | None = ...): ...
    def tight_layout(self, *, pad: float = ..., h_pad: Any | None = ..., w_pad: Any | None = ..., rect: Any | None = ...) -> None: ...

def figaspect(arg): ...
