from dateutil.relativedelta import relativedelta as relativedelta
from dateutil.rrule import DAILY as DAILY, FR as FR, HOURLY as HOURLY, MINUTELY as MINUTELY, MO as MO, MONTHLY as MONTHLY, SA as SA, SECONDLY as SECONDLY, SU as SU, TH as TH, TU as TU, WE as WE, WEEKLY as WEEKLY, YEARLY as YEARLY, rrule as rrule
from matplotlib import ticker, units
from typing import Any

MICROSECONDLY: Any

def set_epoch(epoch) -> None: ...
def get_epoch(): ...
def datestr2num(d, default: Any | None = ...): ...
def date2num(d): ...
def num2date(x, tz: Any | None = ...): ...
def num2timedelta(x): ...
def drange(dstart, dend, delta): ...

class DateFormatter(ticker.Formatter):
    fmt: Any
    tz: Any
    def __init__(self, fmt, tz: Any | None = ..., *, usetex: Any | None = ...) -> None: ...
    def __call__(self, x, pos: int = ...): ...
    def set_tzinfo(self, tz) -> None: ...

class ConciseDateFormatter(ticker.Formatter):
    defaultfmt: str
    formats: Any
    zero_formats: Any
    offset_formats: Any
    offset_string: str
    show_offset: Any
    def __init__(self, locator, tz: Any | None = ..., formats: Any | None = ..., offset_formats: Any | None = ..., zero_formats: Any | None = ..., show_offset: bool = ..., *, usetex: Any | None = ...) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...
    def format_ticks(self, values): ...
    def get_offset(self): ...
    def format_data_short(self, value): ...

class AutoDateFormatter(ticker.Formatter):
    defaultfmt: Any
    scaled: Any
    def __init__(self, locator, tz: Any | None = ..., defaultfmt: str = ..., *, usetex: Any | None = ...) -> None: ...
    def __call__(self, x, pos: Any | None = ...): ...

class rrulewrapper:
    def __init__(self, freq, tzinfo: Any | None = ..., **kwargs) -> None: ...
    def set(self, **kwargs) -> None: ...
    def __getattr__(self, name): ...

class DateLocator(ticker.Locator):
    hms0d: Any
    tz: Any
    def __init__(self, tz: Any | None = ...) -> None: ...
    def set_tzinfo(self, tz) -> None: ...
    def datalim_to_dt(self): ...
    def viewlim_to_dt(self): ...
    def nonsingular(self, vmin, vmax): ...

class RRuleLocator(DateLocator):
    rule: Any
    def __init__(self, o, tz: Any | None = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    @staticmethod
    def get_unit_generic(freq): ...

class AutoDateLocator(DateLocator):
    minticks: Any
    maxticks: Any
    interval_multiples: Any
    intervald: Any
    def __init__(self, tz: Any | None = ..., minticks: int = ..., maxticks: Any | None = ..., interval_multiples: bool = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def nonsingular(self, vmin, vmax): ...
    def get_locator(self, dmin, dmax): ...

class YearLocator(RRuleLocator):
    base: Any
    def __init__(self, base: int = ..., month: int = ..., day: int = ..., tz: Any | None = ...) -> None: ...

class MonthLocator(RRuleLocator):
    def __init__(self, bymonth: Any | None = ..., bymonthday: int = ..., interval: int = ..., tz: Any | None = ...) -> None: ...

class WeekdayLocator(RRuleLocator):
    def __init__(self, byweekday: int = ..., interval: int = ..., tz: Any | None = ...) -> None: ...

class DayLocator(RRuleLocator):
    def __init__(self, bymonthday: Any | None = ..., interval: int = ..., tz: Any | None = ...) -> None: ...

class HourLocator(RRuleLocator):
    def __init__(self, byhour: Any | None = ..., interval: int = ..., tz: Any | None = ...) -> None: ...

class MinuteLocator(RRuleLocator):
    def __init__(self, byminute: Any | None = ..., interval: int = ..., tz: Any | None = ...) -> None: ...

class SecondLocator(RRuleLocator):
    def __init__(self, bysecond: Any | None = ..., interval: int = ..., tz: Any | None = ...) -> None: ...

class MicrosecondLocator(DateLocator):
    def __init__(self, interval: int = ..., tz: Any | None = ...) -> None: ...
    def set_axis(self, axis): ...
    def set_view_interval(self, vmin, vmax): ...
    def set_data_interval(self, vmin, vmax): ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...

def epoch2num(e): ...
def num2epoch(d): ...

class DateConverter(units.ConversionInterface):
    def __init__(self, *, interval_multiples: bool = ...) -> None: ...
    def axisinfo(self, unit, axis): ...
    @staticmethod
    def convert(value, unit, axis): ...
    @staticmethod
    def default_units(x, axis): ...

class ConciseDateConverter(DateConverter):
    def __init__(self, formats: Any | None = ..., zero_formats: Any | None = ..., offset_formats: Any | None = ..., show_offset: bool = ..., *, interval_multiples: bool = ...) -> None: ...
    def axisinfo(self, unit, axis): ...

class _SwitchableDateConverter:
    def axisinfo(self, *args, **kwargs): ...
    def default_units(self, *args, **kwargs): ...
    def convert(self, *args, **kwargs): ...
