from ._color_data import BASE_COLORS as BASE_COLORS, CSS4_COLORS as CSS4_COLORS, TABLEAU_COLORS as TABLEAU_COLORS, XKCD_COLORS as XKCD_COLORS
from matplotlib import cbook as cbook, scale as scale
from typing import Any

class _ColorMapping(dict):
    cache: Any
    def __init__(self, mapping) -> None: ...
    def __setitem__(self, key, value) -> None: ...
    def __delitem__(self, key) -> None: ...

def get_named_colors_mapping(): ...
def is_color_like(c): ...
def same_color(c1, c2): ...
def to_rgba(c, alpha: Any | None = ...): ...
def to_rgba_array(c, alpha: Any | None = ...): ...
def to_rgb(c): ...
def to_hex(c, keep_alpha: bool = ...): ...
cnames = CSS4_COLORS
hexColorPattern: Any
rgb2hex = to_hex
hex2color = to_rgb

class ColorConverter:
    colors: Any
    cache: Any
    to_rgb: Any
    to_rgba: Any
    to_rgba_array: Any

colorConverter: Any

class Colormap:
    name: Any
    N: Any
    colorbar_extend: bool
    def __init__(self, name, N: int = ...) -> None: ...
    def __call__(self, X, alpha: Any | None = ..., bytes: bool = ...): ...
    def __copy__(self): ...
    def __eq__(self, other): ...
    def get_bad(self): ...
    def set_bad(self, color: str = ..., alpha: Any | None = ...) -> None: ...
    def get_under(self): ...
    def set_under(self, color: str = ..., alpha: Any | None = ...) -> None: ...
    def get_over(self): ...
    def set_over(self, color: str = ..., alpha: Any | None = ...) -> None: ...
    def set_extremes(self, *, bad: Any | None = ..., under: Any | None = ..., over: Any | None = ...) -> None: ...
    def with_extremes(self, *, bad: Any | None = ..., under: Any | None = ..., over: Any | None = ...): ...
    def is_gray(self): ...
    def reversed(self, name: Any | None = ...) -> None: ...
    def copy(self): ...

class LinearSegmentedColormap(Colormap):
    monochrome: bool
    def __init__(self, name, segmentdata, N: int = ..., gamma: float = ...) -> None: ...
    def set_gamma(self, gamma) -> None: ...
    @staticmethod
    def from_list(name, colors, N: int = ..., gamma: float = ...): ...
    def reversed(self, name: Any | None = ...): ...

class ListedColormap(Colormap):
    monochrome: bool
    colors: Any
    def __init__(self, colors, name: str = ..., N: Any | None = ...) -> None: ...
    def reversed(self, name: Any | None = ...): ...

class Normalize:
    callbacks: Any
    def __init__(self, vmin: Any | None = ..., vmax: Any | None = ..., clip: bool = ...) -> None: ...
    @property
    def vmin(self): ...
    @vmin.setter
    def vmin(self, value) -> None: ...
    @property
    def vmax(self): ...
    @vmax.setter
    def vmax(self, value) -> None: ...
    @property
    def clip(self): ...
    @clip.setter
    def clip(self, value) -> None: ...
    @staticmethod
    def process_value(value): ...
    def __call__(self, value, clip: Any | None = ...): ...
    def inverse(self, value): ...
    def autoscale(self, A) -> None: ...
    def autoscale_None(self, A) -> None: ...
    def scaled(self): ...

class TwoSlopeNorm(Normalize):
    def __init__(self, vcenter, vmin: Any | None = ..., vmax: Any | None = ...) -> None: ...
    @property
    def vcenter(self): ...
    @vcenter.setter
    def vcenter(self, value) -> None: ...
    vmin: Any
    vmax: Any
    def autoscale_None(self, A) -> None: ...
    def __call__(self, value, clip: Any | None = ...): ...
    def inverse(self, value): ...

class CenteredNorm(Normalize):
    def __init__(self, vcenter: int = ..., halfrange: Any | None = ..., clip: bool = ...) -> None: ...
    def autoscale(self, A) -> None: ...
    def autoscale_None(self, A) -> None: ...
    @property
    def vcenter(self): ...
    @vcenter.setter
    def vcenter(self, vcenter) -> None: ...
    @property
    def halfrange(self): ...
    vmin: Any
    vmax: Any
    @halfrange.setter
    def halfrange(self, halfrange) -> None: ...
    def __call__(self, value, clip: Any | None = ...): ...

def make_norm_from_scale(scale_cls, base_norm_cls: Any | None = ..., *, init: Any | None = ...): ...

class FuncNorm(Normalize): ...

class LogNorm(Normalize):
    def autoscale(self, A) -> None: ...
    def autoscale_None(self, A) -> None: ...

class SymLogNorm(Normalize):
    @property
    def linthresh(self): ...
    @linthresh.setter
    def linthresh(self, value) -> None: ...

class PowerNorm(Normalize):
    gamma: Any
    def __init__(self, gamma, vmin: Any | None = ..., vmax: Any | None = ..., clip: bool = ...) -> None: ...
    def __call__(self, value, clip: Any | None = ...): ...
    def inverse(self, value): ...

class BoundaryNorm(Normalize):
    boundaries: Any
    N: Any
    Ncmap: Any
    extend: Any
    def __init__(self, boundaries, ncolors, clip: bool = ..., *, extend: str = ...) -> None: ...
    def __call__(self, value, clip: Any | None = ...): ...
    def inverse(self, value) -> None: ...

class NoNorm(Normalize):
    def __call__(self, value, clip: Any | None = ...): ...
    def inverse(self, value): ...

def rgb_to_hsv(arr): ...
def hsv_to_rgb(hsv): ...

class LightSource:
    azdeg: Any
    altdeg: Any
    hsv_min_val: Any
    hsv_max_val: Any
    hsv_min_sat: Any
    hsv_max_sat: Any
    def __init__(self, azdeg: int = ..., altdeg: int = ..., hsv_min_val: int = ..., hsv_max_val: int = ..., hsv_min_sat: int = ..., hsv_max_sat: int = ...) -> None: ...
    @property
    def direction(self): ...
    def hillshade(self, elevation, vert_exag: int = ..., dx: int = ..., dy: int = ..., fraction: float = ...): ...
    def shade_normals(self, normals, fraction: float = ...): ...
    def shade(self, data, cmap, norm: Any | None = ..., blend_mode: str = ..., vmin: Any | None = ..., vmax: Any | None = ..., vert_exag: int = ..., dx: int = ..., dy: int = ..., fraction: int = ..., **kwargs): ...
    def shade_rgb(self, rgb, elevation, fraction: float = ..., blend_mode: str = ..., vert_exag: int = ..., dx: int = ..., dy: int = ..., **kwargs): ...
    def blend_hsv(self, rgb, intensity, hsv_max_sat: Any | None = ..., hsv_max_val: Any | None = ..., hsv_min_val: Any | None = ..., hsv_min_sat: Any | None = ...): ...
    def blend_soft_light(self, rgb, intensity): ...
    def blend_overlay(self, rgb, intensity): ...

def from_levels_and_colors(levels, colors, extend: str = ...): ...
