from enum import Enum, IntEnum
from matplotlib import cbook as cbook, colors as colors, docstring as docstring, get_backend as get_backend, is_interactive as is_interactive, rcParams as rcParams, textpath as textpath, tight_bbox as tight_bbox, transforms as transforms, widgets as widgets
from matplotlib._enums import CapStyle as CapStyle, JoinStyle as JoinStyle
from matplotlib._pylab_helpers import Gcf as Gcf
from matplotlib.backend_managers import ToolManager as ToolManager
from matplotlib.path import Path as Path
from matplotlib.transforms import Affine2D as Affine2D
from typing import Any, NamedTuple

def register_backend(format, backend, description: Any | None = ...) -> None: ...
def get_registered_canvas_class(format): ...

class RendererBase:
    def __init__(self) -> None: ...
    def open_group(self, s, gid: Any | None = ...) -> None: ...
    def close_group(self, s) -> None: ...
    def draw_path(self, gc, path, transform, rgbFace: Any | None = ...) -> None: ...
    def draw_markers(self, gc, marker_path, marker_trans, path, trans, rgbFace: Any | None = ...) -> None: ...
    def draw_path_collection(self, gc, master_transform, paths, all_transforms, offsets, offsetTrans, facecolors, edgecolors, linewidths, linestyles, antialiaseds, urls, offset_position) -> None: ...
    def draw_quad_mesh(self, gc, master_transform, meshWidth, meshHeight, coordinates, offsets, offsetTrans, facecolors, antialiased, edgecolors): ...
    def draw_gouraud_triangle(self, gc, points, colors, transform) -> None: ...
    def draw_gouraud_triangles(self, gc, triangles_array, colors_array, transform) -> None: ...
    def get_image_magnification(self): ...
    def draw_image(self, gc, x, y, im, transform: Any | None = ...) -> None: ...
    def option_image_nocomposite(self): ...
    def option_scale_image(self): ...
    def draw_tex(self, gc, x, y, s, prop, angle, *, mtext: Any | None = ...) -> None: ...
    def draw_text(self, gc, x, y, s, prop, angle, ismath: bool = ..., mtext: Any | None = ...) -> None: ...
    def get_text_width_height_descent(self, s, prop, ismath): ...
    def flipy(self): ...
    def get_canvas_width_height(self): ...
    def get_texmanager(self): ...
    def new_gc(self): ...
    def points_to_pixels(self, points): ...
    def start_rasterizing(self) -> None: ...
    def stop_rasterizing(self) -> None: ...
    def start_filter(self) -> None: ...
    def stop_filter(self, filter_func) -> None: ...

class GraphicsContextBase:
    def __init__(self) -> None: ...
    def copy_properties(self, gc) -> None: ...
    def restore(self) -> None: ...
    def get_alpha(self): ...
    def get_antialiased(self): ...
    def get_capstyle(self): ...
    def get_clip_rectangle(self): ...
    def get_clip_path(self): ...
    def get_dashes(self): ...
    def get_forced_alpha(self): ...
    def get_joinstyle(self): ...
    def get_linewidth(self): ...
    def get_rgb(self): ...
    def get_url(self): ...
    def get_gid(self): ...
    def get_snap(self): ...
    def set_alpha(self, alpha) -> None: ...
    def set_antialiased(self, b) -> None: ...
    def set_capstyle(self, cs) -> None: ...
    def set_clip_rectangle(self, rectangle) -> None: ...
    def set_clip_path(self, path) -> None: ...
    def set_dashes(self, dash_offset, dash_list) -> None: ...
    def set_foreground(self, fg, isRGBA: bool = ...) -> None: ...
    def set_joinstyle(self, js) -> None: ...
    def set_linewidth(self, w) -> None: ...
    def set_url(self, url) -> None: ...
    def set_gid(self, id) -> None: ...
    def set_snap(self, snap) -> None: ...
    def set_hatch(self, hatch) -> None: ...
    def get_hatch(self): ...
    def get_hatch_path(self, density: float = ...): ...
    def get_hatch_color(self): ...
    def set_hatch_color(self, hatch_color) -> None: ...
    def get_hatch_linewidth(self): ...
    def get_sketch_params(self): ...
    def set_sketch_params(self, scale: Any | None = ..., length: Any | None = ..., randomness: Any | None = ...) -> None: ...

class TimerBase:
    callbacks: Any
    def __init__(self, interval: Any | None = ..., callbacks: Any | None = ...) -> None: ...
    def __del__(self) -> None: ...
    def start(self, interval: Any | None = ...) -> None: ...
    def stop(self) -> None: ...
    @property
    def interval(self): ...
    @interval.setter
    def interval(self, interval) -> None: ...
    @property
    def single_shot(self): ...
    @single_shot.setter
    def single_shot(self, ss) -> None: ...
    def add_callback(self, func, *args, **kwargs): ...
    def remove_callback(self, func, *args, **kwargs) -> None: ...

class Event:
    name: Any
    canvas: Any
    guiEvent: Any
    def __init__(self, name, canvas, guiEvent: Any | None = ...) -> None: ...

class DrawEvent(Event):
    renderer: Any
    def __init__(self, name, canvas, renderer) -> None: ...

class ResizeEvent(Event):
    def __init__(self, name, canvas) -> None: ...

class CloseEvent(Event): ...

class LocationEvent(Event):
    lastevent: Any
    x: Any
    y: Any
    inaxes: Any
    xdata: Any
    ydata: Any
    def __init__(self, name, canvas, x, y, guiEvent: Any | None = ...) -> None: ...

class MouseButton(IntEnum):
    LEFT: int
    MIDDLE: int
    RIGHT: int
    BACK: int
    FORWARD: int

class MouseEvent(LocationEvent):
    button: Any
    key: Any
    step: Any
    dblclick: Any
    def __init__(self, name, canvas, x, y, button: Any | None = ..., key: Any | None = ..., step: int = ..., dblclick: bool = ..., guiEvent: Any | None = ...) -> None: ...

class PickEvent(Event):
    mouseevent: Any
    artist: Any
    def __init__(self, name, canvas, mouseevent, artist, guiEvent: Any | None = ..., **kwargs) -> None: ...

class KeyEvent(LocationEvent):
    key: Any
    def __init__(self, name, canvas, key, x: int = ..., y: int = ..., guiEvent: Any | None = ...) -> None: ...

class FigureCanvasBase:
    required_interactive_framework: Any
    events: Any
    fixed_dpi: Any
    filetypes: Any
    def supports_blit(cls): ...
    figure: Any
    manager: Any
    widgetlock: Any
    mouse_grabber: Any
    toolbar: Any
    def __init__(self, figure: Any | None = ...) -> None: ...
    callbacks: Any
    button_pick_id: Any
    scroll_pick_id: Any
    def is_saving(self): ...
    def pick(self, mouseevent) -> None: ...
    def blit(self, bbox: Any | None = ...) -> None: ...
    def resize(self, w, h) -> None: ...
    def draw_event(self, renderer) -> None: ...
    def resize_event(self) -> None: ...
    def close_event(self, guiEvent: Any | None = ...) -> None: ...
    def key_press_event(self, key, guiEvent: Any | None = ...) -> None: ...
    def key_release_event(self, key, guiEvent: Any | None = ...) -> None: ...
    def pick_event(self, mouseevent, artist, **kwargs) -> None: ...
    def scroll_event(self, x, y, step, guiEvent: Any | None = ...) -> None: ...
    def button_press_event(self, x, y, button, dblclick: bool = ..., guiEvent: Any | None = ...) -> None: ...
    def button_release_event(self, x, y, button, guiEvent: Any | None = ...) -> None: ...
    def motion_notify_event(self, x, y, guiEvent: Any | None = ...) -> None: ...
    def leave_notify_event(self, guiEvent: Any | None = ...) -> None: ...
    def enter_notify_event(self, guiEvent: Any | None = ..., xy: Any | None = ...) -> None: ...
    def inaxes(self, xy): ...
    def grab_mouse(self, ax) -> None: ...
    def release_mouse(self, ax) -> None: ...
    def set_cursor(self, cursor) -> None: ...
    def draw(self, *args, **kwargs) -> None: ...
    def draw_idle(self, *args, **kwargs) -> None: ...
    @property
    def device_pixel_ratio(self): ...
    def get_width_height(self, *, physical: bool = ...): ...
    @classmethod
    def get_supported_filetypes(cls): ...
    @classmethod
    def get_supported_filetypes_grouped(cls): ...
    def print_figure(self, filename, dpi: Any | None = ..., facecolor: Any | None = ..., edgecolor: Any | None = ..., orientation: str = ..., format: Any | None = ..., *, bbox_inches: Any | None = ..., pad_inches: Any | None = ..., bbox_extra_artists: Any | None = ..., backend: Any | None = ..., **kwargs): ...
    @classmethod
    def get_default_filetype(cls): ...
    def get_window_title(self): ...
    def set_window_title(self, title) -> None: ...
    def get_default_filename(self): ...
    def switch_backends(self, FigureCanvasClass): ...
    def mpl_connect(self, s, func): ...
    def mpl_disconnect(self, cid): ...
    def new_timer(self, interval: Any | None = ..., callbacks: Any | None = ...): ...
    def flush_events(self) -> None: ...
    def start_event_loop(self, timeout: int = ...) -> None: ...
    def stop_event_loop(self) -> None: ...

def key_press_handler(event, canvas: Any | None = ..., toolbar: Any | None = ...): ...
def button_press_handler(event, canvas: Any | None = ..., toolbar: Any | None = ...) -> None: ...

class NonGuiException(Exception): ...

class FigureManagerBase:
    canvas: Any
    num: Any
    key_press_handler_id: Any
    button_press_handler_id: Any
    toolmanager: Any
    toolbar: Any
    def __init__(self, canvas, num) -> None: ...
    def show(self) -> None: ...
    def destroy(self) -> None: ...
    def full_screen_toggle(self) -> None: ...
    def resize(self, w, h) -> None: ...
    def key_press(self, event) -> None: ...
    def button_press(self, event) -> None: ...
    def get_window_title(self): ...
    def set_window_title(self, title) -> None: ...

cursors: Any

class _Mode(str, Enum):
    NONE: str
    PAN: str
    ZOOM: str

class NavigationToolbar2:
    toolitems: Any
    canvas: Any
    mode: Any
    def __init__(self, canvas) -> None: ...
    def set_message(self, s) -> None: ...
    def draw_rubberband(self, event, x0, y0, x1, y1) -> None: ...
    def remove_rubberband(self) -> None: ...
    def home(self, *args) -> None: ...
    def back(self, *args) -> None: ...
    def forward(self, *args) -> None: ...
    def mouse_move(self, event) -> None: ...
    def pan(self, *args) -> None: ...

    class _PanInfo(NamedTuple):
        button: Any
        axes: Any
        cid: Any
    def press_pan(self, event) -> None: ...
    def drag_pan(self, event) -> None: ...
    def release_pan(self, event) -> None: ...
    def zoom(self, *args) -> None: ...

    class _ZoomInfo(NamedTuple):
        direction: Any
        start_xy: Any
        axes: Any
        cid: Any
        cbar: Any
    def press_zoom(self, event) -> None: ...
    def drag_zoom(self, event) -> None: ...
    def release_zoom(self, event) -> None: ...
    def push_current(self) -> None: ...
    subplot_tool: Any
    def configure_subplots(self, *args): ...
    def save_figure(self, *args) -> None: ...
    def set_cursor(self, cursor) -> None: ...
    def update(self) -> None: ...
    def set_history_buttons(self) -> None: ...

class ToolContainerBase:
    toolmanager: Any
    def __init__(self, toolmanager): ...
    def add_tool(self, tool, group, position: int = ...) -> None: ...
    def trigger_tool(self, name) -> None: ...
    def add_toolitem(self, name, group, position, image, description, toggle) -> None: ...
    def toggle_toolitem(self, name, toggled) -> None: ...
    def remove_toolitem(self, name) -> None: ...
    def set_message(self, s) -> None: ...

class _Backend:
    backend_version: str
    FigureCanvas: Any
    FigureManager: Any
    mainloop: Any
    @classmethod
    def new_figure_manager(cls, num, *args, **kwargs): ...
    @classmethod
    def new_figure_manager_given_figure(cls, num, figure): ...
    @classmethod
    def draw_if_interactive(cls) -> None: ...
    @classmethod
    def show(cls, *, block: Any | None = ...) -> None: ...
    @staticmethod
    def export(cls): ...

class ShowBase(_Backend):
    def __call__(self, block: Any | None = ...): ...
