import abc
from matplotlib import cbook as cbook
from matplotlib._animation_data import DISPLAY_TEMPLATE as DISPLAY_TEMPLATE, INCLUDED_FRAMES as INCLUDED_FRAMES, JS_INCLUDE as JS_INCLUDE, STYLE_INCLUDE as STYLE_INCLUDE
from typing import Any

subprocess_creation_flags: int

def adjusted_figsize(w, h, dpi, n): ...

class MovieWriterRegistry:
    def __init__(self) -> None: ...
    def register(self, name): ...
    def is_available(self, name): ...
    def __iter__(self): ...
    def list(self): ...
    def __getitem__(self, name): ...

writers: Any

class AbstractMovieWriter(abc.ABC, metaclass=abc.ABCMeta):
    fps: Any
    metadata: Any
    codec: Any
    bitrate: Any
    def __init__(self, fps: int = ..., metadata: Any | None = ..., codec: Any | None = ..., bitrate: Any | None = ...) -> None: ...
    outfile: Any
    fig: Any
    dpi: Any
    @abc.abstractmethod
    def setup(self, fig, outfile, dpi: Any | None = ...): ...
    @property
    def frame_size(self): ...
    @abc.abstractmethod
    def grab_frame(self, **savefig_kwargs): ...
    @abc.abstractmethod
    def finish(self): ...
    def saving(self, fig, outfile, dpi, *args, **kwargs) -> None: ...

class MovieWriter(AbstractMovieWriter):
    supported_formats: Any
    frame_format: Any
    extra_args: Any
    def __init__(self, fps: int = ..., codec: Any | None = ..., bitrate: Any | None = ..., extra_args: Any | None = ..., metadata: Any | None = ...) -> None: ...
    def setup(self, fig, outfile, dpi: Any | None = ...) -> None: ...
    def finish(self) -> None: ...
    def grab_frame(self, **savefig_kwargs) -> None: ...
    def cleanup(self) -> None: ...
    @classmethod
    def bin_path(cls): ...
    @classmethod
    def isAvailable(cls): ...

class FileMovieWriter(MovieWriter):
    def __init__(self, *args, **kwargs) -> None: ...
    fig: Any
    outfile: Any
    dpi: Any
    temp_prefix: Any
    fname_format_str: str
    def setup(self, fig, outfile, dpi: Any | None = ..., frame_prefix: Any | None = ...) -> None: ...
    def __del__(self) -> None: ...
    @property
    def frame_format(self): ...
    @frame_format.setter
    def frame_format(self, frame_format) -> None: ...
    def grab_frame(self, **savefig_kwargs) -> None: ...
    def finish(self) -> None: ...

class PillowWriter(AbstractMovieWriter):
    @classmethod
    def isAvailable(cls): ...
    def setup(self, fig, outfile, dpi: Any | None = ...) -> None: ...
    def grab_frame(self, **savefig_kwargs) -> None: ...
    def finish(self) -> None: ...

class FFMpegBase:
    codec: str
    @property
    def output_args(self): ...

class FFMpegWriter(FFMpegBase, MovieWriter): ...

class FFMpegFileWriter(FFMpegBase, FileMovieWriter):
    supported_formats: Any

class ImageMagickBase:
    @property
    def delay(self): ...
    @property
    def output_args(self): ...
    @classmethod
    def bin_path(cls): ...
    @classmethod
    def isAvailable(cls): ...

class ImageMagickWriter(ImageMagickBase, MovieWriter): ...

class ImageMagickFileWriter(ImageMagickBase, FileMovieWriter):
    supported_formats: Any

class HTMLWriter(FileMovieWriter):
    supported_formats: Any
    @classmethod
    def isAvailable(cls): ...
    embed_frames: Any
    default_mode: Any
    def __init__(self, fps: int = ..., codec: Any | None = ..., bitrate: Any | None = ..., extra_args: Any | None = ..., metadata: Any | None = ..., embed_frames: bool = ..., default_mode: str = ..., embed_limit: Any | None = ...) -> None: ...
    def setup(self, fig, outfile, dpi, frame_dir: Any | None = ...) -> None: ...
    def grab_frame(self, **savefig_kwargs): ...
    def finish(self) -> None: ...

class Animation:
    frame_seq: Any
    event_source: Any
    def __init__(self, fig, event_source: Any | None = ..., blit: bool = ...) -> None: ...
    def __del__(self) -> None: ...
    def save(self, filename, writer: Any | None = ..., fps: Any | None = ..., dpi: Any | None = ..., codec: Any | None = ..., bitrate: Any | None = ..., extra_args: Any | None = ..., metadata: Any | None = ..., extra_anim: Any | None = ..., savefig_kwargs: Any | None = ..., *, progress_callback: Any | None = ...) -> None: ...
    def new_frame_seq(self): ...
    def new_saved_frame_seq(self): ...
    def to_html5_video(self, embed_limit: Any | None = ...): ...
    def to_jshtml(self, fps: Any | None = ..., embed_frames: bool = ..., default_mode: Any | None = ...): ...
    def pause(self) -> None: ...
    def resume(self) -> None: ...

class TimedAnimation(Animation):
    repeat: Any
    def __init__(self, fig, interval: int = ..., repeat_delay: int = ..., repeat: bool = ..., event_source: Any | None = ..., *args, **kwargs) -> None: ...

class ArtistAnimation(TimedAnimation):
    def __init__(self, fig, artists, *args, **kwargs) -> None: ...

class FuncAnimation(TimedAnimation):
    save_count: Any
    def __init__(self, fig, func, frames: Any | None = ..., init_func: Any | None = ..., fargs: Any | None = ..., save_count: Any | None = ..., *, cache_frame_data: bool = ..., **kwargs): ...
    def new_frame_seq(self): ...
    def new_saved_frame_seq(self): ...
