import enum
from . import cbook as cbook
from ._mathtext_data import latex_to_bakoma as latex_to_bakoma, latex_to_standard as latex_to_standard, stix_glyph_fixes as stix_glyph_fixes, stix_virtual_fonts as stix_virtual_fonts, tex2uni as tex2uni
from .afm import AFM as AFM
from .font_manager import FontProperties as FontProperties, findfont as findfont, get_font as get_font
from .ft2font import KERNING_DEFAULT as KERNING_DEFAULT
from typing import Any, NamedTuple

def get_unicode_index(symbol, math: bool = ...): ...

class Fonts:
    default_font_prop: Any
    mathtext_backend: Any
    used_characters: Any
    def __init__(self, default_font_prop, mathtext_backend) -> None: ...
    def destroy(self) -> None: ...
    def get_kern(self, font1, fontclass1, sym1, fontsize1, font2, fontclass2, sym2, fontsize2, dpi): ...
    def get_metrics(self, font, font_class, sym, fontsize, dpi, math: bool = ...): ...
    def set_canvas_size(self, w, h, d) -> None: ...
    def render_glyph(self, ox, oy, font, font_class, sym, fontsize, dpi) -> None: ...
    def render_rect_filled(self, x1, y1, x2, y2) -> None: ...
    def get_xheight(self, font, fontsize, dpi) -> None: ...
    def get_underline_thickness(self, font, fontsize, dpi) -> None: ...
    def get_used_characters(self): ...
    def get_results(self, box): ...
    def get_sized_alternatives_for_symbol(self, fontname, sym): ...

class TruetypeFonts(Fonts):
    glyphd: Any
    def __init__(self, default_font_prop, mathtext_backend) -> None: ...
    def destroy(self) -> None: ...
    def get_xheight(self, fontname, fontsize, dpi): ...
    def get_underline_thickness(self, font, fontsize, dpi): ...
    def get_kern(self, font1, fontclass1, sym1, fontsize1, font2, fontclass2, sym2, fontsize2, dpi): ...

class BakomaFonts(TruetypeFonts):
    fontmap: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def get_sized_alternatives_for_symbol(self, fontname, sym): ...

class UnicodeFonts(TruetypeFonts):
    use_cmex: bool
    cm_fallback: Any
    fontmap: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def get_sized_alternatives_for_symbol(self, fontname, sym): ...

class DejaVuFonts(UnicodeFonts):
    use_cmex: bool
    cm_fallback: Any
    bakoma: Any
    fontmap: Any
    def __init__(self, *args, **kwargs) -> None: ...

class DejaVuSerifFonts(DejaVuFonts): ...
class DejaVuSansFonts(DejaVuFonts): ...

class StixFonts(UnicodeFonts):
    use_cmex: bool
    cm_fallback: bool
    fontmap: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def get_sized_alternatives_for_symbol(self, fontname, sym): ...

class StixSansFonts(StixFonts): ...

class StandardPsFonts(Fonts):
    basepath: Any
    fontmap: Any
    glyphd: Any
    fonts: Any
    def __init__(self, default_font_prop, mathtext_backend: Any | None = ...) -> None: ...
    pswriter: Any
    def get_kern(self, font1, fontclass1, sym1, fontsize1, font2, fontclass2, sym2, fontsize2, dpi): ...
    def get_xheight(self, font, fontsize, dpi): ...
    def get_underline_thickness(self, font, fontsize, dpi): ...

SHRINK_FACTOR: float
GROW_FACTOR: Any
NUM_SIZE_LEVELS: int

class FontConstantsBase:
    script_space: float
    subdrop: float
    sup1: float
    sub1: float
    sub2: float
    delta: float
    delta_slanted: float
    delta_integral: float

class ComputerModernFontConstants(FontConstantsBase):
    script_space: float
    subdrop: float
    sup1: float
    sub1: float
    sub2: float
    delta: float
    delta_slanted: float
    delta_integral: float

class STIXFontConstants(FontConstantsBase):
    script_space: float
    sup1: float
    sub2: float
    delta: float
    delta_slanted: float
    delta_integral: float

class STIXSansFontConstants(FontConstantsBase):
    script_space: float
    sup1: float
    delta_slanted: float
    delta_integral: float

class DejaVuSerifFontConstants(FontConstantsBase): ...
class DejaVuSansFontConstants(FontConstantsBase): ...

class Node:
    size: int
    def __init__(self) -> None: ...
    def get_kerning(self, next): ...
    def shrink(self) -> None: ...
    def grow(self) -> None: ...
    def render(self, x, y) -> None: ...

class Box(Node):
    width: Any
    height: Any
    depth: Any
    def __init__(self, width, height, depth) -> None: ...
    def shrink(self) -> None: ...
    def grow(self) -> None: ...
    def render(self, x1, y1, x2, y2) -> None: ...

class Vbox(Box):
    def __init__(self, height, depth) -> None: ...

class Hbox(Box):
    def __init__(self, width) -> None: ...

class Char(Node):
    c: Any
    font_output: Any
    font: Any
    font_class: Any
    fontsize: Any
    dpi: Any
    math: Any
    def __init__(self, c, state, math: bool = ...) -> None: ...
    def is_slanted(self): ...
    def get_kerning(self, next): ...
    def render(self, x, y) -> None: ...
    def shrink(self) -> None: ...
    def grow(self) -> None: ...

class Accent(Char):
    def shrink(self) -> None: ...
    def grow(self) -> None: ...
    def render(self, x, y) -> None: ...

class List(Box):
    shift_amount: float
    children: Any
    glue_set: float
    glue_sign: int
    glue_order: int
    def __init__(self, elements) -> None: ...
    def shrink(self) -> None: ...
    def grow(self) -> None: ...

class Hlist(List):
    def __init__(self, elements, w: float = ..., m: str = ..., do_kern: bool = ...) -> None: ...
    children: Any
    def kern(self) -> None: ...
    height: Any
    depth: Any
    width: Any
    glue_sign: int
    glue_order: int
    glue_ratio: float
    def hpack(self, w: float = ..., m: str = ...) -> None: ...

class Vlist(List):
    def __init__(self, elements, h: float = ..., m: str = ...) -> None: ...
    width: Any
    depth: Any
    height: Any
    glue_sign: int
    glue_order: int
    glue_ratio: float
    def vpack(self, h: float = ..., m: str = ..., l=...) -> None: ...

class Rule(Box):
    font_output: Any
    def __init__(self, width, height, depth, state) -> None: ...
    def render(self, x, y, w, h) -> None: ...

class Hrule(Rule):
    def __init__(self, state, thickness: Any | None = ...) -> None: ...

class Vrule(Rule):
    def __init__(self, state) -> None: ...

class _GlueSpec(NamedTuple):
    width: Any
    stretch: Any
    stretch_order: Any
    shrink: Any
    shrink_order: Any

class Glue(Node):
    glue_spec: Any
    def __init__(self, glue_type) -> None: ...
    def shrink(self) -> None: ...
    def grow(self) -> None: ...

class HCentered(Hlist):
    def __init__(self, elements) -> None: ...

class VCentered(Vlist):
    def __init__(self, elements) -> None: ...

class Kern(Node):
    height: int
    depth: int
    width: Any
    def __init__(self, width) -> None: ...
    def shrink(self) -> None: ...
    def grow(self) -> None: ...

class SubSuperCluster(Hlist):
    nucleus: Any
    sub: Any
    super: Any
    def __init__(self) -> None: ...

class AutoHeightChar(Hlist):
    shift_amount: Any
    def __init__(self, c, height, depth, state, always: bool = ..., factor: Any | None = ...) -> None: ...

class AutoWidthChar(Hlist):
    width: Any
    def __init__(self, c, width, state, always: bool = ..., char_class=...) -> None: ...

class Ship:
    max_push: int
    cur_s: int
    cur_v: float
    cur_h: float
    off_h: Any
    off_v: Any
    def __call__(self, ox, oy, box) -> None: ...
    @staticmethod
    def clamp(value): ...
    def hlist_out(self, box) -> None: ...
    def vlist_out(self, box) -> None: ...

ship: Any

def Error(msg): ...

class Parser:
    class _MathStyle(enum.Enum):
        DISPLAYSTYLE: Any
        TEXTSTYLE: Any
        SCRIPTSTYLE: Any
        SCRIPTSCRIPTSTYLE: Any
    def __init__(self) -> None: ...
    def parse(self, s, fonts_object, fontsize, dpi): ...
    class State:
        font_output: Any
        font_class: Any
        fontsize: Any
        dpi: Any
        def __init__(self, font_output, font, font_class, fontsize, dpi) -> None: ...
        def copy(self): ...
        @property
        def font(self): ...
        @font.setter
        def font(self, name) -> None: ...
    def get_state(self): ...
    def pop_state(self) -> None: ...
    def push_state(self) -> None: ...
    def main(self, s, loc, toks): ...
    def math_string(self, s, loc, toks): ...
    def math(self, s, loc, toks): ...
    def non_math(self, s, loc, toks): ...
    def space(self, s, loc, toks): ...
    def customspace(self, s, loc, toks): ...
    def symbol(self, s, loc, toks): ...
    accentprefixed: Any
    def unknown_symbol(self, s, loc, toks) -> None: ...
    def c_over_c(self, s, loc, toks): ...
    def accent(self, s, loc, toks): ...
    def function(self, s, loc, toks): ...
    def operatorname(self, s, loc, toks): ...
    def start_group(self, s, loc, toks): ...
    def group(self, s, loc, toks): ...
    required_group: Any
    simple_group: Any
    def end_group(self, s, loc, toks): ...
    def font(self, s, loc, toks): ...
    def is_overunder(self, nucleus): ...
    def is_dropsub(self, nucleus): ...
    def is_slanted(self, nucleus): ...
    def is_between_brackets(self, s, loc): ...
    def subsuper(self, s, loc, toks): ...
    def genfrac(self, s, loc, toks): ...
    def frac(self, s, loc, toks): ...
    def dfrac(self, s, loc, toks): ...
    def binom(self, s, loc, toks): ...
    overset: Any
    underset: Any
    def sqrt(self, s, loc, toks): ...
    def overline(self, s, loc, toks): ...
    def auto_delim(self, s, loc, toks): ...
