from keras import losses as losses
from keras.models import Sequential as Sequential
from keras.utils.generic_utils import has_arg as has_arg
from keras.utils.np_utils import to_categorical as to_categorical
from typing import Any

class BaseWrapper:
    build_fn: Any
    sk_params: Any
    def __init__(self, build_fn: Any | None = ..., **sk_params) -> None: ...
    def check_params(self, params) -> None: ...
    def get_params(self, **params): ...
    def set_params(self, **params): ...
    model: Any
    def fit(self, x, y, **kwargs): ...
    def filter_sk_params(self, fn, override: Any | None = ...): ...

class KerasClassifier(BaseWrapper):
    def __init__(self, build_fn: Any | None = ..., **sk_params) -> None: ...
    classes_: Any
    n_classes_: Any
    def fit(self, x, y, **kwargs): ...
    def predict(self, x, **kwargs): ...
    def predict_proba(self, x, **kwargs): ...
    def score(self, x, y, **kwargs): ...

class KerasRegressor(BaseWrapper):
    def __init__(self, build_fn: Any | None = ..., **sk_params) -> None: ...
    def predict(self, x, **kwargs): ...
    def score(self, x, y, **kwargs): ...
