import types as python_types
from keras.utils import io_utils as io_utils, tf_contextlib as tf_contextlib, tf_inspect as tf_inspect
from typing import Any

class CustomObjectScope:
    custom_objects: Any
    backup: Any
    def __init__(self, *args) -> None: ...
    def __enter__(self): ...
    def __exit__(self, *args, **kwargs) -> None: ...

def get_custom_objects(): ...

SHARED_OBJECT_KEY: str
SHARED_OBJECT_DISABLED: Any
SHARED_OBJECT_LOADING: Any
SHARED_OBJECT_SAVING: Any

class DisableSharedObjectScope:
    def __enter__(self) -> None: ...
    def __exit__(self, *args, **kwargs) -> None: ...

class NoopLoadingScope:
    def get(self, unused_object_id) -> None: ...
    def set(self, object_id, obj) -> None: ...

class SharedObjectLoadingScope:
    def __enter__(self): ...
    def get(self, object_id): ...
    def set(self, object_id, obj) -> None: ...
    def __exit__(self, *args, **kwargs) -> None: ...

class SharedObjectConfig(dict):
    ref_count: int
    object_id: Any
    def __init__(self, base_config, object_id, **kwargs) -> None: ...
    def increment_ref_count(self) -> None: ...

class SharedObjectSavingScope:
    def __enter__(self): ...
    def get_config(self, obj): ...
    def create_config(self, base_config, obj): ...
    def __exit__(self, *args, **kwargs) -> None: ...

def serialize_keras_class_and_config(cls_name, cls_config, obj: Any | None = ..., shared_object_id: Any | None = ...): ...
def register_keras_serializable(package: str = ..., name: Any | None = ...): ...
def get_registered_name(obj): ...
def skip_failed_serialization() -> None: ...
def get_registered_object(name, custom_objects: Any | None = ..., module_objects: Any | None = ...): ...

class CustomMaskWarning(Warning): ...

def serialize_keras_object(instance): ...
def get_custom_objects_by_name(item, custom_objects: Any | None = ...): ...
def class_and_config_for_serialized_keras_object(config, module_objects: Any | None = ..., custom_objects: Any | None = ..., printable_module_name: str = ...): ...
def deserialize_keras_object(identifier, module_objects: Any | None = ..., custom_objects: Any | None = ..., printable_module_name: str = ...): ...
def func_dump(func): ...
def func_load(code, defaults: Any | None = ..., closure: Any | None = ..., globs: Any | None = ...): ...
def has_arg(fn, name, accept_all: bool = ...): ...

class Progbar:
    target: Any
    width: Any
    verbose: Any
    interval: Any
    unit_name: Any
    stateful_metrics: Any
    def __init__(self, target, width: int = ..., verbose: int = ..., interval: float = ..., stateful_metrics: Any | None = ..., unit_name: str = ...) -> None: ...
    def update(self, current, values: Any | None = ..., finalize: Any | None = ...) -> None: ...
    def add(self, n, values: Any | None = ...) -> None: ...

def make_batches(size, batch_size): ...
def slice_arrays(arrays, start: Any | None = ..., stop: Any | None = ...): ...
def to_list(x): ...
def to_snake_case(name): ...
def is_all_none(structure): ...
def check_for_unexpected_keys(name, input_dict, expected_values) -> None: ...
def validate_kwargs(kwargs, allowed_kwargs, error_message: str = ...) -> None: ...
def validate_config(config): ...
def default(method): ...
def is_default(method): ...
def populate_dict_with_module_objects(target_dict, modules, obj_filter) -> None: ...

class LazyLoader(python_types.ModuleType):
    def __init__(self, local_name, parent_module_globals, name) -> None: ...
    def __getattr__(self, item): ...
custom_object_scope = CustomObjectScope
