import abc
from typing import Any

class ExportOutput(metaclass=abc.ABCMeta):
    __metaclass__: Any
    @abc.abstractmethod
    def as_signature_def(self, receiver_tensors): ...

class ClassificationOutput(ExportOutput):
    def __init__(self, scores: Any | None = ..., classes: Any | None = ...) -> None: ...
    @property
    def scores(self): ...
    @property
    def classes(self): ...
    def as_signature_def(self, receiver_tensors): ...

class RegressionOutput(ExportOutput):
    def __init__(self, value) -> None: ...
    @property
    def value(self): ...
    def as_signature_def(self, receiver_tensors): ...

class PredictOutput(ExportOutput):
    def __init__(self, outputs) -> None: ...
    @property
    def outputs(self): ...
    def as_signature_def(self, receiver_tensors): ...

class _SupervisedOutput(ExportOutput, metaclass=abc.ABCMeta):
    __metaclass__: Any
    LOSS_NAME: str
    PREDICTIONS_NAME: str
    METRICS_NAME: str
    METRIC_VALUE_SUFFIX: str
    METRIC_UPDATE_SUFFIX: str
    def __init__(
        self,
        loss: Any | None = ...,
        predictions: Any | None = ...,
        metrics: Any | None = ...,
    ) -> None: ...
    @property
    def loss(self): ...
    @property
    def predictions(self): ...
    @property
    def metrics(self): ...
    def as_signature_def(self, receiver_tensors): ...

class TrainOutput(_SupervisedOutput): ...
class EvalOutput(_SupervisedOutput): ...
