from typing import Any

from keras import backend as backend
from keras.distribute import distributed_file_utils as distributed_file_utils
from keras.distribute import worker_training_state as worker_training_state
from keras.optimizer_v2 import learning_rate_schedule as learning_rate_schedule
from keras.utils import generic_utils as generic_utils
from keras.utils import io_utils as io_utils
from keras.utils import tf_utils as tf_utils
from keras.utils import version_utils as version_utils
from keras.utils.data_utils import Sequence as Sequence
from keras.utils.generic_utils import Progbar as Progbar
from keras.utils.mode_keys import ModeKeys as ModeKeys

def configure_callbacks(
    callbacks,
    model,
    do_validation: bool = ...,
    batch_size: Any | None = ...,
    epochs: Any | None = ...,
    steps_per_epoch: Any | None = ...,
    samples: Any | None = ...,
    verbose: int = ...,
    count_mode: str = ...,
    mode=...,
): ...
def set_callback_parameters(
    callback_list,
    model,
    do_validation: bool = ...,
    batch_size: Any | None = ...,
    epochs: Any | None = ...,
    steps_per_epoch: Any | None = ...,
    samples: Any | None = ...,
    verbose: int = ...,
    mode=...,
) -> None: ...
def make_logs(model, logs, outputs, mode, prefix: str = ...): ...

class CallbackList:
    callbacks: Any
    def __init__(
        self,
        callbacks: Any | None = ...,
        add_history: bool = ...,
        add_progbar: bool = ...,
        model: Any | None = ...,
        **params
    ) -> None: ...
    def append(self, callback) -> None: ...
    params: Any
    def set_params(self, params) -> None: ...
    model: Any
    def set_model(self, model) -> None: ...
    def on_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...
    def on_train_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_train_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_train_end(self, logs: Any | None = ...) -> None: ...
    def on_test_begin(self, logs: Any | None = ...) -> None: ...
    def on_test_end(self, logs: Any | None = ...) -> None: ...
    def on_predict_begin(self, logs: Any | None = ...) -> None: ...
    def on_predict_end(self, logs: Any | None = ...) -> None: ...
    def __iter__(self): ...

class Callback:
    validation_data: Any
    model: Any
    def __init__(self) -> None: ...
    params: Any
    def set_params(self, params) -> None: ...
    def set_model(self, model) -> None: ...
    def on_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...
    def on_train_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_train_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_train_end(self, logs: Any | None = ...) -> None: ...
    def on_test_begin(self, logs: Any | None = ...) -> None: ...
    def on_test_end(self, logs: Any | None = ...) -> None: ...
    def on_predict_begin(self, logs: Any | None = ...) -> None: ...
    def on_predict_end(self, logs: Any | None = ...) -> None: ...

class BaseLogger(Callback):
    stateful_metrics: Any
    def __init__(self, stateful_metrics: Any | None = ...) -> None: ...
    seen: int
    totals: Any
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

class TerminateOnNaN(Callback):
    def __init__(self) -> None: ...
    def on_batch_end(self, batch, logs: Any | None = ...) -> None: ...

class ProgbarLogger(Callback):
    use_steps: bool
    stateful_metrics: Any
    seen: int
    progbar: Any
    target: Any
    verbose: int
    epochs: int
    def __init__(
        self, count_mode: str = ..., stateful_metrics: Any | None = ...
    ) -> None: ...
    def set_params(self, params) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_test_begin(self, logs: Any | None = ...) -> None: ...
    def on_predict_begin(self, logs: Any | None = ...) -> None: ...
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_train_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...
    def on_test_end(self, logs: Any | None = ...) -> None: ...
    def on_predict_end(self, logs: Any | None = ...) -> None: ...

class History(Callback):
    history: Any
    def __init__(self) -> None: ...
    epoch: Any
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

class ModelCheckpoint(Callback):
    monitor: Any
    verbose: Any
    filepath: Any
    save_best_only: Any
    save_weights_only: Any
    save_freq: Any
    epochs_since_last_save: int
    best: Any
    load_weights_on_restart: Any
    period: Any
    monitor_op: Any
    def __init__(
        self,
        filepath,
        monitor: str = ...,
        verbose: int = ...,
        save_best_only: bool = ...,
        save_weights_only: bool = ...,
        mode: str = ...,
        save_freq: str = ...,
        options: Any | None = ...,
        initial_value_threshold: Any | None = ...,
        **kwargs
    ) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_train_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

class BackupAndRestore(Callback):
    backup_dir: Any
    def __init__(self, backup_dir) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_train_end(self, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

class BackupAndRestoreExperimental(BackupAndRestore):
    def __init__(self, *args, **kwargs) -> None: ...

class EarlyStopping(Callback):
    monitor: Any
    patience: Any
    verbose: Any
    baseline: Any
    min_delta: Any
    wait: int
    stopped_epoch: int
    restore_best_weights: Any
    best_weights: Any
    monitor_op: Any
    def __init__(
        self,
        monitor: str = ...,
        min_delta: int = ...,
        patience: int = ...,
        verbose: int = ...,
        mode: str = ...,
        baseline: Any | None = ...,
        restore_best_weights: bool = ...,
    ) -> None: ...
    best: Any
    best_epoch: int
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...
    def on_train_end(self, logs: Any | None = ...) -> None: ...
    def get_monitor_value(self, logs): ...

class RemoteMonitor(Callback):
    root: Any
    path: Any
    field: Any
    headers: Any
    send_as_json: Any
    def __init__(
        self,
        root: str = ...,
        path: str = ...,
        field: str = ...,
        headers: Any | None = ...,
        send_as_json: bool = ...,
    ) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

class LearningRateScheduler(Callback):
    schedule: Any
    verbose: Any
    def __init__(self, schedule, verbose: int = ...) -> None: ...
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

def keras_model_summary(name, data, step: Any | None = ...): ...

class TensorBoard(Callback, version_utils.TensorBoardVersionSelector):
    log_dir: Any
    histogram_freq: Any
    write_graph: Any
    write_images: Any
    write_steps_per_second: Any
    update_freq: Any
    embeddings_freq: Any
    embeddings_metadata: Any
    def __init__(
        self,
        log_dir: str = ...,
        histogram_freq: int = ...,
        write_graph: bool = ...,
        write_images: bool = ...,
        write_steps_per_second: bool = ...,
        update_freq: str = ...,
        profile_batch: int = ...,
        embeddings_freq: int = ...,
        embeddings_metadata: Any | None = ...,
        **kwargs
    ) -> None: ...
    model: Any
    def set_model(self, model) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_train_end(self, logs: Any | None = ...) -> None: ...
    def on_test_begin(self, logs: Any | None = ...) -> None: ...
    def on_test_end(self, logs: Any | None = ...) -> None: ...
    def on_train_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_train_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_epoch_begin(self, epoch, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...

class ReduceLROnPlateau(Callback):
    monitor: Any
    factor: Any
    min_lr: Any
    min_delta: Any
    patience: Any
    verbose: Any
    cooldown: Any
    cooldown_counter: int
    wait: int
    best: int
    mode: Any
    monitor_op: Any
    def __init__(
        self,
        monitor: str = ...,
        factor: float = ...,
        patience: int = ...,
        verbose: int = ...,
        mode: str = ...,
        min_delta: float = ...,
        cooldown: int = ...,
        min_lr: int = ...,
        **kwargs
    ) -> None: ...
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...) -> None: ...
    def in_cooldown(self): ...

class CSVLogger(Callback):
    sep: Any
    filename: Any
    append: Any
    writer: Any
    keys: Any
    append_header: bool
    def __init__(self, filename, separator: str = ..., append: bool = ...) -> None: ...
    csv_file: Any
    def on_train_begin(self, logs: Any | None = ...) -> None: ...
    def on_epoch_end(self, epoch, logs: Any | None = ...): ...
    def on_train_end(self, logs: Any | None = ...) -> None: ...

class LambdaCallback(Callback):
    on_epoch_begin: Any
    on_epoch_end: Any
    on_batch_begin: Any
    on_batch_end: Any
    on_train_begin: Any
    on_train_end: Any
    def __init__(
        self,
        on_epoch_begin: Any | None = ...,
        on_epoch_end: Any | None = ...,
        on_batch_begin: Any | None = ...,
        on_batch_end: Any | None = ...,
        on_train_begin: Any | None = ...,
        on_train_end: Any | None = ...,
        **kwargs
    ) -> None: ...
