import abc
import tensorflow.compat.v2 as tf
from keras import backend as backend, initializers as initializers
from keras.engine import base_layer_utils as base_layer_utils
from keras.optimizer_v2 import learning_rate_schedule as learning_rate_schedule
from keras.utils import generic_utils as generic_utils, layer_utils as layer_utils, tf_inspect as tf_inspect, tf_utils as tf_utils
from typing import Any

keras_optimizers_gauge: Any

class NullContextmanager:
    def __init__(self, *args, **kwargs) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, type_arg, value_arg, traceback_arg): ...

def name_scope_only_in_function_or_graph(name): ...

class OptimizerV2(tf.__internal__.tracking.Trackable, metaclass=abc.ABCMeta):
    gradient_aggregator: Any
    gradient_transformers: Any
    def __init__(self, name, gradient_aggregator: Any | None = ..., gradient_transformers: Any | None = ..., **kwargs) -> None: ...
    @property
    def clipnorm(self): ...
    @property
    def global_clipnorm(self): ...
    @clipnorm.setter
    def clipnorm(self, val) -> None: ...
    @global_clipnorm.setter
    def global_clipnorm(self, val) -> None: ...
    @property
    def clipvalue(self): ...
    @clipvalue.setter
    def clipvalue(self, val) -> None: ...
    def minimize(self, loss, var_list, grad_loss: Any | None = ..., name: Any | None = ..., tape: Any | None = ...): ...
    def apply_gradients(self, grads_and_vars, name: Any | None = ..., experimental_aggregate_gradients: bool = ...): ...
    def get_gradients(self, loss, params): ...
    def get_updates(self, loss, params): ...
    def __getattribute__(self, name): ...
    def __dir__(self): ...
    def __setattr__(self, name, value) -> None: ...
    def get_slot_names(self): ...
    def add_slot(self, var, slot_name, initializer: str = ..., shape: Any | None = ...): ...
    def get_slot(self, var, slot_name): ...
    @property
    def iterations(self): ...
    @iterations.setter
    def iterations(self, variable) -> None: ...
    @abc.abstractmethod
    def get_config(self): ...
    @classmethod
    def from_config(cls, config, custom_objects: Any | None = ...): ...
    def variables(self): ...
    @property
    def weights(self): ...
    def get_weights(self): ...
    def set_weights(self, weights) -> None: ...
    def add_weight(self, name, shape, dtype: Any | None = ..., initializer: str = ..., trainable: Any | None = ..., synchronization=..., aggregation=...): ...

class RestoredOptimizer(OptimizerV2):
    def __init__(self) -> None: ...
    def get_config(self) -> None: ...
