import tensorflow.compat.v2 as tf
from keras.utils import object_identity as object_identity
from typing import Any

class KerasTensor:
    def __init__(self, type_spec, inferred_value: Any | None = ..., name: Any | None = ...) -> None: ...
    @property
    def type_spec(self): ...
    @property
    def shape(self): ...
    @classmethod
    def from_tensor(cls, tensor): ...
    @classmethod
    def from_type_spec(cls, type_spec, name: Any | None = ...): ...
    def get_shape(self): ...
    def __len__(self) -> None: ...
    @property
    def op(self) -> None: ...
    def __hash__(self): ...
    __array_priority__: int
    def __array__(self, dtype: Any | None = ...) -> None: ...
    @property
    def is_tensor_like(self): ...
    def set_shape(self, shape) -> None: ...
    @property
    def dtype(self): ...
    def ref(self): ...
    @property
    def node(self): ...
    def __iter__(self): ...
    @property
    def name(self): ...

class SparseKerasTensor(KerasTensor): ...

class RaggedKerasTensor(KerasTensor):
    @property
    def ragged_rank(self): ...

class UserRegisteredSpec(tf.TypeSpec):
    shape: Any
    dtype: Any
    def __init__(self, shape, dtype) -> None: ...
    def value_type(self) -> None: ...

class UserRegisteredTypeKerasTensor(KerasTensor):
    def __init__(self, user_registered_symbolic_object) -> None: ...
    @classmethod
    def from_tensor(cls, tensor): ...
    @classmethod
    def from_type_spec(cls, type_spec, name: Any | None = ...) -> None: ...

class _KerasTensorIterator:
    def __init__(self, tensor, dim0) -> None: ...
    def __iter__(self): ...
    def __next__(self): ...

keras_tensor_classes: Any

def register_keras_tensor_specialization(cls, keras_tensor_subclass) -> None: ...
def keras_tensor_to_placeholder(x): ...
def keras_tensor_from_tensor(tensor): ...
def keras_tensor_from_type_spec(type_spec, name: Any | None = ...): ...
def type_spec_with_shape(spec, shape): ...
