import keras
import tensorflow.compat.v2 as tf
from absl.testing import parameterized
from keras import losses as losses
from keras.distribute import distributed_training_utils_v1 as distributed_training_utils_v1, optimizer_combinations as optimizer_combinations
from typing import Any

class Counter(keras.callbacks.Callback):
    method_counts: Any
    def __init__(self) -> None: ...
    def wrap_with_counts(self, method_name, method): ...

class TestDistributionStrategyWithCallbacks(tf.test.TestCase, parameterized.TestCase):
    def test_callbacks_in_fit(self, distribution) -> None: ...
    def test_callbacks_in_eval(self, distribution) -> None: ...
    def test_callbacks_in_predict(self, distribution) -> None: ...

class TestDistributionStrategyErrorCases(tf.test.TestCase, parameterized.TestCase):
    def test_validating_dataset_input_tensors_with_shape_mismatch(self, distribution) -> None: ...
    def test_validating_dataset_input_tensors_with_dtype_mismatch(self, distribution) -> None: ...
    def test_unsupported_features(self, distribution, mode) -> None: ...
    dense: Any
    def test_distribution_strategy_on_subclassed_model(self, distribution): ...
    def test_distribution_strategy_on_deferred_sequential_model(self, distribution) -> None: ...
    def test_standalone_loss_without_loss_reduction(self, distribution) -> None: ...

class TestDistributionStrategyWithLossMasking(tf.test.TestCase, parameterized.TestCase):
    def test_masking(self, distribution, optimizer) -> None: ...

class TestDistributionStrategyWithNormalizationLayer(tf.test.TestCase, parameterized.TestCase):
    def test_batchnorm_correctness(self, distribution, fused, optimizer) -> None: ...
    def test_batchnorm_correctness_with_renorm(self, distribution, optimizer) -> None: ...

class TestDistributionStrategySaveLoadWeights(tf.test.TestCase, parameterized.TestCase):
    def test_save_load_h5(self, distribution, optimizer) -> None: ...
    def test_save_load_trackable(self, distribution, optimizer) -> None: ...

class TestDistributionStrategyValidation(tf.test.TestCase, parameterized.TestCase):
    def test_layer_outside_scope(self, distribution) -> None: ...
    def test_model_outside_scope(self, distribution) -> None: ...

class TestDistributionStrategyWithStaticShapes(tf.test.TestCase, parameterized.TestCase):
    def test_input_batch_size_not_divisible_by_num_replicas(self, distribution) -> None: ...
    def test_static_input_batch_size(self, distribution) -> None: ...
