import keras
import tensorflow.compat.v2 as tf
from absl.testing import parameterized
from keras import backend as backend, testing_utils as testing_utils
from keras.distribute import distributed_training_utils as distributed_training_utils, distributed_training_utils_v1 as distributed_training_utils_v1, multi_worker_testing_utils as multi_worker_testing_utils, optimizer_combinations as optimizer_combinations
from keras.distribute.strategy_combinations import all_strategies as all_strategies, multi_worker_mirrored_strategies as multi_worker_mirrored_strategies, strategies_minus_default_minus_tpu as strategies_minus_default_minus_tpu, strategies_minus_tpu as strategies_minus_tpu, tpu_strategies as tpu_strategies
from keras.engine import base_layer_utils as base_layer_utils
from keras.mixed_precision import policy as policy
from keras.utils import losses_utils as losses_utils, np_utils as np_utils
from typing import Any

def simple_sequential_model(): ...
def simple_subclassed_model(num_labels=...): ...
def simple_multi_inputs_multi_outputs_model(): ...
def get_multi_inputs_multi_outputs_data(): ...
def batch_wrapper(dataset, batch_size, distribution, repeat: Any | None = ...): ...
def get_model(): ...
def get_sample_weights_model(): ...
def get_dataset(distribution): ...
def get_predict_dataset(distribution): ...
def convert_numpy_to_dataset_with_unknown_cardinality(inputs, targets: Any | None = ...): ...
def multi_input_output_model(): ...
def strategy_minus_tpu_combinations(): ...
def tpu_strategy_combinations(): ...
def tpu_strategy_combinations_graph_only(): ...
def multi_worker_strategy_combinations_eager_only(): ...
def all_strategy_combinations(): ...
def all_strategy_minus_default_and_tpu_combinations(): ...
def all_strategy_combinations_minus_default(): ...
def strategy_and_optimizer_combinations(): ...

class BatchCountingCB(keras.callbacks.Callback):
    train_begin_batches: Any
    train_end_batches: Any
    test_begin_batches: Any
    test_end_batches: Any
    predict_begin_batches: Any
    predict_end_batches: Any
    def __init__(self) -> None: ...
    def on_train_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_train_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_test_batch_end(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_begin(self, batch, logs: Any | None = ...) -> None: ...
    def on_predict_batch_end(self, batch, logs: Any | None = ...) -> None: ...

class TestDistributionStrategyWithNumpyArrays(tf.test.TestCase, parameterized.TestCase):
    def test_calculating_input_params_no_steps_no_batch_size(self, distribution) -> None: ...
    def test_calculating_input_params_with_steps_no_batch_size(self, distribution) -> None: ...
    def test_calculating_input_params_no_steps_with_batch_size(self, distribution) -> None: ...
    def test_calculating_input_params_with_steps_with_batch_size(self, distribution) -> None: ...
    def test_calling_model_with_numpy_arrays(self, distribution) -> None: ...
    def test_calling_model_with_mixed_precision(self, distribution) -> None: ...
    v1: Any
    v2: Any
    def test_operator_overload_mixed_precision(self, distribution): ...
    def test_optimizer_in_cross_replica_context_raises_error(self, distribution) -> None: ...
    def test_calling_model_with_nested_numpy_arrays(self, distribution) -> None: ...
    def test_numpy_with_sample_weights(self, distribution) -> None: ...
    def test_flatten_predict_outputs(self, distribution) -> None: ...
    def test_evaluate_with_partial_batch(self, distribution, batch_size) -> None: ...
    def test_predict_with_partial_batch(self, distribution) -> None: ...
    def test_no_target_model(self, distribution): ...
    def test_predict_multi_output_model_with_partial_batch(self, distribution) -> None: ...
    extra_weight_1: Any
    extra_weight_2: Any
    def test_gradients_are_none(self, distribution) -> None: ...

class TestDistributionStrategyWithDatasets(tf.test.TestCase, parameterized.TestCase):
    def test_calling_model_on_same_dataset(self, distribution) -> None: ...
    def test_model_interleaved_eval_same_as_direct_eval(self, distribution) -> None: ...
    def test_fit_with_tuple_and_dict_dataset_inputs(self, distribution) -> None: ...
    def test_fit_with_dictionary_in_the_dataset_b135161171(self, distribution): ...
    def test_fit_eval_and_predict_methods_on_dataset_without_steps(self, distribution) -> None: ...
    def test_predict_on_dataset_with_unknown_cardinality_without_steps(self, distribution, mode) -> None: ...
    def test_on_dataset_with_unknown_cardinality_without_steps(self, distribution, mode) -> None: ...
    def test_on_dataset_with_unknown_cardinality(self, distribution) -> None: ...
    def test_fit_eval_and_predict_methods_on_dataset(self, distribution) -> None: ...
    def test_fit_eval_and_predict_with_optimizer(self, distribution, optimizer) -> None: ...
    def test_dataset_wrong_input_shape(self, distribution, mode) -> None: ...
    def test_dataset_external_batch_input_validation(self, distribution) -> None: ...
    def test_learning_phase_value(self, distribution) -> None: ...
    def testOptimizerWithCallbacks(self, distribution): ...
    def test_evaluate_with_dataset_with_partial_batch(self, distribution, batch_size) -> None: ...
    def test_predict_with_dataset_with_partial_batch(self, distribution) -> None: ...
    def test_predict_multi_output_model_with_dataset_with_partial_batch(self, distribution) -> None: ...
    def test_match_model_input_matches_with_dataset_tensors(self, distribution): ...
    def test_dataset_with_sample_weights(self, distribution) -> None: ...

class TestDistributionStrategyWithDatasetsFile(tf.test.TestCase, parameterized.TestCase):
    input_file_name: Any
    def setUp(self) -> None: ...
    def test_predict_on_dataset_shard_options_file_multi_worker_mirrored(self, distribution, mode): ...

class TestRegularizerLoss(tf.test.TestCase, parameterized.TestCase):
    class IdentityRegularizer(keras.regularizers.Regularizer):
        def __call__(self, x): ...
    class AddLayer(keras.layers.Layer):
        v: Any
        def build(self, _) -> None: ...
        def call(self, inputs): ...
    @staticmethod
    def loss_fn(_, y_pred): ...
    def test_regularizer_loss(self, distribution) -> None: ...

class TestDistributionStrategyWithKerasModels(tf.test.TestCase, parameterized.TestCase):
    def test_distribution_strategy_on_sequential_model(self, distribution) -> None: ...
    def test_distribution_strategy_on_functional_model(self, distribution) -> None: ...
    epochs: int
    train_batches: int
    test_batches: int
    def test_distributed_dataset(self, distribution) -> None: ...
    def test_distributed_datasets_from_function(self, distribution): ...
    def test_host_training_loop(self, distribution) -> None: ...
    def test_host_training_loop_last_partial_execution(self, distribution) -> None: ...
    def test_host_training_loop_dataset_unknown_size(self, distribution): ...
    def test_host_training_loop_truncate_to_epoch(self, distribution) -> None: ...
    v1: Any
    v2: Any
    def test_gradient_clipping(self, distribution): ...
    def test_custom_gradient_transformation(self, distribution): ...
    def test_distribution_strategy_one_dimensional(self, distribution) -> None: ...
    def test_distribution_strategy_with_loss_reduction_types(self, distribution, reduction): ...
    def test_distribution_strategy_with_symbolic_add_loss(self, mode, distribution): ...
    def DISABLED_test_distribution_strategy_with_callable_add_loss(self, distribution): ...
    bias: Any
    def test_distribution_strategy_with_add_metric_in_call(self, distribution): ...
    mean: Any
    def test_distribution_strategy_with_add_metric_object(self, distribution): ...
    def test_distribution_strategy_with_add_metric_outside_call(self, distribution): ...
    def test_sparse_tensor_outputs(self, distribution): ...
    def test_ragged_tensor_outputs(self, distribution): ...
    def test_correctness_of_add_loss_with_merge_call(self, distribution): ...
    def test_unimplemented_parameter_server_strategy(self) -> None: ...

class TestDistributionStrategyWithMultipleAddLossAndMetricCalls(tf.test.TestCase, parameterized.TestCase):
    def test_fit_and_evaluate(self, distribution, model_fn, l1, l2) -> None: ...

class DeterministicModel(keras.Model):
    x: Any
    strategy: Any
    def __init__(self, strategy) -> None: ...
    def build(self, input_shape) -> None: ...
    def call(self, inputs, training: Any | None = ..., mask: Any | None = ...): ...

class TestModelCapturesStrategy(tf.test.TestCase, parameterized.TestCase):
    def test_fit_and_evaluate(self, distribution) -> None: ...
    def test_optimizer(self, distribution): ...
