# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>gc</b></li>
# <li><b>keras</b></li>
# <li><b>matplotlib</b></li>
# <li><b>numpy</b></li>
# <li><b>os</b></li>
# <li><b>pandas</b></li>
# <li><b>sklearn</b></li>
# <li><b>tensorflow</b></li>
# <li><b>warnings</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Visualization</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Visualization" Calls</u></b></summary>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['--'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Epochs'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlim</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[0]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Get or set the x limits of the current axes.
#
# Call signatures::
#
#     left, right = xlim()  # return the current xlim
#     xlim((left, right))   # set the xlim to left, right
#     xlim(left, right)     # set the xlim to left, right
#
# If you do not specify args, you can pass *left* or *right* as kwargs,
# i.e.::
#
#     xlim(right=3)  # adjust the right leaving left unchanged
#     xlim(left=1)  # adjust the left leaving right unchanged
#
# Setting limits turns autoscaling off for the x-axis.
#
# Returns
# -------
# left, right
#     A tuple of the new x-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``xlim()``) is the pyplot
# equivalent of calling `~.Axes.get_xlim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_xlim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylim</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[0, 0.4]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Get or set the y-limits of the current axes.
#
# Call signatures::
#
#     bottom, top = ylim()  # return the current ylim
#     ylim((bottom, top))   # set the ylim to bottom, top
#     ylim(bottom, top)     # set the ylim to bottom, top
#
# If you do not specify args, you can alternatively pass *bottom* or
# *top* as kwargs, i.e.::
#
#     ylim(top=3)  # adjust the top leaving bottom unchanged
#     ylim(bottom=1)  # adjust the bottom leaving top unchanged
#
# Setting limits turns autoscaling off for the y-axis.
#
# Returns
# -------
# bottom, top
#     A tuple of the new y-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``ylim()``) is the pyplot
# equivalent of calling `~.Axes.get_ylim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_ylim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['--'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Epochs'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlim</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[0]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Get or set the x limits of the current axes.
#
# Call signatures::
#
#     left, right = xlim()  # return the current xlim
#     xlim((left, right))   # set the xlim to left, right
#     xlim(left, right)     # set the xlim to left, right
#
# If you do not specify args, you can pass *left* or *right* as kwargs,
# i.e.::
#
#     xlim(right=3)  # adjust the right leaving left unchanged
#     xlim(left=1)  # adjust the left leaving right unchanged
#
# Setting limits turns autoscaling off for the x-axis.
#
# Returns
# -------
# left, right
#     A tuple of the new x-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``xlim()``) is the pyplot
# equivalent of calling `~.Axes.get_xlim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_xlim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylim</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[0, 0.4]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Get or set the y-limits of the current axes.
#
# Call signatures::
#
#     bottom, top = ylim()  # return the current ylim
#     ylim((bottom, top))   # set the ylim to bottom, top
#     ylim(bottom, top)     # set the ylim to bottom, top
#
# If you do not specify args, you can alternatively pass *bottom* or
# *top* as kwargs, i.e.::
#
#     ylim(top=3)  # adjust the top leaving bottom unchanged
#     ylim(bottom=1)  # adjust the bottom leaving top unchanged
#
# Setting limits turns autoscaling off for the y-axis.
#
# Returns
# -------
# bottom, top
#     A tuple of the new y-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``ylim()``) is the pyplot
# equivalent of calling `~.Axes.get_ylim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_ylim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.min</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the minimum of the values over the requested axis.
#
# If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.min()
# 0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.append</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Append rows of `other` to the end of caller, returning a new object.
#
# .. deprecated:: 1.4.0
#     Use :func:`concat` instead. For further details see
#     :ref:`whatsnew_140.deprecations.frame_series_append`
#
# Columns in `other` that are not in the caller are added as new columns.
#
# Parameters
# ----------
# other : DataFrame or Series/dict-like object, or list of these
#     The data to append.
# ignore_index : bool, default False
#     If True, the resulting axis will be labeled 0, 1, …, n - 1.
# verify_integrity : bool, default False
#     If True, raise ValueError on creating index with duplicates.
# sort : bool, default False
#     Sort columns if the columns of `self` and `other` are not aligned.
#
#     .. versionchanged:: 1.0.0
#
#         Changed to not sort by default.
#
# Returns
# -------
# DataFrame
#     A new DataFrame consisting of the rows of caller and the rows of `other`.
#
# See Also
# --------
# concat : General function to concatenate DataFrame or Series objects.
#
# Notes
# -----
# If a list of dict/series is passed and the keys are all contained in
# the DataFrame's index, the order of the columns in the resulting
# DataFrame will be unchanged.
#
# Iteratively appending rows to a DataFrame can be more computationally
# intensive than a single concatenate. A better solution is to append
# those rows to a list and then concatenate the list with the original
# DataFrame all at once.
#
# Examples
# --------
# >>> df = pd.DataFrame([[1, 2], [3, 4]], columns=list('AB'), index=['x', 'y'])
# >>> df
#    A  B
# x  1  2
# y  3  4
# >>> df2 = pd.DataFrame([[5, 6], [7, 8]], columns=list('AB'), index=['x', 'y'])
# >>> df.append(df2)
#    A  B
# x  1  2
# y  3  4
# x  5  6
# y  7  8
#
# With `ignore_index` set to True:
#
# >>> df.append(df2, ignore_index=True)
#    A  B
# 0  1  2
# 1  3  4
# 2  5  6
# 3  7  8
#
# The following, while not recommended methods for generating DataFrames,
# show two ways to generate a DataFrame from multiple data sources.
#
# Less efficient:
#
# >>> df = pd.DataFrame(columns=['A'])
# >>> for i in range(5):
# ...     df = df.append({'A': i}, ignore_index=True)
# >>> df
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# More efficient:
#
# >>> pd.concat([pd.DataFrame([i], columns=['A']) for i in range(5)],
# ...           ignore_index=True)
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.notnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Series.notnull is an alias for Series.notna.
#
# Detect existing (non-missing) values.
#
# Return a boolean same-sized object indicating if the values are not NA.
# Non-missing values get mapped to True. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
# NA values, such as None or :attr:`numpy.NaN`, get mapped to False
# values.
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is not an NA value.
#
# See Also
# --------
# Series.notnull : Alias of notna.
# Series.isna : Boolean inverse of notna.
# Series.dropna : Omit axes labels with missing values.
# notna : Top-level notna.
#
# Examples
# --------
# Show which entries in a DataFrame are not NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.notna()
#      age   born  name    toy
# 0   True  False  True  False
# 1   True   True  True   True
# 2  False   True  True   True
#
# Show which entries in a Series are not NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.notna()
# 0     True
# 1     True
# 2    False
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.fit</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the mean and std to be used for later scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix} of shape (n_samples, n_features)
#     The data used to compute the mean and standard deviation
#     used for later scaling along the features axis.
#
# y : None
#     Ignored.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Individual weights for each sample.
#
#     .. versionadded:: 0.24
#        parameter *sample_weight* support to StandardScaler.
#
# Returns
# -------
# self : object
#     Fitted scaler.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.array</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# array(object, dtype=None, *, copy=True, order='K', subok=False, ndmin=0,
#       like=None)
#
# Create an array.
#
# Parameters
# ----------
# object : array_like
#     An array, any object exposing the array interface, an object whose
#     __array__ method returns an array, or any (nested) sequence.
#     If object is a scalar, a 0-dimensional array containing object is
#     returned.
# dtype : data-type, optional
#     The desired data-type for the array.  If not given, then the type will
#     be determined as the minimum type required to hold the objects in the
#     sequence.
# copy : bool, optional
#     If true (default), then the object is copied.  Otherwise, a copy will
#     only be made if __array__ returns a copy, if obj is a nested sequence,
#     or if a copy is needed to satisfy any of the other requirements
#     (`dtype`, `order`, etc.).
# order : {'K', 'A', 'C', 'F'}, optional
#     Specify the memory layout of the array. If object is not an array, the
#     newly created array will be in C order (row major) unless 'F' is
#     specified, in which case it will be in Fortran order (column major).
#     If object is an array the following holds.
#
#     ===== ========= ===================================================
#     order  no copy                     copy=True
#     ===== ========= ===================================================
#     'K'   unchanged F & C order preserved, otherwise most similar order
#     'A'   unchanged F order if input is F and not C, otherwise C order
#     'C'   C order   C order
#     'F'   F order   F order
#     ===== ========= ===================================================
#
#     When ``copy=False`` and a copy is made for other reasons, the result is
#     the same as if ``copy=True``, with some exceptions for 'A', see the
#     Notes section. The default order is 'K'.
# subok : bool, optional
#     If True, then sub-classes will be passed-through, otherwise
#     the returned array will be forced to be a base-class array (default).
# ndmin : int, optional
#     Specifies the minimum number of dimensions that the resulting
#     array should have.  Ones will be pre-pended to the shape as
#     needed to meet this requirement.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     An array object satisfying the specified requirements.
#
# See Also
# --------
# empty_like : Return an empty array with shape and type of input.
# ones_like : Return an array of ones with shape and type of input.
# zeros_like : Return an array of zeros with shape and type of input.
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Notes
# -----
# When order is 'A' and `object` is an array in neither 'C' nor 'F' order,
# and a copy is forced by a change in dtype, then the order of the result is
# not necessarily 'C' as expected. This is likely a bug.
#
# Examples
# --------
# >>> np.array([1, 2, 3])
# array([1, 2, 3])
#
# Upcasting:
#
# >>> np.array([1, 2, 3.0])
# array([ 1.,  2.,  3.])
#
# More than one dimension:
#
# >>> np.array([[1, 2], [3, 4]])
# array([[1, 2],
#        [3, 4]])
#
# Minimum dimensions 2:
#
# >>> np.array([1, 2, 3], ndmin=2)
# array([[1, 2, 3]])
#
# Type provided:
#
# >>> np.array([1, 2, 3], dtype=complex)
# array([ 1.+0.j,  2.+0.j,  3.+0.j])
#
# Data-type consisting of more than one element:
#
# >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
# >>> x['a']
# array([1, 3])
#
# Creating an array from sub-classes:
#
# >>> np.array(np.mat('1 2; 3 4'))
# array([[1, 2],
#        [3, 4]])
#
# >>> np.array(np.mat('1 2; 3 4'), subok=True)
# matrix([[1, 2],
#         [3, 4]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.std</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the standard deviation along the specified axis.
#
# Returns the standard deviation, a measure of the spread of a distribution,
# of the array elements. The standard deviation is computed for the
# flattened array by default, otherwise over the specified axis.
#
# Parameters
# ----------
# a : array_like
#     Calculate the standard deviation of these values.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the standard deviation is computed. The
#     default is to compute the standard deviation of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a standard deviation is performed over
#     multiple axes, instead of a single axis or all the axes as before.
# dtype : dtype, optional
#     Type to use in computing the standard deviation. For arrays of
#     integer type the default is float64, for arrays of float types it is
#     the same as the array type.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output but the type (of the calculated
#     values) will be cast if necessary.
# ddof : int, optional
#     Means Delta Degrees of Freedom.  The divisor used in calculations
#     is ``N - ddof``, where ``N`` represents the number of elements.
#     By default `ddof` is zero.
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `std` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the standard deviation.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# standard_deviation : ndarray, see dtype parameter above.
#     If `out` is None, return a new array containing the standard deviation,
#     otherwise return a reference to the output array.
#
# See Also
# --------
# var, mean, nanmean, nanstd, nanvar
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# The standard deviation is the square root of the average of the squared
# deviations from the mean, i.e., ``std = sqrt(mean(x))``, where
# ``x = abs(a - a.mean())**2``.
#
# The average squared deviation is typically calculated as ``x.sum() / N``,
# where ``N = len(x)``. If, however, `ddof` is specified, the divisor
# ``N - ddof`` is used instead. In standard statistical practice, ``ddof=1``
# provides an unbiased estimator of the variance of the infinite population.
# ``ddof=0`` provides a maximum likelihood estimate of the variance for
# normally distributed variables. The standard deviation computed in this
# function is the square root of the estimated variance, so even with
# ``ddof=1``, it will not be an unbiased estimate of the standard deviation
# per se.
#
# Note that, for complex numbers, `std` takes the absolute
# value before squaring, so that the result is always real and nonnegative.
#
# For floating-point input, the *std* is computed using the same
# precision the input has. Depending on the input data, this can cause
# the results to be inaccurate, especially for float32 (see example below).
# Specifying a higher-accuracy accumulator using the `dtype` keyword can
# alleviate this issue.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.std(a)
# 1.1180339887498949 # may vary
# >>> np.std(a, axis=0)
# array([1.,  1.])
# >>> np.std(a, axis=1)
# array([0.5,  0.5])
#
# In single precision, std() can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.std(a)
# 0.45000005
#
# Computing the standard deviation in float64 is more accurate:
#
# >>> np.std(a, dtype=np.float64)
# 0.44999999925494177 # may vary
#
# Specifying a where argument:
#
# >>> a = np.array([[14, 8, 11, 10], [7, 9, 10, 11], [10, 15, 5, 10]])
# >>> np.std(a)
# 2.614064523559687 # may vary
# >>> np.std(a, where=[[True], [True], [False]])
# 2.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.min</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Return the minimum of the values over the requested axis.
#
# If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.min()
# 0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'drop': True}</li></ul>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.append</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Append rows of `other` to the end of caller, returning a new object.
#
# .. deprecated:: 1.4.0
#     Use :func:`concat` instead. For further details see
#     :ref:`whatsnew_140.deprecations.frame_series_append`
#
# Columns in `other` that are not in the caller are added as new columns.
#
# Parameters
# ----------
# other : DataFrame or Series/dict-like object, or list of these
#     The data to append.
# ignore_index : bool, default False
#     If True, the resulting axis will be labeled 0, 1, …, n - 1.
# verify_integrity : bool, default False
#     If True, raise ValueError on creating index with duplicates.
# sort : bool, default False
#     Sort columns if the columns of `self` and `other` are not aligned.
#
#     .. versionchanged:: 1.0.0
#
#         Changed to not sort by default.
#
# Returns
# -------
# DataFrame
#     A new DataFrame consisting of the rows of caller and the rows of `other`.
#
# See Also
# --------
# concat : General function to concatenate DataFrame or Series objects.
#
# Notes
# -----
# If a list of dict/series is passed and the keys are all contained in
# the DataFrame's index, the order of the columns in the resulting
# DataFrame will be unchanged.
#
# Iteratively appending rows to a DataFrame can be more computationally
# intensive than a single concatenate. A better solution is to append
# those rows to a list and then concatenate the list with the original
# DataFrame all at once.
#
# Examples
# --------
# >>> df = pd.DataFrame([[1, 2], [3, 4]], columns=list('AB'), index=['x', 'y'])
# >>> df
#    A  B
# x  1  2
# y  3  4
# >>> df2 = pd.DataFrame([[5, 6], [7, 8]], columns=list('AB'), index=['x', 'y'])
# >>> df.append(df2)
#    A  B
# x  1  2
# y  3  4
# x  5  6
# y  7  8
#
# With `ignore_index` set to True:
#
# >>> df.append(df2, ignore_index=True)
#    A  B
# 0  1  2
# 1  3  4
# 2  5  6
# 3  7  8
#
# The following, while not recommended methods for generating DataFrames,
# show two ways to generate a DataFrame from multiple data sources.
#
# Less efficient:
#
# >>> df = pd.DataFrame(columns=['A'])
# >>> for i in range(5):
# ...     df = df.append({'A': i}, ignore_index=True)
# >>> df
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# More efficient:
#
# >>> pd.concat([pd.DataFrame([i], columns=['A']) for i in range(5)],
# ...           ignore_index=True)
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.notnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Series.notnull is an alias for Series.notna.
#
# Detect existing (non-missing) values.
#
# Return a boolean same-sized object indicating if the values are not NA.
# Non-missing values get mapped to True. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
# NA values, such as None or :attr:`numpy.NaN`, get mapped to False
# values.
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is not an NA value.
#
# See Also
# --------
# Series.notnull : Alias of notna.
# Series.isna : Boolean inverse of notna.
# Series.dropna : Omit axes labels with missing values.
# notna : Top-level notna.
#
# Examples
# --------
# Show which entries in a DataFrame are not NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.notna()
#      age   born  name    toy
# 0   True  False  True  False
# 1   True   True  True   True
# 2  False   True  True   True
#
# Show which entries in a Series are not NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.notna()
# 0     True
# 1     True
# 2    False
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 11</u></h3></summary><small><a href=#11>goto cell # 11</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.fit</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the mean and std to be used for later scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix} of shape (n_samples, n_features)
#     The data used to compute the mean and standard deviation
#     used for later scaling along the features axis.
#
# y : None
#     Ignored.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Individual weights for each sample.
#
#     .. versionadded:: 0.24
#        parameter *sample_weight* support to StandardScaler.
#
# Returns
# -------
# self : object
#     Fitted scaler.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.array</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# array(object, dtype=None, *, copy=True, order='K', subok=False, ndmin=0,
#       like=None)
#
# Create an array.
#
# Parameters
# ----------
# object : array_like
#     An array, any object exposing the array interface, an object whose
#     __array__ method returns an array, or any (nested) sequence.
#     If object is a scalar, a 0-dimensional array containing object is
#     returned.
# dtype : data-type, optional
#     The desired data-type for the array.  If not given, then the type will
#     be determined as the minimum type required to hold the objects in the
#     sequence.
# copy : bool, optional
#     If true (default), then the object is copied.  Otherwise, a copy will
#     only be made if __array__ returns a copy, if obj is a nested sequence,
#     or if a copy is needed to satisfy any of the other requirements
#     (`dtype`, `order`, etc.).
# order : {'K', 'A', 'C', 'F'}, optional
#     Specify the memory layout of the array. If object is not an array, the
#     newly created array will be in C order (row major) unless 'F' is
#     specified, in which case it will be in Fortran order (column major).
#     If object is an array the following holds.
#
#     ===== ========= ===================================================
#     order  no copy                     copy=True
#     ===== ========= ===================================================
#     'K'   unchanged F & C order preserved, otherwise most similar order
#     'A'   unchanged F order if input is F and not C, otherwise C order
#     'C'   C order   C order
#     'F'   F order   F order
#     ===== ========= ===================================================
#
#     When ``copy=False`` and a copy is made for other reasons, the result is
#     the same as if ``copy=True``, with some exceptions for 'A', see the
#     Notes section. The default order is 'K'.
# subok : bool, optional
#     If True, then sub-classes will be passed-through, otherwise
#     the returned array will be forced to be a base-class array (default).
# ndmin : int, optional
#     Specifies the minimum number of dimensions that the resulting
#     array should have.  Ones will be pre-pended to the shape as
#     needed to meet this requirement.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     An array object satisfying the specified requirements.
#
# See Also
# --------
# empty_like : Return an empty array with shape and type of input.
# ones_like : Return an array of ones with shape and type of input.
# zeros_like : Return an array of zeros with shape and type of input.
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Notes
# -----
# When order is 'A' and `object` is an array in neither 'C' nor 'F' order,
# and a copy is forced by a change in dtype, then the order of the result is
# not necessarily 'C' as expected. This is likely a bug.
#
# Examples
# --------
# >>> np.array([1, 2, 3])
# array([1, 2, 3])
#
# Upcasting:
#
# >>> np.array([1, 2, 3.0])
# array([ 1.,  2.,  3.])
#
# More than one dimension:
#
# >>> np.array([[1, 2], [3, 4]])
# array([[1, 2],
#        [3, 4]])
#
# Minimum dimensions 2:
#
# >>> np.array([1, 2, 3], ndmin=2)
# array([[1, 2, 3]])
#
# Type provided:
#
# >>> np.array([1, 2, 3], dtype=complex)
# array([ 1.+0.j,  2.+0.j,  3.+0.j])
#
# Data-type consisting of more than one element:
#
# >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
# >>> x['a']
# array([1, 3])
#
# Creating an array from sub-classes:
#
# >>> np.array(np.mat('1 2; 3 4'))
# array([[1, 2],
#        [3, 4]])
#
# >>> np.array(np.mat('1 2; 3 4'), subok=True)
# matrix([[1, 2],
#         [3, 4]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 13</u></h3></summary><small><a href=#13>goto cell # 13</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.array</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# array(object, dtype=None, *, copy=True, order='K', subok=False, ndmin=0,
#       like=None)
#
# Create an array.
#
# Parameters
# ----------
# object : array_like
#     An array, any object exposing the array interface, an object whose
#     __array__ method returns an array, or any (nested) sequence.
#     If object is a scalar, a 0-dimensional array containing object is
#     returned.
# dtype : data-type, optional
#     The desired data-type for the array.  If not given, then the type will
#     be determined as the minimum type required to hold the objects in the
#     sequence.
# copy : bool, optional
#     If true (default), then the object is copied.  Otherwise, a copy will
#     only be made if __array__ returns a copy, if obj is a nested sequence,
#     or if a copy is needed to satisfy any of the other requirements
#     (`dtype`, `order`, etc.).
# order : {'K', 'A', 'C', 'F'}, optional
#     Specify the memory layout of the array. If object is not an array, the
#     newly created array will be in C order (row major) unless 'F' is
#     specified, in which case it will be in Fortran order (column major).
#     If object is an array the following holds.
#
#     ===== ========= ===================================================
#     order  no copy                     copy=True
#     ===== ========= ===================================================
#     'K'   unchanged F & C order preserved, otherwise most similar order
#     'A'   unchanged F order if input is F and not C, otherwise C order
#     'C'   C order   C order
#     'F'   F order   F order
#     ===== ========= ===================================================
#
#     When ``copy=False`` and a copy is made for other reasons, the result is
#     the same as if ``copy=True``, with some exceptions for 'A', see the
#     Notes section. The default order is 'K'.
# subok : bool, optional
#     If True, then sub-classes will be passed-through, otherwise
#     the returned array will be forced to be a base-class array (default).
# ndmin : int, optional
#     Specifies the minimum number of dimensions that the resulting
#     array should have.  Ones will be pre-pended to the shape as
#     needed to meet this requirement.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     An array object satisfying the specified requirements.
#
# See Also
# --------
# empty_like : Return an empty array with shape and type of input.
# ones_like : Return an array of ones with shape and type of input.
# zeros_like : Return an array of zeros with shape and type of input.
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Notes
# -----
# When order is 'A' and `object` is an array in neither 'C' nor 'F' order,
# and a copy is forced by a change in dtype, then the order of the result is
# not necessarily 'C' as expected. This is likely a bug.
#
# Examples
# --------
# >>> np.array([1, 2, 3])
# array([1, 2, 3])
#
# Upcasting:
#
# >>> np.array([1, 2, 3.0])
# array([ 1.,  2.,  3.])
#
# More than one dimension:
#
# >>> np.array([[1, 2], [3, 4]])
# array([[1, 2],
#        [3, 4]])
#
# Minimum dimensions 2:
#
# >>> np.array([1, 2, 3], ndmin=2)
# array([[1, 2, 3]])
#
# Type provided:
#
# >>> np.array([1, 2, 3], dtype=complex)
# array([ 1.+0.j,  2.+0.j,  3.+0.j])
#
# Data-type consisting of more than one element:
#
# >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
# >>> x['a']
# array([1, 3])
#
# Creating an array from sub-classes:
#
# >>> np.array(np.mat('1 2; 3 4'))
# array([[1, 2],
#        [3, 4]])
#
# >>> np.array(np.mat('1 2; 3 4'), subok=True)
# matrix([[1, 2],
#         [3, 4]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 19</u></h3></summary><small><a href=#19>goto cell # 19</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.std</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the standard deviation along the specified axis.
#
# Returns the standard deviation, a measure of the spread of a distribution,
# of the array elements. The standard deviation is computed for the
# flattened array by default, otherwise over the specified axis.
#
# Parameters
# ----------
# a : array_like
#     Calculate the standard deviation of these values.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the standard deviation is computed. The
#     default is to compute the standard deviation of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a standard deviation is performed over
#     multiple axes, instead of a single axis or all the axes as before.
# dtype : dtype, optional
#     Type to use in computing the standard deviation. For arrays of
#     integer type the default is float64, for arrays of float types it is
#     the same as the array type.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output but the type (of the calculated
#     values) will be cast if necessary.
# ddof : int, optional
#     Means Delta Degrees of Freedom.  The divisor used in calculations
#     is ``N - ddof``, where ``N`` represents the number of elements.
#     By default `ddof` is zero.
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `std` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the standard deviation.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# standard_deviation : ndarray, see dtype parameter above.
#     If `out` is None, return a new array containing the standard deviation,
#     otherwise return a reference to the output array.
#
# See Also
# --------
# var, mean, nanmean, nanstd, nanvar
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# The standard deviation is the square root of the average of the squared
# deviations from the mean, i.e., ``std = sqrt(mean(x))``, where
# ``x = abs(a - a.mean())**2``.
#
# The average squared deviation is typically calculated as ``x.sum() / N``,
# where ``N = len(x)``. If, however, `ddof` is specified, the divisor
# ``N - ddof`` is used instead. In standard statistical practice, ``ddof=1``
# provides an unbiased estimator of the variance of the infinite population.
# ``ddof=0`` provides a maximum likelihood estimate of the variance for
# normally distributed variables. The standard deviation computed in this
# function is the square root of the estimated variance, so even with
# ``ddof=1``, it will not be an unbiased estimate of the standard deviation
# per se.
#
# Note that, for complex numbers, `std` takes the absolute
# value before squaring, so that the result is always real and nonnegative.
#
# For floating-point input, the *std* is computed using the same
# precision the input has. Depending on the input data, this can cause
# the results to be inaccurate, especially for float32 (see example below).
# Specifying a higher-accuracy accumulator using the `dtype` keyword can
# alleviate this issue.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.std(a)
# 1.1180339887498949 # may vary
# >>> np.std(a, axis=0)
# array([1.,  1.])
# >>> np.std(a, axis=1)
# array([0.5,  0.5])
#
# In single precision, std() can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.std(a)
# 0.45000005
#
# Computing the standard deviation in float64 is more accurate:
#
# >>> np.std(a, dtype=np.float64)
# 0.44999999925494177 # may vary
#
# Specifying a where argument:
#
# >>> a = np.array([[14, 8, 11, 10], [7, 9, 10, 11], [10, 15, 5, 10]])
# >>> np.std(a)
# 2.614064523559687 # may vary
# >>> np.std(a, where=[[True], [True], [False]])
# 2.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 20</u></h3></summary><small><a href=#20>goto cell # 20</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Series.isnull is an alias for Series.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# Series.isnull : Alias of isna.
# Series.notna : Boolean inverse of isna.
# Series.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Series.isnull is an alias for Series.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# Series.isnull : Alias of isna.
# Series.notna : Boolean inverse of isna.
# Series.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Sub-sampling and Train-test Splitting</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Sub-sampling and Train-test Splitting" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 16</u></h3></summary><small><a href=#16>goto cell # 16</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'shuffle': True}</li></ul>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.min</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the minimum of the values over the requested axis.
#
# If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.min()
# 0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.min</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Return the minimum of the values over the requested axis.
#
# If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.min()
# 0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 13</u></h3></summary><small><a href=#13>goto cell # 13</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Feature Selection</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.activation.Activation</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Applies an activation function to an output.
#
# Args:
#   activation: Activation function, such as `tf.nn.relu`, or string name of
#     built-in activation function, such as "relu".
#
# Usage:
#
# >>> layer = tf.keras.layers.Activation('relu')
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
# >>> layer = tf.keras.layers.Activation(tf.nn.relu)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.merge.concatenate</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Functional interface to the `Concatenate` layer.
#
# >>> x = np.arange(20).reshape(2, 2, 5)
# >>> print(x)
# [[[ 0  1  2  3  4]
#   [ 5  6  7  8  9]]
#  [[10 11 12 13 14]
#   [15 16 17 18 19]]]
# >>> y = np.arange(20, 30).reshape(2, 1, 5)
# >>> print(y)
# [[[20 21 22 23 24]]
#  [[25 26 27 28 29]]]
# >>> tf.keras.layers.concatenate([x, y],
# ...                             axis=1)
# <tf.Tensor: shape=(2, 3, 5), dtype=int64, numpy=
# array([[[ 0,  1,  2,  3,  4],
#       [ 5,  6,  7,  8,  9],
#       [20, 21, 22, 23, 24]],
#      [[10, 11, 12, 13, 14],
#       [15, 16, 17, 18, 19],
#       [25, 26, 27, 28, 29]]])>
#
# Args:
#     inputs: A list of input tensors (at least 2).
#     axis: Concatenation axis.
#     **kwargs: Standard layer keyword arguments.
#
# Returns:
#     A tensor, the concatenation of the inputs alongside axis `axis`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'name': 'base'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'name': 'noise1'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'name': 'noise2'}</li></ul>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.activation.Activation</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['relu'] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> ['relu'] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> ['relu'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies an activation function to an output.
#
# Args:
#   activation: Activation function, such as `tf.nn.relu`, or string name of
#     built-in activation function, such as "relu".
#
# Usage:
#
# >>> layer = tf.keras.layers.Activation('relu')
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
# >>> layer = tf.keras.layers.Activation(tf.nn.relu)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'name': 'base_last'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'name': 'nose1_last'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'name': 'nose2_last'}</li></ul>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.merge.concatenate</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Functional interface to the `Concatenate` layer.
#
# >>> x = np.arange(20).reshape(2, 2, 5)
# >>> print(x)
# [[[ 0  1  2  3  4]
#   [ 5  6  7  8  9]]
#  [[10 11 12 13 14]
#   [15 16 17 18 19]]]
# >>> y = np.arange(20, 30).reshape(2, 1, 5)
# >>> print(y)
# [[[20 21 22 23 24]]
#  [[25 26 27 28 29]]]
# >>> tf.keras.layers.concatenate([x, y],
# ...                             axis=1)
# <tf.Tensor: shape=(2, 3, 5), dtype=int64, numpy=
# array([[[ 0,  1,  2,  3,  4],
#       [ 5,  6,  7,  8,  9],
#       [20, 21, 22, 23, 24]],
#      [[10, 11, 12, 13, 14],
#       [15, 16, 17, 18, 19],
#       [25, 26, 27, 28, 29]]])>
#
# Args:
#     inputs: A list of input tensors (at least 2).
#     axis: Concatenation axis.
#     **kwargs: Standard layer keyword arguments.
#
# Returns:
#     A tensor, the concatenation of the inputs alongside axis `axis`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'inputs': []}</li></ul>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 19</u></h3></summary><small><a href=#19>goto cell # 19</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.backend</u></summary>
# <blockquote>
# <code>
# Keras backend API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.EarlyStopping</u></summary>
# <blockquote>
# <code>
# Stop training when a monitored metric has stopped improving.
#
# Assuming the goal of a training is to minimize the loss. With this, the
# metric to be monitored would be `'loss'`, and mode would be `'min'`. A
# `model.fit()` training loop will check at end of every epoch whether
# the loss is no longer decreasing, considering the `min_delta` and
# `patience` if applicable. Once it's found no longer decreasing,
# `model.stop_training` is marked True and the training terminates.
#
# The quantity to be monitored needs to be available in `logs` dict.
# To make it so, pass the loss or metrics at `model.compile()`.
#
# Args:
#   monitor: Quantity to be monitored.
#   min_delta: Minimum change in the monitored quantity
#       to qualify as an improvement, i.e. an absolute
#       change of less than min_delta, will count as no
#       improvement.
#   patience: Number of epochs with no improvement
#       after which training will be stopped.
#   verbose: verbosity mode.
#   mode: One of `{"auto", "min", "max"}`. In `min` mode,
#       training will stop when the quantity
#       monitored has stopped decreasing; in `"max"`
#       mode it will stop when the quantity
#       monitored has stopped increasing; in `"auto"`
#       mode, the direction is automatically inferred
#       from the name of the monitored quantity.
#   baseline: Baseline value for the monitored quantity.
#       Training will stop if the model doesn't show improvement over the
#       baseline.
#   restore_best_weights: Whether to restore model weights from
#       the epoch with the best value of the monitored quantity.
#       If False, the model weights obtained at the last step of
#       training are used. An epoch will be restored regardless
#       of the performance relative to the `baseline`. If no epoch
#       improves on `baseline`, training will run for `patience`
#       epochs and restore weights from the best epoch in that set.
#
# Example:
#
# >>> callback = tf.keras.callbacks.EarlyStopping(monitor='loss', patience=3)
# >>> # This callback will stop the training when there is no improvement in
# >>> # the loss for three consecutive epochs.
# >>> model = tf.keras.models.Sequential([tf.keras.layers.Dense(10)])
# >>> model.compile(tf.keras.optimizers.SGD(), loss='mse')
# >>> history = model.fit(np.arange(100).reshape(5, 20), np.zeros(5),
# ...                     epochs=10, batch_size=1, callbacks=[callback],
# ...                     verbose=0)
# >>> len(history.history['loss'])  # Only 4 epochs are run.
# 4
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.LearningRateScheduler</u></summary>
# <blockquote>
# <code>
# Learning rate scheduler.
#
# At the beginning of every epoch, this callback gets the updated learning rate
# value from `schedule` function provided at `__init__`, with the current epoch
# and current learning rate, and applies the updated learning rate
# on the optimizer.
#
# Args:
#   schedule: a function that takes an epoch index (integer, indexed from 0)
#       and current learning rate (float) as inputs and returns a new
#       learning rate as output (float).
#   verbose: int. 0: quiet, 1: update messages.
#
# Example:
#
# >>> # This function keeps the initial learning rate for the first ten epochs
# >>> # and decreases it exponentially after that.
# >>> def scheduler(epoch, lr):
# ...   if epoch < 10:
# ...     return lr
# ...   else:
# ...     return lr * tf.math.exp(-0.1)
# >>>
# >>> model = tf.keras.models.Sequential([tf.keras.layers.Dense(10)])
# >>> model.compile(tf.keras.optimizers.SGD(), loss='mse')
# >>> round(model.optimizer.lr.numpy(), 5)
# 0.01
#
# >>> callback = tf.keras.callbacks.LearningRateScheduler(scheduler)
# >>> history = model.fit(np.arange(100).reshape(5, 20), np.zeros(5),
# ...                     epochs=15, callbacks=[callback], verbose=0)
# >>> round(model.optimizer.lr.numpy(), 5)
# 0.00607
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.ModelCheckpoint</u></summary>
# <blockquote>
# <code>
# Callback to save the Keras model or model weights at some frequency.
#
# `ModelCheckpoint` callback is used in conjunction with training using
# `model.fit()` to save a model or weights (in a checkpoint file) at some
# interval, so the model or weights can be loaded later to continue the training
# from the state saved.
#
# A few options this callback provides include:
#
# - Whether to only keep the model that has achieved the "best performance" so
#   far, or whether to save the model at the end of every epoch regardless of
#   performance.
# - Definition of 'best'; which quantity to monitor and whether it should be
#   maximized or minimized.
# - The frequency it should save at. Currently, the callback supports saving at
#   the end of every epoch, or after a fixed number of training batches.
# - Whether only weights are saved, or the whole model is saved.
#
# Note: If you get `WARNING:tensorflow:Can save best model only with <name>
# available, skipping` see the description of the `monitor` argument for
# details on how to get this right.
#
# Example:
#
# ```python
# model.compile(loss=..., optimizer=...,
#               metrics=['accuracy'])
#
# EPOCHS = 10
# checkpoint_filepath = '/tmp/checkpoint'
# model_checkpoint_callback = tf.keras.callbacks.ModelCheckpoint(
#     filepath=checkpoint_filepath,
#     save_weights_only=True,
#     monitor='val_accuracy',
#     mode='max',
#     save_best_only=True)
#
# Model weights are saved at the end of every epoch, if it's the best seen
# so far.
# model.fit(epochs=EPOCHS, callbacks=[model_checkpoint_callback])
#
# The model weights (that are considered the best) are loaded into the model.
# model.load_weights(checkpoint_filepath)
# ```
#
# Args:
#     filepath: string or `PathLike`, path to save the model file. e.g.
#       filepath = os.path.join(working_dir, 'ckpt', file_name). `filepath`
#       can contain named formatting options, which will be filled the value of
#       `epoch` and keys in `logs` (passed in `on_epoch_end`). For example: if
#       `filepath` is `weights.{epoch:02d}-{val_loss:.2f}.hdf5`, then the model
#       checkpoints will be saved with the epoch number and the validation loss
#       in the filename. The directory of the filepath should not be reused by
#       any other callbacks to avoid conflicts.
#     monitor: The metric name to monitor. Typically the metrics are set by the
#       `Model.compile` method. Note:
#
#       * Prefix the name with `"val_`" to monitor validation metrics.
#       * Use `"loss"` or "`val_loss`" to monitor the model's total loss.
#       * If you specify metrics as strings, like `"accuracy"`, pass the same
#         string (with or without the `"val_"` prefix).
#       * If you pass `metrics.Metric` objects, `monitor` should be set to
#         `metric.name`
#       * If you're not sure about the metric names you can check the contents
#         of the `history.history` dictionary returned by
#         `history = model.fit()`
#       * Multi-output models set additional prefixes on the metric names.
#
#     verbose: verbosity mode, 0 or 1.
#     save_best_only: if `save_best_only=True`, it only saves when the model
#       is considered the "best" and the latest best model according to the
#       quantity monitored will not be overwritten. If `filepath` doesn't
#       contain formatting options like `{epoch}` then `filepath` will be
#       overwritten by each new better model.
#     mode: one of {'auto', 'min', 'max'}. If `save_best_only=True`, the
#       decision to overwrite the current save file is made based on either
#       the maximization or the minimization of the monitored quantity.
#       For `val_acc`, this should be `max`, for `val_loss` this should be
#       `min`, etc. In `auto` mode, the mode is set to `max` if the quantities
#       monitored are 'acc' or start with 'fmeasure' and are set to `min` for
#       the rest of the quantities.
#     save_weights_only: if True, then only the model's weights will be saved
#       (`model.save_weights(filepath)`), else the full model is saved
#       (`model.save(filepath)`).
#     save_freq: `'epoch'` or integer. When using `'epoch'`, the callback saves
#       the model after each epoch. When using integer, the callback saves the
#       model at end of this many batches. If the `Model` is compiled with
#       `steps_per_execution=N`, then the saving criteria will be
#       checked every Nth batch. Note that if the saving isn't aligned to
#       epochs, the monitored metric may potentially be less reliable (it
#       could reflect as little as 1 batch, since the metrics get reset every
#       epoch). Defaults to `'epoch'`.
#     options: Optional `tf.train.CheckpointOptions` object if
#       `save_weights_only` is true or optional `tf.saved_model.SaveOptions`
#       object if `save_weights_only` is false.
#     initial_value_threshold: Floating point initial "best" value of the metric
#       to be monitored. Only applies if `save_best_value=True`. Only overwrites
#       the model weights already saved if the performance of current
#       model is better than this value.
#     **kwargs: Additional arguments for backwards compatibility. Possible key
#       is `period`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.ReduceLROnPlateau</u></summary>
# <blockquote>
# <code>
# Reduce learning rate when a metric has stopped improving.
#
# Models often benefit from reducing the learning rate by a factor
# of 2-10 once learning stagnates. This callback monitors a
# quantity and if no improvement is seen for a 'patience' number
# of epochs, the learning rate is reduced.
#
# Example:
#
# ```python
# reduce_lr = ReduceLROnPlateau(monitor='val_loss', factor=0.2,
#                               patience=5, min_lr=0.001)
# model.fit(X_train, Y_train, callbacks=[reduce_lr])
# ```
#
# Args:
#     monitor: quantity to be monitored.
#     factor: factor by which the learning rate will be reduced.
#       `new_lr = lr * factor`.
#     patience: number of epochs with no improvement after which learning rate
#       will be reduced.
#     verbose: int. 0: quiet, 1: update messages.
#     mode: one of `{'auto', 'min', 'max'}`. In `'min'` mode,
#       the learning rate will be reduced when the
#       quantity monitored has stopped decreasing; in `'max'` mode it will be
#       reduced when the quantity monitored has stopped increasing; in `'auto'`
#       mode, the direction is automatically inferred from the name of the
#       monitored quantity.
#     min_delta: threshold for measuring the new optimum, to only focus on
#       significant changes.
#     cooldown: number of epochs to wait before resuming normal operation after
#       lr has been reduced.
#     min_lr: lower bound on the learning rate.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.constraints.MaxNorm</u></summary>
# <blockquote>
# <code>
# MaxNorm weight constraint.
#
# Constrains the weights incident to each hidden unit
# to have a norm less than or equal to a desired value.
#
# Also available via the shortcut function `tf.keras.constraints.max_norm`.
#
# Args:
#   max_value: the maximum norm value for the incoming weights.
#   axis: integer, axis along which to calculate weight norms.
#     For instance, in a `Dense` layer the weight matrix
#     has shape `(input_dim, output_dim)`,
#     set `axis` to `0` to constrain each weight vector
#     of length `(input_dim,)`.
#     In a `Conv2D` layer with `data_format="channels_last"`,
#     the weight tensor has shape
#     `(rows, cols, input_depth, output_depth)`,
#     set `axis` to `[0, 1, 2]`
#     to constrain the weights of each filter tensor of size
#     `(rows, cols, input_depth)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u></summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u></summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.load_weights</u></summary>
# <blockquote>
# <code>
# Loads all layer weights, either from a TensorFlow or an HDF5 weight file.
#
# If `by_name` is False weights are loaded based on the network's
# topology. This means the architecture should be the same as when the weights
# were saved.  Note that layers that don't have weights are not taken into
# account in the topological ordering, so adding or removing layers is fine as
# long as they don't have weights.
#
# If `by_name` is True, weights are loaded into layers only if they share the
# same name. This is useful for fine-tuning or transfer-learning models where
# some of the layers have changed.
#
# Only topological loading (`by_name=False`) is supported when loading weights
# from the TensorFlow format. Note that topological loading differs slightly
# between TensorFlow and HDF5 formats for user-defined classes inheriting from
# `tf.keras.Model`: HDF5 loads based on a flattened list of weights, while the
# TensorFlow format loads based on the object-local names of attributes to
# which layers are assigned in the `Model`'s constructor.
#
# Args:
#     filepath: String, path to the weights file to load. For weight files in
#         TensorFlow format, this is the file prefix (the same as was passed
#         to `save_weights`). This can also be a path to a SavedModel
#         saved from `model.save`.
#     by_name: Boolean, whether to load weights by name or by topological
#         order. Only topological loading is supported for weight files in
#         TensorFlow format.
#     skip_mismatch: Boolean, whether to skip loading of layers where there is
#         a mismatch in the number of weights, or a mismatch in the shape of
#         the weight (only valid when `by_name=True`).
#     options: Optional `tf.train.CheckpointOptions` object that specifies
#         options for loading weights.
#
# Returns:
#     When loading a weight file in TensorFlow format, returns the same status
#     object as `tf.train.Checkpoint.restore`. When graph building, restore
#     ops are run automatically as soon as the network is built (on first call
#     for user-defined classes inheriting from `Model`, immediately if it is
#     already built).
#
#     When loading weights in HDF5 format, returns `None`.
#
# Raises:
#     ImportError: If `h5py` is not available and the weight file is in HDF5
#         format.
#     ValueError: If `skip_mismatch` is set to `True` when `by_name` is
#       `False`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.initializers.initializers_v2.GlorotUniform</u></summary>
# <blockquote>
# <code>
# The Glorot uniform initializer, also called Xavier uniform initializer.
#
# Also available via the shortcut function
# `tf.keras.initializers.glorot_uniform`.
#
# Draws samples from a uniform distribution within `[-limit, limit]`, where
# `limit = sqrt(6 / (fan_in + fan_out))` (`fan_in` is the number of input units
# in the weight tensor and `fan_out` is the number of output units).
#
# Examples:
#
# >>> # Standalone usage:
# >>> initializer = tf.keras.initializers.GlorotUniform()
# >>> values = initializer(shape=(2, 2))
#
# >>> # Usage in a Keras layer:
# >>> initializer = tf.keras.initializers.GlorotUniform()
# >>> layer = tf.keras.layers.Dense(3, kernel_initializer=initializer)
#
# Args:
#   seed: A Python integer. Used to create random seeds. See
#     `tf.compat.v1.set_random_seed` for behavior. Note that seeded
#     initializer will not produce same random values across multiple calls,
#     but multiple initializers will produce same sequence when constructed with
#     same seed value.
#
# References:
#   - [Glorot et al., 2010](http://proceedings.mlr.press/v9/glorot10a.html)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers</u></summary>
# <blockquote>
# <code>
# Keras layers API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.convolutional.Conv2D</u></summary>
# <blockquote>
# <code>
# 2D convolution layer (e.g. spatial convolution over images).
#
# This layer creates a convolution kernel that is convolved
# with the layer input to produce a tensor of
# outputs. If `use_bias` is True,
# a bias vector is created and added to the outputs. Finally, if
# `activation` is not `None`, it is applied to the outputs as well.
#
# When using this layer as the first layer in a model,
# provide the keyword argument `input_shape`
# (tuple of integers or `None`, does not include the sample axis),
# e.g. `input_shape=(128, 128, 3)` for 128x128 RGB pictures
# in `data_format="channels_last"`. You can use `None` when
# a dimension has variable size.
#
# Examples:
#
# >>> # The inputs are 28x28 RGB images with `channels_last` and the batch
# >>> # size is 4.
# >>> input_shape = (4, 28, 28, 3)
# >>> x = tf.random.normal(input_shape)
# >>> y = tf.keras.layers.Conv2D(
# ... 2, 3, activation='relu', input_shape=input_shape[1:])(x)
# >>> print(y.shape)
# (4, 26, 26, 2)
#
# >>> # With `dilation_rate` as 2.
# >>> input_shape = (4, 28, 28, 3)
# >>> x = tf.random.normal(input_shape)
# >>> y = tf.keras.layers.Conv2D(
# ... 2, 3, activation='relu', dilation_rate=2, input_shape=input_shape[1:])(x)
# >>> print(y.shape)
# (4, 24, 24, 2)
#
# >>> # With `padding` as "same".
# >>> input_shape = (4, 28, 28, 3)
# >>> x = tf.random.normal(input_shape)
# >>> y = tf.keras.layers.Conv2D(
# ... 2, 3, activation='relu', padding="same", input_shape=input_shape[1:])(x)
# >>> print(y.shape)
# (4, 28, 28, 2)
#
# >>> # With extended batch shape [4, 7]:
# >>> input_shape = (4, 7, 28, 28, 3)
# >>> x = tf.random.normal(input_shape)
# >>> y = tf.keras.layers.Conv2D(
# ... 2, 3, activation='relu', input_shape=input_shape[2:])(x)
# >>> print(y.shape)
# (4, 7, 26, 26, 2)
#
#
# Args:
#   filters: Integer, the dimensionality of the output space (i.e. the number of
#     output filters in the convolution).
#   kernel_size: An integer or tuple/list of 2 integers, specifying the height
#     and width of the 2D convolution window. Can be a single integer to specify
#     the same value for all spatial dimensions.
#   strides: An integer or tuple/list of 2 integers, specifying the strides of
#     the convolution along the height and width. Can be a single integer to
#     specify the same value for all spatial dimensions. Specifying any stride
#     value != 1 is incompatible with specifying any `dilation_rate` value != 1.
#   padding: one of `"valid"` or `"same"` (case-insensitive).
#     `"valid"` means no padding. `"same"` results in padding with zeros evenly
#     to the left/right or up/down of the input. When `padding="same"` and
#     `strides=1`, the output has the same size as the input.
#   data_format: A string, one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs. `channels_last` corresponds
#     to inputs with shape `(batch_size, height, width, channels)` while
#     `channels_first` corresponds to inputs with shape `(batch_size, channels,
#     height, width)`. It defaults to the `image_data_format` value found in
#     your Keras config file at `~/.keras/keras.json`. If you never set it, then
#     it will be `channels_last`.
#   dilation_rate: an integer or tuple/list of 2 integers, specifying the
#     dilation rate to use for dilated convolution. Can be a single integer to
#     specify the same value for all spatial dimensions. Currently, specifying
#     any `dilation_rate` value != 1 is incompatible with specifying any stride
#     value != 1.
#   groups: A positive integer specifying the number of groups in which the
#     input is split along the channel axis. Each group is convolved separately
#     with `filters / groups` filters. The output is the concatenation of all
#     the `groups` results along the channel axis. Input channels and `filters`
#     must both be divisible by `groups`.
#   activation: Activation function to use. If you don't specify anything, no
#     activation is applied (see `keras.activations`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix (see
#     `keras.initializers`). Defaults to 'glorot_uniform'.
#   bias_initializer: Initializer for the bias vector (see
#     `keras.initializers`). Defaults to 'zeros'.
#   kernel_regularizer: Regularizer function applied to the `kernel` weights
#     matrix (see `keras.regularizers`).
#   bias_regularizer: Regularizer function applied to the bias vector (see
#     `keras.regularizers`).
#   activity_regularizer: Regularizer function applied to the output of the
#     layer (its "activation") (see `keras.regularizers`).
#   kernel_constraint: Constraint function applied to the kernel matrix (see
#     `keras.constraints`).
#   bias_constraint: Constraint function applied to the bias vector (see
#     `keras.constraints`).
#
# Input shape:
#   4+D tensor with shape: `batch_shape + (channels, rows, cols)` if
#     `data_format='channels_first'`
#   or 4+D tensor with shape: `batch_shape + (rows, cols, channels)` if
#     `data_format='channels_last'`.
#
# Output shape:
#   4+D tensor with shape: `batch_shape + (filters, new_rows, new_cols)` if
#   `data_format='channels_first'` or 4+D tensor with shape: `batch_shape +
#     (new_rows, new_cols, filters)` if `data_format='channels_last'`.  `rows`
#     and `cols` values might have changed due to padding.
#
# Returns:
#   A tensor of rank 4+ representing
#   `activation(conv2d(inputs, kernel) + bias)`.
#
# Raises:
#   ValueError: if `padding` is `"causal"`.
#   ValueError: when both `strides > 1` and `dilation_rate > 1`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.convolutional.ZeroPadding2D</u></summary>
# <blockquote>
# <code>
# Zero-padding layer for 2D input (e.g. picture).
#
# This layer can add rows and columns of zeros
# at the top, bottom, left and right side of an image tensor.
#
# Examples:
#
# >>> input_shape = (1, 1, 2, 2)
# >>> x = np.arange(np.prod(input_shape)).reshape(input_shape)
# >>> print(x)
# [[[[0 1]
#    [2 3]]]]
# >>> y = tf.keras.layers.ZeroPadding2D(padding=1)(x)
# >>> print(y)
# tf.Tensor(
#   [[[[0 0]
#      [0 0]
#      [0 0]
#      [0 0]]
#     [[0 0]
#      [0 1]
#      [2 3]
#      [0 0]]
#     [[0 0]
#      [0 0]
#      [0 0]
#      [0 0]]]], shape=(1, 3, 4, 2), dtype=int64)
#
# Args:
#   padding: Int, or tuple of 2 ints, or tuple of 2 tuples of 2 ints.
#     - If int: the same symmetric padding
#       is applied to height and width.
#     - If tuple of 2 ints:
#       interpreted as two different
#       symmetric padding values for height and width:
#       `(symmetric_height_pad, symmetric_width_pad)`.
#     - If tuple of 2 tuples of 2 ints:
#       interpreted as
#       `((top_pad, bottom_pad), (left_pad, right_pad))`
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch_size, height, width, channels)` while `channels_first`
#     corresponds to inputs with shape
#     `(batch_size, channels, height, width)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Input shape:
#   4D tensor with shape:
#   - If `data_format` is `"channels_last"`:
#       `(batch_size, rows, cols, channels)`
#   - If `data_format` is `"channels_first"`:
#       `(batch_size, channels, rows, cols)`
#
# Output shape:
#   4D tensor with shape:
#   - If `data_format` is `"channels_last"`:
#       `(batch_size, padded_rows, padded_cols, channels)`
#   - If `data_format` is `"channels_first"`:
#       `(batch_size, channels, padded_rows, padded_cols)`
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.activation.Activation</u></summary>
# <blockquote>
# <code>
# Applies an activation function to an output.
#
# Args:
#   activation: Activation function, such as `tf.nn.relu`, or string name of
#     built-in activation function, such as "relu".
#
# Usage:
#
# >>> layer = tf.keras.layers.Activation('relu')
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
# >>> layer = tf.keras.layers.Activation(tf.nn.relu)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u></summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.merge.concatenate</u></summary>
# <blockquote>
# <code>
# Functional interface to the `Concatenate` layer.
#
# >>> x = np.arange(20).reshape(2, 2, 5)
# >>> print(x)
# [[[ 0  1  2  3  4]
#   [ 5  6  7  8  9]]
#  [[10 11 12 13 14]
#   [15 16 17 18 19]]]
# >>> y = np.arange(20, 30).reshape(2, 1, 5)
# >>> print(y)
# [[[20 21 22 23 24]]
#  [[25 26 27 28 29]]]
# >>> tf.keras.layers.concatenate([x, y],
# ...                             axis=1)
# <tf.Tensor: shape=(2, 3, 5), dtype=int64, numpy=
# array([[[ 0,  1,  2,  3,  4],
#       [ 5,  6,  7,  8,  9],
#       [20, 21, 22, 23, 24]],
#      [[10, 11, 12, 13, 14],
#       [15, 16, 17, 18, 19],
#       [25, 26, 27, 28, 29]]])>
#
# Args:
#     inputs: A list of input tensors (at least 2).
#     axis: Concatenation axis.
#     **kwargs: Standard layer keyword arguments.
#
# Returns:
#     A tensor, the concatenation of the inputs alongside axis `axis`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u></summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.pooling.AveragePooling2D</u></summary>
# <blockquote>
# <code>
# Average pooling operation for spatial data.
#
# Downsamples the input along its spatial dimensions (height and width)
# by taking the average value over an input window
# (of size defined by `pool_size`) for each channel of the input.
# The window is shifted by `strides` along each dimension.
#
# The resulting output when using `"valid"` padding option has a shape
# (number of rows or columns) of:
# `output_shape = math.floor((input_shape - pool_size) / strides) + 1`
# (when `input_shape >= pool_size`)
#
# The resulting output shape when using the `"same"` padding option is:
# `output_shape = math.floor((input_shape - 1) / strides) + 1`
#
# For example, for `strides=(1, 1)` and `padding="valid"`:
#
# >>> x = tf.constant([[1., 2., 3.],
# ...                  [4., 5., 6.],
# ...                  [7., 8., 9.]])
# >>> x = tf.reshape(x, [1, 3, 3, 1])
# >>> avg_pool_2d = tf.keras.layers.AveragePooling2D(pool_size=(2, 2),
# ...    strides=(1, 1), padding='valid')
# >>> avg_pool_2d(x)
# <tf.Tensor: shape=(1, 2, 2, 1), dtype=float32, numpy=
#   array([[[[3.],
#            [4.]],
#           [[6.],
#            [7.]]]], dtype=float32)>
#
# For example, for `stride=(2, 2)` and `padding="valid"`:
#
# >>> x = tf.constant([[1., 2., 3., 4.],
# ...                  [5., 6., 7., 8.],
# ...                  [9., 10., 11., 12.]])
# >>> x = tf.reshape(x, [1, 3, 4, 1])
# >>> avg_pool_2d = tf.keras.layers.AveragePooling2D(pool_size=(2, 2),
# ...    strides=(2, 2), padding='valid')
# >>> avg_pool_2d(x)
# <tf.Tensor: shape=(1, 1, 2, 1), dtype=float32, numpy=
#   array([[[[3.5],
#            [5.5]]]], dtype=float32)>
#
# For example, for `strides=(1, 1)` and `padding="same"`:
#
# >>> x = tf.constant([[1., 2., 3.],
# ...                  [4., 5., 6.],
# ...                  [7., 8., 9.]])
# >>> x = tf.reshape(x, [1, 3, 3, 1])
# >>> avg_pool_2d = tf.keras.layers.AveragePooling2D(pool_size=(2, 2),
# ...    strides=(1, 1), padding='same')
# >>> avg_pool_2d(x)
# <tf.Tensor: shape=(1, 3, 3, 1), dtype=float32, numpy=
#   array([[[[3.],
#            [4.],
#            [4.5]],
#           [[6.],
#            [7.],
#            [7.5]],
#           [[7.5],
#            [8.5],
#            [9.]]]], dtype=float32)>
#
# Args:
#   pool_size: integer or tuple of 2 integers,
#     factors by which to downscale (vertical, horizontal).
#     `(2, 2)` will halve the input in both spatial dimension.
#     If only one integer is specified, the same window length
#     will be used for both dimensions.
#   strides: Integer, tuple of 2 integers, or None.
#     Strides values.
#     If None, it will default to `pool_size`.
#   padding: One of `"valid"` or `"same"` (case-insensitive).
#     `"valid"` means no padding. `"same"` results in padding evenly to
#     the left/right or up/down of the input such that output has the same
#     height/width dimension as the input.
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, height, width, channels)` while `channels_first`
#     corresponds to inputs with shape
#     `(batch, channels, height, width)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Input shape:
#   - If `data_format='channels_last'`:
#     4D tensor with shape `(batch_size, rows, cols, channels)`.
#   - If `data_format='channels_first'`:
#     4D tensor with shape `(batch_size, channels, rows, cols)`.
#
# Output shape:
#   - If `data_format='channels_last'`:
#     4D tensor with shape `(batch_size, pooled_rows, pooled_cols, channels)`.
#   - If `data_format='channels_first'`:
#     4D tensor with shape `(batch_size, channels, pooled_rows, pooled_cols)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.pooling.MaxPooling2D</u></summary>
# <blockquote>
# <code>
# Max pooling operation for 2D spatial data.
#
# Downsamples the input along its spatial dimensions (height and width)
# by taking the maximum value over an input window
# (of size defined by `pool_size`) for each channel of the input.
# The window is shifted by `strides` along each dimension.
#
# The resulting output,
# when using the `"valid"` padding option, has a spatial shape
# (number of rows or columns) of:
# `output_shape = math.floor((input_shape - pool_size) / strides) + 1`
# (when `input_shape >= pool_size`)
#
# The resulting output shape when using the `"same"` padding option is:
# `output_shape = math.floor((input_shape - 1) / strides) + 1`
#
# For example, for `strides=(1, 1)` and `padding="valid"`:
#
# >>> x = tf.constant([[1., 2., 3.],
# ...                  [4., 5., 6.],
# ...                  [7., 8., 9.]])
# >>> x = tf.reshape(x, [1, 3, 3, 1])
# >>> max_pool_2d = tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    strides=(1, 1), padding='valid')
# >>> max_pool_2d(x)
# <tf.Tensor: shape=(1, 2, 2, 1), dtype=float32, numpy=
#   array([[[[5.],
#            [6.]],
#           [[8.],
#            [9.]]]], dtype=float32)>
#
# For example, for `strides=(2, 2)` and `padding="valid"`:
#
# >>> x = tf.constant([[1., 2., 3., 4.],
# ...                  [5., 6., 7., 8.],
# ...                  [9., 10., 11., 12.]])
# >>> x = tf.reshape(x, [1, 3, 4, 1])
# >>> max_pool_2d = tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    strides=(2, 2), padding='valid')
# >>> max_pool_2d(x)
# <tf.Tensor: shape=(1, 1, 2, 1), dtype=float32, numpy=
#   array([[[[6.],
#            [8.]]]], dtype=float32)>
#
# Usage Example:
#
# >>> input_image = tf.constant([[[[1.], [1.], [2.], [4.]],
# ...                            [[2.], [2.], [3.], [2.]],
# ...                            [[4.], [1.], [1.], [1.]],
# ...                            [[2.], [2.], [1.], [4.]]]])
# >>> output = tf.constant([[[[1], [0]],
# ...                       [[0], [1]]]])
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    input_shape=(4, 4, 1)))
# >>> model.compile('adam', 'mean_squared_error')
# >>> model.predict(input_image, steps=1)
# array([[[[2.],
#          [4.]],
#         [[4.],
#          [4.]]]], dtype=float32)
#
# For example, for stride=(1, 1) and padding="same":
#
# >>> x = tf.constant([[1., 2., 3.],
# ...                  [4., 5., 6.],
# ...                  [7., 8., 9.]])
# >>> x = tf.reshape(x, [1, 3, 3, 1])
# >>> max_pool_2d = tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    strides=(1, 1), padding='same')
# >>> max_pool_2d(x)
# <tf.Tensor: shape=(1, 3, 3, 1), dtype=float32, numpy=
#   array([[[[5.],
#            [6.],
#            [6.]],
#           [[8.],
#            [9.],
#            [9.]],
#           [[8.],
#            [9.],
#            [9.]]]], dtype=float32)>
#
# Args:
#   pool_size: integer or tuple of 2 integers,
#     window size over which to take the maximum.
#     `(2, 2)` will take the max value over a 2x2 pooling window.
#     If only one integer is specified, the same window length
#     will be used for both dimensions.
#   strides: Integer, tuple of 2 integers, or None.
#     Strides values.  Specifies how far the pooling window moves
#     for each pooling step. If None, it will default to `pool_size`.
#   padding: One of `"valid"` or `"same"` (case-insensitive).
#     `"valid"` means no padding. `"same"` results in padding evenly to
#     the left/right or up/down of the input such that output has the same
#     height/width dimension as the input.
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, height, width, channels)` while `channels_first`
#     corresponds to inputs with shape
#     `(batch, channels, height, width)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Input shape:
#   - If `data_format='channels_last'`:
#     4D tensor with shape `(batch_size, rows, cols, channels)`.
#   - If `data_format='channels_first'`:
#     4D tensor with shape `(batch_size, channels, rows, cols)`.
#
# Output shape:
#   - If `data_format='channels_last'`:
#     4D tensor with shape `(batch_size, pooled_rows, pooled_cols, channels)`.
#   - If `data_format='channels_first'`:
#     4D tensor with shape `(batch_size, channels, pooled_rows, pooled_cols)`.
#
# Returns:
#   A tensor of rank 4 representing the maximum pooled values.  See above for
#   output shape.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers</u></summary>
# <blockquote>
# <code>
# Built-in regularizers.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.saving.save.load_model</u></summary>
# <blockquote>
# <code>
# Loads a model saved via `model.save()`.
#
# Usage:
#
# >>> model = tf.keras.Sequential([
# ...     tf.keras.layers.Dense(5, input_shape=(3,)),
# ...     tf.keras.layers.Softmax()])
# >>> model.save('/tmp/model')
# >>> loaded_model = tf.keras.models.load_model('/tmp/model')
# >>> x = tf.random.uniform((10, 3))
# >>> assert np.allclose(model.predict(x), loaded_model.predict(x))
#
# Note that the model weights may have different scoped names after being
# loaded. Scoped names include the model/layer names, such as
# `"dense_1/kernel:0"`. It is recommended that you use the layer properties to
# access specific variables, e.g. `model.get_layer("dense_1").kernel`.
#
# Args:
#     filepath: One of the following:
#         - String or `pathlib.Path` object, path to the saved model
#         - `h5py.File` object from which to load the model
#     custom_objects: Optional dictionary mapping names
#         (strings) to custom classes or functions to be
#         considered during deserialization.
#     compile: Boolean, whether to compile the model
#         after loading.
#     options: Optional `tf.saved_model.LoadOptions` object that specifies
#       options for loading from SavedModel.
#
# Returns:
#     A Keras model instance. If the original model was compiled, and saved with
#     the optimizer, then the returned model will be compiled. Otherwise, the
#     model will be left uncompiled. In the case that an uncompiled model is
#     returned, a warning is displayed if the `compile` argument is set to
#     `True`.
#
# Raises:
#     ImportError: if loading from an hdf5 file and h5py is not available.
#     IOError: In case of an invalid savefile.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot</u></summary>
# <blockquote>
# <code>
# `matplotlib.pyplot` is a state-based interface to matplotlib. It provides
# an implicit,  MATLAB-like, way of plotting.  It also opens figures on your
# screen, and acts as the figure GUI manager.
#
# pyplot is mainly intended for interactive plots and simple cases of
# programmatic plot generation::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     plt.plot(x, y)
#
# The explicit (object-oriented) API is recommended for complex plots, though
# pyplot is still usually used to create the figure and often the axes in the
# figure. See `.pyplot.figure`, `.pyplot.subplots`, and
# `.pyplot.subplot_mosaic` to create figures, and
# :doc:`Axes API <../axes_api>` for the plotting methods on an axes::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u></summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u></summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlim</u></summary>
# <blockquote>
# <code>
# Get or set the x limits of the current axes.
#
# Call signatures::
#
#     left, right = xlim()  # return the current xlim
#     xlim((left, right))   # set the xlim to left, right
#     xlim(left, right)     # set the xlim to left, right
#
# If you do not specify args, you can pass *left* or *right* as kwargs,
# i.e.::
#
#     xlim(right=3)  # adjust the right leaving left unchanged
#     xlim(left=1)  # adjust the left leaving right unchanged
#
# Setting limits turns autoscaling off for the x-axis.
#
# Returns
# -------
# left, right
#     A tuple of the new x-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``xlim()``) is the pyplot
# equivalent of calling `~.Axes.get_xlim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_xlim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u></summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylim</u></summary>
# <blockquote>
# <code>
# Get or set the y-limits of the current axes.
#
# Call signatures::
#
#     bottom, top = ylim()  # return the current ylim
#     ylim((bottom, top))   # set the ylim to bottom, top
#     ylim(bottom, top)     # set the ylim to bottom, top
#
# If you do not specify args, you can alternatively pass *bottom* or
# *top* as kwargs, i.e.::
#
#     ylim(top=3)  # adjust the top leaving bottom unchanged
#     ylim(bottom=1)  # adjust the bottom leaving top unchanged
#
# Setting limits turns autoscaling off for the y-axis.
#
# Returns
# -------
# bottom, top
#     A tuple of the new y-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``ylim()``) is the pyplot
# equivalent of calling `~.Axes.get_ylim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_ylim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.array</u></summary>
# <blockquote>
# <code>
# array(object, dtype=None, *, copy=True, order='K', subok=False, ndmin=0,
#       like=None)
#
# Create an array.
#
# Parameters
# ----------
# object : array_like
#     An array, any object exposing the array interface, an object whose
#     __array__ method returns an array, or any (nested) sequence.
#     If object is a scalar, a 0-dimensional array containing object is
#     returned.
# dtype : data-type, optional
#     The desired data-type for the array.  If not given, then the type will
#     be determined as the minimum type required to hold the objects in the
#     sequence.
# copy : bool, optional
#     If true (default), then the object is copied.  Otherwise, a copy will
#     only be made if __array__ returns a copy, if obj is a nested sequence,
#     or if a copy is needed to satisfy any of the other requirements
#     (`dtype`, `order`, etc.).
# order : {'K', 'A', 'C', 'F'}, optional
#     Specify the memory layout of the array. If object is not an array, the
#     newly created array will be in C order (row major) unless 'F' is
#     specified, in which case it will be in Fortran order (column major).
#     If object is an array the following holds.
#
#     ===== ========= ===================================================
#     order  no copy                     copy=True
#     ===== ========= ===================================================
#     'K'   unchanged F & C order preserved, otherwise most similar order
#     'A'   unchanged F order if input is F and not C, otherwise C order
#     'C'   C order   C order
#     'F'   F order   F order
#     ===== ========= ===================================================
#
#     When ``copy=False`` and a copy is made for other reasons, the result is
#     the same as if ``copy=True``, with some exceptions for 'A', see the
#     Notes section. The default order is 'K'.
# subok : bool, optional
#     If True, then sub-classes will be passed-through, otherwise
#     the returned array will be forced to be a base-class array (default).
# ndmin : int, optional
#     Specifies the minimum number of dimensions that the resulting
#     array should have.  Ones will be pre-pended to the shape as
#     needed to meet this requirement.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     An array object satisfying the specified requirements.
#
# See Also
# --------
# empty_like : Return an empty array with shape and type of input.
# ones_like : Return an array of ones with shape and type of input.
# zeros_like : Return an array of zeros with shape and type of input.
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Notes
# -----
# When order is 'A' and `object` is an array in neither 'C' nor 'F' order,
# and a copy is forced by a change in dtype, then the order of the result is
# not necessarily 'C' as expected. This is likely a bug.
#
# Examples
# --------
# >>> np.array([1, 2, 3])
# array([1, 2, 3])
#
# Upcasting:
#
# >>> np.array([1, 2, 3.0])
# array([ 1.,  2.,  3.])
#
# More than one dimension:
#
# >>> np.array([[1, 2], [3, 4]])
# array([[1, 2],
#        [3, 4]])
#
# Minimum dimensions 2:
#
# >>> np.array([1, 2, 3], ndmin=2)
# array([[1, 2, 3]])
#
# Type provided:
#
# >>> np.array([1, 2, 3], dtype=complex)
# array([ 1.+0.j,  2.+0.j,  3.+0.j])
#
# Data-type consisting of more than one element:
#
# >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
# >>> x['a']
# array([1, 3])
#
# Creating an array from sub-classes:
#
# >>> np.array(np.mat('1 2; 3 4'))
# array([[1, 2],
#        [3, 4]])
#
# >>> np.array(np.mat('1 2; 3 4'), subok=True)
# matrix([[1, 2],
#         [3, 4]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u></summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.std</u></summary>
# <blockquote>
# <code>
# Compute the standard deviation along the specified axis.
#
# Returns the standard deviation, a measure of the spread of a distribution,
# of the array elements. The standard deviation is computed for the
# flattened array by default, otherwise over the specified axis.
#
# Parameters
# ----------
# a : array_like
#     Calculate the standard deviation of these values.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the standard deviation is computed. The
#     default is to compute the standard deviation of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a standard deviation is performed over
#     multiple axes, instead of a single axis or all the axes as before.
# dtype : dtype, optional
#     Type to use in computing the standard deviation. For arrays of
#     integer type the default is float64, for arrays of float types it is
#     the same as the array type.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output but the type (of the calculated
#     values) will be cast if necessary.
# ddof : int, optional
#     Means Delta Degrees of Freedom.  The divisor used in calculations
#     is ``N - ddof``, where ``N`` represents the number of elements.
#     By default `ddof` is zero.
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `std` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the standard deviation.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# standard_deviation : ndarray, see dtype parameter above.
#     If `out` is None, return a new array containing the standard deviation,
#     otherwise return a reference to the output array.
#
# See Also
# --------
# var, mean, nanmean, nanstd, nanvar
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# The standard deviation is the square root of the average of the squared
# deviations from the mean, i.e., ``std = sqrt(mean(x))``, where
# ``x = abs(a - a.mean())**2``.
#
# The average squared deviation is typically calculated as ``x.sum() / N``,
# where ``N = len(x)``. If, however, `ddof` is specified, the divisor
# ``N - ddof`` is used instead. In standard statistical practice, ``ddof=1``
# provides an unbiased estimator of the variance of the infinite population.
# ``ddof=0`` provides a maximum likelihood estimate of the variance for
# normally distributed variables. The standard deviation computed in this
# function is the square root of the estimated variance, so even with
# ``ddof=1``, it will not be an unbiased estimate of the standard deviation
# per se.
#
# Note that, for complex numbers, `std` takes the absolute
# value before squaring, so that the result is always real and nonnegative.
#
# For floating-point input, the *std* is computed using the same
# precision the input has. Depending on the input data, this can cause
# the results to be inaccurate, especially for float32 (see example below).
# Specifying a higher-accuracy accumulator using the `dtype` keyword can
# alleviate this issue.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.std(a)
# 1.1180339887498949 # may vary
# >>> np.std(a, axis=0)
# array([1.,  1.])
# >>> np.std(a, axis=1)
# array([0.5,  0.5])
#
# In single precision, std() can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.std(a)
# 0.45000005
#
# Computing the standard deviation in float64 is more accurate:
#
# >>> np.std(a, dtype=np.float64)
# 0.44999999925494177 # may vary
#
# Specifying a where argument:
#
# >>> a = np.array([[14, 8, 11, 10], [7, 9, 10, 11], [10, 15, 5, 10]])
# >>> np.std(a)
# 2.614064523559687 # may vary
# >>> np.std(a, where=[[True], [True], [False]])
# 2.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.ravel</u></summary>
# <blockquote>
# <code>
# a.ravel([order])
#
# Return a flattened array.
#
# Refer to `numpy.ravel` for full documentation.
#
# See Also
# --------
# numpy.ravel : equivalent function
#
# ndarray.flat : a flat iterator on the array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.append</u></summary>
# <blockquote>
# <code>
# Append rows of `other` to the end of caller, returning a new object.
#
# .. deprecated:: 1.4.0
#     Use :func:`concat` instead. For further details see
#     :ref:`whatsnew_140.deprecations.frame_series_append`
#
# Columns in `other` that are not in the caller are added as new columns.
#
# Parameters
# ----------
# other : DataFrame or Series/dict-like object, or list of these
#     The data to append.
# ignore_index : bool, default False
#     If True, the resulting axis will be labeled 0, 1, …, n - 1.
# verify_integrity : bool, default False
#     If True, raise ValueError on creating index with duplicates.
# sort : bool, default False
#     Sort columns if the columns of `self` and `other` are not aligned.
#
#     .. versionchanged:: 1.0.0
#
#         Changed to not sort by default.
#
# Returns
# -------
# DataFrame
#     A new DataFrame consisting of the rows of caller and the rows of `other`.
#
# See Also
# --------
# concat : General function to concatenate DataFrame or Series objects.
#
# Notes
# -----
# If a list of dict/series is passed and the keys are all contained in
# the DataFrame's index, the order of the columns in the resulting
# DataFrame will be unchanged.
#
# Iteratively appending rows to a DataFrame can be more computationally
# intensive than a single concatenate. A better solution is to append
# those rows to a list and then concatenate the list with the original
# DataFrame all at once.
#
# Examples
# --------
# >>> df = pd.DataFrame([[1, 2], [3, 4]], columns=list('AB'), index=['x', 'y'])
# >>> df
#    A  B
# x  1  2
# y  3  4
# >>> df2 = pd.DataFrame([[5, 6], [7, 8]], columns=list('AB'), index=['x', 'y'])
# >>> df.append(df2)
#    A  B
# x  1  2
# y  3  4
# x  5  6
# y  7  8
#
# With `ignore_index` set to True:
#
# >>> df.append(df2, ignore_index=True)
#    A  B
# 0  1  2
# 1  3  4
# 2  5  6
# 3  7  8
#
# The following, while not recommended methods for generating DataFrames,
# show two ways to generate a DataFrame from multiple data sources.
#
# Less efficient:
#
# >>> df = pd.DataFrame(columns=['A'])
# >>> for i in range(5):
# ...     df = df.append({'A': i}, ignore_index=True)
# >>> df
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# More efficient:
#
# >>> pd.concat([pd.DataFrame([i], columns=['A']) for i in range(5)],
# ...           ignore_index=True)
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u></summary>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations</u></summary>
# <blockquote>
# <code>
# Add the operations to the cls; evaluate the doc strings again
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u></summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.min</u></summary>
# <blockquote>
# <code>
# Return the minimum of the values over the requested axis.
#
# If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.min()
# 0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.isnull</u></summary>
# <blockquote>
# <code>
# Series.isnull is an alias for Series.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# Series.isnull : Alias of isna.
# Series.notna : Boolean inverse of isna.
# Series.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.map</u></summary>
# <blockquote>
# <code>
# Map values of Series according to an input mapping or function.
#
# Used for substituting each value in a Series with another value,
# that may be derived from a function, a ``dict`` or
# a :class:`Series`.
#
# Parameters
# ----------
# arg : function, collections.abc.Mapping subclass or Series
#     Mapping correspondence.
# na_action : {None, 'ignore'}, default None
#     If 'ignore', propagate NaN values, without passing them to the
#     mapping correspondence.
#
# Returns
# -------
# Series
#     Same index as caller.
#
# See Also
# --------
# Series.apply : For applying more complex functions on a Series.
# DataFrame.apply : Apply a function row-/column-wise.
# DataFrame.applymap : Apply a function elementwise on a whole DataFrame.
#
# Notes
# -----
# When ``arg`` is a dictionary, values in Series that are not in the
# dictionary (as keys) are converted to ``NaN``. However, if the
# dictionary is a ``dict`` subclass that defines ``__missing__`` (i.e.
# provides a method for default values), then this default is used
# rather than ``NaN``.
#
# Examples
# --------
# >>> s = pd.Series(['cat', 'dog', np.nan, 'rabbit'])
# >>> s
# 0      cat
# 1      dog
# 2      NaN
# 3   rabbit
# dtype: object
#
# ``map`` accepts a ``dict`` or a ``Series``. Values that are not found
# in the ``dict`` are converted to ``NaN``, unless the dict has a default
# value (e.g. ``defaultdict``):
#
# >>> s.map({'cat': 'kitten', 'dog': 'puppy'})
# 0   kitten
# 1    puppy
# 2      NaN
# 3      NaN
# dtype: object
#
# It also accepts a function:
#
# >>> s.map('I am a {}'.format)
# 0       I am a cat
# 1       I am a dog
# 2       I am a nan
# 3    I am a rabbit
# dtype: object
#
# To avoid applying the function to missing values (and keep them as
# ``NaN``) ``na_action='ignore'`` can be used:
#
# >>> s.map('I am a {}'.format, na_action='ignore')
# 0     I am a cat
# 1     I am a dog
# 2            NaN
# 3  I am a rabbit
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.notnull</u></summary>
# <blockquote>
# <code>
# Series.notnull is an alias for Series.notna.
#
# Detect existing (non-missing) values.
#
# Return a boolean same-sized object indicating if the values are not NA.
# Non-missing values get mapped to True. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
# NA values, such as None or :attr:`numpy.NaN`, get mapped to False
# values.
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is not an NA value.
#
# See Also
# --------
# Series.notnull : Alias of notna.
# Series.isna : Boolean inverse of notna.
# Series.dropna : Omit axes labels with missing values.
# notna : Top-level notna.
#
# Examples
# --------
# Show which entries in a DataFrame are not NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.notna()
#      age   born  name    toy
# 0   True  False  True  False
# 1   True   True  True   True
# 2  False   True  True   True
#
# Show which entries in a Series are not NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.notna()
# 0     True
# 1     True
# 2    False
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>posix</b>
# <ul>
# <li>
# <details><summary><u>posix.listdir</u></summary>
# <blockquote>
# <code>
# Return a list containing the names of the files in the directory.
#
# path can be specified as either str, bytes, or a path-like object.  If path is bytes,
#   the filenames returned will also be bytes; in all other circumstances
#   the filenames returned will be str.
# If path is None, uses the path='.'.
# On some platforms, path may also be specified as an open file descriptor;\
#   the file descriptor must refer to a directory.
#   If this functionality is unavailable, using it raises NotImplementedError.
#
# The list is in arbitrary order.  It does not include the special
# entries '.' and '..' even if they are present in the directory.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u></summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_curve</u></summary>
# <blockquote>
# <code>
# Compute Receiver operating characteristic (ROC).
#
# Note: this implementation is restricted to the binary classification task.
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : ndarray of shape (n_samples,)
#     True binary labels. If labels are not either {-1, 1} or {0, 1}, then
#     pos_label should be explicitly given.
#
# y_score : ndarray of shape (n_samples,)
#     Target scores, can either be probability estimates of the positive
#     class, confidence values, or non-thresholded measure of decisions
#     (as returned by "decision_function" on some classifiers).
#
# pos_label : int or str, default=None
#     The label of the positive class.
#     When ``pos_label=None``, if `y_true` is in {-1, 1} or {0, 1},
#     ``pos_label`` is set to 1, otherwise an error will be raised.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# drop_intermediate : bool, default=True
#     Whether to drop some suboptimal thresholds which would not appear
#     on a plotted ROC curve. This is useful in order to create lighter
#     ROC curves.
#
#     .. versionadded:: 0.17
#        parameter *drop_intermediate*.
#
# Returns
# -------
# fpr : ndarray of shape (>2,)
#     Increasing false positive rates such that element i is the false
#     positive rate of predictions with score >= `thresholds[i]`.
#
# tpr : ndarray of shape (>2,)
#     Increasing true positive rates such that element `i` is the true
#     positive rate of predictions with score >= `thresholds[i]`.
#
# thresholds : ndarray of shape = (n_thresholds,)
#     Decreasing thresholds on the decision function used to compute
#     fpr and tpr. `thresholds[0]` represents no instances being predicted
#     and is arbitrarily set to `max(y_score) + 1`.
#
# See Also
# --------
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
# det_curve: Compute error rates for different probability thresholds.
# roc_auc_score : Compute the area under the ROC curve.
#
# Notes
# -----
# Since the thresholds are sorted from low to high values, they
# are reversed upon returning them to ensure they correspond to both ``fpr``
# and ``tpr``, which are sorted in reversed order during their calculation.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] Fawcett T. An introduction to ROC analysis[J]. Pattern Recognition
#        Letters, 2006, 27(8):861-874.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn import metrics
# >>> y = np.array([1, 1, 2, 2])
# >>> scores = np.array([0.1, 0.4, 0.35, 0.8])
# >>> fpr, tpr, thresholds = metrics.roc_curve(y, scores, pos_label=2)
# >>> fpr
# array([0. , 0. , 0.5, 0.5, 1. ])
# >>> tpr
# array([0. , 0.5, 0.5, 1. , 1. ])
# >>> thresholds
# array([1.8 , 0.8 , 0.4 , 0.35, 0.1 ])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u></summary>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold.split</u></summary>
# <blockquote>
# <code>
# Generate indices to split data into training and test set.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Training data, where `n_samples` is the number of samples
#     and `n_features` is the number of features.
#
#     Note that providing ``y`` is sufficient to generate the splits and
#     hence ``np.zeros(n_samples)`` may be used as a placeholder for
#     ``X`` instead of actual training data.
#
# y : array-like of shape (n_samples,)
#     The target variable for supervised learning problems.
#     Stratification is done based on the y labels.
#
# groups : object
#     Always ignored, exists for compatibility.
#
# Yields
# ------
# train : ndarray
#     The training set indices for that split.
#
# test : ndarray
#     The testing set indices for that split.
#
# Notes
# -----
# Randomized CV splitters may return different results for each call of
# split. You can make the results identical by setting `random_state`
# to an integer.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing</u></summary>
# <blockquote>
# <code>
# The :mod:`sklearn.preprocessing` module includes scaling, centering,
# normalization, binarization methods.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.fit</u></summary>
# <blockquote>
# <code>
# Compute the mean and std to be used for later scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix} of shape (n_samples, n_features)
#     The data used to compute the mean and standard deviation
#     used for later scaling along the features axis.
#
# y : None
#     Ignored.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Individual weights for each sample.
#
#     .. versionadded:: 0.24
#        parameter *sample_weight* support to StandardScaler.
#
# Returns
# -------
# self : object
#     Fitted scaler.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>tensorflow</b>
# <ul>
# <li>
# <details><summary><u>tensorflow</u></summary>
# <blockquote>
# <code>
# Top-level module of TensorFlow. By convention, we refer to this module as
# `tf` instead of `tensorflow`, following the common practice of importing
# TensorFlow via the command `import tensorflow as tf`.
#
# The primary function of this module is to import all of the public TensorFlow
# interfaces into a single place. The interfaces themselves are located in
# sub-modules, as described below.
#
# Note that the file `__init__.py` in the TensorFlow source code tree is actually
# only a placeholder to enable test cases to run. The TensorFlow build replaces
# this file with a file generated from [`api_template.__init__.py`](https://www.github.com/tensorflow/tensorflow/blob/master/tensorflow/api_template.__init__.py)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>warnings</b>
# <ul>
# <li>
# <details><summary><u>warnings.filterwarnings</u></summary>
# <blockquote>
# <code>
# Insert an entry into the list of warnings filters (at the front).
#
# 'action' -- one of "error", "ignore", "always", "default", "module",
#             or "once"
# 'message' -- a regex that the warning message must match
# 'category' -- a class that the warning must be a subclass of
# 'module' -- a regex that the module name must match
# 'lineno' -- an integer line number, 0 matches all warnings
# 'append' -- if true, append to the list of filters
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>posix</h2>
# <ul>
# <li>
# <details><summary><u>posix.listdir</u></summary>
# <blockquote>
# <code>
# Return a list containing the names of the files in the directory.
#
# path can be specified as either str, bytes, or a path-like object.  If path is bytes,
#   the filenames returned will also be bytes; in all other circumstances
#   the filenames returned will be str.
# If path is None, uses the path='.'.
# On some platforms, path may also be specified as an open file descriptor;\
#   the file descriptor must refer to a directory.
#   If this functionality is unavailable, using it raises NotImplementedError.
#
# The list is in arbitrary order.  It does not include the special
# entries '.' and '..' even if they are present in the directory.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>warnings</h2>
# <ul>
# <li>
# <details><summary><u>warnings.filterwarnings</u></summary>
# <blockquote>
# <code>
# Insert an entry into the list of warnings filters (at the front).
#
# 'action' -- one of "error", "ignore", "always", "default", "module",
#             or "once"
# 'message' -- a regex that the warning message must match
# 'category' -- a class that the warning must be a subclass of
# 'module' -- a regex that the module name must match
# 'lineno' -- an integer line number, 0 matches all warnings
# 'append' -- if true, append to the list of filters
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
# This Python 3 environment comes with many helpful analytics libraries installed
# It is defined by the kaggle/python docker image: https://github.com/kaggle/docker-python
# For example, here's several helpful packages to load in 

import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)
from tqdm import tqdm, tqdm_notebook

# Input data files are available in the "../input/" directory.
# For example, running this (by clicking run or pressing Shift+Enter) will list the files in the input directory

import os
print(os.listdir("../input"))
import gc


# Any results you write to the current directory are saved as output.
import tensorflow as tf
from sklearn.model_selection import train_test_split, StratifiedKFold
from sklearn.preprocessing import StandardScaler
from keras import layers
from keras import backend as K
from keras import regularizers
from keras.constraints import max_norm
from keras.models import Sequential
from keras.callbacks import ModelCheckpoint, LearningRateScheduler, EarlyStopping, ReduceLROnPlateau
from keras.models import load_model
from keras.models import Model
from keras.initializers import glorot_uniform
from keras.layers import Input,Dense,Activation,ZeroPadding2D,BatchNormalization,Flatten,Conv2D,AveragePooling2D,MaxPooling2D,Dropout,concatenate
from sklearn import preprocessing

import matplotlib.pyplot as plt
from sklearn.metrics import roc_curve
#from sklearn.metrics import auc
from sklearn.metrics import roc_auc_score

import warnings
warnings.filterwarnings("ignore")



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Model Building and Training | Visualization</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u></summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u></summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u></summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u></summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlim</u></summary>
# <blockquote>
# <code>
# Get or set the x limits of the current axes.
#
# Call signatures::
#
#     left, right = xlim()  # return the current xlim
#     xlim((left, right))   # set the xlim to left, right
#     xlim(left, right)     # set the xlim to left, right
#
# If you do not specify args, you can pass *left* or *right* as kwargs,
# i.e.::
#
#     xlim(right=3)  # adjust the right leaving left unchanged
#     xlim(left=1)  # adjust the left leaving right unchanged
#
# Setting limits turns autoscaling off for the x-axis.
#
# Returns
# -------
# left, right
#     A tuple of the new x-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``xlim()``) is the pyplot
# equivalent of calling `~.Axes.get_xlim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_xlim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylim</u></summary>
# <blockquote>
# <code>
# Get or set the y-limits of the current axes.
#
# Call signatures::
#
#     bottom, top = ylim()  # return the current ylim
#     ylim((bottom, top))   # set the ylim to bottom, top
#     ylim(bottom, top)     # set the ylim to bottom, top
#
# If you do not specify args, you can alternatively pass *bottom* or
# *top* as kwargs, i.e.::
#
#     ylim(top=3)  # adjust the top leaving bottom unchanged
#     ylim(bottom=1)  # adjust the bottom leaving top unchanged
#
# Setting limits turns autoscaling off for the y-axis.
#
# Returns
# -------
# bottom, top
#     A tuple of the new y-axis limits.
#
# Notes
# -----
# Calling this function with no arguments (e.g. ``ylim()``) is the pyplot
# equivalent of calling `~.Axes.get_ylim` on the current axes.
# Calling this function with arguments is the pyplot equivalent of calling
# `~.Axes.set_ylim` on the current axes. All arguments are passed though.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
# define helper functions. auc, plot_history
def auc(y_true, y_pred):
    #auc = tf.metrics.auc(y_true, y_pred)[1]
    y_pred = y_pred.ravel()
    y_true = y_true.ravel()
    return roc_auc_score(y_true, y_pred)

def auc_2(y_true, y_pred):
    return tf.py_func(roc_auc_score, (y_true, y_pred), tf.double)

def plot_history(histories, key='binary_crossentropy'):
    plt.figure(figsize=(16,10))
    #plt.plot([0, 1], [0, 1], 'k--')
    for name, history in histories:
        val = plt.plot(history.epoch, history.history['val_'+key], '--', label=name.title()+' Val')

    plt.plot(history.epoch, history.history[key], color=val[0].get_color(), label=name.title()+' Train')

    plt.xlabel('Epochs')
    plt.ylabel(key.replace('_',' ').title())
    plt.legend()

    plt.xlim([0,max(history.epoch)])
    plt.ylim([0, 0.4])
    plt.show()



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>3. Data Preparation</h1>  <a id='3'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _cell_guid="79c7e3d0-c299-4dcb-8224-4455121ee9b0" _uuid="d629ff2d2480ee46fbb7e2d37f6b5fab8052498a"
# load data 
train_df = pd.read_csv('../input/train.csv')
test_df =  pd.read_csv("../input/test.csv")
base_features = [x for x in train_df.columns.values.tolist() if x.startswith('var_')]


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Data Preparation | Feature Engineering</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.min</u></summary>
# <blockquote>
# <code>
# Return the minimum of the values over the requested axis.
#
# If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.min()
# 0
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u></summary>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.append</u></summary>
# <blockquote>
# <code>
# Append rows of `other` to the end of caller, returning a new object.
#
# .. deprecated:: 1.4.0
#     Use :func:`concat` instead. For further details see
#     :ref:`whatsnew_140.deprecations.frame_series_append`
#
# Columns in `other` that are not in the caller are added as new columns.
#
# Parameters
# ----------
# other : DataFrame or Series/dict-like object, or list of these
#     The data to append.
# ignore_index : bool, default False
#     If True, the resulting axis will be labeled 0, 1, …, n - 1.
# verify_integrity : bool, default False
#     If True, raise ValueError on creating index with duplicates.
# sort : bool, default False
#     Sort columns if the columns of `self` and `other` are not aligned.
#
#     .. versionchanged:: 1.0.0
#
#         Changed to not sort by default.
#
# Returns
# -------
# DataFrame
#     A new DataFrame consisting of the rows of caller and the rows of `other`.
#
# See Also
# --------
# concat : General function to concatenate DataFrame or Series objects.
#
# Notes
# -----
# If a list of dict/series is passed and the keys are all contained in
# the DataFrame's index, the order of the columns in the resulting
# DataFrame will be unchanged.
#
# Iteratively appending rows to a DataFrame can be more computationally
# intensive than a single concatenate. A better solution is to append
# those rows to a list and then concatenate the list with the original
# DataFrame all at once.
#
# Examples
# --------
# >>> df = pd.DataFrame([[1, 2], [3, 4]], columns=list('AB'), index=['x', 'y'])
# >>> df
#    A  B
# x  1  2
# y  3  4
# >>> df2 = pd.DataFrame([[5, 6], [7, 8]], columns=list('AB'), index=['x', 'y'])
# >>> df.append(df2)
#    A  B
# x  1  2
# y  3  4
# x  5  6
# y  7  8
#
# With `ignore_index` set to True:
#
# >>> df.append(df2, ignore_index=True)
#    A  B
# 0  1  2
# 1  3  4
# 2  5  6
# 3  7  8
#
# The following, while not recommended methods for generating DataFrames,
# show two ways to generate a DataFrame from multiple data sources.
#
# Less efficient:
#
# >>> df = pd.DataFrame(columns=['A'])
# >>> for i in range(5):
# ...     df = df.append({'A': i}, ignore_index=True)
# >>> df
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# More efficient:
#
# >>> pd.concat([pd.DataFrame([i], columns=['A']) for i in range(5)],
# ...           ignore_index=True)
#    A
# 0  0
# 1  1
# 2  2
# 3  3
# 4  4
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _kg_hide-input=false
# mark real vs fake
train_df['real'] = 1

for col in base_features:
    test_df[col] = test_df[col].map(test_df[col].value_counts())
a = test_df[base_features].min(axis=1)

test_df = pd.read_csv('../input/test.csv')
test_df['real'] = (a == 1).astype('int')

train = train_df.append(test_df).reset_index(drop=True)
del test_df, train_df; gc.collect()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>5. Data Preparation | Feature Engineering</h1>  <a id='5'></a><small><a href='#top_phases'>back to top</a></small>

# %% _kg_hide-input=false
# count features
for col in tqdm(base_features):
    train[col + 'size'] = train[col].map(train.loc[train.real==1, col].value_counts())
cnt_features = [col + 'size' for col in base_features]

# %%
# magice features 1
for col in tqdm(base_features):
#        train[col+'size'] = train.groupby(col)['target'].transform('size')
    train.loc[train[col+'size']>1,col+'no_noise'] = train.loc[train[col+'size']>1,col]
noise1_features = [col + 'no_noise' for col in base_features]


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>7. Data Preparation | Feature Engineering</h1>  <a id='7'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u></summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
# fill NA as 0, inspired by lightgbm
train[noise1_features] = train[noise1_features].fillna(train[noise1_features].mean())

# %%
# magice features 2
for col in tqdm(base_features):
#        train[col+'size'] = train.groupby(col)['target'].transform('size')
    train.loc[train[col+'size']>2,col+'no_noise2'] = train.loc[train[col+'size']>2,col]
noise2_features = [col + 'no_noise2' for col in base_features]


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>9. Data Preparation | Feature Engineering</h1>  <a id='9'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u></summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
# fill NA as 0, inspired by lightgbm
train[noise2_features] = train[noise2_features].fillna(train[noise2_features].mean())


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>10. Data Preparation</h1>  <a id='10'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.notnull</u></summary>
# <blockquote>
# <code>
# Series.notnull is an alias for Series.notna.
#
# Detect existing (non-missing) values.
#
# Return a boolean same-sized object indicating if the values are not NA.
# Non-missing values get mapped to True. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
# NA values, such as None or :attr:`numpy.NaN`, get mapped to False
# values.
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is not an NA value.
#
# See Also
# --------
# Series.notnull : Alias of notna.
# Series.isna : Boolean inverse of notna.
# Series.dropna : Omit axes labels with missing values.
# notna : Top-level notna.
#
# Examples
# --------
# Show which entries in a DataFrame are not NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.notna()
#      age   born  name    toy
# 0   True  False  True  False
# 1   True   True  True   True
# 2  False   True  True   True
#
# Show which entries in a Series are not NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.notna()
# 0     True
# 1     True
# 2    False
# dtype: bool
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.isnull</u></summary>
# <blockquote>
# <code>
# Series.isnull is an alias for Series.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# Series
#     Mask of bool values for each element in Series that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# Series.isnull : Alias of isna.
# Series.notna : Boolean inverse of isna.
# Series.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
train_df = train[train['target'].notnull()]
test_df = train[train['target'].isnull()]
all_features = base_features + noise1_features + noise2_features


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>11. Data Preparation</h1>  <a id='11'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.fit</u></summary>
# <blockquote>
# <code>
# Compute the mean and std to be used for later scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix} of shape (n_samples, n_features)
#     The data used to compute the mean and standard deviation
#     used for later scaling along the features axis.
#
# y : None
#     Ignored.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Individual weights for each sample.
#
#     .. versionadded:: 0.24
#        parameter *sample_weight* support to StandardScaler.
#
# Returns
# -------
# self : object
#     Fitted scaler.
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="39098e416885d4b96182c53292355a0e49cb0086"
scaler = preprocessing.StandardScaler().fit(train_df[all_features].values)
df_trn = pd.DataFrame(scaler.transform(train_df[all_features].values), columns=all_features)
df_tst = pd.DataFrame(scaler.transform(test_df[all_features].values), columns=all_features)
y = train_df['target'].values



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>12. Data Preparation | Feature Engineering</h1>  <a id='12'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u></summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.array</u></summary>
# <blockquote>
# <code>
# array(object, dtype=None, *, copy=True, order='K', subok=False, ndmin=0,
#       like=None)
#
# Create an array.
#
# Parameters
# ----------
# object : array_like
#     An array, any object exposing the array interface, an object whose
#     __array__ method returns an array, or any (nested) sequence.
#     If object is a scalar, a 0-dimensional array containing object is
#     returned.
# dtype : data-type, optional
#     The desired data-type for the array.  If not given, then the type will
#     be determined as the minimum type required to hold the objects in the
#     sequence.
# copy : bool, optional
#     If true (default), then the object is copied.  Otherwise, a copy will
#     only be made if __array__ returns a copy, if obj is a nested sequence,
#     or if a copy is needed to satisfy any of the other requirements
#     (`dtype`, `order`, etc.).
# order : {'K', 'A', 'C', 'F'}, optional
#     Specify the memory layout of the array. If object is not an array, the
#     newly created array will be in C order (row major) unless 'F' is
#     specified, in which case it will be in Fortran order (column major).
#     If object is an array the following holds.
#
#     ===== ========= ===================================================
#     order  no copy                     copy=True
#     ===== ========= ===================================================
#     'K'   unchanged F & C order preserved, otherwise most similar order
#     'A'   unchanged F order if input is F and not C, otherwise C order
#     'C'   C order   C order
#     'F'   F order   F order
#     ===== ========= ===================================================
#
#     When ``copy=False`` and a copy is made for other reasons, the result is
#     the same as if ``copy=True``, with some exceptions for 'A', see the
#     Notes section. The default order is 'K'.
# subok : bool, optional
#     If True, then sub-classes will be passed-through, otherwise
#     the returned array will be forced to be a base-class array (default).
# ndmin : int, optional
#     Specifies the minimum number of dimensions that the resulting
#     array should have.  Ones will be pre-pended to the shape as
#     needed to meet this requirement.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     An array object satisfying the specified requirements.
#
# See Also
# --------
# empty_like : Return an empty array with shape and type of input.
# ones_like : Return an array of ones with shape and type of input.
# zeros_like : Return an array of zeros with shape and type of input.
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Notes
# -----
# When order is 'A' and `object` is an array in neither 'C' nor 'F' order,
# and a copy is forced by a change in dtype, then the order of the result is
# not necessarily 'C' as expected. This is likely a bug.
#
# Examples
# --------
# >>> np.array([1, 2, 3])
# array([1, 2, 3])
#
# Upcasting:
#
# >>> np.array([1, 2, 3.0])
# array([ 1.,  2.,  3.])
#
# More than one dimension:
#
# >>> np.array([[1, 2], [3, 4]])
# array([[1, 2],
#        [3, 4]])
#
# Minimum dimensions 2:
#
# >>> np.array([1, 2, 3], ndmin=2)
# array([[1, 2, 3]])
#
# Type provided:
#
# >>> np.array([1, 2, 3], dtype=complex)
# array([ 1.+0.j,  2.+0.j,  3.+0.j])
#
# Data-type consisting of more than one element:
#
# >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
# >>> x['a']
# array([1, 3])
#
# Creating an array from sub-classes:
#
# >>> np.array(np.mat('1 2; 3 4'))
# array([[1, 2],
#        [3, 4]])
#
# >>> np.array(np.mat('1 2; 3 4'), subok=True)
# matrix([[1, 2],
#         [3, 4]])
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
def get_keras_data(dataset, cols_info):
    X = {}
    base_feats, noise_feats, noise2_feats = cols_info
    X['base'] = np.reshape(np.array(dataset[base_feats].values), (-1, len(base_feats), 1))
    X['noise1'] = np.reshape(np.array(dataset[noise_feats].values), (-1, len(noise_feats), 1))
    X['noise2'] = np.reshape(np.array(dataset[noise2_feats].values), (-1, len(noise2_feats), 1))
    return X



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>13. Data Preparation | Feature Engineering</h1>  <a id='13'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.reshape</u></summary>
# <blockquote>
# <code>
# Gives a new shape to an array without changing its data.
#
# Parameters
# ----------
# a : array_like
#     Array to be reshaped.
# newshape : int or tuple of ints
#     The new shape should be compatible with the original shape. If
#     an integer, then the result will be a 1-D array of that length.
#     One shape dimension can be -1. In this case, the value is
#     inferred from the length of the array and remaining dimensions.
# order : {'C', 'F', 'A'}, optional
#     Read the elements of `a` using this index order, and place the
#     elements into the reshaped array using this index order.  'C'
#     means to read / write the elements using C-like index order,
#     with the last axis index changing fastest, back to the first
#     axis index changing slowest. 'F' means to read / write the
#     elements using Fortran-like index order, with the first index
#     changing fastest, and the last index changing slowest. Note that
#     the 'C' and 'F' options take no account of the memory layout of
#     the underlying array, and only refer to the order of indexing.
#     'A' means to read / write the elements in Fortran-like index
#     order if `a` is Fortran *contiguous* in memory, C-like order
#     otherwise.
#
# Returns
# -------
# reshaped_array : ndarray
#     This will be a new view object if possible; otherwise, it will
#     be a copy.  Note there is no guarantee of the *memory layout* (C- or
#     Fortran- contiguous) of the returned array.
#
# See Also
# --------
# ndarray.reshape : Equivalent method.
#
# Notes
# -----
# It is not always possible to change the shape of an array without
# copying the data. If you want an error to be raised when the data is copied,
# you should assign the new shape to the shape attribute of the array::
#
#  >>> a = np.zeros((10, 2))
#
#  # A transpose makes the array non-contiguous
#  >>> b = a.T
#
#  # Taking a view makes it possible to modify the shape without modifying
#  # the initial object.
#  >>> c = b.view()
#  >>> c.shape = (20)
#  Traceback (most recent call last):
#     ...
#  AttributeError: Incompatible shape for in-place modification. Use
#  `.reshape()` to make a copy with the desired shape.
#
# The `order` keyword gives the index ordering both for *fetching* the values
# from `a`, and then *placing* the values into the output array.
# For example, let's say you have an array:
#
# >>> a = np.arange(6).reshape((3, 2))
# >>> a
# array([[0, 1],
#        [2, 3],
#        [4, 5]])
#
# You can think of reshaping as first raveling the array (using the given
# index order), then inserting the elements from the raveled array into the
# new array using the same kind of index ordering as was used for the
# raveling.
#
# >>> np.reshape(a, (2, 3)) # C-like index ordering
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(np.ravel(a), (2, 3)) # equivalent to C ravel then C reshape
# array([[0, 1, 2],
#        [3, 4, 5]])
# >>> np.reshape(a, (2, 3), order='F') # Fortran-like index ordering
# array([[0, 4, 3],
#        [2, 1, 5]])
# >>> np.reshape(np.ravel(a, order='F'), (2, 3), order='F')
# array([[0, 4, 3],
#        [2, 1, 5]])
#
# Examples
# --------
# >>> a = np.array([[1,2,3], [4,5,6]])
# >>> np.reshape(a, 6)
# array([1, 2, 3, 4, 5, 6])
# >>> np.reshape(a, 6, order='F')
# array([1, 4, 2, 5, 3, 6])
#
# >>> np.reshape(a, (3,-1))       # the unspecified value is inferred to be 2
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.array</u></summary>
# <blockquote>
# <code>
# array(object, dtype=None, *, copy=True, order='K', subok=False, ndmin=0,
#       like=None)
#
# Create an array.
#
# Parameters
# ----------
# object : array_like
#     An array, any object exposing the array interface, an object whose
#     __array__ method returns an array, or any (nested) sequence.
#     If object is a scalar, a 0-dimensional array containing object is
#     returned.
# dtype : data-type, optional
#     The desired data-type for the array.  If not given, then the type will
#     be determined as the minimum type required to hold the objects in the
#     sequence.
# copy : bool, optional
#     If true (default), then the object is copied.  Otherwise, a copy will
#     only be made if __array__ returns a copy, if obj is a nested sequence,
#     or if a copy is needed to satisfy any of the other requirements
#     (`dtype`, `order`, etc.).
# order : {'K', 'A', 'C', 'F'}, optional
#     Specify the memory layout of the array. If object is not an array, the
#     newly created array will be in C order (row major) unless 'F' is
#     specified, in which case it will be in Fortran order (column major).
#     If object is an array the following holds.
#
#     ===== ========= ===================================================
#     order  no copy                     copy=True
#     ===== ========= ===================================================
#     'K'   unchanged F & C order preserved, otherwise most similar order
#     'A'   unchanged F order if input is F and not C, otherwise C order
#     'C'   C order   C order
#     'F'   F order   F order
#     ===== ========= ===================================================
#
#     When ``copy=False`` and a copy is made for other reasons, the result is
#     the same as if ``copy=True``, with some exceptions for 'A', see the
#     Notes section. The default order is 'K'.
# subok : bool, optional
#     If True, then sub-classes will be passed-through, otherwise
#     the returned array will be forced to be a base-class array (default).
# ndmin : int, optional
#     Specifies the minimum number of dimensions that the resulting
#     array should have.  Ones will be pre-pended to the shape as
#     needed to meet this requirement.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     An array object satisfying the specified requirements.
#
# See Also
# --------
# empty_like : Return an empty array with shape and type of input.
# ones_like : Return an array of ones with shape and type of input.
# zeros_like : Return an array of zeros with shape and type of input.
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Notes
# -----
# When order is 'A' and `object` is an array in neither 'C' nor 'F' order,
# and a copy is forced by a change in dtype, then the order of the result is
# not necessarily 'C' as expected. This is likely a bug.
#
# Examples
# --------
# >>> np.array([1, 2, 3])
# array([1, 2, 3])
#
# Upcasting:
#
# >>> np.array([1, 2, 3.0])
# array([ 1.,  2.,  3.])
#
# More than one dimension:
#
# >>> np.array([[1, 2], [3, 4]])
# array([[1, 2],
#        [3, 4]])
#
# Minimum dimensions 2:
#
# >>> np.array([1, 2, 3], ndmin=2)
# array([[1, 2, 3]])
#
# Type provided:
#
# >>> np.array([1, 2, 3], dtype=complex)
# array([ 1.+0.j,  2.+0.j,  3.+0.j])
#
# Data-type consisting of more than one element:
#
# >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])
# >>> x['a']
# array([1, 3])
#
# Creating an array from sub-classes:
#
# >>> np.array(np.mat('1 2; 3 4'))
# array([[1, 2],
#        [3, 4]])
#
# >>> np.array(np.mat('1 2; 3 4'), subok=True)
# matrix([[1, 2],
#         [3, 4]])
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
cols_info = [base_features, noise1_features, noise2_features]
#X = get_keras_data(df_trn[all_features], cols_info)
X_test = get_keras_data(df_tst[all_features], cols_info)



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>14. Model Building and Training</h1>  <a id='14'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u></summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.activation.Activation</u></summary>
# <blockquote>
# <code>
# Applies an activation function to an output.
#
# Args:
#   activation: Activation function, such as `tf.nn.relu`, or string name of
#     built-in activation function, such as "relu".
#
# Usage:
#
# >>> layer = tf.keras.layers.Activation('relu')
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
# >>> layer = tf.keras.layers.Activation(tf.nn.relu)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u></summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.merge.concatenate</u></summary>
# <blockquote>
# <code>
# Functional interface to the `Concatenate` layer.
#
# >>> x = np.arange(20).reshape(2, 2, 5)
# >>> print(x)
# [[[ 0  1  2  3  4]
#   [ 5  6  7  8  9]]
#  [[10 11 12 13 14]
#   [15 16 17 18 19]]]
# >>> y = np.arange(20, 30).reshape(2, 1, 5)
# >>> print(y)
# [[[20 21 22 23 24]]
#  [[25 26 27 28 29]]]
# >>> tf.keras.layers.concatenate([x, y],
# ...                             axis=1)
# <tf.Tensor: shape=(2, 3, 5), dtype=int64, numpy=
# array([[[ 0,  1,  2,  3,  4],
#       [ 5,  6,  7,  8,  9],
#       [20, 21, 22, 23, 24]],
#      [[10, 11, 12, 13, 14],
#       [15, 16, 17, 18, 19],
#       [25, 26, 27, 28, 29]]])>
#
# Args:
#     inputs: A list of input tensors (at least 2).
#     axis: Concatenation axis.
#     **kwargs: Standard layer keyword arguments.
#
# Returns:
#     A tensor, the concatenation of the inputs alongside axis `axis`.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u></summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="3afd722cdfbd3a200f5b33dcff2fe33635d02002"
# define network structure -> 2D CNN
def Convnet(cols_info, classes=1):
    base_feats, noise1_feats, noise2_feats = cols_info
    
    # base_feats
    X_base_input = Input(shape=(len(base_feats), 1), name='base')
    X_base = Dense(16)(X_base_input)
    X_base = Activation('relu')(X_base)
    X_base = Flatten(name='base_last')(X_base)
    
    # noise1
    X_noise1_input = Input(shape=(len(noise1_feats), 1), name='noise1')
    X_noise1 = Dense(16)(X_noise1_input)
    X_noise1 = Activation('relu')(X_noise1)
    X_noise1 = Flatten(name='nose1_last')(X_noise1)
    
    # noise2
    X_noise2_input = Input(shape=(len(noise2_feats), 1), name='noise2')
    X_noise2 = Dense(16)(X_noise2_input)
    X_noise2 = Activation('relu')(X_noise2)
    X_noise2 = Flatten(name='nose2_last')(X_noise2)
    
    
    X = concatenate([X_base, X_noise1, X_noise2])
    X = Dense(classes, activation='sigmoid')(X)
    
    model = Model(inputs=[X_base_input, X_noise1_input, X_noise2_input],outputs=X)
    
    return model
model = Convnet(cols_info)
model.summary()

# %% _uuid="d2579e2c0abf8be1f0bbe1eec545394475e37568"
try:
    del df_tst
except:
    pass
gc.collect()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>16. Data Preparation</h1>  <a id='16'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u></summary>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="301805e7d06a14a7ac9087079a2eb1a839626519"
# parameters
SEED = 2019
n_folds = 5
debug_flag = True
folds = 5
skf = StratifiedKFold(n_splits=n_folds, shuffle=True, random_state=SEED)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>17. Data Preparation | Feature Engineering | Model Building and Training</h1>  <a id='17'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#17'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="471b1116f2311ea8f757ee041ec9052aebc9ca57"
#transformed_shape = tuple([-1] + list(shape))
#X_test = np.reshape(X_test, transformed_shape)

i = 0
result = pd.DataFrame({"ID_code": test_df.ID_code.values})
val_aucs = []
valid_X = train_df[['target']]
valid_X['predict'] = 0
for train_idx, val_idx in skf.split(df_trn, y):
    if i == folds:
        break
    i += 1    
    X_train, y_train = df_trn.iloc[train_idx], y[train_idx]
    X_valid, y_valid = df_trn.iloc[val_idx], y[val_idx]
    
    X_train = get_keras_data(X_train, cols_info)
    X_valid = get_keras_data(X_valid, cols_info)
    #X_train = np.reshape(X_train, transformed_shape)
    #X_valid = np.reshape(X_valid, transformed_shape)
    
    model_name = 'NN_fold{}.h5'.format(str(i))
    
    model = Convnet(cols_info)
    model.compile(loss='binary_crossentropy', optimizer='adam', metrics=['accuracy', 'binary_crossentropy', auc_2])
    checkpoint = ModelCheckpoint(model_name, monitor='val_auc_2', verbose=1, 
                                 save_best_only=True, mode='max', save_weights_only = True)
    reduceLROnPlat = ReduceLROnPlateau(monitor='val_loss', factor=0.5, patience=4, 
                                       verbose=1, mode='min', epsilon=0.0001)
    earlystop = EarlyStopping(monitor='val_auc_2', mode='max', patience=10, verbose=1)
    history = model.fit(X_train, y_train, 
                        epochs=300, 
                        batch_size=1024 * 2, 
                        validation_data=(X_valid, y_valid), 
                        callbacks=[checkpoint, reduceLROnPlat, earlystop])
    train_history = pd.DataFrame(history.history)
    train_history.to_csv('train_profile_fold{}.csv'.format(str(i)), index=None)
    
    # load and predict
    model.load_weights(model_name)
    
    #predict
    y_pred_keras = model.predict(X_valid).ravel()
    
    # AUC
    valid_X['predict'].iloc[val_idx] = y_pred_keras
    
    fpr_keras, tpr_keras, thresholds_keras = roc_curve(y_valid, y_pred_keras)
    auc_valid = roc_auc_score(y_valid, y_pred_keras)
    val_aucs.append(auc_valid)
    
    prediction = model.predict(X_test)
    result["fold{}".format(str(i))] = prediction

# %% _uuid="cf12c8076b868e0f1228fd2884b14f86a87c0c0a"
for i in range(len(val_aucs)):
    print('Fold_%d AUC: %.6f' % (i+1, val_aucs[i]))


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>19. Data Preparation | Model Building and Training</h1>  <a id='19'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#19'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.std</u></summary>
# <blockquote>
# <code>
# Compute the standard deviation along the specified axis.
#
# Returns the standard deviation, a measure of the spread of a distribution,
# of the array elements. The standard deviation is computed for the
# flattened array by default, otherwise over the specified axis.
#
# Parameters
# ----------
# a : array_like
#     Calculate the standard deviation of these values.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the standard deviation is computed. The
#     default is to compute the standard deviation of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a standard deviation is performed over
#     multiple axes, instead of a single axis or all the axes as before.
# dtype : dtype, optional
#     Type to use in computing the standard deviation. For arrays of
#     integer type the default is float64, for arrays of float types it is
#     the same as the array type.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output but the type (of the calculated
#     values) will be cast if necessary.
# ddof : int, optional
#     Means Delta Degrees of Freedom.  The divisor used in calculations
#     is ``N - ddof``, where ``N`` represents the number of elements.
#     By default `ddof` is zero.
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `std` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the standard deviation.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# standard_deviation : ndarray, see dtype parameter above.
#     If `out` is None, return a new array containing the standard deviation,
#     otherwise return a reference to the output array.
#
# See Also
# --------
# var, mean, nanmean, nanstd, nanvar
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# The standard deviation is the square root of the average of the squared
# deviations from the mean, i.e., ``std = sqrt(mean(x))``, where
# ``x = abs(a - a.mean())**2``.
#
# The average squared deviation is typically calculated as ``x.sum() / N``,
# where ``N = len(x)``. If, however, `ddof` is specified, the divisor
# ``N - ddof`` is used instead. In standard statistical practice, ``ddof=1``
# provides an unbiased estimator of the variance of the infinite population.
# ``ddof=0`` provides a maximum likelihood estimate of the variance for
# normally distributed variables. The standard deviation computed in this
# function is the square root of the estimated variance, so even with
# ``ddof=1``, it will not be an unbiased estimate of the standard deviation
# per se.
#
# Note that, for complex numbers, `std` takes the absolute
# value before squaring, so that the result is always real and nonnegative.
#
# For floating-point input, the *std* is computed using the same
# precision the input has. Depending on the input data, this can cause
# the results to be inaccurate, especially for float32 (see example below).
# Specifying a higher-accuracy accumulator using the `dtype` keyword can
# alleviate this issue.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.std(a)
# 1.1180339887498949 # may vary
# >>> np.std(a, axis=0)
# array([1.,  1.])
# >>> np.std(a, axis=1)
# array([0.5,  0.5])
#
# In single precision, std() can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.std(a)
# 0.45000005
#
# Computing the standard deviation in float64 is more accurate:
#
# >>> np.std(a, dtype=np.float64)
# 0.44999999925494177 # may vary
#
# Specifying a where argument:
#
# >>> a = np.array([[14, 8, 11, 10], [7, 9, 10, 11], [10, 15, 5, 10]])
# >>> np.std(a)
# 2.614064523559687 # may vary
# >>> np.std(a, where=[[True], [True], [False]])
# 2.0
#
# </code>
# <a href='#19'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u></summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#19'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="f5b28c3ad1a96e4edd711546667cbac1527d57c8"
# summary on results
auc_mean = np.mean(val_aucs)
auc_std = np.std(val_aucs)
auc_all = roc_auc_score(valid_X.target, valid_X.predict)
print('%d-fold auc mean: %.9f, std: %.9f. All auc: %6f.' % (n_folds, auc_mean, auc_std, auc_all))


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>20. Data Preparation</h1>  <a id='20'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#20'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#20'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="e978483f1836a293a76bcf54d27cec81905a3667"
y_all = result.values[:, 1:]
result['target'] = np.mean(y_all, axis = 1)
to_submit = result[['ID_code', 'target']]
to_submit.to_csv('NN_submission.csv', index=None)
result.to_csv('NN_all_prediction.csv', index=None)
valid_X['ID_code'] = train_df['ID_code']
valid_X = valid_X[['ID_code', 'target', 'predict']].to_csv('NN_oof.csv', index=None)

# %% _uuid="bc08d7dc3cce9901126e935471f94203e48804ea"
