# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>gc</b></li>
# <li><b>keras</b></li>
# <li><b>matplotlib</b></li>
# <li><b>numpy</b></li>
# <li><b>os</b></li>
# <li><b>pandas</b></li>
# <li><b>sklearn</b></li>
# <li><b>time</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Visualization</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Visualization" Calls</u></b></summary>
# <ul>
#
#
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.merge.merge</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'how': 'left', 'on': ['item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'how': 'left', 'on': ['item_id', 'shop_id']}</li></ul>
# <blockquote>
# <code>
# Merge DataFrame or named Series objects with a database-style join.
#
# A named Series object is treated as a DataFrame with a single named column.
#
# The join is done on columns or indexes. If joining columns on
# columns, the DataFrame indexes *will be ignored*. Otherwise if joining indexes
# on indexes or indexes on a column or columns, the index will be passed on.
# When performing a cross merge, no column specifications to merge on are
# allowed.
#
# .. warning::
#
#     If both key columns contain rows where the key is a null value, those
#     rows will be matched against each other. This is different from usual SQL
#     join behaviour and can lead to unexpected results.
#
# Parameters
# ----------
# left : DataFrame
# right : DataFrame or named Series
#     Object to merge with.
# how : {'left', 'right', 'outer', 'inner', 'cross'}, default 'inner'
#     Type of merge to be performed.
#
#     * left: use only keys from left frame, similar to a SQL left outer join;
#       preserve key order.
#     * right: use only keys from right frame, similar to a SQL right outer join;
#       preserve key order.
#     * outer: use union of keys from both frames, similar to a SQL full outer
#       join; sort keys lexicographically.
#     * inner: use intersection of keys from both frames, similar to a SQL inner
#       join; preserve the order of the left keys.
#     * cross: creates the cartesian product from both frames, preserves the order
#       of the left keys.
#
#       .. versionadded:: 1.2.0
#
# on : label or list
#     Column or index level names to join on. These must be found in both
#     DataFrames. If `on` is None and not merging on indexes then this defaults
#     to the intersection of the columns in both DataFrames.
# left_on : label or list, or array-like
#     Column or index level names to join on in the left DataFrame. Can also
#     be an array or list of arrays of the length of the left DataFrame.
#     These arrays are treated as if they are columns.
# right_on : label or list, or array-like
#     Column or index level names to join on in the right DataFrame. Can also
#     be an array or list of arrays of the length of the right DataFrame.
#     These arrays are treated as if they are columns.
# left_index : bool, default False
#     Use the index from the left DataFrame as the join key(s). If it is a
#     MultiIndex, the number of keys in the other DataFrame (either the index
#     or a number of columns) must match the number of levels.
# right_index : bool, default False
#     Use the index from the right DataFrame as the join key. Same caveats as
#     left_index.
# sort : bool, default False
#     Sort the join keys lexicographically in the result DataFrame. If False,
#     the order of the join keys depends on the join type (how keyword).
# suffixes : list-like, default is ("_x", "_y")
#     A length-2 sequence where each element is optionally a string
#     indicating the suffix to add to overlapping column names in
#     `left` and `right` respectively. Pass a value of `None` instead
#     of a string to indicate that the column name from `left` or
#     `right` should be left as-is, with no suffix. At least one of the
#     values must not be None.
# copy : bool, default True
#     If False, avoid copy if possible.
# indicator : bool or str, default False
#     If True, adds a column to the output DataFrame called "_merge" with
#     information on the source of each row. The column can be given a different
#     name by providing a string argument. The column will have a Categorical
#     type with the value of "left_only" for observations whose merge key only
#     appears in the left DataFrame, "right_only" for observations
#     whose merge key only appears in the right DataFrame, and "both"
#     if the observation's merge key is found in both DataFrames.
#
# validate : str, optional
#     If specified, checks if merge is of specified type.
#
#     * "one_to_one" or "1:1": check if merge keys are unique in both
#       left and right datasets.
#     * "one_to_many" or "1:m": check if merge keys are unique in left
#       dataset.
#     * "many_to_one" or "m:1": check if merge keys are unique in right
#       dataset.
#     * "many_to_many" or "m:m": allowed, but does not result in checks.
#
# Returns
# -------
# DataFrame
#     A DataFrame of the two merged objects.
#
# See Also
# --------
# merge_ordered : Merge with optional filling/interpolation.
# merge_asof : Merge on nearest keys.
# DataFrame.join : Similar method using indices.
#
# Notes
# -----
# Support for specifying index levels as the `on`, `left_on`, and
# `right_on` parameters was added in version 0.23.0
# Support for merging named Series objects was added in version 0.24.0
#
# Examples
# --------
# >>> df1 = pd.DataFrame({'lkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [1, 2, 3, 5]})
# >>> df2 = pd.DataFrame({'rkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [5, 6, 7, 8]})
# >>> df1
#     lkey value
# 0   foo      1
# 1   bar      2
# 2   baz      3
# 3   foo      5
# >>> df2
#     rkey value
# 0   foo      5
# 1   bar      6
# 2   baz      7
# 3   foo      8
#
# Merge df1 and df2 on the lkey and rkey columns. The value columns have
# the default suffixes, _x and _y, appended.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey')
#   lkey  value_x rkey  value_y
# 0  foo        1  foo        5
# 1  foo        1  foo        8
# 2  foo        5  foo        5
# 3  foo        5  foo        8
# 4  bar        2  bar        6
# 5  baz        3  baz        7
#
# Merge DataFrames df1 and df2 with specified left and right suffixes
# appended to any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey',
# ...           suffixes=('_left', '_right'))
#   lkey  value_left rkey  value_right
# 0  foo           1  foo            5
# 1  foo           1  foo            8
# 2  foo           5  foo            5
# 3  foo           5  foo            8
# 4  bar           2  bar            6
# 5  baz           3  baz            7
#
# Merge DataFrames df1 and df2, but raise an exception if the DataFrames have
# any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey', suffixes=(False, False))
# Traceback (most recent call last):
# ...
# ValueError: columns overlap but no suffix specified:
#     Index(['value'], dtype='object')
#
# >>> df1 = pd.DataFrame({'a': ['foo', 'bar'], 'b': [1, 2]})
# >>> df2 = pd.DataFrame({'a': ['foo', 'baz'], 'c': [3, 4]})
# >>> df1
#       a  b
# 0   foo  1
# 1   bar  2
# >>> df2
#       a  c
# 0   foo  3
# 1   baz  4
#
# >>> df1.merge(df2, how='inner', on='a')
#       a  b  c
# 0   foo  1  3
#
# >>> df1.merge(df2, how='left', on='a')
#       a  b  c
# 0   foo  1  3.0
# 1   bar  2  NaN
#
# >>> df1 = pd.DataFrame({'left': ['foo', 'bar']})
# >>> df2 = pd.DataFrame({'right': [7, 8]})
# >>> df1
#     left
# 0   foo
# 1   bar
# >>> df2
#     right
# 0   7
# 1   8
#
# >>> df1.merge(df2, how='cross')
#    left  right
# 0   foo      7
# 1   foo      8
# 2   bar      7
# 3   bar      8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.fillna</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index', 1 or 'columns'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# DataFrame or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.MinMaxScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Transform features by scaling each feature to a given range.
#
# This estimator scales and translates each feature individually such
# that it is in the given range on the training set, e.g. between
# zero and one.
#
# The transformation is given by::
#
#     X_std = (X - X.min(axis=0)) / (X.max(axis=0) - X.min(axis=0))
#     X_scaled = X_std * (max - min) + min
#
# where min, max = feature_range.
#
# This transformation is often used as an alternative to zero mean,
# unit variance scaling.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# feature_range : tuple (min, max), default=(0, 1)
#     Desired range of transformed data.
#
# copy : bool, default=True
#     Set to False to perform inplace row normalization and avoid a
#     copy (if the input is already a numpy array).
#
# clip : bool, default=False
#     Set to True to clip transformed values of held-out data to
#     provided `feature range`.
#
#     .. versionadded:: 0.24
#
# Attributes
# ----------
# min_ : ndarray of shape (n_features,)
#     Per feature adjustment for minimum. Equivalent to
#     ``min - X.min(axis=0) * self.scale_``
#
# scale_ : ndarray of shape (n_features,)
#     Per feature relative scaling of the data. Equivalent to
#     ``(max - min) / (X.max(axis=0) - X.min(axis=0))``
#
#     .. versionadded:: 0.17
#        *scale_* attribute.
#
# data_min_ : ndarray of shape (n_features,)
#     Per feature minimum seen in the data
#
#     .. versionadded:: 0.17
#        *data_min_*
#
# data_max_ : ndarray of shape (n_features,)
#     Per feature maximum seen in the data
#
#     .. versionadded:: 0.17
#        *data_max_*
#
# data_range_ : ndarray of shape (n_features,)
#     Per feature range ``(data_max_ - data_min_)`` seen in the data
#
#     .. versionadded:: 0.17
#        *data_range_*
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# n_samples_seen_ : int
#     The number of samples processed by the estimator.
#     It will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# See Also
# --------
# minmax_scale : Equivalent function without the estimator API.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import MinMaxScaler
# >>> data = [[-1, 2], [-0.5, 6], [0, 10], [1, 18]]
# >>> scaler = MinMaxScaler()
# >>> print(scaler.fit(data))
# MinMaxScaler()
# >>> print(scaler.data_max_)
# [ 1. 18.]
# >>> print(scaler.transform(data))
# [[0.   0.  ]
#  [0.25 0.25]
#  [0.5  0.5 ]
#  [1.   1.  ]]
# >>> print(scaler.transform([[2, 2]]))
# [[1.5 0. ]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.lib.function_base.append</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 2}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 2}</li></ul>
# <blockquote>
# <code>
# Append values to the end of an array.
#
# Parameters
# ----------
# arr : array_like
#     Values are appended to a copy of this array.
# values : array_like
#     These values are appended to a copy of `arr`.  It must be of the
#     correct shape (the same shape as `arr`, excluding `axis`).  If
#     `axis` is not specified, `values` can be any shape and will be
#     flattened before use.
# axis : int, optional
#     The axis along which `values` are appended.  If `axis` is not
#     given, both `arr` and `values` are flattened before use.
#
# Returns
# -------
# append : ndarray
#     A copy of `arr` with `values` appended to `axis`.  Note that
#     `append` does not occur in-place: a new array is allocated and
#     filled.  If `axis` is None, `out` is a flattened array.
#
# See Also
# --------
# insert : Insert elements into an array.
# delete : Delete elements from an array.
#
# Examples
# --------
# >>> np.append([1, 2, 3], [[4, 5, 6], [7, 8, 9]])
# array([1, 2, 3, ..., 7, 8, 9])
#
# When `axis` is specified, `values` must have the correct shape.
#
# >>> np.append([[1, 2, 3], [4, 5, 6]], [[7, 8, 9]], axis=0)
# array([[1, 2, 3],
#        [4, 5, 6],
#        [7, 8, 9]])
# >>> np.append([[1, 2, 3], [4, 5, 6]], [7, 8, 9], axis=0)
# Traceback (most recent call last):
#     ...
# ValueError: all the input arrays must have same number of dimensions, but
# the array at index 0 has 2 dimension(s) and the array at index 1 has 1
# dimension(s)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.merge.merge</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'how': 'left', 'on': ['item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'how': 'left', 'on': ['item_id', 'shop_id']}</li></ul>
# <blockquote>
# <code>
# Merge DataFrame or named Series objects with a database-style join.
#
# A named Series object is treated as a DataFrame with a single named column.
#
# The join is done on columns or indexes. If joining columns on
# columns, the DataFrame indexes *will be ignored*. Otherwise if joining indexes
# on indexes or indexes on a column or columns, the index will be passed on.
# When performing a cross merge, no column specifications to merge on are
# allowed.
#
# .. warning::
#
#     If both key columns contain rows where the key is a null value, those
#     rows will be matched against each other. This is different from usual SQL
#     join behaviour and can lead to unexpected results.
#
# Parameters
# ----------
# left : DataFrame
# right : DataFrame or named Series
#     Object to merge with.
# how : {'left', 'right', 'outer', 'inner', 'cross'}, default 'inner'
#     Type of merge to be performed.
#
#     * left: use only keys from left frame, similar to a SQL left outer join;
#       preserve key order.
#     * right: use only keys from right frame, similar to a SQL right outer join;
#       preserve key order.
#     * outer: use union of keys from both frames, similar to a SQL full outer
#       join; sort keys lexicographically.
#     * inner: use intersection of keys from both frames, similar to a SQL inner
#       join; preserve the order of the left keys.
#     * cross: creates the cartesian product from both frames, preserves the order
#       of the left keys.
#
#       .. versionadded:: 1.2.0
#
# on : label or list
#     Column or index level names to join on. These must be found in both
#     DataFrames. If `on` is None and not merging on indexes then this defaults
#     to the intersection of the columns in both DataFrames.
# left_on : label or list, or array-like
#     Column or index level names to join on in the left DataFrame. Can also
#     be an array or list of arrays of the length of the left DataFrame.
#     These arrays are treated as if they are columns.
# right_on : label or list, or array-like
#     Column or index level names to join on in the right DataFrame. Can also
#     be an array or list of arrays of the length of the right DataFrame.
#     These arrays are treated as if they are columns.
# left_index : bool, default False
#     Use the index from the left DataFrame as the join key(s). If it is a
#     MultiIndex, the number of keys in the other DataFrame (either the index
#     or a number of columns) must match the number of levels.
# right_index : bool, default False
#     Use the index from the right DataFrame as the join key. Same caveats as
#     left_index.
# sort : bool, default False
#     Sort the join keys lexicographically in the result DataFrame. If False,
#     the order of the join keys depends on the join type (how keyword).
# suffixes : list-like, default is ("_x", "_y")
#     A length-2 sequence where each element is optionally a string
#     indicating the suffix to add to overlapping column names in
#     `left` and `right` respectively. Pass a value of `None` instead
#     of a string to indicate that the column name from `left` or
#     `right` should be left as-is, with no suffix. At least one of the
#     values must not be None.
# copy : bool, default True
#     If False, avoid copy if possible.
# indicator : bool or str, default False
#     If True, adds a column to the output DataFrame called "_merge" with
#     information on the source of each row. The column can be given a different
#     name by providing a string argument. The column will have a Categorical
#     type with the value of "left_only" for observations whose merge key only
#     appears in the left DataFrame, "right_only" for observations
#     whose merge key only appears in the right DataFrame, and "both"
#     if the observation's merge key is found in both DataFrames.
#
# validate : str, optional
#     If specified, checks if merge is of specified type.
#
#     * "one_to_one" or "1:1": check if merge keys are unique in both
#       left and right datasets.
#     * "one_to_many" or "1:m": check if merge keys are unique in left
#       dataset.
#     * "many_to_one" or "m:1": check if merge keys are unique in right
#       dataset.
#     * "many_to_many" or "m:m": allowed, but does not result in checks.
#
# Returns
# -------
# DataFrame
#     A DataFrame of the two merged objects.
#
# See Also
# --------
# merge_ordered : Merge with optional filling/interpolation.
# merge_asof : Merge on nearest keys.
# DataFrame.join : Similar method using indices.
#
# Notes
# -----
# Support for specifying index levels as the `on`, `left_on`, and
# `right_on` parameters was added in version 0.23.0
# Support for merging named Series objects was added in version 0.24.0
#
# Examples
# --------
# >>> df1 = pd.DataFrame({'lkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [1, 2, 3, 5]})
# >>> df2 = pd.DataFrame({'rkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [5, 6, 7, 8]})
# >>> df1
#     lkey value
# 0   foo      1
# 1   bar      2
# 2   baz      3
# 3   foo      5
# >>> df2
#     rkey value
# 0   foo      5
# 1   bar      6
# 2   baz      7
# 3   foo      8
#
# Merge df1 and df2 on the lkey and rkey columns. The value columns have
# the default suffixes, _x and _y, appended.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey')
#   lkey  value_x rkey  value_y
# 0  foo        1  foo        5
# 1  foo        1  foo        8
# 2  foo        5  foo        5
# 3  foo        5  foo        8
# 4  bar        2  bar        6
# 5  baz        3  baz        7
#
# Merge DataFrames df1 and df2 with specified left and right suffixes
# appended to any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey',
# ...           suffixes=('_left', '_right'))
#   lkey  value_left rkey  value_right
# 0  foo           1  foo            5
# 1  foo           1  foo            8
# 2  foo           5  foo            5
# 3  foo           5  foo            8
# 4  bar           2  bar            6
# 5  baz           3  baz            7
#
# Merge DataFrames df1 and df2, but raise an exception if the DataFrames have
# any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey', suffixes=(False, False))
# Traceback (most recent call last):
# ...
# ValueError: columns overlap but no suffix specified:
#     Index(['value'], dtype='object')
#
# >>> df1 = pd.DataFrame({'a': ['foo', 'bar'], 'b': [1, 2]})
# >>> df2 = pd.DataFrame({'a': ['foo', 'baz'], 'c': [3, 4]})
# >>> df1
#       a  b
# 0   foo  1
# 1   bar  2
# >>> df2
#       a  c
# 0   foo  3
# 1   baz  4
#
# >>> df1.merge(df2, how='inner', on='a')
#       a  b  c
# 0   foo  1  3
#
# >>> df1.merge(df2, how='left', on='a')
#       a  b  c
# 0   foo  1  3.0
# 1   bar  2  NaN
#
# >>> df1 = pd.DataFrame({'left': ['foo', 'bar']})
# >>> df2 = pd.DataFrame({'right': [7, 8]})
# >>> df1
#     left
# 0   foo
# 1   bar
# >>> df2
#     right
# 0   7
# 1   8
#
# >>> df1.merge(df2, how='cross')
#    left  right
# 0   foo      7
# 1   foo      8
# 2   bar      7
# 3   bar      8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.fillna</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index', 1 or 'columns'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# DataFrame or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.MinMaxScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Transform features by scaling each feature to a given range.
#
# This estimator scales and translates each feature individually such
# that it is in the given range on the training set, e.g. between
# zero and one.
#
# The transformation is given by::
#
#     X_std = (X - X.min(axis=0)) / (X.max(axis=0) - X.min(axis=0))
#     X_scaled = X_std * (max - min) + min
#
# where min, max = feature_range.
#
# This transformation is often used as an alternative to zero mean,
# unit variance scaling.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# feature_range : tuple (min, max), default=(0, 1)
#     Desired range of transformed data.
#
# copy : bool, default=True
#     Set to False to perform inplace row normalization and avoid a
#     copy (if the input is already a numpy array).
#
# clip : bool, default=False
#     Set to True to clip transformed values of held-out data to
#     provided `feature range`.
#
#     .. versionadded:: 0.24
#
# Attributes
# ----------
# min_ : ndarray of shape (n_features,)
#     Per feature adjustment for minimum. Equivalent to
#     ``min - X.min(axis=0) * self.scale_``
#
# scale_ : ndarray of shape (n_features,)
#     Per feature relative scaling of the data. Equivalent to
#     ``(max - min) / (X.max(axis=0) - X.min(axis=0))``
#
#     .. versionadded:: 0.17
#        *scale_* attribute.
#
# data_min_ : ndarray of shape (n_features,)
#     Per feature minimum seen in the data
#
#     .. versionadded:: 0.17
#        *data_min_*
#
# data_max_ : ndarray of shape (n_features,)
#     Per feature maximum seen in the data
#
#     .. versionadded:: 0.17
#        *data_max_*
#
# data_range_ : ndarray of shape (n_features,)
#     Per feature range ``(data_max_ - data_min_)`` seen in the data
#
#     .. versionadded:: 0.17
#        *data_range_*
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# n_samples_seen_ : int
#     The number of samples processed by the estimator.
#     It will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# See Also
# --------
# minmax_scale : Equivalent function without the estimator API.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import MinMaxScaler
# >>> data = [[-1, 2], [-0.5, 6], [0, 10], [1, 18]]
# >>> scaler = MinMaxScaler()
# >>> print(scaler.fit(data))
# MinMaxScaler()
# >>> print(scaler.data_max_)
# [ 1. 18.]
# >>> print(scaler.transform(data))
# [[0.   0.  ]
#  [0.25 0.25]
#  [0.5  0.5 ]
#  [1.   1.  ]]
# >>> print(scaler.transform([[2, 2]]))
# [[1.5 0. ]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.lib.function_base.append</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 2}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 2}</li></ul>
# <blockquote>
# <code>
# Append values to the end of an array.
#
# Parameters
# ----------
# arr : array_like
#     Values are appended to a copy of this array.
# values : array_like
#     These values are appended to a copy of `arr`.  It must be of the
#     correct shape (the same shape as `arr`, excluding `axis`).  If
#     `axis` is not specified, `values` can be any shape and will be
#     flattened before use.
# axis : int, optional
#     The axis along which `values` are appended.  If `axis` is not
#     given, both `arr` and `values` are flattened before use.
#
# Returns
# -------
# append : ndarray
#     A copy of `arr` with `values` appended to `axis`.  Note that
#     `append` does not occur in-place: a new array is allocated and
#     filled.  If `axis` is None, `out` is a flattened array.
#
# See Also
# --------
# insert : Insert elements into an array.
# delete : Delete elements from an array.
#
# Examples
# --------
# >>> np.append([1, 2, 3], [[4, 5, 6], [7, 8, 9]])
# array([1, 2, 3, ..., 7, 8, 9])
#
# When `axis` is specified, `values` must have the correct shape.
#
# >>> np.append([[1, 2, 3], [4, 5, 6]], [[7, 8, 9]], axis=0)
# array([[1, 2, 3],
#        [4, 5, 6],
#        [7, 8, 9]])
# >>> np.append([[1, 2, 3], [4, 5, 6]], [7, 8, 9], axis=0)
# Traceback (most recent call last):
#     ...
# ValueError: all the input arrays must have same number of dimensions, but
# the array at index 0 has 2 dimension(s) and the array at index 1 has 1
# dimension(s)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.groupby</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Group DataFrame using a mapper or by a Series of columns.
#
# A groupby operation involves some combination of splitting the
# object, applying a function, and combining the results. This can be
# used to group large amounts of data and compute operations on these
# groups.
#
# Parameters
# ----------
# by : mapping, function, label, or list of labels
#     Used to determine the groups for the groupby.
#     If ``by`` is a function, it's called on each value of the object's
#     index. If a dict or Series is passed, the Series or dict VALUES
#     will be used to determine the groups (the Series' values are first
#     aligned; see ``.align()`` method). If a list or ndarray of length
#     equal to the selected axis is passed (see the `groupby user guide
#     <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
#     the values are used as-is to determine the groups. A label or list
#     of labels may be passed to group by the columns in ``self``.
#     Notice that a tuple is interpreted as a (single) key.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Split along rows (0) or columns (1).
# level : int, level name, or sequence of such, default None
#     If the axis is a MultiIndex (hierarchical), group by a particular
#     level or levels.
# as_index : bool, default True
#     For aggregated output, return object with group labels as the
#     index. Only relevant for DataFrame input. as_index=False is
#     effectively "SQL-style" grouped output.
# sort : bool, default True
#     Sort group keys. Get better performance by turning this off.
#     Note this does not influence the order of observations within each
#     group. Groupby preserves the order of rows within each group.
# group_keys : bool, default True
#     When calling apply, add group keys to index to identify pieces.
# squeeze : bool, default False
#     Reduce the dimensionality of the return type if possible,
#     otherwise return a consistent type.
#
#     .. deprecated:: 1.1.0
#
# observed : bool, default False
#     This only applies if any of the groupers are Categoricals.
#     If True: only show observed values for categorical groupers.
#     If False: show all values for categorical groupers.
# dropna : bool, default True
#     If True, and if group keys contain NA values, NA values together
#     with row/column will be dropped.
#     If False, NA values will also be treated as the key in groups.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# DataFrameGroupBy
#     Returns a groupby object that contains information about the groups.
#
# See Also
# --------
# resample : Convenience method for frequency conversion and resampling
#     of time series.
#
# Notes
# -----
# See the `user guide
# <https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
# detailed usage and examples, including splitting an object into groups,
# iterating through groups, selecting a group, aggregation, and more.
#
# Examples
# --------
# >>> df = pd.DataFrame({'Animal': ['Falcon', 'Falcon',
# ...                               'Parrot', 'Parrot'],
# ...                    'Max Speed': [380., 370., 24., 26.]})
# >>> df
#    Animal  Max Speed
# 0  Falcon      380.0
# 1  Falcon      370.0
# 2  Parrot       24.0
# 3  Parrot       26.0
# >>> df.groupby(['Animal']).mean()
#         Max Speed
# Animal
# Falcon      375.0
# Parrot       25.0
#
# **Hierarchical Indexes**
#
# We can groupby different levels of a hierarchical index
# using the `level` parameter:
#
# >>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
# ...           ['Captive', 'Wild', 'Captive', 'Wild']]
# >>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
# >>> df = pd.DataFrame({'Max Speed': [390., 350., 30., 20.]},
# ...                   index=index)
# >>> df
#                 Max Speed
# Animal Type
# Falcon Captive      390.0
#        Wild         350.0
# Parrot Captive       30.0
#        Wild          20.0
# >>> df.groupby(level=0).mean()
#         Max Speed
# Animal
# Falcon      370.0
# Parrot       25.0
# >>> df.groupby(level="Type").mean()
#          Max Speed
# Type
# Captive      210.0
# Wild         185.0
#
# We can also choose to include NA in group keys or not by setting
# `dropna` parameter, the default setting is `True`.
#
# >>> l = [[1, 2, 3], [1, None, 4], [2, 1, 3], [1, 2, 2]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by=["b"]).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
#
# >>> df.groupby(by=["b"], dropna=False).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
# NaN 1   4
#
# >>> l = [["a", 12, 12], [None, 12.3, 33.], ["b", 12.3, 123], ["a", 1, 1]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by="a").sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
#
# >>> df.groupby(by="a", dropna=False).sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
# NaN 12.3   33.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.groupby</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Group DataFrame using a mapper or by a Series of columns.
#
# A groupby operation involves some combination of splitting the
# object, applying a function, and combining the results. This can be
# used to group large amounts of data and compute operations on these
# groups.
#
# Parameters
# ----------
# by : mapping, function, label, or list of labels
#     Used to determine the groups for the groupby.
#     If ``by`` is a function, it's called on each value of the object's
#     index. If a dict or Series is passed, the Series or dict VALUES
#     will be used to determine the groups (the Series' values are first
#     aligned; see ``.align()`` method). If a list or ndarray of length
#     equal to the selected axis is passed (see the `groupby user guide
#     <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
#     the values are used as-is to determine the groups. A label or list
#     of labels may be passed to group by the columns in ``self``.
#     Notice that a tuple is interpreted as a (single) key.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Split along rows (0) or columns (1).
# level : int, level name, or sequence of such, default None
#     If the axis is a MultiIndex (hierarchical), group by a particular
#     level or levels.
# as_index : bool, default True
#     For aggregated output, return object with group labels as the
#     index. Only relevant for DataFrame input. as_index=False is
#     effectively "SQL-style" grouped output.
# sort : bool, default True
#     Sort group keys. Get better performance by turning this off.
#     Note this does not influence the order of observations within each
#     group. Groupby preserves the order of rows within each group.
# group_keys : bool, default True
#     When calling apply, add group keys to index to identify pieces.
# squeeze : bool, default False
#     Reduce the dimensionality of the return type if possible,
#     otherwise return a consistent type.
#
#     .. deprecated:: 1.1.0
#
# observed : bool, default False
#     This only applies if any of the groupers are Categoricals.
#     If True: only show observed values for categorical groupers.
#     If False: show all values for categorical groupers.
# dropna : bool, default True
#     If True, and if group keys contain NA values, NA values together
#     with row/column will be dropped.
#     If False, NA values will also be treated as the key in groups.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# DataFrameGroupBy
#     Returns a groupby object that contains information about the groups.
#
# See Also
# --------
# resample : Convenience method for frequency conversion and resampling
#     of time series.
#
# Notes
# -----
# See the `user guide
# <https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
# detailed usage and examples, including splitting an object into groups,
# iterating through groups, selecting a group, aggregation, and more.
#
# Examples
# --------
# >>> df = pd.DataFrame({'Animal': ['Falcon', 'Falcon',
# ...                               'Parrot', 'Parrot'],
# ...                    'Max Speed': [380., 370., 24., 26.]})
# >>> df
#    Animal  Max Speed
# 0  Falcon      380.0
# 1  Falcon      370.0
# 2  Parrot       24.0
# 3  Parrot       26.0
# >>> df.groupby(['Animal']).mean()
#         Max Speed
# Animal
# Falcon      375.0
# Parrot       25.0
#
# **Hierarchical Indexes**
#
# We can groupby different levels of a hierarchical index
# using the `level` parameter:
#
# >>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
# ...           ['Captive', 'Wild', 'Captive', 'Wild']]
# >>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
# >>> df = pd.DataFrame({'Max Speed': [390., 350., 30., 20.]},
# ...                   index=index)
# >>> df
#                 Max Speed
# Animal Type
# Falcon Captive      390.0
#        Wild         350.0
# Parrot Captive       30.0
#        Wild          20.0
# >>> df.groupby(level=0).mean()
#         Max Speed
# Animal
# Falcon      370.0
# Parrot       25.0
# >>> df.groupby(level="Type").mean()
#          Max Speed
# Type
# Captive      210.0
# Wild         185.0
#
# We can also choose to include NA in group keys or not by setting
# `dropna` parameter, the default setting is `True`.
#
# >>> l = [[1, 2, 3], [1, None, 4], [2, 1, 3], [1, 2, 2]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by=["b"]).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
#
# >>> df.groupby(by=["b"], dropna=False).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
# NaN 1   4
#
# >>> l = [["a", 12, 12], [None, 12.3, 33.], ["b", 12.3, 123], ["a", 1, 1]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by="a").sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
#
# >>> df.groupby(by="a", dropna=False).sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
# NaN 12.3   33.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Sub-sampling and Train-test Splitting</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Sub-sampling and Train-test Splitting" Calls</u></b></summary>
# <ul>
#
#
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Feature Selection</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Selection" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.groupby</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Group DataFrame using a mapper or by a Series of columns.
#
# A groupby operation involves some combination of splitting the
# object, applying a function, and combining the results. This can be
# used to group large amounts of data and compute operations on these
# groups.
#
# Parameters
# ----------
# by : mapping, function, label, or list of labels
#     Used to determine the groups for the groupby.
#     If ``by`` is a function, it's called on each value of the object's
#     index. If a dict or Series is passed, the Series or dict VALUES
#     will be used to determine the groups (the Series' values are first
#     aligned; see ``.align()`` method). If a list or ndarray of length
#     equal to the selected axis is passed (see the `groupby user guide
#     <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
#     the values are used as-is to determine the groups. A label or list
#     of labels may be passed to group by the columns in ``self``.
#     Notice that a tuple is interpreted as a (single) key.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Split along rows (0) or columns (1).
# level : int, level name, or sequence of such, default None
#     If the axis is a MultiIndex (hierarchical), group by a particular
#     level or levels.
# as_index : bool, default True
#     For aggregated output, return object with group labels as the
#     index. Only relevant for DataFrame input. as_index=False is
#     effectively "SQL-style" grouped output.
# sort : bool, default True
#     Sort group keys. Get better performance by turning this off.
#     Note this does not influence the order of observations within each
#     group. Groupby preserves the order of rows within each group.
# group_keys : bool, default True
#     When calling apply, add group keys to index to identify pieces.
# squeeze : bool, default False
#     Reduce the dimensionality of the return type if possible,
#     otherwise return a consistent type.
#
#     .. deprecated:: 1.1.0
#
# observed : bool, default False
#     This only applies if any of the groupers are Categoricals.
#     If True: only show observed values for categorical groupers.
#     If False: show all values for categorical groupers.
# dropna : bool, default True
#     If True, and if group keys contain NA values, NA values together
#     with row/column will be dropped.
#     If False, NA values will also be treated as the key in groups.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# DataFrameGroupBy
#     Returns a groupby object that contains information about the groups.
#
# See Also
# --------
# resample : Convenience method for frequency conversion and resampling
#     of time series.
#
# Notes
# -----
# See the `user guide
# <https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
# detailed usage and examples, including splitting an object into groups,
# iterating through groups, selecting a group, aggregation, and more.
#
# Examples
# --------
# >>> df = pd.DataFrame({'Animal': ['Falcon', 'Falcon',
# ...                               'Parrot', 'Parrot'],
# ...                    'Max Speed': [380., 370., 24., 26.]})
# >>> df
#    Animal  Max Speed
# 0  Falcon      380.0
# 1  Falcon      370.0
# 2  Parrot       24.0
# 3  Parrot       26.0
# >>> df.groupby(['Animal']).mean()
#         Max Speed
# Animal
# Falcon      375.0
# Parrot       25.0
#
# **Hierarchical Indexes**
#
# We can groupby different levels of a hierarchical index
# using the `level` parameter:
#
# >>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
# ...           ['Captive', 'Wild', 'Captive', 'Wild']]
# >>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
# >>> df = pd.DataFrame({'Max Speed': [390., 350., 30., 20.]},
# ...                   index=index)
# >>> df
#                 Max Speed
# Animal Type
# Falcon Captive      390.0
#        Wild         350.0
# Parrot Captive       30.0
#        Wild          20.0
# >>> df.groupby(level=0).mean()
#         Max Speed
# Animal
# Falcon      370.0
# Parrot       25.0
# >>> df.groupby(level="Type").mean()
#          Max Speed
# Type
# Captive      210.0
# Wild         185.0
#
# We can also choose to include NA in group keys or not by setting
# `dropna` parameter, the default setting is `True`.
#
# >>> l = [[1, 2, 3], [1, None, 4], [2, 1, 3], [1, 2, 2]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by=["b"]).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
#
# >>> df.groupby(by=["b"], dropna=False).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
# NaN 1   4
#
# >>> l = [["a", 12, 12], [None, 12.3, 33.], ["b", 12.3, 123], ["a", 1, 1]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by="a").sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
#
# >>> df.groupby(by="a", dropna=False).sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
# NaN 12.3   33.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.groupby</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [['item_id', 'shop_id']] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Group DataFrame using a mapper or by a Series of columns.
#
# A groupby operation involves some combination of splitting the
# object, applying a function, and combining the results. This can be
# used to group large amounts of data and compute operations on these
# groups.
#
# Parameters
# ----------
# by : mapping, function, label, or list of labels
#     Used to determine the groups for the groupby.
#     If ``by`` is a function, it's called on each value of the object's
#     index. If a dict or Series is passed, the Series or dict VALUES
#     will be used to determine the groups (the Series' values are first
#     aligned; see ``.align()`` method). If a list or ndarray of length
#     equal to the selected axis is passed (see the `groupby user guide
#     <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
#     the values are used as-is to determine the groups. A label or list
#     of labels may be passed to group by the columns in ``self``.
#     Notice that a tuple is interpreted as a (single) key.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Split along rows (0) or columns (1).
# level : int, level name, or sequence of such, default None
#     If the axis is a MultiIndex (hierarchical), group by a particular
#     level or levels.
# as_index : bool, default True
#     For aggregated output, return object with group labels as the
#     index. Only relevant for DataFrame input. as_index=False is
#     effectively "SQL-style" grouped output.
# sort : bool, default True
#     Sort group keys. Get better performance by turning this off.
#     Note this does not influence the order of observations within each
#     group. Groupby preserves the order of rows within each group.
# group_keys : bool, default True
#     When calling apply, add group keys to index to identify pieces.
# squeeze : bool, default False
#     Reduce the dimensionality of the return type if possible,
#     otherwise return a consistent type.
#
#     .. deprecated:: 1.1.0
#
# observed : bool, default False
#     This only applies if any of the groupers are Categoricals.
#     If True: only show observed values for categorical groupers.
#     If False: show all values for categorical groupers.
# dropna : bool, default True
#     If True, and if group keys contain NA values, NA values together
#     with row/column will be dropped.
#     If False, NA values will also be treated as the key in groups.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# DataFrameGroupBy
#     Returns a groupby object that contains information about the groups.
#
# See Also
# --------
# resample : Convenience method for frequency conversion and resampling
#     of time series.
#
# Notes
# -----
# See the `user guide
# <https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
# detailed usage and examples, including splitting an object into groups,
# iterating through groups, selecting a group, aggregation, and more.
#
# Examples
# --------
# >>> df = pd.DataFrame({'Animal': ['Falcon', 'Falcon',
# ...                               'Parrot', 'Parrot'],
# ...                    'Max Speed': [380., 370., 24., 26.]})
# >>> df
#    Animal  Max Speed
# 0  Falcon      380.0
# 1  Falcon      370.0
# 2  Parrot       24.0
# 3  Parrot       26.0
# >>> df.groupby(['Animal']).mean()
#         Max Speed
# Animal
# Falcon      375.0
# Parrot       25.0
#
# **Hierarchical Indexes**
#
# We can groupby different levels of a hierarchical index
# using the `level` parameter:
#
# >>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
# ...           ['Captive', 'Wild', 'Captive', 'Wild']]
# >>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
# >>> df = pd.DataFrame({'Max Speed': [390., 350., 30., 20.]},
# ...                   index=index)
# >>> df
#                 Max Speed
# Animal Type
# Falcon Captive      390.0
#        Wild         350.0
# Parrot Captive       30.0
#        Wild          20.0
# >>> df.groupby(level=0).mean()
#         Max Speed
# Animal
# Falcon      370.0
# Parrot       25.0
# >>> df.groupby(level="Type").mean()
#          Max Speed
# Type
# Captive      210.0
# Wild         185.0
#
# We can also choose to include NA in group keys or not by setting
# `dropna` parameter, the default setting is `True`.
#
# >>> l = [[1, 2, 3], [1, None, 4], [2, 1, 3], [1, 2, 2]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by=["b"]).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
#
# >>> df.groupby(by=["b"], dropna=False).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
# NaN 1   4
#
# >>> l = [["a", 12, 12], [None, 12.3, 33.], ["b", 12.3, 123], ["a", 1, 1]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by="a").sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
#
# >>> df.groupby(by="a", dropna=False).sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
# NaN 12.3   33.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['ID', 'item_id', 'shop_id']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2015-10']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'axis': 1, 'labels': ['2013-01']}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.recurrent_v2.LSTM</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {'return_sequences': True}</li></ul>
# <ul><li><b>Args:</b> [32] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Long Short-Term Memory layer - Hochreiter 1997.
#
# See [the Keras RNN API guide](https://www.tensorflow.org/guide/keras/rnn)
# for details about the usage of RNN API.
#
# Based on available runtime hardware and constraints, this layer
# will choose different implementations (cuDNN-based or pure-TensorFlow)
# to maximize the performance. If a GPU is available and all
# the arguments to the layer meet the requirement of the cuDNN kernel
# (see below for details), the layer will use a fast cuDNN implementation.
#
# The requirements to use the cuDNN implementation are:
#
# 1. `activation` == `tanh`
# 2. `recurrent_activation` == `sigmoid`
# 3. `recurrent_dropout` == 0
# 4. `unroll` is `False`
# 5. `use_bias` is `True`
# 6. Inputs, if use masking, are strictly right-padded.
# 7. Eager execution is enabled in the outermost context.
#
# For example:
#
# >>> inputs = tf.random.normal([32, 10, 8])
# >>> lstm = tf.keras.layers.LSTM(4)
# >>> output = lstm(inputs)
# >>> print(output.shape)
# (32, 4)
# >>> lstm = tf.keras.layers.LSTM(4, return_sequences=True, return_state=True)
# >>> whole_seq_output, final_memory_state, final_carry_state = lstm(inputs)
# >>> print(whole_seq_output.shape)
# (32, 10, 4)
# >>> print(final_memory_state.shape)
# (32, 4)
# >>> print(final_carry_state.shape)
# (32, 4)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     Default: hyperbolic tangent (`tanh`). If you pass `None`, no activation
#     is applied (ie. "linear" activation: `a(x) = x`).
#   recurrent_activation: Activation function to use for the recurrent step.
#     Default: sigmoid (`sigmoid`). If you pass `None`, no activation is
#     applied (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean (default `True`), whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix, used for
#     the linear transformation of the inputs. Default: `glorot_uniform`.
#   recurrent_initializer: Initializer for the `recurrent_kernel` weights
#     matrix, used for the linear transformation of the recurrent state.
#     Default: `orthogonal`.
#   bias_initializer: Initializer for the bias vector. Default: `zeros`.
#   unit_forget_bias: Boolean (default `True`). If True, add 1 to the bias of
#     the forget gate at initialization. Setting it to true will also force
#     `bias_initializer="zeros"`. This is recommended in [Jozefowicz et
#         al.](http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf).
#   kernel_regularizer: Regularizer function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_regularizer: Regularizer function applied to the
#     `recurrent_kernel` weights matrix. Default: `None`.
#   bias_regularizer: Regularizer function applied to the bias vector. Default:
#     `None`.
#   activity_regularizer: Regularizer function applied to the output of the
#     layer (its "activation"). Default: `None`.
#   kernel_constraint: Constraint function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_constraint: Constraint function applied to the `recurrent_kernel`
#     weights matrix. Default: `None`.
#   bias_constraint: Constraint function applied to the bias vector. Default:
#     `None`.
#   dropout: Float between 0 and 1. Fraction of the units to drop for the linear
#     transformation of the inputs. Default: 0.
#   recurrent_dropout: Float between 0 and 1. Fraction of the units to drop for
#     the linear transformation of the recurrent state. Default: 0.
#   return_sequences: Boolean. Whether to return the last output. in the output
#     sequence, or the full sequence. Default: `False`.
#   return_state: Boolean. Whether to return the last state in addition to the
#     output. Default: `False`.
#   go_backwards: Boolean (default `False`). If True, process the input sequence
#     backwards and return the reversed sequence.
#   stateful: Boolean (default `False`). If True, the last state for each sample
#     at index i in a batch will be used as initial state for the sample of
#     index i in the following batch.
#   time_major: The shape format of the `inputs` and `outputs` tensors.
#     If True, the inputs and outputs will be in shape
#     `[timesteps, batch, feature]`, whereas in the False case, it will be
#     `[batch, timesteps, feature]`. Using `time_major = True` is a bit more
#     efficient because it avoids transposes at the beginning and end of the
#     RNN calculation. However, most TensorFlow data is batch-major, so by
#     default this function accepts input and emits output in batch-major
#     form.
#   unroll: Boolean (default `False`). If True, the network will be unrolled,
#     else a symbolic loop will be used. Unrolling can speed-up a RNN, although
#     it tends to be more memory-intensive. Unrolling is only suitable for short
#     sequences.
#
# Call arguments:
#   inputs: A 3D tensor with shape `[batch, timesteps, feature]`.
#   mask: Binary tensor of shape `[batch, timesteps]` indicating whether
#     a given timestep should be masked (optional, defaults to `None`).
#     An individual `True` entry indicates that the corresponding timestep
#     should be utilized, while a `False` entry indicates that the corresponding
#     timestep should be ignored.
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode. This argument is passed to the cell
#     when calling it. This is only relevant if `dropout` or
#     `recurrent_dropout` is used (optional, defaults to `None`).
#   initial_state: List of initial state tensors to be passed to the first
#     call of the cell (optional, defaults to `None` which causes creation
#     of zero-filled initial state tensors).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'optimizer': 'adam', 'loss': 'mse', 'metrics': ['mse']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.recurrent_v2.LSTM</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {'return_sequences': True}</li></ul>
# <ul><li><b>Args:</b> [32] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Long Short-Term Memory layer - Hochreiter 1997.
#
# See [the Keras RNN API guide](https://www.tensorflow.org/guide/keras/rnn)
# for details about the usage of RNN API.
#
# Based on available runtime hardware and constraints, this layer
# will choose different implementations (cuDNN-based or pure-TensorFlow)
# to maximize the performance. If a GPU is available and all
# the arguments to the layer meet the requirement of the cuDNN kernel
# (see below for details), the layer will use a fast cuDNN implementation.
#
# The requirements to use the cuDNN implementation are:
#
# 1. `activation` == `tanh`
# 2. `recurrent_activation` == `sigmoid`
# 3. `recurrent_dropout` == 0
# 4. `unroll` is `False`
# 5. `use_bias` is `True`
# 6. Inputs, if use masking, are strictly right-padded.
# 7. Eager execution is enabled in the outermost context.
#
# For example:
#
# >>> inputs = tf.random.normal([32, 10, 8])
# >>> lstm = tf.keras.layers.LSTM(4)
# >>> output = lstm(inputs)
# >>> print(output.shape)
# (32, 4)
# >>> lstm = tf.keras.layers.LSTM(4, return_sequences=True, return_state=True)
# >>> whole_seq_output, final_memory_state, final_carry_state = lstm(inputs)
# >>> print(whole_seq_output.shape)
# (32, 10, 4)
# >>> print(final_memory_state.shape)
# (32, 4)
# >>> print(final_carry_state.shape)
# (32, 4)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     Default: hyperbolic tangent (`tanh`). If you pass `None`, no activation
#     is applied (ie. "linear" activation: `a(x) = x`).
#   recurrent_activation: Activation function to use for the recurrent step.
#     Default: sigmoid (`sigmoid`). If you pass `None`, no activation is
#     applied (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean (default `True`), whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix, used for
#     the linear transformation of the inputs. Default: `glorot_uniform`.
#   recurrent_initializer: Initializer for the `recurrent_kernel` weights
#     matrix, used for the linear transformation of the recurrent state.
#     Default: `orthogonal`.
#   bias_initializer: Initializer for the bias vector. Default: `zeros`.
#   unit_forget_bias: Boolean (default `True`). If True, add 1 to the bias of
#     the forget gate at initialization. Setting it to true will also force
#     `bias_initializer="zeros"`. This is recommended in [Jozefowicz et
#         al.](http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf).
#   kernel_regularizer: Regularizer function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_regularizer: Regularizer function applied to the
#     `recurrent_kernel` weights matrix. Default: `None`.
#   bias_regularizer: Regularizer function applied to the bias vector. Default:
#     `None`.
#   activity_regularizer: Regularizer function applied to the output of the
#     layer (its "activation"). Default: `None`.
#   kernel_constraint: Constraint function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_constraint: Constraint function applied to the `recurrent_kernel`
#     weights matrix. Default: `None`.
#   bias_constraint: Constraint function applied to the bias vector. Default:
#     `None`.
#   dropout: Float between 0 and 1. Fraction of the units to drop for the linear
#     transformation of the inputs. Default: 0.
#   recurrent_dropout: Float between 0 and 1. Fraction of the units to drop for
#     the linear transformation of the recurrent state. Default: 0.
#   return_sequences: Boolean. Whether to return the last output. in the output
#     sequence, or the full sequence. Default: `False`.
#   return_state: Boolean. Whether to return the last state in addition to the
#     output. Default: `False`.
#   go_backwards: Boolean (default `False`). If True, process the input sequence
#     backwards and return the reversed sequence.
#   stateful: Boolean (default `False`). If True, the last state for each sample
#     at index i in a batch will be used as initial state for the sample of
#     index i in the following batch.
#   time_major: The shape format of the `inputs` and `outputs` tensors.
#     If True, the inputs and outputs will be in shape
#     `[timesteps, batch, feature]`, whereas in the False case, it will be
#     `[batch, timesteps, feature]`. Using `time_major = True` is a bit more
#     efficient because it avoids transposes at the beginning and end of the
#     RNN calculation. However, most TensorFlow data is batch-major, so by
#     default this function accepts input and emits output in batch-major
#     form.
#   unroll: Boolean (default `False`). If True, the network will be unrolled,
#     else a symbolic loop will be used. Unrolling can speed-up a RNN, although
#     it tends to be more memory-intensive. Unrolling is only suitable for short
#     sequences.
#
# Call arguments:
#   inputs: A 3D tensor with shape `[batch, timesteps, feature]`.
#   mask: Binary tensor of shape `[batch, timesteps]` indicating whether
#     a given timestep should be masked (optional, defaults to `None`).
#     An individual `True` entry indicates that the corresponding timestep
#     should be utilized, while a `False` entry indicates that the corresponding
#     timestep should be ignored.
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode. This argument is passed to the cell
#     when calling it. This is only relevant if `dropout` or
#     `recurrent_dropout` is used (optional, defaults to `None`).
#   initial_state: List of initial state tensors to be passed to the first
#     call of the cell (optional, defaults to `None` which causes creation
#     of zero-filled initial state tensors).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'optimizer': 'adam', 'loss': 'mse', 'metrics': ['mse']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.backend</u></summary>
# <blockquote>
# <code>
# Keras backend API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.EarlyStopping</u></summary>
# <blockquote>
# <code>
# Stop training when a monitored metric has stopped improving.
#
# Assuming the goal of a training is to minimize the loss. With this, the
# metric to be monitored would be `'loss'`, and mode would be `'min'`. A
# `model.fit()` training loop will check at end of every epoch whether
# the loss is no longer decreasing, considering the `min_delta` and
# `patience` if applicable. Once it's found no longer decreasing,
# `model.stop_training` is marked True and the training terminates.
#
# The quantity to be monitored needs to be available in `logs` dict.
# To make it so, pass the loss or metrics at `model.compile()`.
#
# Args:
#   monitor: Quantity to be monitored.
#   min_delta: Minimum change in the monitored quantity
#       to qualify as an improvement, i.e. an absolute
#       change of less than min_delta, will count as no
#       improvement.
#   patience: Number of epochs with no improvement
#       after which training will be stopped.
#   verbose: verbosity mode.
#   mode: One of `{"auto", "min", "max"}`. In `min` mode,
#       training will stop when the quantity
#       monitored has stopped decreasing; in `"max"`
#       mode it will stop when the quantity
#       monitored has stopped increasing; in `"auto"`
#       mode, the direction is automatically inferred
#       from the name of the monitored quantity.
#   baseline: Baseline value for the monitored quantity.
#       Training will stop if the model doesn't show improvement over the
#       baseline.
#   restore_best_weights: Whether to restore model weights from
#       the epoch with the best value of the monitored quantity.
#       If False, the model weights obtained at the last step of
#       training are used. An epoch will be restored regardless
#       of the performance relative to the `baseline`. If no epoch
#       improves on `baseline`, training will run for `patience`
#       epochs and restore weights from the best epoch in that set.
#
# Example:
#
# >>> callback = tf.keras.callbacks.EarlyStopping(monitor='loss', patience=3)
# >>> # This callback will stop the training when there is no improvement in
# >>> # the loss for three consecutive epochs.
# >>> model = tf.keras.models.Sequential([tf.keras.layers.Dense(10)])
# >>> model.compile(tf.keras.optimizers.SGD(), loss='mse')
# >>> history = model.fit(np.arange(100).reshape(5, 20), np.zeros(5),
# ...                     epochs=10, batch_size=1, callbacks=[callback],
# ...                     verbose=0)
# >>> len(history.history['loss'])  # Only 4 epochs are run.
# 4
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.ThresholdedReLU</u></summary>
# <blockquote>
# <code>
# Thresholded Rectified Linear Unit.
#
# It follows:
#
# ```
#   f(x) = x for x > theta
#   f(x) = 0 otherwise`
# ```
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   theta: Float >= 0. Threshold location of activation.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.activation.Activation</u></summary>
# <blockquote>
# <code>
# Applies an activation function to an output.
#
# Args:
#   activation: Activation function, such as `tf.nn.relu`, or string name of
#     built-in activation function, such as "relu".
#
# Usage:
#
# >>> layer = tf.keras.layers.Activation('relu')
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
# >>> layer = tf.keras.layers.Activation(tf.nn.relu)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.embeddings.Embedding</u></summary>
# <blockquote>
# <code>
# Turns positive integers (indexes) into dense vectors of fixed size.
#
# e.g. `[[4], [20]] -> [[0.25, 0.1], [0.6, -0.2]]`
#
# This layer can only be used on positive integer inputs of a fixed range. The
# `tf.keras.layers.TextVectorization`, `tf.keras.layers.StringLookup`,
# and `tf.keras.layers.IntegerLookup` preprocessing layers can help prepare
# inputs for an `Embedding` layer.
#
# This layer accepts `tf.Tensor` and `tf.RaggedTensor` inputs. It cannot be
# called with `tf.SparseTensor` input.
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Embedding(1000, 64, input_length=10))
# >>> # The model will take as input an integer matrix of size (batch,
# >>> # input_length), and the largest integer (i.e. word index) in the input
# >>> # should be no larger than 999 (vocabulary size).
# >>> # Now model.output_shape is (None, 10, 64), where `None` is the batch
# >>> # dimension.
# >>> input_array = np.random.randint(1000, size=(32, 10))
# >>> model.compile('rmsprop', 'mse')
# >>> output_array = model.predict(input_array)
# >>> print(output_array.shape)
# (32, 10, 64)
#
# Args:
#   input_dim: Integer. Size of the vocabulary,
#     i.e. maximum integer index + 1.
#   output_dim: Integer. Dimension of the dense embedding.
#   embeddings_initializer: Initializer for the `embeddings`
#     matrix (see `keras.initializers`).
#   embeddings_regularizer: Regularizer function applied to
#     the `embeddings` matrix (see `keras.regularizers`).
#   embeddings_constraint: Constraint function applied to
#     the `embeddings` matrix (see `keras.constraints`).
#   mask_zero: Boolean, whether or not the input value 0 is a special "padding"
#     value that should be masked out.
#     This is useful when using recurrent layers
#     which may take variable length input.
#     If this is `True`, then all subsequent layers
#     in the model need to support masking or an exception will be raised.
#     If mask_zero is set to True, as a consequence, index 0 cannot be
#     used in the vocabulary (input_dim should equal size of
#     vocabulary + 1).
#   input_length: Length of input sequences, when it is constant.
#     This argument is required if you are going to connect
#     `Flatten` then `Dense` layers upstream
#     (without it, the shape of the dense outputs cannot be computed).
#
# Input shape:
#   2D tensor with shape: `(batch_size, input_length)`.
#
# Output shape:
#   3D tensor with shape: `(batch_size, input_length, output_dim)`.
#
# **Note on variable placement:**
# By default, if a GPU is available, the embedding matrix will be placed on
# the GPU. This achieves the best performance, but it might cause issues:
#
# - You may be using an optimizer that does not support sparse GPU kernels.
# In this case you will see an error upon training your model.
# - Your embedding matrix may be too large to fit on your GPU. In this case
# you will see an Out Of Memory (OOM) error.
#
# In such cases, you should place the embedding matrix on the CPU memory.
# You can do so with a device scope, as such:
#
# ```python
# with tf.device('cpu:0'):
#   embedding_layer = Embedding(...)
#   embedding_layer.build()
# ```
#
# The pre-built `embedding_layer` instance can then be added to a `Sequential`
# model (e.g. `model.add(embedding_layer)`), called in a Functional model
# (e.g. `x = embedding_layer(x)`), or used in a subclassed model.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.pooling.MaxPooling2D</u></summary>
# <blockquote>
# <code>
# Max pooling operation for 2D spatial data.
#
# Downsamples the input along its spatial dimensions (height and width)
# by taking the maximum value over an input window
# (of size defined by `pool_size`) for each channel of the input.
# The window is shifted by `strides` along each dimension.
#
# The resulting output,
# when using the `"valid"` padding option, has a spatial shape
# (number of rows or columns) of:
# `output_shape = math.floor((input_shape - pool_size) / strides) + 1`
# (when `input_shape >= pool_size`)
#
# The resulting output shape when using the `"same"` padding option is:
# `output_shape = math.floor((input_shape - 1) / strides) + 1`
#
# For example, for `strides=(1, 1)` and `padding="valid"`:
#
# >>> x = tf.constant([[1., 2., 3.],
# ...                  [4., 5., 6.],
# ...                  [7., 8., 9.]])
# >>> x = tf.reshape(x, [1, 3, 3, 1])
# >>> max_pool_2d = tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    strides=(1, 1), padding='valid')
# >>> max_pool_2d(x)
# <tf.Tensor: shape=(1, 2, 2, 1), dtype=float32, numpy=
#   array([[[[5.],
#            [6.]],
#           [[8.],
#            [9.]]]], dtype=float32)>
#
# For example, for `strides=(2, 2)` and `padding="valid"`:
#
# >>> x = tf.constant([[1., 2., 3., 4.],
# ...                  [5., 6., 7., 8.],
# ...                  [9., 10., 11., 12.]])
# >>> x = tf.reshape(x, [1, 3, 4, 1])
# >>> max_pool_2d = tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    strides=(2, 2), padding='valid')
# >>> max_pool_2d(x)
# <tf.Tensor: shape=(1, 1, 2, 1), dtype=float32, numpy=
#   array([[[[6.],
#            [8.]]]], dtype=float32)>
#
# Usage Example:
#
# >>> input_image = tf.constant([[[[1.], [1.], [2.], [4.]],
# ...                            [[2.], [2.], [3.], [2.]],
# ...                            [[4.], [1.], [1.], [1.]],
# ...                            [[2.], [2.], [1.], [4.]]]])
# >>> output = tf.constant([[[[1], [0]],
# ...                       [[0], [1]]]])
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    input_shape=(4, 4, 1)))
# >>> model.compile('adam', 'mean_squared_error')
# >>> model.predict(input_image, steps=1)
# array([[[[2.],
#          [4.]],
#         [[4.],
#          [4.]]]], dtype=float32)
#
# For example, for stride=(1, 1) and padding="same":
#
# >>> x = tf.constant([[1., 2., 3.],
# ...                  [4., 5., 6.],
# ...                  [7., 8., 9.]])
# >>> x = tf.reshape(x, [1, 3, 3, 1])
# >>> max_pool_2d = tf.keras.layers.MaxPooling2D(pool_size=(2, 2),
# ...    strides=(1, 1), padding='same')
# >>> max_pool_2d(x)
# <tf.Tensor: shape=(1, 3, 3, 1), dtype=float32, numpy=
#   array([[[[5.],
#            [6.],
#            [6.]],
#           [[8.],
#            [9.],
#            [9.]],
#           [[8.],
#            [9.],
#            [9.]]]], dtype=float32)>
#
# Args:
#   pool_size: integer or tuple of 2 integers,
#     window size over which to take the maximum.
#     `(2, 2)` will take the max value over a 2x2 pooling window.
#     If only one integer is specified, the same window length
#     will be used for both dimensions.
#   strides: Integer, tuple of 2 integers, or None.
#     Strides values.  Specifies how far the pooling window moves
#     for each pooling step. If None, it will default to `pool_size`.
#   padding: One of `"valid"` or `"same"` (case-insensitive).
#     `"valid"` means no padding. `"same"` results in padding evenly to
#     the left/right or up/down of the input such that output has the same
#     height/width dimension as the input.
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, height, width, channels)` while `channels_first`
#     corresponds to inputs with shape
#     `(batch, channels, height, width)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Input shape:
#   - If `data_format='channels_last'`:
#     4D tensor with shape `(batch_size, rows, cols, channels)`.
#   - If `data_format='channels_first'`:
#     4D tensor with shape `(batch_size, channels, rows, cols)`.
#
# Output shape:
#   - If `data_format='channels_last'`:
#     4D tensor with shape `(batch_size, pooled_rows, pooled_cols, channels)`.
#   - If `data_format='channels_first'`:
#     4D tensor with shape `(batch_size, channels, pooled_rows, pooled_cols)`.
#
# Returns:
#   A tensor of rank 4 representing the maximum pooled values.  See above for
#   output shape.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.recurrent_v2.LSTM</u></summary>
# <blockquote>
# <code>
# Long Short-Term Memory layer - Hochreiter 1997.
#
# See [the Keras RNN API guide](https://www.tensorflow.org/guide/keras/rnn)
# for details about the usage of RNN API.
#
# Based on available runtime hardware and constraints, this layer
# will choose different implementations (cuDNN-based or pure-TensorFlow)
# to maximize the performance. If a GPU is available and all
# the arguments to the layer meet the requirement of the cuDNN kernel
# (see below for details), the layer will use a fast cuDNN implementation.
#
# The requirements to use the cuDNN implementation are:
#
# 1. `activation` == `tanh`
# 2. `recurrent_activation` == `sigmoid`
# 3. `recurrent_dropout` == 0
# 4. `unroll` is `False`
# 5. `use_bias` is `True`
# 6. Inputs, if use masking, are strictly right-padded.
# 7. Eager execution is enabled in the outermost context.
#
# For example:
#
# >>> inputs = tf.random.normal([32, 10, 8])
# >>> lstm = tf.keras.layers.LSTM(4)
# >>> output = lstm(inputs)
# >>> print(output.shape)
# (32, 4)
# >>> lstm = tf.keras.layers.LSTM(4, return_sequences=True, return_state=True)
# >>> whole_seq_output, final_memory_state, final_carry_state = lstm(inputs)
# >>> print(whole_seq_output.shape)
# (32, 10, 4)
# >>> print(final_memory_state.shape)
# (32, 4)
# >>> print(final_carry_state.shape)
# (32, 4)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     Default: hyperbolic tangent (`tanh`). If you pass `None`, no activation
#     is applied (ie. "linear" activation: `a(x) = x`).
#   recurrent_activation: Activation function to use for the recurrent step.
#     Default: sigmoid (`sigmoid`). If you pass `None`, no activation is
#     applied (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean (default `True`), whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix, used for
#     the linear transformation of the inputs. Default: `glorot_uniform`.
#   recurrent_initializer: Initializer for the `recurrent_kernel` weights
#     matrix, used for the linear transformation of the recurrent state.
#     Default: `orthogonal`.
#   bias_initializer: Initializer for the bias vector. Default: `zeros`.
#   unit_forget_bias: Boolean (default `True`). If True, add 1 to the bias of
#     the forget gate at initialization. Setting it to true will also force
#     `bias_initializer="zeros"`. This is recommended in [Jozefowicz et
#         al.](http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf).
#   kernel_regularizer: Regularizer function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_regularizer: Regularizer function applied to the
#     `recurrent_kernel` weights matrix. Default: `None`.
#   bias_regularizer: Regularizer function applied to the bias vector. Default:
#     `None`.
#   activity_regularizer: Regularizer function applied to the output of the
#     layer (its "activation"). Default: `None`.
#   kernel_constraint: Constraint function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_constraint: Constraint function applied to the `recurrent_kernel`
#     weights matrix. Default: `None`.
#   bias_constraint: Constraint function applied to the bias vector. Default:
#     `None`.
#   dropout: Float between 0 and 1. Fraction of the units to drop for the linear
#     transformation of the inputs. Default: 0.
#   recurrent_dropout: Float between 0 and 1. Fraction of the units to drop for
#     the linear transformation of the recurrent state. Default: 0.
#   return_sequences: Boolean. Whether to return the last output. in the output
#     sequence, or the full sequence. Default: `False`.
#   return_state: Boolean. Whether to return the last state in addition to the
#     output. Default: `False`.
#   go_backwards: Boolean (default `False`). If True, process the input sequence
#     backwards and return the reversed sequence.
#   stateful: Boolean (default `False`). If True, the last state for each sample
#     at index i in a batch will be used as initial state for the sample of
#     index i in the following batch.
#   time_major: The shape format of the `inputs` and `outputs` tensors.
#     If True, the inputs and outputs will be in shape
#     `[timesteps, batch, feature]`, whereas in the False case, it will be
#     `[batch, timesteps, feature]`. Using `time_major = True` is a bit more
#     efficient because it avoids transposes at the beginning and end of the
#     RNN calculation. However, most TensorFlow data is batch-major, so by
#     default this function accepts input and emits output in batch-major
#     form.
#   unroll: Boolean (default `False`). If True, the network will be unrolled,
#     else a symbolic loop will be used. Unrolling can speed-up a RNN, although
#     it tends to be more memory-intensive. Unrolling is only suitable for short
#     sequences.
#
# Call arguments:
#   inputs: A 3D tensor with shape `[batch, timesteps, feature]`.
#   mask: Binary tensor of shape `[batch, timesteps]` indicating whether
#     a given timestep should be masked (optional, defaults to `None`).
#     An individual `True` entry indicates that the corresponding timestep
#     should be utilized, while a `False` entry indicates that the corresponding
#     timestep should be ignored.
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode. This argument is passed to the cell
#     when calling it. This is only relevant if `dropout` or
#     `recurrent_dropout` is used (optional, defaults to `None`).
#   initial_state: List of initial state tensors to be passed to the first
#     call of the cell (optional, defaults to `None` which causes creation
#     of zero-filled initial state tensors).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.gradient_descent.SGD</u></summary>
# <blockquote>
# <code>
# Gradient descent (with momentum) optimizer.
#
# Update rule for parameter `w` with gradient `g` when `momentum` is 0:
#
# ```python
# w = w - learning_rate * g
# ```
#
# Update rule when `momentum` is larger than 0:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + velocity
# ```
#
# When `nesterov=True`, this rule becomes:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + momentum * velocity - learning_rate * g
# ```
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.01.
#   momentum: float hyperparameter >= 0 that accelerates gradient descent
#     in the relevant
#     direction and dampens oscillations. Defaults to 0, i.e., vanilla gradient
#     descent.
#   nesterov: boolean. Whether to apply Nesterov momentum.
#     Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients.  Defaults to `"SGD"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1)
# >>> var = tf.Variable(1.0)
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> # Step is `- learning_rate * grad`
# >>> var.numpy()
# 0.9
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1, momentum=0.9)
# >>> var = tf.Variable(1.0)
# >>> val0 = var.value()
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> # First step is `- learning_rate * grad`
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val1 = var.value()
# >>> (val0 - val1).numpy()
# 0.1
# >>> # On later steps, step-size increases because of momentum
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val2 = var.value()
# >>> (val1 - val2).numpy()
# 0.18
#
# Reference:
#     - For `nesterov=True`, See [Sutskever et al., 2013](
#       http://jmlr.org/proceedings/papers/v28/sutskever13.pdf).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.rmsprop.RMSprop</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the RMSprop algorithm.
#
# The gist of RMSprop is to:
#
# - Maintain a moving (discounted) average of the square of gradients
# - Divide the gradient by the root of this average
#
# This implementation of RMSprop uses plain momentum, not Nesterov momentum.
#
# The centered version additionally maintains a moving average of the
# gradients, and uses that average to estimate the variance.
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.001.
#   rho: Discounting factor for the history/coming gradient. Defaults to 0.9.
#   momentum: A scalar or a scalar `Tensor`. Defaults to 0.0.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   centered: Boolean. If `True`, gradients are normalized by the estimated
#     variance of the gradient; if False, by the uncentered second moment.
#     Setting this to `True` may help with training, but is slightly more
#     expensive in terms of computation and memory. Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients. Defaults to `"RMSprop"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Note that in the dense implementation of this algorithm, variables and their
# corresponding accumulators (momentum, gradient moving average, square
# gradient moving average) will be updated even if the gradient is zero
# (i.e. accumulators will decay, momentum will be applied). The sparse
# implementation (used when the gradient is an `IndexedSlices` object,
# typically because of `tf.gather` or an embedding lookup in the forward pass)
# will not update variable slices or their accumulators unless those slices
# were used in the forward pass (nor is there an "eventual" correction to
# account for these omitted updates). This leads to more efficient updates for
# large embedding lookup tables (where most of the slices are not accessed in
# a particular graph execution), but differs from the published algorithm.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.RMSprop(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2) / 2.0    # d(loss) / d(var1) = var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> var1.numpy()
# 9.683772
#
# Reference:
#   - [Hinton, 2012](
#     http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot</u></summary>
# <blockquote>
# <code>
# `matplotlib.pyplot` is a state-based interface to matplotlib. It provides
# an implicit,  MATLAB-like, way of plotting.  It also opens figures on your
# screen, and acts as the figure GUI manager.
#
# pyplot is mainly intended for interactive plots and simple cases of
# programmatic plot generation::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     plt.plot(x, y)
#
# The explicit (object-oriented) API is recommended for complex plots, though
# pyplot is still usually used to create the figure and often the axes in the
# figure. See `.pyplot.figure`, `.pyplot.subplots`, and
# `.pyplot.subplot_mosaic` to create figures, and
# :doc:`Axes API <../axes_api>` for the plotting methods on an axes::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.savefig</u></summary>
# <blockquote>
# <code>
# Save the current figure.
#
# Call signature::
#
#   savefig(fname, *, dpi='figure', format=None, metadata=None,
#           bbox_inches=None, pad_inches=0.1,
#           facecolor='auto', edgecolor='auto',
#           backend=None, **kwargs
#          )
#
# The available output formats depend on the backend being used.
#
# Parameters
# ----------
# fname : str or path-like or binary file-like
#     A path, or a Python file-like object, or
#     possibly some backend-dependent object such as
#     `matplotlib.backends.backend_pdf.PdfPages`.
#
#     If *format* is set, it determines the output format, and the file
#     is saved as *fname*.  Note that *fname* is used verbatim, and there
#     is no attempt to make the extension, if any, of *fname* match
#     *format*, and no extension is appended.
#
#     If *format* is not set, then the format is inferred from the
#     extension of *fname*, if there is one.  If *format* is not
#     set and *fname* has no extension, then the file is saved with
#     :rc:`savefig.format` and the appropriate extension is appended to
#     *fname*.
#
# Other Parameters
# ----------------
# dpi : float or 'figure', default: :rc:`savefig.dpi`
#     The resolution in dots per inch.  If 'figure', use the figure's
#     dpi value.
#
# format : str
#     The file format, e.g. 'png', 'pdf', 'svg', ... The behavior when
#     this is unset is documented under *fname*.
#
# metadata : dict, optional
#     Key/value pairs to store in the image metadata. The supported keys
#     and defaults depend on the image format and backend:
#
#     - 'png' with Agg backend: See the parameter ``metadata`` of
#       `~.FigureCanvasAgg.print_png`.
#     - 'pdf' with pdf backend: See the parameter ``metadata`` of
#       `~.backend_pdf.PdfPages`.
#     - 'svg' with svg backend: See the parameter ``metadata`` of
#       `~.FigureCanvasSVG.print_svg`.
#     - 'eps' and 'ps' with PS backend: Only 'Creator' is supported.
#
# bbox_inches : str or `.Bbox`, default: :rc:`savefig.bbox`
#     Bounding box in inches: only the given portion of the figure is
#     saved.  If 'tight', try to figure out the tight bbox of the figure.
#
# pad_inches : float, default: :rc:`savefig.pad_inches`
#     Amount of padding around the figure when bbox_inches is 'tight'.
#
# facecolor : color or 'auto', default: :rc:`savefig.facecolor`
#     The facecolor of the figure.  If 'auto', use the current figure
#     facecolor.
#
# edgecolor : color or 'auto', default: :rc:`savefig.edgecolor`
#     The edgecolor of the figure.  If 'auto', use the current figure
#     edgecolor.
#
# backend : str, optional
#     Use a non-default backend to render the file, e.g. to render a
#     png file with the "cairo" backend rather than the default "agg",
#     or a pdf file with the "pgf" backend rather than the default
#     "pdf".  Note that the default backend is normally sufficient.  See
#     :ref:`the-builtin-backends` for a list of valid backends for each
#     file format.  Custom backends can be referenced as "module://...".
#
# orientation : {'landscape', 'portrait'}
#     Currently only supported by the postscript backend.
#
# papertype : str
#     One of 'letter', 'legal', 'executive', 'ledger', 'a0' through
#     'a10', 'b0' through 'b10'. Only supported for postscript
#     output.
#
# transparent : bool
#     If *True*, the Axes patches will all be transparent; the
#     Figure patch will also be transparent unless *facecolor*
#     and/or *edgecolor* are specified via kwargs.
#
#     If *False* has no effect and the color of the Axes and
#     Figure patches are unchanged (unless the Figure patch
#     is specified via the *facecolor* and/or *edgecolor* keyword
#     arguments in which case those colors are used).
#
#     The transparency of these patches will be restored to their
#     original values upon exit of this function.
#
#     This is useful, for example, for displaying
#     a plot on top of a colored background on a web page.
#
# bbox_extra_artists : list of `~matplotlib.artist.Artist`, optional
#     A list of extra artists that will be considered when the
#     tight bbox is calculated.
#
# pil_kwargs : dict, optional
#     Additional keyword arguments that are passed to
#     `PIL.Image.Image.save` when saving the figure.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u></summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u></summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.argmin</u></summary>
# <blockquote>
# <code>
# Returns the indices of the minimum values along an axis.
#
# Parameters
# ----------
# a : array_like
#     Input array.
# axis : int, optional
#     By default, the index is into the flattened array, otherwise
#     along the specified axis.
# out : array, optional
#     If provided, the result will be inserted into this array. It should
#     be of the appropriate shape and dtype.
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the array.
#
#     .. versionadded:: 1.22.0
#
# Returns
# -------
# index_array : ndarray of ints
#     Array of indices into the array. It has the same shape as `a.shape`
#     with the dimension along `axis` removed. If `keepdims` is set to True,
#     then the size of `axis` will be 1 with the resulting array having same
#     shape as `a.shape`.
#
# See Also
# --------
# ndarray.argmin, argmax
# amin : The minimum value along a given axis.
# unravel_index : Convert a flat index into an index tuple.
# take_along_axis : Apply ``np.expand_dims(index_array, axis)``
#                   from argmin to an array as if by calling min.
#
# Notes
# -----
# In case of multiple occurrences of the minimum values, the indices
# corresponding to the first occurrence are returned.
#
# Examples
# --------
# >>> a = np.arange(6).reshape(2,3) + 10
# >>> a
# array([[10, 11, 12],
#        [13, 14, 15]])
# >>> np.argmin(a)
# 0
# >>> np.argmin(a, axis=0)
# array([0, 0, 0])
# >>> np.argmin(a, axis=1)
# array([0, 0])
#
# Indices of the minimum elements of a N-dimensional array:
#
# >>> ind = np.unravel_index(np.argmin(a, axis=None), a.shape)
# >>> ind
# (0, 0)
# >>> a[ind]
# 10
#
# >>> b = np.arange(6) + 10
# >>> b[4] = 10
# >>> b
# array([10, 11, 12, 13, 10, 15])
# >>> np.argmin(b)  # Only the first occurrence is returned.
# 0
#
# >>> x = np.array([[4,2,3], [1,0,3]])
# >>> index_array = np.argmin(x, axis=-1)
# >>> # Same as np.amin(x, axis=-1, keepdims=True)
# >>> np.take_along_axis(x, np.expand_dims(index_array, axis=-1), axis=-1)
# array([[2],
#        [0]])
# >>> # Same as np.amax(x, axis=-1)
# >>> np.take_along_axis(x, np.expand_dims(index_array, axis=-1), axis=-1).squeeze(axis=-1)
# array([2, 0])
#
# Setting `keepdims` to `True`,
#
# >>> x = np.arange(24).reshape((2, 3, 4))
# >>> res = np.argmin(x, axis=1, keepdims=True)
# >>> res.shape
# (2, 1, 4)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.lib.function_base.append</u></summary>
# <blockquote>
# <code>
# Append values to the end of an array.
#
# Parameters
# ----------
# arr : array_like
#     Values are appended to a copy of this array.
# values : array_like
#     These values are appended to a copy of `arr`.  It must be of the
#     correct shape (the same shape as `arr`, excluding `axis`).  If
#     `axis` is not specified, `values` can be any shape and will be
#     flattened before use.
# axis : int, optional
#     The axis along which `values` are appended.  If `axis` is not
#     given, both `arr` and `values` are flattened before use.
#
# Returns
# -------
# append : ndarray
#     A copy of `arr` with `values` appended to `axis`.  Note that
#     `append` does not occur in-place: a new array is allocated and
#     filled.  If `axis` is None, `out` is a flattened array.
#
# See Also
# --------
# insert : Insert elements into an array.
# delete : Delete elements from an array.
#
# Examples
# --------
# >>> np.append([1, 2, 3], [[4, 5, 6], [7, 8, 9]])
# array([1, 2, 3, ..., 7, 8, 9])
#
# When `axis` is specified, `values` must have the correct shape.
#
# >>> np.append([[1, 2, 3], [4, 5, 6]], [[7, 8, 9]], axis=0)
# array([[1, 2, 3],
#        [4, 5, 6],
#        [7, 8, 9]])
# >>> np.append([[1, 2, 3], [4, 5, 6]], [7, 8, 9], axis=0)
# Traceback (most recent call last):
#     ...
# ValueError: all the input arrays must have same number of dimensions, but
# the array at index 0 has 2 dimension(s) and the array at index 1 has 1
# dimension(s)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.shape</u></summary>
# <blockquote>
# <code>
# Tuple of array dimensions.
#
# The shape property is usually used to get the current shape of an array,
# but may also be used to reshape the array in-place by assigning a tuple of
# array dimensions to it.  As with `numpy.reshape`, one of the new shape
# dimensions can be -1, in which case its value is inferred from the size of
# the array and the remaining dimensions. Reshaping an array in-place will
# fail if a copy is required.
#
# Examples
# --------
# >>> x = np.array([1, 2, 3, 4])
# >>> x.shape
# (4,)
# >>> y = np.zeros((2, 3, 4))
# >>> y.shape
# (2, 3, 4)
# >>> y.shape = (3, 8)
# >>> y
# array([[ 0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.],
#        [ 0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.],
#        [ 0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.]])
# >>> y.shape = (3, 6)
# Traceback (most recent call last):
#   File "<stdin>", line 1, in <module>
# ValueError: total size of new array must be unchanged
# >>> np.zeros((4,2))[::2].shape = (-1,)
# Traceback (most recent call last):
#   File "<stdin>", line 1, in <module>
# AttributeError: Incompatible shape for in-place modification. Use
# `.reshape()` to make a copy with the desired shape.
#
# See Also
# --------
# numpy.reshape : similar function
# ndarray.reshape : similar method
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index', 1 or 'columns'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# DataFrame or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.groupby</u></summary>
# <blockquote>
# <code>
# Group DataFrame using a mapper or by a Series of columns.
#
# A groupby operation involves some combination of splitting the
# object, applying a function, and combining the results. This can be
# used to group large amounts of data and compute operations on these
# groups.
#
# Parameters
# ----------
# by : mapping, function, label, or list of labels
#     Used to determine the groups for the groupby.
#     If ``by`` is a function, it's called on each value of the object's
#     index. If a dict or Series is passed, the Series or dict VALUES
#     will be used to determine the groups (the Series' values are first
#     aligned; see ``.align()`` method). If a list or ndarray of length
#     equal to the selected axis is passed (see the `groupby user guide
#     <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
#     the values are used as-is to determine the groups. A label or list
#     of labels may be passed to group by the columns in ``self``.
#     Notice that a tuple is interpreted as a (single) key.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Split along rows (0) or columns (1).
# level : int, level name, or sequence of such, default None
#     If the axis is a MultiIndex (hierarchical), group by a particular
#     level or levels.
# as_index : bool, default True
#     For aggregated output, return object with group labels as the
#     index. Only relevant for DataFrame input. as_index=False is
#     effectively "SQL-style" grouped output.
# sort : bool, default True
#     Sort group keys. Get better performance by turning this off.
#     Note this does not influence the order of observations within each
#     group. Groupby preserves the order of rows within each group.
# group_keys : bool, default True
#     When calling apply, add group keys to index to identify pieces.
# squeeze : bool, default False
#     Reduce the dimensionality of the return type if possible,
#     otherwise return a consistent type.
#
#     .. deprecated:: 1.1.0
#
# observed : bool, default False
#     This only applies if any of the groupers are Categoricals.
#     If True: only show observed values for categorical groupers.
#     If False: show all values for categorical groupers.
# dropna : bool, default True
#     If True, and if group keys contain NA values, NA values together
#     with row/column will be dropped.
#     If False, NA values will also be treated as the key in groups.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# DataFrameGroupBy
#     Returns a groupby object that contains information about the groups.
#
# See Also
# --------
# resample : Convenience method for frequency conversion and resampling
#     of time series.
#
# Notes
# -----
# See the `user guide
# <https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
# detailed usage and examples, including splitting an object into groups,
# iterating through groups, selecting a group, aggregation, and more.
#
# Examples
# --------
# >>> df = pd.DataFrame({'Animal': ['Falcon', 'Falcon',
# ...                               'Parrot', 'Parrot'],
# ...                    'Max Speed': [380., 370., 24., 26.]})
# >>> df
#    Animal  Max Speed
# 0  Falcon      380.0
# 1  Falcon      370.0
# 2  Parrot       24.0
# 3  Parrot       26.0
# >>> df.groupby(['Animal']).mean()
#         Max Speed
# Animal
# Falcon      375.0
# Parrot       25.0
#
# **Hierarchical Indexes**
#
# We can groupby different levels of a hierarchical index
# using the `level` parameter:
#
# >>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
# ...           ['Captive', 'Wild', 'Captive', 'Wild']]
# >>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
# >>> df = pd.DataFrame({'Max Speed': [390., 350., 30., 20.]},
# ...                   index=index)
# >>> df
#                 Max Speed
# Animal Type
# Falcon Captive      390.0
#        Wild         350.0
# Parrot Captive       30.0
#        Wild          20.0
# >>> df.groupby(level=0).mean()
#         Max Speed
# Animal
# Falcon      370.0
# Parrot       25.0
# >>> df.groupby(level="Type").mean()
#          Max Speed
# Type
# Captive      210.0
# Wild         185.0
#
# We can also choose to include NA in group keys or not by setting
# `dropna` parameter, the default setting is `True`.
#
# >>> l = [[1, 2, 3], [1, None, 4], [2, 1, 3], [1, 2, 2]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by=["b"]).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
#
# >>> df.groupby(by=["b"], dropna=False).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
# NaN 1   4
#
# >>> l = [["a", 12, 12], [None, 12.3, 33.], ["b", 12.3, 123], ["a", 1, 1]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by="a").sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
#
# >>> df.groupby(by="a", dropna=False).sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
# NaN 12.3   33.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.merge.merge</u></summary>
# <blockquote>
# <code>
# Merge DataFrame or named Series objects with a database-style join.
#
# A named Series object is treated as a DataFrame with a single named column.
#
# The join is done on columns or indexes. If joining columns on
# columns, the DataFrame indexes *will be ignored*. Otherwise if joining indexes
# on indexes or indexes on a column or columns, the index will be passed on.
# When performing a cross merge, no column specifications to merge on are
# allowed.
#
# .. warning::
#
#     If both key columns contain rows where the key is a null value, those
#     rows will be matched against each other. This is different from usual SQL
#     join behaviour and can lead to unexpected results.
#
# Parameters
# ----------
# left : DataFrame
# right : DataFrame or named Series
#     Object to merge with.
# how : {'left', 'right', 'outer', 'inner', 'cross'}, default 'inner'
#     Type of merge to be performed.
#
#     * left: use only keys from left frame, similar to a SQL left outer join;
#       preserve key order.
#     * right: use only keys from right frame, similar to a SQL right outer join;
#       preserve key order.
#     * outer: use union of keys from both frames, similar to a SQL full outer
#       join; sort keys lexicographically.
#     * inner: use intersection of keys from both frames, similar to a SQL inner
#       join; preserve the order of the left keys.
#     * cross: creates the cartesian product from both frames, preserves the order
#       of the left keys.
#
#       .. versionadded:: 1.2.0
#
# on : label or list
#     Column or index level names to join on. These must be found in both
#     DataFrames. If `on` is None and not merging on indexes then this defaults
#     to the intersection of the columns in both DataFrames.
# left_on : label or list, or array-like
#     Column or index level names to join on in the left DataFrame. Can also
#     be an array or list of arrays of the length of the left DataFrame.
#     These arrays are treated as if they are columns.
# right_on : label or list, or array-like
#     Column or index level names to join on in the right DataFrame. Can also
#     be an array or list of arrays of the length of the right DataFrame.
#     These arrays are treated as if they are columns.
# left_index : bool, default False
#     Use the index from the left DataFrame as the join key(s). If it is a
#     MultiIndex, the number of keys in the other DataFrame (either the index
#     or a number of columns) must match the number of levels.
# right_index : bool, default False
#     Use the index from the right DataFrame as the join key. Same caveats as
#     left_index.
# sort : bool, default False
#     Sort the join keys lexicographically in the result DataFrame. If False,
#     the order of the join keys depends on the join type (how keyword).
# suffixes : list-like, default is ("_x", "_y")
#     A length-2 sequence where each element is optionally a string
#     indicating the suffix to add to overlapping column names in
#     `left` and `right` respectively. Pass a value of `None` instead
#     of a string to indicate that the column name from `left` or
#     `right` should be left as-is, with no suffix. At least one of the
#     values must not be None.
# copy : bool, default True
#     If False, avoid copy if possible.
# indicator : bool or str, default False
#     If True, adds a column to the output DataFrame called "_merge" with
#     information on the source of each row. The column can be given a different
#     name by providing a string argument. The column will have a Categorical
#     type with the value of "left_only" for observations whose merge key only
#     appears in the left DataFrame, "right_only" for observations
#     whose merge key only appears in the right DataFrame, and "both"
#     if the observation's merge key is found in both DataFrames.
#
# validate : str, optional
#     If specified, checks if merge is of specified type.
#
#     * "one_to_one" or "1:1": check if merge keys are unique in both
#       left and right datasets.
#     * "one_to_many" or "1:m": check if merge keys are unique in left
#       dataset.
#     * "many_to_one" or "m:1": check if merge keys are unique in right
#       dataset.
#     * "many_to_many" or "m:m": allowed, but does not result in checks.
#
# Returns
# -------
# DataFrame
#     A DataFrame of the two merged objects.
#
# See Also
# --------
# merge_ordered : Merge with optional filling/interpolation.
# merge_asof : Merge on nearest keys.
# DataFrame.join : Similar method using indices.
#
# Notes
# -----
# Support for specifying index levels as the `on`, `left_on`, and
# `right_on` parameters was added in version 0.23.0
# Support for merging named Series objects was added in version 0.24.0
#
# Examples
# --------
# >>> df1 = pd.DataFrame({'lkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [1, 2, 3, 5]})
# >>> df2 = pd.DataFrame({'rkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [5, 6, 7, 8]})
# >>> df1
#     lkey value
# 0   foo      1
# 1   bar      2
# 2   baz      3
# 3   foo      5
# >>> df2
#     rkey value
# 0   foo      5
# 1   bar      6
# 2   baz      7
# 3   foo      8
#
# Merge df1 and df2 on the lkey and rkey columns. The value columns have
# the default suffixes, _x and _y, appended.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey')
#   lkey  value_x rkey  value_y
# 0  foo        1  foo        5
# 1  foo        1  foo        8
# 2  foo        5  foo        5
# 3  foo        5  foo        8
# 4  bar        2  bar        6
# 5  baz        3  baz        7
#
# Merge DataFrames df1 and df2 with specified left and right suffixes
# appended to any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey',
# ...           suffixes=('_left', '_right'))
#   lkey  value_left rkey  value_right
# 0  foo           1  foo            5
# 1  foo           1  foo            8
# 2  foo           5  foo            5
# 3  foo           5  foo            8
# 4  bar           2  bar            6
# 5  baz           3  baz            7
#
# Merge DataFrames df1 and df2, but raise an exception if the DataFrames have
# any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey', suffixes=(False, False))
# Traceback (most recent call last):
# ...
# ValueError: columns overlap but no suffix specified:
#     Index(['value'], dtype='object')
#
# >>> df1 = pd.DataFrame({'a': ['foo', 'bar'], 'b': [1, 2]})
# >>> df2 = pd.DataFrame({'a': ['foo', 'baz'], 'c': [3, 4]})
# >>> df1
#       a  b
# 0   foo  1
# 1   bar  2
# >>> df2
#       a  c
# 0   foo  3
# 1   baz  4
#
# >>> df1.merge(df2, how='inner', on='a')
#       a  b  c
# 0   foo  1  3
#
# >>> df1.merge(df2, how='left', on='a')
#       a  b  c
# 0   foo  1  3.0
# 1   bar  2  NaN
#
# >>> df1 = pd.DataFrame({'left': ['foo', 'bar']})
# >>> df2 = pd.DataFrame({'right': [7, 8]})
# >>> df1
#     left
# 0   foo
# 1   bar
# >>> df2
#     right
# 0   7
# 1   8
#
# >>> df1.merge(df2, how='cross')
#    left  right
# 0   foo      7
# 1   foo      8
# 2   bar      7
# 3   bar      8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>posix</b>
# <ul>
# <li>
# <details><summary><u>posix.listdir</u></summary>
# <blockquote>
# <code>
# Return a list containing the names of the files in the directory.
#
# path can be specified as either str, bytes, or a path-like object.  If path is bytes,
#   the filenames returned will also be bytes; in all other circumstances
#   the filenames returned will be str.
# If path is None, uses the path='.'.
# On some platforms, path may also be specified as an open file descriptor;\
#   the file descriptor must refer to a directory.
#   If this functionality is unavailable, using it raises NotImplementedError.
#
# The list is in arbitrary order.  It does not include the special
# entries '.' and '..' even if they are present in the directory.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.MinMaxScaler</u></summary>
# <blockquote>
# <code>
# Transform features by scaling each feature to a given range.
#
# This estimator scales and translates each feature individually such
# that it is in the given range on the training set, e.g. between
# zero and one.
#
# The transformation is given by::
#
#     X_std = (X - X.min(axis=0)) / (X.max(axis=0) - X.min(axis=0))
#     X_scaled = X_std * (max - min) + min
#
# where min, max = feature_range.
#
# This transformation is often used as an alternative to zero mean,
# unit variance scaling.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# feature_range : tuple (min, max), default=(0, 1)
#     Desired range of transformed data.
#
# copy : bool, default=True
#     Set to False to perform inplace row normalization and avoid a
#     copy (if the input is already a numpy array).
#
# clip : bool, default=False
#     Set to True to clip transformed values of held-out data to
#     provided `feature range`.
#
#     .. versionadded:: 0.24
#
# Attributes
# ----------
# min_ : ndarray of shape (n_features,)
#     Per feature adjustment for minimum. Equivalent to
#     ``min - X.min(axis=0) * self.scale_``
#
# scale_ : ndarray of shape (n_features,)
#     Per feature relative scaling of the data. Equivalent to
#     ``(max - min) / (X.max(axis=0) - X.min(axis=0))``
#
#     .. versionadded:: 0.17
#        *scale_* attribute.
#
# data_min_ : ndarray of shape (n_features,)
#     Per feature minimum seen in the data
#
#     .. versionadded:: 0.17
#        *data_min_*
#
# data_max_ : ndarray of shape (n_features,)
#     Per feature maximum seen in the data
#
#     .. versionadded:: 0.17
#        *data_max_*
#
# data_range_ : ndarray of shape (n_features,)
#     Per feature range ``(data_max_ - data_min_)`` seen in the data
#
#     .. versionadded:: 0.17
#        *data_range_*
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# n_samples_seen_ : int
#     The number of samples processed by the estimator.
#     It will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# See Also
# --------
# minmax_scale : Equivalent function without the estimator API.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import MinMaxScaler
# >>> data = [[-1, 2], [-0.5, 6], [0, 10], [1, 18]]
# >>> scaler = MinMaxScaler()
# >>> print(scaler.fit(data))
# MinMaxScaler()
# >>> print(scaler.data_max_)
# [ 1. 18.]
# >>> print(scaler.transform(data))
# [[0.   0.  ]
#  [0.25 0.25]
#  [0.5  0.5 ]
#  [1.   1.  ]]
# >>> print(scaler.transform([[2, 2]]))
# [[1.5 0. ]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>posix</h2>
# <ul>
# <li>
# <details><summary><u>posix.listdir</u></summary>
# <blockquote>
# <code>
# Return a list containing the names of the files in the directory.
#
# path can be specified as either str, bytes, or a path-like object.  If path is bytes,
#   the filenames returned will also be bytes; in all other circumstances
#   the filenames returned will be str.
# If path is None, uses the path='.'.
# On some platforms, path may also be specified as an open file descriptor;\
#   the file descriptor must refer to a directory.
#   If this functionality is unavailable, using it raises NotImplementedError.
#
# The list is in arbitrary order.  It does not include the special
# entries '.' and '..' even if they are present in the directory.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
# This Python 3 environment comes with many helpful analytics libraries installed
# It is defined by the kaggle/python docker image: https://github.com/kaggle/docker-python
# For example, here's several helpful packages to load in 

import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)

# Input data files are available in the "../input/" directory.
# For example, running this (by clicking run or pressing Shift+Enter) will list the files in the input directory

import os
print(os.listdir("../input"))

# Any results you write to the current directory are saved as output.


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation | Feature Engineering | Library Loading | Model Building and Training | Visualization</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.groupby</u></summary>
# <blockquote>
# <code>
# Group DataFrame using a mapper or by a Series of columns.
#
# A groupby operation involves some combination of splitting the
# object, applying a function, and combining the results. This can be
# used to group large amounts of data and compute operations on these
# groups.
#
# Parameters
# ----------
# by : mapping, function, label, or list of labels
#     Used to determine the groups for the groupby.
#     If ``by`` is a function, it's called on each value of the object's
#     index. If a dict or Series is passed, the Series or dict VALUES
#     will be used to determine the groups (the Series' values are first
#     aligned; see ``.align()`` method). If a list or ndarray of length
#     equal to the selected axis is passed (see the `groupby user guide
#     <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
#     the values are used as-is to determine the groups. A label or list
#     of labels may be passed to group by the columns in ``self``.
#     Notice that a tuple is interpreted as a (single) key.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Split along rows (0) or columns (1).
# level : int, level name, or sequence of such, default None
#     If the axis is a MultiIndex (hierarchical), group by a particular
#     level or levels.
# as_index : bool, default True
#     For aggregated output, return object with group labels as the
#     index. Only relevant for DataFrame input. as_index=False is
#     effectively "SQL-style" grouped output.
# sort : bool, default True
#     Sort group keys. Get better performance by turning this off.
#     Note this does not influence the order of observations within each
#     group. Groupby preserves the order of rows within each group.
# group_keys : bool, default True
#     When calling apply, add group keys to index to identify pieces.
# squeeze : bool, default False
#     Reduce the dimensionality of the return type if possible,
#     otherwise return a consistent type.
#
#     .. deprecated:: 1.1.0
#
# observed : bool, default False
#     This only applies if any of the groupers are Categoricals.
#     If True: only show observed values for categorical groupers.
#     If False: show all values for categorical groupers.
# dropna : bool, default True
#     If True, and if group keys contain NA values, NA values together
#     with row/column will be dropped.
#     If False, NA values will also be treated as the key in groups.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# DataFrameGroupBy
#     Returns a groupby object that contains information about the groups.
#
# See Also
# --------
# resample : Convenience method for frequency conversion and resampling
#     of time series.
#
# Notes
# -----
# See the `user guide
# <https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
# detailed usage and examples, including splitting an object into groups,
# iterating through groups, selecting a group, aggregation, and more.
#
# Examples
# --------
# >>> df = pd.DataFrame({'Animal': ['Falcon', 'Falcon',
# ...                               'Parrot', 'Parrot'],
# ...                    'Max Speed': [380., 370., 24., 26.]})
# >>> df
#    Animal  Max Speed
# 0  Falcon      380.0
# 1  Falcon      370.0
# 2  Parrot       24.0
# 3  Parrot       26.0
# >>> df.groupby(['Animal']).mean()
#         Max Speed
# Animal
# Falcon      375.0
# Parrot       25.0
#
# **Hierarchical Indexes**
#
# We can groupby different levels of a hierarchical index
# using the `level` parameter:
#
# >>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
# ...           ['Captive', 'Wild', 'Captive', 'Wild']]
# >>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
# >>> df = pd.DataFrame({'Max Speed': [390., 350., 30., 20.]},
# ...                   index=index)
# >>> df
#                 Max Speed
# Animal Type
# Falcon Captive      390.0
#        Wild         350.0
# Parrot Captive       30.0
#        Wild          20.0
# >>> df.groupby(level=0).mean()
#         Max Speed
# Animal
# Falcon      370.0
# Parrot       25.0
# >>> df.groupby(level="Type").mean()
#          Max Speed
# Type
# Captive      210.0
# Wild         185.0
#
# We can also choose to include NA in group keys or not by setting
# `dropna` parameter, the default setting is `True`.
#
# >>> l = [[1, 2, 3], [1, None, 4], [2, 1, 3], [1, 2, 2]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by=["b"]).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
#
# >>> df.groupby(by=["b"], dropna=False).sum()
#     a   c
# b
# 1.0 2   3
# 2.0 2   5
# NaN 1   4
#
# >>> l = [["a", 12, 12], [None, 12.3, 33.], ["b", 12.3, 123], ["a", 1, 1]]
# >>> df = pd.DataFrame(l, columns=["a", "b", "c"])
#
# >>> df.groupby(by="a").sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
#
# >>> df.groupby(by="a", dropna=False).sum()
#     b     c
# a
# a   13.0   13.0
# b   12.3  123.0
# NaN 12.3   33.0
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.merge.merge</u></summary>
# <blockquote>
# <code>
# Merge DataFrame or named Series objects with a database-style join.
#
# A named Series object is treated as a DataFrame with a single named column.
#
# The join is done on columns or indexes. If joining columns on
# columns, the DataFrame indexes *will be ignored*. Otherwise if joining indexes
# on indexes or indexes on a column or columns, the index will be passed on.
# When performing a cross merge, no column specifications to merge on are
# allowed.
#
# .. warning::
#
#     If both key columns contain rows where the key is a null value, those
#     rows will be matched against each other. This is different from usual SQL
#     join behaviour and can lead to unexpected results.
#
# Parameters
# ----------
# left : DataFrame
# right : DataFrame or named Series
#     Object to merge with.
# how : {'left', 'right', 'outer', 'inner', 'cross'}, default 'inner'
#     Type of merge to be performed.
#
#     * left: use only keys from left frame, similar to a SQL left outer join;
#       preserve key order.
#     * right: use only keys from right frame, similar to a SQL right outer join;
#       preserve key order.
#     * outer: use union of keys from both frames, similar to a SQL full outer
#       join; sort keys lexicographically.
#     * inner: use intersection of keys from both frames, similar to a SQL inner
#       join; preserve the order of the left keys.
#     * cross: creates the cartesian product from both frames, preserves the order
#       of the left keys.
#
#       .. versionadded:: 1.2.0
#
# on : label or list
#     Column or index level names to join on. These must be found in both
#     DataFrames. If `on` is None and not merging on indexes then this defaults
#     to the intersection of the columns in both DataFrames.
# left_on : label or list, or array-like
#     Column or index level names to join on in the left DataFrame. Can also
#     be an array or list of arrays of the length of the left DataFrame.
#     These arrays are treated as if they are columns.
# right_on : label or list, or array-like
#     Column or index level names to join on in the right DataFrame. Can also
#     be an array or list of arrays of the length of the right DataFrame.
#     These arrays are treated as if they are columns.
# left_index : bool, default False
#     Use the index from the left DataFrame as the join key(s). If it is a
#     MultiIndex, the number of keys in the other DataFrame (either the index
#     or a number of columns) must match the number of levels.
# right_index : bool, default False
#     Use the index from the right DataFrame as the join key. Same caveats as
#     left_index.
# sort : bool, default False
#     Sort the join keys lexicographically in the result DataFrame. If False,
#     the order of the join keys depends on the join type (how keyword).
# suffixes : list-like, default is ("_x", "_y")
#     A length-2 sequence where each element is optionally a string
#     indicating the suffix to add to overlapping column names in
#     `left` and `right` respectively. Pass a value of `None` instead
#     of a string to indicate that the column name from `left` or
#     `right` should be left as-is, with no suffix. At least one of the
#     values must not be None.
# copy : bool, default True
#     If False, avoid copy if possible.
# indicator : bool or str, default False
#     If True, adds a column to the output DataFrame called "_merge" with
#     information on the source of each row. The column can be given a different
#     name by providing a string argument. The column will have a Categorical
#     type with the value of "left_only" for observations whose merge key only
#     appears in the left DataFrame, "right_only" for observations
#     whose merge key only appears in the right DataFrame, and "both"
#     if the observation's merge key is found in both DataFrames.
#
# validate : str, optional
#     If specified, checks if merge is of specified type.
#
#     * "one_to_one" or "1:1": check if merge keys are unique in both
#       left and right datasets.
#     * "one_to_many" or "1:m": check if merge keys are unique in left
#       dataset.
#     * "many_to_one" or "m:1": check if merge keys are unique in right
#       dataset.
#     * "many_to_many" or "m:m": allowed, but does not result in checks.
#
# Returns
# -------
# DataFrame
#     A DataFrame of the two merged objects.
#
# See Also
# --------
# merge_ordered : Merge with optional filling/interpolation.
# merge_asof : Merge on nearest keys.
# DataFrame.join : Similar method using indices.
#
# Notes
# -----
# Support for specifying index levels as the `on`, `left_on`, and
# `right_on` parameters was added in version 0.23.0
# Support for merging named Series objects was added in version 0.24.0
#
# Examples
# --------
# >>> df1 = pd.DataFrame({'lkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [1, 2, 3, 5]})
# >>> df2 = pd.DataFrame({'rkey': ['foo', 'bar', 'baz', 'foo'],
# ...                     'value': [5, 6, 7, 8]})
# >>> df1
#     lkey value
# 0   foo      1
# 1   bar      2
# 2   baz      3
# 3   foo      5
# >>> df2
#     rkey value
# 0   foo      5
# 1   bar      6
# 2   baz      7
# 3   foo      8
#
# Merge df1 and df2 on the lkey and rkey columns. The value columns have
# the default suffixes, _x and _y, appended.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey')
#   lkey  value_x rkey  value_y
# 0  foo        1  foo        5
# 1  foo        1  foo        8
# 2  foo        5  foo        5
# 3  foo        5  foo        8
# 4  bar        2  bar        6
# 5  baz        3  baz        7
#
# Merge DataFrames df1 and df2 with specified left and right suffixes
# appended to any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey',
# ...           suffixes=('_left', '_right'))
#   lkey  value_left rkey  value_right
# 0  foo           1  foo            5
# 1  foo           1  foo            8
# 2  foo           5  foo            5
# 3  foo           5  foo            8
# 4  bar           2  bar            6
# 5  baz           3  baz            7
#
# Merge DataFrames df1 and df2, but raise an exception if the DataFrames have
# any overlapping columns.
#
# >>> df1.merge(df2, left_on='lkey', right_on='rkey', suffixes=(False, False))
# Traceback (most recent call last):
# ...
# ValueError: columns overlap but no suffix specified:
#     Index(['value'], dtype='object')
#
# >>> df1 = pd.DataFrame({'a': ['foo', 'bar'], 'b': [1, 2]})
# >>> df2 = pd.DataFrame({'a': ['foo', 'baz'], 'c': [3, 4]})
# >>> df1
#       a  b
# 0   foo  1
# 1   bar  2
# >>> df2
#       a  c
# 0   foo  3
# 1   baz  4
#
# >>> df1.merge(df2, how='inner', on='a')
#       a  b  c
# 0   foo  1  3
#
# >>> df1.merge(df2, how='left', on='a')
#       a  b  c
# 0   foo  1  3.0
# 1   bar  2  NaN
#
# >>> df1 = pd.DataFrame({'left': ['foo', 'bar']})
# >>> df2 = pd.DataFrame({'right': [7, 8]})
# >>> df1
#     left
# 0   foo
# 1   bar
# >>> df2
#     right
# 0   7
# 1   8
#
# >>> df1.merge(df2, how='cross')
#    left  right
# 0   foo      7
# 1   foo      8
# 2   bar      7
# 3   bar      8
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index', 1 or 'columns'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# DataFrame or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.MinMaxScaler</u></summary>
# <blockquote>
# <code>
# Transform features by scaling each feature to a given range.
#
# This estimator scales and translates each feature individually such
# that it is in the given range on the training set, e.g. between
# zero and one.
#
# The transformation is given by::
#
#     X_std = (X - X.min(axis=0)) / (X.max(axis=0) - X.min(axis=0))
#     X_scaled = X_std * (max - min) + min
#
# where min, max = feature_range.
#
# This transformation is often used as an alternative to zero mean,
# unit variance scaling.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# feature_range : tuple (min, max), default=(0, 1)
#     Desired range of transformed data.
#
# copy : bool, default=True
#     Set to False to perform inplace row normalization and avoid a
#     copy (if the input is already a numpy array).
#
# clip : bool, default=False
#     Set to True to clip transformed values of held-out data to
#     provided `feature range`.
#
#     .. versionadded:: 0.24
#
# Attributes
# ----------
# min_ : ndarray of shape (n_features,)
#     Per feature adjustment for minimum. Equivalent to
#     ``min - X.min(axis=0) * self.scale_``
#
# scale_ : ndarray of shape (n_features,)
#     Per feature relative scaling of the data. Equivalent to
#     ``(max - min) / (X.max(axis=0) - X.min(axis=0))``
#
#     .. versionadded:: 0.17
#        *scale_* attribute.
#
# data_min_ : ndarray of shape (n_features,)
#     Per feature minimum seen in the data
#
#     .. versionadded:: 0.17
#        *data_min_*
#
# data_max_ : ndarray of shape (n_features,)
#     Per feature maximum seen in the data
#
#     .. versionadded:: 0.17
#        *data_max_*
#
# data_range_ : ndarray of shape (n_features,)
#     Per feature range ``(data_max_ - data_min_)`` seen in the data
#
#     .. versionadded:: 0.17
#        *data_range_*
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# n_samples_seen_ : int
#     The number of samples processed by the estimator.
#     It will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# See Also
# --------
# minmax_scale : Equivalent function without the estimator API.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import MinMaxScaler
# >>> data = [[-1, 2], [-0.5, 6], [0, 10], [1, 18]]
# >>> scaler = MinMaxScaler()
# >>> print(scaler.fit(data))
# MinMaxScaler()
# >>> print(scaler.data_max_)
# [ 1. 18.]
# >>> print(scaler.transform(data))
# [[0.   0.  ]
#  [0.25 0.25]
#  [0.5  0.5 ]
#  [1.   1.  ]]
# >>> print(scaler.transform([[2, 2]]))
# [[1.5 0. ]]
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.lib.function_base.append</u></summary>
# <blockquote>
# <code>
# Append values to the end of an array.
#
# Parameters
# ----------
# arr : array_like
#     Values are appended to a copy of this array.
# values : array_like
#     These values are appended to a copy of `arr`.  It must be of the
#     correct shape (the same shape as `arr`, excluding `axis`).  If
#     `axis` is not specified, `values` can be any shape and will be
#     flattened before use.
# axis : int, optional
#     The axis along which `values` are appended.  If `axis` is not
#     given, both `arr` and `values` are flattened before use.
#
# Returns
# -------
# append : ndarray
#     A copy of `arr` with `values` appended to `axis`.  Note that
#     `append` does not occur in-place: a new array is allocated and
#     filled.  If `axis` is None, `out` is a flattened array.
#
# See Also
# --------
# insert : Insert elements into an array.
# delete : Delete elements from an array.
#
# Examples
# --------
# >>> np.append([1, 2, 3], [[4, 5, 6], [7, 8, 9]])
# array([1, 2, 3, ..., 7, 8, 9])
#
# When `axis` is specified, `values` must have the correct shape.
#
# >>> np.append([[1, 2, 3], [4, 5, 6]], [[7, 8, 9]], axis=0)
# array([[1, 2, 3],
#        [4, 5, 6],
#        [7, 8, 9]])
# >>> np.append([[1, 2, 3], [4, 5, 6]], [7, 8, 9], axis=0)
# Traceback (most recent call last):
#     ...
# ValueError: all the input arrays must have same number of dimensions, but
# the array at index 0 has 2 dimension(s) and the array at index 1 has 1
# dimension(s)
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.recurrent_v2.LSTM</u></summary>
# <blockquote>
# <code>
# Long Short-Term Memory layer - Hochreiter 1997.
#
# See [the Keras RNN API guide](https://www.tensorflow.org/guide/keras/rnn)
# for details about the usage of RNN API.
#
# Based on available runtime hardware and constraints, this layer
# will choose different implementations (cuDNN-based or pure-TensorFlow)
# to maximize the performance. If a GPU is available and all
# the arguments to the layer meet the requirement of the cuDNN kernel
# (see below for details), the layer will use a fast cuDNN implementation.
#
# The requirements to use the cuDNN implementation are:
#
# 1. `activation` == `tanh`
# 2. `recurrent_activation` == `sigmoid`
# 3. `recurrent_dropout` == 0
# 4. `unroll` is `False`
# 5. `use_bias` is `True`
# 6. Inputs, if use masking, are strictly right-padded.
# 7. Eager execution is enabled in the outermost context.
#
# For example:
#
# >>> inputs = tf.random.normal([32, 10, 8])
# >>> lstm = tf.keras.layers.LSTM(4)
# >>> output = lstm(inputs)
# >>> print(output.shape)
# (32, 4)
# >>> lstm = tf.keras.layers.LSTM(4, return_sequences=True, return_state=True)
# >>> whole_seq_output, final_memory_state, final_carry_state = lstm(inputs)
# >>> print(whole_seq_output.shape)
# (32, 10, 4)
# >>> print(final_memory_state.shape)
# (32, 4)
# >>> print(final_carry_state.shape)
# (32, 4)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     Default: hyperbolic tangent (`tanh`). If you pass `None`, no activation
#     is applied (ie. "linear" activation: `a(x) = x`).
#   recurrent_activation: Activation function to use for the recurrent step.
#     Default: sigmoid (`sigmoid`). If you pass `None`, no activation is
#     applied (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean (default `True`), whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix, used for
#     the linear transformation of the inputs. Default: `glorot_uniform`.
#   recurrent_initializer: Initializer for the `recurrent_kernel` weights
#     matrix, used for the linear transformation of the recurrent state.
#     Default: `orthogonal`.
#   bias_initializer: Initializer for the bias vector. Default: `zeros`.
#   unit_forget_bias: Boolean (default `True`). If True, add 1 to the bias of
#     the forget gate at initialization. Setting it to true will also force
#     `bias_initializer="zeros"`. This is recommended in [Jozefowicz et
#         al.](http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf).
#   kernel_regularizer: Regularizer function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_regularizer: Regularizer function applied to the
#     `recurrent_kernel` weights matrix. Default: `None`.
#   bias_regularizer: Regularizer function applied to the bias vector. Default:
#     `None`.
#   activity_regularizer: Regularizer function applied to the output of the
#     layer (its "activation"). Default: `None`.
#   kernel_constraint: Constraint function applied to the `kernel` weights
#     matrix. Default: `None`.
#   recurrent_constraint: Constraint function applied to the `recurrent_kernel`
#     weights matrix. Default: `None`.
#   bias_constraint: Constraint function applied to the bias vector. Default:
#     `None`.
#   dropout: Float between 0 and 1. Fraction of the units to drop for the linear
#     transformation of the inputs. Default: 0.
#   recurrent_dropout: Float between 0 and 1. Fraction of the units to drop for
#     the linear transformation of the recurrent state. Default: 0.
#   return_sequences: Boolean. Whether to return the last output. in the output
#     sequence, or the full sequence. Default: `False`.
#   return_state: Boolean. Whether to return the last state in addition to the
#     output. Default: `False`.
#   go_backwards: Boolean (default `False`). If True, process the input sequence
#     backwards and return the reversed sequence.
#   stateful: Boolean (default `False`). If True, the last state for each sample
#     at index i in a batch will be used as initial state for the sample of
#     index i in the following batch.
#   time_major: The shape format of the `inputs` and `outputs` tensors.
#     If True, the inputs and outputs will be in shape
#     `[timesteps, batch, feature]`, whereas in the False case, it will be
#     `[batch, timesteps, feature]`. Using `time_major = True` is a bit more
#     efficient because it avoids transposes at the beginning and end of the
#     RNN calculation. However, most TensorFlow data is batch-major, so by
#     default this function accepts input and emits output in batch-major
#     form.
#   unroll: Boolean (default `False`). If True, the network will be unrolled,
#     else a symbolic loop will be used. Unrolling can speed-up a RNN, although
#     it tends to be more memory-intensive. Unrolling is only suitable for short
#     sequences.
#
# Call arguments:
#   inputs: A 3D tensor with shape `[batch, timesteps, feature]`.
#   mask: Binary tensor of shape `[batch, timesteps]` indicating whether
#     a given timestep should be masked (optional, defaults to `None`).
#     An individual `True` entry indicates that the corresponding timestep
#     should be utilized, while a `False` entry indicates that the corresponding
#     timestep should be ignored.
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode. This argument is passed to the cell
#     when calling it. This is only relevant if `dropout` or
#     `recurrent_dropout` is used (optional, defaults to `None`).
#   initial_state: List of initial state tensors to be passed to the first
#     call of the cell (optional, defaults to `None` which causes creation
#     of zero-filled initial state tensors).
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _cell_guid="79c7e3d0-c299-4dcb-8224-4455121ee9b0" _uuid="d629ff2d2480ee46fbb7e2d37f6b5fab8052498a"
# Adapted from https://www.kaggle.com/sebask/keras-2-0

import time
notebookstart= time.time()

import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)
from keras.models import Sequential
from keras.layers import LSTM, Dense, Activation, ThresholdedReLU, MaxPooling2D, Embedding, Dropout
from keras.optimizers import Adam, SGD, RMSprop
from keras import backend as K
from sklearn.model_selection import train_test_split
from keras.callbacks import EarlyStopping
from sklearn.preprocessing import MinMaxScaler
import gc

# Viz
import matplotlib.pyplot as plt

# Import data
sales = pd.read_csv('../input/sales_train.csv', parse_dates=['date'], infer_datetime_format=True, dayfirst=True)
shops = pd.read_csv('../input/shops.csv')
items = pd.read_csv('../input/items.csv')
cats = pd.read_csv('../input/item_categories.csv')
val = pd.read_csv('../input/test.csv')

# Rearrange the raw data to be monthly sales by item-shop
df = sales.groupby([sales.date.apply(lambda x: x.strftime('%Y-%m')),'item_id','shop_id']).sum().reset_index()
df = df[['date','item_id','shop_id','item_cnt_day']]
df["item_cnt_day"].clip(0.,20.,inplace=True)
df = df.pivot_table(index=['item_id','shop_id'], columns='date',values='item_cnt_day',fill_value=0).reset_index()

# Merge data from monthly sales to specific item-shops in test data
test = pd.merge(val,df,on=['item_id','shop_id'], how='left').fillna(0)

# Strip categorical data so keras only sees raw timeseries
test = test.drop(labels=['ID','item_id','shop_id'],axis=1)

# Rearrange the raw data to be monthly average price by item-shop
# Scale Price
scaler = MinMaxScaler(feature_range=(0, 1))
sales["item_price"] = scaler.fit_transform(sales["item_price"].values.reshape(-1,1))
df2 = sales.groupby([sales.date.apply(lambda x: x.strftime('%Y-%m')),'item_id','shop_id']).mean().reset_index()
df2 = df2[['date','item_id','shop_id','item_price']].pivot_table(index=['item_id','shop_id'], columns='date',values='item_price',fill_value=0).reset_index()

# Merge data from average prices to specific item-shops in test data
price = pd.merge(val,df2,on=['item_id','shop_id'], how='left').fillna(0)
price = price.drop(labels=['ID','item_id','shop_id'],axis=1)

# Create x and y training sets from oldest data points
y_train = test['2015-10']
x_sales = test.drop(labels=['2015-10'],axis=1)
x_sales = x_sales.values.reshape((x_sales.shape[0], x_sales.shape[1], 1))
x_prices = price.drop(labels=['2015-10'],axis=1)
x_prices= x_prices.values.reshape((x_prices.shape[0], x_prices.shape[1], 1))
X = np.append(x_sales,x_prices,axis=2)

y = y_train.values.reshape((214200, 1))
print("Training Predictor Shape: ",X.shape)
print("Training Predictee Shape: ",y.shape)
del y_train, x_sales; gc.collect()

# Transform test set into numpy matrix
test = test.drop(labels=['2013-01'],axis=1)
x_test_sales = test.values.reshape((test.shape[0], test.shape[1], 1))
x_test_prices = price.drop(labels=['2013-01'],axis=1)
x_test_prices = x_test_prices.values.reshape((x_test_prices.shape[0], x_test_prices.shape[1], 1))

# Combine Price and Sales Df
test = np.append(x_test_sales,x_test_prices,axis=2)
del x_test_sales,x_test_prices, price; gc.collect()
print("Test Predictor Shape: ",test.shape)

print("Modeling Stage")
# Define the model layers
model_lstm = Sequential()
model_lstm.add(LSTM(16, input_shape=(X.shape[1], X.shape[2]),return_sequences=True))
model_lstm.add(Dropout(0.5))
model_lstm.add(LSTM(32))
model_lstm.add(Dropout(0.5))
model_lstm.add(Dense(1))
model_lstm.compile(optimizer="adam", loss='mse', metrics=["mse"])
print(model_lstm.summary())

# Train Model
print("\nFit Model")
VALID = True
LSTM_PARAM = {"batch_size":128,
              "verbose":2,
              "epochs":10}

modelstart = time.time()
if VALID is True:
    X_train, X_valid, y_train, y_valid = train_test_split(X, y, test_size=0.10, random_state=1, shuffle=False)
    # del X,y; gc.collect()
    print("X Train Shape: ",X_train.shape)
    print("X Valid Shape: ",X_valid.shape)
    print("y Train Shape: ",y_train.shape)
    print("y Valid Shape: ",y_valid.shape)
    
    callbacks_list=[EarlyStopping(monitor="val_loss",min_delta=.001, patience=3,mode='auto')]
    hist = model_lstm.fit(X_train, y_train,
                          validation_data=(X_valid, y_valid),
                          callbacks=callbacks_list,
                          **LSTM_PARAM)
    pred = model_lstm.predict(test)

    # Model Evaluation
    best = np.argmin(hist.history["val_loss"])
    print("Optimal Epoch: {}",best)
    print("Train Score: {}, Validation Score: {}".format(hist.history["loss"][best],hist.history["val_loss"][best]))

    plt.plot(hist.history['loss'], label='train')
    plt.plot(hist.history['val_loss'], label='validation')
    plt.xlabel("Epochs")
    plt.ylabel("Mean Square Error")
    plt.legend()
    plt.show()
    plt.savefig("Train and Validation MSE Progression.png")

if VALID is False:
    print("X Shape: ",X.shape)
    print("y Shape: ",y.shape)
    hist = model_lstm.fit(X,y,**LSTM_PARAM)
    pred = model_lstm.predict(X)
    
    plt.plot(hist.history['loss'], label='Training Loss')
    plt.xlabel("Epochs")
    plt.ylabel("Mean Square Error")
    plt.legend()
    plt.show()
    plt.savefig("Training Loss Progression.png")

print("\Output Submission")
submission = pd.DataFrame(pred,columns=['item_cnt_month'])
submission.to_csv('submission.csv',index_label='ID')
print(submission.head())
print("\nModel Runtime: %0.2f Minutes"%((time.time() - modelstart)/60))
print("Notebook Runtime: %0.2f Minutes"%((time.time() - notebookstart)/60))

# %% _uuid="4d5eb5aade970a3507149c46c66bb3e3de344c5e"
