# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>keras</b></li>
# <li><b>numpy</b></li>
# <li><b>pandas</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Visualization</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.unique</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return unique values of Series object.
#
# Uniques are returned in order of appearance. Hash table-based unique,
# therefore does NOT sort.
#
# Returns
# -------
# ndarray or ExtensionArray
#     The unique values returned as a NumPy array. See Notes.
#
# See Also
# --------
# unique : Top-level unique method for any 1-d array-like object.
# Index.unique : Return Index with unique values from an Index object.
#
# Notes
# -----
# Returns the unique values as a NumPy array. In case of an
# extension-array backed Series, a new
# :class:`~api.extensions.ExtensionArray` of that type with just
# the unique values is returned. This includes
#
#     * Categorical
#     * Period
#     * Datetime with Timezone
#     * Interval
#     * Sparse
#     * IntegerNA
#
# See Examples section.
#
# Examples
# --------
# >>> pd.Series([2, 1, 3, 3], name='A').unique()
# array([2, 1, 3])
#
# >>> pd.Series([pd.Timestamp('2016-01-01') for _ in range(3)]).unique()
# array(['2016-01-01T00:00:00.000000000'], dtype='datetime64[ns]')
#
# >>> pd.Series([pd.Timestamp('2016-01-01', tz='US/Eastern')
# ...            for _ in range(3)]).unique()
# <DatetimeArray>
# ['2016-01-01 00:00:00-05:00']
# Length: 1, dtype: datetime64[ns, US/Eastern]
#
# An Categorical will return categories in the order of
# appearance and with the same dtype.
#
# >>> pd.Series(pd.Categorical(list('baabc'))).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a', 'b', 'c']
# >>> pd.Series(pd.Categorical(list('baabc'), categories=list('abc'),
# ...                          ordered=True)).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a' < 'b' < 'c']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.rename</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Alter axes labels.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# mapper : dict-like or function
#     Dict-like or function transformations to apply to
#     that axis' values. Use either ``mapper`` and ``axis`` to
#     specify the axis to target with ``mapper``, or ``index`` and
#     ``columns``.
# index : dict-like or function
#     Alternative to specifying axis (``mapper, axis=0``
#     is equivalent to ``index=mapper``).
# columns : dict-like or function
#     Alternative to specifying axis (``mapper, axis=1``
#     is equivalent to ``columns=mapper``).
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Axis to target with ``mapper``. Can be either the axis name
#     ('index', 'columns') or number (0, 1). The default is 'index'.
# copy : bool, default True
#     Also copy underlying data.
# inplace : bool, default False
#     Whether to return a new DataFrame. If True then value of copy is
#     ignored.
# level : int or level name, default None
#     In case of a MultiIndex, only rename labels in the specified
#     level.
# errors : {'ignore', 'raise'}, default 'ignore'
#     If 'raise', raise a `KeyError` when a dict-like `mapper`, `index`,
#     or `columns` contains labels that are not present in the Index
#     being transformed.
#     If 'ignore', existing keys will be renamed and extra keys will be
#     ignored.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the renamed axis labels or None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis and
#     "errors='raise'".
#
# See Also
# --------
# DataFrame.rename_axis : Set the name of the axis.
#
# Examples
# --------
# ``DataFrame.rename`` supports two calling conventions
#
# * ``(index=index_mapper, columns=columns_mapper, ...)``
# * ``(mapper, axis={'index', 'columns'}, ...)``
#
# We *highly* recommend using keyword arguments to clarify your
# intent.
#
# Rename columns using a mapping:
#
# >>> df = pd.DataFrame({"A": [1, 2, 3], "B": [4, 5, 6]})
# >>> df.rename(columns={"A": "a", "B": "c"})
#    a  c
# 0  1  4
# 1  2  5
# 2  3  6
#
# Rename index using a mapping:
#
# >>> df.rename(index={0: "x", 1: "y", 2: "z"})
#    A  B
# x  1  4
# y  2  5
# z  3  6
#
# Cast index labels to a different type:
#
# >>> df.index
# RangeIndex(start=0, stop=3, step=1)
# >>> df.rename(index=str).index
# Index(['0', '1', '2'], dtype='object')
#
# >>> df.rename(columns={"A": "a", "B": "b", "C": "c"}, errors="raise")
# Traceback (most recent call last):
# KeyError: ['C'] not found in axis
#
# Using axis-style parameters:
#
# >>> df.rename(str.lower, axis='columns')
#    a  b
# 0  1  4
# 1  2  5
# 2  3  6
#
# >>> df.rename({1: 2, 2: 4}, axis='index')
#    A  B
# 0  1  4
# 2  2  5
# 4  3  6
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.any</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Test whether any array element along a given axis evaluates to True.
#
# Returns single boolean unless `axis` is not ``None``
#
# Parameters
# ----------
# a : array_like
#     Input array or object that can be converted to an array.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which a logical OR reduction is performed.
#     The default (``axis=None``) is to perform a logical OR over all
#     the dimensions of the input array. `axis` may be negative, in
#     which case it counts from the last to the first axis.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a reduction is performed on multiple
#     axes, instead of a single axis or all the axes as before.
# out : ndarray, optional
#     Alternate output array in which to place the result.  It must have
#     the same shape as the expected output and its type is preserved
#     (e.g., if it is of type float, then it will remain so, returning
#     1.0 for True and 0.0 for False, regardless of the type of `a`).
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `any` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in checking for any `True` values.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# any : bool or ndarray
#     A new boolean or `ndarray` is returned unless `out` is specified,
#     in which case a reference to `out` is returned.
#
# See Also
# --------
# ndarray.any : equivalent method
#
# all : Test whether all elements along a given axis evaluate to True.
#
# Notes
# -----
# Not a Number (NaN), positive infinity and negative infinity evaluate
# to `True` because these are not equal to zero.
#
# Examples
# --------
# >>> np.any([[True, False], [True, True]])
# True
#
# >>> np.any([[True, False], [False, False]], axis=0)
# array([ True, False])
#
# >>> np.any([-1, 0, 5])
# True
#
# >>> np.any(np.nan)
# True
#
# >>> np.any([[True, False], [False, False]], where=[[False], [True]])
# False
#
# >>> o=np.array(False)
# >>> z=np.any([-1, 4, 5], out=o)
# >>> z, o
# (array(True), array(True))
# >>> # Check now that z is a reference to o
# >>> z is o
# True
# >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
# (191614240, 191614240)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float32</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Single-precision floating-point number type, compatible with C ``float``.
#
# :Character code: ``'f'``
# :Canonical name: `numpy.single`
# :Alias on this platform (Linux x86_64): `numpy.float32`: 32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.sort</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a sorted copy of an array.
#
# Parameters
# ----------
# a : array_like
#     Array to be sorted.
# axis : int or None, optional
#     Axis along which to sort. If None, the array is flattened before
#     sorting. The default is -1, which sorts along the last axis.
# kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional
#     Sorting algorithm. The default is 'quicksort'. Note that both 'stable'
#     and 'mergesort' use timsort or radix sort under the covers and, in general,
#     the actual implementation will vary with data type. The 'mergesort' option
#     is retained for backwards compatibility.
#
#     .. versionchanged:: 1.15.0.
#        The 'stable' option was added.
#
# order : str or list of str, optional
#     When `a` is an array with fields defined, this argument specifies
#     which fields to compare first, second, etc.  A single field can
#     be specified as a string, and not all fields need be specified,
#     but unspecified fields will still be used, in the order in which
#     they come up in the dtype, to break ties.
#
# Returns
# -------
# sorted_array : ndarray
#     Array of the same type and shape as `a`.
#
# See Also
# --------
# ndarray.sort : Method to sort an array in-place.
# argsort : Indirect sort.
# lexsort : Indirect stable sort on multiple keys.
# searchsorted : Find elements in a sorted array.
# partition : Partial sort.
#
# Notes
# -----
# The various sorting algorithms are characterized by their average speed,
# worst case performance, work space size, and whether they are stable. A
# stable sort keeps items with the same key in the same relative
# order. The four algorithms implemented in NumPy have the following
# properties:
#
# =========== ======= ============= ============ ========
#    kind      speed   worst case    work space   stable
# =========== ======= ============= ============ ========
# 'quicksort'    1     O(n^2)            0          no
# 'heapsort'     3     O(n*log(n))       0          no
# 'mergesort'    2     O(n*log(n))      ~n/2        yes
# 'timsort'      2     O(n*log(n))      ~n/2        yes
# =========== ======= ============= ============ ========
#
# .. note:: The datatype determines which of 'mergesort' or 'timsort'
#    is actually used, even if 'mergesort' is specified. User selection
#    at a finer scale is not currently available.
#
# All the sort algorithms make temporary copies of the data when
# sorting along any but the last axis.  Consequently, sorting along
# the last axis is faster and uses less space than sorting along
# any other axis.
#
# The sort order for complex numbers is lexicographic. If both the real
# and imaginary parts are non-nan then the order is determined by the
# real parts except when they are equal, in which case the order is
# determined by the imaginary parts.
#
# Previous to numpy 1.4.0 sorting real and complex arrays containing nan
# values led to undefined behaviour. In numpy versions >= 1.4.0 nan
# values are sorted to the end. The extended sort order is:
#
#   * Real: [R, nan]
#   * Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
#
# where R is a non-nan real value. Complex values with the same nan
# placements are sorted according to the non-nan part if it exists.
# Non-nan values are sorted as before.
#
# .. versionadded:: 1.12.0
#
# quicksort has been changed to `introsort <https://en.wikipedia.org/wiki/Introsort>`_.
# When sorting does not make enough progress it switches to
# `heapsort <https://en.wikipedia.org/wiki/Heapsort>`_.
# This implementation makes quicksort O(n*log(n)) in the worst case.
#
# 'stable' automatically chooses the best stable sorting algorithm
# for the data type being sorted.
# It, along with 'mergesort' is currently mapped to
# `timsort <https://en.wikipedia.org/wiki/Timsort>`_
# or `radix sort <https://en.wikipedia.org/wiki/Radix_sort>`_
# depending on the data type.
# API forward compatibility currently limits the
# ability to select the implementation and it is hardwired for the different
# data types.
#
# .. versionadded:: 1.17.0
#
# Timsort is added for better performance on already or nearly
# sorted data. On random data timsort is almost identical to
# mergesort. It is now used for stable sort while quicksort is still the
# default sort if none is chosen. For timsort details, refer to
# `CPython listsort.txt <https://github.com/python/cpython/blob/3.7/Objects/listsort.txt>`_.
# 'mergesort' and 'stable' are mapped to radix sort for integer data types. Radix sort is an
# O(n) sort instead of O(n log n).
#
# .. versionchanged:: 1.18.0
#
# NaT now sorts to the end of arrays for consistency with NaN.
#
# Examples
# --------
# >>> a = np.array([[1,4],[3,1]])
# >>> np.sort(a)                # sort along the last axis
# array([[1, 4],
#        [1, 3]])
# >>> np.sort(a, axis=None)     # sort the flattened array
# array([1, 1, 3, 4])
# >>> np.sort(a, axis=0)        # sort along the first axis
# array([[1, 1],
#        [3, 4]])
#
# Use the `order` keyword to specify a field to use when sorting a
# structured array:
#
# >>> dtype = [('name', 'S10'), ('height', float), ('age', int)]
# >>> values = [('Arthur', 1.8, 41), ('Lancelot', 1.9, 38),
# ...           ('Galahad', 1.7, 38)]
# >>> a = np.array(values, dtype=dtype)       # create a structured array
# >>> np.sort(a, order='height')                        # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Arthur', 1.8, 41),
#        ('Lancelot', 1.8999999999999999, 38)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# Sort by age, then height if ages are equal:
#
# >>> np.sort(a, order=['age', 'height'])               # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Lancelot', 1.8999999999999999, 38),
#        ('Arthur', 1.8, 41)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.unique</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return unique values of Series object.
#
# Uniques are returned in order of appearance. Hash table-based unique,
# therefore does NOT sort.
#
# Returns
# -------
# ndarray or ExtensionArray
#     The unique values returned as a NumPy array. See Notes.
#
# See Also
# --------
# unique : Top-level unique method for any 1-d array-like object.
# Index.unique : Return Index with unique values from an Index object.
#
# Notes
# -----
# Returns the unique values as a NumPy array. In case of an
# extension-array backed Series, a new
# :class:`~api.extensions.ExtensionArray` of that type with just
# the unique values is returned. This includes
#
#     * Categorical
#     * Period
#     * Datetime with Timezone
#     * Interval
#     * Sparse
#     * IntegerNA
#
# See Examples section.
#
# Examples
# --------
# >>> pd.Series([2, 1, 3, 3], name='A').unique()
# array([2, 1, 3])
#
# >>> pd.Series([pd.Timestamp('2016-01-01') for _ in range(3)]).unique()
# array(['2016-01-01T00:00:00.000000000'], dtype='datetime64[ns]')
#
# >>> pd.Series([pd.Timestamp('2016-01-01', tz='US/Eastern')
# ...            for _ in range(3)]).unique()
# <DatetimeArray>
# ['2016-01-01 00:00:00-05:00']
# Length: 1, dtype: datetime64[ns, US/Eastern]
#
# An Categorical will return categories in the order of
# appearance and with the same dtype.
#
# >>> pd.Series(pd.Categorical(list('baabc'))).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a', 'b', 'c']
# >>> pd.Series(pd.Categorical(list('baabc'), categories=list('abc'),
# ...                          ordered=True)).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a' < 'b' < 'c']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.rename</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Alter axes labels.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# mapper : dict-like or function
#     Dict-like or function transformations to apply to
#     that axis' values. Use either ``mapper`` and ``axis`` to
#     specify the axis to target with ``mapper``, or ``index`` and
#     ``columns``.
# index : dict-like or function
#     Alternative to specifying axis (``mapper, axis=0``
#     is equivalent to ``index=mapper``).
# columns : dict-like or function
#     Alternative to specifying axis (``mapper, axis=1``
#     is equivalent to ``columns=mapper``).
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Axis to target with ``mapper``. Can be either the axis name
#     ('index', 'columns') or number (0, 1). The default is 'index'.
# copy : bool, default True
#     Also copy underlying data.
# inplace : bool, default False
#     Whether to return a new DataFrame. If True then value of copy is
#     ignored.
# level : int or level name, default None
#     In case of a MultiIndex, only rename labels in the specified
#     level.
# errors : {'ignore', 'raise'}, default 'ignore'
#     If 'raise', raise a `KeyError` when a dict-like `mapper`, `index`,
#     or `columns` contains labels that are not present in the Index
#     being transformed.
#     If 'ignore', existing keys will be renamed and extra keys will be
#     ignored.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the renamed axis labels or None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis and
#     "errors='raise'".
#
# See Also
# --------
# DataFrame.rename_axis : Set the name of the axis.
#
# Examples
# --------
# ``DataFrame.rename`` supports two calling conventions
#
# * ``(index=index_mapper, columns=columns_mapper, ...)``
# * ``(mapper, axis={'index', 'columns'}, ...)``
#
# We *highly* recommend using keyword arguments to clarify your
# intent.
#
# Rename columns using a mapping:
#
# >>> df = pd.DataFrame({"A": [1, 2, 3], "B": [4, 5, 6]})
# >>> df.rename(columns={"A": "a", "B": "c"})
#    a  c
# 0  1  4
# 1  2  5
# 2  3  6
#
# Rename index using a mapping:
#
# >>> df.rename(index={0: "x", 1: "y", 2: "z"})
#    A  B
# x  1  4
# y  2  5
# z  3  6
#
# Cast index labels to a different type:
#
# >>> df.index
# RangeIndex(start=0, stop=3, step=1)
# >>> df.rename(index=str).index
# Index(['0', '1', '2'], dtype='object')
#
# >>> df.rename(columns={"A": "a", "B": "b", "C": "c"}, errors="raise")
# Traceback (most recent call last):
# KeyError: ['C'] not found in axis
#
# Using axis-style parameters:
#
# >>> df.rename(str.lower, axis='columns')
#    a  b
# 0  1  4
# 1  2  5
# 2  3  6
#
# >>> df.rename({1: 2, 2: 4}, axis='index')
#    A  B
# 0  1  4
# 2  2  5
# 4  3  6
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.any</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Test whether any array element along a given axis evaluates to True.
#
# Returns single boolean unless `axis` is not ``None``
#
# Parameters
# ----------
# a : array_like
#     Input array or object that can be converted to an array.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which a logical OR reduction is performed.
#     The default (``axis=None``) is to perform a logical OR over all
#     the dimensions of the input array. `axis` may be negative, in
#     which case it counts from the last to the first axis.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a reduction is performed on multiple
#     axes, instead of a single axis or all the axes as before.
# out : ndarray, optional
#     Alternate output array in which to place the result.  It must have
#     the same shape as the expected output and its type is preserved
#     (e.g., if it is of type float, then it will remain so, returning
#     1.0 for True and 0.0 for False, regardless of the type of `a`).
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `any` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in checking for any `True` values.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# any : bool or ndarray
#     A new boolean or `ndarray` is returned unless `out` is specified,
#     in which case a reference to `out` is returned.
#
# See Also
# --------
# ndarray.any : equivalent method
#
# all : Test whether all elements along a given axis evaluate to True.
#
# Notes
# -----
# Not a Number (NaN), positive infinity and negative infinity evaluate
# to `True` because these are not equal to zero.
#
# Examples
# --------
# >>> np.any([[True, False], [True, True]])
# True
#
# >>> np.any([[True, False], [False, False]], axis=0)
# array([ True, False])
#
# >>> np.any([-1, 0, 5])
# True
#
# >>> np.any(np.nan)
# True
#
# >>> np.any([[True, False], [False, False]], where=[[False], [True]])
# False
#
# >>> o=np.array(False)
# >>> z=np.any([-1, 4, 5], out=o)
# >>> z, o
# (array(True), array(True))
# >>> # Check now that z is a reference to o
# >>> z is o
# True
# >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
# (191614240, 191614240)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float32</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Single-precision floating-point number type, compatible with C ``float``.
#
# :Character code: ``'f'``
# :Canonical name: `numpy.single`
# :Alias on this platform (Linux x86_64): `numpy.float32`: 32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.sort</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a sorted copy of an array.
#
# Parameters
# ----------
# a : array_like
#     Array to be sorted.
# axis : int or None, optional
#     Axis along which to sort. If None, the array is flattened before
#     sorting. The default is -1, which sorts along the last axis.
# kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional
#     Sorting algorithm. The default is 'quicksort'. Note that both 'stable'
#     and 'mergesort' use timsort or radix sort under the covers and, in general,
#     the actual implementation will vary with data type. The 'mergesort' option
#     is retained for backwards compatibility.
#
#     .. versionchanged:: 1.15.0.
#        The 'stable' option was added.
#
# order : str or list of str, optional
#     When `a` is an array with fields defined, this argument specifies
#     which fields to compare first, second, etc.  A single field can
#     be specified as a string, and not all fields need be specified,
#     but unspecified fields will still be used, in the order in which
#     they come up in the dtype, to break ties.
#
# Returns
# -------
# sorted_array : ndarray
#     Array of the same type and shape as `a`.
#
# See Also
# --------
# ndarray.sort : Method to sort an array in-place.
# argsort : Indirect sort.
# lexsort : Indirect stable sort on multiple keys.
# searchsorted : Find elements in a sorted array.
# partition : Partial sort.
#
# Notes
# -----
# The various sorting algorithms are characterized by their average speed,
# worst case performance, work space size, and whether they are stable. A
# stable sort keeps items with the same key in the same relative
# order. The four algorithms implemented in NumPy have the following
# properties:
#
# =========== ======= ============= ============ ========
#    kind      speed   worst case    work space   stable
# =========== ======= ============= ============ ========
# 'quicksort'    1     O(n^2)            0          no
# 'heapsort'     3     O(n*log(n))       0          no
# 'mergesort'    2     O(n*log(n))      ~n/2        yes
# 'timsort'      2     O(n*log(n))      ~n/2        yes
# =========== ======= ============= ============ ========
#
# .. note:: The datatype determines which of 'mergesort' or 'timsort'
#    is actually used, even if 'mergesort' is specified. User selection
#    at a finer scale is not currently available.
#
# All the sort algorithms make temporary copies of the data when
# sorting along any but the last axis.  Consequently, sorting along
# the last axis is faster and uses less space than sorting along
# any other axis.
#
# The sort order for complex numbers is lexicographic. If both the real
# and imaginary parts are non-nan then the order is determined by the
# real parts except when they are equal, in which case the order is
# determined by the imaginary parts.
#
# Previous to numpy 1.4.0 sorting real and complex arrays containing nan
# values led to undefined behaviour. In numpy versions >= 1.4.0 nan
# values are sorted to the end. The extended sort order is:
#
#   * Real: [R, nan]
#   * Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
#
# where R is a non-nan real value. Complex values with the same nan
# placements are sorted according to the non-nan part if it exists.
# Non-nan values are sorted as before.
#
# .. versionadded:: 1.12.0
#
# quicksort has been changed to `introsort <https://en.wikipedia.org/wiki/Introsort>`_.
# When sorting does not make enough progress it switches to
# `heapsort <https://en.wikipedia.org/wiki/Heapsort>`_.
# This implementation makes quicksort O(n*log(n)) in the worst case.
#
# 'stable' automatically chooses the best stable sorting algorithm
# for the data type being sorted.
# It, along with 'mergesort' is currently mapped to
# `timsort <https://en.wikipedia.org/wiki/Timsort>`_
# or `radix sort <https://en.wikipedia.org/wiki/Radix_sort>`_
# depending on the data type.
# API forward compatibility currently limits the
# ability to select the implementation and it is hardwired for the different
# data types.
#
# .. versionadded:: 1.17.0
#
# Timsort is added for better performance on already or nearly
# sorted data. On random data timsort is almost identical to
# mergesort. It is now used for stable sort while quicksort is still the
# default sort if none is chosen. For timsort details, refer to
# `CPython listsort.txt <https://github.com/python/cpython/blob/3.7/Objects/listsort.txt>`_.
# 'mergesort' and 'stable' are mapped to radix sort for integer data types. Radix sort is an
# O(n) sort instead of O(n log n).
#
# .. versionchanged:: 1.18.0
#
# NaT now sorts to the end of arrays for consistency with NaN.
#
# Examples
# --------
# >>> a = np.array([[1,4],[3,1]])
# >>> np.sort(a)                # sort along the last axis
# array([[1, 4],
#        [1, 3]])
# >>> np.sort(a, axis=None)     # sort the flattened array
# array([1, 1, 3, 4])
# >>> np.sort(a, axis=0)        # sort along the first axis
# array([[1, 1],
#        [3, 4]])
#
# Use the `order` keyword to specify a field to use when sorting a
# structured array:
#
# >>> dtype = [('name', 'S10'), ('height', float), ('age', int)]
# >>> values = [('Arthur', 1.8, 41), ('Lancelot', 1.9, 38),
# ...           ('Galahad', 1.7, 38)]
# >>> a = np.array(values, dtype=dtype)       # create a structured array
# >>> np.sort(a, order='height')                        # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Arthur', 1.8, 41),
#        ('Lancelot', 1.8999999999999999, 38)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# Sort by age, then height if ages are equal:
#
# >>> np.sort(a, order=['age', 'height'])               # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Lancelot', 1.8999999999999999, 38),
#        ('Arthur', 1.8, 41)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.rename</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Alter axes labels.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# mapper : dict-like or function
#     Dict-like or function transformations to apply to
#     that axis' values. Use either ``mapper`` and ``axis`` to
#     specify the axis to target with ``mapper``, or ``index`` and
#     ``columns``.
# index : dict-like or function
#     Alternative to specifying axis (``mapper, axis=0``
#     is equivalent to ``index=mapper``).
# columns : dict-like or function
#     Alternative to specifying axis (``mapper, axis=1``
#     is equivalent to ``columns=mapper``).
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Axis to target with ``mapper``. Can be either the axis name
#     ('index', 'columns') or number (0, 1). The default is 'index'.
# copy : bool, default True
#     Also copy underlying data.
# inplace : bool, default False
#     Whether to return a new DataFrame. If True then value of copy is
#     ignored.
# level : int or level name, default None
#     In case of a MultiIndex, only rename labels in the specified
#     level.
# errors : {'ignore', 'raise'}, default 'ignore'
#     If 'raise', raise a `KeyError` when a dict-like `mapper`, `index`,
#     or `columns` contains labels that are not present in the Index
#     being transformed.
#     If 'ignore', existing keys will be renamed and extra keys will be
#     ignored.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the renamed axis labels or None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis and
#     "errors='raise'".
#
# See Also
# --------
# DataFrame.rename_axis : Set the name of the axis.
#
# Examples
# --------
# ``DataFrame.rename`` supports two calling conventions
#
# * ``(index=index_mapper, columns=columns_mapper, ...)``
# * ``(mapper, axis={'index', 'columns'}, ...)``
#
# We *highly* recommend using keyword arguments to clarify your
# intent.
#
# Rename columns using a mapping:
#
# >>> df = pd.DataFrame({"A": [1, 2, 3], "B": [4, 5, 6]})
# >>> df.rename(columns={"A": "a", "B": "c"})
#    a  c
# 0  1  4
# 1  2  5
# 2  3  6
#
# Rename index using a mapping:
#
# >>> df.rename(index={0: "x", 1: "y", 2: "z"})
#    A  B
# x  1  4
# y  2  5
# z  3  6
#
# Cast index labels to a different type:
#
# >>> df.index
# RangeIndex(start=0, stop=3, step=1)
# >>> df.rename(index=str).index
# Index(['0', '1', '2'], dtype='object')
#
# >>> df.rename(columns={"A": "a", "B": "b", "C": "c"}, errors="raise")
# Traceback (most recent call last):
# KeyError: ['C'] not found in axis
#
# Using axis-style parameters:
#
# >>> df.rename(str.lower, axis='columns')
#    a  b
# 0  1  4
# 1  2  5
# 2  3  6
#
# >>> df.rename({1: 2, 2: 4}, axis='index')
#    A  B
# 0  1  4
# 2  2  5
# 4  3  6
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.unique</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return unique values of Series object.
#
# Uniques are returned in order of appearance. Hash table-based unique,
# therefore does NOT sort.
#
# Returns
# -------
# ndarray or ExtensionArray
#     The unique values returned as a NumPy array. See Notes.
#
# See Also
# --------
# unique : Top-level unique method for any 1-d array-like object.
# Index.unique : Return Index with unique values from an Index object.
#
# Notes
# -----
# Returns the unique values as a NumPy array. In case of an
# extension-array backed Series, a new
# :class:`~api.extensions.ExtensionArray` of that type with just
# the unique values is returned. This includes
#
#     * Categorical
#     * Period
#     * Datetime with Timezone
#     * Interval
#     * Sparse
#     * IntegerNA
#
# See Examples section.
#
# Examples
# --------
# >>> pd.Series([2, 1, 3, 3], name='A').unique()
# array([2, 1, 3])
#
# >>> pd.Series([pd.Timestamp('2016-01-01') for _ in range(3)]).unique()
# array(['2016-01-01T00:00:00.000000000'], dtype='datetime64[ns]')
#
# >>> pd.Series([pd.Timestamp('2016-01-01', tz='US/Eastern')
# ...            for _ in range(3)]).unique()
# <DatetimeArray>
# ['2016-01-01 00:00:00-05:00']
# Length: 1, dtype: datetime64[ns, US/Eastern]
#
# An Categorical will return categories in the order of
# appearance and with the same dtype.
#
# >>> pd.Series(pd.Categorical(list('baabc'))).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a', 'b', 'c']
# >>> pd.Series(pd.Categorical(list('baabc'), categories=list('abc'),
# ...                          ordered=True)).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a' < 'b' < 'c']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.sort</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a sorted copy of an array.
#
# Parameters
# ----------
# a : array_like
#     Array to be sorted.
# axis : int or None, optional
#     Axis along which to sort. If None, the array is flattened before
#     sorting. The default is -1, which sorts along the last axis.
# kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional
#     Sorting algorithm. The default is 'quicksort'. Note that both 'stable'
#     and 'mergesort' use timsort or radix sort under the covers and, in general,
#     the actual implementation will vary with data type. The 'mergesort' option
#     is retained for backwards compatibility.
#
#     .. versionchanged:: 1.15.0.
#        The 'stable' option was added.
#
# order : str or list of str, optional
#     When `a` is an array with fields defined, this argument specifies
#     which fields to compare first, second, etc.  A single field can
#     be specified as a string, and not all fields need be specified,
#     but unspecified fields will still be used, in the order in which
#     they come up in the dtype, to break ties.
#
# Returns
# -------
# sorted_array : ndarray
#     Array of the same type and shape as `a`.
#
# See Also
# --------
# ndarray.sort : Method to sort an array in-place.
# argsort : Indirect sort.
# lexsort : Indirect stable sort on multiple keys.
# searchsorted : Find elements in a sorted array.
# partition : Partial sort.
#
# Notes
# -----
# The various sorting algorithms are characterized by their average speed,
# worst case performance, work space size, and whether they are stable. A
# stable sort keeps items with the same key in the same relative
# order. The four algorithms implemented in NumPy have the following
# properties:
#
# =========== ======= ============= ============ ========
#    kind      speed   worst case    work space   stable
# =========== ======= ============= ============ ========
# 'quicksort'    1     O(n^2)            0          no
# 'heapsort'     3     O(n*log(n))       0          no
# 'mergesort'    2     O(n*log(n))      ~n/2        yes
# 'timsort'      2     O(n*log(n))      ~n/2        yes
# =========== ======= ============= ============ ========
#
# .. note:: The datatype determines which of 'mergesort' or 'timsort'
#    is actually used, even if 'mergesort' is specified. User selection
#    at a finer scale is not currently available.
#
# All the sort algorithms make temporary copies of the data when
# sorting along any but the last axis.  Consequently, sorting along
# the last axis is faster and uses less space than sorting along
# any other axis.
#
# The sort order for complex numbers is lexicographic. If both the real
# and imaginary parts are non-nan then the order is determined by the
# real parts except when they are equal, in which case the order is
# determined by the imaginary parts.
#
# Previous to numpy 1.4.0 sorting real and complex arrays containing nan
# values led to undefined behaviour. In numpy versions >= 1.4.0 nan
# values are sorted to the end. The extended sort order is:
#
#   * Real: [R, nan]
#   * Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
#
# where R is a non-nan real value. Complex values with the same nan
# placements are sorted according to the non-nan part if it exists.
# Non-nan values are sorted as before.
#
# .. versionadded:: 1.12.0
#
# quicksort has been changed to `introsort <https://en.wikipedia.org/wiki/Introsort>`_.
# When sorting does not make enough progress it switches to
# `heapsort <https://en.wikipedia.org/wiki/Heapsort>`_.
# This implementation makes quicksort O(n*log(n)) in the worst case.
#
# 'stable' automatically chooses the best stable sorting algorithm
# for the data type being sorted.
# It, along with 'mergesort' is currently mapped to
# `timsort <https://en.wikipedia.org/wiki/Timsort>`_
# or `radix sort <https://en.wikipedia.org/wiki/Radix_sort>`_
# depending on the data type.
# API forward compatibility currently limits the
# ability to select the implementation and it is hardwired for the different
# data types.
#
# .. versionadded:: 1.17.0
#
# Timsort is added for better performance on already or nearly
# sorted data. On random data timsort is almost identical to
# mergesort. It is now used for stable sort while quicksort is still the
# default sort if none is chosen. For timsort details, refer to
# `CPython listsort.txt <https://github.com/python/cpython/blob/3.7/Objects/listsort.txt>`_.
# 'mergesort' and 'stable' are mapped to radix sort for integer data types. Radix sort is an
# O(n) sort instead of O(n log n).
#
# .. versionchanged:: 1.18.0
#
# NaT now sorts to the end of arrays for consistency with NaN.
#
# Examples
# --------
# >>> a = np.array([[1,4],[3,1]])
# >>> np.sort(a)                # sort along the last axis
# array([[1, 4],
#        [1, 3]])
# >>> np.sort(a, axis=None)     # sort the flattened array
# array([1, 1, 3, 4])
# >>> np.sort(a, axis=0)        # sort along the first axis
# array([[1, 1],
#        [3, 4]])
#
# Use the `order` keyword to specify a field to use when sorting a
# structured array:
#
# >>> dtype = [('name', 'S10'), ('height', float), ('age', int)]
# >>> values = [('Arthur', 1.8, 41), ('Lancelot', 1.9, 38),
# ...           ('Galahad', 1.7, 38)]
# >>> a = np.array(values, dtype=dtype)       # create a structured array
# >>> np.sort(a, order='height')                        # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Arthur', 1.8, 41),
#        ('Lancelot', 1.8999999999999999, 38)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# Sort by age, then height if ages are equal:
#
# >>> np.sort(a, order=['age', 'height'])               # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Lancelot', 1.8999999999999999, 38),
#        ('Arthur', 1.8, 41)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.any</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Test whether any array element along a given axis evaluates to True.
#
# Returns single boolean unless `axis` is not ``None``
#
# Parameters
# ----------
# a : array_like
#     Input array or object that can be converted to an array.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which a logical OR reduction is performed.
#     The default (``axis=None``) is to perform a logical OR over all
#     the dimensions of the input array. `axis` may be negative, in
#     which case it counts from the last to the first axis.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a reduction is performed on multiple
#     axes, instead of a single axis or all the axes as before.
# out : ndarray, optional
#     Alternate output array in which to place the result.  It must have
#     the same shape as the expected output and its type is preserved
#     (e.g., if it is of type float, then it will remain so, returning
#     1.0 for True and 0.0 for False, regardless of the type of `a`).
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `any` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in checking for any `True` values.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# any : bool or ndarray
#     A new boolean or `ndarray` is returned unless `out` is specified,
#     in which case a reference to `out` is returned.
#
# See Also
# --------
# ndarray.any : equivalent method
#
# all : Test whether all elements along a given axis evaluate to True.
#
# Notes
# -----
# Not a Number (NaN), positive infinity and negative infinity evaluate
# to `True` because these are not equal to zero.
#
# Examples
# --------
# >>> np.any([[True, False], [True, True]])
# True
#
# >>> np.any([[True, False], [False, False]], axis=0)
# array([ True, False])
#
# >>> np.any([-1, 0, 5])
# True
#
# >>> np.any(np.nan)
# True
#
# >>> np.any([[True, False], [False, False]], where=[[False], [True]])
# False
#
# >>> o=np.array(False)
# >>> z=np.any([-1, 4, 5], out=o)
# >>> z, o
# (array(True), array(True))
# >>> # Check now that z is a reference to o
# >>> z is o
# True
# >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
# (191614240, 191614240)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float32</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Single-precision floating-point number type, compatible with C ``float``.
#
# :Character code: ``'f'``
# :Canonical name: `numpy.single`
# :Alias on this platform (Linux x86_64): `numpy.float32`: 32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.dropna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Remove missing values.
#
# See the :ref:`User Guide <missing_data>` for more on which values are
# considered missing, and how to work with missing data.
#
# Parameters
# ----------
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Determine if rows or columns which contain missing values are
#     removed.
#
#     * 0, or 'index' : Drop rows which contain missing values.
#     * 1, or 'columns' : Drop columns which contain missing value.
#
#     .. versionchanged:: 1.0.0
#
#        Pass tuple or list to drop on multiple axes.
#        Only a single axis is allowed.
#
# how : {'any', 'all'}, default 'any'
#     Determine if row or column is removed from DataFrame, when we have
#     at least one NA or all NA.
#
#     * 'any' : If any NA values are present, drop that row or column.
#     * 'all' : If all values are NA, drop that row or column.
#
# thresh : int, optional
#     Require that many non-NA values.
# subset : column label or sequence of labels, optional
#     Labels along other axis to consider, e.g. if you are dropping rows
#     these would be a list of columns to include.
# inplace : bool, default False
#     If True, do operation inplace and return None.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with NA entries dropped from it or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.isna: Indicate missing values.
# DataFrame.notna : Indicate existing (non-missing) values.
# DataFrame.fillna : Replace missing values.
# Series.dropna : Drop missing values.
# Index.dropna : Drop missing indices.
#
# Examples
# --------
# >>> df = pd.DataFrame({"name": ['Alfred', 'Batman', 'Catwoman'],
# ...                    "toy": [np.nan, 'Batmobile', 'Bullwhip'],
# ...                    "born": [pd.NaT, pd.Timestamp("1940-04-25"),
# ...                             pd.NaT]})
# >>> df
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Drop the rows where at least one element is missing.
#
# >>> df.dropna()
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# Drop the columns where at least one element is missing.
#
# >>> df.dropna(axis='columns')
#        name
# 0    Alfred
# 1    Batman
# 2  Catwoman
#
# Drop the rows where all elements are missing.
#
# >>> df.dropna(how='all')
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep only the rows with at least 2 non-NA values.
#
# >>> df.dropna(thresh=2)
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Define in which columns to look for missing values.
#
# >>> df.dropna(subset=['name', 'toy'])
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep the DataFrame with valid entries in the same variable.
#
# >>> df.dropna(inplace=True)
# >>> df
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.dropna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Remove missing values.
#
# See the :ref:`User Guide <missing_data>` for more on which values are
# considered missing, and how to work with missing data.
#
# Parameters
# ----------
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Determine if rows or columns which contain missing values are
#     removed.
#
#     * 0, or 'index' : Drop rows which contain missing values.
#     * 1, or 'columns' : Drop columns which contain missing value.
#
#     .. versionchanged:: 1.0.0
#
#        Pass tuple or list to drop on multiple axes.
#        Only a single axis is allowed.
#
# how : {'any', 'all'}, default 'any'
#     Determine if row or column is removed from DataFrame, when we have
#     at least one NA or all NA.
#
#     * 'any' : If any NA values are present, drop that row or column.
#     * 'all' : If all values are NA, drop that row or column.
#
# thresh : int, optional
#     Require that many non-NA values.
# subset : column label or sequence of labels, optional
#     Labels along other axis to consider, e.g. if you are dropping rows
#     these would be a list of columns to include.
# inplace : bool, default False
#     If True, do operation inplace and return None.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with NA entries dropped from it or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.isna: Indicate missing values.
# DataFrame.notna : Indicate existing (non-missing) values.
# DataFrame.fillna : Replace missing values.
# Series.dropna : Drop missing values.
# Index.dropna : Drop missing indices.
#
# Examples
# --------
# >>> df = pd.DataFrame({"name": ['Alfred', 'Batman', 'Catwoman'],
# ...                    "toy": [np.nan, 'Batmobile', 'Bullwhip'],
# ...                    "born": [pd.NaT, pd.Timestamp("1940-04-25"),
# ...                             pd.NaT]})
# >>> df
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Drop the rows where at least one element is missing.
#
# >>> df.dropna()
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# Drop the columns where at least one element is missing.
#
# >>> df.dropna(axis='columns')
#        name
# 0    Alfred
# 1    Batman
# 2  Catwoman
#
# Drop the rows where all elements are missing.
#
# >>> df.dropna(how='all')
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep only the rows with at least 2 non-NA values.
#
# >>> df.dropna(thresh=2)
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Define in which columns to look for missing values.
#
# >>> df.dropna(subset=['name', 'toy'])
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep the DataFrame with valid entries in the same variable.
#
# >>> df.dropna(inplace=True)
# >>> df
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Data Sub-sampling and Train-test Splitting</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Engineering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h4><s>Feature Transformation</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Feature Selection</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [512] | <b>Kwargs:</b> {'activation': 'linear'}</li></ul>
# <ul><li><b>Args:</b> [2048] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <ul><li><b>Args:</b> [512] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {'activation': 'linear'}</li></ul>
# <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {'activation': 'linear'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.gradient_descent.SGD</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'lr': 0.0001}</li></ul>
# <blockquote>
# <code>
# Gradient descent (with momentum) optimizer.
#
# Update rule for parameter `w` with gradient `g` when `momentum` is 0:
#
# ```python
# w = w - learning_rate * g
# ```
#
# Update rule when `momentum` is larger than 0:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + velocity
# ```
#
# When `nesterov=True`, this rule becomes:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + momentum * velocity - learning_rate * g
# ```
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.01.
#   momentum: float hyperparameter >= 0 that accelerates gradient descent
#     in the relevant
#     direction and dampens oscillations. Defaults to 0, i.e., vanilla gradient
#     descent.
#   nesterov: boolean. Whether to apply Nesterov momentum.
#     Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients.  Defaults to `"SGD"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1)
# >>> var = tf.Variable(1.0)
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> # Step is `- learning_rate * grad`
# >>> var.numpy()
# 0.9
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1, momentum=0.9)
# >>> var = tf.Variable(1.0)
# >>> val0 = var.value()
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> # First step is `- learning_rate * grad`
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val1 = var.value()
# >>> (val0 - val1).numpy()
# 0.1
# >>> # On later steps, step-size increases because of momentum
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val2 = var.value()
# >>> (val1 - val2).numpy()
# 0.18
#
# Reference:
#     - For `nesterov=True`, See [Sutskever et al., 2013](
#       http://jmlr.org/proceedings/papers/v28/sutskever13.pdf).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'loss': 'mse'}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'batch_size': 32, 'epochs': 100}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [512] | <b>Kwargs:</b> {'activation': 'linear'}</li></ul>
# <ul><li><b>Args:</b> [2048] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <ul><li><b>Args:</b> [512] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <ul><li><b>Args:</b> [16] | <b>Kwargs:</b> {'activation': 'linear'}</li></ul>
# <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {'activation': 'linear'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.gradient_descent.SGD</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'lr': 0.0001}</li></ul>
# <blockquote>
# <code>
# Gradient descent (with momentum) optimizer.
#
# Update rule for parameter `w` with gradient `g` when `momentum` is 0:
#
# ```python
# w = w - learning_rate * g
# ```
#
# Update rule when `momentum` is larger than 0:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + velocity
# ```
#
# When `nesterov=True`, this rule becomes:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + momentum * velocity - learning_rate * g
# ```
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.01.
#   momentum: float hyperparameter >= 0 that accelerates gradient descent
#     in the relevant
#     direction and dampens oscillations. Defaults to 0, i.e., vanilla gradient
#     descent.
#   nesterov: boolean. Whether to apply Nesterov momentum.
#     Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients.  Defaults to `"SGD"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1)
# >>> var = tf.Variable(1.0)
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> # Step is `- learning_rate * grad`
# >>> var.numpy()
# 0.9
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1, momentum=0.9)
# >>> var = tf.Variable(1.0)
# >>> val0 = var.value()
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> # First step is `- learning_rate * grad`
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val1 = var.value()
# >>> (val0 - val1).numpy()
# 0.1
# >>> # On later steps, step-size increases because of momentum
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val2 = var.value()
# >>> (val1 - val2).numpy()
# 0.18
#
# Reference:
#     - For `nesterov=True`, See [Sutskever et al., 2013](
#       http://jmlr.org/proceedings/papers/v28/sutskever13.pdf).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'loss': 'mse'}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'batch_size': 32, 'epochs': 100}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 5</u></h3></summary><small><a href=#5>goto cell # 5</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras</u></summary>
# <blockquote>
# <code>
# Implementation of the Keras API, the high-level API of TensorFlow.
#
# Detailed documentation and user guides are available at
# [keras.io](https://keras.io).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u></summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u></summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.gradient_descent.SGD</u></summary>
# <blockquote>
# <code>
# Gradient descent (with momentum) optimizer.
#
# Update rule for parameter `w` with gradient `g` when `momentum` is 0:
#
# ```python
# w = w - learning_rate * g
# ```
#
# Update rule when `momentum` is larger than 0:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + velocity
# ```
#
# When `nesterov=True`, this rule becomes:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + momentum * velocity - learning_rate * g
# ```
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.01.
#   momentum: float hyperparameter >= 0 that accelerates gradient descent
#     in the relevant
#     direction and dampens oscillations. Defaults to 0, i.e., vanilla gradient
#     descent.
#   nesterov: boolean. Whether to apply Nesterov momentum.
#     Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients.  Defaults to `"SGD"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1)
# >>> var = tf.Variable(1.0)
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> # Step is `- learning_rate * grad`
# >>> var.numpy()
# 0.9
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1, momentum=0.9)
# >>> var = tf.Variable(1.0)
# >>> val0 = var.value()
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> # First step is `- learning_rate * grad`
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val1 = var.value()
# >>> (val0 - val1).numpy()
# 0.1
# >>> # On later steps, step-size increases because of momentum
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val2 = var.value()
# >>> (val1 - val2).numpy()
# 0.18
#
# Reference:
#     - For `nesterov=True`, See [Sutskever et al., 2013](
#       http://jmlr.org/proceedings/papers/v28/sutskever13.pdf).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizers</u></summary>
# <blockquote>
# <code>
# Built-in optimizer classes.
#
# For more examples see the base class `tf.keras.optimizers.Optimizer`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.any</u></summary>
# <blockquote>
# <code>
# Test whether any array element along a given axis evaluates to True.
#
# Returns single boolean unless `axis` is not ``None``
#
# Parameters
# ----------
# a : array_like
#     Input array or object that can be converted to an array.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which a logical OR reduction is performed.
#     The default (``axis=None``) is to perform a logical OR over all
#     the dimensions of the input array. `axis` may be negative, in
#     which case it counts from the last to the first axis.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a reduction is performed on multiple
#     axes, instead of a single axis or all the axes as before.
# out : ndarray, optional
#     Alternate output array in which to place the result.  It must have
#     the same shape as the expected output and its type is preserved
#     (e.g., if it is of type float, then it will remain so, returning
#     1.0 for True and 0.0 for False, regardless of the type of `a`).
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `any` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in checking for any `True` values.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# any : bool or ndarray
#     A new boolean or `ndarray` is returned unless `out` is specified,
#     in which case a reference to `out` is returned.
#
# See Also
# --------
# ndarray.any : equivalent method
#
# all : Test whether all elements along a given axis evaluate to True.
#
# Notes
# -----
# Not a Number (NaN), positive infinity and negative infinity evaluate
# to `True` because these are not equal to zero.
#
# Examples
# --------
# >>> np.any([[True, False], [True, True]])
# True
#
# >>> np.any([[True, False], [False, False]], axis=0)
# array([ True, False])
#
# >>> np.any([-1, 0, 5])
# True
#
# >>> np.any(np.nan)
# True
#
# >>> np.any([[True, False], [False, False]], where=[[False], [True]])
# False
#
# >>> o=np.array(False)
# >>> z=np.any([-1, 4, 5], out=o)
# >>> z, o
# (array(True), array(True))
# >>> # Check now that z is a reference to o
# >>> z is o
# True
# >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
# (191614240, 191614240)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.around</u></summary>
# <blockquote>
# <code>
# Evenly round to the given number of decimals.
#
# Parameters
# ----------
# a : array_like
#     Input data.
# decimals : int, optional
#     Number of decimal places to round to (default: 0).  If
#     decimals is negative, it specifies the number of positions to
#     the left of the decimal point.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output, but the type of the output
#     values will be cast if necessary. See :ref:`ufuncs-output-type` for more
#     details.
#
# Returns
# -------
# rounded_array : ndarray
#     An array of the same type as `a`, containing the rounded values.
#     Unless `out` was specified, a new array is created.  A reference to
#     the result is returned.
#
#     The real and imaginary parts of complex numbers are rounded
#     separately.  The result of rounding a float is a float.
#
# See Also
# --------
# ndarray.round : equivalent method
#
# ceil, fix, floor, rint, trunc
#
#
# Notes
# -----
# For values exactly halfway between rounded decimal values, NumPy
# rounds to the nearest even value. Thus 1.5 and 2.5 round to 2.0,
# -0.5 and 0.5 round to 0.0, etc.
#
# ``np.around`` uses a fast but sometimes inexact algorithm to round
# floating-point datatypes. For positive `decimals` it is equivalent to
# ``np.true_divide(np.rint(a * 10**decimals), 10**decimals)``, which has
# error due to the inexact representation of decimal fractions in the IEEE
# floating point standard [1]_ and errors introduced when scaling by powers
# of ten. For instance, note the extra "1" in the following:
#
#     >>> np.round(56294995342131.5, 3)
#     56294995342131.51
#
# If your goal is to print such values with a fixed number of decimals, it is
# preferable to use numpy's float printing routines to limit the number of
# printed decimals:
#
#     >>> np.format_float_positional(56294995342131.5, precision=3)
#     '56294995342131.5'
#
# The float printing routines use an accurate but much more computationally
# demanding algorithm to compute the number of digits after the decimal
# point.
#
# Alternatively, Python's builtin `round` function uses a more accurate
# but slower algorithm for 64-bit floating point values:
#
#     >>> round(56294995342131.5, 3)
#     56294995342131.5
#     >>> np.round(16.055, 2), round(16.055, 2)  # equals 16.0549999999999997
#     (16.06, 16.05)
#
#
# References
# ----------
# .. [1] "Lecture Notes on the Status of IEEE 754", William Kahan,
#        https://people.eecs.berkeley.edu/~wkahan/ieee754status/IEEE754.PDF
#
# Examples
# --------
# >>> np.around([0.37, 1.64])
# array([0., 2.])
# >>> np.around([0.37, 1.64], decimals=1)
# array([0.4, 1.6])
# >>> np.around([.5, 1.5, 2.5, 3.5, 4.5]) # rounds to nearest even value
# array([0., 2., 2., 4., 4.])
# >>> np.around([1,2,3,11], decimals=1) # ndarray of ints is returned
# array([ 1,  2,  3, 11])
# >>> np.around([1,2,3,11], decimals=-1)
# array([ 0,  0,  0, 10])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.sort</u></summary>
# <blockquote>
# <code>
# Return a sorted copy of an array.
#
# Parameters
# ----------
# a : array_like
#     Array to be sorted.
# axis : int or None, optional
#     Axis along which to sort. If None, the array is flattened before
#     sorting. The default is -1, which sorts along the last axis.
# kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional
#     Sorting algorithm. The default is 'quicksort'. Note that both 'stable'
#     and 'mergesort' use timsort or radix sort under the covers and, in general,
#     the actual implementation will vary with data type. The 'mergesort' option
#     is retained for backwards compatibility.
#
#     .. versionchanged:: 1.15.0.
#        The 'stable' option was added.
#
# order : str or list of str, optional
#     When `a` is an array with fields defined, this argument specifies
#     which fields to compare first, second, etc.  A single field can
#     be specified as a string, and not all fields need be specified,
#     but unspecified fields will still be used, in the order in which
#     they come up in the dtype, to break ties.
#
# Returns
# -------
# sorted_array : ndarray
#     Array of the same type and shape as `a`.
#
# See Also
# --------
# ndarray.sort : Method to sort an array in-place.
# argsort : Indirect sort.
# lexsort : Indirect stable sort on multiple keys.
# searchsorted : Find elements in a sorted array.
# partition : Partial sort.
#
# Notes
# -----
# The various sorting algorithms are characterized by their average speed,
# worst case performance, work space size, and whether they are stable. A
# stable sort keeps items with the same key in the same relative
# order. The four algorithms implemented in NumPy have the following
# properties:
#
# =========== ======= ============= ============ ========
#    kind      speed   worst case    work space   stable
# =========== ======= ============= ============ ========
# 'quicksort'    1     O(n^2)            0          no
# 'heapsort'     3     O(n*log(n))       0          no
# 'mergesort'    2     O(n*log(n))      ~n/2        yes
# 'timsort'      2     O(n*log(n))      ~n/2        yes
# =========== ======= ============= ============ ========
#
# .. note:: The datatype determines which of 'mergesort' or 'timsort'
#    is actually used, even if 'mergesort' is specified. User selection
#    at a finer scale is not currently available.
#
# All the sort algorithms make temporary copies of the data when
# sorting along any but the last axis.  Consequently, sorting along
# the last axis is faster and uses less space than sorting along
# any other axis.
#
# The sort order for complex numbers is lexicographic. If both the real
# and imaginary parts are non-nan then the order is determined by the
# real parts except when they are equal, in which case the order is
# determined by the imaginary parts.
#
# Previous to numpy 1.4.0 sorting real and complex arrays containing nan
# values led to undefined behaviour. In numpy versions >= 1.4.0 nan
# values are sorted to the end. The extended sort order is:
#
#   * Real: [R, nan]
#   * Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
#
# where R is a non-nan real value. Complex values with the same nan
# placements are sorted according to the non-nan part if it exists.
# Non-nan values are sorted as before.
#
# .. versionadded:: 1.12.0
#
# quicksort has been changed to `introsort <https://en.wikipedia.org/wiki/Introsort>`_.
# When sorting does not make enough progress it switches to
# `heapsort <https://en.wikipedia.org/wiki/Heapsort>`_.
# This implementation makes quicksort O(n*log(n)) in the worst case.
#
# 'stable' automatically chooses the best stable sorting algorithm
# for the data type being sorted.
# It, along with 'mergesort' is currently mapped to
# `timsort <https://en.wikipedia.org/wiki/Timsort>`_
# or `radix sort <https://en.wikipedia.org/wiki/Radix_sort>`_
# depending on the data type.
# API forward compatibility currently limits the
# ability to select the implementation and it is hardwired for the different
# data types.
#
# .. versionadded:: 1.17.0
#
# Timsort is added for better performance on already or nearly
# sorted data. On random data timsort is almost identical to
# mergesort. It is now used for stable sort while quicksort is still the
# default sort if none is chosen. For timsort details, refer to
# `CPython listsort.txt <https://github.com/python/cpython/blob/3.7/Objects/listsort.txt>`_.
# 'mergesort' and 'stable' are mapped to radix sort for integer data types. Radix sort is an
# O(n) sort instead of O(n log n).
#
# .. versionchanged:: 1.18.0
#
# NaT now sorts to the end of arrays for consistency with NaN.
#
# Examples
# --------
# >>> a = np.array([[1,4],[3,1]])
# >>> np.sort(a)                # sort along the last axis
# array([[1, 4],
#        [1, 3]])
# >>> np.sort(a, axis=None)     # sort the flattened array
# array([1, 1, 3, 4])
# >>> np.sort(a, axis=0)        # sort along the first axis
# array([[1, 1],
#        [3, 4]])
#
# Use the `order` keyword to specify a field to use when sorting a
# structured array:
#
# >>> dtype = [('name', 'S10'), ('height', float), ('age', int)]
# >>> values = [('Arthur', 1.8, 41), ('Lancelot', 1.9, 38),
# ...           ('Galahad', 1.7, 38)]
# >>> a = np.array(values, dtype=dtype)       # create a structured array
# >>> np.sort(a, order='height')                        # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Arthur', 1.8, 41),
#        ('Lancelot', 1.8999999999999999, 38)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# Sort by age, then height if ages are equal:
#
# >>> np.sort(a, order=['age', 'height'])               # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Lancelot', 1.8999999999999999, 38),
#        ('Arthur', 1.8, 41)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.numeric.ones</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with ones.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: C
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of ones with the given shape, dtype, and order.
#
# See Also
# --------
# ones_like : Return an array of ones with shape and type of input.
# empty : Return a new uninitialized array.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Examples
# --------
# >>> np.ones(5)
# array([1., 1., 1., 1., 1.])
#
# >>> np.ones((5,), dtype=int)
# array([1, 1, 1, 1, 1])
#
# >>> np.ones((2, 1))
# array([[1.],
#        [1.]])
#
# >>> s = (2,2)
# >>> np.ones(s)
# array([[1.,  1.],
#        [1.,  1.]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float32</u></summary>
# <blockquote>
# <code>
# Single-precision floating-point number type, compatible with C ``float``.
#
# :Character code: ``'f'``
# :Canonical name: `numpy.single`
# :Alias on this platform (Linux x86_64): `numpy.float32`: 32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.dropna</u></summary>
# <blockquote>
# <code>
# Remove missing values.
#
# See the :ref:`User Guide <missing_data>` for more on which values are
# considered missing, and how to work with missing data.
#
# Parameters
# ----------
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Determine if rows or columns which contain missing values are
#     removed.
#
#     * 0, or 'index' : Drop rows which contain missing values.
#     * 1, or 'columns' : Drop columns which contain missing value.
#
#     .. versionchanged:: 1.0.0
#
#        Pass tuple or list to drop on multiple axes.
#        Only a single axis is allowed.
#
# how : {'any', 'all'}, default 'any'
#     Determine if row or column is removed from DataFrame, when we have
#     at least one NA or all NA.
#
#     * 'any' : If any NA values are present, drop that row or column.
#     * 'all' : If all values are NA, drop that row or column.
#
# thresh : int, optional
#     Require that many non-NA values.
# subset : column label or sequence of labels, optional
#     Labels along other axis to consider, e.g. if you are dropping rows
#     these would be a list of columns to include.
# inplace : bool, default False
#     If True, do operation inplace and return None.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with NA entries dropped from it or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.isna: Indicate missing values.
# DataFrame.notna : Indicate existing (non-missing) values.
# DataFrame.fillna : Replace missing values.
# Series.dropna : Drop missing values.
# Index.dropna : Drop missing indices.
#
# Examples
# --------
# >>> df = pd.DataFrame({"name": ['Alfred', 'Batman', 'Catwoman'],
# ...                    "toy": [np.nan, 'Batmobile', 'Bullwhip'],
# ...                    "born": [pd.NaT, pd.Timestamp("1940-04-25"),
# ...                             pd.NaT]})
# >>> df
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Drop the rows where at least one element is missing.
#
# >>> df.dropna()
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# Drop the columns where at least one element is missing.
#
# >>> df.dropna(axis='columns')
#        name
# 0    Alfred
# 1    Batman
# 2  Catwoman
#
# Drop the rows where all elements are missing.
#
# >>> df.dropna(how='all')
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep only the rows with at least 2 non-NA values.
#
# >>> df.dropna(thresh=2)
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Define in which columns to look for missing values.
#
# >>> df.dropna(subset=['name', 'toy'])
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep the DataFrame with valid entries in the same variable.
#
# >>> df.dropna(inplace=True)
# >>> df
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.rename</u></summary>
# <blockquote>
# <code>
# Alter axes labels.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# mapper : dict-like or function
#     Dict-like or function transformations to apply to
#     that axis' values. Use either ``mapper`` and ``axis`` to
#     specify the axis to target with ``mapper``, or ``index`` and
#     ``columns``.
# index : dict-like or function
#     Alternative to specifying axis (``mapper, axis=0``
#     is equivalent to ``index=mapper``).
# columns : dict-like or function
#     Alternative to specifying axis (``mapper, axis=1``
#     is equivalent to ``columns=mapper``).
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Axis to target with ``mapper``. Can be either the axis name
#     ('index', 'columns') or number (0, 1). The default is 'index'.
# copy : bool, default True
#     Also copy underlying data.
# inplace : bool, default False
#     Whether to return a new DataFrame. If True then value of copy is
#     ignored.
# level : int or level name, default None
#     In case of a MultiIndex, only rename labels in the specified
#     level.
# errors : {'ignore', 'raise'}, default 'ignore'
#     If 'raise', raise a `KeyError` when a dict-like `mapper`, `index`,
#     or `columns` contains labels that are not present in the Index
#     being transformed.
#     If 'ignore', existing keys will be renamed and extra keys will be
#     ignored.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the renamed axis labels or None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis and
#     "errors='raise'".
#
# See Also
# --------
# DataFrame.rename_axis : Set the name of the axis.
#
# Examples
# --------
# ``DataFrame.rename`` supports two calling conventions
#
# * ``(index=index_mapper, columns=columns_mapper, ...)``
# * ``(mapper, axis={'index', 'columns'}, ...)``
#
# We *highly* recommend using keyword arguments to clarify your
# intent.
#
# Rename columns using a mapping:
#
# >>> df = pd.DataFrame({"A": [1, 2, 3], "B": [4, 5, 6]})
# >>> df.rename(columns={"A": "a", "B": "c"})
#    a  c
# 0  1  4
# 1  2  5
# 2  3  6
#
# Rename index using a mapping:
#
# >>> df.rename(index={0: "x", 1: "y", 2: "z"})
#    A  B
# x  1  4
# y  2  5
# z  3  6
#
# Cast index labels to a different type:
#
# >>> df.index
# RangeIndex(start=0, stop=3, step=1)
# >>> df.rename(index=str).index
# Index(['0', '1', '2'], dtype='object')
#
# >>> df.rename(columns={"A": "a", "B": "b", "C": "c"}, errors="raise")
# Traceback (most recent call last):
# KeyError: ['C'] not found in axis
#
# Using axis-style parameters:
#
# >>> df.rename(str.lower, axis='columns')
#    a  b
# 0  1  4
# 1  2  5
# 2  3  6
#
# >>> df.rename({1: 2, 2: 4}, axis='index')
#    A  B
# 0  1  4
# 2  2  5
# 4  3  6
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u></summary>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.rename</u></summary>
# <blockquote>
# <code>
# Alter Series index labels or name.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# Alternatively, change ``Series.name`` with a scalar value.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# axis : {0 or "index"}
#     Unused. Accepted for compatibility with DataFrame method only.
# index : scalar, hashable sequence, dict-like or function, optional
#     Functions or dict-like are transformations to apply to
#     the index.
#     Scalar or hashable sequence-like will alter the ``Series.name``
#     attribute.
#
# **kwargs
#     Additional keyword arguments passed to the function. Only the
#     "inplace" keyword is used.
#
# Returns
# -------
# Series or None
#     Series with index labels or name altered or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.rename : Corresponding DataFrame method.
# Series.rename_axis : Set the name of the axis.
#
# Examples
# --------
# >>> s = pd.Series([1, 2, 3])
# >>> s
# 0    1
# 1    2
# 2    3
# dtype: int64
# >>> s.rename("my_name")  # scalar, changes Series.name
# 0    1
# 1    2
# 2    3
# Name: my_name, dtype: int64
# >>> s.rename(lambda x: x ** 2)  # function, changes labels
# 0    1
# 1    2
# 4    3
# dtype: int64
# >>> s.rename({1: 3, 2: 5})  # mapping, changes labels
# 0    1
# 3    2
# 5    3
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.unique</u></summary>
# <blockquote>
# <code>
# Return unique values of Series object.
#
# Uniques are returned in order of appearance. Hash table-based unique,
# therefore does NOT sort.
#
# Returns
# -------
# ndarray or ExtensionArray
#     The unique values returned as a NumPy array. See Notes.
#
# See Also
# --------
# unique : Top-level unique method for any 1-d array-like object.
# Index.unique : Return Index with unique values from an Index object.
#
# Notes
# -----
# Returns the unique values as a NumPy array. In case of an
# extension-array backed Series, a new
# :class:`~api.extensions.ExtensionArray` of that type with just
# the unique values is returned. This includes
#
#     * Categorical
#     * Period
#     * Datetime with Timezone
#     * Interval
#     * Sparse
#     * IntegerNA
#
# See Examples section.
#
# Examples
# --------
# >>> pd.Series([2, 1, 3, 3], name='A').unique()
# array([2, 1, 3])
#
# >>> pd.Series([pd.Timestamp('2016-01-01') for _ in range(3)]).unique()
# array(['2016-01-01T00:00:00.000000000'], dtype='datetime64[ns]')
#
# >>> pd.Series([pd.Timestamp('2016-01-01', tz='US/Eastern')
# ...            for _ in range(3)]).unique()
# <DatetimeArray>
# ['2016-01-01 00:00:00-05:00']
# Length: 1, dtype: datetime64[ns, US/Eastern]
#
# An Categorical will return categories in the order of
# appearance and with the same dtype.
#
# >>> pd.Series(pd.Categorical(list('baabc'))).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a', 'b', 'c']
# >>> pd.Series(pd.Categorical(list('baabc'), categories=list('abc'),
# ...                          ordered=True)).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a' < 'b' < 'c']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Data Preparation | Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.dropna</u></summary>
# <blockquote>
# <code>
# Remove missing values.
#
# See the :ref:`User Guide <missing_data>` for more on which values are
# considered missing, and how to work with missing data.
#
# Parameters
# ----------
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Determine if rows or columns which contain missing values are
#     removed.
#
#     * 0, or 'index' : Drop rows which contain missing values.
#     * 1, or 'columns' : Drop columns which contain missing value.
#
#     .. versionchanged:: 1.0.0
#
#        Pass tuple or list to drop on multiple axes.
#        Only a single axis is allowed.
#
# how : {'any', 'all'}, default 'any'
#     Determine if row or column is removed from DataFrame, when we have
#     at least one NA or all NA.
#
#     * 'any' : If any NA values are present, drop that row or column.
#     * 'all' : If all values are NA, drop that row or column.
#
# thresh : int, optional
#     Require that many non-NA values.
# subset : column label or sequence of labels, optional
#     Labels along other axis to consider, e.g. if you are dropping rows
#     these would be a list of columns to include.
# inplace : bool, default False
#     If True, do operation inplace and return None.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with NA entries dropped from it or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.isna: Indicate missing values.
# DataFrame.notna : Indicate existing (non-missing) values.
# DataFrame.fillna : Replace missing values.
# Series.dropna : Drop missing values.
# Index.dropna : Drop missing indices.
#
# Examples
# --------
# >>> df = pd.DataFrame({"name": ['Alfred', 'Batman', 'Catwoman'],
# ...                    "toy": [np.nan, 'Batmobile', 'Bullwhip'],
# ...                    "born": [pd.NaT, pd.Timestamp("1940-04-25"),
# ...                             pd.NaT]})
# >>> df
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Drop the rows where at least one element is missing.
#
# >>> df.dropna()
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# Drop the columns where at least one element is missing.
#
# >>> df.dropna(axis='columns')
#        name
# 0    Alfred
# 1    Batman
# 2  Catwoman
#
# Drop the rows where all elements are missing.
#
# >>> df.dropna(how='all')
#        name        toy       born
# 0    Alfred        NaN        NaT
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep only the rows with at least 2 non-NA values.
#
# >>> df.dropna(thresh=2)
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Define in which columns to look for missing values.
#
# >>> df.dropna(subset=['name', 'toy'])
#        name        toy       born
# 1    Batman  Batmobile 1940-04-25
# 2  Catwoman   Bullwhip        NaT
#
# Keep the DataFrame with valid entries in the same variable.
#
# >>> df.dropna(inplace=True)
# >>> df
#      name        toy       born
# 1  Batman  Batmobile 1940-04-25
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
import numpy as np
import pandas as pd
import keras

import keras
from keras.models import Model
from keras.layers import Input,Dense
from keras import Sequential

train = pd.read_csv("../input/titanic/train.csv")
test = pd.read_csv("../input/titanic/test.csv")

train.Pclass = train.Pclass.values.astype('str')
test.Pclass = test.Pclass.values.astype('str')

train.SibSp = train.SibSp.values.astype('str')
test.SibSp = test.SibSp.values.astype('str')

train.Parch = train.Parch.values.astype('str')
test.Parch = test.Parch.values.astype('str')

use_col =  ['Survived', 'Pclass', 'Sex', 'Age', 'SibSp','Parch','Fare', 'Embarked']

train["Age"] = train.Age.fillna(30.).values
test["Age"] = test.Age.fillna(30.).values

test.Fare[152]=np.mean(test.Fare)

train = train[use_col]
test_x = test[use_col[1:]]

train = train.dropna()

train_y = train[use_col[0]].values
train_x = train[use_col[1:]].copy()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation | Feature Engineering | Library Loading</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.unique</u></summary>
# <blockquote>
# <code>
# Return unique values of Series object.
#
# Uniques are returned in order of appearance. Hash table-based unique,
# therefore does NOT sort.
#
# Returns
# -------
# ndarray or ExtensionArray
#     The unique values returned as a NumPy array. See Notes.
#
# See Also
# --------
# unique : Top-level unique method for any 1-d array-like object.
# Index.unique : Return Index with unique values from an Index object.
#
# Notes
# -----
# Returns the unique values as a NumPy array. In case of an
# extension-array backed Series, a new
# :class:`~api.extensions.ExtensionArray` of that type with just
# the unique values is returned. This includes
#
#     * Categorical
#     * Period
#     * Datetime with Timezone
#     * Interval
#     * Sparse
#     * IntegerNA
#
# See Examples section.
#
# Examples
# --------
# >>> pd.Series([2, 1, 3, 3], name='A').unique()
# array([2, 1, 3])
#
# >>> pd.Series([pd.Timestamp('2016-01-01') for _ in range(3)]).unique()
# array(['2016-01-01T00:00:00.000000000'], dtype='datetime64[ns]')
#
# >>> pd.Series([pd.Timestamp('2016-01-01', tz='US/Eastern')
# ...            for _ in range(3)]).unique()
# <DatetimeArray>
# ['2016-01-01 00:00:00-05:00']
# Length: 1, dtype: datetime64[ns, US/Eastern]
#
# An Categorical will return categories in the order of
# appearance and with the same dtype.
#
# >>> pd.Series(pd.Categorical(list('baabc'))).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a', 'b', 'c']
# >>> pd.Series(pd.Categorical(list('baabc'), categories=list('abc'),
# ...                          ordered=True)).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a' < 'b' < 'c']
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.rename</u></summary>
# <blockquote>
# <code>
# Alter Series index labels or name.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# Alternatively, change ``Series.name`` with a scalar value.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# axis : {0 or "index"}
#     Unused. Accepted for compatibility with DataFrame method only.
# index : scalar, hashable sequence, dict-like or function, optional
#     Functions or dict-like are transformations to apply to
#     the index.
#     Scalar or hashable sequence-like will alter the ``Series.name``
#     attribute.
#
# **kwargs
#     Additional keyword arguments passed to the function. Only the
#     "inplace" keyword is used.
#
# Returns
# -------
# Series or None
#     Series with index labels or name altered or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.rename : Corresponding DataFrame method.
# Series.rename_axis : Set the name of the axis.
#
# Examples
# --------
# >>> s = pd.Series([1, 2, 3])
# >>> s
# 0    1
# 1    2
# 2    3
# dtype: int64
# >>> s.rename("my_name")  # scalar, changes Series.name
# 0    1
# 1    2
# 2    3
# Name: my_name, dtype: int64
# >>> s.rename(lambda x: x ** 2)  # function, changes labels
# 0    1
# 1    2
# 4    3
# dtype: int64
# >>> s.rename({1: 3, 2: 5})  # mapping, changes labels
# 0    1
# 3    2
# 5    3
# dtype: int64
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.rename</u></summary>
# <blockquote>
# <code>
# Alter axes labels.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# mapper : dict-like or function
#     Dict-like or function transformations to apply to
#     that axis' values. Use either ``mapper`` and ``axis`` to
#     specify the axis to target with ``mapper``, or ``index`` and
#     ``columns``.
# index : dict-like or function
#     Alternative to specifying axis (``mapper, axis=0``
#     is equivalent to ``index=mapper``).
# columns : dict-like or function
#     Alternative to specifying axis (``mapper, axis=1``
#     is equivalent to ``columns=mapper``).
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Axis to target with ``mapper``. Can be either the axis name
#     ('index', 'columns') or number (0, 1). The default is 'index'.
# copy : bool, default True
#     Also copy underlying data.
# inplace : bool, default False
#     Whether to return a new DataFrame. If True then value of copy is
#     ignored.
# level : int or level name, default None
#     In case of a MultiIndex, only rename labels in the specified
#     level.
# errors : {'ignore', 'raise'}, default 'ignore'
#     If 'raise', raise a `KeyError` when a dict-like `mapper`, `index`,
#     or `columns` contains labels that are not present in the Index
#     being transformed.
#     If 'ignore', existing keys will be renamed and extra keys will be
#     ignored.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the renamed axis labels or None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis and
#     "errors='raise'".
#
# See Also
# --------
# DataFrame.rename_axis : Set the name of the axis.
#
# Examples
# --------
# ``DataFrame.rename`` supports two calling conventions
#
# * ``(index=index_mapper, columns=columns_mapper, ...)``
# * ``(mapper, axis={'index', 'columns'}, ...)``
#
# We *highly* recommend using keyword arguments to clarify your
# intent.
#
# Rename columns using a mapping:
#
# >>> df = pd.DataFrame({"A": [1, 2, 3], "B": [4, 5, 6]})
# >>> df.rename(columns={"A": "a", "B": "c"})
#    a  c
# 0  1  4
# 1  2  5
# 2  3  6
#
# Rename index using a mapping:
#
# >>> df.rename(index={0: "x", 1: "y", 2: "z"})
#    A  B
# x  1  4
# y  2  5
# z  3  6
#
# Cast index labels to a different type:
#
# >>> df.index
# RangeIndex(start=0, stop=3, step=1)
# >>> df.rename(index=str).index
# Index(['0', '1', '2'], dtype='object')
#
# >>> df.rename(columns={"A": "a", "B": "b", "C": "c"}, errors="raise")
# Traceback (most recent call last):
# KeyError: ['C'] not found in axis
#
# Using axis-style parameters:
#
# >>> df.rename(str.lower, axis='columns')
#    a  b
# 0  1  4
# 1  2  5
# 2  3  6
#
# >>> df.rename({1: 2, 2: 4}, axis='index')
#    A  B
# 0  1  4
# 2  2  5
# 4  3  6
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u></summary>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.any</u></summary>
# <blockquote>
# <code>
# Test whether any array element along a given axis evaluates to True.
#
# Returns single boolean unless `axis` is not ``None``
#
# Parameters
# ----------
# a : array_like
#     Input array or object that can be converted to an array.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which a logical OR reduction is performed.
#     The default (``axis=None``) is to perform a logical OR over all
#     the dimensions of the input array. `axis` may be negative, in
#     which case it counts from the last to the first axis.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a reduction is performed on multiple
#     axes, instead of a single axis or all the axes as before.
# out : ndarray, optional
#     Alternate output array in which to place the result.  It must have
#     the same shape as the expected output and its type is preserved
#     (e.g., if it is of type float, then it will remain so, returning
#     1.0 for True and 0.0 for False, regardless of the type of `a`).
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `any` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in checking for any `True` values.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# any : bool or ndarray
#     A new boolean or `ndarray` is returned unless `out` is specified,
#     in which case a reference to `out` is returned.
#
# See Also
# --------
# ndarray.any : equivalent method
#
# all : Test whether all elements along a given axis evaluate to True.
#
# Notes
# -----
# Not a Number (NaN), positive infinity and negative infinity evaluate
# to `True` because these are not equal to zero.
#
# Examples
# --------
# >>> np.any([[True, False], [True, True]])
# True
#
# >>> np.any([[True, False], [False, False]], axis=0)
# array([ True, False])
#
# >>> np.any([-1, 0, 5])
# True
#
# >>> np.any(np.nan)
# True
#
# >>> np.any([[True, False], [False, False]], where=[[False], [True]])
# False
#
# >>> o=np.array(False)
# >>> z=np.any([-1, 4, 5], out=o)
# >>> z, o
# (array(True), array(True))
# >>> # Check now that z is a reference to o
# >>> z is o
# True
# >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
# (191614240, 191614240)
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float32</u></summary>
# <blockquote>
# <code>
# Single-precision floating-point number type, compatible with C ``float``.
#
# :Character code: ``'f'``
# :Canonical name: `numpy.single`
# :Alias on this platform (Linux x86_64): `numpy.float32`: 32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.around</u></summary>
# <blockquote>
# <code>
# Evenly round to the given number of decimals.
#
# Parameters
# ----------
# a : array_like
#     Input data.
# decimals : int, optional
#     Number of decimal places to round to (default: 0).  If
#     decimals is negative, it specifies the number of positions to
#     the left of the decimal point.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output, but the type of the output
#     values will be cast if necessary. See :ref:`ufuncs-output-type` for more
#     details.
#
# Returns
# -------
# rounded_array : ndarray
#     An array of the same type as `a`, containing the rounded values.
#     Unless `out` was specified, a new array is created.  A reference to
#     the result is returned.
#
#     The real and imaginary parts of complex numbers are rounded
#     separately.  The result of rounding a float is a float.
#
# See Also
# --------
# ndarray.round : equivalent method
#
# ceil, fix, floor, rint, trunc
#
#
# Notes
# -----
# For values exactly halfway between rounded decimal values, NumPy
# rounds to the nearest even value. Thus 1.5 and 2.5 round to 2.0,
# -0.5 and 0.5 round to 0.0, etc.
#
# ``np.around`` uses a fast but sometimes inexact algorithm to round
# floating-point datatypes. For positive `decimals` it is equivalent to
# ``np.true_divide(np.rint(a * 10**decimals), 10**decimals)``, which has
# error due to the inexact representation of decimal fractions in the IEEE
# floating point standard [1]_ and errors introduced when scaling by powers
# of ten. For instance, note the extra "1" in the following:
#
#     >>> np.round(56294995342131.5, 3)
#     56294995342131.51
#
# If your goal is to print such values with a fixed number of decimals, it is
# preferable to use numpy's float printing routines to limit the number of
# printed decimals:
#
#     >>> np.format_float_positional(56294995342131.5, precision=3)
#     '56294995342131.5'
#
# The float printing routines use an accurate but much more computationally
# demanding algorithm to compute the number of digits after the decimal
# point.
#
# Alternatively, Python's builtin `round` function uses a more accurate
# but slower algorithm for 64-bit floating point values:
#
#     >>> round(56294995342131.5, 3)
#     56294995342131.5
#     >>> np.round(16.055, 2), round(16.055, 2)  # equals 16.0549999999999997
#     (16.06, 16.05)
#
#
# References
# ----------
# .. [1] "Lecture Notes on the Status of IEEE 754", William Kahan,
#        https://people.eecs.berkeley.edu/~wkahan/ieee754status/IEEE754.PDF
#
# Examples
# --------
# >>> np.around([0.37, 1.64])
# array([0., 2.])
# >>> np.around([0.37, 1.64], decimals=1)
# array([0.4, 1.6])
# >>> np.around([.5, 1.5, 2.5, 3.5, 4.5]) # rounds to nearest even value
# array([0., 2., 2., 4., 4.])
# >>> np.around([1,2,3,11], decimals=1) # ndarray of ints is returned
# array([ 1,  2,  3, 11])
# >>> np.around([1,2,3,11], decimals=-1)
# array([ 0,  0,  0, 10])
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.numeric.ones</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with ones.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: C
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of ones with the given shape, dtype, and order.
#
# See Also
# --------
# ones_like : Return an array of ones with shape and type of input.
# empty : Return a new uninitialized array.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Examples
# --------
# >>> np.ones(5)
# array([1., 1., 1., 1., 1.])
#
# >>> np.ones((5,), dtype=int)
# array([1, 1, 1, 1, 1])
#
# >>> np.ones((2, 1))
# array([[1.],
#        [1.]])
#
# >>> s = (2,2)
# >>> np.ones(s)
# array([[1.,  1.],
#        [1.,  1.]])
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.sort</u></summary>
# <blockquote>
# <code>
# Return a sorted copy of an array.
#
# Parameters
# ----------
# a : array_like
#     Array to be sorted.
# axis : int or None, optional
#     Axis along which to sort. If None, the array is flattened before
#     sorting. The default is -1, which sorts along the last axis.
# kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional
#     Sorting algorithm. The default is 'quicksort'. Note that both 'stable'
#     and 'mergesort' use timsort or radix sort under the covers and, in general,
#     the actual implementation will vary with data type. The 'mergesort' option
#     is retained for backwards compatibility.
#
#     .. versionchanged:: 1.15.0.
#        The 'stable' option was added.
#
# order : str or list of str, optional
#     When `a` is an array with fields defined, this argument specifies
#     which fields to compare first, second, etc.  A single field can
#     be specified as a string, and not all fields need be specified,
#     but unspecified fields will still be used, in the order in which
#     they come up in the dtype, to break ties.
#
# Returns
# -------
# sorted_array : ndarray
#     Array of the same type and shape as `a`.
#
# See Also
# --------
# ndarray.sort : Method to sort an array in-place.
# argsort : Indirect sort.
# lexsort : Indirect stable sort on multiple keys.
# searchsorted : Find elements in a sorted array.
# partition : Partial sort.
#
# Notes
# -----
# The various sorting algorithms are characterized by their average speed,
# worst case performance, work space size, and whether they are stable. A
# stable sort keeps items with the same key in the same relative
# order. The four algorithms implemented in NumPy have the following
# properties:
#
# =========== ======= ============= ============ ========
#    kind      speed   worst case    work space   stable
# =========== ======= ============= ============ ========
# 'quicksort'    1     O(n^2)            0          no
# 'heapsort'     3     O(n*log(n))       0          no
# 'mergesort'    2     O(n*log(n))      ~n/2        yes
# 'timsort'      2     O(n*log(n))      ~n/2        yes
# =========== ======= ============= ============ ========
#
# .. note:: The datatype determines which of 'mergesort' or 'timsort'
#    is actually used, even if 'mergesort' is specified. User selection
#    at a finer scale is not currently available.
#
# All the sort algorithms make temporary copies of the data when
# sorting along any but the last axis.  Consequently, sorting along
# the last axis is faster and uses less space than sorting along
# any other axis.
#
# The sort order for complex numbers is lexicographic. If both the real
# and imaginary parts are non-nan then the order is determined by the
# real parts except when they are equal, in which case the order is
# determined by the imaginary parts.
#
# Previous to numpy 1.4.0 sorting real and complex arrays containing nan
# values led to undefined behaviour. In numpy versions >= 1.4.0 nan
# values are sorted to the end. The extended sort order is:
#
#   * Real: [R, nan]
#   * Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
#
# where R is a non-nan real value. Complex values with the same nan
# placements are sorted according to the non-nan part if it exists.
# Non-nan values are sorted as before.
#
# .. versionadded:: 1.12.0
#
# quicksort has been changed to `introsort <https://en.wikipedia.org/wiki/Introsort>`_.
# When sorting does not make enough progress it switches to
# `heapsort <https://en.wikipedia.org/wiki/Heapsort>`_.
# This implementation makes quicksort O(n*log(n)) in the worst case.
#
# 'stable' automatically chooses the best stable sorting algorithm
# for the data type being sorted.
# It, along with 'mergesort' is currently mapped to
# `timsort <https://en.wikipedia.org/wiki/Timsort>`_
# or `radix sort <https://en.wikipedia.org/wiki/Radix_sort>`_
# depending on the data type.
# API forward compatibility currently limits the
# ability to select the implementation and it is hardwired for the different
# data types.
#
# .. versionadded:: 1.17.0
#
# Timsort is added for better performance on already or nearly
# sorted data. On random data timsort is almost identical to
# mergesort. It is now used for stable sort while quicksort is still the
# default sort if none is chosen. For timsort details, refer to
# `CPython listsort.txt <https://github.com/python/cpython/blob/3.7/Objects/listsort.txt>`_.
# 'mergesort' and 'stable' are mapped to radix sort for integer data types. Radix sort is an
# O(n) sort instead of O(n log n).
#
# .. versionchanged:: 1.18.0
#
# NaT now sorts to the end of arrays for consistency with NaN.
#
# Examples
# --------
# >>> a = np.array([[1,4],[3,1]])
# >>> np.sort(a)                # sort along the last axis
# array([[1, 4],
#        [1, 3]])
# >>> np.sort(a, axis=None)     # sort the flattened array
# array([1, 1, 3, 4])
# >>> np.sort(a, axis=0)        # sort along the first axis
# array([[1, 1],
#        [3, 4]])
#
# Use the `order` keyword to specify a field to use when sorting a
# structured array:
#
# >>> dtype = [('name', 'S10'), ('height', float), ('age', int)]
# >>> values = [('Arthur', 1.8, 41), ('Lancelot', 1.9, 38),
# ...           ('Galahad', 1.7, 38)]
# >>> a = np.array(values, dtype=dtype)       # create a structured array
# >>> np.sort(a, order='height')                        # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Arthur', 1.8, 41),
#        ('Lancelot', 1.8999999999999999, 38)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# Sort by age, then height if ages are equal:
#
# >>> np.sort(a, order=['age', 'height'])               # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Lancelot', 1.8999999999999999, 38),
#        ('Arthur', 1.8, 41)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
import numpy as np
import pandas as pd

def pandas_type(inp):
    if str(type(inp)) != "<class 'pandas.core.frame.DataFrame'>":
        print("Use pandas DataFrame")
        return False
    else:
        if np.any(inp.isnull()==True)==True:
            print("Your data is a mess")
            return False
        else:
            pass
    
def pandas_enc_str(inp,m_co_var=True):
    out = pd.DataFrame()
    zw = inp.astype
    try:
        zzw = zw.unique()
    except:
        zw = pd.Series(inp)
        zzw = zw.unique()

    if m_co_var == True:
        for i in zzw[1:]:
            try:
                bin_ = eval('zw=='+str(i)).replace({True : 1 , False : 0})
            except:
                bin_ = eval('zw=="'+str(i)+'"').replace({True : 1 , False : 0})
            out[i]=bin_
        return out
    else:
        for i in zzw:
            try:
                bin_ = eval('zw=='+str(i)).replace({True : 1 , False : 0})
            except:
                bin_ = eval('zw=="'+str(i)+'"').replace({True : 1 , False : 0})
            out[i]=bin_
        return out
    
def get_split_len(inp):
    nn1 = str(np.float32(np.mean(inp))-min(inp)).split(".")[0]
    nn2 = str(np.float32(min(inp))).split(".")[1]
    if nn1 != "0":
        return -len(nn1)+3
    else:
        return len(nn2)

def categorize_cat(inp,bins):
    nn = get_split_len(inp)
    leng = (max(inp)-min(inp))/bins
    cats = []
    for i in range(bins):
        cats.append(min(inp)+leng*(i+1))
    return np.around(cats,nn)

def categorize_(inp,bins):
    out = inp.values
    bins_ = categorize_cat(inp,bins)
    zw = np.ones(len(out))*bins_[0]
    for i in range(len(bins_[:-1])):
        for j in range(len(zw)):
            if out[j] > bins_[i]:
                zw[j]=bins_[i+1]
    return zw

def cat_str(inp):
    zw = pd.Series(inp)
    zzw = np.sort(zw.unique())
    cat_dic={}
    for i in range(1,len(zzw)-1):
        cat_dic.update({zzw[i] : str(zzw[i])+"-"+str(zzw[i+1])})
    cat_dic.update({zzw[-1] : "> "+str(zzw[-1])})
    cat_dic.update({zzw[0] : " <"+str(zzw[0])})
    return pd.Series(zw),cat_dic

def pandas_enc(inp,col,bins=5,m_co_var=True):
    out1 = inp[inp.columns[inp.columns!=col]]
    zw = inp[col]
    if pandas_type(inp)!=False:
        pass
    else:
        return None
    if zw.dtype==float:
        zw = categorize_(zw,bins)
        zw,cat_dic = cat_str(zw)
        out2 = pandas_enc_str(zw,m_co_var)
        out2 = out2[np.sort(out2.columns)]
        out2 = out2.rename(columns=cat_dic)
    elif zw.dtype==int:
        print("Specify: str or float")
    elif zw.dtype=="O":
        zw=str(col)+"_"+zw
        out2 = pandas_enc_str(zw,m_co_var)
    else:
        print("Strange dtype")
    return pd.concat([out1,out2], axis=1)

def pandas_multi_enc(inp,col,bins=5,m_co_var=True):
    out = inp
    for i in col:
        out = pandas_enc(out,str(i))
    return out



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>3. Data Preparation | Feature Engineering</h1>  <a id='3'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u></summary>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.rename</u></summary>
# <blockquote>
# <code>
# Alter axes labels.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# mapper : dict-like or function
#     Dict-like or function transformations to apply to
#     that axis' values. Use either ``mapper`` and ``axis`` to
#     specify the axis to target with ``mapper``, or ``index`` and
#     ``columns``.
# index : dict-like or function
#     Alternative to specifying axis (``mapper, axis=0``
#     is equivalent to ``index=mapper``).
# columns : dict-like or function
#     Alternative to specifying axis (``mapper, axis=1``
#     is equivalent to ``columns=mapper``).
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Axis to target with ``mapper``. Can be either the axis name
#     ('index', 'columns') or number (0, 1). The default is 'index'.
# copy : bool, default True
#     Also copy underlying data.
# inplace : bool, default False
#     Whether to return a new DataFrame. If True then value of copy is
#     ignored.
# level : int or level name, default None
#     In case of a MultiIndex, only rename labels in the specified
#     level.
# errors : {'ignore', 'raise'}, default 'ignore'
#     If 'raise', raise a `KeyError` when a dict-like `mapper`, `index`,
#     or `columns` contains labels that are not present in the Index
#     being transformed.
#     If 'ignore', existing keys will be renamed and extra keys will be
#     ignored.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the renamed axis labels or None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis and
#     "errors='raise'".
#
# See Also
# --------
# DataFrame.rename_axis : Set the name of the axis.
#
# Examples
# --------
# ``DataFrame.rename`` supports two calling conventions
#
# * ``(index=index_mapper, columns=columns_mapper, ...)``
# * ``(mapper, axis={'index', 'columns'}, ...)``
#
# We *highly* recommend using keyword arguments to clarify your
# intent.
#
# Rename columns using a mapping:
#
# >>> df = pd.DataFrame({"A": [1, 2, 3], "B": [4, 5, 6]})
# >>> df.rename(columns={"A": "a", "B": "c"})
#    a  c
# 0  1  4
# 1  2  5
# 2  3  6
#
# Rename index using a mapping:
#
# >>> df.rename(index={0: "x", 1: "y", 2: "z"})
#    A  B
# x  1  4
# y  2  5
# z  3  6
#
# Cast index labels to a different type:
#
# >>> df.index
# RangeIndex(start=0, stop=3, step=1)
# >>> df.rename(index=str).index
# Index(['0', '1', '2'], dtype='object')
#
# >>> df.rename(columns={"A": "a", "B": "b", "C": "c"}, errors="raise")
# Traceback (most recent call last):
# KeyError: ['C'] not found in axis
#
# Using axis-style parameters:
#
# >>> df.rename(str.lower, axis='columns')
#    a  b
# 0  1  4
# 1  2  5
# 2  3  6
#
# >>> df.rename({1: 2, 2: 4}, axis='index')
#    A  B
# 0  1  4
# 2  2  5
# 4  3  6
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.unique</u></summary>
# <blockquote>
# <code>
# Return unique values of Series object.
#
# Uniques are returned in order of appearance. Hash table-based unique,
# therefore does NOT sort.
#
# Returns
# -------
# ndarray or ExtensionArray
#     The unique values returned as a NumPy array. See Notes.
#
# See Also
# --------
# unique : Top-level unique method for any 1-d array-like object.
# Index.unique : Return Index with unique values from an Index object.
#
# Notes
# -----
# Returns the unique values as a NumPy array. In case of an
# extension-array backed Series, a new
# :class:`~api.extensions.ExtensionArray` of that type with just
# the unique values is returned. This includes
#
#     * Categorical
#     * Period
#     * Datetime with Timezone
#     * Interval
#     * Sparse
#     * IntegerNA
#
# See Examples section.
#
# Examples
# --------
# >>> pd.Series([2, 1, 3, 3], name='A').unique()
# array([2, 1, 3])
#
# >>> pd.Series([pd.Timestamp('2016-01-01') for _ in range(3)]).unique()
# array(['2016-01-01T00:00:00.000000000'], dtype='datetime64[ns]')
#
# >>> pd.Series([pd.Timestamp('2016-01-01', tz='US/Eastern')
# ...            for _ in range(3)]).unique()
# <DatetimeArray>
# ['2016-01-01 00:00:00-05:00']
# Length: 1, dtype: datetime64[ns, US/Eastern]
#
# An Categorical will return categories in the order of
# appearance and with the same dtype.
#
# >>> pd.Series(pd.Categorical(list('baabc'))).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a', 'b', 'c']
# >>> pd.Series(pd.Categorical(list('baabc'), categories=list('abc'),
# ...                          ordered=True)).unique()
# ['b', 'a', 'c']
# Categories (3, object): ['a' < 'b' < 'c']
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.rename</u></summary>
# <blockquote>
# <code>
# Alter Series index labels or name.
#
# Function / dict values must be unique (1-to-1). Labels not contained in
# a dict / Series will be left as-is. Extra labels listed don't throw an
# error.
#
# Alternatively, change ``Series.name`` with a scalar value.
#
# See the :ref:`user guide <basics.rename>` for more.
#
# Parameters
# ----------
# axis : {0 or "index"}
#     Unused. Accepted for compatibility with DataFrame method only.
# index : scalar, hashable sequence, dict-like or function, optional
#     Functions or dict-like are transformations to apply to
#     the index.
#     Scalar or hashable sequence-like will alter the ``Series.name``
#     attribute.
#
# **kwargs
#     Additional keyword arguments passed to the function. Only the
#     "inplace" keyword is used.
#
# Returns
# -------
# Series or None
#     Series with index labels or name altered or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.rename : Corresponding DataFrame method.
# Series.rename_axis : Set the name of the axis.
#
# Examples
# --------
# >>> s = pd.Series([1, 2, 3])
# >>> s
# 0    1
# 1    2
# 2    3
# dtype: int64
# >>> s.rename("my_name")  # scalar, changes Series.name
# 0    1
# 1    2
# 2    3
# Name: my_name, dtype: int64
# >>> s.rename(lambda x: x ** 2)  # function, changes labels
# 0    1
# 1    2
# 4    3
# dtype: int64
# >>> s.rename({1: 3, 2: 5})  # mapping, changes labels
# 0    1
# 3    2
# 5    3
# dtype: int64
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.numeric.ones</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with ones.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: C
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of ones with the given shape, dtype, and order.
#
# See Also
# --------
# ones_like : Return an array of ones with shape and type of input.
# empty : Return a new uninitialized array.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Examples
# --------
# >>> np.ones(5)
# array([1., 1., 1., 1., 1.])
#
# >>> np.ones((5,), dtype=int)
# array([1, 1, 1, 1, 1])
#
# >>> np.ones((2, 1))
# array([[1.],
#        [1.]])
#
# >>> s = (2,2)
# >>> np.ones(s)
# array([[1.,  1.],
#        [1.,  1.]])
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.sort</u></summary>
# <blockquote>
# <code>
# Return a sorted copy of an array.
#
# Parameters
# ----------
# a : array_like
#     Array to be sorted.
# axis : int or None, optional
#     Axis along which to sort. If None, the array is flattened before
#     sorting. The default is -1, which sorts along the last axis.
# kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional
#     Sorting algorithm. The default is 'quicksort'. Note that both 'stable'
#     and 'mergesort' use timsort or radix sort under the covers and, in general,
#     the actual implementation will vary with data type. The 'mergesort' option
#     is retained for backwards compatibility.
#
#     .. versionchanged:: 1.15.0.
#        The 'stable' option was added.
#
# order : str or list of str, optional
#     When `a` is an array with fields defined, this argument specifies
#     which fields to compare first, second, etc.  A single field can
#     be specified as a string, and not all fields need be specified,
#     but unspecified fields will still be used, in the order in which
#     they come up in the dtype, to break ties.
#
# Returns
# -------
# sorted_array : ndarray
#     Array of the same type and shape as `a`.
#
# See Also
# --------
# ndarray.sort : Method to sort an array in-place.
# argsort : Indirect sort.
# lexsort : Indirect stable sort on multiple keys.
# searchsorted : Find elements in a sorted array.
# partition : Partial sort.
#
# Notes
# -----
# The various sorting algorithms are characterized by their average speed,
# worst case performance, work space size, and whether they are stable. A
# stable sort keeps items with the same key in the same relative
# order. The four algorithms implemented in NumPy have the following
# properties:
#
# =========== ======= ============= ============ ========
#    kind      speed   worst case    work space   stable
# =========== ======= ============= ============ ========
# 'quicksort'    1     O(n^2)            0          no
# 'heapsort'     3     O(n*log(n))       0          no
# 'mergesort'    2     O(n*log(n))      ~n/2        yes
# 'timsort'      2     O(n*log(n))      ~n/2        yes
# =========== ======= ============= ============ ========
#
# .. note:: The datatype determines which of 'mergesort' or 'timsort'
#    is actually used, even if 'mergesort' is specified. User selection
#    at a finer scale is not currently available.
#
# All the sort algorithms make temporary copies of the data when
# sorting along any but the last axis.  Consequently, sorting along
# the last axis is faster and uses less space than sorting along
# any other axis.
#
# The sort order for complex numbers is lexicographic. If both the real
# and imaginary parts are non-nan then the order is determined by the
# real parts except when they are equal, in which case the order is
# determined by the imaginary parts.
#
# Previous to numpy 1.4.0 sorting real and complex arrays containing nan
# values led to undefined behaviour. In numpy versions >= 1.4.0 nan
# values are sorted to the end. The extended sort order is:
#
#   * Real: [R, nan]
#   * Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
#
# where R is a non-nan real value. Complex values with the same nan
# placements are sorted according to the non-nan part if it exists.
# Non-nan values are sorted as before.
#
# .. versionadded:: 1.12.0
#
# quicksort has been changed to `introsort <https://en.wikipedia.org/wiki/Introsort>`_.
# When sorting does not make enough progress it switches to
# `heapsort <https://en.wikipedia.org/wiki/Heapsort>`_.
# This implementation makes quicksort O(n*log(n)) in the worst case.
#
# 'stable' automatically chooses the best stable sorting algorithm
# for the data type being sorted.
# It, along with 'mergesort' is currently mapped to
# `timsort <https://en.wikipedia.org/wiki/Timsort>`_
# or `radix sort <https://en.wikipedia.org/wiki/Radix_sort>`_
# depending on the data type.
# API forward compatibility currently limits the
# ability to select the implementation and it is hardwired for the different
# data types.
#
# .. versionadded:: 1.17.0
#
# Timsort is added for better performance on already or nearly
# sorted data. On random data timsort is almost identical to
# mergesort. It is now used for stable sort while quicksort is still the
# default sort if none is chosen. For timsort details, refer to
# `CPython listsort.txt <https://github.com/python/cpython/blob/3.7/Objects/listsort.txt>`_.
# 'mergesort' and 'stable' are mapped to radix sort for integer data types. Radix sort is an
# O(n) sort instead of O(n log n).
#
# .. versionchanged:: 1.18.0
#
# NaT now sorts to the end of arrays for consistency with NaN.
#
# Examples
# --------
# >>> a = np.array([[1,4],[3,1]])
# >>> np.sort(a)                # sort along the last axis
# array([[1, 4],
#        [1, 3]])
# >>> np.sort(a, axis=None)     # sort the flattened array
# array([1, 1, 3, 4])
# >>> np.sort(a, axis=0)        # sort along the first axis
# array([[1, 1],
#        [3, 4]])
#
# Use the `order` keyword to specify a field to use when sorting a
# structured array:
#
# >>> dtype = [('name', 'S10'), ('height', float), ('age', int)]
# >>> values = [('Arthur', 1.8, 41), ('Lancelot', 1.9, 38),
# ...           ('Galahad', 1.7, 38)]
# >>> a = np.array(values, dtype=dtype)       # create a structured array
# >>> np.sort(a, order='height')                        # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Arthur', 1.8, 41),
#        ('Lancelot', 1.8999999999999999, 38)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# Sort by age, then height if ages are equal:
#
# >>> np.sort(a, order=['age', 'height'])               # doctest: +SKIP
# array([('Galahad', 1.7, 38), ('Lancelot', 1.8999999999999999, 38),
#        ('Arthur', 1.8, 41)],
#       dtype=[('name', '|S10'), ('height', '<f8'), ('age', '<i4')])
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.mean</u></summary>
# <blockquote>
# <code>
# Compute the arithmetic mean along the specified axis.
#
# Returns the average of the array elements.  The average is taken over
# the flattened array by default, otherwise over the specified axis.
# `float64` intermediate and return values are used for integer inputs.
#
# Parameters
# ----------
# a : array_like
#     Array containing numbers whose mean is desired. If `a` is not an
#     array, a conversion is attempted.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which the means are computed. The default is to
#     compute the mean of the flattened array.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a mean is performed over multiple axes,
#     instead of a single axis or all the axes as before.
# dtype : data-type, optional
#     Type to use in computing the mean.  For integer inputs, the default
#     is `float64`; for floating point inputs, it is the same as the
#     input dtype.
# out : ndarray, optional
#     Alternate output array in which to place the result.  The default
#     is ``None``; if provided, it must have the same shape as the
#     expected output, but the type will be cast if necessary.
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `mean` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in the mean. See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# m : ndarray, see dtype parameter above
#     If `out=None`, returns a new array containing the mean values,
#     otherwise a reference to the output array is returned.
#
# See Also
# --------
# average : Weighted average
# std, var, nanmean, nanstd, nanvar
#
# Notes
# -----
# The arithmetic mean is the sum of the elements along the axis divided
# by the number of elements.
#
# Note that for floating-point input, the mean is computed using the
# same precision the input has.  Depending on the input data, this can
# cause the results to be inaccurate, especially for `float32` (see
# example below).  Specifying a higher-precision accumulator using the
# `dtype` keyword can alleviate this issue.
#
# By default, `float16` results are computed using `float32` intermediates
# for extra precision.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> np.mean(a)
# 2.5
# >>> np.mean(a, axis=0)
# array([2., 3.])
# >>> np.mean(a, axis=1)
# array([1.5, 3.5])
#
# In single precision, `mean` can be inaccurate:
#
# >>> a = np.zeros((2, 512*512), dtype=np.float32)
# >>> a[0, :] = 1.0
# >>> a[1, :] = 0.1
# >>> np.mean(a)
# 0.54999924
#
# Computing the mean in float64 is more accurate:
#
# >>> np.mean(a, dtype=np.float64)
# 0.55000000074505806 # may vary
#
# Specifying a where argument:
# >>> a = np.array([[5, 9, 13], [14, 10, 12], [11, 15, 19]])
# >>> np.mean(a)
# 12.0
# >>> np.mean(a, where=[[True], [False], [False]])
# 9.0
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.any</u></summary>
# <blockquote>
# <code>
# Test whether any array element along a given axis evaluates to True.
#
# Returns single boolean unless `axis` is not ``None``
#
# Parameters
# ----------
# a : array_like
#     Input array or object that can be converted to an array.
# axis : None or int or tuple of ints, optional
#     Axis or axes along which a logical OR reduction is performed.
#     The default (``axis=None``) is to perform a logical OR over all
#     the dimensions of the input array. `axis` may be negative, in
#     which case it counts from the last to the first axis.
#
#     .. versionadded:: 1.7.0
#
#     If this is a tuple of ints, a reduction is performed on multiple
#     axes, instead of a single axis or all the axes as before.
# out : ndarray, optional
#     Alternate output array in which to place the result.  It must have
#     the same shape as the expected output and its type is preserved
#     (e.g., if it is of type float, then it will remain so, returning
#     1.0 for True and 0.0 for False, regardless of the type of `a`).
#     See :ref:`ufuncs-output-type` for more details.
#
# keepdims : bool, optional
#     If this is set to True, the axes which are reduced are left
#     in the result as dimensions with size one. With this option,
#     the result will broadcast correctly against the input array.
#
#     If the default value is passed, then `keepdims` will not be
#     passed through to the `any` method of sub-classes of
#     `ndarray`, however any non-default value will be.  If the
#     sub-class' method does not implement `keepdims` any
#     exceptions will be raised.
#
# where : array_like of bool, optional
#     Elements to include in checking for any `True` values.
#     See `~numpy.ufunc.reduce` for details.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# any : bool or ndarray
#     A new boolean or `ndarray` is returned unless `out` is specified,
#     in which case a reference to `out` is returned.
#
# See Also
# --------
# ndarray.any : equivalent method
#
# all : Test whether all elements along a given axis evaluate to True.
#
# Notes
# -----
# Not a Number (NaN), positive infinity and negative infinity evaluate
# to `True` because these are not equal to zero.
#
# Examples
# --------
# >>> np.any([[True, False], [True, True]])
# True
#
# >>> np.any([[True, False], [False, False]], axis=0)
# array([ True, False])
#
# >>> np.any([-1, 0, 5])
# True
#
# >>> np.any(np.nan)
# True
#
# >>> np.any([[True, False], [False, False]], where=[[False], [True]])
# False
#
# >>> o=np.array(False)
# >>> z=np.any([-1, 4, 5], out=o)
# >>> z, o
# (array(True), array(True))
# >>> # Check now that z is a reference to o
# >>> z is o
# True
# >>> id(z), id(o) # identity of z and o              # doctest: +SKIP
# (191614240, 191614240)
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float32</u></summary>
# <blockquote>
# <code>
# Single-precision floating-point number type, compatible with C ``float``.
#
# :Character code: ``'f'``
# :Canonical name: `numpy.single`
# :Alias on this platform (Linux x86_64): `numpy.float32`: 32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.around</u></summary>
# <blockquote>
# <code>
# Evenly round to the given number of decimals.
#
# Parameters
# ----------
# a : array_like
#     Input data.
# decimals : int, optional
#     Number of decimal places to round to (default: 0).  If
#     decimals is negative, it specifies the number of positions to
#     the left of the decimal point.
# out : ndarray, optional
#     Alternative output array in which to place the result. It must have
#     the same shape as the expected output, but the type of the output
#     values will be cast if necessary. See :ref:`ufuncs-output-type` for more
#     details.
#
# Returns
# -------
# rounded_array : ndarray
#     An array of the same type as `a`, containing the rounded values.
#     Unless `out` was specified, a new array is created.  A reference to
#     the result is returned.
#
#     The real and imaginary parts of complex numbers are rounded
#     separately.  The result of rounding a float is a float.
#
# See Also
# --------
# ndarray.round : equivalent method
#
# ceil, fix, floor, rint, trunc
#
#
# Notes
# -----
# For values exactly halfway between rounded decimal values, NumPy
# rounds to the nearest even value. Thus 1.5 and 2.5 round to 2.0,
# -0.5 and 0.5 round to 0.0, etc.
#
# ``np.around`` uses a fast but sometimes inexact algorithm to round
# floating-point datatypes. For positive `decimals` it is equivalent to
# ``np.true_divide(np.rint(a * 10**decimals), 10**decimals)``, which has
# error due to the inexact representation of decimal fractions in the IEEE
# floating point standard [1]_ and errors introduced when scaling by powers
# of ten. For instance, note the extra "1" in the following:
#
#     >>> np.round(56294995342131.5, 3)
#     56294995342131.51
#
# If your goal is to print such values with a fixed number of decimals, it is
# preferable to use numpy's float printing routines to limit the number of
# printed decimals:
#
#     >>> np.format_float_positional(56294995342131.5, precision=3)
#     '56294995342131.5'
#
# The float printing routines use an accurate but much more computationally
# demanding algorithm to compute the number of digits after the decimal
# point.
#
# Alternatively, Python's builtin `round` function uses a more accurate
# but slower algorithm for 64-bit floating point values:
#
#     >>> round(56294995342131.5, 3)
#     56294995342131.5
#     >>> np.round(16.055, 2), round(16.055, 2)  # equals 16.0549999999999997
#     (16.06, 16.05)
#
#
# References
# ----------
# .. [1] "Lecture Notes on the Status of IEEE 754", William Kahan,
#        https://people.eecs.berkeley.edu/~wkahan/ieee754status/IEEE754.PDF
#
# Examples
# --------
# >>> np.around([0.37, 1.64])
# array([0., 2.])
# >>> np.around([0.37, 1.64], decimals=1)
# array([0.4, 1.6])
# >>> np.around([.5, 1.5, 2.5, 3.5, 4.5]) # rounds to nearest even value
# array([0., 2., 2., 4., 4.])
# >>> np.around([1,2,3,11], decimals=1) # ndarray of ints is returned
# array([ 1,  2,  3, 11])
# >>> np.around([1,2,3,11], decimals=-1)
# array([ 0,  0,  0, 10])
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
zw = train_x.append(test_x)
zzw = pandas_multi_enc(zw,['Pclass', 'Sex', 'SibSp', 'Parch', 'Embarked'])

train_x = zzw.iloc[:len(train_x)].values
test_x = zzw.iloc[len(train_x):].values


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Model Building and Training</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.gradient_descent.SGD</u></summary>
# <blockquote>
# <code>
# Gradient descent (with momentum) optimizer.
#
# Update rule for parameter `w` with gradient `g` when `momentum` is 0:
#
# ```python
# w = w - learning_rate * g
# ```
#
# Update rule when `momentum` is larger than 0:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + velocity
# ```
#
# When `nesterov=True`, this rule becomes:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + momentum * velocity - learning_rate * g
# ```
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.01.
#   momentum: float hyperparameter >= 0 that accelerates gradient descent
#     in the relevant
#     direction and dampens oscillations. Defaults to 0, i.e., vanilla gradient
#     descent.
#   nesterov: boolean. Whether to apply Nesterov momentum.
#     Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients.  Defaults to `"SGD"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1)
# >>> var = tf.Variable(1.0)
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> # Step is `- learning_rate * grad`
# >>> var.numpy()
# 0.9
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1, momentum=0.9)
# >>> var = tf.Variable(1.0)
# >>> val0 = var.value()
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> # First step is `- learning_rate * grad`
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val1 = var.value()
# >>> (val0 - val1).numpy()
# 0.1
# >>> # On later steps, step-size increases because of momentum
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val2 = var.value()
# >>> (val1 - val2).numpy()
# 0.18
#
# Reference:
#     - For `nesterov=True`, See [Sutskever et al., 2013](
#       http://jmlr.org/proceedings/papers/v28/sutskever13.pdf).
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
model=Sequential()
model.add(Dense(512,input_dim=zzw.shape[1],activation='linear'))
model.add(Dense(2048,activation='sigmoid'))
model.add(Dense(512,activation='sigmoid'))
model.add(Dense(16,activation='linear'))
model.add(Dense(1,activation='linear'))


sgd=keras.optimizers.SGD(lr=.0001)
model.compile(optimizer=sgd,loss='mse')

res_model = model.fit(train_x,train_y, batch_size=32, epochs=100)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>5. Data Preparation | Model Building and Training</h1>  <a id='5'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#5'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#5'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
zw = model.predict(test_x)

result_csv=pd.DataFrame()

result_csv["PassengerId"]=test.PassengerId
result_csv["Survived"]=np.rint(zw).astype(int)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>6. Data Preparation</h1>  <a id='6'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
result_csv.to_csv("my_titanic_res.csv",index=False)
