# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>h5py</b></li>
# <li><b>keras</b></li>
# <li><b>matplotlib</b></li>
# <li><b>numpy</b></li>
# <li><b>pandas</b></li>
# <li><b>tensorflow</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Visualization</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Visualization" Calls</u></b></summary>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'label': 'train'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'label': 'test'}</li></ul>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'label': 'train'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'label': 'test'}</li></ul>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.ravel</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.ravel([order])
#
# Return a flattened array.
#
# Refer to `numpy.ravel` for full documentation.
#
# See Also
# --------
# numpy.ravel : equivalent function
#
# ndarray.flat : a flat iterator on the array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.tolist</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.tolist()
#
# Return the array as an ``a.ndim``-levels deep nested list of Python scalars.
#
# Return a copy of the array data as a (nested) Python list.
# Data items are converted to the nearest compatible builtin Python type, via
# the `~numpy.ndarray.item` function.
#
# If ``a.ndim`` is 0, then since the depth of the nested list is 0, it will
# not be a list at all, but a simple Python scalar.
#
# Parameters
# ----------
# none
#
# Returns
# -------
# y : object, or list of object, or list of list of object, or ...
#     The possibly nested list of array elements.
#
# Notes
# -----
# The array may be recreated via ``a = np.array(a.tolist())``, although this
# may sometimes lose precision.
#
# Examples
# --------
# For a 1D array, ``a.tolist()`` is almost the same as ``list(a)``,
# except that ``tolist`` changes numpy scalars to Python scalars:
#
# >>> a = np.uint32([1, 2])
# >>> a_list = list(a)
# >>> a_list
# [1, 2]
# >>> type(a_list[0])
# <class 'numpy.uint32'>
# >>> a_tolist = a.tolist()
# >>> a_tolist
# [1, 2]
# >>> type(a_tolist[0])
# <class 'int'>
#
# Additionally, for a 2D array, ``tolist`` applies recursively:
#
# >>> a = np.array([[1, 2], [3, 4]])
# >>> list(a)
# [array([1, 2]), array([3, 4])]
# >>> a.tolist()
# [[1, 2], [3, 4]]
#
# The base case for this recursion is a 0D array:
#
# >>> a = np.array(1)
# >>> list(a)
# Traceback (most recent call last):
#   ...
# TypeError: iteration over a 0-d array
# >>> a.tolist()
# 1
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 13</u></h3></summary><small><a href=#13>goto cell # 13</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.ravel</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.ravel([order])
#
# Return a flattened array.
#
# Refer to `numpy.ravel` for full documentation.
#
# See Also
# --------
# numpy.ravel : equivalent function
#
# ndarray.flat : a flat iterator on the array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.tolist</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.tolist()
#
# Return the array as an ``a.ndim``-levels deep nested list of Python scalars.
#
# Return a copy of the array data as a (nested) Python list.
# Data items are converted to the nearest compatible builtin Python type, via
# the `~numpy.ndarray.item` function.
#
# If ``a.ndim`` is 0, then since the depth of the nested list is 0, it will
# not be a list at all, but a simple Python scalar.
#
# Parameters
# ----------
# none
#
# Returns
# -------
# y : object, or list of object, or list of list of object, or ...
#     The possibly nested list of array elements.
#
# Notes
# -----
# The array may be recreated via ``a = np.array(a.tolist())``, although this
# may sometimes lose precision.
#
# Examples
# --------
# For a 1D array, ``a.tolist()`` is almost the same as ``list(a)``,
# except that ``tolist`` changes numpy scalars to Python scalars:
#
# >>> a = np.uint32([1, 2])
# >>> a_list = list(a)
# >>> a_list
# [1, 2]
# >>> type(a_list[0])
# <class 'numpy.uint32'>
# >>> a_tolist = a.tolist()
# >>> a_tolist
# [1, 2]
# >>> type(a_tolist[0])
# <class 'int'>
#
# Additionally, for a 2D array, ``tolist`` applies recursively:
#
# >>> a = np.array([[1, 2], [3, 4]])
# >>> list(a)
# [array([1, 2]), array([3, 4])]
# >>> a.tolist()
# [[1, 2], [3, 4]]
#
# The base case for this recursion is a 0D array:
#
# >>> a = np.array(1)
# >>> list(a)
# Traceback (most recent call last):
#   ...
# TypeError: iteration over a 0-d array
# >>> a.tolist()
# 1
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.describe</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generate descriptive statistics.
#
# Descriptive statistics include those that summarize the central
# tendency, dispersion and shape of a
# dataset's distribution, excluding ``NaN`` values.
#
# Analyzes both numeric and object series, as well
# as ``DataFrame`` column sets of mixed data types. The output
# will vary depending on what is provided. Refer to the notes
# below for more detail.
#
# Parameters
# ----------
# percentiles : list-like of numbers, optional
#     The percentiles to include in the output. All should
#     fall between 0 and 1. The default is
#     ``[.25, .5, .75]``, which returns the 25th, 50th, and
#     75th percentiles.
# include : 'all', list-like of dtypes or None (default), optional
#     A white list of data types to include in the result. Ignored
#     for ``Series``. Here are the options:
#
#     - 'all' : All columns of the input will be included in the output.
#     - A list-like of dtypes : Limits the results to the
#       provided data types.
#       To limit the result to numeric types submit
#       ``numpy.number``. To limit it instead to object columns submit
#       the ``numpy.object`` data type. Strings
#       can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(include=['O'])``). To
#       select pandas categorical columns, use ``'category'``
#     - None (default) : The result will include all numeric columns.
# exclude : list-like of dtypes or None (default), optional,
#     A black list of data types to omit from the result. Ignored
#     for ``Series``. Here are the options:
#
#     - A list-like of dtypes : Excludes the provided data types
#       from the result. To exclude numeric types submit
#       ``numpy.number``. To exclude object columns submit the data
#       type ``numpy.object``. Strings can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(exclude=['O'])``). To
#       exclude pandas categorical columns, use ``'category'``
#     - None (default) : The result will exclude nothing.
# datetime_is_numeric : bool, default False
#     Whether to treat datetime dtypes as numeric. This affects statistics
#     calculated for the column. For DataFrame input, this also
#     controls whether datetime columns are included by default.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# Series or DataFrame
#     Summary statistics of the Series or Dataframe provided.
#
# See Also
# --------
# DataFrame.count: Count number of non-NA/null observations.
# DataFrame.max: Maximum of the values in the object.
# DataFrame.min: Minimum of the values in the object.
# DataFrame.mean: Mean of the values.
# DataFrame.std: Standard deviation of the observations.
# DataFrame.select_dtypes: Subset of a DataFrame including/excluding
#     columns based on their dtype.
#
# Notes
# -----
# For numeric data, the result's index will include ``count``,
# ``mean``, ``std``, ``min``, ``max`` as well as lower, ``50`` and
# upper percentiles. By default the lower percentile is ``25`` and the
# upper percentile is ``75``. The ``50`` percentile is the
# same as the median.
#
# For object data (e.g. strings or timestamps), the result's index
# will include ``count``, ``unique``, ``top``, and ``freq``. The ``top``
# is the most common value. The ``freq`` is the most common value's
# frequency. Timestamps also include the ``first`` and ``last`` items.
#
# If multiple object values have the highest count, then the
# ``count`` and ``top`` results will be arbitrarily chosen from
# among those with the highest count.
#
# For mixed data types provided via a ``DataFrame``, the default is to
# return only an analysis of numeric columns. If the dataframe consists
# only of object and categorical data without any numeric columns, the
# default is to return an analysis of both the object and categorical
# columns. If ``include='all'`` is provided as an option, the result
# will include a union of attributes of each type.
#
# The `include` and `exclude` parameters can be used to limit
# which columns in a ``DataFrame`` are analyzed for the output.
# The parameters are ignored when analyzing a ``Series``.
#
# Examples
# --------
# Describing a numeric ``Series``.
#
# >>> s = pd.Series([1, 2, 3])
# >>> s.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# dtype: float64
#
# Describing a categorical ``Series``.
#
# >>> s = pd.Series(['a', 'a', 'b', 'c'])
# >>> s.describe()
# count     4
# unique    3
# top       a
# freq      2
# dtype: object
#
# Describing a timestamp ``Series``.
#
# >>> s = pd.Series([
# ...   np.datetime64("2000-01-01"),
# ...   np.datetime64("2010-01-01"),
# ...   np.datetime64("2010-01-01")
# ... ])
# >>> s.describe(datetime_is_numeric=True)
# count                      3
# mean     2006-09-01 08:00:00
# min      2000-01-01 00:00:00
# 25%      2004-12-31 12:00:00
# 50%      2010-01-01 00:00:00
# 75%      2010-01-01 00:00:00
# max      2010-01-01 00:00:00
# dtype: object
#
# Describing a ``DataFrame``. By default only numeric fields
# are returned.
#
# >>> df = pd.DataFrame({'categorical': pd.Categorical(['d','e','f']),
# ...                    'numeric': [1, 2, 3],
# ...                    'object': ['a', 'b', 'c']
# ...                   })
# >>> df.describe()
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Describing all columns of a ``DataFrame`` regardless of data type.
#
# >>> df.describe(include='all')  # doctest: +SKIP
#        categorical  numeric object
# count            3      3.0      3
# unique           3      NaN      3
# top              f      NaN      a
# freq             1      NaN      1
# mean           NaN      2.0    NaN
# std            NaN      1.0    NaN
# min            NaN      1.0    NaN
# 25%            NaN      1.5    NaN
# 50%            NaN      2.0    NaN
# 75%            NaN      2.5    NaN
# max            NaN      3.0    NaN
#
# Describing a column from a ``DataFrame`` by accessing it as
# an attribute.
#
# >>> df.numeric.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# Name: numeric, dtype: float64
#
# Including only numeric columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[np.number])
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Including only string columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[object])  # doctest: +SKIP
#        object
# count       3
# unique      3
# top         a
# freq        1
#
# Including only categorical columns from a ``DataFrame`` description.
#
# >>> df.describe(include=['category'])
#        categorical
# count            3
# unique           3
# top              d
# freq             1
#
# Excluding numeric columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[np.number])  # doctest: +SKIP
#        categorical object
# count            3      3
# unique           3      3
# top              f      a
# freq             1      1
#
# Excluding object columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[object])  # doctest: +SKIP
#        categorical  numeric
# count            3      3.0
# unique           3      NaN
# top              f      NaN
# freq             1      NaN
# mean           NaN      2.0
# std            NaN      1.0
# min            NaN      1.0
# 25%            NaN      1.5
# 50%            NaN      2.0
# 75%            NaN      2.5
# max            NaN      3.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.describe</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generate descriptive statistics.
#
# Descriptive statistics include those that summarize the central
# tendency, dispersion and shape of a
# dataset's distribution, excluding ``NaN`` values.
#
# Analyzes both numeric and object series, as well
# as ``DataFrame`` column sets of mixed data types. The output
# will vary depending on what is provided. Refer to the notes
# below for more detail.
#
# Parameters
# ----------
# percentiles : list-like of numbers, optional
#     The percentiles to include in the output. All should
#     fall between 0 and 1. The default is
#     ``[.25, .5, .75]``, which returns the 25th, 50th, and
#     75th percentiles.
# include : 'all', list-like of dtypes or None (default), optional
#     A white list of data types to include in the result. Ignored
#     for ``Series``. Here are the options:
#
#     - 'all' : All columns of the input will be included in the output.
#     - A list-like of dtypes : Limits the results to the
#       provided data types.
#       To limit the result to numeric types submit
#       ``numpy.number``. To limit it instead to object columns submit
#       the ``numpy.object`` data type. Strings
#       can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(include=['O'])``). To
#       select pandas categorical columns, use ``'category'``
#     - None (default) : The result will include all numeric columns.
# exclude : list-like of dtypes or None (default), optional,
#     A black list of data types to omit from the result. Ignored
#     for ``Series``. Here are the options:
#
#     - A list-like of dtypes : Excludes the provided data types
#       from the result. To exclude numeric types submit
#       ``numpy.number``. To exclude object columns submit the data
#       type ``numpy.object``. Strings can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(exclude=['O'])``). To
#       exclude pandas categorical columns, use ``'category'``
#     - None (default) : The result will exclude nothing.
# datetime_is_numeric : bool, default False
#     Whether to treat datetime dtypes as numeric. This affects statistics
#     calculated for the column. For DataFrame input, this also
#     controls whether datetime columns are included by default.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# Series or DataFrame
#     Summary statistics of the Series or Dataframe provided.
#
# See Also
# --------
# DataFrame.count: Count number of non-NA/null observations.
# DataFrame.max: Maximum of the values in the object.
# DataFrame.min: Minimum of the values in the object.
# DataFrame.mean: Mean of the values.
# DataFrame.std: Standard deviation of the observations.
# DataFrame.select_dtypes: Subset of a DataFrame including/excluding
#     columns based on their dtype.
#
# Notes
# -----
# For numeric data, the result's index will include ``count``,
# ``mean``, ``std``, ``min``, ``max`` as well as lower, ``50`` and
# upper percentiles. By default the lower percentile is ``25`` and the
# upper percentile is ``75``. The ``50`` percentile is the
# same as the median.
#
# For object data (e.g. strings or timestamps), the result's index
# will include ``count``, ``unique``, ``top``, and ``freq``. The ``top``
# is the most common value. The ``freq`` is the most common value's
# frequency. Timestamps also include the ``first`` and ``last`` items.
#
# If multiple object values have the highest count, then the
# ``count`` and ``top`` results will be arbitrarily chosen from
# among those with the highest count.
#
# For mixed data types provided via a ``DataFrame``, the default is to
# return only an analysis of numeric columns. If the dataframe consists
# only of object and categorical data without any numeric columns, the
# default is to return an analysis of both the object and categorical
# columns. If ``include='all'`` is provided as an option, the result
# will include a union of attributes of each type.
#
# The `include` and `exclude` parameters can be used to limit
# which columns in a ``DataFrame`` are analyzed for the output.
# The parameters are ignored when analyzing a ``Series``.
#
# Examples
# --------
# Describing a numeric ``Series``.
#
# >>> s = pd.Series([1, 2, 3])
# >>> s.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# dtype: float64
#
# Describing a categorical ``Series``.
#
# >>> s = pd.Series(['a', 'a', 'b', 'c'])
# >>> s.describe()
# count     4
# unique    3
# top       a
# freq      2
# dtype: object
#
# Describing a timestamp ``Series``.
#
# >>> s = pd.Series([
# ...   np.datetime64("2000-01-01"),
# ...   np.datetime64("2010-01-01"),
# ...   np.datetime64("2010-01-01")
# ... ])
# >>> s.describe(datetime_is_numeric=True)
# count                      3
# mean     2006-09-01 08:00:00
# min      2000-01-01 00:00:00
# 25%      2004-12-31 12:00:00
# 50%      2010-01-01 00:00:00
# 75%      2010-01-01 00:00:00
# max      2010-01-01 00:00:00
# dtype: object
#
# Describing a ``DataFrame``. By default only numeric fields
# are returned.
#
# >>> df = pd.DataFrame({'categorical': pd.Categorical(['d','e','f']),
# ...                    'numeric': [1, 2, 3],
# ...                    'object': ['a', 'b', 'c']
# ...                   })
# >>> df.describe()
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Describing all columns of a ``DataFrame`` regardless of data type.
#
# >>> df.describe(include='all')  # doctest: +SKIP
#        categorical  numeric object
# count            3      3.0      3
# unique           3      NaN      3
# top              f      NaN      a
# freq             1      NaN      1
# mean           NaN      2.0    NaN
# std            NaN      1.0    NaN
# min            NaN      1.0    NaN
# 25%            NaN      1.5    NaN
# 50%            NaN      2.0    NaN
# 75%            NaN      2.5    NaN
# max            NaN      3.0    NaN
#
# Describing a column from a ``DataFrame`` by accessing it as
# an attribute.
#
# >>> df.numeric.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# Name: numeric, dtype: float64
#
# Including only numeric columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[np.number])
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Including only string columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[object])  # doctest: +SKIP
#        object
# count       3
# unique      3
# top         a
# freq        1
#
# Including only categorical columns from a ``DataFrame`` description.
#
# >>> df.describe(include=['category'])
#        categorical
# count            3
# unique           3
# top              d
# freq             1
#
# Excluding numeric columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[np.number])  # doctest: +SKIP
#        categorical object
# count            3      3
# unique           3      3
# top              f      a
# freq             1      1
#
# Excluding object columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[object])  # doctest: +SKIP
#        categorical  numeric
# count            3      3.0
# unique           3      NaN
# top              f      NaN
# freq             1      NaN
# mean           NaN      2.0
# std            NaN      1.0
# min            NaN      1.0
# 25%            NaN      1.5
# 50%            NaN      2.0
# 75%            NaN      2.5
# max            NaN      3.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'inplace': True}</li></ul>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.replace</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <blockquote>
# <code>
# Replace values given in `to_replace` with `value`.
#
# Values of the Series are replaced with other values dynamically.
#
# This differs from updating with ``.loc`` or ``.iloc``, which require
# you to specify a location to update with some value.
#
# Parameters
# ----------
# to_replace : str, regex, list, dict, Series, int, float, or None
#     How to find the values that will be replaced.
#
#     * numeric, str or regex:
#
#         - numeric: numeric values equal to `to_replace` will be
#           replaced with `value`
#         - str: string exactly matching `to_replace` will be replaced
#           with `value`
#         - regex: regexs matching `to_replace` will be replaced with
#           `value`
#
#     * list of str, regex, or numeric:
#
#         - First, if `to_replace` and `value` are both lists, they
#           **must** be the same length.
#         - Second, if ``regex=True`` then all of the strings in **both**
#           lists will be interpreted as regexs otherwise they will match
#           directly. This doesn't matter much for `value` since there
#           are only a few possible substitution regexes you can use.
#         - str, regex and numeric rules apply as above.
#
#     * dict:
#
#         - Dicts can be used to specify different replacement values
#           for different existing values. For example,
#           ``{'a': 'b', 'y': 'z'}`` replaces the value 'a' with 'b' and
#           'y' with 'z'. To use a dict in this way the `value`
#           parameter should be `None`.
#         - For a DataFrame a dict can specify that different values
#           should be replaced in different columns. For example,
#           ``{'a': 1, 'b': 'z'}`` looks for the value 1 in column 'a'
#           and the value 'z' in column 'b' and replaces these values
#           with whatever is specified in `value`. The `value` parameter
#           should not be ``None`` in this case. You can treat this as a
#           special case of passing two lists except that you are
#           specifying the column to search in.
#         - For a DataFrame nested dictionaries, e.g.,
#           ``{'a': {'b': np.nan}}``, are read as follows: look in column
#           'a' for the value 'b' and replace it with NaN. The `value`
#           parameter should be ``None`` to use a nested dict in this
#           way. You can nest regular expressions as well. Note that
#           column names (the top-level dictionary keys in a nested
#           dictionary) **cannot** be regular expressions.
#
#     * None:
#
#         - This means that the `regex` argument must be a string,
#           compiled regular expression, or list, dict, ndarray or
#           Series of such elements. If `value` is also ``None`` then
#           this **must** be a nested dictionary or Series.
#
#     See the examples section for examples of each of these.
# value : scalar, dict, list, str, regex, default None
#     Value to replace any values matching `to_replace` with.
#     For a DataFrame a dict of values can be used to specify which
#     value to use for each column (columns not in the dict will not be
#     filled). Regular expressions, strings and lists or dicts of such
#     objects are also allowed.
# inplace : bool, default False
#     If True, performs operation inplace and returns None.
# limit : int, default None
#     Maximum size gap to forward or backward fill.
# regex : bool or same types as `to_replace`, default False
#     Whether to interpret `to_replace` and/or `value` as regular
#     expressions. If this is ``True`` then `to_replace` *must* be a
#     string. Alternatively, this could be a regular expression or a
#     list, dict, or array of regular expressions in which case
#     `to_replace` must be ``None``.
# method : {'pad', 'ffill', 'bfill', `None`}
#     The method to use when for replacement, when `to_replace` is a
#     scalar, list or tuple and `value` is ``None``.
#
#     .. versionchanged:: 0.23.0
#         Added to DataFrame.
#
# Returns
# -------
# Series
#     Object after replacement.
#
# Raises
# ------
# AssertionError
#     * If `regex` is not a ``bool`` and `to_replace` is not
#       ``None``.
#
# TypeError
#     * If `to_replace` is not a scalar, array-like, ``dict``, or ``None``
#     * If `to_replace` is a ``dict`` and `value` is not a ``list``,
#       ``dict``, ``ndarray``, or ``Series``
#     * If `to_replace` is ``None`` and `regex` is not compilable
#       into a regular expression or is a list, dict, ndarray, or
#       Series.
#     * When replacing multiple ``bool`` or ``datetime64`` objects and
#       the arguments to `to_replace` does not match the type of the
#       value being replaced
#
# ValueError
#     * If a ``list`` or an ``ndarray`` is passed to `to_replace` and
#       `value` but they are not the same length.
#
# See Also
# --------
# Series.fillna : Fill NA values.
# Series.where : Replace values based on boolean condition.
# Series.str.replace : Simple string replacement.
#
# Notes
# -----
# * Regex substitution is performed under the hood with ``re.sub``. The
#   rules for substitution for ``re.sub`` are the same.
# * Regular expressions will only substitute on strings, meaning you
#   cannot provide, for example, a regular expression matching floating
#   point numbers and expect the columns in your frame that have a
#   numeric dtype to be matched. However, if those floating point
#   numbers *are* strings, then you can do this.
# * This method has *a lot* of options. You are encouraged to experiment
#   and play with this method to gain intuition about how it works.
# * When dict is used as the `to_replace` value, it is like
#   key(s) in the dict are the to_replace part and
#   value(s) in the dict are the value parameter.
#
# Examples
# --------
#
# **Scalar `to_replace` and `value`**
#
# >>> s = pd.Series([1, 2, 3, 4, 5])
# >>> s.replace(1, 5)
# 0    5
# 1    2
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# >>> df = pd.DataFrame({'A': [0, 1, 2, 3, 4],
# ...                    'B': [5, 6, 7, 8, 9],
# ...                    'C': ['a', 'b', 'c', 'd', 'e']})
# >>> df.replace(0, 5)
#     A  B  C
# 0  5  5  a
# 1  1  6  b
# 2  2  7  c
# 3  3  8  d
# 4  4  9  e
#
# **List-like `to_replace`**
#
# >>> df.replace([0, 1, 2, 3], 4)
#     A  B  C
# 0  4  5  a
# 1  4  6  b
# 2  4  7  c
# 3  4  8  d
# 4  4  9  e
#
# >>> df.replace([0, 1, 2, 3], [4, 3, 2, 1])
#     A  B  C
# 0  4  5  a
# 1  3  6  b
# 2  2  7  c
# 3  1  8  d
# 4  4  9  e
#
# >>> s.replace([1, 2], method='bfill')
# 0    3
# 1    3
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# **dict-like `to_replace`**
#
# >>> df.replace({0: 10, 1: 100})
#         A  B  C
# 0   10  5  a
# 1  100  6  b
# 2    2  7  c
# 3    3  8  d
# 4    4  9  e
#
# >>> df.replace({'A': 0, 'B': 5}, 100)
#         A    B  C
# 0  100  100  a
# 1    1    6  b
# 2    2    7  c
# 3    3    8  d
# 4    4    9  e
#
# >>> df.replace({'A': {0: 100, 4: 400}})
#         A  B  C
# 0  100  5  a
# 1    1  6  b
# 2    2  7  c
# 3    3  8  d
# 4  400  9  e
#
# **Regular expression `to_replace`**
#
# >>> df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],
# ...                    'B': ['abc', 'bar', 'xyz']})
# >>> df.replace(to_replace=r'^ba.$', value='new', regex=True)
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)
#         A    B
# 0   new  abc
# 1   foo  bar
# 2  bait  xyz
#
# >>> df.replace(regex=r'^ba.$', value='new')
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})
#         A    B
# 0   new  abc
# 1   xyz  new
# 2  bait  xyz
#
# >>> df.replace(regex=[r'^ba.$', 'foo'], value='new')
#         A    B
# 0   new  abc
# 1   new  new
# 2  bait  xyz
#
# Compare the behavior of ``s.replace({'a': None})`` and
# ``s.replace('a', None)`` to understand the peculiarities
# of the `to_replace` parameter:
#
# >>> s = pd.Series([10, 'a', 'a', 'b', 'a'])
#
# When one uses a dict as the `to_replace` value, it is like the
# value(s) in the dict are equal to the `value` parameter.
# ``s.replace({'a': None})`` is equivalent to
# ``s.replace(to_replace={'a': None}, value=None, method=None)``:
#
# >>> s.replace({'a': None})
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
# When ``value`` is not explicitly passed and `to_replace` is a scalar, list
# or tuple, `replace` uses the method parameter (default 'pad') to do the
# replacement. So this is why the 'a' values are being replaced by 10
# in rows 1 and 2 and 'b' in row 4 in this case.
#
# >>> s.replace('a')
# 0    10
# 1    10
# 2    10
# 3     b
# 4     b
# dtype: object
#
# On the other hand, if ``None`` is explicitly passed for ``value``, it will
# be respected:
#
# >>> s.replace('a', None)
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
#     .. versionchanged:: 1.4.0
#         Previously the explicit ``None`` was silently ignored.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'inplace': True}</li></ul>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.replace</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <blockquote>
# <code>
# Replace values given in `to_replace` with `value`.
#
# Values of the Series are replaced with other values dynamically.
#
# This differs from updating with ``.loc`` or ``.iloc``, which require
# you to specify a location to update with some value.
#
# Parameters
# ----------
# to_replace : str, regex, list, dict, Series, int, float, or None
#     How to find the values that will be replaced.
#
#     * numeric, str or regex:
#
#         - numeric: numeric values equal to `to_replace` will be
#           replaced with `value`
#         - str: string exactly matching `to_replace` will be replaced
#           with `value`
#         - regex: regexs matching `to_replace` will be replaced with
#           `value`
#
#     * list of str, regex, or numeric:
#
#         - First, if `to_replace` and `value` are both lists, they
#           **must** be the same length.
#         - Second, if ``regex=True`` then all of the strings in **both**
#           lists will be interpreted as regexs otherwise they will match
#           directly. This doesn't matter much for `value` since there
#           are only a few possible substitution regexes you can use.
#         - str, regex and numeric rules apply as above.
#
#     * dict:
#
#         - Dicts can be used to specify different replacement values
#           for different existing values. For example,
#           ``{'a': 'b', 'y': 'z'}`` replaces the value 'a' with 'b' and
#           'y' with 'z'. To use a dict in this way the `value`
#           parameter should be `None`.
#         - For a DataFrame a dict can specify that different values
#           should be replaced in different columns. For example,
#           ``{'a': 1, 'b': 'z'}`` looks for the value 1 in column 'a'
#           and the value 'z' in column 'b' and replaces these values
#           with whatever is specified in `value`. The `value` parameter
#           should not be ``None`` in this case. You can treat this as a
#           special case of passing two lists except that you are
#           specifying the column to search in.
#         - For a DataFrame nested dictionaries, e.g.,
#           ``{'a': {'b': np.nan}}``, are read as follows: look in column
#           'a' for the value 'b' and replace it with NaN. The `value`
#           parameter should be ``None`` to use a nested dict in this
#           way. You can nest regular expressions as well. Note that
#           column names (the top-level dictionary keys in a nested
#           dictionary) **cannot** be regular expressions.
#
#     * None:
#
#         - This means that the `regex` argument must be a string,
#           compiled regular expression, or list, dict, ndarray or
#           Series of such elements. If `value` is also ``None`` then
#           this **must** be a nested dictionary or Series.
#
#     See the examples section for examples of each of these.
# value : scalar, dict, list, str, regex, default None
#     Value to replace any values matching `to_replace` with.
#     For a DataFrame a dict of values can be used to specify which
#     value to use for each column (columns not in the dict will not be
#     filled). Regular expressions, strings and lists or dicts of such
#     objects are also allowed.
# inplace : bool, default False
#     If True, performs operation inplace and returns None.
# limit : int, default None
#     Maximum size gap to forward or backward fill.
# regex : bool or same types as `to_replace`, default False
#     Whether to interpret `to_replace` and/or `value` as regular
#     expressions. If this is ``True`` then `to_replace` *must* be a
#     string. Alternatively, this could be a regular expression or a
#     list, dict, or array of regular expressions in which case
#     `to_replace` must be ``None``.
# method : {'pad', 'ffill', 'bfill', `None`}
#     The method to use when for replacement, when `to_replace` is a
#     scalar, list or tuple and `value` is ``None``.
#
#     .. versionchanged:: 0.23.0
#         Added to DataFrame.
#
# Returns
# -------
# Series
#     Object after replacement.
#
# Raises
# ------
# AssertionError
#     * If `regex` is not a ``bool`` and `to_replace` is not
#       ``None``.
#
# TypeError
#     * If `to_replace` is not a scalar, array-like, ``dict``, or ``None``
#     * If `to_replace` is a ``dict`` and `value` is not a ``list``,
#       ``dict``, ``ndarray``, or ``Series``
#     * If `to_replace` is ``None`` and `regex` is not compilable
#       into a regular expression or is a list, dict, ndarray, or
#       Series.
#     * When replacing multiple ``bool`` or ``datetime64`` objects and
#       the arguments to `to_replace` does not match the type of the
#       value being replaced
#
# ValueError
#     * If a ``list`` or an ``ndarray`` is passed to `to_replace` and
#       `value` but they are not the same length.
#
# See Also
# --------
# Series.fillna : Fill NA values.
# Series.where : Replace values based on boolean condition.
# Series.str.replace : Simple string replacement.
#
# Notes
# -----
# * Regex substitution is performed under the hood with ``re.sub``. The
#   rules for substitution for ``re.sub`` are the same.
# * Regular expressions will only substitute on strings, meaning you
#   cannot provide, for example, a regular expression matching floating
#   point numbers and expect the columns in your frame that have a
#   numeric dtype to be matched. However, if those floating point
#   numbers *are* strings, then you can do this.
# * This method has *a lot* of options. You are encouraged to experiment
#   and play with this method to gain intuition about how it works.
# * When dict is used as the `to_replace` value, it is like
#   key(s) in the dict are the to_replace part and
#   value(s) in the dict are the value parameter.
#
# Examples
# --------
#
# **Scalar `to_replace` and `value`**
#
# >>> s = pd.Series([1, 2, 3, 4, 5])
# >>> s.replace(1, 5)
# 0    5
# 1    2
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# >>> df = pd.DataFrame({'A': [0, 1, 2, 3, 4],
# ...                    'B': [5, 6, 7, 8, 9],
# ...                    'C': ['a', 'b', 'c', 'd', 'e']})
# >>> df.replace(0, 5)
#     A  B  C
# 0  5  5  a
# 1  1  6  b
# 2  2  7  c
# 3  3  8  d
# 4  4  9  e
#
# **List-like `to_replace`**
#
# >>> df.replace([0, 1, 2, 3], 4)
#     A  B  C
# 0  4  5  a
# 1  4  6  b
# 2  4  7  c
# 3  4  8  d
# 4  4  9  e
#
# >>> df.replace([0, 1, 2, 3], [4, 3, 2, 1])
#     A  B  C
# 0  4  5  a
# 1  3  6  b
# 2  2  7  c
# 3  1  8  d
# 4  4  9  e
#
# >>> s.replace([1, 2], method='bfill')
# 0    3
# 1    3
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# **dict-like `to_replace`**
#
# >>> df.replace({0: 10, 1: 100})
#         A  B  C
# 0   10  5  a
# 1  100  6  b
# 2    2  7  c
# 3    3  8  d
# 4    4  9  e
#
# >>> df.replace({'A': 0, 'B': 5}, 100)
#         A    B  C
# 0  100  100  a
# 1    1    6  b
# 2    2    7  c
# 3    3    8  d
# 4    4    9  e
#
# >>> df.replace({'A': {0: 100, 4: 400}})
#         A  B  C
# 0  100  5  a
# 1    1  6  b
# 2    2  7  c
# 3    3  8  d
# 4  400  9  e
#
# **Regular expression `to_replace`**
#
# >>> df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],
# ...                    'B': ['abc', 'bar', 'xyz']})
# >>> df.replace(to_replace=r'^ba.$', value='new', regex=True)
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)
#         A    B
# 0   new  abc
# 1   foo  bar
# 2  bait  xyz
#
# >>> df.replace(regex=r'^ba.$', value='new')
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})
#         A    B
# 0   new  abc
# 1   xyz  new
# 2  bait  xyz
#
# >>> df.replace(regex=[r'^ba.$', 'foo'], value='new')
#         A    B
# 0   new  abc
# 1   new  new
# 2  bait  xyz
#
# Compare the behavior of ``s.replace({'a': None})`` and
# ``s.replace('a', None)`` to understand the peculiarities
# of the `to_replace` parameter:
#
# >>> s = pd.Series([10, 'a', 'a', 'b', 'a'])
#
# When one uses a dict as the `to_replace` value, it is like the
# value(s) in the dict are equal to the `value` parameter.
# ``s.replace({'a': None})`` is equivalent to
# ``s.replace(to_replace={'a': None}, value=None, method=None)``:
#
# >>> s.replace({'a': None})
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
# When ``value`` is not explicitly passed and `to_replace` is a scalar, list
# or tuple, `replace` uses the method parameter (default 'pad') to do the
# replacement. So this is why the 'a' values are being replaced by 10
# in rows 1 and 2 and 'b' in row 4 in this case.
#
# >>> s.replace('a')
# 0    10
# 1    10
# 2    10
# 3     b
# 4     b
# dtype: object
#
# On the other hand, if ``None`` is explicitly passed for ``value``, it will
# be respected:
#
# >>> s.replace('a', None)
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
#     .. versionchanged:: 1.4.0
#         Previously the explicit ``None`` was silently ignored.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Data Sub-sampling and Train-test Splitting</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Engineering" Calls</u></b></summary>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.replace</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <blockquote>
# <code>
# Replace values given in `to_replace` with `value`.
#
# Values of the Series are replaced with other values dynamically.
#
# This differs from updating with ``.loc`` or ``.iloc``, which require
# you to specify a location to update with some value.
#
# Parameters
# ----------
# to_replace : str, regex, list, dict, Series, int, float, or None
#     How to find the values that will be replaced.
#
#     * numeric, str or regex:
#
#         - numeric: numeric values equal to `to_replace` will be
#           replaced with `value`
#         - str: string exactly matching `to_replace` will be replaced
#           with `value`
#         - regex: regexs matching `to_replace` will be replaced with
#           `value`
#
#     * list of str, regex, or numeric:
#
#         - First, if `to_replace` and `value` are both lists, they
#           **must** be the same length.
#         - Second, if ``regex=True`` then all of the strings in **both**
#           lists will be interpreted as regexs otherwise they will match
#           directly. This doesn't matter much for `value` since there
#           are only a few possible substitution regexes you can use.
#         - str, regex and numeric rules apply as above.
#
#     * dict:
#
#         - Dicts can be used to specify different replacement values
#           for different existing values. For example,
#           ``{'a': 'b', 'y': 'z'}`` replaces the value 'a' with 'b' and
#           'y' with 'z'. To use a dict in this way the `value`
#           parameter should be `None`.
#         - For a DataFrame a dict can specify that different values
#           should be replaced in different columns. For example,
#           ``{'a': 1, 'b': 'z'}`` looks for the value 1 in column 'a'
#           and the value 'z' in column 'b' and replaces these values
#           with whatever is specified in `value`. The `value` parameter
#           should not be ``None`` in this case. You can treat this as a
#           special case of passing two lists except that you are
#           specifying the column to search in.
#         - For a DataFrame nested dictionaries, e.g.,
#           ``{'a': {'b': np.nan}}``, are read as follows: look in column
#           'a' for the value 'b' and replace it with NaN. The `value`
#           parameter should be ``None`` to use a nested dict in this
#           way. You can nest regular expressions as well. Note that
#           column names (the top-level dictionary keys in a nested
#           dictionary) **cannot** be regular expressions.
#
#     * None:
#
#         - This means that the `regex` argument must be a string,
#           compiled regular expression, or list, dict, ndarray or
#           Series of such elements. If `value` is also ``None`` then
#           this **must** be a nested dictionary or Series.
#
#     See the examples section for examples of each of these.
# value : scalar, dict, list, str, regex, default None
#     Value to replace any values matching `to_replace` with.
#     For a DataFrame a dict of values can be used to specify which
#     value to use for each column (columns not in the dict will not be
#     filled). Regular expressions, strings and lists or dicts of such
#     objects are also allowed.
# inplace : bool, default False
#     If True, performs operation inplace and returns None.
# limit : int, default None
#     Maximum size gap to forward or backward fill.
# regex : bool or same types as `to_replace`, default False
#     Whether to interpret `to_replace` and/or `value` as regular
#     expressions. If this is ``True`` then `to_replace` *must* be a
#     string. Alternatively, this could be a regular expression or a
#     list, dict, or array of regular expressions in which case
#     `to_replace` must be ``None``.
# method : {'pad', 'ffill', 'bfill', `None`}
#     The method to use when for replacement, when `to_replace` is a
#     scalar, list or tuple and `value` is ``None``.
#
#     .. versionchanged:: 0.23.0
#         Added to DataFrame.
#
# Returns
# -------
# Series
#     Object after replacement.
#
# Raises
# ------
# AssertionError
#     * If `regex` is not a ``bool`` and `to_replace` is not
#       ``None``.
#
# TypeError
#     * If `to_replace` is not a scalar, array-like, ``dict``, or ``None``
#     * If `to_replace` is a ``dict`` and `value` is not a ``list``,
#       ``dict``, ``ndarray``, or ``Series``
#     * If `to_replace` is ``None`` and `regex` is not compilable
#       into a regular expression or is a list, dict, ndarray, or
#       Series.
#     * When replacing multiple ``bool`` or ``datetime64`` objects and
#       the arguments to `to_replace` does not match the type of the
#       value being replaced
#
# ValueError
#     * If a ``list`` or an ``ndarray`` is passed to `to_replace` and
#       `value` but they are not the same length.
#
# See Also
# --------
# Series.fillna : Fill NA values.
# Series.where : Replace values based on boolean condition.
# Series.str.replace : Simple string replacement.
#
# Notes
# -----
# * Regex substitution is performed under the hood with ``re.sub``. The
#   rules for substitution for ``re.sub`` are the same.
# * Regular expressions will only substitute on strings, meaning you
#   cannot provide, for example, a regular expression matching floating
#   point numbers and expect the columns in your frame that have a
#   numeric dtype to be matched. However, if those floating point
#   numbers *are* strings, then you can do this.
# * This method has *a lot* of options. You are encouraged to experiment
#   and play with this method to gain intuition about how it works.
# * When dict is used as the `to_replace` value, it is like
#   key(s) in the dict are the to_replace part and
#   value(s) in the dict are the value parameter.
#
# Examples
# --------
#
# **Scalar `to_replace` and `value`**
#
# >>> s = pd.Series([1, 2, 3, 4, 5])
# >>> s.replace(1, 5)
# 0    5
# 1    2
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# >>> df = pd.DataFrame({'A': [0, 1, 2, 3, 4],
# ...                    'B': [5, 6, 7, 8, 9],
# ...                    'C': ['a', 'b', 'c', 'd', 'e']})
# >>> df.replace(0, 5)
#     A  B  C
# 0  5  5  a
# 1  1  6  b
# 2  2  7  c
# 3  3  8  d
# 4  4  9  e
#
# **List-like `to_replace`**
#
# >>> df.replace([0, 1, 2, 3], 4)
#     A  B  C
# 0  4  5  a
# 1  4  6  b
# 2  4  7  c
# 3  4  8  d
# 4  4  9  e
#
# >>> df.replace([0, 1, 2, 3], [4, 3, 2, 1])
#     A  B  C
# 0  4  5  a
# 1  3  6  b
# 2  2  7  c
# 3  1  8  d
# 4  4  9  e
#
# >>> s.replace([1, 2], method='bfill')
# 0    3
# 1    3
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# **dict-like `to_replace`**
#
# >>> df.replace({0: 10, 1: 100})
#         A  B  C
# 0   10  5  a
# 1  100  6  b
# 2    2  7  c
# 3    3  8  d
# 4    4  9  e
#
# >>> df.replace({'A': 0, 'B': 5}, 100)
#         A    B  C
# 0  100  100  a
# 1    1    6  b
# 2    2    7  c
# 3    3    8  d
# 4    4    9  e
#
# >>> df.replace({'A': {0: 100, 4: 400}})
#         A  B  C
# 0  100  5  a
# 1    1  6  b
# 2    2  7  c
# 3    3  8  d
# 4  400  9  e
#
# **Regular expression `to_replace`**
#
# >>> df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],
# ...                    'B': ['abc', 'bar', 'xyz']})
# >>> df.replace(to_replace=r'^ba.$', value='new', regex=True)
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)
#         A    B
# 0   new  abc
# 1   foo  bar
# 2  bait  xyz
#
# >>> df.replace(regex=r'^ba.$', value='new')
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})
#         A    B
# 0   new  abc
# 1   xyz  new
# 2  bait  xyz
#
# >>> df.replace(regex=[r'^ba.$', 'foo'], value='new')
#         A    B
# 0   new  abc
# 1   new  new
# 2  bait  xyz
#
# Compare the behavior of ``s.replace({'a': None})`` and
# ``s.replace('a', None)`` to understand the peculiarities
# of the `to_replace` parameter:
#
# >>> s = pd.Series([10, 'a', 'a', 'b', 'a'])
#
# When one uses a dict as the `to_replace` value, it is like the
# value(s) in the dict are equal to the `value` parameter.
# ``s.replace({'a': None})`` is equivalent to
# ``s.replace(to_replace={'a': None}, value=None, method=None)``:
#
# >>> s.replace({'a': None})
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
# When ``value`` is not explicitly passed and `to_replace` is a scalar, list
# or tuple, `replace` uses the method parameter (default 'pad') to do the
# replacement. So this is why the 'a' values are being replaced by 10
# in rows 1 and 2 and 'b' in row 4 in this case.
#
# >>> s.replace('a')
# 0    10
# 1    10
# 2    10
# 3     b
# 4     b
# dtype: object
#
# On the other hand, if ``None`` is explicitly passed for ``value``, it will
# be respected:
#
# >>> s.replace('a', None)
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
#     .. versionchanged:: 1.4.0
#         Previously the explicit ``None`` was silently ignored.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.replace</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <ul><li><b>Args:</b> ['male'] | <b>Kwargs:</b> {'value': 1}</li></ul>
# <ul><li><b>Args:</b> ['female'] | <b>Kwargs:</b> {'value': 0}</li></ul>
# <blockquote>
# <code>
# Replace values given in `to_replace` with `value`.
#
# Values of the Series are replaced with other values dynamically.
#
# This differs from updating with ``.loc`` or ``.iloc``, which require
# you to specify a location to update with some value.
#
# Parameters
# ----------
# to_replace : str, regex, list, dict, Series, int, float, or None
#     How to find the values that will be replaced.
#
#     * numeric, str or regex:
#
#         - numeric: numeric values equal to `to_replace` will be
#           replaced with `value`
#         - str: string exactly matching `to_replace` will be replaced
#           with `value`
#         - regex: regexs matching `to_replace` will be replaced with
#           `value`
#
#     * list of str, regex, or numeric:
#
#         - First, if `to_replace` and `value` are both lists, they
#           **must** be the same length.
#         - Second, if ``regex=True`` then all of the strings in **both**
#           lists will be interpreted as regexs otherwise they will match
#           directly. This doesn't matter much for `value` since there
#           are only a few possible substitution regexes you can use.
#         - str, regex and numeric rules apply as above.
#
#     * dict:
#
#         - Dicts can be used to specify different replacement values
#           for different existing values. For example,
#           ``{'a': 'b', 'y': 'z'}`` replaces the value 'a' with 'b' and
#           'y' with 'z'. To use a dict in this way the `value`
#           parameter should be `None`.
#         - For a DataFrame a dict can specify that different values
#           should be replaced in different columns. For example,
#           ``{'a': 1, 'b': 'z'}`` looks for the value 1 in column 'a'
#           and the value 'z' in column 'b' and replaces these values
#           with whatever is specified in `value`. The `value` parameter
#           should not be ``None`` in this case. You can treat this as a
#           special case of passing two lists except that you are
#           specifying the column to search in.
#         - For a DataFrame nested dictionaries, e.g.,
#           ``{'a': {'b': np.nan}}``, are read as follows: look in column
#           'a' for the value 'b' and replace it with NaN. The `value`
#           parameter should be ``None`` to use a nested dict in this
#           way. You can nest regular expressions as well. Note that
#           column names (the top-level dictionary keys in a nested
#           dictionary) **cannot** be regular expressions.
#
#     * None:
#
#         - This means that the `regex` argument must be a string,
#           compiled regular expression, or list, dict, ndarray or
#           Series of such elements. If `value` is also ``None`` then
#           this **must** be a nested dictionary or Series.
#
#     See the examples section for examples of each of these.
# value : scalar, dict, list, str, regex, default None
#     Value to replace any values matching `to_replace` with.
#     For a DataFrame a dict of values can be used to specify which
#     value to use for each column (columns not in the dict will not be
#     filled). Regular expressions, strings and lists or dicts of such
#     objects are also allowed.
# inplace : bool, default False
#     If True, performs operation inplace and returns None.
# limit : int, default None
#     Maximum size gap to forward or backward fill.
# regex : bool or same types as `to_replace`, default False
#     Whether to interpret `to_replace` and/or `value` as regular
#     expressions. If this is ``True`` then `to_replace` *must* be a
#     string. Alternatively, this could be a regular expression or a
#     list, dict, or array of regular expressions in which case
#     `to_replace` must be ``None``.
# method : {'pad', 'ffill', 'bfill', `None`}
#     The method to use when for replacement, when `to_replace` is a
#     scalar, list or tuple and `value` is ``None``.
#
#     .. versionchanged:: 0.23.0
#         Added to DataFrame.
#
# Returns
# -------
# Series
#     Object after replacement.
#
# Raises
# ------
# AssertionError
#     * If `regex` is not a ``bool`` and `to_replace` is not
#       ``None``.
#
# TypeError
#     * If `to_replace` is not a scalar, array-like, ``dict``, or ``None``
#     * If `to_replace` is a ``dict`` and `value` is not a ``list``,
#       ``dict``, ``ndarray``, or ``Series``
#     * If `to_replace` is ``None`` and `regex` is not compilable
#       into a regular expression or is a list, dict, ndarray, or
#       Series.
#     * When replacing multiple ``bool`` or ``datetime64`` objects and
#       the arguments to `to_replace` does not match the type of the
#       value being replaced
#
# ValueError
#     * If a ``list`` or an ``ndarray`` is passed to `to_replace` and
#       `value` but they are not the same length.
#
# See Also
# --------
# Series.fillna : Fill NA values.
# Series.where : Replace values based on boolean condition.
# Series.str.replace : Simple string replacement.
#
# Notes
# -----
# * Regex substitution is performed under the hood with ``re.sub``. The
#   rules for substitution for ``re.sub`` are the same.
# * Regular expressions will only substitute on strings, meaning you
#   cannot provide, for example, a regular expression matching floating
#   point numbers and expect the columns in your frame that have a
#   numeric dtype to be matched. However, if those floating point
#   numbers *are* strings, then you can do this.
# * This method has *a lot* of options. You are encouraged to experiment
#   and play with this method to gain intuition about how it works.
# * When dict is used as the `to_replace` value, it is like
#   key(s) in the dict are the to_replace part and
#   value(s) in the dict are the value parameter.
#
# Examples
# --------
#
# **Scalar `to_replace` and `value`**
#
# >>> s = pd.Series([1, 2, 3, 4, 5])
# >>> s.replace(1, 5)
# 0    5
# 1    2
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# >>> df = pd.DataFrame({'A': [0, 1, 2, 3, 4],
# ...                    'B': [5, 6, 7, 8, 9],
# ...                    'C': ['a', 'b', 'c', 'd', 'e']})
# >>> df.replace(0, 5)
#     A  B  C
# 0  5  5  a
# 1  1  6  b
# 2  2  7  c
# 3  3  8  d
# 4  4  9  e
#
# **List-like `to_replace`**
#
# >>> df.replace([0, 1, 2, 3], 4)
#     A  B  C
# 0  4  5  a
# 1  4  6  b
# 2  4  7  c
# 3  4  8  d
# 4  4  9  e
#
# >>> df.replace([0, 1, 2, 3], [4, 3, 2, 1])
#     A  B  C
# 0  4  5  a
# 1  3  6  b
# 2  2  7  c
# 3  1  8  d
# 4  4  9  e
#
# >>> s.replace([1, 2], method='bfill')
# 0    3
# 1    3
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# **dict-like `to_replace`**
#
# >>> df.replace({0: 10, 1: 100})
#         A  B  C
# 0   10  5  a
# 1  100  6  b
# 2    2  7  c
# 3    3  8  d
# 4    4  9  e
#
# >>> df.replace({'A': 0, 'B': 5}, 100)
#         A    B  C
# 0  100  100  a
# 1    1    6  b
# 2    2    7  c
# 3    3    8  d
# 4    4    9  e
#
# >>> df.replace({'A': {0: 100, 4: 400}})
#         A  B  C
# 0  100  5  a
# 1    1  6  b
# 2    2  7  c
# 3    3  8  d
# 4  400  9  e
#
# **Regular expression `to_replace`**
#
# >>> df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],
# ...                    'B': ['abc', 'bar', 'xyz']})
# >>> df.replace(to_replace=r'^ba.$', value='new', regex=True)
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)
#         A    B
# 0   new  abc
# 1   foo  bar
# 2  bait  xyz
#
# >>> df.replace(regex=r'^ba.$', value='new')
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})
#         A    B
# 0   new  abc
# 1   xyz  new
# 2  bait  xyz
#
# >>> df.replace(regex=[r'^ba.$', 'foo'], value='new')
#         A    B
# 0   new  abc
# 1   new  new
# 2  bait  xyz
#
# Compare the behavior of ``s.replace({'a': None})`` and
# ``s.replace('a', None)`` to understand the peculiarities
# of the `to_replace` parameter:
#
# >>> s = pd.Series([10, 'a', 'a', 'b', 'a'])
#
# When one uses a dict as the `to_replace` value, it is like the
# value(s) in the dict are equal to the `value` parameter.
# ``s.replace({'a': None})`` is equivalent to
# ``s.replace(to_replace={'a': None}, value=None, method=None)``:
#
# >>> s.replace({'a': None})
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
# When ``value`` is not explicitly passed and `to_replace` is a scalar, list
# or tuple, `replace` uses the method parameter (default 'pad') to do the
# replacement. So this is why the 'a' values are being replaced by 10
# in rows 1 and 2 and 'b' in row 4 in this case.
#
# >>> s.replace('a')
# 0    10
# 1    10
# 2    10
# 3     b
# 4     b
# dtype: object
#
# On the other hand, if ``None`` is explicitly passed for ``value``, it will
# be respected:
#
# >>> s.replace('a', None)
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
#     .. versionchanged:: 1.4.0
#         Previously the explicit ``None`` was silently ignored.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Feature Selection</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.save</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Saves the model to Tensorflow SavedModel or a single HDF5 file.
#
# Please see `tf.keras.models.save_model` or the
# [Serialization and Saving guide](https://keras.io/guides/serialization_and_saving/)
# for details.
#
# Args:
#     filepath: String, PathLike, path to SavedModel or H5 file to save the
#         model.
#     overwrite: Whether to silently overwrite any existing file at the
#         target location, or provide the user with a manual prompt.
#     include_optimizer: If True, save optimizer's state together.
#     save_format: Either `'tf'` or `'h5'`, indicating whether to save the
#         model to Tensorflow SavedModel or HDF5. Defaults to 'tf' in TF 2.X,
#         and 'h5' in TF 1.X.
#     signatures: Signatures to save with the SavedModel. Applicable to the
#         'tf' format only. Please see the `signatures` argument in
#         `tf.saved_model.save` for details.
#     options: (only applies to SavedModel format)
#         `tf.saved_model.SaveOptions` object that specifies options for
#         saving to SavedModel.
#     save_traces: (only applies to SavedModel format) When enabled, the
#         SavedModel will store the function traces for each layer. This
#         can be disabled, so that only the configs of each layer are stored.
#         Defaults to `True`. Disabling this will decrease serialization time
#         and reduce file size, but it requires that all custom layers/models
#         implement a `get_config()` method.
#
# Example:
#
# ```python
# from keras.models import load_model
#
# model.save('my_model.h5')  # creates a HDF5 file 'my_model.h5'
# del model  # deletes the existing model
#
# returns a compiled model
# identical to the previous one
# model = load_model('my_model.h5')
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.saving.save.load_model</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['./model_1.h5'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Loads a model saved via `model.save()`.
#
# Usage:
#
# >>> model = tf.keras.Sequential([
# ...     tf.keras.layers.Dense(5, input_shape=(3,)),
# ...     tf.keras.layers.Softmax()])
# >>> model.save('/tmp/model')
# >>> loaded_model = tf.keras.models.load_model('/tmp/model')
# >>> x = tf.random.uniform((10, 3))
# >>> assert np.allclose(model.predict(x), loaded_model.predict(x))
#
# Note that the model weights may have different scoped names after being
# loaded. Scoped names include the model/layer names, such as
# `"dense_1/kernel:0"`. It is recommended that you use the layer properties to
# access specific variables, e.g. `model.get_layer("dense_1").kernel`.
#
# Args:
#     filepath: One of the following:
#         - String or `pathlib.Path` object, path to the saved model
#         - `h5py.File` object from which to load the model
#     custom_objects: Optional dictionary mapping names
#         (strings) to custom classes or functions to be
#         considered during deserialization.
#     compile: Boolean, whether to compile the model
#         after loading.
#     options: Optional `tf.saved_model.LoadOptions` object that specifies
#       options for loading from SavedModel.
#
# Returns:
#     A Keras model instance. If the original model was compiled, and saved with
#     the optimizer, then the returned model will be compiled. Otherwise, the
#     model will be left uncompiled. In the case that an uncompiled model is
#     returned, a warning is displayed if the `compile` argument is set to
#     `True`.
#
# Raises:
#     ImportError: if loading from an hdf5 file and h5py is not available.
#     IOError: In case of an invalid savefile.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [300] | <b>Kwargs:</b> {'input_dim': 5, 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [150] | <b>Kwargs:</b> {'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [100] | <b>Kwargs:</b> {'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [50] | <b>Kwargs:</b> {'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [25] | <b>Kwargs:</b> {'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'learning_rate': 0.01, 'beta_1': 0.99, 'beta_2': 0.999}</li></ul>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'loss': 'binary_crossentropy', 'metrics': ['accuracy']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 8</u></h3></summary><small><a href=#8>goto cell # 8</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'epochs': 300, 'verbose': 0}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.save</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Saves the model to Tensorflow SavedModel or a single HDF5 file.
#
# Please see `tf.keras.models.save_model` or the
# [Serialization and Saving guide](https://keras.io/guides/serialization_and_saving/)
# for details.
#
# Args:
#     filepath: String, PathLike, path to SavedModel or H5 file to save the
#         model.
#     overwrite: Whether to silently overwrite any existing file at the
#         target location, or provide the user with a manual prompt.
#     include_optimizer: If True, save optimizer's state together.
#     save_format: Either `'tf'` or `'h5'`, indicating whether to save the
#         model to Tensorflow SavedModel or HDF5. Defaults to 'tf' in TF 2.X,
#         and 'h5' in TF 1.X.
#     signatures: Signatures to save with the SavedModel. Applicable to the
#         'tf' format only. Please see the `signatures` argument in
#         `tf.saved_model.save` for details.
#     options: (only applies to SavedModel format)
#         `tf.saved_model.SaveOptions` object that specifies options for
#         saving to SavedModel.
#     save_traces: (only applies to SavedModel format) When enabled, the
#         SavedModel will store the function traces for each layer. This
#         can be disabled, so that only the configs of each layer are stored.
#         Defaults to `True`. Disabling this will decrease serialization time
#         and reduce file size, but it requires that all custom layers/models
#         implement a `get_config()` method.
#
# Example:
#
# ```python
# from keras.models import load_model
#
# model.save('my_model.h5')  # creates a HDF5 file 'my_model.h5'
# del model  # deletes the existing model
#
# returns a compiled model
# identical to the previous one
# model = load_model('my_model.h5')
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 11</u></h3></summary><small><a href=#11>goto cell # 11</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.saving.save.load_model</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['./model_1.h5'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Loads a model saved via `model.save()`.
#
# Usage:
#
# >>> model = tf.keras.Sequential([
# ...     tf.keras.layers.Dense(5, input_shape=(3,)),
# ...     tf.keras.layers.Softmax()])
# >>> model.save('/tmp/model')
# >>> loaded_model = tf.keras.models.load_model('/tmp/model')
# >>> x = tf.random.uniform((10, 3))
# >>> assert np.allclose(model.predict(x), loaded_model.predict(x))
#
# Note that the model weights may have different scoped names after being
# loaded. Scoped names include the model/layer names, such as
# `"dense_1/kernel:0"`. It is recommended that you use the layer properties to
# access specific variables, e.g. `model.get_layer("dense_1").kernel`.
#
# Args:
#     filepath: One of the following:
#         - String or `pathlib.Path` object, path to the saved model
#         - `h5py.File` object from which to load the model
#     custom_objects: Optional dictionary mapping names
#         (strings) to custom classes or functions to be
#         considered during deserialization.
#     compile: Boolean, whether to compile the model
#         after loading.
#     options: Optional `tf.saved_model.LoadOptions` object that specifies
#       options for loading from SavedModel.
#
# Returns:
#     A Keras model instance. If the original model was compiled, and saved with
#     the optimizer, then the returned model will be compiled. Otherwise, the
#     model will be left uncompiled. In the case that an uncompiled model is
#     returned, a warning is displayed if the `compile` argument is set to
#     `True`.
#
# Raises:
#     ImportError: if loading from an hdf5 file and h5py is not available.
#     IOError: In case of an invalid savefile.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'verbose': 2}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'verbose': 2}</li></ul>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 11</u></h3></summary><small><a href=#11>goto cell # 11</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 13</u></h3></summary><small><a href=#13>goto cell # 13</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>h5py</b>
# <ul>
# <li>
# <details><summary><u>h5py</u></summary>
# <blockquote>
# <code>
# This is the h5py package, a Python interface to the HDF5
# scientific data format.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u></summary>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.save</u></summary>
# <blockquote>
# <code>
# Saves the model to Tensorflow SavedModel or a single HDF5 file.
#
# Please see `tf.keras.models.save_model` or the
# [Serialization and Saving guide](https://keras.io/guides/serialization_and_saving/)
# for details.
#
# Args:
#     filepath: String, PathLike, path to SavedModel or H5 file to save the
#         model.
#     overwrite: Whether to silently overwrite any existing file at the
#         target location, or provide the user with a manual prompt.
#     include_optimizer: If True, save optimizer's state together.
#     save_format: Either `'tf'` or `'h5'`, indicating whether to save the
#         model to Tensorflow SavedModel or HDF5. Defaults to 'tf' in TF 2.X,
#         and 'h5' in TF 1.X.
#     signatures: Signatures to save with the SavedModel. Applicable to the
#         'tf' format only. Please see the `signatures` argument in
#         `tf.saved_model.save` for details.
#     options: (only applies to SavedModel format)
#         `tf.saved_model.SaveOptions` object that specifies options for
#         saving to SavedModel.
#     save_traces: (only applies to SavedModel format) When enabled, the
#         SavedModel will store the function traces for each layer. This
#         can be disabled, so that only the configs of each layer are stored.
#         Defaults to `True`. Disabling this will decrease serialization time
#         and reduce file size, but it requires that all custom layers/models
#         implement a `get_config()` method.
#
# Example:
#
# ```python
# from keras.models import load_model
#
# model.save('my_model.h5')  # creates a HDF5 file 'my_model.h5'
# del model  # deletes the existing model
#
# returns a compiled model
# identical to the previous one
# model = load_model('my_model.h5')
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.gradient_descent.SGD</u></summary>
# <blockquote>
# <code>
# Gradient descent (with momentum) optimizer.
#
# Update rule for parameter `w` with gradient `g` when `momentum` is 0:
#
# ```python
# w = w - learning_rate * g
# ```
#
# Update rule when `momentum` is larger than 0:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + velocity
# ```
#
# When `nesterov=True`, this rule becomes:
#
# ```python
# velocity = momentum * velocity - learning_rate * g
# w = w + momentum * velocity - learning_rate * g
# ```
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use. The
#     learning rate. Defaults to 0.01.
#   momentum: float hyperparameter >= 0 that accelerates gradient descent
#     in the relevant
#     direction and dampens oscillations. Defaults to 0, i.e., vanilla gradient
#     descent.
#   nesterov: boolean. Whether to apply Nesterov momentum.
#     Defaults to `False`.
#   name: Optional name prefix for the operations created when applying
#     gradients.  Defaults to `"SGD"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1)
# >>> var = tf.Variable(1.0)
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> # Step is `- learning_rate * grad`
# >>> var.numpy()
# 0.9
#
# >>> opt = tf.keras.optimizers.SGD(learning_rate=0.1, momentum=0.9)
# >>> var = tf.Variable(1.0)
# >>> val0 = var.value()
# >>> loss = lambda: (var ** 2)/2.0         # d(loss)/d(var1) = var1
# >>> # First step is `- learning_rate * grad`
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val1 = var.value()
# >>> (val0 - val1).numpy()
# 0.1
# >>> # On later steps, step-size increases because of momentum
# >>> step_count = opt.minimize(loss, [var]).numpy()
# >>> val2 = var.value()
# >>> (val1 - val2).numpy()
# 0.18
#
# Reference:
#     - For `nesterov=True`, See [Sutskever et al., 2013](
#       http://jmlr.org/proceedings/papers/v28/sutskever13.pdf).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.saving.save.load_model</u></summary>
# <blockquote>
# <code>
# Loads a model saved via `model.save()`.
#
# Usage:
#
# >>> model = tf.keras.Sequential([
# ...     tf.keras.layers.Dense(5, input_shape=(3,)),
# ...     tf.keras.layers.Softmax()])
# >>> model.save('/tmp/model')
# >>> loaded_model = tf.keras.models.load_model('/tmp/model')
# >>> x = tf.random.uniform((10, 3))
# >>> assert np.allclose(model.predict(x), loaded_model.predict(x))
#
# Note that the model weights may have different scoped names after being
# loaded. Scoped names include the model/layer names, such as
# `"dense_1/kernel:0"`. It is recommended that you use the layer properties to
# access specific variables, e.g. `model.get_layer("dense_1").kernel`.
#
# Args:
#     filepath: One of the following:
#         - String or `pathlib.Path` object, path to the saved model
#         - `h5py.File` object from which to load the model
#     custom_objects: Optional dictionary mapping names
#         (strings) to custom classes or functions to be
#         considered during deserialization.
#     compile: Boolean, whether to compile the model
#         after loading.
#     options: Optional `tf.saved_model.LoadOptions` object that specifies
#       options for loading from SavedModel.
#
# Returns:
#     A Keras model instance. If the original model was compiled, and saved with
#     the optimizer, then the returned model will be compiled. Otherwise, the
#     model will be left uncompiled. In the case that an uncompiled model is
#     returned, a warning is displayed if the `compile` argument is set to
#     `True`.
#
# Raises:
#     ImportError: if loading from an hdf5 file and h5py is not available.
#     IOError: In case of an invalid savefile.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot</u></summary>
# <blockquote>
# <code>
# `matplotlib.pyplot` is a state-based interface to matplotlib. It provides
# an implicit,  MATLAB-like, way of plotting.  It also opens figures on your
# screen, and acts as the figure GUI manager.
#
# pyplot is mainly intended for interactive plots and simple cases of
# programmatic plot generation::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     plt.plot(x, y)
#
# The explicit (object-oriented) API is recommended for complex plots, though
# pyplot is still usually used to create the figure and often the axes in the
# figure. See `.pyplot.figure`, `.pyplot.subplots`, and
# `.pyplot.subplot_mosaic` to create figures, and
# :doc:`Axes API <../axes_api>` for the plotting methods on an axes::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u></summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.float64</u></summary>
# <blockquote>
# <code>
# Double-precision floating-point number type, compatible with Python `float`
# and C ``double``.
#
# :Character code: ``'d'``
# :Canonical name: `numpy.double`
# :Alias: `numpy.float_`
# :Alias on this platform (Linux x86_64): `numpy.float64`: 64-bit precision floating-point number type: sign bit, 11 bits exponent, 52 bits mantissa.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.ravel</u></summary>
# <blockquote>
# <code>
# a.ravel([order])
#
# Return a flattened array.
#
# Refer to `numpy.ravel` for full documentation.
#
# See Also
# --------
# numpy.ravel : equivalent function
#
# ndarray.flat : a flat iterator on the array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.tolist</u></summary>
# <blockquote>
# <code>
# a.tolist()
#
# Return the array as an ``a.ndim``-levels deep nested list of Python scalars.
#
# Return a copy of the array data as a (nested) Python list.
# Data items are converted to the nearest compatible builtin Python type, via
# the `~numpy.ndarray.item` function.
#
# If ``a.ndim`` is 0, then since the depth of the nested list is 0, it will
# not be a list at all, but a simple Python scalar.
#
# Parameters
# ----------
# none
#
# Returns
# -------
# y : object, or list of object, or list of list of object, or ...
#     The possibly nested list of array elements.
#
# Notes
# -----
# The array may be recreated via ``a = np.array(a.tolist())``, although this
# may sometimes lose precision.
#
# Examples
# --------
# For a 1D array, ``a.tolist()`` is almost the same as ``list(a)``,
# except that ``tolist`` changes numpy scalars to Python scalars:
#
# >>> a = np.uint32([1, 2])
# >>> a_list = list(a)
# >>> a_list
# [1, 2]
# >>> type(a_list[0])
# <class 'numpy.uint32'>
# >>> a_tolist = a.tolist()
# >>> a_tolist
# [1, 2]
# >>> type(a_tolist[0])
# <class 'int'>
#
# Additionally, for a 2D array, ``tolist`` applies recursively:
#
# >>> a = np.array([[1, 2], [3, 4]])
# >>> list(a)
# [array([1, 2]), array([3, 4])]
# >>> a.tolist()
# [[1, 2], [3, 4]]
#
# The base case for this recursion is a 0D array:
#
# >>> a = np.array(1)
# >>> list(a)
# Traceback (most recent call last):
#   ...
# TypeError: iteration over a 0-d array
# >>> a.tolist()
# 1
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations</u></summary>
# <blockquote>
# <code>
# Add the operations to the cls; evaluate the doc strings again
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u></summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.describe</u></summary>
# <blockquote>
# <code>
# Generate descriptive statistics.
#
# Descriptive statistics include those that summarize the central
# tendency, dispersion and shape of a
# dataset's distribution, excluding ``NaN`` values.
#
# Analyzes both numeric and object series, as well
# as ``DataFrame`` column sets of mixed data types. The output
# will vary depending on what is provided. Refer to the notes
# below for more detail.
#
# Parameters
# ----------
# percentiles : list-like of numbers, optional
#     The percentiles to include in the output. All should
#     fall between 0 and 1. The default is
#     ``[.25, .5, .75]``, which returns the 25th, 50th, and
#     75th percentiles.
# include : 'all', list-like of dtypes or None (default), optional
#     A white list of data types to include in the result. Ignored
#     for ``Series``. Here are the options:
#
#     - 'all' : All columns of the input will be included in the output.
#     - A list-like of dtypes : Limits the results to the
#       provided data types.
#       To limit the result to numeric types submit
#       ``numpy.number``. To limit it instead to object columns submit
#       the ``numpy.object`` data type. Strings
#       can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(include=['O'])``). To
#       select pandas categorical columns, use ``'category'``
#     - None (default) : The result will include all numeric columns.
# exclude : list-like of dtypes or None (default), optional,
#     A black list of data types to omit from the result. Ignored
#     for ``Series``. Here are the options:
#
#     - A list-like of dtypes : Excludes the provided data types
#       from the result. To exclude numeric types submit
#       ``numpy.number``. To exclude object columns submit the data
#       type ``numpy.object``. Strings can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(exclude=['O'])``). To
#       exclude pandas categorical columns, use ``'category'``
#     - None (default) : The result will exclude nothing.
# datetime_is_numeric : bool, default False
#     Whether to treat datetime dtypes as numeric. This affects statistics
#     calculated for the column. For DataFrame input, this also
#     controls whether datetime columns are included by default.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# Series or DataFrame
#     Summary statistics of the Series or Dataframe provided.
#
# See Also
# --------
# DataFrame.count: Count number of non-NA/null observations.
# DataFrame.max: Maximum of the values in the object.
# DataFrame.min: Minimum of the values in the object.
# DataFrame.mean: Mean of the values.
# DataFrame.std: Standard deviation of the observations.
# DataFrame.select_dtypes: Subset of a DataFrame including/excluding
#     columns based on their dtype.
#
# Notes
# -----
# For numeric data, the result's index will include ``count``,
# ``mean``, ``std``, ``min``, ``max`` as well as lower, ``50`` and
# upper percentiles. By default the lower percentile is ``25`` and the
# upper percentile is ``75``. The ``50`` percentile is the
# same as the median.
#
# For object data (e.g. strings or timestamps), the result's index
# will include ``count``, ``unique``, ``top``, and ``freq``. The ``top``
# is the most common value. The ``freq`` is the most common value's
# frequency. Timestamps also include the ``first`` and ``last`` items.
#
# If multiple object values have the highest count, then the
# ``count`` and ``top`` results will be arbitrarily chosen from
# among those with the highest count.
#
# For mixed data types provided via a ``DataFrame``, the default is to
# return only an analysis of numeric columns. If the dataframe consists
# only of object and categorical data without any numeric columns, the
# default is to return an analysis of both the object and categorical
# columns. If ``include='all'`` is provided as an option, the result
# will include a union of attributes of each type.
#
# The `include` and `exclude` parameters can be used to limit
# which columns in a ``DataFrame`` are analyzed for the output.
# The parameters are ignored when analyzing a ``Series``.
#
# Examples
# --------
# Describing a numeric ``Series``.
#
# >>> s = pd.Series([1, 2, 3])
# >>> s.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# dtype: float64
#
# Describing a categorical ``Series``.
#
# >>> s = pd.Series(['a', 'a', 'b', 'c'])
# >>> s.describe()
# count     4
# unique    3
# top       a
# freq      2
# dtype: object
#
# Describing a timestamp ``Series``.
#
# >>> s = pd.Series([
# ...   np.datetime64("2000-01-01"),
# ...   np.datetime64("2010-01-01"),
# ...   np.datetime64("2010-01-01")
# ... ])
# >>> s.describe(datetime_is_numeric=True)
# count                      3
# mean     2006-09-01 08:00:00
# min      2000-01-01 00:00:00
# 25%      2004-12-31 12:00:00
# 50%      2010-01-01 00:00:00
# 75%      2010-01-01 00:00:00
# max      2010-01-01 00:00:00
# dtype: object
#
# Describing a ``DataFrame``. By default only numeric fields
# are returned.
#
# >>> df = pd.DataFrame({'categorical': pd.Categorical(['d','e','f']),
# ...                    'numeric': [1, 2, 3],
# ...                    'object': ['a', 'b', 'c']
# ...                   })
# >>> df.describe()
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Describing all columns of a ``DataFrame`` regardless of data type.
#
# >>> df.describe(include='all')  # doctest: +SKIP
#        categorical  numeric object
# count            3      3.0      3
# unique           3      NaN      3
# top              f      NaN      a
# freq             1      NaN      1
# mean           NaN      2.0    NaN
# std            NaN      1.0    NaN
# min            NaN      1.0    NaN
# 25%            NaN      1.5    NaN
# 50%            NaN      2.0    NaN
# 75%            NaN      2.5    NaN
# max            NaN      3.0    NaN
#
# Describing a column from a ``DataFrame`` by accessing it as
# an attribute.
#
# >>> df.numeric.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# Name: numeric, dtype: float64
#
# Including only numeric columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[np.number])
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Including only string columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[object])  # doctest: +SKIP
#        object
# count       3
# unique      3
# top         a
# freq        1
#
# Including only categorical columns from a ``DataFrame`` description.
#
# >>> df.describe(include=['category'])
#        categorical
# count            3
# unique           3
# top              d
# freq             1
#
# Excluding numeric columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[np.number])  # doctest: +SKIP
#        categorical object
# count            3      3
# unique           3      3
# top              f      a
# freq             1      1
#
# Excluding object columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[object])  # doctest: +SKIP
#        categorical  numeric
# count            3      3.0
# unique           3      NaN
# top              f      NaN
# freq             1      NaN
# mean           NaN      2.0
# std            NaN      1.0
# min            NaN      1.0
# 25%            NaN      1.5
# 50%            NaN      2.0
# 75%            NaN      2.5
# max            NaN      3.0
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.replace</u></summary>
# <blockquote>
# <code>
# Replace values given in `to_replace` with `value`.
#
# Values of the Series are replaced with other values dynamically.
#
# This differs from updating with ``.loc`` or ``.iloc``, which require
# you to specify a location to update with some value.
#
# Parameters
# ----------
# to_replace : str, regex, list, dict, Series, int, float, or None
#     How to find the values that will be replaced.
#
#     * numeric, str or regex:
#
#         - numeric: numeric values equal to `to_replace` will be
#           replaced with `value`
#         - str: string exactly matching `to_replace` will be replaced
#           with `value`
#         - regex: regexs matching `to_replace` will be replaced with
#           `value`
#
#     * list of str, regex, or numeric:
#
#         - First, if `to_replace` and `value` are both lists, they
#           **must** be the same length.
#         - Second, if ``regex=True`` then all of the strings in **both**
#           lists will be interpreted as regexs otherwise they will match
#           directly. This doesn't matter much for `value` since there
#           are only a few possible substitution regexes you can use.
#         - str, regex and numeric rules apply as above.
#
#     * dict:
#
#         - Dicts can be used to specify different replacement values
#           for different existing values. For example,
#           ``{'a': 'b', 'y': 'z'}`` replaces the value 'a' with 'b' and
#           'y' with 'z'. To use a dict in this way the `value`
#           parameter should be `None`.
#         - For a DataFrame a dict can specify that different values
#           should be replaced in different columns. For example,
#           ``{'a': 1, 'b': 'z'}`` looks for the value 1 in column 'a'
#           and the value 'z' in column 'b' and replaces these values
#           with whatever is specified in `value`. The `value` parameter
#           should not be ``None`` in this case. You can treat this as a
#           special case of passing two lists except that you are
#           specifying the column to search in.
#         - For a DataFrame nested dictionaries, e.g.,
#           ``{'a': {'b': np.nan}}``, are read as follows: look in column
#           'a' for the value 'b' and replace it with NaN. The `value`
#           parameter should be ``None`` to use a nested dict in this
#           way. You can nest regular expressions as well. Note that
#           column names (the top-level dictionary keys in a nested
#           dictionary) **cannot** be regular expressions.
#
#     * None:
#
#         - This means that the `regex` argument must be a string,
#           compiled regular expression, or list, dict, ndarray or
#           Series of such elements. If `value` is also ``None`` then
#           this **must** be a nested dictionary or Series.
#
#     See the examples section for examples of each of these.
# value : scalar, dict, list, str, regex, default None
#     Value to replace any values matching `to_replace` with.
#     For a DataFrame a dict of values can be used to specify which
#     value to use for each column (columns not in the dict will not be
#     filled). Regular expressions, strings and lists or dicts of such
#     objects are also allowed.
# inplace : bool, default False
#     If True, performs operation inplace and returns None.
# limit : int, default None
#     Maximum size gap to forward or backward fill.
# regex : bool or same types as `to_replace`, default False
#     Whether to interpret `to_replace` and/or `value` as regular
#     expressions. If this is ``True`` then `to_replace` *must* be a
#     string. Alternatively, this could be a regular expression or a
#     list, dict, or array of regular expressions in which case
#     `to_replace` must be ``None``.
# method : {'pad', 'ffill', 'bfill', `None`}
#     The method to use when for replacement, when `to_replace` is a
#     scalar, list or tuple and `value` is ``None``.
#
#     .. versionchanged:: 0.23.0
#         Added to DataFrame.
#
# Returns
# -------
# Series
#     Object after replacement.
#
# Raises
# ------
# AssertionError
#     * If `regex` is not a ``bool`` and `to_replace` is not
#       ``None``.
#
# TypeError
#     * If `to_replace` is not a scalar, array-like, ``dict``, or ``None``
#     * If `to_replace` is a ``dict`` and `value` is not a ``list``,
#       ``dict``, ``ndarray``, or ``Series``
#     * If `to_replace` is ``None`` and `regex` is not compilable
#       into a regular expression or is a list, dict, ndarray, or
#       Series.
#     * When replacing multiple ``bool`` or ``datetime64`` objects and
#       the arguments to `to_replace` does not match the type of the
#       value being replaced
#
# ValueError
#     * If a ``list`` or an ``ndarray`` is passed to `to_replace` and
#       `value` but they are not the same length.
#
# See Also
# --------
# Series.fillna : Fill NA values.
# Series.where : Replace values based on boolean condition.
# Series.str.replace : Simple string replacement.
#
# Notes
# -----
# * Regex substitution is performed under the hood with ``re.sub``. The
#   rules for substitution for ``re.sub`` are the same.
# * Regular expressions will only substitute on strings, meaning you
#   cannot provide, for example, a regular expression matching floating
#   point numbers and expect the columns in your frame that have a
#   numeric dtype to be matched. However, if those floating point
#   numbers *are* strings, then you can do this.
# * This method has *a lot* of options. You are encouraged to experiment
#   and play with this method to gain intuition about how it works.
# * When dict is used as the `to_replace` value, it is like
#   key(s) in the dict are the to_replace part and
#   value(s) in the dict are the value parameter.
#
# Examples
# --------
#
# **Scalar `to_replace` and `value`**
#
# >>> s = pd.Series([1, 2, 3, 4, 5])
# >>> s.replace(1, 5)
# 0    5
# 1    2
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# >>> df = pd.DataFrame({'A': [0, 1, 2, 3, 4],
# ...                    'B': [5, 6, 7, 8, 9],
# ...                    'C': ['a', 'b', 'c', 'd', 'e']})
# >>> df.replace(0, 5)
#     A  B  C
# 0  5  5  a
# 1  1  6  b
# 2  2  7  c
# 3  3  8  d
# 4  4  9  e
#
# **List-like `to_replace`**
#
# >>> df.replace([0, 1, 2, 3], 4)
#     A  B  C
# 0  4  5  a
# 1  4  6  b
# 2  4  7  c
# 3  4  8  d
# 4  4  9  e
#
# >>> df.replace([0, 1, 2, 3], [4, 3, 2, 1])
#     A  B  C
# 0  4  5  a
# 1  3  6  b
# 2  2  7  c
# 3  1  8  d
# 4  4  9  e
#
# >>> s.replace([1, 2], method='bfill')
# 0    3
# 1    3
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# **dict-like `to_replace`**
#
# >>> df.replace({0: 10, 1: 100})
#         A  B  C
# 0   10  5  a
# 1  100  6  b
# 2    2  7  c
# 3    3  8  d
# 4    4  9  e
#
# >>> df.replace({'A': 0, 'B': 5}, 100)
#         A    B  C
# 0  100  100  a
# 1    1    6  b
# 2    2    7  c
# 3    3    8  d
# 4    4    9  e
#
# >>> df.replace({'A': {0: 100, 4: 400}})
#         A  B  C
# 0  100  5  a
# 1    1  6  b
# 2    2  7  c
# 3    3  8  d
# 4  400  9  e
#
# **Regular expression `to_replace`**
#
# >>> df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],
# ...                    'B': ['abc', 'bar', 'xyz']})
# >>> df.replace(to_replace=r'^ba.$', value='new', regex=True)
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)
#         A    B
# 0   new  abc
# 1   foo  bar
# 2  bait  xyz
#
# >>> df.replace(regex=r'^ba.$', value='new')
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})
#         A    B
# 0   new  abc
# 1   xyz  new
# 2  bait  xyz
#
# >>> df.replace(regex=[r'^ba.$', 'foo'], value='new')
#         A    B
# 0   new  abc
# 1   new  new
# 2  bait  xyz
#
# Compare the behavior of ``s.replace({'a': None})`` and
# ``s.replace('a', None)`` to understand the peculiarities
# of the `to_replace` parameter:
#
# >>> s = pd.Series([10, 'a', 'a', 'b', 'a'])
#
# When one uses a dict as the `to_replace` value, it is like the
# value(s) in the dict are equal to the `value` parameter.
# ``s.replace({'a': None})`` is equivalent to
# ``s.replace(to_replace={'a': None}, value=None, method=None)``:
#
# >>> s.replace({'a': None})
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
# When ``value`` is not explicitly passed and `to_replace` is a scalar, list
# or tuple, `replace` uses the method parameter (default 'pad') to do the
# replacement. So this is why the 'a' values are being replaced by 10
# in rows 1 and 2 and 'b' in row 4 in this case.
#
# >>> s.replace('a')
# 0    10
# 1    10
# 2    10
# 3     b
# 4     b
# dtype: object
#
# On the other hand, if ``None`` is explicitly passed for ``value``, it will
# be respected:
#
# >>> s.replace('a', None)
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
#     .. versionchanged:: 1.4.0
#         Previously the explicit ``None`` was silently ignored.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>tensorflow</b>
# <ul>
# <li>
# <details><summary><u>tensorflow</u></summary>
# <blockquote>
# <code>
# Top-level module of TensorFlow. By convention, we refer to this module as
# `tf` instead of `tensorflow`, following the common practice of importing
# TensorFlow via the command `import tensorflow as tf`.
#
# The primary function of this module is to import all of the public TensorFlow
# interfaces into a single place. The interfaces themselves are located in
# sub-modules, as described below.
#
# Note that the file `__init__.py` in the TensorFlow source code tree is actually
# only a placeholder to enable test cases to run. The TensorFlow build replaces
# this file with a file generated from [`api_template.__init__.py`](https://www.github.com/tensorflow/tensorflow/blob/master/tensorflow/api_template.__init__.py)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>tensorflow.keras</u></summary>
# <blockquote>
# <code>
# Public API for tf.keras namespace.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>tensorflow.python.framework.ops.convert_to_tensor_v2_with_dispatch</u></summary>
# <blockquote>
# <code>
# Converts the given `value` to a `Tensor`.
#
# This function converts Python objects of various types to `Tensor`
# objects. It accepts `Tensor` objects, numpy arrays, Python lists,
# and Python scalars.
#
# For example:
#
# >>> import numpy as np
# >>> def my_func(arg):
# ...   arg = tf.convert_to_tensor(arg, dtype=tf.float32)
# ...   return arg
#
# >>> # The following calls are equivalent.
# ...
# >>> value_1 = my_func(tf.constant([[1.0, 2.0], [3.0, 4.0]]))
# >>> print(value_1)
# tf.Tensor(
#   [[1. 2.]
#    [3. 4.]], shape=(2, 2), dtype=float32)
# >>> value_2 = my_func([[1.0, 2.0], [3.0, 4.0]])
# >>> print(value_2)
# tf.Tensor(
#   [[1. 2.]
#    [3. 4.]], shape=(2, 2), dtype=float32)
# >>> value_3 = my_func(np.array([[1.0, 2.0], [3.0, 4.0]], dtype=np.float32))
# >>> print(value_3)
# tf.Tensor(
#   [[1. 2.]
#    [3. 4.]], shape=(2, 2), dtype=float32)
#
# This function can be useful when composing a new operation in Python
# (such as `my_func` in the example above). All standard Python op
# constructors apply this function to each of their Tensor-valued
# inputs, which allows those ops to accept numpy arrays, Python lists,
# and scalars in addition to `Tensor` objects.
#
# Note: This function diverges from default Numpy behavior for `float` and
#   `string` types when `None` is present in a Python list or scalar. Rather
#   than silently converting `None` values, an error will be thrown.
#
# Args:
#   value: An object whose type has a registered `Tensor` conversion function.
#   dtype: Optional element type for the returned tensor. If missing, the type
#     is inferred from the type of `value`.
#   dtype_hint: Optional element type for the returned tensor, used when dtype
#     is None. In some cases, a caller may not have a dtype in mind when
#     converting to a tensor, so dtype_hint can be used as a soft preference.
#     If the conversion to `dtype_hint` is not possible, this argument has no
#     effect.
#   name: Optional name to use if a new `Tensor` is created.
#
# Returns:
#   A `Tensor` based on `value`.
#
# Raises:
#   TypeError: If no conversion function is registered for `value` to `dtype`.
#   RuntimeError: If a registered conversion function returns an invalid value.
#   ValueError: If the `value` is a tensor not of given `dtype` in graph mode.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
import pandas as pd
import numpy as np
import h5py
import tensorflow as tf
from tensorflow import keras
from keras.models import Sequential
from keras.layers import Dense
from keras.layers import Dropout
from keras.optimizers import Adam
from keras.optimizers import SGD
import matplotlib.pyplot as plt
from keras.models import load_model


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
train_df = pd.read_csv("../input/titanic/train.csv")
test_df = pd.read_csv("../input/titanic/test.csv")


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>3. Data Preparation | Feature Engineering</h1>  <a id='3'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u></summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.replace</u></summary>
# <blockquote>
# <code>
# Replace values given in `to_replace` with `value`.
#
# Values of the Series are replaced with other values dynamically.
#
# This differs from updating with ``.loc`` or ``.iloc``, which require
# you to specify a location to update with some value.
#
# Parameters
# ----------
# to_replace : str, regex, list, dict, Series, int, float, or None
#     How to find the values that will be replaced.
#
#     * numeric, str or regex:
#
#         - numeric: numeric values equal to `to_replace` will be
#           replaced with `value`
#         - str: string exactly matching `to_replace` will be replaced
#           with `value`
#         - regex: regexs matching `to_replace` will be replaced with
#           `value`
#
#     * list of str, regex, or numeric:
#
#         - First, if `to_replace` and `value` are both lists, they
#           **must** be the same length.
#         - Second, if ``regex=True`` then all of the strings in **both**
#           lists will be interpreted as regexs otherwise they will match
#           directly. This doesn't matter much for `value` since there
#           are only a few possible substitution regexes you can use.
#         - str, regex and numeric rules apply as above.
#
#     * dict:
#
#         - Dicts can be used to specify different replacement values
#           for different existing values. For example,
#           ``{'a': 'b', 'y': 'z'}`` replaces the value 'a' with 'b' and
#           'y' with 'z'. To use a dict in this way the `value`
#           parameter should be `None`.
#         - For a DataFrame a dict can specify that different values
#           should be replaced in different columns. For example,
#           ``{'a': 1, 'b': 'z'}`` looks for the value 1 in column 'a'
#           and the value 'z' in column 'b' and replaces these values
#           with whatever is specified in `value`. The `value` parameter
#           should not be ``None`` in this case. You can treat this as a
#           special case of passing two lists except that you are
#           specifying the column to search in.
#         - For a DataFrame nested dictionaries, e.g.,
#           ``{'a': {'b': np.nan}}``, are read as follows: look in column
#           'a' for the value 'b' and replace it with NaN. The `value`
#           parameter should be ``None`` to use a nested dict in this
#           way. You can nest regular expressions as well. Note that
#           column names (the top-level dictionary keys in a nested
#           dictionary) **cannot** be regular expressions.
#
#     * None:
#
#         - This means that the `regex` argument must be a string,
#           compiled regular expression, or list, dict, ndarray or
#           Series of such elements. If `value` is also ``None`` then
#           this **must** be a nested dictionary or Series.
#
#     See the examples section for examples of each of these.
# value : scalar, dict, list, str, regex, default None
#     Value to replace any values matching `to_replace` with.
#     For a DataFrame a dict of values can be used to specify which
#     value to use for each column (columns not in the dict will not be
#     filled). Regular expressions, strings and lists or dicts of such
#     objects are also allowed.
# inplace : bool, default False
#     If True, performs operation inplace and returns None.
# limit : int, default None
#     Maximum size gap to forward or backward fill.
# regex : bool or same types as `to_replace`, default False
#     Whether to interpret `to_replace` and/or `value` as regular
#     expressions. If this is ``True`` then `to_replace` *must* be a
#     string. Alternatively, this could be a regular expression or a
#     list, dict, or array of regular expressions in which case
#     `to_replace` must be ``None``.
# method : {'pad', 'ffill', 'bfill', `None`}
#     The method to use when for replacement, when `to_replace` is a
#     scalar, list or tuple and `value` is ``None``.
#
#     .. versionchanged:: 0.23.0
#         Added to DataFrame.
#
# Returns
# -------
# Series
#     Object after replacement.
#
# Raises
# ------
# AssertionError
#     * If `regex` is not a ``bool`` and `to_replace` is not
#       ``None``.
#
# TypeError
#     * If `to_replace` is not a scalar, array-like, ``dict``, or ``None``
#     * If `to_replace` is a ``dict`` and `value` is not a ``list``,
#       ``dict``, ``ndarray``, or ``Series``
#     * If `to_replace` is ``None`` and `regex` is not compilable
#       into a regular expression or is a list, dict, ndarray, or
#       Series.
#     * When replacing multiple ``bool`` or ``datetime64`` objects and
#       the arguments to `to_replace` does not match the type of the
#       value being replaced
#
# ValueError
#     * If a ``list`` or an ``ndarray`` is passed to `to_replace` and
#       `value` but they are not the same length.
#
# See Also
# --------
# Series.fillna : Fill NA values.
# Series.where : Replace values based on boolean condition.
# Series.str.replace : Simple string replacement.
#
# Notes
# -----
# * Regex substitution is performed under the hood with ``re.sub``. The
#   rules for substitution for ``re.sub`` are the same.
# * Regular expressions will only substitute on strings, meaning you
#   cannot provide, for example, a regular expression matching floating
#   point numbers and expect the columns in your frame that have a
#   numeric dtype to be matched. However, if those floating point
#   numbers *are* strings, then you can do this.
# * This method has *a lot* of options. You are encouraged to experiment
#   and play with this method to gain intuition about how it works.
# * When dict is used as the `to_replace` value, it is like
#   key(s) in the dict are the to_replace part and
#   value(s) in the dict are the value parameter.
#
# Examples
# --------
#
# **Scalar `to_replace` and `value`**
#
# >>> s = pd.Series([1, 2, 3, 4, 5])
# >>> s.replace(1, 5)
# 0    5
# 1    2
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# >>> df = pd.DataFrame({'A': [0, 1, 2, 3, 4],
# ...                    'B': [5, 6, 7, 8, 9],
# ...                    'C': ['a', 'b', 'c', 'd', 'e']})
# >>> df.replace(0, 5)
#     A  B  C
# 0  5  5  a
# 1  1  6  b
# 2  2  7  c
# 3  3  8  d
# 4  4  9  e
#
# **List-like `to_replace`**
#
# >>> df.replace([0, 1, 2, 3], 4)
#     A  B  C
# 0  4  5  a
# 1  4  6  b
# 2  4  7  c
# 3  4  8  d
# 4  4  9  e
#
# >>> df.replace([0, 1, 2, 3], [4, 3, 2, 1])
#     A  B  C
# 0  4  5  a
# 1  3  6  b
# 2  2  7  c
# 3  1  8  d
# 4  4  9  e
#
# >>> s.replace([1, 2], method='bfill')
# 0    3
# 1    3
# 2    3
# 3    4
# 4    5
# dtype: int64
#
# **dict-like `to_replace`**
#
# >>> df.replace({0: 10, 1: 100})
#         A  B  C
# 0   10  5  a
# 1  100  6  b
# 2    2  7  c
# 3    3  8  d
# 4    4  9  e
#
# >>> df.replace({'A': 0, 'B': 5}, 100)
#         A    B  C
# 0  100  100  a
# 1    1    6  b
# 2    2    7  c
# 3    3    8  d
# 4    4    9  e
#
# >>> df.replace({'A': {0: 100, 4: 400}})
#         A  B  C
# 0  100  5  a
# 1    1  6  b
# 2    2  7  c
# 3    3  8  d
# 4  400  9  e
#
# **Regular expression `to_replace`**
#
# >>> df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],
# ...                    'B': ['abc', 'bar', 'xyz']})
# >>> df.replace(to_replace=r'^ba.$', value='new', regex=True)
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)
#         A    B
# 0   new  abc
# 1   foo  bar
# 2  bait  xyz
#
# >>> df.replace(regex=r'^ba.$', value='new')
#         A    B
# 0   new  abc
# 1   foo  new
# 2  bait  xyz
#
# >>> df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})
#         A    B
# 0   new  abc
# 1   xyz  new
# 2  bait  xyz
#
# >>> df.replace(regex=[r'^ba.$', 'foo'], value='new')
#         A    B
# 0   new  abc
# 1   new  new
# 2  bait  xyz
#
# Compare the behavior of ``s.replace({'a': None})`` and
# ``s.replace('a', None)`` to understand the peculiarities
# of the `to_replace` parameter:
#
# >>> s = pd.Series([10, 'a', 'a', 'b', 'a'])
#
# When one uses a dict as the `to_replace` value, it is like the
# value(s) in the dict are equal to the `value` parameter.
# ``s.replace({'a': None})`` is equivalent to
# ``s.replace(to_replace={'a': None}, value=None, method=None)``:
#
# >>> s.replace({'a': None})
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
# When ``value`` is not explicitly passed and `to_replace` is a scalar, list
# or tuple, `replace` uses the method parameter (default 'pad') to do the
# replacement. So this is why the 'a' values are being replaced by 10
# in rows 1 and 2 and 'b' in row 4 in this case.
#
# >>> s.replace('a')
# 0    10
# 1    10
# 2    10
# 3     b
# 4     b
# dtype: object
#
# On the other hand, if ``None`` is explicitly passed for ``value``, it will
# be respected:
#
# >>> s.replace('a', None)
# 0      10
# 1    None
# 2    None
# 3       b
# 4    None
# dtype: object
#
#     .. versionchanged:: 1.4.0
#         Previously the explicit ``None`` was silently ignored.
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
train_df['Age'].fillna((train_df['Age'].mean()),inplace=True)

test_df['Age'].fillna((test_df['Age'].mean()),inplace=True)

train_df['Sex'] = train_df['Sex'].replace('male',value = 1)
train_df['Sex'] = train_df['Sex'].replace('female',value = 0)

test_df['Sex'] = test_df['Sex'].replace('male',value = 1)
test_df['Sex'] = test_df['Sex'].replace('female',value = 0)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Data Preparation</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.describe</u></summary>
# <blockquote>
# <code>
# Generate descriptive statistics.
#
# Descriptive statistics include those that summarize the central
# tendency, dispersion and shape of a
# dataset's distribution, excluding ``NaN`` values.
#
# Analyzes both numeric and object series, as well
# as ``DataFrame`` column sets of mixed data types. The output
# will vary depending on what is provided. Refer to the notes
# below for more detail.
#
# Parameters
# ----------
# percentiles : list-like of numbers, optional
#     The percentiles to include in the output. All should
#     fall between 0 and 1. The default is
#     ``[.25, .5, .75]``, which returns the 25th, 50th, and
#     75th percentiles.
# include : 'all', list-like of dtypes or None (default), optional
#     A white list of data types to include in the result. Ignored
#     for ``Series``. Here are the options:
#
#     - 'all' : All columns of the input will be included in the output.
#     - A list-like of dtypes : Limits the results to the
#       provided data types.
#       To limit the result to numeric types submit
#       ``numpy.number``. To limit it instead to object columns submit
#       the ``numpy.object`` data type. Strings
#       can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(include=['O'])``). To
#       select pandas categorical columns, use ``'category'``
#     - None (default) : The result will include all numeric columns.
# exclude : list-like of dtypes or None (default), optional,
#     A black list of data types to omit from the result. Ignored
#     for ``Series``. Here are the options:
#
#     - A list-like of dtypes : Excludes the provided data types
#       from the result. To exclude numeric types submit
#       ``numpy.number``. To exclude object columns submit the data
#       type ``numpy.object``. Strings can also be used in the style of
#       ``select_dtypes`` (e.g. ``df.describe(exclude=['O'])``). To
#       exclude pandas categorical columns, use ``'category'``
#     - None (default) : The result will exclude nothing.
# datetime_is_numeric : bool, default False
#     Whether to treat datetime dtypes as numeric. This affects statistics
#     calculated for the column. For DataFrame input, this also
#     controls whether datetime columns are included by default.
#
#     .. versionadded:: 1.1.0
#
# Returns
# -------
# Series or DataFrame
#     Summary statistics of the Series or Dataframe provided.
#
# See Also
# --------
# DataFrame.count: Count number of non-NA/null observations.
# DataFrame.max: Maximum of the values in the object.
# DataFrame.min: Minimum of the values in the object.
# DataFrame.mean: Mean of the values.
# DataFrame.std: Standard deviation of the observations.
# DataFrame.select_dtypes: Subset of a DataFrame including/excluding
#     columns based on their dtype.
#
# Notes
# -----
# For numeric data, the result's index will include ``count``,
# ``mean``, ``std``, ``min``, ``max`` as well as lower, ``50`` and
# upper percentiles. By default the lower percentile is ``25`` and the
# upper percentile is ``75``. The ``50`` percentile is the
# same as the median.
#
# For object data (e.g. strings or timestamps), the result's index
# will include ``count``, ``unique``, ``top``, and ``freq``. The ``top``
# is the most common value. The ``freq`` is the most common value's
# frequency. Timestamps also include the ``first`` and ``last`` items.
#
# If multiple object values have the highest count, then the
# ``count`` and ``top`` results will be arbitrarily chosen from
# among those with the highest count.
#
# For mixed data types provided via a ``DataFrame``, the default is to
# return only an analysis of numeric columns. If the dataframe consists
# only of object and categorical data without any numeric columns, the
# default is to return an analysis of both the object and categorical
# columns. If ``include='all'`` is provided as an option, the result
# will include a union of attributes of each type.
#
# The `include` and `exclude` parameters can be used to limit
# which columns in a ``DataFrame`` are analyzed for the output.
# The parameters are ignored when analyzing a ``Series``.
#
# Examples
# --------
# Describing a numeric ``Series``.
#
# >>> s = pd.Series([1, 2, 3])
# >>> s.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# dtype: float64
#
# Describing a categorical ``Series``.
#
# >>> s = pd.Series(['a', 'a', 'b', 'c'])
# >>> s.describe()
# count     4
# unique    3
# top       a
# freq      2
# dtype: object
#
# Describing a timestamp ``Series``.
#
# >>> s = pd.Series([
# ...   np.datetime64("2000-01-01"),
# ...   np.datetime64("2010-01-01"),
# ...   np.datetime64("2010-01-01")
# ... ])
# >>> s.describe(datetime_is_numeric=True)
# count                      3
# mean     2006-09-01 08:00:00
# min      2000-01-01 00:00:00
# 25%      2004-12-31 12:00:00
# 50%      2010-01-01 00:00:00
# 75%      2010-01-01 00:00:00
# max      2010-01-01 00:00:00
# dtype: object
#
# Describing a ``DataFrame``. By default only numeric fields
# are returned.
#
# >>> df = pd.DataFrame({'categorical': pd.Categorical(['d','e','f']),
# ...                    'numeric': [1, 2, 3],
# ...                    'object': ['a', 'b', 'c']
# ...                   })
# >>> df.describe()
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Describing all columns of a ``DataFrame`` regardless of data type.
#
# >>> df.describe(include='all')  # doctest: +SKIP
#        categorical  numeric object
# count            3      3.0      3
# unique           3      NaN      3
# top              f      NaN      a
# freq             1      NaN      1
# mean           NaN      2.0    NaN
# std            NaN      1.0    NaN
# min            NaN      1.0    NaN
# 25%            NaN      1.5    NaN
# 50%            NaN      2.0    NaN
# 75%            NaN      2.5    NaN
# max            NaN      3.0    NaN
#
# Describing a column from a ``DataFrame`` by accessing it as
# an attribute.
#
# >>> df.numeric.describe()
# count    3.0
# mean     2.0
# std      1.0
# min      1.0
# 25%      1.5
# 50%      2.0
# 75%      2.5
# max      3.0
# Name: numeric, dtype: float64
#
# Including only numeric columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[np.number])
#        numeric
# count      3.0
# mean       2.0
# std        1.0
# min        1.0
# 25%        1.5
# 50%        2.0
# 75%        2.5
# max        3.0
#
# Including only string columns in a ``DataFrame`` description.
#
# >>> df.describe(include=[object])  # doctest: +SKIP
#        object
# count       3
# unique      3
# top         a
# freq        1
#
# Including only categorical columns from a ``DataFrame`` description.
#
# >>> df.describe(include=['category'])
#        categorical
# count            3
# unique           3
# top              d
# freq             1
#
# Excluding numeric columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[np.number])  # doctest: +SKIP
#        categorical object
# count            3      3
# unique           3      3
# top              f      a
# freq             1      1
#
# Excluding object columns from a ``DataFrame`` description.
#
# >>> df.describe(exclude=[object])  # doctest: +SKIP
#        categorical  numeric
# count            3      3.0
# unique           3      NaN
# top              f      NaN
# freq             1      NaN
# mean           NaN      2.0
# std            NaN      1.0
# min            NaN      1.0
# 25%            NaN      1.5
# 50%            NaN      2.0
# 75%            NaN      2.5
# max            NaN      3.0
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
train_df.describe()

# %%
n_train = 700
X_train_class = train_df["Pclass"].values.reshape(-1,1)
X_train_sex = train_df["Sex"].values.reshape(-1,1)
X_train_age = train_df["Age"].values.reshape(-1,1)
X_train_sib = train_df["SibSp"].values.reshape(-1,1)
X_train_par = train_df["Parch"].values.reshape(-1,1)


y = train_df["Survived"].values.T


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>6. Data Preparation | Feature Engineering</h1>  <a id='6'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u></summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>tensorflow</h2>
# <ul>
# <li>
# <details><summary><u>tensorflow.python.framework.ops.convert_to_tensor_v2_with_dispatch</u></summary>
# <blockquote>
# <code>
# Converts the given `value` to a `Tensor`.
#
# This function converts Python objects of various types to `Tensor`
# objects. It accepts `Tensor` objects, numpy arrays, Python lists,
# and Python scalars.
#
# For example:
#
# >>> import numpy as np
# >>> def my_func(arg):
# ...   arg = tf.convert_to_tensor(arg, dtype=tf.float32)
# ...   return arg
#
# >>> # The following calls are equivalent.
# ...
# >>> value_1 = my_func(tf.constant([[1.0, 2.0], [3.0, 4.0]]))
# >>> print(value_1)
# tf.Tensor(
#   [[1. 2.]
#    [3. 4.]], shape=(2, 2), dtype=float32)
# >>> value_2 = my_func([[1.0, 2.0], [3.0, 4.0]])
# >>> print(value_2)
# tf.Tensor(
#   [[1. 2.]
#    [3. 4.]], shape=(2, 2), dtype=float32)
# >>> value_3 = my_func(np.array([[1.0, 2.0], [3.0, 4.0]], dtype=np.float32))
# >>> print(value_3)
# tf.Tensor(
#   [[1. 2.]
#    [3. 4.]], shape=(2, 2), dtype=float32)
#
# This function can be useful when composing a new operation in Python
# (such as `my_func` in the example above). All standard Python op
# constructors apply this function to each of their Tensor-valued
# inputs, which allows those ops to accept numpy arrays, Python lists,
# and scalars in addition to `Tensor` objects.
#
# Note: This function diverges from default Numpy behavior for `float` and
#   `string` types when `None` is present in a Python list or scalar. Rather
#   than silently converting `None` values, an error will be thrown.
#
# Args:
#   value: An object whose type has a registered `Tensor` conversion function.
#   dtype: Optional element type for the returned tensor. If missing, the type
#     is inferred from the type of `value`.
#   dtype_hint: Optional element type for the returned tensor, used when dtype
#     is None. In some cases, a caller may not have a dtype in mind when
#     converting to a tensor, so dtype_hint can be used as a soft preference.
#     If the conversion to `dtype_hint` is not possible, this argument has no
#     effect.
#   name: Optional name to use if a new `Tensor` is created.
#
# Returns:
#   A `Tensor` based on `value`.
#
# Raises:
#   TypeError: If no conversion function is registered for `value` to `dtype`.
#   RuntimeError: If a registered conversion function returns an invalid value.
#   ValueError: If the `value` is a tensor not of given `dtype` in graph mode.
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
X_train = np.hstack((X_train_sex[:n_train,:],X_train_class[:n_train,:],X_train_sib[:n_train,:],X_train_age[:n_train,:],X_train_par[:n_train,:]))
X_test = np.hstack((X_train_sex[n_train:,:],X_train_class[n_train:,:],X_train_sib[n_train:,:],X_train_age[n_train:,:],X_train_par[n_train:,:]))
X_train, X_test = tf.convert_to_tensor(X_train.astype(np.float64)),tf.convert_to_tensor(X_test.astype(np.float64))
y_train, y_test = y[:n_train], y[n_train:]


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>7. Model Building and Training</h1>  <a id='7'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
model = Sequential()
model.add(Dense(300,input_dim=5,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(150,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(100,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(50,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(25,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(1,activation='sigmoid'))
model.compile(loss='binary_crossentropy', optimizer=Adam(learning_rate=0.01,beta_1=0.99,beta_2=0.999), metrics=['accuracy'])


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>8. Model Building and Training</h1>  <a id='8'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
history = model.fit(X_train, y_train, validation_data=(X_test, y_test), epochs = 300, verbose = 0)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>9. Model Building and Training | Visualization</h1>  <a id='9'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u></summary>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
_, train_acc = model.evaluate(X_train, y_train, verbose=2)
_, test_acc = model.evaluate(X_test, y_test, verbose=2)
print('Train: %.3f, Test: %.3f' % (train_acc, test_acc))

plt.plot(history.history['accuracy'], label='train')
plt.plot(history.history['val_accuracy'], label='test')
plt.legend()
plt.show()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>10. Model Building and Training</h1>  <a id='10'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.save</u></summary>
# <blockquote>
# <code>
# Saves the model to Tensorflow SavedModel or a single HDF5 file.
#
# Please see `tf.keras.models.save_model` or the
# [Serialization and Saving guide](https://keras.io/guides/serialization_and_saving/)
# for details.
#
# Args:
#     filepath: String, PathLike, path to SavedModel or H5 file to save the
#         model.
#     overwrite: Whether to silently overwrite any existing file at the
#         target location, or provide the user with a manual prompt.
#     include_optimizer: If True, save optimizer's state together.
#     save_format: Either `'tf'` or `'h5'`, indicating whether to save the
#         model to Tensorflow SavedModel or HDF5. Defaults to 'tf' in TF 2.X,
#         and 'h5' in TF 1.X.
#     signatures: Signatures to save with the SavedModel. Applicable to the
#         'tf' format only. Please see the `signatures` argument in
#         `tf.saved_model.save` for details.
#     options: (only applies to SavedModel format)
#         `tf.saved_model.SaveOptions` object that specifies options for
#         saving to SavedModel.
#     save_traces: (only applies to SavedModel format) When enabled, the
#         SavedModel will store the function traces for each layer. This
#         can be disabled, so that only the configs of each layer are stored.
#         Defaults to `True`. Disabling this will decrease serialization time
#         and reduce file size, but it requires that all custom layers/models
#         implement a `get_config()` method.
#
# Example:
#
# ```python
# from keras.models import load_model
#
# model.save('my_model.h5')  # creates a HDF5 file 'my_model.h5'
# del model  # deletes the existing model
#
# returns a compiled model
# identical to the previous one
# model = load_model('my_model.h5')
# ```
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
model.save('model_' + str(1) + '.h5')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>11. Model Building and Training</h1>  <a id='11'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.saving.save.load_model</u></summary>
# <blockquote>
# <code>
# Loads a model saved via `model.save()`.
#
# Usage:
#
# >>> model = tf.keras.Sequential([
# ...     tf.keras.layers.Dense(5, input_shape=(3,)),
# ...     tf.keras.layers.Softmax()])
# >>> model.save('/tmp/model')
# >>> loaded_model = tf.keras.models.load_model('/tmp/model')
# >>> x = tf.random.uniform((10, 3))
# >>> assert np.allclose(model.predict(x), loaded_model.predict(x))
#
# Note that the model weights may have different scoped names after being
# loaded. Scoped names include the model/layer names, such as
# `"dense_1/kernel:0"`. It is recommended that you use the layer properties to
# access specific variables, e.g. `model.get_layer("dense_1").kernel`.
#
# Args:
#     filepath: One of the following:
#         - String or `pathlib.Path` object, path to the saved model
#         - `h5py.File` object from which to load the model
#     custom_objects: Optional dictionary mapping names
#         (strings) to custom classes or functions to be
#         considered during deserialization.
#     compile: Boolean, whether to compile the model
#         after loading.
#     options: Optional `tf.saved_model.LoadOptions` object that specifies
#       options for loading from SavedModel.
#
# Returns:
#     A Keras model instance. If the original model was compiled, and saved with
#     the optimizer, then the returned model will be compiled. Otherwise, the
#     model will be left uncompiled. In the case that an uncompiled model is
#     returned, a warning is displayed if the `compile` argument is set to
#     `True`.
#
# Raises:
#     ImportError: if loading from an hdf5 file and h5py is not available.
#     IOError: In case of an invalid savefile.
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
model = load_model("./model_1.h5")
model.summary()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>12. Data Preparation | Feature Engineering</h1>  <a id='12'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.hstack</u></summary>
# <blockquote>
# <code>
# Stack arrays in sequence horizontally (column wise).
#
# This is equivalent to concatenation along the second axis, except for 1-D
# arrays where it concatenates along the first axis. Rebuilds arrays divided
# by `hsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the second axis,
#     except 1-D arrays which can be any length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# hsplit : Split an array into multiple sub-arrays horizontally (column-wise).
#
# Examples
# --------
# >>> a = np.array((1,2,3))
# >>> b = np.array((4,5,6))
# >>> np.hstack((a,b))
# array([1, 2, 3, 4, 5, 6])
# >>> a = np.array([[1],[2],[3]])
# >>> b = np.array([[4],[5],[6]])
# >>> np.hstack((a,b))
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
X_test_class = test_df["Pclass"].values.reshape(-1,1)
X_test_sex = test_df["Sex"].values.reshape(-1,1)
X_test_age = test_df["Age"].values.reshape(-1,1)
X_test_sib = test_df["SibSp"].values.reshape(-1,1)
X_test_par = test_df["Parch"].values.reshape(-1,1)

x_test = np.hstack((X_test_sex,X_test_class,X_test_sib,X_test_age,X_test_par)).astype(np.float64)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>13. Data Preparation | Model Building and Training</h1>  <a id='13'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.ravel</u></summary>
# <blockquote>
# <code>
# a.ravel([order])
#
# Return a flattened array.
#
# Refer to `numpy.ravel` for full documentation.
#
# See Also
# --------
# numpy.ravel : equivalent function
#
# ndarray.flat : a flat iterator on the array.
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.tolist</u></summary>
# <blockquote>
# <code>
# a.tolist()
#
# Return the array as an ``a.ndim``-levels deep nested list of Python scalars.
#
# Return a copy of the array data as a (nested) Python list.
# Data items are converted to the nearest compatible builtin Python type, via
# the `~numpy.ndarray.item` function.
#
# If ``a.ndim`` is 0, then since the depth of the nested list is 0, it will
# not be a list at all, but a simple Python scalar.
#
# Parameters
# ----------
# none
#
# Returns
# -------
# y : object, or list of object, or list of list of object, or ...
#     The possibly nested list of array elements.
#
# Notes
# -----
# The array may be recreated via ``a = np.array(a.tolist())``, although this
# may sometimes lose precision.
#
# Examples
# --------
# For a 1D array, ``a.tolist()`` is almost the same as ``list(a)``,
# except that ``tolist`` changes numpy scalars to Python scalars:
#
# >>> a = np.uint32([1, 2])
# >>> a_list = list(a)
# >>> a_list
# [1, 2]
# >>> type(a_list[0])
# <class 'numpy.uint32'>
# >>> a_tolist = a.tolist()
# >>> a_tolist
# [1, 2]
# >>> type(a_tolist[0])
# <class 'int'>
#
# Additionally, for a 2D array, ``tolist`` applies recursively:
#
# >>> a = np.array([[1, 2], [3, 4]])
# >>> list(a)
# [array([1, 2]), array([3, 4])]
# >>> a.tolist()
# [[1, 2], [3, 4]]
#
# The base case for this recursion is a 0D array:
#
# >>> a = np.array(1)
# >>> list(a)
# Traceback (most recent call last):
#   ...
# TypeError: iteration over a 0-d array
# >>> a.tolist()
# 1
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
y_pred =[]
prediction = model.predict(x_test).ravel().tolist()
y_pred += prediction

# %%
for i in range(0,len(y_pred)):
    if y_pred[i] > 0.8:
        y_pred[i] = 1
    else:
        y_pred[i] = 0


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>15. Data Preparation</h1>  <a id='15'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#15'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#15'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
submission = pd.read_csv('../input/titanic/gender_submission.csv')
submission['Survived'] = y_pred
submission.to_csv('submission.csv',index=False)

# %%
