# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>csv</b></li>
# <li><b>keras</b></li>
# <li><b>matplotlib</b></li>
# <li><b>numpy</b></li>
# <li><b>os</b></li>
# <li><b>pandas</b></li>
# <li><b>re</b></li>
# <li><b>scipy</b></li>
# <li><b>seaborn</b></li>
# <li><b>sklearn</b></li>
# <li><b>warnings</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Visualization</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Visualization" Calls</u></b></summary>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['(Test data) Number of Survived classes'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.subplots</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a figure and a set of subplots.
#
# This utility wrapper makes it convenient to create common layouts of
# subplots, including the enclosing figure object, in a single call.
#
# Parameters
# ----------
# nrows, ncols : int, default: 1
#     Number of rows/columns of the subplot grid.
#
# sharex, sharey : bool or {'none', 'all', 'row', 'col'}, default: False
#     Controls sharing of properties among x (*sharex*) or y (*sharey*)
#     axes:
#
#     - True or 'all': x- or y-axis will be shared among all subplots.
#     - False or 'none': each subplot x- or y-axis will be independent.
#     - 'row': each subplot row will share an x- or y-axis.
#     - 'col': each subplot column will share an x- or y-axis.
#
#     When subplots have a shared x-axis along a column, only the x tick
#     labels of the bottom subplot are created. Similarly, when subplots
#     have a shared y-axis along a row, only the y tick labels of the first
#     column subplot are created. To later turn other subplots' ticklabels
#     on, use `~matplotlib.axes.Axes.tick_params`.
#
#     When subplots have a shared axis that has units, calling
#     `~matplotlib.axis.Axis.set_units` will update each axis with the
#     new units.
#
# squeeze : bool, default: True
#     - If True, extra dimensions are squeezed out from the returned
#       array of `~matplotlib.axes.Axes`:
#
#       - if only one subplot is constructed (nrows=ncols=1), the
#         resulting single Axes object is returned as a scalar.
#       - for Nx1 or 1xM subplots, the returned object is a 1D numpy
#         object array of Axes objects.
#       - for NxM, subplots with N>1 and M>1 are returned as a 2D array.
#
#     - If False, no squeezing at all is done: the returned Axes object is
#       always a 2D array containing Axes instances, even if it ends up
#       being 1x1.
#
# subplot_kw : dict, optional
#     Dict with keywords passed to the
#     `~matplotlib.figure.Figure.add_subplot` call used to create each
#     subplot.
#
# gridspec_kw : dict, optional
#     Dict with keywords passed to the `~matplotlib.gridspec.GridSpec`
#     constructor used to create the grid the subplots are placed on.
#
# **fig_kw
#     All additional keyword arguments are passed to the
#     `.pyplot.figure` call.
#
# Returns
# -------
# fig : `~.figure.Figure`
#
# ax : `.axes.Axes` or array of Axes
#     *ax* can be either a single `~matplotlib.axes.Axes` object or an
#     array of Axes objects if more than one subplot was created.  The
#     dimensions of the resulting array can be controlled with the squeeze
#     keyword, see above.
#
#     Typical idioms for handling the return value are::
#
#         # using the variable ax for single a Axes
#         fig, ax = plt.subplots()
#
#         # using the variable axs for multiple Axes
#         fig, axs = plt.subplots(2, 2)
#
#         # using tuple unpacking for multiple Axes
#         fig, (ax1, ax2) = plt.subplots(1, 2)
#         fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2)
#
#     The names ``ax`` and pluralized ``axs`` are preferred over ``axes``
#     because for the latter it's not clear if it refers to a single
#     `~.axes.Axes` instance or a collection of these.
#
# See Also
# --------
# .pyplot.figure
# .pyplot.subplot
# .pyplot.axes
# .Figure.subplots
# .Figure.add_subplot
#
# Examples
# --------
# ::
#
#     # First create some toy data:
#     x = np.linspace(0, 2*np.pi, 400)
#     y = np.sin(x**2)
#
#     # Create just a figure and only one subplot
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#     ax.set_title('Simple plot')
#
#     # Create two subplots and unpack the output array immediately
#     f, (ax1, ax2) = plt.subplots(1, 2, sharey=True)
#     ax1.plot(x, y)
#     ax1.set_title('Sharing Y axis')
#     ax2.scatter(x, y)
#
#     # Create four polar axes and access them through the returned array
#     fig, axs = plt.subplots(2, 2, subplot_kw=dict(projection="polar"))
#     axs[0, 0].plot(x, y)
#     axs[1, 1].scatter(x, y)
#
#     # Share a X axis with each column of subplots
#     plt.subplots(2, 2, sharex='col')
#
#     # Share a Y axis with each row of subplots
#     plt.subplots(2, 2, sharey='row')
#
#     # Share both X and Y axes with all subplots
#     plt.subplots(2, 2, sharex='all', sharey='all')
#
#     # Note that this is the same as
#     plt.subplots(2, 2, sharex=True, sharey=True)
#
#     # Create figure number 10 with a single subplot
#     # and clears it if it already exists.
#     fig, ax = plt.subplots(num=10, clear=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'palette': 'icefire'}</li></ul>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.confusion_matrix</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute confusion matrix to evaluate the accuracy of a classification.
#
# By definition a confusion matrix :math:`C` is such that :math:`C_{i, j}`
# is equal to the number of observations known to be in group :math:`i` and
# predicted to be in group :math:`j`.
#
# Thus in binary classification, the count of true negatives is
# :math:`C_{0,0}`, false negatives is :math:`C_{1,0}`, true positives is
# :math:`C_{1,1}` and false positives is :math:`C_{0,1}`.
#
# Read more in the :ref:`User Guide <confusion_matrix>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,)
#     Ground truth (correct) target values.
#
# y_pred : array-like of shape (n_samples,)
#     Estimated targets as returned by a classifier.
#
# labels : array-like of shape (n_classes), default=None
#     List of labels to index the matrix. This may be used to reorder
#     or select a subset of labels.
#     If ``None`` is given, those that appear at least once
#     in ``y_true`` or ``y_pred`` are used in sorted order.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
#     .. versionadded:: 0.18
#
# normalize : {'true', 'pred', 'all'}, default=None
#     Normalizes confusion matrix over the true (rows), predicted (columns)
#     conditions or all the population. If None, confusion matrix will not be
#     normalized.
#
# Returns
# -------
# C : ndarray of shape (n_classes, n_classes)
#     Confusion matrix whose i-th row and j-th
#     column entry indicates the number of
#     samples with true label being i-th class
#     and predicted label being j-th class.
#
# See Also
# --------
# ConfusionMatrixDisplay.from_estimator : Plot the confusion matrix
#     given an estimator, the data, and the label.
# ConfusionMatrixDisplay.from_predictions : Plot the confusion matrix
#     given the true and predicted labels.
# ConfusionMatrixDisplay : Confusion Matrix visualization.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Confusion matrix
#        <https://en.wikipedia.org/wiki/Confusion_matrix>`_
#        (Wikipedia and other references may use a different
#        convention for axes).
#
# Examples
# --------
# >>> from sklearn.metrics import confusion_matrix
# >>> y_true = [2, 0, 2, 2, 0, 1]
# >>> y_pred = [0, 0, 2, 2, 0, 2]
# >>> confusion_matrix(y_true, y_pred)
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# >>> y_true = ["cat", "ant", "cat", "cat", "ant", "bird"]
# >>> y_pred = ["ant", "ant", "cat", "cat", "ant", "cat"]
# >>> confusion_matrix(y_true, y_pred, labels=["ant", "bird", "cat"])
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# In the binary case, we can extract true positives, etc as follows:
#
# >>> tn, fp, fn, tp = confusion_matrix([0, 1, 0, 1], [1, 1, 1, 0]).ravel()
# >>> (tn, fp, fn, tp)
# (0, 2, 1, 1)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'palette': 'icefire'}</li></ul>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 8</u></h3></summary><small><a href=#8>goto cell # 8</a></small>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Number of Survived classes'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'palette': 'icefire'}</li></ul>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 11</u></h3></summary><small><a href=#11>goto cell # 11</a></small>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'color': 'b', 'label': 'validation loss'}</li></ul>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Number of Epochs'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Loss'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.confusion_matrix</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute confusion matrix to evaluate the accuracy of a classification.
#
# By definition a confusion matrix :math:`C` is such that :math:`C_{i, j}`
# is equal to the number of observations known to be in group :math:`i` and
# predicted to be in group :math:`j`.
#
# Thus in binary classification, the count of true negatives is
# :math:`C_{0,0}`, false negatives is :math:`C_{1,0}`, true positives is
# :math:`C_{1,1}` and false positives is :math:`C_{0,1}`.
#
# Read more in the :ref:`User Guide <confusion_matrix>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,)
#     Ground truth (correct) target values.
#
# y_pred : array-like of shape (n_samples,)
#     Estimated targets as returned by a classifier.
#
# labels : array-like of shape (n_classes), default=None
#     List of labels to index the matrix. This may be used to reorder
#     or select a subset of labels.
#     If ``None`` is given, those that appear at least once
#     in ``y_true`` or ``y_pred`` are used in sorted order.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
#     .. versionadded:: 0.18
#
# normalize : {'true', 'pred', 'all'}, default=None
#     Normalizes confusion matrix over the true (rows), predicted (columns)
#     conditions or all the population. If None, confusion matrix will not be
#     normalized.
#
# Returns
# -------
# C : ndarray of shape (n_classes, n_classes)
#     Confusion matrix whose i-th row and j-th
#     column entry indicates the number of
#     samples with true label being i-th class
#     and predicted label being j-th class.
#
# See Also
# --------
# ConfusionMatrixDisplay.from_estimator : Plot the confusion matrix
#     given an estimator, the data, and the label.
# ConfusionMatrixDisplay.from_predictions : Plot the confusion matrix
#     given the true and predicted labels.
# ConfusionMatrixDisplay : Confusion Matrix visualization.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Confusion matrix
#        <https://en.wikipedia.org/wiki/Confusion_matrix>`_
#        (Wikipedia and other references may use a different
#        convention for axes).
#
# Examples
# --------
# >>> from sklearn.metrics import confusion_matrix
# >>> y_true = [2, 0, 2, 2, 0, 1]
# >>> y_pred = [0, 0, 2, 2, 0, 2]
# >>> confusion_matrix(y_true, y_pred)
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# >>> y_true = ["cat", "ant", "cat", "cat", "ant", "bird"]
# >>> y_pred = ["ant", "ant", "cat", "cat", "ant", "cat"]
# >>> confusion_matrix(y_true, y_pred, labels=["ant", "bird", "cat"])
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# In the binary case, we can extract true positives, etc as follows:
#
# >>> tn, fp, fn, tp = confusion_matrix([0, 1, 0, 1], [1, 1, 1, 0]).ravel()
# >>> (tn, fp, fn, tp)
# (0, 2, 1, 1)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.subplots</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a figure and a set of subplots.
#
# This utility wrapper makes it convenient to create common layouts of
# subplots, including the enclosing figure object, in a single call.
#
# Parameters
# ----------
# nrows, ncols : int, default: 1
#     Number of rows/columns of the subplot grid.
#
# sharex, sharey : bool or {'none', 'all', 'row', 'col'}, default: False
#     Controls sharing of properties among x (*sharex*) or y (*sharey*)
#     axes:
#
#     - True or 'all': x- or y-axis will be shared among all subplots.
#     - False or 'none': each subplot x- or y-axis will be independent.
#     - 'row': each subplot row will share an x- or y-axis.
#     - 'col': each subplot column will share an x- or y-axis.
#
#     When subplots have a shared x-axis along a column, only the x tick
#     labels of the bottom subplot are created. Similarly, when subplots
#     have a shared y-axis along a row, only the y tick labels of the first
#     column subplot are created. To later turn other subplots' ticklabels
#     on, use `~matplotlib.axes.Axes.tick_params`.
#
#     When subplots have a shared axis that has units, calling
#     `~matplotlib.axis.Axis.set_units` will update each axis with the
#     new units.
#
# squeeze : bool, default: True
#     - If True, extra dimensions are squeezed out from the returned
#       array of `~matplotlib.axes.Axes`:
#
#       - if only one subplot is constructed (nrows=ncols=1), the
#         resulting single Axes object is returned as a scalar.
#       - for Nx1 or 1xM subplots, the returned object is a 1D numpy
#         object array of Axes objects.
#       - for NxM, subplots with N>1 and M>1 are returned as a 2D array.
#
#     - If False, no squeezing at all is done: the returned Axes object is
#       always a 2D array containing Axes instances, even if it ends up
#       being 1x1.
#
# subplot_kw : dict, optional
#     Dict with keywords passed to the
#     `~matplotlib.figure.Figure.add_subplot` call used to create each
#     subplot.
#
# gridspec_kw : dict, optional
#     Dict with keywords passed to the `~matplotlib.gridspec.GridSpec`
#     constructor used to create the grid the subplots are placed on.
#
# **fig_kw
#     All additional keyword arguments are passed to the
#     `.pyplot.figure` call.
#
# Returns
# -------
# fig : `~.figure.Figure`
#
# ax : `.axes.Axes` or array of Axes
#     *ax* can be either a single `~matplotlib.axes.Axes` object or an
#     array of Axes objects if more than one subplot was created.  The
#     dimensions of the resulting array can be controlled with the squeeze
#     keyword, see above.
#
#     Typical idioms for handling the return value are::
#
#         # using the variable ax for single a Axes
#         fig, ax = plt.subplots()
#
#         # using the variable axs for multiple Axes
#         fig, axs = plt.subplots(2, 2)
#
#         # using tuple unpacking for multiple Axes
#         fig, (ax1, ax2) = plt.subplots(1, 2)
#         fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2)
#
#     The names ``ax`` and pluralized ``axs`` are preferred over ``axes``
#     because for the latter it's not clear if it refers to a single
#     `~.axes.Axes` instance or a collection of these.
#
# See Also
# --------
# .pyplot.figure
# .pyplot.subplot
# .pyplot.axes
# .Figure.subplots
# .Figure.add_subplot
#
# Examples
# --------
# ::
#
#     # First create some toy data:
#     x = np.linspace(0, 2*np.pi, 400)
#     y = np.sin(x**2)
#
#     # Create just a figure and only one subplot
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#     ax.set_title('Simple plot')
#
#     # Create two subplots and unpack the output array immediately
#     f, (ax1, ax2) = plt.subplots(1, 2, sharey=True)
#     ax1.plot(x, y)
#     ax1.set_title('Sharing Y axis')
#     ax2.scatter(x, y)
#
#     # Create four polar axes and access them through the returned array
#     fig, axs = plt.subplots(2, 2, subplot_kw=dict(projection="polar"))
#     axs[0, 0].plot(x, y)
#     axs[1, 1].scatter(x, y)
#
#     # Share a X axis with each column of subplots
#     plt.subplots(2, 2, sharex='col')
#
#     # Share a Y axis with each row of subplots
#     plt.subplots(2, 2, sharey='row')
#
#     # Share both X and Y axes with all subplots
#     plt.subplots(2, 2, sharex='all', sharey='all')
#
#     # Note that this is the same as
#     plt.subplots(2, 2, sharex=True, sharey=True)
#
#     # Create figure number 10 with a single subplot
#     # and clears it if it already exists.
#     fig, ax = plt.subplots(num=10, clear=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Predicted Label'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['True Label'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Confusion Matrix'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'annot': True, 'linewidths': 0.01, 'cmap': 'Greens', 'linecolor': 'gray', 'fmt': '.1f'}</li></ul>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 15</u></h3></summary><small><a href=#15>goto cell # 15</a></small>
# <ul>
#
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'palette': 'icefire'}</li></ul>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 16</u></h3></summary><small><a href=#16>goto cell # 16</a></small>
# <ul>
#
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['(Test data) Number of Survived classes'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'palette': 'icefire'}</li></ul>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 16</u></h3></summary><small><a href=#16>goto cell # 16</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.info</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Print a concise summary of a DataFrame.
#
# This method prints information about a DataFrame including
# the index dtype and columns, non-null values and memory usage.
#
# Parameters
# ----------
# data : DataFrame
#     DataFrame to print information about.
# verbose : bool, optional
#     Whether to print the full summary. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is followed.
# buf : writable buffer, defaults to sys.stdout
#     Where to send the output. By default, the output is printed to
#     sys.stdout. Pass a writable buffer if you need to further process
#     the output.    max_cols : int, optional
#     When to switch from the verbose to the truncated output. If the
#     DataFrame has more than `max_cols` columns, the truncated output
#     is used. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is used.
# memory_usage : bool, str, optional
#     Specifies whether total memory usage of the DataFrame
#     elements (including the index) should be displayed. By default,
#     this follows the ``pandas.options.display.memory_usage`` setting.
#
#     True always show memory usage. False never shows memory usage.
#     A value of 'deep' is equivalent to "True with deep introspection".
#     Memory usage is shown in human-readable units (base-2
#     representation). Without deep introspection a memory estimation is
#     made based in column dtype and number of rows assuming values
#     consume the same memory amount for corresponding dtypes. With deep
#     memory introspection, a real memory usage calculation is performed
#     at the cost of computational resources.
# show_counts : bool, optional
#     Whether to show the non-null counts. By default, this is shown
#     only if the DataFrame is smaller than
#     ``pandas.options.display.max_info_rows`` and
#     ``pandas.options.display.max_info_columns``. A value of True always
#     shows the counts, and False never shows the counts.
# null_counts : bool, optional
#     .. deprecated:: 1.2.0
#         Use show_counts instead.
#
# Returns
# -------
# None
#     This method prints a summary of a DataFrame and returns None.
#
# See Also
# --------
# DataFrame.describe: Generate descriptive statistics of DataFrame
#     columns.
# DataFrame.memory_usage: Memory usage of DataFrame columns.
#
# Examples
# --------
# >>> int_values = [1, 2, 3, 4, 5]
# >>> text_values = ['alpha', 'beta', 'gamma', 'delta', 'epsilon']
# >>> float_values = [0.0, 0.25, 0.5, 0.75, 1.0]
# >>> df = pd.DataFrame({"int_col": int_values, "text_col": text_values,
# ...                   "float_col": float_values})
# >>> df
#     int_col text_col  float_col
# 0        1    alpha       0.00
# 1        2     beta       0.25
# 2        3    gamma       0.50
# 3        4    delta       0.75
# 4        5  epsilon       1.00
#
# Prints information of all columns:
#
# >>> df.info(verbose=True)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Data columns (total 3 columns):
#  #   Column     Non-Null Count  Dtype
# ---  ------     --------------  -----
#  0   int_col    5 non-null      int64
#  1   text_col   5 non-null      object
#  2   float_col  5 non-null      float64
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Prints a summary of columns count and its dtypes but not per column
# information:
#
# >>> df.info(verbose=False)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Columns: 3 entries, int_col to float_col
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Pipe output of DataFrame.info to buffer instead of sys.stdout, get
# buffer content and writes to a text file:
#
# >>> import io
# >>> buffer = io.StringIO()
# >>> df.info(buf=buffer)
# >>> s = buffer.getvalue()
# >>> with open("df_info.txt", "w",
# ...           encoding="utf-8") as f:  # doctest: +SKIP
# ...     f.write(s)
# 260
#
# The `memory_usage` parameter allows deep introspection mode, specially
# useful for big DataFrames and fine-tune memory optimization:
#
# >>> random_strings_array = np.random.choice(['a', 'b', 'c'], 10 ** 6)
# >>> df = pd.DataFrame({
# ...     'column_1': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_2': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_3': np.random.choice(['a', 'b', 'c'], 10 ** 6)
# ... })
# >>> df.info()
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 22.9+ MB
#
# >>> df.info(memory_usage='deep')
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 165.9 MB
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 2</u></h3></summary><small><a href=#2>goto cell # 2</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.info</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Print a concise summary of a DataFrame.
#
# This method prints information about a DataFrame including
# the index dtype and columns, non-null values and memory usage.
#
# Parameters
# ----------
# data : DataFrame
#     DataFrame to print information about.
# verbose : bool, optional
#     Whether to print the full summary. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is followed.
# buf : writable buffer, defaults to sys.stdout
#     Where to send the output. By default, the output is printed to
#     sys.stdout. Pass a writable buffer if you need to further process
#     the output.    max_cols : int, optional
#     When to switch from the verbose to the truncated output. If the
#     DataFrame has more than `max_cols` columns, the truncated output
#     is used. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is used.
# memory_usage : bool, str, optional
#     Specifies whether total memory usage of the DataFrame
#     elements (including the index) should be displayed. By default,
#     this follows the ``pandas.options.display.memory_usage`` setting.
#
#     True always show memory usage. False never shows memory usage.
#     A value of 'deep' is equivalent to "True with deep introspection".
#     Memory usage is shown in human-readable units (base-2
#     representation). Without deep introspection a memory estimation is
#     made based in column dtype and number of rows assuming values
#     consume the same memory amount for corresponding dtypes. With deep
#     memory introspection, a real memory usage calculation is performed
#     at the cost of computational resources.
# show_counts : bool, optional
#     Whether to show the non-null counts. By default, this is shown
#     only if the DataFrame is smaller than
#     ``pandas.options.display.max_info_rows`` and
#     ``pandas.options.display.max_info_columns``. A value of True always
#     shows the counts, and False never shows the counts.
# null_counts : bool, optional
#     .. deprecated:: 1.2.0
#         Use show_counts instead.
#
# Returns
# -------
# None
#     This method prints a summary of a DataFrame and returns None.
#
# See Also
# --------
# DataFrame.describe: Generate descriptive statistics of DataFrame
#     columns.
# DataFrame.memory_usage: Memory usage of DataFrame columns.
#
# Examples
# --------
# >>> int_values = [1, 2, 3, 4, 5]
# >>> text_values = ['alpha', 'beta', 'gamma', 'delta', 'epsilon']
# >>> float_values = [0.0, 0.25, 0.5, 0.75, 1.0]
# >>> df = pd.DataFrame({"int_col": int_values, "text_col": text_values,
# ...                   "float_col": float_values})
# >>> df
#     int_col text_col  float_col
# 0        1    alpha       0.00
# 1        2     beta       0.25
# 2        3    gamma       0.50
# 3        4    delta       0.75
# 4        5  epsilon       1.00
#
# Prints information of all columns:
#
# >>> df.info(verbose=True)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Data columns (total 3 columns):
#  #   Column     Non-Null Count  Dtype
# ---  ------     --------------  -----
#  0   int_col    5 non-null      int64
#  1   text_col   5 non-null      object
#  2   float_col  5 non-null      float64
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Prints a summary of columns count and its dtypes but not per column
# information:
#
# >>> df.info(verbose=False)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Columns: 3 entries, int_col to float_col
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Pipe output of DataFrame.info to buffer instead of sys.stdout, get
# buffer content and writes to a text file:
#
# >>> import io
# >>> buffer = io.StringIO()
# >>> df.info(buf=buffer)
# >>> s = buffer.getvalue()
# >>> with open("df_info.txt", "w",
# ...           encoding="utf-8") as f:  # doctest: +SKIP
# ...     f.write(s)
# 260
#
# The `memory_usage` parameter allows deep introspection mode, specially
# useful for big DataFrames and fine-tune memory optimization:
#
# >>> random_strings_array = np.random.choice(['a', 'b', 'c'], 10 ** 6)
# >>> df = pd.DataFrame({
# ...     'column_1': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_2': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_3': np.random.choice(['a', 'b', 'c'], 10 ** 6)
# ... })
# >>> df.info()
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 22.9+ MB
#
# >>> df.info(memory_usage='deep')
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 165.9 MB
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['PassengerId']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Sub-sampling and Train-test Splitting</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Sub-sampling and Train-test Splitting" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'test_size': 0.1, 'random_state': 2}</li></ul>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'test_size': 0.1, 'random_state': 2}</li></ul>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 16</u></h3></summary><small><a href=#16>goto cell # 16</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Feature Selection</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Selection" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 3</u></h3></summary><small><a href=#3>goto cell # 3</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['PassengerId']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 128, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 64, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 32, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 16, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 1, 'kernel_initializer': 'uniform', 'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.3] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'lr': 0.001, 'beta_1': 0.9, 'beta_2': 0.999}</li></ul>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'loss': 'binary_crossentropy', 'metrics': ['accuracy']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'batch_size': 32, 'epochs': 300}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 128, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 64, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 32, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 16, 'kernel_initializer': 'uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 1, 'kernel_initializer': 'uniform', 'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.3] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'lr': 0.001, 'beta_1': 0.9, 'beta_2': 0.999}</li></ul>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'loss': 'binary_crossentropy', 'metrics': ['accuracy']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'batch_size': 32, 'epochs': 300}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.confusion_matrix</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute confusion matrix to evaluate the accuracy of a classification.
#
# By definition a confusion matrix :math:`C` is such that :math:`C_{i, j}`
# is equal to the number of observations known to be in group :math:`i` and
# predicted to be in group :math:`j`.
#
# Thus in binary classification, the count of true negatives is
# :math:`C_{0,0}`, false negatives is :math:`C_{1,0}`, true positives is
# :math:`C_{1,1}` and false positives is :math:`C_{0,1}`.
#
# Read more in the :ref:`User Guide <confusion_matrix>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,)
#     Ground truth (correct) target values.
#
# y_pred : array-like of shape (n_samples,)
#     Estimated targets as returned by a classifier.
#
# labels : array-like of shape (n_classes), default=None
#     List of labels to index the matrix. This may be used to reorder
#     or select a subset of labels.
#     If ``None`` is given, those that appear at least once
#     in ``y_true`` or ``y_pred`` are used in sorted order.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
#     .. versionadded:: 0.18
#
# normalize : {'true', 'pred', 'all'}, default=None
#     Normalizes confusion matrix over the true (rows), predicted (columns)
#     conditions or all the population. If None, confusion matrix will not be
#     normalized.
#
# Returns
# -------
# C : ndarray of shape (n_classes, n_classes)
#     Confusion matrix whose i-th row and j-th
#     column entry indicates the number of
#     samples with true label being i-th class
#     and predicted label being j-th class.
#
# See Also
# --------
# ConfusionMatrixDisplay.from_estimator : Plot the confusion matrix
#     given an estimator, the data, and the label.
# ConfusionMatrixDisplay.from_predictions : Plot the confusion matrix
#     given the true and predicted labels.
# ConfusionMatrixDisplay : Confusion Matrix visualization.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Confusion matrix
#        <https://en.wikipedia.org/wiki/Confusion_matrix>`_
#        (Wikipedia and other references may use a different
#        convention for axes).
#
# Examples
# --------
# >>> from sklearn.metrics import confusion_matrix
# >>> y_true = [2, 0, 2, 2, 0, 1]
# >>> y_pred = [0, 0, 2, 2, 0, 2]
# >>> confusion_matrix(y_true, y_pred)
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# >>> y_true = ["cat", "ant", "cat", "cat", "ant", "bird"]
# >>> y_pred = ["ant", "ant", "cat", "cat", "ant", "cat"]
# >>> confusion_matrix(y_true, y_pred, labels=["ant", "bird", "cat"])
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# In the binary case, we can extract true positives, etc as follows:
#
# >>> tn, fp, fn, tp = confusion_matrix([0, 1, 0, 1], [1, 1, 1, 0]).ravel()
# >>> (tn, fp, fn, tp)
# (0, 2, 1, 1)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'verbose': 0}</li></ul>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.confusion_matrix</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute confusion matrix to evaluate the accuracy of a classification.
#
# By definition a confusion matrix :math:`C` is such that :math:`C_{i, j}`
# is equal to the number of observations known to be in group :math:`i` and
# predicted to be in group :math:`j`.
#
# Thus in binary classification, the count of true negatives is
# :math:`C_{0,0}`, false negatives is :math:`C_{1,0}`, true positives is
# :math:`C_{1,1}` and false positives is :math:`C_{0,1}`.
#
# Read more in the :ref:`User Guide <confusion_matrix>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,)
#     Ground truth (correct) target values.
#
# y_pred : array-like of shape (n_samples,)
#     Estimated targets as returned by a classifier.
#
# labels : array-like of shape (n_classes), default=None
#     List of labels to index the matrix. This may be used to reorder
#     or select a subset of labels.
#     If ``None`` is given, those that appear at least once
#     in ``y_true`` or ``y_pred`` are used in sorted order.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
#     .. versionadded:: 0.18
#
# normalize : {'true', 'pred', 'all'}, default=None
#     Normalizes confusion matrix over the true (rows), predicted (columns)
#     conditions or all the population. If None, confusion matrix will not be
#     normalized.
#
# Returns
# -------
# C : ndarray of shape (n_classes, n_classes)
#     Confusion matrix whose i-th row and j-th
#     column entry indicates the number of
#     samples with true label being i-th class
#     and predicted label being j-th class.
#
# See Also
# --------
# ConfusionMatrixDisplay.from_estimator : Plot the confusion matrix
#     given an estimator, the data, and the label.
# ConfusionMatrixDisplay.from_predictions : Plot the confusion matrix
#     given the true and predicted labels.
# ConfusionMatrixDisplay : Confusion Matrix visualization.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Confusion matrix
#        <https://en.wikipedia.org/wiki/Confusion_matrix>`_
#        (Wikipedia and other references may use a different
#        convention for axes).
#
# Examples
# --------
# >>> from sklearn.metrics import confusion_matrix
# >>> y_true = [2, 0, 2, 2, 0, 1]
# >>> y_pred = [0, 0, 2, 2, 0, 2]
# >>> confusion_matrix(y_true, y_pred)
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# >>> y_true = ["cat", "ant", "cat", "cat", "ant", "bird"]
# >>> y_pred = ["ant", "ant", "cat", "cat", "ant", "cat"]
# >>> confusion_matrix(y_true, y_pred, labels=["ant", "bird", "cat"])
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# In the binary case, we can extract true positives, etc as follows:
#
# >>> tn, fp, fn, tp = confusion_matrix([0, 1, 0, 1], [1, 1, 1, 0]).ravel()
# >>> (tn, fp, fn, tp)
# (0, 2, 1, 1)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 16</u></h3></summary><small><a href=#16>goto cell # 16</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.backend</u></summary>
# <blockquote>
# <code>
# Keras backend API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.ModelCheckpoint</u></summary>
# <blockquote>
# <code>
# Callback to save the Keras model or model weights at some frequency.
#
# `ModelCheckpoint` callback is used in conjunction with training using
# `model.fit()` to save a model or weights (in a checkpoint file) at some
# interval, so the model or weights can be loaded later to continue the training
# from the state saved.
#
# A few options this callback provides include:
#
# - Whether to only keep the model that has achieved the "best performance" so
#   far, or whether to save the model at the end of every epoch regardless of
#   performance.
# - Definition of 'best'; which quantity to monitor and whether it should be
#   maximized or minimized.
# - The frequency it should save at. Currently, the callback supports saving at
#   the end of every epoch, or after a fixed number of training batches.
# - Whether only weights are saved, or the whole model is saved.
#
# Note: If you get `WARNING:tensorflow:Can save best model only with <name>
# available, skipping` see the description of the `monitor` argument for
# details on how to get this right.
#
# Example:
#
# ```python
# model.compile(loss=..., optimizer=...,
#               metrics=['accuracy'])
#
# EPOCHS = 10
# checkpoint_filepath = '/tmp/checkpoint'
# model_checkpoint_callback = tf.keras.callbacks.ModelCheckpoint(
#     filepath=checkpoint_filepath,
#     save_weights_only=True,
#     monitor='val_accuracy',
#     mode='max',
#     save_best_only=True)
#
# Model weights are saved at the end of every epoch, if it's the best seen
# so far.
# model.fit(epochs=EPOCHS, callbacks=[model_checkpoint_callback])
#
# The model weights (that are considered the best) are loaded into the model.
# model.load_weights(checkpoint_filepath)
# ```
#
# Args:
#     filepath: string or `PathLike`, path to save the model file. e.g.
#       filepath = os.path.join(working_dir, 'ckpt', file_name). `filepath`
#       can contain named formatting options, which will be filled the value of
#       `epoch` and keys in `logs` (passed in `on_epoch_end`). For example: if
#       `filepath` is `weights.{epoch:02d}-{val_loss:.2f}.hdf5`, then the model
#       checkpoints will be saved with the epoch number and the validation loss
#       in the filename. The directory of the filepath should not be reused by
#       any other callbacks to avoid conflicts.
#     monitor: The metric name to monitor. Typically the metrics are set by the
#       `Model.compile` method. Note:
#
#       * Prefix the name with `"val_`" to monitor validation metrics.
#       * Use `"loss"` or "`val_loss`" to monitor the model's total loss.
#       * If you specify metrics as strings, like `"accuracy"`, pass the same
#         string (with or without the `"val_"` prefix).
#       * If you pass `metrics.Metric` objects, `monitor` should be set to
#         `metric.name`
#       * If you're not sure about the metric names you can check the contents
#         of the `history.history` dictionary returned by
#         `history = model.fit()`
#       * Multi-output models set additional prefixes on the metric names.
#
#     verbose: verbosity mode, 0 or 1.
#     save_best_only: if `save_best_only=True`, it only saves when the model
#       is considered the "best" and the latest best model according to the
#       quantity monitored will not be overwritten. If `filepath` doesn't
#       contain formatting options like `{epoch}` then `filepath` will be
#       overwritten by each new better model.
#     mode: one of {'auto', 'min', 'max'}. If `save_best_only=True`, the
#       decision to overwrite the current save file is made based on either
#       the maximization or the minimization of the monitored quantity.
#       For `val_acc`, this should be `max`, for `val_loss` this should be
#       `min`, etc. In `auto` mode, the mode is set to `max` if the quantities
#       monitored are 'acc' or start with 'fmeasure' and are set to `min` for
#       the rest of the quantities.
#     save_weights_only: if True, then only the model's weights will be saved
#       (`model.save_weights(filepath)`), else the full model is saved
#       (`model.save(filepath)`).
#     save_freq: `'epoch'` or integer. When using `'epoch'`, the callback saves
#       the model after each epoch. When using integer, the callback saves the
#       model at end of this many batches. If the `Model` is compiled with
#       `steps_per_execution=N`, then the saving criteria will be
#       checked every Nth batch. Note that if the saving isn't aligned to
#       epochs, the monitored metric may potentially be less reliable (it
#       could reflect as little as 1 batch, since the metrics get reset every
#       epoch). Defaults to `'epoch'`.
#     options: Optional `tf.train.CheckpointOptions` object if
#       `save_weights_only` is true or optional `tf.saved_model.SaveOptions`
#       object if `save_weights_only` is false.
#     initial_value_threshold: Floating point initial "best" value of the metric
#       to be monitored. Only applies if `save_best_value=True`. Only overwrites
#       the model weights already saved if the performance of current
#       model is better than this value.
#     **kwargs: Additional arguments for backwards compatibility. Possible key
#       is `period`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u></summary>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.activation.Activation</u></summary>
# <blockquote>
# <code>
# Applies an activation function to an output.
#
# Args:
#   activation: Activation function, such as `tf.nn.relu`, or string name of
#     built-in activation function, such as "relu".
#
# Usage:
#
# >>> layer = tf.keras.layers.Activation('relu')
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
# >>> layer = tf.keras.layers.Activation(tf.nn.relu)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [0.0, 0.0, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u></summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers.L1</u></summary>
# <blockquote>
# <code>
# A regularizer that applies a L1 regularization penalty.
#
# The L1 regularization penalty is computed as:
# `loss = l1 * reduce_sum(abs(x))`
#
# L1 may be passed to a layer as a string identifier:
#
# >>> dense = tf.keras.layers.Dense(3, kernel_regularizer='l1')
#
# In this case, the default value used is `l1=0.01`.
#
# Attributes:
#     l1: Float; L1 regularization factor.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot</u></summary>
# <blockquote>
# <code>
# `matplotlib.pyplot` is a state-based interface to matplotlib. It provides
# an implicit,  MATLAB-like, way of plotting.  It also opens figures on your
# screen, and acts as the figure GUI manager.
#
# pyplot is mainly intended for interactive plots and simple cases of
# programmatic plot generation::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     plt.plot(x, y)
#
# The explicit (object-oriented) API is recommended for complex plots, though
# pyplot is still usually used to create the figure and often the axes in the
# figure. See `.pyplot.figure`, `.pyplot.subplots`, and
# `.pyplot.subplot_mosaic` to create figures, and
# :doc:`Axes API <../axes_api>` for the plotting methods on an axes::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u></summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.subplots</u></summary>
# <blockquote>
# <code>
# Create a figure and a set of subplots.
#
# This utility wrapper makes it convenient to create common layouts of
# subplots, including the enclosing figure object, in a single call.
#
# Parameters
# ----------
# nrows, ncols : int, default: 1
#     Number of rows/columns of the subplot grid.
#
# sharex, sharey : bool or {'none', 'all', 'row', 'col'}, default: False
#     Controls sharing of properties among x (*sharex*) or y (*sharey*)
#     axes:
#
#     - True or 'all': x- or y-axis will be shared among all subplots.
#     - False or 'none': each subplot x- or y-axis will be independent.
#     - 'row': each subplot row will share an x- or y-axis.
#     - 'col': each subplot column will share an x- or y-axis.
#
#     When subplots have a shared x-axis along a column, only the x tick
#     labels of the bottom subplot are created. Similarly, when subplots
#     have a shared y-axis along a row, only the y tick labels of the first
#     column subplot are created. To later turn other subplots' ticklabels
#     on, use `~matplotlib.axes.Axes.tick_params`.
#
#     When subplots have a shared axis that has units, calling
#     `~matplotlib.axis.Axis.set_units` will update each axis with the
#     new units.
#
# squeeze : bool, default: True
#     - If True, extra dimensions are squeezed out from the returned
#       array of `~matplotlib.axes.Axes`:
#
#       - if only one subplot is constructed (nrows=ncols=1), the
#         resulting single Axes object is returned as a scalar.
#       - for Nx1 or 1xM subplots, the returned object is a 1D numpy
#         object array of Axes objects.
#       - for NxM, subplots with N>1 and M>1 are returned as a 2D array.
#
#     - If False, no squeezing at all is done: the returned Axes object is
#       always a 2D array containing Axes instances, even if it ends up
#       being 1x1.
#
# subplot_kw : dict, optional
#     Dict with keywords passed to the
#     `~matplotlib.figure.Figure.add_subplot` call used to create each
#     subplot.
#
# gridspec_kw : dict, optional
#     Dict with keywords passed to the `~matplotlib.gridspec.GridSpec`
#     constructor used to create the grid the subplots are placed on.
#
# **fig_kw
#     All additional keyword arguments are passed to the
#     `.pyplot.figure` call.
#
# Returns
# -------
# fig : `~.figure.Figure`
#
# ax : `.axes.Axes` or array of Axes
#     *ax* can be either a single `~matplotlib.axes.Axes` object or an
#     array of Axes objects if more than one subplot was created.  The
#     dimensions of the resulting array can be controlled with the squeeze
#     keyword, see above.
#
#     Typical idioms for handling the return value are::
#
#         # using the variable ax for single a Axes
#         fig, ax = plt.subplots()
#
#         # using the variable axs for multiple Axes
#         fig, axs = plt.subplots(2, 2)
#
#         # using tuple unpacking for multiple Axes
#         fig, (ax1, ax2) = plt.subplots(1, 2)
#         fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2)
#
#     The names ``ax`` and pluralized ``axs`` are preferred over ``axes``
#     because for the latter it's not clear if it refers to a single
#     `~.axes.Axes` instance or a collection of these.
#
# See Also
# --------
# .pyplot.figure
# .pyplot.subplot
# .pyplot.axes
# .Figure.subplots
# .Figure.add_subplot
#
# Examples
# --------
# ::
#
#     # First create some toy data:
#     x = np.linspace(0, 2*np.pi, 400)
#     y = np.sin(x**2)
#
#     # Create just a figure and only one subplot
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#     ax.set_title('Simple plot')
#
#     # Create two subplots and unpack the output array immediately
#     f, (ax1, ax2) = plt.subplots(1, 2, sharey=True)
#     ax1.plot(x, y)
#     ax1.set_title('Sharing Y axis')
#     ax2.scatter(x, y)
#
#     # Create four polar axes and access them through the returned array
#     fig, axs = plt.subplots(2, 2, subplot_kw=dict(projection="polar"))
#     axs[0, 0].plot(x, y)
#     axs[1, 1].scatter(x, y)
#
#     # Share a X axis with each column of subplots
#     plt.subplots(2, 2, sharex='col')
#
#     # Share a Y axis with each row of subplots
#     plt.subplots(2, 2, sharey='row')
#
#     # Share both X and Y axes with all subplots
#     plt.subplots(2, 2, sharex='all', sharey='all')
#
#     # Note that this is the same as
#     plt.subplots(2, 2, sharex=True, sharey=True)
#
#     # Create figure number 10 with a single subplot
#     # and clears it if it already exists.
#     fig, ax = plt.subplots(num=10, clear=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u></summary>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u></summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u></summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u></summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.info</u></summary>
# <blockquote>
# <code>
# Print a concise summary of a DataFrame.
#
# This method prints information about a DataFrame including
# the index dtype and columns, non-null values and memory usage.
#
# Parameters
# ----------
# data : DataFrame
#     DataFrame to print information about.
# verbose : bool, optional
#     Whether to print the full summary. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is followed.
# buf : writable buffer, defaults to sys.stdout
#     Where to send the output. By default, the output is printed to
#     sys.stdout. Pass a writable buffer if you need to further process
#     the output.    max_cols : int, optional
#     When to switch from the verbose to the truncated output. If the
#     DataFrame has more than `max_cols` columns, the truncated output
#     is used. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is used.
# memory_usage : bool, str, optional
#     Specifies whether total memory usage of the DataFrame
#     elements (including the index) should be displayed. By default,
#     this follows the ``pandas.options.display.memory_usage`` setting.
#
#     True always show memory usage. False never shows memory usage.
#     A value of 'deep' is equivalent to "True with deep introspection".
#     Memory usage is shown in human-readable units (base-2
#     representation). Without deep introspection a memory estimation is
#     made based in column dtype and number of rows assuming values
#     consume the same memory amount for corresponding dtypes. With deep
#     memory introspection, a real memory usage calculation is performed
#     at the cost of computational resources.
# show_counts : bool, optional
#     Whether to show the non-null counts. By default, this is shown
#     only if the DataFrame is smaller than
#     ``pandas.options.display.max_info_rows`` and
#     ``pandas.options.display.max_info_columns``. A value of True always
#     shows the counts, and False never shows the counts.
# null_counts : bool, optional
#     .. deprecated:: 1.2.0
#         Use show_counts instead.
#
# Returns
# -------
# None
#     This method prints a summary of a DataFrame and returns None.
#
# See Also
# --------
# DataFrame.describe: Generate descriptive statistics of DataFrame
#     columns.
# DataFrame.memory_usage: Memory usage of DataFrame columns.
#
# Examples
# --------
# >>> int_values = [1, 2, 3, 4, 5]
# >>> text_values = ['alpha', 'beta', 'gamma', 'delta', 'epsilon']
# >>> float_values = [0.0, 0.25, 0.5, 0.75, 1.0]
# >>> df = pd.DataFrame({"int_col": int_values, "text_col": text_values,
# ...                   "float_col": float_values})
# >>> df
#     int_col text_col  float_col
# 0        1    alpha       0.00
# 1        2     beta       0.25
# 2        3    gamma       0.50
# 3        4    delta       0.75
# 4        5  epsilon       1.00
#
# Prints information of all columns:
#
# >>> df.info(verbose=True)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Data columns (total 3 columns):
#  #   Column     Non-Null Count  Dtype
# ---  ------     --------------  -----
#  0   int_col    5 non-null      int64
#  1   text_col   5 non-null      object
#  2   float_col  5 non-null      float64
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Prints a summary of columns count and its dtypes but not per column
# information:
#
# >>> df.info(verbose=False)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Columns: 3 entries, int_col to float_col
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Pipe output of DataFrame.info to buffer instead of sys.stdout, get
# buffer content and writes to a text file:
#
# >>> import io
# >>> buffer = io.StringIO()
# >>> df.info(buf=buffer)
# >>> s = buffer.getvalue()
# >>> with open("df_info.txt", "w",
# ...           encoding="utf-8") as f:  # doctest: +SKIP
# ...     f.write(s)
# 260
#
# The `memory_usage` parameter allows deep introspection mode, specially
# useful for big DataFrames and fine-tune memory optimization:
#
# >>> random_strings_array = np.random.choice(['a', 'b', 'c'], 10 ** 6)
# >>> df = pd.DataFrame({
# ...     'column_1': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_2': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_3': np.random.choice(['a', 'b', 'c'], 10 ** 6)
# ... })
# >>> df.info()
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 22.9+ MB
#
# >>> df.info(memory_usage='deep')
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 165.9 MB
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u></summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>re</b>
# <ul>
# <li>
# <details><summary><u>re.search</u></summary>
# <blockquote>
# <code>
# Scan through string looking for a match to the pattern, returning
# a Match object, or None if no match was found.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>scipy</b>
# <ul>
# <li>
# <details><summary><u>scipy.stats._stats_py.pearsonr</u></summary>
# <blockquote>
# <code>
# Pearson correlation coefficient and p-value for testing non-correlation.
#
# The Pearson correlation coefficient [1]_ measures the linear relationship
# between two datasets.  The calculation of the p-value relies on the
# assumption that each dataset is normally distributed.  (See Kowalski [3]_
# for a discussion of the effects of non-normality of the input on the
# distribution of the correlation coefficient.)  Like other correlation
# coefficients, this one varies between -1 and +1 with 0 implying no
# correlation. Correlations of -1 or +1 imply an exact linear relationship.
#
# Parameters
# ----------
# x : (N,) array_like
#     Input array.
# y : (N,) array_like
#     Input array.
#
# Returns
# -------
# r : float
#     Pearson's correlation coefficient.
# p-value : float
#     Two-tailed p-value.
#
# Warns
# -----
# PearsonRConstantInputWarning
#     Raised if an input is a constant array.  The correlation coefficient
#     is not defined in this case, so ``np.nan`` is returned.
#
# PearsonRNearConstantInputWarning
#     Raised if an input is "nearly" constant.  The array ``x`` is considered
#     nearly constant if ``norm(x - mean(x)) < 1e-13 * abs(mean(x))``.
#     Numerical errors in the calculation ``x - mean(x)`` in this case might
#     result in an inaccurate calculation of r.
#
# See Also
# --------
# spearmanr : Spearman rank-order correlation coefficient.
# kendalltau : Kendall's tau, a correlation measure for ordinal data.
#
# Notes
# -----
# The correlation coefficient is calculated as follows:
#
# .. math::
#
#     r = \frac{\sum (x - m_x) (y - m_y)}
#              {\sqrt{\sum (x - m_x)^2 \sum (y - m_y)^2}}
#
# where :math:`m_x` is the mean of the vector x and :math:`m_y` is
# the mean of the vector y.
#
# Under the assumption that x and y are drawn from
# independent normal distributions (so the population correlation coefficient
# is 0), the probability density function of the sample correlation
# coefficient r is ([1]_, [2]_):
#
# .. math::
#
#     f(r) = \frac{{(1-r^2)}^{n/2-2}}{\mathrm{B}(\frac{1}{2},\frac{n}{2}-1)}
#
# where n is the number of samples, and B is the beta function.  This
# is sometimes referred to as the exact distribution of r.  This is
# the distribution that is used in `pearsonr` to compute the p-value.
# The distribution is a beta distribution on the interval [-1, 1],
# with equal shape parameters a = b = n/2 - 1.  In terms of SciPy's
# implementation of the beta distribution, the distribution of r is::
#
#     dist = scipy.stats.beta(n/2 - 1, n/2 - 1, loc=-1, scale=2)
#
# The p-value returned by `pearsonr` is a two-sided p-value. The p-value
# roughly indicates the probability of an uncorrelated system
# producing datasets that have a Pearson correlation at least as extreme
# as the one computed from these datasets. More precisely, for a
# given sample with correlation coefficient r, the p-value is
# the probability that abs(r') of a random sample x' and y' drawn from
# the population with zero correlation would be greater than or equal
# to abs(r). In terms of the object ``dist`` shown above, the p-value
# for a given r and length n can be computed as::
#
#     p = 2*dist.cdf(-abs(r))
#
# When n is 2, the above continuous distribution is not well-defined.
# One can interpret the limit of the beta distribution as the shape
# parameters a and b approach a = b = 0 as a discrete distribution with
# equal probability masses at r = 1 and r = -1.  More directly, one
# can observe that, given the data x = [x1, x2] and y = [y1, y2], and
# assuming x1 != x2 and y1 != y2, the only possible values for r are 1
# and -1.  Because abs(r') for any sample x' and y' with length 2 will
# be 1, the two-sided p-value for a sample of length 2 is always 1.
#
# References
# ----------
# .. [1] "Pearson correlation coefficient", Wikipedia,
#        https://en.wikipedia.org/wiki/Pearson_correlation_coefficient
# .. [2] Student, "Probable error of a correlation coefficient",
#        Biometrika, Volume 6, Issue 2-3, 1 September 1908, pp. 302-310.
# .. [3] C. J. Kowalski, "On the Effects of Non-Normality on the Distribution
#        of the Sample Product-Moment Correlation Coefficient"
#        Journal of the Royal Statistical Society. Series C (Applied
#        Statistics), Vol. 21, No. 1 (1972), pp. 1-12.
#
# Examples
# --------
# >>> from scipy import stats
# >>> stats.pearsonr([1, 2, 3, 4, 5], [10, 9, 2.5, 6, 4])
# (-0.7426106572325057, 0.1505558088534455)
#
# There is a linear dependence between x and y if y = a + b*x + e, where
# a,b are constants and e is a random error term, assumed to be independent
# of x. For simplicity, assume that x is standard normal, a=0, b=1 and let
# e follow a normal distribution with mean zero and standard deviation s>0.
#
# >>> s = 0.5
# >>> x = stats.norm.rvs(size=500)
# >>> e = stats.norm.rvs(scale=s, size=500)
# >>> y = x + e
# >>> stats.pearsonr(x, y)
# (0.9029601878969703, 8.428978827629898e-185) # may vary
#
# This should be close to the exact value given by
#
# >>> 1/np.sqrt(1 + s**2)
# 0.8944271909999159
#
# For s=0.5, we observe a high level of correlation. In general, a large
# variance of the noise reduces the correlation, while the correlation
# approaches one as the variance of the error goes to zero.
#
# It is important to keep in mind that no correlation does not imply
# independence unless (x, y) is jointly normal. Correlation can even be zero
# when there is a very simple dependence structure: if X follows a
# standard normal distribution, let y = abs(x). Note that the correlation
# between x and y is zero. Indeed, since the expectation of x is zero,
# cov(x, y) = E[x*y]. By definition, this equals E[x*abs(x)] which is zero
# by symmetry. The following lines of code illustrate this observation:
#
# >>> y = np.abs(x)
# >>> stats.pearsonr(x, y)
# (-0.016172891856853524, 0.7182823678751942) # may vary
#
# A non-zero correlation coefficient can be misleading. For example, if X has
# a standard normal distribution, define y = x if x < 0 and y = 0 otherwise.
# A simple calculation shows that corr(x, y) = sqrt(2/Pi) = 0.797...,
# implying a high level of correlation:
#
# >>> y = np.where(x < 0, x, 0)
# >>> stats.pearsonr(x, y)
# (0.8537091583771509, 3.183461621422181e-143) # may vary
#
# This is unintuitive since there is no dependence of x and y if x is larger
# than zero which happens in about half of the cases if we sample x and y.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>scipy.stats._stats_py.skew</u></summary>
# <blockquote>
# <code>
# Compute the sample skewness of a data set.
#
# For normally distributed data, the skewness should be about zero. For
# unimodal continuous distributions, a skewness value greater than zero means
# that there is more weight in the right tail of the distribution. The
# function `skewtest` can be used to determine if the skewness value
# is close enough to zero, statistically speaking.
#
# Parameters
# ----------
# a : ndarray
#     Input array.
# axis : int or None, optional
#     Axis along which skewness is calculated. Default is 0.
#     If None, compute over the whole array `a`.
# bias : bool, optional
#     If False, then the calculations are corrected for statistical bias.
# nan_policy : {'propagate', 'raise', 'omit'}, optional
#     Defines how to handle when input contains nan.
#     The following options are available (default is 'propagate'):
#
#       * 'propagate': returns nan
#       * 'raise': throws an error
#       * 'omit': performs the calculations ignoring nan values
#
# Returns
# -------
# skewness : ndarray
#     The skewness of values along an axis, returning 0 where all values are
#     equal.
#
# Notes
# -----
# The sample skewness is computed as the Fisher-Pearson coefficient
# of skewness, i.e.
#
# .. math::
#
#     g_1=\frac{m_3}{m_2^{3/2}}
#
# where
#
# .. math::
#
#     m_i=\frac{1}{N}\sum_{n=1}^N(x[n]-\bar{x})^i
#
# is the biased sample :math:`i\texttt{th}` central moment, and
# :math:`\bar{x}` is
# the sample mean.  If ``bias`` is False, the calculations are
# corrected for bias and the value computed is the adjusted
# Fisher-Pearson standardized moment coefficient, i.e.
#
# .. math::
#
#     G_1=\frac{k_3}{k_2^{3/2}}=
#         \frac{\sqrt{N(N-1)}}{N-2}\frac{m_3}{m_2^{3/2}}.
#
# References
# ----------
# .. [1] Zwillinger, D. and Kokoska, S. (2000). CRC Standard
#    Probability and Statistics Tables and Formulae. Chapman & Hall: New
#    York. 2000.
#    Section 2.2.24.1
#
# Examples
# --------
# >>> from scipy.stats import skew
# >>> skew([1, 2, 3, 4, 5])
# 0.0
# >>> skew([2, 8, 0, 4, 1, 9, 9, 0])
# 0.2650554122698573
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u></summary>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u></summary>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.confusion_matrix</u></summary>
# <blockquote>
# <code>
# Compute confusion matrix to evaluate the accuracy of a classification.
#
# By definition a confusion matrix :math:`C` is such that :math:`C_{i, j}`
# is equal to the number of observations known to be in group :math:`i` and
# predicted to be in group :math:`j`.
#
# Thus in binary classification, the count of true negatives is
# :math:`C_{0,0}`, false negatives is :math:`C_{1,0}`, true positives is
# :math:`C_{1,1}` and false positives is :math:`C_{0,1}`.
#
# Read more in the :ref:`User Guide <confusion_matrix>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,)
#     Ground truth (correct) target values.
#
# y_pred : array-like of shape (n_samples,)
#     Estimated targets as returned by a classifier.
#
# labels : array-like of shape (n_classes), default=None
#     List of labels to index the matrix. This may be used to reorder
#     or select a subset of labels.
#     If ``None`` is given, those that appear at least once
#     in ``y_true`` or ``y_pred`` are used in sorted order.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
#     .. versionadded:: 0.18
#
# normalize : {'true', 'pred', 'all'}, default=None
#     Normalizes confusion matrix over the true (rows), predicted (columns)
#     conditions or all the population. If None, confusion matrix will not be
#     normalized.
#
# Returns
# -------
# C : ndarray of shape (n_classes, n_classes)
#     Confusion matrix whose i-th row and j-th
#     column entry indicates the number of
#     samples with true label being i-th class
#     and predicted label being j-th class.
#
# See Also
# --------
# ConfusionMatrixDisplay.from_estimator : Plot the confusion matrix
#     given an estimator, the data, and the label.
# ConfusionMatrixDisplay.from_predictions : Plot the confusion matrix
#     given the true and predicted labels.
# ConfusionMatrixDisplay : Confusion Matrix visualization.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Confusion matrix
#        <https://en.wikipedia.org/wiki/Confusion_matrix>`_
#        (Wikipedia and other references may use a different
#        convention for axes).
#
# Examples
# --------
# >>> from sklearn.metrics import confusion_matrix
# >>> y_true = [2, 0, 2, 2, 0, 1]
# >>> y_pred = [0, 0, 2, 2, 0, 2]
# >>> confusion_matrix(y_true, y_pred)
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# >>> y_true = ["cat", "ant", "cat", "cat", "ant", "bird"]
# >>> y_pred = ["ant", "ant", "cat", "cat", "ant", "cat"]
# >>> confusion_matrix(y_true, y_pred, labels=["ant", "bird", "cat"])
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# In the binary case, we can extract true positives, etc as follows:
#
# >>> tn, fp, fn, tp = confusion_matrix([0, 1, 0, 1], [1, 1, 1, 0]).ravel()
# >>> (tn, fp, fn, tp)
# (0, 2, 1, 1)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>warnings</b>
# <ul>
# <li>
# <details><summary><u>warnings.filterwarnings</u></summary>
# <blockquote>
# <code>
# Insert an entry into the list of warnings filters (at the front).
#
# 'action' -- one of "error", "ignore", "always", "default", "module",
#             or "once"
# 'message' -- a regex that the warning message must match
# 'category' -- a class that the warning must be a subclass of
# 'module' -- a regex that the module name must match
# 'lineno' -- an integer line number, 0 matches all warnings
# 'append' -- if true, append to the list of filters
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Data Preparation | Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>warnings</h2>
# <ul>
# <li>
# <details><summary><u>warnings.filterwarnings</u></summary>
# <blockquote>
# <code>
# Insert an entry into the list of warnings filters (at the front).
#
# 'action' -- one of "error", "ignore", "always", "default", "module",
#             or "once"
# 'message' -- a regex that the warning message must match
# 'category' -- a class that the warning must be a subclass of
# 'module' -- a regex that the module name must match
# 'lineno' -- an integer line number, 0 matches all warnings
# 'append' -- if true, append to the list of filters
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)
import seaborn as sns

from keras.regularizers import l1
from keras import backend as K

from sklearn.preprocessing import StandardScaler
from sklearn.model_selection import train_test_split
from scipy.stats import skew
from scipy.stats.stats import pearsonr

import matplotlib.pyplot as plt
# %matplotlib inline

import csv
import re

from keras.models import Sequential
from keras.layers import Dense, Activation, BatchNormalization, Dropout
from keras.callbacks import ModelCheckpoint
from keras.optimizers import Adam

# ignore Deprecation Warning
import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning) 

import os

train_orj = pd.read_csv("../input/train.csv", header=0)
test_orj = pd.read_csv("../input/test.csv", header=0)
train_orj.head()
# Any results you write to the current directory are saved as output.


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.info</u></summary>
# <blockquote>
# <code>
# Print a concise summary of a DataFrame.
#
# This method prints information about a DataFrame including
# the index dtype and columns, non-null values and memory usage.
#
# Parameters
# ----------
# data : DataFrame
#     DataFrame to print information about.
# verbose : bool, optional
#     Whether to print the full summary. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is followed.
# buf : writable buffer, defaults to sys.stdout
#     Where to send the output. By default, the output is printed to
#     sys.stdout. Pass a writable buffer if you need to further process
#     the output.    max_cols : int, optional
#     When to switch from the verbose to the truncated output. If the
#     DataFrame has more than `max_cols` columns, the truncated output
#     is used. By default, the setting in
#     ``pandas.options.display.max_info_columns`` is used.
# memory_usage : bool, str, optional
#     Specifies whether total memory usage of the DataFrame
#     elements (including the index) should be displayed. By default,
#     this follows the ``pandas.options.display.memory_usage`` setting.
#
#     True always show memory usage. False never shows memory usage.
#     A value of 'deep' is equivalent to "True with deep introspection".
#     Memory usage is shown in human-readable units (base-2
#     representation). Without deep introspection a memory estimation is
#     made based in column dtype and number of rows assuming values
#     consume the same memory amount for corresponding dtypes. With deep
#     memory introspection, a real memory usage calculation is performed
#     at the cost of computational resources.
# show_counts : bool, optional
#     Whether to show the non-null counts. By default, this is shown
#     only if the DataFrame is smaller than
#     ``pandas.options.display.max_info_rows`` and
#     ``pandas.options.display.max_info_columns``. A value of True always
#     shows the counts, and False never shows the counts.
# null_counts : bool, optional
#     .. deprecated:: 1.2.0
#         Use show_counts instead.
#
# Returns
# -------
# None
#     This method prints a summary of a DataFrame and returns None.
#
# See Also
# --------
# DataFrame.describe: Generate descriptive statistics of DataFrame
#     columns.
# DataFrame.memory_usage: Memory usage of DataFrame columns.
#
# Examples
# --------
# >>> int_values = [1, 2, 3, 4, 5]
# >>> text_values = ['alpha', 'beta', 'gamma', 'delta', 'epsilon']
# >>> float_values = [0.0, 0.25, 0.5, 0.75, 1.0]
# >>> df = pd.DataFrame({"int_col": int_values, "text_col": text_values,
# ...                   "float_col": float_values})
# >>> df
#     int_col text_col  float_col
# 0        1    alpha       0.00
# 1        2     beta       0.25
# 2        3    gamma       0.50
# 3        4    delta       0.75
# 4        5  epsilon       1.00
#
# Prints information of all columns:
#
# >>> df.info(verbose=True)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Data columns (total 3 columns):
#  #   Column     Non-Null Count  Dtype
# ---  ------     --------------  -----
#  0   int_col    5 non-null      int64
#  1   text_col   5 non-null      object
#  2   float_col  5 non-null      float64
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Prints a summary of columns count and its dtypes but not per column
# information:
#
# >>> df.info(verbose=False)
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 5 entries, 0 to 4
# Columns: 3 entries, int_col to float_col
# dtypes: float64(1), int64(1), object(1)
# memory usage: 248.0+ bytes
#
# Pipe output of DataFrame.info to buffer instead of sys.stdout, get
# buffer content and writes to a text file:
#
# >>> import io
# >>> buffer = io.StringIO()
# >>> df.info(buf=buffer)
# >>> s = buffer.getvalue()
# >>> with open("df_info.txt", "w",
# ...           encoding="utf-8") as f:  # doctest: +SKIP
# ...     f.write(s)
# 260
#
# The `memory_usage` parameter allows deep introspection mode, specially
# useful for big DataFrames and fine-tune memory optimization:
#
# >>> random_strings_array = np.random.choice(['a', 'b', 'c'], 10 ** 6)
# >>> df = pd.DataFrame({
# ...     'column_1': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_2': np.random.choice(['a', 'b', 'c'], 10 ** 6),
# ...     'column_3': np.random.choice(['a', 'b', 'c'], 10 ** 6)
# ... })
# >>> df.info()
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 22.9+ MB
#
# >>> df.info(memory_usage='deep')
# <class 'pandas.core.frame.DataFrame'>
# RangeIndex: 1000000 entries, 0 to 999999
# Data columns (total 3 columns):
#  #   Column    Non-Null Count    Dtype
# ---  ------    --------------    -----
#  0   column_1  1000000 non-null  object
#  1   column_2  1000000 non-null  object
#  2   column_3  1000000 non-null  object
# dtypes: object(3)
# memory usage: 165.9 MB
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _cell_guid="79c7e3d0-c299-4dcb-8224-4455121ee9b0" _uuid="d629ff2d2480ee46fbb7e2d37f6b5fab8052498a"
train_orj.info()



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>3. Data Preparation | Feature Engineering</h1>  <a id='3'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>re</h2>
# <ul>
# <li>
# <details><summary><u>re.search</u></summary>
# <blockquote>
# <code>
# Scan through string looking for a match to the pattern, returning
# a Match object, or None if no match was found.
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="facfa03728a1b6f9022048d24900fb877419c784"
def preprocess(data):
    
    #Kabin
    data.Cabin.fillna('9', inplace=True)
    #data['Cabin'].replace('0', 9, inplace=True)
    data.loc[data.Cabin.str[0] == 'A', 'Cabin'] = 1
    data.loc[data.Cabin.str[0] == 'B', 'Cabin'] = 2
    data.loc[data.Cabin.str[0] == 'C', 'Cabin'] = 3
    data.loc[data.Cabin.str[0] == 'D', 'Cabin'] = 4
    data.loc[data.Cabin.str[0] == 'E', 'Cabin'] = 5
    data.loc[data.Cabin.str[0] == 'F', 'Cabin'] = 6
    data.loc[data.Cabin.str[0] == 'G', 'Cabin'] = 7
    data.loc[data.Cabin.str[0] == 'T', 'Cabin'] = 8
    data = data.drop(["Cabin"],axis=1)

    # Cinsiyeti tam sayıya çevirelim
    data['Sex'].replace('female', 1, inplace=True)
    data['Sex'].replace('male', 2, inplace=True)
    
    # Gemiye biniş limanlarını tam sayıya çevirelim
    data['Embarked'].replace('S', 1, inplace=True)
    data['Embarked'].replace('C', 2, inplace=True)
    data['Embarked'].replace('Q', 3, inplace=True)
    
    # Olmayan (NA) yaş değerlerini medyan ile dolduralım
    data['Age'].fillna(data['Age'].median(), inplace=True)
    #data['Age'] = [0 if each >= 60 else 1 if each >= 35 else 2 if each >= 18 else 3 if each >= 12 else 4 if each >= 5 else 5 for each in data['Age']]
   
    data['Fare'].fillna(data['Fare'].median(), inplace=True)
    data['Embarked'].fillna(data['Embarked'].median(), inplace=True)
    
    data = data.drop(["Ticket"],axis=1)
    data = data.drop(["Fare"],axis=1)
    data['SibSp'].replace(0, 9, inplace=True)
    data['Parch'].replace(0, 9, inplace=True)
    return data

def group_titles(data):
    #data['Names'] = data['Name'].map(lambda x: len(re.split(' ', x)))
    data['Title'] = data['Name'].map(lambda x: re.search(', (.+?) ', x).group(1))
    data['Title'].replace('Master.', 1, inplace=True)
    data['Title'].replace('Mr.', 2, inplace=True)
    data['Title'].replace(['Ms.','Mlle.', 'Miss.'], 3, inplace=True)
    data['Title'].replace(['Mme.', 'Mrs.'], 4, inplace=True)
    data['Title'].replace(['Dona.', 'Lady.', 'the Countess.', 'Capt.', 'Col.', 'Don.', 'Dr.', 'Major.', 'Rev.', 'Sir.', 'Jonkheer.', 'the'], 5, inplace=True)
    return data



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Data Preparation | Feature Engineering</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u></summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="d05c1efea8ba5e4e3008d395df3a3abed3ad572a"
train = train_orj.copy().drop(["PassengerId"],axis=1)
train=preprocess(train)
train=group_titles(train)
train = train.drop(["Name"],axis=1)
train.head()

# %% _uuid="8a29acfbda9afd7569858a496b42b841f73f2510"
train.info()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>6. Visualization</h1>  <a id='6'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u></summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u></summary>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="499a867e84b4afc5b6e7f94d238ef3193d5bdc24"
plt.figure(figsize=(10,5))
sns.countplot(train.Age, palette="icefire")
#train.Age.value_counts()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>7. Data Preparation | Library Loading</h1>  <a id='7'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="299a4f206b1dba1e38edd31e9f67d87cd2a1bd5b"
x = train.iloc[:,1:train.shape[1]].values #bağımsız değişkenler
y = train.Survived.values

from sklearn.model_selection import train_test_split
X_train, X_val, Y_train, Y_val = train_test_split(x, y, test_size = 0.1, random_state=2)
print("x_train shape",X_train.shape)
print("x_test shape",X_val.shape)
print("y_train shape",Y_train.shape)
print("y_test shape",Y_val.shape)


#Y_train=np.array(Y_train).astype(int)
#X_train=np.array(X_train).astype(float)
#Y_val = np.array(Y_val).astype(int)
#X_val = np.array(X_val).astype(float)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>8. Visualization</h1>  <a id='8'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u></summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u></summary>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u></summary>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="8981e7fcb315c6aece7948257d5d804ed9a42995"
plt.figure(figsize=(10,5))
sns.countplot(Y_train, palette="icefire")
plt.title("Number of Survived classes")

# %% _uuid="760749aad03ad34562ba669eab9f2c8c961ef50e"
#model 1
'''
num_epochs = 200
batch_size = 32

model = Sequential()
model.add(Dense(64, input_dim=input_length-1, activation='softplus'))
model.add(Dense(32, activation='softplus'))
model.add(Dense(16, activation='softplus'))  
model.add(Dense(8, activation='softplus')) 
model.add(Dense(1, activation='softplus'))

lr = .001
adam0 = Adam(lr = lr)

# Modeli derleyip ve daha iyi bir sonuç elde edildiğinde ağırlıkları kaydedelim
model.compile(loss='binary_crossentropy', optimizer=adam0, metrics=['accuracy'])
filepath = 'weights.best.hdf5'
checkpoint = ModelCheckpoint(filepath, monitor='acc', verbose=1, save_best_only=True, mode='max')
callbacks_list = [checkpoint]

history_model = model.fit(X_train, Y_train, callbacks=callbacks_list, epochs=num_epochs, batch_size=batch_size, verbose=0)

'''


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>10. Model Building and Training</h1>  <a id='10'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u></summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.evaluate</u></summary>
# <blockquote>
# <code>
# Returns the loss value & metrics values for the model in test mode.
#
# Computation is done in batches (see the `batch_size` arg.)
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     y: Target data. Like the input data `x`, it could be either Numpy
#       array(s) or TensorFlow tensor(s). It should be consistent with `x`
#       (you cannot have Numpy inputs and tensor targets, or inversely). If
#       `x` is a dataset, generator or `keras.utils.Sequence` instance, `y`
#       should not be specified (since targets will be obtained from the
#       iterator/dataset).
#     batch_size: Integer or `None`. Number of samples per batch of
#       computation. If unspecified, `batch_size` will default to 32. Do not
#       specify the `batch_size` if your data is in the form of a dataset,
#       generators, or `keras.utils.Sequence` instances (since they generate
#       batches).
#     verbose: 0 or 1. Verbosity mode. 0 = silent, 1 = progress bar.
#     sample_weight: Optional Numpy array of weights for the test samples,
#       used for weighting the loss function. You can either pass a flat (1D)
#       Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples), or in the case of
#           temporal data, you can pass a 2D array with shape `(samples,
#           sequence_length)`, to apply a different weight to every timestep
#           of every sample. This argument is not supported when `x` is a
#           dataset, instead pass sample weights as the third element of `x`.
#     steps: Integer or `None`. Total number of steps (batches of samples)
#       before declaring the evaluation round finished. Ignored with the
#       default value of `None`. If x is a `tf.data` dataset and `steps` is
#       None, 'evaluate' will run until the dataset is exhausted. This
#       argument is not supported with array inputs.
#     callbacks: List of `keras.callbacks.Callback` instances. List of
#       callbacks to apply during evaluation. See
#       [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#       input only. Maximum size for the generator queue. If unspecified,
#       `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#       only. Maximum number of processes to spin up when using process-based
#       threading. If unspecified, `workers` will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#       `keras.utils.Sequence` input only. If `True`, use process-based
#       threading. If unspecified, `use_multiprocessing` will default to
#       `False`. Note that because this implementation relies on
#       multiprocessing, you should not pass non-picklable arguments to the
#       generator as they can't be passed easily to children processes.
#     return_dict: If `True`, loss and metric results are returned as a dict,
#       with each key being the name of the metric. If `False`, they are
#       returned as a list.
#     **kwargs: Unused at this time.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`.
#
# Returns:
#     Scalar test loss (if the model has a single output and no metrics)
#     or list of scalars (if the model has multiple outputs
#     and/or metrics). The attribute `model.metrics_names` will give you
#     the display labels for the scalar outputs.
#
# Raises:
#     RuntimeError: If `model.evaluate` is wrapped in a `tf.function`.
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="e943c35d044c8e76eb83baad9b7b420f383a1333"
# model 2
model = Sequential()

# layers
model.add(Dense(units = 128, kernel_initializer = 'uniform', activation = 'relu', input_dim = X_train.shape[1]))
model.add(BatchNormalization())
model.add(Dropout(0.5))
model.add(Dense(units = 64, kernel_initializer = 'uniform', activation = 'relu'))
model.add(BatchNormalization())
model.add(Dropout(0.5))
model.add(Dense(units = 32, kernel_initializer = 'uniform', activation = 'relu'))
model.add(BatchNormalization())
model.add(Dropout(0.5))
model.add(Dense(units = 16, kernel_initializer = 'uniform', activation = 'relu'))
model.add(Dropout(0.3))
model.add(Dense(units = 1, kernel_initializer = 'uniform', activation = 'sigmoid'))

# Compiling the ANN
optimizer = Adam(lr=0.001, beta_1=0.9, beta_2=0.999)
model.compile(optimizer = optimizer, loss = 'binary_crossentropy', metrics = ['accuracy'])

# Train the ANN
history = model.fit(X_train, Y_train, batch_size = 32, epochs = 300, validation_data = (X_val,Y_val))

scores = model.evaluate(X_train, Y_train, verbose=0)
print("%s: %.3f%%" % (model.metrics_names[1], scores[1]*100))


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>11. Visualization</h1>  <a id='11'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.plot</u></summary>
# <blockquote>
# <code>
# Plot y versus x as lines and/or markers.
#
# Call signatures::
#
#     plot([x], y, [fmt], *, data=None, **kwargs)
#     plot([x], y, [fmt], [x2], y2, [fmt2], ..., **kwargs)
#
# The coordinates of the points or line nodes are given by *x*, *y*.
#
# The optional parameter *fmt* is a convenient way for defining basic
# formatting like color, marker and linestyle. It's a shortcut string
# notation described in the *Notes* section below.
#
# >>> plot(x, y)        # plot x and y using default line style and color
# >>> plot(x, y, 'bo')  # plot x and y using blue circle markers
# >>> plot(y)           # plot y using x as index array 0..N-1
# >>> plot(y, 'r+')     # ditto, but with red plusses
#
# You can use `.Line2D` properties as keyword arguments for more
# control on the appearance. Line properties and *fmt* can be mixed.
# The following two calls yield identical results:
#
# >>> plot(x, y, 'go--', linewidth=2, markersize=12)
# >>> plot(x, y, color='green', marker='o', linestyle='dashed',
# ...      linewidth=2, markersize=12)
#
# When conflicting with *fmt*, keyword arguments take precedence.
#
#
# **Plotting labelled data**
#
# There's a convenient way for plotting objects with labelled data (i.e.
# data that can be accessed by index ``obj['y']``). Instead of giving
# the data in *x* and *y*, you can provide the object in the *data*
# parameter and just give the labels for *x* and *y*::
#
# >>> plot('xlabel', 'ylabel', data=obj)
#
# All indexable objects are supported. This could e.g. be a `dict`, a
# `pandas.DataFrame` or a structured numpy array.
#
#
# **Plotting multiple sets of data**
#
# There are various ways to plot multiple sets of data.
#
# - The most straight forward way is just to call `plot` multiple times.
#   Example:
#
#   >>> plot(x1, y1, 'bo')
#   >>> plot(x2, y2, 'go')
#
# - If *x* and/or *y* are 2D arrays a separate data set will be drawn
#   for every column. If both *x* and *y* are 2D, they must have the
#   same shape. If only one of them is 2D with shape (N, m) the other
#   must have length N and will be used for every data set m.
#
#   Example:
#
#   >>> x = [1, 2, 3]
#   >>> y = np.array([[1, 2], [3, 4], [5, 6]])
#   >>> plot(x, y)
#
#   is equivalent to:
#
#   >>> for col in range(y.shape[1]):
#   ...     plot(x, y[:, col])
#
# - The third way is to specify multiple sets of *[x]*, *y*, *[fmt]*
#   groups::
#
#   >>> plot(x1, y1, 'g^', x2, y2, 'g-')
#
#   In this case, any additional keyword argument applies to all
#   datasets. Also this syntax cannot be combined with the *data*
#   parameter.
#
# By default, each line is assigned a different style specified by a
# 'style cycle'. The *fmt* and line property parameters are only
# necessary if you want explicit deviations from these defaults.
# Alternatively, you can also change the style cycle using
# :rc:`axes.prop_cycle`.
#
#
# Parameters
# ----------
# x, y : array-like or scalar
#     The horizontal / vertical coordinates of the data points.
#     *x* values are optional and default to ``range(len(y))``.
#
#     Commonly, these parameters are 1D arrays.
#
#     They can also be scalars, or two-dimensional (in that case, the
#     columns represent separate data sets).
#
#     These arguments cannot be passed as keywords.
#
# fmt : str, optional
#     A format string, e.g. 'ro' for red circles. See the *Notes*
#     section for a full description of the format strings.
#
#     Format strings are just an abbreviation for quickly setting
#     basic line properties. All of these and more can also be
#     controlled by keyword arguments.
#
#     This argument cannot be passed as keyword.
#
# data : indexable object, optional
#     An object with labelled data. If given, provide the label names to
#     plot in *x* and *y*.
#
#     .. note::
#         Technically there's a slight ambiguity in calls where the
#         second label is a valid *fmt*. ``plot('n', 'o', data=obj)``
#         could be ``plt(x, y)`` or ``plt(y, fmt)``. In such cases,
#         the former interpretation is chosen, but a warning is issued.
#         You may suppress the warning by adding an empty format string
#         ``plot('n', 'o', '', data=obj)``.
#
# Returns
# -------
# list of `.Line2D`
#     A list of lines representing the plotted data.
#
# Other Parameters
# ----------------
# scalex, scaley : bool, default: True
#     These parameters determine if the view limits are adapted to the
#     data limits. The values are passed on to `autoscale_view`.
#
# **kwargs : `.Line2D` properties, optional
#     *kwargs* are used to specify properties like a line label (for
#     auto legends), linewidth, antialiasing, marker face color.
#     Example::
#
#     >>> plot([1, 2, 3], [1, 2, 3], 'go-', label='line 1', linewidth=2)
#     >>> plot([1, 2, 3], [1, 4, 9], 'rs', label='line 2')
#
#     If you specify multiple lines with one plot call, the kwargs apply
#     to all those lines. In case the label object is iterable, each
#     element is used as labels for each set of data.
#
#     Here is a list of available `.Line2D` properties:
#
#     Properties:
#     agg_filter: a filter function, which takes a (m, n, 3) float array and a dpi value, and returns a (m, n, 3) array
#     alpha: scalar or None
#     animated: bool
#     antialiased or aa: bool
#     clip_box: `.Bbox`
#     clip_on: bool
#     clip_path: Patch or (Path, Transform) or None
#     color or c: color
#     dash_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     dash_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     dashes: sequence of floats (on/off ink in points) or (None, None)
#     data: (2, N) array or two 1D arrays
#     drawstyle or ds: {'default', 'steps', 'steps-pre', 'steps-mid', 'steps-post'}, default: 'default'
#     figure: `.Figure`
#     fillstyle: {'full', 'left', 'right', 'bottom', 'top', 'none'}
#     gid: str
#     in_layout: bool
#     label: object
#     linestyle or ls: {'-', '--', '-.', ':', '', (offset, on-off-seq), ...}
#     linewidth or lw: float
#     marker: marker style string, `~.path.Path` or `~.markers.MarkerStyle`
#     markeredgecolor or mec: color
#     markeredgewidth or mew: float
#     markerfacecolor or mfc: color
#     markerfacecoloralt or mfcalt: color
#     markersize or ms: float
#     markevery: None or int or (int, int) or slice or list[int] or float or (float, float) or list[bool]
#     path_effects: `.AbstractPathEffect`
#     picker: float or callable[[Artist, Event], tuple[bool, dict]]
#     pickradius: float
#     rasterized: bool
#     sketch_params: (scale: float, length: float, randomness: float)
#     snap: bool or None
#     solid_capstyle: `.CapStyle` or {'butt', 'projecting', 'round'}
#     solid_joinstyle: `.JoinStyle` or {'miter', 'round', 'bevel'}
#     transform: unknown
#     url: str
#     visible: bool
#     xdata: 1D array
#     ydata: 1D array
#     zorder: float
#
# See Also
# --------
# scatter : XY scatter plot with markers of varying size and/or color (
#     sometimes also called bubble chart).
#
# Notes
# -----
# **Format Strings**
#
# A format string consists of a part for color, marker and line::
#
#     fmt = '[marker][line][color]'
#
# Each of them is optional. If not provided, the value from the style
# cycle is used. Exception: If ``line`` is given, but no ``marker``,
# the data will be a line without markers.
#
# Other combinations such as ``[color][marker][line]`` are also
# supported, but note that their parsing may be ambiguous.
#
# **Markers**
#
# =============   ===============================
# character       description
# =============   ===============================
# ``'.'``         point marker
# ``','``         pixel marker
# ``'o'``         circle marker
# ``'v'``         triangle_down marker
# ``'^'``         triangle_up marker
# ``'<'``         triangle_left marker
# ``'>'``         triangle_right marker
# ``'1'``         tri_down marker
# ``'2'``         tri_up marker
# ``'3'``         tri_left marker
# ``'4'``         tri_right marker
# ``'8'``         octagon marker
# ``'s'``         square marker
# ``'p'``         pentagon marker
# ``'P'``         plus (filled) marker
# ``'*'``         star marker
# ``'h'``         hexagon1 marker
# ``'H'``         hexagon2 marker
# ``'+'``         plus marker
# ``'x'``         x marker
# ``'X'``         x (filled) marker
# ``'D'``         diamond marker
# ``'d'``         thin_diamond marker
# ``'|'``         vline marker
# ``'_'``         hline marker
# =============   ===============================
#
# **Line Styles**
#
# =============    ===============================
# character        description
# =============    ===============================
# ``'-'``          solid line style
# ``'--'``         dashed line style
# ``'-.'``         dash-dot line style
# ``':'``          dotted line style
# =============    ===============================
#
# Example format strings::
#
#     'b'    # blue markers with default shape
#     'or'   # red circles
#     '-g'   # green solid line
#     '--'   # dashed line with default color
#     '^k:'  # black triangle_up markers connected by a dotted line
#
# **Colors**
#
# The supported color abbreviations are the single letter codes
#
# =============    ===============================
# character        color
# =============    ===============================
# ``'b'``          blue
# ``'g'``          green
# ``'r'``          red
# ``'c'``          cyan
# ``'m'``          magenta
# ``'y'``          yellow
# ``'k'``          black
# ``'w'``          white
# =============    ===============================
#
# and the ``'CN'`` colors that index into the default property cycle.
#
# If the color is the only part of the format string, you can
# additionally use any  `matplotlib.colors` spec, e.g. full names
# (``'green'``) or hex strings (``'#008000'``).
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u></summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u></summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.legend</u></summary>
# <blockquote>
# <code>
# Place a legend on the Axes.
#
# Call signatures::
#
#     legend()
#     legend(handles, labels)
#     legend(handles=handles)
#     legend(labels)
#
# The call signatures correspond to the following different ways to use
# this method:
#
# **1. Automatic detection of elements to be shown in the legend**
#
# The elements to be added to the legend are automatically determined,
# when you do not pass in any extra arguments.
#
# In this case, the labels are taken from the artist. You can specify
# them either at artist creation or by calling the
# :meth:`~.Artist.set_label` method on the artist::
#
#     ax.plot([1, 2, 3], label='Inline label')
#     ax.legend()
#
# or::
#
#     line, = ax.plot([1, 2, 3])
#     line.set_label('Label via method')
#     ax.legend()
#
# Specific lines can be excluded from the automatic legend element
# selection by defining a label starting with an underscore.
# This is default for all artists, so calling `.Axes.legend` without
# any arguments and without setting the labels manually will result in
# no legend being drawn.
#
#
# **2. Explicitly listing the artists and labels in the legend**
#
# For full control of which artists have a legend entry, it is possible
# to pass an iterable of legend artists followed by an iterable of
# legend labels respectively::
#
#     ax.legend([line1, line2, line3], ['label1', 'label2', 'label3'])
#
#
# **3. Explicitly listing the artists in the legend**
#
# This is similar to 2, but the labels are taken from the artists'
# label properties. Example::
#
#     line1, = ax.plot([1, 2, 3], label='label1')
#     line2, = ax.plot([1, 2, 3], label='label2')
#     ax.legend(handles=[line1, line2])
#
#
# **4. Labeling existing plot elements**
#
# .. admonition:: Discouraged
#
#     This call signature is discouraged, because the relation between
#     plot elements and labels is only implicit by their order and can
#     easily be mixed up.
#
# To make a legend for all artists on an Axes, call this function with
# an iterable of strings, one for each legend item. For example::
#
#     ax.plot([1, 2, 3])
#     ax.plot([5, 6, 7])
#     ax.legend(['First line', 'Second line'])
#
#
# Parameters
# ----------
# handles : sequence of `.Artist`, optional
#     A list of Artists (lines, patches) to be added to the legend.
#     Use this together with *labels*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
#     The length of handles and labels should be the same in this
#     case. If they are not, they are truncated to the smaller length.
#
# labels : list of str, optional
#     A list of labels to show next to the artists.
#     Use this together with *handles*, if you need full control on what
#     is shown in the legend and the automatic mechanism described above
#     is not sufficient.
#
# Returns
# -------
# `~matplotlib.legend.Legend`
#
# Other Parameters
# ----------------
#
# loc : str or pair of floats, default: :rc:`legend.loc` ('best' for axes, 'upper right' for figures)
#     The location of the legend.
#
#     The strings
#     ``'upper left', 'upper right', 'lower left', 'lower right'``
#     place the legend at the corresponding corner of the axes/figure.
#
#     The strings
#     ``'upper center', 'lower center', 'center left', 'center right'``
#     place the legend at the center of the corresponding edge of the
#     axes/figure.
#
#     The string ``'center'`` places the legend at the center of the axes/figure.
#
#     The string ``'best'`` places the legend at the location, among the nine
#     locations defined so far, with the minimum overlap with other drawn
#     artists.  This option can be quite slow for plots with large amounts of
#     data; your plotting speed may benefit from providing a specific location.
#
#     The location can also be a 2-tuple giving the coordinates of the lower-left
#     corner of the legend in axes coordinates (in which case *bbox_to_anchor*
#     will be ignored).
#
#     For back-compatibility, ``'center right'`` (but no other location) can also
#     be spelled ``'right'``, and each "string" locations can also be given as a
#     numeric value:
#
#         ===============   =============
#         Location String   Location Code
#         ===============   =============
#         'best'            0
#         'upper right'     1
#         'upper left'      2
#         'lower left'      3
#         'lower right'     4
#         'right'           5
#         'center left'     6
#         'center right'    7
#         'lower center'    8
#         'upper center'    9
#         'center'          10
#         ===============   =============
#
# bbox_to_anchor : `.BboxBase`, 2-tuple, or 4-tuple of floats
#     Box that is used to position the legend in conjunction with *loc*.
#     Defaults to `axes.bbox` (if called as a method to `.Axes.legend`) or
#     `figure.bbox` (if `.Figure.legend`).  This argument allows arbitrary
#     placement of the legend.
#
#     Bbox coordinates are interpreted in the coordinate system given by
#     *bbox_transform*, with the default transform
#     Axes or Figure coordinates, depending on which ``legend`` is called.
#
#     If a 4-tuple or `.BboxBase` is given, then it specifies the bbox
#     ``(x, y, width, height)`` that the legend is placed in.
#     To put the legend in the best location in the bottom right
#     quadrant of the axes (or figure)::
#
#         loc='best', bbox_to_anchor=(0.5, 0., 0.5, 0.5)
#
#     A 2-tuple ``(x, y)`` places the corner of the legend specified by *loc* at
#     x, y.  For example, to put the legend's upper right-hand corner in the
#     center of the axes (or figure) the following keywords can be used::
#
#         loc='upper right', bbox_to_anchor=(0.5, 0.5)
#
# ncol : int, default: 1
#     The number of columns that the legend has.
#
# prop : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend. If None (default), the current
#     :data:`matplotlib.rcParams` will be used.
#
# fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}
#     The font size of the legend. If the value is numeric the size will be the
#     absolute font size in points. String values are relative to the current
#     default font size. This argument is only used if *prop* is not specified.
#
# labelcolor : str or list, default: :rc:`legend.labelcolor`
#     The color of the text in the legend. Either a valid color string
#     (for example, 'red'), or a list of color strings. The labelcolor can
#     also be made to match the color of the line or marker using 'linecolor',
#     'markerfacecolor' (or 'mfc'), or 'markeredgecolor' (or 'mec').
#
#     Labelcolor can be set globally using :rc:`legend.labelcolor`. If None,
#     use :rc:`text.color`.
#
# numpoints : int, default: :rc:`legend.numpoints`
#     The number of marker points in the legend when creating a legend
#     entry for a `.Line2D` (line).
#
# scatterpoints : int, default: :rc:`legend.scatterpoints`
#     The number of marker points in the legend when creating
#     a legend entry for a `.PathCollection` (scatter plot).
#
# scatteryoffsets : iterable of floats, default: ``[0.375, 0.5, 0.3125]``
#     The vertical offset (relative to the font size) for the markers
#     created for a scatter plot legend entry. 0.0 is at the base the
#     legend text, and 1.0 is at the top. To draw all markers at the
#     same height, set to ``[0.5]``.
#
# markerscale : float, default: :rc:`legend.markerscale`
#     The relative size of legend markers compared with the originally
#     drawn ones.
#
# markerfirst : bool, default: True
#     If *True*, legend marker is placed to the left of the legend label.
#     If *False*, legend marker is placed to the right of the legend label.
#
# frameon : bool, default: :rc:`legend.frameon`
#     Whether the legend should be drawn on a patch (frame).
#
# fancybox : bool, default: :rc:`legend.fancybox`
#     Whether round edges should be enabled around the `.FancyBboxPatch` which
#     makes up the legend's background.
#
# shadow : bool, default: :rc:`legend.shadow`
#     Whether to draw a shadow behind the legend.
#
# framealpha : float, default: :rc:`legend.framealpha`
#     The alpha transparency of the legend's background.
#     If *shadow* is activated and *framealpha* is ``None``, the default value is
#     ignored.
#
# facecolor : "inherit" or color, default: :rc:`legend.facecolor`
#     The legend's background color.
#     If ``"inherit"``, use :rc:`axes.facecolor`.
#
# edgecolor : "inherit" or color, default: :rc:`legend.edgecolor`
#     The legend's background patch edge color.
#     If ``"inherit"``, use take :rc:`axes.edgecolor`.
#
# mode : {"expand", None}
#     If *mode* is set to ``"expand"`` the legend will be horizontally
#     expanded to fill the axes area (or *bbox_to_anchor* if defines
#     the legend's size).
#
# bbox_transform : None or `matplotlib.transforms.Transform`
#     The transform for the bounding box (*bbox_to_anchor*). For a value
#     of ``None`` (default) the Axes'
#     :data:`~matplotlib.axes.Axes.transAxes` transform will be used.
#
# title : str or None
#     The legend's title. Default is no title (``None``).
#
# title_fontproperties : None or `matplotlib.font_manager.FontProperties` or dict
#     The font properties of the legend's title. If None (default), the
#     *title_fontsize* argument will be used if present; if *title_fontsize* is
#     also None, the current :rc:`legend.title_fontsize` will be used.
#
# title_fontsize : int or {'xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'}, default: :rc:`legend.title_fontsize`
#     The font size of the legend's title.
#     Note: This cannot be combined with *title_fontproperties*. If you want
#     to set the fontsize alongside other font properties, use the *size*
#     parameter in *title_fontproperties*.
#
# borderpad : float, default: :rc:`legend.borderpad`
#     The fractional whitespace inside the legend border, in font-size units.
#
# labelspacing : float, default: :rc:`legend.labelspacing`
#     The vertical space between the legend entries, in font-size units.
#
# handlelength : float, default: :rc:`legend.handlelength`
#     The length of the legend handles, in font-size units.
#
# handleheight : float, default: :rc:`legend.handleheight`
#     The height of the legend handles, in font-size units.
#
# handletextpad : float, default: :rc:`legend.handletextpad`
#     The pad between the legend handle and text, in font-size units.
#
# borderaxespad : float, default: :rc:`legend.borderaxespad`
#     The pad between the axes and legend border, in font-size units.
#
# columnspacing : float, default: :rc:`legend.columnspacing`
#     The spacing between columns, in font-size units.
#
# handler_map : dict or None
#     The custom dictionary mapping instances or types to a legend
#     handler. This *handler_map* updates the default handler map
#     found at `matplotlib.legend.Legend.get_legend_handler_map`.
#
#
# See Also
# --------
# .Figure.legend
#
# Notes
# -----
# Some artists are not supported by this function.  See
# :doc:`/tutorials/intermediate/legend_guide` for details.
#
# Examples
# --------
# .. plot:: gallery/text_labels_and_annotations/legend.py
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="487c5432ed4a6ef8f5e2583e1a93423716e6350f"
# Plot the loss and accuracy curves for training and validation 
plt.plot(history.history['val_loss'], color='b', label="validation loss")
plt.xlabel("Number of Epochs")
plt.ylabel("Loss")
plt.legend()
plt.show()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>12. Data Preparation | Feature Engineering | Library Loading | Model Building and Training | Visualization</h1>  <a id='12'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u></summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.confusion_matrix</u></summary>
# <blockquote>
# <code>
# Compute confusion matrix to evaluate the accuracy of a classification.
#
# By definition a confusion matrix :math:`C` is such that :math:`C_{i, j}`
# is equal to the number of observations known to be in group :math:`i` and
# predicted to be in group :math:`j`.
#
# Thus in binary classification, the count of true negatives is
# :math:`C_{0,0}`, false negatives is :math:`C_{1,0}`, true positives is
# :math:`C_{1,1}` and false positives is :math:`C_{0,1}`.
#
# Read more in the :ref:`User Guide <confusion_matrix>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,)
#     Ground truth (correct) target values.
#
# y_pred : array-like of shape (n_samples,)
#     Estimated targets as returned by a classifier.
#
# labels : array-like of shape (n_classes), default=None
#     List of labels to index the matrix. This may be used to reorder
#     or select a subset of labels.
#     If ``None`` is given, those that appear at least once
#     in ``y_true`` or ``y_pred`` are used in sorted order.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
#     .. versionadded:: 0.18
#
# normalize : {'true', 'pred', 'all'}, default=None
#     Normalizes confusion matrix over the true (rows), predicted (columns)
#     conditions or all the population. If None, confusion matrix will not be
#     normalized.
#
# Returns
# -------
# C : ndarray of shape (n_classes, n_classes)
#     Confusion matrix whose i-th row and j-th
#     column entry indicates the number of
#     samples with true label being i-th class
#     and predicted label being j-th class.
#
# See Also
# --------
# ConfusionMatrixDisplay.from_estimator : Plot the confusion matrix
#     given an estimator, the data, and the label.
# ConfusionMatrixDisplay.from_predictions : Plot the confusion matrix
#     given the true and predicted labels.
# ConfusionMatrixDisplay : Confusion Matrix visualization.
#
# References
# ----------
# .. [1] `Wikipedia entry for the Confusion matrix
#        <https://en.wikipedia.org/wiki/Confusion_matrix>`_
#        (Wikipedia and other references may use a different
#        convention for axes).
#
# Examples
# --------
# >>> from sklearn.metrics import confusion_matrix
# >>> y_true = [2, 0, 2, 2, 0, 1]
# >>> y_pred = [0, 0, 2, 2, 0, 2]
# >>> confusion_matrix(y_true, y_pred)
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# >>> y_true = ["cat", "ant", "cat", "cat", "ant", "bird"]
# >>> y_pred = ["ant", "ant", "cat", "cat", "ant", "cat"]
# >>> confusion_matrix(y_true, y_pred, labels=["ant", "bird", "cat"])
# array([[2, 0, 0],
#        [0, 0, 1],
#        [1, 0, 2]])
#
# In the binary case, we can extract true positives, etc as follows:
#
# >>> tn, fp, fn, tp = confusion_matrix([0, 1, 0, 1], [1, 1, 1, 0]).ravel()
# >>> (tn, fp, fn, tp)
# (0, 2, 1, 1)
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.subplots</u></summary>
# <blockquote>
# <code>
# Create a figure and a set of subplots.
#
# This utility wrapper makes it convenient to create common layouts of
# subplots, including the enclosing figure object, in a single call.
#
# Parameters
# ----------
# nrows, ncols : int, default: 1
#     Number of rows/columns of the subplot grid.
#
# sharex, sharey : bool or {'none', 'all', 'row', 'col'}, default: False
#     Controls sharing of properties among x (*sharex*) or y (*sharey*)
#     axes:
#
#     - True or 'all': x- or y-axis will be shared among all subplots.
#     - False or 'none': each subplot x- or y-axis will be independent.
#     - 'row': each subplot row will share an x- or y-axis.
#     - 'col': each subplot column will share an x- or y-axis.
#
#     When subplots have a shared x-axis along a column, only the x tick
#     labels of the bottom subplot are created. Similarly, when subplots
#     have a shared y-axis along a row, only the y tick labels of the first
#     column subplot are created. To later turn other subplots' ticklabels
#     on, use `~matplotlib.axes.Axes.tick_params`.
#
#     When subplots have a shared axis that has units, calling
#     `~matplotlib.axis.Axis.set_units` will update each axis with the
#     new units.
#
# squeeze : bool, default: True
#     - If True, extra dimensions are squeezed out from the returned
#       array of `~matplotlib.axes.Axes`:
#
#       - if only one subplot is constructed (nrows=ncols=1), the
#         resulting single Axes object is returned as a scalar.
#       - for Nx1 or 1xM subplots, the returned object is a 1D numpy
#         object array of Axes objects.
#       - for NxM, subplots with N>1 and M>1 are returned as a 2D array.
#
#     - If False, no squeezing at all is done: the returned Axes object is
#       always a 2D array containing Axes instances, even if it ends up
#       being 1x1.
#
# subplot_kw : dict, optional
#     Dict with keywords passed to the
#     `~matplotlib.figure.Figure.add_subplot` call used to create each
#     subplot.
#
# gridspec_kw : dict, optional
#     Dict with keywords passed to the `~matplotlib.gridspec.GridSpec`
#     constructor used to create the grid the subplots are placed on.
#
# **fig_kw
#     All additional keyword arguments are passed to the
#     `.pyplot.figure` call.
#
# Returns
# -------
# fig : `~.figure.Figure`
#
# ax : `.axes.Axes` or array of Axes
#     *ax* can be either a single `~matplotlib.axes.Axes` object or an
#     array of Axes objects if more than one subplot was created.  The
#     dimensions of the resulting array can be controlled with the squeeze
#     keyword, see above.
#
#     Typical idioms for handling the return value are::
#
#         # using the variable ax for single a Axes
#         fig, ax = plt.subplots()
#
#         # using the variable axs for multiple Axes
#         fig, axs = plt.subplots(2, 2)
#
#         # using tuple unpacking for multiple Axes
#         fig, (ax1, ax2) = plt.subplots(1, 2)
#         fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2)
#
#     The names ``ax`` and pluralized ``axs`` are preferred over ``axes``
#     because for the latter it's not clear if it refers to a single
#     `~.axes.Axes` instance or a collection of these.
#
# See Also
# --------
# .pyplot.figure
# .pyplot.subplot
# .pyplot.axes
# .Figure.subplots
# .Figure.add_subplot
#
# Examples
# --------
# ::
#
#     # First create some toy data:
#     x = np.linspace(0, 2*np.pi, 400)
#     y = np.sin(x**2)
#
#     # Create just a figure and only one subplot
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#     ax.set_title('Simple plot')
#
#     # Create two subplots and unpack the output array immediately
#     f, (ax1, ax2) = plt.subplots(1, 2, sharey=True)
#     ax1.plot(x, y)
#     ax1.set_title('Sharing Y axis')
#     ax2.scatter(x, y)
#
#     # Create four polar axes and access them through the returned array
#     fig, axs = plt.subplots(2, 2, subplot_kw=dict(projection="polar"))
#     axs[0, 0].plot(x, y)
#     axs[1, 1].scatter(x, y)
#
#     # Share a X axis with each column of subplots
#     plt.subplots(2, 2, sharex='col')
#
#     # Share a Y axis with each row of subplots
#     plt.subplots(2, 2, sharey='row')
#
#     # Share both X and Y axes with all subplots
#     plt.subplots(2, 2, sharex='all', sharey='all')
#
#     # Note that this is the same as
#     plt.subplots(2, 2, sharex=True, sharey=True)
#
#     # Create figure number 10 with a single subplot
#     # and clears it if it already exists.
#     fig, ax = plt.subplots(num=10, clear=True)
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.xlabel</u></summary>
# <blockquote>
# <code>
# Set the label for the x-axis.
#
# Parameters
# ----------
# xlabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'left', 'center', 'right'}, default: :rc:`xaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *x* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.ylabel</u></summary>
# <blockquote>
# <code>
# Set the label for the y-axis.
#
# Parameters
# ----------
# ylabel : str
#     The label text.
#
# labelpad : float, default: :rc:`axes.labelpad`
#     Spacing in points from the Axes bounding box including ticks
#     and tick labels.  If None, the previous value is left as is.
#
# loc : {'bottom', 'center', 'top'}, default: :rc:`yaxis.labellocation`
#     The label position. This is a high-level alternative for passing
#     parameters *y* and *horizontalalignment*.
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     `.Text` properties control the appearance of the label.
#
# See Also
# --------
# text : Documents the properties supported by `.Text`.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u></summary>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.show</u></summary>
# <blockquote>
# <code>
# Display all open figures.
#
# Parameters
# ----------
# block : bool, optional
#     Whether to wait for all figures to be closed before returning.
#
#     If `True` block and run the GUI main loop until all figure windows
#     are closed.
#
#     If `False` ensure that all figure windows are displayed and return
#     immediately.  In this case, you are responsible for ensuring
#     that the event loop is running to have responsive figures.
#
#     Defaults to True in non-interactive mode and to False in interactive
#     mode (see `.pyplot.isinteractive`).
#
# See Also
# --------
# ion : Enable interactive mode, which shows / updates the figure after
#       every plotting command, so that calling ``show()`` is not necessary.
# ioff : Disable interactive mode.
# savefig : Save the figure to an image file instead of showing it on screen.
#
# Notes
# -----
# **Saving figures to file and showing a window at the same time**
#
# If you want an image file as well as a user interface window, use
# `.pyplot.savefig` before `.pyplot.show`. At the end of (a blocking)
# ``show()`` the figure is closed and thus unregistered from pyplot. Calling
# `.pyplot.savefig` afterwards would save a new and thus empty figure. This
# limitation of command order does not apply if the show is non-blocking or
# if you keep a reference to the figure and use `.Figure.savefig`.
#
# **Auto-show in jupyter notebooks**
#
# The jupyter backends (activated via ``%matplotlib inline``,
# ``%matplotlib notebook``, or ``%matplotlib widget``), call ``show()`` at
# the end of every cell by default. Thus, you usually don't have to call it
# explicitly there.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u></summary>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="f6be620cee72b5b9f411c0daa3ab4dadbe58f223"
# confusion matrix
import seaborn as sns
from sklearn.metrics import confusion_matrix
# Predict the values from the validation dataset
y_pred = model.predict(X_val)
y_final = (y_pred > 0.5).astype(int).reshape(X_val.shape[0])
# compute the confusion matrix
confusion_mtx = confusion_matrix(Y_val, y_final) 
# plot the confusion matrix
f,ax = plt.subplots(figsize=(8, 8))
sns.heatmap(confusion_mtx, annot=True, linewidths=0.01,cmap="Greens",linecolor="gray", fmt= '.1f',ax=ax)
plt.xlabel("Predicted Label")
plt.ylabel("True Label")
plt.title("Confusion Matrix")
plt.show()

# %% _uuid="eced493bb8226d199354caefee1bb69e15e8bc28"
# model 3
'''
from keras.layers import Input
import keras
from keras.models import Model

def DenseNet(X_train):
    ip = Input(shape=(X_train.shape[1],))
    x_list = [ip]
    
    x = Dense(128, use_bias=False)(ip)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)

    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(128, use_bias=False)(x)    
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)

    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(64, use_bias=False)(x)    
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)

    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(64, use_bias=False)(x)    
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)

    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(32, use_bias=False)(x)    
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)

    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(32, use_bias=False)(x)    
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)

    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(16, use_bias=False)(x)    
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)
    
    x_list.append(x)
    x = keras.layers.concatenate(x_list)    
    x = Dense(16, use_bias=False)(ip)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.5)(x)    
    
    op = Dense(1, activation='sigmoid')(x)

    model = Model(inputs=ip, outputs=op)
    adam = Adam(lr=0.05,)
    model.compile(loss='binary_crossentropy', optimizer=adam, metrics=['accuracy'])
    return model

model = DenseNet(X_train)
history_model=model.fit(X_train, Y_train, epochs=32, batch_size=200, verbose=0,
          validation_split=0.1)
scores = model.evaluate(X_train, Y_train, verbose=0)
print("%s: %.3f%%" % (model.metrics_names[1], scores[1]*100))
'''


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>14. Data Preparation | Feature Engineering</h1>  <a id='14'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u></summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="417caaedebc5cd53925d6b69a0639a2db2c91364"
test = test_orj.copy()
test=preprocess(test)
test=group_titles(test)
test = test.drop(["Name"],axis=1)
test.head()
#print(test.Title.value_counts())
test.info()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>15. Visualization</h1>  <a id='15'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u></summary>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#15'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="959d59cae62b742c04c82b04530de86acc96ea67"
sns.countplot(test.Age, palette="icefire")
#train.Age.value_counts()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>16. Data Preparation | Feature Engineering | Model Building and Training | Visualization</h1>  <a id='16'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.reshape</u></summary>
# <blockquote>
# <code>
# a.reshape(shape, order='C')
#
# Returns an array containing the same data with a new shape.
#
# Refer to `numpy.reshape` for full documentation.
#
# See Also
# --------
# numpy.reshape : equivalent function
#
# Notes
# -----
# Unlike the free function `numpy.reshape`, this method on `ndarray` allows
# the elements of the shape parameter to be passed in as separate arguments.
# For example, ``a.reshape(10, 11)`` is equivalent to
# ``a.reshape((10, 11))``.
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>matplotlib</h2>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot.figure</u></summary>
# <blockquote>
# <code>
# Create a new figure, or activate an existing figure.
#
# Parameters
# ----------
# num : int or str or `.Figure`, optional
#     A unique identifier for the figure.
#
#     If a figure with that identifier already exists, this figure is made
#     active and returned. An integer refers to the ``Figure.number``
#     attribute, a string refers to the figure label.
#
#     If there is no figure with the identifier or *num* is not given, a new
#     figure is created, made active and returned.  If *num* is an int, it
#     will be used for the ``Figure.number`` attribute, otherwise, an
#     auto-generated integer value is used (starting at 1 and incremented
#     for each new figure). If *num* is a string, the figure label and the
#     window title is set to this value.
#
# figsize : (float, float), default: :rc:`figure.figsize`
#     Width, height in inches.
#
# dpi : float, default: :rc:`figure.dpi`
#     The resolution of the figure in dots-per-inch.
#
# facecolor : color, default: :rc:`figure.facecolor`
#     The background color.
#
# edgecolor : color, default: :rc:`figure.edgecolor`
#     The border color.
#
# frameon : bool, default: True
#     If False, suppress drawing the figure frame.
#
# FigureClass : subclass of `~matplotlib.figure.Figure`
#     Optionally use a custom `.Figure` instance.
#
# clear : bool, default: False
#     If True and the figure already exists, then it is cleared.
#
# tight_layout : bool or dict, default: :rc:`figure.autolayout`
#     If ``False`` use *subplotpars*. If ``True`` adjust subplot
#     parameters using `.tight_layout` with default padding.
#     When providing a dict containing the keys ``pad``, ``w_pad``,
#     ``h_pad``, and ``rect``, the default `.tight_layout` paddings
#     will be overridden.
#
# constrained_layout : bool, default: :rc:`figure.constrained_layout.use`
#     If ``True`` use constrained layout to adjust positioning of plot
#     elements.  Like ``tight_layout``, but designed to be more
#     flexible.  See
#     :doc:`/tutorials/intermediate/constrainedlayout_guide`
#     for examples.  (Note: does not work with `add_subplot` or
#     `~.pyplot.subplot2grid`.)
#
#
# **kwargs : optional
#     See `~.matplotlib.figure.Figure` for other possible arguments.
#
# Returns
# -------
# `~matplotlib.figure.Figure`
#     The `.Figure` instance returned will also be passed to
#     new_figure_manager in the backends, which allows to hook custom
#     `.Figure` classes into the pyplot interface. Additional kwargs will be
#     passed to the `.Figure` init function.
#
# Notes
# -----
# If you are creating many figures, make sure you explicitly call
# `.pyplot.close` on the figures you are not using, because this will
# enable pyplot to properly clean up the memory.
#
# `~matplotlib.rcParams` defines the default values, which can be modified
# in the matplotlibrc file.
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>matplotlib.pyplot.title</u></summary>
# <blockquote>
# <code>
# Set a title for the Axes.
#
# Set one of the three available Axes titles. The available titles
# are positioned above the Axes in the center, flush with the left
# edge, and flush with the right edge.
#
# Parameters
# ----------
# label : str
#     Text to use for the title
#
# fontdict : dict
#     A dictionary controlling the appearance of the title text,
#     the default *fontdict* is::
#
#        {'fontsize': rcParams['axes.titlesize'],
#         'fontweight': rcParams['axes.titleweight'],
#         'color': rcParams['axes.titlecolor'],
#         'verticalalignment': 'baseline',
#         'horizontalalignment': loc}
#
# loc : {'center', 'left', 'right'}, default: :rc:`axes.titlelocation`
#     Which title to set.
#
# y : float, default: :rc:`axes.titley`
#     Vertical Axes location for the title (1.0 is the top).  If
#     None (the default) and :rc:`axes.titley` is also None, y is
#     determined automatically to avoid decorators on the Axes.
#
# pad : float, default: :rc:`axes.titlepad`
#     The offset of the title from the top of the Axes, in points.
#
# Returns
# -------
# `.Text`
#     The matplotlib text instance representing the title
#
# Other Parameters
# ----------------
# **kwargs : `.Text` properties
#     Other keyword arguments are text properties, see `.Text` for a list
#     of valid text properties.
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.categorical.countplot</u></summary>
# <blockquote>
# <code>
# Show the counts of observations in each categorical bin using bars.
#
# A count plot can be thought of as a histogram across a categorical, instead
# of quantitative, variable. The basic API and options are identical to those
# for :func:`barplot`, so you can compare counts across nested variables.
#
#
# Input data can be passed in a variety of formats, including:
#
# - Vectors of data represented as lists, numpy arrays, or pandas Series
#   objects passed directly to the ``x``, ``y``, and/or ``hue`` parameters.
# - A "long-form" DataFrame, in which case the ``x``, ``y``, and ``hue``
#   variables will determine how the data are plotted.
# - A "wide-form" DataFrame, such that each numeric column will be plotted.
# - An array or list of vectors.
#
# In most cases, it is possible to use numpy or Python objects, but pandas
# objects are preferable because the associated names will be used to
# annotate the axes. Additionally, you can use Categorical types for the
# grouping variables to control the order of plot elements.    
#
# This function always treats one of the variables as categorical and
# draws data at ordinal positions (0, 1, ... n) on the relevant axis, even
# when the data has a numeric or date type.
#
# See the :ref:`tutorial <categorical_tutorial>` for more information.    
#
# Parameters
# ----------
# x, y, hue : names of variables in ``data`` or vector data, optional
#     Inputs for plotting long-form data. See examples for interpretation.        
# data : DataFrame, array, or list of arrays, optional
#     Dataset for plotting. If ``x`` and ``y`` are absent, this is
#     interpreted as wide-form. Otherwise it is expected to be long-form.    
# order, hue_order : lists of strings, optional
#     Order to plot the categorical levels in, otherwise the levels are
#     inferred from the data objects.        
# orient : "v" | "h", optional
#     Orientation of the plot (vertical or horizontal). This is usually
#     inferred based on the type of the input variables, but it can be used
#     to resolve ambiguity when both `x` and `y` are numeric or when
#     plotting wide-form data.    
# color : matplotlib color, optional
#     Color for all of the elements, or seed for a gradient palette.    
# palette : palette name, list, or dict
#     Colors to use for the different levels of the ``hue`` variable. Should
#     be something that can be interpreted by :func:`color_palette`, or a
#     dictionary mapping hue levels to matplotlib colors.    
# saturation : float, optional
#     Proportion of the original saturation to draw colors at. Large patches
#     often look better with slightly desaturated colors, but set this to
#     ``1`` if you want the plot colors to perfectly match the input color
#     spec.    
# dodge : bool, optional
#     When hue nesting is used, whether elements should be shifted along the
#     categorical axis.    
# ax : matplotlib Axes, optional
#     Axes object to draw the plot onto, otherwise uses the current Axes.    
# kwargs : key, value mappings
#     Other keyword arguments are passed through to
#     :meth:`matplotlib.axes.Axes.bar`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Returns the Axes object with the plot drawn onto it.    
#
# See Also
# --------
# barplot : Show point estimates and confidence intervals using bars.    
# catplot : Combine a categorical plot with a :class:`FacetGrid`.    
#
# Examples
# --------
#
# Show value counts for a single categorical variable:
#
# .. plot::
#     :context: close-figs
#
#     >>> import seaborn as sns
#     >>> sns.set_theme(style="darkgrid")
#     >>> titanic = sns.load_dataset("titanic")
#     >>> ax = sns.countplot(x="class", data=titanic)
#
# Show value counts for two categorical variables:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="class", hue="who", data=titanic)
#
# Plot the bars horizontally:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(y="class", hue="who", data=titanic)
#
# Use a different color palette:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic, palette="Set3")
#
# Use :meth:`matplotlib.axes.Axes.bar` parameters to control the style.
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.countplot(x="who", data=titanic,
#     ...                    facecolor=(0, 0, 0, 0),
#     ...                    linewidth=5,
#     ...                    edgecolor=sns.color_palette("dark", 3))
#
# Use :func:`catplot` to combine a :func:`countplot` and a
# :class:`FacetGrid`. This allows grouping within additional categorical
# variables. Using :func:`catplot` is safer than using :class:`FacetGrid`
# directly, as it ensures synchronization of variable order across facets:
#
# .. plot::
#     :context: close-figs
#
#     >>> g = sns.catplot(x="class", hue="who", col="survived",
#     ...                 data=titanic, kind="count",
#     ...                 height=4, aspect=.7);
#
# </code>
# <a href='#16'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="816ff32b1086e438cd245d46c927bd81346eadfc"
test_ids = test.iloc[:,0].values #test_orj['PassengerId'].copy()
testdata = test.iloc[:,1:test.shape[1]].values #bağımsız değişkenler
X_test =testdata # np.array(testdata).astype(float)

#print(len(X_test))
#print(X_test[0])

y_pred = model.predict(X_test)
y_final = (y_pred > 0.5).astype(int).reshape(X_test.shape[0])
#print(len(y_final))
output = pd.DataFrame({'PassengerId': test_orj['PassengerId'], 'Survived': y_final})
output.to_csv('prediction-ann_0150.csv', index=False)

plt.figure(figsize=(10,5))
sns.countplot(y_final, palette="icefire")
plt.title("(Test data) Number of Survived classes")
