# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>h5py</b></li>
# <li><b>keras</b></li>
# <li><b>matplotlib</b></li>
# <li><b>numpy</b></li>
# <li><b>pandas</b></li>
# <li><b>tensorflow</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Visualization</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h4><s>Data Profiling and Exploratory Data Analysis</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Data Cleaning Filtering</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Data Sub-sampling and Train-test Splitting</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h4><s>Feature Transformation</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Feature Selection</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h4><s>Model Training</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Validation and Assembling</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
import pandas as pd
import numpy as np
import h5py
import tensorflow as tf
from tensorflow import keras
from keras.models import Sequential
from keras.layers import Dense
from keras.layers import Dropout
from keras.optimizers import Adam
from keras.optimizers import SGD
import matplotlib.pyplot as plt
from keras.models import load_model


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small>

# %%
train_df = pd.read_csv("../input/titanic/train.csv")
test_df = pd.read_csv("../input/titanic/test.csv")

# %%
train_df['Age'].fillna((train_df['Age'].mean()),inplace=True)

test_df['Age'].fillna((test_df['Age'].mean()),inplace=True)

train_df['Sex'] = train_df['Sex'].replace('male',value = 1)
train_df['Sex'] = train_df['Sex'].replace('female',value = 0)

test_df['Sex'] = test_df['Sex'].replace('male',value = 1)
test_df['Sex'] = test_df['Sex'].replace('female',value = 0)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Data Preparation</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small>

# %%
train_df.describe()

# %%
n_train = 700
X_train_class = train_df["Pclass"].values.reshape(-1,1)
X_train_sex = train_df["Sex"].values.reshape(-1,1)
X_train_age = train_df["Age"].values.reshape(-1,1)
X_train_sib = train_df["SibSp"].values.reshape(-1,1)
X_train_par = train_df["Parch"].values.reshape(-1,1)


y = train_df["Survived"].values.T


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>6. Data Preparation | Feature Engineering</h1>  <a id='6'></a><small><a href='#top_phases'>back to top</a></small>

# %%
X_train = np.hstack((X_train_sex[:n_train,:],X_train_class[:n_train,:],X_train_sib[:n_train,:],X_train_age[:n_train,:],X_train_par[:n_train,:]))
X_test = np.hstack((X_train_sex[n_train:,:],X_train_class[n_train:,:],X_train_sib[n_train:,:],X_train_age[n_train:,:],X_train_par[n_train:,:]))
X_train, X_test = tf.convert_to_tensor(X_train.astype(np.float64)),tf.convert_to_tensor(X_test.astype(np.float64))
y_train, y_test = y[:n_train], y[n_train:]


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>7. Model Building and Training</h1>  <a id='7'></a><small><a href='#top_phases'>back to top</a></small>

# %%
model = Sequential()
model.add(Dense(300,input_dim=5,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(150,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(100,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(50,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(25,activation='relu'))
model.add(Dropout(0.2))
model.add(Dense(1,activation='sigmoid'))
model.compile(loss='binary_crossentropy', optimizer=Adam(learning_rate=0.01,beta_1=0.99,beta_2=0.999), metrics=['accuracy'])


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>8. Model Building and Training</h1>  <a id='8'></a><small><a href='#top_phases'>back to top</a></small>

# %%
history = model.fit(X_train, y_train, validation_data=(X_test, y_test), epochs = 300, verbose = 0)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>9. Model Building and Training | Visualization</h1>  <a id='9'></a><small><a href='#top_phases'>back to top</a></small>

# %%
_, train_acc = model.evaluate(X_train, y_train, verbose=2)
_, test_acc = model.evaluate(X_test, y_test, verbose=2)
print('Train: %.3f, Test: %.3f' % (train_acc, test_acc))

plt.plot(history.history['accuracy'], label='train')
plt.plot(history.history['val_accuracy'], label='test')
plt.legend()
plt.show()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>10. Model Building and Training</h1>  <a id='10'></a><small><a href='#top_phases'>back to top</a></small>

# %%
model.save('model_' + str(1) + '.h5')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>11. Model Building and Training</h1>  <a id='11'></a><small><a href='#top_phases'>back to top</a></small>

# %%
model = load_model("./model_1.h5")
model.summary()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>12. Data Preparation | Feature Engineering</h1>  <a id='12'></a><small><a href='#top_phases'>back to top</a></small>

# %%
X_test_class = test_df["Pclass"].values.reshape(-1,1)
X_test_sex = test_df["Sex"].values.reshape(-1,1)
X_test_age = test_df["Age"].values.reshape(-1,1)
X_test_sib = test_df["SibSp"].values.reshape(-1,1)
X_test_par = test_df["Parch"].values.reshape(-1,1)

x_test = np.hstack((X_test_sex,X_test_class,X_test_sib,X_test_age,X_test_par)).astype(np.float64)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>13. Data Preparation | Model Building and Training</h1>  <a id='13'></a><small><a href='#top_phases'>back to top</a></small>

# %%
y_pred =[]
prediction = model.predict(x_test).ravel().tolist()
y_pred += prediction

# %%
for i in range(0,len(y_pred)):
    if y_pred[i] > 0.8:
        y_pred[i] = 1
    else:
        y_pred[i] = 0


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>15. Data Preparation</h1>  <a id='15'></a><small><a href='#top_phases'>back to top</a></small>

# %%
submission = pd.read_csv('../input/titanic/gender_submission.csv')
submission['Survived'] = y_pred
submission.to_csv('submission.csv',index=False)

# %%
