# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>keras</b></li>
# <li><b>numpy</b></li>
# <li><b>os</b></li>
# <li><b>pandas</b></li>
# <li><b>random</b></li>
# <li><b>scipy</b></li>
# <li><b>sklearn</b></li>
# <li><b>time</b></li>
# <li><b>warnings</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Visualization</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'drop': True}</li></ul>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.pop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['target'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Return item and drop from frame. Raise KeyError if not found.
#
# Parameters
# ----------
# item : label
#     Label of column to be popped.
#
# Returns
# -------
# Series
#
# Examples
# --------
# >>> df = pd.DataFrame([('falcon', 'bird', 389.0),
# ...                    ('parrot', 'bird', 24.0),
# ...                    ('lion', 'mammal', 80.5),
# ...                    ('monkey', 'mammal', np.nan)],
# ...                   columns=('name', 'class', 'max_speed'))
# >>> df
#      name   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# >>> df.pop('class')
# 0      bird
# 1      bird
# 2    mammal
# 3    mammal
# Name: class, dtype: object
#
# >>> df
#      name  max_speed
# 0  falcon      389.0
# 1  parrot       24.0
# 2    lion       80.5
# 3  monkey        NaN
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.clip</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.99] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Clip (limit) the values in an array.
#
# Given an interval, values outside the interval are clipped to
# the interval edges.  For example, if an interval of ``[0, 1]``
# is specified, values smaller than 0 become 0, and values larger
# than 1 become 1.
#
# Equivalent to but faster than ``np.minimum(a_max, np.maximum(a, a_min))``.
#
# No check is performed to ensure ``a_min < a_max``.
#
# Parameters
# ----------
# a : array_like
#     Array containing elements to clip.
# a_min, a_max : array_like or None
#     Minimum and maximum value. If ``None``, clipping is not performed on
#     the corresponding edge. Only one of `a_min` and `a_max` may be
#     ``None``. Both are broadcast against `a`.
# out : ndarray, optional
#     The results will be placed in this array. It may be the input
#     array for in-place clipping.  `out` must be of the right shape
#     to hold the output.  Its type is preserved.
# **kwargs
#     For other keyword-only arguments, see the
#     :ref:`ufunc docs <ufuncs.kwargs>`.
#
#     .. versionadded:: 1.17.0
#
# Returns
# -------
# clipped_array : ndarray
#     An array with the elements of `a`, but where values
#     < `a_min` are replaced with `a_min`, and those > `a_max`
#     with `a_max`.
#
# See Also
# --------
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# When `a_min` is greater than `a_max`, `clip` returns an
# array in which all values are equal to `a_max`,
# as shown in the second example.
#
# Examples
# --------
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, 1, 8)
# array([1, 1, 2, 3, 4, 5, 6, 7, 8, 8])
# >>> np.clip(a, 8, 1)
# array([1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
# >>> np.clip(a, 3, 6, out=a)
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, [3, 4, 1, 1, 1, 4, 4, 4, 4, 4], 8)
# array([3, 4, 2, 3, 4, 5, 6, 7, 8, 8])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.stack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Join a sequence of arrays along a new axis.
#
# The ``axis`` parameter specifies the index of the new axis in the
# dimensions of the result. For example, if ``axis=0`` it will be the first
# dimension and if ``axis=-1`` it will be the last dimension.
#
# .. versionadded:: 1.10.0
#
# Parameters
# ----------
# arrays : sequence of array_like
#     Each array must have the same shape.
#
# axis : int, optional
#     The axis in the result array along which the input arrays are stacked.
#
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what stack would have returned if no
#     out argument were specified.
#
# Returns
# -------
# stacked : ndarray
#     The stacked array has one more dimension than the input arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# block : Assemble an nd-array from nested lists of blocks.
# split : Split array into a list of multiple sub-arrays of equal size.
#
# Examples
# --------
# >>> arrays = [np.random.randn(3, 4) for _ in range(10)]
# >>> np.stack(arrays, axis=0).shape
# (10, 3, 4)
#
# >>> np.stack(arrays, axis=1).shape
# (3, 10, 4)
#
# >>> np.stack(arrays, axis=2).shape
# (3, 4, 10)
#
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.stack((a, b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> np.stack((a, b), axis=-1)
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.arange</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# arange([start,] stop[, step,], dtype=None, *, like=None)
#
# Return evenly spaced values within a given interval.
#
# Values are generated within the half-open interval ``[start, stop)``
# (in other words, the interval including `start` but excluding `stop`).
# For integer arguments the function is equivalent to the Python built-in
# `range` function, but returns an ndarray rather than a list.
#
# When using a non-integer step, such as 0.1, it is often better to use
# `numpy.linspace`. See the warnings section below for more information.
#
# Parameters
# ----------
# start : integer or real, optional
#     Start of interval.  The interval includes this value.  The default
#     start value is 0.
# stop : integer or real
#     End of interval.  The interval does not include this value, except
#     in some cases where `step` is not an integer and floating point
#     round-off affects the length of `out`.
# step : integer or real, optional
#     Spacing between values.  For any output `out`, this is the distance
#     between two adjacent values, ``out[i+1] - out[i]``.  The default
#     step size is 1.  If `step` is specified as a position argument,
#     `start` must also be given.
# dtype : dtype
#     The type of the output array.  If `dtype` is not given, infer the data
#     type from the other input arguments.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# arange : ndarray
#     Array of evenly spaced values.
#
#     For floating point arguments, the length of the result is
#     ``ceil((stop - start)/step)``.  Because of floating point overflow,
#     this rule may result in the last element of `out` being greater
#     than `stop`.
#
# Warnings
# --------
# The length of the output might not be numerically stable.
#
# Another stability issue is due to the internal implementation of
# `numpy.arange`.
# The actual step value used to populate the array is
# ``dtype(start + step) - dtype(start)`` and not `step`. Precision loss
# can occur here, due to casting or due to using floating points when
# `start` is much larger than `step`. This can lead to unexpected
# behaviour. For example::
#
#   >>> np.arange(0, 5, 0.5, dtype=int)
#   array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0])
#   >>> np.arange(-3, 3, 0.5, dtype=int)
#   array([-3, -2, -1,  0,  1,  2,  3,  4,  5,  6,  7,  8])
#
# In such cases, the use of `numpy.linspace` should be preferred.
#
# See Also
# --------
# numpy.linspace : Evenly spaced numbers with careful handling of endpoints.
# numpy.ogrid: Arrays of evenly spaced numbers in N-dimensions.
# numpy.mgrid: Grid-shaped arrays of evenly spaced numbers in N-dimensions.
#
# Examples
# --------
# >>> np.arange(3)
# array([0, 1, 2])
# >>> np.arange(3.0)
# array([ 0.,  1.,  2.])
# >>> np.arange(3,7)
# array([3, 4, 5, 6])
# >>> np.arange(3,7,2)
# array([3, 5])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.random.mtrand.RandomState.shuffle</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# shuffle(x)
#
# Modify a sequence in-place by shuffling its contents.
#
# This function only shuffles the array along the first axis of a
# multi-dimensional array. The order of sub-arrays is changed but
# their contents remains the same.
#
# .. note::
#     New code should use the ``shuffle`` method of a ``default_rng()``
#     instance instead; please see the :ref:`random-quick-start`.
#
# Parameters
# ----------
# x : ndarray or MutableSequence
#     The array, list or mutable sequence to be shuffled.
#
# Returns
# -------
# None
#
# See Also
# --------
# Generator.shuffle: which should be used for new code.
#
# Examples
# --------
# >>> arr = np.arange(10)
# >>> np.random.shuffle(arr)
# >>> arr
# [1 7 5 2 9 4 3 6 0 8] # random
#
# Multi-dimensional arrays are only shuffled along the first axis:
#
# >>> arr = np.arange(9).reshape((3, 3))
# >>> np.random.shuffle(arr)
# >>> arr
# array([[3, 4, 5], # random
#        [6, 7, 8],
#        [0, 1, 2]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.vstack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Stack arrays in sequence vertically (row wise).
#
# This is equivalent to concatenation along the first axis after 1-D arrays
# of shape `(N,)` have been reshaped to `(1,N)`. Rebuilds arrays divided by
# `vsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the first axis.
#     1-D arrays must have the same length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays, will be at least 2-D.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# vsplit : Split an array into multiple sub-arrays vertically (row-wise).
#
# Examples
# --------
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.vstack((a,b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> a = np.array([[1], [2], [3]])
# >>> b = np.array([[4], [5], [6]])
# >>> np.vstack((a,b))
# array([[1],
#        [2],
#        [3],
#        [4],
#        [5],
#        [6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.zeros</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# zeros(shape, dtype=float, order='C', *, like=None)
#
# Return a new array of given shape and type, filled with zeros.
#
# Parameters
# ----------
# shape : int or tuple of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: 'C'
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of zeros with the given shape, dtype, and order.
#
# See Also
# --------
# zeros_like : Return an array of zeros with shape and type of input.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# full : Return a new array of given shape filled with value.
#
# Examples
# --------
# >>> np.zeros(5)
# array([ 0.,  0.,  0.,  0.,  0.])
#
# >>> np.zeros((5,), dtype=int)
# array([0, 0, 0, 0, 0])
#
# >>> np.zeros((2, 1))
# array([[ 0.],
#        [ 0.]])
#
# >>> s = (2,2)
# >>> np.zeros(s)
# array([[ 0.,  0.],
#        [ 0.,  0.]])
#
# >>> np.zeros((2,), dtype=[('x', 'i4'), ('y', 'i4')]) # custom dtype
# array([(0, 0), (0, 0)],
#       dtype=[('x', '<i4'), ('y', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'drop': True}</li></ul>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.pop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['target'] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Return item and drop from frame. Raise KeyError if not found.
#
# Parameters
# ----------
# item : label
#     Label of column to be popped.
#
# Returns
# -------
# Series
#
# Examples
# --------
# >>> df = pd.DataFrame([('falcon', 'bird', 389.0),
# ...                    ('parrot', 'bird', 24.0),
# ...                    ('lion', 'mammal', 80.5),
# ...                    ('monkey', 'mammal', np.nan)],
# ...                   columns=('name', 'class', 'max_speed'))
# >>> df
#      name   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# >>> df.pop('class')
# 0      bird
# 1      bird
# 2    mammal
# 3    mammal
# Name: class, dtype: object
#
# >>> df
#      name  max_speed
# 0  falcon      389.0
# 1  parrot       24.0
# 2    lion       80.5
# 3  monkey        NaN
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.fromnumeric.clip</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.99] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Clip (limit) the values in an array.
#
# Given an interval, values outside the interval are clipped to
# the interval edges.  For example, if an interval of ``[0, 1]``
# is specified, values smaller than 0 become 0, and values larger
# than 1 become 1.
#
# Equivalent to but faster than ``np.minimum(a_max, np.maximum(a, a_min))``.
#
# No check is performed to ensure ``a_min < a_max``.
#
# Parameters
# ----------
# a : array_like
#     Array containing elements to clip.
# a_min, a_max : array_like or None
#     Minimum and maximum value. If ``None``, clipping is not performed on
#     the corresponding edge. Only one of `a_min` and `a_max` may be
#     ``None``. Both are broadcast against `a`.
# out : ndarray, optional
#     The results will be placed in this array. It may be the input
#     array for in-place clipping.  `out` must be of the right shape
#     to hold the output.  Its type is preserved.
# **kwargs
#     For other keyword-only arguments, see the
#     :ref:`ufunc docs <ufuncs.kwargs>`.
#
#     .. versionadded:: 1.17.0
#
# Returns
# -------
# clipped_array : ndarray
#     An array with the elements of `a`, but where values
#     < `a_min` are replaced with `a_min`, and those > `a_max`
#     with `a_max`.
#
# See Also
# --------
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# When `a_min` is greater than `a_max`, `clip` returns an
# array in which all values are equal to `a_max`,
# as shown in the second example.
#
# Examples
# --------
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, 1, 8)
# array([1, 1, 2, 3, 4, 5, 6, 7, 8, 8])
# >>> np.clip(a, 8, 1)
# array([1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
# >>> np.clip(a, 3, 6, out=a)
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, [3, 4, 1, 1, 1, 4, 4, 4, 4, 4], 8)
# array([3, 4, 2, 3, 4, 5, 6, 7, 8, 8])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.stack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Join a sequence of arrays along a new axis.
#
# The ``axis`` parameter specifies the index of the new axis in the
# dimensions of the result. For example, if ``axis=0`` it will be the first
# dimension and if ``axis=-1`` it will be the last dimension.
#
# .. versionadded:: 1.10.0
#
# Parameters
# ----------
# arrays : sequence of array_like
#     Each array must have the same shape.
#
# axis : int, optional
#     The axis in the result array along which the input arrays are stacked.
#
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what stack would have returned if no
#     out argument were specified.
#
# Returns
# -------
# stacked : ndarray
#     The stacked array has one more dimension than the input arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# block : Assemble an nd-array from nested lists of blocks.
# split : Split array into a list of multiple sub-arrays of equal size.
#
# Examples
# --------
# >>> arrays = [np.random.randn(3, 4) for _ in range(10)]
# >>> np.stack(arrays, axis=0).shape
# (10, 3, 4)
#
# >>> np.stack(arrays, axis=1).shape
# (3, 10, 4)
#
# >>> np.stack(arrays, axis=2).shape
# (3, 4, 10)
#
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.stack((a, b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> np.stack((a, b), axis=-1)
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.arange</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# arange([start,] stop[, step,], dtype=None, *, like=None)
#
# Return evenly spaced values within a given interval.
#
# Values are generated within the half-open interval ``[start, stop)``
# (in other words, the interval including `start` but excluding `stop`).
# For integer arguments the function is equivalent to the Python built-in
# `range` function, but returns an ndarray rather than a list.
#
# When using a non-integer step, such as 0.1, it is often better to use
# `numpy.linspace`. See the warnings section below for more information.
#
# Parameters
# ----------
# start : integer or real, optional
#     Start of interval.  The interval includes this value.  The default
#     start value is 0.
# stop : integer or real
#     End of interval.  The interval does not include this value, except
#     in some cases where `step` is not an integer and floating point
#     round-off affects the length of `out`.
# step : integer or real, optional
#     Spacing between values.  For any output `out`, this is the distance
#     between two adjacent values, ``out[i+1] - out[i]``.  The default
#     step size is 1.  If `step` is specified as a position argument,
#     `start` must also be given.
# dtype : dtype
#     The type of the output array.  If `dtype` is not given, infer the data
#     type from the other input arguments.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# arange : ndarray
#     Array of evenly spaced values.
#
#     For floating point arguments, the length of the result is
#     ``ceil((stop - start)/step)``.  Because of floating point overflow,
#     this rule may result in the last element of `out` being greater
#     than `stop`.
#
# Warnings
# --------
# The length of the output might not be numerically stable.
#
# Another stability issue is due to the internal implementation of
# `numpy.arange`.
# The actual step value used to populate the array is
# ``dtype(start + step) - dtype(start)`` and not `step`. Precision loss
# can occur here, due to casting or due to using floating points when
# `start` is much larger than `step`. This can lead to unexpected
# behaviour. For example::
#
#   >>> np.arange(0, 5, 0.5, dtype=int)
#   array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0])
#   >>> np.arange(-3, 3, 0.5, dtype=int)
#   array([-3, -2, -1,  0,  1,  2,  3,  4,  5,  6,  7,  8])
#
# In such cases, the use of `numpy.linspace` should be preferred.
#
# See Also
# --------
# numpy.linspace : Evenly spaced numbers with careful handling of endpoints.
# numpy.ogrid: Arrays of evenly spaced numbers in N-dimensions.
# numpy.mgrid: Grid-shaped arrays of evenly spaced numbers in N-dimensions.
#
# Examples
# --------
# >>> np.arange(3)
# array([0, 1, 2])
# >>> np.arange(3.0)
# array([ 0.,  1.,  2.])
# >>> np.arange(3,7)
# array([3, 4, 5, 6])
# >>> np.arange(3,7,2)
# array([3, 5])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.random.mtrand.RandomState.shuffle</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# shuffle(x)
#
# Modify a sequence in-place by shuffling its contents.
#
# This function only shuffles the array along the first axis of a
# multi-dimensional array. The order of sub-arrays is changed but
# their contents remains the same.
#
# .. note::
#     New code should use the ``shuffle`` method of a ``default_rng()``
#     instance instead; please see the :ref:`random-quick-start`.
#
# Parameters
# ----------
# x : ndarray or MutableSequence
#     The array, list or mutable sequence to be shuffled.
#
# Returns
# -------
# None
#
# See Also
# --------
# Generator.shuffle: which should be used for new code.
#
# Examples
# --------
# >>> arr = np.arange(10)
# >>> np.random.shuffle(arr)
# >>> arr
# [1 7 5 2 9 4 3 6 0 8] # random
#
# Multi-dimensional arrays are only shuffled along the first axis:
#
# >>> arr = np.arange(9).reshape((3, 3))
# >>> np.random.shuffle(arr)
# >>> arr
# array([[3, 4, 5], # random
#        [6, 7, 8],
#        [0, 1, 2]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.vstack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Stack arrays in sequence vertically (row wise).
#
# This is equivalent to concatenation along the first axis after 1-D arrays
# of shape `(N,)` have been reshaped to `(1,N)`. Rebuilds arrays divided by
# `vsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the first axis.
#     1-D arrays must have the same length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays, will be at least 2-D.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# vsplit : Split an array into multiple sub-arrays vertically (row-wise).
#
# Examples
# --------
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.vstack((a,b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> a = np.array([[1], [2], [3]])
# >>> b = np.array([[4], [5], [6]])
# >>> np.vstack((a,b))
# array([[1],
#        [2],
#        [3],
#        [4],
#        [5],
#        [6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.zeros</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# zeros(shape, dtype=float, order='C', *, like=None)
#
# Return a new array of given shape and type, filled with zeros.
#
# Parameters
# ----------
# shape : int or tuple of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: 'C'
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of zeros with the given shape, dtype, and order.
#
# See Also
# --------
# zeros_like : Return an array of zeros with shape and type of input.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# full : Return a new array of given shape filled with value.
#
# Examples
# --------
# >>> np.zeros(5)
# array([ 0.,  0.,  0.,  0.,  0.])
#
# >>> np.zeros((5,), dtype=int)
# array([0, 0, 0, 0, 0])
#
# >>> np.zeros((2, 1))
# array([[ 0.],
#        [ 0.]])
#
# >>> s = (2,2)
# >>> np.zeros(s)
# array([[ 0.,  0.],
#        [ 0.,  0.]])
#
# >>> np.zeros((2,), dtype=[('x', 'i4'), ('y', 'i4')]) # custom dtype
# array([(0, 0), (0, 0)],
#       dtype=[('x', '<i4'), ('y', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
#
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
#
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Sub-sampling and Train-test Splitting</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Sub-sampling and Train-test Splitting" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'shuffle': True, 'random_state': 42}</li></ul>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold.split</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generate indices to split data into training and test set.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Training data, where `n_samples` is the number of samples
#     and `n_features` is the number of features.
#
#     Note that providing ``y`` is sufficient to generate the splits and
#     hence ``np.zeros(n_samples)`` may be used as a placeholder for
#     ``X`` instead of actual training data.
#
# y : array-like of shape (n_samples,)
#     The target variable for supervised learning problems.
#     Stratification is done based on the y labels.
#
# groups : object
#     Always ignored, exists for compatibility.
#
# Yields
# ------
# train : ndarray
#     The training set indices for that split.
#
# test : ndarray
#     The testing set indices for that split.
#
# Notes
# -----
# Randomized CV splitters may return different results for each call of
# split. You can make the results identical by setting `random_state`
# to an integer.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'shuffle': True, 'random_state': 42}</li></ul>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold.split</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generate indices to split data into training and test set.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Training data, where `n_samples` is the number of samples
#     and `n_features` is the number of features.
#
#     Note that providing ``y`` is sufficient to generate the splits and
#     hence ``np.zeros(n_samples)`` may be used as a placeholder for
#     ``X`` instead of actual training data.
#
# y : array-like of shape (n_samples,)
#     The target variable for supervised learning problems.
#     Stratification is done based on the y labels.
#
# groups : object
#     Always ignored, exists for compatibility.
#
# Yields
# ------
# train : ndarray
#     The training set indices for that split.
#
# test : ndarray
#     The testing set indices for that split.
#
# Notes
# -----
# Randomized CV splitters may return different results for each call of
# split. You can make the results identical by setting `random_state`
# to an integer.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Engineering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.stack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Join a sequence of arrays along a new axis.
#
# The ``axis`` parameter specifies the index of the new axis in the
# dimensions of the result. For example, if ``axis=0`` it will be the first
# dimension and if ``axis=-1`` it will be the last dimension.
#
# .. versionadded:: 1.10.0
#
# Parameters
# ----------
# arrays : sequence of array_like
#     Each array must have the same shape.
#
# axis : int, optional
#     The axis in the result array along which the input arrays are stacked.
#
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what stack would have returned if no
#     out argument were specified.
#
# Returns
# -------
# stacked : ndarray
#     The stacked array has one more dimension than the input arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# block : Assemble an nd-array from nested lists of blocks.
# split : Split array into a list of multiple sub-arrays of equal size.
#
# Examples
# --------
# >>> arrays = [np.random.randn(3, 4) for _ in range(10)]
# >>> np.stack(arrays, axis=0).shape
# (10, 3, 4)
#
# >>> np.stack(arrays, axis=1).shape
# (3, 10, 4)
#
# >>> np.stack(arrays, axis=2).shape
# (3, 4, 10)
#
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.stack((a, b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> np.stack((a, b), axis=-1)
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.vstack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Stack arrays in sequence vertically (row wise).
#
# This is equivalent to concatenation along the first axis after 1-D arrays
# of shape `(N,)` have been reshaped to `(1,N)`. Rebuilds arrays divided by
# `vsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the first axis.
#     1-D arrays must have the same length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays, will be at least 2-D.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# vsplit : Split an array into multiple sub-arrays vertically (row-wise).
#
# Examples
# --------
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.vstack((a,b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> a = np.array([[1], [2], [3]])
# >>> b = np.array([[4], [5], [6]])
# >>> np.vstack((a,b))
# array([[1],
#        [2],
#        [3],
#        [4],
#        [5],
#        [6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.core.shape_base.stack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Join a sequence of arrays along a new axis.
#
# The ``axis`` parameter specifies the index of the new axis in the
# dimensions of the result. For example, if ``axis=0`` it will be the first
# dimension and if ``axis=-1`` it will be the last dimension.
#
# .. versionadded:: 1.10.0
#
# Parameters
# ----------
# arrays : sequence of array_like
#     Each array must have the same shape.
#
# axis : int, optional
#     The axis in the result array along which the input arrays are stacked.
#
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what stack would have returned if no
#     out argument were specified.
#
# Returns
# -------
# stacked : ndarray
#     The stacked array has one more dimension than the input arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# block : Assemble an nd-array from nested lists of blocks.
# split : Split array into a list of multiple sub-arrays of equal size.
#
# Examples
# --------
# >>> arrays = [np.random.randn(3, 4) for _ in range(10)]
# >>> np.stack(arrays, axis=0).shape
# (10, 3, 4)
#
# >>> np.stack(arrays, axis=1).shape
# (3, 10, 4)
#
# >>> np.stack(arrays, axis=2).shape
# (3, 4, 10)
#
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.stack((a, b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> np.stack((a, b), axis=-1)
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.vstack</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [[]] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Stack arrays in sequence vertically (row wise).
#
# This is equivalent to concatenation along the first axis after 1-D arrays
# of shape `(N,)` have been reshaped to `(1,N)`. Rebuilds arrays divided by
# `vsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the first axis.
#     1-D arrays must have the same length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays, will be at least 2-D.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# vsplit : Split an array into multiple sub-arrays vertically (row-wise).
#
# Examples
# --------
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.vstack((a,b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> a = np.array([[1], [2], [3]])
# >>> b = np.array([[4], [5], [6]])
# >>> np.vstack((a,b))
# array([[1],
#        [2],
#        [3],
#        [4],
#        [5],
#        [6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.random.mtrand.RandomState.shuffle</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# shuffle(x)
#
# Modify a sequence in-place by shuffling its contents.
#
# This function only shuffles the array along the first axis of a
# multi-dimensional array. The order of sub-arrays is changed but
# their contents remains the same.
#
# .. note::
#     New code should use the ``shuffle`` method of a ``default_rng()``
#     instance instead; please see the :ref:`random-quick-start`.
#
# Parameters
# ----------
# x : ndarray or MutableSequence
#     The array, list or mutable sequence to be shuffled.
#
# Returns
# -------
# None
#
# See Also
# --------
# Generator.shuffle: which should be used for new code.
#
# Examples
# --------
# >>> arr = np.arange(10)
# >>> np.random.shuffle(arr)
# >>> arr
# [1 7 5 2 9 4 3 6 0 8] # random
#
# Multi-dimensional arrays are only shuffled along the first axis:
#
# >>> arr = np.arange(9).reshape((3, 3))
# >>> np.random.shuffle(arr)
# >>> arr
# array([[3, 4, 5], # random
#        [6, 7, 8],
#        [0, 1, 2]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.random.mtrand.RandomState.shuffle</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# shuffle(x)
#
# Modify a sequence in-place by shuffling its contents.
#
# This function only shuffles the array along the first axis of a
# multi-dimensional array. The order of sub-arrays is changed but
# their contents remains the same.
#
# .. note::
#     New code should use the ``shuffle`` method of a ``default_rng()``
#     instance instead; please see the :ref:`random-quick-start`.
#
# Parameters
# ----------
# x : ndarray or MutableSequence
#     The array, list or mutable sequence to be shuffled.
#
# Returns
# -------
# None
#
# See Also
# --------
# Generator.shuffle: which should be used for new code.
#
# Examples
# --------
# >>> arr = np.arange(10)
# >>> np.random.shuffle(arr)
# >>> arr
# [1 7 5 2 9 4 3 6 0 8] # random
#
# Multi-dimensional arrays are only shuffled along the first axis:
#
# >>> arr = np.arange(9).reshape((3, 3))
# >>> np.random.shuffle(arr)
# >>> arr
# array([[3, 4, 5], # random
#        [6, 7, 8],
#        [0, 1, 2]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Feature Selection</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Selection" Calls</u></b></summary>
# <ul>
#
#
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [64] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [8] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.PReLU</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Parametric Rectified Linear Unit.
#
# It follows:
#
# ```
#   f(x) = alpha * x for x < 0
#   f(x) = x for x >= 0
# ```
#
# where `alpha` is a learned array with the same shape as x.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha_initializer: Initializer function for the weights.
#   alpha_regularizer: Regularizer for the weights.
#   alpha_constraint: Constraint for the weights.
#   shared_axes: The axes along which to share learnable
#     parameters for the activation function.
#     For example, if the incoming feature maps
#     are from a 2D convolution
#     with output shape `(batch, height, width, channels)`,
#     and you wish to share parameters across space
#     so that each filter only has one set of parameters,
#     set `shared_axes=[1, 2]`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [64] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [8] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [1] | <b>Kwargs:</b> {'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.PReLU</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Parametric Rectified Linear Unit.
#
# It follows:
#
# ```
#   f(x) = alpha * x for x < 0
#   f(x) = x for x >= 0
# ```
#
# where `alpha` is a learned array with the same shape as x.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha_initializer: Initializer function for the weights.
#   alpha_regularizer: Regularizer for the weights.
#   alpha_constraint: Constraint for the weights.
#   shared_axes: The axes along which to share learnable
#     parameters for the activation function.
#     For example, if the incoming feature maps
#     are from a 2D convolution
#     with output shape `(batch, height, width, channels)`,
#     and you wish to share parameters across space
#     so that each filter only has one set of parameters,
#     set `shared_axes=[1, 2]`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.2] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 1</u></h3></summary><small><a href=#1>goto cell # 1</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.backend</u></summary>
# <blockquote>
# <code>
# Keras backend API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.ModelCheckpoint</u></summary>
# <blockquote>
# <code>
# Callback to save the Keras model or model weights at some frequency.
#
# `ModelCheckpoint` callback is used in conjunction with training using
# `model.fit()` to save a model or weights (in a checkpoint file) at some
# interval, so the model or weights can be loaded later to continue the training
# from the state saved.
#
# A few options this callback provides include:
#
# - Whether to only keep the model that has achieved the "best performance" so
#   far, or whether to save the model at the end of every epoch regardless of
#   performance.
# - Definition of 'best'; which quantity to monitor and whether it should be
#   maximized or minimized.
# - The frequency it should save at. Currently, the callback supports saving at
#   the end of every epoch, or after a fixed number of training batches.
# - Whether only weights are saved, or the whole model is saved.
#
# Note: If you get `WARNING:tensorflow:Can save best model only with <name>
# available, skipping` see the description of the `monitor` argument for
# details on how to get this right.
#
# Example:
#
# ```python
# model.compile(loss=..., optimizer=...,
#               metrics=['accuracy'])
#
# EPOCHS = 10
# checkpoint_filepath = '/tmp/checkpoint'
# model_checkpoint_callback = tf.keras.callbacks.ModelCheckpoint(
#     filepath=checkpoint_filepath,
#     save_weights_only=True,
#     monitor='val_accuracy',
#     mode='max',
#     save_best_only=True)
#
# Model weights are saved at the end of every epoch, if it's the best seen
# so far.
# model.fit(epochs=EPOCHS, callbacks=[model_checkpoint_callback])
#
# The model weights (that are considered the best) are loaded into the model.
# model.load_weights(checkpoint_filepath)
# ```
#
# Args:
#     filepath: string or `PathLike`, path to save the model file. e.g.
#       filepath = os.path.join(working_dir, 'ckpt', file_name). `filepath`
#       can contain named formatting options, which will be filled the value of
#       `epoch` and keys in `logs` (passed in `on_epoch_end`). For example: if
#       `filepath` is `weights.{epoch:02d}-{val_loss:.2f}.hdf5`, then the model
#       checkpoints will be saved with the epoch number and the validation loss
#       in the filename. The directory of the filepath should not be reused by
#       any other callbacks to avoid conflicts.
#     monitor: The metric name to monitor. Typically the metrics are set by the
#       `Model.compile` method. Note:
#
#       * Prefix the name with `"val_`" to monitor validation metrics.
#       * Use `"loss"` or "`val_loss`" to monitor the model's total loss.
#       * If you specify metrics as strings, like `"accuracy"`, pass the same
#         string (with or without the `"val_"` prefix).
#       * If you pass `metrics.Metric` objects, `monitor` should be set to
#         `metric.name`
#       * If you're not sure about the metric names you can check the contents
#         of the `history.history` dictionary returned by
#         `history = model.fit()`
#       * Multi-output models set additional prefixes on the metric names.
#
#     verbose: verbosity mode, 0 or 1.
#     save_best_only: if `save_best_only=True`, it only saves when the model
#       is considered the "best" and the latest best model according to the
#       quantity monitored will not be overwritten. If `filepath` doesn't
#       contain formatting options like `{epoch}` then `filepath` will be
#       overwritten by each new better model.
#     mode: one of {'auto', 'min', 'max'}. If `save_best_only=True`, the
#       decision to overwrite the current save file is made based on either
#       the maximization or the minimization of the monitored quantity.
#       For `val_acc`, this should be `max`, for `val_loss` this should be
#       `min`, etc. In `auto` mode, the mode is set to `max` if the quantities
#       monitored are 'acc' or start with 'fmeasure' and are set to `min` for
#       the rest of the quantities.
#     save_weights_only: if True, then only the model's weights will be saved
#       (`model.save_weights(filepath)`), else the full model is saved
#       (`model.save(filepath)`).
#     save_freq: `'epoch'` or integer. When using `'epoch'`, the callback saves
#       the model after each epoch. When using integer, the callback saves the
#       model at end of this many batches. If the `Model` is compiled with
#       `steps_per_execution=N`, then the saving criteria will be
#       checked every Nth batch. Note that if the saving isn't aligned to
#       epochs, the monitored metric may potentially be less reliable (it
#       could reflect as little as 1 batch, since the metrics get reset every
#       epoch). Defaults to `'epoch'`.
#     options: Optional `tf.train.CheckpointOptions` object if
#       `save_weights_only` is true or optional `tf.saved_model.SaveOptions`
#       object if `save_weights_only` is false.
#     initial_value_threshold: Floating point initial "best" value of the metric
#       to be monitored. Only applies if `save_best_value=True`. Only overwrites
#       the model weights already saved if the performance of current
#       model is better than this value.
#     **kwargs: Additional arguments for backwards compatibility. Possible key
#       is `period`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.callbacks.ReduceLROnPlateau</u></summary>
# <blockquote>
# <code>
# Reduce learning rate when a metric has stopped improving.
#
# Models often benefit from reducing the learning rate by a factor
# of 2-10 once learning stagnates. This callback monitors a
# quantity and if no improvement is seen for a 'patience' number
# of epochs, the learning rate is reduced.
#
# Example:
#
# ```python
# reduce_lr = ReduceLROnPlateau(monitor='val_loss', factor=0.2,
#                               patience=5, min_lr=0.001)
# model.fit(X_train, Y_train, callbacks=[reduce_lr])
# ```
#
# Args:
#     monitor: quantity to be monitored.
#     factor: factor by which the learning rate will be reduced.
#       `new_lr = lr * factor`.
#     patience: number of epochs with no improvement after which learning rate
#       will be reduced.
#     verbose: int. 0: quiet, 1: update messages.
#     mode: one of `{'auto', 'min', 'max'}`. In `'min'` mode,
#       the learning rate will be reduced when the
#       quantity monitored has stopped decreasing; in `'max'` mode it will be
#       reduced when the quantity monitored has stopped increasing; in `'auto'`
#       mode, the direction is automatically inferred from the name of the
#       monitored quantity.
#     min_delta: threshold for measuring the new optimum, to only focus on
#       significant changes.
#     cooldown: number of epochs to wait before resuming normal operation after
#       lr has been reduced.
#     min_lr: lower bound on the learning rate.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u></summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u></summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.load_weights</u></summary>
# <blockquote>
# <code>
# Loads all layer weights, either from a TensorFlow or an HDF5 weight file.
#
# If `by_name` is False weights are loaded based on the network's
# topology. This means the architecture should be the same as when the weights
# were saved.  Note that layers that don't have weights are not taken into
# account in the topological ordering, so adding or removing layers is fine as
# long as they don't have weights.
#
# If `by_name` is True, weights are loaded into layers only if they share the
# same name. This is useful for fine-tuning or transfer-learning models where
# some of the layers have changed.
#
# Only topological loading (`by_name=False`) is supported when loading weights
# from the TensorFlow format. Note that topological loading differs slightly
# between TensorFlow and HDF5 formats for user-defined classes inheriting from
# `tf.keras.Model`: HDF5 loads based on a flattened list of weights, while the
# TensorFlow format loads based on the object-local names of attributes to
# which layers are assigned in the `Model`'s constructor.
#
# Args:
#     filepath: String, path to the weights file to load. For weight files in
#         TensorFlow format, this is the file prefix (the same as was passed
#         to `save_weights`). This can also be a path to a SavedModel
#         saved from `model.save`.
#     by_name: Boolean, whether to load weights by name or by topological
#         order. Only topological loading is supported for weight files in
#         TensorFlow format.
#     skip_mismatch: Boolean, whether to skip loading of layers where there is
#         a mismatch in the number of weights, or a mismatch in the shape of
#         the weight (only valid when `by_name=True`).
#     options: Optional `tf.train.CheckpointOptions` object that specifies
#         options for loading weights.
#
# Returns:
#     When loading a weight file in TensorFlow format, returns the same status
#     object as `tf.train.Checkpoint.restore`. When graph building, restore
#     ops are run automatically as soon as the network is built (on first call
#     for user-defined classes inheriting from `Model`, immediately if it is
#     already built).
#
#     When loading weights in HDF5 format, returns `None`.
#
# Raises:
#     ImportError: If `h5py` is not available and the weight file is in HDF5
#         format.
#     ValueError: If `skip_mismatch` is set to `True` when `by_name` is
#       `False`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers</u></summary>
# <blockquote>
# <code>
# Keras layers API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.PReLU</u></summary>
# <blockquote>
# <code>
# Parametric Rectified Linear Unit.
#
# It follows:
#
# ```
#   f(x) = alpha * x for x < 0
#   f(x) = x for x >= 0
# ```
#
# where `alpha` is a learned array with the same shape as x.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha_initializer: Initializer function for the weights.
#   alpha_regularizer: Regularizer for the weights.
#   alpha_constraint: Constraint for the weights.
#   shared_axes: The axes along which to share learnable
#     parameters for the activation function.
#     For example, if the incoming feature maps
#     are from a 2D convolution
#     with output shape `(batch, height, width, channels)`,
#     and you wish to share parameters across space
#     so that each filter only has one set of parameters,
#     set `shared_axes=[1, 2]`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u></summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u></summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.losses.binary_crossentropy</u></summary>
# <blockquote>
# <code>
# Computes the binary crossentropy loss.
#
# Standalone usage:
#
# >>> y_true = [[0, 1], [0, 0]]
# >>> y_pred = [[0.6, 0.4], [0.4, 0.6]]
# >>> loss = tf.keras.losses.binary_crossentropy(y_true, y_pred)
# >>> assert loss.shape == (2,)
# >>> loss.numpy()
# array([0.916 , 0.714], dtype=float32)
#
# Args:
#   y_true: Ground truth values. shape = `[batch_size, d0, .. dN]`.
#   y_pred: The predicted values. shape = `[batch_size, d0, .. dN]`.
#   from_logits: Whether `y_pred` is expected to be a logits tensor. By default,
#     we assume that `y_pred` encodes a probability distribution.
#   label_smoothing: Float in [0, 1]. If > `0` then smooth the labels by
#     squeezing them towards 0.5 That is, using `1. - 0.5 * label_smoothing`
#     for the target class and `0.5 * label_smoothing` for the non-target class.
#   axis: The axis along which the mean is computed. Defaults to -1.
#
# Returns:
#   Binary crossentropy loss value. shape = `[batch_size, d0, .. dN-1]`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.optimizer_v2.adam.Adam</u></summary>
# <blockquote>
# <code>
# Optimizer that implements the Adam algorithm.
#
# Adam optimization is a stochastic gradient descent method that is based on
# adaptive estimation of first-order and second-order moments.
#
# According to
# [Kingma et al., 2014](http://arxiv.org/abs/1412.6980),
# the method is "*computationally
# efficient, has little memory requirement, invariant to diagonal rescaling of
# gradients, and is well suited for problems that are large in terms of
# data/parameters*".
#
# Args:
#   learning_rate: A `Tensor`, floating point value, or a schedule that is a
#     `tf.keras.optimizers.schedules.LearningRateSchedule`, or a callable
#     that takes no arguments and returns the actual value to use, The
#     learning rate. Defaults to 0.001.
#   beta_1: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use. The
#     exponential decay rate for the 1st moment estimates. Defaults to 0.9.
#   beta_2: A float value or a constant float tensor, or a callable
#     that takes no arguments and returns the actual value to use, The
#     exponential decay rate for the 2nd moment estimates. Defaults to 0.999.
#   epsilon: A small constant for numerical stability. This epsilon is
#     "epsilon hat" in the Kingma and Ba paper (in the formula just before
#     Section 2.1), not the epsilon in Algorithm 1 of the paper. Defaults to
#     1e-7.
#   amsgrad: Boolean. Whether to apply AMSGrad variant of this algorithm from
#     the paper "On the Convergence of Adam and beyond". Defaults to `False`.
#   name: Optional name for the operations created when applying gradients.
#     Defaults to `"Adam"`.
#   **kwargs: Keyword arguments. Allowed to be one of
#     `"clipnorm"` or `"clipvalue"`.
#     `"clipnorm"` (float) clips gradients by norm; `"clipvalue"` (float) clips
#     gradients by value.
#
# Usage:
#
# >>> opt = tf.keras.optimizers.Adam(learning_rate=0.1)
# >>> var1 = tf.Variable(10.0)
# >>> loss = lambda: (var1 ** 2)/2.0       # d(loss)/d(var1) == var1
# >>> step_count = opt.minimize(loss, [var1]).numpy()
# >>> # The first step is `-learning_rate*sign(grad)`
# >>> var1.numpy()
# 9.9
#
# Reference:
#   - [Kingma et al., 2014](http://arxiv.org/abs/1412.6980)
#   - [Reddi et al., 2018](
#       https://openreview.net/pdf?id=ryQu7f-RZ) for `amsgrad`.
#
# Notes:
#
# The default value of 1e-7 for epsilon might not be a good default in
# general. For example, when training an Inception network on ImageNet a
# current good choice is 1.0 or 0.1. Note that since Adam uses the
# formulation just before Section 2.1 of the Kingma and Ba paper rather than
# the formulation in Algorithm 1, the "epsilon" referred to here is "epsilon
# hat" in the paper.
#
# The sparse implementation of this algorithm (used when the gradient is an
# IndexedSlices object, typically because of `tf.gather` or an embedding
# lookup in the forward pass) does apply momentum to variable slices even if
# they were not used in the forward pass (meaning they have a gradient equal
# to zero). Momentum decay (beta1) is also applied to the entire momentum
# accumulator. This means that the sparse behavior is equivalent to the dense
# behavior (in contrast to some momentum implementations which ignore momentum
# unless a variable slice was actually used).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.arange</u></summary>
# <blockquote>
# <code>
# arange([start,] stop[, step,], dtype=None, *, like=None)
#
# Return evenly spaced values within a given interval.
#
# Values are generated within the half-open interval ``[start, stop)``
# (in other words, the interval including `start` but excluding `stop`).
# For integer arguments the function is equivalent to the Python built-in
# `range` function, but returns an ndarray rather than a list.
#
# When using a non-integer step, such as 0.1, it is often better to use
# `numpy.linspace`. See the warnings section below for more information.
#
# Parameters
# ----------
# start : integer or real, optional
#     Start of interval.  The interval includes this value.  The default
#     start value is 0.
# stop : integer or real
#     End of interval.  The interval does not include this value, except
#     in some cases where `step` is not an integer and floating point
#     round-off affects the length of `out`.
# step : integer or real, optional
#     Spacing between values.  For any output `out`, this is the distance
#     between two adjacent values, ``out[i+1] - out[i]``.  The default
#     step size is 1.  If `step` is specified as a position argument,
#     `start` must also be given.
# dtype : dtype
#     The type of the output array.  If `dtype` is not given, infer the data
#     type from the other input arguments.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# arange : ndarray
#     Array of evenly spaced values.
#
#     For floating point arguments, the length of the result is
#     ``ceil((stop - start)/step)``.  Because of floating point overflow,
#     this rule may result in the last element of `out` being greater
#     than `stop`.
#
# Warnings
# --------
# The length of the output might not be numerically stable.
#
# Another stability issue is due to the internal implementation of
# `numpy.arange`.
# The actual step value used to populate the array is
# ``dtype(start + step) - dtype(start)`` and not `step`. Precision loss
# can occur here, due to casting or due to using floating points when
# `start` is much larger than `step`. This can lead to unexpected
# behaviour. For example::
#
#   >>> np.arange(0, 5, 0.5, dtype=int)
#   array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0])
#   >>> np.arange(-3, 3, 0.5, dtype=int)
#   array([-3, -2, -1,  0,  1,  2,  3,  4,  5,  6,  7,  8])
#
# In such cases, the use of `numpy.linspace` should be preferred.
#
# See Also
# --------
# numpy.linspace : Evenly spaced numbers with careful handling of endpoints.
# numpy.ogrid: Arrays of evenly spaced numbers in N-dimensions.
# numpy.mgrid: Grid-shaped arrays of evenly spaced numbers in N-dimensions.
#
# Examples
# --------
# >>> np.arange(3)
# array([0, 1, 2])
# >>> np.arange(3.0)
# array([ 0.,  1.,  2.])
# >>> np.arange(3,7)
# array([3, 4, 5, 6])
# >>> np.arange(3,7,2)
# array([3, 5])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core._multiarray_umath.concatenate</u></summary>
# <blockquote>
# <code>
# concatenate((a1, a2, ...), axis=0, out=None, dtype=None, casting="same_kind")
#
# Join a sequence of arrays along an existing axis.
#
# Parameters
# ----------
# a1, a2, ... : sequence of array_like
#     The arrays must have the same shape, except in the dimension
#     corresponding to `axis` (the first, by default).
# axis : int, optional
#     The axis along which the arrays will be joined.  If axis is None,
#     arrays are flattened before use.  Default is 0.
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what concatenate would have returned if no
#     out argument were specified.
# dtype : str or dtype
#     If provided, the destination array will have this dtype. Cannot be
#     provided together with `out`.
#
#     .. versionadded:: 1.20.0
#
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'same_kind'.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# res : ndarray
#     The concatenated array.
#
# See Also
# --------
# ma.concatenate : Concatenate function that preserves input masks.
# array_split : Split an array into multiple sub-arrays of equal or
#               near-equal size.
# split : Split array into a list of multiple sub-arrays of equal size.
# hsplit : Split array into multiple sub-arrays horizontally (column wise).
# vsplit : Split array into multiple sub-arrays vertically (row wise).
# dsplit : Split array into multiple sub-arrays along the 3rd axis (depth).
# stack : Stack a sequence of arrays along a new axis.
# block : Assemble arrays from blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third dimension).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
#
# Notes
# -----
# When one or more of the arrays to be concatenated is a MaskedArray,
# this function will return a MaskedArray object instead of an ndarray,
# but the input masks are *not* preserved. In cases where a MaskedArray
# is expected as input, use the ma.concatenate function from the masked
# array module instead.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> b = np.array([[5, 6]])
# >>> np.concatenate((a, b), axis=0)
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
# >>> np.concatenate((a, b.T), axis=1)
# array([[1, 2, 5],
#        [3, 4, 6]])
# >>> np.concatenate((a, b), axis=None)
# array([1, 2, 3, 4, 5, 6])
#
# This function will not preserve masking of MaskedArray inputs.
#
# >>> a = np.ma.arange(3)
# >>> a[1] = np.ma.masked
# >>> b = np.arange(2, 5)
# >>> a
# masked_array(data=[0, --, 2],
#              mask=[False,  True, False],
#        fill_value=999999)
# >>> b
# array([2, 3, 4])
# >>> np.concatenate([a, b])
# masked_array(data=[0, 1, 2, 2, 3, 4],
#              mask=False,
#        fill_value=999999)
# >>> np.ma.concatenate([a, b])
# masked_array(data=[0, --, 2, 2, 3, 4],
#              mask=[False,  True, False, False, False, False],
#        fill_value=999999)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.clip</u></summary>
# <blockquote>
# <code>
# Clip (limit) the values in an array.
#
# Given an interval, values outside the interval are clipped to
# the interval edges.  For example, if an interval of ``[0, 1]``
# is specified, values smaller than 0 become 0, and values larger
# than 1 become 1.
#
# Equivalent to but faster than ``np.minimum(a_max, np.maximum(a, a_min))``.
#
# No check is performed to ensure ``a_min < a_max``.
#
# Parameters
# ----------
# a : array_like
#     Array containing elements to clip.
# a_min, a_max : array_like or None
#     Minimum and maximum value. If ``None``, clipping is not performed on
#     the corresponding edge. Only one of `a_min` and `a_max` may be
#     ``None``. Both are broadcast against `a`.
# out : ndarray, optional
#     The results will be placed in this array. It may be the input
#     array for in-place clipping.  `out` must be of the right shape
#     to hold the output.  Its type is preserved.
# **kwargs
#     For other keyword-only arguments, see the
#     :ref:`ufunc docs <ufuncs.kwargs>`.
#
#     .. versionadded:: 1.17.0
#
# Returns
# -------
# clipped_array : ndarray
#     An array with the elements of `a`, but where values
#     < `a_min` are replaced with `a_min`, and those > `a_max`
#     with `a_max`.
#
# See Also
# --------
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# When `a_min` is greater than `a_max`, `clip` returns an
# array in which all values are equal to `a_max`,
# as shown in the second example.
#
# Examples
# --------
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, 1, 8)
# array([1, 1, 2, 3, 4, 5, 6, 7, 8, 8])
# >>> np.clip(a, 8, 1)
# array([1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
# >>> np.clip(a, 3, 6, out=a)
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, [3, 4, 1, 1, 1, 4, 4, 4, 4, 4], 8)
# array([3, 4, 2, 3, 4, 5, 6, 7, 8, 8])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.numeric.full</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with `fill_value`.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# fill_value : scalar or array_like
#     Fill value.
# dtype : data-type, optional
#     The desired data-type for the array  The default, None, means
#      ``np.array(fill_value).dtype``.
# order : {'C', 'F'}, optional
#     Whether to store multidimensional data in C- or Fortran-contiguous
#     (row- or column-wise) order in memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of `fill_value` with the given shape, dtype, and order.
#
# See Also
# --------
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
#
# Examples
# --------
# >>> np.full((2, 2), np.inf)
# array([[inf, inf],
#        [inf, inf]])
# >>> np.full((2, 2), 10)
# array([[10, 10],
#        [10, 10]])
#
# >>> np.full((2, 2), [1, 2])
# array([[1, 2],
#        [1, 2]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.numeric.ones</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with ones.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: C
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of ones with the given shape, dtype, and order.
#
# See Also
# --------
# ones_like : Return an array of ones with shape and type of input.
# empty : Return a new uninitialized array.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Examples
# --------
# >>> np.ones(5)
# array([1., 1., 1., 1., 1.])
#
# >>> np.ones((5,), dtype=int)
# array([1, 1, 1, 1, 1])
#
# >>> np.ones((2, 1))
# array([[1.],
#        [1.]])
#
# >>> s = (2,2)
# >>> np.ones(s)
# array([[1.,  1.],
#        [1.,  1.]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.stack</u></summary>
# <blockquote>
# <code>
# Join a sequence of arrays along a new axis.
#
# The ``axis`` parameter specifies the index of the new axis in the
# dimensions of the result. For example, if ``axis=0`` it will be the first
# dimension and if ``axis=-1`` it will be the last dimension.
#
# .. versionadded:: 1.10.0
#
# Parameters
# ----------
# arrays : sequence of array_like
#     Each array must have the same shape.
#
# axis : int, optional
#     The axis in the result array along which the input arrays are stacked.
#
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what stack would have returned if no
#     out argument were specified.
#
# Returns
# -------
# stacked : ndarray
#     The stacked array has one more dimension than the input arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# block : Assemble an nd-array from nested lists of blocks.
# split : Split array into a list of multiple sub-arrays of equal size.
#
# Examples
# --------
# >>> arrays = [np.random.randn(3, 4) for _ in range(10)]
# >>> np.stack(arrays, axis=0).shape
# (10, 3, 4)
#
# >>> np.stack(arrays, axis=1).shape
# (3, 10, 4)
#
# >>> np.stack(arrays, axis=2).shape
# (3, 4, 10)
#
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.stack((a, b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> np.stack((a, b), axis=-1)
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.vstack</u></summary>
# <blockquote>
# <code>
# Stack arrays in sequence vertically (row wise).
#
# This is equivalent to concatenation along the first axis after 1-D arrays
# of shape `(N,)` have been reshaped to `(1,N)`. Rebuilds arrays divided by
# `vsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the first axis.
#     1-D arrays must have the same length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays, will be at least 2-D.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# vsplit : Split an array into multiple sub-arrays vertically (row-wise).
#
# Examples
# --------
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.vstack((a,b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> a = np.array([[1], [2], [3]])
# >>> b = np.array([[4], [5], [6]])
# >>> np.vstack((a,b))
# array([[1],
#        [2],
#        [3],
#        [4],
#        [5],
#        [6]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.lib.npyio.load</u></summary>
# <blockquote>
# <code>
# Load arrays or pickled objects from ``.npy``, ``.npz`` or pickled files.
#
# .. warning:: Loading files that contain object arrays uses the ``pickle``
#              module, which is not secure against erroneous or maliciously
#              constructed data. Consider passing ``allow_pickle=False`` to
#              load data that is known not to contain object arrays for the
#              safer handling of untrusted sources.
#
# Parameters
# ----------
# file : file-like object, string, or pathlib.Path
#     The file to read. File-like objects must support the
#     ``seek()`` and ``read()`` methods. Pickled files require that the
#     file-like object support the ``readline()`` method as well.
# mmap_mode : {None, 'r+', 'r', 'w+', 'c'}, optional
#     If not None, then memory-map the file, using the given mode (see
#     `numpy.memmap` for a detailed description of the modes).  A
#     memory-mapped array is kept on disk. However, it can be accessed
#     and sliced like any ndarray.  Memory mapping is especially useful
#     for accessing small fragments of large files without reading the
#     entire file into memory.
# allow_pickle : bool, optional
#     Allow loading pickled object arrays stored in npy files. Reasons for
#     disallowing pickles include security, as loading pickled data can
#     execute arbitrary code. If pickles are disallowed, loading object
#     arrays will fail. Default: False
#
#     .. versionchanged:: 1.16.3
#         Made default False in response to CVE-2019-6446.
#
# fix_imports : bool, optional
#     Only useful when loading Python 2 generated pickled files on Python 3,
#     which includes npy/npz files containing object arrays. If `fix_imports`
#     is True, pickle will try to map the old Python 2 names to the new names
#     used in Python 3.
# encoding : str, optional
#     What encoding to use when reading Python 2 strings. Only useful when
#     loading Python 2 generated pickled files in Python 3, which includes
#     npy/npz files containing object arrays. Values other than 'latin1',
#     'ASCII', and 'bytes' are not allowed, as they can corrupt numerical
#     data. Default: 'ASCII'
#
# Returns
# -------
# result : array, tuple, dict, etc.
#     Data stored in the file. For ``.npz`` files, the returned instance
#     of NpzFile class must be closed to avoid leaking file descriptors.
#
# Raises
# ------
# OSError
#     If the input file does not exist or cannot be read.
# UnpicklingError
#     If ``allow_pickle=True``, but the file cannot be loaded as a pickle.
# ValueError
#     The file contains an object array, but ``allow_pickle=False`` given.
#
# See Also
# --------
# save, savez, savez_compressed, loadtxt
# memmap : Create a memory-map to an array stored in a file on disk.
# lib.format.open_memmap : Create or load a memory-mapped ``.npy`` file.
#
# Notes
# -----
# - If the file contains pickle data, then whatever object is stored
#   in the pickle is returned.
# - If the file is a ``.npy`` file, then a single array is returned.
# - If the file is a ``.npz`` file, then a dictionary-like object is
#   returned, containing ``{filename: array}`` key-value pairs, one for
#   each file in the archive.
# - If the file is a ``.npz`` file, the returned value supports the
#   context manager protocol in a similar fashion to the open function::
#
#     with load('foo.npz') as data:
#         a = data['a']
#
#   The underlying file descriptor is closed when exiting the 'with'
#   block.
#
# Examples
# --------
# Store data to disk, and load it again:
#
# >>> np.save('/tmp/123', np.array([[1, 2, 3], [4, 5, 6]]))
# >>> np.load('/tmp/123.npy')
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# Store compressed data to disk, and load it again:
#
# >>> a=np.array([[1, 2, 3], [4, 5, 6]])
# >>> b=np.array([1, 2])
# >>> np.savez('/tmp/123.npz', a=a, b=b)
# >>> data = np.load('/tmp/123.npz')
# >>> data['a']
# array([[1, 2, 3],
#        [4, 5, 6]])
# >>> data['b']
# array([1, 2])
# >>> data.close()
#
# Mem-map the stored array, and then access the second row
# directly from disk:
#
# >>> X = np.load('/tmp/123.npy', mmap_mode='r')
# >>> X[1, :]
# memmap([4, 5, 6])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.lib.npyio.save</u></summary>
# <blockquote>
# <code>
# Save an array to a binary file in NumPy ``.npy`` format.
#
# Parameters
# ----------
# file : file, str, or pathlib.Path
#     File or filename to which the data is saved.  If file is a file-object,
#     then the filename is unchanged.  If file is a string or Path, a ``.npy``
#     extension will be appended to the filename if it does not already
#     have one.
# arr : array_like
#     Array data to be saved.
# allow_pickle : bool, optional
#     Allow saving object arrays using Python pickles. Reasons for disallowing
#     pickles include security (loading pickled data can execute arbitrary
#     code) and portability (pickled objects may not be loadable on different
#     Python installations, for example if the stored objects require libraries
#     that are not available, and not all pickled data is compatible between
#     Python 2 and Python 3).
#     Default: True
# fix_imports : bool, optional
#     Only useful in forcing objects in object arrays on Python 3 to be
#     pickled in a Python 2 compatible way. If `fix_imports` is True, pickle
#     will try to map the new Python 3 names to the old module names used in
#     Python 2, so that the pickle data stream is readable with Python 2.
#
# See Also
# --------
# savez : Save several arrays into a ``.npz`` archive
# savetxt, load
#
# Notes
# -----
# For a description of the ``.npy`` format, see :py:mod:`numpy.lib.format`.
#
# Any data saved to the file is appended to the end of the file.
#
# Examples
# --------
# >>> from tempfile import TemporaryFile
# >>> outfile = TemporaryFile()
#
# >>> x = np.arange(10)
# >>> np.save(outfile, x)
#
# >>> _ = outfile.seek(0) # Only needed here to simulate closing & reopening file
# >>> np.load(outfile)
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
#
#
# >>> with open('test.npy', 'wb') as f:
# ...     np.save(f, np.array([1, 2]))
# ...     np.save(f, np.array([1, 3]))
# >>> with open('test.npy', 'rb') as f:
# ...     a = np.load(f)
# ...     b = np.load(f)
# >>> print(a, b)
# [1 2] [1 3]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.random</u></summary>
# <blockquote>
# <code>
# ========================
# Random Number Generation
# ========================
#
# Use ``default_rng()`` to create a `Generator` and call its methods.
#
# =============== =========================================================
# Generator
# --------------- ---------------------------------------------------------
# Generator       Class implementing all of the random number distributions
# default_rng     Default constructor for ``Generator``
# =============== =========================================================
#
# ============================================= ===
# BitGenerator Streams that work with Generator
# --------------------------------------------- ---
# MT19937
# PCG64
# PCG64DXSM
# Philox
# SFC64
# ============================================= ===
#
# ============================================= ===
# Getting entropy to initialize a BitGenerator
# --------------------------------------------- ---
# SeedSequence
# ============================================= ===
#
#
# Legacy
# ------
#
# For backwards compatibility with previous versions of numpy before 1.17, the
# various aliases to the global `RandomState` methods are left alone and do not
# use the new `Generator` API.
#
# ==================== =========================================================
# Utility functions
# -------------------- ---------------------------------------------------------
# random               Uniformly distributed floats over ``[0, 1)``
# bytes                Uniformly distributed random bytes.
# permutation          Randomly permute a sequence / generate a random sequence.
# shuffle              Randomly permute a sequence in place.
# choice               Random sample from 1-D array.
# ==================== =========================================================
#
# ==================== =========================================================
# Compatibility
# functions - removed
# in the new API
# -------------------- ---------------------------------------------------------
# rand                 Uniformly distributed values.
# randn                Normally distributed values.
# ranf                 Uniformly distributed floating point numbers.
# random_integers      Uniformly distributed integers in a given range.
#                      (deprecated, use ``integers(..., closed=True)`` instead)
# random_sample        Alias for `random_sample`
# randint              Uniformly distributed integers in a given range
# seed                 Seed the legacy random number generator.
# ==================== =========================================================
#
# ==================== =========================================================
# Univariate
# distributions
# -------------------- ---------------------------------------------------------
# beta                 Beta distribution over ``[0, 1]``.
# binomial             Binomial distribution.
# chisquare            :math:`\chi^2` distribution.
# exponential          Exponential distribution.
# f                    F (Fisher-Snedecor) distribution.
# gamma                Gamma distribution.
# geometric            Geometric distribution.
# gumbel               Gumbel distribution.
# hypergeometric       Hypergeometric distribution.
# laplace              Laplace distribution.
# logistic             Logistic distribution.
# lognormal            Log-normal distribution.
# logseries            Logarithmic series distribution.
# negative_binomial    Negative binomial distribution.
# noncentral_chisquare Non-central chi-square distribution.
# noncentral_f         Non-central F distribution.
# normal               Normal / Gaussian distribution.
# pareto               Pareto distribution.
# poisson              Poisson distribution.
# power                Power distribution.
# rayleigh             Rayleigh distribution.
# triangular           Triangular distribution.
# uniform              Uniform distribution.
# vonmises             Von Mises circular distribution.
# wald                 Wald (inverse Gaussian) distribution.
# weibull              Weibull distribution.
# zipf                 Zipf's distribution over ranked data.
# ==================== =========================================================
#
# ==================== ==========================================================
# Multivariate
# distributions
# -------------------- ----------------------------------------------------------
# dirichlet            Multivariate generalization of Beta distribution.
# multinomial          Multivariate generalization of the binomial distribution.
# multivariate_normal  Multivariate generalization of the normal distribution.
# ==================== ==========================================================
#
# ==================== =========================================================
# Standard
# distributions
# -------------------- ---------------------------------------------------------
# standard_cauchy      Standard Cauchy-Lorentz distribution.
# standard_exponential Standard exponential distribution.
# standard_gamma       Standard Gamma distribution.
# standard_normal      Standard normal distribution.
# standard_t           Standard Student's t-distribution.
# ==================== =========================================================
#
# ==================== =========================================================
# Internal functions
# -------------------- ---------------------------------------------------------
# get_state            Get tuple representing internal state of generator.
# set_state            Set state of generator.
# ==================== =========================================================
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.random.mtrand.RandomState.shuffle</u></summary>
# <blockquote>
# <code>
# shuffle(x)
#
# Modify a sequence in-place by shuffling its contents.
#
# This function only shuffles the array along the first axis of a
# multi-dimensional array. The order of sub-arrays is changed but
# their contents remains the same.
#
# .. note::
#     New code should use the ``shuffle`` method of a ``default_rng()``
#     instance instead; please see the :ref:`random-quick-start`.
#
# Parameters
# ----------
# x : ndarray or MutableSequence
#     The array, list or mutable sequence to be shuffled.
#
# Returns
# -------
# None
#
# See Also
# --------
# Generator.shuffle: which should be used for new code.
#
# Examples
# --------
# >>> arr = np.arange(10)
# >>> np.random.shuffle(arr)
# >>> arr
# [1 7 5 2 9 4 3 6 0 8] # random
#
# Multi-dimensional arrays are only shuffled along the first axis:
#
# >>> arr = np.arange(9).reshape((3, 3))
# >>> np.random.shuffle(arr)
# >>> arr
# array([[3, 4, 5], # random
#        [6, 7, 8],
#        [0, 1, 2]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.zeros</u></summary>
# <blockquote>
# <code>
# zeros(shape, dtype=float, order='C', *, like=None)
#
# Return a new array of given shape and type, filled with zeros.
#
# Parameters
# ----------
# shape : int or tuple of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: 'C'
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of zeros with the given shape, dtype, and order.
#
# See Also
# --------
# zeros_like : Return an array of zeros with shape and type of input.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# full : Return a new array of given shape filled with value.
#
# Examples
# --------
# >>> np.zeros(5)
# array([ 0.,  0.,  0.,  0.,  0.])
#
# >>> np.zeros((5,), dtype=int)
# array([0, 0, 0, 0, 0])
#
# >>> np.zeros((2, 1))
# array([[ 0.],
#        [ 0.]])
#
# >>> s = (2,2)
# >>> np.zeros(s)
# array([[ 0.,  0.],
#        [ 0.,  0.]])
#
# >>> np.zeros((2,), dtype=[('x', 'i4'), ('y', 'i4')]) # custom dtype
# array([(0, 0), (0, 0)],
#       dtype=[('x', '<i4'), ('y', '<i4')])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.pop</u></summary>
# <blockquote>
# <code>
# Return item and drop from frame. Raise KeyError if not found.
#
# Parameters
# ----------
# item : label
#     Label of column to be popped.
#
# Returns
# -------
# Series
#
# Examples
# --------
# >>> df = pd.DataFrame([('falcon', 'bird', 389.0),
# ...                    ('parrot', 'bird', 24.0),
# ...                    ('lion', 'mammal', 80.5),
# ...                    ('monkey', 'mammal', np.nan)],
# ...                   columns=('name', 'class', 'max_speed'))
# >>> df
#      name   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# >>> df.pop('class')
# 0      bird
# 1      bird
# 2    mammal
# 3    mammal
# Name: class, dtype: object
#
# >>> df
#      name  max_speed
# 0  falcon      389.0
# 1  parrot       24.0
# 2    lion       80.5
# 3  monkey        NaN
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u></summary>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique rows in the DataFrame.
#
# .. versionadded:: 1.1.0
#
# Parameters
# ----------
# subset : list-like, optional
#     Columns to use when counting unique combinations.
# normalize : bool, default False
#     Return proportions rather than frequencies.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# dropna : bool, default True
#     Don’t include counts of rows that contain NA values.
#
#     .. versionadded:: 1.3.0
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.value_counts: Equivalent method on Series.
#
# Notes
# -----
# The returned Series will have a MultiIndex with one level per input
# column. By default, rows that contain any NA values are omitted from
# the result. By default, the resulting Series will be in descending
# order so that the first element is the most frequently-occurring row.
#
# Examples
# --------
# >>> df = pd.DataFrame({'num_legs': [2, 4, 4, 6],
# ...                    'num_wings': [2, 0, 0, 0]},
# ...                   index=['falcon', 'dog', 'cat', 'ant'])
# >>> df
#         num_legs  num_wings
# falcon         2          2
# dog            4          0
# cat            4          0
# ant            6          0
#
# >>> df.value_counts()
# num_legs  num_wings
# 4         0            2
# 2         2            1
# 6         0            1
# dtype: int64
#
# >>> df.value_counts(sort=False)
# num_legs  num_wings
# 2         2            1
# 4         0            2
# 6         0            1
# dtype: int64
#
# >>> df.value_counts(ascending=True)
# num_legs  num_wings
# 2         2            1
# 6         0            1
# 4         0            2
# dtype: int64
#
# >>> df.value_counts(normalize=True)
# num_legs  num_wings
# 4         0            0.50
# 2         2            0.25
# 6         0            0.25
# dtype: float64
#
# With `dropna` set to `False` we can also count rows with NA values.
#
# >>> df = pd.DataFrame({'first_name': ['John', 'Anne', 'John', 'Beth'],
# ...                    'middle_name': ['Smith', pd.NA, pd.NA, 'Louise']})
# >>> df
#   first_name middle_name
# 0       John       Smith
# 1       Anne        <NA>
# 2       John        <NA>
# 3       Beth      Louise
#
# >>> df.value_counts()
# first_name  middle_name
# Beth        Louise         1
# John        Smith          1
# dtype: int64
#
# >>> df.value_counts(dropna=False)
# first_name  middle_name
# Anne        NaN            1
# Beth        Louise         1
# John        Smith          1
#             NaN            1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations</u></summary>
# <blockquote>
# <code>
# Add the operations to the cls; evaluate the doc strings again
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.mean</u></summary>
# <blockquote>
# <code>
# Return the mean of the values over the requested axis.
#
# Parameters
# ----------
# axis : {index (0)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# scalar or Series (if level specified)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.std</u></summary>
# <blockquote>
# <code>
# Return sample standard deviation over requested axis.
#
# Normalized by N-1 by default. This can be changed using the ddof argument.
#
# Parameters
# ----------
# axis : {index (0)}
# skipna : bool, default True
#     Exclude NA/null values. If an entire row/column is NA, the result
#     will be NA.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a scalar.
# ddof : int, default 1
#     Delta Degrees of Freedom. The divisor used in calculations is N - ddof,
#     where N represents the number of elements.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
#
# Returns
# -------
# scalar or Series (if level specified) 
#
# Notes
# -----
# To have the same behaviour as `numpy.std`, use `ddof=0` (instead of the
# default `ddof=1`)
#
# Examples
# --------
# >>> df = pd.DataFrame({'person_id': [0, 1, 2, 3],
# ...                   'age': [21, 25, 62, 43],
# ...                   'height': [1.61, 1.87, 1.49, 2.01]}
# ...                  ).set_index('person_id')
# >>> df
#            age  height
# person_id
# 0           21    1.61
# 1           25    1.87
# 2           62    1.49
# 3           43    2.01
#
# The standard deviation of the columns can be found as follows:
#
# >>> df.std()
# age       18.786076
# height     0.237417
#
# Alternatively, `ddof=0` can be set to normalize by N instead of N-1:
#
# >>> df.std(ddof=0)
# age       16.269219
# height     0.205609
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u></summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u></summary>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.map</u></summary>
# <blockquote>
# <code>
# Map values of Series according to an input mapping or function.
#
# Used for substituting each value in a Series with another value,
# that may be derived from a function, a ``dict`` or
# a :class:`Series`.
#
# Parameters
# ----------
# arg : function, collections.abc.Mapping subclass or Series
#     Mapping correspondence.
# na_action : {None, 'ignore'}, default None
#     If 'ignore', propagate NaN values, without passing them to the
#     mapping correspondence.
#
# Returns
# -------
# Series
#     Same index as caller.
#
# See Also
# --------
# Series.apply : For applying more complex functions on a Series.
# DataFrame.apply : Apply a function row-/column-wise.
# DataFrame.applymap : Apply a function elementwise on a whole DataFrame.
#
# Notes
# -----
# When ``arg`` is a dictionary, values in Series that are not in the
# dictionary (as keys) are converted to ``NaN``. However, if the
# dictionary is a ``dict`` subclass that defines ``__missing__`` (i.e.
# provides a method for default values), then this default is used
# rather than ``NaN``.
#
# Examples
# --------
# >>> s = pd.Series(['cat', 'dog', np.nan, 'rabbit'])
# >>> s
# 0      cat
# 1      dog
# 2      NaN
# 3   rabbit
# dtype: object
#
# ``map`` accepts a ``dict`` or a ``Series``. Values that are not found
# in the ``dict`` are converted to ``NaN``, unless the dict has a default
# value (e.g. ``defaultdict``):
#
# >>> s.map({'cat': 'kitten', 'dog': 'puppy'})
# 0   kitten
# 1    puppy
# 2      NaN
# 3      NaN
# dtype: object
#
# It also accepts a function:
#
# >>> s.map('I am a {}'.format)
# 0       I am a cat
# 1       I am a dog
# 2       I am a nan
# 3    I am a rabbit
# dtype: object
#
# To avoid applying the function to missing values (and keep them as
# ``NaN``) ``na_action='ignore'`` can be used:
#
# >>> s.map('I am a {}'.format, na_action='ignore')
# 0     I am a cat
# 1     I am a dog
# 2            NaN
# 3  I am a rabbit
# dtype: object
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>scipy</b>
# <ul>
# <li>
# <details><summary><u>scipy.stats._stats_py.rankdata</u></summary>
# <blockquote>
# <code>
# Assign ranks to data, dealing with ties appropriately.
#
# By default (``axis=None``), the data array is first flattened, and a flat
# array of ranks is returned. Separately reshape the rank array to the
# shape of the data array if desired (see Examples).
#
# Ranks begin at 1.  The `method` argument controls how ranks are assigned
# to equal values.  See [1]_ for further discussion of ranking methods.
#
# Parameters
# ----------
# a : array_like
#     The array of values to be ranked.
# method : {'average', 'min', 'max', 'dense', 'ordinal'}, optional
#     The method used to assign ranks to tied elements.
#     The following methods are available (default is 'average'):
#
#       * 'average': The average of the ranks that would have been assigned to
#         all the tied values is assigned to each value.
#       * 'min': The minimum of the ranks that would have been assigned to all
#         the tied values is assigned to each value.  (This is also
#         referred to as "competition" ranking.)
#       * 'max': The maximum of the ranks that would have been assigned to all
#         the tied values is assigned to each value.
#       * 'dense': Like 'min', but the rank of the next highest element is
#         assigned the rank immediately after those assigned to the tied
#         elements.
#       * 'ordinal': All values are given a distinct rank, corresponding to
#         the order that the values occur in `a`.
# axis : {None, int}, optional
#     Axis along which to perform the ranking. If ``None``, the data array
#     is first flattened.
#
# Returns
# -------
# ranks : ndarray
#      An array of size equal to the size of `a`, containing rank
#      scores.
#
# References
# ----------
# .. [1] "Ranking", https://en.wikipedia.org/wiki/Ranking
#
# Examples
# --------
# >>> from scipy.stats import rankdata
# >>> rankdata([0, 2, 3, 2])
# array([ 1. ,  2.5,  4. ,  2.5])
# >>> rankdata([0, 2, 3, 2], method='min')
# array([ 1,  2,  4,  2])
# >>> rankdata([0, 2, 3, 2], method='max')
# array([ 1,  3,  4,  3])
# >>> rankdata([0, 2, 3, 2], method='dense')
# array([ 1,  2,  3,  2])
# >>> rankdata([0, 2, 3, 2], method='ordinal')
# array([ 1,  2,  4,  3])
# >>> rankdata([[0, 2], [3, 2]]).reshape(2,2)
# array([[1. , 2.5],
#       [4. , 2.5]])
# >>> rankdata([[0, 2, 2], [3, 2, 5]], axis=1)
# array([[1. , 2.5, 2.5],
#        [2. , 1. , 3. ]])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._classification.log_loss</u></summary>
# <blockquote>
# <code>
# Log loss, aka logistic loss or cross-entropy loss.
#
# This is the loss function used in (multinomial) logistic regression
# and extensions of it such as neural networks, defined as the negative
# log-likelihood of a logistic model that returns ``y_pred`` probabilities
# for its training data ``y_true``.
# The log loss is only defined for two or more labels.
# For a single sample with true label :math:`y \in \{0,1\}` and
# a probability estimate :math:`p = \operatorname{Pr}(y = 1)`, the log
# loss is:
#
# .. math::
#     L_{\log}(y, p) = -(y \log (p) + (1 - y) \log (1 - p))
#
# Read more in the :ref:`User Guide <log_loss>`.
#
# Parameters
# ----------
# y_true : array-like or label indicator matrix
#     Ground truth (correct) labels for n_samples samples.
#
# y_pred : array-like of float, shape = (n_samples, n_classes) or (n_samples,)
#     Predicted probabilities, as returned by a classifier's
#     predict_proba method. If ``y_pred.shape = (n_samples,)``
#     the probabilities provided are assumed to be that of the
#     positive class. The labels in ``y_pred`` are assumed to be
#     ordered alphabetically, as done by
#     :class:`preprocessing.LabelBinarizer`.
#
# eps : float, default=1e-15
#     Log loss is undefined for p=0 or p=1, so probabilities are
#     clipped to max(eps, min(1 - eps, p)).
#
# normalize : bool, default=True
#     If true, return the mean loss per sample.
#     Otherwise, return the sum of the per-sample losses.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# labels : array-like, default=None
#     If not provided, labels will be inferred from y_true. If ``labels``
#     is ``None`` and ``y_pred`` has shape (n_samples,) the labels are
#     assumed to be binary and are inferred from ``y_true``.
#
#     .. versionadded:: 0.18
#
# Returns
# -------
# loss : float
#
# Notes
# -----
# The logarithm used is the natural logarithm (base-e).
#
# Examples
# --------
# >>> from sklearn.metrics import log_loss
# >>> log_loss(["spam", "ham", "ham", "spam"],
# ...          [[.1, .9], [.9, .1], [.8, .2], [.35, .65]])
# 0.21616...
#
# References
# ----------
# C.M. Bishop (2006). Pattern Recognition and Machine Learning. Springer,
# p. 209.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u></summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.KFold</u></summary>
# <blockquote>
# <code>
# K-Folds cross-validator
#
# Provides train/test indices to split data in train/test sets. Split
# dataset into k consecutive folds (without shuffling by default).
#
# Each fold is then used once as a validation while the k - 1 remaining
# folds form the training set.
#
# Read more in the :ref:`User Guide <k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle the data before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold. Otherwise, this
#     parameter has no effect.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import KFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([1, 2, 3, 4])
# >>> kf = KFold(n_splits=2)
# >>> kf.get_n_splits(X)
# 2
# >>> print(kf)
# KFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in kf.split(X):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [2 3] TEST: [0 1]
# TRAIN: [0 1] TEST: [2 3]
#
# Notes
# -----
# The first ``n_samples % n_splits`` folds have size
# ``n_samples // n_splits + 1``, other folds have size
# ``n_samples // n_splits``, where ``n_samples`` is the number of samples.
#
# Randomized CV splitters may return different results for each call of
# split. You can make the results identical by setting `random_state`
# to an integer.
#
# See Also
# --------
# StratifiedKFold : Takes group information into account to avoid building
#     folds with imbalanced class distributions (for binary or multiclass
#     classification tasks).
#
# GroupKFold : K-fold iterator variant with non-overlapping groups.
#
# RepeatedKFold : Repeats K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u></summary>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold.split</u></summary>
# <blockquote>
# <code>
# Generate indices to split data into training and test set.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Training data, where `n_samples` is the number of samples
#     and `n_features` is the number of features.
#
#     Note that providing ``y`` is sufficient to generate the splits and
#     hence ``np.zeros(n_samples)`` may be used as a placeholder for
#     ``X`` instead of actual training data.
#
# y : array-like of shape (n_samples,)
#     The target variable for supervised learning problems.
#     Stratification is done based on the y labels.
#
# groups : object
#     Always ignored, exists for compatibility.
#
# Yields
# ------
# train : ndarray
#     The training set indices for that split.
#
# test : ndarray
#     The testing set indices for that split.
#
# Notes
# -----
# Randomized CV splitters may return different results for each call of
# split. You can make the results identical by setting `random_state`
# to an integer.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>warnings</b>
# <ul>
# <li>
# <details><summary><u>warnings.filterwarnings</u></summary>
# <blockquote>
# <code>
# Insert an entry into the list of warnings filters (at the front).
#
# 'action' -- one of "error", "ignore", "always", "default", "module",
#             or "once"
# 'message' -- a regex that the warning message must match
# 'category' -- a class that the warning must be a subclass of
# 'module' -- a regex that the module name must match
# 'lineno' -- an integer line number, 0 matches all warnings
# 'append' -- if true, append to the list of filters
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Data Preparation | Feature Engineering | Library Loading | Model Building and Training</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>warnings</h2>
# <ul>
# <li>
# <details><summary><u>warnings.filterwarnings</u></summary>
# <blockquote>
# <code>
# Insert an entry into the list of warnings filters (at the front).
#
# 'action' -- one of "error", "ignore", "always", "default", "module",
#             or "once"
# 'message' -- a regex that the warning message must match
# 'category' -- a class that the warning must be a subclass of
# 'module' -- a regex that the module name must match
# 'lineno' -- an integer line number, 0 matches all warnings
# 'append' -- if true, append to the list of filters
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.reset_index</u></summary>
# <blockquote>
# <code>
# Reset the index, or a level of it.
#
# Reset the index of the DataFrame, and use the default one instead.
# If the DataFrame has a MultiIndex, this method can remove one or more
# levels.
#
# Parameters
# ----------
# level : int, str, tuple, or list, default None
#     Only remove the given levels from the index. Removes all levels by
#     default.
# drop : bool, default False
#     Do not try to insert index into dataframe columns. This resets
#     the index to the default integer index.
# inplace : bool, default False
#     Modify the DataFrame in place (do not create a new object).
# col_level : int or str, default 0
#     If the columns have multiple levels, determines which level the
#     labels are inserted into. By default it is inserted into the first
#     level.
# col_fill : object, default ''
#     If the columns have multiple levels, determines how the other
#     levels are named. If None then the index name is repeated.
#
# Returns
# -------
# DataFrame or None
#     DataFrame with the new index or None if ``inplace=True``.
#
# See Also
# --------
# DataFrame.set_index : Opposite of reset_index.
# DataFrame.reindex : Change to new indices or expand indices.
# DataFrame.reindex_like : Change to same indices as other DataFrame.
#
# Examples
# --------
# >>> df = pd.DataFrame([('bird', 389.0),
# ...                    ('bird', 24.0),
# ...                    ('mammal', 80.5),
# ...                    ('mammal', np.nan)],
# ...                   index=['falcon', 'parrot', 'lion', 'monkey'],
# ...                   columns=('class', 'max_speed'))
# >>> df
#          class  max_speed
# falcon    bird      389.0
# parrot    bird       24.0
# lion    mammal       80.5
# monkey  mammal        NaN
#
# When we reset the index, the old index is added as a column, and a
# new sequential index is used:
#
# >>> df.reset_index()
#     index   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# We can use the `drop` parameter to avoid the old index being added as
# a column:
#
# >>> df.reset_index(drop=True)
#     class  max_speed
# 0    bird      389.0
# 1    bird       24.0
# 2  mammal       80.5
# 3  mammal        NaN
#
# You can also use `reset_index` with `MultiIndex`.
#
# >>> index = pd.MultiIndex.from_tuples([('bird', 'falcon'),
# ...                                    ('bird', 'parrot'),
# ...                                    ('mammal', 'lion'),
# ...                                    ('mammal', 'monkey')],
# ...                                   names=['class', 'name'])
# >>> columns = pd.MultiIndex.from_tuples([('speed', 'max'),
# ...                                      ('species', 'type')])
# >>> df = pd.DataFrame([(389.0, 'fly'),
# ...                    ( 24.0, 'fly'),
# ...                    ( 80.5, 'run'),
# ...                    (np.nan, 'jump')],
# ...                   index=index,
# ...                   columns=columns)
# >>> df
#                speed species
#                  max    type
# class  name
# bird   falcon  389.0     fly
#        parrot   24.0     fly
# mammal lion     80.5     run
#        monkey    NaN    jump
#
# If the index has multiple levels, we can reset a subset of them:
#
# >>> df.reset_index(level='class')
#          class  speed species
#                   max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# If we are not dropping the index, by default, it is placed in the top
# level. We can place it in another level:
#
# >>> df.reset_index(level='class', col_level=1)
#                 speed species
#          class    max    type
# name
# falcon    bird  389.0     fly
# parrot    bird   24.0     fly
# lion    mammal   80.5     run
# monkey  mammal    NaN    jump
#
# When the index is inserted under another level, we can specify under
# which one with the parameter `col_fill`:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='species')
#               species  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# If we specify a nonexistent level for `col_fill`, it is created:
#
# >>> df.reset_index(level='class', col_level=1, col_fill='genus')
#                 genus  speed species
#                 class    max    type
# name
# falcon           bird  389.0     fly
# parrot           bird   24.0     fly
# lion           mammal   80.5     run
# monkey         mammal    NaN    jump
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.copy</u></summary>
# <blockquote>
# <code>
# Make a copy of this object's indices and data.
#
# When ``deep=True`` (default), a new object will be created with a
# copy of the calling object's data and indices. Modifications to
# the data or indices of the copy will not be reflected in the
# original object (see notes below).
#
# When ``deep=False``, a new object will be created without copying
# the calling object's data or index (only references to the data
# and index are copied). Any changes to the data of the original
# will be reflected in the shallow copy (and vice versa).
#
# Parameters
# ----------
# deep : bool, default True
#     Make a deep copy, including a copy of the data and the indices.
#     With ``deep=False`` neither the indices nor the data are copied.
#
# Returns
# -------
# copy : Series or DataFrame
#     Object type matches caller.
#
# Notes
# -----
# When ``deep=True``, data is copied but actual Python objects
# will not be copied recursively, only the reference to the object.
# This is in contrast to `copy.deepcopy` in the Standard Library,
# which recursively copies object data (see examples below).
#
# While ``Index`` objects are copied when ``deep=True``, the underlying
# numpy array is not copied for performance reasons. Since ``Index`` is
# immutable, the underlying data can be safely shared and a copy
# is not needed.
#
# Examples
# --------
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> s
# a    1
# b    2
# dtype: int64
#
# >>> s_copy = s.copy()
# >>> s_copy
# a    1
# b    2
# dtype: int64
#
# **Shallow copy versus default (deep) copy:**
#
# >>> s = pd.Series([1, 2], index=["a", "b"])
# >>> deep = s.copy()
# >>> shallow = s.copy(deep=False)
#
# Shallow copy shares data and index with original.
#
# >>> s is shallow
# False
# >>> s.values is shallow.values and s.index is shallow.index
# True
#
# Deep copy has own copy of data and index.
#
# >>> s is deep
# False
# >>> s.values is deep.values or s.index is deep.index
# False
#
# Updates to the data shared by shallow copy and original is reflected
# in both; deep copy remains unchanged.
#
# >>> s[0] = 3
# >>> shallow[1] = 4
# >>> s
# a    3
# b    4
# dtype: int64
# >>> shallow
# a    3
# b    4
# dtype: int64
# >>> deep
# a    1
# b    2
# dtype: int64
#
# Note that when copying an object containing Python objects, a deep copy
# will copy the data, but will not do so recursively. Updating a nested
# data object will be reflected in the deep copy.
#
# >>> s = pd.Series([[1, 2], [3, 4]])
# >>> deep = s.copy()
# >>> s[0][0] = 10
# >>> s
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
# >>> deep
# 0    [10, 2]
# 1     [3, 4]
# dtype: object
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.pop</u></summary>
# <blockquote>
# <code>
# Return item and drop from frame. Raise KeyError if not found.
#
# Parameters
# ----------
# item : label
#     Label of column to be popped.
#
# Returns
# -------
# Series
#
# Examples
# --------
# >>> df = pd.DataFrame([('falcon', 'bird', 389.0),
# ...                    ('parrot', 'bird', 24.0),
# ...                    ('lion', 'mammal', 80.5),
# ...                    ('monkey', 'mammal', np.nan)],
# ...                   columns=('name', 'class', 'max_speed'))
# >>> df
#      name   class  max_speed
# 0  falcon    bird      389.0
# 1  parrot    bird       24.0
# 2    lion  mammal       80.5
# 3  monkey  mammal        NaN
#
# >>> df.pop('class')
# 0      bird
# 1      bird
# 2    mammal
# 3    mammal
# Name: class, dtype: object
#
# >>> df
#      name  max_speed
# 0  falcon      389.0
# 1  parrot       24.0
# 2    lion       80.5
# 3  monkey        NaN
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.reshape.concat.concat</u></summary>
# <blockquote>
# <code>
# Concatenate pandas objects along a particular axis with optional set logic
# along the other axes.
#
# Can also add a layer of hierarchical indexing on the concatenation axis,
# which may be useful if the labels are the same (or overlapping) on
# the passed axis number.
#
# Parameters
# ----------
# objs : a sequence or mapping of Series or DataFrame objects
#     If a mapping is passed, the sorted keys will be used as the `keys`
#     argument, unless it is passed, in which case the values will be
#     selected (see below). Any None objects will be dropped silently unless
#     they are all None in which case a ValueError will be raised.
# axis : {0/'index', 1/'columns'}, default 0
#     The axis to concatenate along.
# join : {'inner', 'outer'}, default 'outer'
#     How to handle indexes on other axis (or axes).
# ignore_index : bool, default False
#     If True, do not use the index values along the concatenation axis. The
#     resulting axis will be labeled 0, ..., n - 1. This is useful if you are
#     concatenating objects where the concatenation axis does not have
#     meaningful indexing information. Note the index values on the other
#     axes are still respected in the join.
# keys : sequence, default None
#     If multiple levels passed, should contain tuples. Construct
#     hierarchical index using the passed keys as the outermost level.
# levels : list of sequences, default None
#     Specific levels (unique values) to use for constructing a
#     MultiIndex. Otherwise they will be inferred from the keys.
# names : list, default None
#     Names for the levels in the resulting hierarchical index.
# verify_integrity : bool, default False
#     Check whether the new concatenated axis contains duplicates. This can
#     be very expensive relative to the actual data concatenation.
# sort : bool, default False
#     Sort non-concatenation axis if it is not already aligned when `join`
#     is 'outer'.
#     This has no effect when ``join='inner'``, which already preserves
#     the order of the non-concatenation axis.
#
#     .. versionchanged:: 1.0.0
#
#        Changed to not sort by default.
#
# copy : bool, default True
#     If False, do not copy data unnecessarily.
#
# Returns
# -------
# object, type of objs
#     When concatenating all ``Series`` along the index (axis=0), a
#     ``Series`` is returned. When ``objs`` contains at least one
#     ``DataFrame``, a ``DataFrame`` is returned. When concatenating along
#     the columns (axis=1), a ``DataFrame`` is returned.
#
# See Also
# --------
# Series.append : Concatenate Series.
# DataFrame.append : Concatenate DataFrames.
# DataFrame.join : Join DataFrames using indexes.
# DataFrame.merge : Merge DataFrames by indexes or columns.
#
# Notes
# -----
# The keys, levels, and names arguments are all optional.
#
# A walkthrough of how this method fits in with other tools for combining
# pandas objects can be found `here
# <https://pandas.pydata.org/pandas-docs/stable/user_guide/merging.html>`__.
#
# Examples
# --------
# Combine two ``Series``.
#
# >>> s1 = pd.Series(['a', 'b'])
# >>> s2 = pd.Series(['c', 'd'])
# >>> pd.concat([s1, s2])
# 0    a
# 1    b
# 0    c
# 1    d
# dtype: object
#
# Clear the existing index and reset it in the result
# by setting the ``ignore_index`` option to ``True``.
#
# >>> pd.concat([s1, s2], ignore_index=True)
# 0    a
# 1    b
# 2    c
# 3    d
# dtype: object
#
# Add a hierarchical index at the outermost level of
# the data with the ``keys`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'])
# s1  0    a
#     1    b
# s2  0    c
#     1    d
# dtype: object
#
# Label the index keys you create with the ``names`` option.
#
# >>> pd.concat([s1, s2], keys=['s1', 's2'],
# ...           names=['Series name', 'Row ID'])
# Series name  Row ID
# s1           0         a
#              1         b
# s2           0         c
#              1         d
# dtype: object
#
# Combine two ``DataFrame`` objects with identical columns.
#
# >>> df1 = pd.DataFrame([['a', 1], ['b', 2]],
# ...                    columns=['letter', 'number'])
# >>> df1
#   letter  number
# 0      a       1
# 1      b       2
# >>> df2 = pd.DataFrame([['c', 3], ['d', 4]],
# ...                    columns=['letter', 'number'])
# >>> df2
#   letter  number
# 0      c       3
# 1      d       4
# >>> pd.concat([df1, df2])
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects with overlapping columns
# and return everything. Columns outside the intersection will
# be filled with ``NaN`` values.
#
# >>> df3 = pd.DataFrame([['c', 3, 'cat'], ['d', 4, 'dog']],
# ...                    columns=['letter', 'number', 'animal'])
# >>> df3
#   letter  number animal
# 0      c       3    cat
# 1      d       4    dog
# >>> pd.concat([df1, df3], sort=False)
#   letter  number animal
# 0      a       1    NaN
# 1      b       2    NaN
# 0      c       3    cat
# 1      d       4    dog
#
# Combine ``DataFrame`` objects with overlapping columns
# and return only those that are shared by passing ``inner`` to
# the ``join`` keyword argument.
#
# >>> pd.concat([df1, df3], join="inner")
#   letter  number
# 0      a       1
# 1      b       2
# 0      c       3
# 1      d       4
#
# Combine ``DataFrame`` objects horizontally along the x axis by
# passing in ``axis=1``.
#
# >>> df4 = pd.DataFrame([['bird', 'polly'], ['monkey', 'george']],
# ...                    columns=['animal', 'name'])
# >>> pd.concat([df1, df4], axis=1)
#   letter  number  animal    name
# 0      a       1    bird   polly
# 1      b       2  monkey  george
#
# Prevent the result from including duplicate index values with the
# ``verify_integrity`` option.
#
# >>> df5 = pd.DataFrame([1], index=['a'])
# >>> df5
#    0
# a  1
# >>> df6 = pd.DataFrame([2], index=['a'])
# >>> df6
#    0
# a  2
# >>> pd.concat([df5, df6], verify_integrity=True)
# Traceback (most recent call last):
#     ...
# ValueError: Indexes have overlapping values: ['a']
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.lib.npyio.load</u></summary>
# <blockquote>
# <code>
# Load arrays or pickled objects from ``.npy``, ``.npz`` or pickled files.
#
# .. warning:: Loading files that contain object arrays uses the ``pickle``
#              module, which is not secure against erroneous or maliciously
#              constructed data. Consider passing ``allow_pickle=False`` to
#              load data that is known not to contain object arrays for the
#              safer handling of untrusted sources.
#
# Parameters
# ----------
# file : file-like object, string, or pathlib.Path
#     The file to read. File-like objects must support the
#     ``seek()`` and ``read()`` methods. Pickled files require that the
#     file-like object support the ``readline()`` method as well.
# mmap_mode : {None, 'r+', 'r', 'w+', 'c'}, optional
#     If not None, then memory-map the file, using the given mode (see
#     `numpy.memmap` for a detailed description of the modes).  A
#     memory-mapped array is kept on disk. However, it can be accessed
#     and sliced like any ndarray.  Memory mapping is especially useful
#     for accessing small fragments of large files without reading the
#     entire file into memory.
# allow_pickle : bool, optional
#     Allow loading pickled object arrays stored in npy files. Reasons for
#     disallowing pickles include security, as loading pickled data can
#     execute arbitrary code. If pickles are disallowed, loading object
#     arrays will fail. Default: False
#
#     .. versionchanged:: 1.16.3
#         Made default False in response to CVE-2019-6446.
#
# fix_imports : bool, optional
#     Only useful when loading Python 2 generated pickled files on Python 3,
#     which includes npy/npz files containing object arrays. If `fix_imports`
#     is True, pickle will try to map the old Python 2 names to the new names
#     used in Python 3.
# encoding : str, optional
#     What encoding to use when reading Python 2 strings. Only useful when
#     loading Python 2 generated pickled files in Python 3, which includes
#     npy/npz files containing object arrays. Values other than 'latin1',
#     'ASCII', and 'bytes' are not allowed, as they can corrupt numerical
#     data. Default: 'ASCII'
#
# Returns
# -------
# result : array, tuple, dict, etc.
#     Data stored in the file. For ``.npz`` files, the returned instance
#     of NpzFile class must be closed to avoid leaking file descriptors.
#
# Raises
# ------
# OSError
#     If the input file does not exist or cannot be read.
# UnpicklingError
#     If ``allow_pickle=True``, but the file cannot be loaded as a pickle.
# ValueError
#     The file contains an object array, but ``allow_pickle=False`` given.
#
# See Also
# --------
# save, savez, savez_compressed, loadtxt
# memmap : Create a memory-map to an array stored in a file on disk.
# lib.format.open_memmap : Create or load a memory-mapped ``.npy`` file.
#
# Notes
# -----
# - If the file contains pickle data, then whatever object is stored
#   in the pickle is returned.
# - If the file is a ``.npy`` file, then a single array is returned.
# - If the file is a ``.npz`` file, then a dictionary-like object is
#   returned, containing ``{filename: array}`` key-value pairs, one for
#   each file in the archive.
# - If the file is a ``.npz`` file, the returned value supports the
#   context manager protocol in a similar fashion to the open function::
#
#     with load('foo.npz') as data:
#         a = data['a']
#
#   The underlying file descriptor is closed when exiting the 'with'
#   block.
#
# Examples
# --------
# Store data to disk, and load it again:
#
# >>> np.save('/tmp/123', np.array([[1, 2, 3], [4, 5, 6]]))
# >>> np.load('/tmp/123.npy')
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# Store compressed data to disk, and load it again:
#
# >>> a=np.array([[1, 2, 3], [4, 5, 6]])
# >>> b=np.array([1, 2])
# >>> np.savez('/tmp/123.npz', a=a, b=b)
# >>> data = np.load('/tmp/123.npz')
# >>> data['a']
# array([[1, 2, 3],
#        [4, 5, 6]])
# >>> data['b']
# array([1, 2])
# >>> data.close()
#
# Mem-map the stored array, and then access the second row
# directly from disk:
#
# >>> X = np.load('/tmp/123.npy', mmap_mode='r')
# >>> X[1, :]
# memmap([4, 5, 6])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.numeric.full</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with `fill_value`.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# fill_value : scalar or array_like
#     Fill value.
# dtype : data-type, optional
#     The desired data-type for the array  The default, None, means
#      ``np.array(fill_value).dtype``.
# order : {'C', 'F'}, optional
#     Whether to store multidimensional data in C- or Fortran-contiguous
#     (row- or column-wise) order in memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of `fill_value` with the given shape, dtype, and order.
#
# See Also
# --------
# full_like : Return a new array with shape of input filled with value.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# zeros : Return a new array setting values to zero.
#
# Examples
# --------
# >>> np.full((2, 2), np.inf)
# array([[inf, inf],
#        [inf, inf]])
# >>> np.full((2, 2), 10)
# array([[10, 10],
#        [10, 10]])
#
# >>> np.full((2, 2), [1, 2])
# array([[1, 2],
#        [1, 2]])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.fromnumeric.clip</u></summary>
# <blockquote>
# <code>
# Clip (limit) the values in an array.
#
# Given an interval, values outside the interval are clipped to
# the interval edges.  For example, if an interval of ``[0, 1]``
# is specified, values smaller than 0 become 0, and values larger
# than 1 become 1.
#
# Equivalent to but faster than ``np.minimum(a_max, np.maximum(a, a_min))``.
#
# No check is performed to ensure ``a_min < a_max``.
#
# Parameters
# ----------
# a : array_like
#     Array containing elements to clip.
# a_min, a_max : array_like or None
#     Minimum and maximum value. If ``None``, clipping is not performed on
#     the corresponding edge. Only one of `a_min` and `a_max` may be
#     ``None``. Both are broadcast against `a`.
# out : ndarray, optional
#     The results will be placed in this array. It may be the input
#     array for in-place clipping.  `out` must be of the right shape
#     to hold the output.  Its type is preserved.
# **kwargs
#     For other keyword-only arguments, see the
#     :ref:`ufunc docs <ufuncs.kwargs>`.
#
#     .. versionadded:: 1.17.0
#
# Returns
# -------
# clipped_array : ndarray
#     An array with the elements of `a`, but where values
#     < `a_min` are replaced with `a_min`, and those > `a_max`
#     with `a_max`.
#
# See Also
# --------
# :ref:`ufuncs-output-type`
#
# Notes
# -----
# When `a_min` is greater than `a_max`, `clip` returns an
# array in which all values are equal to `a_max`,
# as shown in the second example.
#
# Examples
# --------
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, 1, 8)
# array([1, 1, 2, 3, 4, 5, 6, 7, 8, 8])
# >>> np.clip(a, 8, 1)
# array([1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
# >>> np.clip(a, 3, 6, out=a)
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a
# array([3, 3, 3, 3, 4, 5, 6, 6, 6, 6])
# >>> a = np.arange(10)
# >>> a
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
# >>> np.clip(a, [3, 4, 1, 1, 1, 4, 4, 4, 4, 4], 8)
# array([3, 4, 2, 3, 4, 5, 6, 7, 8, 8])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.stack</u></summary>
# <blockquote>
# <code>
# Join a sequence of arrays along a new axis.
#
# The ``axis`` parameter specifies the index of the new axis in the
# dimensions of the result. For example, if ``axis=0`` it will be the first
# dimension and if ``axis=-1`` it will be the last dimension.
#
# .. versionadded:: 1.10.0
#
# Parameters
# ----------
# arrays : sequence of array_like
#     Each array must have the same shape.
#
# axis : int, optional
#     The axis in the result array along which the input arrays are stacked.
#
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what stack would have returned if no
#     out argument were specified.
#
# Returns
# -------
# stacked : ndarray
#     The stacked array has one more dimension than the input arrays.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# block : Assemble an nd-array from nested lists of blocks.
# split : Split array into a list of multiple sub-arrays of equal size.
#
# Examples
# --------
# >>> arrays = [np.random.randn(3, 4) for _ in range(10)]
# >>> np.stack(arrays, axis=0).shape
# (10, 3, 4)
#
# >>> np.stack(arrays, axis=1).shape
# (3, 10, 4)
#
# >>> np.stack(arrays, axis=2).shape
# (3, 4, 10)
#
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.stack((a, b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> np.stack((a, b), axis=-1)
# array([[1, 4],
#        [2, 5],
#        [3, 6]])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.arange</u></summary>
# <blockquote>
# <code>
# arange([start,] stop[, step,], dtype=None, *, like=None)
#
# Return evenly spaced values within a given interval.
#
# Values are generated within the half-open interval ``[start, stop)``
# (in other words, the interval including `start` but excluding `stop`).
# For integer arguments the function is equivalent to the Python built-in
# `range` function, but returns an ndarray rather than a list.
#
# When using a non-integer step, such as 0.1, it is often better to use
# `numpy.linspace`. See the warnings section below for more information.
#
# Parameters
# ----------
# start : integer or real, optional
#     Start of interval.  The interval includes this value.  The default
#     start value is 0.
# stop : integer or real
#     End of interval.  The interval does not include this value, except
#     in some cases where `step` is not an integer and floating point
#     round-off affects the length of `out`.
# step : integer or real, optional
#     Spacing between values.  For any output `out`, this is the distance
#     between two adjacent values, ``out[i+1] - out[i]``.  The default
#     step size is 1.  If `step` is specified as a position argument,
#     `start` must also be given.
# dtype : dtype
#     The type of the output array.  If `dtype` is not given, infer the data
#     type from the other input arguments.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# arange : ndarray
#     Array of evenly spaced values.
#
#     For floating point arguments, the length of the result is
#     ``ceil((stop - start)/step)``.  Because of floating point overflow,
#     this rule may result in the last element of `out` being greater
#     than `stop`.
#
# Warnings
# --------
# The length of the output might not be numerically stable.
#
# Another stability issue is due to the internal implementation of
# `numpy.arange`.
# The actual step value used to populate the array is
# ``dtype(start + step) - dtype(start)`` and not `step`. Precision loss
# can occur here, due to casting or due to using floating points when
# `start` is much larger than `step`. This can lead to unexpected
# behaviour. For example::
#
#   >>> np.arange(0, 5, 0.5, dtype=int)
#   array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0])
#   >>> np.arange(-3, 3, 0.5, dtype=int)
#   array([-3, -2, -1,  0,  1,  2,  3,  4,  5,  6,  7,  8])
#
# In such cases, the use of `numpy.linspace` should be preferred.
#
# See Also
# --------
# numpy.linspace : Evenly spaced numbers with careful handling of endpoints.
# numpy.ogrid: Arrays of evenly spaced numbers in N-dimensions.
# numpy.mgrid: Grid-shaped arrays of evenly spaced numbers in N-dimensions.
#
# Examples
# --------
# >>> np.arange(3)
# array([0, 1, 2])
# >>> np.arange(3.0)
# array([ 0.,  1.,  2.])
# >>> np.arange(3,7)
# array([3, 4, 5, 6])
# >>> np.arange(3,7,2)
# array([3, 5])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.random.mtrand.RandomState.shuffle</u></summary>
# <blockquote>
# <code>
# shuffle(x)
#
# Modify a sequence in-place by shuffling its contents.
#
# This function only shuffles the array along the first axis of a
# multi-dimensional array. The order of sub-arrays is changed but
# their contents remains the same.
#
# .. note::
#     New code should use the ``shuffle`` method of a ``default_rng()``
#     instance instead; please see the :ref:`random-quick-start`.
#
# Parameters
# ----------
# x : ndarray or MutableSequence
#     The array, list or mutable sequence to be shuffled.
#
# Returns
# -------
# None
#
# See Also
# --------
# Generator.shuffle: which should be used for new code.
#
# Examples
# --------
# >>> arr = np.arange(10)
# >>> np.random.shuffle(arr)
# >>> arr
# [1 7 5 2 9 4 3 6 0 8] # random
#
# Multi-dimensional arrays are only shuffled along the first axis:
#
# >>> arr = np.arange(9).reshape((3, 3))
# >>> np.random.shuffle(arr)
# >>> arr
# array([[3, 4, 5], # random
#        [6, 7, 8],
#        [0, 1, 2]])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.shape_base.vstack</u></summary>
# <blockquote>
# <code>
# Stack arrays in sequence vertically (row wise).
#
# This is equivalent to concatenation along the first axis after 1-D arrays
# of shape `(N,)` have been reshaped to `(1,N)`. Rebuilds arrays divided by
# `vsplit`.
#
# This function makes most sense for arrays with up to 3 dimensions. For
# instance, for pixel-data with a height (first axis), width (second axis),
# and r/g/b channels (third axis). The functions `concatenate`, `stack` and
# `block` provide more general stacking and concatenation operations.
#
# Parameters
# ----------
# tup : sequence of ndarrays
#     The arrays must have the same shape along all but the first axis.
#     1-D arrays must have the same length.
#
# Returns
# -------
# stacked : ndarray
#     The array formed by stacking the given arrays, will be at least 2-D.
#
# See Also
# --------
# concatenate : Join a sequence of arrays along an existing axis.
# stack : Join a sequence of arrays along a new axis.
# block : Assemble an nd-array from nested lists of blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# dstack : Stack arrays in sequence depth wise (along third axis).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
# vsplit : Split an array into multiple sub-arrays vertically (row-wise).
#
# Examples
# --------
# >>> a = np.array([1, 2, 3])
# >>> b = np.array([4, 5, 6])
# >>> np.vstack((a,b))
# array([[1, 2, 3],
#        [4, 5, 6]])
#
# >>> a = np.array([[1], [2], [3]])
# >>> b = np.array([[4], [5], [6]])
# >>> np.vstack((a,b))
# array([[1],
#        [2],
#        [3],
#        [4],
#        [5],
#        [6]])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core.numeric.ones</u></summary>
# <blockquote>
# <code>
# Return a new array of given shape and type, filled with ones.
#
# Parameters
# ----------
# shape : int or sequence of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: C
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of ones with the given shape, dtype, and order.
#
# See Also
# --------
# ones_like : Return an array of ones with shape and type of input.
# empty : Return a new uninitialized array.
# zeros : Return a new array setting values to zero.
# full : Return a new array of given shape filled with value.
#
#
# Examples
# --------
# >>> np.ones(5)
# array([1., 1., 1., 1., 1.])
#
# >>> np.ones((5,), dtype=int)
# array([1, 1, 1, 1, 1])
#
# >>> np.ones((2, 1))
# array([[1.],
#        [1.]])
#
# >>> s = (2,2)
# >>> np.ones(s)
# array([[1.,  1.],
#        [1.,  1.]])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.zeros</u></summary>
# <blockquote>
# <code>
# zeros(shape, dtype=float, order='C', *, like=None)
#
# Return a new array of given shape and type, filled with zeros.
#
# Parameters
# ----------
# shape : int or tuple of ints
#     Shape of the new array, e.g., ``(2, 3)`` or ``2``.
# dtype : data-type, optional
#     The desired data-type for the array, e.g., `numpy.int8`.  Default is
#     `numpy.float64`.
# order : {'C', 'F'}, optional, default: 'C'
#     Whether to store multi-dimensional data in row-major
#     (C-style) or column-major (Fortran-style) order in
#     memory.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array of zeros with the given shape, dtype, and order.
#
# See Also
# --------
# zeros_like : Return an array of zeros with shape and type of input.
# empty : Return a new uninitialized array.
# ones : Return a new array setting values to one.
# full : Return a new array of given shape filled with value.
#
# Examples
# --------
# >>> np.zeros(5)
# array([ 0.,  0.,  0.,  0.,  0.])
#
# >>> np.zeros((5,), dtype=int)
# array([0, 0, 0, 0, 0])
#
# >>> np.zeros((2, 1))
# array([[ 0.],
#        [ 0.]])
#
# >>> s = (2,2)
# >>> np.zeros(s)
# array([[ 0.,  0.],
#        [ 0.,  0.]])
#
# >>> np.zeros((2,), dtype=[('x', 'i4'), ('y', 'i4')]) # custom dtype
# array([(0, 0), (0, 0)],
#       dtype=[('x', '<i4'), ('y', '<i4')])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.core._multiarray_umath.concatenate</u></summary>
# <blockquote>
# <code>
# concatenate((a1, a2, ...), axis=0, out=None, dtype=None, casting="same_kind")
#
# Join a sequence of arrays along an existing axis.
#
# Parameters
# ----------
# a1, a2, ... : sequence of array_like
#     The arrays must have the same shape, except in the dimension
#     corresponding to `axis` (the first, by default).
# axis : int, optional
#     The axis along which the arrays will be joined.  If axis is None,
#     arrays are flattened before use.  Default is 0.
# out : ndarray, optional
#     If provided, the destination to place the result. The shape must be
#     correct, matching that of what concatenate would have returned if no
#     out argument were specified.
# dtype : str or dtype
#     If provided, the destination array will have this dtype. Cannot be
#     provided together with `out`.
#
#     .. versionadded:: 1.20.0
#
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'same_kind'.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# res : ndarray
#     The concatenated array.
#
# See Also
# --------
# ma.concatenate : Concatenate function that preserves input masks.
# array_split : Split an array into multiple sub-arrays of equal or
#               near-equal size.
# split : Split array into a list of multiple sub-arrays of equal size.
# hsplit : Split array into multiple sub-arrays horizontally (column wise).
# vsplit : Split array into multiple sub-arrays vertically (row wise).
# dsplit : Split array into multiple sub-arrays along the 3rd axis (depth).
# stack : Stack a sequence of arrays along a new axis.
# block : Assemble arrays from blocks.
# hstack : Stack arrays in sequence horizontally (column wise).
# vstack : Stack arrays in sequence vertically (row wise).
# dstack : Stack arrays in sequence depth wise (along third dimension).
# column_stack : Stack 1-D arrays as columns into a 2-D array.
#
# Notes
# -----
# When one or more of the arrays to be concatenated is a MaskedArray,
# this function will return a MaskedArray object instead of an ndarray,
# but the input masks are *not* preserved. In cases where a MaskedArray
# is expected as input, use the ma.concatenate function from the masked
# array module instead.
#
# Examples
# --------
# >>> a = np.array([[1, 2], [3, 4]])
# >>> b = np.array([[5, 6]])
# >>> np.concatenate((a, b), axis=0)
# array([[1, 2],
#        [3, 4],
#        [5, 6]])
# >>> np.concatenate((a, b.T), axis=1)
# array([[1, 2, 5],
#        [3, 4, 6]])
# >>> np.concatenate((a, b), axis=None)
# array([1, 2, 3, 4, 5, 6])
#
# This function will not preserve masking of MaskedArray inputs.
#
# >>> a = np.ma.arange(3)
# >>> a[1] = np.ma.masked
# >>> b = np.arange(2, 5)
# >>> a
# masked_array(data=[0, --, 2],
#              mask=[False,  True, False],
#        fill_value=999999)
# >>> b
# array([2, 3, 4])
# >>> np.concatenate([a, b])
# masked_array(data=[0, 1, 2, 2, 3, 4],
#              mask=False,
#        fill_value=999999)
# >>> np.ma.concatenate([a, b])
# masked_array(data=[0, --, 2, 2, 3, 4],
#              mask=[False,  True, False, False, False, False],
#        fill_value=999999)
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.lib.npyio.save</u></summary>
# <blockquote>
# <code>
# Save an array to a binary file in NumPy ``.npy`` format.
#
# Parameters
# ----------
# file : file, str, or pathlib.Path
#     File or filename to which the data is saved.  If file is a file-object,
#     then the filename is unchanged.  If file is a string or Path, a ``.npy``
#     extension will be appended to the filename if it does not already
#     have one.
# arr : array_like
#     Array data to be saved.
# allow_pickle : bool, optional
#     Allow saving object arrays using Python pickles. Reasons for disallowing
#     pickles include security (loading pickled data can execute arbitrary
#     code) and portability (pickled objects may not be loadable on different
#     Python installations, for example if the stored objects require libraries
#     that are not available, and not all pickled data is compatible between
#     Python 2 and Python 3).
#     Default: True
# fix_imports : bool, optional
#     Only useful in forcing objects in object arrays on Python 3 to be
#     pickled in a Python 2 compatible way. If `fix_imports` is True, pickle
#     will try to map the new Python 3 names to the old module names used in
#     Python 2, so that the pickle data stream is readable with Python 2.
#
# See Also
# --------
# savez : Save several arrays into a ``.npz`` archive
# savetxt, load
#
# Notes
# -----
# For a description of the ``.npy`` format, see :py:mod:`numpy.lib.format`.
#
# Any data saved to the file is appended to the end of the file.
#
# Examples
# --------
# >>> from tempfile import TemporaryFile
# >>> outfile = TemporaryFile()
#
# >>> x = np.arange(10)
# >>> np.save(outfile, x)
#
# >>> _ = outfile.seek(0) # Only needed here to simulate closing & reopening file
# >>> np.load(outfile)
# array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])
#
#
# >>> with open('test.npy', 'wb') as f:
# ...     np.save(f, np.array([1, 2]))
# ...     np.save(f, np.array([1, 3]))
# >>> with open('test.npy', 'rb') as f:
# ...     a = np.load(f)
# ...     b = np.load(f)
# >>> print(a, b)
# [1 2] [1 3]
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>scipy</h2>
# <ul>
# <li>
# <details><summary><u>scipy.stats._stats_py.rankdata</u></summary>
# <blockquote>
# <code>
# Assign ranks to data, dealing with ties appropriately.
#
# By default (``axis=None``), the data array is first flattened, and a flat
# array of ranks is returned. Separately reshape the rank array to the
# shape of the data array if desired (see Examples).
#
# Ranks begin at 1.  The `method` argument controls how ranks are assigned
# to equal values.  See [1]_ for further discussion of ranking methods.
#
# Parameters
# ----------
# a : array_like
#     The array of values to be ranked.
# method : {'average', 'min', 'max', 'dense', 'ordinal'}, optional
#     The method used to assign ranks to tied elements.
#     The following methods are available (default is 'average'):
#
#       * 'average': The average of the ranks that would have been assigned to
#         all the tied values is assigned to each value.
#       * 'min': The minimum of the ranks that would have been assigned to all
#         the tied values is assigned to each value.  (This is also
#         referred to as "competition" ranking.)
#       * 'max': The maximum of the ranks that would have been assigned to all
#         the tied values is assigned to each value.
#       * 'dense': Like 'min', but the rank of the next highest element is
#         assigned the rank immediately after those assigned to the tied
#         elements.
#       * 'ordinal': All values are given a distinct rank, corresponding to
#         the order that the values occur in `a`.
# axis : {None, int}, optional
#     Axis along which to perform the ranking. If ``None``, the data array
#     is first flattened.
#
# Returns
# -------
# ranks : ndarray
#      An array of size equal to the size of `a`, containing rank
#      scores.
#
# References
# ----------
# .. [1] "Ranking", https://en.wikipedia.org/wiki/Ranking
#
# Examples
# --------
# >>> from scipy.stats import rankdata
# >>> rankdata([0, 2, 3, 2])
# array([ 1. ,  2.5,  4. ,  2.5])
# >>> rankdata([0, 2, 3, 2], method='min')
# array([ 1,  2,  4,  2])
# >>> rankdata([0, 2, 3, 2], method='max')
# array([ 1,  3,  4,  3])
# >>> rankdata([0, 2, 3, 2], method='dense')
# array([ 1,  2,  3,  2])
# >>> rankdata([0, 2, 3, 2], method='ordinal')
# array([ 1,  2,  4,  3])
# >>> rankdata([[0, 2], [3, 2]]).reshape(2,2)
# array([[1. , 2.5],
#       [4. , 2.5]])
# >>> rankdata([[0, 2, 2], [3, 2, 5]], axis=1)
# array([[1. , 2.5, 2.5],
#        [2. , 1. , 3. ]])
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.input_layer.Input</u></summary>
# <blockquote>
# <code>
# `Input()` is used to instantiate a Keras tensor.
#
# A Keras tensor is a symbolic tensor-like object,
# which we augment with certain attributes that allow us to build a Keras model
# just by knowing the inputs and outputs of the model.
#
# For instance, if `a`, `b` and `c` are Keras tensors,
# it becomes possible to do:
# `model = Model(input=[a, b], output=c)`
#
# Args:
#     shape: A shape tuple (integers), not including the batch size.
#         For instance, `shape=(32,)` indicates that the expected input
#         will be batches of 32-dimensional vectors. Elements of this tuple
#         can be None; 'None' elements represent dimensions where the shape is
#         not known.
#     batch_size: optional static batch size (integer).
#     name: An optional name string for the layer.
#         Should be unique in a model (do not reuse the same name twice).
#         It will be autogenerated if it isn't provided.
#     dtype: The data type expected by the input, as a string
#         (`float32`, `float64`, `int32`...)
#     sparse: A boolean specifying whether the placeholder to be created is
#         sparse. Only one of 'ragged' and 'sparse' can be True. Note that,
#         if `sparse` is False, sparse tensors can still be passed into the
#         input - they will be densified with a default value of 0.
#     tensor: Optional existing tensor to wrap into the `Input` layer.
#         If set, the layer will use the `tf.TypeSpec` of this tensor rather
#         than creating a new placeholder tensor.
#     ragged: A boolean specifying whether the placeholder to be created is
#         ragged. Only one of 'ragged' and 'sparse' can be True. In this case,
#         values of 'None' in the 'shape' argument represent ragged dimensions.
#         For more information about RaggedTensors, see
#         [this guide](https://www.tensorflow.org/guide/ragged_tensors).
#     type_spec: A `tf.TypeSpec` object to create the input placeholder from.
#         When provided, all other args except name must be None.
#     **kwargs: deprecated arguments support. Supports `batch_shape` and
#         `batch_input_shape`.
#
# Returns:
#   A `tensor`.
#
# Example:
#
# ```python
# this is a logistic regression in Keras
# x = Input(shape=(32,))
# y = Dense(16, activation='softmax')(x)
# model = Model(x, y)
# ```
#
# Note that even if eager execution is enabled,
# `Input` produces a symbolic tensor-like object (i.e. a placeholder).
# This symbolic tensor-like object can be used with lower-level
# TensorFlow ops that take tensors as inputs, as such:
#
# ```python
# x = Input(shape=(32,))
# y = tf.square(x)  # This op will be treated like a layer
# model = Model(x, y)
# ```
#
# (This behavior does not work for higher-order TensorFlow APIs such as
# control flow and being directly watched by a `tf.GradientTape`).
#
# However, the resulting model will not track any variables that were
# used as inputs to TensorFlow ops. All variable usages must happen within
# Keras layers to make sure they will be tracked by the model's weights.
#
# The Keras Input can also create a placeholder from an arbitrary `tf.TypeSpec`,
# e.g:
#
# ```python
# x = Input(type_spec=tf.RaggedTensorSpec(shape=[None, None],
#                                         dtype=tf.float32, ragged_rank=1))
# y = x.values
# model = Model(x, y)
# ```
# When passing an arbitrary `tf.TypeSpec`, it must represent the signature of an
# entire batch instead of just one example.
#
# Raises:
#   ValueError: If both `sparse` and `ragged` are provided.
#   ValueError: If both `shape` and (`batch_input_shape` or `batch_shape`) are
#     provided.
#   ValueError: If `shape`, `tensor` and `type_spec` are None.
#   ValueError: If arguments besides `type_spec` are non-None while `type_spec`
#               is passed.
#   ValueError: if any unrecognized parameters are provided.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.PReLU</u></summary>
# <blockquote>
# <code>
# Parametric Rectified Linear Unit.
#
# It follows:
#
# ```
#   f(x) = alpha * x for x < 0
#   f(x) = x for x >= 0
# ```
#
# where `alpha` is a learned array with the same shape as x.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha_initializer: Initializer function for the weights.
#   alpha_regularizer: Regularizer for the weights.
#   alpha_constraint: Constraint for the weights.
#   shared_axes: The axes along which to share learnable
#     parameters for the activation function.
#     For example, if the incoming feature maps
#     are from a 2D convolution
#     with output shape `(batch, height, width, channels)`,
#     and you wish to share parameters across space
#     so that each filter only has one set of parameters,
#     set `shared_axes=[1, 2]`.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.normalization.batch_normalization.BatchNormalization</u></summary>
# <blockquote>
# <code>
# Layer that normalizes its inputs.
#
# Batch normalization applies a transformation that maintains the mean output
# close to 0 and the output standard deviation close to 1.
#
# Importantly, batch normalization works differently during training and
# during inference.
#
# **During training** (i.e. when using `fit()` or when calling the layer/model
# with the argument `training=True`), the layer normalizes its output using
# the mean and standard deviation of the current batch of inputs. That is to
# say, for each channel being normalized, the layer returns
# `gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta`, where:
#
# - `epsilon` is small constant (configurable as part of the constructor
# arguments)
# - `gamma` is a learned scaling factor (initialized as 1), which
# can be disabled by passing `scale=False` to the constructor.
# - `beta` is a learned offset factor (initialized as 0), which
# can be disabled by passing `center=False` to the constructor.
#
# **During inference** (i.e. when using `evaluate()` or `predict()` or when
# calling the layer/model with the argument `training=False` (which is the
# default), the layer normalizes its output using a moving average of the
# mean and standard deviation of the batches it has seen during training. That
# is to say, it returns
# `gamma * (batch - self.moving_mean) / sqrt(self.moving_var + epsilon) + beta`.
#
# `self.moving_mean` and `self.moving_var` are non-trainable variables that
# are updated each time the layer in called in training mode, as such:
#
# - `moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)`
# - `moving_var = moving_var * momentum + var(batch) * (1 - momentum)`
#
# As such, the layer will only normalize its inputs during inference
# *after having been trained on data that has similar statistics as the
# inference data*.
#
# Args:
#   axis: Integer, the axis that should be normalized (typically the features
#     axis). For instance, after a `Conv2D` layer with
#     `data_format="channels_first"`, set `axis=1` in `BatchNormalization`.
#   momentum: Momentum for the moving average.
#   epsilon: Small float added to variance to avoid dividing by zero.
#   center: If True, add offset of `beta` to normalized tensor. If False, `beta`
#     is ignored.
#   scale: If True, multiply by `gamma`. If False, `gamma` is not used. When the
#     next layer is linear (also e.g. `nn.relu`), this can be disabled since the
#     scaling will be done by the next layer.
#   beta_initializer: Initializer for the beta weight.
#   gamma_initializer: Initializer for the gamma weight.
#   moving_mean_initializer: Initializer for the moving mean.
#   moving_variance_initializer: Initializer for the moving variance.
#   beta_regularizer: Optional regularizer for the beta weight.
#   gamma_regularizer: Optional regularizer for the gamma weight.
#   beta_constraint: Optional constraint for the beta weight.
#   gamma_constraint: Optional constraint for the gamma weight.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode or in inference mode.
#     - `training=True`: The layer will normalize its inputs using the mean and
#       variance of the current batch of inputs.
#     - `training=False`: The layer will normalize its inputs using the mean and
#       variance of its moving statistics, learned during training.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape` (tuple of
#   integers, does not include the samples axis) when using this layer as the
#   first layer in a model.
#
# Output shape:
#   Same shape as input.
#
# Reference:
#   - [Ioffe and Szegedy, 2015](https://arxiv.org/abs/1502.03167).
#
# **About setting `layer.trainable = False` on a `BatchNormalization` layer:**
#
# The meaning of setting `layer.trainable = False` is to freeze the layer,
# i.e. its internal state will not change during training:
# its trainable weights will not be updated
# during `fit()` or `train_on_batch()`, and its state updates will not be run.
#
# Usually, this does not necessarily mean that the layer is run in inference
# mode (which is normally controlled by the `training` argument that can
# be passed when calling a layer). "Frozen state" and "inference mode"
# are two separate concepts.
#
# However, in the case of the `BatchNormalization` layer, **setting
# `trainable = False` on the layer means that the layer will be
# subsequently run in inference mode** (meaning that it will use
# the moving mean and the moving variance to normalize the current batch,
# rather than using the mean and variance of the current batch).
#
# This behavior has been introduced in TensorFlow 2.0, in order
# to enable `layer.trainable = False` to produce the most commonly
# expected behavior in the convnet fine-tuning use case.
#
# Note that:
#   - Setting `trainable` on an model containing other layers will
#     recursively set the `trainable` value of all inner layers.
#   - If the value of the `trainable`
#     attribute is changed after calling `compile()` on a model,
#     the new value doesn't take effect for this model
#     until `compile()` is called again.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.flatten.Flatten</u></summary>
# <blockquote>
# <code>
# Flattens the input. Does not affect the batch size.
#
# Note: If inputs are shaped `(batch,)` without a feature axis, then
# flattening adds an extra channel dimension and output shape is `(batch, 1)`.
#
# Args:
#   data_format: A string,
#     one of `channels_last` (default) or `channels_first`.
#     The ordering of the dimensions in the inputs.
#     `channels_last` corresponds to inputs with shape
#     `(batch, ..., channels)` while `channels_first` corresponds to
#     inputs with shape `(batch, channels, ...)`.
#     It defaults to the `image_data_format` value found in your
#     Keras config file at `~/.keras/keras.json`.
#     If you never set it, then it will be "channels_last".
#
# Example:
#
# >>> model = tf.keras.Sequential()
# >>> model.add(tf.keras.layers.Conv2D(64, 3, 3, input_shape=(3, 32, 32)))
# >>> model.output_shape
# (None, 1, 10, 64)
#
# >>> model.add(Flatten())
# >>> model.output_shape
# (None, 640)
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model</u></summary>
# <blockquote>
# <code>
# `Model` groups layers into an object with training and inference features.
#
# Args:
#     inputs: The input(s) of the model: a `keras.Input` object or list of
#         `keras.Input` objects.
#     outputs: The output(s) of the model. See Functional API example below.
#     name: String, the name of the model.
#
# There are two ways to instantiate a `Model`:
#
# 1 - With the "Functional API", where you start from `Input`,
# you chain layer calls to specify the model's forward pass,
# and finally you create your model from inputs and outputs:
#
# ```python
# import tensorflow as tf
#
# inputs = tf.keras.Input(shape=(3,))
# x = tf.keras.layers.Dense(4, activation=tf.nn.relu)(inputs)
# outputs = tf.keras.layers.Dense(5, activation=tf.nn.softmax)(x)
# model = tf.keras.Model(inputs=inputs, outputs=outputs)
# ```
#
# Note: Only dicts, lists, and tuples of input tensors are supported. Nested
# inputs are not supported (e.g. lists of list or dicts of dict).
#
# A new Functional API model can also be created by using the
# intermediate tensors. This enables you to quickly extract sub-components
# of the model.
#
# Example:
#
# ```python
# inputs = keras.Input(shape=(None, None, 3))
# processed = keras.layers.RandomCrop(width=32, height=32)(inputs)
# conv = keras.layers.Conv2D(filters=2, kernel_size=3)(processed)
# pooling = keras.layers.GlobalAveragePooling2D()(conv)
# feature = keras.layers.Dense(10)(pooling)
#
# full_model = keras.Model(inputs, feature)
# backbone = keras.Model(processed, conv)
# activations = keras.Model(conv, feature)
# ```
#
# Note that the `backbone` and `activations` models are not
# created with `keras.Input` objects, but with the tensors that are originated
# from `keras.Inputs` objects. Under the hood, the layers and weights will
# be shared across these models, so that user can train the `full_model`, and
# use `backbone` or `activations` to do feature extraction.
# The inputs and outputs of the model can be nested structures of tensors as
# well, and the created models are standard Functional API models that support
# all the existing APIs.
#
# 2 - By subclassing the `Model` class: in that case, you should define your
# layers in `__init__()` and you should implement the model's forward pass
# in `call()`.
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#
#   def call(self, inputs):
#     x = self.dense1(inputs)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# If you subclass `Model`, you can optionally have
# a `training` argument (boolean) in `call()`, which you can use to specify
# a different behavior in training and inference:
#
# ```python
# import tensorflow as tf
#
# class MyModel(tf.keras.Model):
#
#   def __init__(self):
#     super().__init__()
#     self.dense1 = tf.keras.layers.Dense(4, activation=tf.nn.relu)
#     self.dense2 = tf.keras.layers.Dense(5, activation=tf.nn.softmax)
#     self.dropout = tf.keras.layers.Dropout(0.5)
#
#   def call(self, inputs, training=False):
#     x = self.dense1(inputs)
#     if training:
#       x = self.dropout(x, training=training)
#     return self.dense2(x)
#
# model = MyModel()
# ```
#
# Once the model is created, you can config the model with losses and metrics
# with `model.compile()`, train the model with `model.fit()`, or use the model
# to do prediction with `model.predict()`.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold</u></summary>
# <blockquote>
# <code>
# Stratified K-Folds cross-validator.
#
# Provides train/test indices to split data in train/test sets.
#
# This cross-validation object is a variation of KFold that returns
# stratified folds. The folds are made by preserving the percentage of
# samples for each class.
#
# Read more in the :ref:`User Guide <stratified_k_fold>`.
#
# Parameters
# ----------
# n_splits : int, default=5
#     Number of folds. Must be at least 2.
#
#     .. versionchanged:: 0.22
#         ``n_splits`` default value changed from 3 to 5.
#
# shuffle : bool, default=False
#     Whether to shuffle each class's samples before splitting into batches.
#     Note that the samples within each split will not be shuffled.
#
# random_state : int, RandomState instance or None, default=None
#     When `shuffle` is True, `random_state` affects the ordering of the
#     indices, which controls the randomness of each fold for each class.
#     Otherwise, leave `random_state` as `None`.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import StratifiedKFold
# >>> X = np.array([[1, 2], [3, 4], [1, 2], [3, 4]])
# >>> y = np.array([0, 0, 1, 1])
# >>> skf = StratifiedKFold(n_splits=2)
# >>> skf.get_n_splits(X, y)
# 2
# >>> print(skf)
# StratifiedKFold(n_splits=2, random_state=None, shuffle=False)
# >>> for train_index, test_index in skf.split(X, y):
# ...     print("TRAIN:", train_index, "TEST:", test_index)
# ...     X_train, X_test = X[train_index], X[test_index]
# ...     y_train, y_test = y[train_index], y[test_index]
# TRAIN: [1 3] TEST: [0 2]
# TRAIN: [0 2] TEST: [1 3]
#
# Notes
# -----
# The implementation is designed to:
#
# * Generate test sets such that all contain the same distribution of
#   classes, or as close as possible.
# * Be invariant to class label: relabelling ``y = ["Happy", "Sad"]`` to
#   ``y = [1, 0]`` should not change the indices generated.
# * Preserve order dependencies in the dataset ordering, when
#   ``shuffle=False``: all samples from class k in some test set were
#   contiguous in y, or separated in y by samples from classes other than k.
# * Generate test sets where the smallest and largest differ by at most one
#   sample.
#
# .. versionchanged:: 0.22
#     The previous implementation did not follow the last constraint.
#
# See Also
# --------
# RepeatedStratifiedKFold : Repeats Stratified K-Fold n times.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.StratifiedKFold.split</u></summary>
# <blockquote>
# <code>
# Generate indices to split data into training and test set.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Training data, where `n_samples` is the number of samples
#     and `n_features` is the number of features.
#
#     Note that providing ``y`` is sufficient to generate the splits and
#     hence ``np.zeros(n_samples)`` may be used as a placeholder for
#     ``X`` instead of actual training data.
#
# y : array-like of shape (n_samples,)
#     The target variable for supervised learning problems.
#     Stratification is done based on the y labels.
#
# groups : object
#     Always ignored, exists for compatibility.
#
# Yields
# ------
# train : ndarray
#     The training set indices for that split.
#
# test : ndarray
#     The testing set indices for that split.
#
# Notes
# -----
# Randomized CV splitters may return different results for each call of
# split. You can make the results identical by setting `random_state`
# to an integer.
#
# </code>
# <a href='#1'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
import os
os.environ['CUDA_VISIBLE_DEVICES'] = '0'
from sklearn.model_selection import KFold, StratifiedKFold
from sklearn.metrics import roc_auc_score, log_loss
import pandas as pd
import numpy as np
import time
import random
from tqdm import tqdm
import warnings
warnings.filterwarnings('ignore')

import torch
from torch import nn
from torch.utils.data import TensorDataset
from torch.utils.data import DataLoader

MODEL_PATH = ''


train_df = pd.read_csv('../input/santander-customer-transaction-prediction/train.csv',index_col='ID_code')
test_df = pd.read_csv('../input/santander-customer-transaction-prediction/test.csv',index_col='ID_code')

synthetic_indices = np.load('../input/synthetissantandersamples/synthetic_samples_indexes.npy')
mask=np.full(len(test_df),True,dtype=bool)
mask[synthetic_indices]=False
test_df_nonsynthetic = test_df.iloc[mask].reset_index(drop=True).copy()


y = train_df.pop('target')
target = y

tr_te = pd.concat([train_df,test_df])

num_cols = [c for c in train_df.columns]

for f in tqdm(num_cols):
    tr_te[f+'_counts'] = tr_te[f].map(pd.concat([train_df[f], test_df_nonsynthetic[f]], axis=0).value_counts().to_dict(), na_action='ignore')
    tr_te[f+'_counts'] = tr_te[f+'_counts'].fillna(1)


count_cols = [f+'_counts' for f in num_cols]


from scipy.special import erfinv
from scipy.stats import rankdata

def rankgauss(x):
    r = (rankdata(x) - 1) / len(x)  # to [0,1]
    r = 2 * r - 1  # to [-1,1]
    r = np.clip(r, -0.99, 0.99)
    r2 = erfinv(r)
    return r2




print('scaling num_cols')
for col in num_cols + count_cols:
    print('scaling {}'.format(col))
    col_mean = tr_te[col].mean()
    col_std = tr_te[col].std()
    tr_te[col].fillna(col_mean, inplace=True)
    tr_te[col] = rankgauss(tr_te[col].values)


train_df = tr_te[0:train_df.shape[0]]
test_df = tr_te[train_df.shape[0]:]





X = np.stack([train_df[num_cols].values,train_df[count_cols].values],axis = -1)
X_test = np.stack([test_df[num_cols].values,test_df[count_cols].values],axis = -1)
#X = train_df[num_cols].values

def augment_counts(x, y, t_pos, t_neg):
    xs,xn = [],[]
    for i in range(t_pos):
        mask = y>0
        x1 = x[mask].copy()
        ids = np.arange(x1.shape[0])
        for c in range(200):
            np.random.shuffle(ids)
            x1[:,c] = x1[ids][:,c]
            #x1[:,c+200] = x1[ids][:,c+200]
        xs.append(x1)

    for i in range(t_neg):
        mask = y==0
        x1 = x[mask].copy()
        ids = np.arange(x1.shape[0])
        for c in range(200):
            np.random.shuffle(ids)
            x1[:,c] = x1[ids][:,c]
            #x1[:,c+200] = x1[ids][:,c+200]
        xn.append(x1)

    xs = np.vstack(xs)
    xn = np.vstack(xn)
    ys = np.ones(xs.shape[0])
    yn = np.zeros(xn.shape[0])
    x = np.vstack([x,xs,xn])
    y = np.concatenate([y,ys,yn])
    return x,y

from keras import layers as L
import keras.backend as K
from keras.models import Model
from keras.optimizers import Adam
from keras.losses import binary_crossentropy
from keras.callbacks import ModelCheckpoint
def build_model():
    inp = L.Input((200,2))
    x = L.Dense(64)(inp)
    x = L.PReLU()(x)
    x = L.BatchNormalization()(x)
    x = L.Dropout(0.2)(x)
    x = L.Dense(8)(x)
    x = L.PReLU()(x)
    x = L.Flatten()(x)
    out = L.Dense(1,activation='sigmoid')(x)

    m = Model(inp,out)
    print(m.summary())
    return m

num_folds = 5
folds = StratifiedKFold(n_splits=num_folds, shuffle=True, random_state=42)
splits = list(folds.split(train_df.values, target.values))

oof_preds = np.zeros(y.shape)
test_preds = np.zeros(X_test.shape[0])

from keras.callbacks import ReduceLROnPlateau

for fold_ in [0, 1, 2, 3, 4]:
    trn_idx, val_idx = splits[fold_]

    X_train, y_train = X[trn_idx], y[trn_idx]
    X_valid, y_valid = X[val_idx], y[val_idx]
    
    X_train, y_train = augment_counts(X_train, y_train, 2, 1)

    m = build_model()
    ckpt = ModelCheckpoint(MODEL_PATH + 'nn{}.hdf5'.format(fold_), save_best_only=True, verbose=True)
    pl = ReduceLROnPlateau(factor=0.5,patience=5)
    m.compile(optimizer=Adam(), loss=binary_crossentropy)
    m.fit(X_train, y_train, validation_data=(X_valid, y_valid), epochs=20, verbose=1, callbacks=[ckpt,pl], batch_size = 256)
    m.load_weights(MODEL_PATH + 'nn{}.hdf5'.format(fold_))
    oof_preds[val_idx] = m.predict(X_valid)[:, 0]
    test_preds += m.predict(X_test)[:,0]
test_preds/= 5



np.save(MODEL_PATH + 'oof_NN13b_aug.npy',oof_preds)
np.save(MODEL_PATH + 'sub_NN13b_aug.npy',test_preds)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
submission = pd.read_csv('../input/santander-customer-transaction-prediction/sample_submission.csv')
submission['target'] = test_preds
submission.to_csv(MODEL_PATH + 'submission.csv',index=False)

# %%
