# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>keras</b></li>
# <li><b>os</b></li>
# <li><b>pandas</b></li>
# <li><b>sklearn</b></li>
# <li><b>tensorflow</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Visualization</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 8</u></h3></summary><small><a href=#8>goto cell # 8</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 5</u></h3></summary><small><a href=#5>goto cell # 5</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['target', 'ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <ul><li><b>Args:</b> [['ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['target', 'ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <ul><li><b>Args:</b> [['ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Sub-sampling and Train-test Splitting</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Sub-sampling and Train-test Splitting" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'test_size': 0.25, 'random_state': 50}</li></ul>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'test_size': 0.25, 'random_state': 50}</li></ul>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 8</u></h3></summary><small><a href=#8>goto cell # 8</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Feature Selection</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Selection" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['target', 'ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <ul><li><b>Args:</b> [['ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['target', 'ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <ul><li><b>Args:</b> [['ID_code']] | <b>Kwargs:</b> {'axis': 1}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Building and Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>tensorflow</b>
# <ul>
# <li>
# <details><summary><u>tensorflow.python.ops.variables.local_variables_initializer</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Returns an Op that initializes all local variables.
#
# This is just a shortcut for `variables_initializer(local_variables())`
#
# @compatibility(TF2)
# In TF2, variables are initialized immediately when they are created. There is
# no longer a need to run variable initializers before using them.
# @end_compatibility
#
# Returns:
#   An Op that initializes all local variables in the graph.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>tensorflow</b>
# <ul>
# <li>
# <details><summary><u>tensorflow.python.ops.variables.local_variables_initializer</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Returns an Op that initializes all local variables.
#
# This is just a shortcut for `variables_initializer(local_variables())`
#
# @compatibility(TF2)
# In TF2, variables are initialized immediately when they are created. There is
# no longer a need to run variable initializers before using them.
# @end_compatibility
#
# Returns:
#   An Op that initializes all local variables in the graph.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.metrics.AUC</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Approximates the AUC (Area under the curve) of the ROC or PR curves.
#
# The AUC (Area under the curve) of the ROC (Receiver operating
# characteristic; default) or PR (Precision Recall) curves are quality measures
# of binary classifiers. Unlike the accuracy, and like cross-entropy
# losses, ROC-AUC and PR-AUC evaluate all the operational points of a model.
#
# This class approximates AUCs using a Riemann sum. During the metric
# accumulation phrase, predictions are accumulated within predefined buckets
# by value. The AUC is then computed by interpolating per-bucket averages. These
# buckets define the evaluated operational points.
#
# This metric creates four local variables, `true_positives`, `true_negatives`,
# `false_positives` and `false_negatives` that are used to compute the AUC.
# To discretize the AUC curve, a linearly spaced set of thresholds is used to
# compute pairs of recall and precision values. The area under the ROC-curve is
# therefore computed using the height of the recall values by the false positive
# rate, while the area under the PR-curve is the computed using the height of
# the precision values by the recall.
#
# This value is ultimately returned as `auc`, an idempotent operation that
# computes the area under a discretized curve of precision versus recall values
# (computed using the aforementioned variables). The `num_thresholds` variable
# controls the degree of discretization with larger numbers of thresholds more
# closely approximating the true AUC. The quality of the approximation may vary
# dramatically depending on `num_thresholds`. The `thresholds` parameter can be
# used to manually specify thresholds which split the predictions more evenly.
#
# For a best approximation of the real AUC, `predictions` should be distributed
# approximately uniformly in the range [0, 1] (if `from_logits=False`). The
# quality of the AUC approximation may be poor if this is not the case. Setting
# `summation_method` to 'minoring' or 'majoring' can help quantify the error in
# the approximation by providing lower or upper bound estimate of the AUC.
#
# If `sample_weight` is `None`, weights default to 1.
# Use `sample_weight` of 0 to mask values.
#
# Args:
#   num_thresholds: (Optional) Defaults to 200. The number of thresholds to
#     use when discretizing the roc curve. Values must be > 1.
#   curve: (Optional) Specifies the name of the curve to be computed, 'ROC'
#     [default] or 'PR' for the Precision-Recall-curve.
#   summation_method: (Optional) Specifies the [Riemann summation method](
#       https://en.wikipedia.org/wiki/Riemann_sum) used.
#       'interpolation' (default) applies mid-point summation scheme for `ROC`.
#       For PR-AUC, interpolates (true/false) positives but not the ratio that
#       is precision (see Davis & Goadrich 2006 for details);
#       'minoring' applies left summation
#       for increasing intervals and right summation for decreasing intervals;
#       'majoring' does the opposite.
#   name: (Optional) string name of the metric instance.
#   dtype: (Optional) data type of the metric result.
#   thresholds: (Optional) A list of floating point values to use as the
#     thresholds for discretizing the curve. If set, the `num_thresholds`
#     parameter is ignored. Values should be in [0, 1]. Endpoint thresholds
#     equal to {-epsilon, 1+epsilon} for a small positive epsilon value will
#     be automatically included with these to correctly handle predictions
#     equal to exactly 0 or 1.
#   multi_label: boolean indicating whether multilabel data should be
#     treated as such, wherein AUC is computed separately for each label and
#     then averaged across labels, or (when False) if the data should be
#     flattened into a single label before AUC computation. In the latter
#     case, when multilabel data is passed to AUC, each label-prediction pair
#     is treated as an individual data point. Should be set to False for
#     multi-class data.
#   num_labels: (Optional) The number of labels, used when `multi_label` is
#     True. If `num_labels` is not specified, then state variables get created
#     on the first call to `update_state`.
#   label_weights: (Optional) list, array, or tensor of non-negative weights
#     used to compute AUCs for multilabel data. When `multi_label` is True,
#     the weights are applied to the individual label AUCs when they are
#     averaged to produce the multi-label AUC. When it's False, they are used
#     to weight the individual label predictions in computing the confusion
#     matrix on the flattened data. Note that this is unlike class_weights in
#     that class_weights weights the example depending on the value of its
#     label, whereas label_weights depends only on the index of that label
#     before flattening; therefore `label_weights` should not be used for
#     multi-class data.
#   from_logits: boolean indicating whether the predictions (`y_pred` in
#     `update_state`) are probabilities or sigmoid logits. As a rule of thumb,
#     when using a keras loss, the `from_logits` constructor argument of the
#     loss should match the AUC `from_logits` constructor argument.
#
# Standalone usage:
#
# >>> m = tf.keras.metrics.AUC(num_thresholds=3)
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9])
# >>> # threshold values are [0 - 1e-7, 0.5, 1 + 1e-7]
# >>> # tp = [2, 1, 0], fp = [2, 0, 0], fn = [0, 1, 2], tn = [0, 2, 2]
# >>> # tp_rate = recall = [1, 0.5, 0], fp_rate = [1, 0, 0]
# >>> # auc = ((((1+0.5)/2)*(1-0)) + (((0.5+0)/2)*(0-0))) = 0.75
# >>> m.result().numpy()
# 0.75
#
# >>> m.reset_state()
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9],
# ...                sample_weight=[1, 0, 0, 1])
# >>> m.result().numpy()
# 1.0
#
# Usage with `compile()` API:
#
# ```python
# Reports the AUC of a model outputting a probability.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.AUC()])
#
# Reports the AUC of a model outputting a logit.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(from_logits=True),
#               metrics=[tf.keras.metrics.AUC(from_logits=True)])
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers.L2</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# A regularizer that applies a L2 regularization penalty.
#
# The L2 regularization penalty is computed as:
# `loss = l2 * reduce_sum(square(x))`
#
# L2 may be passed to a layer as a string identifier:
#
# >>> dense = tf.keras.layers.Dense(3, kernel_regularizer='l2')
#
# In this case, the default value used is `l2=0.01`.
#
# Attributes:
#     l2: Float; L2 regularization factor.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.constraints.MaxNorm</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# MaxNorm weight constraint.
#
# Constrains the weights incident to each hidden unit
# to have a norm less than or equal to a desired value.
#
# Also available via the shortcut function `tf.keras.constraints.max_norm`.
#
# Args:
#   max_value: the maximum norm value for the incoming weights.
#   axis: integer, axis along which to calculate weight norms.
#     For instance, in a `Dense` layer the weight matrix
#     has shape `(input_dim, output_dim)`,
#     set `axis` to `0` to constrain each weight vector
#     of length `(input_dim,)`.
#     In a `Conv2D` layer with `data_format="channels_last"`,
#     the weight tensor has shape
#     `(rows, cols, input_depth, output_depth)`,
#     set `axis` to `[0, 1, 2]`
#     to constrain the weights of each filter tensor of size
#     `(rows, cols, input_depth)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'batch_size': 16384, 'epochs': 125}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.metrics.AUC</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Approximates the AUC (Area under the curve) of the ROC or PR curves.
#
# The AUC (Area under the curve) of the ROC (Receiver operating
# characteristic; default) or PR (Precision Recall) curves are quality measures
# of binary classifiers. Unlike the accuracy, and like cross-entropy
# losses, ROC-AUC and PR-AUC evaluate all the operational points of a model.
#
# This class approximates AUCs using a Riemann sum. During the metric
# accumulation phrase, predictions are accumulated within predefined buckets
# by value. The AUC is then computed by interpolating per-bucket averages. These
# buckets define the evaluated operational points.
#
# This metric creates four local variables, `true_positives`, `true_negatives`,
# `false_positives` and `false_negatives` that are used to compute the AUC.
# To discretize the AUC curve, a linearly spaced set of thresholds is used to
# compute pairs of recall and precision values. The area under the ROC-curve is
# therefore computed using the height of the recall values by the false positive
# rate, while the area under the PR-curve is the computed using the height of
# the precision values by the recall.
#
# This value is ultimately returned as `auc`, an idempotent operation that
# computes the area under a discretized curve of precision versus recall values
# (computed using the aforementioned variables). The `num_thresholds` variable
# controls the degree of discretization with larger numbers of thresholds more
# closely approximating the true AUC. The quality of the approximation may vary
# dramatically depending on `num_thresholds`. The `thresholds` parameter can be
# used to manually specify thresholds which split the predictions more evenly.
#
# For a best approximation of the real AUC, `predictions` should be distributed
# approximately uniformly in the range [0, 1] (if `from_logits=False`). The
# quality of the AUC approximation may be poor if this is not the case. Setting
# `summation_method` to 'minoring' or 'majoring' can help quantify the error in
# the approximation by providing lower or upper bound estimate of the AUC.
#
# If `sample_weight` is `None`, weights default to 1.
# Use `sample_weight` of 0 to mask values.
#
# Args:
#   num_thresholds: (Optional) Defaults to 200. The number of thresholds to
#     use when discretizing the roc curve. Values must be > 1.
#   curve: (Optional) Specifies the name of the curve to be computed, 'ROC'
#     [default] or 'PR' for the Precision-Recall-curve.
#   summation_method: (Optional) Specifies the [Riemann summation method](
#       https://en.wikipedia.org/wiki/Riemann_sum) used.
#       'interpolation' (default) applies mid-point summation scheme for `ROC`.
#       For PR-AUC, interpolates (true/false) positives but not the ratio that
#       is precision (see Davis & Goadrich 2006 for details);
#       'minoring' applies left summation
#       for increasing intervals and right summation for decreasing intervals;
#       'majoring' does the opposite.
#   name: (Optional) string name of the metric instance.
#   dtype: (Optional) data type of the metric result.
#   thresholds: (Optional) A list of floating point values to use as the
#     thresholds for discretizing the curve. If set, the `num_thresholds`
#     parameter is ignored. Values should be in [0, 1]. Endpoint thresholds
#     equal to {-epsilon, 1+epsilon} for a small positive epsilon value will
#     be automatically included with these to correctly handle predictions
#     equal to exactly 0 or 1.
#   multi_label: boolean indicating whether multilabel data should be
#     treated as such, wherein AUC is computed separately for each label and
#     then averaged across labels, or (when False) if the data should be
#     flattened into a single label before AUC computation. In the latter
#     case, when multilabel data is passed to AUC, each label-prediction pair
#     is treated as an individual data point. Should be set to False for
#     multi-class data.
#   num_labels: (Optional) The number of labels, used when `multi_label` is
#     True. If `num_labels` is not specified, then state variables get created
#     on the first call to `update_state`.
#   label_weights: (Optional) list, array, or tensor of non-negative weights
#     used to compute AUCs for multilabel data. When `multi_label` is True,
#     the weights are applied to the individual label AUCs when they are
#     averaged to produce the multi-label AUC. When it's False, they are used
#     to weight the individual label predictions in computing the confusion
#     matrix on the flattened data. Note that this is unlike class_weights in
#     that class_weights weights the example depending on the value of its
#     label, whereas label_weights depends only on the index of that label
#     before flattening; therefore `label_weights` should not be used for
#     multi-class data.
#   from_logits: boolean indicating whether the predictions (`y_pred` in
#     `update_state`) are probabilities or sigmoid logits. As a rule of thumb,
#     when using a keras loss, the `from_logits` constructor argument of the
#     loss should match the AUC `from_logits` constructor argument.
#
# Standalone usage:
#
# >>> m = tf.keras.metrics.AUC(num_thresholds=3)
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9])
# >>> # threshold values are [0 - 1e-7, 0.5, 1 + 1e-7]
# >>> # tp = [2, 1, 0], fp = [2, 0, 0], fn = [0, 1, 2], tn = [0, 2, 2]
# >>> # tp_rate = recall = [1, 0.5, 0], fp_rate = [1, 0, 0]
# >>> # auc = ((((1+0.5)/2)*(1-0)) + (((0.5+0)/2)*(0-0))) = 0.75
# >>> m.result().numpy()
# 0.75
#
# >>> m.reset_state()
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9],
# ...                sample_weight=[1, 0, 0, 1])
# >>> m.result().numpy()
# 1.0
#
# Usage with `compile()` API:
#
# ```python
# Reports the AUC of a model outputting a probability.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.AUC()])
#
# Reports the AUC of a model outputting a logit.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(from_logits=True),
#               metrics=[tf.keras.metrics.AUC(from_logits=True)])
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers.L2</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [0.005] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.005] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.005] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [0.005] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# A regularizer that applies a L2 regularization penalty.
#
# The L2 regularization penalty is computed as:
# `loss = l2 * reduce_sum(square(x))`
#
# L2 may be passed to a layer as a string identifier:
#
# >>> dense = tf.keras.layers.Dense(3, kernel_regularizer='l2')
#
# In this case, the default value used is `l2=0.01`.
#
# Attributes:
#     l2: Float; L2 regularization factor.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 200, 'activation': 'relu', 'kernel_initializer': 'normal'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 200, 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [100] | <b>Kwargs:</b> {'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [50] | <b>Kwargs:</b> {'activation': 'tanh'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 1, 'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'rate': 0.2}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'rate': 0.1}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'rate': 0.1}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'rate': 0.1}</li></ul>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.constraints.MaxNorm</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [5] | <b>Kwargs:</b> {}</li></ul>
# <ul><li><b>Args:</b> [5] | <b>Kwargs:</b> {}</li></ul>
# <blockquote>
# <code>
# MaxNorm weight constraint.
#
# Constrains the weights incident to each hidden unit
# to have a norm less than or equal to a desired value.
#
# Also available via the shortcut function `tf.keras.constraints.max_norm`.
#
# Args:
#   max_value: the maximum norm value for the incoming weights.
#   axis: integer, axis along which to calculate weight norms.
#     For instance, in a `Dense` layer the weight matrix
#     has shape `(input_dim, output_dim)`,
#     set `axis` to `0` to constrain each weight vector
#     of length `(input_dim,)`.
#     In a `Conv2D` layer with `data_format="channels_last"`,
#     the weight tensor has shape
#     `(rows, cols, input_depth, output_depth)`,
#     set `axis` to `[0, 1, 2]`
#     to constrain the weights of each filter tensor of size
#     `(rows, cols, input_depth)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'loss': 'binary_crossentropy', 'optimizer': 'adam', 'metrics': ['accuracy']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 13</u></h3></summary><small><a href=#13>goto cell # 13</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'batch_size': 16384, 'epochs': 125}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 15</u></h3></summary><small><a href=#15>goto cell # 15</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.backend</u></summary>
# <blockquote>
# <code>
# Keras backend API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.backend.get_session</u></summary>
# <blockquote>
# <code>
# Returns the TF session to be used by the backend.
#
# If a default TensorFlow session is available, we will return it.
#
# Else, we will return the global Keras session assuming it matches
# the current graph.
#
# If no global Keras session exists at this point:
# we will create a new global session.
#
# Note that you can manually set the global session
# via `K.set_session(sess)`.
#
# Args:
#     op_input_list: An option sequence of tensors or ops, which will be used
#       to determine the current graph. Otherwise the default graph will be
#       used.
#
# Returns:
#     A TensorFlow session.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.constraints.MaxNorm</u></summary>
# <blockquote>
# <code>
# MaxNorm weight constraint.
#
# Constrains the weights incident to each hidden unit
# to have a norm less than or equal to a desired value.
#
# Also available via the shortcut function `tf.keras.constraints.max_norm`.
#
# Args:
#   max_value: the maximum norm value for the incoming weights.
#   axis: integer, axis along which to calculate weight norms.
#     For instance, in a `Dense` layer the weight matrix
#     has shape `(input_dim, output_dim)`,
#     set `axis` to `0` to constrain each weight vector
#     of length `(input_dim,)`.
#     In a `Conv2D` layer with `data_format="channels_last"`,
#     the weight tensor has shape
#     `(rows, cols, input_depth, output_depth)`,
#     set `axis` to `[0, 1, 2]`
#     to constrain the weights of each filter tensor of size
#     `(rows, cols, input_depth)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers</u></summary>
# <blockquote>
# <code>
# Keras layers API.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.metrics</u></summary>
# <blockquote>
# <code>
# Built-in metrics.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.metrics.AUC</u></summary>
# <blockquote>
# <code>
# Approximates the AUC (Area under the curve) of the ROC or PR curves.
#
# The AUC (Area under the curve) of the ROC (Receiver operating
# characteristic; default) or PR (Precision Recall) curves are quality measures
# of binary classifiers. Unlike the accuracy, and like cross-entropy
# losses, ROC-AUC and PR-AUC evaluate all the operational points of a model.
#
# This class approximates AUCs using a Riemann sum. During the metric
# accumulation phrase, predictions are accumulated within predefined buckets
# by value. The AUC is then computed by interpolating per-bucket averages. These
# buckets define the evaluated operational points.
#
# This metric creates four local variables, `true_positives`, `true_negatives`,
# `false_positives` and `false_negatives` that are used to compute the AUC.
# To discretize the AUC curve, a linearly spaced set of thresholds is used to
# compute pairs of recall and precision values. The area under the ROC-curve is
# therefore computed using the height of the recall values by the false positive
# rate, while the area under the PR-curve is the computed using the height of
# the precision values by the recall.
#
# This value is ultimately returned as `auc`, an idempotent operation that
# computes the area under a discretized curve of precision versus recall values
# (computed using the aforementioned variables). The `num_thresholds` variable
# controls the degree of discretization with larger numbers of thresholds more
# closely approximating the true AUC. The quality of the approximation may vary
# dramatically depending on `num_thresholds`. The `thresholds` parameter can be
# used to manually specify thresholds which split the predictions more evenly.
#
# For a best approximation of the real AUC, `predictions` should be distributed
# approximately uniformly in the range [0, 1] (if `from_logits=False`). The
# quality of the AUC approximation may be poor if this is not the case. Setting
# `summation_method` to 'minoring' or 'majoring' can help quantify the error in
# the approximation by providing lower or upper bound estimate of the AUC.
#
# If `sample_weight` is `None`, weights default to 1.
# Use `sample_weight` of 0 to mask values.
#
# Args:
#   num_thresholds: (Optional) Defaults to 200. The number of thresholds to
#     use when discretizing the roc curve. Values must be > 1.
#   curve: (Optional) Specifies the name of the curve to be computed, 'ROC'
#     [default] or 'PR' for the Precision-Recall-curve.
#   summation_method: (Optional) Specifies the [Riemann summation method](
#       https://en.wikipedia.org/wiki/Riemann_sum) used.
#       'interpolation' (default) applies mid-point summation scheme for `ROC`.
#       For PR-AUC, interpolates (true/false) positives but not the ratio that
#       is precision (see Davis & Goadrich 2006 for details);
#       'minoring' applies left summation
#       for increasing intervals and right summation for decreasing intervals;
#       'majoring' does the opposite.
#   name: (Optional) string name of the metric instance.
#   dtype: (Optional) data type of the metric result.
#   thresholds: (Optional) A list of floating point values to use as the
#     thresholds for discretizing the curve. If set, the `num_thresholds`
#     parameter is ignored. Values should be in [0, 1]. Endpoint thresholds
#     equal to {-epsilon, 1+epsilon} for a small positive epsilon value will
#     be automatically included with these to correctly handle predictions
#     equal to exactly 0 or 1.
#   multi_label: boolean indicating whether multilabel data should be
#     treated as such, wherein AUC is computed separately for each label and
#     then averaged across labels, or (when False) if the data should be
#     flattened into a single label before AUC computation. In the latter
#     case, when multilabel data is passed to AUC, each label-prediction pair
#     is treated as an individual data point. Should be set to False for
#     multi-class data.
#   num_labels: (Optional) The number of labels, used when `multi_label` is
#     True. If `num_labels` is not specified, then state variables get created
#     on the first call to `update_state`.
#   label_weights: (Optional) list, array, or tensor of non-negative weights
#     used to compute AUCs for multilabel data. When `multi_label` is True,
#     the weights are applied to the individual label AUCs when they are
#     averaged to produce the multi-label AUC. When it's False, they are used
#     to weight the individual label predictions in computing the confusion
#     matrix on the flattened data. Note that this is unlike class_weights in
#     that class_weights weights the example depending on the value of its
#     label, whereas label_weights depends only on the index of that label
#     before flattening; therefore `label_weights` should not be used for
#     multi-class data.
#   from_logits: boolean indicating whether the predictions (`y_pred` in
#     `update_state`) are probabilities or sigmoid logits. As a rule of thumb,
#     when using a keras loss, the `from_logits` constructor argument of the
#     loss should match the AUC `from_logits` constructor argument.
#
# Standalone usage:
#
# >>> m = tf.keras.metrics.AUC(num_thresholds=3)
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9])
# >>> # threshold values are [0 - 1e-7, 0.5, 1 + 1e-7]
# >>> # tp = [2, 1, 0], fp = [2, 0, 0], fn = [0, 1, 2], tn = [0, 2, 2]
# >>> # tp_rate = recall = [1, 0.5, 0], fp_rate = [1, 0, 0]
# >>> # auc = ((((1+0.5)/2)*(1-0)) + (((0.5+0)/2)*(0-0))) = 0.75
# >>> m.result().numpy()
# 0.75
#
# >>> m.reset_state()
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9],
# ...                sample_weight=[1, 0, 0, 1])
# >>> m.result().numpy()
# 1.0
#
# Usage with `compile()` API:
#
# ```python
# Reports the AUC of a model outputting a probability.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.AUC()])
#
# Reports the AUC of a model outputting a logit.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(from_logits=True),
#               metrics=[tf.keras.metrics.AUC(from_logits=True)])
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers</u></summary>
# <blockquote>
# <code>
# Built-in regularizers.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers.L2</u></summary>
# <blockquote>
# <code>
# A regularizer that applies a L2 regularization penalty.
#
# The L2 regularization penalty is computed as:
# `loss = l2 * reduce_sum(square(x))`
#
# L2 may be passed to a layer as a string identifier:
#
# >>> dense = tf.keras.layers.Dense(3, kernel_regularizer='l2')
#
# In this case, the default value used is `l2=0.01`.
#
# Attributes:
#     l2: Float; L2 regularization factor.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u></summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u></summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>tensorflow</b>
# <ul>
# <li>
# <details><summary><u>tensorflow</u></summary>
# <blockquote>
# <code>
# Top-level module of TensorFlow. By convention, we refer to this module as
# `tf` instead of `tensorflow`, following the common practice of importing
# TensorFlow via the command `import tensorflow as tf`.
#
# The primary function of this module is to import all of the public TensorFlow
# interfaces into a single place. The interfaces themselves are located in
# sub-modules, as described below.
#
# Note that the file `__init__.py` in the TensorFlow source code tree is actually
# only a placeholder to enable test cases to run. The TensorFlow build replaces
# this file with a file generated from [`api_template.__init__.py`](https://www.github.com/tensorflow/tensorflow/blob/master/tensorflow/api_template.__init__.py)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>tensorflow.python.ops.variables.local_variables_initializer</u></summary>
# <blockquote>
# <code>
# Returns an Op that initializes all local variables.
#
# This is just a shortcut for `variables_initializer(local_variables())`
#
# @compatibility(TF2)
# In TF2, variables are initialized immediately when they are created. There is
# no longer a need to run variable initializers before using them.
# @end_compatibility
#
# Returns:
#   An Op that initializes all local variables in the graph.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
import tensorflow as tf
import pandas as pd
import os
from sklearn.metrics import roc_auc_score
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from keras import Sequential
from keras import layers
from keras import backend as K
from keras.layers.core import Dense
from keras import regularizers
from keras.layers import Dropout
from keras.constraints import max_norm


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Data Preparation</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#2'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _cell_guid="79c7e3d0-c299-4dcb-8224-4455121ee9b0" _uuid="d629ff2d2480ee46fbb7e2d37f6b5fab8052498a"
# Import data
train = pd.read_csv('../input/train.csv')
test = pd.read_csv('../input/test.csv')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>3. Data Preparation</h1>  <a id='3'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="ef491a4d42450d6c0a79924621c27beebc33a5fa"
train.shape


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Data Preparation</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="977e678a7a750cd0a10ee37e1174f16680fd6b29"
test.shape


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>5. Data Preparation</h1>  <a id='5'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#5'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="cd9b334eabd747735355d44c9e93044b0c47bb1f"
#Check num of cases in label 
print(train.target.value_counts())
print(train.target.value_counts()[1]/train.target.value_counts()[0])


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>6. Data Preparation | Feature Engineering</h1>  <a id='6'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="4aa3662a015dee0cc8ef691e818adc96adfdcfd6"
train_features = train.drop(['target', 'ID_code'], axis=1)
train_targets = train['target']
test_features = test.drop(['ID_code'], axis=1)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>7. Data Preparation</h1>  <a id='7'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="a22d536c925cf641d2830c09066d16b574e9aa7b"
X_train, X_test, y_train, y_test = train_test_split(train_features, train_targets, test_size = 0.25, random_state = 50)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>8. Data Preparation | Feature Engineering | Library Loading</h1>  <a id='8'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u></summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="e0e3037ae4eaef75b7f3df50764c7ba4d018e29c"
# Feature Scaling
from sklearn.preprocessing import StandardScaler
sc = StandardScaler()
X_train = sc.fit_transform(X_train)
X_test = sc.transform(X_test)
test_features = sc.transform(test_features)



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>9. Library Loading | Model Building and Training</h1>  <a id='9'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.metrics.AUC</u></summary>
# <blockquote>
# <code>
# Approximates the AUC (Area under the curve) of the ROC or PR curves.
#
# The AUC (Area under the curve) of the ROC (Receiver operating
# characteristic; default) or PR (Precision Recall) curves are quality measures
# of binary classifiers. Unlike the accuracy, and like cross-entropy
# losses, ROC-AUC and PR-AUC evaluate all the operational points of a model.
#
# This class approximates AUCs using a Riemann sum. During the metric
# accumulation phrase, predictions are accumulated within predefined buckets
# by value. The AUC is then computed by interpolating per-bucket averages. These
# buckets define the evaluated operational points.
#
# This metric creates four local variables, `true_positives`, `true_negatives`,
# `false_positives` and `false_negatives` that are used to compute the AUC.
# To discretize the AUC curve, a linearly spaced set of thresholds is used to
# compute pairs of recall and precision values. The area under the ROC-curve is
# therefore computed using the height of the recall values by the false positive
# rate, while the area under the PR-curve is the computed using the height of
# the precision values by the recall.
#
# This value is ultimately returned as `auc`, an idempotent operation that
# computes the area under a discretized curve of precision versus recall values
# (computed using the aforementioned variables). The `num_thresholds` variable
# controls the degree of discretization with larger numbers of thresholds more
# closely approximating the true AUC. The quality of the approximation may vary
# dramatically depending on `num_thresholds`. The `thresholds` parameter can be
# used to manually specify thresholds which split the predictions more evenly.
#
# For a best approximation of the real AUC, `predictions` should be distributed
# approximately uniformly in the range [0, 1] (if `from_logits=False`). The
# quality of the AUC approximation may be poor if this is not the case. Setting
# `summation_method` to 'minoring' or 'majoring' can help quantify the error in
# the approximation by providing lower or upper bound estimate of the AUC.
#
# If `sample_weight` is `None`, weights default to 1.
# Use `sample_weight` of 0 to mask values.
#
# Args:
#   num_thresholds: (Optional) Defaults to 200. The number of thresholds to
#     use when discretizing the roc curve. Values must be > 1.
#   curve: (Optional) Specifies the name of the curve to be computed, 'ROC'
#     [default] or 'PR' for the Precision-Recall-curve.
#   summation_method: (Optional) Specifies the [Riemann summation method](
#       https://en.wikipedia.org/wiki/Riemann_sum) used.
#       'interpolation' (default) applies mid-point summation scheme for `ROC`.
#       For PR-AUC, interpolates (true/false) positives but not the ratio that
#       is precision (see Davis & Goadrich 2006 for details);
#       'minoring' applies left summation
#       for increasing intervals and right summation for decreasing intervals;
#       'majoring' does the opposite.
#   name: (Optional) string name of the metric instance.
#   dtype: (Optional) data type of the metric result.
#   thresholds: (Optional) A list of floating point values to use as the
#     thresholds for discretizing the curve. If set, the `num_thresholds`
#     parameter is ignored. Values should be in [0, 1]. Endpoint thresholds
#     equal to {-epsilon, 1+epsilon} for a small positive epsilon value will
#     be automatically included with these to correctly handle predictions
#     equal to exactly 0 or 1.
#   multi_label: boolean indicating whether multilabel data should be
#     treated as such, wherein AUC is computed separately for each label and
#     then averaged across labels, or (when False) if the data should be
#     flattened into a single label before AUC computation. In the latter
#     case, when multilabel data is passed to AUC, each label-prediction pair
#     is treated as an individual data point. Should be set to False for
#     multi-class data.
#   num_labels: (Optional) The number of labels, used when `multi_label` is
#     True. If `num_labels` is not specified, then state variables get created
#     on the first call to `update_state`.
#   label_weights: (Optional) list, array, or tensor of non-negative weights
#     used to compute AUCs for multilabel data. When `multi_label` is True,
#     the weights are applied to the individual label AUCs when they are
#     averaged to produce the multi-label AUC. When it's False, they are used
#     to weight the individual label predictions in computing the confusion
#     matrix on the flattened data. Note that this is unlike class_weights in
#     that class_weights weights the example depending on the value of its
#     label, whereas label_weights depends only on the index of that label
#     before flattening; therefore `label_weights` should not be used for
#     multi-class data.
#   from_logits: boolean indicating whether the predictions (`y_pred` in
#     `update_state`) are probabilities or sigmoid logits. As a rule of thumb,
#     when using a keras loss, the `from_logits` constructor argument of the
#     loss should match the AUC `from_logits` constructor argument.
#
# Standalone usage:
#
# >>> m = tf.keras.metrics.AUC(num_thresholds=3)
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9])
# >>> # threshold values are [0 - 1e-7, 0.5, 1 + 1e-7]
# >>> # tp = [2, 1, 0], fp = [2, 0, 0], fn = [0, 1, 2], tn = [0, 2, 2]
# >>> # tp_rate = recall = [1, 0.5, 0], fp_rate = [1, 0, 0]
# >>> # auc = ((((1+0.5)/2)*(1-0)) + (((0.5+0)/2)*(0-0))) = 0.75
# >>> m.result().numpy()
# 0.75
#
# >>> m.reset_state()
# >>> m.update_state([0, 0, 1, 1], [0, 0.5, 0.3, 0.9],
# ...                sample_weight=[1, 0, 0, 1])
# >>> m.result().numpy()
# 1.0
#
# Usage with `compile()` API:
#
# ```python
# Reports the AUC of a model outputting a probability.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.AUC()])
#
# Reports the AUC of a model outputting a logit.
# model.compile(optimizer='sgd',
#               loss=tf.keras.losses.BinaryCrossentropy(from_logits=True),
#               metrics=[tf.keras.metrics.AUC(from_logits=True)])
# ```
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.backend.get_session</u></summary>
# <blockquote>
# <code>
# Returns the TF session to be used by the backend.
#
# If a default TensorFlow session is available, we will return it.
#
# Else, we will return the global Keras session assuming it matches
# the current graph.
#
# If no global Keras session exists at this point:
# we will create a new global session.
#
# Note that you can manually set the global session
# via `K.set_session(sess)`.
#
# Args:
#     op_input_list: An option sequence of tensors or ops, which will be used
#       to determine the current graph. Otherwise the default graph will be
#       used.
#
# Returns:
#     A TensorFlow session.
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>tensorflow</h2>
# <ul>
# <li>
# <details><summary><u>tensorflow.python.ops.variables.local_variables_initializer</u></summary>
# <blockquote>
# <code>
# Returns an Op that initializes all local variables.
#
# This is just a shortcut for `variables_initializer(local_variables())`
#
# @compatibility(TF2)
# In TF2, variables are initialized immediately when they are created. There is
# no longer a need to run variable initializers before using them.
# @end_compatibility
#
# Returns:
#   An Op that initializes all local variables in the graph.
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="8bf12627db197ae404d751061796d6fdde047cc2"
# Add RUC metric to monitor NN
def auc(y_true, y_pred):
    auc = tf.metrics.auc(y_true, y_pred)[1]
    K.get_session().run(tf.local_variables_initializer())
    return auc



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>10. Data Preparation</h1>  <a id='10'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="80489233dcc33baa361ea1b713058bb3730dfe9e"
input_dim = X_train.shape[1]
input_dim

# %% _uuid="79bda7f30f3b3627c9dbacb49542b9dc2c2f0677"
# Try early stopping
#from keras.callbacks import EarlyStopping
#callback = EarlyStopping(monitor='loss', min_delta=0, patience=10, verbose=0, mode='auto', baseline=None, restore_best_weights=True)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>12. Model Building and Training</h1>  <a id='12'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.regularizers.L2</u></summary>
# <blockquote>
# <code>
# A regularizer that applies a L2 regularization penalty.
#
# The L2 regularization penalty is computed as:
# `loss = l2 * reduce_sum(square(x))`
#
# L2 may be passed to a layer as a string identifier:
#
# >>> dense = tf.keras.layers.Dense(3, kernel_regularizer='l2')
#
# In this case, the default value used is `l2=0.01`.
#
# Attributes:
#     l2: Float; L2 regularization factor.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.constraints.MaxNorm</u></summary>
# <blockquote>
# <code>
# MaxNorm weight constraint.
#
# Constrains the weights incident to each hidden unit
# to have a norm less than or equal to a desired value.
#
# Also available via the shortcut function `tf.keras.constraints.max_norm`.
#
# Args:
#   max_value: the maximum norm value for the incoming weights.
#   axis: integer, axis along which to calculate weight norms.
#     For instance, in a `Dense` layer the weight matrix
#     has shape `(input_dim, output_dim)`,
#     set `axis` to `0` to constrain each weight vector
#     of length `(input_dim,)`.
#     In a `Conv2D` layer with `data_format="channels_last"`,
#     the weight tensor has shape
#     `(rows, cols, input_depth, output_depth)`,
#     set `axis` to `[0, 1, 2]`
#     to constrain the weights of each filter tensor of size
#     `(rows, cols, input_depth)`.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.summary</u></summary>
# <blockquote>
# <code>
# Prints a string summary of the network.
#
# Args:
#     line_length: Total length of printed lines
#         (e.g. set this to adapt the display to different
#         terminal window sizes).
#     positions: Relative or absolute positions of log elements
#         in each line. If not provided,
#         defaults to `[.33, .55, .67, 1.]`.
#     print_fn: Print function to use. Defaults to `print`.
#         It will be called on each line of the summary.
#         You can set it to a custom function
#         in order to capture the string summary.
#     expand_nested: Whether to expand the nested models.
#         If not provided, defaults to `False`.
#     show_trainable: Whether to show if a layer is trainable.
#         If not provided, defaults to `False`.
#
# Raises:
#     ValueError: if `summary()` is called before the model is built.
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="083001c4e3e3a32522cbb2cf7df0e55906cdcd7b"
model = Sequential()
# Input layer
model.add(Dense(units = 200, activation = "relu", input_dim = input_dim, kernel_initializer = "normal", kernel_regularizer=regularizers.l2(0.005), 
                kernel_constraint = max_norm(5.)))
# Add dropout regularization
model.add(Dropout(rate=0.2))

# First hidden layer
model.add(Dense(units = 200, activation='relu', kernel_regularizer=regularizers.l2(0.005), kernel_constraint=max_norm(5)))
# Add dropout regularization
model.add(Dropout(rate=0.1))

# Second hidden layer
model.add(Dense(100, activation='relu', kernel_regularizer=regularizers.l2(0.005), kernel_constraint=max_norm(5)))
# Add dropout regularization
model.add(Dropout(rate=0.1))

# Third hidden layer
model.add(Dense(50, activation='tanh', kernel_regularizer=regularizers.l2(0.005), kernel_constraint=max_norm(5)))
# Add dropout regularization
model.add(Dropout(rate=0.1))

# Output layer
model.add(layers.Dense(units = 1, activation='sigmoid'))

model.compile(loss='binary_crossentropy', optimizer='adam', metrics=['accuracy', auc])
model.summary()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>13. Model Building and Training</h1>  <a id='13'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="85799af4ef45d3809e9cbb1903b98522ebbe8fa0"
model.fit(X_train, y_train, batch_size = 16384, epochs = 125, validation_data = (X_test, y_test))#, callbacks = [callback])


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>14. Model Building and Training</h1>  <a id='14'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.metrics._ranking.roc_auc_score</u></summary>
# <blockquote>
# <code>
# Compute Area Under the Receiver Operating Characteristic Curve (ROC AUC)
# from prediction scores.
#
# Note: this implementation can be used with binary, multiclass and
# multilabel classification, but some restrictions apply (see Parameters).
#
# Read more in the :ref:`User Guide <roc_metrics>`.
#
# Parameters
# ----------
# y_true : array-like of shape (n_samples,) or (n_samples, n_classes)
#     True labels or binary label indicators. The binary and multiclass cases
#     expect labels with shape (n_samples,) while the multilabel case expects
#     binary label indicators with shape (n_samples, n_classes).
#
# y_score : array-like of shape (n_samples,) or (n_samples, n_classes)
#     Target scores.
#
#     * In the binary case, it corresponds to an array of shape
#       `(n_samples,)`. Both probability estimates and non-thresholded
#       decision values can be provided. The probability estimates correspond
#       to the **probability of the class with the greater label**,
#       i.e. `estimator.classes_[1]` and thus
#       `estimator.predict_proba(X, y)[:, 1]`. The decision values
#       corresponds to the output of `estimator.decision_function(X, y)`.
#       See more information in the :ref:`User guide <roc_auc_binary>`;
#     * In the multiclass case, it corresponds to an array of shape
#       `(n_samples, n_classes)` of probability estimates provided by the
#       `predict_proba` method. The probability estimates **must**
#       sum to 1 across the possible classes. In addition, the order of the
#       class scores must correspond to the order of ``labels``,
#       if provided, or else to the numerical or lexicographical order of
#       the labels in ``y_true``. See more information in the
#       :ref:`User guide <roc_auc_multiclass>`;
#     * In the multilabel case, it corresponds to an array of shape
#       `(n_samples, n_classes)`. Probability estimates are provided by the
#       `predict_proba` method and the non-thresholded decision values by
#       the `decision_function` method. The probability estimates correspond
#       to the **probability of the class with the greater label for each
#       output** of the classifier. See more information in the
#       :ref:`User guide <roc_auc_multilabel>`.
#
# average : {'micro', 'macro', 'samples', 'weighted'} or None,             default='macro'
#     If ``None``, the scores for each class are returned. Otherwise,
#     this determines the type of averaging performed on the data:
#     Note: multiclass ROC AUC currently only handles the 'macro' and
#     'weighted' averages.
#
#     ``'micro'``:
#         Calculate metrics globally by considering each element of the label
#         indicator matrix as a label.
#     ``'macro'``:
#         Calculate metrics for each label, and find their unweighted
#         mean.  This does not take label imbalance into account.
#     ``'weighted'``:
#         Calculate metrics for each label, and find their average, weighted
#         by support (the number of true instances for each label).
#     ``'samples'``:
#         Calculate metrics for each instance, and find their average.
#
#     Will be ignored when ``y_true`` is binary.
#
# sample_weight : array-like of shape (n_samples,), default=None
#     Sample weights.
#
# max_fpr : float > 0 and <= 1, default=None
#     If not ``None``, the standardized partial AUC [2]_ over the range
#     [0, max_fpr] is returned. For the multiclass case, ``max_fpr``,
#     should be either equal to ``None`` or ``1.0`` as AUC ROC partial
#     computation currently is not supported for multiclass.
#
# multi_class : {'raise', 'ovr', 'ovo'}, default='raise'
#     Only used for multiclass targets. Determines the type of configuration
#     to use. The default value raises an error, so either
#     ``'ovr'`` or ``'ovo'`` must be passed explicitly.
#
#     ``'ovr'``:
#         Stands for One-vs-rest. Computes the AUC of each class
#         against the rest [3]_ [4]_. This
#         treats the multiclass case in the same way as the multilabel case.
#         Sensitive to class imbalance even when ``average == 'macro'``,
#         because class imbalance affects the composition of each of the
#         'rest' groupings.
#     ``'ovo'``:
#         Stands for One-vs-one. Computes the average AUC of all
#         possible pairwise combinations of classes [5]_.
#         Insensitive to class imbalance when
#         ``average == 'macro'``.
#
# labels : array-like of shape (n_classes,), default=None
#     Only used for multiclass targets. List of labels that index the
#     classes in ``y_score``. If ``None``, the numerical or lexicographical
#     order of the labels in ``y_true`` is used.
#
# Returns
# -------
# auc : float
#
# References
# ----------
# .. [1] `Wikipedia entry for the Receiver operating characteristic
#         <https://en.wikipedia.org/wiki/Receiver_operating_characteristic>`_
#
# .. [2] `Analyzing a portion of the ROC curve. McClish, 1989
#         <https://www.ncbi.nlm.nih.gov/pubmed/2668680>`_
#
# .. [3] Provost, F., Domingos, P. (2000). Well-trained PETs: Improving
#        probability estimation trees (Section 6.2), CeDER Working Paper
#        #IS-00-04, Stern School of Business, New York University.
#
# .. [4] `Fawcett, T. (2006). An introduction to ROC analysis. Pattern
#         Recognition Letters, 27(8), 861-874.
#         <https://www.sciencedirect.com/science/article/pii/S016786550500303X>`_
#
# .. [5] `Hand, D.J., Till, R.J. (2001). A Simple Generalisation of the Area
#         Under the ROC Curve for Multiple Class Classification Problems.
#         Machine Learning, 45(2), 171-186.
#         <http://link.springer.com/article/10.1023/A:1010920819831>`_
#
# See Also
# --------
# average_precision_score : Area under the precision-recall curve.
# roc_curve : Compute Receiver operating characteristic (ROC) curve.
# RocCurveDisplay.from_estimator : Plot Receiver Operating Characteristic
#     (ROC) curve given an estimator and some data.
# RocCurveDisplay.from_predictions : Plot Receiver Operating Characteristic
#     (ROC) curve given the true and predicted values.
#
# Examples
# --------
# Binary case:
#
# >>> from sklearn.datasets import load_breast_cancer
# >>> from sklearn.linear_model import LogisticRegression
# >>> from sklearn.metrics import roc_auc_score
# >>> X, y = load_breast_cancer(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear", random_state=0).fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X)[:, 1])
# 0.99...
# >>> roc_auc_score(y, clf.decision_function(X))
# 0.99...
#
# Multiclass case:
#
# >>> from sklearn.datasets import load_iris
# >>> X, y = load_iris(return_X_y=True)
# >>> clf = LogisticRegression(solver="liblinear").fit(X, y)
# >>> roc_auc_score(y, clf.predict_proba(X), multi_class='ovr')
# 0.99...
#
# Multilabel case:
#
# >>> import numpy as np
# >>> from sklearn.datasets import make_multilabel_classification
# >>> from sklearn.multioutput import MultiOutputClassifier
# >>> X, y = make_multilabel_classification(random_state=0)
# >>> clf = MultiOutputClassifier(clf).fit(X, y)
# >>> # get a list of n_output containing probability arrays of shape
# >>> # (n_samples, n_classes)
# >>> y_pred = clf.predict_proba(X)
# >>> # extract the positive columns for each output
# >>> y_pred = np.transpose([pred[:, 1] for pred in y_pred])
# >>> roc_auc_score(y, y_pred, average=None)
# array([0.82..., 0.86..., 0.94..., 0.85... , 0.94...])
# >>> from sklearn.linear_model import RidgeClassifierCV
# >>> clf = RidgeClassifierCV().fit(X, y)
# >>> roc_auc_score(y, clf.decision_function(X), average=None)
# array([0.81..., 0.84... , 0.93..., 0.87..., 0.94...])
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="b5d848c12f5f5b08f3a4a2b089aa53a8d20f46f7"
y_pred = model.predict_proba(X_test)
roc_auc_score(y_test, y_pred)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>15. Model Building and Training</h1>  <a id='15'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#15'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="89b22d2fcee7187cf033ff95f3ab621ba4c7dba9"
id_code_test = test['ID_code']
# Make predicitions
pred = model.predict(test_features)
pred_ = pred[:,0]

# %% _uuid="b594f20d96642cef8cd64a347c1bb04124c09fd1"
pred_


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>17. Data Preparation</h1>  <a id='17'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#17'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _kg_hide-output=false _uuid="c8d5f4fc81d2b5a0091269425383577bb2707592"
# To CSV
my_submission = pd.DataFrame({"ID_code" : id_code_test, "target" : pred_})


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>18. Data Preparation</h1>  <a id='18'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="20483d977735cfd3ea4a90ad7f6b1396a76b07e2"
my_submission


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>19. Data Preparation</h1>  <a id='19'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#19'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% _uuid="33d7f6d84ad3acfb88de49899f4db775ae7857d8"
my_submission.to_csv('submission.csv', index = False, header = True)

# %% _uuid="5b9c899f9688e19de9049e1cd6f65a8055eaea6d"
