# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.1
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# # Index of ML Operations<a id='top_phases'></a>
# <ul>
# <ul><li><details><summary><h2>Imported Libraries</h2></summary>
# <ul>
#
# <li><b>keras</b></li>
# <li><b>matplotlib</b></li>
# <li><b>numpy</b></li>
# <li><b>os</b></li>
# <li><b>pandas</b></li>
# <li><b>seaborn</b></li>
# <li><b>sklearn</b></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Visualization</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Visualization" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'yticklabels': False, 'cbar': False}</li></ul>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 8</u></h3></summary><small><a href=#8>goto cell # 8</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'kind': 'bar', 'stacked': True}</li></ul>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'kind': 'bar', 'stacked': True}</li></ul>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'kind': 'bar', 'stacked': True}</li></ul>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 11</u></h3></summary><small><a href=#11>goto cell # 11</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'kind': 'bar', 'stacked': True}</li></ul>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 18</u></h3></summary><small><a href=#18>goto cell # 18</a></small>
# <ul>
#
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'yticklabels': False, 'cbar': False}</li></ul>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 19</u></h3></summary><small><a href=#19>goto cell # 19</a></small>
# <ul>
#
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'yticklabels': False, 'cbar': False}</li></ul>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Data Preparation</span></h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Preparation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.mode</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mode(s) of the Series.
#
# The mode is the value that appears most often. There can be multiple modes.
#
# Always returns Series even if only one value is returned.
#
# Parameters
# ----------
# dropna : bool, default True
#     Don't consider counts of NaN/NaT.
#
# Returns
# -------
# Series
#     Modes of the Series in sorted order.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Cast a pandas object to a specified dtype ``dtype``.
#
# Parameters
# ----------
# dtype : data type, or dict of column name -> data type
#     Use a numpy.dtype or Python type to cast entire pandas object to
#     the same type. Alternatively, use {col: dtype, ...}, where col is a
#     column label and dtype is a numpy.dtype or Python type to cast one
#     or more of the DataFrame's columns to column-specific types.
# copy : bool, default True
#     Return a copy when ``copy=True`` (be very careful setting
#     ``copy=False`` as changes to values then may propagate to other
#     pandas objects).
# errors : {'raise', 'ignore'}, default 'raise'
#     Control raising of exceptions on invalid data for provided dtype.
#
#     - ``raise`` : allow exceptions to be raised
#     - ``ignore`` : suppress exceptions. On error return original object.
#
# Returns
# -------
# casted : same type as caller
#
# See Also
# --------
# to_datetime : Convert argument to datetime.
# to_timedelta : Convert argument to timedelta.
# to_numeric : Convert argument to a numeric type.
# numpy.ndarray.astype : Cast a numpy array to a specified type.
#
# Notes
# -----
# .. deprecated:: 1.3.0
#
#     Using ``astype`` to convert from timezone-naive dtype to
#     timezone-aware dtype is deprecated and will raise in a
#     future version.  Use :meth:`Series.dt.tz_localize` instead.
#
# Examples
# --------
# Create a DataFrame:
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# Cast all columns to int32:
#
# >>> df.astype('int32').dtypes
# col1    int32
# col2    int32
# dtype: object
#
# Cast col1 to int32 using a dictionary:
#
# >>> df.astype({'col1': 'int32'}).dtypes
# col1    int32
# col2    int64
# dtype: object
#
# Create a series:
#
# >>> ser = pd.Series([1, 2], dtype='int32')
# >>> ser
# 0    1
# 1    2
# dtype: int32
# >>> ser.astype('int64')
# 0    1
# 1    2
# dtype: int64
#
# Convert to categorical type:
#
# >>> ser.astype('category')
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [1, 2]
#
# Convert to ordered categorical type with custom ordering:
#
# >>> from pandas.api.types import CategoricalDtype
# >>> cat_dtype = CategoricalDtype(
# ...     categories=[2, 1], ordered=True)
# >>> ser.astype(cat_dtype)
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [2 < 1]
#
# Note that using ``copy=False`` and changing data on a new
# pandas object may propagate changes:
#
# >>> s1 = pd.Series([1, 2])
# >>> s2 = s1.astype('int64', copy=False)
# >>> s2[0] = 10
# >>> s1  # note that s1[0] has changed too
# 0    10
# 1     2
# dtype: int64
#
# Create a series of dates:
#
# >>> ser_date = pd.Series(pd.date_range('20200101', periods=3))
# >>> ser_date
# 0   2020-01-01
# 1   2020-01-02
# 2   2020-01-03
# dtype: datetime64[ns]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.asarray</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# asarray(a, dtype=None, order=None, *, like=None)
#
# Convert the input to an array.
#
# Parameters
# ----------
# a : array_like
#     Input data, in any form that can be converted to an array.  This
#     includes lists, lists of tuples, tuples, tuples of tuples, tuples
#     of lists and ndarrays.
# dtype : data-type, optional
#     By default, the data-type is inferred from the input data.
# order : {'C', 'F', 'A', 'K'}, optional
#     Memory layout.  'A' and 'K' depend on the order of input array a.
#     'C' row-major (C-style),
#     'F' column-major (Fortran-style) memory representation.
#     'A' (any) means 'F' if `a` is Fortran contiguous, 'C' otherwise
#     'K' (keep) preserve input order
#     Defaults to 'K'.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array interpretation of `a`.  No copy is performed if the input
#     is already an ndarray with matching dtype and order.  If `a` is a
#     subclass of ndarray, a base class ndarray is returned.
#
# See Also
# --------
# asanyarray : Similar function which passes through subclasses.
# ascontiguousarray : Convert input to a contiguous array.
# asfarray : Convert input to a floating point ndarray.
# asfortranarray : Convert input to an ndarray with column-major
#                  memory order.
# asarray_chkfinite : Similar function which checks input for NaNs and Infs.
# fromiter : Create an array from an iterator.
# fromfunction : Construct an array by executing a function on grid
#                positions.
#
# Examples
# --------
# Convert a list into an array:
#
# >>> a = [1, 2]
# >>> np.asarray(a)
# array([1, 2])
#
# Existing arrays are not copied:
#
# >>> a = np.array([1, 2])
# >>> np.asarray(a) is a
# True
#
# If `dtype` is set, array is copied only if dtype does not match:
#
# >>> a = np.array([1, 2], dtype=np.float32)
# >>> np.asarray(a, dtype=np.float32) is a
# True
# >>> np.asarray(a, dtype=np.float64) is a
# False
#
# Contrary to `asanyarray`, ndarray subclasses are not passed through:
#
# >>> issubclass(np.recarray, np.ndarray)
# True
# >>> a = np.array([(1.0, 2), (3.0, 4)], dtype='f4,i4').view(np.recarray)
# >>> np.asarray(a) is a
# False
# >>> np.asanyarray(a) is a
# True
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 17</u></h3></summary><small><a href=#17>goto cell # 17</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.mode</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mode(s) of the Series.
#
# The mode is the value that appears most often. There can be multiple modes.
#
# Always returns Series even if only one value is returned.
#
# Parameters
# ----------
# dropna : bool, default True
#     Don't consider counts of NaN/NaT.
#
# Returns
# -------
# Series
#     Modes of the Series in sorted order.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 29</u></h3></summary><small><a href=#29>goto cell # 29</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 31</u></h3></summary><small><a href=#31>goto cell # 31</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Cast a pandas object to a specified dtype ``dtype``.
#
# Parameters
# ----------
# dtype : data type, or dict of column name -> data type
#     Use a numpy.dtype or Python type to cast entire pandas object to
#     the same type. Alternatively, use {col: dtype, ...}, where col is a
#     column label and dtype is a numpy.dtype or Python type to cast one
#     or more of the DataFrame's columns to column-specific types.
# copy : bool, default True
#     Return a copy when ``copy=True`` (be very careful setting
#     ``copy=False`` as changes to values then may propagate to other
#     pandas objects).
# errors : {'raise', 'ignore'}, default 'raise'
#     Control raising of exceptions on invalid data for provided dtype.
#
#     - ``raise`` : allow exceptions to be raised
#     - ``ignore`` : suppress exceptions. On error return original object.
#
# Returns
# -------
# casted : same type as caller
#
# See Also
# --------
# to_datetime : Convert argument to datetime.
# to_timedelta : Convert argument to timedelta.
# to_numeric : Convert argument to a numeric type.
# numpy.ndarray.astype : Cast a numpy array to a specified type.
#
# Notes
# -----
# .. deprecated:: 1.3.0
#
#     Using ``astype`` to convert from timezone-naive dtype to
#     timezone-aware dtype is deprecated and will raise in a
#     future version.  Use :meth:`Series.dt.tz_localize` instead.
#
# Examples
# --------
# Create a DataFrame:
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# Cast all columns to int32:
#
# >>> df.astype('int32').dtypes
# col1    int32
# col2    int32
# dtype: object
#
# Cast col1 to int32 using a dictionary:
#
# >>> df.astype({'col1': 'int32'}).dtypes
# col1    int32
# col2    int64
# dtype: object
#
# Create a series:
#
# >>> ser = pd.Series([1, 2], dtype='int32')
# >>> ser
# 0    1
# 1    2
# dtype: int32
# >>> ser.astype('int64')
# 0    1
# 1    2
# dtype: int64
#
# Convert to categorical type:
#
# >>> ser.astype('category')
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [1, 2]
#
# Convert to ordered categorical type with custom ordering:
#
# >>> from pandas.api.types import CategoricalDtype
# >>> cat_dtype = CategoricalDtype(
# ...     categories=[2, 1], ordered=True)
# >>> ser.astype(cat_dtype)
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [2 < 1]
#
# Note that using ``copy=False`` and changing data on a new
# pandas object may propagate changes:
#
# >>> s1 = pd.Series([1, 2])
# >>> s2 = s1.astype('int64', copy=False)
# >>> s2[0] = 10
# >>> s1  # note that s1[0] has changed too
# 0    10
# 1     2
# dtype: int64
#
# Create a series of dates:
#
# >>> ser_date = pd.Series(pd.date_range('20200101', periods=3))
# >>> ser_date
# 0   2020-01-01
# 1   2020-01-02
# 2   2020-01-03
# dtype: datetime64[ns]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 32</u></h3></summary><small><a href=#32>goto cell # 32</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 34</u></h3></summary><small><a href=#34>goto cell # 34</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 36</u></h3></summary><small><a href=#36>goto cell # 36</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 40</u></h3></summary><small><a href=#40>goto cell # 40</a></small>
# <ul>
#
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.asarray</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# asarray(a, dtype=None, order=None, *, like=None)
#
# Convert the input to an array.
#
# Parameters
# ----------
# a : array_like
#     Input data, in any form that can be converted to an array.  This
#     includes lists, lists of tuples, tuples, tuples of tuples, tuples
#     of lists and ndarrays.
# dtype : data-type, optional
#     By default, the data-type is inferred from the input data.
# order : {'C', 'F', 'A', 'K'}, optional
#     Memory layout.  'A' and 'K' depend on the order of input array a.
#     'C' row-major (C-style),
#     'F' column-major (Fortran-style) memory representation.
#     'A' (any) means 'F' if `a` is Fortran contiguous, 'C' otherwise
#     'K' (keep) preserve input order
#     Defaults to 'K'.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array interpretation of `a`.  No copy is performed if the input
#     is already an ndarray with matching dtype and order.  If `a` is a
#     subclass of ndarray, a base class ndarray is returned.
#
# See Also
# --------
# asanyarray : Similar function which passes through subclasses.
# ascontiguousarray : Convert input to a contiguous array.
# asfarray : Convert input to a floating point ndarray.
# asfortranarray : Convert input to an ndarray with column-major
#                  memory order.
# asarray_chkfinite : Similar function which checks input for NaNs and Infs.
# fromiter : Create an array from an iterator.
# fromfunction : Construct an array by executing a function on grid
#                positions.
#
# Examples
# --------
# Convert a list into an array:
#
# >>> a = [1, 2]
# >>> np.asarray(a)
# array([1, 2])
#
# Existing arrays are not copied:
#
# >>> a = np.array([1, 2])
# >>> np.asarray(a) is a
# True
#
# If `dtype` is set, array is copied only if dtype does not match:
#
# >>> a = np.array([1, 2], dtype=np.float32)
# >>> np.asarray(a, dtype=np.float32) is a
# True
# >>> np.asarray(a, dtype=np.float64) is a
# False
#
# Contrary to `asanyarray`, ndarray subclasses are not passed through:
#
# >>> issubclass(np.recarray, np.ndarray)
# True
# >>> a = np.array([(1.0, 2), (3.0, 4)], dtype='f4,i4').view(np.recarray)
# >>> np.asarray(a) is a
# False
# >>> np.asanyarray(a) is a
# True
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Data Profiling and Exploratory Data Analysis</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Profiling and Exploratory Data Analysis" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 4</u></h3></summary><small><a href=#4>goto cell # 4</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 5</u></h3></summary><small><a href=#5>goto cell # 5</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 8</u></h3></summary><small><a href=#8>goto cell # 8</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 9</u></h3></summary><small><a href=#9>goto cell # 9</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 10</u></h3></summary><small><a href=#10>goto cell # 10</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 11</u></h3></summary><small><a href=#11>goto cell # 11</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 13</u></h3></summary><small><a href=#13>goto cell # 13</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 14</u></h3></summary><small><a href=#14>goto cell # 14</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 18</u></h3></summary><small><a href=#18>goto cell # 18</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 19</u></h3></summary><small><a href=#19>goto cell # 19</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 21</u></h3></summary><small><a href=#21>goto cell # 21</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 22</u></h3></summary><small><a href=#22>goto cell # 22</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 25</u></h3></summary><small><a href=#25>goto cell # 25</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 26</u></h3></summary><small><a href=#26>goto cell # 26</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 29</u></h3></summary><small><a href=#29>goto cell # 29</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 32</u></h3></summary><small><a href=#32>goto cell # 32</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Cleaning Filtering</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Cleaning Filtering" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Name'] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> ['Name'] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 17</u></h3></summary><small><a href=#17>goto cell # 17</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 20</u></h3></summary><small><a href=#20>goto cell # 20</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Ticket']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Ticket']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Data Sub-sampling and Train-test Splitting</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Data Sub-sampling and Train-test Splitting" Calls</u></b></summary>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'test_size': 0.2, 'random_state': 0}</li></ul>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 28</u></h3></summary><small><a href=#28>goto cell # 28</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'test_size': 0.2, 'random_state': 0}</li></ul>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Feature Engineering</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Feature Transformation</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Transformation" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.mode</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mode(s) of the Series.
#
# The mode is the value that appears most often. There can be multiple modes.
#
# Always returns Series even if only one value is returned.
#
# Parameters
# ----------
# dropna : bool, default True
#     Don't consider counts of NaN/NaT.
#
# Returns
# -------
# Series
#     Modes of the Series in sorted order.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Cast a pandas object to a specified dtype ``dtype``.
#
# Parameters
# ----------
# dtype : data type, or dict of column name -> data type
#     Use a numpy.dtype or Python type to cast entire pandas object to
#     the same type. Alternatively, use {col: dtype, ...}, where col is a
#     column label and dtype is a numpy.dtype or Python type to cast one
#     or more of the DataFrame's columns to column-specific types.
# copy : bool, default True
#     Return a copy when ``copy=True`` (be very careful setting
#     ``copy=False`` as changes to values then may propagate to other
#     pandas objects).
# errors : {'raise', 'ignore'}, default 'raise'
#     Control raising of exceptions on invalid data for provided dtype.
#
#     - ``raise`` : allow exceptions to be raised
#     - ``ignore`` : suppress exceptions. On error return original object.
#
# Returns
# -------
# casted : same type as caller
#
# See Also
# --------
# to_datetime : Convert argument to datetime.
# to_timedelta : Convert argument to timedelta.
# to_numeric : Convert argument to a numeric type.
# numpy.ndarray.astype : Cast a numpy array to a specified type.
#
# Notes
# -----
# .. deprecated:: 1.3.0
#
#     Using ``astype`` to convert from timezone-naive dtype to
#     timezone-aware dtype is deprecated and will raise in a
#     future version.  Use :meth:`Series.dt.tz_localize` instead.
#
# Examples
# --------
# Create a DataFrame:
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# Cast all columns to int32:
#
# >>> df.astype('int32').dtypes
# col1    int32
# col2    int32
# dtype: object
#
# Cast col1 to int32 using a dictionary:
#
# >>> df.astype({'col1': 'int32'}).dtypes
# col1    int32
# col2    int64
# dtype: object
#
# Create a series:
#
# >>> ser = pd.Series([1, 2], dtype='int32')
# >>> ser
# 0    1
# 1    2
# dtype: int32
# >>> ser.astype('int64')
# 0    1
# 1    2
# dtype: int64
#
# Convert to categorical type:
#
# >>> ser.astype('category')
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [1, 2]
#
# Convert to ordered categorical type with custom ordering:
#
# >>> from pandas.api.types import CategoricalDtype
# >>> cat_dtype = CategoricalDtype(
# ...     categories=[2, 1], ordered=True)
# >>> ser.astype(cat_dtype)
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [2 < 1]
#
# Note that using ``copy=False`` and changing data on a new
# pandas object may propagate changes:
#
# >>> s1 = pd.Series([1, 2])
# >>> s2 = s1.astype('int64', copy=False)
# >>> s2[0] = 10
# >>> s1  # note that s1[0] has changed too
# 0    10
# 1     2
# dtype: int64
#
# Create a series of dates:
#
# >>> ser_date = pd.Series(pd.date_range('20200101', periods=3))
# >>> ser_date
# 0   2020-01-01
# 1   2020-01-02
# 2   2020-01-03
# dtype: datetime64[ns]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 6</u></h3></summary><small><a href=#6>goto cell # 6</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 7</u></h3></summary><small><a href=#7>goto cell # 7</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 17</u></h3></summary><small><a href=#17>goto cell # 17</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.mode</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the mode(s) of the Series.
#
# The mode is the value that appears most often. There can be multiple modes.
#
# Always returns Series even if only one value is returned.
#
# Parameters
# ----------
# dropna : bool, default True
#     Don't consider counts of NaN/NaT.
#
# Returns
# -------
# Series
#     Modes of the Series in sorted order.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 29</u></h3></summary><small><a href=#29>goto cell # 29</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 31</u></h3></summary><small><a href=#31>goto cell # 31</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.astype</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Cast a pandas object to a specified dtype ``dtype``.
#
# Parameters
# ----------
# dtype : data type, or dict of column name -> data type
#     Use a numpy.dtype or Python type to cast entire pandas object to
#     the same type. Alternatively, use {col: dtype, ...}, where col is a
#     column label and dtype is a numpy.dtype or Python type to cast one
#     or more of the DataFrame's columns to column-specific types.
# copy : bool, default True
#     Return a copy when ``copy=True`` (be very careful setting
#     ``copy=False`` as changes to values then may propagate to other
#     pandas objects).
# errors : {'raise', 'ignore'}, default 'raise'
#     Control raising of exceptions on invalid data for provided dtype.
#
#     - ``raise`` : allow exceptions to be raised
#     - ``ignore`` : suppress exceptions. On error return original object.
#
# Returns
# -------
# casted : same type as caller
#
# See Also
# --------
# to_datetime : Convert argument to datetime.
# to_timedelta : Convert argument to timedelta.
# to_numeric : Convert argument to a numeric type.
# numpy.ndarray.astype : Cast a numpy array to a specified type.
#
# Notes
# -----
# .. deprecated:: 1.3.0
#
#     Using ``astype`` to convert from timezone-naive dtype to
#     timezone-aware dtype is deprecated and will raise in a
#     future version.  Use :meth:`Series.dt.tz_localize` instead.
#
# Examples
# --------
# Create a DataFrame:
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# Cast all columns to int32:
#
# >>> df.astype('int32').dtypes
# col1    int32
# col2    int32
# dtype: object
#
# Cast col1 to int32 using a dictionary:
#
# >>> df.astype({'col1': 'int32'}).dtypes
# col1    int32
# col2    int64
# dtype: object
#
# Create a series:
#
# >>> ser = pd.Series([1, 2], dtype='int32')
# >>> ser
# 0    1
# 1    2
# dtype: int32
# >>> ser.astype('int64')
# 0    1
# 1    2
# dtype: int64
#
# Convert to categorical type:
#
# >>> ser.astype('category')
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [1, 2]
#
# Convert to ordered categorical type with custom ordering:
#
# >>> from pandas.api.types import CategoricalDtype
# >>> cat_dtype = CategoricalDtype(
# ...     categories=[2, 1], ordered=True)
# >>> ser.astype(cat_dtype)
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [2 < 1]
#
# Note that using ``copy=False`` and changing data on a new
# pandas object may propagate changes:
#
# >>> s1 = pd.Series([1, 2])
# >>> s2 = s1.astype('int64', copy=False)
# >>> s2[0] = 10
# >>> s1  # note that s1[0] has changed too
# 0    10
# 1     2
# dtype: int64
#
# Create a series of dates:
#
# >>> ser_date = pd.Series(pd.date_range('20200101', periods=3))
# >>> ser_date
# 0   2020-01-01
# 1   2020-01-02
# 2   2020-01-03
# dtype: datetime64[ns]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 32</u></h3></summary><small><a href=#32>goto cell # 32</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 34</u></h3></summary><small><a href=#34>goto cell # 34</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 36</u></h3></summary><small><a href=#36>goto cell # 36</a></small>
# <ul>
#
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Feature Selection</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Feature Selection" Calls</u></b></summary>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Ticket']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Ticket']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 12</u></h3></summary><small><a href=#12>goto cell # 12</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> ['Name'] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> ['Name'] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 20</u></h3></summary><small><a href=#20>goto cell # 20</a></small>
# <ul>
#
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Cabin']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Ticket']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <ul><li><b>Args:</b> [['Ticket']] | <b>Kwargs:</b> {'axis': 1, 'inplace': True}</li></ul>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <li><details><summary><h2><span style='color:#42a5f5'>Model Building and Training</span></h2></summary>
# <ul>
#
# None
#
# </ul>
# </details></li>
# <ul><li><details><summary><h2>Model Training</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Training" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'validation_split': 0.35, 'batch_size': 5, 'epochs': 100}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 38</u></h3></summary><small><a href=#38>goto cell # 38</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 20, 'kernel_initializer': 'he_uniform', 'activation': 'relu', 'input_dim': 8}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 10, 'kernel_initializer': 'he_uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 15, 'kernel_initializer': 'he_uniform', 'activation': 'relu'}</li></ul>
# <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'units': 1, 'kernel_initializer': 'glorot_uniform', 'activation': 'sigmoid'}</li></ul>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'optimizer': 'Adamax', 'loss': 'binary_crossentropy', 'metrics': ['accuracy']}</li></ul>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 39</u></h3></summary><small><a href=#39>goto cell # 39</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u> | <b>(See Args)</b> </summary> <ul><li><b>Args:</b> [] | <b>Kwargs:</b> {'validation_split': 0.35, 'batch_size': 5, 'epochs': 100}</li></ul>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h4><s>Model Parameter Tuning</s> (no calls found)</h4></summary>
# <ul>
#
# None
#
# </ul>
# </details></li></ul>
# <ul><li><details><summary><h2>Model Validation and Assembling</h2></summary>
# <ul>
#
# <li><details><summary><b><u>View All "Model Validation and Assembling" Calls</u></b></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
# <li><details open><summary><h3><u>Cell # 40</u></h3></summary><small><a href=#40>goto cell # 40</a></small>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u> | (No Args Found) </summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details></li>
#
# </ul>
# </details></li></ul>
# </ul>
# <hr>
#
# <details><summary><h2>View All ML API Calls in Notebook</h2></summary>
# <ul>
#
# <li> <b>keras</b>
# <ul>
# <li>
# <details><summary><u>keras</u></summary>
# <blockquote>
# <code>
# Implementation of the Keras API, the high-level API of TensorFlow.
#
# Detailed documentation and user guides are available at
# [keras.io](https://keras.io).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.ELU</u></summary>
# <blockquote>
# <code>
# Exponential Linear Unit.
#
# It follows:
#
# ```
#   f(x) =  alpha * (exp(x) - 1.) for x < 0
#   f(x) = x for x >= 0
# ```
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha: Scale for the negative factor.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.LeakyReLU</u></summary>
# <blockquote>
# <code>
# Leaky version of a Rectified Linear Unit.
#
# It allows a small gradient when the unit is not active:
#
# ```
#   f(x) = alpha * x if x < 0
#   f(x) = x if x >= 0
# ```
#
# Usage:
#
# >>> layer = tf.keras.layers.LeakyReLU()
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [-0.9, -0.3, 0.0, 2.0]
# >>> layer = tf.keras.layers.LeakyReLU(alpha=0.1)
# >>> output = layer([-3.0, -1.0, 0.0, 2.0])
# >>> list(output.numpy())
# [-0.3, -0.1, 0.0, 2.0]
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the batch axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha: Float >= 0. Negative slope coefficient. Default to 0.3.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.advanced_activations.PReLU</u></summary>
# <blockquote>
# <code>
# Parametric Rectified Linear Unit.
#
# It follows:
#
# ```
#   f(x) = alpha * x for x < 0
#   f(x) = x for x >= 0
# ```
#
# where `alpha` is a learned array with the same shape as x.
#
# Input shape:
#   Arbitrary. Use the keyword argument `input_shape`
#   (tuple of integers, does not include the samples axis)
#   when using this layer as the first layer in a model.
#
# Output shape:
#   Same shape as the input.
#
# Args:
#   alpha_initializer: Initializer function for the weights.
#   alpha_regularizer: Regularizer for the weights.
#   alpha_constraint: Constraint for the weights.
#   shared_axes: The axes along which to share learnable
#     parameters for the activation function.
#     For example, if the incoming feature maps
#     are from a 2D convolution
#     with output shape `(batch, height, width, channels)`,
#     and you wish to share parameters across space
#     so that each filter only has one set of parameters,
#     set `shared_axes=[1, 2]`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dropout.Dropout</u></summary>
# <blockquote>
# <code>
# Applies Dropout to the input.
#
# The Dropout layer randomly sets input units to 0 with a frequency of `rate`
# at each step during training time, which helps prevent overfitting.
# Inputs not set to 0 are scaled up by 1/(1 - rate) such that the sum over
# all inputs is unchanged.
#
# Note that the Dropout layer only applies when `training` is set to True
# such that no values are dropped during inference. When using `model.fit`,
# `training` will be appropriately set to True automatically, and in other
# contexts, you can set the kwarg explicitly to True when calling the layer.
#
# (This is in contrast to setting `trainable=False` for a Dropout layer.
# `trainable` does not affect the layer's behavior, as Dropout does
# not have any variables/weights that can be frozen during training.)
#
# >>> tf.random.set_seed(0)
# >>> layer = tf.keras.layers.Dropout(.2, input_shape=(2,))
# >>> data = np.arange(10).reshape(5, 2).astype(np.float32)
# >>> print(data)
# [[0. 1.]
#  [2. 3.]
#  [4. 5.]
#  [6. 7.]
#  [8. 9.]]
# >>> outputs = layer(data, training=True)
# >>> print(outputs)
# tf.Tensor(
# [[ 0.    1.25]
#  [ 2.5   3.75]
#  [ 5.    6.25]
#  [ 7.5   8.75]
#  [10.    0.  ]], shape=(5, 2), dtype=float32)
#
# Args:
#   rate: Float between 0 and 1. Fraction of the input units to drop.
#   noise_shape: 1D integer tensor representing the shape of the
#     binary dropout mask that will be multiplied with the input.
#     For instance, if your inputs have shape
#     `(batch_size, timesteps, features)` and
#     you want the dropout mask to be the same for all timesteps,
#     you can use `noise_shape=(batch_size, 1, features)`.
#   seed: A Python integer to use as random seed.
#
# Call arguments:
#   inputs: Input tensor (of any rank).
#   training: Python boolean indicating whether the layer should behave in
#     training mode (adding dropout) or in inference mode (doing nothing).
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>matplotlib</b>
# <ul>
# <li>
# <details><summary><u>matplotlib.pyplot</u></summary>
# <blockquote>
# <code>
# `matplotlib.pyplot` is a state-based interface to matplotlib. It provides
# an implicit,  MATLAB-like, way of plotting.  It also opens figures on your
# screen, and acts as the figure GUI manager.
#
# pyplot is mainly intended for interactive plots and simple cases of
# programmatic plot generation::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     plt.plot(x, y)
#
# The explicit (object-oriented) API is recommended for complex plots, though
# pyplot is still usually used to create the figure and often the axes in the
# figure. See `.pyplot.figure`, `.pyplot.subplots`, and
# `.pyplot.subplot_mosaic` to create figures, and
# :doc:`Axes API <../axes_api>` for the plotting methods on an axes::
#
#     import numpy as np
#     import matplotlib.pyplot as plt
#
#     x = np.arange(0, 5, 0.1)
#     y = np.sin(x)
#     fig, ax = plt.subplots()
#     ax.plot(x, y)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>numpy</b>
# <ul>
# <li>
# <details><summary><u>numpy</u></summary>
# <blockquote>
# <code>
# NumPy
# =====
#
# Provides
#   1. An array object of arbitrary homogeneous items
#   2. Fast mathematical operations over arrays
#   3. Linear Algebra, Fourier Transforms, Random Number Generation
#
# How to use the documentation
# ----------------------------
# Documentation is available in two forms: docstrings provided
# with the code, and a loose standing reference guide, available from
# `the NumPy homepage <https://www.scipy.org>`_.
#
# We recommend exploring the docstrings using
# `IPython <https://ipython.org>`_, an advanced Python shell with
# TAB-completion and introspection capabilities.  See below for further
# instructions.
#
# The docstring examples assume that `numpy` has been imported as `np`::
#
#   >>> import numpy as np
#
# Code snippets are indicated by three greater-than signs::
#
#   >>> x = 42
#   >>> x = x + 1
#
# Use the built-in ``help`` function to view a function's docstring::
#
#   >>> help(np.sort)
#   ... # doctest: +SKIP
#
# For some objects, ``np.info(obj)`` may provide additional help.  This is
# particularly true if you see the line "Help on ufunc object:" at the top
# of the help() page.  Ufuncs are implemented in C, not Python, for speed.
# The native Python help() does not know how to view their help, but our
# np.info() function does.
#
# To search for documents containing a keyword, do::
#
#   >>> np.lookfor('keyword')
#   ... # doctest: +SKIP
#
# General-purpose documents like a glossary and help on the basic concepts
# of numpy are available under the ``doc`` sub-module::
#
#   >>> from numpy import doc
#   >>> help(doc)
#   ... # doctest: +SKIP
#
# Available subpackages
# ---------------------
# doc
#     Topical documentation on broadcasting, indexing, etc.
# lib
#     Basic functions used by several sub-packages.
# random
#     Core Random Tools
# linalg
#     Core Linear Algebra Tools
# fft
#     Core FFT routines
# polynomial
#     Polynomial tools
# testing
#     NumPy testing tools
# f2py
#     Fortran to Python Interface Generator.
# distutils
#     Enhancements to distutils with support for
#     Fortran compilers support and more.
#
# Utilities
# ---------
# test
#     Run numpy unittests
# show_config
#     Show numpy build configuration
# dual
#     Overwrite certain functions with high-performance SciPy tools.
#     Note: `numpy.dual` is deprecated.  Use the functions from NumPy or Scipy
#     directly instead of importing them from `numpy.dual`.
# matlib
#     Make everything matrices.
# __version__
#     NumPy version string
#
# Viewing documentation using IPython
# -----------------------------------
# Start IPython with the NumPy profile (``ipython -p numpy``), which will
# import `numpy` under the alias `np`.  Then, use the ``cpaste`` command to
# paste examples into the shell.  To see which functions are available in
# `numpy`, type ``np.<TAB>`` (where ``<TAB>`` refers to the TAB key), or use
# ``np.*cos*?<ENTER>`` (where ``<ENTER>`` refers to the ENTER key) to narrow
# down the list.  To view the docstring for a function, use
# ``np.cos?<ENTER>`` (to view the docstring) and ``np.cos??<ENTER>`` (to view
# the source code).
#
# Copies vs. in-place operation
# -----------------------------
# Most of the functions in `numpy` return a copy of the array argument
# (e.g., `np.sort`).  In-place versions of these functions are often
# available as array methods, i.e. ``x = np.array([1,2,3]); x.sort()``.
# Exceptions to this rule are documented.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.asarray</u></summary>
# <blockquote>
# <code>
# asarray(a, dtype=None, order=None, *, like=None)
#
# Convert the input to an array.
#
# Parameters
# ----------
# a : array_like
#     Input data, in any form that can be converted to an array.  This
#     includes lists, lists of tuples, tuples, tuples of tuples, tuples
#     of lists and ndarrays.
# dtype : data-type, optional
#     By default, the data-type is inferred from the input data.
# order : {'C', 'F', 'A', 'K'}, optional
#     Memory layout.  'A' and 'K' depend on the order of input array a.
#     'C' row-major (C-style),
#     'F' column-major (Fortran-style) memory representation.
#     'A' (any) means 'F' if `a` is Fortran contiguous, 'C' otherwise
#     'K' (keep) preserve input order
#     Defaults to 'K'.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array interpretation of `a`.  No copy is performed if the input
#     is already an ndarray with matching dtype and order.  If `a` is a
#     subclass of ndarray, a base class ndarray is returned.
#
# See Also
# --------
# asanyarray : Similar function which passes through subclasses.
# ascontiguousarray : Convert input to a contiguous array.
# asfarray : Convert input to a floating point ndarray.
# asfortranarray : Convert input to an ndarray with column-major
#                  memory order.
# asarray_chkfinite : Similar function which checks input for NaNs and Infs.
# fromiter : Create an array from an iterator.
# fromfunction : Construct an array by executing a function on grid
#                positions.
#
# Examples
# --------
# Convert a list into an array:
#
# >>> a = [1, 2]
# >>> np.asarray(a)
# array([1, 2])
#
# Existing arrays are not copied:
#
# >>> a = np.array([1, 2])
# >>> np.asarray(a) is a
# True
#
# If `dtype` is set, array is copied only if dtype does not match:
#
# >>> a = np.array([1, 2], dtype=np.float32)
# >>> np.asarray(a, dtype=np.float32) is a
# True
# >>> np.asarray(a, dtype=np.float64) is a
# False
#
# Contrary to `asanyarray`, ndarray subclasses are not passed through:
#
# >>> issubclass(np.recarray, np.ndarray)
# True
# >>> a = np.array([(1.0, 2), (3.0, 4)], dtype='f4,i4').view(np.recarray)
# >>> np.asarray(a) is a
# False
# >>> np.asanyarray(a) is a
# True
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray</u></summary>
# <blockquote>
# <code>
# ndarray(shape, dtype=float, buffer=None, offset=0,
#         strides=None, order=None)
#
# An array object represents a multidimensional, homogeneous array
# of fixed-size items.  An associated data-type object describes the
# format of each element in the array (its byte-order, how many bytes it
# occupies in memory, whether it is an integer, a floating point number,
# or something else, etc.)
#
# Arrays should be constructed using `array`, `zeros` or `empty` (refer
# to the See Also section below).  The parameters given here refer to
# a low-level method (`ndarray(...)`) for instantiating an array.
#
# For more information, refer to the `numpy` module and examine the
# methods and attributes of an array.
#
# Parameters
# ----------
# (for the __new__ method; see Notes below)
#
# shape : tuple of ints
#     Shape of created array.
# dtype : data-type, optional
#     Any object that can be interpreted as a numpy data type.
# buffer : object exposing buffer interface, optional
#     Used to fill the array with data.
# offset : int, optional
#     Offset of array data in buffer.
# strides : tuple of ints, optional
#     Strides of data in memory.
# order : {'C', 'F'}, optional
#     Row-major (C-style) or column-major (Fortran-style) order.
#
# Attributes
# ----------
# T : ndarray
#     Transpose of the array.
# data : buffer
#     The array's elements, in memory.
# dtype : dtype object
#     Describes the format of the elements in the array.
# flags : dict
#     Dictionary containing information related to memory use, e.g.,
#     'C_CONTIGUOUS', 'OWNDATA', 'WRITEABLE', etc.
# flat : numpy.flatiter object
#     Flattened version of the array as an iterator.  The iterator
#     allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for
#     assignment examples; TODO).
# imag : ndarray
#     Imaginary part of the array.
# real : ndarray
#     Real part of the array.
# size : int
#     Number of elements in the array.
# itemsize : int
#     The memory use of each array element in bytes.
# nbytes : int
#     The total number of bytes required to store the array data,
#     i.e., ``itemsize * size``.
# ndim : int
#     The array's number of dimensions.
# shape : tuple of ints
#     Shape of the array.
# strides : tuple of ints
#     The step-size required to move from one element to the next in
#     memory. For example, a contiguous ``(3, 4)`` array of type
#     ``int16`` in C-order has strides ``(8, 2)``.  This implies that
#     to move from element to element in memory requires jumps of 2 bytes.
#     To move from row-to-row, one needs to jump 8 bytes at a time
#     (``2 * 4``).
# ctypes : ctypes object
#     Class containing properties of the array needed for interaction
#     with ctypes.
# base : ndarray
#     If the array is a view into another array, that array is its `base`
#     (unless that array is also a view).  The `base` array is where the
#     array data is actually stored.
#
# See Also
# --------
# array : Construct an array.
# zeros : Create an array, each element of which is zero.
# empty : Create an array, but leave its allocated memory unchanged (i.e.,
#         it contains "garbage").
# dtype : Create a data-type.
# numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`
#                        w.r.t. its `dtype.type <numpy.dtype.type>`.
#
# Notes
# -----
# There are two modes of creating an array using ``__new__``:
#
# 1. If `buffer` is None, then only `shape`, `dtype`, and `order`
#    are used.
# 2. If `buffer` is an object exposing the buffer interface, then
#    all keywords are interpreted.
#
# No ``__init__`` method is needed because the array is fully initialized
# after the ``__new__`` method.
#
# Examples
# --------
# These examples illustrate the low-level `ndarray` constructor.  Refer
# to the `See Also` section above for easier ways of constructing an
# ndarray.
#
# First mode, `buffer` is None:
#
# >>> np.ndarray(shape=(2,2), dtype=float, order='F')
# array([[0.0e+000, 0.0e+000], # random
#        [     nan, 2.5e-323]])
#
# Second mode:
#
# >>> np.ndarray((2,), buffer=np.array([1,2,3]),
# ...            offset=np.int_().itemsize,
# ...            dtype=int) # offset = 1*itemsize, i.e. skip first element
# array([2, 3])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>os</b>
# <ul>
# <li>
# <details><summary><u>os.walk</u></summary>
# <blockquote>
# <code>
# Directory tree generator.
#
# For each directory in the directory tree rooted at top (including top
# itself, but excluding '.' and '..'), yields a 3-tuple
#
#     dirpath, dirnames, filenames
#
# dirpath is a string, the path to the directory.  dirnames is a list of
# the names of the subdirectories in dirpath (excluding '.' and '..').
# filenames is a list of the names of the non-directory files in dirpath.
# Note that the names in the lists are just names, with no path components.
# To get a full path (which begins with top) to a file or directory in
# dirpath, do os.path.join(dirpath, name).
#
# If optional arg 'topdown' is true or not specified, the triple for a
# directory is generated before the triples for any of its subdirectories
# (directories are generated top down).  If topdown is false, the triple
# for a directory is generated after the triples for all of its
# subdirectories (directories are generated bottom up).
#
# When topdown is true, the caller can modify the dirnames list in-place
# (e.g., via del or slice assignment), and walk will only recurse into the
# subdirectories whose names remain in dirnames; this can be used to prune the
# search, or to impose a specific order of visiting.  Modifying dirnames when
# topdown is false has no effect on the behavior of os.walk(), since the
# directories in dirnames have already been generated by the time dirnames
# itself is generated. No matter the value of topdown, the list of
# subdirectories is retrieved before the tuples for the directory and its
# subdirectories are generated.
#
# By default errors from the os.scandir() call are ignored.  If
# optional arg 'onerror' is specified, it should be a function; it
# will be called with one argument, an OSError instance.  It can
# report the error to continue with the walk, or raise the exception
# to abort the walk.  Note that the filename is available as the
# filename attribute of the exception object.
#
# By default, os.walk does not follow symbolic links to subdirectories on
# systems that support them.  In order to get this functionality, set the
# optional argument 'followlinks' to true.
#
# Caution:  if you pass a relative pathname for top, don't change the
# current working directory between resumptions of walk.  walk never
# changes the current directory, and assumes that the client doesn't
# either.
#
# Example:
#
# import os
# from os.path import join, getsize
# for root, dirs, files in os.walk('python/Lib/email'):
#     print(root, "consumes", end="")
#     print(sum(getsize(join(root, name)) for name in files), end="")
#     print("bytes in", len(files), "non-directory files")
#     if 'CVS' in dirs:
#         dirs.remove('CVS')  # don't visit CVS directories
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>pandas</b>
# <ul>
# <li>
# <details><summary><u>pandas</u></summary>
# <blockquote>
# <code>
# pandas - a powerful data analysis and manipulation library for Python
# =====================================================================
#
# **pandas** is a Python package providing fast, flexible, and expressive data
# structures designed to make working with "relational" or "labeled" data both
# easy and intuitive. It aims to be the fundamental high-level building block for
# doing practical, **real world** data analysis in Python. Additionally, it has
# the broader goal of becoming **the most powerful and flexible open source data
# analysis / manipulation tool available in any language**. It is already well on
# its way toward this goal.
#
# Main Features
# -------------
# Here are just a few of the things that pandas does well:
#
#   - Easy handling of missing data in floating point as well as non-floating
#     point data.
#   - Size mutability: columns can be inserted and deleted from DataFrame and
#     higher dimensional objects
#   - Automatic and explicit data alignment: objects can be explicitly aligned
#     to a set of labels, or the user can simply ignore the labels and let
#     `Series`, `DataFrame`, etc. automatically align the data for you in
#     computations.
#   - Powerful, flexible group by functionality to perform split-apply-combine
#     operations on data sets, for both aggregating and transforming data.
#   - Make it easy to convert ragged, differently-indexed data in other Python
#     and NumPy data structures into DataFrame objects.
#   - Intelligent label-based slicing, fancy indexing, and subsetting of large
#     data sets.
#   - Intuitive merging and joining data sets.
#   - Flexible reshaping and pivoting of data sets.
#   - Hierarchical labeling of axes (possible to have multiple labels per tick).
#   - Robust IO tools for loading data from flat files (CSV and delimited),
#     Excel files, databases, and saving/loading data from the ultrafast HDF5
#     format.
#   - Time series-specific functionality: date range generation and frequency
#     conversion, moving window statistics, date shifting and lagging.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u></summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.astype</u></summary>
# <blockquote>
# <code>
# Cast a pandas object to a specified dtype ``dtype``.
#
# Parameters
# ----------
# dtype : data type, or dict of column name -> data type
#     Use a numpy.dtype or Python type to cast entire pandas object to
#     the same type. Alternatively, use {col: dtype, ...}, where col is a
#     column label and dtype is a numpy.dtype or Python type to cast one
#     or more of the DataFrame's columns to column-specific types.
# copy : bool, default True
#     Return a copy when ``copy=True`` (be very careful setting
#     ``copy=False`` as changes to values then may propagate to other
#     pandas objects).
# errors : {'raise', 'ignore'}, default 'raise'
#     Control raising of exceptions on invalid data for provided dtype.
#
#     - ``raise`` : allow exceptions to be raised
#     - ``ignore`` : suppress exceptions. On error return original object.
#
# Returns
# -------
# casted : same type as caller
#
# See Also
# --------
# to_datetime : Convert argument to datetime.
# to_timedelta : Convert argument to timedelta.
# to_numeric : Convert argument to a numeric type.
# numpy.ndarray.astype : Cast a numpy array to a specified type.
#
# Notes
# -----
# .. deprecated:: 1.3.0
#
#     Using ``astype`` to convert from timezone-naive dtype to
#     timezone-aware dtype is deprecated and will raise in a
#     future version.  Use :meth:`Series.dt.tz_localize` instead.
#
# Examples
# --------
# Create a DataFrame:
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# Cast all columns to int32:
#
# >>> df.astype('int32').dtypes
# col1    int32
# col2    int32
# dtype: object
#
# Cast col1 to int32 using a dictionary:
#
# >>> df.astype({'col1': 'int32'}).dtypes
# col1    int32
# col2    int64
# dtype: object
#
# Create a series:
#
# >>> ser = pd.Series([1, 2], dtype='int32')
# >>> ser
# 0    1
# 1    2
# dtype: int32
# >>> ser.astype('int64')
# 0    1
# 1    2
# dtype: int64
#
# Convert to categorical type:
#
# >>> ser.astype('category')
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [1, 2]
#
# Convert to ordered categorical type with custom ordering:
#
# >>> from pandas.api.types import CategoricalDtype
# >>> cat_dtype = CategoricalDtype(
# ...     categories=[2, 1], ordered=True)
# >>> ser.astype(cat_dtype)
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [2 < 1]
#
# Note that using ``copy=False`` and changing data on a new
# pandas object may propagate changes:
#
# >>> s1 = pd.Series([1, 2])
# >>> s2 = s1.astype('int64', copy=False)
# >>> s2[0] = 10
# >>> s1  # note that s1[0] has changed too
# 0    10
# 1     2
# dtype: int64
#
# Create a series of dates:
#
# >>> ser_date = pd.Series(pd.date_range('20200101', periods=3))
# >>> ser_date
# 0   2020-01-01
# 1   2020-01-02
# 2   2020-01-03
# dtype: datetime64[ns]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series</u></summary>
# <blockquote>
# <code>
# One-dimensional ndarray with axis labels (including time series).
#
# Labels need not be unique but must be a hashable type. The object
# supports both integer- and label-based indexing and provides a host of
# methods for performing operations involving the index. Statistical
# methods from ndarray have been overridden to automatically exclude
# missing data (currently represented as NaN).
#
# Operations between Series (+, -, /, \*, \*\*) align values based on their
# associated index values-- they need not be the same length. The result
# index will be the sorted union of the two indexes.
#
# Parameters
# ----------
# data : array-like, Iterable, dict, or scalar value
#     Contains data stored in Series. If data is a dict, argument order is
#     maintained.
# index : array-like or Index (1d)
#     Values must be hashable and have the same length as `data`.
#     Non-unique index values are allowed. Will default to
#     RangeIndex (0, 1, 2, ..., n) if not provided. If data is dict-like
#     and index is None, then the keys in the data are used as the index. If the
#     index is not None, the resulting Series is reindexed with the index values.
# dtype : str, numpy.dtype, or ExtensionDtype, optional
#     Data type for the output Series. If not specified, this will be
#     inferred from `data`.
#     See the :ref:`user guide <basics.dtypes>` for more usages.
# name : str, optional
#     The name to give to the Series.
# copy : bool, default False
#     Copy input data. Only affects Series or 1d ndarray input. See examples.
#
# Examples
# --------
# Constructing Series from a dictionary with an Index specified
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['a', 'b', 'c'])
# >>> ser
# a   1
# b   2
# c   3
# dtype: int64
#
# The keys of the dictionary match with the Index values, hence the Index
# values have no effect.
#
# >>> d = {'a': 1, 'b': 2, 'c': 3}
# >>> ser = pd.Series(data=d, index=['x', 'y', 'z'])
# >>> ser
# x   NaN
# y   NaN
# z   NaN
# dtype: float64
#
# Note that the Index is first build with the keys from the dictionary.
# After this the Series is reindexed with the given Index values, hence we
# get all NaN as a result.
#
# Constructing Series from a list with `copy=False`.
#
# >>> r = [1, 2]
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# [1, 2]
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `copy` of
# the original data even though `copy=False`, so
# the data is unchanged.
#
# Constructing Series from a 1d ndarray with `copy=False`.
#
# >>> r = np.array([1, 2])
# >>> ser = pd.Series(r, copy=False)
# >>> ser.iloc[0] = 999
# >>> r
# array([999,   2])
# >>> ser
# 0    999
# 1      2
# dtype: int64
#
# Due to input data type the Series has a `view` on
# the original data, so
# the data is changed as well.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.mode</u></summary>
# <blockquote>
# <code>
# Return the mode(s) of the Series.
#
# The mode is the value that appears most often. There can be multiple modes.
#
# Always returns Series even if only one value is returned.
#
# Parameters
# ----------
# dropna : bool, default True
#     Don't consider counts of NaN/NaT.
#
# Returns
# -------
# Series
#     Modes of the Series in sorted order.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u></summary>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>seaborn</b>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u></summary>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <b>sklearn</b>
# <ul>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u></summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#top_phases'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>1. Library Loading</h1>  <a id='1'></a><small><a href='#top_phases'>back to top</a></small>

# %% _uuid="8f2839f25d086af736a60e9eeb907d3b93b6e0e5" _cell_guid="b1076dfc-b9ad-4769-8c92-a6c4dae69d19"
# This Python 3 environment comes with many helpful analytics libraries installed
# It is defined by the kaggle/python Docker image: https://github.com/kaggle/docker-python
# For example, here's several helpful packages to load

import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)

# Input data files are available in the read-only "../input/" directory
# For example, running this (by clicking run or pressing Shift+Enter) will list all files under the input directory

import os
for dirname, _, filenames in os.walk('/kaggle/input'):
    for filename in filenames:
        print(os.path.join(dirname, filename))

# You can write up to 20GB to the current directory (/kaggle/working/) that gets preserved as output when you create a version using "Save & Run All" 
# You can also write temporary files to /kaggle/temp/, but they won't be saved outside of the current session


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>2. Library Loading</h1>  <a id='2'></a><small><a href='#top_phases'>back to top</a></small>

# %%
import matplotlib.pyplot as plt 
# %matplotlib inline 
import seaborn as sns


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>3. Data Preparation</h1>  <a id='3'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.io.parsers.readers.read_csv</u></summary>
# <blockquote>
# <code>
# Read a comma-separated values (csv) file into DataFrame.
#
# Also supports optionally iterating or breaking of the file
# into chunks.
#
# Additional help can be found in the online docs for
# `IO Tools <https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html>`_.
#
# Parameters
# ----------
# filepath_or_buffer : str, path object or file-like object
#     Any valid string path is acceptable. The string could be a URL. Valid
#     URL schemes include http, ftp, s3, gs, and file. For file URLs, a host is
#     expected. A local file could be: file://localhost/path/to/table.csv.
#
#     If you want to pass in a path object, pandas accepts any ``os.PathLike``.
#
#     By file-like object, we refer to objects with a ``read()`` method, such as
#     a file handle (e.g. via builtin ``open`` function) or ``StringIO``.
# sep : str, default ','
#     Delimiter to use. If sep is None, the C engine cannot automatically detect
#     the separator, but the Python parsing engine can, meaning the latter will
#     be used and automatically detect the separator by Python's builtin sniffer
#     tool, ``csv.Sniffer``. In addition, separators longer than 1 character and
#     different from ``'\s+'`` will be interpreted as regular expressions and
#     will also force the use of the Python parsing engine. Note that regex
#     delimiters are prone to ignoring quoted data. Regex example: ``'\r\t'``.
# delimiter : str, default ``None``
#     Alias for sep.
# header : int, list of int, None, default 'infer'
#     Row number(s) to use as the column names, and the start of the
#     data.  Default behavior is to infer the column names: if no names
#     are passed the behavior is identical to ``header=0`` and column
#     names are inferred from the first line of the file, if column
#     names are passed explicitly then the behavior is identical to
#     ``header=None``. Explicitly pass ``header=0`` to be able to
#     replace existing names. The header can be a list of integers that
#     specify row locations for a multi-index on the columns
#     e.g. [0,1,3]. Intervening rows that are not specified will be
#     skipped (e.g. 2 in this example is skipped). Note that this
#     parameter ignores commented lines and empty lines if
#     ``skip_blank_lines=True``, so ``header=0`` denotes the first line of
#     data rather than the first line of the file.
# names : array-like, optional
#     List of column names to use. If the file contains a header row,
#     then you should explicitly pass ``header=0`` to override the column names.
#     Duplicates in this list are not allowed.
# index_col : int, str, sequence of int / str, or False, optional, default ``None``
#   Column(s) to use as the row labels of the ``DataFrame``, either given as
#   string name or column index. If a sequence of int / str is given, a
#   MultiIndex is used.
#
#   Note: ``index_col=False`` can be used to force pandas to *not* use the first
#   column as the index, e.g. when you have a malformed file with delimiters at
#   the end of each line.
# usecols : list-like or callable, optional
#     Return a subset of the columns. If list-like, all elements must either
#     be positional (i.e. integer indices into the document columns) or strings
#     that correspond to column names provided either by the user in `names` or
#     inferred from the document header row(s). If ``names`` are given, the document
#     header row(s) are not taken into account. For example, a valid list-like
#     `usecols` parameter would be ``[0, 1, 2]`` or ``['foo', 'bar', 'baz']``.
#     Element order is ignored, so ``usecols=[0, 1]`` is the same as ``[1, 0]``.
#     To instantiate a DataFrame from ``data`` with element order preserved use
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['foo', 'bar']]`` for columns
#     in ``['foo', 'bar']`` order or
#     ``pd.read_csv(data, usecols=['foo', 'bar'])[['bar', 'foo']]``
#     for ``['bar', 'foo']`` order.
#
#     If callable, the callable function will be evaluated against the column
#     names, returning names where the callable function evaluates to True. An
#     example of a valid callable argument would be ``lambda x: x.upper() in
#     ['AAA', 'BBB', 'DDD']``. Using this parameter results in much faster
#     parsing time and lower memory usage.
# squeeze : bool, default False
#     If the parsed data only contains one column then return a Series.
#
#     .. deprecated:: 1.4.0
#         Append ``.squeeze("columns")`` to the call to ``read_csv`` to squeeze
#         the data.
# prefix : str, optional
#     Prefix to add to column numbers when no header, e.g. 'X' for X0, X1, ...
#
#     .. deprecated:: 1.4.0
#        Use a list comprehension on the DataFrame's columns after calling ``read_csv``.
# mangle_dupe_cols : bool, default True
#     Duplicate columns will be specified as 'X', 'X.1', ...'X.N', rather than
#     'X'...'X'. Passing in False will cause data to be overwritten if there
#     are duplicate names in the columns.
# dtype : Type name or dict of column -> type, optional
#     Data type for data or columns. E.g. {'a': np.float64, 'b': np.int32,
#     'c': 'Int64'}
#     Use `str` or `object` together with suitable `na_values` settings
#     to preserve and not interpret dtype.
#     If converters are specified, they will be applied INSTEAD
#     of dtype conversion.
# engine : {'c', 'python', 'pyarrow'}, optional
#     Parser engine to use. The C and pyarrow engines are faster, while the python engine
#     is currently more feature-complete. Multithreading is currently only supported by
#     the pyarrow engine.
#
#     .. versionadded:: 1.4.0
#
#         The "pyarrow" engine was added as an *experimental* engine, and some features
#         are unsupported, or may not work correctly, with this engine.
# converters : dict, optional
#     Dict of functions for converting values in certain columns. Keys can either
#     be integers or column labels.
# true_values : list, optional
#     Values to consider as True.
# false_values : list, optional
#     Values to consider as False.
# skipinitialspace : bool, default False
#     Skip spaces after delimiter.
# skiprows : list-like, int or callable, optional
#     Line numbers to skip (0-indexed) or number of lines to skip (int)
#     at the start of the file.
#
#     If callable, the callable function will be evaluated against the row
#     indices, returning True if the row should be skipped and False otherwise.
#     An example of a valid callable argument would be ``lambda x: x in [0, 2]``.
# skipfooter : int, default 0
#     Number of lines at bottom of file to skip (Unsupported with engine='c').
# nrows : int, optional
#     Number of rows of file to read. Useful for reading pieces of large files.
# na_values : scalar, str, list-like, or dict, optional
#     Additional strings to recognize as NA/NaN. If dict passed, specific
#     per-column NA values.  By default the following values are interpreted as
#     NaN: '', '#N/A', '#N/A N/A', '#NA', '-1.#IND', '-1.#QNAN', '-NaN', '-nan',
#     '1.#IND', '1.#QNAN', '<NA>', 'N/A', 'NA', 'NULL', 'NaN', 'n/a',
#     'nan', 'null'.
# keep_default_na : bool, default True
#     Whether or not to include the default NaN values when parsing the data.
#     Depending on whether `na_values` is passed in, the behavior is as follows:
#
#     * If `keep_default_na` is True, and `na_values` are specified, `na_values`
#       is appended to the default NaN values used for parsing.
#     * If `keep_default_na` is True, and `na_values` are not specified, only
#       the default NaN values are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are specified, only
#       the NaN values specified `na_values` are used for parsing.
#     * If `keep_default_na` is False, and `na_values` are not specified, no
#       strings will be parsed as NaN.
#
#     Note that if `na_filter` is passed in as False, the `keep_default_na` and
#     `na_values` parameters will be ignored.
# na_filter : bool, default True
#     Detect missing value markers (empty strings and the value of na_values). In
#     data without any NAs, passing na_filter=False can improve the performance
#     of reading a large file.
# verbose : bool, default False
#     Indicate number of NA values placed in non-numeric columns.
# skip_blank_lines : bool, default True
#     If True, skip over blank lines rather than interpreting as NaN values.
# parse_dates : bool or list of int or names or list of lists or dict, default False
#     The behavior is as follows:
#
#     * boolean. If True -> try parsing the index.
#     * list of int or names. e.g. If [1, 2, 3] -> try parsing columns 1, 2, 3
#       each as a separate date column.
#     * list of lists. e.g.  If [[1, 3]] -> combine columns 1 and 3 and parse as
#       a single date column.
#     * dict, e.g. {'foo' : [1, 3]} -> parse columns 1, 3 as date and call
#       result 'foo'
#
#     If a column or index cannot be represented as an array of datetimes,
#     say because of an unparsable value or a mixture of timezones, the column
#     or index will be returned unaltered as an object data type. For
#     non-standard datetime parsing, use ``pd.to_datetime`` after
#     ``pd.read_csv``. To parse an index or column with a mixture of timezones,
#     specify ``date_parser`` to be a partially-applied
#     :func:`pandas.to_datetime` with ``utc=True``. See
#     :ref:`io.csv.mixed_timezones` for more.
#
#     Note: A fast-path exists for iso8601-formatted dates.
# infer_datetime_format : bool, default False
#     If True and `parse_dates` is enabled, pandas will attempt to infer the
#     format of the datetime strings in the columns, and if it can be inferred,
#     switch to a faster method of parsing them. In some cases this can increase
#     the parsing speed by 5-10x.
# keep_date_col : bool, default False
#     If True and `parse_dates` specifies combining multiple columns then
#     keep the original columns.
# date_parser : function, optional
#     Function to use for converting a sequence of string columns to an array of
#     datetime instances. The default uses ``dateutil.parser.parser`` to do the
#     conversion. Pandas will try to call `date_parser` in three different ways,
#     advancing to the next if an exception occurs: 1) Pass one or more arrays
#     (as defined by `parse_dates`) as arguments; 2) concatenate (row-wise) the
#     string values from the columns defined by `parse_dates` into a single array
#     and pass that; and 3) call `date_parser` once for each row using one or
#     more strings (corresponding to the columns defined by `parse_dates`) as
#     arguments.
# dayfirst : bool, default False
#     DD/MM format dates, international and European format.
# cache_dates : bool, default True
#     If True, use a cache of unique, converted dates to apply the datetime
#     conversion. May produce significant speed-up when parsing duplicate
#     date strings, especially ones with timezone offsets.
#
#     .. versionadded:: 0.25.0
# iterator : bool, default False
#     Return TextFileReader object for iteration or getting chunks with
#     ``get_chunk()``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# chunksize : int, optional
#     Return TextFileReader object for iteration.
#     See the `IO Tools docs
#     <https://pandas.pydata.org/pandas-docs/stable/io.html#io-chunking>`_
#     for more information on ``iterator`` and ``chunksize``.
#
#     .. versionchanged:: 1.2
#
#        ``TextFileReader`` is a context manager.
# compression : str or dict, default 'infer'
#     For on-the-fly decompression of on-disk data. If 'infer' and '%s' is
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). If using
#     'zip', the ZIP file must contain only one data file to be read in. Set to
#     ``None`` for no decompression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for Zstandard decompression using a
#     custom compression dictionary:
#     ``compression={'method': 'zstd', 'dict_data': my_compression_dict}``.
#
#     .. versionchanged:: 1.4.0 Zstandard support.
#
# thousands : str, optional
#     Thousands separator.
# decimal : str, default '.'
#     Character to recognize as decimal point (e.g. use ',' for European data).
# lineterminator : str (length 1), optional
#     Character to break file into lines. Only valid with C parser.
# quotechar : str (length 1), optional
#     The character used to denote the start and end of a quoted item. Quoted
#     items can include the delimiter and it will be ignored.
# quoting : int or csv.QUOTE_* instance, default 0
#     Control field quoting behavior per ``csv.QUOTE_*`` constants. Use one of
#     QUOTE_MINIMAL (0), QUOTE_ALL (1), QUOTE_NONNUMERIC (2) or QUOTE_NONE (3).
# doublequote : bool, default ``True``
#    When quotechar is specified and quoting is not ``QUOTE_NONE``, indicate
#    whether or not to interpret two consecutive quotechar elements INSIDE a
#    field as a single ``quotechar`` element.
# escapechar : str (length 1), optional
#     One-character string used to escape other characters.
# comment : str, optional
#     Indicates remainder of line should not be parsed. If found at the beginning
#     of a line, the line will be ignored altogether. This parameter must be a
#     single character. Like empty lines (as long as ``skip_blank_lines=True``),
#     fully commented lines are ignored by the parameter `header` but not by
#     `skiprows`. For example, if ``comment='#'``, parsing
#     ``#empty\na,b,c\n1,2,3`` with ``header=0`` will result in 'a,b,c' being
#     treated as the header.
# encoding : str, optional
#     Encoding to use for UTF when reading/writing (ex. 'utf-8'). `List of Python
#     standard encodings
#     <https://docs.python.org/3/library/codecs.html#standard-encodings>`_ .
#
#     .. versionchanged:: 1.2
#
#        When ``encoding`` is ``None``, ``errors="replace"`` is passed to
#        ``open()``. Otherwise, ``errors="strict"`` is passed to ``open()``.
#        This behavior was previously only the case for ``engine="python"``.
#
#     .. versionchanged:: 1.3.0
#
#        ``encoding_errors`` is a new argument. ``encoding`` has no longer an
#        influence on how encoding errors are handled.
#
# encoding_errors : str, optional, default "strict"
#     How encoding errors are treated. `List of possible values
#     <https://docs.python.org/3/library/codecs.html#error-handlers>`_ .
#
#     .. versionadded:: 1.3.0
#
# dialect : str or csv.Dialect, optional
#     If provided, this parameter will override values (default or not) for the
#     following parameters: `delimiter`, `doublequote`, `escapechar`,
#     `skipinitialspace`, `quotechar`, and `quoting`. If it is necessary to
#     override values, a ParserWarning will be issued. See csv.Dialect
#     documentation for more details.
# error_bad_lines : bool, optional, default ``None``
#     Lines with too many fields (e.g. a csv line with too many commas) will by
#     default cause an exception to be raised, and no DataFrame will be returned.
#     If False, then these "bad lines" will be dropped from the DataFrame that is
#     returned.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# warn_bad_lines : bool, optional, default ``None``
#     If error_bad_lines is False, and warn_bad_lines is True, a warning for each
#     "bad line" will be output.
#
#     .. deprecated:: 1.3.0
#        The ``on_bad_lines`` parameter should be used instead to specify behavior upon
#        encountering a bad line instead.
# on_bad_lines : {'error', 'warn', 'skip'} or callable, default 'error'
#     Specifies what to do upon encountering a bad line (a line with too many fields).
#     Allowed values are :
#
#         - 'error', raise an Exception when a bad line is encountered.
#         - 'warn', raise a warning when a bad line is encountered and skip that line.
#         - 'skip', skip bad lines without raising or warning when they are encountered.
#
#     .. versionadded:: 1.3.0
#
#         - callable, function with signature
#           ``(bad_line: list[str]) -> list[str] | None`` that will process a single
#           bad line. ``bad_line`` is a list of strings split by the ``sep``.
#           If the function returns ``None``, the bad line will be ignored.
#           If the function returns a new list of strings with more elements than
#           expected, a ``ParserWarning`` will be emitted while dropping extra elements.
#           Only supported when ``engine="python"``
#
#     .. versionadded:: 1.4.0
#
# delim_whitespace : bool, default False
#     Specifies whether or not whitespace (e.g. ``' '`` or ``'    '``) will be
#     used as the sep. Equivalent to setting ``sep='\s+'``. If this option
#     is set to True, nothing should be passed in for the ``delimiter``
#     parameter.
# low_memory : bool, default True
#     Internally process the file in chunks, resulting in lower memory use
#     while parsing, but possibly mixed type inference.  To ensure no mixed
#     types either set False, or specify the type with the `dtype` parameter.
#     Note that the entire file is read into a single DataFrame regardless,
#     use the `chunksize` or `iterator` parameter to return the data in chunks.
#     (Only valid with C parser).
# memory_map : bool, default False
#     If a filepath is provided for `filepath_or_buffer`, map the file object
#     directly onto memory and access the data directly from there. Using this
#     option can improve performance because there is no longer any I/O overhead.
# float_precision : str, optional
#     Specifies which converter the C engine should use for floating-point
#     values. The options are ``None`` or 'high' for the ordinary converter,
#     'legacy' for the original lower precision pandas converter, and
#     'round_trip' for the round-trip converter.
#
#     .. versionchanged:: 1.2
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2
#
# Returns
# -------
# DataFrame or TextParser
#     A comma-separated values (csv) file is returned as two-dimensional
#     data structure with labeled axes.
#
# See Also
# --------
# DataFrame.to_csv : Write DataFrame to a comma-separated values (csv) file.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_fwf : Read a table of fixed-width formatted lines into DataFrame.
#
# Examples
# --------
# >>> pd.read_csv('data.csv')  # doctest: +SKIP
#
# </code>
# <a href='#3'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train=pd.read_csv('/kaggle/input/titanic/train.csv')
df_Test=pd.read_csv('/kaggle/input/titanic/test.csv')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>4. Data Preparation</h1>  <a id='4'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#4'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>5. Data Preparation</h1>  <a id='5'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#5'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>6. Data Preparation | Feature Engineering</h1>  <a id='6'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u></summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#6'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.isnull().sum()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>7. Data Preparation | Feature Engineering</h1>  <a id='7'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u></summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#7'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test.isnull().sum()



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>8. Data Preparation | Visualization</h1>  <a id='8'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u></summary>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#8'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
def bar_chart(feature):
    survived = df_Train[df_Train['Survived']==1][feature].value_counts()
    dead = df_Train[df_Train['Survived']==0][feature].value_counts()
    df = pd.DataFrame([survived,dead])
    df.index = ['Survived','Dead']
    df.plot(kind='bar',stacked=True, figsize=(10,5))



# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>9. Data Preparation | Visualization</h1>  <a id='9'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u></summary>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#9'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
bar_chart('Sex')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>10. Data Preparation | Visualization</h1>  <a id='10'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u></summary>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#10'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
bar_chart('Pclass')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>11. Data Preparation | Visualization</h1>  <a id='11'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.plotting._core.PlotAccessor</u></summary>
# <blockquote>
# <code>
# Make plots of Series or DataFrame.
#
# Uses the backend specified by the
# option ``plotting.backend``. By default, matplotlib is used.
#
# Parameters
# ----------
# data : Series or DataFrame
#     The object for which the method is called.
# x : label or position, default None
#     Only used if data is a DataFrame.
# y : label, position or list of label, positions, default None
#     Allows plotting of one column versus another. Only used if data is a
#     DataFrame.
# kind : str
#     The kind of plot to produce:
#
#     - 'line' : line plot (default)
#     - 'bar' : vertical bar plot
#     - 'barh' : horizontal bar plot
#     - 'hist' : histogram
#     - 'box' : boxplot
#     - 'kde' : Kernel Density Estimation plot
#     - 'density' : same as 'kde'
#     - 'area' : area plot
#     - 'pie' : pie plot
#     - 'scatter' : scatter plot (DataFrame only)
#     - 'hexbin' : hexbin plot (DataFrame only)
# ax : matplotlib axes object, default None
#     An axes of the current figure.
# subplots : bool, default False
#     Make separate subplots for each column.
# sharex : bool, default True if ax is None else False
#     In case ``subplots=True``, share x axis and set some x axis labels
#     to invisible; defaults to True if ax is None otherwise False if
#     an ax is passed in; Be aware, that passing in both an ax and
#     ``sharex=True`` will alter all x axis labels for all axis in a figure.
# sharey : bool, default False
#     In case ``subplots=True``, share y axis and set some y axis labels to invisible.
# layout : tuple, optional
#     (rows, columns) for the layout of subplots.
# figsize : a tuple (width, height) in inches
#     Size of a figure object.
# use_index : bool, default True
#     Use index as ticks for x axis.
# title : str or list
#     Title to use for the plot. If a string is passed, print the string
#     at the top of the figure. If a list is passed and `subplots` is
#     True, print each item in the list above the corresponding subplot.
# grid : bool, default None (matlab style default)
#     Axis grid lines.
# legend : bool or {'reverse'}
#     Place legend on axis subplots.
# style : list or dict
#     The matplotlib line style per column.
# logx : bool or 'sym', default False
#     Use log scaling or symlog scaling on x axis.
#     .. versionchanged:: 0.25.0
#
# logy : bool or 'sym' default False
#     Use log scaling or symlog scaling on y axis.
#     .. versionchanged:: 0.25.0
#
# loglog : bool or 'sym', default False
#     Use log scaling or symlog scaling on both x and y axes.
#     .. versionchanged:: 0.25.0
#
# xticks : sequence
#     Values to use for the xticks.
# yticks : sequence
#     Values to use for the yticks.
# xlim : 2-tuple/list
#     Set the x limits of the current axes.
# ylim : 2-tuple/list
#     Set the y limits of the current axes.
# xlabel : label, optional
#     Name to use for the xlabel on x-axis. Default uses index name as xlabel, or the
#     x-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# ylabel : label, optional
#     Name to use for the ylabel on y-axis. Default will show no ylabel, or the
#     y-column name for planar plots.
#
#     .. versionadded:: 1.1.0
#
#     .. versionchanged:: 1.2.0
#
#        Now applicable to planar plots (`scatter`, `hexbin`).
#
# rot : int, default None
#     Rotation for ticks (xticks for vertical, yticks for horizontal
#     plots).
# fontsize : int, default None
#     Font size for xticks and yticks.
# colormap : str or matplotlib colormap object, default None
#     Colormap to select colors from. If string, load colormap with that
#     name from matplotlib.
# colorbar : bool, optional
#     If True, plot colorbar (only relevant for 'scatter' and 'hexbin'
#     plots).
# position : float
#     Specify relative alignments for bar plot layout.
#     From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#     (center).
# table : bool, Series or DataFrame, default False
#     If True, draw a table using the data in the DataFrame and the data
#     will be transposed to meet matplotlib's default layout.
#     If a Series or DataFrame is passed, use passed data to draw a
#     table.
# yerr : DataFrame, Series, array-like, dict and str
#     See :ref:`Plotting with Error Bars <visualization.errorbars>` for
#     detail.
# xerr : DataFrame, Series, array-like, dict and str
#     Equivalent to yerr.
# stacked : bool, default False in line and bar plots, and True in area plot
#     If True, create stacked plot.
# sort_columns : bool, default False
#     Sort column names to determine plot ordering.
# secondary_y : bool or sequence, default False
#     Whether to plot on the secondary y-axis if a list/tuple, which
#     columns to plot on secondary y-axis.
# mark_right : bool, default True
#     When using a secondary_y axis, automatically mark the column
#     labels with "(right)" in the legend.
# include_bool : bool, default is False
#     If True, boolean values can be plotted.
# backend : str, default None
#     Backend to use instead of the backend specified in the option
#     ``plotting.backend``. For instance, 'matplotlib'. Alternatively, to
#     specify the ``plotting.backend`` for the whole session, set
#     ``pd.options.plotting.backend``.
#
#     .. versionadded:: 1.0.0
#
# **kwargs
#     Options to pass to matplotlib plotting method.
#
# Returns
# -------
# :class:`matplotlib.axes.Axes` or numpy.ndarray of them
#     If the backend is not the default matplotlib one, the return value
#     will be the object returned by the backend.
#
# Notes
# -----
# - See matplotlib documentation online for more on this subject
# - If `kind` = 'bar' or 'barh', you can specify relative alignments
#   for bar plot layout by `position` keyword.
#   From 0 (left/bottom-end) to 1 (right/top-end). Default is 0.5
#   (center)
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.base.IndexOpsMixin.value_counts</u></summary>
# <blockquote>
# <code>
# Return a Series containing counts of unique values.
#
# The resulting object will be in descending order so that the
# first element is the most frequently-occurring element.
# Excludes NA values by default.
#
# Parameters
# ----------
# normalize : bool, default False
#     If True then the object returned will contain the relative
#     frequencies of the unique values.
# sort : bool, default True
#     Sort by frequencies.
# ascending : bool, default False
#     Sort in ascending order.
# bins : int, optional
#     Rather than count values, group them into half-open bins,
#     a convenience for ``pd.cut``, only works with numeric data.
# dropna : bool, default True
#     Don't include counts of NaN.
#
# Returns
# -------
# Series
#
# See Also
# --------
# Series.count: Number of non-NA elements in a Series.
# DataFrame.count: Number of non-NA elements in a DataFrame.
# DataFrame.value_counts: Equivalent method on DataFrames.
#
# Examples
# --------
# >>> index = pd.Index([3, 1, 2, 3, 4, np.nan])
# >>> index.value_counts()
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# dtype: int64
#
# With `normalize` set to `True`, returns the relative frequency by
# dividing all values by the sum of values.
#
# >>> s = pd.Series([3, 1, 2, 3, 4, np.nan])
# >>> s.value_counts(normalize=True)
# 3.0    0.4
# 1.0    0.2
# 2.0    0.2
# 4.0    0.2
# dtype: float64
#
# **bins**
#
# Bins can be useful for going from a continuous variable to a
# categorical variable; instead of counting unique
# apparitions of values, divide the index in the specified
# number of half-open bins.
#
# >>> s.value_counts(bins=3)
# (0.996, 2.0]    2
# (2.0, 3.0]      2
# (3.0, 4.0]      1
# dtype: int64
#
# **dropna**
#
# With `dropna` set to `False` we can also see NaN index values.
#
# >>> s.value_counts(dropna=False)
# 3.0    2
# 1.0    1
# 2.0    1
# 4.0    1
# NaN    1
# dtype: int64
#
# </code>
# <a href='#11'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
bar_chart('Embarked')


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>12. Data Preparation | Feature Engineering</h1>  <a id='12'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#12'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
#Deleting unneccesary columns
df_Train.drop('Name', axis=1, inplace=True)
df_Test.drop('Name', axis=1, inplace=True)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>13. Data Preparation</h1>  <a id='13'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#13'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>14. Data Preparation</h1>  <a id='14'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#14'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>15. Data Preparation | Feature Engineering</h1>  <a id='15'></a><small><a href='#top_phases'>back to top</a></small>

# %%
df_Train.Sex[df_Train.Sex == 'male'] = 1
df_Train.Sex[df_Train.Sex == 'female'] = 2

df_Test.Sex[df_Test.Sex == 'male'] = 1
df_Test.Sex[df_Test.Sex == 'female'] = 2


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>16. Data Preparation | Feature Engineering</h1>  <a id='16'></a><small><a href='#top_phases'>back to top</a></small>

# %%
df_Train.Embarked[df_Train.Embarked == 'Q'] = 1
df_Train.Embarked[df_Train.Embarked == 'S'] = 2
df_Train.Embarked[df_Train.Embarked == 'C'] = 3

df_Test.Embarked[df_Test.Embarked == 'Q'] = 1
df_Test.Embarked[df_Test.Embarked == 'S'] = 2
df_Test.Embarked[df_Test.Embarked == 'C'] = 3


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>17. Data Preparation | Feature Engineering</h1>  <a id='17'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.series.Series.mode</u></summary>
# <blockquote>
# <code>
# Return the mode(s) of the Series.
#
# The mode is the value that appears most often. There can be multiple modes.
#
# Always returns Series even if only one value is returned.
#
# Parameters
# ----------
# dropna : bool, default True
#     Don't consider counts of NaN/NaT.
#
# Returns
# -------
# Series
#     Modes of the Series in sorted order.
#
# </code>
# <a href='#17'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.series.Series.fillna</u></summary>
# <blockquote>
# <code>
# Fill NA/NaN values using the specified method.
#
# Parameters
# ----------
# value : scalar, dict, Series, or DataFrame
#     Value to use to fill holes (e.g. 0), alternately a
#     dict/Series/DataFrame of values specifying which value to use for
#     each index (for a Series) or column (for a DataFrame).  Values not
#     in the dict/Series/DataFrame will not be filled. This value cannot
#     be a list.
# method : {'backfill', 'bfill', 'pad', 'ffill', None}, default None
#     Method to use for filling holes in reindexed Series
#     pad / ffill: propagate last valid observation forward to next valid
#     backfill / bfill: use next valid observation to fill gap.
# axis : {0 or 'index'}
#     Axis along which to fill missing values.
# inplace : bool, default False
#     If True, fill in-place. Note: this will modify any
#     other views on this object (e.g., a no-copy slice for a column in a
#     DataFrame).
# limit : int, default None
#     If method is specified, this is the maximum number of consecutive
#     NaN values to forward/backward fill. In other words, if there is
#     a gap with more than this number of consecutive NaNs, it will only
#     be partially filled. If method is not specified, this is the
#     maximum number of entries along the entire axis where NaNs will be
#     filled. Must be greater than 0 if not None.
# downcast : dict, default is None
#     A dict of item->dtype of what to downcast if possible,
#     or the string 'infer' which will try to downcast to an appropriate
#     equal type (e.g. float64 to int64 if possible).
#
# Returns
# -------
# Series or None
#     Object with missing values filled or None if ``inplace=True``.
#
# See Also
# --------
# interpolate : Fill NaN values using interpolation.
# reindex : Conform object to new index.
# asfreq : Convert TimeSeries to specified frequency.
#
# Examples
# --------
# >>> df = pd.DataFrame([[np.nan, 2, np.nan, 0],
# ...                    [3, 4, np.nan, 1],
# ...                    [np.nan, np.nan, np.nan, np.nan],
# ...                    [np.nan, 3, np.nan, 4]],
# ...                   columns=list("ABCD"))
# >>> df
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  NaN  NaN NaN  NaN
# 3  NaN  3.0 NaN  4.0
#
# Replace all NaN elements with 0s.
#
# >>> df.fillna(0)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  0.0
# 3  0.0  3.0  0.0  4.0
#
# We can also propagate non-null values forward or backward.
#
# >>> df.fillna(method="ffill")
#      A    B   C    D
# 0  NaN  2.0 NaN  0.0
# 1  3.0  4.0 NaN  1.0
# 2  3.0  4.0 NaN  1.0
# 3  3.0  3.0 NaN  4.0
#
# Replace all NaN elements in column 'A', 'B', 'C', and 'D', with 0, 1,
# 2, and 3 respectively.
#
# >>> values = {"A": 0, "B": 1, "C": 2, "D": 3}
# >>> df.fillna(value=values)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  2.0  1.0
# 2  0.0  1.0  2.0  3.0
# 3  0.0  3.0  2.0  4.0
#
# Only replace the first NaN element.
#
# >>> df.fillna(value=values, limit=1)
#      A    B    C    D
# 0  0.0  2.0  2.0  0.0
# 1  3.0  4.0  NaN  1.0
# 2  NaN  1.0  NaN  3.0
# 3  NaN  3.0  NaN  4.0
#
# When filling using a DataFrame, replacement happens along
# the same column names and same indices
#
# >>> df2 = pd.DataFrame(np.zeros((4, 4)), columns=list("ABCE"))
# >>> df.fillna(df2)
#      A    B    C    D
# 0  0.0  2.0  0.0  0.0
# 1  3.0  4.0  0.0  1.0
# 2  0.0  0.0  0.0  NaN
# 3  0.0  3.0  0.0  4.0
#
# Note that column D is not affected since it is not present in df2.
#
# </code>
# <a href='#17'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train['Age']=df_Train['Age'].fillna(df_Train['Age'].mode()[0])
df_Test['Age']=df_Test['Age'].fillna(df_Test['Age'].mode()[0])

df_Train['Embarked']=df_Train['Embarked'].fillna(df_Train['Embarked'].mode()[0])
df_Test['Fare']=df_Test['Fare'].fillna(df_Test['Fare'].mode()[0])


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>18. Data Preparation | Visualization</h1>  <a id='18'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#18'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u></summary>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#18'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
sns.heatmap(df_Train.isnull(),yticklabels=False,cbar=False)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>19. Data Preparation | Visualization</h1>  <a id='19'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#19'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>seaborn</h2>
# <ul>
# <li>
# <details><summary><u>seaborn.matrix.heatmap</u></summary>
# <blockquote>
# <code>
# Plot rectangular data as a color-encoded matrix.
#
# This is an Axes-level function and will draw the heatmap into the
# currently-active Axes if none is provided to the ``ax`` argument.  Part of
# this Axes space will be taken and used to plot a colormap, unless ``cbar``
# is False or a separate Axes is provided to ``cbar_ax``.
#
# Parameters
# ----------
# data : rectangular dataset
#     2D dataset that can be coerced into an ndarray. If a Pandas DataFrame
#     is provided, the index/column information will be used to label the
#     columns and rows.
# vmin, vmax : floats, optional
#     Values to anchor the colormap, otherwise they are inferred from the
#     data and other keyword arguments.
# cmap : matplotlib colormap name or object, or list of colors, optional
#     The mapping from data values to color space. If not provided, the
#     default will depend on whether ``center`` is set.
# center : float, optional
#     The value at which to center the colormap when plotting divergant data.
#     Using this parameter will change the default ``cmap`` if none is
#     specified.
# robust : bool, optional
#     If True and ``vmin`` or ``vmax`` are absent, the colormap range is
#     computed with robust quantiles instead of the extreme values.
# annot : bool or rectangular dataset, optional
#     If True, write the data value in each cell. If an array-like with the
#     same shape as ``data``, then use this to annotate the heatmap instead
#     of the data. Note that DataFrames will match on position, not index.
# fmt : str, optional
#     String formatting code to use when adding annotations.
# annot_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.axes.Axes.text` when ``annot``
#     is True.
# linewidths : float, optional
#     Width of the lines that will divide each cell.
# linecolor : color, optional
#     Color of the lines that will divide each cell.
# cbar : bool, optional
#     Whether to draw a colorbar.
# cbar_kws : dict of key, value mappings, optional
#     Keyword arguments for :meth:`matplotlib.figure.Figure.colorbar`.
# cbar_ax : matplotlib Axes, optional
#     Axes in which to draw the colorbar, otherwise take space from the
#     main Axes.
# square : bool, optional
#     If True, set the Axes aspect to "equal" so each cell will be
#     square-shaped.
# xticklabels, yticklabels : "auto", bool, list-like, or int, optional
#     If True, plot the column names of the dataframe. If False, don't plot
#     the column names. If list-like, plot these alternate labels as the
#     xticklabels. If an integer, use the column names but plot only every
#     n label. If "auto", try to densely plot non-overlapping labels.
# mask : bool array or DataFrame, optional
#     If passed, data will not be shown in cells where ``mask`` is True.
#     Cells with missing values are automatically masked.
# ax : matplotlib Axes, optional
#     Axes in which to draw the plot, otherwise use the currently-active
#     Axes.
# kwargs : other keyword arguments
#     All other keyword arguments are passed to
#     :meth:`matplotlib.axes.Axes.pcolormesh`.
#
# Returns
# -------
# ax : matplotlib Axes
#     Axes object with the heatmap.
#
# See Also
# --------
# clustermap : Plot a matrix using hierachical clustering to arrange the
#              rows and columns.
#
# Examples
# --------
#
# Plot a heatmap for a numpy array:
#
# .. plot::
#     :context: close-figs
#
#     >>> import numpy as np; np.random.seed(0)
#     >>> import seaborn as sns; sns.set_theme()
#     >>> uniform_data = np.random.rand(10, 12)
#     >>> ax = sns.heatmap(uniform_data)
#
# Change the limits of the colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(uniform_data, vmin=0, vmax=1)
#
# Plot a heatmap for data centered on 0 with a diverging colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> normal_data = np.random.randn(10, 12)
#     >>> ax = sns.heatmap(normal_data, center=0)
#
# Plot a dataframe with meaningful row and column labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> flights = sns.load_dataset("flights")
#     >>> flights = flights.pivot("month", "year", "passengers")
#     >>> ax = sns.heatmap(flights)
#
# Annotate each cell with the numeric value using integer formatting:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, annot=True, fmt="d")
#
# Add lines between each cell:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, linewidths=.5)
#
# Use a different colormap:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cmap="YlGnBu")
#
# Center the colormap at a specific value:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, center=flights.loc["Jan", 1955])
#
# Plot every other column label and don't plot row labels:
#
# .. plot::
#     :context: close-figs
#
#     >>> data = np.random.randn(50, 20)
#     >>> ax = sns.heatmap(data, xticklabels=2, yticklabels=False)
#
# Don't draw a colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> ax = sns.heatmap(flights, cbar=False)
#
# Use different axes for the colorbar:
#
# .. plot::
#     :context: close-figs
#
#     >>> grid_kws = {"height_ratios": (.9, .05), "hspace": .3}
#     >>> f, (ax, cbar_ax) = plt.subplots(2, gridspec_kw=grid_kws)
#     >>> ax = sns.heatmap(flights, ax=ax,
#     ...                  cbar_ax=cbar_ax,
#     ...                  cbar_kws={"orientation": "horizontal"})
#
# Use a mask to plot only part of a matrix
#
# .. plot::
#     :context: close-figs
#
#     >>> corr = np.corrcoef(np.random.randn(10, 200))
#     >>> mask = np.zeros_like(corr)
#     >>> mask[np.triu_indices_from(mask)] = True
#     >>> with sns.axes_style("white"):
#     ...     f, ax = plt.subplots(figsize=(7, 5))
#     ...     ax = sns.heatmap(corr, mask=mask, vmax=.3, square=True)
#
# </code>
# <a href='#19'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
sns.heatmap(df_Test.isnull(),yticklabels=False,cbar=False)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>20. Data Preparation | Feature Engineering</h1>  <a id='20'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.drop</u></summary>
# <blockquote>
# <code>
# Drop specified labels from rows or columns.
#
# Remove rows or columns by specifying label names and corresponding
# axis, or by specifying directly index or column names. When using a
# multi-index, labels on different levels can be removed by specifying
# the level. See the `user guide <advanced.shown_levels>`
# for more information about the now unused levels.
#
# Parameters
# ----------
# labels : single label or list-like
#     Index or column labels to drop. A tuple will be used as a single
#     label and not treated as a list-like.
# axis : {0 or 'index', 1 or 'columns'}, default 0
#     Whether to drop labels from the index (0 or 'index') or
#     columns (1 or 'columns').
# index : single label or list-like
#     Alternative to specifying axis (``labels, axis=0``
#     is equivalent to ``index=labels``).
# columns : single label or list-like
#     Alternative to specifying axis (``labels, axis=1``
#     is equivalent to ``columns=labels``).
# level : int or level name, optional
#     For MultiIndex, level from which the labels will be removed.
# inplace : bool, default False
#     If False, return a copy. Otherwise, do operation
#     inplace and return None.
# errors : {'ignore', 'raise'}, default 'raise'
#     If 'ignore', suppress error and only existing labels are
#     dropped.
#
# Returns
# -------
# DataFrame or None
#     DataFrame without the removed index or column labels or
#     None if ``inplace=True``.
#
# Raises
# ------
# KeyError
#     If any of the labels is not found in the selected axis.
#
# See Also
# --------
# DataFrame.loc : Label-location based indexer for selection by label.
# DataFrame.dropna : Return DataFrame with labels on given axis omitted
#     where (all or any) data are missing.
# DataFrame.drop_duplicates : Return DataFrame with duplicate rows
#     removed, optionally only considering certain columns.
# Series.drop : Return Series with specified index labels removed.
#
# Examples
# --------
# >>> df = pd.DataFrame(np.arange(12).reshape(3, 4),
# ...                   columns=['A', 'B', 'C', 'D'])
# >>> df
#    A  B   C   D
# 0  0  1   2   3
# 1  4  5   6   7
# 2  8  9  10  11
#
# Drop columns
#
# >>> df.drop(['B', 'C'], axis=1)
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# >>> df.drop(columns=['B', 'C'])
#    A   D
# 0  0   3
# 1  4   7
# 2  8  11
#
# Drop a row by index
#
# >>> df.drop([0, 1])
#    A  B   C   D
# 2  8  9  10  11
#
# Drop columns and/or rows of MultiIndex DataFrame
#
# >>> midx = pd.MultiIndex(levels=[['lama', 'cow', 'falcon'],
# ...                              ['speed', 'weight', 'length']],
# ...                      codes=[[0, 0, 0, 1, 1, 1, 2, 2, 2],
# ...                             [0, 1, 2, 0, 1, 2, 0, 1, 2]])
# >>> df = pd.DataFrame(index=midx, columns=['big', 'small'],
# ...                   data=[[45, 30], [200, 100], [1.5, 1], [30, 20],
# ...                         [250, 150], [1.5, 0.8], [320, 250],
# ...                         [1, 0.8], [0.3, 0.2]])
# >>> df
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#         length  0.3     0.2
#
# Drop a specific index combination from the MultiIndex
# DataFrame, i.e., drop the combination ``'falcon'`` and
# ``'weight'``, which deletes only the corresponding row
#
# >>> df.drop(index=('falcon', 'weight'))
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
#         length  1.5     1.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
#         length  1.5     0.8
# falcon  speed   320.0   250.0
#         length  0.3     0.2
#
# >>> df.drop(index='cow', columns='small')
#                 big
# lama    speed   45.0
#         weight  200.0
#         length  1.5
# falcon  speed   320.0
#         weight  1.0
#         length  0.3
#
# >>> df.drop(index='length', level=1)
#                 big     small
# lama    speed   45.0    30.0
#         weight  200.0   100.0
# cow     speed   30.0    20.0
#         weight  250.0   150.0
# falcon  speed   320.0   250.0
#         weight  1.0     0.8
#
# </code>
# <a href='#20'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.drop(['Cabin'],axis=1,inplace=True)
df_Test.drop(['Cabin'],axis=1,inplace=True)

df_Train.drop(['Ticket'],axis=1,inplace=True)
df_Test.drop(['Ticket'],axis=1,inplace=True)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>21. Data Preparation</h1>  <a id='21'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#21'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>22. Data Preparation</h1>  <a id='22'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#22'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>23. Data Preparation | Feature Engineering</h1>  <a id='23'></a><small><a href='#top_phases'>back to top</a></small>

# %%
df_Train.Fare[df_Train.Fare <= 17] = 1
df_Train.Fare[(df_Train.Fare > 17) & (df_Train.Fare <= 30)] = 2
df_Train.Fare[(df_Train.Fare > 30) & (df_Train.Fare <= 100)] = 3
df_Train.Fare[df_Train.Fare > 100] = 4

df_Test.Fare[df_Test.Fare <= 17] = 1
df_Test.Fare[(df_Test.Fare > 17) & (df_Test.Fare <= 30)] = 2
df_Test.Fare[(df_Test.Fare > 30) & (df_Test.Fare <= 100)] = 3
df_Test.Fare[df_Test.Fare > 100] = 4


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>24. Data Preparation | Feature Engineering</h1>  <a id='24'></a><small><a href='#top_phases'>back to top</a></small>

# %%
df_Train.Age[df_Train.Age <= 16] = 0
df_Train.Age[(df_Train.Age > 16) & (df_Train.Age <= 26)] = 1
df_Train.Age[(df_Train.Age > 26) & (df_Train.Age <= 36)] = 2
df_Train.Age[(df_Train.Age > 36) & (df_Train.Age <= 62)] = 3
df_Train.Age[df_Train.Age > 62] = 4

df_Test.Age[df_Test.Age <= 16] = 0
df_Test.Age[(df_Test.Age > 16) & (df_Test.Age <= 26)] = 1
df_Test.Age[(df_Test.Age > 26) & (df_Test.Age <= 36)] = 2
df_Test.Age[(df_Test.Age > 36) & (df_Test.Age <= 62)] = 3
df_Test.Age[df_Test.Age > 62] = 4


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>25. Data Preparation</h1>  <a id='25'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#25'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>26. Data Preparation</h1>  <a id='26'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.head</u></summary>
# <blockquote>
# <code>
# Return the first `n` rows.
#
# This function returns the first `n` rows for the object based
# on position. It is useful for quickly testing if your object
# has the right type of data in it.
#
# For negative values of `n`, this function returns all rows except
# the last `n` rows, equivalent to ``df[:-n]``.
#
# Parameters
# ----------
# n : int, default 5
#     Number of rows to select.
#
# Returns
# -------
# same type as caller
#     The first `n` rows of the caller object.
#
# See Also
# --------
# DataFrame.tail: Returns the last `n` rows.
#
# Examples
# --------
# >>> df = pd.DataFrame({'animal': ['alligator', 'bee', 'falcon', 'lion',
# ...                    'monkey', 'parrot', 'shark', 'whale', 'zebra']})
# >>> df
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
# 6      shark
# 7      whale
# 8      zebra
#
# Viewing the first 5 lines
#
# >>> df.head()
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
#
# Viewing the first `n` lines (three in this case)
#
# >>> df.head(3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
#
# For negative values of `n`
#
# >>> df.head(-3)
#       animal
# 0  alligator
# 1        bee
# 2     falcon
# 3       lion
# 4     monkey
# 5     parrot
#
# </code>
# <a href='#26'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test.head()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>27. Data Preparation | Feature Engineering</h1>  <a id='27'></a><small><a href='#top_phases'>back to top</a></small>

# %%
X=df_Train[['PassengerId','Pclass','Sex','Age','SibSp','Parch','Fare','Embarked']]
y=df_Train[['Survived']]


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>28. Data Preparation | Library Loading</h1>  <a id='28'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.model_selection._split.train_test_split</u></summary>
# <blockquote>
# <code>
# Split arrays or matrices into random train and test subsets.
#
# Quick utility that wraps input validation and
# ``next(ShuffleSplit().split(X, y))`` and application to input data
# into a single call for splitting (and optionally subsampling) data in a
# oneliner.
#
# Read more in the :ref:`User Guide <cross_validation>`.
#
# Parameters
# ----------
# *arrays : sequence of indexables with same length / shape[0]
#     Allowed inputs are lists, numpy arrays, scipy-sparse
#     matrices or pandas dataframes.
#
# test_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the proportion
#     of the dataset to include in the test split. If int, represents the
#     absolute number of test samples. If None, the value is set to the
#     complement of the train size. If ``train_size`` is also None, it will
#     be set to 0.25.
#
# train_size : float or int, default=None
#     If float, should be between 0.0 and 1.0 and represent the
#     proportion of the dataset to include in the train split. If
#     int, represents the absolute number of train samples. If None,
#     the value is automatically set to the complement of the test size.
#
# random_state : int, RandomState instance or None, default=None
#     Controls the shuffling applied to the data before applying the split.
#     Pass an int for reproducible output across multiple function calls.
#     See :term:`Glossary <random_state>`.
#
# shuffle : bool, default=True
#     Whether or not to shuffle the data before splitting. If shuffle=False
#     then stratify must be None.
#
# stratify : array-like, default=None
#     If not None, data is split in a stratified fashion, using this as
#     the class labels.
#     Read more in the :ref:`User Guide <stratification>`.
#
# Returns
# -------
# splitting : list, length=2 * len(arrays)
#     List containing train-test split of inputs.
#
#     .. versionadded:: 0.16
#         If the input is sparse, the output will be a
#         ``scipy.sparse.csr_matrix``. Else, output type is the same as the
#         input type.
#
# Examples
# --------
# >>> import numpy as np
# >>> from sklearn.model_selection import train_test_split
# >>> X, y = np.arange(10).reshape((5, 2)), range(5)
# >>> X
# array([[0, 1],
#        [2, 3],
#        [4, 5],
#        [6, 7],
#        [8, 9]])
# >>> list(y)
# [0, 1, 2, 3, 4]
#
# >>> X_train, X_test, y_train, y_test = train_test_split(
# ...     X, y, test_size=0.33, random_state=42)
# ...
# >>> X_train
# array([[4, 5],
#        [0, 1],
#        [6, 7]])
# >>> y_train
# [2, 0, 3]
# >>> X_test
# array([[2, 3],
#        [8, 9]])
# >>> y_test
# [1, 4]
#
# >>> train_test_split(y, shuffle=False)
# [[0, 1, 2], [3, 4]]
#
# </code>
# <a href='#28'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
from sklearn.model_selection import train_test_split
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size = 0.2, random_state = 0)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>29. Data Preparation | Feature Engineering</h1>  <a id='29'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#29'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u></summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#29'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Train.isnull().sum()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>30. Data Preparation</h1>  <a id='30'></a><small><a href='#top_phases'>back to top</a></small>

# %%
df_Test.dtypes


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>31. Data Preparation | Feature Engineering</h1>  <a id='31'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.astype</u></summary>
# <blockquote>
# <code>
# Cast a pandas object to a specified dtype ``dtype``.
#
# Parameters
# ----------
# dtype : data type, or dict of column name -> data type
#     Use a numpy.dtype or Python type to cast entire pandas object to
#     the same type. Alternatively, use {col: dtype, ...}, where col is a
#     column label and dtype is a numpy.dtype or Python type to cast one
#     or more of the DataFrame's columns to column-specific types.
# copy : bool, default True
#     Return a copy when ``copy=True`` (be very careful setting
#     ``copy=False`` as changes to values then may propagate to other
#     pandas objects).
# errors : {'raise', 'ignore'}, default 'raise'
#     Control raising of exceptions on invalid data for provided dtype.
#
#     - ``raise`` : allow exceptions to be raised
#     - ``ignore`` : suppress exceptions. On error return original object.
#
# Returns
# -------
# casted : same type as caller
#
# See Also
# --------
# to_datetime : Convert argument to datetime.
# to_timedelta : Convert argument to timedelta.
# to_numeric : Convert argument to a numeric type.
# numpy.ndarray.astype : Cast a numpy array to a specified type.
#
# Notes
# -----
# .. deprecated:: 1.3.0
#
#     Using ``astype`` to convert from timezone-naive dtype to
#     timezone-aware dtype is deprecated and will raise in a
#     future version.  Use :meth:`Series.dt.tz_localize` instead.
#
# Examples
# --------
# Create a DataFrame:
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# Cast all columns to int32:
#
# >>> df.astype('int32').dtypes
# col1    int32
# col2    int32
# dtype: object
#
# Cast col1 to int32 using a dictionary:
#
# >>> df.astype({'col1': 'int32'}).dtypes
# col1    int32
# col2    int64
# dtype: object
#
# Create a series:
#
# >>> ser = pd.Series([1, 2], dtype='int32')
# >>> ser
# 0    1
# 1    2
# dtype: int32
# >>> ser.astype('int64')
# 0    1
# 1    2
# dtype: int64
#
# Convert to categorical type:
#
# >>> ser.astype('category')
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [1, 2]
#
# Convert to ordered categorical type with custom ordering:
#
# >>> from pandas.api.types import CategoricalDtype
# >>> cat_dtype = CategoricalDtype(
# ...     categories=[2, 1], ordered=True)
# >>> ser.astype(cat_dtype)
# 0    1
# 1    2
# dtype: category
# Categories (2, int64): [2 < 1]
#
# Note that using ``copy=False`` and changing data on a new
# pandas object may propagate changes:
#
# >>> s1 = pd.Series([1, 2])
# >>> s2 = s1.astype('int64', copy=False)
# >>> s2[0] = 10
# >>> s1  # note that s1[0] has changed too
# 0    10
# 1     2
# dtype: int64
#
# Create a series of dates:
#
# >>> ser_date = pd.Series(pd.date_range('20200101', periods=3))
# >>> ser_date
# 0   2020-01-01
# 1   2020-01-02
# 2   2020-01-03
# dtype: datetime64[ns]
#
# </code>
# <a href='#31'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test['Sex'] = df_Test['Sex'].astype(int) 
df_Test['Embarked'] = df_Test['Embarked'].astype(int)
df_Test.dtypes


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>32. Data Preparation | Feature Engineering</h1>  <a id='32'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame.isnull</u></summary>
# <blockquote>
# <code>
# DataFrame.isnull is an alias for DataFrame.isna.
#
# Detect missing values.
#
# Return a boolean same-sized object indicating if the values are NA.
# NA values, such as None or :attr:`numpy.NaN`, gets mapped to True
# values.
# Everything else gets mapped to False values. Characters such as empty
# strings ``''`` or :attr:`numpy.inf` are not considered NA values
# (unless you set ``pandas.options.mode.use_inf_as_na = True``).
#
# Returns
# -------
# DataFrame
#     Mask of bool values for each element in DataFrame that
#     indicates whether an element is an NA value.
#
# See Also
# --------
# DataFrame.isnull : Alias of isna.
# DataFrame.notna : Boolean inverse of isna.
# DataFrame.dropna : Omit axes labels with missing values.
# isna : Top-level isna.
#
# Examples
# --------
# Show which entries in a DataFrame are NA.
#
# >>> df = pd.DataFrame(dict(age=[5, 6, np.NaN],
# ...                    born=[pd.NaT, pd.Timestamp('1939-05-27'),
# ...                          pd.Timestamp('1940-04-25')],
# ...                    name=['Alfred', 'Batman', ''],
# ...                    toy=[None, 'Batmobile', 'Joker']))
# >>> df
#    age       born    name        toy
# 0  5.0        NaT  Alfred       None
# 1  6.0 1939-05-27  Batman  Batmobile
# 2  NaN 1940-04-25              Joker
#
# >>> df.isna()
#      age   born   name    toy
# 0  False   True  False   True
# 1  False  False  False  False
# 2   True  False  False  False
#
# Show which entries in a Series are NA.
#
# >>> ser = pd.Series([5, 6, np.NaN])
# >>> ser
# 0    5.0
# 1    6.0
# 2    NaN
# dtype: float64
#
# >>> ser.isna()
# 0    False
# 1    False
# 2     True
# dtype: bool
#
# </code>
# <a href='#32'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame._add_numeric_operations.<locals>.sum</u></summary>
# <blockquote>
# <code>
# Return the sum of the values over the requested axis.
#
# This is equivalent to the method ``numpy.sum``.
#
# Parameters
# ----------
# axis : {index (0), columns (1)}
#     Axis for the function to be applied on.
# skipna : bool, default True
#     Exclude NA/null values when computing the result.
# level : int or level name, default None
#     If the axis is a MultiIndex (hierarchical), count along a
#     particular level, collapsing into a Series.
# numeric_only : bool, default None
#     Include only float, int, boolean columns. If None, will attempt to use
#     everything, then use only numeric data. Not implemented for Series.
# min_count : int, default 0
#     The required number of valid values to perform the operation. If fewer than
#     ``min_count`` non-NA values are present the result will be NA.
# **kwargs
#     Additional keyword arguments to be passed to the function.
#
# Returns
# -------
# Series or DataFrame (if level specified)
#
# See Also
# --------
# Series.sum : Return the sum.
# Series.min : Return the minimum.
# Series.max : Return the maximum.
# Series.idxmin : Return the index of the minimum.
# Series.idxmax : Return the index of the maximum.
# DataFrame.sum : Return the sum over the requested axis.
# DataFrame.min : Return the minimum over the requested axis.
# DataFrame.max : Return the maximum over the requested axis.
# DataFrame.idxmin : Return the index of the minimum over the requested axis.
# DataFrame.idxmax : Return the index of the maximum over the requested axis.
#
# Examples
# --------
# >>> idx = pd.MultiIndex.from_arrays([
# ...     ['warm', 'warm', 'cold', 'cold'],
# ...     ['dog', 'falcon', 'fish', 'spider']],
# ...     names=['blooded', 'animal'])
# >>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
# >>> s
# blooded  animal
# warm     dog       4
#          falcon    2
# cold     fish      0
#          spider    8
# Name: legs, dtype: int64
#
# >>> s.sum()
# 14
#
# By default, the sum of an empty or all-NA Series is ``0``.
#
# >>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
# 0.0
#
# This can be controlled with the ``min_count`` parameter. For example, if
# you'd like the sum of an empty series to be NaN, pass ``min_count=1``.
#
# >>> pd.Series([], dtype="float64").sum(min_count=1)
# nan
#
# Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
# empty series identically.
#
# >>> pd.Series([np.nan]).sum()
# 0.0
#
# >>> pd.Series([np.nan]).sum(min_count=1)
# nan
#
# </code>
# <a href='#32'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
df_Test.isnull().sum()


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>33. Data Preparation</h1>  <a id='33'></a><small><a href='#top_phases'>back to top</a></small>

# %%
df_Test


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>34. Data Preparation | Feature Engineering | Library Loading</h1>  <a id='34'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#34'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#34'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
from sklearn.preprocessing import StandardScaler
sc = StandardScaler()
df_Test1 = sc.fit_transform(df_Test)
df_Test1


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>35. Data Preparation</h1>  <a id='35'></a><small><a href='#top_phases'>back to top</a></small>

# %%
X.shape


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>36. Data Preparation | Feature Engineering | Library Loading</h1>  <a id='36'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>sklearn</h2>
# <ul>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler</u></summary>
# <blockquote>
# <code>
# Standardize features by removing the mean and scaling to unit variance.
#
# The standard score of a sample `x` is calculated as:
#
#     z = (x - u) / s
#
# where `u` is the mean of the training samples or zero if `with_mean=False`,
# and `s` is the standard deviation of the training samples or one if
# `with_std=False`.
#
# Centering and scaling happen independently on each feature by computing
# the relevant statistics on the samples in the training set. Mean and
# standard deviation are then stored to be used on later data using
# :meth:`transform`.
#
# Standardization of a dataset is a common requirement for many
# machine learning estimators: they might behave badly if the
# individual features do not more or less look like standard normally
# distributed data (e.g. Gaussian with 0 mean and unit variance).
#
# For instance many elements used in the objective function of
# a learning algorithm (such as the RBF kernel of Support Vector
# Machines or the L1 and L2 regularizers of linear models) assume that
# all features are centered around 0 and have variance in the same
# order. If a feature has a variance that is orders of magnitude larger
# that others, it might dominate the objective function and make the
# estimator unable to learn from other features correctly as expected.
#
# This scaler can also be applied to sparse CSR or CSC matrices by passing
# `with_mean=False` to avoid breaking the sparsity structure of the data.
#
# Read more in the :ref:`User Guide <preprocessing_scaler>`.
#
# Parameters
# ----------
# copy : bool, default=True
#     If False, try to avoid a copy and do inplace scaling instead.
#     This is not guaranteed to always work inplace; e.g. if the data is
#     not a NumPy array or scipy.sparse CSR matrix, a copy may still be
#     returned.
#
# with_mean : bool, default=True
#     If True, center the data before scaling.
#     This does not work (and will raise an exception) when attempted on
#     sparse matrices, because centering them entails building a dense
#     matrix which in common use cases is likely to be too large to fit in
#     memory.
#
# with_std : bool, default=True
#     If True, scale the data to unit variance (or equivalently,
#     unit standard deviation).
#
# Attributes
# ----------
# scale_ : ndarray of shape (n_features,) or None
#     Per feature relative scaling of the data to achieve zero mean and unit
#     variance. Generally this is calculated using `np.sqrt(var_)`. If a
#     variance is zero, we can't achieve unit variance, and the data is left
#     as-is, giving a scaling factor of 1. `scale_` is equal to `None`
#     when `with_std=False`.
#
#     .. versionadded:: 0.17
#        *scale_*
#
# mean_ : ndarray of shape (n_features,) or None
#     The mean value for each feature in the training set.
#     Equal to ``None`` when ``with_mean=False``.
#
# var_ : ndarray of shape (n_features,) or None
#     The variance for each feature in the training set. Used to compute
#     `scale_`. Equal to ``None`` when ``with_std=False``.
#
# n_features_in_ : int
#     Number of features seen during :term:`fit`.
#
#     .. versionadded:: 0.24
#
# feature_names_in_ : ndarray of shape (`n_features_in_`,)
#     Names of features seen during :term:`fit`. Defined only when `X`
#     has feature names that are all strings.
#
#     .. versionadded:: 1.0
#
# n_samples_seen_ : int or ndarray of shape (n_features,)
#     The number of samples processed by the estimator for each feature.
#     If there are no missing samples, the ``n_samples_seen`` will be an
#     integer, otherwise it will be an array of dtype int. If
#     `sample_weights` are used it will be a float (if no missing data)
#     or an array of dtype float that sums the weights seen so far.
#     Will be reset on new calls to fit, but increments across
#     ``partial_fit`` calls.
#
# See Also
# --------
# scale : Equivalent function without the estimator API.
#
# :class:`~sklearn.decomposition.PCA` : Further removes the linear
#     correlation across features with 'whiten=True'.
#
# Notes
# -----
# NaNs are treated as missing values: disregarded in fit, and maintained in
# transform.
#
# We use a biased estimator for the standard deviation, equivalent to
# `numpy.std(x, ddof=0)`. Note that the choice of `ddof` is unlikely to
# affect model performance.
#
# For a comparison of the different scalers, transformers, and normalizers,
# see :ref:`examples/preprocessing/plot_all_scaling.py
# <sphx_glr_auto_examples_preprocessing_plot_all_scaling.py>`.
#
# Examples
# --------
# >>> from sklearn.preprocessing import StandardScaler
# >>> data = [[0, 0], [0, 0], [1, 1], [1, 1]]
# >>> scaler = StandardScaler()
# >>> print(scaler.fit(data))
# StandardScaler()
# >>> print(scaler.mean_)
# [0.5 0.5]
# >>> print(scaler.transform(data))
# [[-1. -1.]
#  [-1. -1.]
#  [ 1.  1.]
#  [ 1.  1.]]
# >>> print(scaler.transform([[2, 2]]))
# [[3. 3.]]
#
# </code>
# <a href='#36'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.base.TransformerMixin.fit_transform</u></summary>
# <blockquote>
# <code>
# Fit to data, then transform it.
#
# Fits transformer to `X` and `y` with optional parameters `fit_params`
# and returns a transformed version of `X`.
#
# Parameters
# ----------
# X : array-like of shape (n_samples, n_features)
#     Input samples.
#
# y :  array-like of shape (n_samples,) or (n_samples, n_outputs),                 default=None
#     Target values (None for unsupervised transformations).
#
# **fit_params : dict
#     Additional fit parameters.
#
# Returns
# -------
# X_new : ndarray array of shape (n_samples, n_features_new)
#     Transformed array.
#
# </code>
# <a href='#36'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>sklearn.preprocessing._data.StandardScaler.transform</u></summary>
# <blockquote>
# <code>
# Perform standardization by centering and scaling.
#
# Parameters
# ----------
# X : {array-like, sparse matrix of shape (n_samples, n_features)
#     The data used to scale along the features axis.
# copy : bool, default=None
#     Copy the input X or not.
#
# Returns
# -------
# X_tr : {ndarray, sparse matrix} of shape (n_samples, n_features)
#     Transformed array.
#
# </code>
# <a href='#36'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
# Feature Scaling
from sklearn.preprocessing import StandardScaler
sc = StandardScaler()
X_train = sc.fit_transform(X_train)
X_test = sc.transform(X_test)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>37. Library Loading</h1>  <a id='37'></a><small><a href='#top_phases'>back to top</a></small>

# %%
import keras
from keras.models import Sequential
from keras.layers import Dense
from keras.layers import LeakyReLU,PReLU,ELU
from keras.layers import Dropout


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>38. Model Building and Training</h1>  <a id='38'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential</u></summary>
# <blockquote>
# <code>
# `Sequential` groups a linear stack of layers into a `tf.keras.Model`.
#
# `Sequential` provides training and inference features on this model.
#
# Examples:
#
# ```python
# Optionally, the first layer can receive an `input_shape` argument:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# Afterwards, we do automatic shape inference:
# model.add(tf.keras.layers.Dense(4))
#
# This is identical to the following:
# model = tf.keras.Sequential()
# model.add(tf.keras.Input(shape=(16,)))
# model.add(tf.keras.layers.Dense(8))
#
# Note that you can also omit the `input_shape` argument.
# In that case the model doesn't have any weights until the first call
# to a training/evaluation method (since it isn't yet built):
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.weights not created yet
#
# Whereas if you specify the input shape, the model gets built
# continuously as you are adding layers:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8, input_shape=(16,)))
# model.add(tf.keras.layers.Dense(4))
# len(model.weights)
# Returns "4"
#
# When using the delayed-build pattern (no input shape specified), you can
# choose to manually build your model by calling
# `build(batch_input_shape)`:
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(4))
# model.build((None, 16))
# len(model.weights)
# Returns "4"
#
# Note that when using the delayed-build pattern (no input shape specified),
# the model gets built the first time you call `fit`, `eval`, or `predict`,
# or the first time you call the model on some input data.
# model = tf.keras.Sequential()
# model.add(tf.keras.layers.Dense(8))
# model.add(tf.keras.layers.Dense(1))
# model.compile(optimizer='sgd', loss='mse')
# This builds the model for the first time:
# model.fit(x, y, batch_size=32, epochs=10)
# ```
#
# </code>
# <a href='#38'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.layers.core.dense.Dense</u></summary>
# <blockquote>
# <code>
# Just your regular densely-connected NN layer.
#
# `Dense` implements the operation:
# `output = activation(dot(input, kernel) + bias)`
# where `activation` is the element-wise activation function
# passed as the `activation` argument, `kernel` is a weights matrix
# created by the layer, and `bias` is a bias vector created by the layer
# (only applicable if `use_bias` is `True`). These are all attributes of
# `Dense`.
#
# Note: If the input to the layer has a rank greater than 2, then `Dense`
# computes the dot product between the `inputs` and the `kernel` along the
# last axis of the `inputs` and axis 0 of the `kernel` (using `tf.tensordot`).
# For example, if input has dimensions `(batch_size, d0, d1)`,
# then we create a `kernel` with shape `(d1, units)`, and the `kernel` operates
# along axis 2 of the `input`, on every sub-tensor of shape `(1, 1, d1)`
# (there are `batch_size * d0` such sub-tensors).
# The output in this case will have shape `(batch_size, d0, units)`.
#
# Besides, layer attributes cannot be modified after the layer has been called
# once (except the `trainable` attribute).
# When a popular kwarg `input_shape` is passed, then keras will create
# an input layer to insert before the current layer. This can be treated
# equivalent to explicitly defining an `InputLayer`.
#
# Example:
#
# >>> # Create a `Sequential` model and add a Dense layer as the first layer.
# >>> model = tf.keras.models.Sequential()
# >>> model.add(tf.keras.Input(shape=(16,)))
# >>> model.add(tf.keras.layers.Dense(32, activation='relu'))
# >>> # Now the model will take as input arrays of shape (None, 16)
# >>> # and output arrays of shape (None, 32).
# >>> # Note that after the first layer, you don't need to specify
# >>> # the size of the input anymore:
# >>> model.add(tf.keras.layers.Dense(32))
# >>> model.output_shape
# (None, 32)
#
# Args:
#   units: Positive integer, dimensionality of the output space.
#   activation: Activation function to use.
#     If you don't specify anything, no activation is applied
#     (ie. "linear" activation: `a(x) = x`).
#   use_bias: Boolean, whether the layer uses a bias vector.
#   kernel_initializer: Initializer for the `kernel` weights matrix.
#   bias_initializer: Initializer for the bias vector.
#   kernel_regularizer: Regularizer function applied to
#     the `kernel` weights matrix.
#   bias_regularizer: Regularizer function applied to the bias vector.
#   activity_regularizer: Regularizer function applied to
#     the output of the layer (its "activation").
#   kernel_constraint: Constraint function applied to
#     the `kernel` weights matrix.
#   bias_constraint: Constraint function applied to the bias vector.
#
# Input shape:
#   N-D tensor with shape: `(batch_size, ..., input_dim)`.
#   The most common situation would be
#   a 2D input with shape `(batch_size, input_dim)`.
#
# Output shape:
#   N-D tensor with shape: `(batch_size, ..., units)`.
#   For instance, for a 2D input with shape `(batch_size, input_dim)`,
#   the output would have shape `(batch_size, units)`.
#
# </code>
# <a href='#38'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.sequential.Sequential.add</u></summary>
# <blockquote>
# <code>
# Adds a layer instance on top of the layer stack.
#
# Args:
#     layer: layer instance.
#
# Raises:
#     TypeError: If `layer` is not a layer instance.
#     ValueError: In case the `layer` argument does not
#         know its input shape.
#     ValueError: In case the `layer` argument has
#         multiple output tensors, or is already connected
#         somewhere else (forbidden in `Sequential` models).
#
# </code>
# <a href='#38'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>keras.engine.training.Model.compile</u></summary>
# <blockquote>
# <code>
# Configures the model for training.
#
# Example:
#
# ```python
# model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=1e-3),
#               loss=tf.keras.losses.BinaryCrossentropy(),
#               metrics=[tf.keras.metrics.BinaryAccuracy(),
#                        tf.keras.metrics.FalseNegatives()])
# ```
#
# Args:
#     optimizer: String (name of optimizer) or optimizer instance. See
#       `tf.keras.optimizers`.
#     loss: Loss function. Maybe be a string (name of loss function), or
#       a `tf.keras.losses.Loss` instance. See `tf.keras.losses`. A loss
#       function is any callable with the signature `loss = fn(y_true,
#       y_pred)`, where `y_true` are the ground truth values, and
#       `y_pred` are the model's predictions.
#       `y_true` should have shape
#       `(batch_size, d0, .. dN)` (except in the case of
#       sparse loss functions such as
#       sparse categorical crossentropy which expects integer arrays of shape
#       `(batch_size, d0, .. dN-1)`).
#       `y_pred` should have shape `(batch_size, d0, .. dN)`.
#       The loss function should return a float tensor.
#       If a custom `Loss` instance is
#       used and reduction is set to `None`, return value has shape
#       `(batch_size, d0, .. dN-1)` i.e. per-sample or per-timestep loss
#       values; otherwise, it is a scalar. If the model has multiple outputs,
#       you can use a different loss on each output by passing a dictionary
#       or a list of losses. The loss value that will be minimized by the
#       model will then be the sum of all individual losses, unless
#       `loss_weights` is specified.
#     metrics: List of metrics to be evaluated by the model during training
#       and testing. Each of this can be a string (name of a built-in
#       function), function or a `tf.keras.metrics.Metric` instance. See
#       `tf.keras.metrics`. Typically you will use `metrics=['accuracy']`. A
#       function is any callable with the signature `result = fn(y_true,
#       y_pred)`. To specify different metrics for different outputs of a
#       multi-output model, you could also pass a dictionary, such as
#       `metrics={'output_a': 'accuracy', 'output_b': ['accuracy', 'mse']}`.
#       You can also pass a list to specify a metric or a list of metrics
#       for each output, such as `metrics=[['accuracy'], ['accuracy', 'mse']]`
#       or `metrics=['accuracy', ['accuracy', 'mse']]`. When you pass the
#       strings 'accuracy' or 'acc', we convert this to one of
#       `tf.keras.metrics.BinaryAccuracy`,
#       `tf.keras.metrics.CategoricalAccuracy`,
#       `tf.keras.metrics.SparseCategoricalAccuracy` based on the loss
#       function used and the model output shape. We do a similar
#       conversion for the strings 'crossentropy' and 'ce' as well.
#     loss_weights: Optional list or dictionary specifying scalar coefficients
#       (Python floats) to weight the loss contributions of different model
#       outputs. The loss value that will be minimized by the model will then
#       be the *weighted sum* of all individual losses, weighted by the
#       `loss_weights` coefficients.
#         If a list, it is expected to have a 1:1 mapping to the model's
#           outputs. If a dict, it is expected to map output names (strings)
#           to scalar coefficients.
#     weighted_metrics: List of metrics to be evaluated and weighted by
#       `sample_weight` or `class_weight` during training and testing.
#     run_eagerly: Bool. Defaults to `False`. If `True`, this `Model`'s
#       logic will not be wrapped in a `tf.function`. Recommended to leave
#       this as `None` unless your `Model` cannot be run inside a
#       `tf.function`. `run_eagerly=True` is not supported when using
#       `tf.distribute.experimental.ParameterServerStrategy`.
#     steps_per_execution: Int. Defaults to 1. The number of batches to run
#       during each `tf.function` call. Running multiple batches inside a
#       single `tf.function` call can greatly improve performance on TPUs or
#       small models with a large Python overhead. At most, one full epoch
#       will be run each execution. If a number larger than the size of the
#       epoch is passed, the execution will be truncated to the size of the
#       epoch. Note that if `steps_per_execution` is set to `N`,
#       `Callback.on_batch_begin` and `Callback.on_batch_end` methods will
#       only be called every `N` batches (i.e. before/after each `tf.function`
#       execution).
#     jit_compile: If `True`, compile the model training step with XLA.
#       [XLA](https://www.tensorflow.org/xla) is an optimizing compiler for
#       machine learning.
#       `jit_compile` is not enabled for by default.
#       This option cannot be enabled with `run_eagerly=True`.
#       Note that `jit_compile=True` is
#       may not necessarily work for all models.
#       For more information on supported operations please refer to the
#       [XLA documentation](https://www.tensorflow.org/xla).
#       Also refer to
#       [known XLA issues](https://www.tensorflow.org/xla/known_issues) for
#       more details.
#     **kwargs: Arguments supported for backwards compatibility only.
#
# </code>
# <a href='#38'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
classifier = Sequential()
classifier.add(Dense(units = 20, kernel_initializer = 'he_uniform',activation='relu',input_dim = 8))
classifier.add(Dense(units = 10, kernel_initializer = 'he_uniform',activation='relu'))
classifier.add(Dense(units = 15, kernel_initializer = 'he_uniform',activation='relu'))
classifier.add(Dense(units = 1, kernel_initializer = 'glorot_uniform', activation = 'sigmoid'))

classifier.compile(optimizer = 'Adamax', loss = 'binary_crossentropy', metrics = ['accuracy'])


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>39. Model Building and Training</h1>  <a id='39'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.fit</u></summary>
# <blockquote>
# <code>
# Trains the model for a fixed number of epochs (iterations on a dataset).
#
# Args:
#     x: Input data. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A dict mapping input names to the corresponding array/tensors,
#         if the model has named inputs.
#       - A `tf.data` dataset. Should return a tuple
#         of either `(inputs, targets)` or
#         `(inputs, targets, sample_weights)`.
#       - A generator or `keras.utils.Sequence` returning `(inputs, targets)`
#         or `(inputs, targets, sample_weights)`.
#       - A `tf.keras.utils.experimental.DatasetCreator`, which wraps a
#         callable that takes a single argument of type
#         `tf.distribute.InputContext`, and returns a `tf.data.Dataset`.
#         `DatasetCreator` should be used when users prefer to specify the
#         per-replica batching and sharding logic for the `Dataset`.
#         See `tf.keras.utils.experimental.DatasetCreator` doc for more
#         information.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given below. If using
#       `tf.distribute.experimental.ParameterServerStrategy`, only
#       `DatasetCreator` type is supported for `x`.
#     y: Target data. Like the input data `x`,
#       it could be either Numpy array(s) or TensorFlow tensor(s).
#       It should be consistent with `x` (you cannot have Numpy inputs and
#       tensor targets, or inversely). If `x` is a dataset, generator,
#       or `keras.utils.Sequence` instance, `y` should
#       not be specified (since targets will be obtained from `x`).
#     batch_size: Integer or `None`.
#         Number of samples per gradient update.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     epochs: Integer. Number of epochs to train the model.
#         An epoch is an iteration over the entire `x` and `y`
#         data provided
#         (unless the `steps_per_epoch` flag is set to
#         something other than None).
#         Note that in conjunction with `initial_epoch`,
#         `epochs` is to be understood as "final epoch".
#         The model is not trained for a number of iterations
#         given by `epochs`, but merely until the epoch
#         of index `epochs` is reached.
#     verbose: 'auto', 0, 1, or 2. Verbosity mode.
#         0 = silent, 1 = progress bar, 2 = one line per epoch.
#         'auto' defaults to 1 for most cases, but 2 when used with
#         `ParameterServerStrategy`. Note that the progress bar is not
#         particularly useful when logged to a file, so verbose=2 is
#         recommended when not running interactively (eg, in a production
#         environment).
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during training.
#         See `tf.keras.callbacks`. Note `tf.keras.callbacks.ProgbarLogger`
#         and `tf.keras.callbacks.History` callbacks are created automatically
#         and need not be passed into `model.fit`.
#         `tf.keras.callbacks.ProgbarLogger` is created or not based on
#         `verbose` argument to `model.fit`.
#         Callbacks with batch-level calls are currently unsupported with
#         `tf.distribute.experimental.ParameterServerStrategy`, and users are
#         advised to implement epoch-level calls instead with an appropriate
#         `steps_per_epoch` value.
#     validation_split: Float between 0 and 1.
#         Fraction of the training data to be used as validation data.
#         The model will set apart this fraction of the training data,
#         will not train on it, and will evaluate
#         the loss and any model metrics
#         on this data at the end of each epoch.
#         The validation data is selected from the last samples
#         in the `x` and `y` data provided, before shuffling. This argument is
#         not supported when `x` is a dataset, generator or
#        `keras.utils.Sequence` instance.
#         `validation_split` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     validation_data: Data on which to evaluate
#         the loss and any model metrics at the end of each epoch.
#         The model will not be trained on this data. Thus, note the fact
#         that the validation loss of data provided using `validation_split`
#         or `validation_data` is not affected by regularization layers like
#         noise and dropout.
#         `validation_data` will override `validation_split`.
#         `validation_data` could be:
#           - A tuple `(x_val, y_val)` of Numpy arrays or tensors.
#           - A tuple `(x_val, y_val, val_sample_weights)` of NumPy arrays.
#           - A `tf.data.Dataset`.
#           - A Python generator or `keras.utils.Sequence` returning
#           `(inputs, targets)` or `(inputs, targets, sample_weights)`.
#         `validation_data` is not yet supported with
#         `tf.distribute.experimental.ParameterServerStrategy`.
#     shuffle: Boolean (whether to shuffle the training data
#         before each epoch) or str (for 'batch'). This argument is ignored
#         when `x` is a generator or an object of tf.data.Dataset.
#         'batch' is a special option for dealing
#         with the limitations of HDF5 data; it shuffles in batch-sized
#         chunks. Has no effect when `steps_per_epoch` is not `None`.
#     class_weight: Optional dictionary mapping class indices (integers)
#         to a weight (float) value, used for weighting the loss function
#         (during training only).
#         This can be useful to tell the model to
#         "pay more attention" to samples from
#         an under-represented class.
#     sample_weight: Optional Numpy array of weights for
#         the training samples, used for weighting the loss function
#         (during training only). You can either pass a flat (1D)
#         Numpy array with the same length as the input samples
#         (1:1 mapping between weights and samples),
#         or in the case of temporal data,
#         you can pass a 2D array with shape
#         `(samples, sequence_length)`,
#         to apply a different weight to every timestep of every sample. This
#         argument is not supported when `x` is a dataset, generator, or
#        `keras.utils.Sequence` instance, instead provide the sample_weights
#         as the third element of `x`.
#     initial_epoch: Integer.
#         Epoch at which to start training
#         (useful for resuming a previous training run).
#     steps_per_epoch: Integer or `None`.
#         Total number of steps (batches of samples)
#         before declaring one epoch finished and starting the
#         next epoch. When training with input tensors such as
#         TensorFlow data tensors, the default `None` is equal to
#         the number of samples in your dataset divided by
#         the batch size, or 1 if that cannot be determined. If x is a
#         `tf.data` dataset, and 'steps_per_epoch'
#         is None, the epoch will run until the input dataset is exhausted.
#         When passing an infinitely repeating dataset, you must specify the
#         `steps_per_epoch` argument. If `steps_per_epoch=-1` the training
#         will run indefinitely with an infinitely repeating dataset.
#         This argument is not supported with array inputs.
#         When using `tf.distribute.experimental.ParameterServerStrategy`:
#           * `steps_per_epoch=None` is not supported.
#     validation_steps: Only relevant if `validation_data` is provided and
#         is a `tf.data` dataset. Total number of steps (batches of
#         samples) to draw before stopping when performing validation
#         at the end of every epoch. If 'validation_steps' is None, validation
#         will run until the `validation_data` dataset is exhausted. In the
#         case of an infinitely repeated dataset, it will run into an
#         infinite loop. If 'validation_steps' is specified and only part of
#         the dataset will be consumed, the evaluation will start from the
#         beginning of the dataset at each epoch. This ensures that the same
#         validation samples are used every time.
#     validation_batch_size: Integer or `None`.
#         Number of samples per validation batch.
#         If unspecified, will default to `batch_size`.
#         Do not specify the `validation_batch_size` if your data is in the
#         form of datasets, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     validation_freq: Only relevant if validation data is provided. Integer
#         or `collections.abc.Container` instance (e.g. list, tuple, etc.).
#         If an integer, specifies how many training epochs to run before a
#         new validation run is performed, e.g. `validation_freq=2` runs
#         validation every 2 epochs. If a Container, specifies the epochs on
#         which to run validation, e.g. `validation_freq=[1, 2, 10]` runs
#         validation at the end of the 1st, 2nd, and 10th epochs.
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up
#         when using process-based threading. If unspecified, `workers`
#         will default to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# Unpacking behavior for iterator-like inputs:
#     A common pattern is to pass a tf.data.Dataset, generator, or
#   tf.keras.utils.Sequence to the `x` argument of fit, which will in fact
#   yield not only features (x) but optionally targets (y) and sample weights.
#   Keras requires that the output of such iterator-likes be unambiguous. The
#   iterator should return a tuple of length 1, 2, or 3, where the optional
#   second and third elements will be used for y and sample_weight
#   respectively. Any other type provided will be wrapped in a length one
#   tuple, effectively treating everything as 'x'. When yielding dicts, they
#   should still adhere to the top-level tuple structure.
#   e.g. `({"x0": x0, "x1": x1}, y)`. Keras will not attempt to separate
#   features, targets, and weights from the keys of a single dict.
#     A notable unsupported data type is the namedtuple. The reason is that
#   it behaves like both an ordered datatype (tuple) and a mapping
#   datatype (dict). So given a namedtuple of the form:
#       `namedtuple("example_tuple", ["y", "x"])`
#   it is ambiguous whether to reverse the order of the elements when
#   interpreting the value. Even worse is a tuple of the form:
#       `namedtuple("other_tuple", ["x", "y", "z"])`
#   where it is unclear if the tuple was intended to be unpacked into x, y,
#   and sample_weight or passed through as a single element to `x`. As a
#   result the data processing code will simply raise a ValueError if it
#   encounters a namedtuple. (Along with instructions to remedy the issue.)
#
# Returns:
#     A `History` object. Its `History.history` attribute is
#     a record of training loss values and metrics values
#     at successive epochs, as well as validation loss values
#     and validation metrics values (if applicable).
#
# Raises:
#     RuntimeError: 1. If the model was never compiled or,
#     2. If `model.fit` is  wrapped in `tf.function`.
#
#     ValueError: In case of mismatch between the provided input data
#         and what the model expects or when the input data is empty.
#
# </code>
# <a href='#39'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
model=classifier.fit(X_train, y_train, validation_split=0.350, batch_size = 5, epochs = 100)


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>40. Data Preparation | Model Building and Training</h1>  <a id='40'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>keras</h2>
# <ul>
# <li>
# <details><summary><u>keras.engine.training.Model.predict</u></summary>
# <blockquote>
# <code>
# Generates output predictions for the input samples.
#
# Computation is done in batches. This method is designed for batch processing
# of large numbers of inputs. It is not intended for use inside of loops
# that iterate over your data and process small numbers of inputs at a time.
#
# For small numbers of inputs that fit in one batch,
# directly use `__call__()` for faster execution, e.g.,
# `model(x)`, or `model(x, training=False)` if you have layers such as
# `tf.keras.layers.BatchNormalization` that behave differently during
# inference. You may pair the individual model call with a `tf.function`
# for additional performance inside your inner loop.
# If you need access to numpy array values instead of tensors after your
# model call, you can use `tensor.numpy()` to get the numpy array value of
# an eager tensor.
#
# Also, note the fact that test loss is not affected by
# regularization layers like noise and dropout.
#
# Note: See [this FAQ entry](
# https://keras.io/getting_started/faq/#whats-the-difference-between-model-methods-predict-and-call)
# for more details about the difference between `Model` methods `predict()`
# and `__call__()`.
#
# Args:
#     x: Input samples. It could be:
#       - A Numpy array (or array-like), or a list of arrays
#         (in case the model has multiple inputs).
#       - A TensorFlow tensor, or a list of tensors
#         (in case the model has multiple inputs).
#       - A `tf.data` dataset.
#       - A generator or `keras.utils.Sequence` instance.
#       A more detailed description of unpacking behavior for iterator types
#       (Dataset, generator, Sequence) is given in the `Unpacking behavior
#       for iterator-like inputs` section of `Model.fit`.
#     batch_size: Integer or `None`.
#         Number of samples per batch.
#         If unspecified, `batch_size` will default to 32.
#         Do not specify the `batch_size` if your data is in the
#         form of dataset, generators, or `keras.utils.Sequence` instances
#         (since they generate batches).
#     verbose: Verbosity mode, 0 or 1.
#     steps: Total number of steps (batches of samples)
#         before declaring the prediction round finished.
#         Ignored with the default value of `None`. If x is a `tf.data`
#         dataset and `steps` is None, `predict()` will
#         run until the input dataset is exhausted.
#     callbacks: List of `keras.callbacks.Callback` instances.
#         List of callbacks to apply during prediction.
#         See [callbacks](/api_docs/python/tf/keras/callbacks).
#     max_queue_size: Integer. Used for generator or `keras.utils.Sequence`
#         input only. Maximum size for the generator queue.
#         If unspecified, `max_queue_size` will default to 10.
#     workers: Integer. Used for generator or `keras.utils.Sequence` input
#         only. Maximum number of processes to spin up when using
#         process-based threading. If unspecified, `workers` will default
#         to 1.
#     use_multiprocessing: Boolean. Used for generator or
#         `keras.utils.Sequence` input only. If `True`, use process-based
#         threading. If unspecified, `use_multiprocessing` will default to
#         `False`. Note that because this implementation relies on
#         multiprocessing, you should not pass non-picklable arguments to
#         the generator as they can't be passed easily to children processes.
#
# See the discussion of `Unpacking behavior for iterator-like inputs` for
# `Model.fit`. Note that Model.predict uses the same interpretation rules as
# `Model.fit` and `Model.evaluate`, so inputs must be unambiguous for all
# three methods.
#
# Returns:
#     Numpy array(s) of predictions.
#
# Raises:
#     RuntimeError: If `model.predict` is wrapped in a `tf.function`.
#     ValueError: In case of mismatch between the provided
#         input data and the model's expectations,
#         or in case a stateful model receives a number of samples
#         that is not a multiple of the batch size.
#
# </code>
# <a href='#40'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
# <li> <h2 class='hglib'>numpy</h2>
# <ul>
# <li>
# <details><summary><u>numpy.ndarray.astype</u></summary>
# <blockquote>
# <code>
# a.astype(dtype, order='K', casting='unsafe', subok=True, copy=True)
#
# Copy of the array, cast to a specified type.
#
# Parameters
# ----------
# dtype : str or dtype
#     Typecode or data-type to which the array is cast.
# order : {'C', 'F', 'A', 'K'}, optional
#     Controls the memory layout order of the result.
#     'C' means C order, 'F' means Fortran order, 'A'
#     means 'F' order if all the arrays are Fortran contiguous,
#     'C' order otherwise, and 'K' means as close to the
#     order the array elements appear in memory as possible.
#     Default is 'K'.
# casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional
#     Controls what kind of data casting may occur. Defaults to 'unsafe'
#     for backwards compatibility.
#
#       * 'no' means the data types should not be cast at all.
#       * 'equiv' means only byte-order changes are allowed.
#       * 'safe' means only casts which can preserve values are allowed.
#       * 'same_kind' means only safe casts or casts within a kind,
#         like float64 to float32, are allowed.
#       * 'unsafe' means any data conversions may be done.
# subok : bool, optional
#     If True, then sub-classes will be passed-through (default), otherwise
#     the returned array will be forced to be a base-class array.
# copy : bool, optional
#     By default, astype always returns a newly allocated array. If this
#     is set to false, and the `dtype`, `order`, and `subok`
#     requirements are satisfied, the input array is returned instead
#     of a copy.
#
# Returns
# -------
# arr_t : ndarray
#     Unless `copy` is False and the other conditions for returning the input
#     array are satisfied (see description for `copy` input parameter), `arr_t`
#     is a new array of the same shape as the input array, with dtype, order
#     given by `dtype`, `order`.
#
# Notes
# -----
# .. versionchanged:: 1.17.0
#    Casting between a simple data type and a structured one is possible only
#    for "unsafe" casting.  Casting to multiple fields is allowed, but
#    casting from multiple fields is not.
#
# .. versionchanged:: 1.9.0
#    Casting from numeric to string types in 'safe' casting mode requires
#    that the string dtype length is long enough to store the max
#    integer/float value converted.
#
# Raises
# ------
# ComplexWarning
#     When casting from complex to float or int. To avoid this,
#     one should use ``a.real.astype(t)``.
#
# Examples
# --------
# >>> x = np.array([1, 2, 2.5])
# >>> x
# array([1. ,  2. ,  2.5])
#
# >>> x.astype(int)
# array([1, 2, 2])
#
# </code>
# <a href='#40'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>numpy.asarray</u></summary>
# <blockquote>
# <code>
# asarray(a, dtype=None, order=None, *, like=None)
#
# Convert the input to an array.
#
# Parameters
# ----------
# a : array_like
#     Input data, in any form that can be converted to an array.  This
#     includes lists, lists of tuples, tuples, tuples of tuples, tuples
#     of lists and ndarrays.
# dtype : data-type, optional
#     By default, the data-type is inferred from the input data.
# order : {'C', 'F', 'A', 'K'}, optional
#     Memory layout.  'A' and 'K' depend on the order of input array a.
#     'C' row-major (C-style),
#     'F' column-major (Fortran-style) memory representation.
#     'A' (any) means 'F' if `a` is Fortran contiguous, 'C' otherwise
#     'K' (keep) preserve input order
#     Defaults to 'K'.
# like : array_like
#     Reference object to allow the creation of arrays which are not
#     NumPy arrays. If an array-like passed in as ``like`` supports
#     the ``__array_function__`` protocol, the result will be defined
#     by it. In this case, it ensures the creation of an array object
#     compatible with that passed in via this argument.
#
#     .. versionadded:: 1.20.0
#
# Returns
# -------
# out : ndarray
#     Array interpretation of `a`.  No copy is performed if the input
#     is already an ndarray with matching dtype and order.  If `a` is a
#     subclass of ndarray, a base class ndarray is returned.
#
# See Also
# --------
# asanyarray : Similar function which passes through subclasses.
# ascontiguousarray : Convert input to a contiguous array.
# asfarray : Convert input to a floating point ndarray.
# asfortranarray : Convert input to an ndarray with column-major
#                  memory order.
# asarray_chkfinite : Similar function which checks input for NaNs and Infs.
# fromiter : Create an array from an iterator.
# fromfunction : Construct an array by executing a function on grid
#                positions.
#
# Examples
# --------
# Convert a list into an array:
#
# >>> a = [1, 2]
# >>> np.asarray(a)
# array([1, 2])
#
# Existing arrays are not copied:
#
# >>> a = np.array([1, 2])
# >>> np.asarray(a) is a
# True
#
# If `dtype` is set, array is copied only if dtype does not match:
#
# >>> a = np.array([1, 2], dtype=np.float32)
# >>> np.asarray(a, dtype=np.float32) is a
# True
# >>> np.asarray(a, dtype=np.float64) is a
# False
#
# Contrary to `asanyarray`, ndarray subclasses are not passed through:
#
# >>> issubclass(np.recarray, np.ndarray)
# True
# >>> a = np.array([(1.0, 2), (3.0, 4)], dtype='f4,i4').view(np.recarray)
# >>> np.asarray(a) is a
# False
# >>> np.asanyarray(a) is a
# True
#
# </code>
# <a href='#40'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
y_pred = classifier.predict(df_Test1)
y_pred = (y_pred > 0.5) #returns values in True / False in a list of lists format

# Converting True and False values to int
y_pred_int = y_pred.astype(int)

# Coverting list of list to 1 flat list
y_pred_list = [item for sublist in y_pred_int for item in sublist]

# Converting the flat list to np array
y_pred1 = np.asarray(y_pred_list , dtype = int)

# %%
y_pred1


# %% [markdown] deletable=false editable=false run_control={"frozen": true}
# <h1 class='hg'>42. Data Preparation</h1>  <a id='42'></a><small><a href='#top_phases'>back to top</a></small><details><summary><u>View function documentation</u></summary>
# <ul>
#
# <li> <h2 class='hglib'>pandas</h2>
# <ul>
# <li>
# <details><summary><u>pandas.core.frame.DataFrame</u></summary>
# <blockquote>
# <code>
# Two-dimensional, size-mutable, potentially heterogeneous tabular data.
#
# Data structure also contains labeled axes (rows and columns).
# Arithmetic operations align on both row and column labels. Can be
# thought of as a dict-like container for Series objects. The primary
# pandas data structure.
#
# Parameters
# ----------
# data : ndarray (structured or homogeneous), Iterable, dict, or DataFrame
#     Dict can contain Series, arrays, constants, dataclass or list-like objects. If
#     data is a dict, column order follows insertion-order. If a dict contains Series
#     which have an index defined, it is aligned by its index.
#
#     .. versionchanged:: 0.25.0
#        If data is a list of dicts, column order follows insertion-order.
#
# index : Index or array-like
#     Index to use for resulting frame. Will default to RangeIndex if
#     no indexing information part of input data and no index provided.
# columns : Index or array-like
#     Column labels to use for resulting frame when data does not have them,
#     defaulting to RangeIndex(0, 1, 2, ..., n). If data contains column labels,
#     will perform column selection instead.
# dtype : dtype, default None
#     Data type to force. Only a single dtype is allowed. If None, infer.
# copy : bool or None, default None
#     Copy data from inputs.
#     For dict data, the default of None behaves like ``copy=True``.  For DataFrame
#     or 2d ndarray input, the default of None behaves like ``copy=False``.
#
#     .. versionchanged:: 1.3.0
#
# See Also
# --------
# DataFrame.from_records : Constructor from tuples, also record arrays.
# DataFrame.from_dict : From dicts of Series, arrays, or dicts.
# read_csv : Read a comma-separated values (csv) file into DataFrame.
# read_table : Read general delimited file into DataFrame.
# read_clipboard : Read text from clipboard into DataFrame.
#
# Examples
# --------
# Constructing DataFrame from a dictionary.
#
# >>> d = {'col1': [1, 2], 'col2': [3, 4]}
# >>> df = pd.DataFrame(data=d)
# >>> df
#    col1  col2
# 0     1     3
# 1     2     4
#
# Notice that the inferred dtype is int64.
#
# >>> df.dtypes
# col1    int64
# col2    int64
# dtype: object
#
# To enforce a single dtype:
#
# >>> df = pd.DataFrame(data=d, dtype=np.int8)
# >>> df.dtypes
# col1    int8
# col2    int8
# dtype: object
#
# Constructing DataFrame from a dictionary including Series:
#
# >>> d = {'col1': [0, 1, 2, 3], 'col2': pd.Series([2, 3], index=[2, 3])}
# >>> pd.DataFrame(data=d, index=[0, 1, 2, 3])
#    col1  col2
# 0     0   NaN
# 1     1   NaN
# 2     2   2.0
# 3     3   3.0
#
# Constructing DataFrame from numpy ndarray:
#
# >>> df2 = pd.DataFrame(np.array([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
# ...                    columns=['a', 'b', 'c'])
# >>> df2
#    a  b  c
# 0  1  2  3
# 1  4  5  6
# 2  7  8  9
#
# Constructing DataFrame from a numpy ndarray that has labeled columns:
#
# >>> data = np.array([(1, 2, 3), (4, 5, 6), (7, 8, 9)],
# ...                 dtype=[("a", "i4"), ("b", "i4"), ("c", "i4")])
# >>> df3 = pd.DataFrame(data, columns=['c', 'a'])
# ...
# >>> df3
#    c  a
# 0  3  1
# 1  6  4
# 2  9  7
#
# Constructing DataFrame from dataclass:
#
# >>> from dataclasses import make_dataclass
# >>> Point = make_dataclass("Point", [("x", int), ("y", int)])
# >>> pd.DataFrame([Point(0, 0), Point(0, 3), Point(2, 3)])
#    x  y
# 0  0  0
# 1  0  3
# 2  2  3
#
# </code>
# <a href='#42'>back to header</a>
# </blockquote>
# </details>
# </li>
# <li>
# <details><summary><u>pandas.core.generic.NDFrame.to_csv</u></summary>
# <blockquote>
# <code>
# Write object to a comma-separated values (csv) file.
#
# Parameters
# ----------
# path_or_buf : str, path object, file-like object, or None, default None
#     String, path object (implementing os.PathLike[str]), or file-like
#     object implementing a write() function. If None, the result is
#     returned as a string. If a non-binary file object is passed, it should
#     be opened with `newline=''`, disabling universal newlines. If a binary
#     file object is passed, `mode` might need to contain a `'b'`.
#
#     .. versionchanged:: 1.2.0
#
#        Support for binary file objects was introduced.
#
# sep : str, default ','
#     String of length 1. Field delimiter for the output file.
# na_rep : str, default ''
#     Missing data representation.
# float_format : str, default None
#     Format string for floating point numbers.
# columns : sequence, optional
#     Columns to write.
# header : bool or list of str, default True
#     Write out the column names. If a list of strings is given it is
#     assumed to be aliases for the column names.
# index : bool, default True
#     Write row names (index).
# index_label : str or sequence, or False, default None
#     Column label for index column(s) if desired. If None is given, and
#     `header` and `index` are True, then the index names are used. A
#     sequence should be given if the object uses MultiIndex. If
#     False do not print fields for index names. Use index_label=False
#     for easier importing in R.
# mode : str
#     Python write mode, default 'w'.
# encoding : str, optional
#     A string representing the encoding to use in the output file,
#     defaults to 'utf-8'. `encoding` is not supported if `path_or_buf`
#     is a non-binary file object.
# compression : str or dict, default 'infer'
#     For on-the-fly compression of the output data. If 'infer' and '%s'
#     path-like, then detect compression from the following extensions: '.gz',
#     '.bz2', '.zip', '.xz', or '.zst' (otherwise no compression). Set to
#     ``None`` for no compression. Can also be a dict with key ``'method'`` set
#     to one of {``'zip'``, ``'gzip'``, ``'bz2'``, ``'zstd'``} and other
#     key-value pairs are forwarded to ``zipfile.ZipFile``, ``gzip.GzipFile``,
#     ``bz2.BZ2File``, or ``zstandard.ZstdDecompressor``, respectively. As an
#     example, the following could be passed for faster compression and to create
#     a reproducible gzip archive:
#     ``compression={'method': 'gzip', 'compresslevel': 1, 'mtime': 1}``.
#
#     .. versionchanged:: 1.0.0
#
#        May now be a dict with key 'method' as compression mode
#        and other entries as additional compression options if
#        compression mode is 'zip'.
#
#     .. versionchanged:: 1.1.0
#
#        Passing compression options as keys in dict is
#        supported for compression modes 'gzip', 'bz2', 'zstd', and 'zip'.
#
#     .. versionchanged:: 1.2.0
#
#         Compression is supported for binary file objects.
#
#     .. versionchanged:: 1.2.0
#
#         Previous versions forwarded dict entries for 'gzip' to
#         `gzip.open` instead of `gzip.GzipFile` which prevented
#         setting `mtime`.
#
# quoting : optional constant from csv module
#     Defaults to csv.QUOTE_MINIMAL. If you have set a `float_format`
#     then floats are converted to strings and thus csv.QUOTE_NONNUMERIC
#     will treat them as non-numeric.
# quotechar : str, default '\"'
#     String of length 1. Character used to quote fields.
# line_terminator : str, optional
#     The newline character or character sequence to use in the output
#     file. Defaults to `os.linesep`, which depends on the OS in which
#     this method is called ('\\n' for linux, '\\r\\n' for Windows, i.e.).
# chunksize : int or None
#     Rows to write at a time.
# date_format : str, default None
#     Format string for datetime objects.
# doublequote : bool, default True
#     Control quoting of `quotechar` inside a field.
# escapechar : str, default None
#     String of length 1. Character used to escape `sep` and `quotechar`
#     when appropriate.
# decimal : str, default '.'
#     Character recognized as decimal separator. E.g. use ',' for
#     European data.
# errors : str, default 'strict'
#     Specifies how encoding and decoding errors are to be handled.
#     See the errors argument for :func:`open` for a full list
#     of options.
#
#     .. versionadded:: 1.1.0
#
# storage_options : dict, optional
#     Extra options that make sense for a particular storage connection, e.g.
#     host, port, username, password, etc. For HTTP(S) URLs the key-value pairs
#     are forwarded to ``urllib`` as header options. For other URLs (e.g.
#     starting with "s3://", and "gcs://") the key-value pairs are forwarded to
#     ``fsspec``. Please see ``fsspec`` and ``urllib`` for more details.
#
#     .. versionadded:: 1.2.0
#
# Returns
# -------
# None or str
#     If path_or_buf is None, returns the resulting csv format as a
#     string. Otherwise returns None.
#
# See Also
# --------
# read_csv : Load a CSV file into a DataFrame.
# to_excel : Write DataFrame to an Excel file.
#
# Examples
# --------
# >>> df = pd.DataFrame({'name': ['Raphael', 'Donatello'],
# ...                    'mask': ['red', 'purple'],
# ...                    'weapon': ['sai', 'bo staff']})
# >>> df.to_csv(index=False)
# 'name,mask,weapon\nRaphael,red,sai\nDonatello,purple,bo staff\n'
#
# Create 'out.zip' containing 'out.csv'
#
# >>> compression_opts = dict(method='zip',
# ...                         archive_name='out.csv')  # doctest: +SKIP
# >>> df.to_csv('out.zip', index=False,
# ...           compression=compression_opts)  # doctest: +SKIP
#
# To write a csv file to a new folder or nested folder you will first
# need to create it using either Pathlib or os:
#
# >>> from pathlib import Path  # doctest: +SKIP
# >>> filepath = Path('folder/subfolder/out.csv')  # doctest: +SKIP
# >>> filepath.parent.mkdir(parents=True, exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv(filepath)  # doctest: +SKIP
#
# >>> import os  # doctest: +SKIP
# >>> os.makedirs('folder/subfolder', exist_ok=True)  # doctest: +SKIP
# >>> df.to_csv('folder/subfolder/out.csv')  # doctest: +SKIP
#
# </code>
# <a href='#42'>back to header</a>
# </blockquote>
# </details>
# </li>
# </ul>
# </li>
#
# </ul>
# </details>

# %%
output = pd.DataFrame({'PassengerId': df_Test.PassengerId, 'Survived': y_pred1})
output.to_csv('my_submission15.csv', index=False)

# %%
