/*
 * Decompiled with CFR 0.152.
 */
package com.feedbooks.opds;

import com.feedbooks.opds.JSONErrorHandlerImpl;
import com.feedbooks.opds.OPDSRequirementsValidator;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator {
    private String opds_version = "1.1";
    private String encoding;
    private ErrorHandlerImpl eh;

    public void SetErrorHandler(ErrorHandlerImpl errorHandlerImpl) {
        this.eh = errorHandlerImpl;
    }

    public void SetEncoding(String string) {
        this.encoding = string;
    }

    public void SetOPDSVersion(String string) {
        this.opds_version = string;
    }

    private boolean validateByDirectOrFilenames(String[] stringArray, String[] stringArray2) {
        SchemaReader schemaReader = CompactSchemaReader.getInstance();
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, this.eh);
        boolean bl = false;
        OPDSRequirementsValidator oPDSRequirementsValidator = new OPDSRequirementsValidator();
        oPDSRequirementsValidator.setErrorHandler(this.eh);
        oPDSRequirementsValidator.setOPDSVersion(this.opds_version);
        try {
            ValidationDriver validationDriver = new ValidationDriver(propertyMapBuilder.toPropertyMap(), schemaReader);
            InputSource inputSource = ValidationDriver.uriOrFileInputSource("res/opds_v" + this.opds_version + ".rnc");
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            if (validationDriver.loadSchema(inputSource)) {
                for (int i = 0; i < stringArray.length; ++i) {
                    InputSource inputSource2;
                    InputSource inputSource3;
                    if (stringArray2.length == 0) {
                        inputSource2 = inputSource3 = ValidationDriver.uriOrFileInputSource(stringArray[i]);
                    } else {
                        inputSource3 = new InputSource(new StringReader(stringArray[i]));
                        inputSource2 = new InputSource(new StringReader(stringArray[i]));
                        inputSource3.setSystemId(stringArray2[i]);
                        inputSource2.setSystemId(stringArray2[i]);
                        inputSource3.setPublicId(stringArray2[i]);
                        inputSource2.setPublicId(stringArray2[i]);
                    }
                    if (validationDriver.validate(inputSource3) && oPDSRequirementsValidator.validate(inputSource2)) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        catch (SAXException sAXException) {
            bl = true;
            this.eh.printException(sAXException);
        }
        catch (IOException iOException) {
            bl = true;
            this.eh.printException(iOException);
        }
        return bl;
    }

    public boolean validate(String[] stringArray) {
        return this.validateByDirectOrFilenames(stringArray, new String[0]);
    }

    public boolean validate(String[] stringArray, String[] stringArray2) {
        return this.validateByDirectOrFilenames(stringArray, stringArray2);
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        OptionParser optionParser = new OptionParser("hv:e:f:", stringArray);
        String string2 = "1.1";
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(System.out);
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'f': {
                        object = optionParser.getOptionArg();
                        if (!((String)object).equalsIgnoreCase("json")) break;
                        errorHandlerImpl = new JSONErrorHandlerImpl(System.out);
                        break;
                    }
                    case 'v': {
                        string2 = optionParser.getOptionArg();
                        if (new File("res/opds_v" + string2 + ".rnc").exists()) break;
                        System.err.println("invalid OPDS Version " + string2);
                        throw new OptionParser.InvalidOptionException();
                    }
                    case 'e': {
                        string = optionParser.getOptionArg();
                        break;
                    }
                    case 'h': {
                        errorHandlerImpl.print("OPDSValidator usage: java -jar OPDSValidator [options] file");
                        errorHandlerImpl.print("Options:");
                        errorHandlerImpl.print("-h\t\tThis help message");
                        errorHandlerImpl.print("-v opds_version\tOPDSVersion to use (default 1.0)");
                        errorHandlerImpl.print("-e encoding\tFile encoding (passed to jing)");
                        errorHandlerImpl.print("-f format\tError output format (default text, avail : json)");
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            errorHandlerImpl.print("invalid_option" + optionParser.getOptionCharString());
            System.exit(2);
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            errorHandlerImpl.print("option_missing_argument" + optionParser.getOptionCharString());
            System.exit(2);
        }
        stringArray = optionParser.getRemainingArgs();
        object = new Validator();
        if (string != null) {
            ((Validator)object).SetEncoding(string);
        }
        ((Validator)object).SetOPDSVersion(string2);
        ((Validator)object).SetErrorHandler(errorHandlerImpl);
        if (stringArray.length != 0) {
            ((Validator)object).validate(stringArray);
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            char[] cArray = new char[4096];
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            try {
                while (n >= 0) {
                    n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length);
                    if (n <= 0) continue;
                    stringBuilder.append(cArray, 0, n);
                }
                ((Reader)inputStreamReader).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            String[] stringArray2 = new String[]{"stdin://"};
            String[] stringArray3 = new String[]{stringBuilder.toString()};
            ((Validator)object).validate(stringArray3, stringArray2);
        }
        errorHandlerImpl.close();
    }
}

