/*
 * Decompiled with CFR 0.152.
 */
package com.feedbooks.opds;

import com.feedbooks.opds.OPDSRequirementFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class OPDSRequirementAcquisitionOrNavigation
extends OPDSRequirementFilter {
    private boolean in_entry;
    private boolean typed;
    private boolean acquisition_feed;
    private int acquisition_links_count = 0;

    OPDSRequirementAcquisitionOrNavigation() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        if (string2.equalsIgnoreCase("entry")) {
            this.in_entry = true;
            this.acquisition_links_count = 0;
        }
        if (this.in_entry && string2.equalsIgnoreCase("link") && (string4 = attributes.getValue("rel")) != null && string4.contains("opds-spec.org/acquisition")) {
            this.setAcquisitionFeed();
            ++this.acquisition_links_count;
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase("entry")) {
            this.in_entry = false;
            if (!this.isTyped()) {
                if (this.acquisition_links_count > 0) {
                    this.setAcquisitionFeed();
                } else {
                    this.setNavigationFeed();
                }
            } else {
                if (this.isAcquisitionFeed() && this.acquisition_links_count == 0) {
                    this.error(new SAXParseException("Feed CAN'T be an acquisition and navigation feed (no acquisition link found)", this.getLocator()));
                }
                if (this.isNavigationFeed() && this.acquisition_links_count > 0) {
                    this.error(new SAXParseException("Feed CAN'T be an acquisition and navigation feed (found an acquisition link in a navigation feed)", this.getLocator()));
                }
            }
        }
        super.endElement(string, string2, string3);
    }

    private void setAcquisitionFeed() {
        this.acquisition_feed = true;
        this.typed = true;
    }

    private void setNavigationFeed() {
        this.acquisition_feed = false;
        this.typed = true;
    }

    private boolean isTyped() {
        return this.typed;
    }

    private boolean isAcquisitionFeed() {
        return this.isTyped() && this.acquisition_feed;
    }

    private boolean isNavigationFeed() {
        return this.isTyped() && !this.acquisition_feed;
    }
}

