/*
 * Decompiled with CFR 0.152.
 */
package com.feedbooks.opds;

import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JSONErrorHandlerImpl
extends ErrorHandlerImpl {
    private final String bundleName = "com.thaiopensource.xml.sax.resources.Messages";
    private ResourceBundle bundle = null;
    private JSONArray errors = new JSONArray();

    public JSONErrorHandlerImpl() {
        this(System.err);
    }

    public JSONErrorHandlerImpl(OutputStream outputStream) {
        super(outputStream);
    }

    public JSONErrorHandlerImpl(Writer writer) {
        super(writer);
    }

    @Override
    public void close() {
        String string = "";
        try {
            string = this.errors.toString(3);
        }
        catch (JSONException jSONException) {
            string = "Failed JSON Serialization " + jSONException.getMessage();
        }
        super.print(string);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.printSAXParseException("warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this.printSAXParseException("error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void printException(Throwable throwable) {
        if (throwable instanceof SAXException) {
            this.printSAXParseException("fatal", (SAXParseException)throwable);
        } else {
            this.print("fatal :" + this.formatMessage(throwable));
        }
    }

    @Override
    public void print(String string) {
        if (string.length() != 0) {
            this.errors.put((Object)string);
        }
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.thaiopensource.xml.sax.resources.Messages");
        }
        return this.bundle.getString(string);
    }

    private String format(String string, Object[] objectArray) {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    private void printSAXParseException(String string, SAXParseException sAXParseException) {
        try {
            int n;
            JSONObject jSONObject = new JSONObject().put("severity", (Object)string);
            String string2 = sAXParseException.getSystemId();
            if (string2 != null) {
                jSONObject.put("location", (Object)UriOrFile.uriToUriOrFile(string2));
            }
            if ((n = sAXParseException.getLineNumber()) >= 0) {
                jSONObject.put("line", (Object)new Integer(n));
            }
            if ((n = sAXParseException.getColumnNumber()) >= 0) {
                jSONObject.put("column", (Object)new Integer(n));
            }
            jSONObject.put("message", (Object)this.formatMessage(sAXParseException));
            this.errors.put((Object)jSONObject);
        }
        catch (JSONException jSONException) {
            this.print("JSON Object failed");
        }
    }

    private String formatLocation(SAXParseException sAXParseException) {
        Integer n;
        String string = sAXParseException.getSystemId();
        int n2 = sAXParseException.getLineNumber();
        Integer n3 = n2 >= 0 ? new Integer(n2) : null;
        n2 = sAXParseException.getColumnNumber();
        Integer n4 = n = n2 >= 0 ? new Integer(n2) : null;
        if (string != null) {
            string = UriOrFile.uriToUriOrFile(string);
            if (n3 != null) {
                if (n != null) {
                    return this.format("locator_system_id_line_number_column_number", new Object[]{string, n3, n});
                }
                return this.format("locator_system_id_line_number", new Object[]{string, n3});
            }
            return this.format("locator_system_id", new Object[]{string});
        }
        if (n3 != null) {
            if (n != null) {
                return this.format("locator_line_number_column_number", new Object[]{n3, n});
            }
            return this.format("locator_line_number", new Object[]{n3});
        }
        return "";
    }

    private String formatMessage(SAXException sAXException) {
        Exception exception = sAXException.getException();
        String string = sAXException.getMessage();
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 == string || exception.getClass().getName().equals(string)) {
                return this.formatMessage(exception);
            }
            if (string2 == null) {
                return this.format("exception", new Object[]{exception.getClass().getName(), string});
            }
            return this.format("tunnel_exception", new Object[]{exception.getClass().getName(), string, string2});
        }
        if (string == null) {
            string = this.getString("no_detail");
        }
        return string;
    }

    private String formatMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = this.getString("no_detail");
        }
        if (throwable instanceof FileNotFoundException) {
            return this.format("file_not_found", new Object[]{string});
        }
        return this.format("exception", new Object[]{throwable.getClass().getName(), string});
    }
}

