; https://github.com/seahorn/seahorn/issues/434
; RUN: %fpfsea "%s" -O3 --inline --enable-loop-idiom --enable-indvar --no-lower-gv-init-struct --externalize-addr-taken-functions --no-kill-vaarg --with-arith-overflow=true --horn-unify-assumes=true --horn-gsa --no-fat-fns=bcmp,memcpy,assert_bytes_match,ensure_linked_list_is_allocated,sea_aws_linked_list_is_valid --dsa=sea-cs-t --devirt-functions=types --bmc=opsem --horn-vcgen-use-ite --horn-vcgen-only-dataflow=true --horn-bmc-coi=true --sea-opsem-allocator=static --horn-explicit-sp0=false --horn-bv2-lambdas --horn-bv2-simplify=true --horn-bv2-extra-widemem --bound=10 2>&1 | %oc %s
; CHECK: ^unsat$
; ModuleID = '../test/opsem2/widemem/array_eq_c_str_ignore_case_434.ir.bc'
source_filename = "llvm-link"
target datalayout = "e-m:o-p:32:32-Fi8-f64:32:64-v64:32:64-v128:32:128-a:0:32-n32-S32"
target triple = "armv4t-apple-macosx10.17.0"

%struct.aws_byte_cursor = type { i32, i8* }
%struct.aws_allocator = type { i8* (%struct.aws_allocator*, i32)*, void (%struct.aws_allocator*, i8*)*, i8* (%struct.aws_allocator*, i8*, i32, i32)*, i8* (%struct.aws_allocator*, i32, i32)*, i8* }
%struct.aws_byte_buf = type { i32, i8*, i32, %struct.aws_allocator* }
%struct.aws_array_list = type { %struct.aws_allocator*, i32, i32, i32, i8* }
%struct.store_byte_from_buffer = type { i32, i8 }
%struct.aws_linked_list_node = type { %struct.aws_linked_list_node*, %struct.aws_linked_list_node* }
%struct.aws_linked_list = type { %struct.aws_linked_list_node, %struct.aws_linked_list_node }
%struct.saved_aws_linked_list_node = type { %struct.aws_linked_list_node*, %struct.aws_linked_list_node*, %struct.aws_linked_list_node* }
%struct.saved_aws_linked_list = type { i32, %struct.aws_linked_list_node*, %struct.aws_linked_list_node*, %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node, [4 x %struct.saved_aws_linked_list_node] }
%struct.aws_string = type { %struct.aws_allocator*, i32, [1 x i8] }
%struct.aws_priority_queue = type { i32 (i8*, i8*)*, %struct.aws_array_list, %struct.aws_array_list }
%struct.aws_ring_buffer = type { %struct.aws_allocator*, i8*, %struct.aws_atomic_var, %struct.aws_atomic_var, i8* }
%struct.aws_atomic_var = type { i8* }
%struct.aws_hash_table = type { %struct.hash_table_state* }
%struct.hash_table_state = type { i64 (i8*)*, i1 (i8*, i8*)*, void (i8*)*, void (i8*)*, %struct.aws_allocator*, i32, i32, i32, i32, double, [0 x %struct.hash_table_entry] }
%struct.hash_table_entry = type { %struct.aws_hash_element, i64 }
%struct.aws_hash_element = type { i8*, i8* }
%struct.aws_hash_iter = type { %struct.aws_hash_table*, %struct.aws_hash_element, i32, i32, i32, i32, i8*, i8* }
%struct.aws_allocator.13 = type { {}*, void (%struct.aws_allocator.13*, i8*)*, i8* (%struct.aws_allocator.13*, i8*, i32, i32)*, i8* (%struct.aws_allocator.13*, i32, i32)*, i8* }

@s_tolower_table = internal constant [256 x i8] c"\00\01\02\03\04\05\06\07\08\09\0A\0B\0C\0D\0E\0F\10\11\12\13\14\15\16\17\18\19\1A\1B\1C\1D\1E\1F !\22#$%&'()*+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\7F\80\81\82\83\84\85\86\87\88\89\8A\8B\8C\8D\8E\8F\90\91\92\93\94\95\96\97\98\99\9A\9B\9C\9D\9E\9F\A0\A1\A2\A3\A4\A5\A6\A7\A8\A9\AA\AB\AC\AD\AE\AF\B0\B1\B2\B3\B4\B5\B6\B7\B8\B9\BA\BB\BC\BD\BE\BF\C0\C1\C2\C3\C4\C5\C6\C7\C8\C9\CA\CB\CC\CD\CE\CF\D0\D1\D2\D3\D4\D5\D6\D7\D8\D9\DA\DB\DC\DD\DE\DF\E0\E1\E2\E3\E4\E5\E6\E7\E8\E9\EA\EB\EC\ED\EE\EF\F0\F1\F2\F3\F4\F5\F6\F7\F8\F9\FA\FB\FC\FD\FE\FF", align 1, !dbg !0
@.str = private unnamed_addr constant [1 x i8] zeroinitializer, align 1
@.str.1 = private unnamed_addr constant [11 x i8] c"list->data\00", align 1
@.str.2 = private unnamed_addr constant [82 x i8] c"/Users/jorge/Repos/verify-c-common/aws-c-common/include/aws/common/array_list.inl\00", align 1
@.str.3 = private unnamed_addr constant [28 x i8] c"!list->length || list->data\00", align 1
@s_hex_to_num_table = internal constant [256 x i8] c"\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\00\01\02\03\04\05\06\07\08\09\FF\FF\FF\FF\FF\FF\FF\0A\0B\0C\0D\0E\0F\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\0A\0B\0C\0D\0E\0F\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF\FF", align 1, !dbg !193
@s_null_terminator_cursor = internal global %struct.aws_byte_cursor { i32 1, i8* getelementptr inbounds ([2 x i8], [2 x i8]* @.str.4, i32 0, i32 0) }, align 4, !dbg !199
@.str.4 = private unnamed_addr constant [2 x i8] zeroinitializer, align 1
@s_allocator_static = internal global %struct.aws_allocator { i8* (%struct.aws_allocator*, i32)* @s_malloc_allocator, void (%struct.aws_allocator*, i8*)* @s_free_allocator, i8* (%struct.aws_allocator*, i8*, i32, i32)* null, i8* (%struct.aws_allocator*, i32, i32)* null, i8* null }, align 4, !dbg !201
@tl_last_error = internal thread_local global i32 0, align 4, !dbg !240

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_init(%struct.aws_byte_buf* %0, %struct.aws_allocator* %1, i32 %2) #0 !dbg !650 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca %struct.aws_allocator*, align 4
  %7 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !654, metadata !DIExpression()), !dbg !661
  store %struct.aws_allocator* %1, %struct.aws_allocator** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator** %6, metadata !655, metadata !DIExpression()), !dbg !662
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !656, metadata !DIExpression()), !dbg !665
  %8 = load i32, i32* %7, align 4, !dbg !666, !tbaa !663
  %9 = icmp eq i32 %8, 0, !dbg !667
  br i1 %9, label %10, label %11, !dbg !668

10:                                               ; preds = %3
  br label %15, !dbg !668

11:                                               ; preds = %3
  %12 = load %struct.aws_allocator*, %struct.aws_allocator** %6, align 4, !dbg !669, !tbaa !657
  %13 = load i32, i32* %7, align 4, !dbg !670, !tbaa !663
  %14 = call i8* bitcast (i8* (%struct.aws_allocator.13*, i32)* @aws_mem_acquire to i8* (%struct.aws_allocator*, i32)*)(%struct.aws_allocator* %12, i32 %13) #17, !dbg !671
  br label %15, !dbg !668

15:                                               ; preds = %11, %10
  %16 = phi i8* [ null, %10 ], [ %14, %11 ], !dbg !668
  %17 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !672, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %17, i32 0, i32 1, !dbg !673
  store i8* %16, i8** %18, align 4, !dbg !674, !tbaa !675
  %19 = load i32, i32* %7, align 4, !dbg !677, !tbaa !663
  %20 = icmp ne i32 %19, 0, !dbg !679
  br i1 %20, label %21, label %35, !dbg !680

21:                                               ; preds = %15
  %22 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !681, !tbaa !657
  %23 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %22, i32 0, i32 1, !dbg !682
  %24 = load i8*, i8** %23, align 4, !dbg !682, !tbaa !675
  %25 = icmp eq i8* %24, null, !dbg !683
  br i1 %25, label %26, label %35, !dbg !684

26:                                               ; preds = %21
  br label %27, !dbg !685

27:                                               ; preds = %26
  %28 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !687, !tbaa !657
  %29 = bitcast %struct.aws_byte_buf* %28 to i8*, !dbg !687
  %30 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !687, !tbaa !657
  %31 = bitcast %struct.aws_byte_buf* %30 to i8*, !dbg !687
  %32 = call i32 @llvm.objectsize.i32.p0i8(i8* %31, i1 false, i1 true, i1 false), !dbg !687
  %33 = call i8* @__memset_chk(i8* %29, i32 0, i32 16, i32 %32) #18, !dbg !687
  br label %34, !dbg !687

34:                                               ; preds = %27
  store i32 -1, i32* %4, align 4, !dbg !689
  br label %44, !dbg !689

35:                                               ; preds = %21, %15
  %36 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !690, !tbaa !657
  %37 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %36, i32 0, i32 0, !dbg !691
  store i32 0, i32* %37, align 4, !dbg !692, !tbaa !693
  %38 = load i32, i32* %7, align 4, !dbg !694, !tbaa !663
  %39 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !695, !tbaa !657
  %40 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %39, i32 0, i32 2, !dbg !696
  store i32 %38, i32* %40, align 4, !dbg !697, !tbaa !698
  %41 = load %struct.aws_allocator*, %struct.aws_allocator** %6, align 4, !dbg !699, !tbaa !657
  %42 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !700, !tbaa !657
  %43 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %42, i32 0, i32 3, !dbg !701
  store %struct.aws_allocator* %41, %struct.aws_allocator** %43, align 4, !dbg !702, !tbaa !703
  store i32 0, i32* %4, align 4, !dbg !704
  br label %44, !dbg !704

44:                                               ; preds = %35, %34
  %45 = load i32, i32* %4, align 4, !dbg !705
  ret i32 %45, !dbg !705
}

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare void @llvm.dbg.declare(metadata, metadata, metadata) #1

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare i32 @llvm.objectsize.i32.p0i8(i8*, i1 immarg, i1 immarg, i1 immarg) #1

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_init_copy(%struct.aws_byte_buf* %0, %struct.aws_allocator* %1, %struct.aws_byte_buf* %2) #0 !dbg !706 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca %struct.aws_allocator*, align 4
  %7 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !710, metadata !DIExpression()), !dbg !713
  store %struct.aws_allocator* %1, %struct.aws_allocator** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator** %6, metadata !711, metadata !DIExpression()), !dbg !714
  store %struct.aws_byte_buf* %2, %struct.aws_byte_buf** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %7, metadata !712, metadata !DIExpression()), !dbg !715
  br label %8, !dbg !716

8:                                                ; preds = %3
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %7, align 4, !dbg !717, !tbaa !657
  %10 = call zeroext i1 @aws_byte_buf_is_valid(%struct.aws_byte_buf* %9) #17, !dbg !717
  br i1 %10, label %13, label %11, !dbg !720

11:                                               ; preds = %8
  %12 = call i32 @aws_raise_error(i32 34) #17, !dbg !721
  store i32 %12, i32* %4, align 4, !dbg !721
  br label %74, !dbg !721

13:                                               ; preds = %8
  br label %14, !dbg !720

14:                                               ; preds = %13
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %7, align 4, !dbg !723, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 1, !dbg !725
  %17 = load i8*, i8** %16, align 4, !dbg !725, !tbaa !675
  %18 = icmp ne i8* %17, null, !dbg !723
  br i1 %18, label %31, label %19, !dbg !726

19:                                               ; preds = %14
  br label %20, !dbg !727

20:                                               ; preds = %19
  %21 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !729, !tbaa !657
  %22 = bitcast %struct.aws_byte_buf* %21 to i8*, !dbg !729
  %23 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !729, !tbaa !657
  %24 = bitcast %struct.aws_byte_buf* %23 to i8*, !dbg !729
  %25 = call i32 @llvm.objectsize.i32.p0i8(i8* %24, i1 false, i1 true, i1 false), !dbg !729
  %26 = call i8* @__memset_chk(i8* %22, i32 0, i32 16, i32 %25) #18, !dbg !729
  br label %27, !dbg !729

27:                                               ; preds = %20
  %28 = load %struct.aws_allocator*, %struct.aws_allocator** %6, align 4, !dbg !731, !tbaa !657
  %29 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !732, !tbaa !657
  %30 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %29, i32 0, i32 3, !dbg !733
  store %struct.aws_allocator* %28, %struct.aws_allocator** %30, align 4, !dbg !734, !tbaa !703
  store i32 0, i32* %4, align 4, !dbg !735
  br label %74, !dbg !735

31:                                               ; preds = %14
  %32 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !736, !tbaa !657
  %33 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %7, align 4, !dbg !737, !tbaa !657
  %34 = bitcast %struct.aws_byte_buf* %32 to i8*, !dbg !738
  %35 = bitcast %struct.aws_byte_buf* %33 to i8*, !dbg !738
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %34, i8* align 4 %35, i32 16, i1 false), !dbg !738, !tbaa.struct !739
  %36 = load %struct.aws_allocator*, %struct.aws_allocator** %6, align 4, !dbg !740, !tbaa !657
  %37 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !741, !tbaa !657
  %38 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %37, i32 0, i32 3, !dbg !742
  store %struct.aws_allocator* %36, %struct.aws_allocator** %38, align 4, !dbg !743, !tbaa !703
  %39 = load %struct.aws_allocator*, %struct.aws_allocator** %6, align 4, !dbg !744, !tbaa !657
  %40 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %7, align 4, !dbg !745, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %40, i32 0, i32 2, !dbg !746
  %42 = load i32, i32* %41, align 4, !dbg !746, !tbaa !698
  %43 = call i8* bitcast (i8* (%struct.aws_allocator.13*, i32)* @aws_mem_acquire to i8* (%struct.aws_allocator*, i32)*)(%struct.aws_allocator* %39, i32 %42) #17, !dbg !747
  %44 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !748, !tbaa !657
  %45 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %44, i32 0, i32 1, !dbg !749
  store i8* %43, i8** %45, align 4, !dbg !750, !tbaa !675
  %46 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !751, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %46, i32 0, i32 1, !dbg !753
  %48 = load i8*, i8** %47, align 4, !dbg !753, !tbaa !675
  %49 = icmp eq i8* %48, null, !dbg !754
  br i1 %49, label %50, label %59, !dbg !755

50:                                               ; preds = %31
  br label %51, !dbg !756

51:                                               ; preds = %50
  %52 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !758, !tbaa !657
  %53 = bitcast %struct.aws_byte_buf* %52 to i8*, !dbg !758
  %54 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !758, !tbaa !657
  %55 = bitcast %struct.aws_byte_buf* %54 to i8*, !dbg !758
  %56 = call i32 @llvm.objectsize.i32.p0i8(i8* %55, i1 false, i1 true, i1 false), !dbg !758
  %57 = call i8* @__memset_chk(i8* %53, i32 0, i32 16, i32 %56) #18, !dbg !758
  br label %58, !dbg !758

58:                                               ; preds = %51
  store i32 -1, i32* %4, align 4, !dbg !760
  br label %74, !dbg !760

59:                                               ; preds = %31
  %60 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !761, !tbaa !657
  %61 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %60, i32 0, i32 1, !dbg !761
  %62 = load i8*, i8** %61, align 4, !dbg !761, !tbaa !675
  %63 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %7, align 4, !dbg !761, !tbaa !657
  %64 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %63, i32 0, i32 1, !dbg !761
  %65 = load i8*, i8** %64, align 4, !dbg !761, !tbaa !675
  %66 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %7, align 4, !dbg !761, !tbaa !657
  %67 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %66, i32 0, i32 0, !dbg !761
  %68 = load i32, i32* %67, align 4, !dbg !761, !tbaa !693
  %69 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !761, !tbaa !657
  %70 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %69, i32 0, i32 1, !dbg !761
  %71 = load i8*, i8** %70, align 4, !dbg !761, !tbaa !675
  %72 = call i32 @llvm.objectsize.i32.p0i8(i8* %71, i1 false, i1 true, i1 false), !dbg !761
  %73 = call i8* @__memcpy_chk(i8* %62, i8* %65, i32 %68, i32 %72) #18, !dbg !761
  store i32 0, i32* %4, align 4, !dbg !762
  br label %74, !dbg !762

74:                                               ; preds = %59, %58, %27, %11
  %75 = load i32, i32* %4, align 4, !dbg !763
  ret i32 %75, !dbg !763
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_is_valid(%struct.aws_byte_buf* %0) #0 !dbg !764 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !769, metadata !DIExpression()), !dbg !770
  %3 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !771, !tbaa !657
  %4 = icmp ne %struct.aws_byte_buf* %3, null, !dbg !772
  br i1 %4, label %5, label %49, !dbg !773

5:                                                ; preds = %1
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !774, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %6, i32 0, i32 2, !dbg !775
  %8 = load i32, i32* %7, align 4, !dbg !775, !tbaa !698
  %9 = icmp eq i32 %8, 0, !dbg !776
  br i1 %9, label %10, label %20, !dbg !777

10:                                               ; preds = %5
  %11 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !778, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %11, i32 0, i32 0, !dbg !779
  %13 = load i32, i32* %12, align 4, !dbg !779, !tbaa !693
  %14 = icmp eq i32 %13, 0, !dbg !780
  br i1 %14, label %15, label %20, !dbg !781

15:                                               ; preds = %10
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !782, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %16, i32 0, i32 1, !dbg !783
  %18 = load i8*, i8** %17, align 4, !dbg !783, !tbaa !675
  %19 = icmp eq i8* %18, null, !dbg !784
  br i1 %19, label %47, label %20, !dbg !785

20:                                               ; preds = %15, %10, %5
  %21 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !786, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %21, i32 0, i32 2, !dbg !787
  %23 = load i32, i32* %22, align 4, !dbg !787, !tbaa !698
  %24 = icmp ugt i32 %23, 0, !dbg !788
  br i1 %24, label %25, label %45, !dbg !789

25:                                               ; preds = %20
  %26 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !790, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %26, i32 0, i32 0, !dbg !791
  %28 = load i32, i32* %27, align 4, !dbg !791, !tbaa !693
  %29 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !792, !tbaa !657
  %30 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %29, i32 0, i32 2, !dbg !793
  %31 = load i32, i32* %30, align 4, !dbg !793, !tbaa !698
  %32 = icmp ule i32 %28, %31, !dbg !794
  br i1 %32, label %33, label %45, !dbg !795

33:                                               ; preds = %25
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !796, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %34, i32 0, i32 2, !dbg !796
  %36 = load i32, i32* %35, align 4, !dbg !796, !tbaa !698
  %37 = icmp eq i32 %36, 0, !dbg !796
  br i1 %37, label %43, label %38, !dbg !796

38:                                               ; preds = %33
  %39 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !796, !tbaa !657
  %40 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %39, i32 0, i32 1, !dbg !796
  %41 = load i8*, i8** %40, align 4, !dbg !796, !tbaa !675
  %42 = icmp ne i8* %41, null, !dbg !796
  br label %43, !dbg !796

43:                                               ; preds = %38, %33
  %44 = phi i1 [ true, %33 ], [ %42, %38 ]
  br label %45

45:                                               ; preds = %43, %25, %20
  %46 = phi i1 [ false, %25 ], [ false, %20 ], [ %44, %43 ], !dbg !797
  br label %47, !dbg !785

47:                                               ; preds = %45, %15
  %48 = phi i1 [ true, %15 ], [ %46, %45 ]
  br label %49

49:                                               ; preds = %47, %1
  %50 = phi i1 [ false, %1 ], [ %48, %47 ], !dbg !797
  ret i1 %50, !dbg !798
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_raise_error(i32 %0) #2 !dbg !799 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %2, metadata !804, metadata !DIExpression()), !dbg !807
  %3 = load i32, i32* %2, align 4, !dbg !808, !tbaa !805
  call void @aws_raise_error_private(i32 %3) #17, !dbg !809
  ret i32 -1, !dbg !810
}

; Function Attrs: argmemonly nofree nounwind willreturn
declare void @llvm.memcpy.p0i8.p0i8.i32(i8* noalias nocapture writeonly, i8* noalias nocapture readonly, i32, i1 immarg) #3

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_is_valid(%struct.aws_byte_cursor* %0) #0 !dbg !811 {
  %2 = alloca %struct.aws_byte_cursor*, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %2, metadata !815, metadata !DIExpression()), !dbg !816
  %3 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !817, !tbaa !657
  %4 = icmp ne %struct.aws_byte_cursor* %3, null, !dbg !818
  br i1 %4, label %5, label %36, !dbg !819

5:                                                ; preds = %1
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !820, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 0, !dbg !821
  %8 = load i32, i32* %7, align 4, !dbg !821, !tbaa !822
  %9 = icmp eq i32 %8, 0, !dbg !824
  br i1 %9, label %34, label %10, !dbg !825

10:                                               ; preds = %5
  %11 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !826, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %11, i32 0, i32 0, !dbg !827
  %13 = load i32, i32* %12, align 4, !dbg !827, !tbaa !822
  %14 = icmp ugt i32 %13, 0, !dbg !828
  br i1 %14, label %15, label %32, !dbg !829

15:                                               ; preds = %10
  %16 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !830, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %16, i32 0, i32 1, !dbg !831
  %18 = load i8*, i8** %17, align 4, !dbg !831, !tbaa !832
  %19 = icmp ne i8* %18, null, !dbg !830
  br i1 %19, label %20, label %32, !dbg !833

20:                                               ; preds = %15
  %21 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !834, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %21, i32 0, i32 0, !dbg !834
  %23 = load i32, i32* %22, align 4, !dbg !834, !tbaa !822
  %24 = icmp eq i32 %23, 0, !dbg !834
  br i1 %24, label %30, label %25, !dbg !834

25:                                               ; preds = %20
  %26 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !834, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %26, i32 0, i32 1, !dbg !834
  %28 = load i8*, i8** %27, align 4, !dbg !834, !tbaa !832
  %29 = icmp ne i8* %28, null, !dbg !834
  br label %30, !dbg !834

30:                                               ; preds = %25, %20
  %31 = phi i1 [ true, %20 ], [ %29, %25 ]
  br label %32

32:                                               ; preds = %30, %15, %10
  %33 = phi i1 [ false, %15 ], [ false, %10 ], [ %31, %30 ], !dbg !835
  br label %34, !dbg !825

34:                                               ; preds = %32, %5
  %35 = phi i1 [ true, %5 ], [ %33, %32 ]
  br label %36

36:                                               ; preds = %34, %1
  %37 = phi i1 [ false, %1 ], [ %35, %34 ], !dbg !835
  ret i1 %37, !dbg !836
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_reset(%struct.aws_byte_buf* %0, i1 zeroext %1) #0 !dbg !837 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !841, metadata !DIExpression()), !dbg !843
  %5 = zext i1 %1 to i8
  store i8 %5, i8* %4, align 1, !tbaa !844
  call void @llvm.dbg.declare(metadata i8* %4, metadata !842, metadata !DIExpression()), !dbg !846
  %6 = load i8, i8* %4, align 1, !dbg !847, !tbaa !844, !range !849
  %7 = trunc i8 %6 to i1, !dbg !847
  br i1 %7, label %8, label %10, !dbg !850

8:                                                ; preds = %2
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !851, !tbaa !657
  call void @aws_byte_buf_secure_zero(%struct.aws_byte_buf* %9) #17, !dbg !853
  br label %10, !dbg !854

10:                                               ; preds = %8, %2
  %11 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !855, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %11, i32 0, i32 0, !dbg !856
  store i32 0, i32* %12, align 4, !dbg !857, !tbaa !693
  ret void, !dbg !858
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_secure_zero(%struct.aws_byte_buf* %0) #0 !dbg !859 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !861, metadata !DIExpression()), !dbg !862
  %3 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !863, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %3, i32 0, i32 1, !dbg !865
  %5 = load i8*, i8** %4, align 4, !dbg !865, !tbaa !675
  %6 = icmp ne i8* %5, null, !dbg !863
  br i1 %6, label %7, label %14, !dbg !866

7:                                                ; preds = %1
  %8 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !867, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %8, i32 0, i32 1, !dbg !869
  %10 = load i8*, i8** %9, align 4, !dbg !869, !tbaa !675
  %11 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !870, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %11, i32 0, i32 2, !dbg !871
  %13 = load i32, i32* %12, align 4, !dbg !871, !tbaa !698
  call void @aws_secure_zero(i8* %10, i32 %13) #17, !dbg !872
  br label %14, !dbg !873

14:                                               ; preds = %7, %1
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !874, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 0, !dbg !875
  store i32 0, i32* %16, align 4, !dbg !876, !tbaa !693
  ret void, !dbg !877
}

declare !dbg !114 void @aws_secure_zero(i8*, i32) #4

; Function Attrs: nounwind ssp
define void @aws_byte_buf_clean_up(%struct.aws_byte_buf* %0) #0 !dbg !878 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !880, metadata !DIExpression()), !dbg !881
  %3 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !882, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %3, i32 0, i32 3, !dbg !884
  %5 = load %struct.aws_allocator*, %struct.aws_allocator** %4, align 4, !dbg !884, !tbaa !703
  %6 = icmp ne %struct.aws_allocator* %5, null, !dbg !882
  br i1 %6, label %7, label %19, !dbg !885

7:                                                ; preds = %1
  %8 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !886, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %8, i32 0, i32 1, !dbg !887
  %10 = load i8*, i8** %9, align 4, !dbg !887, !tbaa !675
  %11 = icmp ne i8* %10, null, !dbg !886
  br i1 %11, label %12, label %19, !dbg !888

12:                                               ; preds = %7
  %13 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !889, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %13, i32 0, i32 3, !dbg !891
  %15 = load %struct.aws_allocator*, %struct.aws_allocator** %14, align 4, !dbg !891, !tbaa !703
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !892, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %16, i32 0, i32 1, !dbg !893
  %18 = load i8*, i8** %17, align 4, !dbg !893, !tbaa !675
  call void bitcast (void (%struct.aws_allocator.13*, i8*)* @aws_mem_release to void (%struct.aws_allocator*, i8*)*)(%struct.aws_allocator* %15, i8* %18) #17, !dbg !894
  br label %19, !dbg !895

19:                                               ; preds = %12, %7, %1
  %20 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !896, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %20, i32 0, i32 3, !dbg !897
  store %struct.aws_allocator* null, %struct.aws_allocator** %21, align 4, !dbg !898, !tbaa !703
  %22 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !899, !tbaa !657
  %23 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %22, i32 0, i32 1, !dbg !900
  store i8* null, i8** %23, align 4, !dbg !901, !tbaa !675
  %24 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !902, !tbaa !657
  %25 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %24, i32 0, i32 0, !dbg !903
  store i32 0, i32* %25, align 4, !dbg !904, !tbaa !693
  %26 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !905, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %26, i32 0, i32 2, !dbg !906
  store i32 0, i32* %27, align 4, !dbg !907, !tbaa !698
  ret void, !dbg !908
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_clean_up_secure(%struct.aws_byte_buf* %0) #0 !dbg !909 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !911, metadata !DIExpression()), !dbg !912
  %3 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !913, !tbaa !657
  call void @aws_byte_buf_secure_zero(%struct.aws_byte_buf* %3) #17, !dbg !914
  %4 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !915, !tbaa !657
  call void @aws_byte_buf_clean_up(%struct.aws_byte_buf* %4) #17, !dbg !916
  ret void, !dbg !917
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_eq(%struct.aws_byte_buf* %0, %struct.aws_byte_buf* %1) #0 !dbg !918 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !922, metadata !DIExpression()), !dbg !925
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !923, metadata !DIExpression()), !dbg !926
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !927
  call void @llvm.dbg.declare(metadata i8* %5, metadata !924, metadata !DIExpression()), !dbg !928
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !929, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %6, i32 0, i32 1, !dbg !930
  %8 = load i8*, i8** %7, align 4, !dbg !930, !tbaa !675
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !931, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 0, !dbg !932
  %11 = load i32, i32* %10, align 4, !dbg !932, !tbaa !693
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !933, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 1, !dbg !934
  %14 = load i8*, i8** %13, align 4, !dbg !934, !tbaa !675
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !935, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 0, !dbg !936
  %17 = load i32, i32* %16, align 4, !dbg !936, !tbaa !693
  %18 = call zeroext i1 @aws_array_eq(i8* %8, i32 %11, i8* %14, i32 %17) #17, !dbg !937
  %19 = zext i1 %18 to i8, !dbg !928
  store i8 %19, i8* %5, align 1, !dbg !928, !tbaa !844
  %20 = load i8, i8* %5, align 1, !dbg !938, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !938
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !939
  ret i1 %21, !dbg !940
}

; Function Attrs: argmemonly nofree nosync nounwind willreturn
declare void @llvm.lifetime.start.p0i8(i64 immarg, i8* nocapture) #5

; Function Attrs: nounwind ssp
define zeroext i1 @aws_array_eq(i8* %0, i32 %1, i8* %2, i32 %3) #0 !dbg !941 {
  %5 = alloca i1, align 1
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i32, align 4
  store i8* %0, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !947, metadata !DIExpression()), !dbg !951
  store i32 %1, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !948, metadata !DIExpression()), !dbg !952
  store i8* %2, i8** %8, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %8, metadata !949, metadata !DIExpression()), !dbg !953
  store i32 %3, i32* %9, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %9, metadata !950, metadata !DIExpression()), !dbg !954
  %10 = load i32, i32* %7, align 4, !dbg !955, !tbaa !663
  %11 = load i32, i32* %9, align 4, !dbg !957, !tbaa !663
  %12 = icmp ne i32 %10, %11, !dbg !958
  br i1 %12, label %13, label %14, !dbg !959

13:                                               ; preds = %4
  store i1 false, i1* %5, align 1, !dbg !960
  br label %25, !dbg !960

14:                                               ; preds = %4
  %15 = load i32, i32* %7, align 4, !dbg !962, !tbaa !663
  %16 = icmp eq i32 %15, 0, !dbg !964
  br i1 %16, label %17, label %18, !dbg !965

17:                                               ; preds = %14
  store i1 true, i1* %5, align 1, !dbg !966
  br label %25, !dbg !966

18:                                               ; preds = %14
  %19 = load i8*, i8** %6, align 4, !dbg !968, !tbaa !657
  %20 = load i8*, i8** %8, align 4, !dbg !969, !tbaa !657
  %21 = load i32, i32* %7, align 4, !dbg !970, !tbaa !663
  %22 = call i32 @memcmp(i8* %19, i8* %20, i32 %21) #17, !dbg !971
  %23 = icmp ne i32 %22, 0, !dbg !972
  %24 = xor i1 %23, true, !dbg !972
  store i1 %24, i1* %5, align 1, !dbg !973
  br label %25, !dbg !973

25:                                               ; preds = %18, %17, %13
  %26 = load i1, i1* %5, align 1, !dbg !974
  ret i1 %26, !dbg !974
}

; Function Attrs: argmemonly nofree nosync nounwind willreturn
declare void @llvm.lifetime.end.p0i8(i64 immarg, i8* nocapture) #5

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_eq_ignore_case(%struct.aws_byte_buf* %0, %struct.aws_byte_buf* %1) #0 !dbg !975 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !977, metadata !DIExpression()), !dbg !980
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !978, metadata !DIExpression()), !dbg !981
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !982
  call void @llvm.dbg.declare(metadata i8* %5, metadata !979, metadata !DIExpression()), !dbg !983
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !984, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %6, i32 0, i32 1, !dbg !985
  %8 = load i8*, i8** %7, align 4, !dbg !985, !tbaa !675
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !986, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 0, !dbg !987
  %11 = load i32, i32* %10, align 4, !dbg !987, !tbaa !693
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !988, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 1, !dbg !989
  %14 = load i8*, i8** %13, align 4, !dbg !989, !tbaa !675
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !990, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 0, !dbg !991
  %17 = load i32, i32* %16, align 4, !dbg !991, !tbaa !693
  %18 = call zeroext i1 @aws_array_eq_ignore_case(i8* %8, i32 %11, i8* %14, i32 %17) #17, !dbg !992
  %19 = zext i1 %18 to i8, !dbg !983
  store i8 %19, i8* %5, align 1, !dbg !983, !tbaa !844
  %20 = load i8, i8* %5, align 1, !dbg !993, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !993
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !994
  ret i1 %21, !dbg !995
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_array_eq_ignore_case(i8* %0, i32 %1, i8* %2, i32 %3) #0 !dbg !996 {
  %5 = alloca i1, align 1
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i32, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i8*, align 4
  %12 = alloca i32, align 4
  %13 = alloca i32, align 4
  store i8* %0, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !998, metadata !DIExpression()), !dbg !1006
  store i32 %1, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !999, metadata !DIExpression()), !dbg !1007
  store i8* %2, i8** %8, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %8, metadata !1000, metadata !DIExpression()), !dbg !1008
  store i32 %3, i32* %9, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %9, metadata !1001, metadata !DIExpression()), !dbg !1009
  %14 = load i32, i32* %7, align 4, !dbg !1010, !tbaa !663
  %15 = load i32, i32* %9, align 4, !dbg !1012, !tbaa !663
  %16 = icmp ne i32 %14, %15, !dbg !1013
  br i1 %16, label %17, label %18, !dbg !1014

17:                                               ; preds = %4
  store i1 false, i1* %5, align 1, !dbg !1015
  br label %59, !dbg !1015

18:                                               ; preds = %4
  %19 = bitcast i8** %10 to i8*, !dbg !1017
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %19) #19, !dbg !1017
  call void @llvm.dbg.declare(metadata i8** %10, metadata !1002, metadata !DIExpression()), !dbg !1018
  %20 = load i8*, i8** %6, align 4, !dbg !1019, !tbaa !657
  store i8* %20, i8** %10, align 4, !dbg !1018, !tbaa !657
  %21 = bitcast i8** %11 to i8*, !dbg !1020
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %21) #19, !dbg !1020
  call void @llvm.dbg.declare(metadata i8** %11, metadata !1003, metadata !DIExpression()), !dbg !1021
  %22 = load i8*, i8** %8, align 4, !dbg !1022, !tbaa !657
  store i8* %22, i8** %11, align 4, !dbg !1021, !tbaa !657
  %23 = bitcast i32* %12 to i8*, !dbg !1023
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %23) #19, !dbg !1023
  call void @llvm.dbg.declare(metadata i32* %12, metadata !1004, metadata !DIExpression()), !dbg !1024
  store i32 0, i32* %12, align 4, !dbg !1024, !tbaa !663
  br label %24, !dbg !1023

24:                                               ; preds = %49, %18
  %25 = load i32, i32* %12, align 4, !dbg !1025, !tbaa !663
  %26 = load i32, i32* %7, align 4, !dbg !1027, !tbaa !663
  %27 = icmp ult i32 %25, %26, !dbg !1028
  br i1 %27, label %29, label %28, !dbg !1029

28:                                               ; preds = %24
  store i32 2, i32* %13, align 4
  br label %52, !dbg !1029

29:                                               ; preds = %24
  %30 = load i8*, i8** %10, align 4, !dbg !1030, !tbaa !657
  %31 = load i32, i32* %12, align 4, !dbg !1033, !tbaa !663
  %32 = getelementptr inbounds i8, i8* %30, i32 %31, !dbg !1030
  %33 = load i8, i8* %32, align 1, !dbg !1030, !tbaa !1034
  %34 = zext i8 %33 to i32, !dbg !1035
  %35 = getelementptr inbounds [256 x i8], [256 x i8]* @s_tolower_table, i32 0, i32 %34, !dbg !1035
  %36 = load i8, i8* %35, align 1, !dbg !1035, !tbaa !1034
  %37 = zext i8 %36 to i32, !dbg !1035
  %38 = load i8*, i8** %11, align 4, !dbg !1036, !tbaa !657
  %39 = load i32, i32* %12, align 4, !dbg !1037, !tbaa !663
  %40 = getelementptr inbounds i8, i8* %38, i32 %39, !dbg !1036
  %41 = load i8, i8* %40, align 1, !dbg !1036, !tbaa !1034
  %42 = zext i8 %41 to i32, !dbg !1038
  %43 = getelementptr inbounds [256 x i8], [256 x i8]* @s_tolower_table, i32 0, i32 %42, !dbg !1038
  %44 = load i8, i8* %43, align 1, !dbg !1038, !tbaa !1034
  %45 = zext i8 %44 to i32, !dbg !1038
  %46 = icmp ne i32 %37, %45, !dbg !1039
  br i1 %46, label %47, label %48, !dbg !1040

47:                                               ; preds = %29
  store i1 false, i1* %5, align 1, !dbg !1041
  store i32 1, i32* %13, align 4
  br label %52, !dbg !1041

48:                                               ; preds = %29
  br label %49, !dbg !1043

49:                                               ; preds = %48
  %50 = load i32, i32* %12, align 4, !dbg !1044, !tbaa !663
  %51 = add i32 %50, 1, !dbg !1044
  store i32 %51, i32* %12, align 4, !dbg !1044, !tbaa !663
  br label %24, !dbg !1045, !llvm.loop !1046

52:                                               ; preds = %47, %28
  %53 = bitcast i32* %12 to i8*, !dbg !1045
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %53) #19, !dbg !1045
  %54 = load i32, i32* %13, align 4
  switch i32 %54, label %56 [
    i32 2, label %55
  ]

55:                                               ; preds = %52
  store i1 true, i1* %5, align 1, !dbg !1048
  store i32 1, i32* %13, align 4
  br label %56, !dbg !1048

56:                                               ; preds = %55, %52
  %57 = bitcast i8** %11 to i8*, !dbg !1049
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %57) #19, !dbg !1049
  %58 = bitcast i8** %10 to i8*, !dbg !1049
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %58) #19, !dbg !1049
  br label %59

59:                                               ; preds = %56, %17
  %60 = load i1, i1* %5, align 1, !dbg !1049
  ret i1 %60, !dbg !1049
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_eq_c_str(%struct.aws_byte_buf* %0, i8* %1) #0 !dbg !1050 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !1055, metadata !DIExpression()), !dbg !1058
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !1056, metadata !DIExpression()), !dbg !1059
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !1060
  call void @llvm.dbg.declare(metadata i8* %5, metadata !1057, metadata !DIExpression()), !dbg !1061
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !1062, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %6, i32 0, i32 1, !dbg !1063
  %8 = load i8*, i8** %7, align 4, !dbg !1063, !tbaa !675
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !1064, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 0, !dbg !1065
  %11 = load i32, i32* %10, align 4, !dbg !1065, !tbaa !693
  %12 = load i8*, i8** %4, align 4, !dbg !1066, !tbaa !657
  %13 = call zeroext i1 @aws_array_eq_c_str(i8* %8, i32 %11, i8* %12) #17, !dbg !1067
  %14 = zext i1 %13 to i8, !dbg !1061
  store i8 %14, i8* %5, align 1, !dbg !1061, !tbaa !844
  %15 = load i8, i8* %5, align 1, !dbg !1068, !tbaa !844, !range !849
  %16 = trunc i8 %15 to i1, !dbg !1068
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !1069
  ret i1 %16, !dbg !1070
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_array_eq_c_str(i8* %0, i32 %1, i8* %2) #0 !dbg !1071 {
  %4 = alloca i1, align 1
  %5 = alloca i8*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8*, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i32, align 4
  %11 = alloca i32, align 4
  %12 = alloca i8, align 1
  store i8* %0, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !1075, metadata !DIExpression()), !dbg !1085
  store i32 %1, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !1076, metadata !DIExpression()), !dbg !1086
  store i8* %2, i8** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %7, metadata !1077, metadata !DIExpression()), !dbg !1087
  %13 = bitcast i8** %8 to i8*, !dbg !1088
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %13) #19, !dbg !1088
  call void @llvm.dbg.declare(metadata i8** %8, metadata !1078, metadata !DIExpression()), !dbg !1089
  %14 = load i8*, i8** %5, align 4, !dbg !1090, !tbaa !657
  store i8* %14, i8** %8, align 4, !dbg !1089, !tbaa !657
  %15 = bitcast i8** %9 to i8*, !dbg !1091
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !1091
  call void @llvm.dbg.declare(metadata i8** %9, metadata !1079, metadata !DIExpression()), !dbg !1092
  %16 = load i8*, i8** %7, align 4, !dbg !1093, !tbaa !657
  store i8* %16, i8** %9, align 4, !dbg !1092, !tbaa !657
  %17 = bitcast i32* %10 to i8*, !dbg !1094
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %17) #19, !dbg !1094
  call void @llvm.dbg.declare(metadata i32* %10, metadata !1080, metadata !DIExpression()), !dbg !1095
  store i32 0, i32* %10, align 4, !dbg !1095, !tbaa !663
  br label %18, !dbg !1094

18:                                               ; preds = %46, %3
  %19 = load i32, i32* %10, align 4, !dbg !1096, !tbaa !663
  %20 = load i32, i32* %6, align 4, !dbg !1097, !tbaa !663
  %21 = icmp ult i32 %19, %20, !dbg !1098
  br i1 %21, label %23, label %22, !dbg !1099

22:                                               ; preds = %18
  store i32 2, i32* %11, align 4
  br label %49, !dbg !1099

23:                                               ; preds = %18
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %12) #19, !dbg !1100
  call void @llvm.dbg.declare(metadata i8* %12, metadata !1082, metadata !DIExpression()), !dbg !1101
  %24 = load i8*, i8** %9, align 4, !dbg !1102, !tbaa !657
  %25 = load i32, i32* %10, align 4, !dbg !1103, !tbaa !663
  %26 = getelementptr inbounds i8, i8* %24, i32 %25, !dbg !1102
  %27 = load i8, i8* %26, align 1, !dbg !1102, !tbaa !1034
  store i8 %27, i8* %12, align 1, !dbg !1101, !tbaa !1034
  %28 = load i8, i8* %12, align 1, !dbg !1104, !tbaa !1034
  %29 = zext i8 %28 to i32, !dbg !1104
  %30 = icmp eq i32 %29, 0, !dbg !1106
  br i1 %30, label %31, label %32, !dbg !1107

31:                                               ; preds = %23
  store i1 false, i1* %4, align 1, !dbg !1108
  store i32 1, i32* %11, align 4
  br label %43, !dbg !1108

32:                                               ; preds = %23
  %33 = load i8*, i8** %8, align 4, !dbg !1110, !tbaa !657
  %34 = load i32, i32* %10, align 4, !dbg !1112, !tbaa !663
  %35 = getelementptr inbounds i8, i8* %33, i32 %34, !dbg !1110
  %36 = load i8, i8* %35, align 1, !dbg !1110, !tbaa !1034
  %37 = zext i8 %36 to i32, !dbg !1110
  %38 = load i8, i8* %12, align 1, !dbg !1113, !tbaa !1034
  %39 = zext i8 %38 to i32, !dbg !1113
  %40 = icmp ne i32 %37, %39, !dbg !1114
  br i1 %40, label %41, label %42, !dbg !1115

41:                                               ; preds = %32
  store i1 false, i1* %4, align 1, !dbg !1116
  store i32 1, i32* %11, align 4
  br label %43, !dbg !1116

42:                                               ; preds = %32
  store i32 0, i32* %11, align 4, !dbg !1118
  br label %43, !dbg !1118

43:                                               ; preds = %42, %41, %31
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %12) #19, !dbg !1118
  %44 = load i32, i32* %11, align 4
  switch i32 %44, label %49 [
    i32 0, label %45
  ]

45:                                               ; preds = %43
  br label %46, !dbg !1119

46:                                               ; preds = %45
  %47 = load i32, i32* %10, align 4, !dbg !1120, !tbaa !663
  %48 = add i32 %47, 1, !dbg !1120
  store i32 %48, i32* %10, align 4, !dbg !1120, !tbaa !663
  br label %18, !dbg !1121, !llvm.loop !1122

49:                                               ; preds = %43, %22
  %50 = bitcast i32* %10 to i8*, !dbg !1121
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %50) #19, !dbg !1121
  %51 = load i32, i32* %11, align 4
  switch i32 %51, label %59 [
    i32 2, label %52
  ]

52:                                               ; preds = %49
  %53 = load i8*, i8** %9, align 4, !dbg !1124, !tbaa !657
  %54 = load i32, i32* %6, align 4, !dbg !1125, !tbaa !663
  %55 = getelementptr inbounds i8, i8* %53, i32 %54, !dbg !1124
  %56 = load i8, i8* %55, align 1, !dbg !1124, !tbaa !1034
  %57 = zext i8 %56 to i32, !dbg !1124
  %58 = icmp eq i32 %57, 0, !dbg !1126
  store i1 %58, i1* %4, align 1, !dbg !1127
  store i32 1, i32* %11, align 4
  br label %59, !dbg !1127

59:                                               ; preds = %52, %49
  %60 = bitcast i8** %9 to i8*, !dbg !1128
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %60) #19, !dbg !1128
  %61 = bitcast i8** %8 to i8*, !dbg !1128
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %61) #19, !dbg !1128
  %62 = load i1, i1* %4, align 1, !dbg !1128
  ret i1 %62, !dbg !1128
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_eq_c_str_ignore_case(%struct.aws_byte_buf* %0, i8* %1) #0 !dbg !1129 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !1131, metadata !DIExpression()), !dbg !1134
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !1132, metadata !DIExpression()), !dbg !1135
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !1136
  call void @llvm.dbg.declare(metadata i8* %5, metadata !1133, metadata !DIExpression()), !dbg !1137
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !1138, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %6, i32 0, i32 1, !dbg !1139
  %8 = load i8*, i8** %7, align 4, !dbg !1139, !tbaa !675
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !1140, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 0, !dbg !1141
  %11 = load i32, i32* %10, align 4, !dbg !1141, !tbaa !693
  %12 = load i8*, i8** %4, align 4, !dbg !1142, !tbaa !657
  %13 = call zeroext i1 @aws_array_eq_c_str_ignore_case(i8* %8, i32 %11, i8* %12) #17, !dbg !1143
  %14 = zext i1 %13 to i8, !dbg !1137
  store i8 %14, i8* %5, align 1, !dbg !1137, !tbaa !844
  %15 = load i8, i8* %5, align 1, !dbg !1144, !tbaa !844, !range !849
  %16 = trunc i8 %15 to i1, !dbg !1144
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !1145
  ret i1 %16, !dbg !1146
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_array_eq_c_str_ignore_case(i8* %0, i32 %1, i8* %2) #0 !dbg !1147 {
  %4 = alloca i1, align 1
  %5 = alloca i8*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8*, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i32, align 4
  %11 = alloca i32, align 4
  %12 = alloca i8, align 1
  store i8* %0, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !1149, metadata !DIExpression()), !dbg !1159
  store i32 %1, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !1150, metadata !DIExpression()), !dbg !1160
  store i8* %2, i8** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %7, metadata !1151, metadata !DIExpression()), !dbg !1161
  %13 = bitcast i8** %8 to i8*, !dbg !1162
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %13) #19, !dbg !1162
  call void @llvm.dbg.declare(metadata i8** %8, metadata !1152, metadata !DIExpression()), !dbg !1163
  %14 = load i8*, i8** %5, align 4, !dbg !1164, !tbaa !657
  store i8* %14, i8** %8, align 4, !dbg !1163, !tbaa !657
  %15 = bitcast i8** %9 to i8*, !dbg !1165
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !1165
  call void @llvm.dbg.declare(metadata i8** %9, metadata !1153, metadata !DIExpression()), !dbg !1166
  %16 = load i8*, i8** %7, align 4, !dbg !1167, !tbaa !657
  store i8* %16, i8** %9, align 4, !dbg !1166, !tbaa !657
  %17 = bitcast i32* %10 to i8*, !dbg !1168
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %17) #19, !dbg !1168
  call void @llvm.dbg.declare(metadata i32* %10, metadata !1154, metadata !DIExpression()), !dbg !1169
  store i32 0, i32* %10, align 4, !dbg !1169, !tbaa !663
  br label %18, !dbg !1168

18:                                               ; preds = %52, %3
  %19 = load i32, i32* %10, align 4, !dbg !1170, !tbaa !663
  %20 = load i32, i32* %6, align 4, !dbg !1171, !tbaa !663
  %21 = icmp ult i32 %19, %20, !dbg !1172
  br i1 %21, label %23, label %22, !dbg !1173

22:                                               ; preds = %18
  store i32 2, i32* %11, align 4
  br label %55, !dbg !1173

23:                                               ; preds = %18
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %12) #19, !dbg !1174
  call void @llvm.dbg.declare(metadata i8* %12, metadata !1156, metadata !DIExpression()), !dbg !1175
  %24 = load i8*, i8** %9, align 4, !dbg !1176, !tbaa !657
  %25 = load i32, i32* %10, align 4, !dbg !1177, !tbaa !663
  %26 = getelementptr inbounds i8, i8* %24, i32 %25, !dbg !1176
  %27 = load i8, i8* %26, align 1, !dbg !1176, !tbaa !1034
  store i8 %27, i8* %12, align 1, !dbg !1175, !tbaa !1034
  %28 = load i8, i8* %12, align 1, !dbg !1178, !tbaa !1034
  %29 = zext i8 %28 to i32, !dbg !1178
  %30 = icmp eq i32 %29, 0, !dbg !1180
  br i1 %30, label %31, label %32, !dbg !1181

31:                                               ; preds = %23
  store i1 false, i1* %4, align 1, !dbg !1182
  store i32 1, i32* %11, align 4
  br label %49, !dbg !1182

32:                                               ; preds = %23
  %33 = load i8*, i8** %8, align 4, !dbg !1184, !tbaa !657
  %34 = load i32, i32* %10, align 4, !dbg !1186, !tbaa !663
  %35 = getelementptr inbounds i8, i8* %33, i32 %34, !dbg !1184
  %36 = load i8, i8* %35, align 1, !dbg !1184, !tbaa !1034
  %37 = zext i8 %36 to i32, !dbg !1187
  %38 = getelementptr inbounds [256 x i8], [256 x i8]* @s_tolower_table, i32 0, i32 %37, !dbg !1187
  %39 = load i8, i8* %38, align 1, !dbg !1187, !tbaa !1034
  %40 = zext i8 %39 to i32, !dbg !1187
  %41 = load i8, i8* %12, align 1, !dbg !1188, !tbaa !1034
  %42 = zext i8 %41 to i32, !dbg !1189
  %43 = getelementptr inbounds [256 x i8], [256 x i8]* @s_tolower_table, i32 0, i32 %42, !dbg !1189
  %44 = load i8, i8* %43, align 1, !dbg !1189, !tbaa !1034
  %45 = zext i8 %44 to i32, !dbg !1189
  %46 = icmp ne i32 %40, %45, !dbg !1190
  br i1 %46, label %47, label %48, !dbg !1191

47:                                               ; preds = %32
  store i1 false, i1* %4, align 1, !dbg !1192
  store i32 1, i32* %11, align 4
  br label %49, !dbg !1192

48:                                               ; preds = %32
  store i32 0, i32* %11, align 4, !dbg !1194
  br label %49, !dbg !1194

49:                                               ; preds = %48, %47, %31
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %12) #19, !dbg !1194
  %50 = load i32, i32* %11, align 4
  switch i32 %50, label %55 [
    i32 0, label %51
  ]

51:                                               ; preds = %49
  br label %52, !dbg !1195

52:                                               ; preds = %51
  %53 = load i32, i32* %10, align 4, !dbg !1196, !tbaa !663
  %54 = add i32 %53, 1, !dbg !1196
  store i32 %54, i32* %10, align 4, !dbg !1196, !tbaa !663
  br label %18, !dbg !1197, !llvm.loop !1198

55:                                               ; preds = %49, %22
  %56 = bitcast i32* %10 to i8*, !dbg !1197
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %56) #19, !dbg !1197
  %57 = load i32, i32* %11, align 4
  switch i32 %57, label %65 [
    i32 2, label %58
  ]

58:                                               ; preds = %55
  %59 = load i8*, i8** %9, align 4, !dbg !1200, !tbaa !657
  %60 = load i32, i32* %6, align 4, !dbg !1201, !tbaa !663
  %61 = getelementptr inbounds i8, i8* %59, i32 %60, !dbg !1200
  %62 = load i8, i8* %61, align 1, !dbg !1200, !tbaa !1034
  %63 = zext i8 %62 to i32, !dbg !1200
  %64 = icmp eq i32 %63, 0, !dbg !1202
  store i1 %64, i1* %4, align 1, !dbg !1203
  store i32 1, i32* %11, align 4
  br label %65, !dbg !1203

65:                                               ; preds = %58, %55
  %66 = bitcast i8** %9 to i8*, !dbg !1204
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %66) #19, !dbg !1204
  %67 = bitcast i8** %8 to i8*, !dbg !1204
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %67) #19, !dbg !1204
  %68 = load i1, i1* %4, align 1, !dbg !1204
  ret i1 %68, !dbg !1204
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_init_copy_from_cursor(%struct.aws_byte_buf* %0, %struct.aws_allocator* %1, [2 x i32] %2) #0 !dbg !1205 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_cursor, align 4
  %6 = alloca %struct.aws_byte_buf*, align 4
  %7 = alloca %struct.aws_allocator*, align 4
  %8 = bitcast %struct.aws_byte_cursor* %5 to [2 x i32]*
  store [2 x i32] %2, [2 x i32]* %8, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %6, metadata !1209, metadata !DIExpression()), !dbg !1212
  store %struct.aws_allocator* %1, %struct.aws_allocator** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator** %7, metadata !1210, metadata !DIExpression()), !dbg !1213
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %5, metadata !1211, metadata !DIExpression()), !dbg !1214
  br label %9, !dbg !1215

9:                                                ; preds = %3
  %10 = call zeroext i1 @aws_byte_cursor_is_valid(%struct.aws_byte_cursor* %5) #17, !dbg !1216
  br i1 %10, label %13, label %11, !dbg !1219

11:                                               ; preds = %9
  %12 = call i32 @aws_raise_error(i32 34) #17, !dbg !1220
  store i32 %12, i32* %4, align 4, !dbg !1220
  br label %74, !dbg !1220

13:                                               ; preds = %9
  br label %14, !dbg !1219

14:                                               ; preds = %13
  br label %15, !dbg !1222

15:                                               ; preds = %14
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1223, !tbaa !657
  %17 = bitcast %struct.aws_byte_buf* %16 to i8*, !dbg !1223
  %18 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1223, !tbaa !657
  %19 = bitcast %struct.aws_byte_buf* %18 to i8*, !dbg !1223
  %20 = call i32 @llvm.objectsize.i32.p0i8(i8* %19, i1 false, i1 true, i1 false), !dbg !1223
  %21 = call i8* @__memset_chk(i8* %17, i32 0, i32 16, i32 %20) #18, !dbg !1223
  br label %22, !dbg !1223

22:                                               ; preds = %15
  %23 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1225
  %24 = load i32, i32* %23, align 4, !dbg !1225, !tbaa !822
  %25 = icmp ugt i32 %24, 0, !dbg !1226
  br i1 %25, label %26, label %31, !dbg !1227

26:                                               ; preds = %22
  %27 = load %struct.aws_allocator*, %struct.aws_allocator** %7, align 4, !dbg !1228, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1229
  %29 = load i32, i32* %28, align 4, !dbg !1229, !tbaa !822
  %30 = call i8* bitcast (i8* (%struct.aws_allocator.13*, i32)* @aws_mem_acquire to i8* (%struct.aws_allocator*, i32)*)(%struct.aws_allocator* %27, i32 %29) #17, !dbg !1230
  br label %32, !dbg !1227

31:                                               ; preds = %22
  br label %32, !dbg !1227

32:                                               ; preds = %31, %26
  %33 = phi i8* [ %30, %26 ], [ null, %31 ], !dbg !1227
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1231, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %34, i32 0, i32 1, !dbg !1232
  store i8* %33, i8** %35, align 4, !dbg !1233, !tbaa !675
  %36 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1234
  %37 = load i32, i32* %36, align 4, !dbg !1234, !tbaa !822
  %38 = icmp ne i32 %37, 0, !dbg !1236
  br i1 %38, label %39, label %45, !dbg !1237

39:                                               ; preds = %32
  %40 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1238, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %40, i32 0, i32 1, !dbg !1239
  %42 = load i8*, i8** %41, align 4, !dbg !1239, !tbaa !675
  %43 = icmp eq i8* %42, null, !dbg !1240
  br i1 %43, label %44, label %45, !dbg !1241

44:                                               ; preds = %39
  store i32 -1, i32* %4, align 4, !dbg !1242
  br label %74, !dbg !1242

45:                                               ; preds = %39, %32
  %46 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1244
  %47 = load i32, i32* %46, align 4, !dbg !1244, !tbaa !822
  %48 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1245, !tbaa !657
  %49 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %48, i32 0, i32 0, !dbg !1246
  store i32 %47, i32* %49, align 4, !dbg !1247, !tbaa !693
  %50 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1248
  %51 = load i32, i32* %50, align 4, !dbg !1248, !tbaa !822
  %52 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1249, !tbaa !657
  %53 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %52, i32 0, i32 2, !dbg !1250
  store i32 %51, i32* %53, align 4, !dbg !1251, !tbaa !698
  %54 = load %struct.aws_allocator*, %struct.aws_allocator** %7, align 4, !dbg !1252, !tbaa !657
  %55 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1253, !tbaa !657
  %56 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %55, i32 0, i32 3, !dbg !1254
  store %struct.aws_allocator* %54, %struct.aws_allocator** %56, align 4, !dbg !1255, !tbaa !703
  %57 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1256
  %58 = load i32, i32* %57, align 4, !dbg !1256, !tbaa !822
  %59 = icmp ugt i32 %58, 0, !dbg !1258
  br i1 %59, label %60, label %73, !dbg !1259

60:                                               ; preds = %45
  %61 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1260, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %61, i32 0, i32 1, !dbg !1260
  %63 = load i8*, i8** %62, align 4, !dbg !1260, !tbaa !675
  %64 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 1, !dbg !1260
  %65 = load i8*, i8** %64, align 4, !dbg !1260, !tbaa !832
  %66 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !1260
  %67 = load i32, i32* %66, align 4, !dbg !1260, !tbaa !822
  %68 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !1260, !tbaa !657
  %69 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %68, i32 0, i32 1, !dbg !1260
  %70 = load i8*, i8** %69, align 4, !dbg !1260, !tbaa !675
  %71 = call i32 @llvm.objectsize.i32.p0i8(i8* %70, i1 false, i1 true, i1 false), !dbg !1260
  %72 = call i8* @__memcpy_chk(i8* %63, i8* %65, i32 %67, i32 %71) #18, !dbg !1260
  br label %73, !dbg !1262

73:                                               ; preds = %60, %45
  store i32 0, i32* %4, align 4, !dbg !1263
  br label %74, !dbg !1263

74:                                               ; preds = %73, %44, %11
  %75 = load i32, i32* %4, align 4, !dbg !1264
  ret i32 %75, !dbg !1264
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_init_cache_and_update_cursors(%struct.aws_byte_buf* %0, %struct.aws_allocator* %1, ...) #0 !dbg !1265 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca %struct.aws_allocator*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8*, align 4
  %8 = alloca %struct.aws_byte_cursor*, align 4
  %9 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !1269, metadata !DIExpression()), !dbg !1277
  store %struct.aws_allocator* %1, %struct.aws_allocator** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator** %5, metadata !1270, metadata !DIExpression()), !dbg !1278
  br label %10, !dbg !1279

10:                                               ; preds = %2
  %11 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1280, !tbaa !657
  %12 = bitcast %struct.aws_byte_buf* %11 to i8*, !dbg !1280
  %13 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1280, !tbaa !657
  %14 = bitcast %struct.aws_byte_buf* %13 to i8*, !dbg !1280
  %15 = call i32 @llvm.objectsize.i32.p0i8(i8* %14, i1 false, i1 true, i1 false), !dbg !1280
  %16 = call i8* @__memset_chk(i8* %12, i32 0, i32 16, i32 %15) #18, !dbg !1280
  br label %17, !dbg !1280

17:                                               ; preds = %10
  %18 = bitcast i32* %6 to i8*, !dbg !1282
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %18) #19, !dbg !1282
  call void @llvm.dbg.declare(metadata i32* %6, metadata !1271, metadata !DIExpression()), !dbg !1283
  store i32 0, i32* %6, align 4, !dbg !1283, !tbaa !663
  %19 = bitcast i8** %7 to i8*, !dbg !1284
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %19) #19, !dbg !1284
  call void @llvm.dbg.declare(metadata i8** %7, metadata !1272, metadata !DIExpression()), !dbg !1285
  %20 = bitcast i8** %7 to i8*, !dbg !1286
  call void @llvm.va_start(i8* %20), !dbg !1286
  %21 = bitcast %struct.aws_byte_cursor** %8 to i8*, !dbg !1287
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %21) #19, !dbg !1287
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %8, metadata !1276, metadata !DIExpression()), !dbg !1288
  br label %22, !dbg !1289

22:                                               ; preds = %36, %17
  %23 = load i8*, i8** %7, align 4, !dbg !1290
  %24 = getelementptr inbounds i8, i8* %23, i32 4, !dbg !1290
  store i8* %24, i8** %7, align 4, !dbg !1290
  %25 = bitcast i8* %23 to %struct.aws_byte_cursor**, !dbg !1290
  %26 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %25, align 4, !dbg !1290
  store %struct.aws_byte_cursor* %26, %struct.aws_byte_cursor** %8, align 4, !dbg !1291, !tbaa !657
  %27 = icmp ne %struct.aws_byte_cursor* %26, null, !dbg !1292
  br i1 %27, label %28, label %37, !dbg !1289

28:                                               ; preds = %22
  %29 = load i32, i32* %6, align 4, !dbg !1293, !tbaa !663
  %30 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %8, align 4, !dbg !1296, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %30, i32 0, i32 0, !dbg !1297
  %32 = load i32, i32* %31, align 4, !dbg !1297, !tbaa !822
  %33 = call i32 @aws_add_size_checked(i32 %29, i32 %32, i32* %6) #17, !dbg !1298
  %34 = icmp ne i32 %33, 0, !dbg !1298
  br i1 %34, label %35, label %36, !dbg !1299

35:                                               ; preds = %28
  store i32 -1, i32* %3, align 4, !dbg !1300
  store i32 1, i32* %9, align 4
  br label %59, !dbg !1300

36:                                               ; preds = %28
  br label %22, !dbg !1289, !llvm.loop !1302

37:                                               ; preds = %22
  %38 = bitcast i8** %7 to i8*, !dbg !1304
  call void @llvm.va_end(i8* %38), !dbg !1304
  %39 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1305, !tbaa !657
  %40 = load %struct.aws_allocator*, %struct.aws_allocator** %5, align 4, !dbg !1307, !tbaa !657
  %41 = load i32, i32* %6, align 4, !dbg !1308, !tbaa !663
  %42 = call i32 @aws_byte_buf_init(%struct.aws_byte_buf* %39, %struct.aws_allocator* %40, i32 %41) #17, !dbg !1309
  %43 = icmp ne i32 %42, 0, !dbg !1309
  br i1 %43, label %44, label %45, !dbg !1310

44:                                               ; preds = %37
  store i32 -1, i32* %3, align 4, !dbg !1311
  store i32 1, i32* %9, align 4
  br label %59, !dbg !1311

45:                                               ; preds = %37
  %46 = bitcast i8** %7 to i8*, !dbg !1313
  call void @llvm.va_start(i8* %46), !dbg !1313
  br label %47, !dbg !1314

47:                                               ; preds = %53, %45
  %48 = load i8*, i8** %7, align 4, !dbg !1315
  %49 = getelementptr inbounds i8, i8* %48, i32 4, !dbg !1315
  store i8* %49, i8** %7, align 4, !dbg !1315
  %50 = bitcast i8* %48 to %struct.aws_byte_cursor**, !dbg !1315
  %51 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %50, align 4, !dbg !1315
  store %struct.aws_byte_cursor* %51, %struct.aws_byte_cursor** %8, align 4, !dbg !1316, !tbaa !657
  %52 = icmp ne %struct.aws_byte_cursor* %51, null, !dbg !1317
  br i1 %52, label %53, label %57, !dbg !1314

53:                                               ; preds = %47
  %54 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1318, !tbaa !657
  %55 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %8, align 4, !dbg !1320, !tbaa !657
  %56 = call i32 @aws_byte_buf_append_and_update(%struct.aws_byte_buf* %54, %struct.aws_byte_cursor* %55) #17, !dbg !1321
  br label %47, !dbg !1314, !llvm.loop !1322

57:                                               ; preds = %47
  %58 = bitcast i8** %7 to i8*, !dbg !1324
  call void @llvm.va_end(i8* %58), !dbg !1324
  store i32 0, i32* %3, align 4, !dbg !1325
  store i32 1, i32* %9, align 4
  br label %59, !dbg !1325

59:                                               ; preds = %57, %44, %35
  %60 = bitcast %struct.aws_byte_cursor** %8 to i8*, !dbg !1326
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %60) #19, !dbg !1326
  %61 = bitcast i8** %7 to i8*, !dbg !1326
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %61) #19, !dbg !1326
  %62 = bitcast i32* %6 to i8*, !dbg !1326
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %62) #19, !dbg !1326
  %63 = load i32, i32* %3, align 4, !dbg !1326
  ret i32 %63, !dbg !1326
}

; Function Attrs: nofree nosync nounwind willreturn
declare void @llvm.va_start(i8*) #6

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_add_size_checked(i32 %0, i32 %1, i32* %2) #2 !dbg !1327 {
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32*, align 4
  store i32 %0, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !1333, metadata !DIExpression()), !dbg !1336
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !1334, metadata !DIExpression()), !dbg !1337
  store i32* %2, i32** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %6, metadata !1335, metadata !DIExpression()), !dbg !1338
  %7 = load i32, i32* %4, align 4, !dbg !1339, !tbaa !663
  %8 = load i32, i32* %5, align 4, !dbg !1340, !tbaa !663
  %9 = load i32*, i32** %6, align 4, !dbg !1341, !tbaa !657
  %10 = call i32 @aws_add_u32_checked(i32 %7, i32 %8, i32* %9) #17, !dbg !1342
  ret i32 %10, !dbg !1343
}

; Function Attrs: nofree nosync nounwind willreturn
declare void @llvm.va_end(i8*) #6

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_and_update(%struct.aws_byte_buf* %0, %struct.aws_byte_cursor* %1) #0 !dbg !1344 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !1346, metadata !DIExpression()), !dbg !1348
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !1347, metadata !DIExpression()), !dbg !1349
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1350, !tbaa !657
  %7 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1352, !tbaa !657
  %8 = call i32 @aws_byte_buf_append(%struct.aws_byte_buf* %6, %struct.aws_byte_cursor* %7) #17, !dbg !1353
  %9 = icmp ne i32 %8, 0, !dbg !1353
  br i1 %9, label %10, label %11, !dbg !1354

10:                                               ; preds = %2
  store i32 -1, i32* %3, align 4, !dbg !1355
  br label %25, !dbg !1355

11:                                               ; preds = %2
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1357, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 1, !dbg !1358
  %14 = load i8*, i8** %13, align 4, !dbg !1358, !tbaa !675
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1359, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 0, !dbg !1360
  %17 = load i32, i32* %16, align 4, !dbg !1360, !tbaa !693
  %18 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1361, !tbaa !657
  %19 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %18, i32 0, i32 0, !dbg !1362
  %20 = load i32, i32* %19, align 4, !dbg !1362, !tbaa !822
  %21 = sub i32 %17, %20, !dbg !1363
  %22 = getelementptr inbounds i8, i8* %14, i32 %21, !dbg !1364
  %23 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1365, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %23, i32 0, i32 1, !dbg !1366
  store i8* %22, i8** %24, align 4, !dbg !1367, !tbaa !832
  store i32 0, i32* %3, align 4, !dbg !1368
  br label %25, !dbg !1368

25:                                               ; preds = %11, %10
  %26 = load i32, i32* %3, align 4, !dbg !1369
  ret i32 %26, !dbg !1369
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append(%struct.aws_byte_buf* %0, %struct.aws_byte_cursor* %1) #0 !dbg !1370 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !1372, metadata !DIExpression()), !dbg !1374
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !1373, metadata !DIExpression()), !dbg !1375
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1376, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %6, i32 0, i32 2, !dbg !1378
  %8 = load i32, i32* %7, align 4, !dbg !1378, !tbaa !698
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1379, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 0, !dbg !1380
  %11 = load i32, i32* %10, align 4, !dbg !1380, !tbaa !693
  %12 = sub i32 %8, %11, !dbg !1381
  %13 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1382, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %13, i32 0, i32 0, !dbg !1383
  %15 = load i32, i32* %14, align 4, !dbg !1383, !tbaa !822
  %16 = icmp ult i32 %12, %15, !dbg !1384
  br i1 %16, label %17, label %19, !dbg !1385

17:                                               ; preds = %2
  %18 = call i32 @aws_raise_error(i32 26) #17, !dbg !1386
  store i32 %18, i32* %3, align 4, !dbg !1388
  br label %55, !dbg !1388

19:                                               ; preds = %2
  %20 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1389, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %20, i32 0, i32 0, !dbg !1391
  %22 = load i32, i32* %21, align 4, !dbg !1391, !tbaa !822
  %23 = icmp ugt i32 %22, 0, !dbg !1392
  br i1 %23, label %24, label %54, !dbg !1393

24:                                               ; preds = %19
  %25 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1394, !tbaa !657
  %26 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %25, i32 0, i32 1, !dbg !1394
  %27 = load i8*, i8** %26, align 4, !dbg !1394, !tbaa !675
  %28 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1394, !tbaa !657
  %29 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %28, i32 0, i32 0, !dbg !1394
  %30 = load i32, i32* %29, align 4, !dbg !1394, !tbaa !693
  %31 = getelementptr inbounds i8, i8* %27, i32 %30, !dbg !1394
  %32 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1394, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %32, i32 0, i32 1, !dbg !1394
  %34 = load i8*, i8** %33, align 4, !dbg !1394, !tbaa !832
  %35 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1394, !tbaa !657
  %36 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %35, i32 0, i32 0, !dbg !1394
  %37 = load i32, i32* %36, align 4, !dbg !1394, !tbaa !822
  %38 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1394, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %38, i32 0, i32 1, !dbg !1394
  %40 = load i8*, i8** %39, align 4, !dbg !1394, !tbaa !675
  %41 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1394, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %41, i32 0, i32 0, !dbg !1394
  %43 = load i32, i32* %42, align 4, !dbg !1394, !tbaa !693
  %44 = getelementptr inbounds i8, i8* %40, i32 %43, !dbg !1394
  %45 = call i32 @llvm.objectsize.i32.p0i8(i8* %44, i1 false, i1 true, i1 false), !dbg !1394
  %46 = call i8* @__memcpy_chk(i8* %31, i8* %34, i32 %37, i32 %45) #18, !dbg !1394
  %47 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1396, !tbaa !657
  %48 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %47, i32 0, i32 0, !dbg !1397
  %49 = load i32, i32* %48, align 4, !dbg !1397, !tbaa !822
  %50 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1398, !tbaa !657
  %51 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %50, i32 0, i32 0, !dbg !1399
  %52 = load i32, i32* %51, align 4, !dbg !1400, !tbaa !693
  %53 = add i32 %52, %49, !dbg !1400
  store i32 %53, i32* %51, align 4, !dbg !1400, !tbaa !693
  br label %54, !dbg !1401

54:                                               ; preds = %24, %19
  store i32 0, i32* %3, align 4, !dbg !1402
  br label %55, !dbg !1402

55:                                               ; preds = %54, %17
  %56 = load i32, i32* %3, align 4, !dbg !1403
  ret i32 %56, !dbg !1403
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_add_u32_checked(i32 %0, i32 %1, i32* %2) #2 !dbg !1404 {
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32*, align 4
  store i32 %0, i32* %5, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %5, metadata !1409, metadata !DIExpression()), !dbg !1412
  store i32 %1, i32* %6, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %6, metadata !1410, metadata !DIExpression()), !dbg !1413
  store i32* %2, i32** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %7, metadata !1411, metadata !DIExpression()), !dbg !1414
  %8 = load i32, i32* %5, align 4, !dbg !1415, !tbaa !805
  %9 = load i32, i32* %6, align 4, !dbg !1417, !tbaa !805
  %10 = load i32*, i32** %7, align 4, !dbg !1418, !tbaa !657
  %11 = call { i32, i1 } @llvm.uadd.with.overflow.i32(i32 %8, i32 %9), !dbg !1419
  %12 = extractvalue { i32, i1 } %11, 1, !dbg !1419
  %13 = extractvalue { i32, i1 } %11, 0, !dbg !1419
  store i32 %13, i32* %10, align 4, !dbg !1419
  br i1 %12, label %14, label %16, !dbg !1420

14:                                               ; preds = %3
  %15 = call i32 @aws_raise_error(i32 5) #17, !dbg !1421
  store i32 %15, i32* %4, align 4, !dbg !1423
  br label %17, !dbg !1423

16:                                               ; preds = %3
  store i32 0, i32* %4, align 4, !dbg !1424
  br label %17, !dbg !1424

17:                                               ; preds = %16, %14
  %18 = load i32, i32* %4, align 4, !dbg !1425
  ret i32 %18, !dbg !1425
}

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare { i32, i1 } @llvm.uadd.with.overflow.i32(i32, i32) #1

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_next_split(%struct.aws_byte_cursor* noalias %0, i8 signext %1, %struct.aws_byte_cursor* noalias %2) #0 !dbg !1426 {
  %4 = alloca i1, align 1
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca i8, align 1
  %7 = alloca %struct.aws_byte_cursor*, align 4
  %8 = alloca i8, align 1
  %9 = alloca i32, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i8*, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !1432, metadata !DIExpression()), !dbg !1441
  store i8 %1, i8* %6, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %6, metadata !1433, metadata !DIExpression()), !dbg !1442
  store %struct.aws_byte_cursor* %2, %struct.aws_byte_cursor** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %7, metadata !1434, metadata !DIExpression()), !dbg !1443
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %8) #19, !dbg !1444
  call void @llvm.dbg.declare(metadata i8* %8, metadata !1435, metadata !DIExpression()), !dbg !1445
  %12 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1446, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %12, i32 0, i32 1, !dbg !1447
  %14 = load i8*, i8** %13, align 4, !dbg !1447, !tbaa !832
  %15 = icmp eq i8* %14, null, !dbg !1448
  %16 = zext i1 %15 to i8, !dbg !1445
  store i8 %16, i8* %8, align 1, !dbg !1445, !tbaa !844
  %17 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1449, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %17, i32 0, i32 1, !dbg !1449
  %19 = load i8*, i8** %18, align 4, !dbg !1449, !tbaa !832
  %20 = icmp eq i8* %19, null, !dbg !1449
  %21 = xor i1 %20, true, !dbg !1449
  %22 = xor i1 %21, true, !dbg !1449
  %23 = zext i1 %22 to i32, !dbg !1449
  %24 = call i32 @llvm.expect.i32(i32 %23, i32 0), !dbg !1449
  %25 = icmp ne i32 %24, 0, !dbg !1449
  br i1 %25, label %26, label %44, !dbg !1451

26:                                               ; preds = %3
  %27 = load i8, i8* %8, align 1, !dbg !1452, !tbaa !844, !range !849
  %28 = trunc i8 %27 to i1, !dbg !1452
  br i1 %28, label %29, label %34, !dbg !1455

29:                                               ; preds = %26
  %30 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1456, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %30, i32 0, i32 1, !dbg !1458
  store i8* getelementptr inbounds ([1 x i8], [1 x i8]* @.str, i32 0, i32 0), i8** %31, align 4, !dbg !1459, !tbaa !832
  %32 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1460, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %32, i32 0, i32 0, !dbg !1461
  store i32 0, i32* %33, align 4, !dbg !1462, !tbaa !822
  store i1 true, i1* %4, align 1, !dbg !1463
  store i32 1, i32* %9, align 4
  br label %137, !dbg !1463

34:                                               ; preds = %26
  br label %35, !dbg !1464

35:                                               ; preds = %34
  %36 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1465, !tbaa !657
  %37 = bitcast %struct.aws_byte_cursor* %36 to i8*, !dbg !1465
  %38 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1465, !tbaa !657
  %39 = bitcast %struct.aws_byte_cursor* %38 to i8*, !dbg !1465
  %40 = call i32 @llvm.objectsize.i32.p0i8(i8* %39, i1 false, i1 true, i1 false), !dbg !1465
  %41 = call i8* @__memset_chk(i8* %37, i32 0, i32 8, i32 %40) #18, !dbg !1465
  br label %42, !dbg !1465

42:                                               ; preds = %35
  br label %43, !dbg !1465

43:                                               ; preds = %42
  store i1 false, i1* %4, align 1, !dbg !1467
  store i32 1, i32* %9, align 4
  br label %137, !dbg !1467

44:                                               ; preds = %3
  %45 = load i8, i8* %8, align 1, !dbg !1468, !tbaa !844, !range !849
  %46 = trunc i8 %45 to i1, !dbg !1468
  br i1 %46, label %47, label %52, !dbg !1469

47:                                               ; preds = %44
  %48 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1470, !tbaa !657
  %49 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1472, !tbaa !657
  %50 = bitcast %struct.aws_byte_cursor* %48 to i8*, !dbg !1473
  %51 = bitcast %struct.aws_byte_cursor* %49 to i8*, !dbg !1473
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %50, i8* align 4 %51, i32 8, i1 false), !dbg !1473, !tbaa.struct !1474
  br label %112, !dbg !1475

52:                                               ; preds = %44
  %53 = bitcast i8** %10 to i8*, !dbg !1476
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %53) #19, !dbg !1476
  call void @llvm.dbg.declare(metadata i8** %10, metadata !1437, metadata !DIExpression()), !dbg !1477
  %54 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1478, !tbaa !657
  %55 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %54, i32 0, i32 1, !dbg !1479
  %56 = load i8*, i8** %55, align 4, !dbg !1479, !tbaa !832
  %57 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1480, !tbaa !657
  %58 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %57, i32 0, i32 0, !dbg !1481
  %59 = load i32, i32* %58, align 4, !dbg !1481, !tbaa !822
  %60 = getelementptr inbounds i8, i8* %56, i32 %59, !dbg !1482
  store i8* %60, i8** %10, align 4, !dbg !1477, !tbaa !657
  %61 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1483, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %61, i32 0, i32 0, !dbg !1484
  %63 = load i32, i32* %62, align 4, !dbg !1484, !tbaa !822
  %64 = add i32 %63, 1, !dbg !1485
  %65 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1486, !tbaa !657
  %66 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %65, i32 0, i32 1, !dbg !1487
  %67 = load i8*, i8** %66, align 4, !dbg !1488, !tbaa !832
  %68 = getelementptr inbounds i8, i8* %67, i32 %64, !dbg !1488
  store i8* %68, i8** %66, align 4, !dbg !1488, !tbaa !832
  %69 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1489, !tbaa !657
  %70 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %69, i32 0, i32 1, !dbg !1491
  %71 = load i8*, i8** %70, align 4, !dbg !1491, !tbaa !832
  %72 = load i8*, i8** %10, align 4, !dbg !1492, !tbaa !657
  %73 = icmp ugt i8* %71, %72, !dbg !1493
  br i1 %73, label %82, label %74, !dbg !1494

74:                                               ; preds = %52
  %75 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1495, !tbaa !657
  %76 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %75, i32 0, i32 1, !dbg !1496
  %77 = load i8*, i8** %76, align 4, !dbg !1496, !tbaa !832
  %78 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1497, !tbaa !657
  %79 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %78, i32 0, i32 1, !dbg !1498
  %80 = load i8*, i8** %79, align 4, !dbg !1498, !tbaa !832
  %81 = icmp ult i8* %77, %80, !dbg !1499
  br i1 %81, label %82, label %92, !dbg !1500

82:                                               ; preds = %74, %52
  br label %83, !dbg !1501

83:                                               ; preds = %82
  %84 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1503, !tbaa !657
  %85 = bitcast %struct.aws_byte_cursor* %84 to i8*, !dbg !1503
  %86 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1503, !tbaa !657
  %87 = bitcast %struct.aws_byte_cursor* %86 to i8*, !dbg !1503
  %88 = call i32 @llvm.objectsize.i32.p0i8(i8* %87, i1 false, i1 true, i1 false), !dbg !1503
  %89 = call i8* @__memset_chk(i8* %85, i32 0, i32 8, i32 %88) #18, !dbg !1503
  br label %90, !dbg !1503

90:                                               ; preds = %83
  br label %91, !dbg !1503

91:                                               ; preds = %90
  store i1 false, i1* %4, align 1, !dbg !1505
  store i32 1, i32* %9, align 4
  br label %108, !dbg !1505

92:                                               ; preds = %74
  %93 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1506, !tbaa !657
  %94 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %93, i32 0, i32 0, !dbg !1507
  %95 = load i32, i32* %94, align 4, !dbg !1507, !tbaa !822
  %96 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1508, !tbaa !657
  %97 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %96, i32 0, i32 1, !dbg !1509
  %98 = load i8*, i8** %97, align 4, !dbg !1509, !tbaa !832
  %99 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1510, !tbaa !657
  %100 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %99, i32 0, i32 1, !dbg !1511
  %101 = load i8*, i8** %100, align 4, !dbg !1511, !tbaa !832
  %102 = ptrtoint i8* %98 to i32, !dbg !1512
  %103 = ptrtoint i8* %101 to i32, !dbg !1512
  %104 = sub i32 %102, %103, !dbg !1512
  %105 = sub i32 %95, %104, !dbg !1513
  %106 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1514, !tbaa !657
  %107 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %106, i32 0, i32 0, !dbg !1515
  store i32 %105, i32* %107, align 4, !dbg !1516, !tbaa !822
  store i32 0, i32* %9, align 4, !dbg !1517
  br label %108, !dbg !1517

108:                                              ; preds = %92, %91
  %109 = bitcast i8** %10 to i8*, !dbg !1517
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %109) #19, !dbg !1517
  %110 = load i32, i32* %9, align 4
  switch i32 %110, label %137 [
    i32 0, label %111
  ]

111:                                              ; preds = %108
  br label %112

112:                                              ; preds = %111, %47
  %113 = bitcast i8** %11 to i8*, !dbg !1518
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %113) #19, !dbg !1518
  call void @llvm.dbg.declare(metadata i8** %11, metadata !1440, metadata !DIExpression()), !dbg !1519
  %114 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1520, !tbaa !657
  %115 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %114, i32 0, i32 1, !dbg !1521
  %116 = load i8*, i8** %115, align 4, !dbg !1521, !tbaa !832
  %117 = load i8, i8* %6, align 1, !dbg !1522, !tbaa !1034
  %118 = sext i8 %117 to i32, !dbg !1522
  %119 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1523, !tbaa !657
  %120 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %119, i32 0, i32 0, !dbg !1524
  %121 = load i32, i32* %120, align 4, !dbg !1524, !tbaa !822
  %122 = call i8* @memchr(i8* %116, i32 %118, i32 %121) #17, !dbg !1525
  store i8* %122, i8** %11, align 4, !dbg !1519, !tbaa !657
  %123 = load i8*, i8** %11, align 4, !dbg !1526, !tbaa !657
  %124 = icmp ne i8* %123, null, !dbg !1526
  br i1 %124, label %125, label %135, !dbg !1528

125:                                              ; preds = %112
  %126 = load i8*, i8** %11, align 4, !dbg !1529, !tbaa !657
  %127 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1531, !tbaa !657
  %128 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %127, i32 0, i32 1, !dbg !1532
  %129 = load i8*, i8** %128, align 4, !dbg !1532, !tbaa !832
  %130 = ptrtoint i8* %126 to i32, !dbg !1533
  %131 = ptrtoint i8* %129 to i32, !dbg !1533
  %132 = sub i32 %130, %131, !dbg !1533
  %133 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1534, !tbaa !657
  %134 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %133, i32 0, i32 0, !dbg !1535
  store i32 %132, i32* %134, align 4, !dbg !1536, !tbaa !822
  br label %135, !dbg !1537

135:                                              ; preds = %125, %112
  store i1 true, i1* %4, align 1, !dbg !1538
  store i32 1, i32* %9, align 4
  %136 = bitcast i8** %11 to i8*, !dbg !1539
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %136) #19, !dbg !1539
  br label %137

137:                                              ; preds = %135, %108, %43, %29
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #19, !dbg !1539
  %138 = load i1, i1* %4, align 1, !dbg !1539
  ret i1 %138, !dbg !1539
}

; Function Attrs: nofree nosync nounwind readnone willreturn
declare i32 @llvm.expect.i32(i32, i32) #7

declare i8* @memchr(i8*, i32, i32) #4

; Function Attrs: nounwind ssp
define i32 @aws_byte_cursor_split_on_char_n(%struct.aws_byte_cursor* noalias %0, i8 signext %1, i32 %2, %struct.aws_array_list* noalias %3) #0 !dbg !1540 {
  %5 = alloca i32, align 4
  %6 = alloca %struct.aws_byte_cursor*, align 4
  %7 = alloca i8, align 1
  %8 = alloca i32, align 4
  %9 = alloca %struct.aws_array_list*, align 4
  %10 = alloca i32, align 4
  %11 = alloca i32, align 4
  %12 = alloca %struct.aws_byte_cursor, align 4
  %13 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %6, metadata !1545, metadata !DIExpression()), !dbg !1552
  store i8 %1, i8* %7, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %7, metadata !1546, metadata !DIExpression()), !dbg !1553
  store i32 %2, i32* %8, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %8, metadata !1547, metadata !DIExpression()), !dbg !1554
  store %struct.aws_array_list* %3, %struct.aws_array_list** %9, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %9, metadata !1548, metadata !DIExpression()), !dbg !1555
  %14 = bitcast i32* %10 to i8*, !dbg !1556
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !1556
  call void @llvm.dbg.declare(metadata i32* %10, metadata !1549, metadata !DIExpression()), !dbg !1557
  %15 = load i32, i32* %8, align 4, !dbg !1558, !tbaa !663
  %16 = icmp ugt i32 %15, 0, !dbg !1559
  br i1 %16, label %17, label %19, !dbg !1558

17:                                               ; preds = %4
  %18 = load i32, i32* %8, align 4, !dbg !1560, !tbaa !663
  br label %20, !dbg !1558

19:                                               ; preds = %4
  br label %20, !dbg !1558

20:                                               ; preds = %19, %17
  %21 = phi i32 [ %18, %17 ], [ -1, %19 ], !dbg !1558
  store i32 %21, i32* %10, align 4, !dbg !1557, !tbaa !663
  %22 = bitcast i32* %11 to i8*, !dbg !1561
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %22) #19, !dbg !1561
  call void @llvm.dbg.declare(metadata i32* %11, metadata !1550, metadata !DIExpression()), !dbg !1562
  store i32 0, i32* %11, align 4, !dbg !1562, !tbaa !663
  %23 = bitcast %struct.aws_byte_cursor* %12 to i8*, !dbg !1563
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %23) #19, !dbg !1563
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %12, metadata !1551, metadata !DIExpression()), !dbg !1564
  br label %24, !dbg !1565

24:                                               ; preds = %20
  %25 = bitcast %struct.aws_byte_cursor* %12 to i8*, !dbg !1566
  call void @llvm.memset.p0i8.i32(i8* align 4 %25, i8 0, i32 8, i1 false), !dbg !1566
  br label %26, !dbg !1566

26:                                               ; preds = %24
  br label %27, !dbg !1566

27:                                               ; preds = %26
  br label %28, !dbg !1568

28:                                               ; preds = %67, %27
  %29 = load i32, i32* %11, align 4, !dbg !1569, !tbaa !663
  %30 = load i32, i32* %10, align 4, !dbg !1570, !tbaa !663
  %31 = icmp ule i32 %29, %30, !dbg !1571
  br i1 %31, label %32, label %36, !dbg !1572

32:                                               ; preds = %28
  %33 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1573, !tbaa !657
  %34 = load i8, i8* %7, align 1, !dbg !1574, !tbaa !1034
  %35 = call zeroext i1 @aws_byte_cursor_next_split(%struct.aws_byte_cursor* %33, i8 signext %34, %struct.aws_byte_cursor* %12) #17, !dbg !1575
  br label %36

36:                                               ; preds = %32, %28
  %37 = phi i1 [ false, %28 ], [ %35, %32 ], !dbg !1576
  br i1 %37, label %38, label %70, !dbg !1568

38:                                               ; preds = %36
  %39 = load i32, i32* %11, align 4, !dbg !1577, !tbaa !663
  %40 = load i32, i32* %10, align 4, !dbg !1580, !tbaa !663
  %41 = icmp eq i32 %39, %40, !dbg !1581
  br i1 %41, label %42, label %56, !dbg !1582

42:                                               ; preds = %38
  %43 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1583, !tbaa !657
  %44 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %43, i32 0, i32 0, !dbg !1585
  %45 = load i32, i32* %44, align 4, !dbg !1585, !tbaa !822
  %46 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %12, i32 0, i32 1, !dbg !1586
  %47 = load i8*, i8** %46, align 4, !dbg !1586, !tbaa !832
  %48 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1587, !tbaa !657
  %49 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %48, i32 0, i32 1, !dbg !1588
  %50 = load i8*, i8** %49, align 4, !dbg !1588, !tbaa !832
  %51 = ptrtoint i8* %47 to i32, !dbg !1589
  %52 = ptrtoint i8* %50 to i32, !dbg !1589
  %53 = sub i32 %51, %52, !dbg !1589
  %54 = sub i32 %45, %53, !dbg !1590
  %55 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %12, i32 0, i32 0, !dbg !1591
  store i32 %54, i32* %55, align 4, !dbg !1592, !tbaa !822
  br label %56, !dbg !1593

56:                                               ; preds = %42, %38
  %57 = load %struct.aws_array_list*, %struct.aws_array_list** %9, align 4, !dbg !1594, !tbaa !657
  %58 = bitcast %struct.aws_byte_cursor* %12 to i8*, !dbg !1594
  %59 = call i32 @aws_array_list_push_back(%struct.aws_array_list* %57, i8* %58) #17, !dbg !1594
  %60 = icmp ne i32 %59, 0, !dbg !1594
  %61 = xor i1 %60, true, !dbg !1594
  %62 = xor i1 %61, true, !dbg !1594
  %63 = zext i1 %62 to i32, !dbg !1594
  %64 = call i32 @llvm.expect.i32(i32 %63, i32 0), !dbg !1594
  %65 = icmp ne i32 %64, 0, !dbg !1594
  br i1 %65, label %66, label %67, !dbg !1596

66:                                               ; preds = %56
  store i32 -1, i32* %5, align 4, !dbg !1597
  store i32 1, i32* %13, align 4
  br label %71, !dbg !1597

67:                                               ; preds = %56
  %68 = load i32, i32* %11, align 4, !dbg !1599, !tbaa !663
  %69 = add i32 %68, 1, !dbg !1599
  store i32 %69, i32* %11, align 4, !dbg !1599, !tbaa !663
  br label %28, !dbg !1568, !llvm.loop !1600

70:                                               ; preds = %36
  store i32 0, i32* %5, align 4, !dbg !1602
  store i32 1, i32* %13, align 4
  br label %71, !dbg !1602

71:                                               ; preds = %70, %66
  %72 = bitcast %struct.aws_byte_cursor* %12 to i8*, !dbg !1603
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %72) #19, !dbg !1603
  %73 = bitcast i32* %11 to i8*, !dbg !1603
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %73) #19, !dbg !1603
  %74 = bitcast i32* %10 to i8*, !dbg !1603
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %74) #19, !dbg !1603
  %75 = load i32, i32* %5, align 4, !dbg !1603
  ret i32 %75, !dbg !1603
}

; Function Attrs: argmemonly nofree nounwind willreturn writeonly
declare void @llvm.memset.p0i8.i32(i8* nocapture writeonly, i8, i32, i1 immarg) #8

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_array_list_push_back(%struct.aws_array_list* noalias %0, i8* %1) #2 !dbg !1604 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_array_list*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store %struct.aws_array_list* %0, %struct.aws_array_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %4, metadata !1609, metadata !DIExpression()), !dbg !1612
  store i8* %1, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !1610, metadata !DIExpression()), !dbg !1613
  %8 = bitcast i32* %6 to i8*, !dbg !1614
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %8) #19, !dbg !1614
  call void @llvm.dbg.declare(metadata i32* %6, metadata !1611, metadata !DIExpression()), !dbg !1615
  %9 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !1616, !tbaa !657
  %10 = load i8*, i8** %5, align 4, !dbg !1617, !tbaa !657
  %11 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !1618, !tbaa !657
  %12 = call i32 @aws_array_list_length(%struct.aws_array_list* %11) #17, !dbg !1619
  %13 = call i32 @aws_array_list_set_at(%struct.aws_array_list* %9, i8* %10, i32 %12) #17, !dbg !1620
  store i32 %13, i32* %6, align 4, !dbg !1615, !tbaa !805
  %14 = load i32, i32* %6, align 4, !dbg !1621, !tbaa !805
  %15 = icmp ne i32 %14, 0, !dbg !1621
  br i1 %15, label %16, label %26, !dbg !1623

16:                                               ; preds = %2
  %17 = call i32 @aws_last_error() #17, !dbg !1624
  %18 = icmp eq i32 %17, 10, !dbg !1625
  br i1 %18, label %19, label %26, !dbg !1626

19:                                               ; preds = %16
  %20 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !1627, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %20, i32 0, i32 0, !dbg !1628
  %22 = load %struct.aws_allocator*, %struct.aws_allocator** %21, align 4, !dbg !1628, !tbaa !1629
  %23 = icmp ne %struct.aws_allocator* %22, null, !dbg !1627
  br i1 %23, label %26, label %24, !dbg !1631

24:                                               ; preds = %19
  %25 = call i32 @aws_raise_error(i32 27) #17, !dbg !1632
  store i32 %25, i32* %3, align 4, !dbg !1634
  store i32 1, i32* %7, align 4
  br label %28, !dbg !1634

26:                                               ; preds = %19, %16, %2
  %27 = load i32, i32* %6, align 4, !dbg !1635, !tbaa !805
  store i32 %27, i32* %3, align 4, !dbg !1636
  store i32 1, i32* %7, align 4
  br label %28, !dbg !1636

28:                                               ; preds = %26, %24
  %29 = bitcast i32* %6 to i8*, !dbg !1637
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %29) #19, !dbg !1637
  %30 = load i32, i32* %3, align 4, !dbg !1637
  ret i32 %30, !dbg !1637
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_array_list_length(%struct.aws_array_list* noalias %0) #2 !dbg !1638 {
  %2 = alloca %struct.aws_array_list*, align 4
  %3 = alloca i32, align 4
  store %struct.aws_array_list* %0, %struct.aws_array_list** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %2, metadata !1645, metadata !DIExpression()), !dbg !1647
  %4 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !1648, !tbaa !657
  %5 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %4, i32 0, i32 2, !dbg !1648
  %6 = load i32, i32* %5, align 4, !dbg !1648, !tbaa !1650
  %7 = icmp ne i32 %6, 0, !dbg !1648
  br i1 %7, label %8, label %14, !dbg !1648

8:                                                ; preds = %1
  %9 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !1648, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %9, i32 0, i32 4, !dbg !1648
  %11 = load i8*, i8** %10, align 4, !dbg !1648, !tbaa !1651
  %12 = icmp ne i8* %11, null, !dbg !1648
  br i1 %12, label %14, label %13, !dbg !1652

13:                                               ; preds = %8
  call void @aws_fatal_assert(i8* getelementptr inbounds ([28 x i8], [28 x i8]* @.str.3, i32 0, i32 0), i8* getelementptr inbounds ([82 x i8], [82 x i8]* @.str.2, i32 0, i32 0), i32 312) #20, !dbg !1653
  unreachable, !dbg !1653

14:                                               ; preds = %8, %1
  %15 = bitcast i32* %3 to i8*, !dbg !1655
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !1655
  call void @llvm.dbg.declare(metadata i32* %3, metadata !1646, metadata !DIExpression()), !dbg !1656
  %16 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !1657, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %16, i32 0, i32 2, !dbg !1658
  %18 = load i32, i32* %17, align 4, !dbg !1658, !tbaa !1650
  store i32 %18, i32* %3, align 4, !dbg !1656, !tbaa !663
  %19 = load i32, i32* %3, align 4, !dbg !1659, !tbaa !663
  %20 = bitcast i32* %3 to i8*, !dbg !1660
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %20) #19, !dbg !1660
  ret i32 %19, !dbg !1661
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_array_list_set_at(%struct.aws_array_list* noalias %0, i8* %1, i32 %2) #2 !dbg !1662 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_array_list*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  store %struct.aws_array_list* %0, %struct.aws_array_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %5, metadata !1666, metadata !DIExpression()), !dbg !1669
  store i8* %1, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !1667, metadata !DIExpression()), !dbg !1670
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !1668, metadata !DIExpression()), !dbg !1671
  %8 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1672, !tbaa !657
  %9 = load i32, i32* %7, align 4, !dbg !1674, !tbaa !663
  %10 = call i32 @aws_array_list_ensure_capacity(%struct.aws_array_list* %8, i32 %9) #17, !dbg !1675
  %11 = icmp ne i32 %10, 0, !dbg !1675
  br i1 %11, label %12, label %13, !dbg !1676

12:                                               ; preds = %3
  store i32 -1, i32* %4, align 4, !dbg !1677
  br label %57, !dbg !1677

13:                                               ; preds = %3
  %14 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1679, !tbaa !657
  %15 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %14, i32 0, i32 4, !dbg !1679
  %16 = load i8*, i8** %15, align 4, !dbg !1679, !tbaa !1651
  %17 = icmp ne i8* %16, null, !dbg !1679
  br i1 %17, label %19, label %18, !dbg !1681

18:                                               ; preds = %13
  call void @aws_fatal_assert(i8* getelementptr inbounds ([11 x i8], [11 x i8]* @.str.1, i32 0, i32 0), i8* getelementptr inbounds ([82 x i8], [82 x i8]* @.str.2, i32 0, i32 0), i32 359) #20, !dbg !1682
  unreachable, !dbg !1682

19:                                               ; preds = %13
  %20 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1684, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %20, i32 0, i32 4, !dbg !1684
  %22 = load i8*, i8** %21, align 4, !dbg !1684, !tbaa !1651
  %23 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1684, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %23, i32 0, i32 3, !dbg !1684
  %25 = load i32, i32* %24, align 4, !dbg !1684, !tbaa !1685
  %26 = load i32, i32* %7, align 4, !dbg !1684, !tbaa !663
  %27 = mul i32 %25, %26, !dbg !1684
  %28 = getelementptr inbounds i8, i8* %22, i32 %27, !dbg !1684
  %29 = load i8*, i8** %6, align 4, !dbg !1684, !tbaa !657
  %30 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1684, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %30, i32 0, i32 3, !dbg !1684
  %32 = load i32, i32* %31, align 4, !dbg !1684, !tbaa !1685
  %33 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1684, !tbaa !657
  %34 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %33, i32 0, i32 4, !dbg !1684
  %35 = load i8*, i8** %34, align 4, !dbg !1684, !tbaa !1651
  %36 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1684, !tbaa !657
  %37 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %36, i32 0, i32 3, !dbg !1684
  %38 = load i32, i32* %37, align 4, !dbg !1684, !tbaa !1685
  %39 = load i32, i32* %7, align 4, !dbg !1684, !tbaa !663
  %40 = mul i32 %38, %39, !dbg !1684
  %41 = getelementptr inbounds i8, i8* %35, i32 %40, !dbg !1684
  %42 = call i32 @llvm.objectsize.i32.p0i8(i8* %41, i1 false, i1 true, i1 false), !dbg !1684
  %43 = call i8* @__memcpy_chk(i8* %28, i8* %29, i32 %32, i32 %42) #18, !dbg !1684
  %44 = load i32, i32* %7, align 4, !dbg !1686, !tbaa !663
  %45 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1688, !tbaa !657
  %46 = call i32 @aws_array_list_length(%struct.aws_array_list* %45) #17, !dbg !1689
  %47 = icmp uge i32 %44, %46, !dbg !1690
  br i1 %47, label %48, label %56, !dbg !1691

48:                                               ; preds = %19
  %49 = load i32, i32* %7, align 4, !dbg !1692, !tbaa !663
  %50 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !1695, !tbaa !657
  %51 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %50, i32 0, i32 2, !dbg !1696
  %52 = call i32 @aws_add_size_checked(i32 %49, i32 1, i32* %51) #17, !dbg !1697
  %53 = icmp ne i32 %52, 0, !dbg !1697
  br i1 %53, label %54, label %55, !dbg !1698

54:                                               ; preds = %48
  store i32 -1, i32* %4, align 4, !dbg !1699
  br label %57, !dbg !1699

55:                                               ; preds = %48
  br label %56, !dbg !1701

56:                                               ; preds = %55, %19
  store i32 0, i32* %4, align 4, !dbg !1702
  br label %57, !dbg !1702

57:                                               ; preds = %56, %54, %12
  %58 = load i32, i32* %4, align 4, !dbg !1703
  ret i32 %58, !dbg !1703
}

declare !dbg !168 i32 @aws_array_list_ensure_capacity(%struct.aws_array_list*, i32) #4

; Function Attrs: noreturn
declare !dbg !180 void @aws_fatal_assert(i8*, i8*, i32) #9

; Function Attrs: nounwind ssp
define i32 @aws_byte_cursor_split_on_char(%struct.aws_byte_cursor* noalias %0, i8 signext %1, %struct.aws_array_list* noalias %2) #0 !dbg !1704 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i8, align 1
  %6 = alloca %struct.aws_array_list*, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !1708, metadata !DIExpression()), !dbg !1711
  store i8 %1, i8* %5, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %5, metadata !1709, metadata !DIExpression()), !dbg !1712
  store %struct.aws_array_list* %2, %struct.aws_array_list** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %6, metadata !1710, metadata !DIExpression()), !dbg !1713
  %7 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1714, !tbaa !657
  %8 = load i8, i8* %5, align 1, !dbg !1715, !tbaa !1034
  %9 = load %struct.aws_array_list*, %struct.aws_array_list** %6, align 4, !dbg !1716, !tbaa !657
  %10 = call i32 @aws_byte_cursor_split_on_char_n(%struct.aws_byte_cursor* %7, i8 signext %8, i32 0, %struct.aws_array_list* %9) #17, !dbg !1717
  ret i32 %10, !dbg !1718
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_cursor_find_exact(%struct.aws_byte_cursor* noalias %0, %struct.aws_byte_cursor* noalias %1, %struct.aws_byte_cursor* %2) #0 !dbg !1719 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca %struct.aws_byte_cursor*, align 4
  %7 = alloca %struct.aws_byte_cursor*, align 4
  %8 = alloca %struct.aws_byte_cursor, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i32, align 4
  %11 = alloca %struct.aws_byte_cursor, align 4
  %12 = alloca %struct.aws_byte_cursor, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !1723, metadata !DIExpression()), !dbg !1729
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %6, metadata !1724, metadata !DIExpression()), !dbg !1730
  store %struct.aws_byte_cursor* %2, %struct.aws_byte_cursor** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %7, metadata !1725, metadata !DIExpression()), !dbg !1731
  %13 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1732, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %13, i32 0, i32 0, !dbg !1734
  %15 = load i32, i32* %14, align 4, !dbg !1734, !tbaa !822
  %16 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1735, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %16, i32 0, i32 0, !dbg !1736
  %18 = load i32, i32* %17, align 4, !dbg !1736, !tbaa !822
  %19 = icmp ugt i32 %15, %18, !dbg !1737
  br i1 %19, label %20, label %22, !dbg !1738

20:                                               ; preds = %3
  %21 = call i32 @aws_raise_error(i32 48) #17, !dbg !1739
  store i32 %21, i32* %4, align 4, !dbg !1741
  br label %97, !dbg !1741

22:                                               ; preds = %3
  %23 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1742, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %23, i32 0, i32 0, !dbg !1744
  %25 = load i32, i32* %24, align 4, !dbg !1744, !tbaa !822
  %26 = icmp ult i32 %25, 1, !dbg !1745
  br i1 %26, label %27, label %29, !dbg !1746

27:                                               ; preds = %22
  %28 = call i32 @aws_raise_error(i32 4) #17, !dbg !1747
  store i32 %28, i32* %4, align 4, !dbg !1749
  br label %97, !dbg !1749

29:                                               ; preds = %22
  %30 = bitcast %struct.aws_byte_cursor* %8 to i8*, !dbg !1750
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %30) #19, !dbg !1750
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %8, metadata !1726, metadata !DIExpression()), !dbg !1751
  %31 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !1752, !tbaa !657
  %32 = bitcast %struct.aws_byte_cursor* %8 to i8*, !dbg !1753
  %33 = bitcast %struct.aws_byte_cursor* %31 to i8*, !dbg !1753
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %32, i8* align 4 %33, i32 8, i1 false), !dbg !1753, !tbaa.struct !1474
  br label %34, !dbg !1754

34:                                               ; preds = %92, %29
  %35 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 0, !dbg !1755
  %36 = load i32, i32* %35, align 4, !dbg !1755, !tbaa !822
  %37 = icmp ne i32 %36, 0, !dbg !1754
  br i1 %37, label %38, label %93, !dbg !1754

38:                                               ; preds = %34
  %39 = bitcast i8** %9 to i8*, !dbg !1756
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %39) #19, !dbg !1756
  call void @llvm.dbg.declare(metadata i8** %9, metadata !1727, metadata !DIExpression()), !dbg !1757
  %40 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 1, !dbg !1758
  %41 = load i8*, i8** %40, align 4, !dbg !1758, !tbaa !832
  %42 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1759, !tbaa !657
  %43 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %42, i32 0, i32 1, !dbg !1760
  %44 = load i8*, i8** %43, align 4, !dbg !1760, !tbaa !832
  %45 = load i8, i8* %44, align 1, !dbg !1761, !tbaa !1034
  %46 = sext i8 %45 to i32, !dbg !1762
  %47 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 0, !dbg !1763
  %48 = load i32, i32* %47, align 4, !dbg !1763, !tbaa !822
  %49 = call i8* @memchr(i8* %41, i32 %46, i32 %48) #17, !dbg !1764
  store i8* %49, i8** %9, align 4, !dbg !1757, !tbaa !657
  %50 = load i8*, i8** %9, align 4, !dbg !1765, !tbaa !657
  %51 = icmp ne i8* %50, null, !dbg !1765
  br i1 %51, label %54, label %52, !dbg !1767

52:                                               ; preds = %38
  %53 = call i32 @aws_raise_error(i32 48) #17, !dbg !1768
  store i32 %53, i32* %4, align 4, !dbg !1770
  store i32 1, i32* %10, align 4
  br label %89, !dbg !1770

54:                                               ; preds = %38
  %55 = load i8*, i8** %9, align 4, !dbg !1771, !tbaa !657
  %56 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 1, !dbg !1772
  %57 = load i8*, i8** %56, align 4, !dbg !1772, !tbaa !832
  %58 = ptrtoint i8* %55 to i32, !dbg !1773
  %59 = ptrtoint i8* %57 to i32, !dbg !1773
  %60 = sub i32 %58, %59, !dbg !1773
  %61 = bitcast %struct.aws_byte_cursor* %11 to i8*, !dbg !1774
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %61) #19, !dbg !1774
  call void @aws_byte_cursor_advance(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %11, %struct.aws_byte_cursor* %8, i32 %60) #17, !dbg !1774
  %62 = bitcast %struct.aws_byte_cursor* %11 to i8*, !dbg !1774
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %62) #19, !dbg !1774
  %63 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 0, !dbg !1775
  %64 = load i32, i32* %63, align 4, !dbg !1775, !tbaa !822
  %65 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1777, !tbaa !657
  %66 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %65, i32 0, i32 0, !dbg !1778
  %67 = load i32, i32* %66, align 4, !dbg !1778, !tbaa !822
  %68 = icmp ult i32 %64, %67, !dbg !1779
  br i1 %68, label %69, label %71, !dbg !1780

69:                                               ; preds = %54
  %70 = call i32 @aws_raise_error(i32 48) #17, !dbg !1781
  store i32 %70, i32* %4, align 4, !dbg !1783
  store i32 1, i32* %10, align 4
  br label %89, !dbg !1783

71:                                               ; preds = %54
  %72 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 1, !dbg !1784
  %73 = load i8*, i8** %72, align 4, !dbg !1784, !tbaa !832
  %74 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1786, !tbaa !657
  %75 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %74, i32 0, i32 1, !dbg !1787
  %76 = load i8*, i8** %75, align 4, !dbg !1787, !tbaa !832
  %77 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !1788, !tbaa !657
  %78 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %77, i32 0, i32 0, !dbg !1789
  %79 = load i32, i32* %78, align 4, !dbg !1789, !tbaa !822
  %80 = call i32 @memcmp(i8* %73, i8* %76, i32 %79) #17, !dbg !1790
  %81 = icmp ne i32 %80, 0, !dbg !1790
  br i1 %81, label %86, label %82, !dbg !1791

82:                                               ; preds = %71
  %83 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %7, align 4, !dbg !1792, !tbaa !657
  %84 = bitcast %struct.aws_byte_cursor* %83 to i8*, !dbg !1794
  %85 = bitcast %struct.aws_byte_cursor* %8 to i8*, !dbg !1794
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %84, i8* align 4 %85, i32 8, i1 false), !dbg !1794, !tbaa.struct !1474
  store i32 0, i32* %4, align 4, !dbg !1795
  store i32 1, i32* %10, align 4
  br label %89, !dbg !1795

86:                                               ; preds = %71
  %87 = bitcast %struct.aws_byte_cursor* %12 to i8*, !dbg !1796
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %87) #19, !dbg !1796
  call void @aws_byte_cursor_advance(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %12, %struct.aws_byte_cursor* %8, i32 1) #17, !dbg !1796
  %88 = bitcast %struct.aws_byte_cursor* %12 to i8*, !dbg !1796
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %88) #19, !dbg !1796
  store i32 0, i32* %10, align 4, !dbg !1797
  br label %89, !dbg !1797

89:                                               ; preds = %86, %82, %69, %52
  %90 = bitcast i8** %9 to i8*, !dbg !1797
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %90) #19, !dbg !1797
  %91 = load i32, i32* %10, align 4
  switch i32 %91, label %95 [
    i32 0, label %92
  ]

92:                                               ; preds = %89
  br label %34, !dbg !1754, !llvm.loop !1798

93:                                               ; preds = %34
  %94 = call i32 @aws_raise_error(i32 48) #17, !dbg !1799
  store i32 %94, i32* %4, align 4, !dbg !1800
  store i32 1, i32* %10, align 4
  br label %95, !dbg !1800

95:                                               ; preds = %93, %89
  %96 = bitcast %struct.aws_byte_cursor* %8 to i8*, !dbg !1801
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %96) #19, !dbg !1801
  br label %97

97:                                               ; preds = %95, %27, %20
  %98 = load i32, i32* %4, align 4, !dbg !1801
  ret i32 %98, !dbg !1801
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_advance(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %1, i32 %2) #0 !dbg !1802 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i32, align 4
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !1807, metadata !DIExpression()), !dbg !1810
  store i32 %2, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !1808, metadata !DIExpression()), !dbg !1811
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !1809, metadata !DIExpression()), !dbg !1812
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1813, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 0, !dbg !1815
  %8 = load i32, i32* %7, align 4, !dbg !1815, !tbaa !822
  %9 = icmp ugt i32 %8, 2147483647, !dbg !1816
  br i1 %9, label %19, label %10, !dbg !1817

10:                                               ; preds = %3
  %11 = load i32, i32* %5, align 4, !dbg !1818, !tbaa !663
  %12 = icmp ugt i32 %11, 2147483647, !dbg !1819
  br i1 %12, label %19, label %13, !dbg !1820

13:                                               ; preds = %10
  %14 = load i32, i32* %5, align 4, !dbg !1821, !tbaa !663
  %15 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1822, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %15, i32 0, i32 0, !dbg !1823
  %17 = load i32, i32* %16, align 4, !dbg !1823, !tbaa !822
  %18 = icmp ugt i32 %14, %17, !dbg !1824
  br i1 %18, label %19, label %22, !dbg !1825

19:                                               ; preds = %13, %10, %3
  %20 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !1826
  store i8* null, i8** %20, align 4, !dbg !1828, !tbaa !832
  %21 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !1829
  store i32 0, i32* %21, align 4, !dbg !1830, !tbaa !822
  br label %49, !dbg !1831

22:                                               ; preds = %13
  %23 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1832, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %23, i32 0, i32 1, !dbg !1834
  %25 = load i8*, i8** %24, align 4, !dbg !1834, !tbaa !832
  %26 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !1835
  store i8* %25, i8** %26, align 4, !dbg !1836, !tbaa !832
  %27 = load i32, i32* %5, align 4, !dbg !1837, !tbaa !663
  %28 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !1838
  store i32 %27, i32* %28, align 4, !dbg !1839, !tbaa !822
  %29 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1840, !tbaa !657
  %30 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %29, i32 0, i32 1, !dbg !1841
  %31 = load i8*, i8** %30, align 4, !dbg !1841, !tbaa !832
  %32 = icmp eq i8* %31, null, !dbg !1842
  br i1 %32, label %33, label %34, !dbg !1843

33:                                               ; preds = %22
  br label %40, !dbg !1843

34:                                               ; preds = %22
  %35 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1844, !tbaa !657
  %36 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %35, i32 0, i32 1, !dbg !1845
  %37 = load i8*, i8** %36, align 4, !dbg !1845, !tbaa !832
  %38 = load i32, i32* %5, align 4, !dbg !1846, !tbaa !663
  %39 = getelementptr inbounds i8, i8* %37, i32 %38, !dbg !1847
  br label %40, !dbg !1843

40:                                               ; preds = %34, %33
  %41 = phi i8* [ null, %33 ], [ %39, %34 ], !dbg !1843
  %42 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1848, !tbaa !657
  %43 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %42, i32 0, i32 1, !dbg !1849
  store i8* %41, i8** %43, align 4, !dbg !1850, !tbaa !832
  %44 = load i32, i32* %5, align 4, !dbg !1851, !tbaa !663
  %45 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1852, !tbaa !657
  %46 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %45, i32 0, i32 0, !dbg !1853
  %47 = load i32, i32* %46, align 4, !dbg !1854, !tbaa !822
  %48 = sub i32 %47, %44, !dbg !1854
  store i32 %48, i32* %46, align 4, !dbg !1854, !tbaa !822
  br label %49

49:                                               ; preds = %40, %19
  ret void, !dbg !1855
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_cat(%struct.aws_byte_buf* %0, i32 %1, ...) #0 !dbg !1856 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  %9 = alloca %struct.aws_byte_buf*, align 4
  %10 = alloca %struct.aws_byte_cursor, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !1860, metadata !DIExpression()), !dbg !1869
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !1861, metadata !DIExpression()), !dbg !1870
  %11 = bitcast i8** %6 to i8*, !dbg !1871
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %11) #19, !dbg !1871
  call void @llvm.dbg.declare(metadata i8** %6, metadata !1862, metadata !DIExpression()), !dbg !1872
  %12 = bitcast i8** %6 to i8*, !dbg !1873
  call void @llvm.va_start(i8* %12), !dbg !1873
  %13 = bitcast i32* %7 to i8*, !dbg !1874
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %13) #19, !dbg !1874
  call void @llvm.dbg.declare(metadata i32* %7, metadata !1863, metadata !DIExpression()), !dbg !1875
  store i32 0, i32* %7, align 4, !dbg !1875, !tbaa !663
  br label %14, !dbg !1874

14:                                               ; preds = %38, %2
  %15 = load i32, i32* %7, align 4, !dbg !1876, !tbaa !663
  %16 = load i32, i32* %5, align 4, !dbg !1877, !tbaa !663
  %17 = icmp ult i32 %15, %16, !dbg !1878
  br i1 %17, label %19, label %18, !dbg !1879

18:                                               ; preds = %14
  store i32 2, i32* %8, align 4
  br label %41, !dbg !1879

19:                                               ; preds = %14
  %20 = bitcast %struct.aws_byte_buf** %9 to i8*, !dbg !1880
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %20) #19, !dbg !1880
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %9, metadata !1865, metadata !DIExpression()), !dbg !1881
  %21 = load i8*, i8** %6, align 4, !dbg !1882
  %22 = getelementptr inbounds i8, i8* %21, i32 4, !dbg !1882
  store i8* %22, i8** %6, align 4, !dbg !1882
  %23 = bitcast i8* %21 to %struct.aws_byte_buf**, !dbg !1882
  %24 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %23, align 4, !dbg !1882
  store %struct.aws_byte_buf* %24, %struct.aws_byte_buf** %9, align 4, !dbg !1881, !tbaa !657
  %25 = bitcast %struct.aws_byte_cursor* %10 to i8*, !dbg !1883
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %25) #19, !dbg !1883
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %10, metadata !1868, metadata !DIExpression()), !dbg !1884
  %26 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %9, align 4, !dbg !1885, !tbaa !657
  call void @aws_byte_cursor_from_buf(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %10, %struct.aws_byte_buf* %26) #17, !dbg !1886
  %27 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !1887, !tbaa !657
  %28 = call i32 @aws_byte_buf_append(%struct.aws_byte_buf* %27, %struct.aws_byte_cursor* %10) #17, !dbg !1889
  %29 = icmp ne i32 %28, 0, !dbg !1889
  br i1 %29, label %30, label %32, !dbg !1890

30:                                               ; preds = %19
  %31 = bitcast i8** %6 to i8*, !dbg !1891
  call void @llvm.va_end(i8* %31), !dbg !1891
  store i32 -1, i32* %3, align 4, !dbg !1893
  store i32 1, i32* %8, align 4
  br label %33, !dbg !1893

32:                                               ; preds = %19
  store i32 0, i32* %8, align 4, !dbg !1894
  br label %33, !dbg !1894

33:                                               ; preds = %32, %30
  %34 = bitcast %struct.aws_byte_cursor* %10 to i8*, !dbg !1894
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %34) #19, !dbg !1894
  %35 = bitcast %struct.aws_byte_buf** %9 to i8*, !dbg !1894
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %35) #19, !dbg !1894
  %36 = load i32, i32* %8, align 4
  switch i32 %36, label %41 [
    i32 0, label %37
  ]

37:                                               ; preds = %33
  br label %38, !dbg !1895

38:                                               ; preds = %37
  %39 = load i32, i32* %7, align 4, !dbg !1896, !tbaa !663
  %40 = add i32 %39, 1, !dbg !1896
  store i32 %40, i32* %7, align 4, !dbg !1896, !tbaa !663
  br label %14, !dbg !1897, !llvm.loop !1898

41:                                               ; preds = %33, %18
  %42 = bitcast i32* %7 to i8*, !dbg !1897
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %42) #19, !dbg !1897
  %43 = load i32, i32* %8, align 4
  switch i32 %43, label %46 [
    i32 2, label %44
  ]

44:                                               ; preds = %41
  %45 = bitcast i8** %6 to i8*, !dbg !1900
  call void @llvm.va_end(i8* %45), !dbg !1900
  store i32 0, i32* %3, align 4, !dbg !1901
  store i32 1, i32* %8, align 4
  br label %46, !dbg !1901

46:                                               ; preds = %44, %41
  %47 = bitcast i8** %6 to i8*, !dbg !1902
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %47) #19, !dbg !1902
  %48 = load i32, i32* %3, align 4, !dbg !1902
  ret i32 %48, !dbg !1902
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_from_buf(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_buf* %1) #0 !dbg !1903 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !1907, metadata !DIExpression()), !dbg !1909
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !1908, metadata !DIExpression()), !dbg !1910
  %4 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !1911, !tbaa !657
  %5 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %4, i32 0, i32 1, !dbg !1912
  %6 = load i8*, i8** %5, align 4, !dbg !1912, !tbaa !675
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !1913
  store i8* %6, i8** %7, align 4, !dbg !1914, !tbaa !832
  %8 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !1915, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %8, i32 0, i32 0, !dbg !1916
  %10 = load i32, i32* %9, align 4, !dbg !1916, !tbaa !693
  %11 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !1917
  store i32 %10, i32* %11, align 4, !dbg !1918, !tbaa !822
  ret void, !dbg !1919
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_eq(%struct.aws_byte_cursor* %0, %struct.aws_byte_cursor* %1) #0 !dbg !1920 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !1924, metadata !DIExpression()), !dbg !1927
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !1925, metadata !DIExpression()), !dbg !1928
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !1929
  call void @llvm.dbg.declare(metadata i8* %5, metadata !1926, metadata !DIExpression()), !dbg !1930
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !1931, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 1, !dbg !1932
  %8 = load i8*, i8** %7, align 4, !dbg !1932, !tbaa !832
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !1933, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !1934
  %11 = load i32, i32* %10, align 4, !dbg !1934, !tbaa !822
  %12 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1935, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %12, i32 0, i32 1, !dbg !1936
  %14 = load i8*, i8** %13, align 4, !dbg !1936, !tbaa !832
  %15 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1937, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %15, i32 0, i32 0, !dbg !1938
  %17 = load i32, i32* %16, align 4, !dbg !1938, !tbaa !822
  %18 = call zeroext i1 @aws_array_eq(i8* %8, i32 %11, i8* %14, i32 %17) #17, !dbg !1939
  %19 = zext i1 %18 to i8, !dbg !1930
  store i8 %19, i8* %5, align 1, !dbg !1930, !tbaa !844
  %20 = load i8, i8* %5, align 1, !dbg !1940, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !1940
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !1941
  ret i1 %21, !dbg !1942
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_eq_ignore_case(%struct.aws_byte_cursor* %0, %struct.aws_byte_cursor* %1) #0 !dbg !1943 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !1945, metadata !DIExpression()), !dbg !1948
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !1946, metadata !DIExpression()), !dbg !1949
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !1950
  call void @llvm.dbg.declare(metadata i8* %5, metadata !1947, metadata !DIExpression()), !dbg !1951
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !1952, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 1, !dbg !1953
  %8 = load i8*, i8** %7, align 4, !dbg !1953, !tbaa !832
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !1954, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !1955
  %11 = load i32, i32* %10, align 4, !dbg !1955, !tbaa !822
  %12 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1956, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %12, i32 0, i32 1, !dbg !1957
  %14 = load i8*, i8** %13, align 4, !dbg !1957, !tbaa !832
  %15 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !1958, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %15, i32 0, i32 0, !dbg !1959
  %17 = load i32, i32* %16, align 4, !dbg !1959, !tbaa !822
  %18 = call zeroext i1 @aws_array_eq_ignore_case(i8* %8, i32 %11, i8* %14, i32 %17) #17, !dbg !1960
  %19 = zext i1 %18 to i8, !dbg !1951
  store i8 %19, i8* %5, align 1, !dbg !1951, !tbaa !844
  %20 = load i8, i8* %5, align 1, !dbg !1961, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !1961
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !1962
  ret i1 %21, !dbg !1963
}

; Function Attrs: nounwind ssp
define i8* @aws_lookup_table_to_lower_get() #0 !dbg !1964 {
  ret i8* getelementptr inbounds ([256 x i8], [256 x i8]* @s_tolower_table, i32 0, i32 0), !dbg !1967
}

; Function Attrs: nounwind ssp
define i64 @aws_hash_array_ignore_case(i8* %0, i32 %1) #0 !dbg !1968 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i64, align 8
  %6 = alloca i64, align 8
  %7 = alloca i8*, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i64, align 8
  %10 = alloca i8, align 1
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !1972, metadata !DIExpression()), !dbg !1982
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !1973, metadata !DIExpression()), !dbg !1983
  %11 = bitcast i64* %5 to i8*, !dbg !1984
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %11) #19, !dbg !1984
  call void @llvm.dbg.declare(metadata i64* %5, metadata !1974, metadata !DIExpression()), !dbg !1985
  store i64 -3750763034362895579, i64* %5, align 8, !dbg !1985, !tbaa !1986
  %12 = bitcast i64* %6 to i8*, !dbg !1988
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %12) #19, !dbg !1988
  call void @llvm.dbg.declare(metadata i64* %6, metadata !1976, metadata !DIExpression()), !dbg !1989
  store i64 1099511628211, i64* %6, align 8, !dbg !1989, !tbaa !1986
  %13 = bitcast i8** %7 to i8*, !dbg !1990
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %13) #19, !dbg !1990
  call void @llvm.dbg.declare(metadata i8** %7, metadata !1977, metadata !DIExpression()), !dbg !1991
  %14 = load i8*, i8** %3, align 4, !dbg !1992, !tbaa !657
  store i8* %14, i8** %7, align 4, !dbg !1991, !tbaa !657
  %15 = bitcast i8** %8 to i8*, !dbg !1993
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !1993
  call void @llvm.dbg.declare(metadata i8** %8, metadata !1978, metadata !DIExpression()), !dbg !1994
  %16 = load i8*, i8** %7, align 4, !dbg !1995, !tbaa !657
  %17 = icmp eq i8* %16, null, !dbg !1996
  br i1 %17, label %18, label %19, !dbg !1997

18:                                               ; preds = %2
  br label %23, !dbg !1997

19:                                               ; preds = %2
  %20 = load i8*, i8** %7, align 4, !dbg !1998, !tbaa !657
  %21 = load i32, i32* %4, align 4, !dbg !1999, !tbaa !663
  %22 = getelementptr inbounds i8, i8* %20, i32 %21, !dbg !2000
  br label %23, !dbg !1997

23:                                               ; preds = %19, %18
  %24 = phi i8* [ null, %18 ], [ %22, %19 ], !dbg !1997
  store i8* %24, i8** %8, align 4, !dbg !1994, !tbaa !657
  %25 = bitcast i64* %9 to i8*, !dbg !2001
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %25) #19, !dbg !2001
  call void @llvm.dbg.declare(metadata i64* %9, metadata !1979, metadata !DIExpression()), !dbg !2002
  store i64 -3750763034362895579, i64* %9, align 8, !dbg !2002, !tbaa !1986
  br label %26, !dbg !2003

26:                                               ; preds = %30, %23
  %27 = load i8*, i8** %7, align 4, !dbg !2004, !tbaa !657
  %28 = load i8*, i8** %8, align 4, !dbg !2005, !tbaa !657
  %29 = icmp ne i8* %27, %28, !dbg !2006
  br i1 %29, label %30, label %43, !dbg !2003

30:                                               ; preds = %26
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %10) #19, !dbg !2007
  call void @llvm.dbg.declare(metadata i8* %10, metadata !1980, metadata !DIExpression()), !dbg !2008
  %31 = load i8*, i8** %7, align 4, !dbg !2009, !tbaa !657
  %32 = getelementptr inbounds i8, i8* %31, i32 1, !dbg !2009
  store i8* %32, i8** %7, align 4, !dbg !2009, !tbaa !657
  %33 = load i8, i8* %31, align 1, !dbg !2010, !tbaa !1034
  %34 = zext i8 %33 to i32, !dbg !2011
  %35 = getelementptr inbounds [256 x i8], [256 x i8]* @s_tolower_table, i32 0, i32 %34, !dbg !2011
  %36 = load i8, i8* %35, align 1, !dbg !2011, !tbaa !1034
  store i8 %36, i8* %10, align 1, !dbg !2008, !tbaa !1034
  %37 = load i8, i8* %10, align 1, !dbg !2012, !tbaa !1034
  %38 = zext i8 %37 to i64, !dbg !2012
  %39 = load i64, i64* %9, align 8, !dbg !2013, !tbaa !1986
  %40 = xor i64 %39, %38, !dbg !2013
  store i64 %40, i64* %9, align 8, !dbg !2013, !tbaa !1986
  %41 = load i64, i64* %9, align 8, !dbg !2014, !tbaa !1986
  %42 = mul i64 %41, 1099511628211, !dbg !2014
  store i64 %42, i64* %9, align 8, !dbg !2014, !tbaa !1986
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %10) #19, !dbg !2015
  br label %26, !dbg !2003, !llvm.loop !2016

43:                                               ; preds = %26
  %44 = load i64, i64* %9, align 8, !dbg !2017, !tbaa !1986
  %45 = bitcast i64* %9 to i8*, !dbg !2018
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %45) #19, !dbg !2018
  %46 = bitcast i8** %8 to i8*, !dbg !2018
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %46) #19, !dbg !2018
  %47 = bitcast i8** %7 to i8*, !dbg !2018
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %47) #19, !dbg !2018
  %48 = bitcast i64* %6 to i8*, !dbg !2018
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %48) #19, !dbg !2018
  %49 = bitcast i64* %5 to i8*, !dbg !2018
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %49) #19, !dbg !2018
  ret i64 %44, !dbg !2019
}

; Function Attrs: nounwind ssp
define i64 @aws_hash_byte_cursor_ptr_ignore_case(i8* %0) #0 !dbg !2020 {
  %2 = alloca i8*, align 4
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i64, align 8
  store i8* %0, i8** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %2, metadata !2022, metadata !DIExpression()), !dbg !2026
  %5 = bitcast %struct.aws_byte_cursor** %3 to i8*, !dbg !2027
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %5) #19, !dbg !2027
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !2023, metadata !DIExpression()), !dbg !2028
  %6 = load i8*, i8** %2, align 4, !dbg !2029, !tbaa !657
  %7 = bitcast i8* %6 to %struct.aws_byte_cursor*, !dbg !2029
  store %struct.aws_byte_cursor* %7, %struct.aws_byte_cursor** %3, align 4, !dbg !2028, !tbaa !657
  %8 = bitcast i64* %4 to i8*, !dbg !2030
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %8) #19, !dbg !2030
  call void @llvm.dbg.declare(metadata i64* %4, metadata !2025, metadata !DIExpression()), !dbg !2031
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2032, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 1, !dbg !2033
  %11 = load i8*, i8** %10, align 4, !dbg !2033, !tbaa !832
  %12 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2034, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %12, i32 0, i32 0, !dbg !2035
  %14 = load i32, i32* %13, align 4, !dbg !2035, !tbaa !822
  %15 = call i64 @aws_hash_array_ignore_case(i8* %11, i32 %14) #17, !dbg !2036
  store i64 %15, i64* %4, align 8, !dbg !2031, !tbaa !1986
  %16 = load i64, i64* %4, align 8, !dbg !2037, !tbaa !1986
  %17 = bitcast i64* %4 to i8*, !dbg !2038
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %17) #19, !dbg !2038
  %18 = bitcast %struct.aws_byte_cursor** %3 to i8*, !dbg !2038
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %18) #19, !dbg !2038
  ret i64 %16, !dbg !2039
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_eq_byte_buf(%struct.aws_byte_cursor* %0, %struct.aws_byte_buf* %1) #0 !dbg !2040 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !2044, metadata !DIExpression()), !dbg !2047
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !2045, metadata !DIExpression()), !dbg !2048
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !2049
  call void @llvm.dbg.declare(metadata i8* %5, metadata !2046, metadata !DIExpression()), !dbg !2050
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2051, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 1, !dbg !2052
  %8 = load i8*, i8** %7, align 4, !dbg !2052, !tbaa !832
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2053, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !2054
  %11 = load i32, i32* %10, align 4, !dbg !2054, !tbaa !822
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2055, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 1, !dbg !2056
  %14 = load i8*, i8** %13, align 4, !dbg !2056, !tbaa !675
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2057, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 0, !dbg !2058
  %17 = load i32, i32* %16, align 4, !dbg !2058, !tbaa !693
  %18 = call zeroext i1 @aws_array_eq(i8* %8, i32 %11, i8* %14, i32 %17) #17, !dbg !2059
  %19 = zext i1 %18 to i8, !dbg !2050
  store i8 %19, i8* %5, align 1, !dbg !2050, !tbaa !844
  %20 = load i8, i8* %5, align 1, !dbg !2060, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !2060
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !2061
  ret i1 %21, !dbg !2062
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_eq_byte_buf_ignore_case(%struct.aws_byte_cursor* %0, %struct.aws_byte_buf* %1) #0 !dbg !2063 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !2065, metadata !DIExpression()), !dbg !2068
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !2066, metadata !DIExpression()), !dbg !2069
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !2070
  call void @llvm.dbg.declare(metadata i8* %5, metadata !2067, metadata !DIExpression()), !dbg !2071
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2072, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 1, !dbg !2073
  %8 = load i8*, i8** %7, align 4, !dbg !2073, !tbaa !832
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2074, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !2075
  %11 = load i32, i32* %10, align 4, !dbg !2075, !tbaa !822
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2076, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 1, !dbg !2077
  %14 = load i8*, i8** %13, align 4, !dbg !2077, !tbaa !675
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2078, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 0, !dbg !2079
  %17 = load i32, i32* %16, align 4, !dbg !2079, !tbaa !693
  %18 = call zeroext i1 @aws_array_eq_ignore_case(i8* %8, i32 %11, i8* %14, i32 %17) #17, !dbg !2080
  %19 = zext i1 %18 to i8, !dbg !2071
  store i8 %19, i8* %5, align 1, !dbg !2071, !tbaa !844
  %20 = load i8, i8* %5, align 1, !dbg !2081, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !2081
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !2082
  ret i1 %21, !dbg !2083
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_eq_c_str(%struct.aws_byte_cursor* %0, i8* %1) #0 !dbg !2084 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !2088, metadata !DIExpression()), !dbg !2091
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !2089, metadata !DIExpression()), !dbg !2092
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !2093
  call void @llvm.dbg.declare(metadata i8* %5, metadata !2090, metadata !DIExpression()), !dbg !2094
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2095, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 1, !dbg !2096
  %8 = load i8*, i8** %7, align 4, !dbg !2096, !tbaa !832
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2097, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !2098
  %11 = load i32, i32* %10, align 4, !dbg !2098, !tbaa !822
  %12 = load i8*, i8** %4, align 4, !dbg !2099, !tbaa !657
  %13 = call zeroext i1 @aws_array_eq_c_str(i8* %8, i32 %11, i8* %12) #17, !dbg !2100
  %14 = zext i1 %13 to i8, !dbg !2094
  store i8 %14, i8* %5, align 1, !dbg !2094, !tbaa !844
  %15 = load i8, i8* %5, align 1, !dbg !2101, !tbaa !844, !range !849
  %16 = trunc i8 %15 to i1, !dbg !2101
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !2102
  ret i1 %16, !dbg !2103
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_eq_c_str_ignore_case(%struct.aws_byte_cursor* %0, i8* %1) #0 !dbg !2104 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !2106, metadata !DIExpression()), !dbg !2109
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !2107, metadata !DIExpression()), !dbg !2110
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !2111
  call void @llvm.dbg.declare(metadata i8* %5, metadata !2108, metadata !DIExpression()), !dbg !2112
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2113, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %6, i32 0, i32 1, !dbg !2114
  %8 = load i8*, i8** %7, align 4, !dbg !2114, !tbaa !832
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2115, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !2116
  %11 = load i32, i32* %10, align 4, !dbg !2116, !tbaa !822
  %12 = load i8*, i8** %4, align 4, !dbg !2117, !tbaa !657
  %13 = call zeroext i1 @aws_array_eq_c_str_ignore_case(i8* %8, i32 %11, i8* %12) #17, !dbg !2118
  %14 = zext i1 %13 to i8, !dbg !2112
  store i8 %14, i8* %5, align 1, !dbg !2112, !tbaa !844
  %15 = load i8, i8* %5, align 1, !dbg !2119, !tbaa !844, !range !849
  %16 = trunc i8 %15 to i1, !dbg !2119
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !2120
  ret i1 %16, !dbg !2121
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_with_lookup(%struct.aws_byte_buf* noalias %0, %struct.aws_byte_cursor* noalias %1, i8* %2) #0 !dbg !2122 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca %struct.aws_byte_cursor*, align 4
  %7 = alloca i8*, align 4
  %8 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !2127, metadata !DIExpression()), !dbg !2132
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %6, metadata !2128, metadata !DIExpression()), !dbg !2133
  store i8* %2, i8** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %7, metadata !2129, metadata !DIExpression()), !dbg !2134
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2135, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 2, !dbg !2137
  %11 = load i32, i32* %10, align 4, !dbg !2137, !tbaa !698
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2138, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 0, !dbg !2139
  %14 = load i32, i32* %13, align 4, !dbg !2139, !tbaa !693
  %15 = sub i32 %11, %14, !dbg !2140
  %16 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2141, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %16, i32 0, i32 0, !dbg !2142
  %18 = load i32, i32* %17, align 4, !dbg !2142, !tbaa !822
  %19 = icmp ult i32 %15, %18, !dbg !2143
  br i1 %19, label %20, label %22, !dbg !2144

20:                                               ; preds = %3
  %21 = call i32 @aws_raise_error(i32 26) #17, !dbg !2145
  store i32 %21, i32* %4, align 4, !dbg !2147
  br label %68, !dbg !2147

22:                                               ; preds = %3
  %23 = bitcast i32* %8 to i8*, !dbg !2148
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %23) #19, !dbg !2148
  call void @llvm.dbg.declare(metadata i32* %8, metadata !2130, metadata !DIExpression()), !dbg !2149
  store i32 0, i32* %8, align 4, !dbg !2149, !tbaa !663
  br label %24, !dbg !2148

24:                                               ; preds = %52, %22
  %25 = load i32, i32* %8, align 4, !dbg !2150, !tbaa !663
  %26 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2152, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %26, i32 0, i32 0, !dbg !2153
  %28 = load i32, i32* %27, align 4, !dbg !2153, !tbaa !822
  %29 = icmp ult i32 %25, %28, !dbg !2154
  br i1 %29, label %32, label %30, !dbg !2155

30:                                               ; preds = %24
  %31 = bitcast i32* %8 to i8*, !dbg !2156
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %31) #19, !dbg !2156
  br label %55

32:                                               ; preds = %24
  %33 = load i8*, i8** %7, align 4, !dbg !2157, !tbaa !657
  %34 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2159, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %34, i32 0, i32 1, !dbg !2160
  %36 = load i8*, i8** %35, align 4, !dbg !2160, !tbaa !832
  %37 = load i32, i32* %8, align 4, !dbg !2161, !tbaa !663
  %38 = getelementptr inbounds i8, i8* %36, i32 %37, !dbg !2159
  %39 = load i8, i8* %38, align 1, !dbg !2159, !tbaa !1034
  %40 = zext i8 %39 to i32, !dbg !2157
  %41 = getelementptr inbounds i8, i8* %33, i32 %40, !dbg !2157
  %42 = load i8, i8* %41, align 1, !dbg !2157, !tbaa !1034
  %43 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2162, !tbaa !657
  %44 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %43, i32 0, i32 1, !dbg !2163
  %45 = load i8*, i8** %44, align 4, !dbg !2163, !tbaa !675
  %46 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2164, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %46, i32 0, i32 0, !dbg !2165
  %48 = load i32, i32* %47, align 4, !dbg !2165, !tbaa !693
  %49 = load i32, i32* %8, align 4, !dbg !2166, !tbaa !663
  %50 = add i32 %48, %49, !dbg !2167
  %51 = getelementptr inbounds i8, i8* %45, i32 %50, !dbg !2162
  store i8 %42, i8* %51, align 1, !dbg !2168, !tbaa !1034
  br label %52, !dbg !2169

52:                                               ; preds = %32
  %53 = load i32, i32* %8, align 4, !dbg !2170, !tbaa !663
  %54 = add i32 %53, 1, !dbg !2170
  store i32 %54, i32* %8, align 4, !dbg !2170, !tbaa !663
  br label %24, !dbg !2156, !llvm.loop !2171

55:                                               ; preds = %30
  %56 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2173, !tbaa !657
  %57 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %56, i32 0, i32 0, !dbg !2175
  %58 = load i32, i32* %57, align 4, !dbg !2175, !tbaa !693
  %59 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2176, !tbaa !657
  %60 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %59, i32 0, i32 0, !dbg !2177
  %61 = load i32, i32* %60, align 4, !dbg !2177, !tbaa !822
  %62 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2178, !tbaa !657
  %63 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %62, i32 0, i32 0, !dbg !2179
  %64 = call i32 @aws_add_size_checked(i32 %58, i32 %61, i32* %63) #17, !dbg !2180
  %65 = icmp ne i32 %64, 0, !dbg !2180
  br i1 %65, label %66, label %67, !dbg !2181

66:                                               ; preds = %55
  store i32 -1, i32* %4, align 4, !dbg !2182
  br label %68, !dbg !2182

67:                                               ; preds = %55
  store i32 0, i32* %4, align 4, !dbg !2184
  br label %68, !dbg !2184

68:                                               ; preds = %67, %66, %20
  %69 = load i32, i32* %4, align 4, !dbg !2185
  ret i32 %69, !dbg !2185
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_dynamic(%struct.aws_byte_buf* %0, %struct.aws_byte_cursor* %1) #0 !dbg !2186 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca %struct.aws_byte_cursor*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !2188, metadata !DIExpression()), !dbg !2190
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2189, metadata !DIExpression()), !dbg !2191
  %5 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !2192, !tbaa !657
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2193, !tbaa !657
  %7 = call i32 @s_aws_byte_buf_append_dynamic(%struct.aws_byte_buf* %5, %struct.aws_byte_cursor* %6, i1 zeroext false) #17, !dbg !2194
  ret i32 %7, !dbg !2195
}

; Function Attrs: nounwind ssp
define internal i32 @s_aws_byte_buf_append_dynamic(%struct.aws_byte_buf* %0, %struct.aws_byte_cursor* %1, i1 zeroext %2) #0 !dbg !2196 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca %struct.aws_byte_cursor*, align 4
  %7 = alloca i8, align 1
  %8 = alloca i32, align 4
  %9 = alloca i32, align 4
  %10 = alloca i32, align 4
  %11 = alloca i32, align 4
  %12 = alloca i32, align 4
  %13 = alloca i8*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !2200, metadata !DIExpression()), !dbg !2210
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %6, metadata !2201, metadata !DIExpression()), !dbg !2211
  %14 = zext i1 %2 to i8
  store i8 %14, i8* %7, align 1, !tbaa !844
  call void @llvm.dbg.declare(metadata i8* %7, metadata !2202, metadata !DIExpression()), !dbg !2212
  br label %15, !dbg !2213

15:                                               ; preds = %3
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2214, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %16, i32 0, i32 3, !dbg !2214
  %18 = load %struct.aws_allocator*, %struct.aws_allocator** %17, align 4, !dbg !2214, !tbaa !703
  %19 = icmp ne %struct.aws_allocator* %18, null, !dbg !2214
  br i1 %19, label %22, label %20, !dbg !2217

20:                                               ; preds = %15
  %21 = call i32 @aws_raise_error(i32 34) #17, !dbg !2218
  store i32 %21, i32* %4, align 4, !dbg !2218
  br label %207, !dbg !2218

22:                                               ; preds = %15
  br label %23, !dbg !2217

23:                                               ; preds = %22
  %24 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2220, !tbaa !657
  %25 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %24, i32 0, i32 2, !dbg !2221
  %26 = load i32, i32* %25, align 4, !dbg !2221, !tbaa !698
  %27 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2222, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %27, i32 0, i32 0, !dbg !2223
  %29 = load i32, i32* %28, align 4, !dbg !2223, !tbaa !693
  %30 = sub i32 %26, %29, !dbg !2224
  %31 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2225, !tbaa !657
  %32 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %31, i32 0, i32 0, !dbg !2226
  %33 = load i32, i32* %32, align 4, !dbg !2226, !tbaa !822
  %34 = icmp ult i32 %30, %33, !dbg !2227
  br i1 %34, label %35, label %170, !dbg !2228

35:                                               ; preds = %23
  %36 = bitcast i32* %8 to i8*, !dbg !2229
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %36) #19, !dbg !2229
  call void @llvm.dbg.declare(metadata i32* %8, metadata !2203, metadata !DIExpression()), !dbg !2230
  %37 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2231, !tbaa !657
  %38 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %37, i32 0, i32 0, !dbg !2232
  %39 = load i32, i32* %38, align 4, !dbg !2232, !tbaa !822
  %40 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2233, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %40, i32 0, i32 2, !dbg !2234
  %42 = load i32, i32* %41, align 4, !dbg !2234, !tbaa !698
  %43 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2235, !tbaa !657
  %44 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %43, i32 0, i32 0, !dbg !2236
  %45 = load i32, i32* %44, align 4, !dbg !2236, !tbaa !693
  %46 = sub i32 %42, %45, !dbg !2237
  %47 = sub i32 %39, %46, !dbg !2238
  store i32 %47, i32* %8, align 4, !dbg !2230, !tbaa !663
  %48 = bitcast i32* %9 to i8*, !dbg !2239
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %48) #19, !dbg !2239
  call void @llvm.dbg.declare(metadata i32* %9, metadata !2206, metadata !DIExpression()), !dbg !2240
  store i32 0, i32* %9, align 4, !dbg !2240, !tbaa !663
  %49 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2241, !tbaa !657
  %50 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %49, i32 0, i32 2, !dbg !2243
  %51 = load i32, i32* %50, align 4, !dbg !2243, !tbaa !698
  %52 = load i32, i32* %8, align 4, !dbg !2244, !tbaa !663
  %53 = call i32 @aws_add_size_checked(i32 %51, i32 %52, i32* %9) #17, !dbg !2245
  %54 = icmp ne i32 %53, 0, !dbg !2245
  br i1 %54, label %55, label %56, !dbg !2246

55:                                               ; preds = %35
  store i32 -1, i32* %4, align 4, !dbg !2247
  store i32 1, i32* %10, align 4
  br label %165, !dbg !2247

56:                                               ; preds = %35
  %57 = bitcast i32* %11 to i8*, !dbg !2249
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %57) #19, !dbg !2249
  call void @llvm.dbg.declare(metadata i32* %11, metadata !2207, metadata !DIExpression()), !dbg !2250
  %58 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2251, !tbaa !657
  %59 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %58, i32 0, i32 2, !dbg !2252
  %60 = load i32, i32* %59, align 4, !dbg !2252, !tbaa !698
  %61 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2253, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %61, i32 0, i32 2, !dbg !2254
  %63 = load i32, i32* %62, align 4, !dbg !2254, !tbaa !698
  %64 = call i32 @aws_add_size_saturating(i32 %60, i32 %63) #17, !dbg !2255
  store i32 %64, i32* %11, align 4, !dbg !2250, !tbaa !663
  %65 = bitcast i32* %12 to i8*, !dbg !2256
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %65) #19, !dbg !2256
  call void @llvm.dbg.declare(metadata i32* %12, metadata !2208, metadata !DIExpression()), !dbg !2257
  %66 = load i32, i32* %9, align 4, !dbg !2258, !tbaa !663
  store i32 %66, i32* %12, align 4, !dbg !2257, !tbaa !663
  %67 = load i32, i32* %12, align 4, !dbg !2259, !tbaa !663
  %68 = load i32, i32* %11, align 4, !dbg !2261, !tbaa !663
  %69 = icmp ult i32 %67, %68, !dbg !2262
  br i1 %69, label %70, label %72, !dbg !2263

70:                                               ; preds = %56
  %71 = load i32, i32* %11, align 4, !dbg !2264, !tbaa !663
  store i32 %71, i32* %12, align 4, !dbg !2266, !tbaa !663
  br label %72, !dbg !2267

72:                                               ; preds = %70, %56
  %73 = bitcast i8** %13 to i8*, !dbg !2268
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %73) #19, !dbg !2268
  call void @llvm.dbg.declare(metadata i8** %13, metadata !2209, metadata !DIExpression()), !dbg !2269
  %74 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2270, !tbaa !657
  %75 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %74, i32 0, i32 3, !dbg !2271
  %76 = load %struct.aws_allocator*, %struct.aws_allocator** %75, align 4, !dbg !2271, !tbaa !703
  %77 = load i32, i32* %12, align 4, !dbg !2272, !tbaa !663
  %78 = call i8* bitcast (i8* (%struct.aws_allocator.13*, i32)* @aws_mem_acquire to i8* (%struct.aws_allocator*, i32)*)(%struct.aws_allocator* %76, i32 %77) #17, !dbg !2273
  store i8* %78, i8** %13, align 4, !dbg !2269, !tbaa !657
  %79 = load i8*, i8** %13, align 4, !dbg !2274, !tbaa !657
  %80 = icmp eq i8* %79, null, !dbg !2276
  br i1 %80, label %81, label %98, !dbg !2277

81:                                               ; preds = %72
  %82 = load i32, i32* %12, align 4, !dbg !2278, !tbaa !663
  %83 = load i32, i32* %9, align 4, !dbg !2281, !tbaa !663
  %84 = icmp ugt i32 %82, %83, !dbg !2282
  br i1 %84, label %85, label %96, !dbg !2283

85:                                               ; preds = %81
  %86 = load i32, i32* %9, align 4, !dbg !2284, !tbaa !663
  store i32 %86, i32* %12, align 4, !dbg !2286, !tbaa !663
  %87 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2287, !tbaa !657
  %88 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %87, i32 0, i32 3, !dbg !2288
  %89 = load %struct.aws_allocator*, %struct.aws_allocator** %88, align 4, !dbg !2288, !tbaa !703
  %90 = load i32, i32* %12, align 4, !dbg !2289, !tbaa !663
  %91 = call i8* bitcast (i8* (%struct.aws_allocator.13*, i32)* @aws_mem_acquire to i8* (%struct.aws_allocator*, i32)*)(%struct.aws_allocator* %89, i32 %90) #17, !dbg !2290
  store i8* %91, i8** %13, align 4, !dbg !2291, !tbaa !657
  %92 = load i8*, i8** %13, align 4, !dbg !2292, !tbaa !657
  %93 = icmp eq i8* %92, null, !dbg !2294
  br i1 %93, label %94, label %95, !dbg !2295

94:                                               ; preds = %85
  store i32 -1, i32* %4, align 4, !dbg !2296
  store i32 1, i32* %10, align 4
  br label %161, !dbg !2296

95:                                               ; preds = %85
  br label %97, !dbg !2298

96:                                               ; preds = %81
  store i32 -1, i32* %4, align 4, !dbg !2299
  store i32 1, i32* %10, align 4
  br label %161, !dbg !2299

97:                                               ; preds = %95
  br label %98, !dbg !2301

98:                                               ; preds = %97, %72
  %99 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2302, !tbaa !657
  %100 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %99, i32 0, i32 0, !dbg !2304
  %101 = load i32, i32* %100, align 4, !dbg !2304, !tbaa !693
  %102 = icmp ugt i32 %101, 0, !dbg !2305
  br i1 %102, label %103, label %114, !dbg !2306

103:                                              ; preds = %98
  %104 = load i8*, i8** %13, align 4, !dbg !2307, !tbaa !657
  %105 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2307, !tbaa !657
  %106 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %105, i32 0, i32 1, !dbg !2307
  %107 = load i8*, i8** %106, align 4, !dbg !2307, !tbaa !675
  %108 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2307, !tbaa !657
  %109 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %108, i32 0, i32 0, !dbg !2307
  %110 = load i32, i32* %109, align 4, !dbg !2307, !tbaa !693
  %111 = load i8*, i8** %13, align 4, !dbg !2307, !tbaa !657
  %112 = call i32 @llvm.objectsize.i32.p0i8(i8* %111, i1 false, i1 true, i1 false), !dbg !2307
  %113 = call i8* @__memcpy_chk(i8* %104, i8* %107, i32 %110, i32 %112) #18, !dbg !2307
  br label %114, !dbg !2309

114:                                              ; preds = %103, %98
  %115 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2310, !tbaa !657
  %116 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %115, i32 0, i32 0, !dbg !2312
  %117 = load i32, i32* %116, align 4, !dbg !2312, !tbaa !822
  %118 = icmp ugt i32 %117, 0, !dbg !2313
  br i1 %118, label %119, label %138, !dbg !2314

119:                                              ; preds = %114
  %120 = load i8*, i8** %13, align 4, !dbg !2315, !tbaa !657
  %121 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2315, !tbaa !657
  %122 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %121, i32 0, i32 0, !dbg !2315
  %123 = load i32, i32* %122, align 4, !dbg !2315, !tbaa !693
  %124 = getelementptr inbounds i8, i8* %120, i32 %123, !dbg !2315
  %125 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2315, !tbaa !657
  %126 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %125, i32 0, i32 1, !dbg !2315
  %127 = load i8*, i8** %126, align 4, !dbg !2315, !tbaa !832
  %128 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2315, !tbaa !657
  %129 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %128, i32 0, i32 0, !dbg !2315
  %130 = load i32, i32* %129, align 4, !dbg !2315, !tbaa !822
  %131 = load i8*, i8** %13, align 4, !dbg !2315, !tbaa !657
  %132 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2315, !tbaa !657
  %133 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %132, i32 0, i32 0, !dbg !2315
  %134 = load i32, i32* %133, align 4, !dbg !2315, !tbaa !693
  %135 = getelementptr inbounds i8, i8* %131, i32 %134, !dbg !2315
  %136 = call i32 @llvm.objectsize.i32.p0i8(i8* %135, i1 false, i1 true, i1 false), !dbg !2315
  %137 = call i8* @__memcpy_chk(i8* %124, i8* %127, i32 %130, i32 %136) #18, !dbg !2315
  br label %138, !dbg !2317

138:                                              ; preds = %119, %114
  %139 = load i8, i8* %7, align 1, !dbg !2318, !tbaa !844, !range !849
  %140 = trunc i8 %139 to i1, !dbg !2318
  br i1 %140, label %141, label %148, !dbg !2320

141:                                              ; preds = %138
  %142 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2321, !tbaa !657
  %143 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %142, i32 0, i32 1, !dbg !2323
  %144 = load i8*, i8** %143, align 4, !dbg !2323, !tbaa !675
  %145 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2324, !tbaa !657
  %146 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %145, i32 0, i32 2, !dbg !2325
  %147 = load i32, i32* %146, align 4, !dbg !2325, !tbaa !698
  call void @aws_secure_zero(i8* %144, i32 %147) #17, !dbg !2326
  br label %148, !dbg !2327

148:                                              ; preds = %141, %138
  %149 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2328, !tbaa !657
  %150 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %149, i32 0, i32 3, !dbg !2329
  %151 = load %struct.aws_allocator*, %struct.aws_allocator** %150, align 4, !dbg !2329, !tbaa !703
  %152 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2330, !tbaa !657
  %153 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %152, i32 0, i32 1, !dbg !2331
  %154 = load i8*, i8** %153, align 4, !dbg !2331, !tbaa !675
  call void bitcast (void (%struct.aws_allocator.13*, i8*)* @aws_mem_release to void (%struct.aws_allocator*, i8*)*)(%struct.aws_allocator* %151, i8* %154) #17, !dbg !2332
  %155 = load i8*, i8** %13, align 4, !dbg !2333, !tbaa !657
  %156 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2334, !tbaa !657
  %157 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %156, i32 0, i32 1, !dbg !2335
  store i8* %155, i8** %157, align 4, !dbg !2336, !tbaa !675
  %158 = load i32, i32* %12, align 4, !dbg !2337, !tbaa !663
  %159 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2338, !tbaa !657
  %160 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %159, i32 0, i32 2, !dbg !2339
  store i32 %158, i32* %160, align 4, !dbg !2340, !tbaa !698
  store i32 0, i32* %10, align 4, !dbg !2341
  br label %161, !dbg !2341

161:                                              ; preds = %148, %96, %94
  %162 = bitcast i8** %13 to i8*, !dbg !2341
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %162) #19, !dbg !2341
  %163 = bitcast i32* %12 to i8*, !dbg !2341
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %163) #19, !dbg !2341
  %164 = bitcast i32* %11 to i8*, !dbg !2341
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %164) #19, !dbg !2341
  br label %165

165:                                              ; preds = %161, %55
  %166 = bitcast i32* %9 to i8*, !dbg !2341
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %166) #19, !dbg !2341
  %167 = bitcast i32* %8 to i8*, !dbg !2341
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %167) #19, !dbg !2341
  %168 = load i32, i32* %10, align 4
  switch i32 %168, label %209 [
    i32 0, label %169
    i32 1, label %207
  ]

169:                                              ; preds = %165
  br label %199, !dbg !2342

170:                                              ; preds = %23
  %171 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2343, !tbaa !657
  %172 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %171, i32 0, i32 0, !dbg !2346
  %173 = load i32, i32* %172, align 4, !dbg !2346, !tbaa !822
  %174 = icmp ugt i32 %173, 0, !dbg !2347
  br i1 %174, label %175, label %198, !dbg !2348

175:                                              ; preds = %170
  %176 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2349, !tbaa !657
  %177 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %176, i32 0, i32 1, !dbg !2349
  %178 = load i8*, i8** %177, align 4, !dbg !2349, !tbaa !675
  %179 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2349, !tbaa !657
  %180 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %179, i32 0, i32 0, !dbg !2349
  %181 = load i32, i32* %180, align 4, !dbg !2349, !tbaa !693
  %182 = getelementptr inbounds i8, i8* %178, i32 %181, !dbg !2349
  %183 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2349, !tbaa !657
  %184 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %183, i32 0, i32 1, !dbg !2349
  %185 = load i8*, i8** %184, align 4, !dbg !2349, !tbaa !832
  %186 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2349, !tbaa !657
  %187 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %186, i32 0, i32 0, !dbg !2349
  %188 = load i32, i32* %187, align 4, !dbg !2349, !tbaa !822
  %189 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2349, !tbaa !657
  %190 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %189, i32 0, i32 1, !dbg !2349
  %191 = load i8*, i8** %190, align 4, !dbg !2349, !tbaa !675
  %192 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2349, !tbaa !657
  %193 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %192, i32 0, i32 0, !dbg !2349
  %194 = load i32, i32* %193, align 4, !dbg !2349, !tbaa !693
  %195 = getelementptr inbounds i8, i8* %191, i32 %194, !dbg !2349
  %196 = call i32 @llvm.objectsize.i32.p0i8(i8* %195, i1 false, i1 true, i1 false), !dbg !2349
  %197 = call i8* @__memcpy_chk(i8* %182, i8* %185, i32 %188, i32 %196) #18, !dbg !2349
  br label %198, !dbg !2351

198:                                              ; preds = %175, %170
  br label %199

199:                                              ; preds = %198, %169
  %200 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2352, !tbaa !657
  %201 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %200, i32 0, i32 0, !dbg !2353
  %202 = load i32, i32* %201, align 4, !dbg !2353, !tbaa !822
  %203 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !2354, !tbaa !657
  %204 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %203, i32 0, i32 0, !dbg !2355
  %205 = load i32, i32* %204, align 4, !dbg !2356, !tbaa !693
  %206 = add i32 %205, %202, !dbg !2356
  store i32 %206, i32* %204, align 4, !dbg !2356, !tbaa !693
  store i32 0, i32* %4, align 4, !dbg !2357
  br label %207, !dbg !2357

207:                                              ; preds = %199, %165, %20
  %208 = load i32, i32* %4, align 4, !dbg !2358
  ret i32 %208, !dbg !2358

209:                                              ; preds = %165
  unreachable
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_add_size_saturating(i32 %0, i32 %1) #2 !dbg !2359 {
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  store i32 %0, i32* %3, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %3, metadata !2363, metadata !DIExpression()), !dbg !2365
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !2364, metadata !DIExpression()), !dbg !2366
  %5 = load i32, i32* %3, align 4, !dbg !2367, !tbaa !663
  %6 = load i32, i32* %4, align 4, !dbg !2368, !tbaa !663
  %7 = call i32 @aws_add_u32_saturating(i32 %5, i32 %6) #17, !dbg !2369
  ret i32 %7, !dbg !2370
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_add_u32_saturating(i32 %0, i32 %1) #2 !dbg !2371 {
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  store i32 %0, i32* %3, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %3, metadata !2375, metadata !DIExpression()), !dbg !2378
  store i32 %1, i32* %4, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %4, metadata !2376, metadata !DIExpression()), !dbg !2379
  %6 = bitcast i32* %5 to i8*, !dbg !2380
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %6) #19, !dbg !2380
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2377, metadata !DIExpression()), !dbg !2381
  %7 = load i32, i32* %3, align 4, !dbg !2382, !tbaa !805
  %8 = load i32, i32* %4, align 4, !dbg !2384, !tbaa !805
  %9 = call { i32, i1 } @llvm.uadd.with.overflow.i32(i32 %7, i32 %8), !dbg !2385
  %10 = extractvalue { i32, i1 } %9, 1, !dbg !2385
  %11 = extractvalue { i32, i1 } %9, 0, !dbg !2385
  store i32 %11, i32* %5, align 4, !dbg !2385
  br i1 %10, label %12, label %13, !dbg !2386

12:                                               ; preds = %2
  store i32 -1, i32* %5, align 4, !dbg !2387, !tbaa !805
  br label %13, !dbg !2389

13:                                               ; preds = %12, %2
  %14 = load i32, i32* %5, align 4, !dbg !2390, !tbaa !805
  %15 = bitcast i32* %5 to i8*, !dbg !2391
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %15) #19, !dbg !2391
  ret i32 %14, !dbg !2392
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_dynamic_secure(%struct.aws_byte_buf* %0, %struct.aws_byte_cursor* %1) #0 !dbg !2393 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca %struct.aws_byte_cursor*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !2395, metadata !DIExpression()), !dbg !2397
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2396, metadata !DIExpression()), !dbg !2398
  %5 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !2399, !tbaa !657
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2400, !tbaa !657
  %7 = call i32 @s_aws_byte_buf_append_dynamic(%struct.aws_byte_buf* %5, %struct.aws_byte_cursor* %6, i1 zeroext true) #17, !dbg !2401
  ret i32 %7, !dbg !2402
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_byte_dynamic(%struct.aws_byte_buf* %0, i8 zeroext %1) #0 !dbg !2403 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !2407, metadata !DIExpression()), !dbg !2409
  store i8 %1, i8* %4, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %4, metadata !2408, metadata !DIExpression()), !dbg !2410
  %5 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !2411, !tbaa !657
  %6 = load i8, i8* %4, align 1, !dbg !2412, !tbaa !1034
  %7 = call i32 @s_aws_byte_buf_append_byte_dynamic(%struct.aws_byte_buf* %5, i8 zeroext %6, i1 zeroext false) #17, !dbg !2413
  ret i32 %7, !dbg !2414
}

; Function Attrs: nounwind ssp
define internal i32 @s_aws_byte_buf_append_byte_dynamic(%struct.aws_byte_buf* %0, i8 zeroext %1, i1 zeroext %2) #0 !dbg !2415 {
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i8, align 1
  %6 = alloca i8, align 1
  %7 = alloca %struct.aws_byte_cursor, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !2419, metadata !DIExpression()), !dbg !2423
  store i8 %1, i8* %5, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %5, metadata !2420, metadata !DIExpression()), !dbg !2424
  %8 = zext i1 %2 to i8
  store i8 %8, i8* %6, align 1, !tbaa !844
  call void @llvm.dbg.declare(metadata i8* %6, metadata !2421, metadata !DIExpression()), !dbg !2425
  %9 = bitcast %struct.aws_byte_cursor* %7 to i8*, !dbg !2426
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %9) #19, !dbg !2426
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %7, metadata !2422, metadata !DIExpression()), !dbg !2427
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %7, i32 0, i32 0, !dbg !2428
  store i32 1, i32* %10, align 4, !dbg !2428, !tbaa !822
  %11 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %7, i32 0, i32 1, !dbg !2428
  store i8* %5, i8** %11, align 4, !dbg !2428, !tbaa !832
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2429, !tbaa !657
  %13 = load i8, i8* %6, align 1, !dbg !2430, !tbaa !844, !range !849
  %14 = trunc i8 %13 to i1, !dbg !2430
  %15 = call i32 @s_aws_byte_buf_append_dynamic(%struct.aws_byte_buf* %12, %struct.aws_byte_cursor* %7, i1 zeroext %14) #17, !dbg !2431
  %16 = bitcast %struct.aws_byte_cursor* %7 to i8*, !dbg !2432
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %16) #19, !dbg !2432
  ret i32 %15, !dbg !2433
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_byte_dynamic_secure(%struct.aws_byte_buf* %0, i8 zeroext %1) #0 !dbg !2434 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !2436, metadata !DIExpression()), !dbg !2438
  store i8 %1, i8* %4, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %4, metadata !2437, metadata !DIExpression()), !dbg !2439
  %5 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !2440, !tbaa !657
  %6 = load i8, i8* %4, align 1, !dbg !2441, !tbaa !1034
  %7 = call i32 @s_aws_byte_buf_append_byte_dynamic(%struct.aws_byte_buf* %5, i8 zeroext %6, i1 zeroext true) #17, !dbg !2442
  ret i32 %7, !dbg !2443
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_reserve(%struct.aws_byte_buf* %0, i32 %1) #0 !dbg !2444 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !2448, metadata !DIExpression()), !dbg !2450
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2449, metadata !DIExpression()), !dbg !2451
  br label %6, !dbg !2452

6:                                                ; preds = %2
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2453, !tbaa !657
  %8 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %7, i32 0, i32 3, !dbg !2453
  %9 = load %struct.aws_allocator*, %struct.aws_allocator** %8, align 4, !dbg !2453, !tbaa !703
  %10 = icmp ne %struct.aws_allocator* %9, null, !dbg !2453
  br i1 %10, label %13, label %11, !dbg !2456

11:                                               ; preds = %6
  %12 = call i32 @aws_raise_error(i32 34) #17, !dbg !2457
  store i32 %12, i32* %3, align 4, !dbg !2457
  br label %45, !dbg !2457

13:                                               ; preds = %6
  br label %14, !dbg !2456

14:                                               ; preds = %13
  br label %15, !dbg !2459

15:                                               ; preds = %14
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2460, !tbaa !657
  %17 = call zeroext i1 @aws_byte_buf_is_valid(%struct.aws_byte_buf* %16) #17, !dbg !2460
  br i1 %17, label %20, label %18, !dbg !2463

18:                                               ; preds = %15
  %19 = call i32 @aws_raise_error(i32 34) #17, !dbg !2464
  store i32 %19, i32* %3, align 4, !dbg !2464
  br label %45, !dbg !2464

20:                                               ; preds = %15
  br label %21, !dbg !2463

21:                                               ; preds = %20
  %22 = load i32, i32* %5, align 4, !dbg !2466, !tbaa !663
  %23 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2468, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %23, i32 0, i32 2, !dbg !2469
  %25 = load i32, i32* %24, align 4, !dbg !2469, !tbaa !698
  %26 = icmp ule i32 %22, %25, !dbg !2470
  br i1 %26, label %27, label %28, !dbg !2471

27:                                               ; preds = %21
  store i32 0, i32* %3, align 4, !dbg !2472
  br label %45, !dbg !2472

28:                                               ; preds = %21
  %29 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2474, !tbaa !657
  %30 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %29, i32 0, i32 3, !dbg !2476
  %31 = load %struct.aws_allocator*, %struct.aws_allocator** %30, align 4, !dbg !2476, !tbaa !703
  %32 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2477, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %32, i32 0, i32 1, !dbg !2478
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2479, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %34, i32 0, i32 2, !dbg !2480
  %36 = load i32, i32* %35, align 4, !dbg !2480, !tbaa !698
  %37 = load i32, i32* %5, align 4, !dbg !2481, !tbaa !663
  %38 = call i32 bitcast (i32 (%struct.aws_allocator.13*, i8**, i32, i32)* @aws_mem_realloc to i32 (%struct.aws_allocator*, i8**, i32, i32)*)(%struct.aws_allocator* %31, i8** %33, i32 %36, i32 %37) #17, !dbg !2482
  %39 = icmp ne i32 %38, 0, !dbg !2482
  br i1 %39, label %40, label %41, !dbg !2483

40:                                               ; preds = %28
  store i32 -1, i32* %3, align 4, !dbg !2484
  br label %45, !dbg !2484

41:                                               ; preds = %28
  %42 = load i32, i32* %5, align 4, !dbg !2486, !tbaa !663
  %43 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2487, !tbaa !657
  %44 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %43, i32 0, i32 2, !dbg !2488
  store i32 %42, i32* %44, align 4, !dbg !2489, !tbaa !698
  store i32 0, i32* %3, align 4, !dbg !2490
  br label %45, !dbg !2490

45:                                               ; preds = %41, %40, %27, %18, %11
  %46 = load i32, i32* %3, align 4, !dbg !2491
  ret i32 %46, !dbg !2491
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_reserve_relative(%struct.aws_byte_buf* %0, i32 %1) #0 !dbg !2492 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !2494, metadata !DIExpression()), !dbg !2497
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2495, metadata !DIExpression()), !dbg !2498
  br label %8, !dbg !2499

8:                                                ; preds = %2
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2500, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 3, !dbg !2500
  %11 = load %struct.aws_allocator*, %struct.aws_allocator** %10, align 4, !dbg !2500, !tbaa !703
  %12 = icmp ne %struct.aws_allocator* %11, null, !dbg !2500
  br i1 %12, label %15, label %13, !dbg !2503

13:                                               ; preds = %8
  %14 = call i32 @aws_raise_error(i32 34) #17, !dbg !2504
  store i32 %14, i32* %3, align 4, !dbg !2504
  br label %43, !dbg !2504

15:                                               ; preds = %8
  br label %16, !dbg !2503

16:                                               ; preds = %15
  br label %17, !dbg !2506

17:                                               ; preds = %16
  %18 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2507, !tbaa !657
  %19 = call zeroext i1 @aws_byte_buf_is_valid(%struct.aws_byte_buf* %18) #17, !dbg !2507
  br i1 %19, label %22, label %20, !dbg !2510

20:                                               ; preds = %17
  %21 = call i32 @aws_raise_error(i32 34) #17, !dbg !2511
  store i32 %21, i32* %3, align 4, !dbg !2511
  br label %43, !dbg !2511

22:                                               ; preds = %17
  br label %23, !dbg !2510

23:                                               ; preds = %22
  %24 = bitcast i32* %6 to i8*, !dbg !2513
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %24) #19, !dbg !2513
  call void @llvm.dbg.declare(metadata i32* %6, metadata !2496, metadata !DIExpression()), !dbg !2514
  store i32 0, i32* %6, align 4, !dbg !2514, !tbaa !663
  %25 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2515, !tbaa !657
  %26 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %25, i32 0, i32 0, !dbg !2515
  %27 = load i32, i32* %26, align 4, !dbg !2515, !tbaa !693
  %28 = load i32, i32* %5, align 4, !dbg !2515, !tbaa !663
  %29 = call i32 @aws_add_size_checked(i32 %27, i32 %28, i32* %6) #17, !dbg !2515
  %30 = icmp ne i32 %29, 0, !dbg !2515
  %31 = xor i1 %30, true, !dbg !2515
  %32 = xor i1 %31, true, !dbg !2515
  %33 = zext i1 %32 to i32, !dbg !2515
  %34 = call i32 @llvm.expect.i32(i32 %33, i32 0), !dbg !2515
  %35 = icmp ne i32 %34, 0, !dbg !2515
  br i1 %35, label %36, label %37, !dbg !2517

36:                                               ; preds = %23
  store i32 -1, i32* %3, align 4, !dbg !2518
  store i32 1, i32* %7, align 4
  br label %41, !dbg !2518

37:                                               ; preds = %23
  %38 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !2520, !tbaa !657
  %39 = load i32, i32* %6, align 4, !dbg !2521, !tbaa !663
  %40 = call i32 @aws_byte_buf_reserve(%struct.aws_byte_buf* %38, i32 %39) #17, !dbg !2522
  store i32 %40, i32* %3, align 4, !dbg !2523
  store i32 1, i32* %7, align 4
  br label %41, !dbg !2523

41:                                               ; preds = %37, %36
  %42 = bitcast i32* %6 to i8*, !dbg !2524
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %42) #19, !dbg !2524
  br label %43

43:                                               ; preds = %41, %20, %13
  %44 = load i32, i32* %3, align 4, !dbg !2524
  ret i32 %44, !dbg !2524
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_right_trim_pred(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %1, i1 (i8)* %2) #0 !dbg !2525 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i1 (i8)*, align 4
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2533, metadata !DIExpression()), !dbg !2536
  store i1 (i8)* %2, i1 (i8)** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i1 (i8)** %5, metadata !2534, metadata !DIExpression()), !dbg !2537
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !2535, metadata !DIExpression()), !dbg !2538
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2539, !tbaa !657
  %7 = bitcast %struct.aws_byte_cursor* %0 to i8*, !dbg !2540
  %8 = bitcast %struct.aws_byte_cursor* %6 to i8*, !dbg !2540
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %7, i8* align 4 %8, i32 8, i1 false), !dbg !2540, !tbaa.struct !1474
  br label %9, !dbg !2541

9:                                                ; preds = %25, %3
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2542
  %11 = load i32, i32* %10, align 4, !dbg !2542, !tbaa !822
  %12 = icmp ugt i32 %11, 0, !dbg !2543
  br i1 %12, label %13, label %23, !dbg !2544

13:                                               ; preds = %9
  %14 = load i1 (i8)*, i1 (i8)** %5, align 4, !dbg !2545, !tbaa !657
  %15 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2546
  %16 = load i8*, i8** %15, align 4, !dbg !2546, !tbaa !832
  %17 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2547
  %18 = load i32, i32* %17, align 4, !dbg !2547, !tbaa !822
  %19 = getelementptr inbounds i8, i8* %16, i32 %18, !dbg !2548
  %20 = getelementptr inbounds i8, i8* %19, i32 -1, !dbg !2549
  %21 = load i8, i8* %20, align 1, !dbg !2550, !tbaa !1034
  %22 = call zeroext i1 %14(i8 zeroext %21), !dbg !2545
  br label %23

23:                                               ; preds = %13, %9
  %24 = phi i1 [ false, %9 ], [ %22, %13 ], !dbg !2551
  br i1 %24, label %25, label %29, !dbg !2541

25:                                               ; preds = %23
  %26 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2552
  %27 = load i32, i32* %26, align 4, !dbg !2554, !tbaa !822
  %28 = add i32 %27, -1, !dbg !2554
  store i32 %28, i32* %26, align 4, !dbg !2554, !tbaa !822
  br label %9, !dbg !2541, !llvm.loop !2555

29:                                               ; preds = %23
  ret void, !dbg !2557
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_left_trim_pred(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %1, i1 (i8)* %2) #0 !dbg !2558 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i1 (i8)*, align 4
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2560, metadata !DIExpression()), !dbg !2563
  store i1 (i8)* %2, i1 (i8)** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i1 (i8)** %5, metadata !2561, metadata !DIExpression()), !dbg !2564
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !2562, metadata !DIExpression()), !dbg !2565
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2566, !tbaa !657
  %7 = bitcast %struct.aws_byte_cursor* %0 to i8*, !dbg !2567
  %8 = bitcast %struct.aws_byte_cursor* %6 to i8*, !dbg !2567
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %7, i8* align 4 %8, i32 8, i1 false), !dbg !2567, !tbaa.struct !1474
  br label %9, !dbg !2568

9:                                                ; preds = %21, %3
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2569
  %11 = load i32, i32* %10, align 4, !dbg !2569, !tbaa !822
  %12 = icmp ugt i32 %11, 0, !dbg !2570
  br i1 %12, label %13, label %19, !dbg !2571

13:                                               ; preds = %9
  %14 = load i1 (i8)*, i1 (i8)** %5, align 4, !dbg !2572, !tbaa !657
  %15 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2573
  %16 = load i8*, i8** %15, align 4, !dbg !2573, !tbaa !832
  %17 = load i8, i8* %16, align 1, !dbg !2574, !tbaa !1034
  %18 = call zeroext i1 %14(i8 zeroext %17), !dbg !2572
  br label %19

19:                                               ; preds = %13, %9
  %20 = phi i1 [ false, %9 ], [ %18, %13 ], !dbg !2575
  br i1 %20, label %21, label %28, !dbg !2568

21:                                               ; preds = %19
  %22 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2576
  %23 = load i32, i32* %22, align 4, !dbg !2578, !tbaa !822
  %24 = add i32 %23, -1, !dbg !2578
  store i32 %24, i32* %22, align 4, !dbg !2578, !tbaa !822
  %25 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2579
  %26 = load i8*, i8** %25, align 4, !dbg !2580, !tbaa !832
  %27 = getelementptr inbounds i8, i8* %26, i32 1, !dbg !2580
  store i8* %27, i8** %25, align 4, !dbg !2580, !tbaa !832
  br label %9, !dbg !2568, !llvm.loop !2581

28:                                               ; preds = %19
  ret void, !dbg !2583
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_trim_pred(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %1, i1 (i8)* %2) #0 !dbg !2584 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i1 (i8)*, align 4
  %6 = alloca %struct.aws_byte_cursor, align 4
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2586, metadata !DIExpression()), !dbg !2590
  store i1 (i8)* %2, i1 (i8)** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i1 (i8)** %5, metadata !2587, metadata !DIExpression()), !dbg !2591
  %7 = bitcast %struct.aws_byte_cursor* %6 to i8*, !dbg !2592
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %7) #19, !dbg !2592
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %6, metadata !2588, metadata !DIExpression()), !dbg !2593
  %8 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2594, !tbaa !657
  %9 = load i1 (i8)*, i1 (i8)** %5, align 4, !dbg !2595, !tbaa !657
  call void @aws_byte_cursor_left_trim_pred(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %6, %struct.aws_byte_cursor* %8, i1 (i8)* %9) #17, !dbg !2596
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !2589, metadata !DIExpression()), !dbg !2597
  %10 = load i1 (i8)*, i1 (i8)** %5, align 4, !dbg !2598, !tbaa !657
  call void @aws_byte_cursor_right_trim_pred(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %6, i1 (i8)* %10) #17, !dbg !2599
  %11 = bitcast %struct.aws_byte_cursor* %6 to i8*, !dbg !2600
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #19, !dbg !2600
  ret void, !dbg !2600
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_satisfies_pred(%struct.aws_byte_cursor* %0, i1 (i8)* %1) #0 !dbg !2601 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i1 (i8)*, align 4
  %5 = alloca %struct.aws_byte_cursor, align 4
  %6 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !2605, metadata !DIExpression()), !dbg !2609
  store i1 (i8)* %1, i1 (i8)** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i1 (i8)** %4, metadata !2606, metadata !DIExpression()), !dbg !2610
  %7 = bitcast %struct.aws_byte_cursor* %5 to i8*, !dbg !2611
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %7) #19, !dbg !2611
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %5, metadata !2607, metadata !DIExpression()), !dbg !2612
  %8 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !2613, !tbaa !657
  %9 = load i1 (i8)*, i1 (i8)** %4, align 4, !dbg !2614, !tbaa !657
  call void @aws_byte_cursor_left_trim_pred(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %5, %struct.aws_byte_cursor* %8, i1 (i8)* %9) #17, !dbg !2615
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !2616
  call void @llvm.dbg.declare(metadata i8* %6, metadata !2608, metadata !DIExpression()), !dbg !2617
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !2618
  %11 = load i32, i32* %10, align 4, !dbg !2618, !tbaa !822
  %12 = icmp eq i32 %11, 0, !dbg !2619
  %13 = zext i1 %12 to i8, !dbg !2617
  store i8 %13, i8* %6, align 1, !dbg !2617, !tbaa !844
  %14 = load i8, i8* %6, align 1, !dbg !2620, !tbaa !844, !range !849
  %15 = trunc i8 %14 to i1, !dbg !2620
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !2621
  %16 = bitcast %struct.aws_byte_cursor* %5 to i8*, !dbg !2621
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %16) #19, !dbg !2621
  ret i1 %15, !dbg !2622
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_cursor_compare_lexical(%struct.aws_byte_cursor* %0, %struct.aws_byte_cursor* %1) #0 !dbg !2623 {
  %3 = alloca i32, align 4
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2627, metadata !DIExpression()), !dbg !2631
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !2628, metadata !DIExpression()), !dbg !2632
  %9 = bitcast i32* %6 to i8*, !dbg !2633
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %9) #19, !dbg !2633
  call void @llvm.dbg.declare(metadata i32* %6, metadata !2629, metadata !DIExpression()), !dbg !2634
  %10 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2635, !tbaa !657
  %11 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %10, i32 0, i32 0, !dbg !2636
  %12 = load i32, i32* %11, align 4, !dbg !2636, !tbaa !822
  store i32 %12, i32* %6, align 4, !dbg !2634, !tbaa !663
  %13 = load i32, i32* %6, align 4, !dbg !2637, !tbaa !663
  %14 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2639, !tbaa !657
  %15 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %14, i32 0, i32 0, !dbg !2640
  %16 = load i32, i32* %15, align 4, !dbg !2640, !tbaa !822
  %17 = icmp ugt i32 %13, %16, !dbg !2641
  br i1 %17, label %18, label %22, !dbg !2642

18:                                               ; preds = %2
  %19 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2643, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %19, i32 0, i32 0, !dbg !2645
  %21 = load i32, i32* %20, align 4, !dbg !2645, !tbaa !822
  store i32 %21, i32* %6, align 4, !dbg !2646, !tbaa !663
  br label %22, !dbg !2647

22:                                               ; preds = %18, %2
  %23 = bitcast i32* %7 to i8*, !dbg !2648
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %23) #19, !dbg !2648
  call void @llvm.dbg.declare(metadata i32* %7, metadata !2630, metadata !DIExpression()), !dbg !2649
  %24 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2650, !tbaa !657
  %25 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %24, i32 0, i32 1, !dbg !2651
  %26 = load i8*, i8** %25, align 4, !dbg !2651, !tbaa !832
  %27 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2652, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %27, i32 0, i32 1, !dbg !2653
  %29 = load i8*, i8** %28, align 4, !dbg !2653, !tbaa !832
  %30 = load i32, i32* %6, align 4, !dbg !2654, !tbaa !663
  %31 = call i32 @memcmp(i8* %26, i8* %29, i32 %30) #17, !dbg !2655
  store i32 %31, i32* %7, align 4, !dbg !2649, !tbaa !805
  %32 = load i32, i32* %7, align 4, !dbg !2656, !tbaa !805
  %33 = icmp ne i32 %32, 0, !dbg !2658
  br i1 %33, label %34, label %36, !dbg !2659

34:                                               ; preds = %22
  %35 = load i32, i32* %7, align 4, !dbg !2660, !tbaa !805
  store i32 %35, i32* %3, align 4, !dbg !2662
  store i32 1, i32* %8, align 4
  br label %53, !dbg !2662

36:                                               ; preds = %22
  %37 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2663, !tbaa !657
  %38 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %37, i32 0, i32 0, !dbg !2665
  %39 = load i32, i32* %38, align 4, !dbg !2665, !tbaa !822
  %40 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2666, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %40, i32 0, i32 0, !dbg !2667
  %42 = load i32, i32* %41, align 4, !dbg !2667, !tbaa !822
  %43 = icmp ne i32 %39, %42, !dbg !2668
  br i1 %43, label %44, label %52, !dbg !2669

44:                                               ; preds = %36
  %45 = load i32, i32* %6, align 4, !dbg !2670, !tbaa !663
  %46 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2672, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %46, i32 0, i32 0, !dbg !2673
  %48 = load i32, i32* %47, align 4, !dbg !2673, !tbaa !822
  %49 = icmp eq i32 %45, %48, !dbg !2674
  %50 = zext i1 %49 to i64, !dbg !2670
  %51 = select i1 %49, i32 -1, i32 1, !dbg !2670
  store i32 %51, i32* %3, align 4, !dbg !2675
  store i32 1, i32* %8, align 4
  br label %53, !dbg !2675

52:                                               ; preds = %36
  store i32 0, i32* %3, align 4, !dbg !2676
  store i32 1, i32* %8, align 4
  br label %53, !dbg !2676

53:                                               ; preds = %52, %44, %34
  %54 = bitcast i32* %7 to i8*, !dbg !2677
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %54) #19, !dbg !2677
  %55 = bitcast i32* %6 to i8*, !dbg !2677
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %55) #19, !dbg !2677
  %56 = load i32, i32* %3, align 4, !dbg !2677
  ret i32 %56, !dbg !2677
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_cursor_compare_lookup(%struct.aws_byte_cursor* %0, %struct.aws_byte_cursor* %1, i8* %2) #0 !dbg !2678 {
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca %struct.aws_byte_cursor*, align 4
  %7 = alloca i8*, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i8*, align 4
  %12 = alloca i8, align 1
  %13 = alloca i8, align 1
  %14 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !2682, metadata !DIExpression()), !dbg !2692
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %6, metadata !2683, metadata !DIExpression()), !dbg !2693
  store i8* %2, i8** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %7, metadata !2684, metadata !DIExpression()), !dbg !2694
  %15 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2695, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %15, i32 0, i32 0, !dbg !2697
  %17 = load i32, i32* %16, align 4, !dbg !2697, !tbaa !822
  %18 = icmp eq i32 %17, 0, !dbg !2698
  br i1 %18, label %19, label %25, !dbg !2699

19:                                               ; preds = %3
  %20 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2700, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %20, i32 0, i32 0, !dbg !2701
  %22 = load i32, i32* %21, align 4, !dbg !2701, !tbaa !822
  %23 = icmp eq i32 %22, 0, !dbg !2702
  br i1 %23, label %24, label %25, !dbg !2703

24:                                               ; preds = %19
  store i32 0, i32* %4, align 4, !dbg !2704
  br label %120, !dbg !2704

25:                                               ; preds = %19, %3
  %26 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2706, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %26, i32 0, i32 0, !dbg !2708
  %28 = load i32, i32* %27, align 4, !dbg !2708, !tbaa !822
  %29 = icmp eq i32 %28, 0, !dbg !2709
  br i1 %29, label %30, label %31, !dbg !2710

30:                                               ; preds = %25
  store i32 -1, i32* %4, align 4, !dbg !2711
  br label %120, !dbg !2711

31:                                               ; preds = %25
  %32 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2713, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %32, i32 0, i32 0, !dbg !2715
  %34 = load i32, i32* %33, align 4, !dbg !2715, !tbaa !822
  %35 = icmp eq i32 %34, 0, !dbg !2716
  br i1 %35, label %36, label %37, !dbg !2717

36:                                               ; preds = %31
  store i32 1, i32* %4, align 4, !dbg !2718
  br label %120, !dbg !2718

37:                                               ; preds = %31
  br label %38

38:                                               ; preds = %37
  br label %39

39:                                               ; preds = %38
  %40 = bitcast i8** %8 to i8*, !dbg !2720
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %40) #19, !dbg !2720
  call void @llvm.dbg.declare(metadata i8** %8, metadata !2685, metadata !DIExpression()), !dbg !2721
  %41 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2722, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %41, i32 0, i32 1, !dbg !2723
  %43 = load i8*, i8** %42, align 4, !dbg !2723, !tbaa !832
  store i8* %43, i8** %8, align 4, !dbg !2721, !tbaa !657
  %44 = bitcast i8** %9 to i8*, !dbg !2724
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %44) #19, !dbg !2724
  call void @llvm.dbg.declare(metadata i8** %9, metadata !2686, metadata !DIExpression()), !dbg !2725
  %45 = load i8*, i8** %8, align 4, !dbg !2726, !tbaa !657
  %46 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !2727, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %46, i32 0, i32 0, !dbg !2728
  %48 = load i32, i32* %47, align 4, !dbg !2728, !tbaa !822
  %49 = getelementptr inbounds i8, i8* %45, i32 %48, !dbg !2729
  store i8* %49, i8** %9, align 4, !dbg !2725, !tbaa !657
  %50 = bitcast i8** %10 to i8*, !dbg !2730
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %50) #19, !dbg !2730
  call void @llvm.dbg.declare(metadata i8** %10, metadata !2687, metadata !DIExpression()), !dbg !2731
  %51 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2732, !tbaa !657
  %52 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %51, i32 0, i32 1, !dbg !2733
  %53 = load i8*, i8** %52, align 4, !dbg !2733, !tbaa !832
  store i8* %53, i8** %10, align 4, !dbg !2731, !tbaa !657
  %54 = bitcast i8** %11 to i8*, !dbg !2734
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %54) #19, !dbg !2734
  call void @llvm.dbg.declare(metadata i8** %11, metadata !2688, metadata !DIExpression()), !dbg !2735
  %55 = load i8*, i8** %10, align 4, !dbg !2736, !tbaa !657
  %56 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %6, align 4, !dbg !2737, !tbaa !657
  %57 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %56, i32 0, i32 0, !dbg !2738
  %58 = load i32, i32* %57, align 4, !dbg !2738, !tbaa !822
  %59 = getelementptr inbounds i8, i8* %55, i32 %58, !dbg !2739
  store i8* %59, i8** %11, align 4, !dbg !2735, !tbaa !657
  br label %60, !dbg !2740

60:                                               ; preds = %103, %39
  %61 = load i8*, i8** %8, align 4, !dbg !2741, !tbaa !657
  %62 = load i8*, i8** %9, align 4, !dbg !2742, !tbaa !657
  %63 = icmp ult i8* %61, %62, !dbg !2743
  br i1 %63, label %64, label %68, !dbg !2744

64:                                               ; preds = %60
  %65 = load i8*, i8** %10, align 4, !dbg !2745, !tbaa !657
  %66 = load i8*, i8** %11, align 4, !dbg !2746, !tbaa !657
  %67 = icmp ult i8* %65, %66, !dbg !2747
  br label %68

68:                                               ; preds = %64, %60
  %69 = phi i1 [ false, %60 ], [ %67, %64 ], !dbg !2748
  br i1 %69, label %70, label %104, !dbg !2740

70:                                               ; preds = %68
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %12) #19, !dbg !2749
  call void @llvm.dbg.declare(metadata i8* %12, metadata !2689, metadata !DIExpression()), !dbg !2750
  %71 = load i8*, i8** %7, align 4, !dbg !2751, !tbaa !657
  %72 = load i8*, i8** %8, align 4, !dbg !2752, !tbaa !657
  %73 = load i8, i8* %72, align 1, !dbg !2753, !tbaa !1034
  %74 = zext i8 %73 to i32, !dbg !2751
  %75 = getelementptr inbounds i8, i8* %71, i32 %74, !dbg !2751
  %76 = load i8, i8* %75, align 1, !dbg !2751, !tbaa !1034
  store i8 %76, i8* %12, align 1, !dbg !2750, !tbaa !1034
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %13) #19, !dbg !2754
  call void @llvm.dbg.declare(metadata i8* %13, metadata !2691, metadata !DIExpression()), !dbg !2755
  %77 = load i8*, i8** %7, align 4, !dbg !2756, !tbaa !657
  %78 = load i8*, i8** %10, align 4, !dbg !2757, !tbaa !657
  %79 = load i8, i8* %78, align 1, !dbg !2758, !tbaa !1034
  %80 = zext i8 %79 to i32, !dbg !2756
  %81 = getelementptr inbounds i8, i8* %77, i32 %80, !dbg !2756
  %82 = load i8, i8* %81, align 1, !dbg !2756, !tbaa !1034
  store i8 %82, i8* %13, align 1, !dbg !2755, !tbaa !1034
  %83 = load i8, i8* %12, align 1, !dbg !2759, !tbaa !1034
  %84 = zext i8 %83 to i32, !dbg !2759
  %85 = load i8, i8* %13, align 1, !dbg !2761, !tbaa !1034
  %86 = zext i8 %85 to i32, !dbg !2761
  %87 = icmp slt i32 %84, %86, !dbg !2762
  br i1 %87, label %88, label %89, !dbg !2763

88:                                               ; preds = %70
  store i32 -1, i32* %4, align 4, !dbg !2764
  store i32 1, i32* %14, align 4
  br label %101, !dbg !2764

89:                                               ; preds = %70
  %90 = load i8, i8* %12, align 1, !dbg !2766, !tbaa !1034
  %91 = zext i8 %90 to i32, !dbg !2766
  %92 = load i8, i8* %13, align 1, !dbg !2768, !tbaa !1034
  %93 = zext i8 %92 to i32, !dbg !2768
  %94 = icmp sgt i32 %91, %93, !dbg !2769
  br i1 %94, label %95, label %96, !dbg !2770

95:                                               ; preds = %89
  store i32 1, i32* %4, align 4, !dbg !2771
  store i32 1, i32* %14, align 4
  br label %101, !dbg !2771

96:                                               ; preds = %89
  %97 = load i8*, i8** %8, align 4, !dbg !2773, !tbaa !657
  %98 = getelementptr inbounds i8, i8* %97, i32 1, !dbg !2773
  store i8* %98, i8** %8, align 4, !dbg !2773, !tbaa !657
  %99 = load i8*, i8** %10, align 4, !dbg !2774, !tbaa !657
  %100 = getelementptr inbounds i8, i8* %99, i32 1, !dbg !2774
  store i8* %100, i8** %10, align 4, !dbg !2774, !tbaa !657
  store i32 0, i32* %14, align 4, !dbg !2775
  br label %101, !dbg !2775

101:                                              ; preds = %96, %95, %88
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %13) #19, !dbg !2775
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %12) #19, !dbg !2775
  %102 = load i32, i32* %14, align 4
  switch i32 %102, label %115 [
    i32 0, label %103
  ]

103:                                              ; preds = %101
  br label %60, !dbg !2740, !llvm.loop !2776

104:                                              ; preds = %68
  %105 = load i8*, i8** %8, align 4, !dbg !2777, !tbaa !657
  %106 = load i8*, i8** %9, align 4, !dbg !2779, !tbaa !657
  %107 = icmp ult i8* %105, %106, !dbg !2780
  br i1 %107, label %108, label %109, !dbg !2781

108:                                              ; preds = %104
  store i32 1, i32* %4, align 4, !dbg !2782
  store i32 1, i32* %14, align 4
  br label %115, !dbg !2782

109:                                              ; preds = %104
  %110 = load i8*, i8** %10, align 4, !dbg !2784, !tbaa !657
  %111 = load i8*, i8** %11, align 4, !dbg !2786, !tbaa !657
  %112 = icmp ult i8* %110, %111, !dbg !2787
  br i1 %112, label %113, label %114, !dbg !2788

113:                                              ; preds = %109
  store i32 -1, i32* %4, align 4, !dbg !2789
  store i32 1, i32* %14, align 4
  br label %115, !dbg !2789

114:                                              ; preds = %109
  store i32 0, i32* %4, align 4, !dbg !2791
  store i32 1, i32* %14, align 4
  br label %115, !dbg !2791

115:                                              ; preds = %114, %113, %108, %101
  %116 = bitcast i8** %11 to i8*, !dbg !2792
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %116) #19, !dbg !2792
  %117 = bitcast i8** %10 to i8*, !dbg !2792
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %117) #19, !dbg !2792
  %118 = bitcast i8** %9 to i8*, !dbg !2792
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %118) #19, !dbg !2792
  %119 = bitcast i8** %8 to i8*, !dbg !2792
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %119) #19, !dbg !2792
  br label %120

120:                                              ; preds = %115, %36, %30, %24
  %121 = load i32, i32* %4, align 4, !dbg !2792
  ret i32 %121, !dbg !2792
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_from_c_str(%struct.aws_byte_buf* noalias sret(%struct.aws_byte_buf) %0, i8* %1) #0 !dbg !2793 {
  %3 = alloca i8*, align 4
  store i8* %1, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !2797, metadata !DIExpression()), !dbg !2799
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf* %0, metadata !2798, metadata !DIExpression()), !dbg !2800
  %4 = load i8*, i8** %3, align 4, !dbg !2801, !tbaa !657
  %5 = icmp ne i8* %4, null, !dbg !2801
  br i1 %5, label %7, label %6, !dbg !2802

6:                                                ; preds = %2
  br label %10, !dbg !2802

7:                                                ; preds = %2
  %8 = load i8*, i8** %3, align 4, !dbg !2803, !tbaa !657
  %9 = call i32 @strlen(i8* %8) #17, !dbg !2804
  br label %10, !dbg !2802

10:                                               ; preds = %7, %6
  %11 = phi i32 [ 0, %6 ], [ %9, %7 ], !dbg !2802
  %12 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 0, !dbg !2805
  store i32 %11, i32* %12, align 4, !dbg !2806, !tbaa !693
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 0, !dbg !2807
  %14 = load i32, i32* %13, align 4, !dbg !2807, !tbaa !693
  %15 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 2, !dbg !2808
  store i32 %14, i32* %15, align 4, !dbg !2809, !tbaa !698
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 2, !dbg !2810
  %17 = load i32, i32* %16, align 4, !dbg !2810, !tbaa !698
  %18 = icmp eq i32 %17, 0, !dbg !2811
  br i1 %18, label %19, label %20, !dbg !2812

19:                                               ; preds = %10
  br label %22, !dbg !2812

20:                                               ; preds = %10
  %21 = load i8*, i8** %3, align 4, !dbg !2813, !tbaa !657
  br label %22, !dbg !2812

22:                                               ; preds = %20, %19
  %23 = phi i8* [ null, %19 ], [ %21, %20 ], !dbg !2812
  %24 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 1, !dbg !2814
  store i8* %23, i8** %24, align 4, !dbg !2815, !tbaa !675
  %25 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 3, !dbg !2816
  store %struct.aws_allocator* null, %struct.aws_allocator** %25, align 4, !dbg !2817, !tbaa !703
  ret void, !dbg !2818
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_from_array(%struct.aws_byte_buf* noalias sret(%struct.aws_byte_buf) %0, i8* %1, i32 %2) #0 !dbg !2819 {
  %4 = alloca i8*, align 4
  %5 = alloca i32, align 4
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !2823, metadata !DIExpression()), !dbg !2826
  store i32 %2, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2824, metadata !DIExpression()), !dbg !2827
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf* %0, metadata !2825, metadata !DIExpression()), !dbg !2828
  %6 = load i32, i32* %5, align 4, !dbg !2829, !tbaa !663
  %7 = icmp ugt i32 %6, 0, !dbg !2830
  br i1 %7, label %8, label %10, !dbg !2831

8:                                                ; preds = %3
  %9 = load i8*, i8** %4, align 4, !dbg !2832, !tbaa !657
  br label %11, !dbg !2831

10:                                               ; preds = %3
  br label %11, !dbg !2831

11:                                               ; preds = %10, %8
  %12 = phi i8* [ %9, %8 ], [ null, %10 ], !dbg !2831
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 1, !dbg !2833
  store i8* %12, i8** %13, align 4, !dbg !2834, !tbaa !675
  %14 = load i32, i32* %5, align 4, !dbg !2835, !tbaa !663
  %15 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 0, !dbg !2836
  store i32 %14, i32* %15, align 4, !dbg !2837, !tbaa !693
  %16 = load i32, i32* %5, align 4, !dbg !2838, !tbaa !663
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 2, !dbg !2839
  store i32 %16, i32* %17, align 4, !dbg !2840, !tbaa !698
  %18 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 3, !dbg !2841
  store %struct.aws_allocator* null, %struct.aws_allocator** %18, align 4, !dbg !2842, !tbaa !703
  ret void, !dbg !2843
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_from_empty_array(%struct.aws_byte_buf* noalias sret(%struct.aws_byte_buf) %0, i8* %1, i32 %2) #0 !dbg !2844 {
  %4 = alloca i8*, align 4
  %5 = alloca i32, align 4
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !2846, metadata !DIExpression()), !dbg !2849
  store i32 %2, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2847, metadata !DIExpression()), !dbg !2850
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf* %0, metadata !2848, metadata !DIExpression()), !dbg !2851
  %6 = load i32, i32* %5, align 4, !dbg !2852, !tbaa !663
  %7 = icmp ugt i32 %6, 0, !dbg !2853
  br i1 %7, label %8, label %10, !dbg !2854

8:                                                ; preds = %3
  %9 = load i8*, i8** %4, align 4, !dbg !2855, !tbaa !657
  br label %11, !dbg !2854

10:                                               ; preds = %3
  br label %11, !dbg !2854

11:                                               ; preds = %10, %8
  %12 = phi i8* [ %9, %8 ], [ null, %10 ], !dbg !2854
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 1, !dbg !2856
  store i8* %12, i8** %13, align 4, !dbg !2857, !tbaa !675
  %14 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 0, !dbg !2858
  store i32 0, i32* %14, align 4, !dbg !2859, !tbaa !693
  %15 = load i32, i32* %5, align 4, !dbg !2860, !tbaa !663
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 2, !dbg !2861
  store i32 %15, i32* %16, align 4, !dbg !2862, !tbaa !698
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %0, i32 0, i32 3, !dbg !2863
  store %struct.aws_allocator* null, %struct.aws_allocator** %17, align 4, !dbg !2864, !tbaa !703
  ret void, !dbg !2865
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_from_c_str(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, i8* %1) #0 !dbg !2866 {
  %3 = alloca i8*, align 4
  store i8* %1, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !2870, metadata !DIExpression()), !dbg !2872
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !2871, metadata !DIExpression()), !dbg !2873
  %4 = load i8*, i8** %3, align 4, !dbg !2874, !tbaa !657
  %5 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2875
  store i8* %4, i8** %5, align 4, !dbg !2876, !tbaa !832
  %6 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2877
  %7 = load i8*, i8** %6, align 4, !dbg !2877, !tbaa !832
  %8 = icmp ne i8* %7, null, !dbg !2878
  br i1 %8, label %9, label %12, !dbg !2878

9:                                                ; preds = %2
  %10 = load i8*, i8** %3, align 4, !dbg !2879, !tbaa !657
  %11 = call i32 @strlen(i8* %10) #17, !dbg !2880
  br label %13, !dbg !2878

12:                                               ; preds = %2
  br label %13, !dbg !2878

13:                                               ; preds = %12, %9
  %14 = phi i32 [ %11, %9 ], [ 0, %12 ], !dbg !2878
  %15 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2881
  store i32 %14, i32* %15, align 4, !dbg !2882, !tbaa !822
  ret void, !dbg !2883
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_from_array(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, i8* %1, i32 %2) #0 !dbg !2884 {
  %4 = alloca i8*, align 4
  %5 = alloca i32, align 4
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !2888, metadata !DIExpression()), !dbg !2891
  store i32 %2, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2889, metadata !DIExpression()), !dbg !2892
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !2890, metadata !DIExpression()), !dbg !2893
  %6 = load i8*, i8** %4, align 4, !dbg !2894, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2895
  store i8* %6, i8** %7, align 4, !dbg !2896, !tbaa !832
  %8 = load i32, i32* %5, align 4, !dbg !2897, !tbaa !663
  %9 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2898
  store i32 %8, i32* %9, align 4, !dbg !2899, !tbaa !822
  ret void, !dbg !2900
}

; Function Attrs: nounwind ssp
define i32 @aws_nospec_mask(i32 %0, i32 %1) #0 !dbg !2901 {
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store i32 %0, i32* %3, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %3, metadata !2903, metadata !DIExpression()), !dbg !2908
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !2904, metadata !DIExpression()), !dbg !2909
  %8 = load i32, i32* %3, align 4, !dbg !2910, !tbaa !663
  %9 = call i32 asm sideeffect "", "=r,0"(i32 %8) #19, !dbg !2910, !srcloc !2911
  store i32 %9, i32* %3, align 4, !dbg !2910, !tbaa !663
  %10 = bitcast i32* %5 to i8*, !dbg !2912
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %10) #19, !dbg !2912
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2905, metadata !DIExpression()), !dbg !2913
  %11 = load i32, i32* %3, align 4, !dbg !2914, !tbaa !663
  %12 = load i32, i32* %4, align 4, !dbg !2915, !tbaa !663
  %13 = or i32 %11, %12, !dbg !2916
  store i32 %13, i32* %5, align 4, !dbg !2913, !tbaa !663
  %14 = bitcast i32* %6 to i8*, !dbg !2917
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !2917
  call void @llvm.dbg.declare(metadata i32* %6, metadata !2906, metadata !DIExpression()), !dbg !2918
  %15 = load i32, i32* %4, align 4, !dbg !2919, !tbaa !663
  %16 = load i32, i32* %3, align 4, !dbg !2920, !tbaa !663
  %17 = sub i32 %15, %16, !dbg !2921
  %18 = sub i32 %17, 1, !dbg !2922
  store i32 %18, i32* %6, align 4, !dbg !2918, !tbaa !663
  %19 = bitcast i32* %7 to i8*, !dbg !2923
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %19) #19, !dbg !2923
  call void @llvm.dbg.declare(metadata i32* %7, metadata !2907, metadata !DIExpression()), !dbg !2924
  %20 = load i32, i32* %5, align 4, !dbg !2925, !tbaa !663
  %21 = load i32, i32* %6, align 4, !dbg !2926, !tbaa !663
  %22 = or i32 %20, %21, !dbg !2927
  store i32 %22, i32* %7, align 4, !dbg !2924, !tbaa !663
  %23 = load i32, i32* %7, align 4, !dbg !2928, !tbaa !663
  %24 = xor i32 %23, -1, !dbg !2929
  %25 = udiv i32 %24, -2147483648, !dbg !2930
  store i32 %25, i32* %7, align 4, !dbg !2931, !tbaa !663
  %26 = load i32, i32* %7, align 4, !dbg !2932, !tbaa !663
  %27 = mul i32 %26, -1, !dbg !2933
  store i32 %27, i32* %7, align 4, !dbg !2934, !tbaa !663
  %28 = load i32, i32* %7, align 4, !dbg !2935, !tbaa !663
  %29 = bitcast i32* %7 to i8*, !dbg !2936
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %29) #19, !dbg !2936
  %30 = bitcast i32* %6 to i8*, !dbg !2936
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %30) #19, !dbg !2936
  %31 = bitcast i32* %5 to i8*, !dbg !2936
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %31) #19, !dbg !2936
  ret i32 %28, !dbg !2937
}

; Function Attrs: nounwind ssp
define void @aws_byte_cursor_advance_nospec(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %1, i32 %2) #0 !dbg !2938 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !2942, metadata !DIExpression()), !dbg !2948
  store i32 %2, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !2943, metadata !DIExpression()), !dbg !2949
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !2944, metadata !DIExpression()), !dbg !2950
  %7 = load i32, i32* %5, align 4, !dbg !2951, !tbaa !663
  %8 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2952, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 0, !dbg !2953
  %10 = load i32, i32* %9, align 4, !dbg !2953, !tbaa !822
  %11 = icmp ule i32 %7, %10, !dbg !2954
  br i1 %11, label %12, label %76, !dbg !2955

12:                                               ; preds = %3
  %13 = load i32, i32* %5, align 4, !dbg !2956, !tbaa !663
  %14 = icmp ule i32 %13, 2147483647, !dbg !2957
  br i1 %14, label %15, label %76, !dbg !2958

15:                                               ; preds = %12
  %16 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2959, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %16, i32 0, i32 0, !dbg !2960
  %18 = load i32, i32* %17, align 4, !dbg !2960, !tbaa !822
  %19 = icmp ule i32 %18, 2147483647, !dbg !2961
  br i1 %19, label %20, label %76, !dbg !2962

20:                                               ; preds = %15
  %21 = bitcast i32* %6 to i8*, !dbg !2963
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %21) #19, !dbg !2963
  call void @llvm.dbg.declare(metadata i32* %6, metadata !2945, metadata !DIExpression()), !dbg !2964
  %22 = load i32, i32* %5, align 4, !dbg !2965, !tbaa !663
  %23 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2966, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %23, i32 0, i32 0, !dbg !2967
  %25 = load i32, i32* %24, align 4, !dbg !2967, !tbaa !822
  %26 = add i32 %25, 1, !dbg !2968
  %27 = call i32 @aws_nospec_mask(i32 %22, i32 %26) #17, !dbg !2969
  store i32 %27, i32* %6, align 4, !dbg !2964, !tbaa !663
  %28 = load i32, i32* %5, align 4, !dbg !2970, !tbaa !663
  %29 = load i32, i32* %6, align 4, !dbg !2971, !tbaa !663
  %30 = and i32 %28, %29, !dbg !2972
  store i32 %30, i32* %5, align 4, !dbg !2973, !tbaa !663
  %31 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2974, !tbaa !657
  %32 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %31, i32 0, i32 1, !dbg !2975
  %33 = load i8*, i8** %32, align 4, !dbg !2975, !tbaa !832
  %34 = ptrtoint i8* %33 to i32, !dbg !2976
  %35 = load i32, i32* %6, align 4, !dbg !2977, !tbaa !663
  %36 = and i32 %34, %35, !dbg !2978
  %37 = inttoptr i32 %36 to i8*, !dbg !2979
  %38 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2980, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %38, i32 0, i32 1, !dbg !2981
  store i8* %37, i8** %39, align 4, !dbg !2982, !tbaa !832
  %40 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2983, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %40, i32 0, i32 0, !dbg !2984
  %42 = load i32, i32* %41, align 4, !dbg !2984, !tbaa !822
  %43 = load i32, i32* %6, align 4, !dbg !2985, !tbaa !663
  %44 = and i32 %42, %43, !dbg !2986
  %45 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2987, !tbaa !657
  %46 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %45, i32 0, i32 0, !dbg !2988
  store i32 %44, i32* %46, align 4, !dbg !2989, !tbaa !822
  %47 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2990, !tbaa !657
  %48 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %47, i32 0, i32 1, !dbg !2991
  %49 = load i8*, i8** %48, align 4, !dbg !2991, !tbaa !832
  %50 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !2992
  store i8* %49, i8** %50, align 4, !dbg !2993, !tbaa !832
  %51 = load i32, i32* %5, align 4, !dbg !2994, !tbaa !663
  %52 = load i32, i32* %6, align 4, !dbg !2995, !tbaa !663
  %53 = and i32 %51, %52, !dbg !2996
  %54 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !2997
  store i32 %53, i32* %54, align 4, !dbg !2998, !tbaa !822
  %55 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !2999, !tbaa !657
  %56 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %55, i32 0, i32 1, !dbg !3000
  %57 = load i8*, i8** %56, align 4, !dbg !3000, !tbaa !832
  %58 = icmp eq i8* %57, null, !dbg !3001
  br i1 %58, label %59, label %60, !dbg !3002

59:                                               ; preds = %20
  br label %66, !dbg !3002

60:                                               ; preds = %20
  %61 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !3003, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %61, i32 0, i32 1, !dbg !3004
  %63 = load i8*, i8** %62, align 4, !dbg !3004, !tbaa !832
  %64 = load i32, i32* %5, align 4, !dbg !3005, !tbaa !663
  %65 = getelementptr inbounds i8, i8* %63, i32 %64, !dbg !3006
  br label %66, !dbg !3002

66:                                               ; preds = %60, %59
  %67 = phi i8* [ null, %59 ], [ %65, %60 ], !dbg !3002
  %68 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !3007, !tbaa !657
  %69 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %68, i32 0, i32 1, !dbg !3008
  store i8* %67, i8** %69, align 4, !dbg !3009, !tbaa !832
  %70 = load i32, i32* %5, align 4, !dbg !3010, !tbaa !663
  %71 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !3011, !tbaa !657
  %72 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %71, i32 0, i32 0, !dbg !3012
  %73 = load i32, i32* %72, align 4, !dbg !3013, !tbaa !822
  %74 = sub i32 %73, %70, !dbg !3013
  store i32 %74, i32* %72, align 4, !dbg !3013, !tbaa !822
  %75 = bitcast i32* %6 to i8*, !dbg !3014
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %75) #19, !dbg !3014
  br label %79, !dbg !3015

76:                                               ; preds = %15, %12, %3
  %77 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 1, !dbg !3016
  store i8* null, i8** %77, align 4, !dbg !3018, !tbaa !832
  %78 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %0, i32 0, i32 0, !dbg !3019
  store i32 0, i32* %78, align 4, !dbg !3020, !tbaa !822
  br label %79

79:                                               ; preds = %76, %66
  ret void, !dbg !3021
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* noalias %0, i8* noalias %1, i32 %2) #0 !dbg !3022 {
  %4 = alloca i1, align 1
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca %struct.aws_byte_cursor, align 4
  %9 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !3027, metadata !DIExpression()), !dbg !3031
  store i8* %1, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !3028, metadata !DIExpression()), !dbg !3032
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !3029, metadata !DIExpression()), !dbg !3033
  %10 = load i32, i32* %7, align 4, !dbg !3034, !tbaa !663
  %11 = icmp eq i32 %10, 0, !dbg !3036
  br i1 %11, label %12, label %13, !dbg !3037

12:                                               ; preds = %3
  store i1 true, i1* %4, align 1, !dbg !3038
  br label %31, !dbg !3038

13:                                               ; preds = %3
  %14 = bitcast %struct.aws_byte_cursor* %8 to i8*, !dbg !3040
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %14) #19, !dbg !3040
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %8, metadata !3030, metadata !DIExpression()), !dbg !3041
  %15 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !3042, !tbaa !657
  %16 = load i32, i32* %7, align 4, !dbg !3043, !tbaa !663
  call void @aws_byte_cursor_advance_nospec(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %8, %struct.aws_byte_cursor* %15, i32 %16) #17, !dbg !3044
  %17 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 1, !dbg !3045
  %18 = load i8*, i8** %17, align 4, !dbg !3045, !tbaa !832
  %19 = icmp ne i8* %18, null, !dbg !3047
  br i1 %19, label %20, label %28, !dbg !3048

20:                                               ; preds = %13
  %21 = load i8*, i8** %6, align 4, !dbg !3049, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 1, !dbg !3049
  %23 = load i8*, i8** %22, align 4, !dbg !3049, !tbaa !832
  %24 = load i32, i32* %7, align 4, !dbg !3049, !tbaa !663
  %25 = load i8*, i8** %6, align 4, !dbg !3049, !tbaa !657
  %26 = call i32 @llvm.objectsize.i32.p0i8(i8* %25, i1 false, i1 true, i1 false), !dbg !3049
  %27 = call i8* @__memcpy_chk(i8* %21, i8* %23, i32 %24, i32 %26) #18, !dbg !3049
  store i1 true, i1* %4, align 1, !dbg !3051
  store i32 1, i32* %9, align 4
  br label %29, !dbg !3051

28:                                               ; preds = %13
  store i1 false, i1* %4, align 1, !dbg !3052
  store i32 1, i32* %9, align 4
  br label %29, !dbg !3052

29:                                               ; preds = %28, %20
  %30 = bitcast %struct.aws_byte_cursor* %8 to i8*, !dbg !3053
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %30) #19, !dbg !3053
  br label %31

31:                                               ; preds = %29, %12
  %32 = load i1, i1* %4, align 1, !dbg !3053
  ret i1 %32, !dbg !3053
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_and_fill_buffer(%struct.aws_byte_cursor* noalias %0, %struct.aws_byte_buf* noalias %1) #0 !dbg !3054 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !3058, metadata !DIExpression()), !dbg !3060
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !3059, metadata !DIExpression()), !dbg !3061
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !3062, !tbaa !657
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3064, !tbaa !657
  %8 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %7, i32 0, i32 1, !dbg !3065
  %9 = load i8*, i8** %8, align 4, !dbg !3065, !tbaa !675
  %10 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3066, !tbaa !657
  %11 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %10, i32 0, i32 2, !dbg !3067
  %12 = load i32, i32* %11, align 4, !dbg !3067, !tbaa !698
  %13 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %9, i32 %12) #17, !dbg !3068
  br i1 %13, label %14, label %20, !dbg !3069

14:                                               ; preds = %2
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3070, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %15, i32 0, i32 2, !dbg !3072
  %17 = load i32, i32* %16, align 4, !dbg !3072, !tbaa !698
  %18 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3073, !tbaa !657
  %19 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %18, i32 0, i32 0, !dbg !3074
  store i32 %17, i32* %19, align 4, !dbg !3075, !tbaa !693
  store i1 true, i1* %3, align 1, !dbg !3076
  br label %21, !dbg !3076

20:                                               ; preds = %2
  store i1 false, i1* %3, align 1, !dbg !3077
  br label %21, !dbg !3077

21:                                               ; preds = %20, %14
  %22 = load i1, i1* %3, align 1, !dbg !3078
  ret i1 %22, !dbg !3078
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_u8(%struct.aws_byte_cursor* noalias %0, i8* noalias %1) #0 !dbg !3079 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3084, metadata !DIExpression()), !dbg !3087
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !3085, metadata !DIExpression()), !dbg !3088
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3089
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3086, metadata !DIExpression()), !dbg !3090
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3091, !tbaa !657
  %7 = load i8*, i8** %4, align 4, !dbg !3092, !tbaa !657
  %8 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %7, i32 1) #17, !dbg !3093
  %9 = zext i1 %8 to i8, !dbg !3090
  store i8 %9, i8* %5, align 1, !dbg !3090, !tbaa !844
  %10 = load i8, i8* %5, align 1, !dbg !3094, !tbaa !844, !range !849
  %11 = trunc i8 %10 to i1, !dbg !3094
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3095
  ret i1 %11, !dbg !3096
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_be16(%struct.aws_byte_cursor* %0, i16* %1) #0 !dbg !3097 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i16*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3102, metadata !DIExpression()), !dbg !3105
  store i16* %1, i16** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i16** %4, metadata !3103, metadata !DIExpression()), !dbg !3106
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3107
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3104, metadata !DIExpression()), !dbg !3108
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3109, !tbaa !657
  %7 = load i16*, i16** %4, align 4, !dbg !3110, !tbaa !657
  %8 = bitcast i16* %7 to i8*, !dbg !3110
  %9 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %8, i32 2) #17, !dbg !3111
  %10 = zext i1 %9 to i8, !dbg !3108
  store i8 %10, i8* %5, align 1, !dbg !3108, !tbaa !844
  %11 = load i8, i8* %5, align 1, !dbg !3112, !tbaa !844, !range !849
  %12 = trunc i8 %11 to i1, !dbg !3112
  %13 = xor i1 %12, true, !dbg !3112
  %14 = xor i1 %13, true, !dbg !3112
  %15 = zext i1 %14 to i32, !dbg !3112
  %16 = call i32 @llvm.expect.i32(i32 %15, i32 1), !dbg !3112
  %17 = icmp ne i32 %16, 0, !dbg !3112
  br i1 %17, label %18, label %23, !dbg !3114

18:                                               ; preds = %2
  %19 = load i16*, i16** %4, align 4, !dbg !3115, !tbaa !657
  %20 = load i16, i16* %19, align 2, !dbg !3117, !tbaa !3118
  %21 = call zeroext i16 @aws_ntoh16(i16 zeroext %20) #17, !dbg !3120
  %22 = load i16*, i16** %4, align 4, !dbg !3121, !tbaa !657
  store i16 %21, i16* %22, align 2, !dbg !3122, !tbaa !3118
  br label %23, !dbg !3123

23:                                               ; preds = %18, %2
  %24 = load i8, i8* %5, align 1, !dbg !3124, !tbaa !844, !range !849
  %25 = trunc i8 %24 to i1, !dbg !3124
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3125
  ret i1 %25, !dbg !3126
}

; Function Attrs: inlinehint nounwind ssp
define internal zeroext i16 @aws_ntoh16(i16 zeroext %0) #2 !dbg !3127 {
  %2 = alloca i16, align 2
  store i16 %0, i16* %2, align 2, !tbaa !3118
  call void @llvm.dbg.declare(metadata i16* %2, metadata !3132, metadata !DIExpression()), !dbg !3133
  %3 = load i16, i16* %2, align 2, !dbg !3134, !tbaa !3118
  %4 = call i1 @llvm.is.constant.i16(i16 %3), !dbg !3134
  br i1 %4, label %5, label %17, !dbg !3134

5:                                                ; preds = %1
  %6 = load i16, i16* %2, align 2, !dbg !3134, !tbaa !3118
  %7 = zext i16 %6 to i32, !dbg !3134
  %8 = and i32 %7, 65280, !dbg !3134
  %9 = lshr i32 %8, 8, !dbg !3134
  %10 = load i16, i16* %2, align 2, !dbg !3134, !tbaa !3118
  %11 = zext i16 %10 to i32, !dbg !3134
  %12 = and i32 %11, 255, !dbg !3134
  %13 = shl i32 %12, 8, !dbg !3134
  %14 = or i32 %9, %13, !dbg !3134
  %15 = trunc i32 %14 to i16, !dbg !3134
  %16 = zext i16 %15 to i32, !dbg !3134
  br label %21, !dbg !3134

17:                                               ; preds = %1
  %18 = load i16, i16* %2, align 2, !dbg !3134, !tbaa !3118
  %19 = call zeroext i16 @_OSSwapInt16(i16 zeroext %18) #17, !dbg !3134
  %20 = zext i16 %19 to i32, !dbg !3134
  br label %21, !dbg !3134

21:                                               ; preds = %17, %5
  %22 = phi i32 [ %16, %5 ], [ %20, %17 ], !dbg !3134
  %23 = trunc i32 %22 to i16, !dbg !3134
  ret i16 %23, !dbg !3135
}

; Function Attrs: convergent nofree nosync nounwind readnone willreturn
declare i1 @llvm.is.constant.i16(i16) #10

; Function Attrs: inlinehint nounwind ssp
define internal zeroext i16 @_OSSwapInt16(i16 zeroext %0) #2 !dbg !3136 {
  %2 = alloca i16, align 2
  store i16 %0, i16* %2, align 2, !tbaa !3118
  call void @llvm.dbg.declare(metadata i16* %2, metadata !3139, metadata !DIExpression()), !dbg !3140
  %3 = load i16, i16* %2, align 2, !dbg !3141, !tbaa !3118
  %4 = zext i16 %3 to i32, !dbg !3141
  %5 = shl i32 %4, 8, !dbg !3142
  %6 = load i16, i16* %2, align 2, !dbg !3143, !tbaa !3118
  %7 = zext i16 %6 to i32, !dbg !3143
  %8 = ashr i32 %7, 8, !dbg !3144
  %9 = or i32 %5, %8, !dbg !3145
  %10 = trunc i32 %9 to i16, !dbg !3146
  ret i16 %10, !dbg !3147
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_be24(%struct.aws_byte_cursor* %0, i32* %1) #0 !dbg !3148 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i32*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3152, metadata !DIExpression()), !dbg !3156
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !3153, metadata !DIExpression()), !dbg !3157
  %7 = bitcast i8** %5 to i8*, !dbg !3158
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !3158
  call void @llvm.dbg.declare(metadata i8** %5, metadata !3154, metadata !DIExpression()), !dbg !3159
  %8 = load i32*, i32** %4, align 4, !dbg !3160, !tbaa !657
  %9 = bitcast i32* %8 to i8*, !dbg !3161
  store i8* %9, i8** %5, align 4, !dbg !3159, !tbaa !657
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !3162
  call void @llvm.dbg.declare(metadata i8* %6, metadata !3155, metadata !DIExpression()), !dbg !3163
  %10 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3164, !tbaa !657
  %11 = load i8*, i8** %5, align 4, !dbg !3165, !tbaa !657
  %12 = getelementptr inbounds i8, i8* %11, i32 1, !dbg !3165
  %13 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %10, i8* %12, i32 3) #17, !dbg !3166
  %14 = zext i1 %13 to i8, !dbg !3163
  store i8 %14, i8* %6, align 1, !dbg !3163, !tbaa !844
  %15 = load i8, i8* %6, align 1, !dbg !3167, !tbaa !844, !range !849
  %16 = trunc i8 %15 to i1, !dbg !3167
  %17 = xor i1 %16, true, !dbg !3167
  %18 = xor i1 %17, true, !dbg !3167
  %19 = zext i1 %18 to i32, !dbg !3167
  %20 = call i32 @llvm.expect.i32(i32 %19, i32 1), !dbg !3167
  %21 = icmp ne i32 %20, 0, !dbg !3167
  br i1 %21, label %22, label %29, !dbg !3169

22:                                               ; preds = %2
  %23 = load i8*, i8** %5, align 4, !dbg !3170, !tbaa !657
  %24 = getelementptr inbounds i8, i8* %23, i32 0, !dbg !3170
  store i8 0, i8* %24, align 1, !dbg !3172, !tbaa !1034
  %25 = load i32*, i32** %4, align 4, !dbg !3173, !tbaa !657
  %26 = load i32, i32* %25, align 4, !dbg !3174, !tbaa !805
  %27 = call i32 @aws_ntoh32(i32 %26) #17, !dbg !3175
  %28 = load i32*, i32** %4, align 4, !dbg !3176, !tbaa !657
  store i32 %27, i32* %28, align 4, !dbg !3177, !tbaa !805
  br label %29, !dbg !3178

29:                                               ; preds = %22, %2
  %30 = load i8, i8* %6, align 1, !dbg !3179, !tbaa !844, !range !849
  %31 = trunc i8 %30 to i1, !dbg !3179
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !3180
  %32 = bitcast i8** %5 to i8*, !dbg !3180
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %32) #19, !dbg !3180
  ret i1 %31, !dbg !3181
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_ntoh32(i32 %0) #2 !dbg !3182 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %2, metadata !3186, metadata !DIExpression()), !dbg !3187
  %3 = load i32, i32* %2, align 4, !dbg !3188, !tbaa !805
  %4 = call i1 @llvm.is.constant.i32(i32 %3), !dbg !3188
  br i1 %4, label %5, label %21, !dbg !3188

5:                                                ; preds = %1
  %6 = load i32, i32* %2, align 4, !dbg !3188, !tbaa !805
  %7 = and i32 %6, -16777216, !dbg !3188
  %8 = lshr i32 %7, 24, !dbg !3188
  %9 = load i32, i32* %2, align 4, !dbg !3188, !tbaa !805
  %10 = and i32 %9, 16711680, !dbg !3188
  %11 = lshr i32 %10, 8, !dbg !3188
  %12 = or i32 %8, %11, !dbg !3188
  %13 = load i32, i32* %2, align 4, !dbg !3188, !tbaa !805
  %14 = and i32 %13, 65280, !dbg !3188
  %15 = shl i32 %14, 8, !dbg !3188
  %16 = or i32 %12, %15, !dbg !3188
  %17 = load i32, i32* %2, align 4, !dbg !3188, !tbaa !805
  %18 = and i32 %17, 255, !dbg !3188
  %19 = shl i32 %18, 24, !dbg !3188
  %20 = or i32 %16, %19, !dbg !3188
  br label %24, !dbg !3188

21:                                               ; preds = %1
  %22 = load i32, i32* %2, align 4, !dbg !3188, !tbaa !805
  %23 = call i32 @_OSSwapInt32(i32 %22) #17, !dbg !3188
  br label %24, !dbg !3188

24:                                               ; preds = %21, %5
  %25 = phi i32 [ %20, %5 ], [ %23, %21 ], !dbg !3188
  ret i32 %25, !dbg !3189
}

; Function Attrs: convergent nofree nosync nounwind readnone willreturn
declare i1 @llvm.is.constant.i32(i32) #10

; Function Attrs: inlinehint nounwind ssp
define internal i32 @_OSSwapInt32(i32 %0) #2 !dbg !3190 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %2, metadata !3192, metadata !DIExpression()), !dbg !3193
  %3 = load i32, i32* %2, align 4, !dbg !3194, !tbaa !805
  %4 = call i32 @llvm.bswap.i32(i32 %3), !dbg !3195
  store i32 %4, i32* %2, align 4, !dbg !3196, !tbaa !805
  %5 = load i32, i32* %2, align 4, !dbg !3197, !tbaa !805
  ret i32 %5, !dbg !3198
}

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare i32 @llvm.bswap.i32(i32) #1

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_be32(%struct.aws_byte_cursor* %0, i32* %1) #0 !dbg !3199 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i32*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3201, metadata !DIExpression()), !dbg !3204
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !3202, metadata !DIExpression()), !dbg !3205
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3206
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3203, metadata !DIExpression()), !dbg !3207
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3208, !tbaa !657
  %7 = load i32*, i32** %4, align 4, !dbg !3209, !tbaa !657
  %8 = bitcast i32* %7 to i8*, !dbg !3209
  %9 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %8, i32 4) #17, !dbg !3210
  %10 = zext i1 %9 to i8, !dbg !3207
  store i8 %10, i8* %5, align 1, !dbg !3207, !tbaa !844
  %11 = load i8, i8* %5, align 1, !dbg !3211, !tbaa !844, !range !849
  %12 = trunc i8 %11 to i1, !dbg !3211
  %13 = xor i1 %12, true, !dbg !3211
  %14 = xor i1 %13, true, !dbg !3211
  %15 = zext i1 %14 to i32, !dbg !3211
  %16 = call i32 @llvm.expect.i32(i32 %15, i32 1), !dbg !3211
  %17 = icmp ne i32 %16, 0, !dbg !3211
  br i1 %17, label %18, label %23, !dbg !3213

18:                                               ; preds = %2
  %19 = load i32*, i32** %4, align 4, !dbg !3214, !tbaa !657
  %20 = load i32, i32* %19, align 4, !dbg !3216, !tbaa !805
  %21 = call i32 @aws_ntoh32(i32 %20) #17, !dbg !3217
  %22 = load i32*, i32** %4, align 4, !dbg !3218, !tbaa !657
  store i32 %21, i32* %22, align 4, !dbg !3219, !tbaa !805
  br label %23, !dbg !3220

23:                                               ; preds = %18, %2
  %24 = load i8, i8* %5, align 1, !dbg !3221, !tbaa !844, !range !849
  %25 = trunc i8 %24 to i1, !dbg !3221
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3222
  ret i1 %25, !dbg !3223
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_float_be32(%struct.aws_byte_cursor* %0, float* %1) #0 !dbg !3224 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca float*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3230, metadata !DIExpression()), !dbg !3233
  store float* %1, float** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata float** %4, metadata !3231, metadata !DIExpression()), !dbg !3234
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3235
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3232, metadata !DIExpression()), !dbg !3236
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3237, !tbaa !657
  %7 = load float*, float** %4, align 4, !dbg !3238, !tbaa !657
  %8 = bitcast float* %7 to i8*, !dbg !3238
  %9 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %8, i32 4) #17, !dbg !3239
  %10 = zext i1 %9 to i8, !dbg !3236
  store i8 %10, i8* %5, align 1, !dbg !3236, !tbaa !844
  %11 = load i8, i8* %5, align 1, !dbg !3240, !tbaa !844, !range !849
  %12 = trunc i8 %11 to i1, !dbg !3240
  %13 = xor i1 %12, true, !dbg !3240
  %14 = xor i1 %13, true, !dbg !3240
  %15 = zext i1 %14 to i32, !dbg !3240
  %16 = call i32 @llvm.expect.i32(i32 %15, i32 1), !dbg !3240
  %17 = icmp ne i32 %16, 0, !dbg !3240
  br i1 %17, label %18, label %23, !dbg !3242

18:                                               ; preds = %2
  %19 = load float*, float** %4, align 4, !dbg !3243, !tbaa !657
  %20 = load float, float* %19, align 4, !dbg !3245, !tbaa !3246
  %21 = call float @aws_ntohf32(float %20) #17, !dbg !3248
  %22 = load float*, float** %4, align 4, !dbg !3249, !tbaa !657
  store float %21, float* %22, align 4, !dbg !3250, !tbaa !3246
  br label %23, !dbg !3251

23:                                               ; preds = %18, %2
  %24 = load i8, i8* %5, align 1, !dbg !3252, !tbaa !844, !range !849
  %25 = trunc i8 %24 to i1, !dbg !3252
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3253
  ret i1 %25, !dbg !3254
}

; Function Attrs: inlinehint nounwind ssp
define internal float @aws_ntohf32(float %0) #2 !dbg !3255 {
  %2 = alloca float, align 4
  store float %0, float* %2, align 4, !tbaa !3246
  call void @llvm.dbg.declare(metadata float* %2, metadata !3259, metadata !DIExpression()), !dbg !3260
  %3 = load float, float* %2, align 4, !dbg !3261, !tbaa !3246
  %4 = call float @aws_htonf32(float %3) #17, !dbg !3262
  ret float %4, !dbg !3263
}

; Function Attrs: inlinehint nounwind ssp
define internal float @aws_htonf32(float %0) #2 !dbg !3264 {
  %2 = alloca float, align 4
  %3 = alloca float, align 4
  %4 = alloca i8*, align 4
  %5 = alloca float, align 4
  %6 = alloca i8*, align 4
  store float %0, float* %3, align 4, !tbaa !3246
  call void @llvm.dbg.declare(metadata float* %3, metadata !3266, metadata !DIExpression()), !dbg !3270
  %7 = call i32 @aws_is_big_endian() #17, !dbg !3271
  %8 = icmp ne i32 %7, 0, !dbg !3271
  br i1 %8, label %9, label %11, !dbg !3273

9:                                                ; preds = %1
  %10 = load float, float* %3, align 4, !dbg !3274, !tbaa !3246
  store float %10, float* %2, align 4, !dbg !3276
  br label %41, !dbg !3276

11:                                               ; preds = %1
  %12 = bitcast i8** %4 to i8*, !dbg !3277
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !3277
  call void @llvm.dbg.declare(metadata i8** %4, metadata !3267, metadata !DIExpression()), !dbg !3278
  %13 = bitcast float* %3 to i8*, !dbg !3279
  store i8* %13, i8** %4, align 4, !dbg !3278, !tbaa !657
  %14 = bitcast float* %5 to i8*, !dbg !3280
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !3280
  call void @llvm.dbg.declare(metadata float* %5, metadata !3268, metadata !DIExpression()), !dbg !3281
  %15 = bitcast i8** %6 to i8*, !dbg !3282
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !3282
  call void @llvm.dbg.declare(metadata i8** %6, metadata !3269, metadata !DIExpression()), !dbg !3283
  %16 = bitcast float* %5 to i8*, !dbg !3284
  store i8* %16, i8** %6, align 4, !dbg !3283, !tbaa !657
  %17 = load i8*, i8** %4, align 4, !dbg !3285, !tbaa !657
  %18 = getelementptr inbounds i8, i8* %17, i32 3, !dbg !3285
  %19 = load i8, i8* %18, align 1, !dbg !3285, !tbaa !1034
  %20 = load i8*, i8** %6, align 4, !dbg !3286, !tbaa !657
  %21 = getelementptr inbounds i8, i8* %20, i32 0, !dbg !3286
  store i8 %19, i8* %21, align 1, !dbg !3287, !tbaa !1034
  %22 = load i8*, i8** %4, align 4, !dbg !3288, !tbaa !657
  %23 = getelementptr inbounds i8, i8* %22, i32 2, !dbg !3288
  %24 = load i8, i8* %23, align 1, !dbg !3288, !tbaa !1034
  %25 = load i8*, i8** %6, align 4, !dbg !3289, !tbaa !657
  %26 = getelementptr inbounds i8, i8* %25, i32 1, !dbg !3289
  store i8 %24, i8* %26, align 1, !dbg !3290, !tbaa !1034
  %27 = load i8*, i8** %4, align 4, !dbg !3291, !tbaa !657
  %28 = getelementptr inbounds i8, i8* %27, i32 1, !dbg !3291
  %29 = load i8, i8* %28, align 1, !dbg !3291, !tbaa !1034
  %30 = load i8*, i8** %6, align 4, !dbg !3292, !tbaa !657
  %31 = getelementptr inbounds i8, i8* %30, i32 2, !dbg !3292
  store i8 %29, i8* %31, align 1, !dbg !3293, !tbaa !1034
  %32 = load i8*, i8** %4, align 4, !dbg !3294, !tbaa !657
  %33 = getelementptr inbounds i8, i8* %32, i32 0, !dbg !3294
  %34 = load i8, i8* %33, align 1, !dbg !3294, !tbaa !1034
  %35 = load i8*, i8** %6, align 4, !dbg !3295, !tbaa !657
  %36 = getelementptr inbounds i8, i8* %35, i32 3, !dbg !3295
  store i8 %34, i8* %36, align 1, !dbg !3296, !tbaa !1034
  %37 = load float, float* %5, align 4, !dbg !3297, !tbaa !3246
  store float %37, float* %2, align 4, !dbg !3298
  %38 = bitcast i8** %6 to i8*, !dbg !3299
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %38) #19, !dbg !3299
  %39 = bitcast float* %5 to i8*, !dbg !3299
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %39) #19, !dbg !3299
  %40 = bitcast i8** %4 to i8*, !dbg !3299
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %40) #19, !dbg !3299
  br label %41

41:                                               ; preds = %11, %9
  %42 = load float, float* %2, align 4, !dbg !3299
  ret float %42, !dbg !3299
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_is_big_endian() #2 !dbg !3300 {
  %1 = alloca i16, align 2
  %2 = bitcast i16* %1 to i8*, !dbg !3304
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %2) #19, !dbg !3304
  call void @llvm.dbg.declare(metadata i16* %1, metadata !3302, metadata !DIExpression()), !dbg !3305
  store i16 256, i16* %1, align 2, !dbg !3305, !tbaa !3118
  %3 = bitcast i16* %1 to i8*, !dbg !3306
  %4 = load i8, i8* %3, align 2, !dbg !3306, !tbaa !1034
  %5 = zext i8 %4 to i32, !dbg !3306
  %6 = bitcast i16* %1 to i8*, !dbg !3307
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %6) #19, !dbg !3307
  ret i32 %5, !dbg !3308
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_float_be64(%struct.aws_byte_cursor* %0, double* %1) #0 !dbg !3309 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca double*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3314, metadata !DIExpression()), !dbg !3317
  store double* %1, double** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata double** %4, metadata !3315, metadata !DIExpression()), !dbg !3318
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3319
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3316, metadata !DIExpression()), !dbg !3320
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3321, !tbaa !657
  %7 = load double*, double** %4, align 4, !dbg !3322, !tbaa !657
  %8 = bitcast double* %7 to i8*, !dbg !3322
  %9 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %8, i32 8) #17, !dbg !3323
  %10 = zext i1 %9 to i8, !dbg !3320
  store i8 %10, i8* %5, align 1, !dbg !3320, !tbaa !844
  %11 = load i8, i8* %5, align 1, !dbg !3324, !tbaa !844, !range !849
  %12 = trunc i8 %11 to i1, !dbg !3324
  %13 = xor i1 %12, true, !dbg !3324
  %14 = xor i1 %13, true, !dbg !3324
  %15 = zext i1 %14 to i32, !dbg !3324
  %16 = call i32 @llvm.expect.i32(i32 %15, i32 1), !dbg !3324
  %17 = icmp ne i32 %16, 0, !dbg !3324
  br i1 %17, label %18, label %23, !dbg !3326

18:                                               ; preds = %2
  %19 = load double*, double** %4, align 4, !dbg !3327, !tbaa !657
  %20 = load double, double* %19, align 4, !dbg !3329, !tbaa !3330
  %21 = call double @aws_ntohf64(double %20) #17, !dbg !3332
  %22 = load double*, double** %4, align 4, !dbg !3333, !tbaa !657
  store double %21, double* %22, align 4, !dbg !3334, !tbaa !3330
  br label %23, !dbg !3335

23:                                               ; preds = %18, %2
  %24 = load i8, i8* %5, align 1, !dbg !3336, !tbaa !844, !range !849
  %25 = trunc i8 %24 to i1, !dbg !3336
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3337
  ret i1 %25, !dbg !3338
}

; Function Attrs: inlinehint nounwind ssp
define internal double @aws_ntohf64(double %0) #2 !dbg !3339 {
  %2 = alloca double, align 8
  store double %0, double* %2, align 8, !tbaa !3330
  call void @llvm.dbg.declare(metadata double* %2, metadata !3343, metadata !DIExpression()), !dbg !3344
  %3 = load double, double* %2, align 8, !dbg !3345, !tbaa !3330
  %4 = call double @aws_htonf64(double %3) #17, !dbg !3346
  ret double %4, !dbg !3347
}

; Function Attrs: inlinehint nounwind ssp
define internal double @aws_htonf64(double %0) #2 !dbg !3348 {
  %2 = alloca double, align 4
  %3 = alloca double, align 8
  %4 = alloca i8*, align 4
  %5 = alloca double, align 8
  %6 = alloca i8*, align 4
  store double %0, double* %3, align 8, !tbaa !3330
  call void @llvm.dbg.declare(metadata double* %3, metadata !3350, metadata !DIExpression()), !dbg !3354
  %7 = call i32 @aws_is_big_endian() #17, !dbg !3355
  %8 = icmp ne i32 %7, 0, !dbg !3355
  br i1 %8, label %9, label %11, !dbg !3357

9:                                                ; preds = %1
  %10 = load double, double* %3, align 8, !dbg !3358, !tbaa !3330
  store double %10, double* %2, align 4, !dbg !3360
  br label %61, !dbg !3360

11:                                               ; preds = %1
  %12 = bitcast i8** %4 to i8*, !dbg !3361
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !3361
  call void @llvm.dbg.declare(metadata i8** %4, metadata !3351, metadata !DIExpression()), !dbg !3362
  %13 = bitcast double* %3 to i8*, !dbg !3363
  store i8* %13, i8** %4, align 4, !dbg !3362, !tbaa !657
  %14 = bitcast double* %5 to i8*, !dbg !3364
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %14) #19, !dbg !3364
  call void @llvm.dbg.declare(metadata double* %5, metadata !3352, metadata !DIExpression()), !dbg !3365
  %15 = bitcast i8** %6 to i8*, !dbg !3366
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !3366
  call void @llvm.dbg.declare(metadata i8** %6, metadata !3353, metadata !DIExpression()), !dbg !3367
  %16 = bitcast double* %5 to i8*, !dbg !3368
  store i8* %16, i8** %6, align 4, !dbg !3367, !tbaa !657
  %17 = load i8*, i8** %4, align 4, !dbg !3369, !tbaa !657
  %18 = getelementptr inbounds i8, i8* %17, i32 7, !dbg !3369
  %19 = load i8, i8* %18, align 1, !dbg !3369, !tbaa !1034
  %20 = load i8*, i8** %6, align 4, !dbg !3370, !tbaa !657
  %21 = getelementptr inbounds i8, i8* %20, i32 0, !dbg !3370
  store i8 %19, i8* %21, align 1, !dbg !3371, !tbaa !1034
  %22 = load i8*, i8** %4, align 4, !dbg !3372, !tbaa !657
  %23 = getelementptr inbounds i8, i8* %22, i32 6, !dbg !3372
  %24 = load i8, i8* %23, align 1, !dbg !3372, !tbaa !1034
  %25 = load i8*, i8** %6, align 4, !dbg !3373, !tbaa !657
  %26 = getelementptr inbounds i8, i8* %25, i32 1, !dbg !3373
  store i8 %24, i8* %26, align 1, !dbg !3374, !tbaa !1034
  %27 = load i8*, i8** %4, align 4, !dbg !3375, !tbaa !657
  %28 = getelementptr inbounds i8, i8* %27, i32 5, !dbg !3375
  %29 = load i8, i8* %28, align 1, !dbg !3375, !tbaa !1034
  %30 = load i8*, i8** %6, align 4, !dbg !3376, !tbaa !657
  %31 = getelementptr inbounds i8, i8* %30, i32 2, !dbg !3376
  store i8 %29, i8* %31, align 1, !dbg !3377, !tbaa !1034
  %32 = load i8*, i8** %4, align 4, !dbg !3378, !tbaa !657
  %33 = getelementptr inbounds i8, i8* %32, i32 4, !dbg !3378
  %34 = load i8, i8* %33, align 1, !dbg !3378, !tbaa !1034
  %35 = load i8*, i8** %6, align 4, !dbg !3379, !tbaa !657
  %36 = getelementptr inbounds i8, i8* %35, i32 3, !dbg !3379
  store i8 %34, i8* %36, align 1, !dbg !3380, !tbaa !1034
  %37 = load i8*, i8** %4, align 4, !dbg !3381, !tbaa !657
  %38 = getelementptr inbounds i8, i8* %37, i32 3, !dbg !3381
  %39 = load i8, i8* %38, align 1, !dbg !3381, !tbaa !1034
  %40 = load i8*, i8** %6, align 4, !dbg !3382, !tbaa !657
  %41 = getelementptr inbounds i8, i8* %40, i32 4, !dbg !3382
  store i8 %39, i8* %41, align 1, !dbg !3383, !tbaa !1034
  %42 = load i8*, i8** %4, align 4, !dbg !3384, !tbaa !657
  %43 = getelementptr inbounds i8, i8* %42, i32 2, !dbg !3384
  %44 = load i8, i8* %43, align 1, !dbg !3384, !tbaa !1034
  %45 = load i8*, i8** %6, align 4, !dbg !3385, !tbaa !657
  %46 = getelementptr inbounds i8, i8* %45, i32 5, !dbg !3385
  store i8 %44, i8* %46, align 1, !dbg !3386, !tbaa !1034
  %47 = load i8*, i8** %4, align 4, !dbg !3387, !tbaa !657
  %48 = getelementptr inbounds i8, i8* %47, i32 1, !dbg !3387
  %49 = load i8, i8* %48, align 1, !dbg !3387, !tbaa !1034
  %50 = load i8*, i8** %6, align 4, !dbg !3388, !tbaa !657
  %51 = getelementptr inbounds i8, i8* %50, i32 6, !dbg !3388
  store i8 %49, i8* %51, align 1, !dbg !3389, !tbaa !1034
  %52 = load i8*, i8** %4, align 4, !dbg !3390, !tbaa !657
  %53 = getelementptr inbounds i8, i8* %52, i32 0, !dbg !3390
  %54 = load i8, i8* %53, align 1, !dbg !3390, !tbaa !1034
  %55 = load i8*, i8** %6, align 4, !dbg !3391, !tbaa !657
  %56 = getelementptr inbounds i8, i8* %55, i32 7, !dbg !3391
  store i8 %54, i8* %56, align 1, !dbg !3392, !tbaa !1034
  %57 = load double, double* %5, align 8, !dbg !3393, !tbaa !3330
  store double %57, double* %2, align 4, !dbg !3394
  %58 = bitcast i8** %6 to i8*, !dbg !3395
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %58) #19, !dbg !3395
  %59 = bitcast double* %5 to i8*, !dbg !3395
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %59) #19, !dbg !3395
  %60 = bitcast i8** %4 to i8*, !dbg !3395
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %60) #19, !dbg !3395
  br label %61

61:                                               ; preds = %11, %9
  %62 = load double, double* %2, align 4, !dbg !3395
  ret double %62, !dbg !3395
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_be64(%struct.aws_byte_cursor* %0, i64* %1) #0 !dbg !3396 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i64*, align 4
  %5 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3401, metadata !DIExpression()), !dbg !3404
  store i64* %1, i64** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i64** %4, metadata !3402, metadata !DIExpression()), !dbg !3405
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3406
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3403, metadata !DIExpression()), !dbg !3407
  %6 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3408, !tbaa !657
  %7 = load i64*, i64** %4, align 4, !dbg !3409, !tbaa !657
  %8 = bitcast i64* %7 to i8*, !dbg !3409
  %9 = call zeroext i1 @aws_byte_cursor_read(%struct.aws_byte_cursor* %6, i8* %8, i32 8) #17, !dbg !3410
  %10 = zext i1 %9 to i8, !dbg !3407
  store i8 %10, i8* %5, align 1, !dbg !3407, !tbaa !844
  %11 = load i8, i8* %5, align 1, !dbg !3411, !tbaa !844, !range !849
  %12 = trunc i8 %11 to i1, !dbg !3411
  %13 = xor i1 %12, true, !dbg !3411
  %14 = xor i1 %13, true, !dbg !3411
  %15 = zext i1 %14 to i32, !dbg !3411
  %16 = call i32 @llvm.expect.i32(i32 %15, i32 1), !dbg !3411
  %17 = icmp ne i32 %16, 0, !dbg !3411
  br i1 %17, label %18, label %23, !dbg !3413

18:                                               ; preds = %2
  %19 = load i64*, i64** %4, align 4, !dbg !3414, !tbaa !657
  %20 = load i64, i64* %19, align 4, !dbg !3416, !tbaa !1986
  %21 = call i64 @aws_ntoh64(i64 %20) #17, !dbg !3417
  %22 = load i64*, i64** %4, align 4, !dbg !3418, !tbaa !657
  store i64 %21, i64* %22, align 4, !dbg !3419, !tbaa !1986
  br label %23, !dbg !3420

23:                                               ; preds = %18, %2
  %24 = load i8, i8* %5, align 1, !dbg !3421, !tbaa !844, !range !849
  %25 = trunc i8 %24 to i1, !dbg !3421
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3422
  ret i1 %25, !dbg !3423
}

; Function Attrs: inlinehint nounwind ssp
define internal i64 @aws_ntoh64(i64 %0) #2 !dbg !3424 {
  %2 = alloca i64, align 8
  store i64 %0, i64* %2, align 8, !tbaa !1986
  call void @llvm.dbg.declare(metadata i64* %2, metadata !3428, metadata !DIExpression()), !dbg !3429
  %3 = load i64, i64* %2, align 8, !dbg !3430, !tbaa !1986
  %4 = call i64 @aws_hton64(i64 %3) #17, !dbg !3431
  ret i64 %4, !dbg !3432
}

; Function Attrs: inlinehint nounwind ssp
define internal i64 @aws_hton64(i64 %0) #2 !dbg !3433 {
  %2 = alloca i64, align 4
  %3 = alloca i64, align 8
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  store i64 %0, i64* %3, align 8, !tbaa !1986
  call void @llvm.dbg.declare(metadata i64* %3, metadata !3435, metadata !DIExpression()), !dbg !3438
  %6 = call i32 @aws_is_big_endian() #17, !dbg !3439
  %7 = icmp ne i32 %6, 0, !dbg !3439
  br i1 %7, label %8, label %10, !dbg !3441

8:                                                ; preds = %1
  %9 = load i64, i64* %3, align 8, !dbg !3442, !tbaa !1986
  store i64 %9, i64* %2, align 4, !dbg !3444
  br label %71, !dbg !3444

10:                                               ; preds = %1
  %11 = bitcast i32* %4 to i8*, !dbg !3445
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %11) #19, !dbg !3445
  call void @llvm.dbg.declare(metadata i32* %4, metadata !3436, metadata !DIExpression()), !dbg !3446
  %12 = load i64, i64* %3, align 8, !dbg !3447, !tbaa !1986
  %13 = and i64 %12, 4294967295, !dbg !3448
  %14 = trunc i64 %13 to i32, !dbg !3447
  store i32 %14, i32* %4, align 4, !dbg !3446, !tbaa !805
  %15 = bitcast i32* %5 to i8*, !dbg !3449
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !3449
  call void @llvm.dbg.declare(metadata i32* %5, metadata !3437, metadata !DIExpression()), !dbg !3450
  %16 = load i64, i64* %3, align 8, !dbg !3451, !tbaa !1986
  %17 = lshr i64 %16, 32, !dbg !3452
  %18 = trunc i64 %17 to i32, !dbg !3453
  store i32 %18, i32* %5, align 4, !dbg !3450, !tbaa !805
  %19 = load i32, i32* %4, align 4, !dbg !3454, !tbaa !805
  %20 = call i1 @llvm.is.constant.i32(i32 %19), !dbg !3454
  br i1 %20, label %21, label %37, !dbg !3454

21:                                               ; preds = %10
  %22 = load i32, i32* %4, align 4, !dbg !3454, !tbaa !805
  %23 = and i32 %22, -16777216, !dbg !3454
  %24 = lshr i32 %23, 24, !dbg !3454
  %25 = load i32, i32* %4, align 4, !dbg !3454, !tbaa !805
  %26 = and i32 %25, 16711680, !dbg !3454
  %27 = lshr i32 %26, 8, !dbg !3454
  %28 = or i32 %24, %27, !dbg !3454
  %29 = load i32, i32* %4, align 4, !dbg !3454, !tbaa !805
  %30 = and i32 %29, 65280, !dbg !3454
  %31 = shl i32 %30, 8, !dbg !3454
  %32 = or i32 %28, %31, !dbg !3454
  %33 = load i32, i32* %4, align 4, !dbg !3454, !tbaa !805
  %34 = and i32 %33, 255, !dbg !3454
  %35 = shl i32 %34, 24, !dbg !3454
  %36 = or i32 %32, %35, !dbg !3454
  br label %40, !dbg !3454

37:                                               ; preds = %10
  %38 = load i32, i32* %4, align 4, !dbg !3454, !tbaa !805
  %39 = call i32 @_OSSwapInt32(i32 %38) #17, !dbg !3454
  br label %40, !dbg !3454

40:                                               ; preds = %37, %21
  %41 = phi i32 [ %36, %21 ], [ %39, %37 ], !dbg !3454
  %42 = zext i32 %41 to i64, !dbg !3455
  %43 = shl i64 %42, 32, !dbg !3456
  %44 = load i32, i32* %5, align 4, !dbg !3457, !tbaa !805
  %45 = call i1 @llvm.is.constant.i32(i32 %44), !dbg !3457
  br i1 %45, label %46, label %62, !dbg !3457

46:                                               ; preds = %40
  %47 = load i32, i32* %5, align 4, !dbg !3457, !tbaa !805
  %48 = and i32 %47, -16777216, !dbg !3457
  %49 = lshr i32 %48, 24, !dbg !3457
  %50 = load i32, i32* %5, align 4, !dbg !3457, !tbaa !805
  %51 = and i32 %50, 16711680, !dbg !3457
  %52 = lshr i32 %51, 8, !dbg !3457
  %53 = or i32 %49, %52, !dbg !3457
  %54 = load i32, i32* %5, align 4, !dbg !3457, !tbaa !805
  %55 = and i32 %54, 65280, !dbg !3457
  %56 = shl i32 %55, 8, !dbg !3457
  %57 = or i32 %53, %56, !dbg !3457
  %58 = load i32, i32* %5, align 4, !dbg !3457, !tbaa !805
  %59 = and i32 %58, 255, !dbg !3457
  %60 = shl i32 %59, 24, !dbg !3457
  %61 = or i32 %57, %60, !dbg !3457
  br label %65, !dbg !3457

62:                                               ; preds = %40
  %63 = load i32, i32* %5, align 4, !dbg !3457, !tbaa !805
  %64 = call i32 @_OSSwapInt32(i32 %63) #17, !dbg !3457
  br label %65, !dbg !3457

65:                                               ; preds = %62, %46
  %66 = phi i32 [ %61, %46 ], [ %64, %62 ], !dbg !3457
  %67 = zext i32 %66 to i64, !dbg !3457
  %68 = or i64 %43, %67, !dbg !3458
  store i64 %68, i64* %2, align 4, !dbg !3459
  %69 = bitcast i32* %5 to i8*, !dbg !3460
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %69) #19, !dbg !3460
  %70 = bitcast i32* %4 to i8*, !dbg !3460
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %70) #19, !dbg !3460
  br label %71

71:                                               ; preds = %65, %8
  %72 = load i64, i64* %2, align 4, !dbg !3460
  ret i64 %72, !dbg !3460
}

; Function Attrs: nounwind ssp
define i8* @aws_lookup_table_hex_to_num_get() #0 !dbg !3461 {
  ret i8* getelementptr inbounds ([256 x i8], [256 x i8]* @s_hex_to_num_table, i32 0, i32 0), !dbg !3462
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_read_hex_u8(%struct.aws_byte_cursor* %0, i8* %1) #0 !dbg !3463 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  %6 = alloca i8, align 1
  %7 = alloca i8, align 1
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !3467, metadata !DIExpression()), !dbg !3474
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !3468, metadata !DIExpression()), !dbg !3475
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #19, !dbg !3476
  call void @llvm.dbg.declare(metadata i8* %5, metadata !3469, metadata !DIExpression()), !dbg !3477
  store i8 0, i8* %5, align 1, !dbg !3477, !tbaa !844
  %8 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3478, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %8, i32 0, i32 0, !dbg !3478
  %10 = load i32, i32* %9, align 4, !dbg !3478, !tbaa !822
  %11 = icmp uge i32 %10, 2, !dbg !3478
  %12 = xor i1 %11, true, !dbg !3478
  %13 = xor i1 %12, true, !dbg !3478
  %14 = zext i1 %13 to i32, !dbg !3478
  %15 = call i32 @llvm.expect.i32(i32 %14, i32 1), !dbg !3478
  %16 = icmp ne i32 %15, 0, !dbg !3478
  br i1 %16, label %17, label %66, !dbg !3479

17:                                               ; preds = %2
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !3480
  call void @llvm.dbg.declare(metadata i8* %6, metadata !3470, metadata !DIExpression()), !dbg !3481
  %18 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3482, !tbaa !657
  %19 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %18, i32 0, i32 1, !dbg !3483
  %20 = load i8*, i8** %19, align 4, !dbg !3483, !tbaa !832
  %21 = getelementptr inbounds i8, i8* %20, i32 0, !dbg !3482
  %22 = load i8, i8* %21, align 1, !dbg !3482, !tbaa !1034
  %23 = zext i8 %22 to i32, !dbg !3484
  %24 = getelementptr inbounds [256 x i8], [256 x i8]* @s_hex_to_num_table, i32 0, i32 %23, !dbg !3484
  %25 = load i8, i8* %24, align 1, !dbg !3484, !tbaa !1034
  store i8 %25, i8* %6, align 1, !dbg !3481, !tbaa !1034
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %7) #19, !dbg !3485
  call void @llvm.dbg.declare(metadata i8* %7, metadata !3473, metadata !DIExpression()), !dbg !3486
  %26 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3487, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %26, i32 0, i32 1, !dbg !3488
  %28 = load i8*, i8** %27, align 4, !dbg !3488, !tbaa !832
  %29 = getelementptr inbounds i8, i8* %28, i32 1, !dbg !3487
  %30 = load i8, i8* %29, align 1, !dbg !3487, !tbaa !1034
  %31 = zext i8 %30 to i32, !dbg !3489
  %32 = getelementptr inbounds [256 x i8], [256 x i8]* @s_hex_to_num_table, i32 0, i32 %31, !dbg !3489
  %33 = load i8, i8* %32, align 1, !dbg !3489, !tbaa !1034
  store i8 %33, i8* %7, align 1, !dbg !3486, !tbaa !1034
  %34 = load i8, i8* %6, align 1, !dbg !3490, !tbaa !1034
  %35 = zext i8 %34 to i32, !dbg !3490
  %36 = icmp ne i32 %35, 255, !dbg !3490
  br i1 %36, label %37, label %41, !dbg !3490

37:                                               ; preds = %17
  %38 = load i8, i8* %7, align 1, !dbg !3490, !tbaa !1034
  %39 = zext i8 %38 to i32, !dbg !3490
  %40 = icmp ne i32 %39, 255, !dbg !3490
  br label %41

41:                                               ; preds = %37, %17
  %42 = phi i1 [ false, %17 ], [ %40, %37 ], !dbg !3492
  %43 = xor i1 %42, true, !dbg !3490
  %44 = xor i1 %43, true, !dbg !3490
  %45 = zext i1 %44 to i32, !dbg !3490
  %46 = call i32 @llvm.expect.i32(i32 %45, i32 1), !dbg !3490
  %47 = icmp ne i32 %46, 0, !dbg !3490
  br i1 %47, label %48, label %65, !dbg !3493

48:                                               ; preds = %41
  %49 = load i8, i8* %6, align 1, !dbg !3494, !tbaa !1034
  %50 = zext i8 %49 to i32, !dbg !3494
  %51 = shl i32 %50, 4, !dbg !3496
  %52 = load i8, i8* %7, align 1, !dbg !3497, !tbaa !1034
  %53 = zext i8 %52 to i32, !dbg !3497
  %54 = or i32 %51, %53, !dbg !3498
  %55 = trunc i32 %54 to i8, !dbg !3499
  %56 = load i8*, i8** %4, align 4, !dbg !3500, !tbaa !657
  store i8 %55, i8* %56, align 1, !dbg !3501, !tbaa !1034
  %57 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3502, !tbaa !657
  %58 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %57, i32 0, i32 1, !dbg !3503
  %59 = load i8*, i8** %58, align 4, !dbg !3504, !tbaa !832
  %60 = getelementptr inbounds i8, i8* %59, i32 2, !dbg !3504
  store i8* %60, i8** %58, align 4, !dbg !3504, !tbaa !832
  %61 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !3505, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %61, i32 0, i32 0, !dbg !3506
  %63 = load i32, i32* %62, align 4, !dbg !3507, !tbaa !822
  %64 = sub i32 %63, 2, !dbg !3507
  store i32 %64, i32* %62, align 4, !dbg !3507, !tbaa !822
  store i8 1, i8* %5, align 1, !dbg !3508, !tbaa !844
  br label %65, !dbg !3509

65:                                               ; preds = %48, %41
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %7) #19, !dbg !3510
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !3510
  br label %66, !dbg !3511

66:                                               ; preds = %65, %2
  %67 = load i8, i8* %5, align 1, !dbg !3512, !tbaa !844, !range !849
  %68 = trunc i8 %67 to i1, !dbg !3512
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %5) #19, !dbg !3513
  ret i1 %68, !dbg !3514
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_advance(%struct.aws_byte_buf* noalias %0, %struct.aws_byte_buf* noalias %1, i32 %2) #0 !dbg !3515 {
  %4 = alloca i1, align 1
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca %struct.aws_byte_buf*, align 4
  %7 = alloca i32, align 4
  %8 = alloca %struct.aws_byte_buf, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !3520, metadata !DIExpression()), !dbg !3523
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %6, metadata !3521, metadata !DIExpression()), !dbg !3524
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !3522, metadata !DIExpression()), !dbg !3525
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3526, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 2, !dbg !3528
  %11 = load i32, i32* %10, align 4, !dbg !3528, !tbaa !698
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3529, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 0, !dbg !3530
  %14 = load i32, i32* %13, align 4, !dbg !3530, !tbaa !693
  %15 = sub i32 %11, %14, !dbg !3531
  %16 = load i32, i32* %7, align 4, !dbg !3532, !tbaa !663
  %17 = icmp uge i32 %15, %16, !dbg !3533
  br i1 %17, label %18, label %47, !dbg !3534

18:                                               ; preds = %3
  %19 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !3535, !tbaa !657
  %20 = bitcast %struct.aws_byte_buf* %8 to i8*, !dbg !3537
  call void @llvm.lifetime.start.p0i8(i64 16, i8* %20) #19, !dbg !3537
  %21 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3538, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %21, i32 0, i32 1, !dbg !3539
  %23 = load i8*, i8** %22, align 4, !dbg !3539, !tbaa !675
  %24 = icmp eq i8* %23, null, !dbg !3540
  br i1 %24, label %25, label %26, !dbg !3541

25:                                               ; preds = %18
  br label %34, !dbg !3541

26:                                               ; preds = %18
  %27 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3542, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %27, i32 0, i32 1, !dbg !3543
  %29 = load i8*, i8** %28, align 4, !dbg !3543, !tbaa !675
  %30 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3544, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %30, i32 0, i32 0, !dbg !3545
  %32 = load i32, i32* %31, align 4, !dbg !3545, !tbaa !693
  %33 = getelementptr inbounds i8, i8* %29, i32 %32, !dbg !3546
  br label %34, !dbg !3541

34:                                               ; preds = %26, %25
  %35 = phi i8* [ null, %25 ], [ %33, %26 ], !dbg !3541
  %36 = load i32, i32* %7, align 4, !dbg !3547, !tbaa !663
  call void @aws_byte_buf_from_array(%struct.aws_byte_buf* sret(%struct.aws_byte_buf) %8, i8* %35, i32 %36) #17, !dbg !3537
  %37 = bitcast %struct.aws_byte_buf* %19 to i8*, !dbg !3537
  %38 = bitcast %struct.aws_byte_buf* %8 to i8*, !dbg !3537
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %37, i8* align 4 %38, i32 16, i1 false), !dbg !3537, !tbaa.struct !739
  %39 = bitcast %struct.aws_byte_buf* %8 to i8*, !dbg !3537
  call void @llvm.lifetime.end.p0i8(i64 16, i8* %39) #19, !dbg !3537
  %40 = load i32, i32* %7, align 4, !dbg !3548, !tbaa !663
  %41 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3549, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %41, i32 0, i32 0, !dbg !3550
  %43 = load i32, i32* %42, align 4, !dbg !3551, !tbaa !693
  %44 = add i32 %43, %40, !dbg !3551
  store i32 %44, i32* %42, align 4, !dbg !3551, !tbaa !693
  %45 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !3552, !tbaa !657
  %46 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %45, i32 0, i32 0, !dbg !3553
  store i32 0, i32* %46, align 4, !dbg !3554, !tbaa !693
  store i1 true, i1* %4, align 1, !dbg !3555
  br label %56, !dbg !3555

47:                                               ; preds = %3
  br label %48, !dbg !3556

48:                                               ; preds = %47
  %49 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !3558, !tbaa !657
  %50 = bitcast %struct.aws_byte_buf* %49 to i8*, !dbg !3558
  %51 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %6, align 4, !dbg !3558, !tbaa !657
  %52 = bitcast %struct.aws_byte_buf* %51 to i8*, !dbg !3558
  %53 = call i32 @llvm.objectsize.i32.p0i8(i8* %52, i1 false, i1 true, i1 false), !dbg !3558
  %54 = call i8* @__memset_chk(i8* %50, i32 0, i32 16, i32 %53) #18, !dbg !3558
  br label %55, !dbg !3558

55:                                               ; preds = %48
  store i1 false, i1* %4, align 1, !dbg !3560
  br label %56, !dbg !3560

56:                                               ; preds = %55, %34
  %57 = load i1, i1* %4, align 1, !dbg !3561
  ret i1 %57, !dbg !3561
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* noalias %0, i8* noalias %1, i32 %2) #0 !dbg !3562 {
  %4 = alloca i1, align 1
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !3567, metadata !DIExpression()), !dbg !3570
  store i8* %1, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !3568, metadata !DIExpression()), !dbg !3571
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !3569, metadata !DIExpression()), !dbg !3572
  %8 = load i32, i32* %7, align 4, !dbg !3573, !tbaa !663
  %9 = icmp eq i32 %8, 0, !dbg !3575
  br i1 %9, label %10, label %11, !dbg !3576

10:                                               ; preds = %3
  store i1 true, i1* %4, align 1, !dbg !3577
  br label %54, !dbg !3577

11:                                               ; preds = %3
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3579, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 0, !dbg !3581
  %14 = load i32, i32* %13, align 4, !dbg !3581, !tbaa !693
  %15 = icmp ugt i32 %14, 2147483647, !dbg !3582
  br i1 %15, label %29, label %16, !dbg !3583

16:                                               ; preds = %11
  %17 = load i32, i32* %7, align 4, !dbg !3584, !tbaa !663
  %18 = icmp ugt i32 %17, 2147483647, !dbg !3585
  br i1 %18, label %29, label %19, !dbg !3586

19:                                               ; preds = %16
  %20 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3587, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %20, i32 0, i32 0, !dbg !3588
  %22 = load i32, i32* %21, align 4, !dbg !3588, !tbaa !693
  %23 = load i32, i32* %7, align 4, !dbg !3589, !tbaa !663
  %24 = add i32 %22, %23, !dbg !3590
  %25 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3591, !tbaa !657
  %26 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %25, i32 0, i32 2, !dbg !3592
  %27 = load i32, i32* %26, align 4, !dbg !3592, !tbaa !698
  %28 = icmp ugt i32 %24, %27, !dbg !3593
  br i1 %28, label %29, label %30, !dbg !3594

29:                                               ; preds = %19, %16, %11
  store i1 false, i1* %4, align 1, !dbg !3595
  br label %54, !dbg !3595

30:                                               ; preds = %19
  %31 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3597, !tbaa !657
  %32 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %31, i32 0, i32 1, !dbg !3597
  %33 = load i8*, i8** %32, align 4, !dbg !3597, !tbaa !675
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3597, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %34, i32 0, i32 0, !dbg !3597
  %36 = load i32, i32* %35, align 4, !dbg !3597, !tbaa !693
  %37 = getelementptr inbounds i8, i8* %33, i32 %36, !dbg !3597
  %38 = load i8*, i8** %6, align 4, !dbg !3597, !tbaa !657
  %39 = load i32, i32* %7, align 4, !dbg !3597, !tbaa !663
  %40 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3597, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %40, i32 0, i32 1, !dbg !3597
  %42 = load i8*, i8** %41, align 4, !dbg !3597, !tbaa !675
  %43 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3597, !tbaa !657
  %44 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %43, i32 0, i32 0, !dbg !3597
  %45 = load i32, i32* %44, align 4, !dbg !3597, !tbaa !693
  %46 = getelementptr inbounds i8, i8* %42, i32 %45, !dbg !3597
  %47 = call i32 @llvm.objectsize.i32.p0i8(i8* %46, i1 false, i1 true, i1 false), !dbg !3597
  %48 = call i8* @__memcpy_chk(i8* %37, i8* %38, i32 %39, i32 %47) #18, !dbg !3597
  %49 = load i32, i32* %7, align 4, !dbg !3598, !tbaa !663
  %50 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3599, !tbaa !657
  %51 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %50, i32 0, i32 0, !dbg !3600
  %52 = load i32, i32* %51, align 4, !dbg !3601, !tbaa !693
  %53 = add i32 %52, %49, !dbg !3601
  store i32 %53, i32* %51, align 4, !dbg !3601, !tbaa !693
  store i1 true, i1* %4, align 1, !dbg !3602
  br label %54, !dbg !3602

54:                                               ; preds = %30, %29, %10
  %55 = load i1, i1* %4, align 1, !dbg !3603
  ret i1 %55, !dbg !3603
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_from_whole_buffer(%struct.aws_byte_buf* noalias %0, [4 x i32] %1) #0 !dbg !3604 {
  %3 = alloca %struct.aws_byte_buf, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = bitcast %struct.aws_byte_buf* %3 to [4 x i32]*
  store [4 x i32] %1, [4 x i32]* %5, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !3608, metadata !DIExpression()), !dbg !3610
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf* %3, metadata !3609, metadata !DIExpression()), !dbg !3611
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !3612, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %3, i32 0, i32 1, !dbg !3613
  %8 = load i8*, i8** %7, align 4, !dbg !3613, !tbaa !675
  %9 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %3, i32 0, i32 0, !dbg !3614
  %10 = load i32, i32* %9, align 4, !dbg !3614, !tbaa !693
  %11 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %6, i8* %8, i32 %10) #17, !dbg !3615
  ret i1 %11, !dbg !3616
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_from_whole_cursor(%struct.aws_byte_buf* noalias %0, [2 x i32] %1) #0 !dbg !3617 {
  %3 = alloca %struct.aws_byte_cursor, align 4
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = bitcast %struct.aws_byte_cursor* %3 to [2 x i32]*
  store [2 x i32] %1, [2 x i32]* %5, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !3621, metadata !DIExpression()), !dbg !3623
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %3, metadata !3622, metadata !DIExpression()), !dbg !3624
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !3625, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %3, i32 0, i32 1, !dbg !3626
  %8 = load i8*, i8** %7, align 4, !dbg !3626, !tbaa !832
  %9 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %3, i32 0, i32 0, !dbg !3627
  %10 = load i32, i32* %9, align 4, !dbg !3627, !tbaa !822
  %11 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %6, i8* %8, i32 %10) #17, !dbg !3628
  ret i1 %11, !dbg !3629
}

; Function Attrs: nounwind ssp
define void @aws_byte_buf_write_to_capacity(%struct.aws_byte_cursor* noalias sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_buf* %1, %struct.aws_byte_cursor* %2) #0 !dbg !3630 {
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !3634, metadata !DIExpression()), !dbg !3639
  store %struct.aws_byte_cursor* %2, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !3635, metadata !DIExpression()), !dbg !3640
  %8 = bitcast i32* %6 to i8*, !dbg !3641
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %8) #19, !dbg !3641
  call void @llvm.dbg.declare(metadata i32* %6, metadata !3636, metadata !DIExpression()), !dbg !3642
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !3643, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 2, !dbg !3644
  %11 = load i32, i32* %10, align 4, !dbg !3644, !tbaa !698
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !3645, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %12, i32 0, i32 0, !dbg !3646
  %14 = load i32, i32* %13, align 4, !dbg !3646, !tbaa !693
  %15 = sub i32 %11, %14, !dbg !3647
  store i32 %15, i32* %6, align 4, !dbg !3642, !tbaa !663
  %16 = bitcast i32* %7 to i8*, !dbg !3648
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %16) #19, !dbg !3648
  call void @llvm.dbg.declare(metadata i32* %7, metadata !3637, metadata !DIExpression()), !dbg !3649
  %17 = load i32, i32* %6, align 4, !dbg !3650, !tbaa !663
  %18 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !3651, !tbaa !657
  %19 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %18, i32 0, i32 0, !dbg !3652
  %20 = load i32, i32* %19, align 4, !dbg !3652, !tbaa !822
  %21 = call i32 @aws_min_size(i32 %17, i32 %20) #17, !dbg !3653
  store i32 %21, i32* %7, align 4, !dbg !3649, !tbaa !663
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor* %0, metadata !3638, metadata !DIExpression()), !dbg !3654
  %22 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !3655, !tbaa !657
  %23 = load i32, i32* %7, align 4, !dbg !3656, !tbaa !663
  call void @aws_byte_cursor_advance(%struct.aws_byte_cursor* sret(%struct.aws_byte_cursor) %0, %struct.aws_byte_cursor* %22, i32 %23) #17, !dbg !3657
  %24 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !3658, !tbaa !657
  %25 = bitcast %struct.aws_byte_cursor* %0 to [2 x i32]*, !dbg !3659
  %26 = load [2 x i32], [2 x i32]* %25, align 4, !dbg !3659
  %27 = call zeroext i1 @aws_byte_buf_write_from_whole_cursor(%struct.aws_byte_buf* %24, [2 x i32] %26) #17, !dbg !3659
  %28 = bitcast i32* %7 to i8*, !dbg !3660
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %28) #19, !dbg !3660
  %29 = bitcast i32* %6 to i8*, !dbg !3660
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %29) #19, !dbg !3660
  ret void, !dbg !3660
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_min_size(i32 %0, i32 %1) #2 !dbg !3661 {
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  store i32 %0, i32* %3, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %3, metadata !3663, metadata !DIExpression()), !dbg !3665
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !3664, metadata !DIExpression()), !dbg !3666
  %5 = load i32, i32* %3, align 4, !dbg !3667, !tbaa !663
  %6 = load i32, i32* %4, align 4, !dbg !3668, !tbaa !663
  %7 = icmp ult i32 %5, %6, !dbg !3669
  br i1 %7, label %8, label %10, !dbg !3667

8:                                                ; preds = %2
  %9 = load i32, i32* %3, align 4, !dbg !3670, !tbaa !663
  br label %12, !dbg !3667

10:                                               ; preds = %2
  %11 = load i32, i32* %4, align 4, !dbg !3671, !tbaa !663
  br label %12, !dbg !3667

12:                                               ; preds = %10, %8
  %13 = phi i32 [ %9, %8 ], [ %11, %10 ], !dbg !3667
  ret i32 %13, !dbg !3672
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_u8(%struct.aws_byte_buf* noalias %0, i8 zeroext %1) #0 !dbg !3673 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i8, align 1
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !3677, metadata !DIExpression()), !dbg !3679
  store i8 %1, i8* %4, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %4, metadata !3678, metadata !DIExpression()), !dbg !3680
  %5 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !3681, !tbaa !657
  %6 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %5, i8* %4, i32 1) #17, !dbg !3682
  ret i1 %6, !dbg !3683
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_u8_n(%struct.aws_byte_buf* %0, i8 zeroext %1, i32 %2) #0 !dbg !3684 {
  %4 = alloca i1, align 1
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !3688, metadata !DIExpression()), !dbg !3691
  store i8 %1, i8* %6, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %6, metadata !3689, metadata !DIExpression()), !dbg !3692
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !3690, metadata !DIExpression()), !dbg !3693
  %8 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3694, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %8, i32 0, i32 0, !dbg !3696
  %10 = load i32, i32* %9, align 4, !dbg !3696, !tbaa !693
  %11 = icmp ugt i32 %10, 2147483647, !dbg !3697
  br i1 %11, label %25, label %12, !dbg !3698

12:                                               ; preds = %3
  %13 = load i32, i32* %7, align 4, !dbg !3699, !tbaa !663
  %14 = icmp ugt i32 %13, 2147483647, !dbg !3700
  br i1 %14, label %25, label %15, !dbg !3701

15:                                               ; preds = %12
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3702, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %16, i32 0, i32 0, !dbg !3703
  %18 = load i32, i32* %17, align 4, !dbg !3703, !tbaa !693
  %19 = load i32, i32* %7, align 4, !dbg !3704, !tbaa !663
  %20 = add i32 %18, %19, !dbg !3705
  %21 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3706, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %21, i32 0, i32 2, !dbg !3707
  %23 = load i32, i32* %22, align 4, !dbg !3707, !tbaa !698
  %24 = icmp ugt i32 %20, %23, !dbg !3708
  br i1 %24, label %25, label %26, !dbg !3709

25:                                               ; preds = %15, %12, %3
  store i1 false, i1* %4, align 1, !dbg !3710
  br label %51, !dbg !3710

26:                                               ; preds = %15
  %27 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3712, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %27, i32 0, i32 1, !dbg !3712
  %29 = load i8*, i8** %28, align 4, !dbg !3712, !tbaa !675
  %30 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3712, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %30, i32 0, i32 0, !dbg !3712
  %32 = load i32, i32* %31, align 4, !dbg !3712, !tbaa !693
  %33 = getelementptr inbounds i8, i8* %29, i32 %32, !dbg !3712
  %34 = load i8, i8* %6, align 1, !dbg !3712, !tbaa !1034
  %35 = zext i8 %34 to i32, !dbg !3712
  %36 = load i32, i32* %7, align 4, !dbg !3712, !tbaa !663
  %37 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3712, !tbaa !657
  %38 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %37, i32 0, i32 1, !dbg !3712
  %39 = load i8*, i8** %38, align 4, !dbg !3712, !tbaa !675
  %40 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3712, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %40, i32 0, i32 0, !dbg !3712
  %42 = load i32, i32* %41, align 4, !dbg !3712, !tbaa !693
  %43 = getelementptr inbounds i8, i8* %39, i32 %42, !dbg !3712
  %44 = call i32 @llvm.objectsize.i32.p0i8(i8* %43, i1 false, i1 true, i1 false), !dbg !3712
  %45 = call i8* @__memset_chk(i8* %33, i32 %35, i32 %36, i32 %44) #18, !dbg !3712
  %46 = load i32, i32* %7, align 4, !dbg !3713, !tbaa !663
  %47 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !3714, !tbaa !657
  %48 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %47, i32 0, i32 0, !dbg !3715
  %49 = load i32, i32* %48, align 4, !dbg !3716, !tbaa !693
  %50 = add i32 %49, %46, !dbg !3716
  store i32 %50, i32* %48, align 4, !dbg !3716, !tbaa !693
  store i1 true, i1* %4, align 1, !dbg !3717
  br label %51, !dbg !3717

51:                                               ; preds = %26, %25
  %52 = load i1, i1* %4, align 1, !dbg !3718
  ret i1 %52, !dbg !3718
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_be16(%struct.aws_byte_buf* %0, i16 zeroext %1) #0 !dbg !3719 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i16, align 2
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !3723, metadata !DIExpression()), !dbg !3725
  store i16 %1, i16* %4, align 2, !tbaa !3118
  call void @llvm.dbg.declare(metadata i16* %4, metadata !3724, metadata !DIExpression()), !dbg !3726
  %5 = load i16, i16* %4, align 2, !dbg !3727, !tbaa !3118
  %6 = call zeroext i16 @aws_hton16(i16 zeroext %5) #17, !dbg !3728
  store i16 %6, i16* %4, align 2, !dbg !3729, !tbaa !3118
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !3730, !tbaa !657
  %8 = bitcast i16* %4 to i8*, !dbg !3731
  %9 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %7, i8* %8, i32 2) #17, !dbg !3732
  ret i1 %9, !dbg !3733
}

; Function Attrs: inlinehint nounwind ssp
define internal zeroext i16 @aws_hton16(i16 zeroext %0) #2 !dbg !3734 {
  %2 = alloca i16, align 2
  store i16 %0, i16* %2, align 2, !tbaa !3118
  call void @llvm.dbg.declare(metadata i16* %2, metadata !3736, metadata !DIExpression()), !dbg !3737
  %3 = load i16, i16* %2, align 2, !dbg !3738, !tbaa !3118
  %4 = call i1 @llvm.is.constant.i16(i16 %3), !dbg !3738
  br i1 %4, label %5, label %17, !dbg !3738

5:                                                ; preds = %1
  %6 = load i16, i16* %2, align 2, !dbg !3738, !tbaa !3118
  %7 = zext i16 %6 to i32, !dbg !3738
  %8 = and i32 %7, 65280, !dbg !3738
  %9 = lshr i32 %8, 8, !dbg !3738
  %10 = load i16, i16* %2, align 2, !dbg !3738, !tbaa !3118
  %11 = zext i16 %10 to i32, !dbg !3738
  %12 = and i32 %11, 255, !dbg !3738
  %13 = shl i32 %12, 8, !dbg !3738
  %14 = or i32 %9, %13, !dbg !3738
  %15 = trunc i32 %14 to i16, !dbg !3738
  %16 = zext i16 %15 to i32, !dbg !3738
  br label %21, !dbg !3738

17:                                               ; preds = %1
  %18 = load i16, i16* %2, align 2, !dbg !3738, !tbaa !3118
  %19 = call zeroext i16 @_OSSwapInt16(i16 zeroext %18) #17, !dbg !3738
  %20 = zext i16 %19 to i32, !dbg !3738
  br label %21, !dbg !3738

21:                                               ; preds = %17, %5
  %22 = phi i32 [ %16, %5 ], [ %20, %17 ], !dbg !3738
  %23 = trunc i32 %22 to i16, !dbg !3738
  ret i16 %23, !dbg !3739
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_be24(%struct.aws_byte_buf* %0, i32 %1) #0 !dbg !3740 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !3744, metadata !DIExpression()), !dbg !3748
  store i32 %1, i32* %5, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %5, metadata !3745, metadata !DIExpression()), !dbg !3749
  %8 = load i32, i32* %5, align 4, !dbg !3750, !tbaa !805
  %9 = icmp ugt i32 %8, 16777215, !dbg !3752
  br i1 %9, label %10, label %11, !dbg !3753

10:                                               ; preds = %2
  store i1 false, i1* %3, align 1, !dbg !3754
  br label %23, !dbg !3754

11:                                               ; preds = %2
  %12 = bitcast i32* %6 to i8*, !dbg !3756
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !3756
  call void @llvm.dbg.declare(metadata i32* %6, metadata !3746, metadata !DIExpression()), !dbg !3757
  %13 = load i32, i32* %5, align 4, !dbg !3758, !tbaa !805
  %14 = call i32 @aws_hton32(i32 %13) #17, !dbg !3759
  store i32 %14, i32* %6, align 4, !dbg !3757, !tbaa !805
  %15 = bitcast i8** %7 to i8*, !dbg !3760
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !3760
  call void @llvm.dbg.declare(metadata i8** %7, metadata !3747, metadata !DIExpression()), !dbg !3761
  %16 = bitcast i32* %6 to i8*, !dbg !3762
  store i8* %16, i8** %7, align 4, !dbg !3761, !tbaa !657
  %17 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !3763, !tbaa !657
  %18 = load i8*, i8** %7, align 4, !dbg !3764, !tbaa !657
  %19 = getelementptr inbounds i8, i8* %18, i32 1, !dbg !3764
  %20 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %17, i8* %19, i32 3) #17, !dbg !3765
  store i1 %20, i1* %3, align 1, !dbg !3766
  %21 = bitcast i8** %7 to i8*, !dbg !3767
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %21) #19, !dbg !3767
  %22 = bitcast i32* %6 to i8*, !dbg !3767
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %22) #19, !dbg !3767
  br label %23

23:                                               ; preds = %11, %10
  %24 = load i1, i1* %3, align 1, !dbg !3767
  ret i1 %24, !dbg !3767
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_hton32(i32 %0) #2 !dbg !3768 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %2, metadata !3770, metadata !DIExpression()), !dbg !3771
  %3 = load i32, i32* %2, align 4, !dbg !3772, !tbaa !805
  %4 = call i1 @llvm.is.constant.i32(i32 %3), !dbg !3772
  br i1 %4, label %5, label %21, !dbg !3772

5:                                                ; preds = %1
  %6 = load i32, i32* %2, align 4, !dbg !3772, !tbaa !805
  %7 = and i32 %6, -16777216, !dbg !3772
  %8 = lshr i32 %7, 24, !dbg !3772
  %9 = load i32, i32* %2, align 4, !dbg !3772, !tbaa !805
  %10 = and i32 %9, 16711680, !dbg !3772
  %11 = lshr i32 %10, 8, !dbg !3772
  %12 = or i32 %8, %11, !dbg !3772
  %13 = load i32, i32* %2, align 4, !dbg !3772, !tbaa !805
  %14 = and i32 %13, 65280, !dbg !3772
  %15 = shl i32 %14, 8, !dbg !3772
  %16 = or i32 %12, %15, !dbg !3772
  %17 = load i32, i32* %2, align 4, !dbg !3772, !tbaa !805
  %18 = and i32 %17, 255, !dbg !3772
  %19 = shl i32 %18, 24, !dbg !3772
  %20 = or i32 %16, %19, !dbg !3772
  br label %24, !dbg !3772

21:                                               ; preds = %1
  %22 = load i32, i32* %2, align 4, !dbg !3772, !tbaa !805
  %23 = call i32 @_OSSwapInt32(i32 %22) #17, !dbg !3772
  br label %24, !dbg !3772

24:                                               ; preds = %21, %5
  %25 = phi i32 [ %20, %5 ], [ %23, %21 ], !dbg !3772
  ret i32 %25, !dbg !3773
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_be32(%struct.aws_byte_buf* %0, i32 %1) #0 !dbg !3774 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !3776, metadata !DIExpression()), !dbg !3778
  store i32 %1, i32* %4, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %4, metadata !3777, metadata !DIExpression()), !dbg !3779
  %5 = load i32, i32* %4, align 4, !dbg !3780, !tbaa !805
  %6 = call i32 @aws_hton32(i32 %5) #17, !dbg !3781
  store i32 %6, i32* %4, align 4, !dbg !3782, !tbaa !805
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !3783, !tbaa !657
  %8 = bitcast i32* %4 to i8*, !dbg !3784
  %9 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %7, i8* %8, i32 4) #17, !dbg !3785
  ret i1 %9, !dbg !3786
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_float_be32(%struct.aws_byte_buf* %0, float %1) #0 !dbg !3787 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca float, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !3791, metadata !DIExpression()), !dbg !3793
  store float %1, float* %4, align 4, !tbaa !3246
  call void @llvm.dbg.declare(metadata float* %4, metadata !3792, metadata !DIExpression()), !dbg !3794
  %5 = load float, float* %4, align 4, !dbg !3795, !tbaa !3246
  %6 = call float @aws_htonf32(float %5) #17, !dbg !3796
  store float %6, float* %4, align 4, !dbg !3797, !tbaa !3246
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !3798, !tbaa !657
  %8 = bitcast float* %4 to i8*, !dbg !3799
  %9 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %7, i8* %8, i32 4) #17, !dbg !3800
  ret i1 %9, !dbg !3801
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_be64(%struct.aws_byte_buf* %0, i64 %1) #0 !dbg !3802 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i64, align 8
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !3806, metadata !DIExpression()), !dbg !3808
  store i64 %1, i64* %4, align 8, !tbaa !1986
  call void @llvm.dbg.declare(metadata i64* %4, metadata !3807, metadata !DIExpression()), !dbg !3809
  %5 = load i64, i64* %4, align 8, !dbg !3810, !tbaa !1986
  %6 = call i64 @aws_hton64(i64 %5) #17, !dbg !3811
  store i64 %6, i64* %4, align 8, !dbg !3812, !tbaa !1986
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !3813, !tbaa !657
  %8 = bitcast i64* %4 to i8*, !dbg !3814
  %9 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %7, i8* %8, i32 8) #17, !dbg !3815
  ret i1 %9, !dbg !3816
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_write_float_be64(%struct.aws_byte_buf* %0, double %1) #0 !dbg !3817 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca double, align 8
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !3821, metadata !DIExpression()), !dbg !3823
  store double %1, double* %4, align 8, !tbaa !3330
  call void @llvm.dbg.declare(metadata double* %4, metadata !3822, metadata !DIExpression()), !dbg !3824
  %5 = load double, double* %4, align 8, !dbg !3825, !tbaa !3330
  %6 = call double @aws_htonf64(double %5) #17, !dbg !3826
  store double %6, double* %4, align 8, !dbg !3827, !tbaa !3330
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !3828, !tbaa !657
  %8 = bitcast double* %4 to i8*, !dbg !3829
  %9 = call zeroext i1 @aws_byte_buf_write(%struct.aws_byte_buf* %7, i8* %8, i32 8) #17, !dbg !3830
  ret i1 %9, !dbg !3831
}

; Function Attrs: nounwind ssp
define i32 @aws_byte_buf_append_null_terminator(%struct.aws_byte_buf* %0) #0 !dbg !3832 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !3836, metadata !DIExpression()), !dbg !3837
  %3 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !3838, !tbaa !657
  %4 = call i32 @aws_byte_buf_append_dynamic(%struct.aws_byte_buf* %3, %struct.aws_byte_cursor* @s_null_terminator_cursor) #17, !dbg !3839
  ret i32 %4, !dbg !3840
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_isalnum(i8 zeroext %0) #0 !dbg !3841 {
  %2 = alloca i8, align 1
  store i8 %0, i8* %2, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %2, metadata !3843, metadata !DIExpression()), !dbg !3844
  %3 = load i8, i8* %2, align 1, !dbg !3845, !tbaa !1034
  %4 = zext i8 %3 to i32, !dbg !3845
  %5 = icmp sge i32 %4, 97, !dbg !3846
  br i1 %5, label %6, label %10, !dbg !3847

6:                                                ; preds = %1
  %7 = load i8, i8* %2, align 1, !dbg !3848, !tbaa !1034
  %8 = zext i8 %7 to i32, !dbg !3848
  %9 = icmp sle i32 %8, 122, !dbg !3849
  br i1 %9, label %28, label %10, !dbg !3850

10:                                               ; preds = %6, %1
  %11 = load i8, i8* %2, align 1, !dbg !3851, !tbaa !1034
  %12 = zext i8 %11 to i32, !dbg !3851
  %13 = icmp sge i32 %12, 65, !dbg !3852
  br i1 %13, label %14, label %18, !dbg !3853

14:                                               ; preds = %10
  %15 = load i8, i8* %2, align 1, !dbg !3854, !tbaa !1034
  %16 = zext i8 %15 to i32, !dbg !3854
  %17 = icmp sle i32 %16, 90, !dbg !3855
  br i1 %17, label %28, label %18, !dbg !3856

18:                                               ; preds = %14, %10
  %19 = load i8, i8* %2, align 1, !dbg !3857, !tbaa !1034
  %20 = zext i8 %19 to i32, !dbg !3857
  %21 = icmp sge i32 %20, 48, !dbg !3858
  br i1 %21, label %22, label %26, !dbg !3859

22:                                               ; preds = %18
  %23 = load i8, i8* %2, align 1, !dbg !3860, !tbaa !1034
  %24 = zext i8 %23 to i32, !dbg !3860
  %25 = icmp sle i32 %24, 57, !dbg !3861
  br label %26

26:                                               ; preds = %22, %18
  %27 = phi i1 [ false, %18 ], [ %25, %22 ], !dbg !3862
  br label %28, !dbg !3856

28:                                               ; preds = %26, %14, %6
  %29 = phi i1 [ true, %14 ], [ true, %6 ], [ %27, %26 ]
  ret i1 %29, !dbg !3863
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_isalpha(i8 zeroext %0) #0 !dbg !3864 {
  %2 = alloca i8, align 1
  store i8 %0, i8* %2, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %2, metadata !3866, metadata !DIExpression()), !dbg !3867
  %3 = load i8, i8* %2, align 1, !dbg !3868, !tbaa !1034
  %4 = zext i8 %3 to i32, !dbg !3868
  %5 = icmp sge i32 %4, 97, !dbg !3869
  br i1 %5, label %6, label %10, !dbg !3870

6:                                                ; preds = %1
  %7 = load i8, i8* %2, align 1, !dbg !3871, !tbaa !1034
  %8 = zext i8 %7 to i32, !dbg !3871
  %9 = icmp sle i32 %8, 122, !dbg !3872
  br i1 %9, label %20, label %10, !dbg !3873

10:                                               ; preds = %6, %1
  %11 = load i8, i8* %2, align 1, !dbg !3874, !tbaa !1034
  %12 = zext i8 %11 to i32, !dbg !3874
  %13 = icmp sge i32 %12, 65, !dbg !3875
  br i1 %13, label %14, label %18, !dbg !3876

14:                                               ; preds = %10
  %15 = load i8, i8* %2, align 1, !dbg !3877, !tbaa !1034
  %16 = zext i8 %15 to i32, !dbg !3877
  %17 = icmp sle i32 %16, 90, !dbg !3878
  br label %18

18:                                               ; preds = %14, %10
  %19 = phi i1 [ false, %10 ], [ %17, %14 ], !dbg !3879
  br label %20, !dbg !3873

20:                                               ; preds = %18, %6
  %21 = phi i1 [ true, %6 ], [ %19, %18 ]
  ret i1 %21, !dbg !3880
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_isdigit(i8 zeroext %0) #0 !dbg !3881 {
  %2 = alloca i8, align 1
  store i8 %0, i8* %2, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %2, metadata !3883, metadata !DIExpression()), !dbg !3884
  %3 = load i8, i8* %2, align 1, !dbg !3885, !tbaa !1034
  %4 = zext i8 %3 to i32, !dbg !3885
  %5 = icmp sge i32 %4, 48, !dbg !3886
  br i1 %5, label %6, label %10, !dbg !3887

6:                                                ; preds = %1
  %7 = load i8, i8* %2, align 1, !dbg !3888, !tbaa !1034
  %8 = zext i8 %7 to i32, !dbg !3888
  %9 = icmp sle i32 %8, 57, !dbg !3889
  br label %10

10:                                               ; preds = %6, %1
  %11 = phi i1 [ false, %1 ], [ %9, %6 ], !dbg !3890
  ret i1 %11, !dbg !3891
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_isxdigit(i8 zeroext %0) #0 !dbg !3892 {
  %2 = alloca i8, align 1
  store i8 %0, i8* %2, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %2, metadata !3894, metadata !DIExpression()), !dbg !3895
  %3 = load i8, i8* %2, align 1, !dbg !3896, !tbaa !1034
  %4 = zext i8 %3 to i32, !dbg !3896
  %5 = icmp sge i32 %4, 48, !dbg !3897
  br i1 %5, label %6, label %10, !dbg !3898

6:                                                ; preds = %1
  %7 = load i8, i8* %2, align 1, !dbg !3899, !tbaa !1034
  %8 = zext i8 %7 to i32, !dbg !3899
  %9 = icmp sle i32 %8, 57, !dbg !3900
  br i1 %9, label %28, label %10, !dbg !3901

10:                                               ; preds = %6, %1
  %11 = load i8, i8* %2, align 1, !dbg !3902, !tbaa !1034
  %12 = zext i8 %11 to i32, !dbg !3902
  %13 = icmp sge i32 %12, 97, !dbg !3903
  br i1 %13, label %14, label %18, !dbg !3904

14:                                               ; preds = %10
  %15 = load i8, i8* %2, align 1, !dbg !3905, !tbaa !1034
  %16 = zext i8 %15 to i32, !dbg !3905
  %17 = icmp sle i32 %16, 102, !dbg !3906
  br i1 %17, label %28, label %18, !dbg !3907

18:                                               ; preds = %14, %10
  %19 = load i8, i8* %2, align 1, !dbg !3908, !tbaa !1034
  %20 = zext i8 %19 to i32, !dbg !3908
  %21 = icmp sge i32 %20, 65, !dbg !3909
  br i1 %21, label %22, label %26, !dbg !3910

22:                                               ; preds = %18
  %23 = load i8, i8* %2, align 1, !dbg !3911, !tbaa !1034
  %24 = zext i8 %23 to i32, !dbg !3911
  %25 = icmp sle i32 %24, 70, !dbg !3912
  br label %26

26:                                               ; preds = %22, %18
  %27 = phi i1 [ false, %18 ], [ %25, %22 ], !dbg !3913
  br label %28, !dbg !3907

28:                                               ; preds = %26, %14, %6
  %29 = phi i1 [ true, %14 ], [ true, %6 ], [ %27, %26 ]
  ret i1 %29, !dbg !3914
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_isspace(i8 zeroext %0) #0 !dbg !3915 {
  %2 = alloca i1, align 1
  %3 = alloca i8, align 1
  store i8 %0, i8* %3, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %3, metadata !3917, metadata !DIExpression()), !dbg !3918
  %4 = load i8, i8* %3, align 1, !dbg !3919, !tbaa !1034
  %5 = zext i8 %4 to i32, !dbg !3919
  switch i32 %5, label %7 [
    i32 32, label %6
    i32 9, label %6
    i32 10, label %6
    i32 11, label %6
    i32 12, label %6
    i32 13, label %6
  ], !dbg !3920

6:                                                ; preds = %1, %1, %1, %1, %1, %1
  store i1 true, i1* %2, align 1, !dbg !3921
  br label %8, !dbg !3921

7:                                                ; preds = %1
  store i1 false, i1* %2, align 1, !dbg !3923
  br label %8, !dbg !3923

8:                                                ; preds = %7, %6
  %9 = load i1, i1* %2, align 1, !dbg !3924
  ret i1 %9, !dbg !3924
}

; Function Attrs: nounwind ssp
define i32 @main() #0 !dbg !3925 {
  %1 = alloca i32, align 4
  %2 = alloca i32, align 4
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i8*, align 4
  %6 = alloca %struct.store_byte_from_buffer, align 4
  %7 = alloca %struct.store_byte_from_buffer, align 4
  store i32 0, i32* %1, align 4
  %8 = bitcast i32* %2 to i8*, !dbg !3934
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %8) #19, !dbg !3934
  call void @llvm.dbg.declare(metadata i32* %2, metadata !3928, metadata !DIExpression()), !dbg !3935
  %9 = call i32 @nd_size_t() #21, !dbg !3936
  store i32 %9, i32* %2, align 4, !dbg !3935, !tbaa !663
  %10 = load i32, i32* %2, align 4, !dbg !3937, !tbaa !663
  %11 = icmp ule i32 %10, 10, !dbg !3938
  call void @__SEA_assume(i1 zeroext %11) #17, !dbg !3939
  %12 = bitcast i8** %3 to i8*, !dbg !3940
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !3940
  call void @llvm.dbg.declare(metadata i8** %3, metadata !3929, metadata !DIExpression()), !dbg !3941
  %13 = call i8* @can_fail_malloc(i32 10) #17, !dbg !3942
  store i8* %13, i8** %3, align 4, !dbg !3941, !tbaa !657
  %14 = bitcast i32* %4 to i8*, !dbg !3943
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !3943
  call void @llvm.dbg.declare(metadata i32* %4, metadata !3930, metadata !DIExpression()), !dbg !3944
  store i32 0, i32* %4, align 4, !dbg !3944, !tbaa !663
  %15 = bitcast i8** %5 to i8*, !dbg !3945
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !3945
  call void @llvm.dbg.declare(metadata i8** %5, metadata !3931, metadata !DIExpression()), !dbg !3946
  %16 = call i8* @ensure_c_str_is_nd_allocated_safe(i32 10, i32* %4) #17, !dbg !3947
  store i8* %16, i8** %5, align 4, !dbg !3946, !tbaa !657
  %17 = bitcast %struct.store_byte_from_buffer* %6 to i8*, !dbg !3948
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %17) #19, !dbg !3948
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer* %6, metadata !3932, metadata !DIExpression()), !dbg !3949
  %18 = load i8*, i8** %3, align 4, !dbg !3950, !tbaa !657
  %19 = load i32, i32* %2, align 4, !dbg !3951, !tbaa !663
  call void @save_byte_from_array(i8* %18, i32 %19, %struct.store_byte_from_buffer* %6) #17, !dbg !3952
  %20 = bitcast %struct.store_byte_from_buffer* %7 to i8*, !dbg !3953
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %20) #19, !dbg !3953
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer* %7, metadata !3933, metadata !DIExpression()), !dbg !3954
  %21 = load i8*, i8** %5, align 4, !dbg !3955, !tbaa !657
  %22 = load i32, i32* %4, align 4, !dbg !3956, !tbaa !663
  call void @save_byte_from_array(i8* %21, i32 %22, %struct.store_byte_from_buffer* %7) #17, !dbg !3957
  %23 = load i8*, i8** %3, align 4, !dbg !3958, !tbaa !657
  %24 = icmp ne i8* %23, null, !dbg !3958
  br i1 %24, label %28, label %25, !dbg !3959

25:                                               ; preds = %0
  %26 = load i32, i32* %2, align 4, !dbg !3960, !tbaa !663
  %27 = icmp eq i32 %26, 0, !dbg !3961
  br label %28, !dbg !3959

28:                                               ; preds = %25, %0
  %29 = phi i1 [ true, %0 ], [ %27, %25 ]
  call void @__SEA_assume(i1 zeroext %29) #17, !dbg !3962
  %30 = load i8*, i8** %5, align 4, !dbg !3963, !tbaa !657
  %31 = icmp ne i8* %30, null, !dbg !3963
  call void @__SEA_assume(i1 zeroext %31) #17, !dbg !3964
  %32 = load i8*, i8** %3, align 4, !dbg !3965, !tbaa !657
  %33 = load i32, i32* %2, align 4, !dbg !3967, !tbaa !663
  %34 = load i8*, i8** %5, align 4, !dbg !3968, !tbaa !657
  %35 = call zeroext i1 @aws_array_eq_c_str_ignore_case(i8* %32, i32 %33, i8* %34) #17, !dbg !3969
  br i1 %35, label %36, label %47, !dbg !3970

36:                                               ; preds = %28
  %37 = load i32, i32* %2, align 4, !dbg !3971, !tbaa !663
  %38 = load i32, i32* %4, align 4, !dbg !3971, !tbaa !663
  %39 = icmp eq i32 %37, %38, !dbg !3971
  call void @__VERIFIER_assert(i1 zeroext %39) #17, !dbg !3971
  %40 = load i32, i32* %2, align 4, !dbg !3971, !tbaa !663
  %41 = load i32, i32* %4, align 4, !dbg !3971, !tbaa !663
  %42 = icmp eq i32 %40, %41, !dbg !3971
  br i1 %42, label %44, label %43, !dbg !3971

43:                                               ; preds = %36
  call void @__VERIFIER_error() #17, !dbg !3971
  br label %44, !dbg !3971

44:                                               ; preds = %43, %36
  %45 = phi i1 [ true, %36 ], [ false, %43 ]
  %46 = zext i1 %45 to i32, !dbg !3971
  br label %47, !dbg !3973

47:                                               ; preds = %44, %28
  %48 = load i32, i32* %2, align 4, !dbg !3974, !tbaa !663
  %49 = icmp ugt i32 %48, 0, !dbg !3976
  br i1 %49, label %50, label %52, !dbg !3977

50:                                               ; preds = %47
  %51 = load i8*, i8** %3, align 4, !dbg !3978, !tbaa !657
  call void @assert_byte_from_buffer_matches(i8* %51, %struct.store_byte_from_buffer* %6) #17, !dbg !3980
  br label %52, !dbg !3981

52:                                               ; preds = %50, %47
  %53 = load i32, i32* %4, align 4, !dbg !3982, !tbaa !663
  %54 = icmp ugt i32 %53, 0, !dbg !3984
  br i1 %54, label %55, label %57, !dbg !3985

55:                                               ; preds = %52
  %56 = load i8*, i8** %5, align 4, !dbg !3986, !tbaa !657
  call void @assert_byte_from_buffer_matches(i8* %56, %struct.store_byte_from_buffer* %7) #17, !dbg !3988
  br label %57, !dbg !3989

57:                                               ; preds = %55, %52
  %58 = bitcast %struct.store_byte_from_buffer* %7 to i8*, !dbg !3990
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %58) #19, !dbg !3990
  %59 = bitcast %struct.store_byte_from_buffer* %6 to i8*, !dbg !3990
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %59) #19, !dbg !3990
  %60 = bitcast i8** %5 to i8*, !dbg !3990
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %60) #19, !dbg !3990
  %61 = bitcast i32* %4 to i8*, !dbg !3990
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %61) #19, !dbg !3990
  %62 = bitcast i8** %3 to i8*, !dbg !3990
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %62) #19, !dbg !3990
  %63 = bitcast i32* %2 to i8*, !dbg !3990
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %63) #19, !dbg !3990
  ret i32 0, !dbg !3991
}

; Function Attrs: argmemonly nounwind
declare !dbg !249 i32 @nd_size_t() #11

declare void @__SEA_assume(i1 zeroext) #4

declare void @__VERIFIER_assert(i1 zeroext) #4

declare void @__VERIFIER_error() #4

; Function Attrs: nounwind ssp
define void @initialize_array_list(%struct.aws_array_list* %0) #0 !dbg !3992 {
  %2 = alloca %struct.aws_array_list*, align 4
  store %struct.aws_array_list* %0, %struct.aws_array_list** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %2, metadata !4006, metadata !DIExpression()), !dbg !4007
  %3 = call i32 @nd_size_t() #21, !dbg !4008
  %4 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4009, !tbaa !657
  %5 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %4, i32 0, i32 1, !dbg !4010
  store i32 %3, i32* %5, align 4, !dbg !4011, !tbaa !4012
  %6 = call i32 @nd_size_t() #21, !dbg !4013
  %7 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4014, !tbaa !657
  %8 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %7, i32 0, i32 2, !dbg !4015
  store i32 %6, i32* %8, align 4, !dbg !4016, !tbaa !1650
  %9 = call i32 @nd_size_t() #21, !dbg !4017
  %10 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4018, !tbaa !657
  %11 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %10, i32 0, i32 3, !dbg !4019
  store i32 %9, i32* %11, align 4, !dbg !4020, !tbaa !1685
  %12 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4021, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %12, i32 0, i32 1, !dbg !4022
  %14 = load i32, i32* %13, align 4, !dbg !4022, !tbaa !4012
  %15 = call i8* @can_fail_malloc(i32 %14) #17, !dbg !4023
  %16 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4024, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %16, i32 0, i32 4, !dbg !4025
  store i8* %15, i8** %17, align 4, !dbg !4026, !tbaa !1651
  %18 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !4027
  %19 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4028, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %19, i32 0, i32 0, !dbg !4029
  store %struct.aws_allocator* %18, %struct.aws_allocator** %20, align 4, !dbg !4030, !tbaa !1629
  ret void, !dbg !4031
}

; Function Attrs: nounwind ssp
define i8* @can_fail_malloc(i32 %0) #0 !dbg !4032 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !4036, metadata !DIExpression()), !dbg !4037
  %3 = load i32, i32* %2, align 4, !dbg !4038, !tbaa !663
  %4 = icmp uge i32 %3, 1, !dbg !4039
  %5 = zext i1 %4 to i32, !dbg !4039
  call void @__VERIFIER_assume(i32 %5) #17, !dbg !4040
  %6 = load i32, i32* %2, align 4, !dbg !4041, !tbaa !663
  %7 = icmp eq i32 %6, 0, !dbg !4042
  br i1 %7, label %8, label %9, !dbg !4041

8:                                                ; preds = %1
  br label %12, !dbg !4041

9:                                                ; preds = %1
  %10 = load i32, i32* %2, align 4, !dbg !4043, !tbaa !663
  %11 = call i8* @sea_malloc_havoc(i32 %10) #17, !dbg !4044
  br label %12, !dbg !4041

12:                                               ; preds = %9, %8
  %13 = phi i8* [ null, %8 ], [ %11, %9 ], !dbg !4041
  ret i8* %13, !dbg !4045
}

; Function Attrs: nounwind ssp
define %struct.aws_allocator* @sea_allocator() #0 !dbg !4046 {
  ret %struct.aws_allocator* @s_allocator_static, !dbg !4049
}

; Function Attrs: nounwind ssp
define internal i8* @s_malloc_allocator(%struct.aws_allocator* %0, i32 %1) #0 !dbg !4050 {
  %3 = alloca %struct.aws_allocator*, align 4
  %4 = alloca i32, align 4
  store %struct.aws_allocator* %0, %struct.aws_allocator** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator** %3, metadata !4052, metadata !DIExpression()), !dbg !4054
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !4053, metadata !DIExpression()), !dbg !4055
  %5 = load %struct.aws_allocator*, %struct.aws_allocator** %3, align 4, !dbg !4056, !tbaa !657
  %6 = load i32, i32* %4, align 4, !dbg !4057, !tbaa !663
  %7 = call i8* @bounded_malloc(i32 %6) #17, !dbg !4058
  ret i8* %7, !dbg !4059
}

; Function Attrs: nounwind ssp
define internal void @s_free_allocator(%struct.aws_allocator* %0, i8* %1) #0 !dbg !4060 {
  %3 = alloca %struct.aws_allocator*, align 4
  %4 = alloca i8*, align 4
  store %struct.aws_allocator* %0, %struct.aws_allocator** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator** %3, metadata !4062, metadata !DIExpression()), !dbg !4064
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !4063, metadata !DIExpression()), !dbg !4065
  %5 = load %struct.aws_allocator*, %struct.aws_allocator** %3, align 4, !dbg !4066, !tbaa !657
  %6 = load i8*, i8** %4, align 4, !dbg !4067, !tbaa !657
  call void @free(i8* %6) #17, !dbg !4068
  ret void, !dbg !4069
}

declare !dbg !214 void @free(i8*) #4

; Function Attrs: nounwind ssp
define i8* @bounded_malloc(i32 %0) #0 !dbg !4070 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !4072, metadata !DIExpression()), !dbg !4073
  %3 = load i32, i32* %2, align 4, !dbg !4074, !tbaa !663
  %4 = icmp uge i32 %3, 1, !dbg !4075
  %5 = zext i1 %4 to i32, !dbg !4075
  call void @__VERIFIER_assume(i32 %5) #17, !dbg !4076
  %6 = load i32, i32* %2, align 4, !dbg !4077, !tbaa !663
  %7 = icmp eq i32 %6, 0, !dbg !4078
  br i1 %7, label %8, label %9, !dbg !4077

8:                                                ; preds = %1
  br label %12, !dbg !4077

9:                                                ; preds = %1
  %10 = load i32, i32* %2, align 4, !dbg !4079, !tbaa !663
  %11 = call i8* @sea_malloc_havoc_safe(i32 %10) #17, !dbg !4080
  br label %12, !dbg !4077

12:                                               ; preds = %9, %8
  %13 = phi i8* [ null, %8 ], [ %11, %9 ], !dbg !4077
  ret i8* %13, !dbg !4081
}

declare void @__VERIFIER_assume(i32) #4

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc_havoc_safe(i32 %0) #12 !dbg !4082 {
  %2 = alloca i32, align 4
  %3 = alloca i8*, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !4084, metadata !DIExpression()), !dbg !4086
  %4 = bitcast i8** %3 to i8*, !dbg !4087
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !4087
  call void @llvm.dbg.declare(metadata i8** %3, metadata !4085, metadata !DIExpression()), !dbg !4088
  %5 = load i32, i32* %2, align 4, !dbg !4089, !tbaa !663
  %6 = call i8* @sea_malloc_havoc(i32 %5) #17, !dbg !4090
  store i8* %6, i8** %3, align 4, !dbg !4088, !tbaa !657
  %7 = load i8*, i8** %3, align 4, !dbg !4091, !tbaa !657
  %8 = icmp ne i8* %7, null, !dbg !4091
  call void @__SEA_assume(i1 zeroext %8) #17, !dbg !4092
  %9 = load i8*, i8** %3, align 4, !dbg !4093, !tbaa !657
  %10 = bitcast i8** %3 to i8*, !dbg !4094
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #19, !dbg !4094
  ret i8* %9, !dbg !4095
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc_havoc(i32 %0) #12 !dbg !4096 {
  %2 = alloca i32, align 4
  %3 = alloca i8*, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !4098, metadata !DIExpression()), !dbg !4100
  %4 = bitcast i8** %3 to i8*, !dbg !4101
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !4101
  call void @llvm.dbg.declare(metadata i8** %3, metadata !4099, metadata !DIExpression()), !dbg !4102
  %5 = load i32, i32* %2, align 4, !dbg !4103, !tbaa !663
  %6 = call i8* @sea_malloc(i32 %5) #17, !dbg !4104
  store i8* %6, i8** %3, align 4, !dbg !4102, !tbaa !657
  %7 = load i8*, i8** %3, align 4, !dbg !4105, !tbaa !657
  %8 = load i32, i32* %2, align 4, !dbg !4106, !tbaa !663
  call void @memhavoc(i8* %7, i32 %8) #21, !dbg !4107
  %9 = load i8*, i8** %3, align 4, !dbg !4108, !tbaa !657
  %10 = bitcast i8** %3 to i8*, !dbg !4109
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #19, !dbg !4109
  ret i8* %9, !dbg !4110
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc(i32 %0) #12 !dbg !4111 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !4113, metadata !DIExpression()), !dbg !4114
  %3 = call zeroext i1 @nd_malloc_is_fail() #21, !dbg !4115
  br i1 %3, label %4, label %5, !dbg !4115

4:                                                ; preds = %1
  br label %8, !dbg !4115

5:                                                ; preds = %1
  %6 = load i32, i32* %2, align 4, !dbg !4116, !tbaa !663
  %7 = call i8* @malloc(i32 %6) #22, !dbg !4117
  br label %8, !dbg !4115

8:                                                ; preds = %5, %4
  %9 = phi i8* [ null, %4 ], [ %7, %5 ], !dbg !4115
  ret i8* %9, !dbg !4118
}

; Function Attrs: argmemonly nounwind
declare !dbg !596 void @memhavoc(i8*, i32) #11

; Function Attrs: argmemonly nounwind
declare !dbg !595 zeroext i1 @nd_malloc_is_fail() #11

; Function Attrs: allocsize(0)
declare i8* @malloc(i32) #13

; Function Attrs: nounwind ssp
define void @initialize_bounded_array_list(%struct.aws_array_list* %0) #0 !dbg !4119 {
  %2 = alloca %struct.aws_array_list*, align 4
  store %struct.aws_array_list* %0, %struct.aws_array_list** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %2, metadata !4121, metadata !DIExpression()), !dbg !4122
  %3 = call i32 @nd_size_t() #21, !dbg !4123
  %4 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4124, !tbaa !657
  %5 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %4, i32 0, i32 1, !dbg !4125
  store i32 %3, i32* %5, align 4, !dbg !4126, !tbaa !4012
  %6 = call i32 @nd_size_t() #21, !dbg !4127
  %7 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4128, !tbaa !657
  %8 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %7, i32 0, i32 3, !dbg !4129
  store i32 %6, i32* %8, align 4, !dbg !4130, !tbaa !1685
  %9 = call i32 @nd_size_t() #21, !dbg !4131
  %10 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4132, !tbaa !657
  %11 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %10, i32 0, i32 2, !dbg !4133
  store i32 %9, i32* %11, align 4, !dbg !4134, !tbaa !1650
  %12 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4135, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %12, i32 0, i32 1, !dbg !4136
  %14 = load i32, i32* %13, align 4, !dbg !4136, !tbaa !4012
  %15 = call i8* @can_fail_malloc(i32 %14) #17, !dbg !4137
  %16 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4138, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %16, i32 0, i32 4, !dbg !4139
  store i8* %15, i8** %17, align 4, !dbg !4140, !tbaa !1651
  %18 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !4141
  %19 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4142, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %19, i32 0, i32 0, !dbg !4143
  store %struct.aws_allocator* %18, %struct.aws_allocator** %20, align 4, !dbg !4144, !tbaa !1629
  %21 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4145, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %21, i32 0, i32 2, !dbg !4146
  %23 = load i32, i32* %22, align 4, !dbg !4146, !tbaa !1650
  %24 = call i32 @sea_max_array_list_len() #17, !dbg !4147
  %25 = icmp ule i32 %23, %24, !dbg !4148
  call void @__SEA_assume(i1 zeroext %25) #17, !dbg !4149
  %26 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4150, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %26, i32 0, i32 3, !dbg !4151
  %28 = load i32, i32* %27, align 4, !dbg !4151, !tbaa !1685
  %29 = call i32 @sea_max_array_list_item_size() #17, !dbg !4152
  %30 = icmp eq i32 %28, %29, !dbg !4153
  call void @__SEA_assume(i1 zeroext %30) #17, !dbg !4154
  %31 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4155, !tbaa !657
  %32 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %31, i32 0, i32 1, !dbg !4156
  %33 = load i32, i32* %32, align 4, !dbg !4156, !tbaa !4012
  %34 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4157, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %34, i32 0, i32 3, !dbg !4158
  %36 = load i32, i32* %35, align 4, !dbg !4158, !tbaa !1685
  %37 = load %struct.aws_array_list*, %struct.aws_array_list** %2, align 4, !dbg !4159, !tbaa !657
  %38 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %37, i32 0, i32 2, !dbg !4160
  %39 = load i32, i32* %38, align 4, !dbg !4160, !tbaa !1650
  %40 = mul i32 %36, %39, !dbg !4161
  %41 = icmp uge i32 %33, %40, !dbg !4162
  call void @__SEA_assume(i1 zeroext %41) #17, !dbg !4163
  ret void, !dbg !4164
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_array_list_is_bounded(%struct.aws_array_list* %0, i32 %1, i32 %2) #0 !dbg !4165 {
  %4 = alloca %struct.aws_array_list*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8, align 1
  %8 = alloca i8, align 1
  store %struct.aws_array_list* %0, %struct.aws_array_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %4, metadata !4172, metadata !DIExpression()), !dbg !4177
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !4173, metadata !DIExpression()), !dbg !4178
  store i32 %2, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !4174, metadata !DIExpression()), !dbg !4179
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %7) #19, !dbg !4180
  call void @llvm.dbg.declare(metadata i8* %7, metadata !4175, metadata !DIExpression()), !dbg !4181
  %9 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !4182, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %9, i32 0, i32 3, !dbg !4183
  %11 = load i32, i32* %10, align 4, !dbg !4183, !tbaa !1685
  %12 = load i32, i32* %6, align 4, !dbg !4184, !tbaa !663
  %13 = icmp eq i32 %11, %12, !dbg !4185
  %14 = zext i1 %13 to i8, !dbg !4181
  store i8 %14, i8* %7, align 1, !dbg !4181, !tbaa !844
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %8) #19, !dbg !4186
  call void @llvm.dbg.declare(metadata i8* %8, metadata !4176, metadata !DIExpression()), !dbg !4187
  %15 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !4188, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %15, i32 0, i32 2, !dbg !4189
  %17 = load i32, i32* %16, align 4, !dbg !4189, !tbaa !1650
  %18 = load i32, i32* %5, align 4, !dbg !4190, !tbaa !663
  %19 = icmp ule i32 %17, %18, !dbg !4191
  %20 = zext i1 %19 to i8, !dbg !4187
  store i8 %20, i8* %8, align 1, !dbg !4187, !tbaa !844
  %21 = load i8, i8* %7, align 1, !dbg !4192, !tbaa !844, !range !849
  %22 = trunc i8 %21 to i1, !dbg !4192
  br i1 %22, label %23, label %26, !dbg !4193

23:                                               ; preds = %3
  %24 = load i8, i8* %8, align 1, !dbg !4194, !tbaa !844, !range !849
  %25 = trunc i8 %24 to i1, !dbg !4194
  br label %26

26:                                               ; preds = %23, %3
  %27 = phi i1 [ false, %3 ], [ %25, %23 ], !dbg !4195
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #19, !dbg !4196
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %7) #19, !dbg !4196
  ret i1 %27, !dbg !4197
}

; Function Attrs: nounwind ssp
define void @initialize_byte_buf(%struct.aws_byte_buf* %0) #0 !dbg !4198 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !4211, metadata !DIExpression()), !dbg !4214
  %5 = bitcast i32* %3 to i8*, !dbg !4215
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %5) #19, !dbg !4215
  call void @llvm.dbg.declare(metadata i32* %3, metadata !4212, metadata !DIExpression()), !dbg !4216
  %6 = call i32 @nd_size_t() #21, !dbg !4217
  store i32 %6, i32* %3, align 4, !dbg !4216, !tbaa !663
  %7 = bitcast i32* %4 to i8*, !dbg !4218
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !4218
  call void @llvm.dbg.declare(metadata i32* %4, metadata !4213, metadata !DIExpression()), !dbg !4219
  %8 = call i32 @nd_size_t() #21, !dbg !4220
  store i32 %8, i32* %4, align 4, !dbg !4219, !tbaa !663
  %9 = load i32, i32* %3, align 4, !dbg !4221, !tbaa !663
  %10 = load i32, i32* %4, align 4, !dbg !4222, !tbaa !663
  %11 = icmp ule i32 %9, %10, !dbg !4223
  call void @__SEA_assume(i1 zeroext %11) #17, !dbg !4224
  %12 = load i32, i32* %4, align 4, !dbg !4225, !tbaa !663
  %13 = call i32 @sea_max_buffer_size() #17, !dbg !4226
  %14 = icmp ule i32 %12, %13, !dbg !4227
  call void @__SEA_assume(i1 zeroext %14) #17, !dbg !4228
  %15 = load i32, i32* %3, align 4, !dbg !4229, !tbaa !663
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4230, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %16, i32 0, i32 0, !dbg !4231
  store i32 %15, i32* %17, align 4, !dbg !4232, !tbaa !693
  %18 = load i32, i32* %4, align 4, !dbg !4233, !tbaa !663
  %19 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4234, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %19, i32 0, i32 2, !dbg !4235
  store i32 %18, i32* %20, align 4, !dbg !4236, !tbaa !698
  %21 = load i32, i32* %4, align 4, !dbg !4237, !tbaa !663
  %22 = mul i32 %21, 1, !dbg !4238
  %23 = call i8* @can_fail_malloc(i32 %22) #17, !dbg !4239
  %24 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4240, !tbaa !657
  %25 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %24, i32 0, i32 1, !dbg !4241
  store i8* %23, i8** %25, align 4, !dbg !4242, !tbaa !675
  %26 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !4243
  %27 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4244, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %27, i32 0, i32 3, !dbg !4245
  store %struct.aws_allocator* %26, %struct.aws_allocator** %28, align 4, !dbg !4246, !tbaa !703
  %29 = bitcast i32* %4 to i8*, !dbg !4247
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %29) #19, !dbg !4247
  %30 = bitcast i32* %3 to i8*, !dbg !4247
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %30) #19, !dbg !4247
  ret void, !dbg !4247
}

; Function Attrs: nounwind ssp
define void @initialize_byte_cursor(%struct.aws_byte_cursor* %0) #0 !dbg !4248 {
  %2 = alloca %struct.aws_byte_cursor*, align 4
  %3 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %2, metadata !4258, metadata !DIExpression()), !dbg !4260
  %4 = call i32 @nd_size_t() #21, !dbg !4261
  %5 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !4262, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !4263
  store i32 %4, i32* %6, align 4, !dbg !4264, !tbaa !822
  %7 = bitcast i32* %3 to i8*, !dbg !4265
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !4265
  call void @llvm.dbg.declare(metadata i32* %3, metadata !4259, metadata !DIExpression()), !dbg !4266
  %8 = call i32 @sea_max_buffer_size() #17, !dbg !4267
  store i32 %8, i32* %3, align 4, !dbg !4266, !tbaa !663
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !4268, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !4269
  %11 = load i32, i32* %10, align 4, !dbg !4269, !tbaa !822
  %12 = load i32, i32* %3, align 4, !dbg !4270, !tbaa !663
  %13 = icmp ule i32 %11, %12, !dbg !4271
  call void @__SEA_assume(i1 zeroext %13) #17, !dbg !4272
  %14 = load i32, i32* %3, align 4, !dbg !4273, !tbaa !663
  %15 = mul i32 1, %14, !dbg !4274
  %16 = call i8* @can_fail_malloc(i32 %15) #17, !dbg !4275
  %17 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !4276, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %17, i32 0, i32 1, !dbg !4277
  store i8* %16, i8** %18, align 4, !dbg !4278, !tbaa !832
  %19 = bitcast i32* %3 to i8*, !dbg !4279
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %19) #19, !dbg !4279
  ret void, !dbg !4279
}

; Function Attrs: nounwind ssp
define void @initialize_byte_cursor_aligned(%struct.aws_byte_cursor* %0) #0 !dbg !4280 {
  %2 = alloca %struct.aws_byte_cursor*, align 4
  %3 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %2, metadata !4282, metadata !DIExpression()), !dbg !4284
  %4 = call i32 @nd_size_t() #21, !dbg !4285
  %5 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !4286, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !4287
  store i32 %4, i32* %6, align 4, !dbg !4288, !tbaa !822
  %7 = bitcast i32* %3 to i8*, !dbg !4289
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !4289
  call void @llvm.dbg.declare(metadata i32* %3, metadata !4283, metadata !DIExpression()), !dbg !4290
  %8 = call i32 @sea_max_buffer_size() #17, !dbg !4291
  store i32 %8, i32* %3, align 4, !dbg !4290, !tbaa !663
  %9 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !4292, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %9, i32 0, i32 0, !dbg !4293
  %11 = load i32, i32* %10, align 4, !dbg !4293, !tbaa !822
  %12 = load i32, i32* %3, align 4, !dbg !4294, !tbaa !663
  %13 = icmp ule i32 %11, %12, !dbg !4295
  call void @__SEA_assume(i1 zeroext %13) #17, !dbg !4296
  %14 = load i32, i32* %3, align 4, !dbg !4297, !tbaa !663
  %15 = mul i32 1, %14, !dbg !4298
  %16 = call i8* @sea_malloc_aligned_havoc(i32 %15) #17, !dbg !4299
  %17 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %2, align 4, !dbg !4300, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %17, i32 0, i32 1, !dbg !4301
  store i8* %16, i8** %18, align 4, !dbg !4302, !tbaa !832
  %19 = bitcast i32* %3 to i8*, !dbg !4303
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %19) #19, !dbg !4303
  ret void, !dbg !4303
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc_aligned_havoc(i32 %0) #12 !dbg !4304 {
  %2 = alloca i32, align 4
  %3 = alloca i8*, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !4306, metadata !DIExpression()), !dbg !4308
  %4 = bitcast i8** %3 to i8*, !dbg !4309
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !4309
  call void @llvm.dbg.declare(metadata i8** %3, metadata !4307, metadata !DIExpression()), !dbg !4310
  %5 = load i32, i32* %2, align 4, !dbg !4311, !tbaa !663
  %6 = call i8* @sea_malloc_aligned(i32 %5) #17, !dbg !4312
  store i8* %6, i8** %3, align 4, !dbg !4310, !tbaa !657
  %7 = load i8*, i8** %3, align 4, !dbg !4313, !tbaa !657
  %8 = load i32, i32* %2, align 4, !dbg !4314, !tbaa !663
  call void @memhavoc(i8* %7, i32 %8) #21, !dbg !4315
  %9 = load i8*, i8** %3, align 4, !dbg !4316, !tbaa !657
  %10 = bitcast i8** %3 to i8*, !dbg !4317
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #19, !dbg !4317
  ret i8* %9, !dbg !4318
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc_aligned(i32 %0) #12 !dbg !586 {
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !590, metadata !DIExpression()), !dbg !4319
  %4 = bitcast i32* %3 to i8*, !dbg !4320
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !4320
  call void @llvm.dbg.declare(metadata i32* %3, metadata !591, metadata !DIExpression()), !dbg !4321
  %5 = load i32, i32* %2, align 4, !dbg !4322, !tbaa !663
  %6 = add i32 %5, 7, !dbg !4322
  %7 = and i32 %6, -8, !dbg !4322
  store i32 %7, i32* %3, align 4, !dbg !4321, !tbaa !663
  %8 = load i32, i32* %3, align 4, !dbg !4323, !tbaa !663
  %9 = call i8* @sea_malloc(i32 %8) #17, !dbg !4324
  %10 = bitcast i32* %3 to i8*, !dbg !4325
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #19, !dbg !4325
  ret i8* %9, !dbg !4326
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_is_bounded(%struct.aws_byte_buf* %0, i32 %1) #0 !dbg !4327 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !4334, metadata !DIExpression()), !dbg !4336
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !4335, metadata !DIExpression()), !dbg !4337
  %5 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !4338, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %5, i32 0, i32 2, !dbg !4339
  %7 = load i32, i32* %6, align 4, !dbg !4339, !tbaa !698
  %8 = load i32, i32* %4, align 4, !dbg !4340, !tbaa !663
  %9 = icmp ule i32 %7, %8, !dbg !4341
  ret i1 %9, !dbg !4342
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_cursor_is_bounded(%struct.aws_byte_cursor* %0, i32 %1) #0 !dbg !4343 {
  %3 = alloca %struct.aws_byte_cursor*, align 4
  %4 = alloca i32, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %3, metadata !4350, metadata !DIExpression()), !dbg !4352
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !4351, metadata !DIExpression()), !dbg !4353
  %5 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %3, align 4, !dbg !4354, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %5, i32 0, i32 0, !dbg !4355
  %7 = load i32, i32* %6, align 4, !dbg !4355, !tbaa !822
  %8 = load i32, i32* %4, align 4, !dbg !4356, !tbaa !663
  %9 = icmp ule i32 %7, %8, !dbg !4357
  ret i1 %9, !dbg !4358
}

; Function Attrs: nounwind ssp
define void @ensure_byte_buf_has_allocated_buffer_member(%struct.aws_byte_buf* %0) #0 !dbg !4359 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !4361, metadata !DIExpression()), !dbg !4362
  %3 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !4363
  %4 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4364, !tbaa !657
  %5 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %4, i32 0, i32 3, !dbg !4365
  store %struct.aws_allocator* %3, %struct.aws_allocator** %5, align 4, !dbg !4366, !tbaa !703
  %6 = call i32 @sea_max_buffer_size() #17, !dbg !4367
  %7 = mul i32 1, %6, !dbg !4368
  %8 = call i8* @bounded_malloc(i32 %7) #17, !dbg !4369
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4370, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %9, i32 0, i32 1, !dbg !4371
  store i8* %8, i8** %10, align 4, !dbg !4372, !tbaa !675
  ret void, !dbg !4373
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_byte_buf_has_allocator(%struct.aws_byte_buf* %0) #0 !dbg !4374 {
  %2 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %2, metadata !4378, metadata !DIExpression()), !dbg !4379
  %3 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %2, align 4, !dbg !4380, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %3, i32 0, i32 3, !dbg !4381
  %5 = load %struct.aws_allocator*, %struct.aws_allocator** %4, align 4, !dbg !4381, !tbaa !703
  %6 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !4382
  %7 = icmp eq %struct.aws_allocator* %5, %6, !dbg !4383
  ret i1 %7, !dbg !4384
}

; Function Attrs: nounwind ssp
define zeroext i1 @byte_bufs_are_equal(%struct.aws_byte_buf* %0, %struct.aws_byte_buf* %1) #0 !dbg !4385 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !4389, metadata !DIExpression()), !dbg !4391
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !4390, metadata !DIExpression()), !dbg !4392
  %6 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !4393, !tbaa !657
  %7 = icmp ne %struct.aws_byte_buf* %6, null, !dbg !4393
  br i1 %7, label %8, label %11, !dbg !4395

8:                                                ; preds = %2
  %9 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !4396, !tbaa !657
  %10 = icmp ne %struct.aws_byte_buf* %9, null, !dbg !4396
  br i1 %10, label %15, label %11, !dbg !4397

11:                                               ; preds = %8, %2
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !4398, !tbaa !657
  %13 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !4399, !tbaa !657
  %14 = icmp eq %struct.aws_byte_buf* %12, %13, !dbg !4400
  store i1 %14, i1* %3, align 1, !dbg !4401
  br label %49, !dbg !4401

15:                                               ; preds = %8
  %16 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !4402, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %16, i32 0, i32 0, !dbg !4403
  %18 = load i32, i32* %17, align 4, !dbg !4403, !tbaa !693
  %19 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !4404, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %19, i32 0, i32 0, !dbg !4405
  %21 = load i32, i32* %20, align 4, !dbg !4405, !tbaa !693
  %22 = icmp eq i32 %18, %21, !dbg !4406
  br i1 %22, label %23, label %47, !dbg !4407

23:                                               ; preds = %15
  %24 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !4408, !tbaa !657
  %25 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %24, i32 0, i32 1, !dbg !4409
  %26 = load i8*, i8** %25, align 4, !dbg !4409, !tbaa !675
  %27 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !4410, !tbaa !657
  %28 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %27, i32 0, i32 1, !dbg !4411
  %29 = load i8*, i8** %28, align 4, !dbg !4411, !tbaa !675
  %30 = icmp eq i8* %26, %29, !dbg !4412
  br i1 %30, label %31, label %47, !dbg !4413

31:                                               ; preds = %23
  %32 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !4414, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %32, i32 0, i32 2, !dbg !4415
  %34 = load i32, i32* %33, align 4, !dbg !4415, !tbaa !698
  %35 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !4416, !tbaa !657
  %36 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %35, i32 0, i32 2, !dbg !4417
  %37 = load i32, i32* %36, align 4, !dbg !4417, !tbaa !698
  %38 = icmp eq i32 %34, %37, !dbg !4418
  br i1 %38, label %39, label %47, !dbg !4419

39:                                               ; preds = %31
  %40 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !4420, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %40, i32 0, i32 3, !dbg !4421
  %42 = load %struct.aws_allocator*, %struct.aws_allocator** %41, align 4, !dbg !4421, !tbaa !703
  %43 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !4422, !tbaa !657
  %44 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %43, i32 0, i32 3, !dbg !4423
  %45 = load %struct.aws_allocator*, %struct.aws_allocator** %44, align 4, !dbg !4423, !tbaa !703
  %46 = icmp eq %struct.aws_allocator* %42, %45, !dbg !4424
  br label %47

47:                                               ; preds = %39, %31, %23, %15
  %48 = phi i1 [ false, %31 ], [ false, %23 ], [ false, %15 ], [ %46, %39 ], !dbg !4425
  store i1 %48, i1* %3, align 1, !dbg !4426
  br label %49, !dbg !4426

49:                                               ; preds = %47, %11
  %50 = load i1, i1* %3, align 1, !dbg !4427
  ret i1 %50, !dbg !4427
}

; Function Attrs: nounwind ssp
define void @init_node(%struct.aws_linked_list_node* %0) #0 !dbg !4428 {
  %2 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %2, metadata !4433, metadata !DIExpression()), !dbg !4434
  %3 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %2, align 4, !dbg !4435, !tbaa !657
  %4 = icmp ne %struct.aws_linked_list_node* %3, null, !dbg !4435
  call void @__SEA_assume(i1 zeroext %4) #17, !dbg !4436
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %2, align 4, !dbg !4437, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %5, i32 0, i32 0, !dbg !4438
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %6, align 4, !dbg !4439, !tbaa !4440
  %7 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %2, align 4, !dbg !4442, !tbaa !657
  %8 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %7, i32 0, i32 1, !dbg !4443
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %8, align 4, !dbg !4444, !tbaa !4445
  ret void, !dbg !4446
}

; Function Attrs: nounwind ssp
define void @sea_nd_init_aws_linked_list_from_head(%struct.aws_linked_list* %0, i32* %1) #0 !dbg !4447 {
  %3 = alloca %struct.aws_linked_list*, align 4
  %4 = alloca i32*, align 4
  %5 = alloca i32, align 4
  %6 = alloca %struct.aws_linked_list_node*, align 4
  %7 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %3, metadata !4456, metadata !DIExpression()), !dbg !4463
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !4457, metadata !DIExpression()), !dbg !4464
  %8 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4465, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %8, i32 0, i32 0, !dbg !4466
  %10 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %9, i32 0, i32 1, !dbg !4467
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %10, align 4, !dbg !4468, !tbaa !4469
  %11 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4471, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %11, i32 0, i32 1, !dbg !4472
  %13 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %12, i32 0, i32 0, !dbg !4473
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %13, align 4, !dbg !4474, !tbaa !4475
  %14 = bitcast i32* %5 to i8*, !dbg !4476
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !4476
  call void @llvm.dbg.declare(metadata i32* %5, metadata !4458, metadata !DIExpression()), !dbg !4477
  %15 = call i32 @nd_size_t() #21, !dbg !4478
  store i32 %15, i32* %5, align 4, !dbg !4477, !tbaa !663
  %16 = load i32, i32* %5, align 4, !dbg !4479, !tbaa !663
  %17 = load i32*, i32** %4, align 4, !dbg !4480, !tbaa !657
  store i32 %16, i32* %17, align 4, !dbg !4481, !tbaa !663
  %18 = load i32, i32* %5, align 4, !dbg !4482, !tbaa !663
  %19 = icmp ule i32 %18, 2, !dbg !4483
  br i1 %19, label %20, label %23, !dbg !4484

20:                                               ; preds = %2
  %21 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4485, !tbaa !657
  %22 = load i32, i32* %5, align 4, !dbg !4487, !tbaa !663
  call void @init_short_aws_linked_list(%struct.aws_linked_list* %21, i32 %22) #17, !dbg !4488
  br label %42, !dbg !4489

23:                                               ; preds = %2
  %24 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4490
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %24) #19, !dbg !4490
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %6, metadata !4459, metadata !DIExpression()), !dbg !4491
  %25 = call i8* @malloc(i32 8) #22, !dbg !4492
  %26 = bitcast i8* %25 to %struct.aws_linked_list_node*, !dbg !4492
  store %struct.aws_linked_list_node* %26, %struct.aws_linked_list_node** %6, align 4, !dbg !4491, !tbaa !657
  %27 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4493, !tbaa !657
  call void @init_node(%struct.aws_linked_list_node* %27) #17, !dbg !4494
  %28 = bitcast %struct.aws_linked_list_node** %7 to i8*, !dbg !4495
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %28) #19, !dbg !4495
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %7, metadata !4462, metadata !DIExpression()), !dbg !4496
  %29 = call i8* @malloc(i32 8) #22, !dbg !4497
  %30 = bitcast i8* %29 to %struct.aws_linked_list_node*, !dbg !4497
  store %struct.aws_linked_list_node* %30, %struct.aws_linked_list_node** %7, align 4, !dbg !4496, !tbaa !657
  %31 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4498, !tbaa !657
  call void @init_node(%struct.aws_linked_list_node* %31) #17, !dbg !4499
  %32 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4500, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %32, i32 0, i32 0, !dbg !4501
  %34 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4502, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %33, %struct.aws_linked_list_node* %34, i1 zeroext true) #17, !dbg !4503
  %35 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4504, !tbaa !657
  %36 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4505, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %35, %struct.aws_linked_list_node* %36, i1 zeroext true) #17, !dbg !4506
  %37 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4507, !tbaa !657
  %38 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4508, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %38, i32 0, i32 1, !dbg !4509
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %37, %struct.aws_linked_list_node* %39, i1 zeroext false) #17, !dbg !4510
  %40 = bitcast %struct.aws_linked_list_node** %7 to i8*, !dbg !4511
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %40) #19, !dbg !4511
  %41 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4511
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %41) #19, !dbg !4511
  br label %42

42:                                               ; preds = %23, %20
  %43 = bitcast i32* %5 to i8*, !dbg !4512
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %43) #19, !dbg !4512
  ret void, !dbg !4512
}

; Function Attrs: inlinehint nounwind ssp
define internal void @init_short_aws_linked_list(%struct.aws_linked_list* %0, i32 %1) #2 !dbg !4513 {
  %3 = alloca %struct.aws_linked_list*, align 4
  %4 = alloca i32, align 4
  %5 = alloca %struct.aws_linked_list_node*, align 4
  %6 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %3, metadata !4517, metadata !DIExpression()), !dbg !4521
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !4518, metadata !DIExpression()), !dbg !4522
  %7 = bitcast %struct.aws_linked_list_node** %5 to i8*, !dbg !4523
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !4523
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %5, metadata !4519, metadata !DIExpression()), !dbg !4524
  %8 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4525
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %8) #19, !dbg !4525
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %6, metadata !4520, metadata !DIExpression()), !dbg !4526
  %9 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4527, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %9, i32 0, i32 0, !dbg !4528
  %11 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %10, i32 0, i32 1, !dbg !4529
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %11, align 4, !dbg !4530, !tbaa !4469
  %12 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4531, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %12, i32 0, i32 1, !dbg !4532
  %14 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %13, i32 0, i32 0, !dbg !4533
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %14, align 4, !dbg !4534, !tbaa !4475
  %15 = load i32, i32* %4, align 4, !dbg !4535, !tbaa !663
  %16 = icmp eq i32 %15, 0, !dbg !4537
  br i1 %16, label %17, label %22, !dbg !4538

17:                                               ; preds = %2
  %18 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4539, !tbaa !657
  %19 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %18, i32 0, i32 0, !dbg !4541
  %20 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4542, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %20, i32 0, i32 1, !dbg !4543
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %19, %struct.aws_linked_list_node* %21, i1 zeroext true) #17, !dbg !4544
  br label %52, !dbg !4545

22:                                               ; preds = %2
  %23 = load i32, i32* %4, align 4, !dbg !4546, !tbaa !663
  %24 = icmp eq i32 %23, 1, !dbg !4548
  br i1 %24, label %25, label %34, !dbg !4549

25:                                               ; preds = %22
  %26 = call i8* @malloc(i32 8) #22, !dbg !4550
  %27 = bitcast i8* %26 to %struct.aws_linked_list_node*, !dbg !4550
  store %struct.aws_linked_list_node* %27, %struct.aws_linked_list_node** %5, align 4, !dbg !4552, !tbaa !657
  %28 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4553, !tbaa !657
  %29 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %28, i32 0, i32 0, !dbg !4554
  %30 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4555, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %29, %struct.aws_linked_list_node* %30, i1 zeroext true) #17, !dbg !4556
  %31 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4557, !tbaa !657
  %32 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4558, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %32, i32 0, i32 1, !dbg !4559
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %31, %struct.aws_linked_list_node* %33, i1 zeroext true) #17, !dbg !4560
  br label %51, !dbg !4561

34:                                               ; preds = %22
  %35 = load i32, i32* %4, align 4, !dbg !4562, !tbaa !663
  %36 = icmp eq i32 %35, 2, !dbg !4564
  br i1 %36, label %37, label %50, !dbg !4565

37:                                               ; preds = %34
  %38 = call i8* @malloc(i32 8) #22, !dbg !4566
  %39 = bitcast i8* %38 to %struct.aws_linked_list_node*, !dbg !4566
  store %struct.aws_linked_list_node* %39, %struct.aws_linked_list_node** %5, align 4, !dbg !4568, !tbaa !657
  %40 = call i8* @malloc(i32 8) #22, !dbg !4569
  %41 = bitcast i8* %40 to %struct.aws_linked_list_node*, !dbg !4569
  store %struct.aws_linked_list_node* %41, %struct.aws_linked_list_node** %6, align 4, !dbg !4570, !tbaa !657
  %42 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4571, !tbaa !657
  %43 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %42, i32 0, i32 0, !dbg !4572
  %44 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4573, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %43, %struct.aws_linked_list_node* %44, i1 zeroext true) #17, !dbg !4574
  %45 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4575, !tbaa !657
  %46 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4576, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %45, %struct.aws_linked_list_node* %46, i1 zeroext true) #17, !dbg !4577
  %47 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4578, !tbaa !657
  %48 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4579, !tbaa !657
  %49 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %48, i32 0, i32 1, !dbg !4580
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %47, %struct.aws_linked_list_node* %49, i1 zeroext true) #17, !dbg !4581
  br label %50, !dbg !4582

50:                                               ; preds = %37, %34
  br label %51

51:                                               ; preds = %50, %25
  br label %52

52:                                               ; preds = %51, %17
  %53 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4583
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %53) #19, !dbg !4583
  %54 = bitcast %struct.aws_linked_list_node** %5 to i8*, !dbg !4583
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %54) #19, !dbg !4583
  ret void, !dbg !4583
}

; Function Attrs: nounwind ssp
define void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %0, %struct.aws_linked_list_node* %1, i1 zeroext %2) #0 !dbg !4584 {
  %4 = alloca %struct.aws_linked_list_node*, align 4
  %5 = alloca %struct.aws_linked_list_node*, align 4
  %6 = alloca i8, align 1
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %4, metadata !4586, metadata !DIExpression()), !dbg !4589
  store %struct.aws_linked_list_node* %1, %struct.aws_linked_list_node** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %5, metadata !4587, metadata !DIExpression()), !dbg !4590
  %7 = zext i1 %2 to i8
  store i8 %7, i8* %6, align 1, !tbaa !844
  call void @llvm.dbg.declare(metadata i8* %6, metadata !4588, metadata !DIExpression()), !dbg !4591
  %8 = load i8, i8* %6, align 1, !dbg !4592, !tbaa !844, !range !849
  %9 = trunc i8 %8 to i1, !dbg !4592
  br i1 %9, label %10, label %17, !dbg !4594

10:                                               ; preds = %3
  %11 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4595, !tbaa !657
  %12 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !4597, !tbaa !657
  %13 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %12, i32 0, i32 0, !dbg !4598
  store %struct.aws_linked_list_node* %11, %struct.aws_linked_list_node** %13, align 4, !dbg !4599, !tbaa !4440
  %14 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !4600, !tbaa !657
  %15 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4601, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %15, i32 0, i32 1, !dbg !4602
  store %struct.aws_linked_list_node* %14, %struct.aws_linked_list_node** %16, align 4, !dbg !4603, !tbaa !4445
  br label %32, !dbg !4604

17:                                               ; preds = %3
  %18 = call %struct.aws_linked_list_node* @nd_linked_list_node() #21, !dbg !4605
  %19 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !4607, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %19, i32 0, i32 0, !dbg !4608
  store %struct.aws_linked_list_node* %18, %struct.aws_linked_list_node** %20, align 4, !dbg !4609, !tbaa !4440
  %21 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !4610, !tbaa !657
  %22 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %21, i32 0, i32 0, !dbg !4611
  %23 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %22, align 4, !dbg !4611, !tbaa !4440
  %24 = icmp ne %struct.aws_linked_list_node* %23, null, !dbg !4612
  call void @__SEA_assume(i1 zeroext %24) #17, !dbg !4613
  %25 = call %struct.aws_linked_list_node* @nd_linked_list_node() #21, !dbg !4614
  %26 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4615, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %26, i32 0, i32 1, !dbg !4616
  store %struct.aws_linked_list_node* %25, %struct.aws_linked_list_node** %27, align 4, !dbg !4617, !tbaa !4445
  %28 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %5, align 4, !dbg !4618, !tbaa !657
  %29 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %28, i32 0, i32 1, !dbg !4619
  %30 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %29, align 4, !dbg !4619, !tbaa !4445
  %31 = icmp ne %struct.aws_linked_list_node* %30, null, !dbg !4620
  call void @__SEA_assume(i1 zeroext %31) #17, !dbg !4621
  br label %32

32:                                               ; preds = %17, %10
  ret void, !dbg !4622
}

; Function Attrs: argmemonly nounwind
declare !dbg !347 %struct.aws_linked_list_node* @nd_linked_list_node() #11

; Function Attrs: nounwind ssp
define void @sea_nd_init_aws_linked_list_from_tail(%struct.aws_linked_list* %0, i32* %1) #0 !dbg !4623 {
  %3 = alloca %struct.aws_linked_list*, align 4
  %4 = alloca i32*, align 4
  %5 = alloca i32, align 4
  %6 = alloca %struct.aws_linked_list_node*, align 4
  %7 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %3, metadata !4625, metadata !DIExpression()), !dbg !4632
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !4626, metadata !DIExpression()), !dbg !4633
  %8 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4634, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %8, i32 0, i32 0, !dbg !4635
  %10 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %9, i32 0, i32 1, !dbg !4636
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %10, align 4, !dbg !4637, !tbaa !4469
  %11 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4638, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %11, i32 0, i32 1, !dbg !4639
  %13 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %12, i32 0, i32 0, !dbg !4640
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %13, align 4, !dbg !4641, !tbaa !4475
  %14 = bitcast i32* %5 to i8*, !dbg !4642
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !4642
  call void @llvm.dbg.declare(metadata i32* %5, metadata !4627, metadata !DIExpression()), !dbg !4643
  %15 = call i32 @nd_size_t() #21, !dbg !4644
  store i32 %15, i32* %5, align 4, !dbg !4643, !tbaa !663
  %16 = load i32, i32* %5, align 4, !dbg !4645, !tbaa !663
  %17 = load i32*, i32** %4, align 4, !dbg !4646, !tbaa !657
  store i32 %16, i32* %17, align 4, !dbg !4647, !tbaa !663
  %18 = load i32, i32* %5, align 4, !dbg !4648, !tbaa !663
  %19 = icmp ule i32 %18, 2, !dbg !4649
  br i1 %19, label %20, label %23, !dbg !4650

20:                                               ; preds = %2
  %21 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4651, !tbaa !657
  %22 = load i32, i32* %5, align 4, !dbg !4653, !tbaa !663
  call void @init_short_aws_linked_list(%struct.aws_linked_list* %21, i32 %22) #17, !dbg !4654
  br label %42, !dbg !4655

23:                                               ; preds = %2
  %24 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4656
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %24) #19, !dbg !4656
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %6, metadata !4628, metadata !DIExpression()), !dbg !4657
  %25 = call i8* @malloc(i32 8) #22, !dbg !4658
  %26 = bitcast i8* %25 to %struct.aws_linked_list_node*, !dbg !4658
  store %struct.aws_linked_list_node* %26, %struct.aws_linked_list_node** %6, align 4, !dbg !4657, !tbaa !657
  %27 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4659, !tbaa !657
  call void @init_node(%struct.aws_linked_list_node* %27) #17, !dbg !4660
  %28 = bitcast %struct.aws_linked_list_node** %7 to i8*, !dbg !4661
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %28) #19, !dbg !4661
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %7, metadata !4631, metadata !DIExpression()), !dbg !4662
  %29 = call i8* @malloc(i32 8) #22, !dbg !4663
  %30 = bitcast i8* %29 to %struct.aws_linked_list_node*, !dbg !4663
  store %struct.aws_linked_list_node* %30, %struct.aws_linked_list_node** %7, align 4, !dbg !4662, !tbaa !657
  %31 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4664, !tbaa !657
  call void @init_node(%struct.aws_linked_list_node* %31) #17, !dbg !4665
  %32 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4666, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %32, i32 0, i32 0, !dbg !4667
  %34 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4668, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %33, %struct.aws_linked_list_node* %34, i1 zeroext false) #17, !dbg !4669
  %35 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4670, !tbaa !657
  %36 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4671, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %35, %struct.aws_linked_list_node* %36, i1 zeroext true) #17, !dbg !4672
  %37 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4673, !tbaa !657
  %38 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4674, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %38, i32 0, i32 1, !dbg !4675
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %37, %struct.aws_linked_list_node* %39, i1 zeroext true) #17, !dbg !4676
  %40 = bitcast %struct.aws_linked_list_node** %7 to i8*, !dbg !4677
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %40) #19, !dbg !4677
  %41 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4677
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %41) #19, !dbg !4677
  br label %42

42:                                               ; preds = %23, %20
  %43 = bitcast i32* %5 to i8*, !dbg !4678
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %43) #19, !dbg !4678
  ret void, !dbg !4678
}

; Function Attrs: nounwind ssp
define void @sea_nd_init_aws_linked_list(%struct.aws_linked_list* %0, i32* %1) #0 !dbg !4679 {
  %3 = alloca %struct.aws_linked_list*, align 4
  %4 = alloca i32*, align 4
  %5 = alloca i32, align 4
  %6 = alloca %struct.aws_linked_list_node*, align 4
  %7 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %3, metadata !4681, metadata !DIExpression()), !dbg !4688
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !4682, metadata !DIExpression()), !dbg !4689
  %8 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4690, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %8, i32 0, i32 0, !dbg !4691
  %10 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %9, i32 0, i32 1, !dbg !4692
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %10, align 4, !dbg !4693, !tbaa !4469
  %11 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4694, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %11, i32 0, i32 1, !dbg !4695
  %13 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %12, i32 0, i32 0, !dbg !4696
  store %struct.aws_linked_list_node* null, %struct.aws_linked_list_node** %13, align 4, !dbg !4697, !tbaa !4475
  %14 = bitcast i32* %5 to i8*, !dbg !4698
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !4698
  call void @llvm.dbg.declare(metadata i32* %5, metadata !4683, metadata !DIExpression()), !dbg !4699
  %15 = call i32 @nd_size_t() #21, !dbg !4700
  store i32 %15, i32* %5, align 4, !dbg !4699, !tbaa !663
  %16 = load i32, i32* %5, align 4, !dbg !4701, !tbaa !663
  %17 = load i32*, i32** %4, align 4, !dbg !4702, !tbaa !657
  store i32 %16, i32* %17, align 4, !dbg !4703, !tbaa !663
  %18 = load i32, i32* %5, align 4, !dbg !4704, !tbaa !663
  %19 = icmp ule i32 %18, 2, !dbg !4705
  br i1 %19, label %20, label %23, !dbg !4706

20:                                               ; preds = %2
  %21 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4707, !tbaa !657
  %22 = load i32, i32* %5, align 4, !dbg !4709, !tbaa !663
  call void @init_short_aws_linked_list(%struct.aws_linked_list* %21, i32 %22) #17, !dbg !4710
  br label %42, !dbg !4711

23:                                               ; preds = %2
  %24 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4712
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %24) #19, !dbg !4712
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %6, metadata !4684, metadata !DIExpression()), !dbg !4713
  %25 = call i8* @malloc(i32 8) #22, !dbg !4714
  %26 = bitcast i8* %25 to %struct.aws_linked_list_node*, !dbg !4714
  store %struct.aws_linked_list_node* %26, %struct.aws_linked_list_node** %6, align 4, !dbg !4713, !tbaa !657
  %27 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4715, !tbaa !657
  call void @init_node(%struct.aws_linked_list_node* %27) #17, !dbg !4716
  %28 = bitcast %struct.aws_linked_list_node** %7 to i8*, !dbg !4717
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %28) #19, !dbg !4717
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %7, metadata !4687, metadata !DIExpression()), !dbg !4718
  %29 = call i8* @malloc(i32 8) #22, !dbg !4719
  %30 = bitcast i8* %29 to %struct.aws_linked_list_node*, !dbg !4719
  store %struct.aws_linked_list_node* %30, %struct.aws_linked_list_node** %7, align 4, !dbg !4718, !tbaa !657
  %31 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4720, !tbaa !657
  call void @init_node(%struct.aws_linked_list_node* %31) #17, !dbg !4721
  %32 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4722, !tbaa !657
  %33 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %32, i32 0, i32 0, !dbg !4723
  %34 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4724, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %33, %struct.aws_linked_list_node* %34, i1 zeroext true) #17, !dbg !4725
  %35 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !4726, !tbaa !657
  %36 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4727, !tbaa !657
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %35, %struct.aws_linked_list_node* %36, i1 zeroext false) #17, !dbg !4728
  %37 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4729, !tbaa !657
  %38 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4730, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %38, i32 0, i32 1, !dbg !4731
  call void @aws_linked_list_attach_after(%struct.aws_linked_list_node* %37, %struct.aws_linked_list_node* %39, i1 zeroext true) #17, !dbg !4732
  %40 = bitcast %struct.aws_linked_list_node** %7 to i8*, !dbg !4733
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %40) #19, !dbg !4733
  %41 = bitcast %struct.aws_linked_list_node** %6 to i8*, !dbg !4733
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %41) #19, !dbg !4733
  br label %42

42:                                               ; preds = %23, %20
  %43 = bitcast i32* %5 to i8*, !dbg !4734
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %43) #19, !dbg !4734
  ret void, !dbg !4734
}

; Function Attrs: nounwind ssp
define zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list_node* %1) #0 !dbg !4735 {
  %3 = alloca %struct.aws_linked_list_node*, align 4
  %4 = alloca %struct.saved_aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %3, metadata !4745, metadata !DIExpression()), !dbg !4747
  store %struct.saved_aws_linked_list_node* %1, %struct.saved_aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list_node** %4, metadata !4746, metadata !DIExpression()), !dbg !4748
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4749, !tbaa !657
  %6 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4750, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %6, i32 0, i32 0, !dbg !4751
  %8 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4751, !tbaa !4752
  %9 = icmp eq %struct.aws_linked_list_node* %5, %8, !dbg !4754
  br i1 %9, label %10, label %18, !dbg !4755

10:                                               ; preds = %2
  %11 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4756, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %11, i32 0, i32 1, !dbg !4757
  %13 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %12, align 4, !dbg !4757, !tbaa !4445
  %14 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4758, !tbaa !657
  %15 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %14, i32 0, i32 1, !dbg !4759
  %16 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %15, align 4, !dbg !4759, !tbaa !4760
  %17 = icmp eq %struct.aws_linked_list_node* %13, %16, !dbg !4761
  br label %18

18:                                               ; preds = %10, %2
  %19 = phi i1 [ false, %2 ], [ %17, %10 ], !dbg !4762
  ret i1 %19, !dbg !4763
}

; Function Attrs: nounwind ssp
define zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list_node* %1) #0 !dbg !4764 {
  %3 = alloca %struct.aws_linked_list_node*, align 4
  %4 = alloca %struct.saved_aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %3, metadata !4766, metadata !DIExpression()), !dbg !4768
  store %struct.saved_aws_linked_list_node* %1, %struct.saved_aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list_node** %4, metadata !4767, metadata !DIExpression()), !dbg !4769
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4770, !tbaa !657
  %6 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4771, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %6, i32 0, i32 0, !dbg !4772
  %8 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !4772, !tbaa !4752
  %9 = icmp eq %struct.aws_linked_list_node* %5, %8, !dbg !4773
  br i1 %9, label %10, label %18, !dbg !4774

10:                                               ; preds = %2
  %11 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4775, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %11, i32 0, i32 0, !dbg !4776
  %13 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %12, align 4, !dbg !4776, !tbaa !4440
  %14 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4777, !tbaa !657
  %15 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %14, i32 0, i32 2, !dbg !4778
  %16 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %15, align 4, !dbg !4778, !tbaa !4779
  %17 = icmp eq %struct.aws_linked_list_node* %13, %16, !dbg !4780
  br label %18

18:                                               ; preds = %10, %2
  %19 = phi i1 [ false, %2 ], [ %17, %10 ], !dbg !4781
  ret i1 %19, !dbg !4782
}

; Function Attrs: nounwind ssp
define zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list_node* %1) #0 !dbg !4783 {
  %3 = alloca %struct.aws_linked_list_node*, align 4
  %4 = alloca %struct.saved_aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %3, metadata !4785, metadata !DIExpression()), !dbg !4787
  store %struct.saved_aws_linked_list_node* %1, %struct.saved_aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list_node** %4, metadata !4786, metadata !DIExpression()), !dbg !4788
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4789, !tbaa !657
  %6 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4790, !tbaa !657
  %7 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %5, %struct.saved_aws_linked_list_node* %6) #17, !dbg !4791
  br i1 %7, label %8, label %12, !dbg !4792

8:                                                ; preds = %2
  %9 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4793, !tbaa !657
  %10 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4794, !tbaa !657
  %11 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %9, %struct.saved_aws_linked_list_node* %10) #17, !dbg !4795
  br label %12

12:                                               ; preds = %8, %2
  %13 = phi i1 [ false, %2 ], [ %11, %8 ], !dbg !4796
  ret i1 %13, !dbg !4797
}

; Function Attrs: nounwind ssp
define void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list_node* %1) #0 !dbg !4798 {
  %3 = alloca %struct.aws_linked_list_node*, align 4
  %4 = alloca %struct.saved_aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %3, metadata !4802, metadata !DIExpression()), !dbg !4804
  store %struct.saved_aws_linked_list_node* %1, %struct.saved_aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list_node** %4, metadata !4803, metadata !DIExpression()), !dbg !4805
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4806, !tbaa !657
  %6 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4807, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %6, i32 0, i32 0, !dbg !4808
  store %struct.aws_linked_list_node* %5, %struct.aws_linked_list_node** %7, align 4, !dbg !4809, !tbaa !4752
  %8 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4810, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %8, i32 0, i32 1, !dbg !4811
  %10 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !4811, !tbaa !4445
  %11 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4812, !tbaa !657
  %12 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %11, i32 0, i32 1, !dbg !4813
  store %struct.aws_linked_list_node* %10, %struct.aws_linked_list_node** %12, align 4, !dbg !4814, !tbaa !4760
  %13 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !4815, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %13, i32 0, i32 0, !dbg !4816
  %15 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %14, align 4, !dbg !4816, !tbaa !4440
  %16 = load %struct.saved_aws_linked_list_node*, %struct.saved_aws_linked_list_node** %4, align 4, !dbg !4817, !tbaa !657
  %17 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %16, i32 0, i32 2, !dbg !4818
  store %struct.aws_linked_list_node* %15, %struct.aws_linked_list_node** %17, align 4, !dbg !4819, !tbaa !4779
  ret void, !dbg !4820
}

; Function Attrs: nounwind ssp
define zeroext i1 @check_tail_unchanged(%struct.aws_linked_list* %0, %struct.saved_aws_linked_list* %1) #0 !dbg !4821 {
  %3 = alloca %struct.aws_linked_list*, align 4
  %4 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %3, metadata !4837, metadata !DIExpression()), !dbg !4839
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %4, metadata !4838, metadata !DIExpression()), !dbg !4840
  %5 = load %struct.aws_linked_list*, %struct.aws_linked_list** %3, align 4, !dbg !4841, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %5, i32 0, i32 1, !dbg !4842
  %7 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %4, align 4, !dbg !4843, !tbaa !657
  %8 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %7, i32 0, i32 4, !dbg !4844
  %9 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %6, %struct.saved_aws_linked_list_node* %8) #17, !dbg !4845
  ret i1 %9, !dbg !4846
}

; Function Attrs: nounwind ssp
define zeroext i1 @is_aws_list_unchanged_to_tail(%struct.aws_linked_list* %0, %struct.saved_aws_linked_list* %1) #0 !dbg !4847 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_linked_list*, align 4
  %5 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %4, metadata !4849, metadata !DIExpression()), !dbg !4851
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %5, metadata !4850, metadata !DIExpression()), !dbg !4852
  %6 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4853, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %6, i32 0, i32 0, !dbg !4855
  %8 = load i32, i32* %7, align 4, !dbg !4855, !tbaa !4856
  %9 = icmp eq i32 %8, 0, !dbg !4858
  br i1 %9, label %10, label %16, !dbg !4859

10:                                               ; preds = %2
  %11 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !4860, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %11, i32 0, i32 1, !dbg !4862
  %13 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4863, !tbaa !657
  %14 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %13, i32 0, i32 4, !dbg !4864
  %15 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %12, %struct.saved_aws_linked_list_node* %14) #17, !dbg !4865
  store i1 %15, i1* %3, align 1, !dbg !4866
  br label %112, !dbg !4866

16:                                               ; preds = %2
  %17 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4867, !tbaa !657
  %18 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %17, i32 0, i32 0, !dbg !4869
  %19 = load i32, i32* %18, align 4, !dbg !4869, !tbaa !4856
  %20 = icmp eq i32 %19, 1, !dbg !4870
  br i1 %20, label %21, label %37, !dbg !4871

21:                                               ; preds = %16
  %22 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4872, !tbaa !657
  %23 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %22, i32 0, i32 1, !dbg !4874
  %24 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %23, align 4, !dbg !4874, !tbaa !4875
  %25 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4876, !tbaa !657
  %26 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %25, i32 0, i32 5, !dbg !4877
  %27 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %26, i32 0, i32 0, !dbg !4876
  %28 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %24, %struct.saved_aws_linked_list_node* %27) #17, !dbg !4878
  br i1 %28, label %29, label %35, !dbg !4879

29:                                               ; preds = %21
  %30 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !4880, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %30, i32 0, i32 1, !dbg !4881
  %32 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4882, !tbaa !657
  %33 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %32, i32 0, i32 4, !dbg !4883
  %34 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %31, %struct.saved_aws_linked_list_node* %33) #17, !dbg !4884
  br label %35

35:                                               ; preds = %29, %21
  %36 = phi i1 [ false, %21 ], [ %34, %29 ], !dbg !4885
  store i1 %36, i1* %3, align 1, !dbg !4886
  br label %112, !dbg !4886

37:                                               ; preds = %16
  %38 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4887, !tbaa !657
  %39 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %38, i32 0, i32 0, !dbg !4889
  %40 = load i32, i32* %39, align 4, !dbg !4889, !tbaa !4856
  %41 = icmp eq i32 %40, 2, !dbg !4890
  br i1 %41, label %42, label %68, !dbg !4891

42:                                               ; preds = %37
  %43 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4892, !tbaa !657
  %44 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %43, i32 0, i32 1, !dbg !4894
  %45 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %44, align 4, !dbg !4894, !tbaa !4875
  %46 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4895, !tbaa !657
  %47 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %46, i32 0, i32 5, !dbg !4896
  %48 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %47, i32 0, i32 0, !dbg !4895
  %49 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %45, %struct.saved_aws_linked_list_node* %48) #17, !dbg !4897
  br i1 %49, label %50, label %66, !dbg !4898

50:                                               ; preds = %42
  %51 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4899, !tbaa !657
  %52 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %51, i32 0, i32 1, !dbg !4900
  %53 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %52, align 4, !dbg !4900, !tbaa !4875
  %54 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %53, i32 0, i32 0, !dbg !4901
  %55 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %54, align 4, !dbg !4901, !tbaa !4440
  %56 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4902, !tbaa !657
  %57 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %56, i32 0, i32 5, !dbg !4903
  %58 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %57, i32 0, i32 1, !dbg !4902
  %59 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %55, %struct.saved_aws_linked_list_node* %58) #17, !dbg !4904
  br i1 %59, label %60, label %66, !dbg !4905

60:                                               ; preds = %50
  %61 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !4906, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %61, i32 0, i32 1, !dbg !4907
  %63 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4908, !tbaa !657
  %64 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %63, i32 0, i32 4, !dbg !4909
  %65 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %62, %struct.saved_aws_linked_list_node* %64) #17, !dbg !4910
  br label %66

66:                                               ; preds = %60, %50, %42
  %67 = phi i1 [ false, %50 ], [ false, %42 ], [ %65, %60 ], !dbg !4911
  store i1 %67, i1* %3, align 1, !dbg !4912
  br label %112, !dbg !4912

68:                                               ; preds = %37
  %69 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4913, !tbaa !657
  %70 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %69, i32 0, i32 0, !dbg !4915
  %71 = load i32, i32* %70, align 4, !dbg !4915, !tbaa !4856
  %72 = icmp eq i32 %71, 3, !dbg !4916
  br i1 %72, label %73, label %111, !dbg !4917

73:                                               ; preds = %68
  %74 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4918, !tbaa !657
  %75 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %74, i32 0, i32 1, !dbg !4920
  %76 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %75, align 4, !dbg !4920, !tbaa !4875
  %77 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4921, !tbaa !657
  %78 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %77, i32 0, i32 5, !dbg !4922
  %79 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %78, i32 0, i32 0, !dbg !4921
  %80 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %76, %struct.saved_aws_linked_list_node* %79) #17, !dbg !4923
  br i1 %80, label %81, label %109, !dbg !4924

81:                                               ; preds = %73
  %82 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4925, !tbaa !657
  %83 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %82, i32 0, i32 1, !dbg !4926
  %84 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %83, align 4, !dbg !4926, !tbaa !4875
  %85 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %84, i32 0, i32 0, !dbg !4927
  %86 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %85, align 4, !dbg !4927, !tbaa !4440
  %87 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4928, !tbaa !657
  %88 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %87, i32 0, i32 5, !dbg !4929
  %89 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %88, i32 0, i32 1, !dbg !4928
  %90 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %86, %struct.saved_aws_linked_list_node* %89) #17, !dbg !4930
  br i1 %90, label %91, label %109, !dbg !4931

91:                                               ; preds = %81
  %92 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4932, !tbaa !657
  %93 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %92, i32 0, i32 1, !dbg !4933
  %94 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %93, align 4, !dbg !4933, !tbaa !4875
  %95 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %94, i32 0, i32 0, !dbg !4934
  %96 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %95, align 4, !dbg !4934, !tbaa !4440
  %97 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %96, i32 0, i32 0, !dbg !4935
  %98 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %97, align 4, !dbg !4935, !tbaa !4440
  %99 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4936, !tbaa !657
  %100 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %99, i32 0, i32 5, !dbg !4937
  %101 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %100, i32 0, i32 2, !dbg !4936
  %102 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %98, %struct.saved_aws_linked_list_node* %101) #17, !dbg !4938
  br i1 %102, label %103, label %109, !dbg !4939

103:                                              ; preds = %91
  %104 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !4940, !tbaa !657
  %105 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %104, i32 0, i32 1, !dbg !4941
  %106 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4942, !tbaa !657
  %107 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %106, i32 0, i32 4, !dbg !4943
  %108 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %105, %struct.saved_aws_linked_list_node* %107) #17, !dbg !4944
  br label %109

109:                                              ; preds = %103, %91, %81, %73
  %110 = phi i1 [ false, %91 ], [ false, %81 ], [ false, %73 ], [ %108, %103 ], !dbg !4945
  store i1 %110, i1* %3, align 1, !dbg !4946
  br label %112, !dbg !4946

111:                                              ; preds = %68
  store i1 false, i1* %3, align 1, !dbg !4947
  br label %112, !dbg !4947

112:                                              ; preds = %111, %109, %66, %35, %10
  %113 = load i1, i1* %3, align 1, !dbg !4949
  ret i1 %113, !dbg !4949
}

; Function Attrs: nounwind ssp
define zeroext i1 @is_aws_list_unchanged_to_head(%struct.aws_linked_list* %0, %struct.saved_aws_linked_list* %1) #0 !dbg !4950 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_linked_list*, align 4
  %5 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %4, metadata !4952, metadata !DIExpression()), !dbg !4954
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %5, metadata !4953, metadata !DIExpression()), !dbg !4955
  %6 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4956, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %6, i32 0, i32 0, !dbg !4958
  %8 = load i32, i32* %7, align 4, !dbg !4958, !tbaa !4856
  %9 = icmp eq i32 %8, 0, !dbg !4959
  br i1 %9, label %10, label %16, !dbg !4960

10:                                               ; preds = %2
  %11 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !4961, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %11, i32 0, i32 0, !dbg !4963
  %13 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4964, !tbaa !657
  %14 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %13, i32 0, i32 3, !dbg !4965
  %15 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %12, %struct.saved_aws_linked_list_node* %14) #17, !dbg !4966
  store i1 %15, i1* %3, align 1, !dbg !4967
  br label %112, !dbg !4967

16:                                               ; preds = %2
  %17 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4968, !tbaa !657
  %18 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %17, i32 0, i32 0, !dbg !4970
  %19 = load i32, i32* %18, align 4, !dbg !4970, !tbaa !4856
  %20 = icmp eq i32 %19, 1, !dbg !4971
  br i1 %20, label %21, label %37, !dbg !4972

21:                                               ; preds = %16
  %22 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4973, !tbaa !657
  %23 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %22, i32 0, i32 1, !dbg !4975
  %24 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %23, align 4, !dbg !4975, !tbaa !4875
  %25 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4976, !tbaa !657
  %26 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %25, i32 0, i32 5, !dbg !4977
  %27 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %26, i32 0, i32 0, !dbg !4976
  %28 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %24, %struct.saved_aws_linked_list_node* %27) #17, !dbg !4978
  br i1 %28, label %29, label %35, !dbg !4979

29:                                               ; preds = %21
  %30 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !4980, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %30, i32 0, i32 0, !dbg !4981
  %32 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4982, !tbaa !657
  %33 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %32, i32 0, i32 3, !dbg !4983
  %34 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %31, %struct.saved_aws_linked_list_node* %33) #17, !dbg !4984
  br label %35

35:                                               ; preds = %29, %21
  %36 = phi i1 [ false, %21 ], [ %34, %29 ], !dbg !4985
  store i1 %36, i1* %3, align 1, !dbg !4986
  br label %112, !dbg !4986

37:                                               ; preds = %16
  %38 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4987, !tbaa !657
  %39 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %38, i32 0, i32 0, !dbg !4989
  %40 = load i32, i32* %39, align 4, !dbg !4989, !tbaa !4856
  %41 = icmp eq i32 %40, 2, !dbg !4990
  br i1 %41, label %42, label %68, !dbg !4991

42:                                               ; preds = %37
  %43 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4992, !tbaa !657
  %44 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %43, i32 0, i32 1, !dbg !4994
  %45 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %44, align 4, !dbg !4994, !tbaa !4875
  %46 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4995, !tbaa !657
  %47 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %46, i32 0, i32 5, !dbg !4996
  %48 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %47, i32 0, i32 0, !dbg !4995
  %49 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %45, %struct.saved_aws_linked_list_node* %48) #17, !dbg !4997
  br i1 %49, label %50, label %66, !dbg !4998

50:                                               ; preds = %42
  %51 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !4999, !tbaa !657
  %52 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %51, i32 0, i32 1, !dbg !5000
  %53 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %52, align 4, !dbg !5000, !tbaa !4875
  %54 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %53, i32 0, i32 1, !dbg !5001
  %55 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %54, align 4, !dbg !5001, !tbaa !4445
  %56 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5002, !tbaa !657
  %57 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %56, i32 0, i32 5, !dbg !5003
  %58 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %57, i32 0, i32 1, !dbg !5002
  %59 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %55, %struct.saved_aws_linked_list_node* %58) #17, !dbg !5004
  br i1 %59, label %60, label %66, !dbg !5005

60:                                               ; preds = %50
  %61 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !5006, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %61, i32 0, i32 0, !dbg !5007
  %63 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5008, !tbaa !657
  %64 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %63, i32 0, i32 3, !dbg !5009
  %65 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %62, %struct.saved_aws_linked_list_node* %64) #17, !dbg !5010
  br label %66

66:                                               ; preds = %60, %50, %42
  %67 = phi i1 [ false, %50 ], [ false, %42 ], [ %65, %60 ], !dbg !5011
  store i1 %67, i1* %3, align 1, !dbg !5012
  br label %112, !dbg !5012

68:                                               ; preds = %37
  %69 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5013, !tbaa !657
  %70 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %69, i32 0, i32 0, !dbg !5015
  %71 = load i32, i32* %70, align 4, !dbg !5015, !tbaa !4856
  %72 = icmp eq i32 %71, 3, !dbg !5016
  br i1 %72, label %73, label %111, !dbg !5017

73:                                               ; preds = %68
  %74 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5018, !tbaa !657
  %75 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %74, i32 0, i32 1, !dbg !5020
  %76 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %75, align 4, !dbg !5020, !tbaa !4875
  %77 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5021, !tbaa !657
  %78 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %77, i32 0, i32 5, !dbg !5022
  %79 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %78, i32 0, i32 0, !dbg !5021
  %80 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %76, %struct.saved_aws_linked_list_node* %79) #17, !dbg !5023
  br i1 %80, label %81, label %109, !dbg !5024

81:                                               ; preds = %73
  %82 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5025, !tbaa !657
  %83 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %82, i32 0, i32 1, !dbg !5026
  %84 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %83, align 4, !dbg !5026, !tbaa !4875
  %85 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %84, i32 0, i32 1, !dbg !5027
  %86 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %85, align 4, !dbg !5027, !tbaa !4445
  %87 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5028, !tbaa !657
  %88 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %87, i32 0, i32 5, !dbg !5029
  %89 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %88, i32 0, i32 1, !dbg !5028
  %90 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %86, %struct.saved_aws_linked_list_node* %89) #17, !dbg !5030
  br i1 %90, label %91, label %109, !dbg !5031

91:                                               ; preds = %81
  %92 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5032, !tbaa !657
  %93 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %92, i32 0, i32 1, !dbg !5033
  %94 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %93, align 4, !dbg !5033, !tbaa !4875
  %95 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %94, i32 0, i32 1, !dbg !5034
  %96 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %95, align 4, !dbg !5034, !tbaa !4445
  %97 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %96, i32 0, i32 1, !dbg !5035
  %98 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %97, align 4, !dbg !5035, !tbaa !4445
  %99 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5036, !tbaa !657
  %100 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %99, i32 0, i32 5, !dbg !5037
  %101 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %100, i32 0, i32 2, !dbg !5036
  %102 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %98, %struct.saved_aws_linked_list_node* %101) #17, !dbg !5038
  br i1 %102, label %103, label %109, !dbg !5039

103:                                              ; preds = %91
  %104 = load %struct.aws_linked_list*, %struct.aws_linked_list** %4, align 4, !dbg !5040, !tbaa !657
  %105 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %104, i32 0, i32 0, !dbg !5041
  %106 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5042, !tbaa !657
  %107 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %106, i32 0, i32 3, !dbg !5043
  %108 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %105, %struct.saved_aws_linked_list_node* %107) #17, !dbg !5044
  br label %109

109:                                              ; preds = %103, %91, %81, %73
  %110 = phi i1 [ false, %91 ], [ false, %81 ], [ false, %73 ], [ %108, %103 ], !dbg !5045
  store i1 %110, i1* %3, align 1, !dbg !5046
  br label %112, !dbg !5046

111:                                              ; preds = %68
  store i1 false, i1* %3, align 1, !dbg !5047
  br label %112, !dbg !5047

112:                                              ; preds = %111, %109, %66, %35, %10
  %113 = load i1, i1* %3, align 1, !dbg !5049
  ret i1 %113, !dbg !5049
}

; Function Attrs: nounwind ssp
define zeroext i1 @is_aws_list_unchanged_full(%struct.aws_linked_list* %0, %struct.saved_aws_linked_list* %1) #0 !dbg !5050 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_linked_list*, align 4
  %5 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %4, metadata !5052, metadata !DIExpression()), !dbg !5054
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %5, metadata !5053, metadata !DIExpression()), !dbg !5055
  %6 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5056, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %6, i32 0, i32 0, !dbg !5058
  %8 = load i32, i32* %7, align 4, !dbg !5058, !tbaa !4856
  %9 = icmp eq i32 %8, 0, !dbg !5059
  br i1 %9, label %10, label %32, !dbg !5060

10:                                               ; preds = %2
  %11 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5061, !tbaa !657
  %12 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %11, i32 0, i32 3, !dbg !5063
  %13 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %12, i32 0, i32 2, !dbg !5064
  %14 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %13, align 4, !dbg !5064, !tbaa !5065
  %15 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5066, !tbaa !657
  %16 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %15, i32 0, i32 4, !dbg !5067
  %17 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %16, i32 0, i32 0, !dbg !5068
  %18 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %17, align 4, !dbg !5068, !tbaa !5069
  %19 = icmp eq %struct.aws_linked_list_node* %14, %18, !dbg !5070
  br i1 %19, label %20, label %30, !dbg !5071

20:                                               ; preds = %10
  %21 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5072, !tbaa !657
  %22 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %21, i32 0, i32 4, !dbg !5073
  %23 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %22, i32 0, i32 1, !dbg !5074
  %24 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %23, align 4, !dbg !5074, !tbaa !5075
  %25 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5076, !tbaa !657
  %26 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %25, i32 0, i32 3, !dbg !5077
  %27 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %26, i32 0, i32 0, !dbg !5078
  %28 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %27, align 4, !dbg !5078, !tbaa !5079
  %29 = icmp eq %struct.aws_linked_list_node* %24, %28, !dbg !5080
  br label %30

30:                                               ; preds = %20, %10
  %31 = phi i1 [ false, %10 ], [ %29, %20 ], !dbg !5081
  store i1 %31, i1* %3, align 1, !dbg !5082
  br label %191, !dbg !5082

32:                                               ; preds = %2
  %33 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5083, !tbaa !657
  %34 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %33, i32 0, i32 0, !dbg !5085
  %35 = load i32, i32* %34, align 4, !dbg !5085, !tbaa !4856
  %36 = icmp eq i32 %35, 1, !dbg !5086
  br i1 %36, label %37, label %57, !dbg !5087

37:                                               ; preds = %32
  %38 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5088, !tbaa !657
  %39 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %38, i32 0, i32 1, !dbg !5090
  %40 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %39, align 4, !dbg !5090, !tbaa !4875
  %41 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5091, !tbaa !657
  %42 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %41, i32 0, i32 2, !dbg !5092
  %43 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %42, align 4, !dbg !5092, !tbaa !5093
  %44 = icmp eq %struct.aws_linked_list_node* %40, %43, !dbg !5094
  br i1 %44, label %45, label %55, !dbg !5095

45:                                               ; preds = %37
  %46 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5096, !tbaa !657
  %47 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %46, i32 0, i32 1, !dbg !5097
  %48 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %47, align 4, !dbg !5097, !tbaa !4875
  %49 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5098, !tbaa !657
  %50 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %49, i32 0, i32 5, !dbg !5099
  %51 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %50, i32 0, i32 0, !dbg !5098
  %52 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %51, i32 0, i32 0, !dbg !5100
  %53 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %52, align 4, !dbg !5100, !tbaa !4752
  %54 = icmp eq %struct.aws_linked_list_node* %48, %53, !dbg !5101
  br label %55

55:                                               ; preds = %45, %37
  %56 = phi i1 [ false, %37 ], [ %54, %45 ], !dbg !5102
  store i1 %56, i1* %3, align 1, !dbg !5103
  br label %191, !dbg !5103

57:                                               ; preds = %32
  %58 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5104, !tbaa !657
  %59 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %58, i32 0, i32 0, !dbg !5106
  %60 = load i32, i32* %59, align 4, !dbg !5106, !tbaa !4856
  %61 = icmp eq i32 %60, 2, !dbg !5107
  br i1 %61, label %62, label %80, !dbg !5108

62:                                               ; preds = %57
  %63 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5109, !tbaa !657
  %64 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %63, i32 0, i32 1, !dbg !5111
  %65 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %64, align 4, !dbg !5111, !tbaa !4875
  %66 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5112, !tbaa !657
  %67 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %66, i32 0, i32 5, !dbg !5113
  %68 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %67, i32 0, i32 0, !dbg !5112
  %69 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %65, %struct.saved_aws_linked_list_node* %68) #17, !dbg !5114
  br i1 %69, label %70, label %78, !dbg !5115

70:                                               ; preds = %62
  %71 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5116, !tbaa !657
  %72 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %71, i32 0, i32 2, !dbg !5117
  %73 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %72, align 4, !dbg !5117, !tbaa !5093
  %74 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5118, !tbaa !657
  %75 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %74, i32 0, i32 5, !dbg !5119
  %76 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %75, i32 0, i32 1, !dbg !5118
  %77 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %73, %struct.saved_aws_linked_list_node* %76) #17, !dbg !5120
  br label %78

78:                                               ; preds = %70, %62
  %79 = phi i1 [ false, %62 ], [ %77, %70 ], !dbg !5121
  store i1 %79, i1* %3, align 1, !dbg !5122
  br label %191, !dbg !5122

80:                                               ; preds = %57
  %81 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5123, !tbaa !657
  %82 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %81, i32 0, i32 0, !dbg !5125
  %83 = load i32, i32* %82, align 4, !dbg !5125, !tbaa !4856
  %84 = icmp eq i32 %83, 3, !dbg !5126
  br i1 %84, label %85, label %147, !dbg !5127

85:                                               ; preds = %80
  %86 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5128, !tbaa !657
  %87 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %86, i32 0, i32 1, !dbg !5131
  %88 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %87, align 4, !dbg !5131, !tbaa !4875
  %89 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5132, !tbaa !657
  %90 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %89, i32 0, i32 5, !dbg !5133
  %91 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %90, i32 0, i32 0, !dbg !5132
  %92 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %88, %struct.saved_aws_linked_list_node* %91) #17, !dbg !5134
  br i1 %92, label %93, label %146, !dbg !5135

93:                                               ; preds = %85
  %94 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5136, !tbaa !657
  %95 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %94, i32 0, i32 2, !dbg !5137
  %96 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %95, align 4, !dbg !5137, !tbaa !5093
  %97 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5138, !tbaa !657
  %98 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %97, i32 0, i32 5, !dbg !5139
  %99 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %98, i32 0, i32 2, !dbg !5138
  %100 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %96, %struct.saved_aws_linked_list_node* %99) #17, !dbg !5140
  br i1 %100, label %101, label %146, !dbg !5141

101:                                              ; preds = %93
  %102 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5142, !tbaa !657
  %103 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %102, i32 0, i32 5, !dbg !5145
  %104 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %103, i32 0, i32 1, !dbg !5142
  %105 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %104, i32 0, i32 0, !dbg !5146
  %106 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %105, align 4, !dbg !5146, !tbaa !4752
  %107 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5147, !tbaa !657
  %108 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %107, i32 0, i32 1, !dbg !5148
  %109 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %108, align 4, !dbg !5148, !tbaa !4875
  %110 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %109, i32 0, i32 0, !dbg !5149
  %111 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %110, align 4, !dbg !5149, !tbaa !4440
  %112 = icmp eq %struct.aws_linked_list_node* %106, %111, !dbg !5150
  br i1 %112, label %113, label %123, !dbg !5151

113:                                              ; preds = %101
  %114 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5152, !tbaa !657
  %115 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %114, i32 0, i32 1, !dbg !5154
  %116 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %115, align 4, !dbg !5154, !tbaa !4875
  %117 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %116, i32 0, i32 0, !dbg !5155
  %118 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %117, align 4, !dbg !5155, !tbaa !4440
  %119 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5156, !tbaa !657
  %120 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %119, i32 0, i32 5, !dbg !5157
  %121 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %120, i32 0, i32 1, !dbg !5156
  %122 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %118, %struct.saved_aws_linked_list_node* %121) #17, !dbg !5158
  store i1 %122, i1* %3, align 1, !dbg !5159
  br label %191, !dbg !5159

123:                                              ; preds = %101
  %124 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5160, !tbaa !657
  %125 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %124, i32 0, i32 5, !dbg !5162
  %126 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %125, i32 0, i32 1, !dbg !5160
  %127 = getelementptr inbounds %struct.saved_aws_linked_list_node, %struct.saved_aws_linked_list_node* %126, i32 0, i32 0, !dbg !5163
  %128 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %127, align 4, !dbg !5163, !tbaa !4752
  %129 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5164, !tbaa !657
  %130 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %129, i32 0, i32 2, !dbg !5165
  %131 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %130, align 4, !dbg !5165, !tbaa !5093
  %132 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %131, i32 0, i32 1, !dbg !5166
  %133 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %132, align 4, !dbg !5166, !tbaa !4445
  %134 = icmp eq %struct.aws_linked_list_node* %128, %133, !dbg !5167
  br i1 %134, label %135, label %145, !dbg !5168

135:                                              ; preds = %123
  %136 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5169, !tbaa !657
  %137 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %136, i32 0, i32 2, !dbg !5171
  %138 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %137, align 4, !dbg !5171, !tbaa !5093
  %139 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %138, i32 0, i32 1, !dbg !5172
  %140 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %139, align 4, !dbg !5172, !tbaa !4445
  %141 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5173, !tbaa !657
  %142 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %141, i32 0, i32 5, !dbg !5174
  %143 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %142, i32 0, i32 1, !dbg !5173
  %144 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %140, %struct.saved_aws_linked_list_node* %143) #17, !dbg !5175
  store i1 %144, i1* %3, align 1, !dbg !5176
  br label %191, !dbg !5176

145:                                              ; preds = %123
  store i1 false, i1* %3, align 1, !dbg !5177
  br label %191, !dbg !5177

146:                                              ; preds = %93, %85
  store i1 false, i1* %3, align 1, !dbg !5178
  br label %191, !dbg !5178

147:                                              ; preds = %80
  %148 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5179, !tbaa !657
  %149 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %148, i32 0, i32 0, !dbg !5181
  %150 = load i32, i32* %149, align 4, !dbg !5181, !tbaa !4856
  %151 = icmp eq i32 %150, 4, !dbg !5182
  br i1 %151, label %152, label %190, !dbg !5183

152:                                              ; preds = %147
  %153 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5184, !tbaa !657
  %154 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %153, i32 0, i32 1, !dbg !5186
  %155 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %154, align 4, !dbg !5186, !tbaa !4875
  %156 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5187, !tbaa !657
  %157 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %156, i32 0, i32 5, !dbg !5188
  %158 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %157, i32 0, i32 0, !dbg !5187
  %159 = call zeroext i1 @nodes_next_equal(%struct.aws_linked_list_node* %155, %struct.saved_aws_linked_list_node* %158) #17, !dbg !5189
  br i1 %159, label %160, label %188, !dbg !5190

160:                                              ; preds = %152
  %161 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5191, !tbaa !657
  %162 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %161, i32 0, i32 1, !dbg !5192
  %163 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %162, align 4, !dbg !5192, !tbaa !4875
  %164 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %163, i32 0, i32 0, !dbg !5193
  %165 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %164, align 4, !dbg !5193, !tbaa !4440
  %166 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5194, !tbaa !657
  %167 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %166, i32 0, i32 5, !dbg !5195
  %168 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %167, i32 0, i32 1, !dbg !5194
  %169 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %165, %struct.saved_aws_linked_list_node* %168) #17, !dbg !5196
  br i1 %169, label %170, label %188, !dbg !5197

170:                                              ; preds = %160
  %171 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5198, !tbaa !657
  %172 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %171, i32 0, i32 2, !dbg !5199
  %173 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %172, align 4, !dbg !5199, !tbaa !5093
  %174 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %173, i32 0, i32 1, !dbg !5200
  %175 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %174, align 4, !dbg !5200, !tbaa !4445
  %176 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5201, !tbaa !657
  %177 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %176, i32 0, i32 5, !dbg !5202
  %178 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %177, i32 0, i32 2, !dbg !5201
  %179 = call zeroext i1 @nodes_equal(%struct.aws_linked_list_node* %175, %struct.saved_aws_linked_list_node* %178) #17, !dbg !5203
  br i1 %179, label %180, label %188, !dbg !5204

180:                                              ; preds = %170
  %181 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5205, !tbaa !657
  %182 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %181, i32 0, i32 2, !dbg !5206
  %183 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %182, align 4, !dbg !5206, !tbaa !5093
  %184 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5207, !tbaa !657
  %185 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %184, i32 0, i32 5, !dbg !5208
  %186 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %185, i32 0, i32 3, !dbg !5207
  %187 = call zeroext i1 @nodes_prev_equal(%struct.aws_linked_list_node* %183, %struct.saved_aws_linked_list_node* %186) #17, !dbg !5209
  br label %188

188:                                              ; preds = %180, %170, %160, %152
  %189 = phi i1 [ false, %170 ], [ false, %160 ], [ false, %152 ], [ %187, %180 ], !dbg !5210
  store i1 %189, i1* %3, align 1, !dbg !5211
  br label %191, !dbg !5211

190:                                              ; preds = %147
  store i1 false, i1* %3, align 1, !dbg !5212
  br label %191, !dbg !5212

191:                                              ; preds = %190, %188, %146, %145, %135, %113, %78, %55, %30
  %192 = load i1, i1* %3, align 1, !dbg !5213
  ret i1 %192, !dbg !5213
}

; Function Attrs: nounwind ssp
define %struct.aws_linked_list_node* @getNext(%struct.aws_linked_list_node* %0) #0 !dbg !5214 {
  %2 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %2, metadata !5218, metadata !DIExpression()), !dbg !5219
  %3 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %2, align 4, !dbg !5220, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %3, i32 0, i32 0, !dbg !5221
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5221, !tbaa !4440
  ret %struct.aws_linked_list_node* %5, !dbg !5222
}

; Function Attrs: nounwind ssp
define %struct.aws_linked_list_node* @getPrev(%struct.aws_linked_list_node* %0) #0 !dbg !5223 {
  %2 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %2, metadata !5225, metadata !DIExpression()), !dbg !5226
  %3 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %2, align 4, !dbg !5227, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %3, i32 0, i32 1, !dbg !5228
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5228, !tbaa !4445
  ret %struct.aws_linked_list_node* %5, !dbg !5229
}

; Function Attrs: nounwind ssp
define void @save_one_node(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list* %1) #0 !dbg !5230 {
  %3 = alloca %struct.aws_linked_list_node*, align 4
  %4 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %3, metadata !5234, metadata !DIExpression()), !dbg !5236
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %4, metadata !5235, metadata !DIExpression()), !dbg !5237
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !5238, !tbaa !657
  %6 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %4, align 4, !dbg !5239, !tbaa !657
  %7 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %6, i32 0, i32 5, !dbg !5240
  %8 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %7, i32 0, i32 0, !dbg !5239
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %5, %struct.saved_aws_linked_list_node* %8) #17, !dbg !5241
  %9 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %4, align 4, !dbg !5242, !tbaa !657
  %10 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %9, i32 0, i32 0, !dbg !5243
  store i32 1, i32* %10, align 4, !dbg !5244, !tbaa !4856
  ret void, !dbg !5245
}

; Function Attrs: nounwind ssp
define void @save_two_nodes(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list* %1, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* %2) #0 !dbg !5246 {
  %4 = alloca %struct.aws_linked_list_node*, align 4
  %5 = alloca %struct.saved_aws_linked_list*, align 4
  %6 = alloca %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %4, metadata !5251, metadata !DIExpression()), !dbg !5254
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %5, metadata !5252, metadata !DIExpression()), !dbg !5255
  store %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* %2, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, metadata !5253, metadata !DIExpression()), !dbg !5256
  %7 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5257, !tbaa !657
  %8 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5258, !tbaa !657
  %9 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %8, i32 0, i32 5, !dbg !5259
  %10 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %9, i32 0, i32 0, !dbg !5258
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %7, %struct.saved_aws_linked_list_node* %10) #17, !dbg !5260
  %11 = load %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)*, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, align 4, !dbg !5261, !tbaa !657
  %12 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5262, !tbaa !657
  %13 = call %struct.aws_linked_list_node* %11(%struct.aws_linked_list_node* %12), !dbg !5263
  %14 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5264, !tbaa !657
  %15 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %14, i32 0, i32 5, !dbg !5265
  %16 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %15, i32 0, i32 1, !dbg !5264
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %13, %struct.saved_aws_linked_list_node* %16) #17, !dbg !5266
  %17 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5267, !tbaa !657
  %18 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %17, i32 0, i32 0, !dbg !5268
  store i32 2, i32* %18, align 4, !dbg !5269, !tbaa !4856
  ret void, !dbg !5270
}

; Function Attrs: nounwind ssp
define void @save_three_nodes(%struct.aws_linked_list_node* %0, %struct.saved_aws_linked_list* %1, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* %2) #0 !dbg !5271 {
  %4 = alloca %struct.aws_linked_list_node*, align 4
  %5 = alloca %struct.saved_aws_linked_list*, align 4
  %6 = alloca %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %4, metadata !5273, metadata !DIExpression()), !dbg !5276
  store %struct.saved_aws_linked_list* %1, %struct.saved_aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %5, metadata !5274, metadata !DIExpression()), !dbg !5277
  store %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* %2, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, metadata !5275, metadata !DIExpression()), !dbg !5278
  %7 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5279, !tbaa !657
  %8 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5280, !tbaa !657
  %9 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %8, i32 0, i32 5, !dbg !5281
  %10 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %9, i32 0, i32 0, !dbg !5280
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %7, %struct.saved_aws_linked_list_node* %10) #17, !dbg !5282
  %11 = load %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)*, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, align 4, !dbg !5283, !tbaa !657
  %12 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5284, !tbaa !657
  %13 = call %struct.aws_linked_list_node* %11(%struct.aws_linked_list_node* %12), !dbg !5285
  %14 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5286, !tbaa !657
  %15 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %14, i32 0, i32 5, !dbg !5287
  %16 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %15, i32 0, i32 1, !dbg !5286
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %13, %struct.saved_aws_linked_list_node* %16) #17, !dbg !5288
  %17 = load %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)*, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, align 4, !dbg !5289, !tbaa !657
  %18 = load %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)*, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)** %6, align 4, !dbg !5290, !tbaa !657
  %19 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5291, !tbaa !657
  %20 = call %struct.aws_linked_list_node* %18(%struct.aws_linked_list_node* %19), !dbg !5292
  %21 = call %struct.aws_linked_list_node* %17(%struct.aws_linked_list_node* %20), !dbg !5293
  %22 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5294, !tbaa !657
  %23 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %22, i32 0, i32 5, !dbg !5295
  %24 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %23, i32 0, i32 2, !dbg !5294
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %21, %struct.saved_aws_linked_list_node* %24) #17, !dbg !5296
  %25 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %5, align 4, !dbg !5297, !tbaa !657
  %26 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %25, i32 0, i32 0, !dbg !5298
  store i32 3, i32* %26, align 4, !dbg !5299, !tbaa !4856
  ret void, !dbg !5300
}

; Function Attrs: nounwind ssp
define void @aws_linked_list_save_to_tail(%struct.aws_linked_list* %0, i32 %1, %struct.aws_linked_list_node* %2, %struct.saved_aws_linked_list* %3) #0 !dbg !5301 {
  %5 = alloca %struct.aws_linked_list*, align 4
  %6 = alloca i32, align 4
  %7 = alloca %struct.aws_linked_list_node*, align 4
  %8 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %5, metadata !5305, metadata !DIExpression()), !dbg !5309
  store i32 %1, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !5306, metadata !DIExpression()), !dbg !5310
  store %struct.aws_linked_list_node* %2, %struct.aws_linked_list_node** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %7, metadata !5307, metadata !DIExpression()), !dbg !5311
  store %struct.saved_aws_linked_list* %3, %struct.saved_aws_linked_list** %8, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %8, metadata !5308, metadata !DIExpression()), !dbg !5312
  %9 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5313, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %9, i32 0, i32 0, !dbg !5314
  %11 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5315, !tbaa !657
  %12 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %11, i32 0, i32 3, !dbg !5316
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %10, %struct.saved_aws_linked_list_node* %12) #17, !dbg !5317
  %13 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5318, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %13, i32 0, i32 1, !dbg !5319
  %15 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5320, !tbaa !657
  %16 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %15, i32 0, i32 4, !dbg !5321
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %14, %struct.saved_aws_linked_list_node* %16) #17, !dbg !5322
  %17 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5323, !tbaa !657
  %18 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5324, !tbaa !657
  %19 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %18, i32 0, i32 1, !dbg !5325
  store %struct.aws_linked_list_node* %17, %struct.aws_linked_list_node** %19, align 4, !dbg !5326, !tbaa !4875
  %20 = load i32, i32* %6, align 4, !dbg !5327, !tbaa !663
  %21 = icmp eq i32 %20, 0, !dbg !5329
  br i1 %21, label %22, label %34, !dbg !5330

22:                                               ; preds = %4
  %23 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5331, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %23, i32 0, i32 0, !dbg !5334
  %25 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5335, !tbaa !657
  %26 = icmp eq %struct.aws_linked_list_node* %24, %25, !dbg !5336
  br i1 %26, label %27, label %30, !dbg !5337

27:                                               ; preds = %22
  %28 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5338, !tbaa !657
  %29 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5340, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %28, %struct.saved_aws_linked_list* %29) #17, !dbg !5341
  br label %33, !dbg !5342

30:                                               ; preds = %22
  %31 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5343, !tbaa !657
  %32 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %31, i32 0, i32 0, !dbg !5345
  store i32 0, i32* %32, align 4, !dbg !5346, !tbaa !4856
  br label %33

33:                                               ; preds = %30, %27
  br label %101, !dbg !5347

34:                                               ; preds = %4
  %35 = load i32, i32* %6, align 4, !dbg !5348, !tbaa !663
  %36 = icmp eq i32 %35, 1, !dbg !5350
  br i1 %36, label %37, label %60, !dbg !5351

37:                                               ; preds = %34
  %38 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5352, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %38, i32 0, i32 0, !dbg !5355
  %40 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5356, !tbaa !657
  %41 = icmp eq %struct.aws_linked_list_node* %39, %40, !dbg !5357
  br i1 %41, label %42, label %45, !dbg !5358

42:                                               ; preds = %37
  %43 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5359, !tbaa !657
  %44 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5361, !tbaa !657
  call void @save_two_nodes(%struct.aws_linked_list_node* %43, %struct.saved_aws_linked_list* %44, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getNext) #17, !dbg !5362
  br label %59, !dbg !5363

45:                                               ; preds = %37
  %46 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5364, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %46, i32 0, i32 0, !dbg !5366
  %48 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %47, i32 0, i32 0, !dbg !5367
  %49 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %48, align 4, !dbg !5367, !tbaa !5368
  %50 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5369, !tbaa !657
  %51 = icmp eq %struct.aws_linked_list_node* %49, %50, !dbg !5370
  br i1 %51, label %52, label %55, !dbg !5371

52:                                               ; preds = %45
  %53 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5372, !tbaa !657
  %54 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5374, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %53, %struct.saved_aws_linked_list* %54) #17, !dbg !5375
  br label %58, !dbg !5376

55:                                               ; preds = %45
  %56 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5377, !tbaa !657
  %57 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %56, i32 0, i32 0, !dbg !5379
  store i32 0, i32* %57, align 4, !dbg !5380, !tbaa !4856
  br label %58

58:                                               ; preds = %55, %52
  br label %59

59:                                               ; preds = %58, %42
  br label %100, !dbg !5381

60:                                               ; preds = %34
  %61 = load i32, i32* %6, align 4, !dbg !5382, !tbaa !663
  %62 = icmp ugt i32 %61, 1, !dbg !5384
  br i1 %62, label %63, label %99, !dbg !5385

63:                                               ; preds = %60
  %64 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5386, !tbaa !657
  %65 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %64, i32 0, i32 0, !dbg !5389
  %66 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5390, !tbaa !657
  %67 = icmp eq %struct.aws_linked_list_node* %65, %66, !dbg !5391
  br i1 %67, label %68, label %71, !dbg !5392

68:                                               ; preds = %63
  %69 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5393, !tbaa !657
  %70 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5395, !tbaa !657
  call void @save_three_nodes(%struct.aws_linked_list_node* %69, %struct.saved_aws_linked_list* %70, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getNext) #17, !dbg !5396
  br label %98, !dbg !5397

71:                                               ; preds = %63
  %72 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5398, !tbaa !657
  %73 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %72, i32 0, i32 0, !dbg !5400
  %74 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %73, i32 0, i32 0, !dbg !5401
  %75 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %74, align 4, !dbg !5401, !tbaa !5368
  %76 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5402, !tbaa !657
  %77 = icmp eq %struct.aws_linked_list_node* %75, %76, !dbg !5403
  br i1 %77, label %78, label %81, !dbg !5404

78:                                               ; preds = %71
  %79 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5405, !tbaa !657
  %80 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5407, !tbaa !657
  call void @save_two_nodes(%struct.aws_linked_list_node* %79, %struct.saved_aws_linked_list* %80, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getNext) #17, !dbg !5408
  br label %97, !dbg !5409

81:                                               ; preds = %71
  %82 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5410, !tbaa !657
  %83 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %82, i32 0, i32 0, !dbg !5412
  %84 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %83, i32 0, i32 0, !dbg !5413
  %85 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %84, align 4, !dbg !5413, !tbaa !5368
  %86 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %85, i32 0, i32 0, !dbg !5414
  %87 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %86, align 4, !dbg !5414, !tbaa !4440
  %88 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5415, !tbaa !657
  %89 = icmp eq %struct.aws_linked_list_node* %87, %88, !dbg !5416
  br i1 %89, label %90, label %93, !dbg !5417

90:                                               ; preds = %81
  %91 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5418, !tbaa !657
  %92 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5420, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %91, %struct.saved_aws_linked_list* %92) #17, !dbg !5421
  br label %96, !dbg !5422

93:                                               ; preds = %81
  %94 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5423, !tbaa !657
  %95 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %94, i32 0, i32 0, !dbg !5425
  store i32 0, i32* %95, align 4, !dbg !5426, !tbaa !4856
  br label %96

96:                                               ; preds = %93, %90
  br label %97

97:                                               ; preds = %96, %78
  br label %98

98:                                               ; preds = %97, %68
  br label %99, !dbg !5427

99:                                               ; preds = %98, %60
  br label %100

100:                                              ; preds = %99, %59
  br label %101

101:                                              ; preds = %100, %33
  ret void, !dbg !5428
}

; Function Attrs: nounwind ssp
define void @aws_linked_list_save_to_head(%struct.aws_linked_list* %0, i32 %1, %struct.aws_linked_list_node* %2, %struct.saved_aws_linked_list* %3) #0 !dbg !5429 {
  %5 = alloca %struct.aws_linked_list*, align 4
  %6 = alloca i32, align 4
  %7 = alloca %struct.aws_linked_list_node*, align 4
  %8 = alloca %struct.saved_aws_linked_list*, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %5, metadata !5431, metadata !DIExpression()), !dbg !5435
  store i32 %1, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !5432, metadata !DIExpression()), !dbg !5436
  store %struct.aws_linked_list_node* %2, %struct.aws_linked_list_node** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %7, metadata !5433, metadata !DIExpression()), !dbg !5437
  store %struct.saved_aws_linked_list* %3, %struct.saved_aws_linked_list** %8, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %8, metadata !5434, metadata !DIExpression()), !dbg !5438
  %9 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5439, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %9, i32 0, i32 0, !dbg !5440
  %11 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5441, !tbaa !657
  %12 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %11, i32 0, i32 3, !dbg !5442
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %10, %struct.saved_aws_linked_list_node* %12) #17, !dbg !5443
  %13 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5444, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %13, i32 0, i32 1, !dbg !5445
  %15 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5446, !tbaa !657
  %16 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %15, i32 0, i32 4, !dbg !5447
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %14, %struct.saved_aws_linked_list_node* %16) #17, !dbg !5448
  %17 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5449, !tbaa !657
  %18 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5450, !tbaa !657
  %19 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %18, i32 0, i32 1, !dbg !5451
  store %struct.aws_linked_list_node* %17, %struct.aws_linked_list_node** %19, align 4, !dbg !5452, !tbaa !4875
  %20 = load i32, i32* %6, align 4, !dbg !5453, !tbaa !663
  %21 = icmp eq i32 %20, 0, !dbg !5455
  br i1 %21, label %22, label %34, !dbg !5456

22:                                               ; preds = %4
  %23 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5457, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %23, i32 0, i32 1, !dbg !5460
  %25 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5461, !tbaa !657
  %26 = icmp eq %struct.aws_linked_list_node* %24, %25, !dbg !5462
  br i1 %26, label %27, label %30, !dbg !5463

27:                                               ; preds = %22
  %28 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5464, !tbaa !657
  %29 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5466, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %28, %struct.saved_aws_linked_list* %29) #17, !dbg !5467
  br label %33, !dbg !5468

30:                                               ; preds = %22
  %31 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5469, !tbaa !657
  %32 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %31, i32 0, i32 0, !dbg !5471
  store i32 0, i32* %32, align 4, !dbg !5472, !tbaa !4856
  br label %33

33:                                               ; preds = %30, %27
  br label %101, !dbg !5473

34:                                               ; preds = %4
  %35 = load i32, i32* %6, align 4, !dbg !5474, !tbaa !663
  %36 = icmp eq i32 %35, 1, !dbg !5476
  br i1 %36, label %37, label %60, !dbg !5477

37:                                               ; preds = %34
  %38 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5478, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %38, i32 0, i32 1, !dbg !5481
  %40 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5482, !tbaa !657
  %41 = icmp eq %struct.aws_linked_list_node* %39, %40, !dbg !5483
  br i1 %41, label %42, label %45, !dbg !5484

42:                                               ; preds = %37
  %43 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5485, !tbaa !657
  %44 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5487, !tbaa !657
  call void @save_two_nodes(%struct.aws_linked_list_node* %43, %struct.saved_aws_linked_list* %44, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getPrev) #17, !dbg !5488
  br label %59, !dbg !5489

45:                                               ; preds = %37
  %46 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5490, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %46, i32 0, i32 1, !dbg !5492
  %48 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %47, i32 0, i32 1, !dbg !5493
  %49 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %48, align 4, !dbg !5493, !tbaa !5494
  %50 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5495, !tbaa !657
  %51 = icmp eq %struct.aws_linked_list_node* %49, %50, !dbg !5496
  br i1 %51, label %52, label %55, !dbg !5497

52:                                               ; preds = %45
  %53 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5498, !tbaa !657
  %54 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5500, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %53, %struct.saved_aws_linked_list* %54) #17, !dbg !5501
  br label %58, !dbg !5502

55:                                               ; preds = %45
  %56 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5503, !tbaa !657
  %57 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %56, i32 0, i32 0, !dbg !5505
  store i32 0, i32* %57, align 4, !dbg !5506, !tbaa !4856
  br label %58

58:                                               ; preds = %55, %52
  br label %59

59:                                               ; preds = %58, %42
  br label %100, !dbg !5507

60:                                               ; preds = %34
  %61 = load i32, i32* %6, align 4, !dbg !5508, !tbaa !663
  %62 = icmp ugt i32 %61, 1, !dbg !5510
  br i1 %62, label %63, label %99, !dbg !5511

63:                                               ; preds = %60
  %64 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5512, !tbaa !657
  %65 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %64, i32 0, i32 1, !dbg !5515
  %66 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5516, !tbaa !657
  %67 = icmp eq %struct.aws_linked_list_node* %65, %66, !dbg !5517
  br i1 %67, label %68, label %71, !dbg !5518

68:                                               ; preds = %63
  %69 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5519, !tbaa !657
  %70 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5521, !tbaa !657
  call void @save_three_nodes(%struct.aws_linked_list_node* %69, %struct.saved_aws_linked_list* %70, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getPrev) #17, !dbg !5522
  br label %98, !dbg !5523

71:                                               ; preds = %63
  %72 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5524, !tbaa !657
  %73 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %72, i32 0, i32 1, !dbg !5526
  %74 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %73, i32 0, i32 1, !dbg !5527
  %75 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %74, align 4, !dbg !5527, !tbaa !5494
  %76 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5528, !tbaa !657
  %77 = icmp eq %struct.aws_linked_list_node* %75, %76, !dbg !5529
  br i1 %77, label %78, label %81, !dbg !5530

78:                                               ; preds = %71
  %79 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5531, !tbaa !657
  %80 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5533, !tbaa !657
  call void @save_two_nodes(%struct.aws_linked_list_node* %79, %struct.saved_aws_linked_list* %80, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getPrev) #17, !dbg !5534
  br label %97, !dbg !5535

81:                                               ; preds = %71
  %82 = load %struct.aws_linked_list*, %struct.aws_linked_list** %5, align 4, !dbg !5536, !tbaa !657
  %83 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %82, i32 0, i32 1, !dbg !5538
  %84 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %83, i32 0, i32 1, !dbg !5539
  %85 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %84, align 4, !dbg !5539, !tbaa !5494
  %86 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %85, i32 0, i32 1, !dbg !5540
  %87 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %86, align 4, !dbg !5540, !tbaa !4445
  %88 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5541, !tbaa !657
  %89 = icmp eq %struct.aws_linked_list_node* %87, %88, !dbg !5542
  br i1 %89, label %90, label %93, !dbg !5543

90:                                               ; preds = %81
  %91 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %7, align 4, !dbg !5544, !tbaa !657
  %92 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5546, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %91, %struct.saved_aws_linked_list* %92) #17, !dbg !5547
  br label %96, !dbg !5548

93:                                               ; preds = %81
  %94 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %8, align 4, !dbg !5549, !tbaa !657
  %95 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %94, i32 0, i32 0, !dbg !5551
  store i32 0, i32* %95, align 4, !dbg !5552, !tbaa !4856
  br label %96

96:                                               ; preds = %93, %90
  br label %97

97:                                               ; preds = %96, %78
  br label %98

98:                                               ; preds = %97, %68
  br label %99, !dbg !5553

99:                                               ; preds = %98, %60
  br label %100

100:                                              ; preds = %99, %59
  br label %101

101:                                              ; preds = %100, %33
  ret void, !dbg !5554
}

; Function Attrs: nounwind ssp
define void @aws_linked_list_save_full(%struct.aws_linked_list* %0, i32 %1, %struct.aws_linked_list_node* %2, %struct.aws_linked_list_node* %3, %struct.saved_aws_linked_list* %4) #0 !dbg !5555 {
  %6 = alloca %struct.aws_linked_list*, align 4
  %7 = alloca i32, align 4
  %8 = alloca %struct.aws_linked_list_node*, align 4
  %9 = alloca %struct.aws_linked_list_node*, align 4
  %10 = alloca %struct.saved_aws_linked_list*, align 4
  %11 = alloca i32, align 4
  %12 = alloca i32, align 4
  store %struct.aws_linked_list* %0, %struct.aws_linked_list** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list** %6, metadata !5559, metadata !DIExpression()), !dbg !5571
  store i32 %1, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !5560, metadata !DIExpression()), !dbg !5572
  store %struct.aws_linked_list_node* %2, %struct.aws_linked_list_node** %8, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %8, metadata !5561, metadata !DIExpression()), !dbg !5573
  store %struct.aws_linked_list_node* %3, %struct.aws_linked_list_node** %9, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %9, metadata !5562, metadata !DIExpression()), !dbg !5574
  store %struct.saved_aws_linked_list* %4, %struct.saved_aws_linked_list** %10, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.saved_aws_linked_list** %10, metadata !5563, metadata !DIExpression()), !dbg !5575
  %13 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5576, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %13, i32 0, i32 0, !dbg !5577
  %15 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5578, !tbaa !657
  %16 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %15, i32 0, i32 3, !dbg !5579
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %14, %struct.saved_aws_linked_list_node* %16) #17, !dbg !5580
  %17 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5581, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %17, i32 0, i32 1, !dbg !5582
  %19 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5583, !tbaa !657
  %20 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %19, i32 0, i32 4, !dbg !5584
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %18, %struct.saved_aws_linked_list_node* %20) #17, !dbg !5585
  %21 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5586, !tbaa !657
  %22 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5587, !tbaa !657
  %23 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %22, i32 0, i32 1, !dbg !5588
  store %struct.aws_linked_list_node* %21, %struct.aws_linked_list_node** %23, align 4, !dbg !5589, !tbaa !4875
  %24 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !5590, !tbaa !657
  %25 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5591, !tbaa !657
  %26 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %25, i32 0, i32 2, !dbg !5592
  store %struct.aws_linked_list_node* %24, %struct.aws_linked_list_node** %26, align 4, !dbg !5593, !tbaa !5093
  %27 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5594, !tbaa !657
  %28 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !5596, !tbaa !657
  %29 = icmp eq %struct.aws_linked_list_node* %27, %28, !dbg !5597
  br i1 %29, label %30, label %33, !dbg !5598

30:                                               ; preds = %5
  %31 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5599, !tbaa !657
  %32 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5601, !tbaa !657
  call void @save_one_node(%struct.aws_linked_list_node* %31, %struct.saved_aws_linked_list* %32) #17, !dbg !5602
  br label %199, !dbg !5603

33:                                               ; preds = %5
  %34 = load i32, i32* %7, align 4, !dbg !5604, !tbaa !663
  %35 = icmp eq i32 %34, 0, !dbg !5605
  br i1 %35, label %36, label %48, !dbg !5606

36:                                               ; preds = %33
  %37 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5607, !tbaa !657
  %38 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5610, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %38, i32 0, i32 0, !dbg !5611
  %40 = icmp eq %struct.aws_linked_list_node* %37, %39, !dbg !5612
  br i1 %40, label %41, label %44, !dbg !5613

41:                                               ; preds = %36
  %42 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5614, !tbaa !657
  %43 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5616, !tbaa !657
  call void @save_two_nodes(%struct.aws_linked_list_node* %42, %struct.saved_aws_linked_list* %43, %struct.aws_linked_list_node* (%struct.aws_linked_list_node*)* @getNext) #17, !dbg !5617
  br label %47, !dbg !5618

44:                                               ; preds = %36
  %45 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5619, !tbaa !657
  %46 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %45, i32 0, i32 0, !dbg !5621
  store i32 0, i32* %46, align 4, !dbg !5622, !tbaa !4856
  br label %47

47:                                               ; preds = %44, %41
  br label %199, !dbg !5623

48:                                               ; preds = %33
  %49 = load i32, i32* %7, align 4, !dbg !5624, !tbaa !663
  %50 = icmp eq i32 %49, 1, !dbg !5625
  br i1 %50, label %51, label %107, !dbg !5626

51:                                               ; preds = %48
  %52 = bitcast i32* %11 to i8*, !dbg !5627
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %52) #19, !dbg !5627
  call void @llvm.dbg.declare(metadata i32* %11, metadata !5564, metadata !DIExpression()), !dbg !5628
  store i32 0, i32* %11, align 4, !dbg !5628, !tbaa !663
  %53 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5629, !tbaa !657
  %54 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5631, !tbaa !657
  %55 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %54, i32 0, i32 0, !dbg !5632
  %56 = icmp eq %struct.aws_linked_list_node* %53, %55, !dbg !5633
  br i1 %56, label %57, label %72, !dbg !5634

57:                                               ; preds = %51
  %58 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5635, !tbaa !657
  %59 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %58, i32 0, i32 0, !dbg !5637
  %60 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5638, !tbaa !657
  %61 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %60, i32 0, i32 5, !dbg !5639
  %62 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %61, i32 0, i32 0, !dbg !5638
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %59, %struct.saved_aws_linked_list_node* %62) #17, !dbg !5640
  %63 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5641, !tbaa !657
  %64 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %63, i32 0, i32 0, !dbg !5642
  %65 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %64, i32 0, i32 0, !dbg !5643
  %66 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %65, align 4, !dbg !5643, !tbaa !5368
  %67 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5644, !tbaa !657
  %68 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %67, i32 0, i32 5, !dbg !5645
  %69 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %68, i32 0, i32 1, !dbg !5644
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %66, %struct.saved_aws_linked_list_node* %69) #17, !dbg !5646
  %70 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5647, !tbaa !657
  %71 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %70, i32 0, i32 0, !dbg !5648
  store i32 2, i32* %71, align 4, !dbg !5649, !tbaa !4856
  store i32 2, i32* %11, align 4, !dbg !5650, !tbaa !663
  br label %90, !dbg !5651

72:                                               ; preds = %51
  %73 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5652, !tbaa !657
  %74 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5654, !tbaa !657
  %75 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %74, i32 0, i32 0, !dbg !5655
  %76 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %75, i32 0, i32 0, !dbg !5656
  %77 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %76, align 4, !dbg !5656, !tbaa !5368
  %78 = icmp eq %struct.aws_linked_list_node* %73, %77, !dbg !5657
  br i1 %78, label %79, label %89, !dbg !5658

79:                                               ; preds = %72
  %80 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5659, !tbaa !657
  %81 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %80, i32 0, i32 0, !dbg !5661
  %82 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %81, i32 0, i32 0, !dbg !5662
  %83 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %82, align 4, !dbg !5662, !tbaa !5368
  %84 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5663, !tbaa !657
  %85 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %84, i32 0, i32 5, !dbg !5664
  %86 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %85, i32 0, i32 0, !dbg !5663
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %83, %struct.saved_aws_linked_list_node* %86) #17, !dbg !5665
  %87 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5666, !tbaa !657
  %88 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %87, i32 0, i32 0, !dbg !5667
  store i32 1, i32* %88, align 4, !dbg !5668, !tbaa !4856
  store i32 1, i32* %11, align 4, !dbg !5669, !tbaa !663
  br label %89, !dbg !5670

89:                                               ; preds = %79, %72
  br label %90

90:                                               ; preds = %89, %57
  %91 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !5671, !tbaa !657
  %92 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5673, !tbaa !657
  %93 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %92, i32 0, i32 1, !dbg !5674
  %94 = icmp eq %struct.aws_linked_list_node* %91, %93, !dbg !5675
  br i1 %94, label %95, label %105, !dbg !5676

95:                                               ; preds = %90
  %96 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !5677, !tbaa !657
  %97 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5679, !tbaa !657
  %98 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %97, i32 0, i32 5, !dbg !5680
  %99 = load i32, i32* %11, align 4, !dbg !5681, !tbaa !663
  %100 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %98, i32 0, i32 %99, !dbg !5679
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %96, %struct.saved_aws_linked_list_node* %100) #17, !dbg !5682
  %101 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5683, !tbaa !657
  %102 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %101, i32 0, i32 0, !dbg !5684
  %103 = load i32, i32* %102, align 4, !dbg !5685, !tbaa !4856
  %104 = add i32 %103, 1, !dbg !5685
  store i32 %104, i32* %102, align 4, !dbg !5685, !tbaa !4856
  br label %105, !dbg !5686

105:                                              ; preds = %95, %90
  %106 = bitcast i32* %11 to i8*, !dbg !5687
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %106) #19, !dbg !5687
  br label %198, !dbg !5688

107:                                              ; preds = %48
  %108 = load i32, i32* %7, align 4, !dbg !5689, !tbaa !663
  %109 = icmp ugt i32 %108, 1, !dbg !5690
  br i1 %109, label %110, label %197, !dbg !5691

110:                                              ; preds = %107
  %111 = bitcast i32* %12 to i8*, !dbg !5692
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %111) #19, !dbg !5692
  call void @llvm.dbg.declare(metadata i32* %12, metadata !5568, metadata !DIExpression()), !dbg !5693
  store i32 0, i32* %12, align 4, !dbg !5693, !tbaa !663
  %112 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5694, !tbaa !657
  %113 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5696, !tbaa !657
  %114 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %113, i32 0, i32 0, !dbg !5697
  %115 = icmp eq %struct.aws_linked_list_node* %112, %114, !dbg !5698
  br i1 %115, label %116, label %131, !dbg !5699

116:                                              ; preds = %110
  %117 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5700, !tbaa !657
  %118 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %117, i32 0, i32 0, !dbg !5702
  %119 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5703, !tbaa !657
  %120 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %119, i32 0, i32 5, !dbg !5704
  %121 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %120, i32 0, i32 0, !dbg !5703
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %118, %struct.saved_aws_linked_list_node* %121) #17, !dbg !5705
  %122 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5706, !tbaa !657
  %123 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %122, i32 0, i32 0, !dbg !5707
  %124 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %123, i32 0, i32 0, !dbg !5708
  %125 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %124, align 4, !dbg !5708, !tbaa !5368
  %126 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5709, !tbaa !657
  %127 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %126, i32 0, i32 5, !dbg !5710
  %128 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %127, i32 0, i32 1, !dbg !5709
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %125, %struct.saved_aws_linked_list_node* %128) #17, !dbg !5711
  %129 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5712, !tbaa !657
  %130 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %129, i32 0, i32 0, !dbg !5713
  store i32 2, i32* %130, align 4, !dbg !5714, !tbaa !4856
  store i32 2, i32* %12, align 4, !dbg !5715, !tbaa !663
  br label %149, !dbg !5716

131:                                              ; preds = %110
  %132 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %8, align 4, !dbg !5717, !tbaa !657
  %133 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5719, !tbaa !657
  %134 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %133, i32 0, i32 0, !dbg !5720
  %135 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %134, i32 0, i32 0, !dbg !5721
  %136 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %135, align 4, !dbg !5721, !tbaa !5368
  %137 = icmp eq %struct.aws_linked_list_node* %132, %136, !dbg !5722
  br i1 %137, label %138, label %148, !dbg !5723

138:                                              ; preds = %131
  %139 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5724, !tbaa !657
  %140 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %139, i32 0, i32 0, !dbg !5726
  %141 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %140, i32 0, i32 0, !dbg !5727
  %142 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %141, align 4, !dbg !5727, !tbaa !5368
  %143 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5728, !tbaa !657
  %144 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %143, i32 0, i32 5, !dbg !5729
  %145 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %144, i32 0, i32 0, !dbg !5728
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %142, %struct.saved_aws_linked_list_node* %145) #17, !dbg !5730
  %146 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5731, !tbaa !657
  %147 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %146, i32 0, i32 0, !dbg !5732
  store i32 1, i32* %147, align 4, !dbg !5733, !tbaa !4856
  store i32 1, i32* %12, align 4, !dbg !5734, !tbaa !663
  br label %148, !dbg !5735

148:                                              ; preds = %138, %131
  br label %149

149:                                              ; preds = %148, %116
  %150 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !5736, !tbaa !657
  %151 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5738, !tbaa !657
  %152 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %151, i32 0, i32 1, !dbg !5739
  %153 = icmp eq %struct.aws_linked_list_node* %150, %152, !dbg !5740
  br i1 %153, label %154, label %174, !dbg !5741

154:                                              ; preds = %149
  %155 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5742, !tbaa !657
  %156 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %155, i32 0, i32 1, !dbg !5744
  %157 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %156, i32 0, i32 1, !dbg !5745
  %158 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %157, align 4, !dbg !5745, !tbaa !5494
  %159 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5746, !tbaa !657
  %160 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %159, i32 0, i32 5, !dbg !5747
  %161 = load i32, i32* %12, align 4, !dbg !5748, !tbaa !663
  %162 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %160, i32 0, i32 %161, !dbg !5746
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %158, %struct.saved_aws_linked_list_node* %162) #17, !dbg !5749
  %163 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5750, !tbaa !657
  %164 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %163, i32 0, i32 1, !dbg !5751
  %165 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5752, !tbaa !657
  %166 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %165, i32 0, i32 5, !dbg !5753
  %167 = load i32, i32* %12, align 4, !dbg !5754, !tbaa !663
  %168 = add i32 %167, 1, !dbg !5755
  %169 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %166, i32 0, i32 %168, !dbg !5752
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %164, %struct.saved_aws_linked_list_node* %169) #17, !dbg !5756
  %170 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5757, !tbaa !657
  %171 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %170, i32 0, i32 0, !dbg !5758
  %172 = load i32, i32* %171, align 4, !dbg !5759, !tbaa !4856
  %173 = add i32 %172, 2, !dbg !5759
  store i32 %173, i32* %171, align 4, !dbg !5759, !tbaa !4856
  br label %195, !dbg !5760

174:                                              ; preds = %149
  %175 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %9, align 4, !dbg !5761, !tbaa !657
  %176 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5763, !tbaa !657
  %177 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %176, i32 0, i32 1, !dbg !5764
  %178 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %177, i32 0, i32 1, !dbg !5765
  %179 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %178, align 4, !dbg !5765, !tbaa !5494
  %180 = icmp eq %struct.aws_linked_list_node* %175, %179, !dbg !5766
  br i1 %180, label %181, label %194, !dbg !5767

181:                                              ; preds = %174
  %182 = load %struct.aws_linked_list*, %struct.aws_linked_list** %6, align 4, !dbg !5768, !tbaa !657
  %183 = getelementptr inbounds %struct.aws_linked_list, %struct.aws_linked_list* %182, i32 0, i32 1, !dbg !5770
  %184 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %183, i32 0, i32 1, !dbg !5771
  %185 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %184, align 4, !dbg !5771, !tbaa !5494
  %186 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5772, !tbaa !657
  %187 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %186, i32 0, i32 5, !dbg !5773
  %188 = load i32, i32* %12, align 4, !dbg !5774, !tbaa !663
  %189 = getelementptr inbounds [4 x %struct.saved_aws_linked_list_node], [4 x %struct.saved_aws_linked_list_node]* %187, i32 0, i32 %188, !dbg !5772
  call void @sea_save_aws_node_to_sea_node(%struct.aws_linked_list_node* %185, %struct.saved_aws_linked_list_node* %189) #17, !dbg !5775
  %190 = load %struct.saved_aws_linked_list*, %struct.saved_aws_linked_list** %10, align 4, !dbg !5776, !tbaa !657
  %191 = getelementptr inbounds %struct.saved_aws_linked_list, %struct.saved_aws_linked_list* %190, i32 0, i32 0, !dbg !5777
  %192 = load i32, i32* %191, align 4, !dbg !5778, !tbaa !4856
  %193 = add i32 %192, 1, !dbg !5778
  store i32 %193, i32* %191, align 4, !dbg !5778, !tbaa !4856
  br label %194, !dbg !5779

194:                                              ; preds = %181, %174
  br label %195

195:                                              ; preds = %194, %154
  %196 = bitcast i32* %12 to i8*, !dbg !5780
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %196) #19, !dbg !5780
  br label %197, !dbg !5781

197:                                              ; preds = %195, %107
  br label %198

198:                                              ; preds = %197, %105
  br label %199

199:                                              ; preds = %198, %47, %30
  ret void, !dbg !5782
}

; Function Attrs: nounwind ssp
define zeroext i1 @is_aws_linked_list_node_attached_after(%struct.aws_linked_list_node* %0, %struct.aws_linked_list_node* %1) #0 !dbg !5783 {
  %3 = alloca %struct.aws_linked_list_node*, align 4
  %4 = alloca %struct.aws_linked_list_node*, align 4
  store %struct.aws_linked_list_node* %0, %struct.aws_linked_list_node** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %3, metadata !5787, metadata !DIExpression()), !dbg !5789
  store %struct.aws_linked_list_node* %1, %struct.aws_linked_list_node** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_linked_list_node** %4, metadata !5788, metadata !DIExpression()), !dbg !5790
  %5 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !5791, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %5, i32 0, i32 0, !dbg !5792
  %7 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %6, align 4, !dbg !5792, !tbaa !4440
  %8 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5793, !tbaa !657
  %9 = icmp eq %struct.aws_linked_list_node* %7, %8, !dbg !5794
  br i1 %9, label %10, label %16, !dbg !5795

10:                                               ; preds = %2
  %11 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %4, align 4, !dbg !5796, !tbaa !657
  %12 = getelementptr inbounds %struct.aws_linked_list_node, %struct.aws_linked_list_node* %11, i32 0, i32 1, !dbg !5797
  %13 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %12, align 4, !dbg !5797, !tbaa !4445
  %14 = load %struct.aws_linked_list_node*, %struct.aws_linked_list_node** %3, align 4, !dbg !5798, !tbaa !657
  %15 = icmp eq %struct.aws_linked_list_node* %13, %14, !dbg !5799
  br label %16

16:                                               ; preds = %10, %2
  %17 = phi i1 [ false, %2 ], [ %15, %10 ], !dbg !5800
  ret i1 %17, !dbg !5801
}

; Function Attrs: nounwind ssp
define %struct.aws_string* @ensure_string_is_allocated(i32 %0) #0 !dbg !5802 {
  %2 = alloca i32, align 4
  %3 = alloca %struct.aws_string*, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !5819, metadata !DIExpression()), !dbg !5821
  %4 = bitcast %struct.aws_string** %3 to i8*, !dbg !5822
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !5822
  call void @llvm.dbg.declare(metadata %struct.aws_string** %3, metadata !5820, metadata !DIExpression()), !dbg !5823
  %5 = load i32, i32* %2, align 4, !dbg !5824, !tbaa !663
  %6 = add i32 12, %5, !dbg !5825
  %7 = add i32 %6, 1, !dbg !5826
  %8 = call i8* @sea_malloc_havoc_safe(i32 %7) #17, !dbg !5827
  %9 = bitcast i8* %8 to %struct.aws_string*, !dbg !5827
  store %struct.aws_string* %9, %struct.aws_string** %3, align 4, !dbg !5823, !tbaa !657
  %10 = load %struct.aws_string*, %struct.aws_string** %3, align 4, !dbg !5828, !tbaa !657
  %11 = icmp ne %struct.aws_string* %10, null, !dbg !5828
  br i1 %11, label %12, label %23, !dbg !5830

12:                                               ; preds = %1
  %13 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !5831
  %14 = load %struct.aws_string*, %struct.aws_string** %3, align 4, !dbg !5833, !tbaa !657
  %15 = getelementptr inbounds %struct.aws_string, %struct.aws_string* %14, i32 0, i32 0, !dbg !5834
  store %struct.aws_allocator* %13, %struct.aws_allocator** %15, align 4, !dbg !5835, !tbaa !657
  %16 = load i32, i32* %2, align 4, !dbg !5836, !tbaa !663
  %17 = load %struct.aws_string*, %struct.aws_string** %3, align 4, !dbg !5837, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_string, %struct.aws_string* %17, i32 0, i32 1, !dbg !5838
  store i32 %16, i32* %18, align 4, !dbg !5839, !tbaa !663
  %19 = load %struct.aws_string*, %struct.aws_string** %3, align 4, !dbg !5840, !tbaa !657
  %20 = getelementptr inbounds %struct.aws_string, %struct.aws_string* %19, i32 0, i32 2, !dbg !5841
  %21 = load i32, i32* %2, align 4, !dbg !5842, !tbaa !663
  %22 = getelementptr inbounds [1 x i8], [1 x i8]* %20, i32 0, i32 %21, !dbg !5840
  store i8 0, i8* %22, align 1, !dbg !5843, !tbaa !1034
  br label %23, !dbg !5844

23:                                               ; preds = %12, %1
  %24 = load %struct.aws_string*, %struct.aws_string** %3, align 4, !dbg !5845, !tbaa !657
  %25 = bitcast %struct.aws_string** %3 to i8*, !dbg !5846
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %25) #19, !dbg !5846
  ret %struct.aws_string* %24, !dbg !5847
}

; Function Attrs: nounwind ssp
define %struct.aws_string* @ensure_string_is_allocated_bounded_length(i32 %0) #0 !dbg !5848 {
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !5850, metadata !DIExpression()), !dbg !5852
  %4 = bitcast i32* %3 to i8*, !dbg !5853
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !5853
  call void @llvm.dbg.declare(metadata i32* %3, metadata !5851, metadata !DIExpression()), !dbg !5854
  %5 = call i32 @nd_size_t() #21, !dbg !5855
  store i32 %5, i32* %3, align 4, !dbg !5854, !tbaa !663
  %6 = load i32, i32* %3, align 4, !dbg !5856, !tbaa !663
  %7 = icmp ugt i32 %6, 0, !dbg !5857
  call void @__SEA_assume(i1 zeroext %7) #17, !dbg !5858
  %8 = load i32, i32* %3, align 4, !dbg !5859, !tbaa !663
  %9 = load i32, i32* %2, align 4, !dbg !5860, !tbaa !663
  %10 = icmp ult i32 %8, %9, !dbg !5861
  call void @__SEA_assume(i1 zeroext %10) #17, !dbg !5862
  %11 = load i32, i32* %3, align 4, !dbg !5863, !tbaa !663
  %12 = call %struct.aws_string* @ensure_string_is_allocated(i32 %11) #17, !dbg !5864
  %13 = bitcast i32* %3 to i8*, !dbg !5865
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %13) #19, !dbg !5865
  ret %struct.aws_string* %12, !dbg !5866
}

; Function Attrs: nounwind ssp
define %struct.aws_string* @ensure_string_is_allocated_nondet_length() #0 !dbg !5867 {
  %1 = call %struct.aws_string* @ensure_string_is_allocated_bounded_length(i32 -14) #17, !dbg !5870
  ret %struct.aws_string* %1, !dbg !5871
}

; Function Attrs: nounwind ssp
define i8* @ensure_c_str_is_nd_allocated(i32 %0, i32* %1) #0 !dbg !5872 {
  %3 = alloca i32, align 4
  %4 = alloca i32*, align 4
  store i32 %0, i32* %3, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %3, metadata !5876, metadata !DIExpression()), !dbg !5878
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !5877, metadata !DIExpression()), !dbg !5879
  %5 = load i32, i32* %3, align 4, !dbg !5880, !tbaa !663
  %6 = load i32*, i32** %4, align 4, !dbg !5881, !tbaa !657
  %7 = call i8* @_ensure_c_str_is_nd_allocated(i32 %5, i32* %6, i1 zeroext false) #17, !dbg !5882
  ret i8* %7, !dbg !5883
}

; Function Attrs: nounwind ssp
define internal i8* @_ensure_c_str_is_nd_allocated(i32 %0, i32* %1, i1 zeroext %2) #0 !dbg !5884 {
  %4 = alloca i8*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32*, align 4
  %7 = alloca i8, align 1
  %8 = alloca i32, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i32, align 4
  store i32 %0, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !5888, metadata !DIExpression()), !dbg !5894
  store i32* %1, i32** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %6, metadata !5889, metadata !DIExpression()), !dbg !5895
  %11 = zext i1 %2 to i8
  store i8 %11, i8* %7, align 1, !tbaa !844
  call void @llvm.dbg.declare(metadata i8* %7, metadata !5890, metadata !DIExpression()), !dbg !5896
  %12 = bitcast i32* %8 to i8*, !dbg !5897
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !5897
  call void @llvm.dbg.declare(metadata i32* %8, metadata !5891, metadata !DIExpression()), !dbg !5898
  %13 = call i32 @nd_size_t() #21, !dbg !5899
  store i32 %13, i32* %8, align 4, !dbg !5900, !tbaa !663
  %14 = load i32, i32* %8, align 4, !dbg !5901, !tbaa !663
  %15 = icmp ugt i32 %14, 0, !dbg !5902
  call void @__SEA_assume(i1 zeroext %15) #17, !dbg !5903
  %16 = load i32, i32* %8, align 4, !dbg !5904, !tbaa !663
  %17 = load i32, i32* %5, align 4, !dbg !5905, !tbaa !663
  %18 = icmp ule i32 %16, %17, !dbg !5906
  call void @__SEA_assume(i1 zeroext %18) #17, !dbg !5907
  %19 = load i32, i32* %5, align 4, !dbg !5908, !tbaa !663
  %20 = call i32 @sea_max_string_len() #17, !dbg !5909
  %21 = icmp ule i32 %19, %20, !dbg !5910
  call void @__SEA_assume(i1 zeroext %21) #17, !dbg !5911
  %22 = bitcast i8** %9 to i8*, !dbg !5912
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %22) #19, !dbg !5912
  call void @llvm.dbg.declare(metadata i8** %9, metadata !5892, metadata !DIExpression()), !dbg !5913
  %23 = load i8, i8* %7, align 1, !dbg !5914, !tbaa !844, !range !849
  %24 = trunc i8 %23 to i1, !dbg !5914
  br i1 %24, label %25, label %28, !dbg !5916

25:                                               ; preds = %3
  %26 = load i32, i32* %8, align 4, !dbg !5917, !tbaa !663
  %27 = call i8* @sea_malloc_havoc_safe(i32 %26) #17, !dbg !5919
  store i8* %27, i8** %9, align 4, !dbg !5920, !tbaa !657
  br label %35, !dbg !5921

28:                                               ; preds = %3
  %29 = load i32, i32* %8, align 4, !dbg !5922, !tbaa !663
  %30 = call i8* @sea_malloc_havoc(i32 %29) #17, !dbg !5924
  store i8* %30, i8** %9, align 4, !dbg !5925, !tbaa !657
  %31 = load i8*, i8** %9, align 4, !dbg !5926, !tbaa !657
  %32 = icmp ne i8* %31, null, !dbg !5926
  br i1 %32, label %34, label %33, !dbg !5928

33:                                               ; preds = %28
  store i8* null, i8** %4, align 4, !dbg !5929
  store i32 1, i32* %10, align 4
  br label %43, !dbg !5929

34:                                               ; preds = %28
  br label %35

35:                                               ; preds = %34, %25
  %36 = load i8*, i8** %9, align 4, !dbg !5931, !tbaa !657
  %37 = load i32, i32* %8, align 4, !dbg !5932, !tbaa !663
  %38 = sub i32 %37, 1, !dbg !5933
  call void @sea_init_str(i8* %36, i32 %38) #17, !dbg !5934
  %39 = load i32, i32* %8, align 4, !dbg !5935, !tbaa !663
  %40 = sub i32 %39, 1, !dbg !5936
  %41 = load i32*, i32** %6, align 4, !dbg !5937, !tbaa !657
  store i32 %40, i32* %41, align 4, !dbg !5938, !tbaa !663
  %42 = load i8*, i8** %9, align 4, !dbg !5939, !tbaa !657
  store i8* %42, i8** %4, align 4, !dbg !5940
  store i32 1, i32* %10, align 4
  br label %43, !dbg !5940

43:                                               ; preds = %35, %33
  %44 = bitcast i8** %9 to i8*, !dbg !5941
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %44) #19, !dbg !5941
  %45 = bitcast i32* %8 to i8*, !dbg !5941
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %45) #19, !dbg !5941
  %46 = load i8*, i8** %4, align 4, !dbg !5941
  ret i8* %46, !dbg !5941
}

; Function Attrs: nounwind ssp
define internal void @sea_init_str(i8* %0, i32 %1) #0 !dbg !5942 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !5946, metadata !DIExpression()), !dbg !5951
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !5947, metadata !DIExpression()), !dbg !5952
  %7 = load i8*, i8** %3, align 4, !dbg !5953, !tbaa !657
  %8 = load i32, i32* %4, align 4, !dbg !5954, !tbaa !663
  %9 = getelementptr inbounds i8, i8* %7, i32 %8, !dbg !5953
  store i8 0, i8* %9, align 1, !dbg !5955, !tbaa !1034
  %10 = bitcast i32* %5 to i8*, !dbg !5956
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %10) #19, !dbg !5956
  call void @llvm.dbg.declare(metadata i32* %5, metadata !5948, metadata !DIExpression()), !dbg !5957
  %11 = call i32 @sea_max_string_len() #17, !dbg !5958
  store i32 %11, i32* %5, align 4, !dbg !5957, !tbaa !663
  %12 = bitcast i32* %6 to i8*, !dbg !5959
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !5959
  call void @llvm.dbg.declare(metadata i32* %6, metadata !5949, metadata !DIExpression()), !dbg !5960
  store i32 0, i32* %6, align 4, !dbg !5960, !tbaa !663
  br label %13, !dbg !5959

13:                                               ; preds = %31, %2
  %14 = load i32, i32* %6, align 4, !dbg !5961, !tbaa !663
  %15 = load i32, i32* %5, align 4, !dbg !5963, !tbaa !663
  %16 = icmp ult i32 %14, %15, !dbg !5964
  br i1 %16, label %19, label %17, !dbg !5965

17:                                               ; preds = %13
  %18 = bitcast i32* %6 to i8*, !dbg !5966
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %18) #19, !dbg !5966
  br label %34

19:                                               ; preds = %13
  %20 = load i32, i32* %6, align 4, !dbg !5967, !tbaa !663
  %21 = load i32, i32* %4, align 4, !dbg !5970, !tbaa !663
  %22 = icmp ult i32 %20, %21, !dbg !5971
  br i1 %22, label %23, label %30, !dbg !5972

23:                                               ; preds = %19
  %24 = load i8*, i8** %3, align 4, !dbg !5973, !tbaa !657
  %25 = load i32, i32* %6, align 4, !dbg !5975, !tbaa !663
  %26 = getelementptr inbounds i8, i8* %24, i32 %25, !dbg !5973
  %27 = load i8, i8* %26, align 1, !dbg !5973, !tbaa !1034
  %28 = sext i8 %27 to i32, !dbg !5973
  %29 = icmp ne i32 %28, 0, !dbg !5976
  call void @__SEA_assume(i1 zeroext %29) #17, !dbg !5977
  br label %30, !dbg !5978

30:                                               ; preds = %23, %19
  br label %31, !dbg !5979

31:                                               ; preds = %30
  %32 = load i32, i32* %6, align 4, !dbg !5980, !tbaa !663
  %33 = add i32 %32, 1, !dbg !5980
  store i32 %33, i32* %6, align 4, !dbg !5980, !tbaa !663
  br label %13, !dbg !5966, !llvm.loop !5981

34:                                               ; preds = %17
  %35 = bitcast i32* %5 to i8*, !dbg !5983
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %35) #19, !dbg !5983
  ret void, !dbg !5983
}

; Function Attrs: nounwind ssp
define i8* @ensure_c_str_is_nd_allocated_aligned(i32 %0, i32* %1) #0 !dbg !5984 {
  %3 = alloca i32, align 4
  %4 = alloca i32*, align 4
  store i32 %0, i32* %3, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %3, metadata !5986, metadata !DIExpression()), !dbg !5988
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !5987, metadata !DIExpression()), !dbg !5989
  %5 = load i32, i32* %3, align 4, !dbg !5990, !tbaa !663
  %6 = load i32*, i32** %4, align 4, !dbg !5991, !tbaa !657
  %7 = call i8* @_ensure_c_str_is_nd_allocated_aligned(i32 %5, i32* %6, i1 zeroext false) #17, !dbg !5992
  ret i8* %7, !dbg !5993
}

; Function Attrs: nounwind ssp
define internal i8* @_ensure_c_str_is_nd_allocated_aligned(i32 %0, i32* %1, i1 zeroext %2) #0 !dbg !5994 {
  %4 = alloca i8*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32*, align 4
  %7 = alloca i8, align 1
  %8 = alloca i32, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i32, align 4
  store i32 %0, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !5996, metadata !DIExpression()), !dbg !6001
  store i32* %1, i32** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %6, metadata !5997, metadata !DIExpression()), !dbg !6002
  %11 = zext i1 %2 to i8
  store i8 %11, i8* %7, align 1, !tbaa !844
  call void @llvm.dbg.declare(metadata i8* %7, metadata !5998, metadata !DIExpression()), !dbg !6003
  %12 = bitcast i32* %8 to i8*, !dbg !6004
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !6004
  call void @llvm.dbg.declare(metadata i32* %8, metadata !5999, metadata !DIExpression()), !dbg !6005
  %13 = call i32 @nd_size_t() #21, !dbg !6006
  store i32 %13, i32* %8, align 4, !dbg !6007, !tbaa !663
  %14 = load i32, i32* %8, align 4, !dbg !6008, !tbaa !663
  %15 = icmp ugt i32 %14, 0, !dbg !6009
  call void @__SEA_assume(i1 zeroext %15) #17, !dbg !6010
  %16 = load i32, i32* %8, align 4, !dbg !6011, !tbaa !663
  %17 = load i32, i32* %5, align 4, !dbg !6012, !tbaa !663
  %18 = icmp ule i32 %16, %17, !dbg !6013
  call void @__SEA_assume(i1 zeroext %18) #17, !dbg !6014
  %19 = load i32, i32* %5, align 4, !dbg !6015, !tbaa !663
  %20 = call i32 @sea_max_string_len() #17, !dbg !6016
  %21 = icmp ule i32 %19, %20, !dbg !6017
  call void @__SEA_assume(i1 zeroext %21) #17, !dbg !6018
  %22 = bitcast i8** %9 to i8*, !dbg !6019
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %22) #19, !dbg !6019
  call void @llvm.dbg.declare(metadata i8** %9, metadata !6000, metadata !DIExpression()), !dbg !6020
  %23 = load i32, i32* %8, align 4, !dbg !6021, !tbaa !663
  %24 = call i8* @sea_malloc_aligned_havoc(i32 %23) #17, !dbg !6022
  store i8* %24, i8** %9, align 4, !dbg !6023, !tbaa !657
  %25 = load i8, i8* %7, align 1, !dbg !6024, !tbaa !844, !range !849
  %26 = trunc i8 %25 to i1, !dbg !6024
  br i1 %26, label %27, label %30, !dbg !6026

27:                                               ; preds = %3
  %28 = load i8*, i8** %9, align 4, !dbg !6027, !tbaa !657
  %29 = icmp ne i8* %28, null, !dbg !6027
  call void @__SEA_assume(i1 zeroext %29) #17, !dbg !6028
  br label %30, !dbg !6028

30:                                               ; preds = %27, %3
  %31 = load i8*, i8** %9, align 4, !dbg !6029, !tbaa !657
  %32 = icmp ne i8* %31, null, !dbg !6029
  br i1 %32, label %34, label %33, !dbg !6031

33:                                               ; preds = %30
  store i8* null, i8** %4, align 4, !dbg !6032
  store i32 1, i32* %10, align 4
  br label %42, !dbg !6032

34:                                               ; preds = %30
  %35 = load i8*, i8** %9, align 4, !dbg !6033, !tbaa !657
  %36 = load i32, i32* %8, align 4, !dbg !6034, !tbaa !663
  %37 = sub i32 %36, 1, !dbg !6035
  call void @sea_init_str(i8* %35, i32 %37) #17, !dbg !6036
  %38 = load i32, i32* %8, align 4, !dbg !6037, !tbaa !663
  %39 = sub i32 %38, 1, !dbg !6038
  %40 = load i32*, i32** %6, align 4, !dbg !6039, !tbaa !657
  store i32 %39, i32* %40, align 4, !dbg !6040, !tbaa !663
  %41 = load i8*, i8** %9, align 4, !dbg !6041, !tbaa !657
  store i8* %41, i8** %4, align 4, !dbg !6042
  store i32 1, i32* %10, align 4
  br label %42, !dbg !6042

42:                                               ; preds = %34, %33
  %43 = bitcast i8** %9 to i8*, !dbg !6043
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %43) #19, !dbg !6043
  %44 = bitcast i32* %8 to i8*, !dbg !6043
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %44) #19, !dbg !6043
  %45 = load i8*, i8** %4, align 4, !dbg !6043
  ret i8* %45, !dbg !6043
}

; Function Attrs: nounwind ssp
define i8* @ensure_c_str_is_nd_allocated_safe(i32 %0, i32* %1) #0 !dbg !6044 {
  %3 = alloca i32, align 4
  %4 = alloca i32*, align 4
  store i32 %0, i32* %3, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %3, metadata !6046, metadata !DIExpression()), !dbg !6048
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !6047, metadata !DIExpression()), !dbg !6049
  %5 = load i32, i32* %3, align 4, !dbg !6050, !tbaa !663
  %6 = load i32*, i32** %4, align 4, !dbg !6051, !tbaa !657
  %7 = call i8* @_ensure_c_str_is_nd_allocated(i32 %5, i32* %6, i1 zeroext true) #17, !dbg !6052
  ret i8* %7, !dbg !6053
}

; Function Attrs: nounwind ssp
define i32 @nd_aws_priority_queue_compare_fn(i8* %0, i8* %1) #0 !dbg !6054 {
  %3 = alloca i8*, align 4
  %4 = alloca i8*, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !6059, metadata !DIExpression()), !dbg !6061
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !6060, metadata !DIExpression()), !dbg !6062
  %5 = call i32 @nd_int() #21, !dbg !6063
  ret i32 %5, !dbg !6064
}

; Function Attrs: argmemonly nounwind
declare !dbg !384 i32 @nd_int() #11

; Function Attrs: nounwind ssp
define void @initialize_priority_queue(%struct.aws_priority_queue* %0) #0 !dbg !6065 {
  %2 = alloca %struct.aws_priority_queue*, align 4
  store %struct.aws_priority_queue* %0, %struct.aws_priority_queue** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_priority_queue** %2, metadata !6078, metadata !DIExpression()), !dbg !6079
  %3 = load %struct.aws_priority_queue*, %struct.aws_priority_queue** %2, align 4, !dbg !6080, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_priority_queue, %struct.aws_priority_queue* %3, i32 0, i32 0, !dbg !6081
  store i32 (i8*, i8*)* @nd_aws_priority_queue_compare_fn, i32 (i8*, i8*)** %4, align 4, !dbg !6082, !tbaa !6083
  %5 = load %struct.aws_priority_queue*, %struct.aws_priority_queue** %2, align 4, !dbg !6085, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_priority_queue, %struct.aws_priority_queue* %5, i32 0, i32 1, !dbg !6086
  call void @initialize_array_list(%struct.aws_array_list* %6) #17, !dbg !6087
  %7 = load %struct.aws_priority_queue*, %struct.aws_priority_queue** %2, align 4, !dbg !6088, !tbaa !657
  %8 = getelementptr inbounds %struct.aws_priority_queue, %struct.aws_priority_queue* %7, i32 0, i32 2, !dbg !6089
  call void @initialize_array_list(%struct.aws_array_list* %8) #17, !dbg !6090
  ret void, !dbg !6091
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_priority_queue_is_bounded(%struct.aws_priority_queue* %0, i32 %1, i32 %2) #0 !dbg !6092 {
  %4 = alloca %struct.aws_priority_queue*, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8, align 1
  %8 = alloca i8, align 1
  store %struct.aws_priority_queue* %0, %struct.aws_priority_queue** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_priority_queue** %4, metadata !6096, metadata !DIExpression()), !dbg !6101
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6097, metadata !DIExpression()), !dbg !6102
  store i32 %2, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6098, metadata !DIExpression()), !dbg !6103
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %7) #19, !dbg !6104
  call void @llvm.dbg.declare(metadata i8* %7, metadata !6099, metadata !DIExpression()), !dbg !6105
  %9 = load %struct.aws_priority_queue*, %struct.aws_priority_queue** %4, align 4, !dbg !6106, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_priority_queue, %struct.aws_priority_queue* %9, i32 0, i32 1, !dbg !6107
  %11 = load i32, i32* %5, align 4, !dbg !6108, !tbaa !663
  %12 = load i32, i32* %6, align 4, !dbg !6109, !tbaa !663
  %13 = call zeroext i1 @aws_array_list_is_bounded(%struct.aws_array_list* %10, i32 %11, i32 %12) #17, !dbg !6110
  %14 = zext i1 %13 to i8, !dbg !6105
  store i8 %14, i8* %7, align 1, !dbg !6105, !tbaa !844
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %8) #19, !dbg !6111
  call void @llvm.dbg.declare(metadata i8* %8, metadata !6100, metadata !DIExpression()), !dbg !6112
  %15 = load %struct.aws_priority_queue*, %struct.aws_priority_queue** %4, align 4, !dbg !6113, !tbaa !657
  %16 = getelementptr inbounds %struct.aws_priority_queue, %struct.aws_priority_queue* %15, i32 0, i32 2, !dbg !6114
  %17 = load i32, i32* %5, align 4, !dbg !6115, !tbaa !663
  %18 = call zeroext i1 @aws_array_list_is_bounded(%struct.aws_array_list* %16, i32 %17, i32 4) #17, !dbg !6116
  %19 = zext i1 %18 to i8, !dbg !6112
  store i8 %19, i8* %8, align 1, !dbg !6112, !tbaa !844
  %20 = load i8, i8* %7, align 1, !dbg !6117, !tbaa !844, !range !849
  %21 = trunc i8 %20 to i1, !dbg !6117
  br i1 %21, label %22, label %25, !dbg !6118

22:                                               ; preds = %3
  %23 = load i8, i8* %8, align 1, !dbg !6119, !tbaa !844, !range !849
  %24 = trunc i8 %23 to i1, !dbg !6119
  br label %25

25:                                               ; preds = %22, %3
  %26 = phi i1 [ false, %3 ], [ %24, %22 ], !dbg !6120
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #19, !dbg !6121
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %7) #19, !dbg !6121
  ret i1 %26, !dbg !6122
}

; Function Attrs: nounwind ssp
define void @initialize_ring_buffer(%struct.aws_ring_buffer* %0, i32 %1) #0 !dbg !6123 {
  %3 = alloca %struct.aws_ring_buffer*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  store %struct.aws_ring_buffer* %0, %struct.aws_ring_buffer** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_ring_buffer** %3, metadata !6140, metadata !DIExpression()), !dbg !6144
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !6141, metadata !DIExpression()), !dbg !6145
  %7 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !6146
  %8 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6147, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %8, i32 0, i32 0, !dbg !6148
  store %struct.aws_allocator* %7, %struct.aws_allocator** %9, align 4, !dbg !6149, !tbaa !6150
  %10 = load i32, i32* %4, align 4, !dbg !6153, !tbaa !663
  %11 = icmp ult i32 0, %10, !dbg !6154
  call void @__SEA_assume(i1 zeroext %11) #17, !dbg !6155
  %12 = load i32, i32* %4, align 4, !dbg !6156, !tbaa !663
  %13 = call i8* @bounded_malloc(i32 %12) #17, !dbg !6157
  %14 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6158, !tbaa !657
  %15 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %14, i32 0, i32 1, !dbg !6159
  store i8* %13, i8** %15, align 4, !dbg !6160, !tbaa !6161
  %16 = bitcast i32* %5 to i8*, !dbg !6162
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %16) #19, !dbg !6162
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6142, metadata !DIExpression()), !dbg !6163
  %17 = call i32 @nd_size_t() #21, !dbg !6164
  store i32 %17, i32* %5, align 4, !dbg !6163, !tbaa !663
  %18 = bitcast i32* %6 to i8*, !dbg !6165
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %18) #19, !dbg !6165
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6143, metadata !DIExpression()), !dbg !6166
  %19 = call i32 @nd_size_t() #21, !dbg !6167
  store i32 %19, i32* %6, align 4, !dbg !6166, !tbaa !663
  %20 = load i32, i32* %5, align 4, !dbg !6168, !tbaa !663
  %21 = load i32, i32* %4, align 4, !dbg !6169, !tbaa !663
  %22 = icmp ult i32 %20, %21, !dbg !6170
  call void @__SEA_assume(i1 zeroext %22) #17, !dbg !6171
  %23 = load i32, i32* %6, align 4, !dbg !6172, !tbaa !663
  %24 = load i32, i32* %4, align 4, !dbg !6173, !tbaa !663
  %25 = icmp ult i32 %23, %24, !dbg !6174
  call void @__SEA_assume(i1 zeroext %25) #17, !dbg !6175
  %26 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6176, !tbaa !657
  %27 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %26, i32 0, i32 2, !dbg !6177
  %28 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6178, !tbaa !657
  %29 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %28, i32 0, i32 1, !dbg !6179
  %30 = load i8*, i8** %29, align 4, !dbg !6179, !tbaa !6161
  %31 = load i32, i32* %5, align 4, !dbg !6180, !tbaa !663
  %32 = getelementptr inbounds i8, i8* %30, i32 %31, !dbg !6181
  call void @aws_atomic_store_ptr(%struct.aws_atomic_var* %27, i8* %32) #17, !dbg !6182
  %33 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6183, !tbaa !657
  %34 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %33, i32 0, i32 3, !dbg !6184
  %35 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6185, !tbaa !657
  %36 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %35, i32 0, i32 1, !dbg !6186
  %37 = load i8*, i8** %36, align 4, !dbg !6186, !tbaa !6161
  %38 = load i32, i32* %6, align 4, !dbg !6187, !tbaa !663
  %39 = getelementptr inbounds i8, i8* %37, i32 %38, !dbg !6188
  call void @aws_atomic_store_ptr(%struct.aws_atomic_var* %34, i8* %39) #17, !dbg !6189
  %40 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6190, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %40, i32 0, i32 1, !dbg !6191
  %42 = load i8*, i8** %41, align 4, !dbg !6191, !tbaa !6161
  %43 = load i32, i32* %4, align 4, !dbg !6192, !tbaa !663
  %44 = getelementptr inbounds i8, i8* %42, i32 %43, !dbg !6193
  %45 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %3, align 4, !dbg !6194, !tbaa !657
  %46 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %45, i32 0, i32 4, !dbg !6195
  store i8* %44, i8** %46, align 4, !dbg !6196, !tbaa !6197
  %47 = bitcast i32* %6 to i8*, !dbg !6198
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %47) #19, !dbg !6198
  %48 = bitcast i32* %5 to i8*, !dbg !6198
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %48) #19, !dbg !6198
  ret void, !dbg !6198
}

; Function Attrs: inlinehint nounwind ssp
define internal void @aws_atomic_store_ptr(%struct.aws_atomic_var* %0, i8* %1) #2 !dbg !6199 {
  %3 = alloca %struct.aws_atomic_var*, align 4
  %4 = alloca i8*, align 4
  store %struct.aws_atomic_var* %0, %struct.aws_atomic_var** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_atomic_var** %3, metadata !6206, metadata !DIExpression()), !dbg !6208
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !6207, metadata !DIExpression()), !dbg !6209
  %5 = load %struct.aws_atomic_var*, %struct.aws_atomic_var** %3, align 4, !dbg !6210, !tbaa !657
  %6 = load i8*, i8** %4, align 4, !dbg !6211, !tbaa !657
  call void @aws_atomic_store_ptr_explicit(%struct.aws_atomic_var* %5, i8* %6, i32 5) #17, !dbg !6212
  ret void, !dbg !6213
}

; Function Attrs: inlinehint nounwind ssp
define internal void @aws_atomic_store_ptr_explicit(%struct.aws_atomic_var* %0, i8* %1, i32 %2) #2 !dbg !6214 {
  %4 = alloca %struct.aws_atomic_var*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i8*, align 4
  store %struct.aws_atomic_var* %0, %struct.aws_atomic_var** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_atomic_var** %4, metadata !6219, metadata !DIExpression()), !dbg !6222
  store i8* %1, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !6220, metadata !DIExpression()), !dbg !6223
  store i32 %2, i32* %6, align 4, !tbaa !1034
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6221, metadata !DIExpression()), !dbg !6224
  %8 = load %struct.aws_atomic_var*, %struct.aws_atomic_var** %4, align 4, !dbg !6225, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_atomic_var, %struct.aws_atomic_var* %8, i32 0, i32 0, !dbg !6225
  %10 = load i32, i32* %6, align 4, !dbg !6226, !tbaa !1034
  %11 = call i32 @aws_atomic_priv_xlate_order(i32 %10) #17, !dbg !6227
  %12 = load i8*, i8** %5, align 4, !dbg !6228, !tbaa !657
  store i8* %12, i8** %7, align 4, !dbg !6229, !tbaa !657
  %13 = bitcast i8** %9 to i32*, !dbg !6229
  %14 = bitcast i8** %7 to i32*, !dbg !6229
  switch i32 %11, label %15 [
    i32 3, label %17
    i32 5, label %19
  ], !dbg !6229

15:                                               ; preds = %3
  %16 = load i32, i32* %14, align 4, !dbg !6229
  store atomic volatile i32 %16, i32* %13 monotonic, align 4, !dbg !6229
  br label %21, !dbg !6229

17:                                               ; preds = %3
  %18 = load i32, i32* %14, align 4, !dbg !6229
  store atomic volatile i32 %18, i32* %13 release, align 4, !dbg !6229
  br label %21, !dbg !6229

19:                                               ; preds = %3
  %20 = load i32, i32* %14, align 4, !dbg !6229
  store atomic volatile i32 %20, i32* %13 seq_cst, align 4, !dbg !6229
  br label %21, !dbg !6229

21:                                               ; preds = %19, %17, %15
  ret void, !dbg !6230
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_atomic_priv_xlate_order(i32 %0) #2 !dbg !6231 {
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  store i32 %0, i32* %3, align 4, !tbaa !1034
  call void @llvm.dbg.declare(metadata i32* %3, metadata !6235, metadata !DIExpression()), !dbg !6236
  %4 = load i32, i32* %3, align 4, !dbg !6237, !tbaa !1034
  switch i32 %4, label %10 [
    i32 0, label %5
    i32 2, label %6
    i32 3, label %7
    i32 4, label %8
    i32 5, label %9
  ], !dbg !6238

5:                                                ; preds = %1
  store i32 0, i32* %2, align 4, !dbg !6239
  br label %11, !dbg !6239

6:                                                ; preds = %1
  store i32 2, i32* %2, align 4, !dbg !6241
  br label %11, !dbg !6241

7:                                                ; preds = %1
  store i32 3, i32* %2, align 4, !dbg !6242
  br label %11, !dbg !6242

8:                                                ; preds = %1
  store i32 4, i32* %2, align 4, !dbg !6243
  br label %11, !dbg !6243

9:                                                ; preds = %1
  store i32 5, i32* %2, align 4, !dbg !6244
  br label %11, !dbg !6244

10:                                               ; preds = %1
  call void @abort() #23, !dbg !6245
  unreachable, !dbg !6245

11:                                               ; preds = %9, %8, %7, %6, %5
  %12 = load i32, i32* %2, align 4, !dbg !6246
  ret i32 %12, !dbg !6246
}

; Function Attrs: cold noreturn
declare void @abort() #14

; Function Attrs: nounwind ssp
define void @ensure_byte_buf_has_allocated_buffer_member_in_range(%struct.aws_byte_buf* %0, i8* %1, i8* %2) #0 !dbg !6247 {
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  %9 = alloca i32, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !6258, metadata !DIExpression()), !dbg !6264
  store i8* %1, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !6259, metadata !DIExpression()), !dbg !6265
  store i8* %2, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !6260, metadata !DIExpression()), !dbg !6266
  %10 = load i8*, i8** %5, align 4, !dbg !6267, !tbaa !657
  %11 = load i8*, i8** %6, align 4, !dbg !6267, !tbaa !657
  %12 = icmp ult i8* %10, %11, !dbg !6267
  call void @__VERIFIER_assert(i1 zeroext %12) #17, !dbg !6267
  %13 = load i8*, i8** %5, align 4, !dbg !6267, !tbaa !657
  %14 = load i8*, i8** %6, align 4, !dbg !6267, !tbaa !657
  %15 = icmp ult i8* %13, %14, !dbg !6267
  br i1 %15, label %17, label %16, !dbg !6267

16:                                               ; preds = %3
  call void @__VERIFIER_error() #17, !dbg !6267
  br label %17, !dbg !6267

17:                                               ; preds = %16, %3
  %18 = phi i1 [ true, %3 ], [ false, %16 ]
  %19 = zext i1 %18 to i32, !dbg !6267
  %20 = bitcast i32* %7 to i8*, !dbg !6268
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %20) #19, !dbg !6268
  call void @llvm.dbg.declare(metadata i32* %7, metadata !6261, metadata !DIExpression()), !dbg !6269
  %21 = load i8*, i8** %6, align 4, !dbg !6270, !tbaa !657
  %22 = load i8*, i8** %5, align 4, !dbg !6271, !tbaa !657
  %23 = ptrtoint i8* %21 to i32, !dbg !6272
  %24 = ptrtoint i8* %22 to i32, !dbg !6272
  %25 = sub i32 %23, %24, !dbg !6272
  store i32 %25, i32* %7, align 4, !dbg !6269, !tbaa !663
  %26 = bitcast i32* %8 to i8*, !dbg !6273
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %26) #19, !dbg !6273
  call void @llvm.dbg.declare(metadata i32* %8, metadata !6262, metadata !DIExpression()), !dbg !6274
  %27 = call i32 @nd_size_t() #21, !dbg !6275
  store i32 %27, i32* %8, align 4, !dbg !6274, !tbaa !663
  %28 = load i32, i32* %8, align 4, !dbg !6276, !tbaa !663
  %29 = load i32, i32* %7, align 4, !dbg !6277, !tbaa !663
  %30 = icmp ult i32 %28, %29, !dbg !6278
  call void @__SEA_assume(i1 zeroext %30) #17, !dbg !6279
  %31 = load i8*, i8** %5, align 4, !dbg !6280, !tbaa !657
  %32 = load i32, i32* %8, align 4, !dbg !6281, !tbaa !663
  %33 = getelementptr inbounds i8, i8* %31, i32 %32, !dbg !6282
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !6283, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %34, i32 0, i32 1, !dbg !6284
  store i8* %33, i8** %35, align 4, !dbg !6285, !tbaa !675
  %36 = bitcast i32* %9 to i8*, !dbg !6286
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %36) #19, !dbg !6286
  call void @llvm.dbg.declare(metadata i32* %9, metadata !6263, metadata !DIExpression()), !dbg !6287
  %37 = load i8*, i8** %6, align 4, !dbg !6288, !tbaa !657
  %38 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !6289, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %38, i32 0, i32 1, !dbg !6290
  %40 = load i8*, i8** %39, align 4, !dbg !6290, !tbaa !675
  %41 = ptrtoint i8* %37 to i32, !dbg !6291
  %42 = ptrtoint i8* %40 to i32, !dbg !6291
  %43 = sub i32 %41, %42, !dbg !6291
  store i32 %43, i32* %9, align 4, !dbg !6287, !tbaa !663
  %44 = load i32, i32* %9, align 4, !dbg !6292, !tbaa !663
  %45 = icmp ult i32 0, %44, !dbg !6292
  call void @__VERIFIER_assert(i1 zeroext %45) #17, !dbg !6292
  %46 = load i32, i32* %9, align 4, !dbg !6292, !tbaa !663
  %47 = icmp ult i32 0, %46, !dbg !6292
  br i1 %47, label %49, label %48, !dbg !6292

48:                                               ; preds = %17
  call void @__VERIFIER_error() #17, !dbg !6292
  br label %49, !dbg !6292

49:                                               ; preds = %48, %17
  %50 = phi i1 [ true, %17 ], [ false, %48 ]
  %51 = zext i1 %50 to i32, !dbg !6292
  %52 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !6293, !tbaa !657
  %53 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %52, i32 0, i32 2, !dbg !6294
  %54 = load i32, i32* %53, align 4, !dbg !6294, !tbaa !698
  %55 = icmp ult i32 0, %54, !dbg !6295
  br i1 %55, label %56, label %62, !dbg !6296

56:                                               ; preds = %49
  %57 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !6297, !tbaa !657
  %58 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %57, i32 0, i32 2, !dbg !6298
  %59 = load i32, i32* %58, align 4, !dbg !6298, !tbaa !698
  %60 = load i32, i32* %9, align 4, !dbg !6299, !tbaa !663
  %61 = icmp ule i32 %59, %60, !dbg !6300
  br label %62

62:                                               ; preds = %56, %49
  %63 = phi i1 [ false, %49 ], [ %61, %56 ], !dbg !6301
  call void @__SEA_assume(i1 zeroext %63) #17, !dbg !6302
  %64 = bitcast i32* %9 to i8*, !dbg !6303
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %64) #19, !dbg !6303
  %65 = bitcast i32* %8 to i8*, !dbg !6303
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %65) #19, !dbg !6303
  %66 = bitcast i32* %7 to i8*, !dbg !6303
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %66) #19, !dbg !6303
  ret void, !dbg !6303
}

; Function Attrs: nounwind ssp
define void @ensure_byte_buf_has_allocated_buffer_member_in_ring_buf(%struct.aws_byte_buf* %0, %struct.aws_ring_buffer* %1) #0 !dbg !6304 {
  %3 = alloca %struct.aws_byte_buf*, align 4
  %4 = alloca %struct.aws_ring_buffer*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %3, metadata !6308, metadata !DIExpression()), !dbg !6312
  store %struct.aws_ring_buffer* %1, %struct.aws_ring_buffer** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_ring_buffer** %4, metadata !6309, metadata !DIExpression()), !dbg !6313
  %7 = call zeroext i1 @nd_bool() #21, !dbg !6314
  br i1 %7, label %8, label %9, !dbg !6314

8:                                                ; preds = %2
  br label %11, !dbg !6314

9:                                                ; preds = %2
  %10 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !6315
  br label %11, !dbg !6314

11:                                               ; preds = %9, %8
  %12 = phi %struct.aws_allocator* [ null, %8 ], [ %10, %9 ], !dbg !6314
  %13 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !6316, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %13, i32 0, i32 3, !dbg !6317
  store %struct.aws_allocator* %12, %struct.aws_allocator** %14, align 4, !dbg !6318, !tbaa !703
  %15 = bitcast i8** %5 to i8*, !dbg !6319
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !6319
  call void @llvm.dbg.declare(metadata i8** %5, metadata !6310, metadata !DIExpression()), !dbg !6320
  %16 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6321, !tbaa !657
  %17 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %16, i32 0, i32 2, !dbg !6322
  %18 = call i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %17) #17, !dbg !6323
  store i8* %18, i8** %5, align 4, !dbg !6320, !tbaa !657
  %19 = bitcast i8** %6 to i8*, !dbg !6324
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %19) #19, !dbg !6324
  call void @llvm.dbg.declare(metadata i8** %6, metadata !6311, metadata !DIExpression()), !dbg !6325
  %20 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6326, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %20, i32 0, i32 3, !dbg !6327
  %22 = call i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %21) #17, !dbg !6328
  store i8* %22, i8** %6, align 4, !dbg !6325, !tbaa !657
  %23 = load i8*, i8** %5, align 4, !dbg !6329, !tbaa !657
  %24 = load i8*, i8** %6, align 4, !dbg !6331, !tbaa !657
  %25 = icmp ult i8* %23, %24, !dbg !6332
  br i1 %25, label %26, label %51, !dbg !6333

26:                                               ; preds = %11
  %27 = call zeroext i1 @nd_bool() #21, !dbg !6334
  br i1 %27, label %28, label %39, !dbg !6337

28:                                               ; preds = %26
  %29 = load i8*, i8** %6, align 4, !dbg !6338, !tbaa !657
  %30 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6340, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %30, i32 0, i32 4, !dbg !6341
  %32 = load i8*, i8** %31, align 4, !dbg !6341, !tbaa !6197
  %33 = icmp ult i8* %29, %32, !dbg !6342
  call void @__SEA_assume(i1 zeroext %33) #17, !dbg !6343
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !6344, !tbaa !657
  %35 = load i8*, i8** %6, align 4, !dbg !6345, !tbaa !657
  %36 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6346, !tbaa !657
  %37 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %36, i32 0, i32 4, !dbg !6347
  %38 = load i8*, i8** %37, align 4, !dbg !6347, !tbaa !6197
  call void @ensure_byte_buf_has_allocated_buffer_member_in_range(%struct.aws_byte_buf* %34, i8* %35, i8* %38) #17, !dbg !6348
  br label %50, !dbg !6349

39:                                               ; preds = %26
  %40 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6350, !tbaa !657
  %41 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %40, i32 0, i32 1, !dbg !6352
  %42 = load i8*, i8** %41, align 4, !dbg !6352, !tbaa !6161
  %43 = load i8*, i8** %5, align 4, !dbg !6353, !tbaa !657
  %44 = icmp ult i8* %42, %43, !dbg !6354
  call void @__SEA_assume(i1 zeroext %44) #17, !dbg !6355
  %45 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !6356, !tbaa !657
  %46 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6357, !tbaa !657
  %47 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %46, i32 0, i32 1, !dbg !6358
  %48 = load i8*, i8** %47, align 4, !dbg !6358, !tbaa !6161
  %49 = load i8*, i8** %5, align 4, !dbg !6359, !tbaa !657
  call void @ensure_byte_buf_has_allocated_buffer_member_in_range(%struct.aws_byte_buf* %45, i8* %48, i8* %49) #17, !dbg !6360
  br label %50

50:                                               ; preds = %39, %28
  br label %55, !dbg !6361

51:                                               ; preds = %11
  %52 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %3, align 4, !dbg !6362, !tbaa !657
  %53 = load i8*, i8** %6, align 4, !dbg !6364, !tbaa !657
  %54 = load i8*, i8** %5, align 4, !dbg !6365, !tbaa !657
  call void @ensure_byte_buf_has_allocated_buffer_member_in_range(%struct.aws_byte_buf* %52, i8* %53, i8* %54) #17, !dbg !6366
  br label %55

55:                                               ; preds = %51, %50
  %56 = bitcast i8** %6 to i8*, !dbg !6367
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %56) #19, !dbg !6367
  %57 = bitcast i8** %5 to i8*, !dbg !6367
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %57) #19, !dbg !6367
  ret void, !dbg !6367
}

; Function Attrs: argmemonly nounwind
declare !dbg !457 zeroext i1 @nd_bool() #11

; Function Attrs: inlinehint nounwind ssp
define internal i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %0) #2 !dbg !6368 {
  %2 = alloca %struct.aws_atomic_var*, align 4
  store %struct.aws_atomic_var* %0, %struct.aws_atomic_var** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_atomic_var** %2, metadata !6374, metadata !DIExpression()), !dbg !6375
  %3 = load %struct.aws_atomic_var*, %struct.aws_atomic_var** %2, align 4, !dbg !6376, !tbaa !657
  %4 = call i8* @aws_atomic_load_ptr_explicit(%struct.aws_atomic_var* %3, i32 5) #17, !dbg !6377
  ret i8* %4, !dbg !6378
}

; Function Attrs: inlinehint nounwind ssp
define internal i8* @aws_atomic_load_ptr_explicit(%struct.aws_atomic_var* %0, i32 %1) #2 !dbg !6379 {
  %3 = alloca %struct.aws_atomic_var*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i8*, align 4
  store %struct.aws_atomic_var* %0, %struct.aws_atomic_var** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_atomic_var** %3, metadata !6383, metadata !DIExpression()), !dbg !6385
  store i32 %1, i32* %4, align 4, !tbaa !1034
  call void @llvm.dbg.declare(metadata i32* %4, metadata !6384, metadata !DIExpression()), !dbg !6386
  %6 = load %struct.aws_atomic_var*, %struct.aws_atomic_var** %3, align 4, !dbg !6387, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_atomic_var, %struct.aws_atomic_var* %6, i32 0, i32 0, !dbg !6387
  %8 = load i32, i32* %4, align 4, !dbg !6388, !tbaa !1034
  %9 = call i32 @aws_atomic_priv_xlate_order(i32 %8) #17, !dbg !6389
  %10 = bitcast i8** %7 to i32*, !dbg !6390
  %11 = bitcast i8** %5 to i32*, !dbg !6390
  switch i32 %9, label %12 [
    i32 1, label %14
    i32 2, label %14
    i32 5, label %16
  ], !dbg !6390

12:                                               ; preds = %2
  %13 = load atomic volatile i32, i32* %10 monotonic, align 4, !dbg !6390
  store i32 %13, i32* %11, align 4, !dbg !6390
  br label %18, !dbg !6390

14:                                               ; preds = %2, %2
  %15 = load atomic volatile i32, i32* %10 acquire, align 4, !dbg !6390
  store i32 %15, i32* %11, align 4, !dbg !6390
  br label %18, !dbg !6390

16:                                               ; preds = %2
  %17 = load atomic volatile i32, i32* %10 seq_cst, align 4, !dbg !6390
  store i32 %17, i32* %11, align 4, !dbg !6390
  br label %18, !dbg !6390

18:                                               ; preds = %16, %14, %12
  %19 = bitcast i32* %11 to i8**, !dbg !6390
  %20 = load i8*, i8** %19, align 4, !dbg !6390, !tbaa !657
  ret i8* %20, !dbg !6391
}

; Function Attrs: nounwind ssp
define zeroext i1 @ring_buffers_are_equal(%struct.aws_ring_buffer* %0, %struct.aws_ring_buffer* %1) #0 !dbg !6392 {
  %3 = alloca i1, align 1
  %4 = alloca %struct.aws_ring_buffer*, align 4
  %5 = alloca %struct.aws_ring_buffer*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  %8 = alloca i8*, align 4
  %9 = alloca i8*, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i8*, align 4
  store %struct.aws_ring_buffer* %0, %struct.aws_ring_buffer** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_ring_buffer** %4, metadata !6396, metadata !DIExpression()), !dbg !6403
  store %struct.aws_ring_buffer* %1, %struct.aws_ring_buffer** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_ring_buffer** %5, metadata !6397, metadata !DIExpression()), !dbg !6404
  %12 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6405, !tbaa !657
  %13 = icmp ne %struct.aws_ring_buffer* %12, null, !dbg !6405
  br i1 %13, label %14, label %17, !dbg !6407

14:                                               ; preds = %2
  %15 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6408, !tbaa !657
  %16 = icmp ne %struct.aws_ring_buffer* %15, null, !dbg !6408
  br i1 %16, label %21, label %17, !dbg !6409

17:                                               ; preds = %14, %2
  %18 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6410, !tbaa !657
  %19 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6411, !tbaa !657
  %20 = icmp eq %struct.aws_ring_buffer* %18, %19, !dbg !6412
  store i1 %20, i1* %3, align 1, !dbg !6413
  br label %82, !dbg !6413

21:                                               ; preds = %14
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !6414
  call void @llvm.dbg.declare(metadata i8* %6, metadata !6398, metadata !DIExpression()), !dbg !6415
  %22 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6416, !tbaa !657
  %23 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %22, i32 0, i32 0, !dbg !6417
  %24 = load %struct.aws_allocator*, %struct.aws_allocator** %23, align 4, !dbg !6417, !tbaa !6150
  %25 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6418, !tbaa !657
  %26 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %25, i32 0, i32 0, !dbg !6419
  %27 = load %struct.aws_allocator*, %struct.aws_allocator** %26, align 4, !dbg !6419, !tbaa !6150
  %28 = icmp eq %struct.aws_allocator* %24, %27, !dbg !6420
  br i1 %28, label %29, label %45, !dbg !6421

29:                                               ; preds = %21
  %30 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6422, !tbaa !657
  %31 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %30, i32 0, i32 1, !dbg !6423
  %32 = load i8*, i8** %31, align 4, !dbg !6423, !tbaa !6161
  %33 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6424, !tbaa !657
  %34 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %33, i32 0, i32 1, !dbg !6425
  %35 = load i8*, i8** %34, align 4, !dbg !6425, !tbaa !6161
  %36 = icmp eq i8* %32, %35, !dbg !6426
  br i1 %36, label %37, label %45, !dbg !6427

37:                                               ; preds = %29
  %38 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6428, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %38, i32 0, i32 4, !dbg !6429
  %40 = load i8*, i8** %39, align 4, !dbg !6429, !tbaa !6197
  %41 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6430, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %41, i32 0, i32 4, !dbg !6431
  %43 = load i8*, i8** %42, align 4, !dbg !6431, !tbaa !6197
  %44 = icmp eq i8* %40, %43, !dbg !6432
  br label %45

45:                                               ; preds = %37, %29, %21
  %46 = phi i1 [ false, %29 ], [ false, %21 ], [ %44, %37 ], !dbg !6433
  %47 = zext i1 %46 to i8, !dbg !6415
  store i8 %47, i8* %6, align 1, !dbg !6415, !tbaa !844
  %48 = load i8, i8* %6, align 1, !dbg !6434, !tbaa !844, !range !849
  %49 = trunc i8 %48 to i1, !dbg !6434
  br i1 %49, label %51, label %50, !dbg !6436

50:                                               ; preds = %45
  store i1 false, i1* %3, align 1, !dbg !6437
  store i32 1, i32* %7, align 4
  br label %81, !dbg !6437

51:                                               ; preds = %45
  %52 = bitcast i8** %8 to i8*, !dbg !6438
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %52) #19, !dbg !6438
  call void @llvm.dbg.declare(metadata i8** %8, metadata !6399, metadata !DIExpression()), !dbg !6439
  %53 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6440, !tbaa !657
  %54 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %53, i32 0, i32 2, !dbg !6441
  %55 = call i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %54) #17, !dbg !6442
  store i8* %55, i8** %8, align 4, !dbg !6439, !tbaa !657
  %56 = bitcast i8** %9 to i8*, !dbg !6443
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %56) #19, !dbg !6443
  call void @llvm.dbg.declare(metadata i8** %9, metadata !6400, metadata !DIExpression()), !dbg !6444
  %57 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %4, align 4, !dbg !6445, !tbaa !657
  %58 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %57, i32 0, i32 3, !dbg !6446
  %59 = call i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %58) #17, !dbg !6447
  store i8* %59, i8** %9, align 4, !dbg !6444, !tbaa !657
  %60 = bitcast i8** %10 to i8*, !dbg !6448
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %60) #19, !dbg !6448
  call void @llvm.dbg.declare(metadata i8** %10, metadata !6401, metadata !DIExpression()), !dbg !6449
  %61 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6450, !tbaa !657
  %62 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %61, i32 0, i32 2, !dbg !6451
  %63 = call i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %62) #17, !dbg !6452
  store i8* %63, i8** %10, align 4, !dbg !6449, !tbaa !657
  %64 = bitcast i8** %11 to i8*, !dbg !6453
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %64) #19, !dbg !6453
  call void @llvm.dbg.declare(metadata i8** %11, metadata !6402, metadata !DIExpression()), !dbg !6454
  %65 = load %struct.aws_ring_buffer*, %struct.aws_ring_buffer** %5, align 4, !dbg !6455, !tbaa !657
  %66 = getelementptr inbounds %struct.aws_ring_buffer, %struct.aws_ring_buffer* %65, i32 0, i32 3, !dbg !6456
  %67 = call i8* @aws_atomic_load_ptr(%struct.aws_atomic_var* %66) #17, !dbg !6457
  store i8* %67, i8** %11, align 4, !dbg !6454, !tbaa !657
  %68 = load i8*, i8** %8, align 4, !dbg !6458, !tbaa !657
  %69 = load i8*, i8** %10, align 4, !dbg !6459, !tbaa !657
  %70 = icmp eq i8* %68, %69, !dbg !6460
  br i1 %70, label %71, label %75, !dbg !6461

71:                                               ; preds = %51
  %72 = load i8*, i8** %9, align 4, !dbg !6462, !tbaa !657
  %73 = load i8*, i8** %11, align 4, !dbg !6463, !tbaa !657
  %74 = icmp eq i8* %72, %73, !dbg !6464
  br label %75

75:                                               ; preds = %71, %51
  %76 = phi i1 [ false, %51 ], [ %74, %71 ], !dbg !6433
  store i1 %76, i1* %3, align 1, !dbg !6465
  store i32 1, i32* %7, align 4
  %77 = bitcast i8** %11 to i8*, !dbg !6466
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %77) #19, !dbg !6466
  %78 = bitcast i8** %10 to i8*, !dbg !6466
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %78) #19, !dbg !6466
  %79 = bitcast i8** %9 to i8*, !dbg !6466
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %79) #19, !dbg !6466
  %80 = bitcast i8** %8 to i8*, !dbg !6466
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %80) #19, !dbg !6466
  br label %81

81:                                               ; preds = %75, %50
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !6466
  br label %82

82:                                               ; preds = %81, %17
  %83 = load i1, i1* %3, align 1, !dbg !6466
  ret i1 %83, !dbg !6466
}

; Function Attrs: nounwind ssp
define void @hash_proof_destroy_noop(i8* %0) #0 !dbg !6467 {
  %2 = alloca i8*, align 4
  store i8* %0, i8** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %2, metadata !6469, metadata !DIExpression()), !dbg !6470
  ret void, !dbg !6471
}

; Function Attrs: nounwind ssp
define void @initialize_bounded_aws_hash_table(%struct.aws_hash_table* %0, i32 %1) #0 !dbg !6472 {
  %3 = alloca %struct.aws_hash_table*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca %struct.hash_table_state*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %3, metadata !6477, metadata !DIExpression()), !dbg !6482
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !6478, metadata !DIExpression()), !dbg !6483
  %8 = bitcast i32* %5 to i8*, !dbg !6484
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %8) #19, !dbg !6484
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6479, metadata !DIExpression()), !dbg !6485
  %9 = call i32 @nd_size_t() #21, !dbg !6486
  store i32 %9, i32* %5, align 4, !dbg !6485, !tbaa !663
  %10 = load i32, i32* %5, align 4, !dbg !6487, !tbaa !663
  %11 = load i32, i32* %4, align 4, !dbg !6488, !tbaa !663
  %12 = icmp ule i32 %10, %11, !dbg !6489
  call void @__SEA_assume(i1 zeroext %12) #17, !dbg !6490
  %13 = load i32, i32* %5, align 4, !dbg !6491, !tbaa !663
  %14 = call zeroext i1 @aws_is_power_of_two(i32 %13) #17, !dbg !6492
  call void @__SEA_assume(i1 zeroext %14) #17, !dbg !6493
  %15 = bitcast i32* %6 to i8*, !dbg !6494
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !6494
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6480, metadata !DIExpression()), !dbg !6495
  %16 = call i32 @nd_size_t() #21, !dbg !6496
  store i32 %16, i32* %6, align 4, !dbg !6495, !tbaa !663
  %17 = load i32, i32* %5, align 4, !dbg !6497, !tbaa !663
  %18 = call i32 @hash_table_state_required_bytes(i32 %17, i32* %6) #17, !dbg !6498
  %19 = icmp eq i32 %18, 0, !dbg !6499
  call void @__SEA_assume(i1 zeroext %19) #17, !dbg !6500
  %20 = bitcast %struct.hash_table_state** %7 to i8*, !dbg !6501
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %20) #19, !dbg !6501
  call void @llvm.dbg.declare(metadata %struct.hash_table_state** %7, metadata !6481, metadata !DIExpression()), !dbg !6502
  %21 = load i32, i32* %6, align 4, !dbg !6503, !tbaa !663
  %22 = call i8* @bounded_malloc(i32 %21) #17, !dbg !6504
  %23 = bitcast i8* %22 to %struct.hash_table_state*, !dbg !6504
  store %struct.hash_table_state* %23, %struct.hash_table_state** %7, align 4, !dbg !6502, !tbaa !657
  %24 = load i32, i32* %5, align 4, !dbg !6505, !tbaa !663
  %25 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6506, !tbaa !657
  %26 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %25, i32 0, i32 5, !dbg !6507
  store i32 %24, i32* %26, align 4, !dbg !6508, !tbaa !663
  %27 = load i32, i32* %5, align 4, !dbg !6509, !tbaa !663
  %28 = sub i32 %27, 1, !dbg !6510
  %29 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6511, !tbaa !657
  %30 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %29, i32 0, i32 8, !dbg !6512
  store i32 %28, i32* %30, align 4, !dbg !6513, !tbaa !663
  %31 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6514, !tbaa !657
  %32 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %31, i32 0, i32 9, !dbg !6515
  store double 0x3FEE666666666666, double* %32, align 4, !dbg !6516, !tbaa !3330
  %33 = call %struct.aws_allocator* @sea_allocator() #17, !dbg !6517
  %34 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6518, !tbaa !657
  %35 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %34, i32 0, i32 4, !dbg !6519
  store %struct.aws_allocator* %33, %struct.aws_allocator** %35, align 4, !dbg !6520, !tbaa !657
  %36 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6521, !tbaa !657
  %37 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %36, i32 0, i32 0, !dbg !6522
  store i64 (i8*)* @nd_hash_fn, i64 (i8*)** %37, align 4, !dbg !6523, !tbaa !657
  %38 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6524, !tbaa !657
  %39 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %38, i32 0, i32 1, !dbg !6525
  store i1 (i8*, i8*)* @nd_hash_equals_fn, i1 (i8*, i8*)** %39, align 4, !dbg !6526, !tbaa !657
  %40 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6527, !tbaa !657
  %41 = load %struct.aws_hash_table*, %struct.aws_hash_table** %3, align 4, !dbg !6528, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %41, i32 0, i32 0, !dbg !6529
  store %struct.hash_table_state* %40, %struct.hash_table_state** %42, align 4, !dbg !6530, !tbaa !6531
  %43 = bitcast %struct.hash_table_state** %7 to i8*, !dbg !6533
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %43) #19, !dbg !6533
  %44 = bitcast i32* %6 to i8*, !dbg !6533
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %44) #19, !dbg !6533
  %45 = bitcast i32* %5 to i8*, !dbg !6533
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %45) #19, !dbg !6533
  ret void, !dbg !6533
}

; Function Attrs: inlinehint nounwind ssp
define internal zeroext i1 @aws_is_power_of_two(i32 %0) #2 !dbg !6534 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !6538, metadata !DIExpression()), !dbg !6539
  %3 = load i32, i32* %2, align 4, !dbg !6540, !tbaa !663
  %4 = icmp ne i32 %3, 0, !dbg !6540
  br i1 %4, label %5, label %12, !dbg !6541

5:                                                ; preds = %1
  %6 = load i32, i32* %2, align 4, !dbg !6542, !tbaa !663
  %7 = load i32, i32* %2, align 4, !dbg !6543, !tbaa !663
  %8 = sub i32 %7, 1, !dbg !6544
  %9 = and i32 %6, %8, !dbg !6545
  %10 = icmp ne i32 %9, 0, !dbg !6546
  %11 = xor i1 %10, true, !dbg !6546
  br label %12

12:                                               ; preds = %5, %1
  %13 = phi i1 [ false, %1 ], [ %11, %5 ], !dbg !6547
  ret i1 %13, !dbg !6548
}

declare !dbg !470 i32 @hash_table_state_required_bytes(i32, i32*) #4

declare i64 @nd_hash_fn(i8*) #4

declare zeroext i1 @nd_hash_equals_fn(i8*, i8*) #4

; Function Attrs: nounwind ssp
define void @initialize_aws_hash_iter(%struct.aws_hash_iter* %0, %struct.aws_hash_table* %1) #0 !dbg !6549 {
  %3 = alloca %struct.aws_hash_iter*, align 4
  %4 = alloca %struct.aws_hash_table*, align 4
  store %struct.aws_hash_iter* %0, %struct.aws_hash_iter** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_iter** %3, metadata !6554, metadata !DIExpression()), !dbg !6556
  store %struct.aws_hash_table* %1, %struct.aws_hash_table** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %4, metadata !6555, metadata !DIExpression()), !dbg !6557
  %5 = load %struct.aws_hash_table*, %struct.aws_hash_table** %4, align 4, !dbg !6558, !tbaa !657
  %6 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6559, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_hash_iter, %struct.aws_hash_iter* %6, i32 0, i32 0, !dbg !6560
  store %struct.aws_hash_table* %5, %struct.aws_hash_table** %7, align 4, !dbg !6561, !tbaa !6562
  %8 = call noalias i8* @nd_voidp() #17, !dbg !6565
  %9 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6566, !tbaa !657
  %10 = getelementptr inbounds %struct.aws_hash_iter, %struct.aws_hash_iter* %9, i32 0, i32 1, !dbg !6567
  %11 = getelementptr inbounds %struct.aws_hash_element, %struct.aws_hash_element* %10, i32 0, i32 0, !dbg !6568
  store i8* %8, i8** %11, align 4, !dbg !6569, !tbaa !6570
  %12 = call noalias i8* @nd_voidp() #17, !dbg !6571
  %13 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6572, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_hash_iter, %struct.aws_hash_iter* %13, i32 0, i32 1, !dbg !6573
  %15 = getelementptr inbounds %struct.aws_hash_element, %struct.aws_hash_element* %14, i32 0, i32 1, !dbg !6574
  store i8* %12, i8** %15, align 4, !dbg !6575, !tbaa !6576
  %16 = call i32 @nd_size_t() #21, !dbg !6577
  %17 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6578, !tbaa !657
  %18 = getelementptr inbounds %struct.aws_hash_iter, %struct.aws_hash_iter* %17, i32 0, i32 2, !dbg !6579
  store i32 %16, i32* %18, align 4, !dbg !6580, !tbaa !6581
  %19 = call i32 @nd_size_t() #21, !dbg !6582
  %20 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6583, !tbaa !657
  %21 = getelementptr inbounds %struct.aws_hash_iter, %struct.aws_hash_iter* %20, i32 0, i32 3, !dbg !6584
  store i32 %19, i32* %21, align 4, !dbg !6585, !tbaa !6586
  %22 = call i32 @nd_hash_iter_status() #21, !dbg !6587
  %23 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6588, !tbaa !657
  %24 = getelementptr inbounds %struct.aws_hash_iter, %struct.aws_hash_iter* %23, i32 0, i32 4, !dbg !6589
  store i32 %22, i32* %24, align 4, !dbg !6590, !tbaa !6591
  ret void, !dbg !6592
}

declare !dbg !497 noalias i8* @nd_voidp() #4

; Function Attrs: argmemonly nounwind
declare !dbg !500 i32 @nd_hash_iter_status() #11

; Function Attrs: nounwind ssp
define void @mk_valid_aws_hash_iter(%struct.aws_hash_iter* %0, %struct.aws_hash_table* %1) #0 !dbg !6593 {
  %3 = alloca %struct.aws_hash_iter*, align 4
  %4 = alloca %struct.aws_hash_table*, align 4
  store %struct.aws_hash_iter* %0, %struct.aws_hash_iter** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_iter** %3, metadata !6595, metadata !DIExpression()), !dbg !6597
  store %struct.aws_hash_table* %1, %struct.aws_hash_table** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %4, metadata !6596, metadata !DIExpression()), !dbg !6598
  %5 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6599, !tbaa !657
  %6 = load %struct.aws_hash_table*, %struct.aws_hash_table** %4, align 4, !dbg !6600, !tbaa !657
  call void @initialize_aws_hash_iter(%struct.aws_hash_iter* %5, %struct.aws_hash_table* %6) #17, !dbg !6601
  %7 = load %struct.aws_hash_iter*, %struct.aws_hash_iter** %3, align 4, !dbg !6602, !tbaa !657
  %8 = call zeroext i1 @aws_hash_iter_is_valid(%struct.aws_hash_iter* %7) #17, !dbg !6603
  call void @__SEA_assume(i1 zeroext %8) #17, !dbg !6604
  ret void, !dbg !6605
}

declare !dbg !503 zeroext i1 @aws_hash_iter_is_valid(%struct.aws_hash_iter*) #4

; Function Attrs: nounwind ssp
define void @save_byte_from_hash_table(%struct.aws_hash_table* %0, %struct.store_byte_from_buffer* %1) #0 !dbg !6606 {
  %3 = alloca %struct.aws_hash_table*, align 4
  %4 = alloca %struct.store_byte_from_buffer*, align 4
  %5 = alloca %struct.hash_table_state*, align 4
  %6 = alloca i32, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %3, metadata !6610, metadata !DIExpression()), !dbg !6614
  store %struct.store_byte_from_buffer* %1, %struct.store_byte_from_buffer** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %4, metadata !6611, metadata !DIExpression()), !dbg !6615
  %7 = bitcast %struct.hash_table_state** %5 to i8*, !dbg !6616
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !6616
  call void @llvm.dbg.declare(metadata %struct.hash_table_state** %5, metadata !6612, metadata !DIExpression()), !dbg !6617
  %8 = load %struct.aws_hash_table*, %struct.aws_hash_table** %3, align 4, !dbg !6618, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %8, i32 0, i32 0, !dbg !6619
  %10 = load %struct.hash_table_state*, %struct.hash_table_state** %9, align 4, !dbg !6619, !tbaa !6531
  store %struct.hash_table_state* %10, %struct.hash_table_state** %5, align 4, !dbg !6617, !tbaa !657
  %11 = bitcast i32* %6 to i8*, !dbg !6620
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %11) #19, !dbg !6620
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6613, metadata !DIExpression()), !dbg !6621
  %12 = call i32 @nd_size_t() #21, !dbg !6622
  store i32 %12, i32* %6, align 4, !dbg !6621, !tbaa !663
  %13 = load %struct.hash_table_state*, %struct.hash_table_state** %5, align 4, !dbg !6623, !tbaa !657
  %14 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %13, i32 0, i32 5, !dbg !6624
  %15 = load i32, i32* %14, align 4, !dbg !6624, !tbaa !663
  %16 = call i32 @hash_table_state_required_bytes(i32 %15, i32* %6) #17, !dbg !6625
  %17 = icmp eq i32 %16, 0, !dbg !6626
  call void @__SEA_assume(i1 zeroext %17) #17, !dbg !6627
  %18 = load %struct.hash_table_state*, %struct.hash_table_state** %5, align 4, !dbg !6628, !tbaa !657
  %19 = bitcast %struct.hash_table_state* %18 to i8*, !dbg !6629
  %20 = load i32, i32* %6, align 4, !dbg !6630, !tbaa !663
  %21 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6631, !tbaa !657
  call void @save_byte_from_array(i8* %19, i32 %20, %struct.store_byte_from_buffer* %21) #17, !dbg !6632
  %22 = bitcast i32* %6 to i8*, !dbg !6633
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %22) #19, !dbg !6633
  %23 = bitcast %struct.hash_table_state** %5 to i8*, !dbg !6633
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %23) #19, !dbg !6633
  ret void, !dbg !6633
}

; Function Attrs: nounwind ssp
define void @save_byte_from_array(i8* %0, i32 %1, %struct.store_byte_from_buffer* %2) #0 !dbg !6634 {
  %4 = alloca i8*, align 4
  %5 = alloca i32, align 4
  %6 = alloca %struct.store_byte_from_buffer*, align 4
  store i8* %0, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !6646, metadata !DIExpression()), !dbg !6649
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6647, metadata !DIExpression()), !dbg !6650
  store %struct.store_byte_from_buffer* %2, %struct.store_byte_from_buffer** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %6, metadata !6648, metadata !DIExpression()), !dbg !6651
  %7 = call i32 @nd_size_t() #21, !dbg !6652
  %8 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !6653, !tbaa !657
  %9 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %8, i32 0, i32 0, !dbg !6654
  store i32 %7, i32* %9, align 4, !dbg !6655, !tbaa !6656
  %10 = load i32, i32* %5, align 4, !dbg !6658, !tbaa !663
  %11 = icmp ugt i32 %10, 0, !dbg !6660
  br i1 %11, label %12, label %32, !dbg !6661

12:                                               ; preds = %3
  %13 = load i8*, i8** %4, align 4, !dbg !6662, !tbaa !657
  %14 = icmp ne i8* %13, null, !dbg !6662
  br i1 %14, label %15, label %32, !dbg !6663

15:                                               ; preds = %12
  %16 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !6664, !tbaa !657
  %17 = icmp ne %struct.store_byte_from_buffer* %16, null, !dbg !6664
  br i1 %17, label %18, label %32, !dbg !6665

18:                                               ; preds = %15
  %19 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !6666, !tbaa !657
  %20 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %19, i32 0, i32 0, !dbg !6668
  %21 = load i32, i32* %20, align 4, !dbg !6668, !tbaa !6656
  %22 = load i32, i32* %5, align 4, !dbg !6669, !tbaa !663
  %23 = icmp ult i32 %21, %22, !dbg !6670
  call void @__SEA_assume(i1 zeroext %23) #17, !dbg !6671
  %24 = load i8*, i8** %4, align 4, !dbg !6672, !tbaa !657
  %25 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !6673, !tbaa !657
  %26 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %25, i32 0, i32 0, !dbg !6674
  %27 = load i32, i32* %26, align 4, !dbg !6674, !tbaa !6656
  %28 = getelementptr inbounds i8, i8* %24, i32 %27, !dbg !6672
  %29 = load i8, i8* %28, align 1, !dbg !6672, !tbaa !1034
  %30 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !6675, !tbaa !657
  %31 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %30, i32 0, i32 1, !dbg !6676
  store i8 %29, i8* %31, align 4, !dbg !6677, !tbaa !6678
  br label %36, !dbg !6679

32:                                               ; preds = %15, %12, %3
  %33 = call zeroext i8 @nd_uint8_t() #21, !dbg !6680
  %34 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !6682, !tbaa !657
  %35 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %34, i32 0, i32 1, !dbg !6683
  store i8 %33, i8* %35, align 4, !dbg !6684, !tbaa !6678
  br label %36

36:                                               ; preds = %32, %18
  ret void, !dbg !6685
}

; Function Attrs: argmemonly nounwind
declare !dbg !575 zeroext i8 @nd_uint8_t() #11

; Function Attrs: nounwind ssp
define void @assert_hash_table_unchanged(%struct.aws_hash_table* %0, %struct.store_byte_from_buffer* %1) #0 !dbg !6686 {
  %3 = alloca %struct.aws_hash_table*, align 4
  %4 = alloca %struct.store_byte_from_buffer*, align 4
  %5 = alloca %struct.hash_table_state*, align 4
  %6 = alloca i8*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %3, metadata !6690, metadata !DIExpression()), !dbg !6694
  store %struct.store_byte_from_buffer* %1, %struct.store_byte_from_buffer** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %4, metadata !6691, metadata !DIExpression()), !dbg !6695
  %7 = bitcast %struct.hash_table_state** %5 to i8*, !dbg !6696
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !6696
  call void @llvm.dbg.declare(metadata %struct.hash_table_state** %5, metadata !6692, metadata !DIExpression()), !dbg !6697
  %8 = load %struct.aws_hash_table*, %struct.aws_hash_table** %3, align 4, !dbg !6698, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %8, i32 0, i32 0, !dbg !6699
  %10 = load %struct.hash_table_state*, %struct.hash_table_state** %9, align 4, !dbg !6699, !tbaa !6531
  store %struct.hash_table_state* %10, %struct.hash_table_state** %5, align 4, !dbg !6697, !tbaa !657
  %11 = bitcast i8** %6 to i8*, !dbg !6700
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %11) #19, !dbg !6700
  call void @llvm.dbg.declare(metadata i8** %6, metadata !6693, metadata !DIExpression()), !dbg !6701
  %12 = load %struct.hash_table_state*, %struct.hash_table_state** %5, align 4, !dbg !6702, !tbaa !657
  %13 = bitcast %struct.hash_table_state* %12 to i8*, !dbg !6703
  store i8* %13, i8** %6, align 4, !dbg !6701, !tbaa !657
  %14 = load %struct.hash_table_state*, %struct.hash_table_state** %5, align 4, !dbg !6704, !tbaa !657
  %15 = bitcast %struct.hash_table_state* %14 to i8*, !dbg !6705
  %16 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6706, !tbaa !657
  call void @assert_byte_from_buffer_matches(i8* %15, %struct.store_byte_from_buffer* %16) #17, !dbg !6707
  %17 = bitcast i8** %6 to i8*, !dbg !6708
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %17) #19, !dbg !6708
  %18 = bitcast %struct.hash_table_state** %5 to i8*, !dbg !6708
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %18) #19, !dbg !6708
  ret void, !dbg !6708
}

; Function Attrs: nounwind ssp
define void @assert_byte_from_buffer_matches(i8* %0, %struct.store_byte_from_buffer* %1) #0 !dbg !6709 {
  %3 = alloca i8*, align 4
  %4 = alloca %struct.store_byte_from_buffer*, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !6716, metadata !DIExpression()), !dbg !6718
  store %struct.store_byte_from_buffer* %1, %struct.store_byte_from_buffer** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %4, metadata !6717, metadata !DIExpression()), !dbg !6719
  %5 = load i8*, i8** %3, align 4, !dbg !6720, !tbaa !657
  %6 = icmp ne i8* %5, null, !dbg !6720
  br i1 %6, label %7, label %39, !dbg !6722

7:                                                ; preds = %2
  %8 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6723, !tbaa !657
  %9 = icmp ne %struct.store_byte_from_buffer* %8, null, !dbg !6723
  br i1 %9, label %10, label %39, !dbg !6724

10:                                               ; preds = %7
  %11 = load i8*, i8** %3, align 4, !dbg !6725, !tbaa !657
  %12 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6725, !tbaa !657
  %13 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %12, i32 0, i32 0, !dbg !6725
  %14 = load i32, i32* %13, align 4, !dbg !6725, !tbaa !6656
  %15 = getelementptr inbounds i8, i8* %11, i32 %14, !dbg !6725
  %16 = load i8, i8* %15, align 1, !dbg !6725, !tbaa !1034
  %17 = zext i8 %16 to i32, !dbg !6725
  %18 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6725, !tbaa !657
  %19 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %18, i32 0, i32 1, !dbg !6725
  %20 = load i8, i8* %19, align 4, !dbg !6725, !tbaa !6678
  %21 = zext i8 %20 to i32, !dbg !6725
  %22 = icmp eq i32 %17, %21, !dbg !6725
  call void @__VERIFIER_assert(i1 zeroext %22) #17, !dbg !6725
  %23 = load i8*, i8** %3, align 4, !dbg !6725, !tbaa !657
  %24 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6725, !tbaa !657
  %25 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %24, i32 0, i32 0, !dbg !6725
  %26 = load i32, i32* %25, align 4, !dbg !6725, !tbaa !6656
  %27 = getelementptr inbounds i8, i8* %23, i32 %26, !dbg !6725
  %28 = load i8, i8* %27, align 1, !dbg !6725, !tbaa !1034
  %29 = zext i8 %28 to i32, !dbg !6725
  %30 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %4, align 4, !dbg !6725, !tbaa !657
  %31 = getelementptr inbounds %struct.store_byte_from_buffer, %struct.store_byte_from_buffer* %30, i32 0, i32 1, !dbg !6725
  %32 = load i8, i8* %31, align 4, !dbg !6725, !tbaa !6678
  %33 = zext i8 %32 to i32, !dbg !6725
  %34 = icmp eq i32 %29, %33, !dbg !6725
  br i1 %34, label %36, label %35, !dbg !6725

35:                                               ; preds = %10
  call void @__VERIFIER_error() #17, !dbg !6725
  br label %36, !dbg !6725

36:                                               ; preds = %35, %10
  %37 = phi i1 [ true, %10 ], [ false, %35 ]
  %38 = zext i1 %37 to i32, !dbg !6725
  br label %39, !dbg !6727

39:                                               ; preds = %36, %7, %2
  ret void, !dbg !6728
}

; Function Attrs: nounwind ssp
define void @ensure_hash_table_has_valid_destroy_functions(%struct.aws_hash_table* %0) #0 !dbg !6729 {
  %2 = alloca %struct.aws_hash_table*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %2, metadata !6733, metadata !DIExpression()), !dbg !6734
  %3 = call zeroext i1 @nd_bool() #21, !dbg !6735
  %4 = zext i1 %3 to i64, !dbg !6735
  %5 = select i1 %3, void (i8*)* null, void (i8*)* @hash_proof_destroy_noop, !dbg !6735
  %6 = load %struct.aws_hash_table*, %struct.aws_hash_table** %2, align 4, !dbg !6736, !tbaa !657
  %7 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %6, i32 0, i32 0, !dbg !6737
  %8 = load %struct.hash_table_state*, %struct.hash_table_state** %7, align 4, !dbg !6737, !tbaa !6531
  %9 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %8, i32 0, i32 2, !dbg !6738
  store void (i8*)* %5, void (i8*)** %9, align 4, !dbg !6739, !tbaa !657
  %10 = call zeroext i1 @nd_bool() #21, !dbg !6740
  %11 = zext i1 %10 to i64, !dbg !6740
  %12 = select i1 %10, void (i8*)* null, void (i8*)* @hash_proof_destroy_noop, !dbg !6740
  %13 = load %struct.aws_hash_table*, %struct.aws_hash_table** %2, align 4, !dbg !6741, !tbaa !657
  %14 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %13, i32 0, i32 0, !dbg !6742
  %15 = load %struct.hash_table_state*, %struct.hash_table_state** %14, align 4, !dbg !6742, !tbaa !6531
  %16 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %15, i32 0, i32 3, !dbg !6743
  store void (i8*)* %12, void (i8*)** %16, align 4, !dbg !6744, !tbaa !657
  ret void, !dbg !6745
}

; Function Attrs: nounwind ssp
define zeroext i1 @hash_table_state_has_an_empty_slot(%struct.hash_table_state* %0, i32* %1) #0 !dbg !6746 {
  %3 = alloca %struct.hash_table_state*, align 4
  %4 = alloca i32*, align 4
  %5 = alloca i32, align 4
  store %struct.hash_table_state* %0, %struct.hash_table_state** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.hash_table_state** %3, metadata !6754, metadata !DIExpression()), !dbg !6757
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !6755, metadata !DIExpression()), !dbg !6758
  %6 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6759, !tbaa !657
  %7 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %6, i32 0, i32 6, !dbg !6760
  %8 = load i32, i32* %7, align 4, !dbg !6760, !tbaa !663
  %9 = icmp ugt i32 %8, 0, !dbg !6761
  call void @__SEA_assume(i1 zeroext %9) #17, !dbg !6762
  %10 = bitcast i32* %5 to i8*, !dbg !6763
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %10) #19, !dbg !6763
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6756, metadata !DIExpression()), !dbg !6764
  %11 = call i32 @nd_size_t() #21, !dbg !6765
  store i32 %11, i32* %5, align 4, !dbg !6764, !tbaa !663
  %12 = load i32, i32* %5, align 4, !dbg !6766, !tbaa !663
  %13 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6767, !tbaa !657
  %14 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %13, i32 0, i32 5, !dbg !6768
  %15 = load i32, i32* %14, align 4, !dbg !6768, !tbaa !663
  %16 = icmp ult i32 %12, %15, !dbg !6769
  call void @__SEA_assume(i1 zeroext %16) #17, !dbg !6770
  %17 = load i32, i32* %5, align 4, !dbg !6771, !tbaa !663
  %18 = load i32*, i32** %4, align 4, !dbg !6772, !tbaa !657
  store i32 %17, i32* %18, align 4, !dbg !6773, !tbaa !663
  %19 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6774, !tbaa !657
  %20 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %19, i32 0, i32 10, !dbg !6775
  %21 = load i32, i32* %5, align 4, !dbg !6776, !tbaa !663
  %22 = getelementptr inbounds [0 x %struct.hash_table_entry], [0 x %struct.hash_table_entry]* %20, i32 0, i32 %21, !dbg !6774
  %23 = getelementptr inbounds %struct.hash_table_entry, %struct.hash_table_entry* %22, i32 0, i32 1, !dbg !6777
  %24 = load i64, i64* %23, align 4, !dbg !6777, !tbaa !6778
  %25 = icmp eq i64 %24, 0, !dbg !6780
  %26 = bitcast i32* %5 to i8*, !dbg !6781
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %26) #19, !dbg !6781
  ret i1 %25, !dbg !6782
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_hash_table_has_an_empty_slot(%struct.aws_hash_table* %0, i32* %1) #0 !dbg !6783 {
  %3 = alloca %struct.aws_hash_table*, align 4
  %4 = alloca i32*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %3, metadata !6788, metadata !DIExpression()), !dbg !6790
  store i32* %1, i32** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %4, metadata !6789, metadata !DIExpression()), !dbg !6791
  %5 = load %struct.aws_hash_table*, %struct.aws_hash_table** %3, align 4, !dbg !6792, !tbaa !657
  %6 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %5, i32 0, i32 0, !dbg !6793
  %7 = load %struct.hash_table_state*, %struct.hash_table_state** %6, align 4, !dbg !6793, !tbaa !6531
  %8 = load i32*, i32** %4, align 4, !dbg !6794, !tbaa !657
  %9 = call zeroext i1 @hash_table_state_has_an_empty_slot(%struct.hash_table_state* %7, i32* %8) #17, !dbg !6795
  ret i1 %9, !dbg !6796
}

; Function Attrs: nounwind ssp
define i32 @aws_hash_table_deep_entry_count(%struct.aws_hash_table* %0) #0 !dbg !6797 {
  %2 = alloca %struct.aws_hash_table*, align 4
  %3 = alloca %struct.hash_table_state*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca %struct.hash_table_entry*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %2, metadata !6801, metadata !DIExpression()), !dbg !6810
  %7 = bitcast %struct.hash_table_state** %3 to i8*, !dbg !6811
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !6811
  call void @llvm.dbg.declare(metadata %struct.hash_table_state** %3, metadata !6802, metadata !DIExpression()), !dbg !6812
  %8 = load %struct.aws_hash_table*, %struct.aws_hash_table** %2, align 4, !dbg !6813, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %8, i32 0, i32 0, !dbg !6814
  %10 = load %struct.hash_table_state*, %struct.hash_table_state** %9, align 4, !dbg !6814, !tbaa !6531
  store %struct.hash_table_state* %10, %struct.hash_table_state** %3, align 4, !dbg !6812, !tbaa !657
  %11 = bitcast i32* %4 to i8*, !dbg !6815
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %11) #19, !dbg !6815
  call void @llvm.dbg.declare(metadata i32* %4, metadata !6803, metadata !DIExpression()), !dbg !6816
  store i32 0, i32* %4, align 4, !dbg !6816, !tbaa !663
  %12 = bitcast i32* %5 to i8*, !dbg !6817
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !6817
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6804, metadata !DIExpression()), !dbg !6818
  store i32 0, i32* %5, align 4, !dbg !6818, !tbaa !663
  br label %13, !dbg !6817

13:                                               ; preds = %36, %1
  %14 = load i32, i32* %5, align 4, !dbg !6819, !tbaa !663
  %15 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6820, !tbaa !657
  %16 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %15, i32 0, i32 5, !dbg !6821
  %17 = load i32, i32* %16, align 4, !dbg !6821, !tbaa !663
  %18 = icmp ult i32 %14, %17, !dbg !6822
  br i1 %18, label %21, label %19, !dbg !6823

19:                                               ; preds = %13
  %20 = bitcast i32* %5 to i8*, !dbg !6824
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %20) #19, !dbg !6824
  br label %39

21:                                               ; preds = %13
  %22 = bitcast %struct.hash_table_entry** %6 to i8*, !dbg !6825
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %22) #19, !dbg !6825
  call void @llvm.dbg.declare(metadata %struct.hash_table_entry** %6, metadata !6806, metadata !DIExpression()), !dbg !6826
  %23 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6827, !tbaa !657
  %24 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %23, i32 0, i32 10, !dbg !6828
  %25 = load i32, i32* %5, align 4, !dbg !6829, !tbaa !663
  %26 = getelementptr inbounds [0 x %struct.hash_table_entry], [0 x %struct.hash_table_entry]* %24, i32 0, i32 %25, !dbg !6827
  store %struct.hash_table_entry* %26, %struct.hash_table_entry** %6, align 4, !dbg !6826, !tbaa !657
  %27 = load %struct.hash_table_entry*, %struct.hash_table_entry** %6, align 4, !dbg !6830, !tbaa !657
  %28 = getelementptr inbounds %struct.hash_table_entry, %struct.hash_table_entry* %27, i32 0, i32 1, !dbg !6832
  %29 = load i64, i64* %28, align 4, !dbg !6832, !tbaa !6778
  %30 = icmp ne i64 %29, 0, !dbg !6830
  br i1 %30, label %31, label %34, !dbg !6833

31:                                               ; preds = %21
  %32 = load i32, i32* %4, align 4, !dbg !6834, !tbaa !663
  %33 = add i32 %32, 1, !dbg !6834
  store i32 %33, i32* %4, align 4, !dbg !6834, !tbaa !663
  br label %34, !dbg !6836

34:                                               ; preds = %31, %21
  %35 = bitcast %struct.hash_table_entry** %6 to i8*, !dbg !6837
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %35) #19, !dbg !6837
  br label %36, !dbg !6838

36:                                               ; preds = %34
  %37 = load i32, i32* %5, align 4, !dbg !6839, !tbaa !663
  %38 = add i32 %37, 1, !dbg !6839
  store i32 %38, i32* %5, align 4, !dbg !6839, !tbaa !663
  br label %13, !dbg !6824, !llvm.loop !6840

39:                                               ; preds = %19
  %40 = load i32, i32* %4, align 4, !dbg !6842, !tbaa !663
  %41 = bitcast i32* %4 to i8*, !dbg !6843
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %41) #19, !dbg !6843
  %42 = bitcast %struct.hash_table_state** %3 to i8*, !dbg !6843
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %42) #19, !dbg !6843
  ret i32 %40, !dbg !6844
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_hash_table_entry_count_is_valid(%struct.aws_hash_table* %0) #0 !dbg !6845 {
  %2 = alloca %struct.aws_hash_table*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %2, metadata !6849, metadata !DIExpression()), !dbg !6850
  %3 = load %struct.aws_hash_table*, %struct.aws_hash_table** %2, align 4, !dbg !6851, !tbaa !657
  %4 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %3, i32 0, i32 0, !dbg !6852
  %5 = load %struct.hash_table_state*, %struct.hash_table_state** %4, align 4, !dbg !6852, !tbaa !6531
  %6 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %5, i32 0, i32 6, !dbg !6853
  %7 = load i32, i32* %6, align 4, !dbg !6853, !tbaa !663
  %8 = load %struct.aws_hash_table*, %struct.aws_hash_table** %2, align 4, !dbg !6854, !tbaa !657
  %9 = call i32 @aws_hash_table_deep_entry_count(%struct.aws_hash_table* %8) #17, !dbg !6855
  %10 = icmp eq i32 %7, %9, !dbg !6856
  ret i1 %10, !dbg !6857
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_hash_table_deep_is_empty(%struct.aws_hash_table* %0) #0 !dbg !6858 {
  %2 = alloca %struct.aws_hash_table*, align 4
  %3 = alloca %struct.hash_table_state*, align 4
  %4 = alloca i8, align 1
  %5 = alloca i32, align 4
  %6 = alloca %struct.hash_table_entry*, align 4
  store %struct.aws_hash_table* %0, %struct.aws_hash_table** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_hash_table** %2, metadata !6860, metadata !DIExpression()), !dbg !6868
  %7 = bitcast %struct.hash_table_state** %3 to i8*, !dbg !6869
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %7) #19, !dbg !6869
  call void @llvm.dbg.declare(metadata %struct.hash_table_state** %3, metadata !6861, metadata !DIExpression()), !dbg !6870
  %8 = load %struct.aws_hash_table*, %struct.aws_hash_table** %2, align 4, !dbg !6871, !tbaa !657
  %9 = getelementptr inbounds %struct.aws_hash_table, %struct.aws_hash_table* %8, i32 0, i32 0, !dbg !6872
  %10 = load %struct.hash_table_state*, %struct.hash_table_state** %9, align 4, !dbg !6872, !tbaa !6531
  store %struct.hash_table_state* %10, %struct.hash_table_state** %3, align 4, !dbg !6870, !tbaa !657
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %4) #19, !dbg !6873
  call void @llvm.dbg.declare(metadata i8* %4, metadata !6862, metadata !DIExpression()), !dbg !6874
  store i8 1, i8* %4, align 1, !dbg !6874, !tbaa !844
  %11 = bitcast i32* %5 to i8*, !dbg !6875
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %11) #19, !dbg !6875
  call void @llvm.dbg.declare(metadata i32* %5, metadata !6863, metadata !DIExpression()), !dbg !6876
  store i32 0, i32* %5, align 4, !dbg !6876, !tbaa !663
  br label %12, !dbg !6875

12:                                               ; preds = %37, %1
  %13 = load i32, i32* %5, align 4, !dbg !6877, !tbaa !663
  %14 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6878, !tbaa !657
  %15 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %14, i32 0, i32 5, !dbg !6879
  %16 = load i32, i32* %15, align 4, !dbg !6879, !tbaa !663
  %17 = icmp ult i32 %13, %16, !dbg !6880
  br i1 %17, label %20, label %18, !dbg !6881

18:                                               ; preds = %12
  %19 = bitcast i32* %5 to i8*, !dbg !6882
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %19) #19, !dbg !6882
  br label %40

20:                                               ; preds = %12
  %21 = bitcast %struct.hash_table_entry** %6 to i8*, !dbg !6883
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %21) #19, !dbg !6883
  call void @llvm.dbg.declare(metadata %struct.hash_table_entry** %6, metadata !6865, metadata !DIExpression()), !dbg !6884
  %22 = load %struct.hash_table_state*, %struct.hash_table_state** %3, align 4, !dbg !6885, !tbaa !657
  %23 = getelementptr inbounds %struct.hash_table_state, %struct.hash_table_state* %22, i32 0, i32 10, !dbg !6886
  %24 = load i32, i32* %5, align 4, !dbg !6887, !tbaa !663
  %25 = getelementptr inbounds [0 x %struct.hash_table_entry], [0 x %struct.hash_table_entry]* %23, i32 0, i32 %24, !dbg !6885
  store %struct.hash_table_entry* %25, %struct.hash_table_entry** %6, align 4, !dbg !6884, !tbaa !657
  %26 = load i8, i8* %4, align 1, !dbg !6888, !tbaa !844, !range !849
  %27 = trunc i8 %26 to i1, !dbg !6888
  br i1 %27, label %28, label %33, !dbg !6889

28:                                               ; preds = %20
  %29 = load %struct.hash_table_entry*, %struct.hash_table_entry** %6, align 4, !dbg !6890, !tbaa !657
  %30 = getelementptr inbounds %struct.hash_table_entry, %struct.hash_table_entry* %29, i32 0, i32 1, !dbg !6891
  %31 = load i64, i64* %30, align 4, !dbg !6891, !tbaa !6778
  %32 = icmp eq i64 %31, 0, !dbg !6892
  br label %33

33:                                               ; preds = %28, %20
  %34 = phi i1 [ false, %20 ], [ %32, %28 ], !dbg !6893
  %35 = zext i1 %34 to i8, !dbg !6894
  store i8 %35, i8* %4, align 1, !dbg !6894, !tbaa !844
  %36 = bitcast %struct.hash_table_entry** %6 to i8*, !dbg !6895
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %36) #19, !dbg !6895
  br label %37, !dbg !6896

37:                                               ; preds = %33
  %38 = load i32, i32* %5, align 4, !dbg !6897, !tbaa !663
  %39 = add i32 %38, 1, !dbg !6897
  store i32 %39, i32* %5, align 4, !dbg !6897, !tbaa !663
  br label %12, !dbg !6882, !llvm.loop !6898

40:                                               ; preds = %18
  %41 = load i8, i8* %4, align 1, !dbg !6900, !tbaa !844, !range !849
  %42 = trunc i8 %41 to i1, !dbg !6900
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %4) #19, !dbg !6901
  %43 = bitcast %struct.hash_table_state** %3 to i8*, !dbg !6901
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %43) #19, !dbg !6901
  ret i1 %42, !dbg !6902
}

; Function Attrs: nounwind ssp
define void @assert_bytes_match(i8* %0, i8* %1, i32 %2) #0 !dbg !6903 {
  %4 = alloca i8*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store i8* %0, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !6907, metadata !DIExpression()), !dbg !6913
  store i8* %1, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !6908, metadata !DIExpression()), !dbg !6914
  store i32 %2, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6909, metadata !DIExpression()), !dbg !6915
  %8 = load i32, i32* %6, align 4, !dbg !6916, !tbaa !663
  %9 = icmp eq i32 %8, 0, !dbg !6916
  br i1 %9, label %20, label %10, !dbg !6916

10:                                               ; preds = %3
  %11 = load i8*, i8** %4, align 4, !dbg !6916, !tbaa !657
  %12 = icmp ne i8* %11, null, !dbg !6916
  %13 = xor i1 %12, true, !dbg !6916
  %14 = zext i1 %13 to i32, !dbg !6916
  %15 = load i8*, i8** %5, align 4, !dbg !6916, !tbaa !657
  %16 = icmp ne i8* %15, null, !dbg !6916
  %17 = xor i1 %16, true, !dbg !6916
  %18 = zext i1 %17 to i32, !dbg !6916
  %19 = icmp eq i32 %14, %18, !dbg !6916
  br label %20, !dbg !6916

20:                                               ; preds = %10, %3
  %21 = phi i1 [ true, %3 ], [ %19, %10 ]
  call void @__VERIFIER_assert(i1 zeroext %21) #17, !dbg !6916
  %22 = load i32, i32* %6, align 4, !dbg !6916, !tbaa !663
  %23 = icmp eq i32 %22, 0, !dbg !6916
  br i1 %23, label %34, label %24, !dbg !6916

24:                                               ; preds = %20
  %25 = load i8*, i8** %4, align 4, !dbg !6916, !tbaa !657
  %26 = icmp ne i8* %25, null, !dbg !6916
  %27 = xor i1 %26, true, !dbg !6916
  %28 = zext i1 %27 to i32, !dbg !6916
  %29 = load i8*, i8** %5, align 4, !dbg !6916, !tbaa !657
  %30 = icmp ne i8* %29, null, !dbg !6916
  %31 = xor i1 %30, true, !dbg !6916
  %32 = zext i1 %31 to i32, !dbg !6916
  %33 = icmp eq i32 %28, %32, !dbg !6916
  br label %34, !dbg !6916

34:                                               ; preds = %24, %20
  %35 = phi i1 [ true, %20 ], [ %33, %24 ]
  br i1 %35, label %37, label %36, !dbg !6916

36:                                               ; preds = %34
  call void @__VERIFIER_error() #17, !dbg !6916
  br label %37, !dbg !6916

37:                                               ; preds = %36, %34
  %38 = phi i1 [ true, %34 ], [ false, %36 ]
  %39 = zext i1 %38 to i32, !dbg !6916
  %40 = load i32, i32* %6, align 4, !dbg !6917, !tbaa !663
  %41 = icmp ugt i32 %40, 0, !dbg !6918
  br i1 %41, label %42, label %86, !dbg !6919

42:                                               ; preds = %37
  %43 = load i8*, i8** %4, align 4, !dbg !6920, !tbaa !657
  %44 = icmp ne i8* %43, null, !dbg !6921
  br i1 %44, label %45, label %86, !dbg !6922

45:                                               ; preds = %42
  %46 = load i8*, i8** %5, align 4, !dbg !6923, !tbaa !657
  %47 = icmp ne i8* %46, null, !dbg !6924
  br i1 %47, label %48, label %86, !dbg !6925

48:                                               ; preds = %45
  %49 = bitcast i32* %7 to i8*, !dbg !6926
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %49) #19, !dbg !6926
  call void @llvm.dbg.declare(metadata i32* %7, metadata !6910, metadata !DIExpression()), !dbg !6927
  %50 = call i32 @nd_size_t() #21, !dbg !6928
  store i32 %50, i32* %7, align 4, !dbg !6927, !tbaa !663
  %51 = load i32, i32* %7, align 4, !dbg !6929, !tbaa !663
  %52 = load i32, i32* %6, align 4, !dbg !6930, !tbaa !663
  %53 = icmp ult i32 %51, %52, !dbg !6931
  br i1 %53, label %54, label %57, !dbg !6932

54:                                               ; preds = %48
  %55 = load i32, i32* %6, align 4, !dbg !6933, !tbaa !663
  %56 = icmp ult i32 %55, 8388607, !dbg !6934
  br label %57

57:                                               ; preds = %54, %48
  %58 = phi i1 [ false, %48 ], [ %56, %54 ], !dbg !6935
  call void @__SEA_assume(i1 zeroext %58) #17, !dbg !6936
  %59 = load i8*, i8** %4, align 4, !dbg !6937, !tbaa !657
  %60 = load i32, i32* %7, align 4, !dbg !6937, !tbaa !663
  %61 = getelementptr inbounds i8, i8* %59, i32 %60, !dbg !6937
  %62 = load i8, i8* %61, align 1, !dbg !6937, !tbaa !1034
  %63 = zext i8 %62 to i32, !dbg !6937
  %64 = load i8*, i8** %5, align 4, !dbg !6937, !tbaa !657
  %65 = load i32, i32* %7, align 4, !dbg !6937, !tbaa !663
  %66 = getelementptr inbounds i8, i8* %64, i32 %65, !dbg !6937
  %67 = load i8, i8* %66, align 1, !dbg !6937, !tbaa !1034
  %68 = zext i8 %67 to i32, !dbg !6937
  %69 = icmp eq i32 %63, %68, !dbg !6937
  call void @__VERIFIER_assert(i1 zeroext %69) #17, !dbg !6937
  %70 = load i8*, i8** %4, align 4, !dbg !6937, !tbaa !657
  %71 = load i32, i32* %7, align 4, !dbg !6937, !tbaa !663
  %72 = getelementptr inbounds i8, i8* %70, i32 %71, !dbg !6937
  %73 = load i8, i8* %72, align 1, !dbg !6937, !tbaa !1034
  %74 = zext i8 %73 to i32, !dbg !6937
  %75 = load i8*, i8** %5, align 4, !dbg !6937, !tbaa !657
  %76 = load i32, i32* %7, align 4, !dbg !6937, !tbaa !663
  %77 = getelementptr inbounds i8, i8* %75, i32 %76, !dbg !6937
  %78 = load i8, i8* %77, align 1, !dbg !6937, !tbaa !1034
  %79 = zext i8 %78 to i32, !dbg !6937
  %80 = icmp eq i32 %74, %79, !dbg !6937
  br i1 %80, label %82, label %81, !dbg !6937

81:                                               ; preds = %57
  call void @__VERIFIER_error() #17, !dbg !6937
  br label %82, !dbg !6937

82:                                               ; preds = %81, %57
  %83 = phi i1 [ true, %57 ], [ false, %81 ]
  %84 = zext i1 %83 to i32, !dbg !6937
  %85 = bitcast i32* %7 to i8*, !dbg !6938
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %85) #19, !dbg !6938
  br label %86, !dbg !6939

86:                                               ; preds = %82, %45, %42, %37
  ret void, !dbg !6940
}

; Function Attrs: nounwind ssp
define void @assert_all_bytes_are(i8* %0, i8 zeroext %1, i32 %2) #0 !dbg !6941 {
  %4 = alloca i8*, align 4
  %5 = alloca i8, align 1
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store i8* %0, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !6945, metadata !DIExpression()), !dbg !6951
  store i8 %1, i8* %5, align 1, !tbaa !1034
  call void @llvm.dbg.declare(metadata i8* %5, metadata !6946, metadata !DIExpression()), !dbg !6952
  store i32 %2, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !6947, metadata !DIExpression()), !dbg !6953
  %8 = load i32, i32* %6, align 4, !dbg !6954, !tbaa !663
  %9 = icmp ugt i32 %8, 0, !dbg !6955
  br i1 %9, label %10, label %40, !dbg !6956

10:                                               ; preds = %3
  %11 = load i8*, i8** %4, align 4, !dbg !6957, !tbaa !657
  %12 = icmp ne i8* %11, null, !dbg !6958
  br i1 %12, label %13, label %40, !dbg !6959

13:                                               ; preds = %10
  %14 = bitcast i32* %7 to i8*, !dbg !6960
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !6960
  call void @llvm.dbg.declare(metadata i32* %7, metadata !6948, metadata !DIExpression()), !dbg !6961
  %15 = call i32 @nd_size_t() #21, !dbg !6962
  store i32 %15, i32* %7, align 4, !dbg !6961, !tbaa !663
  %16 = load i32, i32* %7, align 4, !dbg !6963, !tbaa !663
  %17 = load i32, i32* %6, align 4, !dbg !6964, !tbaa !663
  %18 = icmp ult i32 %16, %17, !dbg !6965
  call void @__SEA_assume(i1 zeroext %18) #17, !dbg !6966
  %19 = load i8*, i8** %4, align 4, !dbg !6967, !tbaa !657
  %20 = load i32, i32* %7, align 4, !dbg !6967, !tbaa !663
  %21 = getelementptr inbounds i8, i8* %19, i32 %20, !dbg !6967
  %22 = load i8, i8* %21, align 1, !dbg !6967, !tbaa !1034
  %23 = zext i8 %22 to i32, !dbg !6967
  %24 = load i8, i8* %5, align 1, !dbg !6967, !tbaa !1034
  %25 = zext i8 %24 to i32, !dbg !6967
  %26 = icmp eq i32 %23, %25, !dbg !6967
  call void @__VERIFIER_assert(i1 zeroext %26) #17, !dbg !6967
  %27 = load i8*, i8** %4, align 4, !dbg !6967, !tbaa !657
  %28 = load i32, i32* %7, align 4, !dbg !6967, !tbaa !663
  %29 = getelementptr inbounds i8, i8* %27, i32 %28, !dbg !6967
  %30 = load i8, i8* %29, align 1, !dbg !6967, !tbaa !1034
  %31 = zext i8 %30 to i32, !dbg !6967
  %32 = load i8, i8* %5, align 1, !dbg !6967, !tbaa !1034
  %33 = zext i8 %32 to i32, !dbg !6967
  %34 = icmp eq i32 %31, %33, !dbg !6967
  br i1 %34, label %36, label %35, !dbg !6967

35:                                               ; preds = %13
  call void @__VERIFIER_error() #17, !dbg !6967
  br label %36, !dbg !6967

36:                                               ; preds = %35, %13
  %37 = phi i1 [ true, %13 ], [ false, %35 ]
  %38 = zext i1 %37 to i32, !dbg !6967
  %39 = bitcast i32* %7 to i8*, !dbg !6968
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %39) #19, !dbg !6968
  br label %40, !dbg !6969

40:                                               ; preds = %36, %10, %3
  ret void, !dbg !6970
}

; Function Attrs: nounwind ssp
define void @assert_all_zeroes(i8* %0, i32 %1) #0 !dbg !6971 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !6975, metadata !DIExpression()), !dbg !6977
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !6976, metadata !DIExpression()), !dbg !6978
  %5 = load i8*, i8** %3, align 4, !dbg !6979, !tbaa !657
  %6 = load i32, i32* %4, align 4, !dbg !6980, !tbaa !663
  call void @assert_all_bytes_are(i8* %5, i8 zeroext 0, i32 %6) #17, !dbg !6981
  ret void, !dbg !6982
}

; Function Attrs: nounwind ssp
define void @assert_array_list_equivalence(%struct.aws_array_list* %0, %struct.aws_array_list* %1, %struct.store_byte_from_buffer* %2) #0 !dbg !6983 {
  %4 = alloca %struct.aws_array_list*, align 4
  %5 = alloca %struct.aws_array_list*, align 4
  %6 = alloca %struct.store_byte_from_buffer*, align 4
  store %struct.aws_array_list* %0, %struct.aws_array_list** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %4, metadata !7017, metadata !DIExpression()), !dbg !7020
  store %struct.aws_array_list* %1, %struct.aws_array_list** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_array_list** %5, metadata !7018, metadata !DIExpression()), !dbg !7021
  store %struct.store_byte_from_buffer* %2, %struct.store_byte_from_buffer** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %6, metadata !7019, metadata !DIExpression()), !dbg !7022
  %7 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7023, !tbaa !657
  %8 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7025, !tbaa !657
  %9 = icmp eq %struct.aws_array_list* %7, %8, !dbg !7026
  br i1 %9, label %10, label %11, !dbg !7027

10:                                               ; preds = %3
  br label %112, !dbg !7028

11:                                               ; preds = %3
  %12 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7030, !tbaa !657
  %13 = icmp ne %struct.aws_array_list* %12, null, !dbg !7030
  br i1 %13, label %14, label %17, !dbg !7030

14:                                               ; preds = %11
  %15 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7030, !tbaa !657
  %16 = icmp ne %struct.aws_array_list* %15, null, !dbg !7030
  br label %17

17:                                               ; preds = %14, %11
  %18 = phi i1 [ false, %11 ], [ %16, %14 ], !dbg !7032
  call void @__VERIFIER_assert(i1 zeroext %18) #17, !dbg !7030
  %19 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7030, !tbaa !657
  %20 = icmp ne %struct.aws_array_list* %19, null, !dbg !7030
  br i1 %20, label %21, label %24, !dbg !7030

21:                                               ; preds = %17
  %22 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7030, !tbaa !657
  %23 = icmp ne %struct.aws_array_list* %22, null, !dbg !7030
  br label %24

24:                                               ; preds = %21, %17
  %25 = phi i1 [ false, %17 ], [ %23, %21 ], !dbg !7032
  br i1 %25, label %27, label %26, !dbg !7030

26:                                               ; preds = %24
  call void @__VERIFIER_error() #17, !dbg !7030
  br label %27, !dbg !7030

27:                                               ; preds = %26, %24
  %28 = phi i1 [ true, %24 ], [ false, %26 ]
  %29 = zext i1 %28 to i32, !dbg !7030
  br label %30

30:                                               ; preds = %27
  %31 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7033, !tbaa !657
  %32 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %31, i32 0, i32 0, !dbg !7033
  %33 = load %struct.aws_allocator*, %struct.aws_allocator** %32, align 4, !dbg !7033, !tbaa !1629
  %34 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7033, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %34, i32 0, i32 0, !dbg !7033
  %36 = load %struct.aws_allocator*, %struct.aws_allocator** %35, align 4, !dbg !7033, !tbaa !1629
  %37 = icmp eq %struct.aws_allocator* %33, %36, !dbg !7033
  call void @__VERIFIER_assert(i1 zeroext %37) #17, !dbg !7033
  %38 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7033, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %38, i32 0, i32 0, !dbg !7033
  %40 = load %struct.aws_allocator*, %struct.aws_allocator** %39, align 4, !dbg !7033, !tbaa !1629
  %41 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7033, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %41, i32 0, i32 0, !dbg !7033
  %43 = load %struct.aws_allocator*, %struct.aws_allocator** %42, align 4, !dbg !7033, !tbaa !1629
  %44 = icmp eq %struct.aws_allocator* %40, %43, !dbg !7033
  br i1 %44, label %46, label %45, !dbg !7033

45:                                               ; preds = %30
  call void @__VERIFIER_error() #17, !dbg !7033
  br label %46, !dbg !7033

46:                                               ; preds = %45, %30
  %47 = phi i1 [ true, %30 ], [ false, %45 ]
  %48 = zext i1 %47 to i32, !dbg !7033
  %49 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7034, !tbaa !657
  %50 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %49, i32 0, i32 1, !dbg !7034
  %51 = load i32, i32* %50, align 4, !dbg !7034, !tbaa !4012
  %52 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7034, !tbaa !657
  %53 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %52, i32 0, i32 1, !dbg !7034
  %54 = load i32, i32* %53, align 4, !dbg !7034, !tbaa !4012
  %55 = icmp eq i32 %51, %54, !dbg !7034
  call void @__VERIFIER_assert(i1 zeroext %55) #17, !dbg !7034
  %56 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7034, !tbaa !657
  %57 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %56, i32 0, i32 1, !dbg !7034
  %58 = load i32, i32* %57, align 4, !dbg !7034, !tbaa !4012
  %59 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7034, !tbaa !657
  %60 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %59, i32 0, i32 1, !dbg !7034
  %61 = load i32, i32* %60, align 4, !dbg !7034, !tbaa !4012
  %62 = icmp eq i32 %58, %61, !dbg !7034
  br i1 %62, label %64, label %63, !dbg !7034

63:                                               ; preds = %46
  call void @__VERIFIER_error() #17, !dbg !7034
  br label %64, !dbg !7034

64:                                               ; preds = %63, %46
  %65 = phi i1 [ true, %46 ], [ false, %63 ]
  %66 = zext i1 %65 to i32, !dbg !7034
  %67 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7035, !tbaa !657
  %68 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %67, i32 0, i32 2, !dbg !7035
  %69 = load i32, i32* %68, align 4, !dbg !7035, !tbaa !1650
  %70 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7035, !tbaa !657
  %71 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %70, i32 0, i32 2, !dbg !7035
  %72 = load i32, i32* %71, align 4, !dbg !7035, !tbaa !1650
  %73 = icmp eq i32 %69, %72, !dbg !7035
  call void @__VERIFIER_assert(i1 zeroext %73) #17, !dbg !7035
  %74 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7035, !tbaa !657
  %75 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %74, i32 0, i32 2, !dbg !7035
  %76 = load i32, i32* %75, align 4, !dbg !7035, !tbaa !1650
  %77 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7035, !tbaa !657
  %78 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %77, i32 0, i32 2, !dbg !7035
  %79 = load i32, i32* %78, align 4, !dbg !7035, !tbaa !1650
  %80 = icmp eq i32 %76, %79, !dbg !7035
  br i1 %80, label %82, label %81, !dbg !7035

81:                                               ; preds = %64
  call void @__VERIFIER_error() #17, !dbg !7035
  br label %82, !dbg !7035

82:                                               ; preds = %81, %64
  %83 = phi i1 [ true, %64 ], [ false, %81 ]
  %84 = zext i1 %83 to i32, !dbg !7035
  %85 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7036, !tbaa !657
  %86 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %85, i32 0, i32 3, !dbg !7036
  %87 = load i32, i32* %86, align 4, !dbg !7036, !tbaa !1685
  %88 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7036, !tbaa !657
  %89 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %88, i32 0, i32 3, !dbg !7036
  %90 = load i32, i32* %89, align 4, !dbg !7036, !tbaa !1685
  %91 = icmp eq i32 %87, %90, !dbg !7036
  call void @__VERIFIER_assert(i1 zeroext %91) #17, !dbg !7036
  %92 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7036, !tbaa !657
  %93 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %92, i32 0, i32 3, !dbg !7036
  %94 = load i32, i32* %93, align 4, !dbg !7036, !tbaa !1685
  %95 = load %struct.aws_array_list*, %struct.aws_array_list** %5, align 4, !dbg !7036, !tbaa !657
  %96 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %95, i32 0, i32 3, !dbg !7036
  %97 = load i32, i32* %96, align 4, !dbg !7036, !tbaa !1685
  %98 = icmp eq i32 %94, %97, !dbg !7036
  br i1 %98, label %100, label %99, !dbg !7036

99:                                               ; preds = %82
  call void @__VERIFIER_error() #17, !dbg !7036
  br label %100, !dbg !7036

100:                                              ; preds = %99, %82
  %101 = phi i1 [ true, %82 ], [ false, %99 ]
  %102 = zext i1 %101 to i32, !dbg !7036
  %103 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7037, !tbaa !657
  %104 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %103, i32 0, i32 1, !dbg !7039
  %105 = load i32, i32* %104, align 4, !dbg !7039, !tbaa !4012
  %106 = icmp ugt i32 %105, 0, !dbg !7040
  br i1 %106, label %107, label %112, !dbg !7041

107:                                              ; preds = %100
  %108 = load %struct.aws_array_list*, %struct.aws_array_list** %4, align 4, !dbg !7042, !tbaa !657
  %109 = getelementptr inbounds %struct.aws_array_list, %struct.aws_array_list* %108, i32 0, i32 4, !dbg !7044
  %110 = load i8*, i8** %109, align 4, !dbg !7044, !tbaa !1651
  %111 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !7045, !tbaa !657
  call void @assert_byte_from_buffer_matches(i8* %110, %struct.store_byte_from_buffer* %111) #17, !dbg !7046
  br label %112, !dbg !7047

112:                                              ; preds = %107, %100, %10
  ret void, !dbg !7048
}

; Function Attrs: nounwind ssp
define void @assert_byte_buf_equivalence(%struct.aws_byte_buf* %0, %struct.aws_byte_buf* %1, %struct.store_byte_from_buffer* %2) #0 !dbg !7049 {
  %4 = alloca %struct.aws_byte_buf*, align 4
  %5 = alloca %struct.aws_byte_buf*, align 4
  %6 = alloca %struct.store_byte_from_buffer*, align 4
  store %struct.aws_byte_buf* %0, %struct.aws_byte_buf** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %4, metadata !7062, metadata !DIExpression()), !dbg !7065
  store %struct.aws_byte_buf* %1, %struct.aws_byte_buf** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_buf** %5, metadata !7063, metadata !DIExpression()), !dbg !7066
  store %struct.store_byte_from_buffer* %2, %struct.store_byte_from_buffer** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %6, metadata !7064, metadata !DIExpression()), !dbg !7067
  %7 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7068, !tbaa !657
  %8 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7070, !tbaa !657
  %9 = icmp eq %struct.aws_byte_buf* %7, %8, !dbg !7071
  br i1 %9, label %10, label %11, !dbg !7072

10:                                               ; preds = %3
  br label %94, !dbg !7073

11:                                               ; preds = %3
  %12 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7075, !tbaa !657
  %13 = icmp ne %struct.aws_byte_buf* %12, null, !dbg !7075
  br i1 %13, label %14, label %17, !dbg !7075

14:                                               ; preds = %11
  %15 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7075, !tbaa !657
  %16 = icmp ne %struct.aws_byte_buf* %15, null, !dbg !7075
  br label %17

17:                                               ; preds = %14, %11
  %18 = phi i1 [ false, %11 ], [ %16, %14 ], !dbg !7077
  call void @__VERIFIER_assert(i1 zeroext %18) #17, !dbg !7075
  %19 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7075, !tbaa !657
  %20 = icmp ne %struct.aws_byte_buf* %19, null, !dbg !7075
  br i1 %20, label %21, label %24, !dbg !7075

21:                                               ; preds = %17
  %22 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7075, !tbaa !657
  %23 = icmp ne %struct.aws_byte_buf* %22, null, !dbg !7075
  br label %24

24:                                               ; preds = %21, %17
  %25 = phi i1 [ false, %17 ], [ %23, %21 ], !dbg !7077
  br i1 %25, label %27, label %26, !dbg !7075

26:                                               ; preds = %24
  call void @__VERIFIER_error() #17, !dbg !7075
  br label %27, !dbg !7075

27:                                               ; preds = %26, %24
  %28 = phi i1 [ true, %24 ], [ false, %26 ]
  %29 = zext i1 %28 to i32, !dbg !7075
  br label %30

30:                                               ; preds = %27
  %31 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7078, !tbaa !657
  %32 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %31, i32 0, i32 0, !dbg !7078
  %33 = load i32, i32* %32, align 4, !dbg !7078, !tbaa !693
  %34 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7078, !tbaa !657
  %35 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %34, i32 0, i32 0, !dbg !7078
  %36 = load i32, i32* %35, align 4, !dbg !7078, !tbaa !693
  %37 = icmp eq i32 %33, %36, !dbg !7078
  call void @__VERIFIER_assert(i1 zeroext %37) #17, !dbg !7078
  %38 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7078, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %38, i32 0, i32 0, !dbg !7078
  %40 = load i32, i32* %39, align 4, !dbg !7078, !tbaa !693
  %41 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7078, !tbaa !657
  %42 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %41, i32 0, i32 0, !dbg !7078
  %43 = load i32, i32* %42, align 4, !dbg !7078, !tbaa !693
  %44 = icmp eq i32 %40, %43, !dbg !7078
  br i1 %44, label %46, label %45, !dbg !7078

45:                                               ; preds = %30
  call void @__VERIFIER_error() #17, !dbg !7078
  br label %46, !dbg !7078

46:                                               ; preds = %45, %30
  %47 = phi i1 [ true, %30 ], [ false, %45 ]
  %48 = zext i1 %47 to i32, !dbg !7078
  %49 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7079, !tbaa !657
  %50 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %49, i32 0, i32 2, !dbg !7079
  %51 = load i32, i32* %50, align 4, !dbg !7079, !tbaa !698
  %52 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7079, !tbaa !657
  %53 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %52, i32 0, i32 2, !dbg !7079
  %54 = load i32, i32* %53, align 4, !dbg !7079, !tbaa !698
  %55 = icmp eq i32 %51, %54, !dbg !7079
  call void @__VERIFIER_assert(i1 zeroext %55) #17, !dbg !7079
  %56 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7079, !tbaa !657
  %57 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %56, i32 0, i32 2, !dbg !7079
  %58 = load i32, i32* %57, align 4, !dbg !7079, !tbaa !698
  %59 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7079, !tbaa !657
  %60 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %59, i32 0, i32 2, !dbg !7079
  %61 = load i32, i32* %60, align 4, !dbg !7079, !tbaa !698
  %62 = icmp eq i32 %58, %61, !dbg !7079
  br i1 %62, label %64, label %63, !dbg !7079

63:                                               ; preds = %46
  call void @__VERIFIER_error() #17, !dbg !7079
  br label %64, !dbg !7079

64:                                               ; preds = %63, %46
  %65 = phi i1 [ true, %46 ], [ false, %63 ]
  %66 = zext i1 %65 to i32, !dbg !7079
  %67 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7080, !tbaa !657
  %68 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %67, i32 0, i32 3, !dbg !7080
  %69 = load %struct.aws_allocator*, %struct.aws_allocator** %68, align 4, !dbg !7080, !tbaa !703
  %70 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7080, !tbaa !657
  %71 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %70, i32 0, i32 3, !dbg !7080
  %72 = load %struct.aws_allocator*, %struct.aws_allocator** %71, align 4, !dbg !7080, !tbaa !703
  %73 = icmp eq %struct.aws_allocator* %69, %72, !dbg !7080
  call void @__VERIFIER_assert(i1 zeroext %73) #17, !dbg !7080
  %74 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7080, !tbaa !657
  %75 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %74, i32 0, i32 3, !dbg !7080
  %76 = load %struct.aws_allocator*, %struct.aws_allocator** %75, align 4, !dbg !7080, !tbaa !703
  %77 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %5, align 4, !dbg !7080, !tbaa !657
  %78 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %77, i32 0, i32 3, !dbg !7080
  %79 = load %struct.aws_allocator*, %struct.aws_allocator** %78, align 4, !dbg !7080, !tbaa !703
  %80 = icmp eq %struct.aws_allocator* %76, %79, !dbg !7080
  br i1 %80, label %82, label %81, !dbg !7080

81:                                               ; preds = %64
  call void @__VERIFIER_error() #17, !dbg !7080
  br label %82, !dbg !7080

82:                                               ; preds = %81, %64
  %83 = phi i1 [ true, %64 ], [ false, %81 ]
  %84 = zext i1 %83 to i32, !dbg !7080
  %85 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7081, !tbaa !657
  %86 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %85, i32 0, i32 0, !dbg !7083
  %87 = load i32, i32* %86, align 4, !dbg !7083, !tbaa !693
  %88 = icmp ugt i32 %87, 0, !dbg !7084
  br i1 %88, label %89, label %94, !dbg !7085

89:                                               ; preds = %82
  %90 = load %struct.aws_byte_buf*, %struct.aws_byte_buf** %4, align 4, !dbg !7086, !tbaa !657
  %91 = getelementptr inbounds %struct.aws_byte_buf, %struct.aws_byte_buf* %90, i32 0, i32 1, !dbg !7088
  %92 = load i8*, i8** %91, align 4, !dbg !7088, !tbaa !675
  %93 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !7089, !tbaa !657
  call void @assert_byte_from_buffer_matches(i8* %92, %struct.store_byte_from_buffer* %93) #17, !dbg !7090
  br label %94, !dbg !7091

94:                                               ; preds = %89, %82, %10
  ret void, !dbg !7092
}

; Function Attrs: nounwind ssp
define void @assert_byte_cursor_equivalence(%struct.aws_byte_cursor* %0, %struct.aws_byte_cursor* %1, %struct.store_byte_from_buffer* %2) #0 !dbg !7093 {
  %4 = alloca %struct.aws_byte_cursor*, align 4
  %5 = alloca %struct.aws_byte_cursor*, align 4
  %6 = alloca %struct.store_byte_from_buffer*, align 4
  store %struct.aws_byte_cursor* %0, %struct.aws_byte_cursor** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %4, metadata !7104, metadata !DIExpression()), !dbg !7107
  store %struct.aws_byte_cursor* %1, %struct.aws_byte_cursor** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_byte_cursor** %5, metadata !7105, metadata !DIExpression()), !dbg !7108
  store %struct.store_byte_from_buffer* %2, %struct.store_byte_from_buffer** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.store_byte_from_buffer** %6, metadata !7106, metadata !DIExpression()), !dbg !7109
  %7 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7110, !tbaa !657
  %8 = icmp ne %struct.aws_byte_cursor* %7, null, !dbg !7110
  %9 = xor i1 %8, true, !dbg !7110
  %10 = zext i1 %9 to i32, !dbg !7110
  %11 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !7110, !tbaa !657
  %12 = icmp ne %struct.aws_byte_cursor* %11, null, !dbg !7110
  %13 = xor i1 %12, true, !dbg !7110
  %14 = zext i1 %13 to i32, !dbg !7110
  %15 = icmp eq i32 %10, %14, !dbg !7110
  call void @__VERIFIER_assert(i1 zeroext %15) #17, !dbg !7110
  %16 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7110, !tbaa !657
  %17 = icmp ne %struct.aws_byte_cursor* %16, null, !dbg !7110
  %18 = xor i1 %17, true, !dbg !7110
  %19 = zext i1 %18 to i32, !dbg !7110
  %20 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !7110, !tbaa !657
  %21 = icmp ne %struct.aws_byte_cursor* %20, null, !dbg !7110
  %22 = xor i1 %21, true, !dbg !7110
  %23 = zext i1 %22 to i32, !dbg !7110
  %24 = icmp eq i32 %19, %23, !dbg !7110
  br i1 %24, label %26, label %25, !dbg !7110

25:                                               ; preds = %3
  call void @__VERIFIER_error() #17, !dbg !7110
  br label %26, !dbg !7110

26:                                               ; preds = %25, %3
  %27 = phi i1 [ true, %3 ], [ false, %25 ]
  %28 = zext i1 %27 to i32, !dbg !7110
  %29 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7111, !tbaa !657
  %30 = icmp ne %struct.aws_byte_cursor* %29, null, !dbg !7111
  br i1 %30, label %31, label %63, !dbg !7113

31:                                               ; preds = %26
  %32 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !7114, !tbaa !657
  %33 = icmp ne %struct.aws_byte_cursor* %32, null, !dbg !7114
  br i1 %33, label %34, label %63, !dbg !7115

34:                                               ; preds = %31
  %35 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7116, !tbaa !657
  %36 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %35, i32 0, i32 0, !dbg !7116
  %37 = load i32, i32* %36, align 4, !dbg !7116, !tbaa !822
  %38 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !7116, !tbaa !657
  %39 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %38, i32 0, i32 0, !dbg !7116
  %40 = load i32, i32* %39, align 4, !dbg !7116, !tbaa !822
  %41 = icmp eq i32 %37, %40, !dbg !7116
  call void @__VERIFIER_assert(i1 zeroext %41) #17, !dbg !7116
  %42 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7116, !tbaa !657
  %43 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %42, i32 0, i32 0, !dbg !7116
  %44 = load i32, i32* %43, align 4, !dbg !7116, !tbaa !822
  %45 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %5, align 4, !dbg !7116, !tbaa !657
  %46 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %45, i32 0, i32 0, !dbg !7116
  %47 = load i32, i32* %46, align 4, !dbg !7116, !tbaa !822
  %48 = icmp eq i32 %44, %47, !dbg !7116
  br i1 %48, label %50, label %49, !dbg !7116

49:                                               ; preds = %34
  call void @__VERIFIER_error() #17, !dbg !7116
  br label %50, !dbg !7116

50:                                               ; preds = %49, %34
  %51 = phi i1 [ true, %34 ], [ false, %49 ]
  %52 = zext i1 %51 to i32, !dbg !7116
  %53 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7118, !tbaa !657
  %54 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %53, i32 0, i32 0, !dbg !7120
  %55 = load i32, i32* %54, align 4, !dbg !7120, !tbaa !822
  %56 = icmp ugt i32 %55, 0, !dbg !7121
  br i1 %56, label %57, label %62, !dbg !7122

57:                                               ; preds = %50
  %58 = load %struct.aws_byte_cursor*, %struct.aws_byte_cursor** %4, align 4, !dbg !7123, !tbaa !657
  %59 = getelementptr inbounds %struct.aws_byte_cursor, %struct.aws_byte_cursor* %58, i32 0, i32 1, !dbg !7125
  %60 = load i8*, i8** %59, align 4, !dbg !7125, !tbaa !832
  %61 = load %struct.store_byte_from_buffer*, %struct.store_byte_from_buffer** %6, align 4, !dbg !7126, !tbaa !657
  call void @assert_byte_from_buffer_matches(i8* %60, %struct.store_byte_from_buffer* %61) #17, !dbg !7127
  br label %62, !dbg !7128

62:                                               ; preds = %57, %50
  br label %63, !dbg !7129

63:                                               ; preds = %62, %31, %26
  ret void, !dbg !7130
}

; Function Attrs: nounwind ssp
define zeroext i1 @nondet_equals(i8* %0, i8* %1) #0 !dbg !7131 {
  %3 = alloca i8*, align 4
  %4 = alloca i8*, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !7135, metadata !DIExpression()), !dbg !7137
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !7136, metadata !DIExpression()), !dbg !7138
  %5 = load i8*, i8** %3, align 4, !dbg !7139, !tbaa !657
  %6 = icmp ne i8* %5, null, !dbg !7139
  call void @__VERIFIER_assert(i1 zeroext %6) #17, !dbg !7139
  %7 = load i8*, i8** %3, align 4, !dbg !7139, !tbaa !657
  %8 = icmp ne i8* %7, null, !dbg !7139
  br i1 %8, label %10, label %9, !dbg !7139

9:                                                ; preds = %2
  call void @__VERIFIER_error() #17, !dbg !7139
  br label %10, !dbg !7139

10:                                               ; preds = %9, %2
  %11 = phi i1 [ true, %2 ], [ false, %9 ]
  %12 = zext i1 %11 to i32, !dbg !7139
  %13 = load i8*, i8** %4, align 4, !dbg !7140, !tbaa !657
  %14 = icmp ne i8* %13, null, !dbg !7140
  call void @__VERIFIER_assert(i1 zeroext %14) #17, !dbg !7140
  %15 = load i8*, i8** %4, align 4, !dbg !7140, !tbaa !657
  %16 = icmp ne i8* %15, null, !dbg !7140
  br i1 %16, label %18, label %17, !dbg !7140

17:                                               ; preds = %10
  call void @__VERIFIER_error() #17, !dbg !7140
  br label %18, !dbg !7140

18:                                               ; preds = %17, %10
  %19 = phi i1 [ true, %10 ], [ false, %17 ]
  %20 = zext i1 %19 to i32, !dbg !7140
  %21 = load i8*, i8** %3, align 4, !dbg !7141, !tbaa !657
  %22 = load i8*, i8** %4, align 4, !dbg !7142, !tbaa !657
  %23 = icmp eq i8* %21, %22, !dbg !7143
  br i1 %23, label %24, label %25, !dbg !7141

24:                                               ; preds = %18
  br label %28, !dbg !7141

25:                                               ; preds = %18
  %26 = call zeroext i1 @nd_bool() #21, !dbg !7144
  %27 = zext i1 %26 to i32, !dbg !7144
  br label %28, !dbg !7141

28:                                               ; preds = %25, %24
  %29 = phi i32 [ 1, %24 ], [ %27, %25 ], !dbg !7141
  %30 = icmp ne i32 %29, 0, !dbg !7141
  ret i1 %30, !dbg !7145
}

; Function Attrs: nounwind ssp
define i64 @uninterpreted_hasher(i8* %0) #0 !dbg !7146 {
  %2 = alloca i8*, align 4
  store i8* %0, i8** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %2, metadata !7148, metadata !DIExpression()), !dbg !7149
  %3 = call i64 @nd_uint64_t() #21, !dbg !7150
  ret i64 %3, !dbg !7151
}

; Function Attrs: argmemonly nounwind
declare !dbg !578 i64 @nd_uint64_t() #11

; Function Attrs: nounwind ssp allocsize(1)
define i8* @realloc(i8* %0, i32 %1) #15 !dbg !7152 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !7156, metadata !DIExpression()), !dbg !7158
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !7157, metadata !DIExpression()), !dbg !7159
  %5 = load i8*, i8** %3, align 4, !dbg !7160, !tbaa !657
  %6 = load i32, i32* %4, align 4, !dbg !7161, !tbaa !663
  %7 = call i8* @sea_realloc(i8* %5, i32 %6) #17, !dbg !7162
  ret i8* %7, !dbg !7163
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_realloc(i8* %0, i32 %1) #12 !dbg !7164 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  store i8* %0, i8** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %3, metadata !7168, metadata !DIExpression()), !dbg !7170
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !7169, metadata !DIExpression()), !dbg !7171
  %5 = load i8*, i8** %3, align 4, !dbg !7172, !tbaa !657
  %6 = icmp ne i8* %5, null, !dbg !7172
  br i1 %6, label %7, label %9, !dbg !7174

7:                                                ; preds = %2
  %8 = load i8*, i8** %3, align 4, !dbg !7175, !tbaa !657
  call void @sea_free(i8* %8) #17, !dbg !7176
  br label %9, !dbg !7176

9:                                                ; preds = %7, %2
  %10 = load i32, i32* %4, align 4, !dbg !7177, !tbaa !663
  %11 = call i8* @sea_malloc(i32 %10) #17, !dbg !7178
  ret i8* %11, !dbg !7179
}

; Function Attrs: alwaysinline nounwind ssp
define void @sea_free(i8* %0) #12 !dbg !7180 {
  %2 = alloca i8*, align 4
  store i8* %0, i8** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %2, metadata !7182, metadata !DIExpression()), !dbg !7183
  %3 = load i8*, i8** %2, align 4, !dbg !7184, !tbaa !657
  call void @free(i8* %3) #17, !dbg !7185
  ret void, !dbg !7186
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc_safe(i32 %0) #12 !dbg !7187 {
  %2 = alloca i32, align 4
  %3 = alloca i8*, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !7189, metadata !DIExpression()), !dbg !7191
  %4 = bitcast i8** %3 to i8*, !dbg !7192
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !7192
  call void @llvm.dbg.declare(metadata i8** %3, metadata !7190, metadata !DIExpression()), !dbg !7193
  %5 = load i32, i32* %2, align 4, !dbg !7194, !tbaa !663
  %6 = call i8* @malloc(i32 %5) #22, !dbg !7195
  store i8* %6, i8** %3, align 4, !dbg !7193, !tbaa !657
  %7 = load i8*, i8** %3, align 4, !dbg !7196, !tbaa !657
  %8 = icmp ne i8* %7, null, !dbg !7196
  call void @__SEA_assume(i1 zeroext %8) #17, !dbg !7197
  %9 = load i8*, i8** %3, align 4, !dbg !7198, !tbaa !657
  %10 = bitcast i8** %3 to i8*, !dbg !7199
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #19, !dbg !7199
  ret i8* %9, !dbg !7200
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @sea_malloc_aligned_safe(i32 %0) #12 !dbg !7201 {
  %2 = alloca i32, align 4
  %3 = alloca i8*, align 4
  store i32 %0, i32* %2, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %2, metadata !7203, metadata !DIExpression()), !dbg !7205
  %4 = bitcast i8** %3 to i8*, !dbg !7206
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #19, !dbg !7206
  call void @llvm.dbg.declare(metadata i8** %3, metadata !7204, metadata !DIExpression()), !dbg !7207
  %5 = load i32, i32* %2, align 4, !dbg !7208, !tbaa !663
  %6 = call i8* @sea_malloc_aligned(i32 %5) #17, !dbg !7209
  store i8* %6, i8** %3, align 4, !dbg !7207, !tbaa !657
  %7 = load i8*, i8** %3, align 4, !dbg !7210, !tbaa !657
  %8 = icmp ne i8* %7, null, !dbg !7210
  call void @__SEA_assume(i1 zeroext %8) #17, !dbg !7211
  %9 = load i8*, i8** %3, align 4, !dbg !7212, !tbaa !657
  %10 = bitcast i8** %3 to i8*, !dbg !7213
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #19, !dbg !7213
  ret i8* %9, !dbg !7214
}

; Function Attrs: nounwind ssp
define i8* @aws_mem_acquire(%struct.aws_allocator.13* %0, i32 %1) #0 !dbg !7215 {
  %3 = alloca %struct.aws_allocator.13*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i8*, align 4
  store %struct.aws_allocator.13* %0, %struct.aws_allocator.13** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator.13** %3, metadata !7218, metadata !DIExpression()), !dbg !7221
  store i32 %1, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !7219, metadata !DIExpression()), !dbg !7222
  %6 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %3, align 4, !dbg !7223, !tbaa !657
  %7 = load i32, i32* %4, align 4, !dbg !7224, !tbaa !663
  %8 = icmp ne i32 %7, 0, !dbg !7224
  call void @__VERIFIER_assert(i1 zeroext %8) #17, !dbg !7224
  %9 = load i32, i32* %4, align 4, !dbg !7224, !tbaa !663
  %10 = icmp ne i32 %9, 0, !dbg !7224
  br i1 %10, label %12, label %11, !dbg !7224

11:                                               ; preds = %2
  call void @__VERIFIER_error() #17, !dbg !7224
  br label %12, !dbg !7224

12:                                               ; preds = %11, %2
  %13 = phi i1 [ true, %2 ], [ false, %11 ]
  %14 = zext i1 %13 to i32, !dbg !7224
  %15 = bitcast i8** %5 to i8*, !dbg !7225
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %15) #19, !dbg !7225
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7220, metadata !DIExpression()), !dbg !7226
  %16 = load i32, i32* %4, align 4, !dbg !7227, !tbaa !663
  %17 = call i8* @can_fail_malloc(i32 %16) #17, !dbg !7228
  store i8* %17, i8** %5, align 4, !dbg !7226, !tbaa !657
  %18 = load i8*, i8** %5, align 4, !dbg !7229, !tbaa !657
  %19 = icmp ne i8* %18, null, !dbg !7229
  br i1 %19, label %22, label %20, !dbg !7231

20:                                               ; preds = %12
  %21 = call i32 @aws_raise_error.11(i32 1) #17, !dbg !7232
  br label %22, !dbg !7234

22:                                               ; preds = %20, %12
  %23 = load i8*, i8** %5, align 4, !dbg !7235, !tbaa !657
  %24 = bitcast i8** %5 to i8*, !dbg !7236
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %24) #19, !dbg !7236
  ret i8* %23, !dbg !7237
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_raise_error.11(i32 %0) #2 !dbg !7238 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %2, metadata !7240, metadata !DIExpression()), !dbg !7241
  %3 = load i32, i32* %2, align 4, !dbg !7242, !tbaa !805
  call void @aws_raise_error_private(i32 %3) #17, !dbg !7243
  ret i32 -1, !dbg !7244
}

; Function Attrs: nounwind ssp
define void @aws_raise_error_private(i32 %0) #0 !dbg !7245 {
  %2 = alloca i32, align 4
  store i32 %0, i32* %2, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %2, metadata !7247, metadata !DIExpression()), !dbg !7248
  %3 = load i32, i32* %2, align 4, !dbg !7249, !tbaa !805
  store i32 %3, i32* @tl_last_error, align 4, !dbg !7250, !tbaa !805
  ret void, !dbg !7251
}

; Function Attrs: nounwind ssp
define i8* @aws_mem_calloc(%struct.aws_allocator.13* %0, i32 %1, i32 %2) #0 !dbg !7252 {
  %4 = alloca i8*, align 4
  %5 = alloca %struct.aws_allocator.13*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  %9 = alloca i32, align 4
  %10 = alloca i8*, align 4
  store %struct.aws_allocator.13* %0, %struct.aws_allocator.13** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator.13** %5, metadata !7254, metadata !DIExpression()), !dbg !7259
  store i32 %1, i32* %6, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %6, metadata !7255, metadata !DIExpression()), !dbg !7260
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !7256, metadata !DIExpression()), !dbg !7261
  %11 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %5, align 4, !dbg !7262, !tbaa !657
  %12 = bitcast i32* %8 to i8*, !dbg !7263
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %12) #19, !dbg !7263
  call void @llvm.dbg.declare(metadata i32* %8, metadata !7257, metadata !DIExpression()), !dbg !7264
  %13 = load i32, i32* %6, align 4, !dbg !7265, !tbaa !663
  %14 = load i32, i32* %7, align 4, !dbg !7267, !tbaa !663
  %15 = call i32 @aws_mul_size_checked(i32 %13, i32 %14, i32* %8) #17, !dbg !7268
  %16 = icmp ne i32 %15, 0, !dbg !7268
  br i1 %16, label %17, label %18, !dbg !7269

17:                                               ; preds = %3
  store i8* null, i8** %4, align 4, !dbg !7270
  store i32 1, i32* %9, align 4
  br label %36, !dbg !7270

18:                                               ; preds = %3
  %19 = bitcast i8** %10 to i8*, !dbg !7272
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %19) #19, !dbg !7272
  call void @llvm.dbg.declare(metadata i8** %10, metadata !7258, metadata !DIExpression()), !dbg !7273
  %20 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %5, align 4, !dbg !7274, !tbaa !657
  %21 = load i32, i32* %8, align 4, !dbg !7275, !tbaa !663
  %22 = call i8* @aws_mem_acquire(%struct.aws_allocator.13* %20, i32 %21) #17, !dbg !7276
  store i8* %22, i8** %10, align 4, !dbg !7273, !tbaa !657
  %23 = load i8*, i8** %10, align 4, !dbg !7277, !tbaa !657
  %24 = icmp ne i8* %23, null, !dbg !7277
  br i1 %24, label %27, label %25, !dbg !7279

25:                                               ; preds = %18
  %26 = call i32 @aws_raise_error.11(i32 1) #17, !dbg !7280
  store i8* null, i8** %4, align 4, !dbg !7282
  store i32 1, i32* %9, align 4
  br label %34, !dbg !7282

27:                                               ; preds = %18
  %28 = load i8*, i8** %10, align 4, !dbg !7283, !tbaa !657
  %29 = load i32, i32* %8, align 4, !dbg !7283, !tbaa !663
  %30 = load i8*, i8** %10, align 4, !dbg !7283, !tbaa !657
  %31 = call i32 @llvm.objectsize.i32.p0i8(i8* %30, i1 false, i1 true, i1 false), !dbg !7283
  %32 = call i8* @__memset_chk(i8* %28, i32 0, i32 %29, i32 %31) #18, !dbg !7283
  %33 = load i8*, i8** %10, align 4, !dbg !7284, !tbaa !657
  store i8* %33, i8** %4, align 4, !dbg !7285
  store i32 1, i32* %9, align 4
  br label %34, !dbg !7285

34:                                               ; preds = %27, %25
  %35 = bitcast i8** %10 to i8*, !dbg !7286
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %35) #19, !dbg !7286
  br label %36

36:                                               ; preds = %34, %17
  %37 = bitcast i32* %8 to i8*, !dbg !7286
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %37) #19, !dbg !7286
  %38 = load i8*, i8** %4, align 4, !dbg !7286
  ret i8* %38, !dbg !7286
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_mul_size_checked(i32 %0, i32 %1, i32* %2) #2 !dbg !7287 {
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32*, align 4
  store i32 %0, i32* %4, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %4, metadata !7289, metadata !DIExpression()), !dbg !7292
  store i32 %1, i32* %5, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %5, metadata !7290, metadata !DIExpression()), !dbg !7293
  store i32* %2, i32** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %6, metadata !7291, metadata !DIExpression()), !dbg !7294
  %7 = load i32, i32* %4, align 4, !dbg !7295, !tbaa !663
  %8 = load i32, i32* %5, align 4, !dbg !7296, !tbaa !663
  %9 = load i32*, i32** %6, align 4, !dbg !7297, !tbaa !657
  %10 = call i32 @aws_mul_u32_checked(i32 %7, i32 %8, i32* %9) #17, !dbg !7298
  ret i32 %10, !dbg !7299
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @__memset_chk(i8* %0, i32 %1, i32 %2, i32 %3) #12 !dbg !7300 {
  %5 = alloca i8*, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  store i8* %0, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7305, metadata !DIExpression()), !dbg !7309
  store i32 %1, i32* %6, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %6, metadata !7306, metadata !DIExpression()), !dbg !7310
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !7307, metadata !DIExpression()), !dbg !7311
  store i32 %3, i32* %8, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %8, metadata !7308, metadata !DIExpression()), !dbg !7312
  %9 = load i32, i32* %8, align 4, !dbg !7313, !tbaa !663
  %10 = load i32, i32* %7, align 4, !dbg !7313, !tbaa !663
  %11 = icmp ult i32 %9, %10, !dbg !7313
  %12 = xor i1 %11, true, !dbg !7313
  call void @__VERIFIER_assert(i1 zeroext %12) #17, !dbg !7313
  %13 = load i32, i32* %8, align 4, !dbg !7313, !tbaa !663
  %14 = load i32, i32* %7, align 4, !dbg !7313, !tbaa !663
  %15 = icmp ult i32 %13, %14, !dbg !7313
  %16 = xor i1 %15, true, !dbg !7313
  br i1 %16, label %18, label %17, !dbg !7313

17:                                               ; preds = %4
  call void @__VERIFIER_error() #17, !dbg !7313
  br label %18, !dbg !7313

18:                                               ; preds = %17, %4
  %19 = phi i1 [ true, %4 ], [ false, %17 ]
  %20 = zext i1 %19 to i32, !dbg !7313
  %21 = load i8*, i8** %5, align 4, !dbg !7314, !tbaa !657
  %22 = load i32, i32* %6, align 4, !dbg !7315, !tbaa !805
  %23 = trunc i32 %22 to i8, !dbg !7316
  %24 = load i32, i32* %7, align 4, !dbg !7317, !tbaa !663
  call void @llvm.memset.p0i8.i32(i8* align 1 %21, i8 %23, i32 %24, i1 false), !dbg !7316
  ret i8* %21, !dbg !7318
}

; Function Attrs: inlinehint nounwind ssp
define internal i32 @aws_mul_u32_checked(i32 %0, i32 %1, i32* %2) #2 !dbg !7319 {
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32*, align 4
  store i32 %0, i32* %5, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %5, metadata !7321, metadata !DIExpression()), !dbg !7324
  store i32 %1, i32* %6, align 4, !tbaa !805
  call void @llvm.dbg.declare(metadata i32* %6, metadata !7322, metadata !DIExpression()), !dbg !7325
  store i32* %2, i32** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i32** %7, metadata !7323, metadata !DIExpression()), !dbg !7326
  %8 = load i32, i32* %5, align 4, !dbg !7327, !tbaa !805
  %9 = load i32, i32* %6, align 4, !dbg !7329, !tbaa !805
  %10 = load i32*, i32** %7, align 4, !dbg !7330, !tbaa !657
  %11 = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 %8, i32 %9), !dbg !7331
  %12 = extractvalue { i32, i1 } %11, 1, !dbg !7331
  %13 = extractvalue { i32, i1 } %11, 0, !dbg !7331
  store i32 %13, i32* %10, align 4, !dbg !7331
  br i1 %12, label %14, label %16, !dbg !7332

14:                                               ; preds = %3
  %15 = call i32 @aws_raise_error.11(i32 5) #17, !dbg !7333
  store i32 %15, i32* %4, align 4, !dbg !7335
  br label %17, !dbg !7335

16:                                               ; preds = %3
  store i32 0, i32* %4, align 4, !dbg !7336
  br label %17, !dbg !7336

17:                                               ; preds = %16, %14
  %18 = load i32, i32* %4, align 4, !dbg !7337
  ret i32 %18, !dbg !7337
}

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare { i32, i1 } @llvm.umul.with.overflow.i32(i32, i32) #1

; Function Attrs: nounwind ssp
define void @aws_mem_release(%struct.aws_allocator.13* %0, i8* %1) #0 !dbg !7338 {
  %3 = alloca %struct.aws_allocator.13*, align 4
  %4 = alloca i8*, align 4
  store %struct.aws_allocator.13* %0, %struct.aws_allocator.13** %3, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator.13** %3, metadata !7340, metadata !DIExpression()), !dbg !7342
  store i8* %1, i8** %4, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %4, metadata !7341, metadata !DIExpression()), !dbg !7343
  %5 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %3, align 4, !dbg !7344, !tbaa !657
  %6 = load i8*, i8** %4, align 4, !dbg !7345, !tbaa !657
  %7 = icmp ne i8* %6, null, !dbg !7347
  br i1 %7, label %8, label %10, !dbg !7348

8:                                                ; preds = %2
  %9 = load i8*, i8** %4, align 4, !dbg !7349, !tbaa !657
  call void @free(i8* %9) #17, !dbg !7351
  br label %10, !dbg !7352

10:                                               ; preds = %8, %2
  ret void, !dbg !7353
}

; Function Attrs: nounwind ssp
define i32 @aws_mem_realloc(%struct.aws_allocator.13* %0, i8** %1, i32 %2, i32 %3) #0 !dbg !7354 {
  %5 = alloca i32, align 4
  %6 = alloca %struct.aws_allocator.13*, align 4
  %7 = alloca i8**, align 4
  %8 = alloca i32, align 4
  %9 = alloca i32, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i32, align 4
  store %struct.aws_allocator.13* %0, %struct.aws_allocator.13** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator.13** %6, metadata !7358, metadata !DIExpression()), !dbg !7363
  store i8** %1, i8*** %7, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8*** %7, metadata !7359, metadata !DIExpression()), !dbg !7364
  store i32 %2, i32* %8, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %8, metadata !7360, metadata !DIExpression()), !dbg !7365
  store i32 %3, i32* %9, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %9, metadata !7361, metadata !DIExpression()), !dbg !7366
  %12 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %6, align 4, !dbg !7367, !tbaa !657
  %13 = load i32, i32* %9, align 4, !dbg !7368, !tbaa !663
  %14 = icmp eq i32 %13, 0, !dbg !7370
  br i1 %14, label %15, label %20, !dbg !7371

15:                                               ; preds = %4
  %16 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %6, align 4, !dbg !7372, !tbaa !657
  %17 = load i8**, i8*** %7, align 4, !dbg !7374, !tbaa !657
  %18 = load i8*, i8** %17, align 4, !dbg !7375, !tbaa !657
  call void @aws_mem_release(%struct.aws_allocator.13* %16, i8* %18) #17, !dbg !7376
  %19 = load i8**, i8*** %7, align 4, !dbg !7377, !tbaa !657
  store i8* null, i8** %19, align 4, !dbg !7378, !tbaa !657
  store i32 0, i32* %5, align 4, !dbg !7379
  br label %60, !dbg !7379

20:                                               ; preds = %4
  %21 = load i32, i32* %8, align 4, !dbg !7380, !tbaa !663
  %22 = load i32, i32* %9, align 4, !dbg !7382, !tbaa !663
  %23 = icmp uge i32 %21, %22, !dbg !7383
  br i1 %23, label %24, label %25, !dbg !7384

24:                                               ; preds = %20
  store i32 0, i32* %5, align 4, !dbg !7385
  br label %60, !dbg !7385

25:                                               ; preds = %20
  %26 = bitcast i8** %10 to i8*, !dbg !7387
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %26) #19, !dbg !7387
  call void @llvm.dbg.declare(metadata i8** %10, metadata !7362, metadata !DIExpression()), !dbg !7388
  %27 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %6, align 4, !dbg !7389, !tbaa !657
  %28 = load i32, i32* %9, align 4, !dbg !7390, !tbaa !663
  %29 = call i8* @aws_mem_acquire(%struct.aws_allocator.13* %27, i32 %28) #17, !dbg !7391
  store i8* %29, i8** %10, align 4, !dbg !7388, !tbaa !657
  %30 = load i8*, i8** %10, align 4, !dbg !7392, !tbaa !657
  %31 = icmp ne i8* %30, null, !dbg !7392
  br i1 %31, label %34, label %32, !dbg !7394

32:                                               ; preds = %25
  %33 = call i32 @aws_raise_error.11(i32 1) #17, !dbg !7395
  store i32 %33, i32* %5, align 4, !dbg !7397
  store i32 1, i32* %11, align 4
  br label %58, !dbg !7397

34:                                               ; preds = %25
  %35 = load i8*, i8** %10, align 4, !dbg !7398, !tbaa !657
  %36 = load i8**, i8*** %7, align 4, !dbg !7398, !tbaa !657
  %37 = load i8*, i8** %36, align 4, !dbg !7398, !tbaa !657
  %38 = load i32, i32* %8, align 4, !dbg !7398, !tbaa !663
  %39 = load i8*, i8** %10, align 4, !dbg !7398, !tbaa !657
  %40 = call i32 @llvm.objectsize.i32.p0i8(i8* %39, i1 false, i1 true, i1 false), !dbg !7398
  %41 = call i8* @__memcpy_chk(i8* %35, i8* %37, i32 %38, i32 %40) #18, !dbg !7398
  %42 = load i8*, i8** %10, align 4, !dbg !7399, !tbaa !657
  %43 = load i32, i32* %8, align 4, !dbg !7399, !tbaa !663
  %44 = getelementptr inbounds i8, i8* %42, i32 %43, !dbg !7399
  %45 = load i32, i32* %9, align 4, !dbg !7399, !tbaa !663
  %46 = load i32, i32* %8, align 4, !dbg !7399, !tbaa !663
  %47 = sub i32 %45, %46, !dbg !7399
  %48 = load i8*, i8** %10, align 4, !dbg !7399, !tbaa !657
  %49 = load i32, i32* %8, align 4, !dbg !7399, !tbaa !663
  %50 = getelementptr inbounds i8, i8* %48, i32 %49, !dbg !7399
  %51 = call i32 @llvm.objectsize.i32.p0i8(i8* %50, i1 false, i1 true, i1 false), !dbg !7399
  %52 = call i8* @__memset_chk(i8* %44, i32 0, i32 %47, i32 %51) #18, !dbg !7399
  %53 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %6, align 4, !dbg !7400, !tbaa !657
  %54 = load i8**, i8*** %7, align 4, !dbg !7401, !tbaa !657
  %55 = load i8*, i8** %54, align 4, !dbg !7402, !tbaa !657
  call void @aws_mem_release(%struct.aws_allocator.13* %53, i8* %55) #17, !dbg !7403
  %56 = load i8*, i8** %10, align 4, !dbg !7404, !tbaa !657
  %57 = load i8**, i8*** %7, align 4, !dbg !7405, !tbaa !657
  store i8* %56, i8** %57, align 4, !dbg !7406, !tbaa !657
  store i32 0, i32* %5, align 4, !dbg !7407
  store i32 1, i32* %11, align 4
  br label %58, !dbg !7407

58:                                               ; preds = %34, %32
  %59 = bitcast i8** %10 to i8*, !dbg !7408
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %59) #19, !dbg !7408
  br label %60

60:                                               ; preds = %58, %24, %15
  %61 = load i32, i32* %5, align 4, !dbg !7408
  ret i32 %61, !dbg !7408
}

; Function Attrs: alwaysinline nounwind ssp
define i8* @__memcpy_chk(i8* %0, i8* %1, i32 %2, i32 %3) #12 !dbg !7409 {
  %5 = alloca i8*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  store i8* %0, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7413, metadata !DIExpression()), !dbg !7417
  store i8* %1, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !7414, metadata !DIExpression()), !dbg !7418
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !7415, metadata !DIExpression()), !dbg !7419
  store i32 %3, i32* %8, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %8, metadata !7416, metadata !DIExpression()), !dbg !7420
  %9 = load i32, i32* %8, align 4, !dbg !7421, !tbaa !663
  %10 = load i32, i32* %7, align 4, !dbg !7421, !tbaa !663
  %11 = icmp ult i32 %9, %10, !dbg !7421
  %12 = xor i1 %11, true, !dbg !7421
  call void @__VERIFIER_assert(i1 zeroext %12) #17, !dbg !7421
  %13 = load i32, i32* %8, align 4, !dbg !7421, !tbaa !663
  %14 = load i32, i32* %7, align 4, !dbg !7421, !tbaa !663
  %15 = icmp ult i32 %13, %14, !dbg !7421
  %16 = xor i1 %15, true, !dbg !7421
  br i1 %16, label %18, label %17, !dbg !7421

17:                                               ; preds = %4
  call void @__VERIFIER_error() #17, !dbg !7421
  br label %18, !dbg !7421

18:                                               ; preds = %17, %4
  %19 = phi i1 [ true, %4 ], [ false, %17 ]
  %20 = zext i1 %19 to i32, !dbg !7421
  %21 = load i8*, i8** %5, align 4, !dbg !7422, !tbaa !657
  %22 = load i8*, i8** %6, align 4, !dbg !7423, !tbaa !657
  %23 = load i32, i32* %7, align 4, !dbg !7424, !tbaa !663
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 1 %21, i8* align 1 %22, i32 %23, i1 false), !dbg !7425
  ret i8* %21, !dbg !7426
}

; Function Attrs: nounwind ssp
define zeroext i1 @aws_allocator_is_valid(%struct.aws_allocator.13* %0) #0 !dbg !7427 {
  %2 = alloca %struct.aws_allocator.13*, align 4
  store %struct.aws_allocator.13* %0, %struct.aws_allocator.13** %2, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata %struct.aws_allocator.13** %2, metadata !7433, metadata !DIExpression()), !dbg !7434
  %3 = load %struct.aws_allocator.13*, %struct.aws_allocator.13** %2, align 4, !dbg !7435, !tbaa !657
  %4 = call %struct.aws_allocator.13* bitcast (%struct.aws_allocator* ()* @sea_allocator to %struct.aws_allocator.13* ()*)() #17, !dbg !7436
  %5 = icmp eq %struct.aws_allocator.13* %3, %4, !dbg !7437
  ret i1 %5, !dbg !7438
}

; Function Attrs: alwaysinline nounwind ssp
define i32 @bcmp(i8* %0, i8* %1, i32 %2) #12 !dbg !7439 {
  %4 = alloca i32, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  %9 = alloca i32, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i8*, align 4
  %12 = alloca i32, align 4
  store i8* %0, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7443, metadata !DIExpression()), !dbg !7450
  store i8* %1, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !7444, metadata !DIExpression()), !dbg !7451
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !7445, metadata !DIExpression()), !dbg !7452
  %13 = bitcast i32* %8 to i8*, !dbg !7453
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %13) #19, !dbg !7453
  call void @llvm.dbg.declare(metadata i32* %8, metadata !7446, metadata !DIExpression()), !dbg !7454
  %14 = bitcast i32* %9 to i8*, !dbg !7455
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !7455
  call void @llvm.dbg.declare(metadata i32* %9, metadata !7447, metadata !DIExpression()), !dbg !7456
  %15 = call i32 @sea_max_buffer_size() #17, !dbg !7457
  store i32 %15, i32* %9, align 4, !dbg !7456, !tbaa !663
  %16 = bitcast i8** %10 to i8*, !dbg !7458
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %16) #19, !dbg !7458
  call void @llvm.dbg.declare(metadata i8** %10, metadata !7448, metadata !DIExpression()), !dbg !7459
  %17 = bitcast i8** %11 to i8*, !dbg !7460
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %17) #19, !dbg !7460
  call void @llvm.dbg.declare(metadata i8** %11, metadata !7449, metadata !DIExpression()), !dbg !7461
  %18 = load i8*, i8** %5, align 4, !dbg !7462, !tbaa !657
  store i8* %18, i8** %10, align 4, !dbg !7463, !tbaa !657
  %19 = load i8*, i8** %6, align 4, !dbg !7464, !tbaa !657
  store i8* %19, i8** %11, align 4, !dbg !7465, !tbaa !657
  %20 = load i8*, i8** %10, align 4, !dbg !7466, !tbaa !657
  %21 = load i8*, i8** %11, align 4, !dbg !7468, !tbaa !657
  %22 = icmp eq i8* %20, %21, !dbg !7469
  br i1 %22, label %23, label %24, !dbg !7470

23:                                               ; preds = %3
  store i32 0, i32* %4, align 4, !dbg !7471
  store i32 1, i32* %12, align 4
  br label %82, !dbg !7471

24:                                               ; preds = %3
  %25 = load i8*, i8** %10, align 4, !dbg !7472, !tbaa !657
  %26 = icmp eq i8* %25, null, !dbg !7474
  br i1 %26, label %30, label %27, !dbg !7475

27:                                               ; preds = %24
  %28 = load i8*, i8** %11, align 4, !dbg !7476, !tbaa !657
  %29 = icmp eq i8* %28, null, !dbg !7477
  br i1 %29, label %30, label %31, !dbg !7478

30:                                               ; preds = %27, %24
  store i32 1, i32* %4, align 4, !dbg !7479
  store i32 1, i32* %12, align 4
  br label %82, !dbg !7479

31:                                               ; preds = %27
  store i32 0, i32* %8, align 4, !dbg !7480, !tbaa !663
  br label %32, !dbg !7482

32:                                               ; preds = %55, %31
  %33 = load i32, i32* %8, align 4, !dbg !7483, !tbaa !663
  %34 = load i32, i32* %9, align 4, !dbg !7485, !tbaa !663
  %35 = icmp ult i32 %33, %34, !dbg !7486
  br i1 %35, label %36, label %58, !dbg !7487

36:                                               ; preds = %32
  %37 = load i32, i32* %8, align 4, !dbg !7488, !tbaa !663
  %38 = load i32, i32* %7, align 4, !dbg !7491, !tbaa !663
  %39 = icmp ult i32 %37, %38, !dbg !7492
  br i1 %39, label %40, label %54, !dbg !7493

40:                                               ; preds = %36
  %41 = load i8*, i8** %10, align 4, !dbg !7494, !tbaa !657
  %42 = load i32, i32* %8, align 4, !dbg !7497, !tbaa !663
  %43 = getelementptr inbounds i8, i8* %41, i32 %42, !dbg !7494
  %44 = load i8, i8* %43, align 1, !dbg !7494, !tbaa !1034
  %45 = zext i8 %44 to i32, !dbg !7494
  %46 = load i8*, i8** %11, align 4, !dbg !7498, !tbaa !657
  %47 = load i32, i32* %8, align 4, !dbg !7499, !tbaa !663
  %48 = getelementptr inbounds i8, i8* %46, i32 %47, !dbg !7498
  %49 = load i8, i8* %48, align 1, !dbg !7498, !tbaa !1034
  %50 = zext i8 %49 to i32, !dbg !7498
  %51 = icmp ne i32 %45, %50, !dbg !7500
  br i1 %51, label %52, label %53, !dbg !7501

52:                                               ; preds = %40
  store i32 1, i32* %4, align 4, !dbg !7502
  store i32 1, i32* %12, align 4
  br label %82, !dbg !7502

53:                                               ; preds = %40
  br label %54, !dbg !7504

54:                                               ; preds = %53, %36
  br label %55, !dbg !7505

55:                                               ; preds = %54
  %56 = load i32, i32* %8, align 4, !dbg !7506, !tbaa !663
  %57 = add i32 %56, 1, !dbg !7506
  store i32 %57, i32* %8, align 4, !dbg !7506, !tbaa !663
  br label %32, !dbg !7507, !llvm.loop !7508

58:                                               ; preds = %32
  %59 = load i32, i32* %9, align 4, !dbg !7510, !tbaa !663
  store i32 %59, i32* %8, align 4, !dbg !7512, !tbaa !663
  br label %60, !dbg !7513

60:                                               ; preds = %78, %58
  %61 = load i32, i32* %8, align 4, !dbg !7514, !tbaa !663
  %62 = load i32, i32* %7, align 4, !dbg !7516, !tbaa !663
  %63 = icmp ult i32 %61, %62, !dbg !7517
  br i1 %63, label %64, label %81, !dbg !7518

64:                                               ; preds = %60
  %65 = load i8*, i8** %10, align 4, !dbg !7519, !tbaa !657
  %66 = load i32, i32* %8, align 4, !dbg !7522, !tbaa !663
  %67 = getelementptr inbounds i8, i8* %65, i32 %66, !dbg !7519
  %68 = load i8, i8* %67, align 1, !dbg !7519, !tbaa !1034
  %69 = zext i8 %68 to i32, !dbg !7519
  %70 = load i8*, i8** %11, align 4, !dbg !7523, !tbaa !657
  %71 = load i32, i32* %8, align 4, !dbg !7524, !tbaa !663
  %72 = getelementptr inbounds i8, i8* %70, i32 %71, !dbg !7523
  %73 = load i8, i8* %72, align 1, !dbg !7523, !tbaa !1034
  %74 = zext i8 %73 to i32, !dbg !7523
  %75 = icmp ne i32 %69, %74, !dbg !7525
  br i1 %75, label %76, label %77, !dbg !7526

76:                                               ; preds = %64
  store i32 1, i32* %4, align 4, !dbg !7527
  store i32 1, i32* %12, align 4
  br label %82, !dbg !7527

77:                                               ; preds = %64
  br label %78, !dbg !7528

78:                                               ; preds = %77
  %79 = load i32, i32* %8, align 4, !dbg !7529, !tbaa !663
  %80 = add i32 %79, 1, !dbg !7529
  store i32 %80, i32* %8, align 4, !dbg !7529, !tbaa !663
  br label %60, !dbg !7530, !llvm.loop !7531

81:                                               ; preds = %60
  store i32 0, i32* %4, align 4, !dbg !7533
  store i32 1, i32* %12, align 4
  br label %82, !dbg !7533

82:                                               ; preds = %81, %76, %52, %30, %23
  %83 = bitcast i8** %11 to i8*, !dbg !7534
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %83) #19, !dbg !7534
  %84 = bitcast i8** %10 to i8*, !dbg !7534
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %84) #19, !dbg !7534
  %85 = bitcast i32* %9 to i8*, !dbg !7534
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %85) #19, !dbg !7534
  %86 = bitcast i32* %8 to i8*, !dbg !7534
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %86) #19, !dbg !7534
  %87 = load i32, i32* %4, align 4, !dbg !7534
  ret i32 %87, !dbg !7534
}

; Function Attrs: alwaysinline nounwind ssp
define i32 @memcmp(i8* %0, i8* %1, i32 %2) #12 !dbg !7535 {
  %4 = alloca i32, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8*, align 4
  %7 = alloca i32, align 4
  %8 = alloca i32, align 4
  %9 = alloca i32, align 4
  %10 = alloca i8*, align 4
  %11 = alloca i8*, align 4
  %12 = alloca i32, align 4
  store i8* %0, i8** %5, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7537, metadata !DIExpression()), !dbg !7544
  store i8* %1, i8** %6, align 4, !tbaa !657
  call void @llvm.dbg.declare(metadata i8** %6, metadata !7538, metadata !DIExpression()), !dbg !7545
  store i32 %2, i32* %7, align 4, !tbaa !663
  call void @llvm.dbg.declare(metadata i32* %7, metadata !7539, metadata !DIExpression()), !dbg !7546
  %13 = bitcast i32* %8 to i8*, !dbg !7547
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %13) #19, !dbg !7547
  call void @llvm.dbg.declare(metadata i32* %8, metadata !7540, metadata !DIExpression()), !dbg !7548
  %14 = bitcast i32* %9 to i8*, !dbg !7549
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %14) #19, !dbg !7549
  call void @llvm.dbg.declare(metadata i32* %9, metadata !7541, metadata !DIExpression()), !dbg !7550
  %15 = call i32 @sea_max_buffer_size() #17, !dbg !7551
  store i32 %15, i32* %9, align 4, !dbg !7550, !tbaa !663
  %16 = bitcast i8** %10 to i8*, !dbg !7552
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %16) #19, !dbg !7552
  call void @llvm.dbg.declare(metadata i8** %10, metadata !7542, metadata !DIExpression()), !dbg !7553
  %17 = bitcast i8** %11 to i8*, !dbg !7554
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %17) #19, !dbg !7554
  call void @llvm.dbg.declare(metadata i8** %11, metadata !7543, metadata !DIExpression()), !dbg !7555
  %18 = load i8*, i8** %5, align 4, !dbg !7556, !tbaa !657
  store i8* %18, i8** %10, align 4, !dbg !7557, !tbaa !657
  %19 = load i8*, i8** %6, align 4, !dbg !7558, !tbaa !657
  store i8* %19, i8** %11, align 4, !dbg !7559, !tbaa !657
  %20 = load i8*, i8** %10, align 4, !dbg !7560, !tbaa !657
  %21 = load i8*, i8** %11, align 4, !dbg !7562, !tbaa !657
  %22 = icmp eq i8* %20, %21, !dbg !7563
  br i1 %22, label %23, label %24, !dbg !7564

23:                                               ; preds = %3
  store i32 0, i32* %4, align 4, !dbg !7565
  store i32 1, i32* %12, align 4
  br label %101, !dbg !7565

24:                                               ; preds = %3
  store i32 0, i32* %8, align 4, !dbg !7566, !tbaa !663
  br label %25, !dbg !7568

25:                                               ; preds = %61, %24
  %26 = load i32, i32* %8, align 4, !dbg !7569, !tbaa !663
  %27 = load i32, i32* %9, align 4, !dbg !7571, !tbaa !663
  %28 = icmp ult i32 %26, %27, !dbg !7572
  br i1 %28, label %29, label %64, !dbg !7573

29:                                               ; preds = %25
  %30 = load i32, i32* %8, align 4, !dbg !7574, !tbaa !663
  %31 = load i32, i32* %7, align 4, !dbg !7577, !tbaa !663
  %32 = icmp ult i32 %30, %31, !dbg !7578
  br i1 %32, label %33, label %60, !dbg !7579

33:                                               ; preds = %29
  %34 = load i8*, i8** %10, align 4, !dbg !7580, !tbaa !657
  %35 = load i32, i32* %8, align 4, !dbg !7583, !tbaa !663
  %36 = getelementptr inbounds i8, i8* %34, i32 %35, !dbg !7580
  %37 = load i8, i8* %36, align 1, !dbg !7580, !tbaa !1034
  %38 = zext i8 %37 to i32, !dbg !7580
  %39 = load i8*, i8** %11, align 4, !dbg !7584, !tbaa !657
  %40 = load i32, i32* %8, align 4, !dbg !7585, !tbaa !663
  %41 = getelementptr inbounds i8, i8* %39, i32 %40, !dbg !7584
  %42 = load i8, i8* %41, align 1, !dbg !7584, !tbaa !1034
  %43 = zext i8 %42 to i32, !dbg !7584
  %44 = icmp ne i32 %38, %43, !dbg !7586
  br i1 %44, label %45, label %59, !dbg !7587

45:                                               ; preds = %33
  %46 = load i8*, i8** %10, align 4, !dbg !7588, !tbaa !657
  %47 = load i32, i32* %8, align 4, !dbg !7590, !tbaa !663
  %48 = getelementptr inbounds i8, i8* %46, i32 %47, !dbg !7588
  %49 = load i8, i8* %48, align 1, !dbg !7588, !tbaa !1034
  %50 = zext i8 %49 to i32, !dbg !7588
  %51 = load i8*, i8** %11, align 4, !dbg !7591, !tbaa !657
  %52 = load i32, i32* %8, align 4, !dbg !7592, !tbaa !663
  %53 = getelementptr inbounds i8, i8* %51, i32 %52, !dbg !7591
  %54 = load i8, i8* %53, align 1, !dbg !7591, !tbaa !1034
  %55 = zext i8 %54 to i32, !dbg !7591
  %56 = icmp slt i32 %50, %55, !dbg !7593
  %57 = zext i1 %56 to i64, !dbg !7588
  %58 = select i1 %56, i32 -1, i32 1, !dbg !7588
  store i32 %58, i32* %4, align 4, !dbg !7594
  store i32 1, i32* %12, align 4
  br label %101, !dbg !7594

59:                                               ; preds = %33
  br label %60, !dbg !7595

60:                                               ; preds = %59, %29
  br label %61, !dbg !7596

61:                                               ; preds = %60
  %62 = load i32, i32* %8, align 4, !dbg !7597, !tbaa !663
  %63 = add i32 %62, 1, !dbg !7597
  store i32 %63, i32* %8, align 4, !dbg !7597, !tbaa !663
  br label %25, !dbg !7598, !llvm.loop !7599

64:                                               ; preds = %25
  %65 = load i32, i32* %9, align 4, !dbg !7601, !tbaa !663
  store i32 %65, i32* %8, align 4, !dbg !7603, !tbaa !663
  br label %66, !dbg !7604

66:                                               ; preds = %97, %64
  %67 = load i32, i32* %8, align 4, !dbg !7605, !tbaa !663
  %68 = load i32, i32* %7, align 4, !dbg !7607, !tbaa !663
  %69 = icmp ult i32 %67, %68, !dbg !7608
  br i1 %69, label %70, label %100, !dbg !7609

70:                                               ; preds = %66
  %71 = load i8*, i8** %10, align 4, !dbg !7610, !tbaa !657
  %72 = load i32, i32* %8, align 4, !dbg !7613, !tbaa !663
  %73 = getelementptr inbounds i8, i8* %71, i32 %72, !dbg !7610
  %74 = load i8, i8* %73, align 1, !dbg !7610, !tbaa !1034
  %75 = zext i8 %74 to i32, !dbg !7610
  %76 = load i8*, i8** %11, align 4, !dbg !7614, !tbaa !657
  %77 = load i32, i32* %8, align 4, !dbg !7615, !tbaa !663
  %78 = getelementptr inbounds i8, i8* %76, i32 %77, !dbg !7614
  %79 = load i8, i8* %78, align 1, !dbg !7614, !tbaa !1034
  %80 = zext i8 %79 to i32, !dbg !7614
  %81 = icmp ne i32 %75, %80, !dbg !7616
  br i1 %81, label %82, label %96, !dbg !7617

82:                                               ; preds = %70
  %83 = load i8*, i8** %10, align 4, !dbg !7618, !tbaa !657
  %84 = load i32, i32* %8, align 4, !dbg !7619, !tbaa !663
  %85 = getelementptr inbounds i8, i8* %83, i32 %84, !dbg !7618
  %86 = load i8, i8* %85, align 1, !dbg !7618, !tbaa !1034
  %87 = zext i8 %86 to i32, !dbg !7618
  %88 = load i8*, i8** %11, align 4, !dbg !7620, !tbaa !657
  %89 = load i32, i32* %8, align 4, !dbg !7621, !tbaa !663
  %90 = getelementptr inbounds i8, i8* %88, i32 %89, !dbg !7620
  %91 = load i8, i8* %90, align 1, !dbg !7620, !tbaa !1034
  %92 = zext i8 %91 to i32, !dbg !7620
  %93 = icmp slt i32 %87, %92, !dbg !7622
  %94 = zext i1 %93 to i64, !dbg !7618
  %95 = select i1 %93, i32 -1, i32 1, !dbg !7618
  store i32 %95, i32* %4, align 4, !dbg !7623
  store i32 1, i32* %12, align 4
  br label %101, !dbg !7623

96:                                               ; preds = %70
  br label %97, !dbg !7624

97:                                               ; preds = %96
  %98 = load i32, i32* %8, align 4, !dbg !7625, !tbaa !663
  %99 = add i32 %98, 1, !dbg !7625
  store i32 %99, i32* %8, align 4, !dbg !7625, !tbaa !663
  br label %66, !dbg !7626, !llvm.loop !7627

100:                                              ; preds = %66
  store i32 0, i32* %4, align 4, !dbg !7629
  store i32 1, i32* %12, align 4
  br label %101, !dbg !7629

101:                                              ; preds = %100, %82, %45, %23
  %102 = bitcast i8** %11 to i8*, !dbg !7630
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %102) #19, !dbg !7630
  %103 = bitcast i8** %10 to i8*, !dbg !7630
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %103) #19, !dbg !7630
  %104 = bitcast i32* %9 to i8*, !dbg !7630
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %104) #19, !dbg !7630
  %105 = bitcast i32* %8 to i8*, !dbg !7630
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %105) #19, !dbg !7630
  %106 = load i32, i32* %4, align 4, !dbg !7630
  ret i32 %106, !dbg !7630
}

; Function Attrs: nounwind ssp
define i32 @aws_last_error() #0 !dbg !7631 {
  %1 = load i32, i32* @tl_last_error, align 4, !dbg !7632, !tbaa !805
  ret i32 %1, !dbg !7633
}

; Function Attrs: nounwind ssp
define i32 @sea_max_buffer_size() #0 !dbg !7634 {
  ret i32 10, !dbg !7638
}

; Function Attrs: nounwind ssp
define i32 @sea_max_string_len() #0 !dbg !7639 {
  ret i32 16, !dbg !7640
}

; Function Attrs: nounwind ssp
define i32 @klee_max_memory_size() #0 !dbg !7641 {
  ret i32 3, !dbg !7642
}

; Function Attrs: nounwind ssp
define i32 @sea_max_array_list_item_size() #0 !dbg !7643 {
  ret i32 2, !dbg !7644
}

; Function Attrs: nounwind ssp
define i32 @sea_max_array_list_len() #0 !dbg !7645 {
  ret i32 0, !dbg !7646
}

; Function Attrs: nounwind ssp
define i32 @fuzz_max_array_list_len() #0 !dbg !7647 {
  ret i32 10, !dbg !7648
}

; Function Attrs: nounwind ssp
define i32 @fuzz_max_array_list_item_size() #0 !dbg !7649 {
  ret i32 256, !dbg !7650
}

; Function Attrs: nounwind ssp
define i32 @sea_max_table_size() #0 !dbg !7651 {
  ret i32 4, !dbg !7652
}

; Function Attrs: ssp
define i32 @strlen(i8* %0) #16 !dbg !7653 {
  %2 = alloca i8*, align 4
  store i8* %0, i8** %2, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %2, metadata !7658, metadata !DIExpression()), !dbg !7663
  %3 = load i8*, i8** %2, align 4, !dbg !7664, !tbaa !7659
  %4 = call i32 @sea_max_string_len() #17, !dbg !7665
  %5 = call i32 @sea_strlen(i8* %3, i32 %4) #17, !dbg !7666
  ret i32 %5, !dbg !7667
}

; Function Attrs: ssp
define i32 @sea_strlen(i8* %0, i32 %1) #16 !dbg !7668 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  store i8* %0, i8** %3, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %3, metadata !7672, metadata !DIExpression()), !dbg !7675
  store i32 %1, i32* %4, align 4, !tbaa !7676
  call void @llvm.dbg.declare(metadata i32* %4, metadata !7673, metadata !DIExpression()), !dbg !7678
  %6 = bitcast i32* %5 to i8*, !dbg !7679
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %6) #19, !dbg !7679
  call void @llvm.dbg.declare(metadata i32* %5, metadata !7674, metadata !DIExpression()), !dbg !7680
  %7 = load i8*, i8** %3, align 4, !dbg !7681, !tbaa !7659
  %8 = call i32 @_ZN4LoopILm0ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* @isEOF, i8* %7) #17, !dbg !7682
  store i32 %8, i32* %5, align 4, !dbg !7680, !tbaa !7676
  %9 = load i32, i32* %5, align 4, !dbg !7683, !tbaa !7676
  %10 = load i32, i32* %4, align 4, !dbg !7684, !tbaa !7676
  %11 = icmp ule i32 %9, %10, !dbg !7685
  br i1 %11, label %12, label %14, !dbg !7683

12:                                               ; preds = %2
  %13 = load i32, i32* %5, align 4, !dbg !7686, !tbaa !7676
  br label %15, !dbg !7683

14:                                               ; preds = %2
  br label %15, !dbg !7683

15:                                               ; preds = %14, %12
  %16 = phi i32 [ %13, %12 ], [ 0, %14 ], !dbg !7683
  %17 = bitcast i32* %5 to i8*, !dbg !7687
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %17) #19, !dbg !7687
  ret i32 %16, !dbg !7688
}

; Function Attrs: nounwind ssp
define zeroext i1 @isEOF(i32 %0, i32 %1, i8* %2) #0 !dbg !7689 {
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i8*, align 4
  store i32 %0, i32* %4, align 4, !tbaa !7697
  call void @llvm.dbg.declare(metadata i32* %4, metadata !7694, metadata !DIExpression()), !dbg !7699
  store i32 %1, i32* %5, align 4, !tbaa !7697
  call void @llvm.dbg.declare(metadata i32* %5, metadata !7695, metadata !DIExpression()), !dbg !7700
  store i8* %2, i8** %6, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %6, metadata !7696, metadata !DIExpression()), !dbg !7701
  %7 = load i8*, i8** %6, align 4, !dbg !7702, !tbaa !7659
  %8 = load i32, i32* %4, align 4, !dbg !7703, !tbaa !7697
  %9 = getelementptr inbounds i8, i8* %7, i32 %8, !dbg !7702
  %10 = load i8, i8* %9, align 1, !dbg !7702, !tbaa !7704
  %11 = sext i8 %10 to i32, !dbg !7702
  %12 = icmp eq i32 %11, 0, !dbg !7705
  ret i1 %12, !dbg !7706
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm0ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7707 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7719, metadata !DIExpression()), !dbg !7722
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7720, metadata !DIExpression()), !dbg !7723
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7724
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7721, metadata !DIExpression()), !dbg !7725
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7726, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7727, !tbaa !7659
  %10 = call zeroext i1 %8(i32 0, i32 16, i8* %9), !dbg !7726
  %11 = zext i1 %10 to i8, !dbg !7725
  store i8 %11, i8* %6, align 1, !dbg !7725, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7730, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7730
  br i1 %13, label %14, label %15, !dbg !7732

14:                                               ; preds = %2
  store i32 0, i32* %3, align 4, !dbg !7733
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7733

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7734, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7735, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm1ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7736
  store i32 %18, i32* %3, align 4, !dbg !7737
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7737

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7738
  %20 = load i32, i32* %3, align 4, !dbg !7738
  ret i32 %20, !dbg !7738
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm1ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7739 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7746, metadata !DIExpression()), !dbg !7749
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7747, metadata !DIExpression()), !dbg !7750
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7751
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7748, metadata !DIExpression()), !dbg !7752
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7753, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7754, !tbaa !7659
  %10 = call zeroext i1 %8(i32 1, i32 16, i8* %9), !dbg !7753
  %11 = zext i1 %10 to i8, !dbg !7752
  store i8 %11, i8* %6, align 1, !dbg !7752, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7755, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7755
  br i1 %13, label %14, label %15, !dbg !7757

14:                                               ; preds = %2
  store i32 1, i32* %3, align 4, !dbg !7758
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7758

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7759, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7760, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm2ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7761
  store i32 %18, i32* %3, align 4, !dbg !7762
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7762

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7763
  %20 = load i32, i32* %3, align 4, !dbg !7763
  ret i32 %20, !dbg !7763
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm2ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7764 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7771, metadata !DIExpression()), !dbg !7774
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7772, metadata !DIExpression()), !dbg !7775
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7776
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7773, metadata !DIExpression()), !dbg !7777
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7778, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7779, !tbaa !7659
  %10 = call zeroext i1 %8(i32 2, i32 16, i8* %9), !dbg !7778
  %11 = zext i1 %10 to i8, !dbg !7777
  store i8 %11, i8* %6, align 1, !dbg !7777, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7780, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7780
  br i1 %13, label %14, label %15, !dbg !7782

14:                                               ; preds = %2
  store i32 2, i32* %3, align 4, !dbg !7783
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7783

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7784, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7785, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm3ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7786
  store i32 %18, i32* %3, align 4, !dbg !7787
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7787

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7788
  %20 = load i32, i32* %3, align 4, !dbg !7788
  ret i32 %20, !dbg !7788
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm3ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7789 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7796, metadata !DIExpression()), !dbg !7799
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7797, metadata !DIExpression()), !dbg !7800
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7801
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7798, metadata !DIExpression()), !dbg !7802
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7803, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7804, !tbaa !7659
  %10 = call zeroext i1 %8(i32 3, i32 16, i8* %9), !dbg !7803
  %11 = zext i1 %10 to i8, !dbg !7802
  store i8 %11, i8* %6, align 1, !dbg !7802, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7805, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7805
  br i1 %13, label %14, label %15, !dbg !7807

14:                                               ; preds = %2
  store i32 3, i32* %3, align 4, !dbg !7808
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7808

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7809, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7810, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm4ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7811
  store i32 %18, i32* %3, align 4, !dbg !7812
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7812

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7813
  %20 = load i32, i32* %3, align 4, !dbg !7813
  ret i32 %20, !dbg !7813
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm4ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7814 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7821, metadata !DIExpression()), !dbg !7824
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7822, metadata !DIExpression()), !dbg !7825
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7826
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7823, metadata !DIExpression()), !dbg !7827
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7828, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7829, !tbaa !7659
  %10 = call zeroext i1 %8(i32 4, i32 16, i8* %9), !dbg !7828
  %11 = zext i1 %10 to i8, !dbg !7827
  store i8 %11, i8* %6, align 1, !dbg !7827, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7830, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7830
  br i1 %13, label %14, label %15, !dbg !7832

14:                                               ; preds = %2
  store i32 4, i32* %3, align 4, !dbg !7833
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7833

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7834, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7835, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm5ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7836
  store i32 %18, i32* %3, align 4, !dbg !7837
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7837

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7838
  %20 = load i32, i32* %3, align 4, !dbg !7838
  ret i32 %20, !dbg !7838
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm5ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7839 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7846, metadata !DIExpression()), !dbg !7849
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7847, metadata !DIExpression()), !dbg !7850
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7851
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7848, metadata !DIExpression()), !dbg !7852
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7853, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7854, !tbaa !7659
  %10 = call zeroext i1 %8(i32 5, i32 16, i8* %9), !dbg !7853
  %11 = zext i1 %10 to i8, !dbg !7852
  store i8 %11, i8* %6, align 1, !dbg !7852, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7855, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7855
  br i1 %13, label %14, label %15, !dbg !7857

14:                                               ; preds = %2
  store i32 5, i32* %3, align 4, !dbg !7858
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7858

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7859, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7860, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm6ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7861
  store i32 %18, i32* %3, align 4, !dbg !7862
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7862

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7863
  %20 = load i32, i32* %3, align 4, !dbg !7863
  ret i32 %20, !dbg !7863
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm6ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7864 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7871, metadata !DIExpression()), !dbg !7874
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7872, metadata !DIExpression()), !dbg !7875
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7876
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7873, metadata !DIExpression()), !dbg !7877
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7878, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7879, !tbaa !7659
  %10 = call zeroext i1 %8(i32 6, i32 16, i8* %9), !dbg !7878
  %11 = zext i1 %10 to i8, !dbg !7877
  store i8 %11, i8* %6, align 1, !dbg !7877, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7880, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7880
  br i1 %13, label %14, label %15, !dbg !7882

14:                                               ; preds = %2
  store i32 6, i32* %3, align 4, !dbg !7883
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7883

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7884, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7885, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm7ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7886
  store i32 %18, i32* %3, align 4, !dbg !7887
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7887

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7888
  %20 = load i32, i32* %3, align 4, !dbg !7888
  ret i32 %20, !dbg !7888
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm7ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7889 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7896, metadata !DIExpression()), !dbg !7899
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7897, metadata !DIExpression()), !dbg !7900
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7901
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7898, metadata !DIExpression()), !dbg !7902
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7903, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7904, !tbaa !7659
  %10 = call zeroext i1 %8(i32 7, i32 16, i8* %9), !dbg !7903
  %11 = zext i1 %10 to i8, !dbg !7902
  store i8 %11, i8* %6, align 1, !dbg !7902, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7905, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7905
  br i1 %13, label %14, label %15, !dbg !7907

14:                                               ; preds = %2
  store i32 7, i32* %3, align 4, !dbg !7908
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7908

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7909, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7910, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm8ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7911
  store i32 %18, i32* %3, align 4, !dbg !7912
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7912

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7913
  %20 = load i32, i32* %3, align 4, !dbg !7913
  ret i32 %20, !dbg !7913
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm8ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7914 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7921, metadata !DIExpression()), !dbg !7924
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7922, metadata !DIExpression()), !dbg !7925
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7926
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7923, metadata !DIExpression()), !dbg !7927
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7928, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7929, !tbaa !7659
  %10 = call zeroext i1 %8(i32 8, i32 16, i8* %9), !dbg !7928
  %11 = zext i1 %10 to i8, !dbg !7927
  store i8 %11, i8* %6, align 1, !dbg !7927, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7930, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7930
  br i1 %13, label %14, label %15, !dbg !7932

14:                                               ; preds = %2
  store i32 8, i32* %3, align 4, !dbg !7933
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7933

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7934, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7935, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm9ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7936
  store i32 %18, i32* %3, align 4, !dbg !7937
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7937

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7938
  %20 = load i32, i32* %3, align 4, !dbg !7938
  ret i32 %20, !dbg !7938
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm9ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7939 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7946, metadata !DIExpression()), !dbg !7949
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7947, metadata !DIExpression()), !dbg !7950
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7951
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7948, metadata !DIExpression()), !dbg !7952
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7953, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7954, !tbaa !7659
  %10 = call zeroext i1 %8(i32 9, i32 16, i8* %9), !dbg !7953
  %11 = zext i1 %10 to i8, !dbg !7952
  store i8 %11, i8* %6, align 1, !dbg !7952, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7955, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7955
  br i1 %13, label %14, label %15, !dbg !7957

14:                                               ; preds = %2
  store i32 9, i32* %3, align 4, !dbg !7958
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7958

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7959, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7960, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm10ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7961
  store i32 %18, i32* %3, align 4, !dbg !7962
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7962

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7963
  %20 = load i32, i32* %3, align 4, !dbg !7963
  ret i32 %20, !dbg !7963
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm10ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7964 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7971, metadata !DIExpression()), !dbg !7974
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7972, metadata !DIExpression()), !dbg !7975
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !7976
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7973, metadata !DIExpression()), !dbg !7977
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7978, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !7979, !tbaa !7659
  %10 = call zeroext i1 %8(i32 10, i32 16, i8* %9), !dbg !7978
  %11 = zext i1 %10 to i8, !dbg !7977
  store i8 %11, i8* %6, align 1, !dbg !7977, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !7980, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !7980
  br i1 %13, label %14, label %15, !dbg !7982

14:                                               ; preds = %2
  store i32 10, i32* %3, align 4, !dbg !7983
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7983

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !7984, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !7985, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm11ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !7986
  store i32 %18, i32* %3, align 4, !dbg !7987
  store i32 1, i32* %7, align 4
  br label %19, !dbg !7987

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !7988
  %20 = load i32, i32* %3, align 4, !dbg !7988
  ret i32 %20, !dbg !7988
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm11ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !7989 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !7996, metadata !DIExpression()), !dbg !7999
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !7997, metadata !DIExpression()), !dbg !8000
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !8001
  call void @llvm.dbg.declare(metadata i8* %6, metadata !7998, metadata !DIExpression()), !dbg !8002
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8003, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !8004, !tbaa !7659
  %10 = call zeroext i1 %8(i32 11, i32 16, i8* %9), !dbg !8003
  %11 = zext i1 %10 to i8, !dbg !8002
  store i8 %11, i8* %6, align 1, !dbg !8002, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !8005, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !8005
  br i1 %13, label %14, label %15, !dbg !8007

14:                                               ; preds = %2
  store i32 11, i32* %3, align 4, !dbg !8008
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8008

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8009, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !8010, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm12ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !8011
  store i32 %18, i32* %3, align 4, !dbg !8012
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8012

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !8013
  %20 = load i32, i32* %3, align 4, !dbg !8013
  ret i32 %20, !dbg !8013
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm12ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !8014 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !8021, metadata !DIExpression()), !dbg !8024
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !8022, metadata !DIExpression()), !dbg !8025
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !8026
  call void @llvm.dbg.declare(metadata i8* %6, metadata !8023, metadata !DIExpression()), !dbg !8027
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8028, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !8029, !tbaa !7659
  %10 = call zeroext i1 %8(i32 12, i32 16, i8* %9), !dbg !8028
  %11 = zext i1 %10 to i8, !dbg !8027
  store i8 %11, i8* %6, align 1, !dbg !8027, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !8030, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !8030
  br i1 %13, label %14, label %15, !dbg !8032

14:                                               ; preds = %2
  store i32 12, i32* %3, align 4, !dbg !8033
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8033

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8034, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !8035, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm13ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !8036
  store i32 %18, i32* %3, align 4, !dbg !8037
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8037

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !8038
  %20 = load i32, i32* %3, align 4, !dbg !8038
  ret i32 %20, !dbg !8038
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm13ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !8039 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !8046, metadata !DIExpression()), !dbg !8049
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !8047, metadata !DIExpression()), !dbg !8050
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !8051
  call void @llvm.dbg.declare(metadata i8* %6, metadata !8048, metadata !DIExpression()), !dbg !8052
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8053, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !8054, !tbaa !7659
  %10 = call zeroext i1 %8(i32 13, i32 16, i8* %9), !dbg !8053
  %11 = zext i1 %10 to i8, !dbg !8052
  store i8 %11, i8* %6, align 1, !dbg !8052, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !8055, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !8055
  br i1 %13, label %14, label %15, !dbg !8057

14:                                               ; preds = %2
  store i32 13, i32* %3, align 4, !dbg !8058
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8058

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8059, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !8060, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm14ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !8061
  store i32 %18, i32* %3, align 4, !dbg !8062
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8062

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !8063
  %20 = load i32, i32* %3, align 4, !dbg !8063
  ret i32 %20, !dbg !8063
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm14ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !8064 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !8071, metadata !DIExpression()), !dbg !8074
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !8072, metadata !DIExpression()), !dbg !8075
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !8076
  call void @llvm.dbg.declare(metadata i8* %6, metadata !8073, metadata !DIExpression()), !dbg !8077
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8078, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !8079, !tbaa !7659
  %10 = call zeroext i1 %8(i32 14, i32 16, i8* %9), !dbg !8078
  %11 = zext i1 %10 to i8, !dbg !8077
  store i8 %11, i8* %6, align 1, !dbg !8077, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !8080, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !8080
  br i1 %13, label %14, label %15, !dbg !8082

14:                                               ; preds = %2
  store i32 14, i32* %3, align 4, !dbg !8083
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8083

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8084, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !8085, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm15ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !8086
  store i32 %18, i32* %3, align 4, !dbg !8087
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8087

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !8088
  %20 = load i32, i32* %3, align 4, !dbg !8088
  ret i32 %20, !dbg !8088
}

; Function Attrs: ssp
define linkonce_odr i32 @_ZN4LoopILm15ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #16 align 2 !dbg !8089 {
  %3 = alloca i32, align 4
  %4 = alloca i1 (i32, i32, i8*)*, align 4
  %5 = alloca i8*, align 4
  %6 = alloca i8, align 1
  %7 = alloca i32, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %4, metadata !8096, metadata !DIExpression()), !dbg !8099
  store i8* %1, i8** %5, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %5, metadata !8097, metadata !DIExpression()), !dbg !8100
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %6) #19, !dbg !8101
  call void @llvm.dbg.declare(metadata i8* %6, metadata !8098, metadata !DIExpression()), !dbg !8102
  %8 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8103, !tbaa !7659
  %9 = load i8*, i8** %5, align 4, !dbg !8104, !tbaa !7659
  %10 = call zeroext i1 %8(i32 15, i32 16, i8* %9), !dbg !8103
  %11 = zext i1 %10 to i8, !dbg !8102
  store i8 %11, i8* %6, align 1, !dbg !8102, !tbaa !7728
  %12 = load i8, i8* %6, align 1, !dbg !8105, !tbaa !7728, !range !849
  %13 = trunc i8 %12 to i1, !dbg !8105
  br i1 %13, label %14, label %15, !dbg !8107

14:                                               ; preds = %2
  store i32 15, i32* %3, align 4, !dbg !8108
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8108

15:                                               ; preds = %2
  %16 = load i1 (i32, i32, i8*)*, i1 (i32, i32, i8*)** %4, align 4, !dbg !8109, !tbaa !7659
  %17 = load i8*, i8** %5, align 4, !dbg !8110, !tbaa !7659
  %18 = call i32 @_ZN4LoopILm16ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %16, i8* %17) #17, !dbg !8111
  store i32 %18, i32* %3, align 4, !dbg !8112
  store i32 1, i32* %7, align 4
  br label %19, !dbg !8112

19:                                               ; preds = %15, %14
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %6) #19, !dbg !8113
  %20 = load i32, i32* %3, align 4, !dbg !8113
  ret i32 %20, !dbg !8113
}

; Function Attrs: nounwind ssp
define linkonce_odr i32 @_ZN4LoopILm16ELm16EFbiiPKcEE4callEPS2_S1_(i1 (i32, i32, i8*)* %0, i8* %1) #0 align 2 !dbg !8114 {
  %3 = alloca i1 (i32, i32, i8*)*, align 4
  %4 = alloca i8*, align 4
  store i1 (i32, i32, i8*)* %0, i1 (i32, i32, i8*)** %3, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i1 (i32, i32, i8*)** %3, metadata !8121, metadata !DIExpression()), !dbg !8123
  store i8* %1, i8** %4, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %4, metadata !8122, metadata !DIExpression()), !dbg !8124
  ret i32 16, !dbg !8125
}

; Function Attrs: ssp
define i32 @sea_strlen_unused(i8* %0, i32 %1) #16 !dbg !8126 {
  %3 = alloca i8*, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  %7 = alloca i32, align 4
  store i8* %0, i8** %3, align 4, !tbaa !7659
  call void @llvm.dbg.declare(metadata i8** %3, metadata !8128, metadata !DIExpression()), !dbg !8133
  store i32 %1, i32* %4, align 4, !tbaa !7676
  call void @llvm.dbg.declare(metadata i32* %4, metadata !8129, metadata !DIExpression()), !dbg !8134
  %8 = bitcast i32* %5 to i8*, !dbg !8135
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %8) #19, !dbg !8135
  call void @llvm.dbg.declare(metadata i32* %5, metadata !8130, metadata !DIExpression()), !dbg !8136
  %9 = call i32 @_Z9nd_size_tv() #21, !dbg !8137
  store i32 %9, i32* %5, align 4, !dbg !8138, !tbaa !7676
  %10 = bitcast i32* %6 to i8*, !dbg !8139
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %10) #19, !dbg !8139
  call void @llvm.dbg.declare(metadata i32* %6, metadata !8131, metadata !DIExpression()), !dbg !8140
  %11 = call i32 @sea_max_string_len() #17, !dbg !8141
  store i32 %11, i32* %6, align 4, !dbg !8140, !tbaa !7676
  %12 = load i32, i32* %5, align 4, !dbg !8142, !tbaa !7676
  %13 = load i32, i32* %4, align 4, !dbg !8143, !tbaa !7676
  %14 = icmp ult i32 %12, %13, !dbg !8144
  br i1 %14, label %15, label %19, !dbg !8145

15:                                               ; preds = %2
  %16 = load i32, i32* %4, align 4, !dbg !8146, !tbaa !7676
  %17 = load i32, i32* %6, align 4, !dbg !8147, !tbaa !7676
  %18 = icmp ule i32 %16, %17, !dbg !8148
  br label %19

19:                                               ; preds = %15, %2
  %20 = phi i1 [ false, %2 ], [ %18, %15 ], !dbg !8149
  call void @__SEA_assume(i1 zeroext %20) #17, !dbg !8150
  %21 = load i8*, i8** %3, align 4, !dbg !8151, !tbaa !7659
  %22 = load i32, i32* %5, align 4, !dbg !8152, !tbaa !7676
  %23 = getelementptr inbounds i8, i8* %21, i32 %22, !dbg !8151
  %24 = load i8, i8* %23, align 1, !dbg !8151, !tbaa !7704
  %25 = sext i8 %24 to i32, !dbg !8151
  %26 = icmp eq i32 %25, 0, !dbg !8153
  call void @__SEA_assume(i1 zeroext %26) #17, !dbg !8154
  %27 = bitcast i32* %7 to i8*, !dbg !8155
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %27) #19, !dbg !8155
  call void @llvm.dbg.declare(metadata i32* %7, metadata !8132, metadata !DIExpression()), !dbg !8156
  store i32 0, i32* %7, align 4, !dbg !8156, !tbaa !7676
  store i32 0, i32* %7, align 4, !dbg !8157, !tbaa !7676
  br label %28, !dbg !8159

28:                                               ; preds = %44, %19
  %29 = load i32, i32* %7, align 4, !dbg !8160, !tbaa !7676
  %30 = load i32, i32* %6, align 4, !dbg !8162, !tbaa !7676
  %31 = icmp ult i32 %29, %30, !dbg !8163
  br i1 %31, label %32, label %47, !dbg !8164

32:                                               ; preds = %28
  %33 = load i32, i32* %7, align 4, !dbg !8165, !tbaa !7676
  %34 = load i32, i32* %5, align 4, !dbg !8168, !tbaa !7676
  %35 = icmp ult i32 %33, %34, !dbg !8169
  br i1 %35, label %36, label %43, !dbg !8170

36:                                               ; preds = %32
  %37 = load i8*, i8** %3, align 4, !dbg !8171, !tbaa !7659
  %38 = load i32, i32* %7, align 4, !dbg !8173, !tbaa !7676
  %39 = getelementptr inbounds i8, i8* %37, i32 %38, !dbg !8171
  %40 = load i8, i8* %39, align 1, !dbg !8171, !tbaa !7704
  %41 = sext i8 %40 to i32, !dbg !8171
  %42 = icmp ne i32 %41, 0, !dbg !8174
  call void @__SEA_assume(i1 zeroext %42) #17, !dbg !8175
  br label %43, !dbg !8176

43:                                               ; preds = %36, %32
  br label %44, !dbg !8177

44:                                               ; preds = %43
  %45 = load i32, i32* %7, align 4, !dbg !8178, !tbaa !7676
  %46 = add i32 %45, 1, !dbg !8178
  store i32 %46, i32* %7, align 4, !dbg !8178, !tbaa !7676
  br label %28, !dbg !8179, !llvm.loop !8180

47:                                               ; preds = %28
  %48 = load i32, i32* %5, align 4, !dbg !8182, !tbaa !7676
  %49 = bitcast i32* %7 to i8*, !dbg !8183
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %49) #19, !dbg !8183
  %50 = bitcast i32* %6 to i8*, !dbg !8183
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %50) #19, !dbg !8183
  %51 = bitcast i32* %5 to i8*, !dbg !8183
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %51) #19, !dbg !8183
  ret i32 %48, !dbg !8184
}

; Function Attrs: argmemonly nounwind
declare !dbg !635 i32 @_Z9nd_size_tv() #11

attributes #0 = { nounwind ssp "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #1 = { nofree nosync nounwind readnone speculatable willreturn }
attributes #2 = { inlinehint nounwind ssp "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #3 = { argmemonly nofree nounwind willreturn }
attributes #4 = { "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #5 = { argmemonly nofree nosync nounwind willreturn }
attributes #6 = { nofree nosync nounwind willreturn }
attributes #7 = { nofree nosync nounwind readnone willreturn }
attributes #8 = { argmemonly nofree nounwind willreturn writeonly }
attributes #9 = { noreturn "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #10 = { convergent nofree nosync nounwind readnone willreturn }
attributes #11 = { argmemonly nounwind "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #12 = { alwaysinline nounwind ssp "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #13 = { allocsize(0) "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #14 = { cold noreturn "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #15 = { nounwind ssp allocsize(1) "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #16 = { ssp "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-builtin-memcpy" "no-builtin-memmove" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="false" "stack-protector-buffer-size"="8" "target-cpu"="arm7tdmi" "target-features"="+armv4t,+soft-float,+strict-align,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8d16,-fp-armv8d16sp,-fp-armv8sp,-fp16,-fp16fml,-fp64,-fpregs,-fullfp16,-mve,-mve.fp,-neon,-thumb-mode,-vfp2,-vfp2sp,-vfp3,-vfp3d16,-vfp3d16sp,-vfp3sp,-vfp4,-vfp4d16,-vfp4d16sp,-vfp4sp" "unsafe-fp-math"="false" "use-soft-float"="true" }
attributes #17 = { "no-builtin-memcpy" "no-builtin-memmove" }
attributes #18 = { nounwind "no-builtin-memcpy" "no-builtin-memmove" }
attributes #19 = { nounwind }
attributes #20 = { noreturn "no-builtin-memcpy" "no-builtin-memmove" }
attributes #21 = { argmemonly nounwind "no-builtin-memcpy" "no-builtin-memmove" }
attributes #22 = { allocsize(0) "no-builtin-memcpy" "no-builtin-memmove" }
attributes #23 = { cold noreturn "no-builtin-memcpy" "no-builtin-memmove" }

!llvm.dbg.cu = !{!2, !246, !276, !305, !334, !350, !381, !422, !460, !572, !203, !581, !597, !623, !242, !626, !628}
!llvm.ident = !{!643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643, !643}
!llvm.module.flags = !{!644, !645, !646, !647, !648, !649}

!0 = !DIGlobalVariableExpression(var: !1, expr: !DIExpression())
!1 = distinct !DIGlobalVariable(name: "s_tolower_table", scope: !2, file: !195, line: 375, type: !196, isLocal: true, isDefinition: true)
!2 = distinct !DICompileUnit(language: DW_LANG_C99, file: !3, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !4, retainedTypes: !60, globals: !192, nameTableKind: None)
!3 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/aws-c-common/source/byte_buf.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/jobs/array_eq_c_str_ignore_case")
!4 = !{!5}
!5 = !DICompositeType(tag: DW_TAG_enumeration_type, name: "aws_common_error", file: !6, line: 143, baseType: !7, size: 32, elements: !8)
!6 = !DIFile(filename: "aws-c-common/include/aws/common/error.h", directory: "/Users/jorge/Repos/verify-c-common")
!7 = !DIBasicType(name: "unsigned int", size: 32, encoding: DW_ATE_unsigned)
!8 = !{!9, !10, !11, !12, !13, !14, !15, !16, !17, !18, !19, !20, !21, !22, !23, !24, !25, !26, !27, !28, !29, !30, !31, !32, !33, !34, !35, !36, !37, !38, !39, !40, !41, !42, !43, !44, !45, !46, !47, !48, !49, !50, !51, !52, !53, !54, !55, !56, !57, !58, !59}
!9 = !DIEnumerator(name: "AWS_ERROR_SUCCESS", value: 0, isUnsigned: true)
!10 = !DIEnumerator(name: "AWS_ERROR_OOM", value: 1, isUnsigned: true)
!11 = !DIEnumerator(name: "AWS_ERROR_NO_SPACE", value: 2, isUnsigned: true)
!12 = !DIEnumerator(name: "AWS_ERROR_UNKNOWN", value: 3, isUnsigned: true)
!13 = !DIEnumerator(name: "AWS_ERROR_SHORT_BUFFER", value: 4, isUnsigned: true)
!14 = !DIEnumerator(name: "AWS_ERROR_OVERFLOW_DETECTED", value: 5, isUnsigned: true)
!15 = !DIEnumerator(name: "AWS_ERROR_UNSUPPORTED_OPERATION", value: 6, isUnsigned: true)
!16 = !DIEnumerator(name: "AWS_ERROR_INVALID_BUFFER_SIZE", value: 7, isUnsigned: true)
!17 = !DIEnumerator(name: "AWS_ERROR_INVALID_HEX_STR", value: 8, isUnsigned: true)
!18 = !DIEnumerator(name: "AWS_ERROR_INVALID_BASE64_STR", value: 9, isUnsigned: true)
!19 = !DIEnumerator(name: "AWS_ERROR_INVALID_INDEX", value: 10, isUnsigned: true)
!20 = !DIEnumerator(name: "AWS_ERROR_THREAD_INVALID_SETTINGS", value: 11, isUnsigned: true)
!21 = !DIEnumerator(name: "AWS_ERROR_THREAD_INSUFFICIENT_RESOURCE", value: 12, isUnsigned: true)
!22 = !DIEnumerator(name: "AWS_ERROR_THREAD_NO_PERMISSIONS", value: 13, isUnsigned: true)
!23 = !DIEnumerator(name: "AWS_ERROR_THREAD_NOT_JOINABLE", value: 14, isUnsigned: true)
!24 = !DIEnumerator(name: "AWS_ERROR_THREAD_NO_SUCH_THREAD_ID", value: 15, isUnsigned: true)
!25 = !DIEnumerator(name: "AWS_ERROR_THREAD_DEADLOCK_DETECTED", value: 16, isUnsigned: true)
!26 = !DIEnumerator(name: "AWS_ERROR_MUTEX_NOT_INIT", value: 17, isUnsigned: true)
!27 = !DIEnumerator(name: "AWS_ERROR_MUTEX_TIMEOUT", value: 18, isUnsigned: true)
!28 = !DIEnumerator(name: "AWS_ERROR_MUTEX_CALLER_NOT_OWNER", value: 19, isUnsigned: true)
!29 = !DIEnumerator(name: "AWS_ERROR_MUTEX_FAILED", value: 20, isUnsigned: true)
!30 = !DIEnumerator(name: "AWS_ERROR_COND_VARIABLE_INIT_FAILED", value: 21, isUnsigned: true)
!31 = !DIEnumerator(name: "AWS_ERROR_COND_VARIABLE_TIMED_OUT", value: 22, isUnsigned: true)
!32 = !DIEnumerator(name: "AWS_ERROR_COND_VARIABLE_ERROR_UNKNOWN", value: 23, isUnsigned: true)
!33 = !DIEnumerator(name: "AWS_ERROR_CLOCK_FAILURE", value: 24, isUnsigned: true)
!34 = !DIEnumerator(name: "AWS_ERROR_LIST_EMPTY", value: 25, isUnsigned: true)
!35 = !DIEnumerator(name: "AWS_ERROR_DEST_COPY_TOO_SMALL", value: 26, isUnsigned: true)
!36 = !DIEnumerator(name: "AWS_ERROR_LIST_EXCEEDS_MAX_SIZE", value: 27, isUnsigned: true)
!37 = !DIEnumerator(name: "AWS_ERROR_LIST_STATIC_MODE_CANT_SHRINK", value: 28, isUnsigned: true)
!38 = !DIEnumerator(name: "AWS_ERROR_PRIORITY_QUEUE_FULL", value: 29, isUnsigned: true)
!39 = !DIEnumerator(name: "AWS_ERROR_PRIORITY_QUEUE_EMPTY", value: 30, isUnsigned: true)
!40 = !DIEnumerator(name: "AWS_ERROR_PRIORITY_QUEUE_BAD_NODE", value: 31, isUnsigned: true)
!41 = !DIEnumerator(name: "AWS_ERROR_HASHTBL_ITEM_NOT_FOUND", value: 32, isUnsigned: true)
!42 = !DIEnumerator(name: "AWS_ERROR_INVALID_DATE_STR", value: 33, isUnsigned: true)
!43 = !DIEnumerator(name: "AWS_ERROR_INVALID_ARGUMENT", value: 34, isUnsigned: true)
!44 = !DIEnumerator(name: "AWS_ERROR_RANDOM_GEN_FAILED", value: 35, isUnsigned: true)
!45 = !DIEnumerator(name: "AWS_ERROR_MALFORMED_INPUT_STRING", value: 36, isUnsigned: true)
!46 = !DIEnumerator(name: "AWS_ERROR_UNIMPLEMENTED", value: 37, isUnsigned: true)
!47 = !DIEnumerator(name: "AWS_ERROR_INVALID_STATE", value: 38, isUnsigned: true)
!48 = !DIEnumerator(name: "AWS_ERROR_ENVIRONMENT_GET", value: 39, isUnsigned: true)
!49 = !DIEnumerator(name: "AWS_ERROR_ENVIRONMENT_SET", value: 40, isUnsigned: true)
!50 = !DIEnumerator(name: "AWS_ERROR_ENVIRONMENT_UNSET", value: 41, isUnsigned: true)
!51 = !DIEnumerator(name: "AWS_ERROR_STREAM_UNSEEKABLE", value: 42, isUnsigned: true)
!52 = !DIEnumerator(name: "AWS_ERROR_NO_PERMISSION", value: 43, isUnsigned: true)
!53 = !DIEnumerator(name: "AWS_ERROR_FILE_INVALID_PATH", value: 44, isUnsigned: true)
!54 = !DIEnumerator(name: "AWS_ERROR_MAX_FDS_EXCEEDED", value: 45, isUnsigned: true)
!55 = !DIEnumerator(name: "AWS_ERROR_SYS_CALL_FAILURE", value: 46, isUnsigned: true)
!56 = !DIEnumerator(name: "AWS_ERROR_C_STRING_BUFFER_NOT_NULL_TERMINATED", value: 47, isUnsigned: true)
!57 = !DIEnumerator(name: "AWS_ERROR_STRING_MATCH_NOT_FOUND", value: 48, isUnsigned: true)
!58 = !DIEnumerator(name: "AWS_ERROR_DIVIDE_BY_ZERO", value: 49, isUnsigned: true)
!59 = !DIEnumerator(name: "AWS_ERROR_END_COMMON_RANGE", value: 1023, isUnsigned: true)
!60 = !{!61, !62, !92, !103, !109, !113, !114, !118, !123, !124, !130, !131, !121, !129, !140, !143, !146, !151, !153, !154, !157, !159, !162, !165, !168, !180, !73, !184, !186, !188, !163, !189}
!61 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: null, size: 32)
!62 = !DISubprogram(name: "aws_mem_acquire", scope: !63, file: !63, line: 58, type: !64, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!63 = !DIFile(filename: "aws-c-common/include/aws/common/allocator.h", directory: "/Users/jorge/Repos/verify-c-common")
!64 = !DISubroutineType(types: !65)
!65 = !{!61, !66, !77}
!66 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !67, size: 32)
!67 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !68)
!68 = !{!69, !78, !82, !86, !90}
!69 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !67, file: !63, line: 16, baseType: !70, size: 32)
!70 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !71, size: 32)
!71 = !DISubroutineType(types: !72)
!72 = !{!61, !66, !73}
!73 = !DIDerivedType(tag: DW_TAG_typedef, name: "size_t", file: !74, line: 31, baseType: !75)
!74 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/sys/_types/_size_t.h", directory: "")
!75 = !DIDerivedType(tag: DW_TAG_typedef, name: "__darwin_size_t", file: !76, line: 70, baseType: !77)
!76 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/arm/_types.h", directory: "")
!77 = !DIBasicType(name: "long unsigned int", size: 32, encoding: DW_ATE_unsigned)
!78 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !67, file: !63, line: 17, baseType: !79, size: 32, offset: 32)
!79 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !80, size: 32)
!80 = !DISubroutineType(types: !81)
!81 = !{null, !66, !61}
!82 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !67, file: !63, line: 19, baseType: !83, size: 32, offset: 64)
!83 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !84, size: 32)
!84 = !DISubroutineType(types: !85)
!85 = !{!61, !66, !61, !73, !73}
!86 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !67, file: !63, line: 21, baseType: !87, size: 32, offset: 96)
!87 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !88, size: 32)
!88 = !DISubroutineType(types: !89)
!89 = !{!61, !66, !73, !73}
!90 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !67, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!91 = !{}
!92 = !DISubprogram(name: "aws_byte_buf_is_valid", scope: !93, file: !93, line: 132, type: !94, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!93 = !DIFile(filename: "aws-c-common/include/aws/common/byte_buf.h", directory: "/Users/jorge/Repos/verify-c-common")
!94 = !DISubroutineType(types: !95)
!95 = !{!96, !97}
!96 = !DIBasicType(name: "_Bool", size: 8, encoding: DW_ATE_boolean)
!97 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !98, size: 32)
!98 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !99)
!99 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_byte_buf", file: !93, line: 25, size: 128, elements: !100)
!100 = !{!101, !102, !107, !108}
!101 = !DIDerivedType(tag: DW_TAG_member, name: "len", scope: !99, file: !93, line: 27, baseType: !73, size: 32)
!102 = !DIDerivedType(tag: DW_TAG_member, name: "buffer", scope: !99, file: !93, line: 28, baseType: !103, size: 32, offset: 32)
!103 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !104, size: 32)
!104 = !DIDerivedType(tag: DW_TAG_typedef, name: "uint8_t", file: !105, line: 31, baseType: !106)
!105 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/_types/_uint8_t.h", directory: "")
!106 = !DIBasicType(name: "unsigned char", size: 8, encoding: DW_ATE_unsigned_char)
!107 = !DIDerivedType(tag: DW_TAG_member, name: "capacity", scope: !99, file: !93, line: 29, baseType: !73, size: 32, offset: 64)
!108 = !DIDerivedType(tag: DW_TAG_member, name: "allocator", scope: !99, file: !93, line: 30, baseType: !66, size: 32, offset: 96)
!109 = !DISubprogram(name: "aws_byte_buf_secure_zero", scope: !93, file: !93, line: 186, type: !110, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!110 = !DISubroutineType(types: !111)
!111 = !{null, !112}
!112 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !99, size: 32)
!113 = !DISubprogram(name: "aws_mem_release", scope: !63, file: !63, line: 84, type: !80, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!114 = !DISubprogram(name: "aws_secure_zero", scope: !115, file: !115, line: 56, type: !116, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!115 = !DIFile(filename: "aws-c-common/include/aws/common/zero.h", directory: "/Users/jorge/Repos/verify-c-common")
!116 = !DISubroutineType(types: !117)
!117 = !{null, !61, !77}
!118 = !DISubprogram(name: "aws_array_eq", scope: !93, file: !93, line: 77, type: !119, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!119 = !DISubroutineType(types: !120)
!120 = !{!96, !121, !77, !121, !77}
!121 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !122, size: 32)
!122 = !DIDerivedType(tag: DW_TAG_const_type, baseType: null)
!123 = !DISubprogram(name: "aws_array_eq_ignore_case", scope: !93, file: !93, line: 87, type: !119, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!124 = !DISubprogram(name: "aws_array_eq_c_str", scope: !93, file: !93, line: 100, type: !125, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!125 = !DISubroutineType(types: !126)
!126 = !{!96, !121, !77, !127}
!127 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !128, size: 32)
!128 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !129)
!129 = !DIBasicType(name: "char", size: 8, encoding: DW_ATE_signed_char)
!130 = !DISubprogram(name: "aws_array_eq_c_str_ignore_case", scope: !93, file: !93, line: 111, type: !125, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!131 = !DISubprogram(name: "aws_byte_buf_append_and_update", scope: !93, file: !93, line: 412, type: !132, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!132 = !DISubroutineType(types: !133)
!133 = !{!134, !112, !135}
!134 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
!135 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !136, size: 32)
!136 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_byte_cursor", file: !93, line: 38, size: 64, elements: !137)
!137 = !{!138, !139}
!138 = !DIDerivedType(tag: DW_TAG_member, name: "len", scope: !136, file: !93, line: 40, baseType: !73, size: 32)
!139 = !DIDerivedType(tag: DW_TAG_member, name: "ptr", scope: !136, file: !93, line: 41, baseType: !103, size: 32, offset: 32)
!140 = !DISubprogram(name: "aws_byte_cursor_advance", scope: !93, file: !93, line: 574, type: !141, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!141 = !DISubroutineType(types: !142)
!142 = !{!136, !135, !77}
!143 = !DISubprogram(name: "aws_byte_cursor_from_buf", scope: !93, file: !93, line: 558, type: !144, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!144 = !DISubroutineType(types: !145)
!145 = !{!136, !97}
!146 = !DISubprogram(name: "aws_byte_buf_append", scope: !93, file: !93, line: 345, type: !147, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!147 = !DISubroutineType(types: !148)
!148 = !{!134, !112, !149}
!149 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !150, size: 32)
!150 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !136)
!151 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !152, size: 32)
!152 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !104)
!153 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !61, size: 32)
!154 = !DISubprogram(name: "aws_mem_realloc", scope: !63, file: !63, line: 95, type: !155, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!155 = !DISubroutineType(types: !156)
!156 = !{!134, !66, !153, !77, !77}
!157 = !DIDerivedType(tag: DW_TAG_typedef, name: "uintptr_t", file: !158, line: 34, baseType: !77)
!158 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/sys/_types/_uintptr_t.h", directory: "")
!159 = !DISubprogram(name: "aws_raise_error_private", scope: !6, file: !6, line: 82, type: !160, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!160 = !DISubroutineType(types: !161)
!161 = !{null, !134}
!162 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !163, size: 32)
!163 = !DIDerivedType(tag: DW_TAG_typedef, name: "uint32_t", file: !164, line: 31, baseType: !7)
!164 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/_types/_uint32_t.h", directory: "")
!165 = !DISubprogram(name: "aws_last_error", scope: !6, file: !6, line: 52, type: !166, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!166 = !DISubroutineType(types: !167)
!167 = !{!134}
!168 = !DISubprogram(name: "aws_array_list_ensure_capacity", scope: !169, file: !169, line: 187, type: !170, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!169 = !DIFile(filename: "aws-c-common/include/aws/common/array_list.h", directory: "/Users/jorge/Repos/verify-c-common")
!170 = !DISubroutineType(types: !171)
!171 = !{!134, !172, !77}
!172 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !173, size: 32)
!173 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_array_list", file: !169, line: 15, size: 160, elements: !174)
!174 = !{!175, !176, !177, !178, !179}
!175 = !DIDerivedType(tag: DW_TAG_member, name: "alloc", scope: !173, file: !169, line: 16, baseType: !66, size: 32)
!176 = !DIDerivedType(tag: DW_TAG_member, name: "current_size", scope: !173, file: !169, line: 17, baseType: !73, size: 32, offset: 32)
!177 = !DIDerivedType(tag: DW_TAG_member, name: "length", scope: !173, file: !169, line: 18, baseType: !73, size: 32, offset: 64)
!178 = !DIDerivedType(tag: DW_TAG_member, name: "item_size", scope: !173, file: !169, line: 19, baseType: !73, size: 32, offset: 96)
!179 = !DIDerivedType(tag: DW_TAG_member, name: "data", scope: !173, file: !169, line: 20, baseType: !61, size: 32, offset: 128)
!180 = !DISubprogram(name: "aws_fatal_assert", scope: !181, file: !181, line: 17, type: !182, flags: DIFlagPrototyped | DIFlagNoReturn, spFlags: DISPFlagOptimized, retainedNodes: !91)
!181 = !DIFile(filename: "aws-c-common/include/aws/common/assert.h", directory: "/Users/jorge/Repos/verify-c-common")
!182 = !DISubroutineType(types: !183)
!183 = !{null, !127, !127, !134}
!184 = !DIDerivedType(tag: DW_TAG_typedef, name: "__uint16_t", file: !76, line: 21, baseType: !185)
!185 = !DIBasicType(name: "unsigned short", size: 16, encoding: DW_ATE_unsigned)
!186 = !DIDerivedType(tag: DW_TAG_typedef, name: "uint16_t", file: !187, line: 31, baseType: !185)
!187 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/_types/_uint16_t.h", directory: "")
!188 = !DIDerivedType(tag: DW_TAG_typedef, name: "__uint32_t", file: !76, line: 23, baseType: !7)
!189 = !DIDerivedType(tag: DW_TAG_typedef, name: "uint64_t", file: !190, line: 31, baseType: !191)
!190 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/_types/_uint64_t.h", directory: "")
!191 = !DIBasicType(name: "long long unsigned int", size: 64, encoding: DW_ATE_unsigned)
!192 = !{!0, !193, !199}
!193 = !DIGlobalVariableExpression(var: !194, expr: !DIExpression())
!194 = distinct !DIGlobalVariable(name: "s_hex_to_num_table", scope: !2, file: !195, line: 1312, type: !196, isLocal: true, isDefinition: true)
!195 = !DIFile(filename: "aws-c-common/source/byte_buf.c", directory: "/Users/jorge/Repos/verify-c-common")
!196 = !DICompositeType(tag: DW_TAG_array_type, baseType: !152, size: 2048, elements: !197)
!197 = !{!198}
!198 = !DISubrange(count: 256, lowerBound: 0)
!199 = !DIGlobalVariableExpression(var: !200, expr: !DIExpression())
!200 = distinct !DIGlobalVariable(name: "s_null_terminator_cursor", scope: !2, file: !195, line: 1596, type: !136, isLocal: true, isDefinition: true)
!201 = !DIGlobalVariableExpression(var: !202, expr: !DIExpression())
!202 = distinct !DIGlobalVariable(name: "s_allocator_static", scope: !203, file: !219, line: 45, type: !220, isLocal: true, isDefinition: true)
!203 = distinct !DICompileUnit(language: DW_LANG_C99, file: !204, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !205, globals: !218, nameTableKind: None)
!204 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/proof_allocators.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!205 = !{!206, !61, !210, !213, !214}
!206 = !DISubprogram(name: "sea_realloc", scope: !207, file: !207, line: 60, type: !208, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!207 = !DIFile(filename: "seahorn/include/sea_allocators.h", directory: "/Users/jorge/Repos/verify-c-common")
!208 = !DISubroutineType(types: !209)
!209 = !{!61, !61, !77}
!210 = !DISubprogram(name: "sea_malloc_havoc_safe", scope: !207, file: !207, line: 43, type: !211, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!211 = !DISubroutineType(types: !212)
!212 = !{!61, !77}
!213 = !DISubprogram(name: "sea_malloc_havoc", scope: !207, file: !207, line: 29, type: !211, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!214 = !DISubprogram(name: "free", scope: !215, file: !215, line: 42, type: !216, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!215 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/malloc/_malloc.h", directory: "")
!216 = !DISubroutineType(types: !217)
!217 = !{null, !61}
!218 = !{!201}
!219 = !DIFile(filename: "seahorn/lib/proof_allocators.c", directory: "/Users/jorge/Repos/verify-c-common")
!220 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !221)
!221 = !{!222, !227, !231, !235, !239}
!222 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !220, file: !63, line: 16, baseType: !223, size: 32)
!223 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !224, size: 32)
!224 = !DISubroutineType(types: !225)
!225 = !{!61, !226, !73}
!226 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !220, size: 32)
!227 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !220, file: !63, line: 17, baseType: !228, size: 32, offset: 32)
!228 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !229, size: 32)
!229 = !DISubroutineType(types: !230)
!230 = !{null, !226, !61}
!231 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !220, file: !63, line: 19, baseType: !232, size: 32, offset: 64)
!232 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !233, size: 32)
!233 = !DISubroutineType(types: !234)
!234 = !{!61, !226, !61, !73, !73}
!235 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !220, file: !63, line: 21, baseType: !236, size: 32, offset: 96)
!236 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !237, size: 32)
!237 = !DISubroutineType(types: !238)
!238 = !{!61, !226, !73, !73}
!239 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !220, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!240 = !DIGlobalVariableExpression(var: !241, expr: !DIExpression())
!241 = distinct !DIGlobalVariable(name: "tl_last_error", scope: !242, file: !245, line: 3, type: !134, isLocal: true, isDefinition: true)
!242 = distinct !DICompileUnit(language: DW_LANG_C99, file: !243, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, globals: !244, nameTableKind: None)
!243 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/error_override.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!244 = !{!240}
!245 = !DIFile(filename: "seahorn/lib/error_override.c", directory: "/Users/jorge/Repos/verify-c-common")
!246 = distinct !DICompileUnit(language: DW_LANG_C99, file: !247, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !248, nameTableKind: None)
!247 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/jobs/array_eq_c_str_ignore_case/aws_array_eq_c_str_ignore_case_harness.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/jobs/array_eq_c_str_ignore_case")
!248 = !{!249, !253, !255, !103, !260, !130, !271}
!249 = !DISubprogram(name: "nd_size_t", scope: !250, file: !250, line: 20, type: !251, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!250 = !DIFile(filename: "seahorn/include/nondet.h", directory: "/Users/jorge/Repos/verify-c-common")
!251 = !DISubroutineType(types: !252)
!252 = !{!77}
!253 = !DISubprogram(name: "can_fail_malloc", scope: !254, file: !254, line: 29, type: !211, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!254 = !DIFile(filename: "seahorn/include/proof_allocators.h", directory: "/Users/jorge/Repos/verify-c-common")
!255 = !DISubprogram(name: "ensure_c_str_is_nd_allocated_safe", scope: !256, file: !256, line: 11, type: !257, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!256 = !DIFile(filename: "seahorn/include/string_helper.h", directory: "/Users/jorge/Repos/verify-c-common")
!257 = !DISubroutineType(types: !258)
!258 = !{!127, !77, !259}
!259 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !77, size: 32)
!260 = !DISubprogram(name: "save_byte_from_array", scope: !261, file: !261, line: 77, type: !262, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!261 = !DIFile(filename: "seahorn/include/utils.h", directory: "/Users/jorge/Repos/verify-c-common")
!262 = !DISubroutineType(types: !263)
!263 = !{null, !264, !77, !266}
!264 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !265, size: 32)
!265 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !106)
!266 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !267, size: 32)
!267 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "store_byte_from_buffer", file: !261, line: 42, size: 64, elements: !268)
!268 = !{!269, !270}
!269 = !DIDerivedType(tag: DW_TAG_member, name: "index", scope: !267, file: !261, line: 43, baseType: !73, size: 32)
!270 = !DIDerivedType(tag: DW_TAG_member, name: "byte", scope: !267, file: !261, line: 44, baseType: !104, size: 8, offset: 32)
!271 = !DISubprogram(name: "assert_byte_from_buffer_matches", scope: !261, file: !261, line: 68, type: !272, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!272 = !DISubroutineType(types: !273)
!273 = !{null, !264, !274}
!274 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !275, size: 32)
!275 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !267)
!276 = distinct !DICompileUnit(language: DW_LANG_C99, file: !277, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !278, nameTableKind: None)
!277 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/array_list_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!278 = !{!249, !253, !279, !302, !304}
!279 = !DISubprogram(name: "sea_allocator", scope: !254, file: !254, line: 34, type: !280, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!280 = !DISubroutineType(types: !281)
!281 = !{!282}
!282 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !283, size: 32)
!283 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !284)
!284 = !{!285, !289, !293, !297, !301}
!285 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !283, file: !63, line: 16, baseType: !286, size: 32)
!286 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !287, size: 32)
!287 = !DISubroutineType(types: !288)
!288 = !{!61, !282, !73}
!289 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !283, file: !63, line: 17, baseType: !290, size: 32, offset: 32)
!290 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !291, size: 32)
!291 = !DISubroutineType(types: !292)
!292 = !{null, !282, !61}
!293 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !283, file: !63, line: 19, baseType: !294, size: 32, offset: 64)
!294 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !295, size: 32)
!295 = !DISubroutineType(types: !296)
!296 = !{!61, !282, !61, !73, !73}
!297 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !283, file: !63, line: 21, baseType: !298, size: 32, offset: 96)
!298 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !299, size: 32)
!299 = !DISubroutineType(types: !300)
!300 = !{!61, !282, !73, !73}
!301 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !283, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!302 = !DISubprogram(name: "sea_max_array_list_len", scope: !303, file: !303, line: 31, type: !251, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!303 = !DIFile(filename: "seahorn/include/bounds.h", directory: "/Users/jorge/Repos/verify-c-common")
!304 = !DISubprogram(name: "sea_max_array_list_item_size", scope: !303, file: !303, line: 26, type: !251, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!305 = distinct !DICompileUnit(language: DW_LANG_C99, file: !306, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !307, nameTableKind: None)
!306 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/byte_buf_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!307 = !{!249, !308, !253, !309, !332, !333}
!308 = !DISubprogram(name: "sea_max_buffer_size", scope: !303, file: !303, line: 11, type: !251, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!309 = !DISubprogram(name: "sea_allocator", scope: !254, file: !254, line: 34, type: !310, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!310 = !DISubroutineType(types: !311)
!311 = !{!312}
!312 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !313, size: 32)
!313 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !314)
!314 = !{!315, !319, !323, !327, !331}
!315 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !313, file: !63, line: 16, baseType: !316, size: 32)
!316 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !317, size: 32)
!317 = !DISubroutineType(types: !318)
!318 = !{!61, !312, !73}
!319 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !313, file: !63, line: 17, baseType: !320, size: 32, offset: 32)
!320 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !321, size: 32)
!321 = !DISubroutineType(types: !322)
!322 = !{null, !312, !61}
!323 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !313, file: !63, line: 19, baseType: !324, size: 32, offset: 64)
!324 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !325, size: 32)
!325 = !DISubroutineType(types: !326)
!326 = !{!61, !312, !61, !73, !73}
!327 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !313, file: !63, line: 21, baseType: !328, size: 32, offset: 96)
!328 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !329, size: 32)
!329 = !DISubroutineType(types: !330)
!330 = !{!61, !312, !73, !73}
!331 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !313, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!332 = !DISubprogram(name: "sea_malloc_aligned_havoc", scope: !207, file: !207, line: 57, type: !211, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!333 = !DISubprogram(name: "bounded_malloc", scope: !254, file: !254, line: 22, type: !211, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!334 = distinct !DICompileUnit(language: DW_LANG_C99, file: !335, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !336, nameTableKind: None)
!335 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/linked_list_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!336 = !{!249, !337, !347, !61}
!337 = !DISubprogram(name: "aws_linked_list_attach_after", scope: !338, file: !338, line: 14, type: !339, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!338 = !DIFile(filename: "seahorn/include/linked_list_helper.h", directory: "/Users/jorge/Repos/verify-c-common")
!339 = !DISubroutineType(types: !340)
!340 = !{null, !341, !341, !96}
!341 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !342, size: 32)
!342 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_linked_list_node", file: !343, line: 13, size: 64, elements: !344)
!343 = !DIFile(filename: "aws-c-common/include/aws/common/linked_list.h", directory: "/Users/jorge/Repos/verify-c-common")
!344 = !{!345, !346}
!345 = !DIDerivedType(tag: DW_TAG_member, name: "next", scope: !342, file: !343, line: 14, baseType: !341, size: 32)
!346 = !DIDerivedType(tag: DW_TAG_member, name: "prev", scope: !342, file: !343, line: 15, baseType: !341, size: 32, offset: 32)
!347 = !DISubprogram(name: "nd_linked_list_node", scope: !338, file: !338, line: 8, type: !348, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!348 = !DISubroutineType(types: !349)
!349 = !{!341}
!350 = distinct !DICompileUnit(language: DW_LANG_C99, file: !351, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !352, nameTableKind: None)
!351 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/string_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!352 = !{!210, !353, !378, !379, !103, !249, !380, !213, !332}
!353 = !DISubprogram(name: "sea_allocator", scope: !254, file: !254, line: 34, type: !354, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!354 = !DISubroutineType(types: !355)
!355 = !{!356}
!356 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !357, size: 32)
!357 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !358)
!358 = !{!359, !365, !369, !373, !377}
!359 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !357, file: !63, line: 16, baseType: !360, size: 32)
!360 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !361, size: 32)
!361 = !DISubroutineType(types: !362)
!362 = !{!61, !356, !363}
!363 = !DIDerivedType(tag: DW_TAG_typedef, name: "size_t", file: !364, line: 46, baseType: !77)
!364 = !DIFile(filename: "src/clang-10.0.1.src/install-release/lib/clang/10.0.1/include/stddef.h", directory: "/Users/jorge")
!365 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !357, file: !63, line: 17, baseType: !366, size: 32, offset: 32)
!366 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !367, size: 32)
!367 = !DISubroutineType(types: !368)
!368 = !{null, !356, !61}
!369 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !357, file: !63, line: 19, baseType: !370, size: 32, offset: 64)
!370 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !371, size: 32)
!371 = !DISubroutineType(types: !372)
!372 = !{!61, !356, !61, !363, !363}
!373 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !357, file: !63, line: 21, baseType: !374, size: 32, offset: 96)
!374 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !375, size: 32)
!375 = !DISubroutineType(types: !376)
!376 = !{!61, !356, !363, !363}
!377 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !357, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!378 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !356, size: 32)
!379 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !363, size: 32)
!380 = !DISubprogram(name: "sea_max_string_len", scope: !303, file: !303, line: 16, type: !251, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!381 = distinct !DICompileUnit(language: DW_LANG_C99, file: !382, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !383, nameTableKind: None)
!382 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/priority_queue_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!383 = !{!384, !385, !417}
!384 = !DISubprogram(name: "nd_int", scope: !250, file: !250, line: 19, type: !166, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!385 = !DISubprogram(name: "initialize_array_list", scope: !386, file: !386, line: 9, type: !387, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!386 = !DIFile(filename: "seahorn/include/array_list_helper.h", directory: "/Users/jorge/Repos/verify-c-common")
!387 = !DISubroutineType(types: !388)
!388 = !{null, !389}
!389 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !390, size: 32)
!390 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_array_list", file: !169, line: 15, size: 160, elements: !391)
!391 = !{!392, !413, !414, !415, !416}
!392 = !DIDerivedType(tag: DW_TAG_member, name: "alloc", scope: !390, file: !169, line: 16, baseType: !393, size: 32)
!393 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !394, size: 32)
!394 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !395)
!395 = !{!396, !400, !404, !408, !412}
!396 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !394, file: !63, line: 16, baseType: !397, size: 32)
!397 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !398, size: 32)
!398 = !DISubroutineType(types: !399)
!399 = !{!61, !393, !73}
!400 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !394, file: !63, line: 17, baseType: !401, size: 32, offset: 32)
!401 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !402, size: 32)
!402 = !DISubroutineType(types: !403)
!403 = !{null, !393, !61}
!404 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !394, file: !63, line: 19, baseType: !405, size: 32, offset: 64)
!405 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !406, size: 32)
!406 = !DISubroutineType(types: !407)
!407 = !{!61, !393, !61, !73, !73}
!408 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !394, file: !63, line: 21, baseType: !409, size: 32, offset: 96)
!409 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !410, size: 32)
!410 = !DISubroutineType(types: !411)
!411 = !{!61, !393, !73, !73}
!412 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !394, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!413 = !DIDerivedType(tag: DW_TAG_member, name: "current_size", scope: !390, file: !169, line: 17, baseType: !73, size: 32, offset: 32)
!414 = !DIDerivedType(tag: DW_TAG_member, name: "length", scope: !390, file: !169, line: 18, baseType: !73, size: 32, offset: 64)
!415 = !DIDerivedType(tag: DW_TAG_member, name: "item_size", scope: !390, file: !169, line: 19, baseType: !73, size: 32, offset: 96)
!416 = !DIDerivedType(tag: DW_TAG_member, name: "data", scope: !390, file: !169, line: 20, baseType: !61, size: 32, offset: 128)
!417 = !DISubprogram(name: "aws_array_list_is_bounded", scope: !386, file: !386, line: 19, type: !418, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!418 = !DISubroutineType(types: !419)
!419 = !{!96, !420, !77, !77}
!420 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !421, size: 32)
!421 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !390)
!422 = distinct !DICompileUnit(language: DW_LANG_C99, file: !423, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !424, retainedTypes: !433, nameTableKind: None)
!423 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/ring_buffer_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!424 = !{!425}
!425 = !DICompositeType(tag: DW_TAG_enumeration_type, name: "aws_memory_order", file: !426, line: 34, baseType: !7, size: 32, elements: !427)
!426 = !DIFile(filename: "aws-c-common/include/aws/common/atomics.h", directory: "/Users/jorge/Repos/verify-c-common")
!427 = !{!428, !429, !430, !431, !432}
!428 = !DIEnumerator(name: "aws_memory_order_relaxed", value: 0, isUnsigned: true)
!429 = !DIEnumerator(name: "aws_memory_order_acquire", value: 2, isUnsigned: true)
!430 = !DIEnumerator(name: "aws_memory_order_release", value: 3, isUnsigned: true)
!431 = !DIEnumerator(name: "aws_memory_order_acq_rel", value: 4, isUnsigned: true)
!432 = !DIEnumerator(name: "aws_memory_order_seq_cst", value: 5, isUnsigned: true)
!433 = !{!434, !333, !249, !457}
!434 = !DISubprogram(name: "sea_allocator", scope: !254, file: !254, line: 34, type: !435, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!435 = !DISubroutineType(types: !436)
!436 = !{!437}
!437 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !438, size: 32)
!438 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !439)
!439 = !{!440, !444, !448, !452, !456}
!440 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !438, file: !63, line: 16, baseType: !441, size: 32)
!441 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !442, size: 32)
!442 = !DISubroutineType(types: !443)
!443 = !{!61, !437, !73}
!444 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !438, file: !63, line: 17, baseType: !445, size: 32, offset: 32)
!445 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !446, size: 32)
!446 = !DISubroutineType(types: !447)
!447 = !{null, !437, !61}
!448 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !438, file: !63, line: 19, baseType: !449, size: 32, offset: 64)
!449 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !450, size: 32)
!450 = !DISubroutineType(types: !451)
!451 = !{!61, !437, !61, !73, !73}
!452 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !438, file: !63, line: 21, baseType: !453, size: 32, offset: 96)
!453 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !454, size: 32)
!454 = !DISubroutineType(types: !455)
!455 = !{!61, !437, !73, !73}
!456 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !438, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!457 = !DISubprogram(name: "nd_bool", scope: !250, file: !250, line: 18, type: !458, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!458 = !DISubroutineType(types: !459)
!459 = !{!96}
!460 = distinct !DICompileUnit(language: DW_LANG_C99, file: !461, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !462, retainedTypes: !469, nameTableKind: None)
!461 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/hash_table_helper.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!462 = !{!463}
!463 = !DICompositeType(tag: DW_TAG_enumeration_type, name: "aws_hash_iter_status", file: !464, line: 68, baseType: !7, size: 32, elements: !465)
!464 = !DIFile(filename: "aws-c-common/include/aws/common/hash_table.h", directory: "/Users/jorge/Repos/verify-c-common")
!465 = !{!466, !467, !468}
!466 = !DIEnumerator(name: "AWS_HASH_ITER_STATUS_DONE", value: 0, isUnsigned: true)
!467 = !DIEnumerator(name: "AWS_HASH_ITER_STATUS_DELETE_CALLED", value: 1, isUnsigned: true)
!468 = !DIEnumerator(name: "AWS_HASH_ITER_STATUS_READY_FOR_USE", value: 2, isUnsigned: true)
!469 = !{!249, !470, !333, !474, !497, !500, !503, !103, !559, !567, !457}
!470 = !DISubprogram(name: "hash_table_state_required_bytes", scope: !471, file: !471, line: 60, type: !472, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!471 = !DIFile(filename: "aws-c-common/include/aws/common/private/hash_table_impl.h", directory: "/Users/jorge/Repos/verify-c-common")
!472 = !DISubroutineType(types: !473)
!473 = !{!134, !77, !259}
!474 = !DISubprogram(name: "sea_allocator", scope: !254, file: !254, line: 34, type: !475, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!475 = !DISubroutineType(types: !476)
!476 = !{!477}
!477 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !478, size: 32)
!478 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !479)
!479 = !{!480, !484, !488, !492, !496}
!480 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !478, file: !63, line: 16, baseType: !481, size: 32)
!481 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !482, size: 32)
!482 = !DISubroutineType(types: !483)
!483 = !{!61, !477, !73}
!484 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !478, file: !63, line: 17, baseType: !485, size: 32, offset: 32)
!485 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !486, size: 32)
!486 = !DISubroutineType(types: !487)
!487 = !{null, !477, !61}
!488 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !478, file: !63, line: 19, baseType: !489, size: 32, offset: 64)
!489 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !490, size: 32)
!490 = !DISubroutineType(types: !491)
!491 = !{!61, !477, !61, !73, !73}
!492 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !478, file: !63, line: 21, baseType: !493, size: 32, offset: 96)
!493 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !494, size: 32)
!494 = !DISubroutineType(types: !495)
!495 = !{!61, !477, !73, !73}
!496 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !478, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!497 = !DISubprogram(name: "nd_voidp", scope: !250, file: !250, line: 25, type: !498, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!498 = !DISubroutineType(types: !499)
!499 = !{!61}
!500 = !DISubprogram(name: "nd_hash_iter_status", scope: !501, file: !501, line: 40, type: !502, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!501 = !DIFile(filename: "seahorn/lib/hash_table_helper.c", directory: "/Users/jorge/Repos/verify-c-common")
!502 = !DISubroutineType(types: !462)
!503 = !DISubprogram(name: "aws_hash_iter_is_valid", scope: !464, file: !464, line: 424, type: !504, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!504 = !DISubroutineType(types: !505)
!505 = !{!96, !506}
!506 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !507, size: 32)
!507 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !508)
!508 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_hash_iter", file: !464, line: 74, size: 288, elements: !509)
!509 = !{!510, !552, !553, !554, !555, !556, !557, !558}
!510 = !DIDerivedType(tag: DW_TAG_member, name: "map", scope: !508, file: !464, line: 75, baseType: !511, size: 32)
!511 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !512, size: 32)
!512 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !513)
!513 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_hash_table", file: !464, line: 48, size: 32, elements: !514)
!514 = !{!515}
!515 = !DIDerivedType(tag: DW_TAG_member, name: "p_impl", scope: !513, file: !464, line: 49, baseType: !516, size: 32)
!516 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !517, size: 32)
!517 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "hash_table_state", file: !471, line: 28, size: 352, elements: !518)
!518 = !{!519, !524, !529, !532, !533, !534, !535, !536, !537, !538, !540}
!519 = !DIDerivedType(tag: DW_TAG_member, name: "hash_fn", scope: !517, file: !471, line: 29, baseType: !520, size: 32)
!520 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !521, size: 32)
!521 = !DIDerivedType(tag: DW_TAG_typedef, name: "aws_hash_fn", file: !464, line: 92, baseType: !522)
!522 = !DISubroutineType(types: !523)
!523 = !{!189, !121}
!524 = !DIDerivedType(tag: DW_TAG_member, name: "equals_fn", scope: !517, file: !471, line: 30, baseType: !525, size: 32, offset: 32)
!525 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !526, size: 32)
!526 = !DIDerivedType(tag: DW_TAG_typedef, name: "aws_hash_callback_eq_fn", file: !464, line: 104, baseType: !527)
!527 = !DISubroutineType(types: !528)
!528 = !{!96, !121, !121}
!529 = !DIDerivedType(tag: DW_TAG_member, name: "destroy_key_fn", scope: !517, file: !471, line: 31, baseType: !530, size: 32, offset: 64)
!530 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !531, size: 32)
!531 = !DIDerivedType(tag: DW_TAG_typedef, name: "aws_hash_callback_destroy_fn", file: !464, line: 116, baseType: !216)
!532 = !DIDerivedType(tag: DW_TAG_member, name: "destroy_value_fn", scope: !517, file: !471, line: 32, baseType: !530, size: 32, offset: 96)
!533 = !DIDerivedType(tag: DW_TAG_member, name: "alloc", scope: !517, file: !471, line: 33, baseType: !477, size: 32, offset: 128)
!534 = !DIDerivedType(tag: DW_TAG_member, name: "size", scope: !517, file: !471, line: 35, baseType: !73, size: 32, offset: 160)
!535 = !DIDerivedType(tag: DW_TAG_member, name: "entry_count", scope: !517, file: !471, line: 35, baseType: !73, size: 32, offset: 192)
!536 = !DIDerivedType(tag: DW_TAG_member, name: "max_load", scope: !517, file: !471, line: 36, baseType: !73, size: 32, offset: 224)
!537 = !DIDerivedType(tag: DW_TAG_member, name: "mask", scope: !517, file: !471, line: 38, baseType: !73, size: 32, offset: 256)
!538 = !DIDerivedType(tag: DW_TAG_member, name: "max_load_factor", scope: !517, file: !471, line: 39, baseType: !539, size: 64, offset: 288)
!539 = !DIBasicType(name: "double", size: 64, encoding: DW_ATE_float)
!540 = !DIDerivedType(tag: DW_TAG_member, name: "slots", scope: !517, file: !471, line: 41, baseType: !541, offset: 352)
!541 = !DICompositeType(tag: DW_TAG_array_type, baseType: !542, elements: !550)
!542 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "hash_table_entry", file: !471, line: 13, size: 128, elements: !543)
!543 = !{!544, !549}
!544 = !DIDerivedType(tag: DW_TAG_member, name: "element", scope: !542, file: !471, line: 14, baseType: !545, size: 64)
!545 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_hash_element", file: !464, line: 63, size: 64, elements: !546)
!546 = !{!547, !548}
!547 = !DIDerivedType(tag: DW_TAG_member, name: "key", scope: !545, file: !464, line: 64, baseType: !121, size: 32)
!548 = !DIDerivedType(tag: DW_TAG_member, name: "value", scope: !545, file: !464, line: 65, baseType: !61, size: 32, offset: 32)
!549 = !DIDerivedType(tag: DW_TAG_member, name: "hash_code", scope: !542, file: !471, line: 15, baseType: !189, size: 64, offset: 64)
!550 = !{!551}
!551 = !DISubrange(count: -1, lowerBound: 0)
!552 = !DIDerivedType(tag: DW_TAG_member, name: "element", scope: !508, file: !464, line: 76, baseType: !545, size: 64, offset: 32)
!553 = !DIDerivedType(tag: DW_TAG_member, name: "slot", scope: !508, file: !464, line: 77, baseType: !73, size: 32, offset: 96)
!554 = !DIDerivedType(tag: DW_TAG_member, name: "limit", scope: !508, file: !464, line: 78, baseType: !73, size: 32, offset: 128)
!555 = !DIDerivedType(tag: DW_TAG_member, name: "status", scope: !508, file: !464, line: 79, baseType: !463, size: 32, offset: 160)
!556 = !DIDerivedType(tag: DW_TAG_member, name: "unused_0", scope: !508, file: !464, line: 84, baseType: !134, size: 32, offset: 192)
!557 = !DIDerivedType(tag: DW_TAG_member, name: "unused_1", scope: !508, file: !464, line: 85, baseType: !61, size: 32, offset: 224)
!558 = !DIDerivedType(tag: DW_TAG_member, name: "unused_2", scope: !508, file: !464, line: 86, baseType: !61, size: 32, offset: 256)
!559 = !DISubprogram(name: "save_byte_from_array", scope: !261, file: !261, line: 77, type: !560, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!560 = !DISubroutineType(types: !561)
!561 = !{null, !264, !77, !562}
!562 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !563, size: 32)
!563 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "store_byte_from_buffer", file: !261, line: 42, size: 64, elements: !564)
!564 = !{!565, !566}
!565 = !DIDerivedType(tag: DW_TAG_member, name: "index", scope: !563, file: !261, line: 43, baseType: !73, size: 32)
!566 = !DIDerivedType(tag: DW_TAG_member, name: "byte", scope: !563, file: !261, line: 44, baseType: !104, size: 8, offset: 32)
!567 = !DISubprogram(name: "assert_byte_from_buffer_matches", scope: !261, file: !261, line: 68, type: !568, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!568 = !DISubroutineType(types: !569)
!569 = !{null, !264, !570}
!570 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !571, size: 32)
!571 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !563)
!572 = distinct !DICompileUnit(language: DW_LANG_C99, file: !573, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !574, nameTableKind: None)
!573 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/utils.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!574 = !{!61, !249, !575, !103, !457, !578}
!575 = !DISubprogram(name: "nd_uint8_t", scope: !250, file: !250, line: 24, type: !576, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!576 = !DISubroutineType(types: !577)
!577 = !{!106}
!578 = !DISubprogram(name: "nd_uint64_t", scope: !250, file: !250, line: 23, type: !579, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!579 = !DISubroutineType(types: !580)
!580 = !{!191}
!581 = distinct !DICompileUnit(language: DW_LANG_C99, file: !582, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !583, retainedTypes: !594, nameTableKind: None)
!582 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/sea_allocators.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!583 = !{!584}
!584 = !DICompositeType(tag: DW_TAG_enumeration_type, scope: !586, file: !585, line: 25, baseType: !7, size: 32, elements: !592)
!585 = !DIFile(filename: "seahorn/lib/sea_allocators.c", directory: "/Users/jorge/Repos/verify-c-common")
!586 = distinct !DISubprogram(name: "sea_malloc_aligned", scope: !585, file: !585, line: 24, type: !587, scopeLine: 24, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !581, retainedNodes: !589)
!587 = !DISubroutineType(types: !588)
!588 = !{!61, !363}
!589 = !{!590, !591}
!590 = !DILocalVariable(name: "sz", arg: 1, scope: !586, file: !585, line: 24, type: !363)
!591 = !DILocalVariable(name: "alloc_sz", scope: !586, file: !585, line: 26, type: !363)
!592 = !{!593}
!593 = !DIEnumerator(name: "S_ALIGNMENT", value: 8, isUnsigned: true)
!594 = !{!595, !61, !596, !214}
!595 = !DISubprogram(name: "nd_malloc_is_fail", scope: !585, file: !585, line: 9, type: !458, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!596 = !DISubprogram(name: "memhavoc", scope: !585, file: !585, line: 7, type: !116, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!597 = distinct !DICompileUnit(language: DW_LANG_C99, file: !598, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !4, retainedTypes: !599, nameTableKind: None)
!598 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/allocator_override.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!599 = !{!253, !61, !214, !103, !600, !159, !162}
!600 = !DISubprogram(name: "sea_allocator", scope: !254, file: !254, line: 34, type: !601, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!601 = !DISubroutineType(types: !602)
!602 = !{!603}
!603 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !604, size: 32)
!604 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "aws_allocator", file: !63, line: 15, size: 160, elements: !605)
!605 = !{!606, !610, !614, !618, !622}
!606 = !DIDerivedType(tag: DW_TAG_member, name: "mem_acquire", scope: !604, file: !63, line: 16, baseType: !607, size: 32)
!607 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !608, size: 32)
!608 = !DISubroutineType(types: !609)
!609 = !{!61, !603, !73}
!610 = !DIDerivedType(tag: DW_TAG_member, name: "mem_release", scope: !604, file: !63, line: 17, baseType: !611, size: 32, offset: 32)
!611 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !612, size: 32)
!612 = !DISubroutineType(types: !613)
!613 = !{null, !603, !61}
!614 = !DIDerivedType(tag: DW_TAG_member, name: "mem_realloc", scope: !604, file: !63, line: 19, baseType: !615, size: 32, offset: 64)
!615 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !616, size: 32)
!616 = !DISubroutineType(types: !617)
!617 = !{!61, !603, !61, !73, !73}
!618 = !DIDerivedType(tag: DW_TAG_member, name: "mem_calloc", scope: !604, file: !63, line: 21, baseType: !619, size: 32, offset: 96)
!619 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !620, size: 32)
!620 = !DISubroutineType(types: !621)
!621 = !{!61, !603, !73, !73}
!622 = !DIDerivedType(tag: DW_TAG_member, name: "impl", scope: !604, file: !63, line: 22, baseType: !61, size: 32, offset: 128)
!623 = distinct !DICompileUnit(language: DW_LANG_C99, file: !624, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !625, nameTableKind: None)
!624 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/bcmp.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!625 = !{!308, !61}
!626 = distinct !DICompileUnit(language: DW_LANG_C99, file: !627, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, nameTableKind: None)
!627 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/bounds.c", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!628 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus_14, file: !629, producer: "clang version 10.0.1 ", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !91, retainedTypes: !630, imports: !636, nameTableKind: None)
!629 = !DIFile(filename: "/Users/jorge/Repos/verify-c-common/seahorn/lib/sea_string.cc", directory: "/Users/jorge/Repos/verify-c-common/build/seahorn/lib")
!630 = !{!380, !631, !635}
!631 = !DISubprogram(name: "sea_strlen", scope: !632, file: !632, line: 8, type: !633, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!632 = !DIFile(filename: "seahorn/include/sea_string.h", directory: "/Users/jorge/Repos/verify-c-common")
!633 = !DISubroutineType(types: !634)
!634 = !{!77, !127, !77}
!635 = !DISubprogram(name: "nd_size_t", linkageName: "_Z9nd_size_tv", scope: !250, file: !250, line: 20, type: !251, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !91)
!636 = !{!637}
!637 = !DIImportedEntity(tag: DW_TAG_imported_declaration, scope: !628, entity: !638, file: !642, line: 51)
!638 = !DIDerivedType(tag: DW_TAG_typedef, name: "nullptr_t", scope: !640, file: !639, line: 56, baseType: !641)
!639 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/c++/v1/__nullptr", directory: "")
!640 = !DINamespace(name: "std", scope: null)
!641 = !DIBasicType(tag: DW_TAG_unspecified_type, name: "decltype(nullptr)")
!642 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/c++/v1/stddef.h", directory: "")
!643 = !{!"clang version 10.0.1 "}
!644 = !{i32 2, !"SDK Version", [2 x i32] [i32 12, i32 0]}
!645 = !{i32 7, !"Dwarf Version", i32 4}
!646 = !{i32 2, !"Debug Info Version", i32 3}
!647 = !{i32 1, !"wchar_size", i32 4}
!648 = !{i32 1, !"min_enum_size", i32 4}
!649 = !{i32 7, !"PIC Level", i32 2}
!650 = distinct !DISubprogram(name: "aws_byte_buf_init", scope: !195, file: !195, line: 17, type: !651, scopeLine: 17, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !653)
!651 = !DISubroutineType(types: !652)
!652 = !{!134, !112, !66, !73}
!653 = !{!654, !655, !656}
!654 = !DILocalVariable(name: "buf", arg: 1, scope: !650, file: !195, line: 17, type: !112)
!655 = !DILocalVariable(name: "allocator", arg: 2, scope: !650, file: !195, line: 17, type: !66)
!656 = !DILocalVariable(name: "capacity", arg: 3, scope: !650, file: !195, line: 17, type: !73)
!657 = !{!658, !658, i64 0}
!658 = !{!"any pointer", !659, i64 0}
!659 = !{!"omnipotent char", !660, i64 0}
!660 = !{!"Simple C/C++ TBAA"}
!661 = !DILocation(line: 17, column: 44, scope: !650)
!662 = !DILocation(line: 17, column: 71, scope: !650)
!663 = !{!664, !664, i64 0}
!664 = !{!"long", !659, i64 0}
!665 = !DILocation(line: 17, column: 89, scope: !650)
!666 = !DILocation(line: 21, column: 20, scope: !650)
!667 = !DILocation(line: 21, column: 29, scope: !650)
!668 = !DILocation(line: 21, column: 19, scope: !650)
!669 = !DILocation(line: 21, column: 60, scope: !650)
!670 = !DILocation(line: 21, column: 71, scope: !650)
!671 = !DILocation(line: 21, column: 44, scope: !650)
!672 = !DILocation(line: 21, column: 5, scope: !650)
!673 = !DILocation(line: 21, column: 10, scope: !650)
!674 = !DILocation(line: 21, column: 17, scope: !650)
!675 = !{!676, !658, i64 4}
!676 = !{!"aws_byte_buf", !664, i64 0, !658, i64 4, !664, i64 8, !658, i64 12}
!677 = !DILocation(line: 22, column: 9, scope: !678)
!678 = distinct !DILexicalBlock(scope: !650, file: !195, line: 22, column: 9)
!679 = !DILocation(line: 22, column: 18, scope: !678)
!680 = !DILocation(line: 22, column: 23, scope: !678)
!681 = !DILocation(line: 22, column: 26, scope: !678)
!682 = !DILocation(line: 22, column: 31, scope: !678)
!683 = !DILocation(line: 22, column: 38, scope: !678)
!684 = !DILocation(line: 22, column: 9, scope: !650)
!685 = !DILocation(line: 23, column: 9, scope: !686)
!686 = distinct !DILexicalBlock(scope: !678, file: !195, line: 22, column: 47)
!687 = !DILocation(line: 23, column: 9, scope: !688)
!688 = distinct !DILexicalBlock(scope: !686, file: !195, line: 23, column: 9)
!689 = !DILocation(line: 24, column: 9, scope: !686)
!690 = !DILocation(line: 27, column: 5, scope: !650)
!691 = !DILocation(line: 27, column: 10, scope: !650)
!692 = !DILocation(line: 27, column: 14, scope: !650)
!693 = !{!676, !664, i64 0}
!694 = !DILocation(line: 28, column: 21, scope: !650)
!695 = !DILocation(line: 28, column: 5, scope: !650)
!696 = !DILocation(line: 28, column: 10, scope: !650)
!697 = !DILocation(line: 28, column: 19, scope: !650)
!698 = !{!676, !664, i64 8}
!699 = !DILocation(line: 29, column: 22, scope: !650)
!700 = !DILocation(line: 29, column: 5, scope: !650)
!701 = !DILocation(line: 29, column: 10, scope: !650)
!702 = !DILocation(line: 29, column: 20, scope: !650)
!703 = !{!676, !658, i64 12}
!704 = !DILocation(line: 31, column: 5, scope: !650)
!705 = !DILocation(line: 32, column: 1, scope: !650)
!706 = distinct !DISubprogram(name: "aws_byte_buf_init_copy", scope: !195, file: !195, line: 34, type: !707, scopeLine: 34, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !709)
!707 = !DISubroutineType(types: !708)
!708 = !{!134, !112, !66, !97}
!709 = !{!710, !711, !712}
!710 = !DILocalVariable(name: "dest", arg: 1, scope: !706, file: !195, line: 34, type: !112)
!711 = !DILocalVariable(name: "allocator", arg: 2, scope: !706, file: !195, line: 34, type: !66)
!712 = !DILocalVariable(name: "src", arg: 3, scope: !706, file: !195, line: 34, type: !97)
!713 = !DILocation(line: 34, column: 49, scope: !706)
!714 = !DILocation(line: 34, column: 77, scope: !706)
!715 = !DILocation(line: 34, column: 115, scope: !706)
!716 = !DILocation(line: 37, column: 5, scope: !706)
!717 = !DILocation(line: 37, column: 5, scope: !718)
!718 = distinct !DILexicalBlock(scope: !719, file: !195, line: 37, column: 5)
!719 = distinct !DILexicalBlock(scope: !706, file: !195, line: 37, column: 5)
!720 = !DILocation(line: 37, column: 5, scope: !719)
!721 = !DILocation(line: 37, column: 5, scope: !722)
!722 = distinct !DILexicalBlock(scope: !718, file: !195, line: 37, column: 5)
!723 = !DILocation(line: 39, column: 10, scope: !724)
!724 = distinct !DILexicalBlock(scope: !706, file: !195, line: 39, column: 9)
!725 = !DILocation(line: 39, column: 15, scope: !724)
!726 = !DILocation(line: 39, column: 9, scope: !706)
!727 = !DILocation(line: 40, column: 9, scope: !728)
!728 = distinct !DILexicalBlock(scope: !724, file: !195, line: 39, column: 23)
!729 = !DILocation(line: 40, column: 9, scope: !730)
!730 = distinct !DILexicalBlock(scope: !728, file: !195, line: 40, column: 9)
!731 = !DILocation(line: 41, column: 27, scope: !728)
!732 = !DILocation(line: 41, column: 9, scope: !728)
!733 = !DILocation(line: 41, column: 15, scope: !728)
!734 = !DILocation(line: 41, column: 25, scope: !728)
!735 = !DILocation(line: 43, column: 9, scope: !728)
!736 = !DILocation(line: 46, column: 6, scope: !706)
!737 = !DILocation(line: 46, column: 14, scope: !706)
!738 = !DILocation(line: 46, column: 13, scope: !706)
!739 = !{i64 0, i64 4, !663, i64 4, i64 4, !657, i64 8, i64 4, !663, i64 12, i64 4, !657}
!740 = !DILocation(line: 47, column: 23, scope: !706)
!741 = !DILocation(line: 47, column: 5, scope: !706)
!742 = !DILocation(line: 47, column: 11, scope: !706)
!743 = !DILocation(line: 47, column: 21, scope: !706)
!744 = !DILocation(line: 48, column: 47, scope: !706)
!745 = !DILocation(line: 48, column: 58, scope: !706)
!746 = !DILocation(line: 48, column: 63, scope: !706)
!747 = !DILocation(line: 48, column: 31, scope: !706)
!748 = !DILocation(line: 48, column: 5, scope: !706)
!749 = !DILocation(line: 48, column: 11, scope: !706)
!750 = !DILocation(line: 48, column: 18, scope: !706)
!751 = !DILocation(line: 49, column: 9, scope: !752)
!752 = distinct !DILexicalBlock(scope: !706, file: !195, line: 49, column: 9)
!753 = !DILocation(line: 49, column: 15, scope: !752)
!754 = !DILocation(line: 49, column: 22, scope: !752)
!755 = !DILocation(line: 49, column: 9, scope: !706)
!756 = !DILocation(line: 50, column: 9, scope: !757)
!757 = distinct !DILexicalBlock(scope: !752, file: !195, line: 49, column: 31)
!758 = !DILocation(line: 50, column: 9, scope: !759)
!759 = distinct !DILexicalBlock(scope: !757, file: !195, line: 50, column: 9)
!760 = !DILocation(line: 51, column: 9, scope: !757)
!761 = !DILocation(line: 53, column: 5, scope: !706)
!762 = !DILocation(line: 55, column: 5, scope: !706)
!763 = !DILocation(line: 56, column: 1, scope: !706)
!764 = distinct !DISubprogram(name: "aws_byte_buf_is_valid", scope: !195, file: !195, line: 58, type: !765, scopeLine: 58, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !768)
!765 = !DISubroutineType(types: !766)
!766 = !{!96, !767}
!767 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !97)
!768 = !{!769}
!769 = !DILocalVariable(name: "buf", arg: 1, scope: !764, file: !195, line: 58, type: !767)
!770 = !DILocation(line: 58, column: 61, scope: !764)
!771 = !DILocation(line: 59, column: 12, scope: !764)
!772 = !DILocation(line: 59, column: 16, scope: !764)
!773 = !DILocation(line: 59, column: 24, scope: !764)
!774 = !DILocation(line: 60, column: 14, scope: !764)
!775 = !DILocation(line: 60, column: 19, scope: !764)
!776 = !DILocation(line: 60, column: 28, scope: !764)
!777 = !DILocation(line: 60, column: 33, scope: !764)
!778 = !DILocation(line: 60, column: 36, scope: !764)
!779 = !DILocation(line: 60, column: 41, scope: !764)
!780 = !DILocation(line: 60, column: 45, scope: !764)
!781 = !DILocation(line: 60, column: 50, scope: !764)
!782 = !DILocation(line: 60, column: 53, scope: !764)
!783 = !DILocation(line: 60, column: 58, scope: !764)
!784 = !DILocation(line: 60, column: 65, scope: !764)
!785 = !DILocation(line: 60, column: 74, scope: !764)
!786 = !DILocation(line: 61, column: 14, scope: !764)
!787 = !DILocation(line: 61, column: 19, scope: !764)
!788 = !DILocation(line: 61, column: 28, scope: !764)
!789 = !DILocation(line: 61, column: 32, scope: !764)
!790 = !DILocation(line: 61, column: 35, scope: !764)
!791 = !DILocation(line: 61, column: 40, scope: !764)
!792 = !DILocation(line: 61, column: 47, scope: !764)
!793 = !DILocation(line: 61, column: 52, scope: !764)
!794 = !DILocation(line: 61, column: 44, scope: !764)
!795 = !DILocation(line: 61, column: 61, scope: !764)
!796 = !DILocation(line: 61, column: 64, scope: !764)
!797 = !DILocation(line: 0, scope: !764)
!798 = !DILocation(line: 59, column: 5, scope: !764)
!799 = distinct !DISubprogram(name: "aws_raise_error", scope: !800, file: !800, line: 17, type: !801, scopeLine: 17, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !803)
!800 = !DIFile(filename: "aws-c-common/include/aws/common/error.inl", directory: "/Users/jorge/Repos/verify-c-common")
!801 = !DISubroutineType(types: !802)
!802 = !{!134, !134}
!803 = !{!804}
!804 = !DILocalVariable(name: "err", arg: 1, scope: !799, file: !800, line: 17, type: !134)
!805 = !{!806, !806, i64 0}
!806 = !{!"int", !659, i64 0}
!807 = !DILocation(line: 17, column: 25, scope: !799)
!808 = !DILocation(line: 24, column: 29, scope: !799)
!809 = !DILocation(line: 24, column: 5, scope: !799)
!810 = !DILocation(line: 26, column: 5, scope: !799)
!811 = distinct !DISubprogram(name: "aws_byte_cursor_is_valid", scope: !195, file: !195, line: 64, type: !812, scopeLine: 64, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !814)
!812 = !DISubroutineType(types: !813)
!813 = !{!96, !149}
!814 = !{!815}
!815 = !DILocalVariable(name: "cursor", arg: 1, scope: !811, file: !195, line: 64, type: !149)
!816 = !DILocation(line: 64, column: 61, scope: !811)
!817 = !DILocation(line: 65, column: 12, scope: !811)
!818 = !DILocation(line: 65, column: 19, scope: !811)
!819 = !DILocation(line: 65, column: 27, scope: !811)
!820 = !DILocation(line: 66, column: 14, scope: !811)
!821 = !DILocation(line: 66, column: 22, scope: !811)
!822 = !{!823, !664, i64 0}
!823 = !{!"aws_byte_cursor", !664, i64 0, !658, i64 4}
!824 = !DILocation(line: 66, column: 26, scope: !811)
!825 = !DILocation(line: 66, column: 32, scope: !811)
!826 = !DILocation(line: 66, column: 36, scope: !811)
!827 = !DILocation(line: 66, column: 44, scope: !811)
!828 = !DILocation(line: 66, column: 48, scope: !811)
!829 = !DILocation(line: 66, column: 52, scope: !811)
!830 = !DILocation(line: 66, column: 55, scope: !811)
!831 = !DILocation(line: 66, column: 63, scope: !811)
!832 = !{!823, !658, i64 4}
!833 = !DILocation(line: 66, column: 67, scope: !811)
!834 = !DILocation(line: 66, column: 70, scope: !811)
!835 = !DILocation(line: 0, scope: !811)
!836 = !DILocation(line: 65, column: 5, scope: !811)
!837 = distinct !DISubprogram(name: "aws_byte_buf_reset", scope: !195, file: !195, line: 69, type: !838, scopeLine: 69, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !840)
!838 = !DISubroutineType(types: !839)
!839 = !{null, !112, !96}
!840 = !{!841, !842}
!841 = !DILocalVariable(name: "buf", arg: 1, scope: !837, file: !195, line: 69, type: !112)
!842 = !DILocalVariable(name: "zero_contents", arg: 2, scope: !837, file: !195, line: 69, type: !96)
!843 = !DILocation(line: 69, column: 46, scope: !837)
!844 = !{!845, !845, i64 0}
!845 = !{!"_Bool", !659, i64 0}
!846 = !DILocation(line: 69, column: 56, scope: !837)
!847 = !DILocation(line: 70, column: 9, scope: !848)
!848 = distinct !DILexicalBlock(scope: !837, file: !195, line: 70, column: 9)
!849 = !{i8 0, i8 2}
!850 = !DILocation(line: 70, column: 9, scope: !837)
!851 = !DILocation(line: 71, column: 34, scope: !852)
!852 = distinct !DILexicalBlock(scope: !848, file: !195, line: 70, column: 24)
!853 = !DILocation(line: 71, column: 9, scope: !852)
!854 = !DILocation(line: 72, column: 5, scope: !852)
!855 = !DILocation(line: 73, column: 5, scope: !837)
!856 = !DILocation(line: 73, column: 10, scope: !837)
!857 = !DILocation(line: 73, column: 14, scope: !837)
!858 = !DILocation(line: 74, column: 1, scope: !837)
!859 = distinct !DISubprogram(name: "aws_byte_buf_secure_zero", scope: !195, file: !195, line: 87, type: !110, scopeLine: 87, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !860)
!860 = !{!861}
!861 = !DILocalVariable(name: "buf", arg: 1, scope: !859, file: !195, line: 87, type: !112)
!862 = !DILocation(line: 87, column: 52, scope: !859)
!863 = !DILocation(line: 89, column: 9, scope: !864)
!864 = distinct !DILexicalBlock(scope: !859, file: !195, line: 89, column: 9)
!865 = !DILocation(line: 89, column: 14, scope: !864)
!866 = !DILocation(line: 89, column: 9, scope: !859)
!867 = !DILocation(line: 90, column: 25, scope: !868)
!868 = distinct !DILexicalBlock(scope: !864, file: !195, line: 89, column: 22)
!869 = !DILocation(line: 90, column: 30, scope: !868)
!870 = !DILocation(line: 90, column: 38, scope: !868)
!871 = !DILocation(line: 90, column: 43, scope: !868)
!872 = !DILocation(line: 90, column: 9, scope: !868)
!873 = !DILocation(line: 91, column: 5, scope: !868)
!874 = !DILocation(line: 92, column: 5, scope: !859)
!875 = !DILocation(line: 92, column: 10, scope: !859)
!876 = !DILocation(line: 92, column: 14, scope: !859)
!877 = !DILocation(line: 94, column: 1, scope: !859)
!878 = distinct !DISubprogram(name: "aws_byte_buf_clean_up", scope: !195, file: !195, line: 76, type: !110, scopeLine: 76, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !879)
!879 = !{!880}
!880 = !DILocalVariable(name: "buf", arg: 1, scope: !878, file: !195, line: 76, type: !112)
!881 = !DILocation(line: 76, column: 49, scope: !878)
!882 = !DILocation(line: 78, column: 9, scope: !883)
!883 = distinct !DILexicalBlock(scope: !878, file: !195, line: 78, column: 9)
!884 = !DILocation(line: 78, column: 14, scope: !883)
!885 = !DILocation(line: 78, column: 24, scope: !883)
!886 = !DILocation(line: 78, column: 27, scope: !883)
!887 = !DILocation(line: 78, column: 32, scope: !883)
!888 = !DILocation(line: 78, column: 9, scope: !878)
!889 = !DILocation(line: 79, column: 25, scope: !890)
!890 = distinct !DILexicalBlock(scope: !883, file: !195, line: 78, column: 40)
!891 = !DILocation(line: 79, column: 30, scope: !890)
!892 = !DILocation(line: 79, column: 49, scope: !890)
!893 = !DILocation(line: 79, column: 54, scope: !890)
!894 = !DILocation(line: 79, column: 9, scope: !890)
!895 = !DILocation(line: 80, column: 5, scope: !890)
!896 = !DILocation(line: 81, column: 5, scope: !878)
!897 = !DILocation(line: 81, column: 10, scope: !878)
!898 = !DILocation(line: 81, column: 20, scope: !878)
!899 = !DILocation(line: 82, column: 5, scope: !878)
!900 = !DILocation(line: 82, column: 10, scope: !878)
!901 = !DILocation(line: 82, column: 17, scope: !878)
!902 = !DILocation(line: 83, column: 5, scope: !878)
!903 = !DILocation(line: 83, column: 10, scope: !878)
!904 = !DILocation(line: 83, column: 14, scope: !878)
!905 = !DILocation(line: 84, column: 5, scope: !878)
!906 = !DILocation(line: 84, column: 10, scope: !878)
!907 = !DILocation(line: 84, column: 19, scope: !878)
!908 = !DILocation(line: 85, column: 1, scope: !878)
!909 = distinct !DISubprogram(name: "aws_byte_buf_clean_up_secure", scope: !195, file: !195, line: 96, type: !110, scopeLine: 96, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !910)
!910 = !{!911}
!911 = !DILocalVariable(name: "buf", arg: 1, scope: !909, file: !195, line: 96, type: !112)
!912 = !DILocation(line: 96, column: 56, scope: !909)
!913 = !DILocation(line: 98, column: 30, scope: !909)
!914 = !DILocation(line: 98, column: 5, scope: !909)
!915 = !DILocation(line: 99, column: 27, scope: !909)
!916 = !DILocation(line: 99, column: 5, scope: !909)
!917 = !DILocation(line: 101, column: 1, scope: !909)
!918 = distinct !DISubprogram(name: "aws_byte_buf_eq", scope: !195, file: !195, line: 103, type: !919, scopeLine: 103, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !921)
!919 = !DISubroutineType(types: !920)
!920 = !{!96, !767, !767}
!921 = !{!922, !923, !924}
!922 = !DILocalVariable(name: "a", arg: 1, scope: !918, file: !195, line: 103, type: !767)
!923 = !DILocalVariable(name: "b", arg: 2, scope: !918, file: !195, line: 103, type: !767)
!924 = !DILocalVariable(name: "rval", scope: !918, file: !195, line: 106, type: !96)
!925 = !DILocation(line: 103, column: 55, scope: !918)
!926 = !DILocation(line: 103, column: 91, scope: !918)
!927 = !DILocation(line: 106, column: 5, scope: !918)
!928 = !DILocation(line: 106, column: 10, scope: !918)
!929 = !DILocation(line: 106, column: 30, scope: !918)
!930 = !DILocation(line: 106, column: 33, scope: !918)
!931 = !DILocation(line: 106, column: 41, scope: !918)
!932 = !DILocation(line: 106, column: 44, scope: !918)
!933 = !DILocation(line: 106, column: 49, scope: !918)
!934 = !DILocation(line: 106, column: 52, scope: !918)
!935 = !DILocation(line: 106, column: 60, scope: !918)
!936 = !DILocation(line: 106, column: 63, scope: !918)
!937 = !DILocation(line: 106, column: 17, scope: !918)
!938 = !DILocation(line: 109, column: 12, scope: !918)
!939 = !DILocation(line: 110, column: 1, scope: !918)
!940 = !DILocation(line: 109, column: 5, scope: !918)
!941 = distinct !DISubprogram(name: "aws_array_eq", scope: !195, file: !195, line: 419, type: !942, scopeLine: 419, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !946)
!942 = !DISubroutineType(types: !943)
!943 = !{!96, !944, !945, !944, !945}
!944 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !121)
!945 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !73)
!946 = !{!947, !948, !949, !950}
!947 = !DILocalVariable(name: "array_a", arg: 1, scope: !941, file: !195, line: 419, type: !944)
!948 = !DILocalVariable(name: "len_a", arg: 2, scope: !941, file: !195, line: 419, type: !945)
!949 = !DILocalVariable(name: "array_b", arg: 3, scope: !941, file: !195, line: 419, type: !944)
!950 = !DILocalVariable(name: "len_b", arg: 4, scope: !941, file: !195, line: 419, type: !945)
!951 = !DILocation(line: 419, column: 37, scope: !941)
!952 = !DILocation(line: 419, column: 59, scope: !941)
!953 = !DILocation(line: 419, column: 84, scope: !941)
!954 = !DILocation(line: 419, column: 106, scope: !941)
!955 = !DILocation(line: 425, column: 9, scope: !956)
!956 = distinct !DILexicalBlock(scope: !941, file: !195, line: 425, column: 9)
!957 = !DILocation(line: 425, column: 18, scope: !956)
!958 = !DILocation(line: 425, column: 15, scope: !956)
!959 = !DILocation(line: 425, column: 9, scope: !941)
!960 = !DILocation(line: 426, column: 9, scope: !961)
!961 = distinct !DILexicalBlock(scope: !956, file: !195, line: 425, column: 25)
!962 = !DILocation(line: 429, column: 9, scope: !963)
!963 = distinct !DILexicalBlock(scope: !941, file: !195, line: 429, column: 9)
!964 = !DILocation(line: 429, column: 15, scope: !963)
!965 = !DILocation(line: 429, column: 9, scope: !941)
!966 = !DILocation(line: 430, column: 9, scope: !967)
!967 = distinct !DILexicalBlock(scope: !963, file: !195, line: 429, column: 21)
!968 = !DILocation(line: 433, column: 20, scope: !941)
!969 = !DILocation(line: 433, column: 29, scope: !941)
!970 = !DILocation(line: 433, column: 38, scope: !941)
!971 = !DILocation(line: 433, column: 13, scope: !941)
!972 = !DILocation(line: 433, column: 12, scope: !941)
!973 = !DILocation(line: 433, column: 5, scope: !941)
!974 = !DILocation(line: 434, column: 1, scope: !941)
!975 = distinct !DISubprogram(name: "aws_byte_buf_eq_ignore_case", scope: !195, file: !195, line: 112, type: !919, scopeLine: 112, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !976)
!976 = !{!977, !978, !979}
!977 = !DILocalVariable(name: "a", arg: 1, scope: !975, file: !195, line: 112, type: !767)
!978 = !DILocalVariable(name: "b", arg: 2, scope: !975, file: !195, line: 112, type: !767)
!979 = !DILocalVariable(name: "rval", scope: !975, file: !195, line: 115, type: !96)
!980 = !DILocation(line: 112, column: 67, scope: !975)
!981 = !DILocation(line: 112, column: 103, scope: !975)
!982 = !DILocation(line: 115, column: 5, scope: !975)
!983 = !DILocation(line: 115, column: 10, scope: !975)
!984 = !DILocation(line: 115, column: 42, scope: !975)
!985 = !DILocation(line: 115, column: 45, scope: !975)
!986 = !DILocation(line: 115, column: 53, scope: !975)
!987 = !DILocation(line: 115, column: 56, scope: !975)
!988 = !DILocation(line: 115, column: 61, scope: !975)
!989 = !DILocation(line: 115, column: 64, scope: !975)
!990 = !DILocation(line: 115, column: 72, scope: !975)
!991 = !DILocation(line: 115, column: 75, scope: !975)
!992 = !DILocation(line: 115, column: 17, scope: !975)
!993 = !DILocation(line: 118, column: 12, scope: !975)
!994 = !DILocation(line: 119, column: 1, scope: !975)
!995 = !DILocation(line: 118, column: 5, scope: !975)
!996 = distinct !DISubprogram(name: "aws_array_eq_ignore_case", scope: !195, file: !195, line: 394, type: !942, scopeLine: 398, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !997)
!997 = !{!998, !999, !1000, !1001, !1002, !1003, !1004}
!998 = !DILocalVariable(name: "array_a", arg: 1, scope: !996, file: !195, line: 395, type: !944)
!999 = !DILocalVariable(name: "len_a", arg: 2, scope: !996, file: !195, line: 396, type: !945)
!1000 = !DILocalVariable(name: "array_b", arg: 3, scope: !996, file: !195, line: 397, type: !944)
!1001 = !DILocalVariable(name: "len_b", arg: 4, scope: !996, file: !195, line: 398, type: !945)
!1002 = !DILocalVariable(name: "bytes_a", scope: !996, file: !195, line: 408, type: !151)
!1003 = !DILocalVariable(name: "bytes_b", scope: !996, file: !195, line: 409, type: !151)
!1004 = !DILocalVariable(name: "i", scope: !1005, file: !195, line: 410, type: !73)
!1005 = distinct !DILexicalBlock(scope: !996, file: !195, line: 410, column: 5)
!1006 = !DILocation(line: 395, column: 23, scope: !996)
!1007 = !DILocation(line: 396, column: 18, scope: !996)
!1008 = !DILocation(line: 397, column: 23, scope: !996)
!1009 = !DILocation(line: 398, column: 18, scope: !996)
!1010 = !DILocation(line: 404, column: 9, scope: !1011)
!1011 = distinct !DILexicalBlock(scope: !996, file: !195, line: 404, column: 9)
!1012 = !DILocation(line: 404, column: 18, scope: !1011)
!1013 = !DILocation(line: 404, column: 15, scope: !1011)
!1014 = !DILocation(line: 404, column: 9, scope: !996)
!1015 = !DILocation(line: 405, column: 9, scope: !1016)
!1016 = distinct !DILexicalBlock(scope: !1011, file: !195, line: 404, column: 25)
!1017 = !DILocation(line: 408, column: 5, scope: !996)
!1018 = !DILocation(line: 408, column: 20, scope: !996)
!1019 = !DILocation(line: 408, column: 30, scope: !996)
!1020 = !DILocation(line: 409, column: 5, scope: !996)
!1021 = !DILocation(line: 409, column: 20, scope: !996)
!1022 = !DILocation(line: 409, column: 30, scope: !996)
!1023 = !DILocation(line: 410, column: 10, scope: !1005)
!1024 = !DILocation(line: 410, column: 17, scope: !1005)
!1025 = !DILocation(line: 410, column: 24, scope: !1026)
!1026 = distinct !DILexicalBlock(scope: !1005, file: !195, line: 410, column: 5)
!1027 = !DILocation(line: 410, column: 28, scope: !1026)
!1028 = !DILocation(line: 410, column: 26, scope: !1026)
!1029 = !DILocation(line: 410, column: 5, scope: !1005)
!1030 = !DILocation(line: 411, column: 29, scope: !1031)
!1031 = distinct !DILexicalBlock(scope: !1032, file: !195, line: 411, column: 13)
!1032 = distinct !DILexicalBlock(scope: !1026, file: !195, line: 410, column: 40)
!1033 = !DILocation(line: 411, column: 37, scope: !1031)
!1034 = !{!659, !659, i64 0}
!1035 = !DILocation(line: 411, column: 13, scope: !1031)
!1036 = !DILocation(line: 411, column: 60, scope: !1031)
!1037 = !DILocation(line: 411, column: 68, scope: !1031)
!1038 = !DILocation(line: 411, column: 44, scope: !1031)
!1039 = !DILocation(line: 411, column: 41, scope: !1031)
!1040 = !DILocation(line: 411, column: 13, scope: !1032)
!1041 = !DILocation(line: 412, column: 13, scope: !1042)
!1042 = distinct !DILexicalBlock(scope: !1031, file: !195, line: 411, column: 73)
!1043 = !DILocation(line: 414, column: 5, scope: !1032)
!1044 = !DILocation(line: 410, column: 35, scope: !1026)
!1045 = !DILocation(line: 410, column: 5, scope: !1026)
!1046 = distinct !{!1046, !1029, !1047}
!1047 = !DILocation(line: 414, column: 5, scope: !1005)
!1048 = !DILocation(line: 416, column: 5, scope: !996)
!1049 = !DILocation(line: 417, column: 1, scope: !996)
!1050 = distinct !DISubprogram(name: "aws_byte_buf_eq_c_str", scope: !195, file: !195, line: 121, type: !1051, scopeLine: 121, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1054)
!1051 = !DISubroutineType(types: !1052)
!1052 = !{!96, !767, !1053}
!1053 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !127)
!1054 = !{!1055, !1056, !1057}
!1055 = !DILocalVariable(name: "buf", arg: 1, scope: !1050, file: !195, line: 121, type: !767)
!1056 = !DILocalVariable(name: "c_str", arg: 2, scope: !1050, file: !195, line: 121, type: !1053)
!1057 = !DILocalVariable(name: "rval", scope: !1050, file: !195, line: 124, type: !96)
!1058 = !DILocation(line: 121, column: 61, scope: !1050)
!1059 = !DILocation(line: 121, column: 84, scope: !1050)
!1060 = !DILocation(line: 124, column: 5, scope: !1050)
!1061 = !DILocation(line: 124, column: 10, scope: !1050)
!1062 = !DILocation(line: 124, column: 36, scope: !1050)
!1063 = !DILocation(line: 124, column: 41, scope: !1050)
!1064 = !DILocation(line: 124, column: 49, scope: !1050)
!1065 = !DILocation(line: 124, column: 54, scope: !1050)
!1066 = !DILocation(line: 124, column: 59, scope: !1050)
!1067 = !DILocation(line: 124, column: 17, scope: !1050)
!1068 = !DILocation(line: 126, column: 12, scope: !1050)
!1069 = !DILocation(line: 127, column: 1, scope: !1050)
!1070 = !DILocation(line: 126, column: 5, scope: !1050)
!1071 = distinct !DISubprogram(name: "aws_array_eq_c_str", scope: !195, file: !195, line: 464, type: !1072, scopeLine: 464, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1074)
!1072 = !DISubroutineType(types: !1073)
!1073 = !{!96, !944, !945, !1053}
!1074 = !{!1075, !1076, !1077, !1078, !1079, !1080, !1082}
!1075 = !DILocalVariable(name: "array", arg: 1, scope: !1071, file: !195, line: 464, type: !944)
!1076 = !DILocalVariable(name: "array_len", arg: 2, scope: !1071, file: !195, line: 464, type: !945)
!1077 = !DILocalVariable(name: "c_str", arg: 3, scope: !1071, file: !195, line: 464, type: !1053)
!1078 = !DILocalVariable(name: "array_bytes", scope: !1071, file: !195, line: 475, type: !151)
!1079 = !DILocalVariable(name: "str_bytes", scope: !1071, file: !195, line: 476, type: !151)
!1080 = !DILocalVariable(name: "i", scope: !1081, file: !195, line: 478, type: !73)
!1081 = distinct !DILexicalBlock(scope: !1071, file: !195, line: 478, column: 5)
!1082 = !DILocalVariable(name: "s", scope: !1083, file: !195, line: 479, type: !104)
!1083 = distinct !DILexicalBlock(scope: !1084, file: !195, line: 478, column: 44)
!1084 = distinct !DILexicalBlock(scope: !1081, file: !195, line: 478, column: 5)
!1085 = !DILocation(line: 464, column: 43, scope: !1071)
!1086 = !DILocation(line: 464, column: 63, scope: !1071)
!1087 = !DILocation(line: 464, column: 92, scope: !1071)
!1088 = !DILocation(line: 475, column: 5, scope: !1071)
!1089 = !DILocation(line: 475, column: 20, scope: !1071)
!1090 = !DILocation(line: 475, column: 34, scope: !1071)
!1091 = !DILocation(line: 476, column: 5, scope: !1071)
!1092 = !DILocation(line: 476, column: 20, scope: !1071)
!1093 = !DILocation(line: 476, column: 49, scope: !1071)
!1094 = !DILocation(line: 478, column: 10, scope: !1081)
!1095 = !DILocation(line: 478, column: 17, scope: !1081)
!1096 = !DILocation(line: 478, column: 24, scope: !1084)
!1097 = !DILocation(line: 478, column: 28, scope: !1084)
!1098 = !DILocation(line: 478, column: 26, scope: !1084)
!1099 = !DILocation(line: 478, column: 5, scope: !1081)
!1100 = !DILocation(line: 479, column: 9, scope: !1083)
!1101 = !DILocation(line: 479, column: 17, scope: !1083)
!1102 = !DILocation(line: 479, column: 21, scope: !1083)
!1103 = !DILocation(line: 479, column: 31, scope: !1083)
!1104 = !DILocation(line: 480, column: 13, scope: !1105)
!1105 = distinct !DILexicalBlock(scope: !1083, file: !195, line: 480, column: 13)
!1106 = !DILocation(line: 480, column: 15, scope: !1105)
!1107 = !DILocation(line: 480, column: 13, scope: !1083)
!1108 = !DILocation(line: 481, column: 13, scope: !1109)
!1109 = distinct !DILexicalBlock(scope: !1105, file: !195, line: 480, column: 24)
!1110 = !DILocation(line: 484, column: 13, scope: !1111)
!1111 = distinct !DILexicalBlock(scope: !1083, file: !195, line: 484, column: 13)
!1112 = !DILocation(line: 484, column: 25, scope: !1111)
!1113 = !DILocation(line: 484, column: 31, scope: !1111)
!1114 = !DILocation(line: 484, column: 28, scope: !1111)
!1115 = !DILocation(line: 484, column: 13, scope: !1083)
!1116 = !DILocation(line: 485, column: 13, scope: !1117)
!1117 = distinct !DILexicalBlock(scope: !1111, file: !195, line: 484, column: 34)
!1118 = !DILocation(line: 487, column: 5, scope: !1084)
!1119 = !DILocation(line: 487, column: 5, scope: !1083)
!1120 = !DILocation(line: 478, column: 39, scope: !1084)
!1121 = !DILocation(line: 478, column: 5, scope: !1084)
!1122 = distinct !{!1122, !1099, !1123}
!1123 = !DILocation(line: 487, column: 5, scope: !1081)
!1124 = !DILocation(line: 489, column: 12, scope: !1071)
!1125 = !DILocation(line: 489, column: 22, scope: !1071)
!1126 = !DILocation(line: 489, column: 33, scope: !1071)
!1127 = !DILocation(line: 489, column: 5, scope: !1071)
!1128 = !DILocation(line: 490, column: 1, scope: !1071)
!1129 = distinct !DISubprogram(name: "aws_byte_buf_eq_c_str_ignore_case", scope: !195, file: !195, line: 129, type: !1051, scopeLine: 129, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1130)
!1130 = !{!1131, !1132, !1133}
!1131 = !DILocalVariable(name: "buf", arg: 1, scope: !1129, file: !195, line: 129, type: !767)
!1132 = !DILocalVariable(name: "c_str", arg: 2, scope: !1129, file: !195, line: 129, type: !1053)
!1133 = !DILocalVariable(name: "rval", scope: !1129, file: !195, line: 132, type: !96)
!1134 = !DILocation(line: 129, column: 73, scope: !1129)
!1135 = !DILocation(line: 129, column: 96, scope: !1129)
!1136 = !DILocation(line: 132, column: 5, scope: !1129)
!1137 = !DILocation(line: 132, column: 10, scope: !1129)
!1138 = !DILocation(line: 132, column: 48, scope: !1129)
!1139 = !DILocation(line: 132, column: 53, scope: !1129)
!1140 = !DILocation(line: 132, column: 61, scope: !1129)
!1141 = !DILocation(line: 132, column: 66, scope: !1129)
!1142 = !DILocation(line: 132, column: 71, scope: !1129)
!1143 = !DILocation(line: 132, column: 17, scope: !1129)
!1144 = !DILocation(line: 134, column: 12, scope: !1129)
!1145 = !DILocation(line: 135, column: 1, scope: !1129)
!1146 = !DILocation(line: 134, column: 5, scope: !1129)
!1147 = distinct !DISubprogram(name: "aws_array_eq_c_str_ignore_case", scope: !195, file: !195, line: 436, type: !1072, scopeLine: 436, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1148)
!1148 = !{!1149, !1150, !1151, !1152, !1153, !1154, !1156}
!1149 = !DILocalVariable(name: "array", arg: 1, scope: !1147, file: !195, line: 436, type: !944)
!1150 = !DILocalVariable(name: "array_len", arg: 2, scope: !1147, file: !195, line: 436, type: !945)
!1151 = !DILocalVariable(name: "c_str", arg: 3, scope: !1147, file: !195, line: 436, type: !1053)
!1152 = !DILocalVariable(name: "array_bytes", scope: !1147, file: !195, line: 447, type: !151)
!1153 = !DILocalVariable(name: "str_bytes", scope: !1147, file: !195, line: 448, type: !151)
!1154 = !DILocalVariable(name: "i", scope: !1155, file: !195, line: 450, type: !73)
!1155 = distinct !DILexicalBlock(scope: !1147, file: !195, line: 450, column: 5)
!1156 = !DILocalVariable(name: "s", scope: !1157, file: !195, line: 451, type: !104)
!1157 = distinct !DILexicalBlock(scope: !1158, file: !195, line: 450, column: 44)
!1158 = distinct !DILexicalBlock(scope: !1155, file: !195, line: 450, column: 5)
!1159 = !DILocation(line: 436, column: 55, scope: !1147)
!1160 = !DILocation(line: 436, column: 75, scope: !1147)
!1161 = !DILocation(line: 436, column: 104, scope: !1147)
!1162 = !DILocation(line: 447, column: 5, scope: !1147)
!1163 = !DILocation(line: 447, column: 20, scope: !1147)
!1164 = !DILocation(line: 447, column: 34, scope: !1147)
!1165 = !DILocation(line: 448, column: 5, scope: !1147)
!1166 = !DILocation(line: 448, column: 20, scope: !1147)
!1167 = !DILocation(line: 448, column: 49, scope: !1147)
!1168 = !DILocation(line: 450, column: 10, scope: !1155)
!1169 = !DILocation(line: 450, column: 17, scope: !1155)
!1170 = !DILocation(line: 450, column: 24, scope: !1158)
!1171 = !DILocation(line: 450, column: 28, scope: !1158)
!1172 = !DILocation(line: 450, column: 26, scope: !1158)
!1173 = !DILocation(line: 450, column: 5, scope: !1155)
!1174 = !DILocation(line: 451, column: 9, scope: !1157)
!1175 = !DILocation(line: 451, column: 17, scope: !1157)
!1176 = !DILocation(line: 451, column: 21, scope: !1157)
!1177 = !DILocation(line: 451, column: 31, scope: !1157)
!1178 = !DILocation(line: 452, column: 13, scope: !1179)
!1179 = distinct !DILexicalBlock(scope: !1157, file: !195, line: 452, column: 13)
!1180 = !DILocation(line: 452, column: 15, scope: !1179)
!1181 = !DILocation(line: 452, column: 13, scope: !1157)
!1182 = !DILocation(line: 453, column: 13, scope: !1183)
!1183 = distinct !DILexicalBlock(scope: !1179, file: !195, line: 452, column: 24)
!1184 = !DILocation(line: 456, column: 29, scope: !1185)
!1185 = distinct !DILexicalBlock(scope: !1157, file: !195, line: 456, column: 13)
!1186 = !DILocation(line: 456, column: 41, scope: !1185)
!1187 = !DILocation(line: 456, column: 13, scope: !1185)
!1188 = !DILocation(line: 456, column: 64, scope: !1185)
!1189 = !DILocation(line: 456, column: 48, scope: !1185)
!1190 = !DILocation(line: 456, column: 45, scope: !1185)
!1191 = !DILocation(line: 456, column: 13, scope: !1157)
!1192 = !DILocation(line: 457, column: 13, scope: !1193)
!1193 = distinct !DILexicalBlock(scope: !1185, file: !195, line: 456, column: 68)
!1194 = !DILocation(line: 459, column: 5, scope: !1158)
!1195 = !DILocation(line: 459, column: 5, scope: !1157)
!1196 = !DILocation(line: 450, column: 39, scope: !1158)
!1197 = !DILocation(line: 450, column: 5, scope: !1158)
!1198 = distinct !{!1198, !1173, !1199}
!1199 = !DILocation(line: 459, column: 5, scope: !1155)
!1200 = !DILocation(line: 461, column: 12, scope: !1147)
!1201 = !DILocation(line: 461, column: 22, scope: !1147)
!1202 = !DILocation(line: 461, column: 33, scope: !1147)
!1203 = !DILocation(line: 461, column: 5, scope: !1147)
!1204 = !DILocation(line: 462, column: 1, scope: !1147)
!1205 = distinct !DISubprogram(name: "aws_byte_buf_init_copy_from_cursor", scope: !195, file: !195, line: 137, type: !1206, scopeLine: 140, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1208)
!1206 = !DISubroutineType(types: !1207)
!1207 = !{!134, !112, !66, !136}
!1208 = !{!1209, !1210, !1211}
!1209 = !DILocalVariable(name: "dest", arg: 1, scope: !1205, file: !195, line: 138, type: !112)
!1210 = !DILocalVariable(name: "allocator", arg: 2, scope: !1205, file: !195, line: 139, type: !66)
!1211 = !DILocalVariable(name: "src", arg: 3, scope: !1205, file: !195, line: 140, type: !136)
!1212 = !DILocation(line: 138, column: 26, scope: !1205)
!1213 = !DILocation(line: 139, column: 27, scope: !1205)
!1214 = !DILocation(line: 140, column: 28, scope: !1205)
!1215 = !DILocation(line: 143, column: 5, scope: !1205)
!1216 = !DILocation(line: 143, column: 5, scope: !1217)
!1217 = distinct !DILexicalBlock(scope: !1218, file: !195, line: 143, column: 5)
!1218 = distinct !DILexicalBlock(scope: !1205, file: !195, line: 143, column: 5)
!1219 = !DILocation(line: 143, column: 5, scope: !1218)
!1220 = !DILocation(line: 143, column: 5, scope: !1221)
!1221 = distinct !DILexicalBlock(scope: !1217, file: !195, line: 143, column: 5)
!1222 = !DILocation(line: 145, column: 5, scope: !1205)
!1223 = !DILocation(line: 145, column: 5, scope: !1224)
!1224 = distinct !DILexicalBlock(scope: !1205, file: !195, line: 145, column: 5)
!1225 = !DILocation(line: 147, column: 25, scope: !1205)
!1226 = !DILocation(line: 147, column: 29, scope: !1205)
!1227 = !DILocation(line: 147, column: 20, scope: !1205)
!1228 = !DILocation(line: 147, column: 63, scope: !1205)
!1229 = !DILocation(line: 147, column: 78, scope: !1205)
!1230 = !DILocation(line: 147, column: 47, scope: !1205)
!1231 = !DILocation(line: 147, column: 5, scope: !1205)
!1232 = !DILocation(line: 147, column: 11, scope: !1205)
!1233 = !DILocation(line: 147, column: 18, scope: !1205)
!1234 = !DILocation(line: 148, column: 13, scope: !1235)
!1235 = distinct !DILexicalBlock(scope: !1205, file: !195, line: 148, column: 9)
!1236 = !DILocation(line: 148, column: 17, scope: !1235)
!1237 = !DILocation(line: 148, column: 22, scope: !1235)
!1238 = !DILocation(line: 148, column: 25, scope: !1235)
!1239 = !DILocation(line: 148, column: 31, scope: !1235)
!1240 = !DILocation(line: 148, column: 38, scope: !1235)
!1241 = !DILocation(line: 148, column: 9, scope: !1205)
!1242 = !DILocation(line: 149, column: 9, scope: !1243)
!1243 = distinct !DILexicalBlock(scope: !1235, file: !195, line: 148, column: 47)
!1244 = !DILocation(line: 152, column: 21, scope: !1205)
!1245 = !DILocation(line: 152, column: 5, scope: !1205)
!1246 = !DILocation(line: 152, column: 11, scope: !1205)
!1247 = !DILocation(line: 152, column: 15, scope: !1205)
!1248 = !DILocation(line: 153, column: 26, scope: !1205)
!1249 = !DILocation(line: 153, column: 5, scope: !1205)
!1250 = !DILocation(line: 153, column: 11, scope: !1205)
!1251 = !DILocation(line: 153, column: 20, scope: !1205)
!1252 = !DILocation(line: 154, column: 23, scope: !1205)
!1253 = !DILocation(line: 154, column: 5, scope: !1205)
!1254 = !DILocation(line: 154, column: 11, scope: !1205)
!1255 = !DILocation(line: 154, column: 21, scope: !1205)
!1256 = !DILocation(line: 155, column: 13, scope: !1257)
!1257 = distinct !DILexicalBlock(scope: !1205, file: !195, line: 155, column: 9)
!1258 = !DILocation(line: 155, column: 17, scope: !1257)
!1259 = !DILocation(line: 155, column: 9, scope: !1205)
!1260 = !DILocation(line: 156, column: 9, scope: !1261)
!1261 = distinct !DILexicalBlock(scope: !1257, file: !195, line: 155, column: 22)
!1262 = !DILocation(line: 157, column: 5, scope: !1261)
!1263 = !DILocation(line: 159, column: 5, scope: !1205)
!1264 = !DILocation(line: 160, column: 1, scope: !1205)
!1265 = distinct !DISubprogram(name: "aws_byte_buf_init_cache_and_update_cursors", scope: !195, file: !195, line: 162, type: !1266, scopeLine: 162, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1268)
!1266 = !DISubroutineType(types: !1267)
!1267 = !{!134, !112, !66, null}
!1268 = !{!1269, !1270, !1271, !1272, !1276}
!1269 = !DILocalVariable(name: "dest", arg: 1, scope: !1265, file: !195, line: 162, type: !112)
!1270 = !DILocalVariable(name: "allocator", arg: 2, scope: !1265, file: !195, line: 162, type: !66)
!1271 = !DILocalVariable(name: "total_len", scope: !1265, file: !195, line: 168, type: !73)
!1272 = !DILocalVariable(name: "args", scope: !1265, file: !195, line: 169, type: !1273)
!1273 = !DIDerivedType(tag: DW_TAG_typedef, name: "va_list", file: !1274, line: 14, baseType: !1275)
!1274 = !DIFile(filename: "src/clang-10.0.1.src/install-release/lib/clang/10.0.1/include/stdarg.h", directory: "/Users/jorge")
!1275 = !DIDerivedType(tag: DW_TAG_typedef, name: "__builtin_va_list", file: !3, line: 169, baseType: !61)
!1276 = !DILocalVariable(name: "cursor_i", scope: !1265, file: !195, line: 173, type: !135)
!1277 = !DILocation(line: 162, column: 69, scope: !1265)
!1278 = !DILocation(line: 162, column: 97, scope: !1265)
!1279 = !DILocation(line: 166, column: 5, scope: !1265)
!1280 = !DILocation(line: 166, column: 5, scope: !1281)
!1281 = distinct !DILexicalBlock(scope: !1265, file: !195, line: 166, column: 5)
!1282 = !DILocation(line: 168, column: 5, scope: !1265)
!1283 = !DILocation(line: 168, column: 12, scope: !1265)
!1284 = !DILocation(line: 169, column: 5, scope: !1265)
!1285 = !DILocation(line: 169, column: 13, scope: !1265)
!1286 = !DILocation(line: 170, column: 5, scope: !1265)
!1287 = !DILocation(line: 173, column: 5, scope: !1265)
!1288 = !DILocation(line: 173, column: 29, scope: !1265)
!1289 = !DILocation(line: 174, column: 5, scope: !1265)
!1290 = !DILocation(line: 174, column: 24, scope: !1265)
!1291 = !DILocation(line: 174, column: 22, scope: !1265)
!1292 = !DILocation(line: 174, column: 64, scope: !1265)
!1293 = !DILocation(line: 176, column: 34, scope: !1294)
!1294 = distinct !DILexicalBlock(scope: !1295, file: !195, line: 176, column: 13)
!1295 = distinct !DILexicalBlock(scope: !1265, file: !195, line: 174, column: 73)
!1296 = !DILocation(line: 176, column: 45, scope: !1294)
!1297 = !DILocation(line: 176, column: 55, scope: !1294)
!1298 = !DILocation(line: 176, column: 13, scope: !1294)
!1299 = !DILocation(line: 176, column: 13, scope: !1295)
!1300 = !DILocation(line: 177, column: 13, scope: !1301)
!1301 = distinct !DILexicalBlock(scope: !1294, file: !195, line: 176, column: 73)
!1302 = distinct !{!1302, !1289, !1303}
!1303 = !DILocation(line: 179, column: 5, scope: !1265)
!1304 = !DILocation(line: 180, column: 5, scope: !1265)
!1305 = !DILocation(line: 182, column: 27, scope: !1306)
!1306 = distinct !DILexicalBlock(scope: !1265, file: !195, line: 182, column: 9)
!1307 = !DILocation(line: 182, column: 33, scope: !1306)
!1308 = !DILocation(line: 182, column: 44, scope: !1306)
!1309 = !DILocation(line: 182, column: 9, scope: !1306)
!1310 = !DILocation(line: 182, column: 9, scope: !1265)
!1311 = !DILocation(line: 183, column: 9, scope: !1312)
!1312 = distinct !DILexicalBlock(scope: !1306, file: !195, line: 182, column: 56)
!1313 = !DILocation(line: 186, column: 5, scope: !1265)
!1314 = !DILocation(line: 187, column: 5, scope: !1265)
!1315 = !DILocation(line: 187, column: 24, scope: !1265)
!1316 = !DILocation(line: 187, column: 22, scope: !1265)
!1317 = !DILocation(line: 187, column: 64, scope: !1265)
!1318 = !DILocation(line: 189, column: 40, scope: !1319)
!1319 = distinct !DILexicalBlock(scope: !1265, file: !195, line: 187, column: 73)
!1320 = !DILocation(line: 189, column: 46, scope: !1319)
!1321 = !DILocation(line: 189, column: 9, scope: !1319)
!1322 = distinct !{!1322, !1314, !1323}
!1323 = !DILocation(line: 190, column: 5, scope: !1265)
!1324 = !DILocation(line: 191, column: 5, scope: !1265)
!1325 = !DILocation(line: 193, column: 5, scope: !1265)
!1326 = !DILocation(line: 194, column: 1, scope: !1265)
!1327 = distinct !DISubprogram(name: "aws_add_size_checked", scope: !1328, file: !1328, line: 126, type: !1329, scopeLine: 126, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1332)
!1328 = !DIFile(filename: "aws-c-common/include/aws/common/math.inl", directory: "/Users/jorge/Repos/verify-c-common")
!1329 = !DISubroutineType(types: !1330)
!1330 = !{!134, !73, !73, !1331}
!1331 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !73, size: 32)
!1332 = !{!1333, !1334, !1335}
!1333 = !DILocalVariable(name: "a", arg: 1, scope: !1327, file: !1328, line: 126, type: !73)
!1334 = !DILocalVariable(name: "b", arg: 2, scope: !1327, file: !1328, line: 126, type: !73)
!1335 = !DILocalVariable(name: "r", arg: 3, scope: !1327, file: !1328, line: 126, type: !1331)
!1336 = !DILocation(line: 126, column: 49, scope: !1327)
!1337 = !DILocation(line: 126, column: 59, scope: !1327)
!1338 = !DILocation(line: 126, column: 70, scope: !1327)
!1339 = !DILocation(line: 128, column: 32, scope: !1327)
!1340 = !DILocation(line: 128, column: 35, scope: !1327)
!1341 = !DILocation(line: 128, column: 50, scope: !1327)
!1342 = !DILocation(line: 128, column: 12, scope: !1327)
!1343 = !DILocation(line: 128, column: 5, scope: !1327)
!1344 = distinct !DISubprogram(name: "aws_byte_buf_append_and_update", scope: !195, file: !195, line: 1584, type: !132, scopeLine: 1584, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1345)
!1345 = !{!1346, !1347}
!1346 = !DILocalVariable(name: "to", arg: 1, scope: !1344, file: !195, line: 1584, type: !112)
!1347 = !DILocalVariable(name: "from_and_update", arg: 2, scope: !1344, file: !195, line: 1584, type: !135)
!1348 = !DILocation(line: 1584, column: 57, scope: !1344)
!1349 = !DILocation(line: 1584, column: 85, scope: !1344)
!1350 = !DILocation(line: 1588, column: 29, scope: !1351)
!1351 = distinct !DILexicalBlock(scope: !1344, file: !195, line: 1588, column: 9)
!1352 = !DILocation(line: 1588, column: 33, scope: !1351)
!1353 = !DILocation(line: 1588, column: 9, scope: !1351)
!1354 = !DILocation(line: 1588, column: 9, scope: !1344)
!1355 = !DILocation(line: 1589, column: 9, scope: !1356)
!1356 = distinct !DILexicalBlock(scope: !1351, file: !195, line: 1588, column: 51)
!1357 = !DILocation(line: 1592, column: 28, scope: !1344)
!1358 = !DILocation(line: 1592, column: 32, scope: !1344)
!1359 = !DILocation(line: 1592, column: 42, scope: !1344)
!1360 = !DILocation(line: 1592, column: 46, scope: !1344)
!1361 = !DILocation(line: 1592, column: 52, scope: !1344)
!1362 = !DILocation(line: 1592, column: 69, scope: !1344)
!1363 = !DILocation(line: 1592, column: 50, scope: !1344)
!1364 = !DILocation(line: 1592, column: 39, scope: !1344)
!1365 = !DILocation(line: 1592, column: 5, scope: !1344)
!1366 = !DILocation(line: 1592, column: 22, scope: !1344)
!1367 = !DILocation(line: 1592, column: 26, scope: !1344)
!1368 = !DILocation(line: 1593, column: 5, scope: !1344)
!1369 = !DILocation(line: 1594, column: 1, scope: !1344)
!1370 = distinct !DISubprogram(name: "aws_byte_buf_append", scope: !195, file: !195, line: 561, type: !147, scopeLine: 561, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1371)
!1371 = !{!1372, !1373}
!1372 = !DILocalVariable(name: "to", arg: 1, scope: !1370, file: !195, line: 561, type: !112)
!1373 = !DILocalVariable(name: "from", arg: 2, scope: !1370, file: !195, line: 561, type: !149)
!1374 = !DILocation(line: 561, column: 46, scope: !1370)
!1375 = !DILocation(line: 561, column: 80, scope: !1370)
!1376 = !DILocation(line: 565, column: 9, scope: !1377)
!1377 = distinct !DILexicalBlock(scope: !1370, file: !195, line: 565, column: 9)
!1378 = !DILocation(line: 565, column: 13, scope: !1377)
!1379 = !DILocation(line: 565, column: 24, scope: !1377)
!1380 = !DILocation(line: 565, column: 28, scope: !1377)
!1381 = !DILocation(line: 565, column: 22, scope: !1377)
!1382 = !DILocation(line: 565, column: 34, scope: !1377)
!1383 = !DILocation(line: 565, column: 40, scope: !1377)
!1384 = !DILocation(line: 565, column: 32, scope: !1377)
!1385 = !DILocation(line: 565, column: 9, scope: !1370)
!1386 = !DILocation(line: 568, column: 16, scope: !1387)
!1387 = distinct !DILexicalBlock(scope: !1377, file: !195, line: 565, column: 45)
!1388 = !DILocation(line: 568, column: 9, scope: !1387)
!1389 = !DILocation(line: 571, column: 9, scope: !1390)
!1390 = distinct !DILexicalBlock(scope: !1370, file: !195, line: 571, column: 9)
!1391 = !DILocation(line: 571, column: 15, scope: !1390)
!1392 = !DILocation(line: 571, column: 19, scope: !1390)
!1393 = !DILocation(line: 571, column: 9, scope: !1370)
!1394 = !DILocation(line: 575, column: 9, scope: !1395)
!1395 = distinct !DILexicalBlock(scope: !1390, file: !195, line: 571, column: 24)
!1396 = !DILocation(line: 576, column: 20, scope: !1395)
!1397 = !DILocation(line: 576, column: 26, scope: !1395)
!1398 = !DILocation(line: 576, column: 9, scope: !1395)
!1399 = !DILocation(line: 576, column: 13, scope: !1395)
!1400 = !DILocation(line: 576, column: 17, scope: !1395)
!1401 = !DILocation(line: 577, column: 5, scope: !1395)
!1402 = !DILocation(line: 581, column: 5, scope: !1370)
!1403 = !DILocation(line: 582, column: 1, scope: !1370)
!1404 = distinct !DISubprogram(name: "aws_add_u32_checked", scope: !1405, file: !1405, line: 93, type: !1406, scopeLine: 93, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1408)
!1405 = !DIFile(filename: "aws-c-common/include/aws/common/math.gcc_overflow.inl", directory: "/Users/jorge/Repos/verify-c-common")
!1406 = !DISubroutineType(types: !1407)
!1407 = !{!134, !163, !163, !162}
!1408 = !{!1409, !1410, !1411}
!1409 = !DILocalVariable(name: "a", arg: 1, scope: !1404, file: !1405, line: 93, type: !163)
!1410 = !DILocalVariable(name: "b", arg: 2, scope: !1404, file: !1405, line: 93, type: !163)
!1411 = !DILocalVariable(name: "r", arg: 3, scope: !1404, file: !1405, line: 93, type: !162)
!1412 = !DILocation(line: 93, column: 50, scope: !1404)
!1413 = !DILocation(line: 93, column: 62, scope: !1404)
!1414 = !DILocation(line: 93, column: 75, scope: !1404)
!1415 = !DILocation(line: 94, column: 32, scope: !1416)
!1416 = distinct !DILexicalBlock(scope: !1404, file: !1405, line: 94, column: 9)
!1417 = !DILocation(line: 94, column: 35, scope: !1416)
!1418 = !DILocation(line: 94, column: 38, scope: !1416)
!1419 = !DILocation(line: 94, column: 9, scope: !1416)
!1420 = !DILocation(line: 94, column: 9, scope: !1404)
!1421 = !DILocation(line: 95, column: 16, scope: !1422)
!1422 = distinct !DILexicalBlock(scope: !1416, file: !1405, line: 94, column: 42)
!1423 = !DILocation(line: 95, column: 9, scope: !1422)
!1424 = !DILocation(line: 97, column: 5, scope: !1404)
!1425 = !DILocation(line: 98, column: 1, scope: !1404)
!1426 = distinct !DISubprogram(name: "aws_byte_cursor_next_split", scope: !195, file: !195, line: 196, type: !1427, scopeLine: 199, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1431)
!1427 = !DISubroutineType(types: !1428)
!1428 = !{!96, !1429, !129, !1430}
!1429 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !149)
!1430 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !135)
!1431 = !{!1432, !1433, !1434, !1435, !1437, !1440}
!1432 = !DILocalVariable(name: "input_str", arg: 1, scope: !1426, file: !195, line: 197, type: !1429)
!1433 = !DILocalVariable(name: "split_on", arg: 2, scope: !1426, file: !195, line: 198, type: !129)
!1434 = !DILocalVariable(name: "substr", arg: 3, scope: !1426, file: !195, line: 199, type: !1430)
!1435 = !DILocalVariable(name: "first_run", scope: !1426, file: !195, line: 204, type: !1436)
!1436 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !96)
!1437 = !DILocalVariable(name: "input_end", scope: !1438, file: !195, line: 228, type: !151)
!1438 = distinct !DILexicalBlock(scope: !1439, file: !195, line: 225, column: 12)
!1439 = distinct !DILexicalBlock(scope: !1426, file: !195, line: 223, column: 9)
!1440 = !DILocalVariable(name: "new_location", scope: !1426, file: !195, line: 245, type: !103)
!1441 = !DILocation(line: 197, column: 48, scope: !1426)
!1442 = !DILocation(line: 198, column: 10, scope: !1426)
!1443 = !DILocation(line: 199, column: 42, scope: !1426)
!1444 = !DILocation(line: 204, column: 5, scope: !1426)
!1445 = !DILocation(line: 204, column: 16, scope: !1426)
!1446 = !DILocation(line: 204, column: 28, scope: !1426)
!1447 = !DILocation(line: 204, column: 36, scope: !1426)
!1448 = !DILocation(line: 204, column: 40, scope: !1426)
!1449 = !DILocation(line: 208, column: 9, scope: !1450)
!1450 = distinct !DILexicalBlock(scope: !1426, file: !195, line: 208, column: 9)
!1451 = !DILocation(line: 208, column: 9, scope: !1426)
!1452 = !DILocation(line: 209, column: 13, scope: !1453)
!1453 = distinct !DILexicalBlock(scope: !1454, file: !195, line: 209, column: 13)
!1454 = distinct !DILexicalBlock(scope: !1450, file: !195, line: 208, column: 47)
!1455 = !DILocation(line: 209, column: 13, scope: !1454)
!1456 = !DILocation(line: 211, column: 13, scope: !1457)
!1457 = distinct !DILexicalBlock(scope: !1453, file: !195, line: 209, column: 24)
!1458 = !DILocation(line: 211, column: 21, scope: !1457)
!1459 = !DILocation(line: 211, column: 25, scope: !1457)
!1460 = !DILocation(line: 212, column: 13, scope: !1457)
!1461 = !DILocation(line: 212, column: 21, scope: !1457)
!1462 = !DILocation(line: 212, column: 25, scope: !1457)
!1463 = !DILocation(line: 213, column: 13, scope: !1457)
!1464 = !DILocation(line: 217, column: 9, scope: !1454)
!1465 = !DILocation(line: 217, column: 9, scope: !1466)
!1466 = distinct !DILexicalBlock(scope: !1454, file: !195, line: 217, column: 9)
!1467 = !DILocation(line: 218, column: 9, scope: !1454)
!1468 = !DILocation(line: 223, column: 9, scope: !1439)
!1469 = !DILocation(line: 223, column: 9, scope: !1426)
!1470 = !DILocation(line: 224, column: 10, scope: !1471)
!1471 = distinct !DILexicalBlock(scope: !1439, file: !195, line: 223, column: 20)
!1472 = !DILocation(line: 224, column: 20, scope: !1471)
!1473 = !DILocation(line: 224, column: 19, scope: !1471)
!1474 = !{i64 0, i64 4, !663, i64 4, i64 4, !657}
!1475 = !DILocation(line: 225, column: 5, scope: !1471)
!1476 = !DILocation(line: 228, column: 9, scope: !1438)
!1477 = !DILocation(line: 228, column: 24, scope: !1438)
!1478 = !DILocation(line: 228, column: 36, scope: !1438)
!1479 = !DILocation(line: 228, column: 47, scope: !1438)
!1480 = !DILocation(line: 228, column: 53, scope: !1438)
!1481 = !DILocation(line: 228, column: 64, scope: !1438)
!1482 = !DILocation(line: 228, column: 51, scope: !1438)
!1483 = !DILocation(line: 229, column: 24, scope: !1438)
!1484 = !DILocation(line: 229, column: 32, scope: !1438)
!1485 = !DILocation(line: 229, column: 36, scope: !1438)
!1486 = !DILocation(line: 229, column: 9, scope: !1438)
!1487 = !DILocation(line: 229, column: 17, scope: !1438)
!1488 = !DILocation(line: 229, column: 21, scope: !1438)
!1489 = !DILocation(line: 234, column: 13, scope: !1490)
!1490 = distinct !DILexicalBlock(scope: !1438, file: !195, line: 234, column: 13)
!1491 = !DILocation(line: 234, column: 21, scope: !1490)
!1492 = !DILocation(line: 234, column: 27, scope: !1490)
!1493 = !DILocation(line: 234, column: 25, scope: !1490)
!1494 = !DILocation(line: 234, column: 37, scope: !1490)
!1495 = !DILocation(line: 234, column: 40, scope: !1490)
!1496 = !DILocation(line: 234, column: 48, scope: !1490)
!1497 = !DILocation(line: 234, column: 54, scope: !1490)
!1498 = !DILocation(line: 234, column: 65, scope: !1490)
!1499 = !DILocation(line: 234, column: 52, scope: !1490)
!1500 = !DILocation(line: 234, column: 13, scope: !1438)
!1501 = !DILocation(line: 236, column: 13, scope: !1502)
!1502 = distinct !DILexicalBlock(scope: !1490, file: !195, line: 234, column: 70)
!1503 = !DILocation(line: 236, column: 13, scope: !1504)
!1504 = distinct !DILexicalBlock(scope: !1502, file: !195, line: 236, column: 13)
!1505 = !DILocation(line: 237, column: 13, scope: !1502)
!1506 = !DILocation(line: 241, column: 23, scope: !1438)
!1507 = !DILocation(line: 241, column: 34, scope: !1438)
!1508 = !DILocation(line: 241, column: 41, scope: !1438)
!1509 = !DILocation(line: 241, column: 49, scope: !1438)
!1510 = !DILocation(line: 241, column: 55, scope: !1438)
!1511 = !DILocation(line: 241, column: 66, scope: !1438)
!1512 = !DILocation(line: 241, column: 53, scope: !1438)
!1513 = !DILocation(line: 241, column: 38, scope: !1438)
!1514 = !DILocation(line: 241, column: 9, scope: !1438)
!1515 = !DILocation(line: 241, column: 17, scope: !1438)
!1516 = !DILocation(line: 241, column: 21, scope: !1438)
!1517 = !DILocation(line: 242, column: 5, scope: !1439)
!1518 = !DILocation(line: 245, column: 5, scope: !1426)
!1519 = !DILocation(line: 245, column: 14, scope: !1426)
!1520 = !DILocation(line: 245, column: 36, scope: !1426)
!1521 = !DILocation(line: 245, column: 44, scope: !1426)
!1522 = !DILocation(line: 245, column: 49, scope: !1426)
!1523 = !DILocation(line: 245, column: 59, scope: !1426)
!1524 = !DILocation(line: 245, column: 67, scope: !1426)
!1525 = !DILocation(line: 245, column: 29, scope: !1426)
!1526 = !DILocation(line: 246, column: 9, scope: !1527)
!1527 = distinct !DILexicalBlock(scope: !1426, file: !195, line: 246, column: 9)
!1528 = !DILocation(line: 246, column: 9, scope: !1426)
!1529 = !DILocation(line: 249, column: 23, scope: !1530)
!1530 = distinct !DILexicalBlock(scope: !1527, file: !195, line: 246, column: 23)
!1531 = !DILocation(line: 249, column: 38, scope: !1530)
!1532 = !DILocation(line: 249, column: 46, scope: !1530)
!1533 = !DILocation(line: 249, column: 36, scope: !1530)
!1534 = !DILocation(line: 249, column: 9, scope: !1530)
!1535 = !DILocation(line: 249, column: 17, scope: !1530)
!1536 = !DILocation(line: 249, column: 21, scope: !1530)
!1537 = !DILocation(line: 250, column: 5, scope: !1530)
!1538 = !DILocation(line: 253, column: 5, scope: !1426)
!1539 = !DILocation(line: 254, column: 1, scope: !1426)
!1540 = distinct !DISubprogram(name: "aws_byte_cursor_split_on_char_n", scope: !195, file: !195, line: 256, type: !1541, scopeLine: 260, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1544)
!1541 = !DISubroutineType(types: !1542)
!1542 = !{!134, !1429, !129, !73, !1543}
!1543 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !172)
!1544 = !{!1545, !1546, !1547, !1548, !1549, !1550, !1551}
!1545 = !DILocalVariable(name: "input_str", arg: 1, scope: !1540, file: !195, line: 257, type: !1429)
!1546 = !DILocalVariable(name: "split_on", arg: 2, scope: !1540, file: !195, line: 258, type: !129)
!1547 = !DILocalVariable(name: "n", arg: 3, scope: !1540, file: !195, line: 259, type: !73)
!1548 = !DILocalVariable(name: "output", arg: 4, scope: !1540, file: !195, line: 260, type: !1543)
!1549 = !DILocalVariable(name: "max_splits", scope: !1540, file: !195, line: 265, type: !73)
!1550 = !DILocalVariable(name: "split_count", scope: !1540, file: !195, line: 266, type: !73)
!1551 = !DILocalVariable(name: "substr", scope: !1540, file: !195, line: 268, type: !136)
!1552 = !DILocation(line: 257, column: 48, scope: !1540)
!1553 = !DILocation(line: 258, column: 10, scope: !1540)
!1554 = !DILocation(line: 259, column: 12, scope: !1540)
!1555 = !DILocation(line: 260, column: 41, scope: !1540)
!1556 = !DILocation(line: 265, column: 5, scope: !1540)
!1557 = !DILocation(line: 265, column: 12, scope: !1540)
!1558 = !DILocation(line: 265, column: 25, scope: !1540)
!1559 = !DILocation(line: 265, column: 27, scope: !1540)
!1560 = !DILocation(line: 265, column: 33, scope: !1540)
!1561 = !DILocation(line: 266, column: 5, scope: !1540)
!1562 = !DILocation(line: 266, column: 12, scope: !1540)
!1563 = !DILocation(line: 268, column: 5, scope: !1540)
!1564 = !DILocation(line: 268, column: 28, scope: !1540)
!1565 = !DILocation(line: 269, column: 5, scope: !1540)
!1566 = !DILocation(line: 269, column: 5, scope: !1567)
!1567 = distinct !DILexicalBlock(scope: !1540, file: !195, line: 269, column: 5)
!1568 = !DILocation(line: 272, column: 5, scope: !1540)
!1569 = !DILocation(line: 272, column: 12, scope: !1540)
!1570 = !DILocation(line: 272, column: 27, scope: !1540)
!1571 = !DILocation(line: 272, column: 24, scope: !1540)
!1572 = !DILocation(line: 272, column: 38, scope: !1540)
!1573 = !DILocation(line: 272, column: 68, scope: !1540)
!1574 = !DILocation(line: 272, column: 79, scope: !1540)
!1575 = !DILocation(line: 272, column: 41, scope: !1540)
!1576 = !DILocation(line: 0, scope: !1540)
!1577 = !DILocation(line: 274, column: 13, scope: !1578)
!1578 = distinct !DILexicalBlock(scope: !1579, file: !195, line: 274, column: 13)
!1579 = distinct !DILexicalBlock(scope: !1540, file: !195, line: 272, column: 99)
!1580 = !DILocation(line: 274, column: 28, scope: !1578)
!1581 = !DILocation(line: 274, column: 25, scope: !1578)
!1582 = !DILocation(line: 274, column: 13, scope: !1579)
!1583 = !DILocation(line: 276, column: 26, scope: !1584)
!1584 = distinct !DILexicalBlock(scope: !1578, file: !195, line: 274, column: 40)
!1585 = !DILocation(line: 276, column: 37, scope: !1584)
!1586 = !DILocation(line: 276, column: 51, scope: !1584)
!1587 = !DILocation(line: 276, column: 57, scope: !1584)
!1588 = !DILocation(line: 276, column: 68, scope: !1584)
!1589 = !DILocation(line: 276, column: 55, scope: !1584)
!1590 = !DILocation(line: 276, column: 41, scope: !1584)
!1591 = !DILocation(line: 276, column: 20, scope: !1584)
!1592 = !DILocation(line: 276, column: 24, scope: !1584)
!1593 = !DILocation(line: 277, column: 9, scope: !1584)
!1594 = !DILocation(line: 279, column: 13, scope: !1595)
!1595 = distinct !DILexicalBlock(scope: !1579, file: !195, line: 279, column: 13)
!1596 = !DILocation(line: 279, column: 13, scope: !1579)
!1597 = !DILocation(line: 280, column: 13, scope: !1598)
!1598 = distinct !DILexicalBlock(scope: !1595, file: !195, line: 279, column: 84)
!1599 = !DILocation(line: 282, column: 9, scope: !1579)
!1600 = distinct !{!1600, !1568, !1601}
!1601 = !DILocation(line: 283, column: 5, scope: !1540)
!1602 = !DILocation(line: 285, column: 5, scope: !1540)
!1603 = !DILocation(line: 286, column: 1, scope: !1540)
!1604 = distinct !DISubprogram(name: "aws_array_list_push_back", scope: !1605, file: !1605, line: 130, type: !1606, scopeLine: 130, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1608)
!1605 = !DIFile(filename: "aws-c-common/include/aws/common/array_list.inl", directory: "/Users/jorge/Repos/verify-c-common")
!1606 = !DISubroutineType(types: !1607)
!1607 = !{!134, !1543, !121}
!1608 = !{!1609, !1610, !1611}
!1609 = !DILocalVariable(name: "list", arg: 1, scope: !1604, file: !1605, line: 130, type: !1543)
!1610 = !DILocalVariable(name: "val", arg: 2, scope: !1604, file: !1605, line: 130, type: !121)
!1611 = !DILocalVariable(name: "err_code", scope: !1604, file: !1605, line: 136, type: !134)
!1612 = !DILocation(line: 130, column: 66, scope: !1604)
!1613 = !DILocation(line: 130, column: 84, scope: !1604)
!1614 = !DILocation(line: 136, column: 5, scope: !1604)
!1615 = !DILocation(line: 136, column: 9, scope: !1604)
!1616 = !DILocation(line: 136, column: 42, scope: !1604)
!1617 = !DILocation(line: 136, column: 48, scope: !1604)
!1618 = !DILocation(line: 136, column: 75, scope: !1604)
!1619 = !DILocation(line: 136, column: 53, scope: !1604)
!1620 = !DILocation(line: 136, column: 20, scope: !1604)
!1621 = !DILocation(line: 138, column: 9, scope: !1622)
!1622 = distinct !DILexicalBlock(scope: !1604, file: !1605, line: 138, column: 9)
!1623 = !DILocation(line: 138, column: 18, scope: !1622)
!1624 = !DILocation(line: 138, column: 21, scope: !1622)
!1625 = !DILocation(line: 138, column: 38, scope: !1622)
!1626 = !DILocation(line: 138, column: 65, scope: !1622)
!1627 = !DILocation(line: 138, column: 69, scope: !1622)
!1628 = !DILocation(line: 138, column: 75, scope: !1622)
!1629 = !{!1630, !658, i64 0}
!1630 = !{!"aws_array_list", !658, i64 0, !664, i64 4, !664, i64 8, !664, i64 12, !658, i64 16}
!1631 = !DILocation(line: 138, column: 9, scope: !1604)
!1632 = !DILocation(line: 140, column: 16, scope: !1633)
!1633 = distinct !DILexicalBlock(scope: !1622, file: !1605, line: 138, column: 82)
!1634 = !DILocation(line: 140, column: 9, scope: !1633)
!1635 = !DILocation(line: 144, column: 12, scope: !1604)
!1636 = !DILocation(line: 144, column: 5, scope: !1604)
!1637 = !DILocation(line: 145, column: 1, scope: !1604)
!1638 = distinct !DISubprogram(name: "aws_array_list_length", scope: !1605, file: !1605, line: 307, type: !1639, scopeLine: 307, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1644)
!1639 = !DISubroutineType(types: !1640)
!1640 = !{!73, !1641}
!1641 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !1642)
!1642 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !1643, size: 32)
!1643 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !173)
!1644 = !{!1645, !1646}
!1645 = !DILocalVariable(name: "list", arg: 1, scope: !1638, file: !1605, line: 307, type: !1641)
!1646 = !DILocalVariable(name: "len", scope: !1638, file: !1605, line: 314, type: !73)
!1647 = !DILocation(line: 307, column: 72, scope: !1638)
!1648 = !DILocation(line: 312, column: 5, scope: !1649)
!1649 = distinct !DILexicalBlock(scope: !1638, file: !1605, line: 312, column: 5)
!1650 = !{!1630, !664, i64 8}
!1651 = !{!1630, !658, i64 16}
!1652 = !DILocation(line: 312, column: 5, scope: !1638)
!1653 = !DILocation(line: 312, column: 5, scope: !1654)
!1654 = distinct !DILexicalBlock(scope: !1649, file: !1605, line: 312, column: 5)
!1655 = !DILocation(line: 314, column: 5, scope: !1638)
!1656 = !DILocation(line: 314, column: 12, scope: !1638)
!1657 = !DILocation(line: 314, column: 18, scope: !1638)
!1658 = !DILocation(line: 314, column: 24, scope: !1638)
!1659 = !DILocation(line: 316, column: 12, scope: !1638)
!1660 = !DILocation(line: 317, column: 1, scope: !1638)
!1661 = !DILocation(line: 316, column: 5, scope: !1638)
!1662 = distinct !DISubprogram(name: "aws_array_list_set_at", scope: !1605, file: !1605, line: 348, type: !1663, scopeLine: 348, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1665)
!1663 = !DISubroutineType(types: !1664)
!1664 = !{!134, !1543, !121, !73}
!1665 = !{!1666, !1667, !1668}
!1666 = !DILocalVariable(name: "list", arg: 1, scope: !1662, file: !1605, line: 348, type: !1543)
!1667 = !DILocalVariable(name: "val", arg: 2, scope: !1662, file: !1605, line: 348, type: !121)
!1668 = !DILocalVariable(name: "index", arg: 3, scope: !1662, file: !1605, line: 348, type: !73)
!1669 = !DILocation(line: 348, column: 63, scope: !1662)
!1670 = !DILocation(line: 348, column: 81, scope: !1662)
!1671 = !DILocation(line: 348, column: 93, scope: !1662)
!1672 = !DILocation(line: 354, column: 40, scope: !1673)
!1673 = distinct !DILexicalBlock(scope: !1662, file: !1605, line: 354, column: 9)
!1674 = !DILocation(line: 354, column: 46, scope: !1673)
!1675 = !DILocation(line: 354, column: 9, scope: !1673)
!1676 = !DILocation(line: 354, column: 9, scope: !1662)
!1677 = !DILocation(line: 356, column: 9, scope: !1678)
!1678 = distinct !DILexicalBlock(scope: !1673, file: !1605, line: 354, column: 54)
!1679 = !DILocation(line: 359, column: 5, scope: !1680)
!1680 = distinct !DILexicalBlock(scope: !1662, file: !1605, line: 359, column: 5)
!1681 = !DILocation(line: 359, column: 5, scope: !1662)
!1682 = !DILocation(line: 359, column: 5, scope: !1683)
!1683 = distinct !DILexicalBlock(scope: !1680, file: !1605, line: 359, column: 5)
!1684 = !DILocation(line: 361, column: 5, scope: !1662)
!1685 = !{!1630, !664, i64 12}
!1686 = !DILocation(line: 367, column: 9, scope: !1687)
!1687 = distinct !DILexicalBlock(scope: !1662, file: !1605, line: 367, column: 9)
!1688 = !DILocation(line: 367, column: 40, scope: !1687)
!1689 = !DILocation(line: 367, column: 18, scope: !1687)
!1690 = !DILocation(line: 367, column: 15, scope: !1687)
!1691 = !DILocation(line: 367, column: 9, scope: !1662)
!1692 = !DILocation(line: 368, column: 34, scope: !1693)
!1693 = distinct !DILexicalBlock(scope: !1694, file: !1605, line: 368, column: 13)
!1694 = distinct !DILexicalBlock(scope: !1687, file: !1605, line: 367, column: 47)
!1695 = !DILocation(line: 368, column: 45, scope: !1693)
!1696 = !DILocation(line: 368, column: 51, scope: !1693)
!1697 = !DILocation(line: 368, column: 13, scope: !1693)
!1698 = !DILocation(line: 368, column: 13, scope: !1694)
!1699 = !DILocation(line: 370, column: 13, scope: !1700)
!1700 = distinct !DILexicalBlock(scope: !1693, file: !1605, line: 368, column: 60)
!1701 = !DILocation(line: 372, column: 5, scope: !1694)
!1702 = !DILocation(line: 375, column: 5, scope: !1662)
!1703 = !DILocation(line: 376, column: 1, scope: !1662)
!1704 = distinct !DISubprogram(name: "aws_byte_cursor_split_on_char", scope: !195, file: !195, line: 288, type: !1705, scopeLine: 291, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1707)
!1705 = !DISubroutineType(types: !1706)
!1706 = !{!134, !1429, !129, !1543}
!1707 = !{!1708, !1709, !1710}
!1708 = !DILocalVariable(name: "input_str", arg: 1, scope: !1704, file: !195, line: 289, type: !1429)
!1709 = !DILocalVariable(name: "split_on", arg: 2, scope: !1704, file: !195, line: 290, type: !129)
!1710 = !DILocalVariable(name: "output", arg: 3, scope: !1704, file: !195, line: 291, type: !1543)
!1711 = !DILocation(line: 289, column: 48, scope: !1704)
!1712 = !DILocation(line: 290, column: 10, scope: !1704)
!1713 = !DILocation(line: 291, column: 41, scope: !1704)
!1714 = !DILocation(line: 293, column: 44, scope: !1704)
!1715 = !DILocation(line: 293, column: 55, scope: !1704)
!1716 = !DILocation(line: 293, column: 68, scope: !1704)
!1717 = !DILocation(line: 293, column: 12, scope: !1704)
!1718 = !DILocation(line: 293, column: 5, scope: !1704)
!1719 = distinct !DISubprogram(name: "aws_byte_cursor_find_exact", scope: !195, file: !195, line: 296, type: !1720, scopeLine: 299, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1722)
!1720 = !DISubroutineType(types: !1721)
!1721 = !{!134, !1429, !1429, !135}
!1722 = !{!1723, !1724, !1725, !1726, !1727}
!1723 = !DILocalVariable(name: "input_str", arg: 1, scope: !1719, file: !195, line: 297, type: !1429)
!1724 = !DILocalVariable(name: "to_find", arg: 2, scope: !1719, file: !195, line: 298, type: !1429)
!1725 = !DILocalVariable(name: "first_find", arg: 3, scope: !1719, file: !195, line: 299, type: !135)
!1726 = !DILocalVariable(name: "working_cur", scope: !1719, file: !195, line: 308, type: !136)
!1727 = !DILocalVariable(name: "first_char_location", scope: !1728, file: !195, line: 311, type: !103)
!1728 = distinct !DILexicalBlock(scope: !1719, file: !195, line: 310, column: 29)
!1729 = !DILocation(line: 297, column: 48, scope: !1719)
!1730 = !DILocation(line: 298, column: 48, scope: !1719)
!1731 = !DILocation(line: 299, column: 29, scope: !1719)
!1732 = !DILocation(line: 300, column: 9, scope: !1733)
!1733 = distinct !DILexicalBlock(scope: !1719, file: !195, line: 300, column: 9)
!1734 = !DILocation(line: 300, column: 18, scope: !1733)
!1735 = !DILocation(line: 300, column: 24, scope: !1733)
!1736 = !DILocation(line: 300, column: 35, scope: !1733)
!1737 = !DILocation(line: 300, column: 22, scope: !1733)
!1738 = !DILocation(line: 300, column: 9, scope: !1719)
!1739 = !DILocation(line: 301, column: 16, scope: !1740)
!1740 = distinct !DILexicalBlock(scope: !1733, file: !195, line: 300, column: 40)
!1741 = !DILocation(line: 301, column: 9, scope: !1740)
!1742 = !DILocation(line: 304, column: 9, scope: !1743)
!1743 = distinct !DILexicalBlock(scope: !1719, file: !195, line: 304, column: 9)
!1744 = !DILocation(line: 304, column: 18, scope: !1743)
!1745 = !DILocation(line: 304, column: 22, scope: !1743)
!1746 = !DILocation(line: 304, column: 9, scope: !1719)
!1747 = !DILocation(line: 305, column: 16, scope: !1748)
!1748 = distinct !DILexicalBlock(scope: !1743, file: !195, line: 304, column: 27)
!1749 = !DILocation(line: 305, column: 9, scope: !1748)
!1750 = !DILocation(line: 308, column: 5, scope: !1719)
!1751 = !DILocation(line: 308, column: 28, scope: !1719)
!1752 = !DILocation(line: 308, column: 43, scope: !1719)
!1753 = !DILocation(line: 308, column: 42, scope: !1719)
!1754 = !DILocation(line: 310, column: 5, scope: !1719)
!1755 = !DILocation(line: 310, column: 24, scope: !1719)
!1756 = !DILocation(line: 311, column: 9, scope: !1728)
!1757 = !DILocation(line: 311, column: 18, scope: !1728)
!1758 = !DILocation(line: 311, column: 59, scope: !1728)
!1759 = !DILocation(line: 311, column: 71, scope: !1728)
!1760 = !DILocation(line: 311, column: 80, scope: !1728)
!1761 = !DILocation(line: 311, column: 70, scope: !1728)
!1762 = !DILocation(line: 311, column: 64, scope: !1728)
!1763 = !DILocation(line: 311, column: 97, scope: !1728)
!1764 = !DILocation(line: 311, column: 40, scope: !1728)
!1765 = !DILocation(line: 313, column: 14, scope: !1766)
!1766 = distinct !DILexicalBlock(scope: !1728, file: !195, line: 313, column: 13)
!1767 = !DILocation(line: 313, column: 13, scope: !1728)
!1768 = !DILocation(line: 314, column: 20, scope: !1769)
!1769 = distinct !DILexicalBlock(scope: !1766, file: !195, line: 313, column: 35)
!1770 = !DILocation(line: 314, column: 13, scope: !1769)
!1771 = !DILocation(line: 317, column: 47, scope: !1728)
!1772 = !DILocation(line: 317, column: 81, scope: !1728)
!1773 = !DILocation(line: 317, column: 67, scope: !1728)
!1774 = !DILocation(line: 317, column: 9, scope: !1728)
!1775 = !DILocation(line: 319, column: 25, scope: !1776)
!1776 = distinct !DILexicalBlock(scope: !1728, file: !195, line: 319, column: 13)
!1777 = !DILocation(line: 319, column: 31, scope: !1776)
!1778 = !DILocation(line: 319, column: 40, scope: !1776)
!1779 = !DILocation(line: 319, column: 29, scope: !1776)
!1780 = !DILocation(line: 319, column: 13, scope: !1728)
!1781 = !DILocation(line: 320, column: 20, scope: !1782)
!1782 = distinct !DILexicalBlock(scope: !1776, file: !195, line: 319, column: 45)
!1783 = !DILocation(line: 320, column: 13, scope: !1782)
!1784 = !DILocation(line: 323, column: 33, scope: !1785)
!1785 = distinct !DILexicalBlock(scope: !1728, file: !195, line: 323, column: 13)
!1786 = !DILocation(line: 323, column: 38, scope: !1785)
!1787 = !DILocation(line: 323, column: 47, scope: !1785)
!1788 = !DILocation(line: 323, column: 52, scope: !1785)
!1789 = !DILocation(line: 323, column: 61, scope: !1785)
!1790 = !DILocation(line: 323, column: 14, scope: !1785)
!1791 = !DILocation(line: 323, column: 13, scope: !1728)
!1792 = !DILocation(line: 324, column: 14, scope: !1793)
!1793 = distinct !DILexicalBlock(scope: !1785, file: !195, line: 323, column: 67)
!1794 = !DILocation(line: 324, column: 27, scope: !1793)
!1795 = !DILocation(line: 325, column: 13, scope: !1793)
!1796 = !DILocation(line: 328, column: 9, scope: !1728)
!1797 = !DILocation(line: 329, column: 5, scope: !1719)
!1798 = distinct !{!1798, !1754, !1797}
!1799 = !DILocation(line: 331, column: 12, scope: !1719)
!1800 = !DILocation(line: 331, column: 5, scope: !1719)
!1801 = !DILocation(line: 332, column: 1, scope: !1719)
!1802 = distinct !DISubprogram(name: "aws_byte_cursor_advance", scope: !195, file: !195, line: 1048, type: !1803, scopeLine: 1048, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1806)
!1803 = !DISubroutineType(types: !1804)
!1804 = !{!136, !1805, !945}
!1805 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !135)
!1806 = !{!1807, !1808, !1809}
!1807 = !DILocalVariable(name: "cursor", arg: 1, scope: !1802, file: !195, line: 1048, type: !1805)
!1808 = !DILocalVariable(name: "len", arg: 2, scope: !1802, file: !195, line: 1048, type: !945)
!1809 = !DILocalVariable(name: "rv", scope: !1802, file: !195, line: 1050, type: !136)
!1810 = !DILocation(line: 1048, column: 78, scope: !1802)
!1811 = !DILocation(line: 1048, column: 99, scope: !1802)
!1812 = !DILocation(line: 1050, column: 28, scope: !1802)
!1813 = !DILocation(line: 1051, column: 9, scope: !1814)
!1814 = distinct !DILexicalBlock(scope: !1802, file: !195, line: 1051, column: 9)
!1815 = !DILocation(line: 1051, column: 17, scope: !1814)
!1816 = !DILocation(line: 1051, column: 21, scope: !1814)
!1817 = !DILocation(line: 1051, column: 39, scope: !1814)
!1818 = !DILocation(line: 1051, column: 42, scope: !1814)
!1819 = !DILocation(line: 1051, column: 46, scope: !1814)
!1820 = !DILocation(line: 1051, column: 64, scope: !1814)
!1821 = !DILocation(line: 1051, column: 67, scope: !1814)
!1822 = !DILocation(line: 1051, column: 73, scope: !1814)
!1823 = !DILocation(line: 1051, column: 81, scope: !1814)
!1824 = !DILocation(line: 1051, column: 71, scope: !1814)
!1825 = !DILocation(line: 1051, column: 9, scope: !1802)
!1826 = !DILocation(line: 1052, column: 12, scope: !1827)
!1827 = distinct !DILexicalBlock(scope: !1814, file: !195, line: 1051, column: 86)
!1828 = !DILocation(line: 1052, column: 16, scope: !1827)
!1829 = !DILocation(line: 1053, column: 12, scope: !1827)
!1830 = !DILocation(line: 1053, column: 16, scope: !1827)
!1831 = !DILocation(line: 1054, column: 5, scope: !1827)
!1832 = !DILocation(line: 1055, column: 18, scope: !1833)
!1833 = distinct !DILexicalBlock(scope: !1814, file: !195, line: 1054, column: 12)
!1834 = !DILocation(line: 1055, column: 26, scope: !1833)
!1835 = !DILocation(line: 1055, column: 12, scope: !1833)
!1836 = !DILocation(line: 1055, column: 16, scope: !1833)
!1837 = !DILocation(line: 1056, column: 18, scope: !1833)
!1838 = !DILocation(line: 1056, column: 12, scope: !1833)
!1839 = !DILocation(line: 1056, column: 16, scope: !1833)
!1840 = !DILocation(line: 1057, column: 24, scope: !1833)
!1841 = !DILocation(line: 1057, column: 32, scope: !1833)
!1842 = !DILocation(line: 1057, column: 36, scope: !1833)
!1843 = !DILocation(line: 1057, column: 23, scope: !1833)
!1844 = !DILocation(line: 1057, column: 54, scope: !1833)
!1845 = !DILocation(line: 1057, column: 62, scope: !1833)
!1846 = !DILocation(line: 1057, column: 68, scope: !1833)
!1847 = !DILocation(line: 1057, column: 66, scope: !1833)
!1848 = !DILocation(line: 1057, column: 9, scope: !1833)
!1849 = !DILocation(line: 1057, column: 17, scope: !1833)
!1850 = !DILocation(line: 1057, column: 21, scope: !1833)
!1851 = !DILocation(line: 1058, column: 24, scope: !1833)
!1852 = !DILocation(line: 1058, column: 9, scope: !1833)
!1853 = !DILocation(line: 1058, column: 17, scope: !1833)
!1854 = !DILocation(line: 1058, column: 21, scope: !1833)
!1855 = !DILocation(line: 1062, column: 5, scope: !1802)
!1856 = distinct !DISubprogram(name: "aws_byte_buf_cat", scope: !195, file: !195, line: 334, type: !1857, scopeLine: 334, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1859)
!1857 = !DISubroutineType(types: !1858)
!1858 = !{!134, !112, !73, null}
!1859 = !{!1860, !1861, !1862, !1863, !1865, !1868}
!1860 = !DILocalVariable(name: "dest", arg: 1, scope: !1856, file: !195, line: 334, type: !112)
!1861 = !DILocalVariable(name: "number_of_args", arg: 2, scope: !1856, file: !195, line: 334, type: !73)
!1862 = !DILocalVariable(name: "ap", scope: !1856, file: !195, line: 337, type: !1273)
!1863 = !DILocalVariable(name: "i", scope: !1864, file: !195, line: 340, type: !73)
!1864 = distinct !DILexicalBlock(scope: !1856, file: !195, line: 340, column: 5)
!1865 = !DILocalVariable(name: "buffer", scope: !1866, file: !195, line: 341, type: !112)
!1866 = distinct !DILexicalBlock(scope: !1867, file: !195, line: 340, column: 49)
!1867 = distinct !DILexicalBlock(scope: !1864, file: !195, line: 340, column: 5)
!1868 = !DILocalVariable(name: "cursor", scope: !1866, file: !195, line: 342, type: !136)
!1869 = !DILocation(line: 334, column: 43, scope: !1856)
!1870 = !DILocation(line: 334, column: 56, scope: !1856)
!1871 = !DILocation(line: 337, column: 5, scope: !1856)
!1872 = !DILocation(line: 337, column: 13, scope: !1856)
!1873 = !DILocation(line: 338, column: 5, scope: !1856)
!1874 = !DILocation(line: 340, column: 10, scope: !1864)
!1875 = !DILocation(line: 340, column: 17, scope: !1864)
!1876 = !DILocation(line: 340, column: 24, scope: !1867)
!1877 = !DILocation(line: 340, column: 28, scope: !1867)
!1878 = !DILocation(line: 340, column: 26, scope: !1867)
!1879 = !DILocation(line: 340, column: 5, scope: !1864)
!1880 = !DILocation(line: 341, column: 9, scope: !1866)
!1881 = !DILocation(line: 341, column: 30, scope: !1866)
!1882 = !DILocation(line: 341, column: 39, scope: !1866)
!1883 = !DILocation(line: 342, column: 9, scope: !1866)
!1884 = !DILocation(line: 342, column: 32, scope: !1866)
!1885 = !DILocation(line: 342, column: 66, scope: !1866)
!1886 = !DILocation(line: 342, column: 41, scope: !1866)
!1887 = !DILocation(line: 344, column: 33, scope: !1888)
!1888 = distinct !DILexicalBlock(scope: !1866, file: !195, line: 344, column: 13)
!1889 = !DILocation(line: 344, column: 13, scope: !1888)
!1890 = !DILocation(line: 344, column: 13, scope: !1866)
!1891 = !DILocation(line: 345, column: 13, scope: !1892)
!1892 = distinct !DILexicalBlock(scope: !1888, file: !195, line: 344, column: 49)
!1893 = !DILocation(line: 347, column: 13, scope: !1892)
!1894 = !DILocation(line: 349, column: 5, scope: !1867)
!1895 = !DILocation(line: 349, column: 5, scope: !1866)
!1896 = !DILocation(line: 340, column: 44, scope: !1867)
!1897 = !DILocation(line: 340, column: 5, scope: !1867)
!1898 = distinct !{!1898, !1879, !1899}
!1899 = !DILocation(line: 349, column: 5, scope: !1864)
!1900 = !DILocation(line: 351, column: 5, scope: !1856)
!1901 = !DILocation(line: 353, column: 5, scope: !1856)
!1902 = !DILocation(line: 354, column: 1, scope: !1856)
!1903 = distinct !DISubprogram(name: "aws_byte_cursor_from_buf", scope: !195, file: !195, line: 940, type: !1904, scopeLine: 940, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1906)
!1904 = !DISubroutineType(types: !1905)
!1905 = !{!136, !767}
!1906 = !{!1907, !1908}
!1907 = !DILocalVariable(name: "buf", arg: 1, scope: !1903, file: !195, line: 940, type: !767)
!1908 = !DILocalVariable(name: "cur", scope: !1903, file: !195, line: 942, type: !136)
!1909 = !DILocation(line: 940, column: 82, scope: !1903)
!1910 = !DILocation(line: 942, column: 28, scope: !1903)
!1911 = !DILocation(line: 943, column: 15, scope: !1903)
!1912 = !DILocation(line: 943, column: 20, scope: !1903)
!1913 = !DILocation(line: 943, column: 9, scope: !1903)
!1914 = !DILocation(line: 943, column: 13, scope: !1903)
!1915 = !DILocation(line: 944, column: 15, scope: !1903)
!1916 = !DILocation(line: 944, column: 20, scope: !1903)
!1917 = !DILocation(line: 944, column: 9, scope: !1903)
!1918 = !DILocation(line: 944, column: 13, scope: !1903)
!1919 = !DILocation(line: 946, column: 5, scope: !1903)
!1920 = distinct !DISubprogram(name: "aws_byte_cursor_eq", scope: !195, file: !195, line: 356, type: !1921, scopeLine: 356, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1923)
!1921 = !DISubroutineType(types: !1922)
!1922 = !{!96, !149, !149}
!1923 = !{!1924, !1925, !1926}
!1924 = !DILocalVariable(name: "a", arg: 1, scope: !1920, file: !195, line: 356, type: !149)
!1925 = !DILocalVariable(name: "b", arg: 2, scope: !1920, file: !195, line: 356, type: !149)
!1926 = !DILocalVariable(name: "rv", scope: !1920, file: !195, line: 359, type: !96)
!1927 = !DILocation(line: 356, column: 55, scope: !1920)
!1928 = !DILocation(line: 356, column: 88, scope: !1920)
!1929 = !DILocation(line: 359, column: 5, scope: !1920)
!1930 = !DILocation(line: 359, column: 10, scope: !1920)
!1931 = !DILocation(line: 359, column: 28, scope: !1920)
!1932 = !DILocation(line: 359, column: 31, scope: !1920)
!1933 = !DILocation(line: 359, column: 36, scope: !1920)
!1934 = !DILocation(line: 359, column: 39, scope: !1920)
!1935 = !DILocation(line: 359, column: 44, scope: !1920)
!1936 = !DILocation(line: 359, column: 47, scope: !1920)
!1937 = !DILocation(line: 359, column: 52, scope: !1920)
!1938 = !DILocation(line: 359, column: 55, scope: !1920)
!1939 = !DILocation(line: 359, column: 15, scope: !1920)
!1940 = !DILocation(line: 362, column: 12, scope: !1920)
!1941 = !DILocation(line: 363, column: 1, scope: !1920)
!1942 = !DILocation(line: 362, column: 5, scope: !1920)
!1943 = distinct !DISubprogram(name: "aws_byte_cursor_eq_ignore_case", scope: !195, file: !195, line: 365, type: !1921, scopeLine: 365, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1944)
!1944 = !{!1945, !1946, !1947}
!1945 = !DILocalVariable(name: "a", arg: 1, scope: !1943, file: !195, line: 365, type: !149)
!1946 = !DILocalVariable(name: "b", arg: 2, scope: !1943, file: !195, line: 365, type: !149)
!1947 = !DILocalVariable(name: "rv", scope: !1943, file: !195, line: 368, type: !96)
!1948 = !DILocation(line: 365, column: 67, scope: !1943)
!1949 = !DILocation(line: 365, column: 100, scope: !1943)
!1950 = !DILocation(line: 368, column: 5, scope: !1943)
!1951 = !DILocation(line: 368, column: 10, scope: !1943)
!1952 = !DILocation(line: 368, column: 40, scope: !1943)
!1953 = !DILocation(line: 368, column: 43, scope: !1943)
!1954 = !DILocation(line: 368, column: 48, scope: !1943)
!1955 = !DILocation(line: 368, column: 51, scope: !1943)
!1956 = !DILocation(line: 368, column: 56, scope: !1943)
!1957 = !DILocation(line: 368, column: 59, scope: !1943)
!1958 = !DILocation(line: 368, column: 64, scope: !1943)
!1959 = !DILocation(line: 368, column: 67, scope: !1943)
!1960 = !DILocation(line: 368, column: 15, scope: !1943)
!1961 = !DILocation(line: 371, column: 12, scope: !1943)
!1962 = !DILocation(line: 372, column: 1, scope: !1943)
!1963 = !DILocation(line: 371, column: 5, scope: !1943)
!1964 = distinct !DISubprogram(name: "aws_lookup_table_to_lower_get", scope: !195, file: !195, line: 390, type: !1965, scopeLine: 390, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !91)
!1965 = !DISubroutineType(types: !1966)
!1966 = !{!151}
!1967 = !DILocation(line: 391, column: 5, scope: !1964)
!1968 = distinct !DISubprogram(name: "aws_hash_array_ignore_case", scope: !195, file: !195, line: 492, type: !1969, scopeLine: 492, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !1971)
!1969 = !DISubroutineType(types: !1970)
!1970 = !{!189, !121, !945}
!1971 = !{!1972, !1973, !1974, !1976, !1977, !1978, !1979, !1980}
!1972 = !DILocalVariable(name: "array", arg: 1, scope: !1968, file: !195, line: 492, type: !121)
!1973 = !DILocalVariable(name: "len", arg: 2, scope: !1968, file: !195, line: 492, type: !945)
!1974 = !DILocalVariable(name: "fnv_offset_basis", scope: !1968, file: !195, line: 495, type: !1975)
!1975 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !189)
!1976 = !DILocalVariable(name: "fnv_prime", scope: !1968, file: !195, line: 496, type: !1975)
!1977 = !DILocalVariable(name: "i", scope: !1968, file: !195, line: 498, type: !151)
!1978 = !DILocalVariable(name: "end", scope: !1968, file: !195, line: 499, type: !151)
!1979 = !DILocalVariable(name: "hash", scope: !1968, file: !195, line: 501, type: !189)
!1980 = !DILocalVariable(name: "lower", scope: !1981, file: !195, line: 503, type: !152)
!1981 = distinct !DILexicalBlock(scope: !1968, file: !195, line: 502, column: 22)
!1982 = !DILocation(line: 492, column: 49, scope: !1968)
!1983 = !DILocation(line: 492, column: 69, scope: !1968)
!1984 = !DILocation(line: 495, column: 5, scope: !1968)
!1985 = !DILocation(line: 495, column: 20, scope: !1968)
!1986 = !{!1987, !1987, i64 0}
!1987 = !{!"long long", !659, i64 0}
!1988 = !DILocation(line: 496, column: 5, scope: !1968)
!1989 = !DILocation(line: 496, column: 20, scope: !1968)
!1990 = !DILocation(line: 498, column: 5, scope: !1968)
!1991 = !DILocation(line: 498, column: 20, scope: !1968)
!1992 = !DILocation(line: 498, column: 24, scope: !1968)
!1993 = !DILocation(line: 499, column: 5, scope: !1968)
!1994 = !DILocation(line: 499, column: 20, scope: !1968)
!1995 = !DILocation(line: 499, column: 27, scope: !1968)
!1996 = !DILocation(line: 499, column: 29, scope: !1968)
!1997 = !DILocation(line: 499, column: 26, scope: !1968)
!1998 = !DILocation(line: 499, column: 48, scope: !1968)
!1999 = !DILocation(line: 499, column: 52, scope: !1968)
!2000 = !DILocation(line: 499, column: 50, scope: !1968)
!2001 = !DILocation(line: 501, column: 5, scope: !1968)
!2002 = !DILocation(line: 501, column: 14, scope: !1968)
!2003 = !DILocation(line: 502, column: 5, scope: !1968)
!2004 = !DILocation(line: 502, column: 12, scope: !1968)
!2005 = !DILocation(line: 502, column: 17, scope: !1968)
!2006 = !DILocation(line: 502, column: 14, scope: !1968)
!2007 = !DILocation(line: 503, column: 9, scope: !1981)
!2008 = !DILocation(line: 503, column: 23, scope: !1981)
!2009 = !DILocation(line: 503, column: 49, scope: !1981)
!2010 = !DILocation(line: 503, column: 47, scope: !1981)
!2011 = !DILocation(line: 503, column: 31, scope: !1981)
!2012 = !DILocation(line: 504, column: 17, scope: !1981)
!2013 = !DILocation(line: 504, column: 14, scope: !1981)
!2014 = !DILocation(line: 509, column: 14, scope: !1981)
!2015 = !DILocation(line: 513, column: 5, scope: !1968)
!2016 = distinct !{!2016, !2003, !2015}
!2017 = !DILocation(line: 514, column: 12, scope: !1968)
!2018 = !DILocation(line: 515, column: 1, scope: !1968)
!2019 = !DILocation(line: 514, column: 5, scope: !1968)
!2020 = distinct !DISubprogram(name: "aws_hash_byte_cursor_ptr_ignore_case", scope: !195, file: !195, line: 517, type: !522, scopeLine: 517, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2021)
!2021 = !{!2022, !2023, !2025}
!2022 = !DILocalVariable(name: "item", arg: 1, scope: !2020, file: !195, line: 517, type: !121)
!2023 = !DILocalVariable(name: "cursor", scope: !2020, file: !195, line: 519, type: !2024)
!2024 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !149)
!2025 = !DILocalVariable(name: "rval", scope: !2020, file: !195, line: 520, type: !189)
!2026 = !DILocation(line: 517, column: 59, scope: !2020)
!2027 = !DILocation(line: 519, column: 5, scope: !2020)
!2028 = !DILocation(line: 519, column: 41, scope: !2020)
!2029 = !DILocation(line: 519, column: 50, scope: !2020)
!2030 = !DILocation(line: 520, column: 5, scope: !2020)
!2031 = !DILocation(line: 520, column: 14, scope: !2020)
!2032 = !DILocation(line: 520, column: 48, scope: !2020)
!2033 = !DILocation(line: 520, column: 56, scope: !2020)
!2034 = !DILocation(line: 520, column: 61, scope: !2020)
!2035 = !DILocation(line: 520, column: 69, scope: !2020)
!2036 = !DILocation(line: 520, column: 21, scope: !2020)
!2037 = !DILocation(line: 522, column: 12, scope: !2020)
!2038 = !DILocation(line: 523, column: 1, scope: !2020)
!2039 = !DILocation(line: 522, column: 5, scope: !2020)
!2040 = distinct !DISubprogram(name: "aws_byte_cursor_eq_byte_buf", scope: !195, file: !195, line: 525, type: !2041, scopeLine: 525, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2043)
!2041 = !DISubroutineType(types: !2042)
!2042 = !{!96, !2024, !767}
!2043 = !{!2044, !2045, !2046}
!2044 = !DILocalVariable(name: "a", arg: 1, scope: !2040, file: !195, line: 525, type: !2024)
!2045 = !DILocalVariable(name: "b", arg: 2, scope: !2040, file: !195, line: 525, type: !767)
!2046 = !DILocalVariable(name: "rv", scope: !2040, file: !195, line: 528, type: !96)
!2047 = !DILocation(line: 525, column: 70, scope: !2040)
!2048 = !DILocation(line: 525, column: 106, scope: !2040)
!2049 = !DILocation(line: 528, column: 5, scope: !2040)
!2050 = !DILocation(line: 528, column: 10, scope: !2040)
!2051 = !DILocation(line: 528, column: 28, scope: !2040)
!2052 = !DILocation(line: 528, column: 31, scope: !2040)
!2053 = !DILocation(line: 528, column: 36, scope: !2040)
!2054 = !DILocation(line: 528, column: 39, scope: !2040)
!2055 = !DILocation(line: 528, column: 44, scope: !2040)
!2056 = !DILocation(line: 528, column: 47, scope: !2040)
!2057 = !DILocation(line: 528, column: 55, scope: !2040)
!2058 = !DILocation(line: 528, column: 58, scope: !2040)
!2059 = !DILocation(line: 528, column: 15, scope: !2040)
!2060 = !DILocation(line: 531, column: 12, scope: !2040)
!2061 = !DILocation(line: 532, column: 1, scope: !2040)
!2062 = !DILocation(line: 531, column: 5, scope: !2040)
!2063 = distinct !DISubprogram(name: "aws_byte_cursor_eq_byte_buf_ignore_case", scope: !195, file: !195, line: 534, type: !2041, scopeLine: 536, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2064)
!2064 = !{!2065, !2066, !2067}
!2065 = !DILocalVariable(name: "a", arg: 1, scope: !2063, file: !195, line: 535, type: !2024)
!2066 = !DILocalVariable(name: "b", arg: 2, scope: !2063, file: !195, line: 536, type: !767)
!2067 = !DILocalVariable(name: "rv", scope: !2063, file: !195, line: 539, type: !96)
!2068 = !DILocation(line: 535, column: 41, scope: !2063)
!2069 = !DILocation(line: 536, column: 38, scope: !2063)
!2070 = !DILocation(line: 539, column: 5, scope: !2063)
!2071 = !DILocation(line: 539, column: 10, scope: !2063)
!2072 = !DILocation(line: 539, column: 40, scope: !2063)
!2073 = !DILocation(line: 539, column: 43, scope: !2063)
!2074 = !DILocation(line: 539, column: 48, scope: !2063)
!2075 = !DILocation(line: 539, column: 51, scope: !2063)
!2076 = !DILocation(line: 539, column: 56, scope: !2063)
!2077 = !DILocation(line: 539, column: 59, scope: !2063)
!2078 = !DILocation(line: 539, column: 67, scope: !2063)
!2079 = !DILocation(line: 539, column: 70, scope: !2063)
!2080 = !DILocation(line: 539, column: 15, scope: !2063)
!2081 = !DILocation(line: 542, column: 12, scope: !2063)
!2082 = !DILocation(line: 543, column: 1, scope: !2063)
!2083 = !DILocation(line: 542, column: 5, scope: !2063)
!2084 = distinct !DISubprogram(name: "aws_byte_cursor_eq_c_str", scope: !195, file: !195, line: 545, type: !2085, scopeLine: 545, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2087)
!2085 = !DISubroutineType(types: !2086)
!2086 = !{!96, !2024, !1053}
!2087 = !{!2088, !2089, !2090}
!2088 = !DILocalVariable(name: "cursor", arg: 1, scope: !2084, file: !195, line: 545, type: !2024)
!2089 = !DILocalVariable(name: "c_str", arg: 2, scope: !2084, file: !195, line: 545, type: !1053)
!2090 = !DILocalVariable(name: "rv", scope: !2084, file: !195, line: 548, type: !96)
!2091 = !DILocation(line: 545, column: 67, scope: !2084)
!2092 = !DILocation(line: 545, column: 93, scope: !2084)
!2093 = !DILocation(line: 548, column: 5, scope: !2084)
!2094 = !DILocation(line: 548, column: 10, scope: !2084)
!2095 = !DILocation(line: 548, column: 34, scope: !2084)
!2096 = !DILocation(line: 548, column: 42, scope: !2084)
!2097 = !DILocation(line: 548, column: 47, scope: !2084)
!2098 = !DILocation(line: 548, column: 55, scope: !2084)
!2099 = !DILocation(line: 548, column: 60, scope: !2084)
!2100 = !DILocation(line: 548, column: 15, scope: !2084)
!2101 = !DILocation(line: 550, column: 12, scope: !2084)
!2102 = !DILocation(line: 551, column: 1, scope: !2084)
!2103 = !DILocation(line: 550, column: 5, scope: !2084)
!2104 = distinct !DISubprogram(name: "aws_byte_cursor_eq_c_str_ignore_case", scope: !195, file: !195, line: 553, type: !2085, scopeLine: 553, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2105)
!2105 = !{!2106, !2107, !2108}
!2106 = !DILocalVariable(name: "cursor", arg: 1, scope: !2104, file: !195, line: 553, type: !2024)
!2107 = !DILocalVariable(name: "c_str", arg: 2, scope: !2104, file: !195, line: 553, type: !1053)
!2108 = !DILocalVariable(name: "rv", scope: !2104, file: !195, line: 556, type: !96)
!2109 = !DILocation(line: 553, column: 79, scope: !2104)
!2110 = !DILocation(line: 553, column: 105, scope: !2104)
!2111 = !DILocation(line: 556, column: 5, scope: !2104)
!2112 = !DILocation(line: 556, column: 10, scope: !2104)
!2113 = !DILocation(line: 556, column: 46, scope: !2104)
!2114 = !DILocation(line: 556, column: 54, scope: !2104)
!2115 = !DILocation(line: 556, column: 59, scope: !2104)
!2116 = !DILocation(line: 556, column: 67, scope: !2104)
!2117 = !DILocation(line: 556, column: 72, scope: !2104)
!2118 = !DILocation(line: 556, column: 15, scope: !2104)
!2119 = !DILocation(line: 558, column: 12, scope: !2104)
!2120 = !DILocation(line: 559, column: 1, scope: !2104)
!2121 = !DILocation(line: 558, column: 5, scope: !2104)
!2122 = distinct !DISubprogram(name: "aws_byte_buf_append_with_lookup", scope: !195, file: !195, line: 584, type: !2123, scopeLine: 587, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2126)
!2123 = !DISubroutineType(types: !2124)
!2124 = !{!134, !2125, !1429, !151}
!2125 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !112)
!2126 = !{!2127, !2128, !2129, !2130}
!2127 = !DILocalVariable(name: "to", arg: 1, scope: !2122, file: !195, line: 585, type: !2125)
!2128 = !DILocalVariable(name: "from", arg: 2, scope: !2122, file: !195, line: 586, type: !1429)
!2129 = !DILocalVariable(name: "lookup_table", arg: 3, scope: !2122, file: !195, line: 587, type: !151)
!2130 = !DILocalVariable(name: "i", scope: !2131, file: !195, line: 599, type: !73)
!2131 = distinct !DILexicalBlock(scope: !2122, file: !195, line: 599, column: 5)
!2132 = !DILocation(line: 585, column: 39, scope: !2122)
!2133 = !DILocation(line: 586, column: 48, scope: !2122)
!2134 = !DILocation(line: 587, column: 20, scope: !2122)
!2135 = !DILocation(line: 593, column: 9, scope: !2136)
!2136 = distinct !DILexicalBlock(scope: !2122, file: !195, line: 593, column: 9)
!2137 = !DILocation(line: 593, column: 13, scope: !2136)
!2138 = !DILocation(line: 593, column: 24, scope: !2136)
!2139 = !DILocation(line: 593, column: 28, scope: !2136)
!2140 = !DILocation(line: 593, column: 22, scope: !2136)
!2141 = !DILocation(line: 593, column: 34, scope: !2136)
!2142 = !DILocation(line: 593, column: 40, scope: !2136)
!2143 = !DILocation(line: 593, column: 32, scope: !2136)
!2144 = !DILocation(line: 593, column: 9, scope: !2122)
!2145 = !DILocation(line: 596, column: 16, scope: !2146)
!2146 = distinct !DILexicalBlock(scope: !2136, file: !195, line: 593, column: 45)
!2147 = !DILocation(line: 596, column: 9, scope: !2146)
!2148 = !DILocation(line: 599, column: 10, scope: !2131)
!2149 = !DILocation(line: 599, column: 17, scope: !2131)
!2150 = !DILocation(line: 599, column: 24, scope: !2151)
!2151 = distinct !DILexicalBlock(scope: !2131, file: !195, line: 599, column: 5)
!2152 = !DILocation(line: 599, column: 28, scope: !2151)
!2153 = !DILocation(line: 599, column: 34, scope: !2151)
!2154 = !DILocation(line: 599, column: 26, scope: !2151)
!2155 = !DILocation(line: 599, column: 5, scope: !2131)
!2156 = !DILocation(line: 599, column: 5, scope: !2151)
!2157 = !DILocation(line: 600, column: 35, scope: !2158)
!2158 = distinct !DILexicalBlock(scope: !2151, file: !195, line: 599, column: 44)
!2159 = !DILocation(line: 600, column: 48, scope: !2158)
!2160 = !DILocation(line: 600, column: 54, scope: !2158)
!2161 = !DILocation(line: 600, column: 58, scope: !2158)
!2162 = !DILocation(line: 600, column: 9, scope: !2158)
!2163 = !DILocation(line: 600, column: 13, scope: !2158)
!2164 = !DILocation(line: 600, column: 20, scope: !2158)
!2165 = !DILocation(line: 600, column: 24, scope: !2158)
!2166 = !DILocation(line: 600, column: 30, scope: !2158)
!2167 = !DILocation(line: 600, column: 28, scope: !2158)
!2168 = !DILocation(line: 600, column: 33, scope: !2158)
!2169 = !DILocation(line: 601, column: 5, scope: !2158)
!2170 = !DILocation(line: 599, column: 39, scope: !2151)
!2171 = distinct !{!2171, !2155, !2172}
!2172 = !DILocation(line: 601, column: 5, scope: !2131)
!2173 = !DILocation(line: 603, column: 30, scope: !2174)
!2174 = distinct !DILexicalBlock(scope: !2122, file: !195, line: 603, column: 9)
!2175 = !DILocation(line: 603, column: 34, scope: !2174)
!2176 = !DILocation(line: 603, column: 39, scope: !2174)
!2177 = !DILocation(line: 603, column: 45, scope: !2174)
!2178 = !DILocation(line: 603, column: 51, scope: !2174)
!2179 = !DILocation(line: 603, column: 55, scope: !2174)
!2180 = !DILocation(line: 603, column: 9, scope: !2174)
!2181 = !DILocation(line: 603, column: 9, scope: !2122)
!2182 = !DILocation(line: 604, column: 9, scope: !2183)
!2183 = distinct !DILexicalBlock(scope: !2174, file: !195, line: 603, column: 61)
!2184 = !DILocation(line: 609, column: 5, scope: !2122)
!2185 = !DILocation(line: 610, column: 1, scope: !2122)
!2186 = distinct !DISubprogram(name: "aws_byte_buf_append_dynamic", scope: !195, file: !195, line: 713, type: !147, scopeLine: 713, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2187)
!2187 = !{!2188, !2189}
!2188 = !DILocalVariable(name: "to", arg: 1, scope: !2186, file: !195, line: 713, type: !112)
!2189 = !DILocalVariable(name: "from", arg: 2, scope: !2186, file: !195, line: 713, type: !149)
!2190 = !DILocation(line: 713, column: 54, scope: !2186)
!2191 = !DILocation(line: 713, column: 88, scope: !2186)
!2192 = !DILocation(line: 714, column: 42, scope: !2186)
!2193 = !DILocation(line: 714, column: 46, scope: !2186)
!2194 = !DILocation(line: 714, column: 12, scope: !2186)
!2195 = !DILocation(line: 714, column: 5, scope: !2186)
!2196 = distinct !DISubprogram(name: "s_aws_byte_buf_append_dynamic", scope: !195, file: !195, line: 612, type: !2197, scopeLine: 615, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2199)
!2197 = !DISubroutineType(types: !2198)
!2198 = !{!134, !112, !149, !96}
!2199 = !{!2200, !2201, !2202, !2203, !2206, !2207, !2208, !2209}
!2200 = !DILocalVariable(name: "to", arg: 1, scope: !2196, file: !195, line: 613, type: !112)
!2201 = !DILocalVariable(name: "from", arg: 2, scope: !2196, file: !195, line: 614, type: !149)
!2202 = !DILocalVariable(name: "clear_released_memory", arg: 3, scope: !2196, file: !195, line: 615, type: !96)
!2203 = !DILocalVariable(name: "missing_capacity", scope: !2204, file: !195, line: 624, type: !73)
!2204 = distinct !DILexicalBlock(scope: !2205, file: !195, line: 620, column: 45)
!2205 = distinct !DILexicalBlock(scope: !2196, file: !195, line: 620, column: 9)
!2206 = !DILocalVariable(name: "required_capacity", scope: !2204, file: !195, line: 626, type: !73)
!2207 = !DILocalVariable(name: "growth_capacity", scope: !2204, file: !195, line: 638, type: !73)
!2208 = !DILocalVariable(name: "new_capacity", scope: !2204, file: !195, line: 640, type: !73)
!2209 = !DILocalVariable(name: "new_buffer", scope: !2204, file: !195, line: 653, type: !103)
!2210 = !DILocation(line: 613, column: 26, scope: !2196)
!2211 = !DILocation(line: 614, column: 35, scope: !2196)
!2212 = !DILocation(line: 615, column: 10, scope: !2196)
!2213 = !DILocation(line: 618, column: 5, scope: !2196)
!2214 = !DILocation(line: 618, column: 5, scope: !2215)
!2215 = distinct !DILexicalBlock(scope: !2216, file: !195, line: 618, column: 5)
!2216 = distinct !DILexicalBlock(scope: !2196, file: !195, line: 618, column: 5)
!2217 = !DILocation(line: 618, column: 5, scope: !2216)
!2218 = !DILocation(line: 618, column: 5, scope: !2219)
!2219 = distinct !DILexicalBlock(scope: !2215, file: !195, line: 618, column: 5)
!2220 = !DILocation(line: 620, column: 9, scope: !2205)
!2221 = !DILocation(line: 620, column: 13, scope: !2205)
!2222 = !DILocation(line: 620, column: 24, scope: !2205)
!2223 = !DILocation(line: 620, column: 28, scope: !2205)
!2224 = !DILocation(line: 620, column: 22, scope: !2205)
!2225 = !DILocation(line: 620, column: 34, scope: !2205)
!2226 = !DILocation(line: 620, column: 40, scope: !2205)
!2227 = !DILocation(line: 620, column: 32, scope: !2205)
!2228 = !DILocation(line: 620, column: 9, scope: !2196)
!2229 = !DILocation(line: 624, column: 9, scope: !2204)
!2230 = !DILocation(line: 624, column: 16, scope: !2204)
!2231 = !DILocation(line: 624, column: 35, scope: !2204)
!2232 = !DILocation(line: 624, column: 41, scope: !2204)
!2233 = !DILocation(line: 624, column: 48, scope: !2204)
!2234 = !DILocation(line: 624, column: 52, scope: !2204)
!2235 = !DILocation(line: 624, column: 63, scope: !2204)
!2236 = !DILocation(line: 624, column: 67, scope: !2204)
!2237 = !DILocation(line: 624, column: 61, scope: !2204)
!2238 = !DILocation(line: 624, column: 45, scope: !2204)
!2239 = !DILocation(line: 626, column: 9, scope: !2204)
!2240 = !DILocation(line: 626, column: 16, scope: !2204)
!2241 = !DILocation(line: 627, column: 34, scope: !2242)
!2242 = distinct !DILexicalBlock(scope: !2204, file: !195, line: 627, column: 13)
!2243 = !DILocation(line: 627, column: 38, scope: !2242)
!2244 = !DILocation(line: 627, column: 48, scope: !2242)
!2245 = !DILocation(line: 627, column: 13, scope: !2242)
!2246 = !DILocation(line: 627, column: 13, scope: !2204)
!2247 = !DILocation(line: 630, column: 13, scope: !2248)
!2248 = distinct !DILexicalBlock(scope: !2242, file: !195, line: 627, column: 87)
!2249 = !DILocation(line: 638, column: 9, scope: !2204)
!2250 = !DILocation(line: 638, column: 16, scope: !2204)
!2251 = !DILocation(line: 638, column: 58, scope: !2204)
!2252 = !DILocation(line: 638, column: 62, scope: !2204)
!2253 = !DILocation(line: 638, column: 72, scope: !2204)
!2254 = !DILocation(line: 638, column: 76, scope: !2204)
!2255 = !DILocation(line: 638, column: 34, scope: !2204)
!2256 = !DILocation(line: 640, column: 9, scope: !2204)
!2257 = !DILocation(line: 640, column: 16, scope: !2204)
!2258 = !DILocation(line: 640, column: 31, scope: !2204)
!2259 = !DILocation(line: 641, column: 13, scope: !2260)
!2260 = distinct !DILexicalBlock(scope: !2204, file: !195, line: 641, column: 13)
!2261 = !DILocation(line: 641, column: 28, scope: !2260)
!2262 = !DILocation(line: 641, column: 26, scope: !2260)
!2263 = !DILocation(line: 641, column: 13, scope: !2204)
!2264 = !DILocation(line: 642, column: 28, scope: !2265)
!2265 = distinct !DILexicalBlock(scope: !2260, file: !195, line: 641, column: 45)
!2266 = !DILocation(line: 642, column: 26, scope: !2265)
!2267 = !DILocation(line: 643, column: 9, scope: !2265)
!2268 = !DILocation(line: 653, column: 9, scope: !2204)
!2269 = !DILocation(line: 653, column: 18, scope: !2204)
!2270 = !DILocation(line: 653, column: 47, scope: !2204)
!2271 = !DILocation(line: 653, column: 51, scope: !2204)
!2272 = !DILocation(line: 653, column: 62, scope: !2204)
!2273 = !DILocation(line: 653, column: 31, scope: !2204)
!2274 = !DILocation(line: 654, column: 13, scope: !2275)
!2275 = distinct !DILexicalBlock(scope: !2204, file: !195, line: 654, column: 13)
!2276 = !DILocation(line: 654, column: 24, scope: !2275)
!2277 = !DILocation(line: 654, column: 13, scope: !2204)
!2278 = !DILocation(line: 655, column: 17, scope: !2279)
!2279 = distinct !DILexicalBlock(scope: !2280, file: !195, line: 655, column: 17)
!2280 = distinct !DILexicalBlock(scope: !2275, file: !195, line: 654, column: 33)
!2281 = !DILocation(line: 655, column: 32, scope: !2279)
!2282 = !DILocation(line: 655, column: 30, scope: !2279)
!2283 = !DILocation(line: 655, column: 17, scope: !2280)
!2284 = !DILocation(line: 656, column: 32, scope: !2285)
!2285 = distinct !DILexicalBlock(scope: !2279, file: !195, line: 655, column: 51)
!2286 = !DILocation(line: 656, column: 30, scope: !2285)
!2287 = !DILocation(line: 657, column: 46, scope: !2285)
!2288 = !DILocation(line: 657, column: 50, scope: !2285)
!2289 = !DILocation(line: 657, column: 61, scope: !2285)
!2290 = !DILocation(line: 657, column: 30, scope: !2285)
!2291 = !DILocation(line: 657, column: 28, scope: !2285)
!2292 = !DILocation(line: 658, column: 21, scope: !2293)
!2293 = distinct !DILexicalBlock(scope: !2285, file: !195, line: 658, column: 21)
!2294 = !DILocation(line: 658, column: 32, scope: !2293)
!2295 = !DILocation(line: 658, column: 21, scope: !2285)
!2296 = !DILocation(line: 661, column: 21, scope: !2297)
!2297 = distinct !DILexicalBlock(scope: !2293, file: !195, line: 658, column: 41)
!2298 = !DILocation(line: 663, column: 13, scope: !2285)
!2299 = !DILocation(line: 666, column: 17, scope: !2300)
!2300 = distinct !DILexicalBlock(scope: !2279, file: !195, line: 663, column: 20)
!2301 = !DILocation(line: 668, column: 9, scope: !2280)
!2302 = !DILocation(line: 673, column: 13, scope: !2303)
!2303 = distinct !DILexicalBlock(scope: !2204, file: !195, line: 673, column: 13)
!2304 = !DILocation(line: 673, column: 17, scope: !2303)
!2305 = !DILocation(line: 673, column: 21, scope: !2303)
!2306 = !DILocation(line: 673, column: 13, scope: !2204)
!2307 = !DILocation(line: 674, column: 13, scope: !2308)
!2308 = distinct !DILexicalBlock(scope: !2303, file: !195, line: 673, column: 26)
!2309 = !DILocation(line: 675, column: 9, scope: !2308)
!2310 = !DILocation(line: 679, column: 13, scope: !2311)
!2311 = distinct !DILexicalBlock(scope: !2204, file: !195, line: 679, column: 13)
!2312 = !DILocation(line: 679, column: 19, scope: !2311)
!2313 = !DILocation(line: 679, column: 23, scope: !2311)
!2314 = !DILocation(line: 679, column: 13, scope: !2204)
!2315 = !DILocation(line: 680, column: 13, scope: !2316)
!2316 = distinct !DILexicalBlock(scope: !2311, file: !195, line: 679, column: 28)
!2317 = !DILocation(line: 681, column: 9, scope: !2316)
!2318 = !DILocation(line: 683, column: 13, scope: !2319)
!2319 = distinct !DILexicalBlock(scope: !2204, file: !195, line: 683, column: 13)
!2320 = !DILocation(line: 683, column: 13, scope: !2204)
!2321 = !DILocation(line: 684, column: 29, scope: !2322)
!2322 = distinct !DILexicalBlock(scope: !2319, file: !195, line: 683, column: 36)
!2323 = !DILocation(line: 684, column: 33, scope: !2322)
!2324 = !DILocation(line: 684, column: 41, scope: !2322)
!2325 = !DILocation(line: 684, column: 45, scope: !2322)
!2326 = !DILocation(line: 684, column: 13, scope: !2322)
!2327 = !DILocation(line: 685, column: 9, scope: !2322)
!2328 = !DILocation(line: 690, column: 25, scope: !2204)
!2329 = !DILocation(line: 690, column: 29, scope: !2204)
!2330 = !DILocation(line: 690, column: 40, scope: !2204)
!2331 = !DILocation(line: 690, column: 44, scope: !2204)
!2332 = !DILocation(line: 690, column: 9, scope: !2204)
!2333 = !DILocation(line: 695, column: 22, scope: !2204)
!2334 = !DILocation(line: 695, column: 9, scope: !2204)
!2335 = !DILocation(line: 695, column: 13, scope: !2204)
!2336 = !DILocation(line: 695, column: 20, scope: !2204)
!2337 = !DILocation(line: 696, column: 24, scope: !2204)
!2338 = !DILocation(line: 696, column: 9, scope: !2204)
!2339 = !DILocation(line: 696, column: 13, scope: !2204)
!2340 = !DILocation(line: 696, column: 22, scope: !2204)
!2341 = !DILocation(line: 697, column: 5, scope: !2205)
!2342 = !DILocation(line: 697, column: 5, scope: !2204)
!2343 = !DILocation(line: 698, column: 13, scope: !2344)
!2344 = distinct !DILexicalBlock(scope: !2345, file: !195, line: 698, column: 13)
!2345 = distinct !DILexicalBlock(scope: !2205, file: !195, line: 697, column: 12)
!2346 = !DILocation(line: 698, column: 19, scope: !2344)
!2347 = !DILocation(line: 698, column: 23, scope: !2344)
!2348 = !DILocation(line: 698, column: 13, scope: !2345)
!2349 = !DILocation(line: 702, column: 13, scope: !2350)
!2350 = distinct !DILexicalBlock(scope: !2344, file: !195, line: 698, column: 28)
!2351 = !DILocation(line: 703, column: 9, scope: !2350)
!2352 = !DILocation(line: 706, column: 16, scope: !2196)
!2353 = !DILocation(line: 706, column: 22, scope: !2196)
!2354 = !DILocation(line: 706, column: 5, scope: !2196)
!2355 = !DILocation(line: 706, column: 9, scope: !2196)
!2356 = !DILocation(line: 706, column: 13, scope: !2196)
!2357 = !DILocation(line: 710, column: 5, scope: !2196)
!2358 = !DILocation(line: 711, column: 1, scope: !2196)
!2359 = distinct !DISubprogram(name: "aws_add_size_saturating", scope: !1328, file: !1328, line: 112, type: !2360, scopeLine: 112, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2362)
!2360 = !DISubroutineType(types: !2361)
!2361 = !{!73, !73, !73}
!2362 = !{!2363, !2364}
!2363 = !DILocalVariable(name: "a", arg: 1, scope: !2359, file: !1328, line: 112, type: !73)
!2364 = !DILocalVariable(name: "b", arg: 2, scope: !2359, file: !1328, line: 112, type: !73)
!2365 = !DILocation(line: 112, column: 55, scope: !2359)
!2366 = !DILocation(line: 112, column: 65, scope: !2359)
!2367 = !DILocation(line: 114, column: 43, scope: !2359)
!2368 = !DILocation(line: 114, column: 46, scope: !2359)
!2369 = !DILocation(line: 114, column: 20, scope: !2359)
!2370 = !DILocation(line: 114, column: 5, scope: !2359)
!2371 = distinct !DISubprogram(name: "aws_add_u32_saturating", scope: !1405, file: !1405, line: 103, type: !2372, scopeLine: 103, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2374)
!2372 = !DISubroutineType(types: !2373)
!2373 = !{!163, !163, !163}
!2374 = !{!2375, !2376, !2377}
!2375 = !DILocalVariable(name: "a", arg: 1, scope: !2371, file: !1405, line: 103, type: !163)
!2376 = !DILocalVariable(name: "b", arg: 2, scope: !2371, file: !1405, line: 103, type: !163)
!2377 = !DILocalVariable(name: "res", scope: !2371, file: !1405, line: 104, type: !163)
!2378 = !DILocation(line: 103, column: 58, scope: !2371)
!2379 = !DILocation(line: 103, column: 70, scope: !2371)
!2380 = !DILocation(line: 104, column: 5, scope: !2371)
!2381 = !DILocation(line: 104, column: 14, scope: !2371)
!2382 = !DILocation(line: 106, column: 32, scope: !2383)
!2383 = distinct !DILexicalBlock(scope: !2371, file: !1405, line: 106, column: 9)
!2384 = !DILocation(line: 106, column: 35, scope: !2383)
!2385 = !DILocation(line: 106, column: 9, scope: !2383)
!2386 = !DILocation(line: 106, column: 9, scope: !2371)
!2387 = !DILocation(line: 107, column: 13, scope: !2388)
!2388 = distinct !DILexicalBlock(scope: !2383, file: !1405, line: 106, column: 45)
!2389 = !DILocation(line: 108, column: 5, scope: !2388)
!2390 = !DILocation(line: 110, column: 12, scope: !2371)
!2391 = !DILocation(line: 111, column: 1, scope: !2371)
!2392 = !DILocation(line: 110, column: 5, scope: !2371)
!2393 = distinct !DISubprogram(name: "aws_byte_buf_append_dynamic_secure", scope: !195, file: !195, line: 717, type: !147, scopeLine: 717, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2394)
!2394 = !{!2395, !2396}
!2395 = !DILocalVariable(name: "to", arg: 1, scope: !2393, file: !195, line: 717, type: !112)
!2396 = !DILocalVariable(name: "from", arg: 2, scope: !2393, file: !195, line: 717, type: !149)
!2397 = !DILocation(line: 717, column: 61, scope: !2393)
!2398 = !DILocation(line: 717, column: 95, scope: !2393)
!2399 = !DILocation(line: 718, column: 42, scope: !2393)
!2400 = !DILocation(line: 718, column: 46, scope: !2393)
!2401 = !DILocation(line: 718, column: 12, scope: !2393)
!2402 = !DILocation(line: 718, column: 5, scope: !2393)
!2403 = distinct !DISubprogram(name: "aws_byte_buf_append_byte_dynamic", scope: !195, file: !195, line: 737, type: !2404, scopeLine: 737, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2406)
!2404 = !DISubroutineType(types: !2405)
!2405 = !{!134, !112, !104}
!2406 = !{!2407, !2408}
!2407 = !DILocalVariable(name: "buffer", arg: 1, scope: !2403, file: !195, line: 737, type: !112)
!2408 = !DILocalVariable(name: "value", arg: 2, scope: !2403, file: !195, line: 737, type: !104)
!2409 = !DILocation(line: 737, column: 59, scope: !2403)
!2410 = !DILocation(line: 737, column: 75, scope: !2403)
!2411 = !DILocation(line: 738, column: 47, scope: !2403)
!2412 = !DILocation(line: 738, column: 55, scope: !2403)
!2413 = !DILocation(line: 738, column: 12, scope: !2403)
!2414 = !DILocation(line: 738, column: 5, scope: !2403)
!2415 = distinct !DISubprogram(name: "s_aws_byte_buf_append_byte_dynamic", scope: !195, file: !195, line: 721, type: !2416, scopeLine: 721, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2418)
!2416 = !DISubroutineType(types: !2417)
!2417 = !{!134, !112, !104, !96}
!2418 = !{!2419, !2420, !2421, !2422}
!2419 = !DILocalVariable(name: "buffer", arg: 1, scope: !2415, file: !195, line: 721, type: !112)
!2420 = !DILocalVariable(name: "value", arg: 2, scope: !2415, file: !195, line: 721, type: !104)
!2421 = !DILocalVariable(name: "clear_released_memory", arg: 3, scope: !2415, file: !195, line: 721, type: !96)
!2422 = !DILocalVariable(name: "eq_cursor", scope: !2415, file: !195, line: 728, type: !136)
!2423 = !DILocation(line: 721, column: 68, scope: !2415)
!2424 = !DILocation(line: 721, column: 84, scope: !2415)
!2425 = !DILocation(line: 721, column: 96, scope: !2415)
!2426 = !DILocation(line: 728, column: 5, scope: !2415)
!2427 = !DILocation(line: 728, column: 28, scope: !2415)
!2428 = !DILocation(line: 728, column: 40, scope: !2415)
!2429 = !DILocation(line: 734, column: 42, scope: !2415)
!2430 = !DILocation(line: 734, column: 62, scope: !2415)
!2431 = !DILocation(line: 734, column: 12, scope: !2415)
!2432 = !DILocation(line: 735, column: 1, scope: !2415)
!2433 = !DILocation(line: 734, column: 5, scope: !2415)
!2434 = distinct !DISubprogram(name: "aws_byte_buf_append_byte_dynamic_secure", scope: !195, file: !195, line: 741, type: !2404, scopeLine: 741, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2435)
!2435 = !{!2436, !2437}
!2436 = !DILocalVariable(name: "buffer", arg: 1, scope: !2434, file: !195, line: 741, type: !112)
!2437 = !DILocalVariable(name: "value", arg: 2, scope: !2434, file: !195, line: 741, type: !104)
!2438 = !DILocation(line: 741, column: 66, scope: !2434)
!2439 = !DILocation(line: 741, column: 82, scope: !2434)
!2440 = !DILocation(line: 742, column: 47, scope: !2434)
!2441 = !DILocation(line: 742, column: 55, scope: !2434)
!2442 = !DILocation(line: 742, column: 12, scope: !2434)
!2443 = !DILocation(line: 742, column: 5, scope: !2434)
!2444 = distinct !DISubprogram(name: "aws_byte_buf_reserve", scope: !195, file: !195, line: 745, type: !2445, scopeLine: 745, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2447)
!2445 = !DISubroutineType(types: !2446)
!2446 = !{!134, !112, !73}
!2447 = !{!2448, !2449}
!2448 = !DILocalVariable(name: "buffer", arg: 1, scope: !2444, file: !195, line: 745, type: !112)
!2449 = !DILocalVariable(name: "requested_capacity", arg: 2, scope: !2444, file: !195, line: 745, type: !73)
!2450 = !DILocation(line: 745, column: 47, scope: !2444)
!2451 = !DILocation(line: 745, column: 62, scope: !2444)
!2452 = !DILocation(line: 746, column: 5, scope: !2444)
!2453 = !DILocation(line: 746, column: 5, scope: !2454)
!2454 = distinct !DILexicalBlock(scope: !2455, file: !195, line: 746, column: 5)
!2455 = distinct !DILexicalBlock(scope: !2444, file: !195, line: 746, column: 5)
!2456 = !DILocation(line: 746, column: 5, scope: !2455)
!2457 = !DILocation(line: 746, column: 5, scope: !2458)
!2458 = distinct !DILexicalBlock(scope: !2454, file: !195, line: 746, column: 5)
!2459 = !DILocation(line: 747, column: 5, scope: !2444)
!2460 = !DILocation(line: 747, column: 5, scope: !2461)
!2461 = distinct !DILexicalBlock(scope: !2462, file: !195, line: 747, column: 5)
!2462 = distinct !DILexicalBlock(scope: !2444, file: !195, line: 747, column: 5)
!2463 = !DILocation(line: 747, column: 5, scope: !2462)
!2464 = !DILocation(line: 747, column: 5, scope: !2465)
!2465 = distinct !DILexicalBlock(scope: !2461, file: !195, line: 747, column: 5)
!2466 = !DILocation(line: 749, column: 9, scope: !2467)
!2467 = distinct !DILexicalBlock(scope: !2444, file: !195, line: 749, column: 9)
!2468 = !DILocation(line: 749, column: 31, scope: !2467)
!2469 = !DILocation(line: 749, column: 39, scope: !2467)
!2470 = !DILocation(line: 749, column: 28, scope: !2467)
!2471 = !DILocation(line: 749, column: 9, scope: !2444)
!2472 = !DILocation(line: 751, column: 9, scope: !2473)
!2473 = distinct !DILexicalBlock(scope: !2467, file: !195, line: 749, column: 49)
!2474 = !DILocation(line: 754, column: 25, scope: !2475)
!2475 = distinct !DILexicalBlock(scope: !2444, file: !195, line: 754, column: 9)
!2476 = !DILocation(line: 754, column: 33, scope: !2475)
!2477 = !DILocation(line: 754, column: 54, scope: !2475)
!2478 = !DILocation(line: 754, column: 62, scope: !2475)
!2479 = !DILocation(line: 754, column: 70, scope: !2475)
!2480 = !DILocation(line: 754, column: 78, scope: !2475)
!2481 = !DILocation(line: 754, column: 88, scope: !2475)
!2482 = !DILocation(line: 754, column: 9, scope: !2475)
!2483 = !DILocation(line: 754, column: 9, scope: !2444)
!2484 = !DILocation(line: 755, column: 9, scope: !2485)
!2485 = distinct !DILexicalBlock(scope: !2475, file: !195, line: 754, column: 109)
!2486 = !DILocation(line: 758, column: 24, scope: !2444)
!2487 = !DILocation(line: 758, column: 5, scope: !2444)
!2488 = !DILocation(line: 758, column: 13, scope: !2444)
!2489 = !DILocation(line: 758, column: 22, scope: !2444)
!2490 = !DILocation(line: 761, column: 5, scope: !2444)
!2491 = !DILocation(line: 762, column: 1, scope: !2444)
!2492 = distinct !DISubprogram(name: "aws_byte_buf_reserve_relative", scope: !195, file: !195, line: 764, type: !2445, scopeLine: 764, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2493)
!2493 = !{!2494, !2495, !2496}
!2494 = !DILocalVariable(name: "buffer", arg: 1, scope: !2492, file: !195, line: 764, type: !112)
!2495 = !DILocalVariable(name: "additional_length", arg: 2, scope: !2492, file: !195, line: 764, type: !73)
!2496 = !DILocalVariable(name: "requested_capacity", scope: !2492, file: !195, line: 768, type: !73)
!2497 = !DILocation(line: 764, column: 56, scope: !2492)
!2498 = !DILocation(line: 764, column: 71, scope: !2492)
!2499 = !DILocation(line: 765, column: 5, scope: !2492)
!2500 = !DILocation(line: 765, column: 5, scope: !2501)
!2501 = distinct !DILexicalBlock(scope: !2502, file: !195, line: 765, column: 5)
!2502 = distinct !DILexicalBlock(scope: !2492, file: !195, line: 765, column: 5)
!2503 = !DILocation(line: 765, column: 5, scope: !2502)
!2504 = !DILocation(line: 765, column: 5, scope: !2505)
!2505 = distinct !DILexicalBlock(scope: !2501, file: !195, line: 765, column: 5)
!2506 = !DILocation(line: 766, column: 5, scope: !2492)
!2507 = !DILocation(line: 766, column: 5, scope: !2508)
!2508 = distinct !DILexicalBlock(scope: !2509, file: !195, line: 766, column: 5)
!2509 = distinct !DILexicalBlock(scope: !2492, file: !195, line: 766, column: 5)
!2510 = !DILocation(line: 766, column: 5, scope: !2509)
!2511 = !DILocation(line: 766, column: 5, scope: !2512)
!2512 = distinct !DILexicalBlock(scope: !2508, file: !195, line: 766, column: 5)
!2513 = !DILocation(line: 768, column: 5, scope: !2492)
!2514 = !DILocation(line: 768, column: 12, scope: !2492)
!2515 = !DILocation(line: 769, column: 9, scope: !2516)
!2516 = distinct !DILexicalBlock(scope: !2492, file: !195, line: 769, column: 9)
!2517 = !DILocation(line: 769, column: 9, scope: !2492)
!2518 = !DILocation(line: 771, column: 9, scope: !2519)
!2519 = distinct !DILexicalBlock(scope: !2516, file: !195, line: 769, column: 98)
!2520 = !DILocation(line: 774, column: 33, scope: !2492)
!2521 = !DILocation(line: 774, column: 41, scope: !2492)
!2522 = !DILocation(line: 774, column: 12, scope: !2492)
!2523 = !DILocation(line: 774, column: 5, scope: !2492)
!2524 = !DILocation(line: 775, column: 1, scope: !2492)
!2525 = distinct !DISubprogram(name: "aws_byte_cursor_right_trim_pred", scope: !195, file: !195, line: 777, type: !2526, scopeLine: 779, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2532)
!2526 = !DISubroutineType(types: !2527)
!2527 = !{!136, !149, !2528}
!2528 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !2529, size: 32)
!2529 = !DIDerivedType(tag: DW_TAG_typedef, name: "aws_byte_predicate_fn", file: !93, line: 67, baseType: !2530)
!2530 = !DISubroutineType(types: !2531)
!2531 = !{!96, !104}
!2532 = !{!2533, !2534, !2535}
!2533 = !DILocalVariable(name: "source", arg: 1, scope: !2525, file: !195, line: 778, type: !149)
!2534 = !DILocalVariable(name: "predicate", arg: 2, scope: !2525, file: !195, line: 779, type: !2528)
!2535 = !DILocalVariable(name: "trimmed", scope: !2525, file: !195, line: 782, type: !136)
!2536 = !DILocation(line: 778, column: 35, scope: !2525)
!2537 = !DILocation(line: 779, column: 28, scope: !2525)
!2538 = !DILocation(line: 782, column: 28, scope: !2525)
!2539 = !DILocation(line: 782, column: 39, scope: !2525)
!2540 = !DILocation(line: 782, column: 38, scope: !2525)
!2541 = !DILocation(line: 784, column: 5, scope: !2525)
!2542 = !DILocation(line: 784, column: 20, scope: !2525)
!2543 = !DILocation(line: 784, column: 24, scope: !2525)
!2544 = !DILocation(line: 784, column: 28, scope: !2525)
!2545 = !DILocation(line: 784, column: 31, scope: !2525)
!2546 = !DILocation(line: 784, column: 51, scope: !2525)
!2547 = !DILocation(line: 784, column: 65, scope: !2525)
!2548 = !DILocation(line: 784, column: 55, scope: !2525)
!2549 = !DILocation(line: 784, column: 69, scope: !2525)
!2550 = !DILocation(line: 784, column: 41, scope: !2525)
!2551 = !DILocation(line: 0, scope: !2525)
!2552 = !DILocation(line: 785, column: 19, scope: !2553)
!2553 = distinct !DILexicalBlock(scope: !2525, file: !195, line: 784, column: 76)
!2554 = !DILocation(line: 785, column: 9, scope: !2553)
!2555 = distinct !{!2555, !2541, !2556}
!2556 = !DILocation(line: 786, column: 5, scope: !2525)
!2557 = !DILocation(line: 789, column: 5, scope: !2525)
!2558 = distinct !DISubprogram(name: "aws_byte_cursor_left_trim_pred", scope: !195, file: !195, line: 792, type: !2526, scopeLine: 794, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2559)
!2559 = !{!2560, !2561, !2562}
!2560 = !DILocalVariable(name: "source", arg: 1, scope: !2558, file: !195, line: 793, type: !149)
!2561 = !DILocalVariable(name: "predicate", arg: 2, scope: !2558, file: !195, line: 794, type: !2528)
!2562 = !DILocalVariable(name: "trimmed", scope: !2558, file: !195, line: 797, type: !136)
!2563 = !DILocation(line: 793, column: 35, scope: !2558)
!2564 = !DILocation(line: 794, column: 28, scope: !2558)
!2565 = !DILocation(line: 797, column: 28, scope: !2558)
!2566 = !DILocation(line: 797, column: 39, scope: !2558)
!2567 = !DILocation(line: 797, column: 38, scope: !2558)
!2568 = !DILocation(line: 799, column: 5, scope: !2558)
!2569 = !DILocation(line: 799, column: 20, scope: !2558)
!2570 = !DILocation(line: 799, column: 24, scope: !2558)
!2571 = !DILocation(line: 799, column: 28, scope: !2558)
!2572 = !DILocation(line: 799, column: 31, scope: !2558)
!2573 = !DILocation(line: 799, column: 51, scope: !2558)
!2574 = !DILocation(line: 799, column: 41, scope: !2558)
!2575 = !DILocation(line: 0, scope: !2558)
!2576 = !DILocation(line: 800, column: 19, scope: !2577)
!2577 = distinct !DILexicalBlock(scope: !2558, file: !195, line: 799, column: 58)
!2578 = !DILocation(line: 800, column: 9, scope: !2577)
!2579 = !DILocation(line: 801, column: 19, scope: !2577)
!2580 = !DILocation(line: 801, column: 9, scope: !2577)
!2581 = distinct !{!2581, !2568, !2582}
!2582 = !DILocation(line: 802, column: 5, scope: !2558)
!2583 = !DILocation(line: 805, column: 5, scope: !2558)
!2584 = distinct !DISubprogram(name: "aws_byte_cursor_trim_pred", scope: !195, file: !195, line: 808, type: !2526, scopeLine: 810, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2585)
!2585 = !{!2586, !2587, !2588, !2589}
!2586 = !DILocalVariable(name: "source", arg: 1, scope: !2584, file: !195, line: 809, type: !149)
!2587 = !DILocalVariable(name: "predicate", arg: 2, scope: !2584, file: !195, line: 810, type: !2528)
!2588 = !DILocalVariable(name: "left_trimmed", scope: !2584, file: !195, line: 813, type: !136)
!2589 = !DILocalVariable(name: "dest", scope: !2584, file: !195, line: 814, type: !136)
!2590 = !DILocation(line: 809, column: 35, scope: !2584)
!2591 = !DILocation(line: 810, column: 28, scope: !2584)
!2592 = !DILocation(line: 813, column: 5, scope: !2584)
!2593 = !DILocation(line: 813, column: 28, scope: !2584)
!2594 = !DILocation(line: 813, column: 74, scope: !2584)
!2595 = !DILocation(line: 813, column: 82, scope: !2584)
!2596 = !DILocation(line: 813, column: 43, scope: !2584)
!2597 = !DILocation(line: 814, column: 28, scope: !2584)
!2598 = !DILocation(line: 814, column: 82, scope: !2584)
!2599 = !DILocation(line: 814, column: 35, scope: !2584)
!2600 = !DILocation(line: 818, column: 1, scope: !2584)
!2601 = distinct !DISubprogram(name: "aws_byte_cursor_satisfies_pred", scope: !195, file: !195, line: 820, type: !2602, scopeLine: 820, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2604)
!2602 = !DISubroutineType(types: !2603)
!2603 = !{!96, !149, !2528}
!2604 = !{!2605, !2606, !2607, !2608}
!2605 = !DILocalVariable(name: "source", arg: 1, scope: !2601, file: !195, line: 820, type: !149)
!2606 = !DILocalVariable(name: "predicate", arg: 2, scope: !2601, file: !195, line: 820, type: !2528)
!2607 = !DILocalVariable(name: "trimmed", scope: !2601, file: !195, line: 821, type: !136)
!2608 = !DILocalVariable(name: "rval", scope: !2601, file: !195, line: 822, type: !96)
!2609 = !DILocation(line: 820, column: 67, scope: !2601)
!2610 = !DILocation(line: 820, column: 98, scope: !2601)
!2611 = !DILocation(line: 821, column: 5, scope: !2601)
!2612 = !DILocation(line: 821, column: 28, scope: !2601)
!2613 = !DILocation(line: 821, column: 69, scope: !2601)
!2614 = !DILocation(line: 821, column: 77, scope: !2601)
!2615 = !DILocation(line: 821, column: 38, scope: !2601)
!2616 = !DILocation(line: 822, column: 5, scope: !2601)
!2617 = !DILocation(line: 822, column: 10, scope: !2601)
!2618 = !DILocation(line: 822, column: 26, scope: !2601)
!2619 = !DILocation(line: 822, column: 30, scope: !2601)
!2620 = !DILocation(line: 824, column: 12, scope: !2601)
!2621 = !DILocation(line: 825, column: 1, scope: !2601)
!2622 = !DILocation(line: 824, column: 5, scope: !2601)
!2623 = distinct !DISubprogram(name: "aws_byte_cursor_compare_lexical", scope: !195, file: !195, line: 827, type: !2624, scopeLine: 827, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2626)
!2624 = !DISubroutineType(types: !2625)
!2625 = !{!134, !149, !149}
!2626 = !{!2627, !2628, !2629, !2630}
!2627 = !DILocalVariable(name: "lhs", arg: 1, scope: !2623, file: !195, line: 827, type: !149)
!2628 = !DILocalVariable(name: "rhs", arg: 2, scope: !2623, file: !195, line: 827, type: !149)
!2629 = !DILocalVariable(name: "comparison_length", scope: !2623, file: !195, line: 833, type: !73)
!2630 = !DILocalVariable(name: "result", scope: !2623, file: !195, line: 838, type: !134)
!2631 = !DILocation(line: 827, column: 67, scope: !2623)
!2632 = !DILocation(line: 827, column: 102, scope: !2623)
!2633 = !DILocation(line: 833, column: 5, scope: !2623)
!2634 = !DILocation(line: 833, column: 12, scope: !2623)
!2635 = !DILocation(line: 833, column: 32, scope: !2623)
!2636 = !DILocation(line: 833, column: 37, scope: !2623)
!2637 = !DILocation(line: 834, column: 9, scope: !2638)
!2638 = distinct !DILexicalBlock(scope: !2623, file: !195, line: 834, column: 9)
!2639 = !DILocation(line: 834, column: 29, scope: !2638)
!2640 = !DILocation(line: 834, column: 34, scope: !2638)
!2641 = !DILocation(line: 834, column: 27, scope: !2638)
!2642 = !DILocation(line: 834, column: 9, scope: !2623)
!2643 = !DILocation(line: 835, column: 29, scope: !2644)
!2644 = distinct !DILexicalBlock(scope: !2638, file: !195, line: 834, column: 39)
!2645 = !DILocation(line: 835, column: 34, scope: !2644)
!2646 = !DILocation(line: 835, column: 27, scope: !2644)
!2647 = !DILocation(line: 836, column: 5, scope: !2644)
!2648 = !DILocation(line: 838, column: 5, scope: !2623)
!2649 = !DILocation(line: 838, column: 9, scope: !2623)
!2650 = !DILocation(line: 838, column: 25, scope: !2623)
!2651 = !DILocation(line: 838, column: 30, scope: !2623)
!2652 = !DILocation(line: 838, column: 35, scope: !2623)
!2653 = !DILocation(line: 838, column: 40, scope: !2623)
!2654 = !DILocation(line: 838, column: 45, scope: !2623)
!2655 = !DILocation(line: 838, column: 18, scope: !2623)
!2656 = !DILocation(line: 842, column: 9, scope: !2657)
!2657 = distinct !DILexicalBlock(scope: !2623, file: !195, line: 842, column: 9)
!2658 = !DILocation(line: 842, column: 16, scope: !2657)
!2659 = !DILocation(line: 842, column: 9, scope: !2623)
!2660 = !DILocation(line: 843, column: 16, scope: !2661)
!2661 = distinct !DILexicalBlock(scope: !2657, file: !195, line: 842, column: 22)
!2662 = !DILocation(line: 843, column: 9, scope: !2661)
!2663 = !DILocation(line: 846, column: 9, scope: !2664)
!2664 = distinct !DILexicalBlock(scope: !2623, file: !195, line: 846, column: 9)
!2665 = !DILocation(line: 846, column: 14, scope: !2664)
!2666 = !DILocation(line: 846, column: 21, scope: !2664)
!2667 = !DILocation(line: 846, column: 26, scope: !2664)
!2668 = !DILocation(line: 846, column: 18, scope: !2664)
!2669 = !DILocation(line: 846, column: 9, scope: !2623)
!2670 = !DILocation(line: 847, column: 16, scope: !2671)
!2671 = distinct !DILexicalBlock(scope: !2664, file: !195, line: 846, column: 31)
!2672 = !DILocation(line: 847, column: 37, scope: !2671)
!2673 = !DILocation(line: 847, column: 42, scope: !2671)
!2674 = !DILocation(line: 847, column: 34, scope: !2671)
!2675 = !DILocation(line: 847, column: 9, scope: !2671)
!2676 = !DILocation(line: 850, column: 5, scope: !2623)
!2677 = !DILocation(line: 851, column: 1, scope: !2623)
!2678 = distinct !DISubprogram(name: "aws_byte_cursor_compare_lookup", scope: !195, file: !195, line: 853, type: !2679, scopeLine: 856, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2681)
!2679 = !DISubroutineType(types: !2680)
!2680 = !{!134, !149, !149, !151}
!2681 = !{!2682, !2683, !2684, !2685, !2686, !2687, !2688, !2689, !2691}
!2682 = !DILocalVariable(name: "lhs", arg: 1, scope: !2678, file: !195, line: 854, type: !149)
!2683 = !DILocalVariable(name: "rhs", arg: 2, scope: !2678, file: !195, line: 855, type: !149)
!2684 = !DILocalVariable(name: "lookup_table", arg: 3, scope: !2678, file: !195, line: 856, type: !151)
!2685 = !DILocalVariable(name: "lhs_curr", scope: !2678, file: !195, line: 867, type: !151)
!2686 = !DILocalVariable(name: "lhs_end", scope: !2678, file: !195, line: 868, type: !151)
!2687 = !DILocalVariable(name: "rhs_curr", scope: !2678, file: !195, line: 870, type: !151)
!2688 = !DILocalVariable(name: "rhs_end", scope: !2678, file: !195, line: 871, type: !151)
!2689 = !DILocalVariable(name: "lhc", scope: !2690, file: !195, line: 874, type: !104)
!2690 = distinct !DILexicalBlock(scope: !2678, file: !195, line: 873, column: 54)
!2691 = !DILocalVariable(name: "rhc", scope: !2690, file: !195, line: 875, type: !104)
!2692 = !DILocation(line: 854, column: 35, scope: !2678)
!2693 = !DILocation(line: 855, column: 35, scope: !2678)
!2694 = !DILocation(line: 856, column: 20, scope: !2678)
!2695 = !DILocation(line: 860, column: 9, scope: !2696)
!2696 = distinct !DILexicalBlock(scope: !2678, file: !195, line: 860, column: 9)
!2697 = !DILocation(line: 860, column: 14, scope: !2696)
!2698 = !DILocation(line: 860, column: 18, scope: !2696)
!2699 = !DILocation(line: 860, column: 23, scope: !2696)
!2700 = !DILocation(line: 860, column: 26, scope: !2696)
!2701 = !DILocation(line: 860, column: 31, scope: !2696)
!2702 = !DILocation(line: 860, column: 35, scope: !2696)
!2703 = !DILocation(line: 860, column: 9, scope: !2678)
!2704 = !DILocation(line: 861, column: 9, scope: !2705)
!2705 = distinct !DILexicalBlock(scope: !2696, file: !195, line: 860, column: 41)
!2706 = !DILocation(line: 862, column: 16, scope: !2707)
!2707 = distinct !DILexicalBlock(scope: !2696, file: !195, line: 862, column: 16)
!2708 = !DILocation(line: 862, column: 21, scope: !2707)
!2709 = !DILocation(line: 862, column: 25, scope: !2707)
!2710 = !DILocation(line: 862, column: 16, scope: !2696)
!2711 = !DILocation(line: 863, column: 9, scope: !2712)
!2712 = distinct !DILexicalBlock(scope: !2707, file: !195, line: 862, column: 31)
!2713 = !DILocation(line: 864, column: 16, scope: !2714)
!2714 = distinct !DILexicalBlock(scope: !2707, file: !195, line: 864, column: 16)
!2715 = !DILocation(line: 864, column: 21, scope: !2714)
!2716 = !DILocation(line: 864, column: 25, scope: !2714)
!2717 = !DILocation(line: 864, column: 16, scope: !2707)
!2718 = !DILocation(line: 865, column: 9, scope: !2719)
!2719 = distinct !DILexicalBlock(scope: !2714, file: !195, line: 864, column: 31)
!2720 = !DILocation(line: 867, column: 5, scope: !2678)
!2721 = !DILocation(line: 867, column: 20, scope: !2678)
!2722 = !DILocation(line: 867, column: 31, scope: !2678)
!2723 = !DILocation(line: 867, column: 36, scope: !2678)
!2724 = !DILocation(line: 868, column: 5, scope: !2678)
!2725 = !DILocation(line: 868, column: 20, scope: !2678)
!2726 = !DILocation(line: 868, column: 30, scope: !2678)
!2727 = !DILocation(line: 868, column: 41, scope: !2678)
!2728 = !DILocation(line: 868, column: 46, scope: !2678)
!2729 = !DILocation(line: 868, column: 39, scope: !2678)
!2730 = !DILocation(line: 870, column: 5, scope: !2678)
!2731 = !DILocation(line: 870, column: 20, scope: !2678)
!2732 = !DILocation(line: 870, column: 31, scope: !2678)
!2733 = !DILocation(line: 870, column: 36, scope: !2678)
!2734 = !DILocation(line: 871, column: 5, scope: !2678)
!2735 = !DILocation(line: 871, column: 20, scope: !2678)
!2736 = !DILocation(line: 871, column: 30, scope: !2678)
!2737 = !DILocation(line: 871, column: 41, scope: !2678)
!2738 = !DILocation(line: 871, column: 46, scope: !2678)
!2739 = !DILocation(line: 871, column: 39, scope: !2678)
!2740 = !DILocation(line: 873, column: 5, scope: !2678)
!2741 = !DILocation(line: 873, column: 12, scope: !2678)
!2742 = !DILocation(line: 873, column: 23, scope: !2678)
!2743 = !DILocation(line: 873, column: 21, scope: !2678)
!2744 = !DILocation(line: 873, column: 31, scope: !2678)
!2745 = !DILocation(line: 873, column: 34, scope: !2678)
!2746 = !DILocation(line: 873, column: 45, scope: !2678)
!2747 = !DILocation(line: 873, column: 43, scope: !2678)
!2748 = !DILocation(line: 0, scope: !2678)
!2749 = !DILocation(line: 874, column: 9, scope: !2690)
!2750 = !DILocation(line: 874, column: 17, scope: !2690)
!2751 = !DILocation(line: 874, column: 23, scope: !2690)
!2752 = !DILocation(line: 874, column: 37, scope: !2690)
!2753 = !DILocation(line: 874, column: 36, scope: !2690)
!2754 = !DILocation(line: 875, column: 9, scope: !2690)
!2755 = !DILocation(line: 875, column: 17, scope: !2690)
!2756 = !DILocation(line: 875, column: 23, scope: !2690)
!2757 = !DILocation(line: 875, column: 37, scope: !2690)
!2758 = !DILocation(line: 875, column: 36, scope: !2690)
!2759 = !DILocation(line: 879, column: 13, scope: !2760)
!2760 = distinct !DILexicalBlock(scope: !2690, file: !195, line: 879, column: 13)
!2761 = !DILocation(line: 879, column: 19, scope: !2760)
!2762 = !DILocation(line: 879, column: 17, scope: !2760)
!2763 = !DILocation(line: 879, column: 13, scope: !2690)
!2764 = !DILocation(line: 880, column: 13, scope: !2765)
!2765 = distinct !DILexicalBlock(scope: !2760, file: !195, line: 879, column: 24)
!2766 = !DILocation(line: 883, column: 13, scope: !2767)
!2767 = distinct !DILexicalBlock(scope: !2690, file: !195, line: 883, column: 13)
!2768 = !DILocation(line: 883, column: 19, scope: !2767)
!2769 = !DILocation(line: 883, column: 17, scope: !2767)
!2770 = !DILocation(line: 883, column: 13, scope: !2690)
!2771 = !DILocation(line: 884, column: 13, scope: !2772)
!2772 = distinct !DILexicalBlock(scope: !2767, file: !195, line: 883, column: 24)
!2773 = !DILocation(line: 887, column: 17, scope: !2690)
!2774 = !DILocation(line: 888, column: 17, scope: !2690)
!2775 = !DILocation(line: 889, column: 5, scope: !2678)
!2776 = distinct !{!2776, !2740, !2775}
!2777 = !DILocation(line: 893, column: 9, scope: !2778)
!2778 = distinct !DILexicalBlock(scope: !2678, file: !195, line: 893, column: 9)
!2779 = !DILocation(line: 893, column: 20, scope: !2778)
!2780 = !DILocation(line: 893, column: 18, scope: !2778)
!2781 = !DILocation(line: 893, column: 9, scope: !2678)
!2782 = !DILocation(line: 894, column: 9, scope: !2783)
!2783 = distinct !DILexicalBlock(scope: !2778, file: !195, line: 893, column: 29)
!2784 = !DILocation(line: 897, column: 9, scope: !2785)
!2785 = distinct !DILexicalBlock(scope: !2678, file: !195, line: 897, column: 9)
!2786 = !DILocation(line: 897, column: 20, scope: !2785)
!2787 = !DILocation(line: 897, column: 18, scope: !2785)
!2788 = !DILocation(line: 897, column: 9, scope: !2678)
!2789 = !DILocation(line: 898, column: 9, scope: !2790)
!2790 = distinct !DILexicalBlock(scope: !2785, file: !195, line: 897, column: 29)
!2791 = !DILocation(line: 901, column: 5, scope: !2678)
!2792 = !DILocation(line: 902, column: 1, scope: !2678)
!2793 = distinct !DISubprogram(name: "aws_byte_buf_from_c_str", scope: !195, file: !195, line: 907, type: !2794, scopeLine: 907, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2796)
!2794 = !DISubroutineType(types: !2795)
!2795 = !{!99, !127}
!2796 = !{!2797, !2798}
!2797 = !DILocalVariable(name: "c_str", arg: 1, scope: !2793, file: !195, line: 907, type: !127)
!2798 = !DILocalVariable(name: "buf", scope: !2793, file: !195, line: 908, type: !99)
!2799 = !DILocation(line: 907, column: 57, scope: !2793)
!2800 = !DILocation(line: 908, column: 25, scope: !2793)
!2801 = !DILocation(line: 909, column: 17, scope: !2793)
!2802 = !DILocation(line: 909, column: 15, scope: !2793)
!2803 = !DILocation(line: 909, column: 37, scope: !2793)
!2804 = !DILocation(line: 909, column: 30, scope: !2793)
!2805 = !DILocation(line: 909, column: 9, scope: !2793)
!2806 = !DILocation(line: 909, column: 13, scope: !2793)
!2807 = !DILocation(line: 910, column: 24, scope: !2793)
!2808 = !DILocation(line: 910, column: 9, scope: !2793)
!2809 = !DILocation(line: 910, column: 18, scope: !2793)
!2810 = !DILocation(line: 911, column: 23, scope: !2793)
!2811 = !DILocation(line: 911, column: 32, scope: !2793)
!2812 = !DILocation(line: 911, column: 18, scope: !2793)
!2813 = !DILocation(line: 911, column: 58, scope: !2793)
!2814 = !DILocation(line: 911, column: 9, scope: !2793)
!2815 = !DILocation(line: 911, column: 16, scope: !2793)
!2816 = !DILocation(line: 912, column: 9, scope: !2793)
!2817 = !DILocation(line: 912, column: 19, scope: !2793)
!2818 = !DILocation(line: 914, column: 5, scope: !2793)
!2819 = distinct !DISubprogram(name: "aws_byte_buf_from_array", scope: !195, file: !195, line: 917, type: !2820, scopeLine: 917, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2822)
!2820 = !DISubroutineType(types: !2821)
!2821 = !{!99, !121, !73}
!2822 = !{!2823, !2824, !2825}
!2823 = !DILocalVariable(name: "bytes", arg: 1, scope: !2819, file: !195, line: 917, type: !121)
!2824 = !DILocalVariable(name: "len", arg: 2, scope: !2819, file: !195, line: 917, type: !73)
!2825 = !DILocalVariable(name: "buf", scope: !2819, file: !195, line: 919, type: !99)
!2826 = !DILocation(line: 917, column: 57, scope: !2819)
!2827 = !DILocation(line: 917, column: 71, scope: !2819)
!2828 = !DILocation(line: 919, column: 25, scope: !2819)
!2829 = !DILocation(line: 920, column: 19, scope: !2819)
!2830 = !DILocation(line: 920, column: 23, scope: !2819)
!2831 = !DILocation(line: 920, column: 18, scope: !2819)
!2832 = !DILocation(line: 920, column: 41, scope: !2819)
!2833 = !DILocation(line: 920, column: 9, scope: !2819)
!2834 = !DILocation(line: 920, column: 16, scope: !2819)
!2835 = !DILocation(line: 921, column: 15, scope: !2819)
!2836 = !DILocation(line: 921, column: 9, scope: !2819)
!2837 = !DILocation(line: 921, column: 13, scope: !2819)
!2838 = !DILocation(line: 922, column: 20, scope: !2819)
!2839 = !DILocation(line: 922, column: 9, scope: !2819)
!2840 = !DILocation(line: 922, column: 18, scope: !2819)
!2841 = !DILocation(line: 923, column: 9, scope: !2819)
!2842 = !DILocation(line: 923, column: 19, scope: !2819)
!2843 = !DILocation(line: 925, column: 5, scope: !2819)
!2844 = distinct !DISubprogram(name: "aws_byte_buf_from_empty_array", scope: !195, file: !195, line: 928, type: !2820, scopeLine: 928, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2845)
!2845 = !{!2846, !2847, !2848}
!2846 = !DILocalVariable(name: "bytes", arg: 1, scope: !2844, file: !195, line: 928, type: !121)
!2847 = !DILocalVariable(name: "capacity", arg: 2, scope: !2844, file: !195, line: 928, type: !73)
!2848 = !DILocalVariable(name: "buf", scope: !2844, file: !195, line: 931, type: !99)
!2849 = !DILocation(line: 928, column: 63, scope: !2844)
!2850 = !DILocation(line: 928, column: 77, scope: !2844)
!2851 = !DILocation(line: 931, column: 25, scope: !2844)
!2852 = !DILocation(line: 932, column: 19, scope: !2844)
!2853 = !DILocation(line: 932, column: 28, scope: !2844)
!2854 = !DILocation(line: 932, column: 18, scope: !2844)
!2855 = !DILocation(line: 932, column: 46, scope: !2844)
!2856 = !DILocation(line: 932, column: 9, scope: !2844)
!2857 = !DILocation(line: 932, column: 16, scope: !2844)
!2858 = !DILocation(line: 933, column: 9, scope: !2844)
!2859 = !DILocation(line: 933, column: 13, scope: !2844)
!2860 = !DILocation(line: 934, column: 20, scope: !2844)
!2861 = !DILocation(line: 934, column: 9, scope: !2844)
!2862 = !DILocation(line: 934, column: 18, scope: !2844)
!2863 = !DILocation(line: 935, column: 9, scope: !2844)
!2864 = !DILocation(line: 935, column: 19, scope: !2844)
!2865 = !DILocation(line: 937, column: 5, scope: !2844)
!2866 = distinct !DISubprogram(name: "aws_byte_cursor_from_c_str", scope: !195, file: !195, line: 949, type: !2867, scopeLine: 949, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2869)
!2867 = !DISubroutineType(types: !2868)
!2868 = !{!136, !127}
!2869 = !{!2870, !2871}
!2870 = !DILocalVariable(name: "c_str", arg: 1, scope: !2866, file: !195, line: 949, type: !127)
!2871 = !DILocalVariable(name: "cur", scope: !2866, file: !195, line: 950, type: !136)
!2872 = !DILocation(line: 949, column: 63, scope: !2866)
!2873 = !DILocation(line: 950, column: 28, scope: !2866)
!2874 = !DILocation(line: 951, column: 26, scope: !2866)
!2875 = !DILocation(line: 951, column: 9, scope: !2866)
!2876 = !DILocation(line: 951, column: 13, scope: !2866)
!2877 = !DILocation(line: 952, column: 20, scope: !2866)
!2878 = !DILocation(line: 952, column: 15, scope: !2866)
!2879 = !DILocation(line: 952, column: 34, scope: !2866)
!2880 = !DILocation(line: 952, column: 27, scope: !2866)
!2881 = !DILocation(line: 952, column: 9, scope: !2866)
!2882 = !DILocation(line: 952, column: 13, scope: !2866)
!2883 = !DILocation(line: 954, column: 5, scope: !2866)
!2884 = distinct !DISubprogram(name: "aws_byte_cursor_from_array", scope: !195, file: !195, line: 957, type: !2885, scopeLine: 957, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2887)
!2885 = !DISubroutineType(types: !2886)
!2886 = !{!136, !944, !945}
!2887 = !{!2888, !2889, !2890}
!2888 = !DILocalVariable(name: "bytes", arg: 1, scope: !2884, file: !195, line: 957, type: !944)
!2889 = !DILocalVariable(name: "len", arg: 2, scope: !2884, file: !195, line: 957, type: !945)
!2890 = !DILocalVariable(name: "cur", scope: !2884, file: !195, line: 959, type: !136)
!2891 = !DILocation(line: 957, column: 69, scope: !2884)
!2892 = !DILocation(line: 957, column: 89, scope: !2884)
!2893 = !DILocation(line: 959, column: 28, scope: !2884)
!2894 = !DILocation(line: 960, column: 26, scope: !2884)
!2895 = !DILocation(line: 960, column: 9, scope: !2884)
!2896 = !DILocation(line: 960, column: 13, scope: !2884)
!2897 = !DILocation(line: 961, column: 15, scope: !2884)
!2898 = !DILocation(line: 961, column: 9, scope: !2884)
!2899 = !DILocation(line: 961, column: 13, scope: !2884)
!2900 = !DILocation(line: 963, column: 5, scope: !2884)
!2901 = distinct !DISubprogram(name: "aws_nospec_mask", scope: !195, file: !195, line: 976, type: !2360, scopeLine: 976, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2902)
!2902 = !{!2903, !2904, !2905, !2906, !2907}
!2903 = !DILocalVariable(name: "index", arg: 1, scope: !2901, file: !195, line: 976, type: !73)
!2904 = !DILocalVariable(name: "bound", arg: 2, scope: !2901, file: !195, line: 976, type: !73)
!2905 = !DILocalVariable(name: "negative_mask", scope: !2901, file: !195, line: 1007, type: !73)
!2906 = !DILocalVariable(name: "toobig_mask", scope: !2901, file: !195, line: 1008, type: !73)
!2907 = !DILocalVariable(name: "combined_mask", scope: !2901, file: !195, line: 1009, type: !73)
!2908 = !DILocation(line: 976, column: 31, scope: !2901)
!2909 = !DILocation(line: 976, column: 45, scope: !2901)
!2910 = !DILocation(line: 988, column: 5, scope: !2901)
!2911 = !{i32 34259}
!2912 = !DILocation(line: 1007, column: 5, scope: !2901)
!2913 = !DILocation(line: 1007, column: 12, scope: !2901)
!2914 = !DILocation(line: 1007, column: 28, scope: !2901)
!2915 = !DILocation(line: 1007, column: 36, scope: !2901)
!2916 = !DILocation(line: 1007, column: 34, scope: !2901)
!2917 = !DILocation(line: 1008, column: 5, scope: !2901)
!2918 = !DILocation(line: 1008, column: 12, scope: !2901)
!2919 = !DILocation(line: 1008, column: 26, scope: !2901)
!2920 = !DILocation(line: 1008, column: 34, scope: !2901)
!2921 = !DILocation(line: 1008, column: 32, scope: !2901)
!2922 = !DILocation(line: 1008, column: 40, scope: !2901)
!2923 = !DILocation(line: 1009, column: 5, scope: !2901)
!2924 = !DILocation(line: 1009, column: 12, scope: !2901)
!2925 = !DILocation(line: 1009, column: 28, scope: !2901)
!2926 = !DILocation(line: 1009, column: 44, scope: !2901)
!2927 = !DILocation(line: 1009, column: 42, scope: !2901)
!2928 = !DILocation(line: 1022, column: 23, scope: !2901)
!2929 = !DILocation(line: 1022, column: 22, scope: !2901)
!2930 = !DILocation(line: 1022, column: 38, scope: !2901)
!2931 = !DILocation(line: 1022, column: 19, scope: !2901)
!2932 = !DILocation(line: 1030, column: 21, scope: !2901)
!2933 = !DILocation(line: 1030, column: 35, scope: !2901)
!2934 = !DILocation(line: 1030, column: 19, scope: !2901)
!2935 = !DILocation(line: 1032, column: 12, scope: !2901)
!2936 = !DILocation(line: 1033, column: 1, scope: !2901)
!2937 = !DILocation(line: 1032, column: 5, scope: !2901)
!2938 = distinct !DISubprogram(name: "aws_byte_cursor_advance_nospec", scope: !195, file: !195, line: 1075, type: !2939, scopeLine: 1075, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !2941)
!2939 = !DISubroutineType(types: !2940)
!2940 = !{!136, !1805, !73}
!2941 = !{!2942, !2943, !2944, !2945}
!2942 = !DILocalVariable(name: "cursor", arg: 1, scope: !2938, file: !195, line: 1075, type: !1805)
!2943 = !DILocalVariable(name: "len", arg: 2, scope: !2938, file: !195, line: 1075, type: !73)
!2944 = !DILocalVariable(name: "rv", scope: !2938, file: !195, line: 1078, type: !136)
!2945 = !DILocalVariable(name: "mask", scope: !2946, file: !195, line: 1086, type: !157)
!2946 = distinct !DILexicalBlock(scope: !2947, file: !195, line: 1080, column: 89)
!2947 = distinct !DILexicalBlock(scope: !2938, file: !195, line: 1080, column: 9)
!2948 = !DILocation(line: 1075, column: 85, scope: !2938)
!2949 = !DILocation(line: 1075, column: 100, scope: !2938)
!2950 = !DILocation(line: 1078, column: 28, scope: !2938)
!2951 = !DILocation(line: 1080, column: 9, scope: !2947)
!2952 = !DILocation(line: 1080, column: 16, scope: !2947)
!2953 = !DILocation(line: 1080, column: 24, scope: !2947)
!2954 = !DILocation(line: 1080, column: 13, scope: !2947)
!2955 = !DILocation(line: 1080, column: 28, scope: !2947)
!2956 = !DILocation(line: 1080, column: 31, scope: !2947)
!2957 = !DILocation(line: 1080, column: 35, scope: !2947)
!2958 = !DILocation(line: 1080, column: 54, scope: !2947)
!2959 = !DILocation(line: 1080, column: 57, scope: !2947)
!2960 = !DILocation(line: 1080, column: 65, scope: !2947)
!2961 = !DILocation(line: 1080, column: 69, scope: !2947)
!2962 = !DILocation(line: 1080, column: 9, scope: !2938)
!2963 = !DILocation(line: 1086, column: 9, scope: !2946)
!2964 = !DILocation(line: 1086, column: 19, scope: !2946)
!2965 = !DILocation(line: 1086, column: 42, scope: !2946)
!2966 = !DILocation(line: 1086, column: 47, scope: !2946)
!2967 = !DILocation(line: 1086, column: 55, scope: !2946)
!2968 = !DILocation(line: 1086, column: 59, scope: !2946)
!2969 = !DILocation(line: 1086, column: 26, scope: !2946)
!2970 = !DILocation(line: 1089, column: 15, scope: !2946)
!2971 = !DILocation(line: 1089, column: 21, scope: !2946)
!2972 = !DILocation(line: 1089, column: 19, scope: !2946)
!2973 = !DILocation(line: 1089, column: 13, scope: !2946)
!2974 = !DILocation(line: 1090, column: 46, scope: !2946)
!2975 = !DILocation(line: 1090, column: 54, scope: !2946)
!2976 = !DILocation(line: 1090, column: 35, scope: !2946)
!2977 = !DILocation(line: 1090, column: 60, scope: !2946)
!2978 = !DILocation(line: 1090, column: 58, scope: !2946)
!2979 = !DILocation(line: 1090, column: 23, scope: !2946)
!2980 = !DILocation(line: 1090, column: 9, scope: !2946)
!2981 = !DILocation(line: 1090, column: 17, scope: !2946)
!2982 = !DILocation(line: 1090, column: 21, scope: !2946)
!2983 = !DILocation(line: 1092, column: 23, scope: !2946)
!2984 = !DILocation(line: 1092, column: 31, scope: !2946)
!2985 = !DILocation(line: 1092, column: 37, scope: !2946)
!2986 = !DILocation(line: 1092, column: 35, scope: !2946)
!2987 = !DILocation(line: 1092, column: 9, scope: !2946)
!2988 = !DILocation(line: 1092, column: 17, scope: !2946)
!2989 = !DILocation(line: 1092, column: 21, scope: !2946)
!2990 = !DILocation(line: 1094, column: 18, scope: !2946)
!2991 = !DILocation(line: 1094, column: 26, scope: !2946)
!2992 = !DILocation(line: 1094, column: 12, scope: !2946)
!2993 = !DILocation(line: 1094, column: 16, scope: !2946)
!2994 = !DILocation(line: 1096, column: 18, scope: !2946)
!2995 = !DILocation(line: 1096, column: 24, scope: !2946)
!2996 = !DILocation(line: 1096, column: 22, scope: !2946)
!2997 = !DILocation(line: 1096, column: 12, scope: !2946)
!2998 = !DILocation(line: 1096, column: 16, scope: !2946)
!2999 = !DILocation(line: 1098, column: 24, scope: !2946)
!3000 = !DILocation(line: 1098, column: 32, scope: !2946)
!3001 = !DILocation(line: 1098, column: 36, scope: !2946)
!3002 = !DILocation(line: 1098, column: 23, scope: !2946)
!3003 = !DILocation(line: 1098, column: 54, scope: !2946)
!3004 = !DILocation(line: 1098, column: 62, scope: !2946)
!3005 = !DILocation(line: 1098, column: 68, scope: !2946)
!3006 = !DILocation(line: 1098, column: 66, scope: !2946)
!3007 = !DILocation(line: 1098, column: 9, scope: !2946)
!3008 = !DILocation(line: 1098, column: 17, scope: !2946)
!3009 = !DILocation(line: 1098, column: 21, scope: !2946)
!3010 = !DILocation(line: 1099, column: 24, scope: !2946)
!3011 = !DILocation(line: 1099, column: 9, scope: !2946)
!3012 = !DILocation(line: 1099, column: 17, scope: !2946)
!3013 = !DILocation(line: 1099, column: 21, scope: !2946)
!3014 = !DILocation(line: 1100, column: 5, scope: !2947)
!3015 = !DILocation(line: 1100, column: 5, scope: !2946)
!3016 = !DILocation(line: 1101, column: 12, scope: !3017)
!3017 = distinct !DILexicalBlock(scope: !2947, file: !195, line: 1100, column: 12)
!3018 = !DILocation(line: 1101, column: 16, scope: !3017)
!3019 = !DILocation(line: 1102, column: 12, scope: !3017)
!3020 = !DILocation(line: 1102, column: 16, scope: !3017)
!3021 = !DILocation(line: 1107, column: 5, scope: !2938)
!3022 = distinct !DISubprogram(name: "aws_byte_cursor_read", scope: !195, file: !195, line: 1118, type: !3023, scopeLine: 1118, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3026)
!3023 = !DISubroutineType(types: !3024)
!3024 = !{!96, !1430, !3025, !945}
!3025 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !61)
!3026 = !{!3027, !3028, !3029, !3030}
!3027 = !DILocalVariable(name: "cur", arg: 1, scope: !3022, file: !195, line: 1118, type: !1430)
!3028 = !DILocalVariable(name: "dest", arg: 2, scope: !3022, file: !195, line: 1118, type: !3025)
!3029 = !DILocalVariable(name: "len", arg: 3, scope: !3022, file: !195, line: 1118, type: !945)
!3030 = !DILocalVariable(name: "slice", scope: !3022, file: !195, line: 1125, type: !136)
!3031 = !DILocation(line: 1118, column: 64, scope: !3022)
!3032 = !DILocation(line: 1118, column: 88, scope: !3022)
!3033 = !DILocation(line: 1118, column: 107, scope: !3022)
!3034 = !DILocation(line: 1121, column: 9, scope: !3035)
!3035 = distinct !DILexicalBlock(scope: !3022, file: !195, line: 1121, column: 9)
!3036 = !DILocation(line: 1121, column: 13, scope: !3035)
!3037 = !DILocation(line: 1121, column: 9, scope: !3022)
!3038 = !DILocation(line: 1122, column: 9, scope: !3039)
!3039 = distinct !DILexicalBlock(scope: !3035, file: !195, line: 1121, column: 19)
!3040 = !DILocation(line: 1125, column: 5, scope: !3022)
!3041 = !DILocation(line: 1125, column: 28, scope: !3022)
!3042 = !DILocation(line: 1125, column: 67, scope: !3022)
!3043 = !DILocation(line: 1125, column: 72, scope: !3022)
!3044 = !DILocation(line: 1125, column: 36, scope: !3022)
!3045 = !DILocation(line: 1127, column: 15, scope: !3046)
!3046 = distinct !DILexicalBlock(scope: !3022, file: !195, line: 1127, column: 9)
!3047 = !DILocation(line: 1127, column: 9, scope: !3046)
!3048 = !DILocation(line: 1127, column: 9, scope: !3022)
!3049 = !DILocation(line: 1128, column: 9, scope: !3050)
!3050 = distinct !DILexicalBlock(scope: !3046, file: !195, line: 1127, column: 20)
!3051 = !DILocation(line: 1131, column: 9, scope: !3050)
!3052 = !DILocation(line: 1134, column: 5, scope: !3022)
!3053 = !DILocation(line: 1135, column: 1, scope: !3022)
!3054 = distinct !DISubprogram(name: "aws_byte_cursor_read_and_fill_buffer", scope: !195, file: !195, line: 1144, type: !3055, scopeLine: 1146, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3057)
!3055 = !DISubroutineType(types: !3056)
!3056 = !{!96, !1430, !2125}
!3057 = !{!3058, !3059}
!3058 = !DILocalVariable(name: "cur", arg: 1, scope: !3054, file: !195, line: 1145, type: !1430)
!3059 = !DILocalVariable(name: "dest", arg: 2, scope: !3054, file: !195, line: 1146, type: !2125)
!3060 = !DILocation(line: 1145, column: 42, scope: !3054)
!3061 = !DILocation(line: 1146, column: 39, scope: !3054)
!3062 = !DILocation(line: 1149, column: 30, scope: !3063)
!3063 = distinct !DILexicalBlock(scope: !3054, file: !195, line: 1149, column: 9)
!3064 = !DILocation(line: 1149, column: 35, scope: !3063)
!3065 = !DILocation(line: 1149, column: 41, scope: !3063)
!3066 = !DILocation(line: 1149, column: 49, scope: !3063)
!3067 = !DILocation(line: 1149, column: 55, scope: !3063)
!3068 = !DILocation(line: 1149, column: 9, scope: !3063)
!3069 = !DILocation(line: 1149, column: 9, scope: !3054)
!3070 = !DILocation(line: 1150, column: 21, scope: !3071)
!3071 = distinct !DILexicalBlock(scope: !3063, file: !195, line: 1149, column: 66)
!3072 = !DILocation(line: 1150, column: 27, scope: !3071)
!3073 = !DILocation(line: 1150, column: 9, scope: !3071)
!3074 = !DILocation(line: 1150, column: 15, scope: !3071)
!3075 = !DILocation(line: 1150, column: 19, scope: !3071)
!3076 = !DILocation(line: 1153, column: 9, scope: !3071)
!3077 = !DILocation(line: 1157, column: 5, scope: !3054)
!3078 = !DILocation(line: 1158, column: 1, scope: !3054)
!3079 = distinct !DISubprogram(name: "aws_byte_cursor_read_u8", scope: !195, file: !195, line: 1167, type: !3080, scopeLine: 1167, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3083)
!3080 = !DISubroutineType(types: !3081)
!3081 = !{!96, !1430, !3082}
!3082 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !103)
!3083 = !{!3084, !3085, !3086}
!3084 = !DILocalVariable(name: "cur", arg: 1, scope: !3079, file: !195, line: 1167, type: !1430)
!3085 = !DILocalVariable(name: "var", arg: 2, scope: !3079, file: !195, line: 1167, type: !3082)
!3086 = !DILocalVariable(name: "rv", scope: !3079, file: !195, line: 1170, type: !96)
!3087 = !DILocation(line: 1167, column: 67, scope: !3079)
!3088 = !DILocation(line: 1167, column: 94, scope: !3079)
!3089 = !DILocation(line: 1170, column: 5, scope: !3079)
!3090 = !DILocation(line: 1170, column: 10, scope: !3079)
!3091 = !DILocation(line: 1170, column: 36, scope: !3079)
!3092 = !DILocation(line: 1170, column: 41, scope: !3079)
!3093 = !DILocation(line: 1170, column: 15, scope: !3079)
!3094 = !DILocation(line: 1172, column: 12, scope: !3079)
!3095 = !DILocation(line: 1173, column: 1, scope: !3079)
!3096 = !DILocation(line: 1172, column: 5, scope: !3079)
!3097 = distinct !DISubprogram(name: "aws_byte_cursor_read_be16", scope: !195, file: !195, line: 1183, type: !3098, scopeLine: 1183, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3101)
!3098 = !DISubroutineType(types: !3099)
!3099 = !{!96, !135, !3100}
!3100 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !186, size: 32)
!3101 = !{!3102, !3103, !3104}
!3102 = !DILocalVariable(name: "cur", arg: 1, scope: !3097, file: !195, line: 1183, type: !135)
!3103 = !DILocalVariable(name: "var", arg: 2, scope: !3097, file: !195, line: 1183, type: !3100)
!3104 = !DILocalVariable(name: "rv", scope: !3097, file: !195, line: 1186, type: !96)
!3105 = !DILocation(line: 1183, column: 56, scope: !3097)
!3106 = !DILocation(line: 1183, column: 71, scope: !3097)
!3107 = !DILocation(line: 1186, column: 5, scope: !3097)
!3108 = !DILocation(line: 1186, column: 10, scope: !3097)
!3109 = !DILocation(line: 1186, column: 36, scope: !3097)
!3110 = !DILocation(line: 1186, column: 41, scope: !3097)
!3111 = !DILocation(line: 1186, column: 15, scope: !3097)
!3112 = !DILocation(line: 1188, column: 9, scope: !3113)
!3113 = distinct !DILexicalBlock(scope: !3097, file: !195, line: 1188, column: 9)
!3114 = !DILocation(line: 1188, column: 9, scope: !3097)
!3115 = !DILocation(line: 1189, column: 28, scope: !3116)
!3116 = distinct !DILexicalBlock(scope: !3113, file: !195, line: 1188, column: 25)
!3117 = !DILocation(line: 1189, column: 27, scope: !3116)
!3118 = !{!3119, !3119, i64 0}
!3119 = !{!"short", !659, i64 0}
!3120 = !DILocation(line: 1189, column: 16, scope: !3116)
!3121 = !DILocation(line: 1189, column: 10, scope: !3116)
!3122 = !DILocation(line: 1189, column: 14, scope: !3116)
!3123 = !DILocation(line: 1190, column: 5, scope: !3116)
!3124 = !DILocation(line: 1193, column: 12, scope: !3097)
!3125 = !DILocation(line: 1194, column: 1, scope: !3097)
!3126 = !DILocation(line: 1193, column: 5, scope: !3097)
!3127 = distinct !DISubprogram(name: "aws_ntoh16", scope: !3128, file: !3128, line: 154, type: !3129, scopeLine: 154, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3131)
!3128 = !DIFile(filename: "aws-c-common/include/aws/common/byte_order.inl", directory: "/Users/jorge/Repos/verify-c-common")
!3129 = !DISubroutineType(types: !3130)
!3130 = !{!186, !186}
!3131 = !{!3132}
!3132 = !DILocalVariable(name: "x", arg: 1, scope: !3127, file: !3128, line: 154, type: !186)
!3133 = !DILocation(line: 154, column: 46, scope: !3127)
!3134 = !DILocation(line: 158, column: 12, scope: !3127)
!3135 = !DILocation(line: 158, column: 5, scope: !3127)
!3136 = distinct !DISubprogram(name: "_OSSwapInt16", scope: !3137, file: !3137, line: 15, type: !3129, scopeLine: 18, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3138)
!3137 = !DIFile(filename: "/Library/Developer/CommandLineTools/SDKs/MacOSX12.0.sdk/usr/include/libkern/arm/OSByteOrder.h", directory: "")
!3138 = !{!3139}
!3139 = !DILocalVariable(name: "_data", arg: 1, scope: !3136, file: !3137, line: 16, type: !186)
!3140 = !DILocation(line: 16, column: 18, scope: !3136)
!3141 = !DILocation(line: 20, column: 20, scope: !3136)
!3142 = !DILocation(line: 20, column: 26, scope: !3136)
!3143 = !DILocation(line: 20, column: 33, scope: !3136)
!3144 = !DILocation(line: 20, column: 39, scope: !3136)
!3145 = !DILocation(line: 20, column: 31, scope: !3136)
!3146 = !DILocation(line: 20, column: 9, scope: !3136)
!3147 = !DILocation(line: 20, column: 2, scope: !3136)
!3148 = distinct !DISubprogram(name: "aws_byte_cursor_read_be24", scope: !195, file: !195, line: 1205, type: !3149, scopeLine: 1205, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3151)
!3149 = !DISubroutineType(types: !3150)
!3150 = !{!96, !135, !162}
!3151 = !{!3152, !3153, !3154, !3155}
!3152 = !DILocalVariable(name: "cur", arg: 1, scope: !3148, file: !195, line: 1205, type: !135)
!3153 = !DILocalVariable(name: "var", arg: 2, scope: !3148, file: !195, line: 1205, type: !162)
!3154 = !DILocalVariable(name: "var_bytes", scope: !3148, file: !195, line: 1209, type: !103)
!3155 = !DILocalVariable(name: "rv", scope: !3148, file: !195, line: 1212, type: !96)
!3156 = !DILocation(line: 1205, column: 56, scope: !3148)
!3157 = !DILocation(line: 1205, column: 71, scope: !3148)
!3158 = !DILocation(line: 1209, column: 5, scope: !3148)
!3159 = !DILocation(line: 1209, column: 14, scope: !3148)
!3160 = !DILocation(line: 1209, column: 34, scope: !3148)
!3161 = !DILocation(line: 1209, column: 26, scope: !3148)
!3162 = !DILocation(line: 1212, column: 5, scope: !3148)
!3163 = !DILocation(line: 1212, column: 10, scope: !3148)
!3164 = !DILocation(line: 1212, column: 36, scope: !3148)
!3165 = !DILocation(line: 1212, column: 42, scope: !3148)
!3166 = !DILocation(line: 1212, column: 15, scope: !3148)
!3167 = !DILocation(line: 1214, column: 9, scope: !3168)
!3168 = distinct !DILexicalBlock(scope: !3148, file: !195, line: 1214, column: 9)
!3169 = !DILocation(line: 1214, column: 9, scope: !3148)
!3170 = !DILocation(line: 1216, column: 9, scope: !3171)
!3171 = distinct !DILexicalBlock(scope: !3168, file: !195, line: 1214, column: 25)
!3172 = !DILocation(line: 1216, column: 22, scope: !3171)
!3173 = !DILocation(line: 1218, column: 28, scope: !3171)
!3174 = !DILocation(line: 1218, column: 27, scope: !3171)
!3175 = !DILocation(line: 1218, column: 16, scope: !3171)
!3176 = !DILocation(line: 1218, column: 10, scope: !3171)
!3177 = !DILocation(line: 1218, column: 14, scope: !3171)
!3178 = !DILocation(line: 1219, column: 5, scope: !3171)
!3179 = !DILocation(line: 1222, column: 12, scope: !3148)
!3180 = !DILocation(line: 1223, column: 1, scope: !3148)
!3181 = !DILocation(line: 1222, column: 5, scope: !3148)
!3182 = distinct !DISubprogram(name: "aws_ntoh32", scope: !3128, file: !3128, line: 118, type: !3183, scopeLine: 118, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3185)
!3183 = !DISubroutineType(types: !3184)
!3184 = !{!163, !163}
!3185 = !{!3186}
!3186 = !DILocalVariable(name: "x", arg: 1, scope: !3182, file: !3128, line: 118, type: !163)
!3187 = !DILocation(line: 118, column: 46, scope: !3182)
!3188 = !DILocation(line: 122, column: 12, scope: !3182)
!3189 = !DILocation(line: 122, column: 5, scope: !3182)
!3190 = distinct !DISubprogram(name: "_OSSwapInt32", scope: !3137, file: !3137, line: 25, type: !3183, scopeLine: 28, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3191)
!3191 = !{!3192}
!3192 = !DILocalVariable(name: "_data", arg: 1, scope: !3190, file: !3137, line: 26, type: !163)
!3193 = !DILocation(line: 26, column: 18, scope: !3190)
!3194 = !DILocation(line: 30, column: 28, scope: !3190)
!3195 = !DILocation(line: 30, column: 10, scope: !3190)
!3196 = !DILocation(line: 30, column: 8, scope: !3190)
!3197 = !DILocation(line: 36, column: 9, scope: !3190)
!3198 = !DILocation(line: 36, column: 2, scope: !3190)
!3199 = distinct !DISubprogram(name: "aws_byte_cursor_read_be32", scope: !195, file: !195, line: 1233, type: !3149, scopeLine: 1233, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3200)
!3200 = !{!3201, !3202, !3203}
!3201 = !DILocalVariable(name: "cur", arg: 1, scope: !3199, file: !195, line: 1233, type: !135)
!3202 = !DILocalVariable(name: "var", arg: 2, scope: !3199, file: !195, line: 1233, type: !162)
!3203 = !DILocalVariable(name: "rv", scope: !3199, file: !195, line: 1236, type: !96)
!3204 = !DILocation(line: 1233, column: 56, scope: !3199)
!3205 = !DILocation(line: 1233, column: 71, scope: !3199)
!3206 = !DILocation(line: 1236, column: 5, scope: !3199)
!3207 = !DILocation(line: 1236, column: 10, scope: !3199)
!3208 = !DILocation(line: 1236, column: 36, scope: !3199)
!3209 = !DILocation(line: 1236, column: 41, scope: !3199)
!3210 = !DILocation(line: 1236, column: 15, scope: !3199)
!3211 = !DILocation(line: 1238, column: 9, scope: !3212)
!3212 = distinct !DILexicalBlock(scope: !3199, file: !195, line: 1238, column: 9)
!3213 = !DILocation(line: 1238, column: 9, scope: !3199)
!3214 = !DILocation(line: 1239, column: 28, scope: !3215)
!3215 = distinct !DILexicalBlock(scope: !3212, file: !195, line: 1238, column: 25)
!3216 = !DILocation(line: 1239, column: 27, scope: !3215)
!3217 = !DILocation(line: 1239, column: 16, scope: !3215)
!3218 = !DILocation(line: 1239, column: 10, scope: !3215)
!3219 = !DILocation(line: 1239, column: 14, scope: !3215)
!3220 = !DILocation(line: 1240, column: 5, scope: !3215)
!3221 = !DILocation(line: 1243, column: 12, scope: !3199)
!3222 = !DILocation(line: 1244, column: 1, scope: !3199)
!3223 = !DILocation(line: 1243, column: 5, scope: !3199)
!3224 = distinct !DISubprogram(name: "aws_byte_cursor_read_float_be32", scope: !195, file: !195, line: 1254, type: !3225, scopeLine: 1254, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3229)
!3225 = !DISubroutineType(types: !3226)
!3226 = !{!96, !135, !3227}
!3227 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !3228, size: 32)
!3228 = !DIBasicType(name: "float", size: 32, encoding: DW_ATE_float)
!3229 = !{!3230, !3231, !3232}
!3230 = !DILocalVariable(name: "cur", arg: 1, scope: !3224, file: !195, line: 1254, type: !135)
!3231 = !DILocalVariable(name: "var", arg: 2, scope: !3224, file: !195, line: 1254, type: !3227)
!3232 = !DILocalVariable(name: "rv", scope: !3224, file: !195, line: 1257, type: !96)
!3233 = !DILocation(line: 1254, column: 62, scope: !3224)
!3234 = !DILocation(line: 1254, column: 74, scope: !3224)
!3235 = !DILocation(line: 1257, column: 5, scope: !3224)
!3236 = !DILocation(line: 1257, column: 10, scope: !3224)
!3237 = !DILocation(line: 1257, column: 36, scope: !3224)
!3238 = !DILocation(line: 1257, column: 41, scope: !3224)
!3239 = !DILocation(line: 1257, column: 15, scope: !3224)
!3240 = !DILocation(line: 1259, column: 9, scope: !3241)
!3241 = distinct !DILexicalBlock(scope: !3224, file: !195, line: 1259, column: 9)
!3242 = !DILocation(line: 1259, column: 9, scope: !3224)
!3243 = !DILocation(line: 1260, column: 29, scope: !3244)
!3244 = distinct !DILexicalBlock(scope: !3241, file: !195, line: 1259, column: 25)
!3245 = !DILocation(line: 1260, column: 28, scope: !3244)
!3246 = !{!3247, !3247, i64 0}
!3247 = !{!"float", !659, i64 0}
!3248 = !DILocation(line: 1260, column: 16, scope: !3244)
!3249 = !DILocation(line: 1260, column: 10, scope: !3244)
!3250 = !DILocation(line: 1260, column: 14, scope: !3244)
!3251 = !DILocation(line: 1261, column: 5, scope: !3244)
!3252 = !DILocation(line: 1264, column: 12, scope: !3224)
!3253 = !DILocation(line: 1265, column: 1, scope: !3224)
!3254 = !DILocation(line: 1264, column: 5, scope: !3224)
!3255 = distinct !DISubprogram(name: "aws_ntohf32", scope: !3128, file: !3128, line: 129, type: !3256, scopeLine: 129, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3258)
!3256 = !DISubroutineType(types: !3257)
!3257 = !{!3228, !3228}
!3258 = !{!3259}
!3259 = !DILocalVariable(name: "x", arg: 1, scope: !3255, file: !3128, line: 129, type: !3228)
!3260 = !DILocation(line: 129, column: 41, scope: !3255)
!3261 = !DILocation(line: 130, column: 24, scope: !3255)
!3262 = !DILocation(line: 130, column: 12, scope: !3255)
!3263 = !DILocation(line: 130, column: 5, scope: !3255)
!3264 = distinct !DISubprogram(name: "aws_htonf32", scope: !3128, file: !3128, line: 72, type: !3256, scopeLine: 72, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3265)
!3265 = !{!3266, !3267, !3268, !3269}
!3266 = !DILocalVariable(name: "x", arg: 1, scope: !3264, file: !3128, line: 72, type: !3228)
!3267 = !DILocalVariable(name: "f_storage", scope: !3264, file: !3128, line: 77, type: !103)
!3268 = !DILocalVariable(name: "ret_value", scope: !3264, file: !3128, line: 79, type: !3228)
!3269 = !DILocalVariable(name: "ret_storage", scope: !3264, file: !3128, line: 80, type: !103)
!3270 = !DILocation(line: 72, column: 41, scope: !3264)
!3271 = !DILocation(line: 73, column: 9, scope: !3272)
!3272 = distinct !DILexicalBlock(scope: !3264, file: !3128, line: 73, column: 9)
!3273 = !DILocation(line: 73, column: 9, scope: !3264)
!3274 = !DILocation(line: 74, column: 16, scope: !3275)
!3275 = distinct !DILexicalBlock(scope: !3272, file: !3128, line: 73, column: 30)
!3276 = !DILocation(line: 74, column: 9, scope: !3275)
!3277 = !DILocation(line: 77, column: 5, scope: !3264)
!3278 = !DILocation(line: 77, column: 14, scope: !3264)
!3279 = !DILocation(line: 77, column: 26, scope: !3264)
!3280 = !DILocation(line: 79, column: 5, scope: !3264)
!3281 = !DILocation(line: 79, column: 11, scope: !3264)
!3282 = !DILocation(line: 80, column: 5, scope: !3264)
!3283 = !DILocation(line: 80, column: 14, scope: !3264)
!3284 = !DILocation(line: 80, column: 28, scope: !3264)
!3285 = !DILocation(line: 82, column: 22, scope: !3264)
!3286 = !DILocation(line: 82, column: 5, scope: !3264)
!3287 = !DILocation(line: 82, column: 20, scope: !3264)
!3288 = !DILocation(line: 83, column: 22, scope: !3264)
!3289 = !DILocation(line: 83, column: 5, scope: !3264)
!3290 = !DILocation(line: 83, column: 20, scope: !3264)
!3291 = !DILocation(line: 84, column: 22, scope: !3264)
!3292 = !DILocation(line: 84, column: 5, scope: !3264)
!3293 = !DILocation(line: 84, column: 20, scope: !3264)
!3294 = !DILocation(line: 85, column: 22, scope: !3264)
!3295 = !DILocation(line: 85, column: 5, scope: !3264)
!3296 = !DILocation(line: 85, column: 20, scope: !3264)
!3297 = !DILocation(line: 87, column: 12, scope: !3264)
!3298 = !DILocation(line: 87, column: 5, scope: !3264)
!3299 = !DILocation(line: 88, column: 1, scope: !3264)
!3300 = distinct !DISubprogram(name: "aws_is_big_endian", scope: !3128, file: !3128, line: 26, type: !166, scopeLine: 26, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3301)
!3301 = !{!3302}
!3302 = !DILocalVariable(name: "z", scope: !3300, file: !3128, line: 27, type: !3303)
!3303 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !186)
!3304 = !DILocation(line: 27, column: 5, scope: !3300)
!3305 = !DILocation(line: 27, column: 20, scope: !3300)
!3306 = !DILocation(line: 28, column: 12, scope: !3300)
!3307 = !DILocation(line: 29, column: 1, scope: !3300)
!3308 = !DILocation(line: 28, column: 5, scope: !3300)
!3309 = distinct !DISubprogram(name: "aws_byte_cursor_read_float_be64", scope: !195, file: !195, line: 1275, type: !3310, scopeLine: 1275, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3313)
!3310 = !DISubroutineType(types: !3311)
!3311 = !{!96, !135, !3312}
!3312 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !539, size: 32)
!3313 = !{!3314, !3315, !3316}
!3314 = !DILocalVariable(name: "cur", arg: 1, scope: !3309, file: !195, line: 1275, type: !135)
!3315 = !DILocalVariable(name: "var", arg: 2, scope: !3309, file: !195, line: 1275, type: !3312)
!3316 = !DILocalVariable(name: "rv", scope: !3309, file: !195, line: 1278, type: !96)
!3317 = !DILocation(line: 1275, column: 62, scope: !3309)
!3318 = !DILocation(line: 1275, column: 75, scope: !3309)
!3319 = !DILocation(line: 1278, column: 5, scope: !3309)
!3320 = !DILocation(line: 1278, column: 10, scope: !3309)
!3321 = !DILocation(line: 1278, column: 36, scope: !3309)
!3322 = !DILocation(line: 1278, column: 41, scope: !3309)
!3323 = !DILocation(line: 1278, column: 15, scope: !3309)
!3324 = !DILocation(line: 1280, column: 9, scope: !3325)
!3325 = distinct !DILexicalBlock(scope: !3309, file: !195, line: 1280, column: 9)
!3326 = !DILocation(line: 1280, column: 9, scope: !3309)
!3327 = !DILocation(line: 1281, column: 29, scope: !3328)
!3328 = distinct !DILexicalBlock(scope: !3325, file: !195, line: 1280, column: 25)
!3329 = !DILocation(line: 1281, column: 28, scope: !3328)
!3330 = !{!3331, !3331, i64 0}
!3331 = !{!"double", !659, i64 0}
!3332 = !DILocation(line: 1281, column: 16, scope: !3328)
!3333 = !DILocation(line: 1281, column: 10, scope: !3328)
!3334 = !DILocation(line: 1281, column: 14, scope: !3328)
!3335 = !DILocation(line: 1282, column: 5, scope: !3328)
!3336 = !DILocation(line: 1285, column: 12, scope: !3309)
!3337 = !DILocation(line: 1286, column: 1, scope: !3309)
!3338 = !DILocation(line: 1285, column: 5, scope: !3309)
!3339 = distinct !DISubprogram(name: "aws_ntohf64", scope: !3128, file: !3128, line: 136, type: !3340, scopeLine: 136, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3342)
!3340 = !DISubroutineType(types: !3341)
!3341 = !{!539, !539}
!3342 = !{!3343}
!3343 = !DILocalVariable(name: "x", arg: 1, scope: !3339, file: !3128, line: 136, type: !539)
!3344 = !DILocation(line: 136, column: 43, scope: !3339)
!3345 = !DILocation(line: 137, column: 24, scope: !3339)
!3346 = !DILocation(line: 137, column: 12, scope: !3339)
!3347 = !DILocation(line: 137, column: 5, scope: !3339)
!3348 = distinct !DISubprogram(name: "aws_htonf64", scope: !3128, file: !3128, line: 93, type: !3340, scopeLine: 93, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3349)
!3349 = !{!3350, !3351, !3352, !3353}
!3350 = !DILocalVariable(name: "x", arg: 1, scope: !3348, file: !3128, line: 93, type: !539)
!3351 = !DILocalVariable(name: "f_storage", scope: !3348, file: !3128, line: 98, type: !103)
!3352 = !DILocalVariable(name: "ret_value", scope: !3348, file: !3128, line: 100, type: !539)
!3353 = !DILocalVariable(name: "ret_storage", scope: !3348, file: !3128, line: 101, type: !103)
!3354 = !DILocation(line: 93, column: 43, scope: !3348)
!3355 = !DILocation(line: 94, column: 9, scope: !3356)
!3356 = distinct !DILexicalBlock(scope: !3348, file: !3128, line: 94, column: 9)
!3357 = !DILocation(line: 94, column: 9, scope: !3348)
!3358 = !DILocation(line: 95, column: 16, scope: !3359)
!3359 = distinct !DILexicalBlock(scope: !3356, file: !3128, line: 94, column: 30)
!3360 = !DILocation(line: 95, column: 9, scope: !3359)
!3361 = !DILocation(line: 98, column: 5, scope: !3348)
!3362 = !DILocation(line: 98, column: 14, scope: !3348)
!3363 = !DILocation(line: 98, column: 26, scope: !3348)
!3364 = !DILocation(line: 100, column: 5, scope: !3348)
!3365 = !DILocation(line: 100, column: 12, scope: !3348)
!3366 = !DILocation(line: 101, column: 5, scope: !3348)
!3367 = !DILocation(line: 101, column: 14, scope: !3348)
!3368 = !DILocation(line: 101, column: 28, scope: !3348)
!3369 = !DILocation(line: 103, column: 22, scope: !3348)
!3370 = !DILocation(line: 103, column: 5, scope: !3348)
!3371 = !DILocation(line: 103, column: 20, scope: !3348)
!3372 = !DILocation(line: 104, column: 22, scope: !3348)
!3373 = !DILocation(line: 104, column: 5, scope: !3348)
!3374 = !DILocation(line: 104, column: 20, scope: !3348)
!3375 = !DILocation(line: 105, column: 22, scope: !3348)
!3376 = !DILocation(line: 105, column: 5, scope: !3348)
!3377 = !DILocation(line: 105, column: 20, scope: !3348)
!3378 = !DILocation(line: 106, column: 22, scope: !3348)
!3379 = !DILocation(line: 106, column: 5, scope: !3348)
!3380 = !DILocation(line: 106, column: 20, scope: !3348)
!3381 = !DILocation(line: 107, column: 22, scope: !3348)
!3382 = !DILocation(line: 107, column: 5, scope: !3348)
!3383 = !DILocation(line: 107, column: 20, scope: !3348)
!3384 = !DILocation(line: 108, column: 22, scope: !3348)
!3385 = !DILocation(line: 108, column: 5, scope: !3348)
!3386 = !DILocation(line: 108, column: 20, scope: !3348)
!3387 = !DILocation(line: 109, column: 22, scope: !3348)
!3388 = !DILocation(line: 109, column: 5, scope: !3348)
!3389 = !DILocation(line: 109, column: 20, scope: !3348)
!3390 = !DILocation(line: 110, column: 22, scope: !3348)
!3391 = !DILocation(line: 110, column: 5, scope: !3348)
!3392 = !DILocation(line: 110, column: 20, scope: !3348)
!3393 = !DILocation(line: 112, column: 12, scope: !3348)
!3394 = !DILocation(line: 112, column: 5, scope: !3348)
!3395 = !DILocation(line: 113, column: 1, scope: !3348)
!3396 = distinct !DISubprogram(name: "aws_byte_cursor_read_be64", scope: !195, file: !195, line: 1296, type: !3397, scopeLine: 1296, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3400)
!3397 = !DISubroutineType(types: !3398)
!3398 = !{!96, !135, !3399}
!3399 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !189, size: 32)
!3400 = !{!3401, !3402, !3403}
!3401 = !DILocalVariable(name: "cur", arg: 1, scope: !3396, file: !195, line: 1296, type: !135)
!3402 = !DILocalVariable(name: "var", arg: 2, scope: !3396, file: !195, line: 1296, type: !3399)
!3403 = !DILocalVariable(name: "rv", scope: !3396, file: !195, line: 1299, type: !96)
!3404 = !DILocation(line: 1296, column: 56, scope: !3396)
!3405 = !DILocation(line: 1296, column: 71, scope: !3396)
!3406 = !DILocation(line: 1299, column: 5, scope: !3396)
!3407 = !DILocation(line: 1299, column: 10, scope: !3396)
!3408 = !DILocation(line: 1299, column: 36, scope: !3396)
!3409 = !DILocation(line: 1299, column: 41, scope: !3396)
!3410 = !DILocation(line: 1299, column: 15, scope: !3396)
!3411 = !DILocation(line: 1301, column: 9, scope: !3412)
!3412 = distinct !DILexicalBlock(scope: !3396, file: !195, line: 1301, column: 9)
!3413 = !DILocation(line: 1301, column: 9, scope: !3396)
!3414 = !DILocation(line: 1302, column: 28, scope: !3415)
!3415 = distinct !DILexicalBlock(scope: !3412, file: !195, line: 1301, column: 25)
!3416 = !DILocation(line: 1302, column: 27, scope: !3415)
!3417 = !DILocation(line: 1302, column: 16, scope: !3415)
!3418 = !DILocation(line: 1302, column: 10, scope: !3415)
!3419 = !DILocation(line: 1302, column: 14, scope: !3415)
!3420 = !DILocation(line: 1303, column: 5, scope: !3415)
!3421 = !DILocation(line: 1306, column: 12, scope: !3396)
!3422 = !DILocation(line: 1307, column: 1, scope: !3396)
!3423 = !DILocation(line: 1306, column: 5, scope: !3396)
!3424 = distinct !DISubprogram(name: "aws_ntoh64", scope: !3128, file: !3128, line: 54, type: !3425, scopeLine: 54, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3427)
!3425 = !DISubroutineType(types: !3426)
!3426 = !{!189, !189}
!3427 = !{!3428}
!3428 = !DILocalVariable(name: "x", arg: 1, scope: !3424, file: !3128, line: 54, type: !189)
!3429 = !DILocation(line: 54, column: 46, scope: !3424)
!3430 = !DILocation(line: 55, column: 23, scope: !3424)
!3431 = !DILocation(line: 55, column: 12, scope: !3424)
!3432 = !DILocation(line: 55, column: 5, scope: !3424)
!3433 = distinct !DISubprogram(name: "aws_hton64", scope: !3128, file: !3128, line: 34, type: !3425, scopeLine: 34, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3434)
!3434 = !{!3435, !3436, !3437}
!3435 = !DILocalVariable(name: "x", arg: 1, scope: !3433, file: !3128, line: 34, type: !189)
!3436 = !DILocalVariable(name: "low", scope: !3433, file: !3128, line: 45, type: !163)
!3437 = !DILocalVariable(name: "high", scope: !3433, file: !3128, line: 46, type: !163)
!3438 = !DILocation(line: 34, column: 46, scope: !3433)
!3439 = !DILocation(line: 35, column: 9, scope: !3440)
!3440 = distinct !DILexicalBlock(scope: !3433, file: !3128, line: 35, column: 9)
!3441 = !DILocation(line: 35, column: 9, scope: !3433)
!3442 = !DILocation(line: 36, column: 16, scope: !3443)
!3443 = distinct !DILexicalBlock(scope: !3440, file: !3128, line: 35, column: 30)
!3444 = !DILocation(line: 36, column: 9, scope: !3443)
!3445 = !DILocation(line: 45, column: 5, scope: !3433)
!3446 = !DILocation(line: 45, column: 14, scope: !3433)
!3447 = !DILocation(line: 45, column: 20, scope: !3433)
!3448 = !DILocation(line: 45, column: 22, scope: !3433)
!3449 = !DILocation(line: 46, column: 5, scope: !3433)
!3450 = !DILocation(line: 46, column: 14, scope: !3433)
!3451 = !DILocation(line: 46, column: 32, scope: !3433)
!3452 = !DILocation(line: 46, column: 34, scope: !3433)
!3453 = !DILocation(line: 46, column: 21, scope: !3433)
!3454 = !DILocation(line: 47, column: 23, scope: !3433)
!3455 = !DILocation(line: 47, column: 13, scope: !3433)
!3456 = !DILocation(line: 47, column: 35, scope: !3433)
!3457 = !DILocation(line: 47, column: 43, scope: !3433)
!3458 = !DILocation(line: 47, column: 41, scope: !3433)
!3459 = !DILocation(line: 47, column: 5, scope: !3433)
!3460 = !DILocation(line: 49, column: 1, scope: !3433)
!3461 = distinct !DISubprogram(name: "aws_lookup_table_hex_to_num_get", scope: !195, file: !195, line: 1336, type: !1965, scopeLine: 1336, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !91)
!3462 = !DILocation(line: 1337, column: 5, scope: !3461)
!3463 = distinct !DISubprogram(name: "aws_byte_cursor_read_hex_u8", scope: !195, file: !195, line: 1340, type: !3464, scopeLine: 1340, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3466)
!3464 = !DISubroutineType(types: !3465)
!3465 = !{!96, !135, !103}
!3466 = !{!3467, !3468, !3469, !3470, !3473}
!3467 = !DILocalVariable(name: "cur", arg: 1, scope: !3463, file: !195, line: 1340, type: !135)
!3468 = !DILocalVariable(name: "var", arg: 2, scope: !3463, file: !195, line: 1340, type: !103)
!3469 = !DILocalVariable(name: "success", scope: !3463, file: !195, line: 1344, type: !96)
!3470 = !DILocalVariable(name: "hi", scope: !3471, file: !195, line: 1346, type: !152)
!3471 = distinct !DILexicalBlock(scope: !3472, file: !195, line: 1345, column: 36)
!3472 = distinct !DILexicalBlock(scope: !3463, file: !195, line: 1345, column: 9)
!3473 = !DILocalVariable(name: "lo", scope: !3471, file: !195, line: 1347, type: !152)
!3474 = !DILocation(line: 1340, column: 58, scope: !3463)
!3475 = !DILocation(line: 1340, column: 72, scope: !3463)
!3476 = !DILocation(line: 1344, column: 5, scope: !3463)
!3477 = !DILocation(line: 1344, column: 10, scope: !3463)
!3478 = !DILocation(line: 1345, column: 9, scope: !3472)
!3479 = !DILocation(line: 1345, column: 9, scope: !3463)
!3480 = !DILocation(line: 1346, column: 9, scope: !3471)
!3481 = !DILocation(line: 1346, column: 23, scope: !3471)
!3482 = !DILocation(line: 1346, column: 47, scope: !3471)
!3483 = !DILocation(line: 1346, column: 52, scope: !3471)
!3484 = !DILocation(line: 1346, column: 28, scope: !3471)
!3485 = !DILocation(line: 1347, column: 9, scope: !3471)
!3486 = !DILocation(line: 1347, column: 23, scope: !3471)
!3487 = !DILocation(line: 1347, column: 47, scope: !3471)
!3488 = !DILocation(line: 1347, column: 52, scope: !3471)
!3489 = !DILocation(line: 1347, column: 28, scope: !3471)
!3490 = !DILocation(line: 1350, column: 13, scope: !3491)
!3491 = distinct !DILexicalBlock(scope: !3471, file: !195, line: 1350, column: 13)
!3492 = !DILocation(line: 0, scope: !3491)
!3493 = !DILocation(line: 1350, column: 13, scope: !3471)
!3494 = !DILocation(line: 1351, column: 21, scope: !3495)
!3495 = distinct !DILexicalBlock(scope: !3491, file: !195, line: 1350, column: 49)
!3496 = !DILocation(line: 1351, column: 24, scope: !3495)
!3497 = !DILocation(line: 1351, column: 32, scope: !3495)
!3498 = !DILocation(line: 1351, column: 30, scope: !3495)
!3499 = !DILocation(line: 1351, column: 20, scope: !3495)
!3500 = !DILocation(line: 1351, column: 14, scope: !3495)
!3501 = !DILocation(line: 1351, column: 18, scope: !3495)
!3502 = !DILocation(line: 1352, column: 13, scope: !3495)
!3503 = !DILocation(line: 1352, column: 18, scope: !3495)
!3504 = !DILocation(line: 1352, column: 22, scope: !3495)
!3505 = !DILocation(line: 1353, column: 13, scope: !3495)
!3506 = !DILocation(line: 1353, column: 18, scope: !3495)
!3507 = !DILocation(line: 1353, column: 22, scope: !3495)
!3508 = !DILocation(line: 1354, column: 21, scope: !3495)
!3509 = !DILocation(line: 1355, column: 9, scope: !3495)
!3510 = !DILocation(line: 1356, column: 5, scope: !3472)
!3511 = !DILocation(line: 1356, column: 5, scope: !3471)
!3512 = !DILocation(line: 1359, column: 12, scope: !3463)
!3513 = !DILocation(line: 1360, column: 1, scope: !3463)
!3514 = !DILocation(line: 1359, column: 5, scope: !3463)
!3515 = distinct !DISubprogram(name: "aws_byte_buf_advance", scope: !195, file: !195, line: 1373, type: !3516, scopeLine: 1376, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3519)
!3516 = !DISubroutineType(types: !3517)
!3517 = !{!96, !3518, !3518, !945}
!3518 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !2125)
!3519 = !{!3520, !3521, !3522}
!3520 = !DILocalVariable(name: "buffer", arg: 1, scope: !3515, file: !195, line: 1374, type: !3518)
!3521 = !DILocalVariable(name: "output", arg: 2, scope: !3515, file: !195, line: 1375, type: !3518)
!3522 = !DILocalVariable(name: "len", arg: 3, scope: !3515, file: !195, line: 1376, type: !945)
!3523 = !DILocation(line: 1374, column: 45, scope: !3515)
!3524 = !DILocation(line: 1375, column: 45, scope: !3515)
!3525 = !DILocation(line: 1376, column: 18, scope: !3515)
!3526 = !DILocation(line: 1379, column: 9, scope: !3527)
!3527 = distinct !DILexicalBlock(scope: !3515, file: !195, line: 1379, column: 9)
!3528 = !DILocation(line: 1379, column: 17, scope: !3527)
!3529 = !DILocation(line: 1379, column: 28, scope: !3527)
!3530 = !DILocation(line: 1379, column: 36, scope: !3527)
!3531 = !DILocation(line: 1379, column: 26, scope: !3527)
!3532 = !DILocation(line: 1379, column: 43, scope: !3527)
!3533 = !DILocation(line: 1379, column: 40, scope: !3527)
!3534 = !DILocation(line: 1379, column: 9, scope: !3515)
!3535 = !DILocation(line: 1380, column: 10, scope: !3536)
!3536 = distinct !DILexicalBlock(scope: !3527, file: !195, line: 1379, column: 48)
!3537 = !DILocation(line: 1380, column: 19, scope: !3536)
!3538 = !DILocation(line: 1380, column: 44, scope: !3536)
!3539 = !DILocation(line: 1380, column: 52, scope: !3536)
!3540 = !DILocation(line: 1380, column: 59, scope: !3536)
!3541 = !DILocation(line: 1380, column: 43, scope: !3536)
!3542 = !DILocation(line: 1380, column: 77, scope: !3536)
!3543 = !DILocation(line: 1380, column: 85, scope: !3536)
!3544 = !DILocation(line: 1380, column: 94, scope: !3536)
!3545 = !DILocation(line: 1380, column: 102, scope: !3536)
!3546 = !DILocation(line: 1380, column: 92, scope: !3536)
!3547 = !DILocation(line: 1380, column: 107, scope: !3536)
!3548 = !DILocation(line: 1381, column: 24, scope: !3536)
!3549 = !DILocation(line: 1381, column: 9, scope: !3536)
!3550 = !DILocation(line: 1381, column: 17, scope: !3536)
!3551 = !DILocation(line: 1381, column: 21, scope: !3536)
!3552 = !DILocation(line: 1382, column: 9, scope: !3536)
!3553 = !DILocation(line: 1382, column: 17, scope: !3536)
!3554 = !DILocation(line: 1382, column: 21, scope: !3536)
!3555 = !DILocation(line: 1385, column: 9, scope: !3536)
!3556 = !DILocation(line: 1387, column: 9, scope: !3557)
!3557 = distinct !DILexicalBlock(scope: !3527, file: !195, line: 1386, column: 12)
!3558 = !DILocation(line: 1387, column: 9, scope: !3559)
!3559 = distinct !DILexicalBlock(scope: !3557, file: !195, line: 1387, column: 9)
!3560 = !DILocation(line: 1390, column: 9, scope: !3557)
!3561 = !DILocation(line: 1392, column: 1, scope: !3515)
!3562 = distinct !DISubprogram(name: "aws_byte_buf_write", scope: !195, file: !195, line: 1401, type: !3563, scopeLine: 1401, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !3566)
!3563 = !DISubroutineType(types: !3564)
!3564 = !{!96, !2125, !3565, !73}
!3565 = !DIDerivedType(tag: DW_TAG_restrict_type, baseType: !151)
!3566 = !{!3567, !3568, !3569}
!3567 = !DILocalVariable(name: "buf", arg: 1, scope: !3562, file: !195, line: 1401, type: !2125)
!3568 = !DILocalVariable(name: "src", arg: 2, scope: !3562, file: !195, line: 1401, type: !3565)
!3569 = !DILocalVariable(name: "len", arg: 3, scope: !3562, file: !195, line: 1401, type: !73)
!3570 = !DILocation(line: 1401, column: 59, scope: !3562)
!3571 = !DILocation(line: 1401, column: 92, scope: !3562)
!3572 = !DILocation(line: 1401, column: 104, scope: !3562)
!3573 = !DILocation(line: 1405, column: 9, scope: !3574)
!3574 = distinct !DILexicalBlock(scope: !3562, file: !195, line: 1405, column: 9)
!3575 = !DILocation(line: 1405, column: 13, scope: !3574)
!3576 = !DILocation(line: 1405, column: 9, scope: !3562)
!3577 = !DILocation(line: 1407, column: 9, scope: !3578)
!3578 = distinct !DILexicalBlock(scope: !3574, file: !195, line: 1405, column: 19)
!3579 = !DILocation(line: 1410, column: 9, scope: !3580)
!3580 = distinct !DILexicalBlock(scope: !3562, file: !195, line: 1410, column: 9)
!3581 = !DILocation(line: 1410, column: 14, scope: !3580)
!3582 = !DILocation(line: 1410, column: 18, scope: !3580)
!3583 = !DILocation(line: 1410, column: 36, scope: !3580)
!3584 = !DILocation(line: 1410, column: 39, scope: !3580)
!3585 = !DILocation(line: 1410, column: 43, scope: !3580)
!3586 = !DILocation(line: 1410, column: 61, scope: !3580)
!3587 = !DILocation(line: 1410, column: 64, scope: !3580)
!3588 = !DILocation(line: 1410, column: 69, scope: !3580)
!3589 = !DILocation(line: 1410, column: 75, scope: !3580)
!3590 = !DILocation(line: 1410, column: 73, scope: !3580)
!3591 = !DILocation(line: 1410, column: 81, scope: !3580)
!3592 = !DILocation(line: 1410, column: 86, scope: !3580)
!3593 = !DILocation(line: 1410, column: 79, scope: !3580)
!3594 = !DILocation(line: 1410, column: 9, scope: !3562)
!3595 = !DILocation(line: 1412, column: 9, scope: !3596)
!3596 = distinct !DILexicalBlock(scope: !3580, file: !195, line: 1410, column: 96)
!3597 = !DILocation(line: 1415, column: 5, scope: !3562)
!3598 = !DILocation(line: 1416, column: 17, scope: !3562)
!3599 = !DILocation(line: 1416, column: 5, scope: !3562)
!3600 = !DI